import { AddToPrincipalPolicyResult, IPrincipal, IRole, PolicyStatement, PrincipalPolicyFragment } from "../../aws-iam";
import { Construct } from "../../core";
import { Cluster } from './cluster';
/**
 * Options for `ServiceAccount`
 */
export interface ServiceAccountOptions {
    /**
     * The name of the service account.
     * @default - If no name is given, it will use the id of the resource.
     */
    readonly name?: string;
    /**
     * The namespace of the service account.
     * @default "default"
     */
    readonly namespace?: string;
}
/**
 * Properties for defining service accounts
 */
export interface ServiceAccountProps extends ServiceAccountOptions {
    /**
     * The cluster to apply the patch to.
     * [disable-awslint:ref-via-interface]
     */
    readonly cluster: Cluster;
}
/**
 * Service Account
 */
export declare class ServiceAccount extends Construct implements IPrincipal {
    /**
     * The role which is linked to the service account.
     */
    readonly role: IRole;
    readonly assumeRoleAction: string;
    readonly grantPrincipal: IPrincipal;
    readonly policyFragment: PrincipalPolicyFragment;
    /**
     * The name of the service account.
     */
    readonly serviceAccountName: string;
    /**
     * The namespace where the service account is located in.
     */
    readonly serviceAccountNamespace: string;
    constructor(scope: Construct, id: string, props: ServiceAccountProps);
    addToPolicy(statement: PolicyStatement): boolean;
    addToPrincipalPolicy(statement: PolicyStatement): AddToPrincipalPolicyResult;
}
