import * as codepipeline from "../../../aws-codepipeline";
import { Construct } from "../../../core";
import { Action } from '../action';
/**
 * Construction properties of the {@link ServiceCatalogDeployAction ServiceCatalog deploy CodePipeline Action}.
 *
 * **Note**: this API is still experimental, and may have breaking changes in the future!
 *
 * @experimental
 */
export interface ServiceCatalogDeployActionProps extends codepipeline.CommonAwsActionProps {
    /**
     * The path to the cloudformation artifact.
     */
    readonly templatePath: codepipeline.ArtifactPath;
    /**
     * The name of the version of the Service Catalog product to be deployed.
     */
    readonly productVersionName: string;
    /**
     * The optional description of this version of the Service Catalog product.
     * @default ''
     */
    readonly productVersionDescription?: string;
    /**
     * The identifier of the product in the Service Catalog. This product must already exist.
     */
    readonly productId: string;
}
/**
 * CodePipeline action to connect to an existing ServiceCatalog product.
 *
 * **Note**: this class is still experimental, and may have breaking changes in the future!
 *
 * @experimental
 */
export declare class ServiceCatalogDeployAction extends Action {
    private readonly templatePath;
    private readonly productVersionName;
    private readonly productVersionDescription?;
    private readonly productId;
    private readonly productType;
    constructor(props: ServiceCatalogDeployActionProps);
    protected bound(_scope: Construct, _stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
}
