"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcsDeploymentConfig = void 0;
const utils_1 = require("../utils");
/**
 * A custom Deployment Configuration for an ECS Deployment Group.
 *
 * Note: This class currently stands as namespaced container of the default configurations
 * until CloudFormation supports custom ECS Deployment Configs. Until then it is closed
 * (private constructor) and does not extend {@link cdk.Construct}
 *
 * @resource AWS::CodeDeploy::DeploymentConfig
 */
class EcsDeploymentConfig {
    constructor() {
        // nothing to do until CFN supports custom ECS deployment configurations
    }
    /**
     * Import a custom Deployment Configuration for an ECS Deployment Group defined outside the CDK.
     *
     * @param _scope the parent Construct for this new Construct
     * @param _id the logical ID of this new Construct
     * @param ecsDeploymentConfigName the name of the referenced custom Deployment Configuration
     * @returns a Construct representing a reference to an existing custom Deployment Configuration
     */
    static fromEcsDeploymentConfigName(_scope, _id, ecsDeploymentConfigName) {
        return deploymentConfig(ecsDeploymentConfigName);
    }
}
exports.EcsDeploymentConfig = EcsDeploymentConfig;
EcsDeploymentConfig.ALL_AT_ONCE = deploymentConfig('CodeDeployDefault.ECSAllAtOnce');
function deploymentConfig(name) {
    return {
        deploymentConfigName: name,
        deploymentConfigArn: utils_1.arnForDeploymentConfig(name),
    };
}
//# sourceMappingURL=data:application/json;base64,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