/**
 * BuildSpec for CodeBuild projects
 */
export declare abstract class BuildSpec {
    static fromObject(value: {
        [key: string]: any;
    }): BuildSpec;
    /**
     * Use a file from the source as buildspec
     *
     * Use this if you want to use a file different from 'buildspec.yml'`
     */
    static fromSourceFilename(filename: string): BuildSpec;
    /**
     * Whether the buildspec is directly available or deferred until build-time
     */
    abstract readonly isImmediate: boolean;
    protected constructor();
    /**
     * Render the represented BuildSpec
     */
    abstract toBuildSpec(): string;
}
