"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Unit = exports.Statistic = void 0;
/**
 * Statistic to use over the aggregation period
 */
var Statistic;
(function (Statistic) {
    /**
     * The count (number) of data points used for the statistical calculation.
     */
    Statistic["SAMPLE_COUNT"] = "SampleCount";
    /**
     * The value of Sum / SampleCount during the specified period.
     */
    Statistic["AVERAGE"] = "Average";
    /**
     * All values submitted for the matching metric added together.
     * This statistic can be useful for determining the total volume of a metric.
     */
    Statistic["SUM"] = "Sum";
    /**
     * The lowest value observed during the specified period.
     * You can use this value to determine low volumes of activity for your application.
     */
    Statistic["MINIMUM"] = "Minimum";
    /**
     * The highest value observed during the specified period.
     * You can use this value to determine high volumes of activity for your application.
     */
    Statistic["MAXIMUM"] = "Maximum";
})(Statistic = exports.Statistic || (exports.Statistic = {}));
/**
 * Unit for metric
 */
var Unit;
(function (Unit) {
    /**
     * Seconds
     */
    Unit["SECONDS"] = "Seconds";
    /**
     * Microseconds
     */
    Unit["MICROSECONDS"] = "Microseconds";
    /**
     * Milliseconds
     */
    Unit["MILLISECONDS"] = "Milliseconds";
    /**
     * Bytes
     */
    Unit["BYTES"] = "Bytes";
    /**
     * Kilobytes
     */
    Unit["KILOBYTES"] = "Kilobytes";
    /**
     * Megabytes
     */
    Unit["MEGABYTES"] = "Megabytes";
    /**
     * Gigabytes
     */
    Unit["GIGABYTES"] = "Gigabytes";
    /**
     * Terabytes
     */
    Unit["TERABYTES"] = "Terabytes";
    /**
     * Bits
     */
    Unit["BITS"] = "Bits";
    /**
     * Kilobits
     */
    Unit["KILOBITS"] = "Kilobits";
    /**
     * Megabits
     */
    Unit["MEGABITS"] = "Megabits";
    /**
     * Gigabits
     */
    Unit["GIGABITS"] = "Gigabits";
    /**
     * Terabits
     */
    Unit["TERABITS"] = "Terabits";
    /**
     * Percent
     */
    Unit["PERCENT"] = "Percent";
    /**
     * Count
     */
    Unit["COUNT"] = "Count";
    /**
     * Bytes/second (B/s)
     */
    Unit["BYTES_PER_SECOND"] = "Bytes/Second";
    /**
     * Kilobytes/second (kB/s)
     */
    Unit["KILOBYTES_PER_SECOND"] = "Kilobytes/Second";
    /**
     * Megabytes/second (MB/s)
     */
    Unit["MEGABYTES_PER_SECOND"] = "Megabytes/Second";
    /**
     * Gigabytes/second (GB/s)
     */
    Unit["GIGABYTES_PER_SECOND"] = "Gigabytes/Second";
    /**
     * Terabytes/second (TB/s)
     */
    Unit["TERABYTES_PER_SECOND"] = "Terabytes/Second";
    /**
     * Bits/second (b/s)
     */
    Unit["BITS_PER_SECOND"] = "Bits/Second";
    /**
     * Kilobits/second (kb/s)
     */
    Unit["KILOBITS_PER_SECOND"] = "Kilobits/Second";
    /**
     * Megabits/second (Mb/s)
     */
    Unit["MEGABITS_PER_SECOND"] = "Megabits/Second";
    /**
     * Gigabits/second (Gb/s)
     */
    Unit["GIGABITS_PER_SECOND"] = "Gigabits/Second";
    /**
     * Terabits/second (Tb/s)
     */
    Unit["TERABITS_PER_SECOND"] = "Terabits/Second";
    /**
     * Count/second
     */
    Unit["COUNT_PER_SECOND"] = "Count/Second";
    /**
     * No unit
     */
    Unit["NONE"] = "None";
})(Unit = exports.Unit || (exports.Unit = {}));
//# sourceMappingURL=data:application/json;base64,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