"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationScalingAction = void 0;
/**
 * Use an ApplicationAutoScaling StepScalingAction as an Alarm Action
 */
class ApplicationScalingAction {
    constructor(stepScalingAction) {
        this.stepScalingAction = stepScalingAction;
    }
    /**
     * Returns an alarm action configuration to use an ApplicationScaling StepScalingAction
     * as an alarm action
     */
    bind(_scope, _alarm) {
        return { alarmActionArn: this.stepScalingAction.scalingPolicyArn };
    }
}
exports.ApplicationScalingAction = ApplicationScalingAction;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBwc2NhbGluZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFwcHNjYWxpbmcudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBR0E7O0dBRUc7QUFDSCxNQUFhLHdCQUF3QjtJQUNqQyxZQUE2QixpQkFBK0M7UUFBL0Msc0JBQWlCLEdBQWpCLGlCQUFpQixDQUE4QjtJQUM1RSxDQUFDO0lBQ0Q7OztPQUdHO0lBQ0ksSUFBSSxDQUFDLE1BQXFCLEVBQUUsTUFBeUI7UUFDeEQsT0FBTyxFQUFFLGNBQWMsRUFBRSxJQUFJLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsQ0FBQztJQUN2RSxDQUFDO0NBQ0o7QUFWRCw0REFVQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGFwcHNjYWxpbmcgZnJvbSBcIi4uLy4uL2F3cy1hcHBsaWNhdGlvbmF1dG9zY2FsaW5nXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtYXBwbGljYXRpb25hdXRvc2NhbGluZydcbmltcG9ydCAqIGFzIGNsb3Vkd2F0Y2ggZnJvbSBcIi4uLy4uL2F3cy1jbG91ZHdhdGNoXCI7IC8vIEF1dG9tYXRpY2FsbHkgcmUtd3JpdHRlbiBmcm9tICdAYXdzLWNkay9hd3MtY2xvdWR3YXRjaCdcbmltcG9ydCAqIGFzIGNkayBmcm9tIFwiLi4vLi4vY29yZVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvY29yZSdcbi8qKlxuICogVXNlIGFuIEFwcGxpY2F0aW9uQXV0b1NjYWxpbmcgU3RlcFNjYWxpbmdBY3Rpb24gYXMgYW4gQWxhcm0gQWN0aW9uXG4gKi9cbmV4cG9ydCBjbGFzcyBBcHBsaWNhdGlvblNjYWxpbmdBY3Rpb24gaW1wbGVtZW50cyBjbG91ZHdhdGNoLklBbGFybUFjdGlvbiB7XG4gICAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBzdGVwU2NhbGluZ0FjdGlvbjogYXBwc2NhbGluZy5TdGVwU2NhbGluZ0FjdGlvbikge1xuICAgIH1cbiAgICAvKipcbiAgICAgKiBSZXR1cm5zIGFuIGFsYXJtIGFjdGlvbiBjb25maWd1cmF0aW9uIHRvIHVzZSBhbiBBcHBsaWNhdGlvblNjYWxpbmcgU3RlcFNjYWxpbmdBY3Rpb25cbiAgICAgKiBhcyBhbiBhbGFybSBhY3Rpb25cbiAgICAgKi9cbiAgICBwdWJsaWMgYmluZChfc2NvcGU6IGNkay5Db25zdHJ1Y3QsIF9hbGFybTogY2xvdWR3YXRjaC5JQWxhcm0pOiBjbG91ZHdhdGNoLkFsYXJtQWN0aW9uQ29uZmlnIHtcbiAgICAgICAgcmV0dXJuIHsgYWxhcm1BY3Rpb25Bcm46IHRoaXMuc3RlcFNjYWxpbmdBY3Rpb24uc2NhbGluZ1BvbGljeUFybiB9O1xuICAgIH1cbn1cbiJdfQ==