"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OriginGroup = void 0;
/**
 * An Origin that represents a group.
 * Consists of a primary Origin,
 * and a fallback Origin called when the primary returns one of the provided HTTP status codes.
 */
class OriginGroup {
    constructor(props) {
        this.props = props;
    }
    bind(scope, options) {
        const primaryOriginConfig = this.props.primaryOrigin.bind(scope, options);
        if (primaryOriginConfig.failoverConfig) {
            throw new Error('An OriginGroup cannot use an Origin with its own failover configuration as its primary origin!');
        }
        return {
            originProperty: primaryOriginConfig.originProperty,
            failoverConfig: {
                failoverOrigin: this.props.fallbackOrigin,
                statusCodes: this.props.fallbackStatusCodes,
            },
        };
    }
}
exports.OriginGroup = OriginGroup;
//# sourceMappingURL=data:application/json;base64,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