"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Resolver = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const appsync_generated_1 = require("./appsync.generated");
/**
 * An AppSync resolver
 */
class Resolver extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const pipelineConfig = props.pipelineConfig && props.pipelineConfig.length ? { functions: props.pipelineConfig } : undefined;
        this.resolver = new appsync_generated_1.CfnResolver(this, 'Resource', {
            apiId: props.api.apiId,
            typeName: props.typeName,
            fieldName: props.fieldName,
            dataSourceName: props.dataSource ? props.dataSource.name : undefined,
            kind: pipelineConfig ? 'PIPELINE' : 'UNIT',
            pipelineConfig: pipelineConfig,
            requestMappingTemplate: props.requestMappingTemplate ? props.requestMappingTemplate.renderTemplate() : undefined,
            responseMappingTemplate: props.responseMappingTemplate ? props.responseMappingTemplate.renderTemplate() : undefined,
        });
        props.api.addSchemaDependency(this.resolver);
        if (props.dataSource) {
            this.resolver.addDependsOn(props.dataSource.ds);
        }
        this.arn = this.resolver.attrResolverArn;
    }
}
exports.Resolver = Resolver;
//# sourceMappingURL=data:application/json;base64,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