import { IFunction } from "../../../../aws-lambda";
import { HttpRouteIntegrationBindOptions, HttpRouteIntegrationConfig, IHttpRouteIntegration, PayloadFormatVersion } from '../integration';
/**
 * Lambda Proxy integration properties
 */
export interface LambdaProxyIntegrationProps {
    /**
     * The handler for this integration.
     */
    readonly handler: IFunction;
    /**
     * Version of the payload sent to the lambda handler.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     * @default PayloadFormatVersion.VERSION_2_0
     */
    readonly payloadFormatVersion?: PayloadFormatVersion;
}
/**
 * The Lambda Proxy integration resource for HTTP API
 */
export declare class LambdaProxyIntegration implements IHttpRouteIntegration {
    private readonly props;
    constructor(props: LambdaProxyIntegrationProps);
    bind(options: HttpRouteIntegrationBindOptions): HttpRouteIntegrationConfig;
}
