"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Domain = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const amplify_generated_1 = require("./amplify.generated");
/**
 * An Amplify Console domain
 */
class Domain extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.subDomains = props.subDomains || [];
        const domainName = props.domainName || id;
        const domain = new amplify_generated_1.CfnDomain(this, 'Resource', {
            appId: props.app.appId,
            domainName,
            subDomainSettings: core_1.Lazy.anyValue({ produce: () => this.renderSubDomainSettings() }, { omitEmptyArray: true }),
        });
        this.arn = domain.attrArn;
        this.certificateRecord = domain.attrCertificateRecord;
        this.domainName = domain.attrDomainName;
        this.domainStatus = domain.attrDomainStatus;
        this.statusReason = domain.attrStatusReason;
        this.domainAutoSubDomainCreationPatterns = domain.attrAutoSubDomainCreationPatterns;
        this.domainAutoSubDomainIamRole = domain.attrAutoSubDomainIamRole;
        this.domainEnableAutoSubDomain = domain.attrEnableAutoSubDomain;
    }
    /**
     * Maps a branch to a sub domain
     *
     * @param branch The branch
     * @param prefix The prefix. Use '' to map to the root of the domain. Defaults to branch name.
     */
    mapSubDomain(branch, prefix) {
        this.subDomains.push({ branch, prefix });
        return this;
    }
    /**
     * Maps a branch to the domain root
     */
    mapRoot(branch) {
        return this.mapSubDomain(branch, '');
    }
    validate() {
        if (this.subDomains.length === 0) {
            return ['The domain doesn\'t contain any subdomains'];
        }
        return [];
    }
    renderSubDomainSettings() {
        return this.subDomains.map(s => ({
            branchName: s.branch.branchName,
            prefix: s.prefix === undefined ? s.branch.branchName : s.prefix,
        }));
    }
}
exports.Domain = Domain;
//# sourceMappingURL=data:application/json;base64,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