from setuptools import setup

with open('README.md', 'r') as f:
    long_description = f.read()

setup(
    name='rapy_genius',
    version='0.0.2',
    description='a python api to collect data from genius.com using their API',
    py_modules=["data_manager","genius_api"],
    package_dir={'':'src'},
    classifiers=[
        "Programming Language :: Python :: 3.7",
        "License :: OSI Approved :: Apache Software License",
        "Operating System :: OS Independent"
    ],
    long_description=long_description,
    long_description_content_type='text/markdown',
    install_requires=[
        "argon2-cffi==20.1.0",
        "astroid==2.4.2",
        "async-generator==1.10",
        "attrs==20.2.0",
        "autopep8==1.5.4",
        "backcall==0.2.0",
        "beautifulsoup4==4.9.3",
        "bleach==3.2.1",
        "bs4==0.0.1",
        "certifi==2020.6.20",
        "cffi==1.14.3",
        "chardet==3.0.4",
        "colorama==0.4.4",
        "cycler==0.10.0",
        "decorator==4.4.2",
        "defusedxml==0.6.0",
        "dill==0.3.3",
        "entrypoints==0.3",
        "filelock==3.0.12",
        "idna==2.10",
        "importlib-metadata==2.0.0",
        "isort==5.6.4",
        "jedi==0.17.2",
        "Jinja2==2.11.2",
        "joblib==0.17.0",
        "json5==0.9.5",
        "jsonschema==3.2.0",
        "kiwisolver==1.2.0",
        "lazy-object-proxy==1.4.3",
        "MarkupSafe==1.1.1",
        "mccabe==0.6.1",
        "mistune==0.8.4",
        "multiprocess==0.70.11.1",
        "nbclient==0.5.1",
        "nbconvert==6.0.7",
        "nbformat==5.0.8",
        "nest-asyncio==1.4.2",
        "packaging==20.4",
        "pandocfilters==1.4.3",
        "parso==0.7.1",
        "pickleshare==0.7.5",
        "Pillow==8.0.1",
        "pip-autoremove==0.9.1",
        "prometheus-client==0.8.0",
        "prompt-toolkit==3.0.8",
        "pyarrow==2.0.0",
        "pycodestyle==2.6.0",
        "pycparser==2.20",
        "Pygments==2.7.2",
        "pylint==2.6.0",
        "pymongo==3.11.0",
        "pyparsing==2.4.7",
        "pyrsistent==0.17.3",
        "python-dateutil==2.8.1",
        "pytz==2020.1",
        "pywin32==228",
        "pywinpty==0.5.7",
        "pyzmq==19.0.2",
        "requests==2.24.0",
        "Send2Trash==1.5.0",
        "six==1.15.0",
        "soupsieve==2.0.1",
        "terminado==0.9.1",
        "testpath==0.4.4",
        "threadpoolctl==2.1.0",
        "toml==0.10.2",
        "tornado==6.1",
        "tqdm==4.49.0",
        "traitlets==5.0.5",
        "typed-ast==1.4.1",
        "urllib3==1.25.11",
        "wcwidth==0.2.5",
        "webencodings==0.5.1",
        "wrapt==1.12.1",
        "xxhash==2.0.0",
        "zipp==3.4.0",
    ],
    extras_require={
        "dev": [
            "pytest>=3.7",
        ],
    },
    url='https://github.com/maatarmed/rapy_genius',
    author='Maatar M',
    author_email='maatar93@gmail.com',
)