# Copyright 2015 Cisco Systems, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

""" This is an auto-generated module containing ManagedObject Meta information. """

from .ucsccoremeta import UcscVersion
from .ucsccoremeta import MoMeta

class VersionMeta:
    """ This class contains all the UcscVersion supported by this package."""
    Version101a = UcscVersion("1.0(1a)")
    Version111a = UcscVersion("1.1(1a)")
    Version111b = UcscVersion("1.1(1b)")
    Version112a = UcscVersion("1.1(2a)")
    Version121a = UcscVersion("1.2(1a)")
    Version121e = UcscVersion("1.2(1e)")
    Version131a = UcscVersion("1.3(1a)")
    Version141a = UcscVersion("1.4(1a)")
    Version151a = UcscVersion("1.5(1a)")
    Version151b = UcscVersion("1.5(1b)")
    Version201b = UcscVersion("2.0(1b)")
    Version201c = UcscVersion("2.0(1c)")
    Version201d = UcscVersion("2.0(1d)")
    Version201e = UcscVersion("2.0(1e)")
    Version201f = UcscVersion("2.0(1f)")
    Version201g = UcscVersion("2.0(1g)")
    Version201h = UcscVersion("2.0(1h)")
    Version201i = UcscVersion("2.0(1i)")
    Version201j = UcscVersion("2.0(1j)")
    Version201k = UcscVersion("2.0(1k)")
    Version201l = UcscVersion("2.0(1l)")
    Version201m = UcscVersion("2.0(1m)")
    Version201n = UcscVersion("2.0(1n)")
    Version201o = UcscVersion("2.0(1o)")

MO_CLASS_ID = frozenset([
    "AaaAuthRealm",
    "AaaAuthRealmFsm",
    "AaaAuthRealmFsmStage",
    "AaaConsoleAuth",
    "AaaDefaultAuth",
    "AaaDomain",
    "AaaDomainAuth",
    "AaaDomainGroup",
    "AaaEpAuthProfile",
    "AaaEpFsm",
    "AaaEpFsmStage",
    "AaaEpFsmTask",
    "AaaEpLogin",
    "AaaEpUser",
    "AaaExtMgmtCutThruTkn",
    "AaaLdapEp",
    "AaaLdapEpFsm",
    "AaaLdapEpFsmStage",
    "AaaLdapGroup",
    "AaaLdapGroupRule",
    "AaaLdapProvider",
    "AaaLocale",
    "AaaLog",
    "AaaModLR",
    "AaaOrg",
    "AaaProviderGroup",
    "AaaProviderRef",
    "AaaPwdProfile",
    "AaaRadiusEp",
    "AaaRadiusEpFsm",
    "AaaRadiusEpFsmStage",
    "AaaRadiusProvider",
    "AaaRealmFsm",
    "AaaRealmFsmStage",
    "AaaRealmFsmTask",
    "AaaRemoteUser",
    "AaaRole",
    "AaaSession",
    "AaaSessionLR",
    "AaaShellLogin",
    "AaaSshAuth",
    "AaaTacacsPlusEp",
    "AaaTacacsPlusEpFsm",
    "AaaTacacsPlusEpFsmStage",
    "AaaTacacsPlusProvider",
    "AaaUser",
    "AaaUserData",
    "AaaUserEp",
    "AaaUserEpFsm",
    "AaaUserEpFsmStage",
    "AaaUserEpFsmTask",
    "AaaUserLocale",
    "AaaUserPreferences",
    "AaaUserRole",
    "AaaWebLogin",
    "AdaptorCapQual",
    "AdaptorCapSpec",
    "AdaptorEthAdvFilterProfile",
    "AdaptorEthArfsProfile",
    "AdaptorEthCompQueueProfile",
    "AdaptorEthFailoverProfile",
    "AdaptorEthGENEVEProfile",
    "AdaptorEthInterruptProfile",
    "AdaptorEthInterruptScalingProfile",
    "AdaptorEthNVGREProfile",
    "AdaptorEthOffloadProfile",
    "AdaptorEthPortBySizeLargeStats",
    "AdaptorEthPortBySizeLargeStatsHist",
    "AdaptorEthPortBySizeSmallStats",
    "AdaptorEthPortBySizeSmallStatsHist",
    "AdaptorEthPortErrStats",
    "AdaptorEthPortErrStatsHist",
    "AdaptorEthPortMcastStats",
    "AdaptorEthPortMcastStatsHist",
    "AdaptorEthPortOutsizedStats",
    "AdaptorEthPortOutsizedStatsHist",
    "AdaptorEthPortStats",
    "AdaptorEthPortStatsHist",
    "AdaptorEthRecvQueueProfile",
    "AdaptorEthRoCEProfile",
    "AdaptorEthVxLANProfile",
    "AdaptorEthWorkQueueProfile",
    "AdaptorEtherIfStats",
    "AdaptorEtherIfStatsHist",
    "AdaptorExtEthIf",
    "AdaptorExtEthIfOperation",
    "AdaptorExtIpV6RssHashProfile",
    "AdaptorFcCdbWorkQueueProfile",
    "AdaptorFcErrorRecoveryProfile",
    "AdaptorFcFnicProfile",
    "AdaptorFcIfEventStats",
    "AdaptorFcIfEventStatsHist",
    "AdaptorFcIfFC4Stats",
    "AdaptorFcIfFC4StatsHist",
    "AdaptorFcIfFrameStats",
    "AdaptorFcIfFrameStatsHist",
    "AdaptorFcInterruptProfile",
    "AdaptorFcPortFLogiProfile",
    "AdaptorFcPortPLogiProfile",
    "AdaptorFcPortProfile",
    "AdaptorFcPortStats",
    "AdaptorFcPortStatsHist",
    "AdaptorFcRecvQueueProfile",
    "AdaptorFcWorkQueueProfile",
    "AdaptorFruCapProvider",
    "AdaptorHBAVnicStats",
    "AdaptorHBAVnicStatsHist",
    "AdaptorHostEthIf",
    "AdaptorHostEthIfOperation",
    "AdaptorHostEthIfProfile",
    "AdaptorHostFcIf",
    "AdaptorHostFcIfOperation",
    "AdaptorHostFcIfProfile",
    "AdaptorHostIfConfig",
    "AdaptorHostIscsiIf",
    "AdaptorHostIscsiIfOperation",
    "AdaptorHostIscsiIfProfile",
    "AdaptorHostScsiIf",
    "AdaptorHostScsiLunRef",
    "AdaptorIScsiCap",
    "AdaptorIpV4RssHashProfile",
    "AdaptorIpV6RssHashProfile",
    "AdaptorMenloBaseErrorStats",
    "AdaptorMenloBaseErrorStatsHist",
    "AdaptorMenloDcePortStats",
    "AdaptorMenloDcePortStatsHist",
    "AdaptorMenloEthErrorStats",
    "AdaptorMenloEthErrorStatsHist",
    "AdaptorMenloEthStats",
    "AdaptorMenloEthStatsHist",
    "AdaptorMenloFcErrorStats",
    "AdaptorMenloFcErrorStatsHist",
    "AdaptorMenloFcStats",
    "AdaptorMenloFcStatsHist",
    "AdaptorMenloHostPortStats",
    "AdaptorMenloHostPortStatsHist",
    "AdaptorMenloMcpuErrorStats",
    "AdaptorMenloMcpuErrorStatsHist",
    "AdaptorMenloMcpuStats",
    "AdaptorMenloMcpuStatsHist",
    "AdaptorMenloNetEgStats",
    "AdaptorMenloNetEgStatsHist",
    "AdaptorMenloNetInStats",
    "AdaptorMenloNetInStatsHist",
    "AdaptorMenloQErrorStats",
    "AdaptorMenloQErrorStatsHist",
    "AdaptorMenloQStats",
    "AdaptorMenloQStatsHist",
    "AdaptorNICVnicStats",
    "AdaptorNICVnicStatsHist",
    "AdaptorProtocolProfile",
    "AdaptorQual",
    "AdaptorRnicCapSpec",
    "AdaptorRssProfile",
    "AdaptorUnit",
    "AdaptorUnitAssocCtx",
    "AdaptorUnitExtn",
    "AdaptorUsnicConnDef",
    "AdaptorVlan",
    "AdaptorVmmqConnDef",
    "AdaptorVnicStats",
    "AdaptorVnicStatsHist",
    "BiosBOT",
    "BiosBootDev",
    "BiosBootDevGrp",
    "BiosTokenFeatureGroup",
    "BiosTokenParam",
    "BiosTokenSettings",
    "BiosUnit",
    "BiosVProfile",
    "BiosVfACPI10Support",
    "BiosVfASPMSupport",
    "BiosVfAllUSBDevices",
    "BiosVfAltitude",
    "BiosVfAssertNMIOnPERR",
    "BiosVfAssertNMIOnSERR",
    "BiosVfBootOptionRetry",
    "BiosVfCPUHardwarePowerManagement",
    "BiosVfCPUPerformance",
    "BiosVfCPUPowerManagement",
    "BiosVfConsistentDeviceNameControl",
    "BiosVfConsoleRedirection",
    "BiosVfCoreMultiProcessing",
    "BiosVfDDR3VoltageSelection",
    "BiosVfDRAMClockThrottling",
    "BiosVfDirectCacheAccess",
    "BiosVfDramRefreshRate",
    "BiosVfEnergyPerformanceTuning",
    "BiosVfEnhancedIntelSpeedStepTech",
    "BiosVfEnhancedPowerCappingSupport",
    "BiosVfExecuteDisableBit",
    "BiosVfFRB2Timer",
    "BiosVfFrequencyFloorOverride",
    "BiosVfFrontPanelLockout",
    "BiosVfIOEMezz1OptionROM",
    "BiosVfIOENVMe1OptionROM",
    "BiosVfIOENVMe2OptionROM",
    "BiosVfIOESlot1OptionROM",
    "BiosVfIOESlot2OptionROM",
    "BiosVfIntegratedGraphics",
    "BiosVfIntegratedGraphicsApertureSize",
    "BiosVfIntelEntrySASRAIDModule",
    "BiosVfIntelHyperThreadingTech",
    "BiosVfIntelTrustedExecutionTechnology",
    "BiosVfIntelTurboBoostTech",
    "BiosVfIntelVTForDirectedIO",
    "BiosVfIntelVirtualizationTechnology",
    "BiosVfInterleaveConfiguration",
    "BiosVfLocalX2Apic",
    "BiosVfLvDIMMSupport",
    "BiosVfMaxVariableMTRRSetting",
    "BiosVfMaximumMemoryBelow4GB",
    "BiosVfMemoryMappedIOAbove4GB",
    "BiosVfMirroringMode",
    "BiosVfNUMAOptimized",
    "BiosVfOSBootWatchdogTimer",
    "BiosVfOSBootWatchdogTimerPolicy",
    "BiosVfOSBootWatchdogTimerTimeout",
    "BiosVfOnboardGraphics",
    "BiosVfOnboardSATAController",
    "BiosVfOnboardStorage",
    "BiosVfOptionROMEnable",
    "BiosVfOptionROMLoad",
    "BiosVfOutOfBandManagement",
    "BiosVfPCHSATAMode",
    "BiosVfPCILOMPortsConfiguration",
    "BiosVfPCIROMCLP",
    "BiosVfPCISlotLinkSpeed",
    "BiosVfPCISlotOptionROMEnable",
    "BiosVfPOSTErrorPause",
    "BiosVfPSTATECoordination",
    "BiosVfPackageCStateLimit",
    "BiosVfProcessorC1E",
    "BiosVfProcessorC3Report",
    "BiosVfProcessorC6Report",
    "BiosVfProcessorC7Report",
    "BiosVfProcessorCMCI",
    "BiosVfProcessorCState",
    "BiosVfProcessorEnergyConfiguration",
    "BiosVfProcessorPrefetchConfig",
    "BiosVfQPILinkFrequencySelect",
    "BiosVfQPISnoopMode",
    "BiosVfQuietBoot",
    "BiosVfRedirectionAfterBIOSPOST",
    "BiosVfResumeOnACPowerLoss",
    "BiosVfSBMezz1OptionROM",
    "BiosVfSBNVMe1OptionROM",
    "BiosVfSIOC1OptionROM",
    "BiosVfSIOC2OptionROM",
    "BiosVfScrubPolicies",
    "BiosVfSelectMemoryRASConfiguration",
    "BiosVfSerialPortAEnable",
    "BiosVfSparingMode",
    "BiosVfSriovConfig",
    "BiosVfTPMPendingOperation",
    "BiosVfTPMSupport",
    "BiosVfTrustedPlatformModule",
    "BiosVfUCSMBootModeControl",
    "BiosVfUCSMBootOrderRuleControl",
    "BiosVfUEFIOSUseLegacyVideo",
    "BiosVfUSBBootConfig",
    "BiosVfUSBConfiguration",
    "BiosVfUSBFrontPanelAccessLock",
    "BiosVfUSBPortConfiguration",
    "BiosVfUSBSystemIdlePowerOptimizingSetting",
    "BiosVfVGAPriority",
    "BiosVfWorkloadConfiguration",
    "CallhomeDest",
    "CallhomeEp",
    "CallhomeFaultInst",
    "CallhomeHolder",
    "CallhomeHolderFsm",
    "CallhomeHolderFsmStage",
    "CallhomeHolderFsmTask",
    "CallhomeHttp",
    "CallhomePeriodicSystemInventory",
    "CallhomePolicy",
    "CallhomeProfile",
    "CallhomeSmtp",
    "CallhomeSource",
    "CallhomeTestAlert",
    "CapabilityCatalogue",
    "CertRepairEp",
    "CertRepairEpFsm",
    "CertRepairEpFsmStage",
    "CertRepairEpFsmTask",
    "ChangeChangedObjectRef",
    "ChangeEp",
    "ChangeEpFsm",
    "ChangeEpFsmStage",
    "ChangeEpFsmTask",
    "CimcvmediaActualMountEntry",
    "CimcvmediaActualMountList",
    "CimcvmediaConfigMountEntry",
    "CimcvmediaExtMgmtRuleEntry",
    "CimcvmediaMountConfigDef",
    "CimcvmediaMountConfigPolicy",
    "ClitestTypeTest",
    "ClitestTypeTest2",
    "ClitestTypeTestChild",
    "CommCimxml",
    "CommCoreFile",
    "CommDateTime",
    "CommDateTimeFsm",
    "CommDateTimeFsmStage",
    "CommDateTimeFsmTask",
    "CommDns",
    "CommDnsProvider",
    "CommEvtChannel",
    "CommHttp",
    "CommHttps",
    "CommLocale",
    "CommLogComponent",
    "CommNtp",
    "CommNtpProvider",
    "CommShellSvcLimits",
    "CommSmashCLP",
    "CommSnmp",
    "CommSnmpCommunity",
    "CommSnmpTrap",
    "CommSnmpTrapData",
    "CommSnmpUser",
    "CommSsh",
    "CommSvcEp",
    "CommSvcEpFsm",
    "CommSvcEpFsmStage",
    "CommSvcEpFsmTask",
    "CommSvcPolicy",
    "CommSyslog",
    "CommSyslogClient",
    "CommSyslogConsole",
    "CommSyslogFile",
    "CommSyslogMonitor",
    "CommSyslogSource",
    "CommTelnet",
    "CommWebChannel",
    "CommWebSvcLimits",
    "CommWsman",
    "CommXmlClConnPolicy",
    "ComputeAutoconfigPolicy",
    "ComputeBlade",
    "ComputeBladeDiscPolicy",
    "ComputeBladeEp",
    "ComputeBladeInheritPolicy",
    "ComputeBoard",
    "ComputeBoardConnector",
    "ComputeBoardController",
    "ComputeCartridge",
    "ComputeCartridgeOperation",
    "ComputeChassisConnPolicy",
    "ComputeChassisConnPolicyOperation",
    "ComputeChassisDiscPolicy",
    "ComputeChassisFeatMask",
    "ComputeChassisQual",
    "ComputeDomainGroupQual",
    "ComputeDomainHwChangeDiscPolicy",
    "ComputeDomainNameQual",
    "ComputeDomainPortDiscPolicy",
    "ComputeDomainQual",
    "ComputeEnvFeatMask",
    "ComputeExtBoard",
    "ComputeFabricEthMonSrcEp",
    "ComputeFabricEthMonSrcEpCont",
    "ComputeFabricFcMonSrcEp",
    "ComputeFabricFcMonSrcEpCont",
    "ComputeFactoryResetOp",
    "ComputeFactoryResetOperation",
    "ComputeFaultUpgradeFlag",
    "ComputeGraphicsCardPolicy",
    "ComputeGroupMembership",
    "ComputeGroupMembershipRef",
    "ComputeHwChangeDiscPolicy",
    "ComputeIOHub",
    "ComputeIOHubEnvStats",
    "ComputeIOHubEnvStatsHist",
    "ComputeInstance",
    "ComputeInstanceIdQual",
    "ComputeInstanceMapping",
    "ComputeLocalTemplDef",
    "ComputeMbPowerStats",
    "ComputeMbPowerStatsHist",
    "ComputeMbTempStats",
    "ComputeMbTempStatsHist",
    "ComputeNetworkFeatMask",
    "ComputeOwnerQual",
    "ComputePCIeFatalCompletionStats",
    "ComputePCIeFatalCompletionStatsHist",
    "ComputePCIeFatalProtocolStats",
    "ComputePCIeFatalProtocolStatsHist",
    "ComputePCIeFatalReceiveStats",
    "ComputePCIeFatalReceiveStatsHist",
    "ComputePCIeFatalStats",
    "ComputePCIeFatalStatsHist",
    "ComputePhysicalAssocCtx",
    "ComputePhysicalExtension",
    "ComputePhysicalOperation",
    "ComputePhysicalQual",
    "ComputePool",
    "ComputePoolPolicyRef",
    "ComputePoolable",
    "ComputePooledEnclosureComputeSlot",
    "ComputePooledRackUnit",
    "ComputePooledSlot",
    "ComputePoolingPolicy",
    "ComputePortDiscPolicy",
    "ComputePowerSyncDef",
    "ComputePowerSyncPolicy",
    "ComputeProductFamilyQual",
    "ComputeProfile",
    "ComputePsuPolicy",
    "ComputeQual",
    "ComputeRackQual",
    "ComputeRackUnit",
    "ComputeRackUnitMbTempStats",
    "ComputeRackUnitMbTempStatsHist",
    "ComputeRebootLog",
    "ComputeRemoteOpStatus",
    "ComputeRequirement",
    "ComputeResourceAggrEp",
    "ComputeResourceSet",
    "ComputeResourceSetManager",
    "ComputeResourceSetMember",
    "ComputeScrubPolicy",
    "ComputeServerDiscPolicy",
    "ComputeServerFeatMask",
    "ComputeServerMgmtPolicy",
    "ComputeServerUnit",
    "ComputeSession",
    "ComputeSiteQual",
    "ComputeSlotQual",
    "ComputeStorageFeatMask",
    "ComputeSystem",
    "ComputeSystemAddrQual",
    "ComputeSystemFsm",
    "ComputeSystemFsmStage",
    "ComputeSystemFsmTask",
    "ComputeSystemQual",
    "ComputeTemplate",
    "ComputeTemplateMapping",
    "ComputeUser",
    "ComputeUserEp",
    "ConfigAckItem",
    "ConfigAdaptorItem",
    "ConfigAppImpactResponse",
    "ConfigBackup",
    "ConfigBackupFsm",
    "ConfigBackupFsmStage",
    "ConfigBackupFsmTask",
    "ConfigCartridgeFilter",
    "ConfigCartridgeItem",
    "ConfigCatalogue",
    "ConfigChassisFilter",
    "ConfigChassisItem",
    "ConfigComponentsFilter",
    "ConfigConsumerCatalogue",
    "ConfigConsumerCatalogueFsm",
    "ConfigConsumerCatalogueFsmStage",
    "ConfigConsumerCatalogueFsmTask",
    "ConfigControllerItem",
    "ConfigCpuInfo",
    "ConfigCpuItem",
    "ConfigCryptoCardItem",
    "ConfigDbConfig",
    "ConfigDomainFilter",
    "ConfigDomainItem",
    "ConfigFabricInterconnectFilter",
    "ConfigFabricInterconnectItem",
    "ConfigFanItem",
    "ConfigFexFilter",
    "ConfigFexItem",
    "ConfigFilterGroup",
    "ConfigFilterItem",
    "ConfigFsm",
    "ConfigFsmStage",
    "ConfigGraphicsCardItem",
    "ConfigIOMItem",
    "ConfigImpact",
    "ConfigImpactAnalyzer",
    "ConfigImpactAnalyzerEp",
    "ConfigInputConfig",
    "ConfigInputConfigSet",
    "ConfigLocalDiskItem",
    "ConfigLunItem",
    "ConfigManagedEpImpactResponse",
    "ConfigMemoryItem",
    "ConfigMotherboardItem",
    "ConfigNetRefItem",
    "ConfigOrgItem",
    "ConfigPSUItem",
    "ConfigPolicyUsageItem",
    "ConfigPortItem",
    "ConfigSearchOptions",
    "ConfigSearchResult",
    "ConfigServerFilter",
    "ConfigServerItem",
    "ConfigServiceProfileFilter",
    "ConfigSorter",
    "ConfigSpotLightItem",
    "ConfigStorageArrayProfileFilter",
    "ConfigStorageBladeFilter",
    "ConfigStorageItem",
    "ConfigUCImpact",
    "ConsumerInst",
    "ConsumerInstFsm",
    "ConsumerInstFsmStage",
    "ConsumerInstFsmTask",
    "ConsumerUniverse",
    "ControllerEp",
    "ControllerEpFsm",
    "ControllerEpFsmStage",
    "ControllerEpFsmTask",
    "CpmaintAck",
    "CpmaintMaintPolicy",
    "DcxVIf",
    "DcxVc",
    "DiagLogEp",
    "DiagMemoryTest",
    "DiagRslt",
    "DiagRunPolicy",
    "DiagSrvCapProvider",
    "DiagSrvCtrl",
    "DiagSrvCtrlOperation",
    "DiagSrvCtrlOperationFsm",
    "DiagSrvCtrlOperationFsmStage",
    "DiagSrvCtrlOperationFsmTask",
    "DomainChassisFeature",
    "DomainChassisParam",
    "DomainChassisProfileItem",
    "DomainEnvironmentFeature",
    "DomainEnvironmentParam",
    "DomainEp",
    "DomainFamilyCapProvider",
    "DomainFeatureCatalog",
    "DomainNetworkFeature",
    "DomainNetworkParam",
    "DomainProfile",
    "DomainProfileFsm",
    "DomainProfileFsmStage",
    "DomainProfileFsmTask",
    "DomainServerFeature",
    "DomainServerParam",
    "DomainServiceProfileItem",
    "DomainStorageFeature",
    "DomainStorageParam",
    "DpsecMac",
    "DupeChangeTracker",
    "DupeChangeTrackerEp",
    "DupeChangeTrackerEpFsm",
    "DupeChangeTrackerEpFsmStage",
    "DupeChangeTrackerEpFsmTask",
    "DupeEp",
    "DupeExtRequestor",
    "DupeIntRequestor",
    "DupeScope",
    "DupeScopeEp",
    "DupeScopeResult",
    "EpqosDefinition",
    "EpqosEgress",
    "EquipmentAdvancedBootOrder",
    "EquipmentBeaconLed",
    "EquipmentBinding",
    "EquipmentBladeCapProvider",
    "EquipmentBreakoutCap",
    "EquipmentCPMeta",
    "EquipmentChassis",
    "EquipmentChassisAssocCtx",
    "EquipmentChassisCapProvider",
    "EquipmentChassisIssues",
    "EquipmentChassisOperation",
    "EquipmentChassisProfile",
    "EquipmentChassisProfileAssocCtx",
    "EquipmentChassisProfileFsm",
    "EquipmentChassisProfileFsmStage",
    "EquipmentChassisProfileFsmTask",
    "EquipmentChassisQual",
    "EquipmentChassisRequirement",
    "EquipmentChassisStats",
    "EquipmentChassisStatsHist",
    "EquipmentCimcVmedia",
    "EquipmentComputeConn",
    "EquipmentComputeConnPolicy",
    "EquipmentDriveSecCap",
    "EquipmentFan",
    "EquipmentFanModule",
    "EquipmentFanModuleCapProvider",
    "EquipmentFanModuleStats",
    "EquipmentFanModuleStatsHist",
    "EquipmentFanStats",
    "EquipmentFanStatsHist",
    "EquipmentFex",
    "EquipmentFexCapProvider",
    "EquipmentFexEnvStats",
    "EquipmentFexEnvStatsHist",
    "EquipmentFexOperation",
    "EquipmentFexPowerSummary",
    "EquipmentFexPowerSummaryHist",
    "EquipmentFexPsuInputStats",
    "EquipmentFexPsuInputStatsHist",
    "EquipmentFruVariant",
    "EquipmentGemCapProvider",
    "EquipmentHealthLed",
    "EquipmentHostIfCapProvider",
    "EquipmentIOCard",
    "EquipmentIOCardCapProvider",
    "EquipmentIOCardStats",
    "EquipmentIOCardStatsHist",
    "EquipmentImpliedStorageEnclosureDef",
    "EquipmentIndicatorLed",
    "EquipmentInstance",
    "EquipmentInstanceMapping",
    "EquipmentLocalDiskCapProvider",
    "EquipmentLocalDiskControllerCapProvider",
    "EquipmentLocalDiskDef",
    "EquipmentLocalTemplDef",
    "EquipmentLocatorLed",
    "EquipmentLocatorLedOperation",
    "EquipmentManufacturingDef",
    "EquipmentMemoryUnitCapProvider",
    "EquipmentNetworkElementFanStats",
    "EquipmentNetworkElementFanStatsHist",
    "EquipmentPciDef",
    "EquipmentPhysicalQual",
    "EquipmentPicture",
    "EquipmentPool",
    "EquipmentPoolable",
    "EquipmentPoolingPolicy",
    "EquipmentProcessorUnitCapProvider",
    "EquipmentPsu",
    "EquipmentPsuCapProvider",
    "EquipmentPsuInputStats",
    "EquipmentPsuInputStatsHist",
    "EquipmentPsuOutputStats",
    "EquipmentPsuOutputStatsHist",
    "EquipmentPsuStats",
    "EquipmentPsuStatsHist",
    "EquipmentQual",
    "EquipmentRackUnitCapProvider",
    "EquipmentRackUnitFanStats",
    "EquipmentRackUnitFanStatsHist",
    "EquipmentRackUnitPsuStats",
    "EquipmentRackUnitPsuStatsHist",
    "EquipmentRequirement",
    "EquipmentSecureBoot",
    "EquipmentServerFeatureCap",
    "EquipmentServerUnitCapProvider",
    "EquipmentSharedIOModule",
    "EquipmentSiocTempStats",
    "EquipmentSiocTempStatsHist",
    "EquipmentStorageProcessorCap",
    "EquipmentSwitchCapProvider",
    "EquipmentSwitchCard",
    "EquipmentSwitchIOCard",
    "EquipmentSwitchIOCardCapProvider",
    "EquipmentSystemFruCapProvider",
    "EquipmentSystemIOController",
    "EquipmentSystemIOControllerOperation",
    "EquipmentTemplate",
    "EquipmentTemplateMapping",
    "EquipmentTier",
    "EquipmentUnifiedPortCapProvider",
    "EquipmentXcvr",
    "EtherErrStats",
    "EtherErrStatsHist",
    "EtherFcoeInterfaceStats",
    "EtherFcoeInterfaceStatsHist",
    "EtherLossStats",
    "EtherLossStatsHist",
    "EtherPIo",
    "EtherPauseStats",
    "EtherPauseStatsHist",
    "EtherRxStats",
    "EtherRxStatsHist",
    "EtherServerIntFIo",
    "EtherSwitchIntFIo",
    "EtherTxStats",
    "EtherTxStatsHist",
    "EventApplication",
    "EventEpCtrl",
    "EventHolder",
    "EventInst",
    "EventLog",
    "EventPolicy",
    "EventRecord",
    "ExtmgmtArpTargets",
    "ExtmgmtGatewayPing",
    "ExtmgmtIfMonPolicy",
    "ExtmgmtMiiStatus",
    "ExtmgmtNdiscTargets",
    "ExtpolClient",
    "ExtpolClientCont",
    "ExtpolClientFsm",
    "ExtpolClientFsmStage",
    "ExtpolClientFsmTask",
    "ExtpolController",
    "ExtpolControllerCont",
    "ExtpolDomain",
    "ExtpolEp",
    "ExtpolEpFsm",
    "ExtpolEpFsmStage",
    "ExtpolEpFsmTask",
    "ExtpolHBStatus",
    "ExtpolProvider",
    "ExtpolProviderCont",
    "ExtpolRegistry",
    "ExtpolRegistryCapability",
    "ExtpolSystemContext",
    "ExtpolVersionHolder",
    "ExtvmmNetworkSets",
    "ExtvmmVMNetworkSets",
    "FabricBreakout",
    "FabricBreakoutOperation",
    "FabricCabling",
    "FabricCablingSw",
    "FabricCartridgeSlotEp",
    "FabricCartridgeSlotEpOperation",
    "FabricCdpLinkPolicy",
    "FabricChangedObjectRef",
    "FabricChassisEp",
    "FabricComputeMSlotEp",
    "FabricComputePhEp",
    "FabricComputePhEpOperation",
    "FabricComputeSlotEp",
    "FabricComputeSlotEpOperation",
    "FabricConsumer",
    "FabricDceSrv",
    "FabricDceSwSrv",
    "FabricDceSwSrvEp",
    "FabricDceSwSrvEpOperation",
    "FabricDceSwSrvPc",
    "FabricDceSwSrvPcEp",
    "FabricDceSwSrvPcEpOperation",
    "FabricDceSwSrvPcOperation",
    "FabricDceSwSrvPcOperationFsm",
    "FabricDceSwSrvPcOperationFsmStage",
    "FabricDomainEp",
    "FabricEnclosurePhEp",
    "FabricEnclosurePhEpOperation",
    "FabricEnclosureSlotEp",
    "FabricEnclosureSlotEpOperation",
    "FabricEp",
    "FabricEthEstc",
    "FabricEthEstcCloud",
    "FabricEthEstcEp",
    "FabricEthEstcEpOperation",
    "FabricEthEstcEpOperationFsm",
    "FabricEthEstcEpOperationFsmStage",
    "FabricEthEstcPc",
    "FabricEthEstcPcEp",
    "FabricEthEstcPcEpOperation",
    "FabricEthEstcPcOperation",
    "FabricEthEstcPcOperationFsm",
    "FabricEthEstcPcOperationFsmStage",
    "FabricEthLan",
    "FabricEthLanEp",
    "FabricEthLanEpOperation",
    "FabricEthLanEpOperationFsm",
    "FabricEthLanEpOperationFsmStage",
    "FabricEthLanPc",
    "FabricEthLanPcEp",
    "FabricEthLanPcEpOperation",
    "FabricEthLanPcOperation",
    "FabricEthLanPcOperationFsm",
    "FabricEthLanPcOperationFsmStage",
    "FabricEthLinkProfile",
    "FabricEthMon",
    "FabricEthMonDestEp",
    "FabricEthMonDestEpOperation",
    "FabricEthMonLan",
    "FabricEthMonOperation",
    "FabricEthMonOperationFsm",
    "FabricEthMonOperationFsmStage",
    "FabricEthMonSrcEp",
    "FabricEthMonSrcEpOperation",
    "FabricEthMonSrcRef",
    "FabricEthPortOperationFsm",
    "FabricEthPortOperationFsmStage",
    "FabricEthTargetEp",
    "FabricEthTargetEpOperation",
    "FabricEthVlanPc",
    "FabricEthVlanPortEp",
    "FabricEtherRef",
    "FabricExtension",
    "FabricFIPortOperationFsm",
    "FabricFIPortOperationFsmStage",
    "FabricFIPortOperationFsmTask",
    "FabricFcEndpoint",
    "FabricFcEstc",
    "FabricFcEstcCloud",
    "FabricFcEstcEp",
    "FabricFcEstcEpOperation",
    "FabricFcEstcEpOperationFsm",
    "FabricFcEstcEpOperationFsmStage",
    "FabricFcMon",
    "FabricFcMonDestEp",
    "FabricFcMonDestEpOperation",
    "FabricFcMonOperation",
    "FabricFcMonOperationFsm",
    "FabricFcMonOperationFsmStage",
    "FabricFcMonSan",
    "FabricFcMonSrcEp",
    "FabricFcMonSrcEpOperation",
    "FabricFcMonSrcRef",
    "FabricFcPortOperationFsm",
    "FabricFcPortOperationFsmStage",
    "FabricFcSan",
    "FabricFcSanEp",
    "FabricFcSanEpOperation",
    "FabricFcSanEpOperationFsm",
    "FabricFcSanEpOperationFsmStage",
    "FabricFcSanPc",
    "FabricFcSanPcEp",
    "FabricFcSanPcEpOperation",
    "FabricFcSanPcOperation",
    "FabricFcSanPcOperationFsm",
    "FabricFcSanPcOperationFsmStage",
    "FabricFcUplinkOperation",
    "FabricFcUserZone",
    "FabricFcUserZoneIvt",
    "FabricFcVsanPc",
    "FabricFcVsanPortEp",
    "FabricFcZoneProfile",
    "FabricFcZoneProfileFsm",
    "FabricFcZoneProfileFsmStage",
    "FabricFcZoneProfileFsmTask",
    "FabricFcZoneProfileIvt",
    "FabricFcoeEstcEp",
    "FabricFcoeEstcEpOperation",
    "FabricFcoeEstcEpOperationFsm",
    "FabricFcoeEstcEpOperationFsmStage",
    "FabricFcoeSanEp",
    "FabricFcoeSanEpOperation",
    "FabricFcoeSanEpOperationFsm",
    "FabricFcoeSanEpOperationFsmStage",
    "FabricFcoeSanPc",
    "FabricFcoeSanPcEp",
    "FabricFcoeSanPcEpOperation",
    "FabricFcoeSanPcOperation",
    "FabricFcoeSanPcOperationFsm",
    "FabricFcoeSanPcOperationFsmStage",
    "FabricFcoeVsanPc",
    "FabricFcoeVsanPortEp",
    "FabricHolder",
    "FabricIf",
    "FabricLacpPolicy",
    "FabricLanAccessMgr",
    "FabricLanCloud",
    "FabricLanCloudPolicy",
    "FabricLanMonCloud",
    "FabricLanPinGroup",
    "FabricLanPinGroupOperation",
    "FabricLanPinTarget",
    "FabricLanPinTargetOperation",
    "FabricLastAckedSlot",
    "FabricMulticastPolicy",
    "FabricNetGroup",
    "FabricNetGroupEp",
    "FabricNetGroupPermit",
    "FabricNetGroupRef",
    "FabricNetGroupReq",
    "FabricOrgVlanPolicy",
    "FabricPoolableVlan",
    "FabricPooledVlan",
    "FabricSanCloud",
    "FabricSanGroup",
    "FabricSanGroupRef",
    "FabricSanMonCloud",
    "FabricSanPinGroup",
    "FabricSanPinGroupOperation",
    "FabricSanPinTarget",
    "FabricSanPinTargetOperation",
    "FabricSubGroup",
    "FabricSwChPhEp",
    "FabricSwChPhEpOperation",
    "FabricSwSubGroup",
    "FabricSystem",
    "FabricUdldLinkPolicy",
    "FabricUdldPolicy",
    "FabricVCon",
    "FabricVConProfile",
    "FabricVlan",
    "FabricVlanEp",
    "FabricVlanGroupReq",
    "FabricVlanPermit",
    "FabricVlanPermitItem",
    "FabricVlanReq",
    "FabricVnetEpSyncEp",
    "FabricVnetEpSyncEpFsm",
    "FabricVnetEpSyncEpFsmStage",
    "FabricVnetEpSyncEpFsmTask",
    "FabricVsan",
    "FabricVsanEp",
    "FabricVsanMembership",
    "FaultDomainEp",
    "FaultDomainInst",
    "FaultGlobalSeverityHolder",
    "FaultGlobalTypedHolder",
    "FaultHolder",
    "FaultInst",
    "FaultLocalTypedHolder",
    "FaultPolicy",
    "FaultSummary",
    "FaultSummaryInst",
    "FaultSvcSummary",
    "FaultTypedHolder",
    "FcErrStats",
    "FcErrStatsHist",
    "FcPIo",
    "FcStats",
    "FcStatsHist",
    "FcpoolAddr",
    "FcpoolBlock",
    "FcpoolBootTarget",
    "FcpoolFormat",
    "FcpoolInitiator",
    "FcpoolInitiatorEp",
    "FcpoolInitiators",
    "FcpoolUniverse",
    "FdBlade",
    "FdBladeFsm",
    "FdBladeFsmStage",
    "FdChassis",
    "FdPhysicalFsm",
    "FdPhysicalFsmStage",
    "FdPhysicalFsmTask",
    "FdRackUnit",
    "FdRackUnitFsm",
    "FdRackUnitFsmStage",
    "FeatureCatalogEp",
    "FeatureChassisDef",
    "FeatureEnvDef",
    "FeatureNetworkDef",
    "FeatureServerDef",
    "FeatureStorageDef",
    "FirmwareAck",
    "FirmwareAutoSyncPolicy",
    "FirmwareBootDefinition",
    "FirmwareBootUnit",
    "FirmwareBundleInfo",
    "FirmwareBundleInfoDigest",
    "FirmwareBundleType",
    "FirmwareBundleTypeCapProvider",
    "FirmwareCatalogPack",
    "FirmwareCatalogPackConfig",
    "FirmwareCatalogue",
    "FirmwareChassisComponentSpec",
    "FirmwareChassisPack",
    "FirmwareCompSource",
    "FirmwareCompTarget",
    "FirmwareComponentSpec",
    "FirmwareComputeHostPack",
    "FirmwareComputeMgmtPack",
    "FirmwareComputeStoragePack",
    "FirmwareConnectionPolicy",
    "FirmwareDependency",
    "FirmwareDistImage",
    "FirmwareDistributable",
    "FirmwareDistributableFsm",
    "FirmwareDistributableFsmStage",
    "FirmwareDistributableFsmTask",
    "FirmwareDomainInfo",
    "FirmwareDomainInfraProfile",
    "FirmwareDownloadPolicy",
    "FirmwareDownloader",
    "FirmwareDownloaderFsm",
    "FirmwareDownloaderFsmStage",
    "FirmwareDownloaderFsmTask",
    "FirmwareExcludeChassisComponent",
    "FirmwareExcludeServerComponent",
    "FirmwareImage",
    "FirmwareInfra",
    "FirmwareInfraPack",
    "FirmwareInfraPackConfig",
    "FirmwareInfraPolicy",
    "FirmwareInstallImpact",
    "FirmwarePolicy",
    "FirmwareProductFamily",
    "FirmwareRemoteCatalogue",
    "FirmwareRunning",
    "FirmwareSource",
    "FirmwareStatus",
    "FirmwareStoragePack",
    "FirmwareSystem",
    "FirmwareType",
    "FirmwareUpdatable",
    "FirmwareUpgradeDetail",
    "FirmwareUpgradeInfo",
    "FlowctrlDefinition",
    "FlowctrlItem",
    "FsmStatus",
    "GlAppendRule",
    "GlBlockEp",
    "GlBlockOp",
    "GlByMo",
    "GlComplexRefEp",
    "GlConflictEp",
    "GlConflictResolutionRuleEp",
    "GlDomainEp",
    "GlEp",
    "GlGlobalDefaultPolicyEp",
    "GlIdRef",
    "GlIdRefEp",
    "GlIdentCtxEp",
    "GlIdentCtxOp",
    "GlIdentCtxResOp",
    "GlIdentCtxResOpFsm",
    "GlIdentCtxResOpFsmStage",
    "GlIdentCtxResOpFsmTask",
    "GlInventoryEp",
    "GlLsp",
    "GlMcastPolicy",
    "GlOperationEp",
    "GlPathEp",
    "GlPolicy",
    "GlPolicyAlgorithmedOp",
    "GlPolicyEp",
    "GlPolicyInvEp",
    "GlPolicyNameRuleEp",
    "GlPolicyOp",
    "GlPolicyRef",
    "GlPolicyRefEp",
    "GlPolicyResOp",
    "GlPolicyResolutionEp",
    "GlPool",
    "GlPoolEp",
    "GlPoolInvEp",
    "GlPoolOp",
    "GlRefsEp",
    "GlRequest",
    "GlRequestFsm",
    "GlRequestFsmStage",
    "GlRequestFsmTask",
    "GlRequestVnetEp",
    "GlRequestVnetEpDomainEp",
    "GlRequestVnetEpDomainEpFsm",
    "GlRequestVnetEpDomainEpFsmStage",
    "GlRequestVnetEpDomainEpFsmTask",
    "GlRequestVnetEpFsm",
    "GlRequestVnetEpFsmStage",
    "GlRequestVnetEpFsmTask",
    "GlRequestVnetEpHolder",
    "GlRequestor",
    "GlRequestorEp",
    "GlSPInvEp",
    "GlServerPoolResOp",
    "GlServiceProfile",
    "GlSpDefEp",
    "GlTemplateEp",
    "GlTemplateOp",
    "GlTemplateResOp",
    "GlUsage",
    "GlUsageEp",
    "GlVlan",
    "GlVnetInvHolder",
    "GlVnicTemplate",
    "GlVnicTemplateEp",
    "GlVsan",
    "GlVxanEp",
    "GlVxanOp",
    "GlVxanResOp",
    "GmetaClass",
    "GmetaPolicyMapElement",
    "GmetaProp",
    "GraphicsCard",
    "GraphicsController",
    "GuiGuiComponent",
    "GuiGuiCont",
    "HcAdapterFirmwareItem",
    "HcAdapterItem",
    "HcAdmin",
    "HcCatalog",
    "HcCatalogList",
    "HcCatalogSource",
    "HcCatalogVersion",
    "HcCleanup",
    "HcDownloadPolicy",
    "HcDownloader",
    "HcDriverInfoItem",
    "HcDriverItem",
    "HcHolder",
    "HcItemNote",
    "HcOsInfoItem",
    "HcOsItem",
    "HcReport",
    "HcScopeDn",
    "HcServerComponent",
    "HcSupportedAdapterFirmwareItem",
    "HcSupportedAdapterItem",
    "HcSupportedDriverItem",
    "HcSupportedOsItem",
    "HcUcsVersionItem",
    "IdentDomainSyncEp",
    "IdentExecutionEp",
    "IdentExecutionRequestEp",
    "IdentIdentCtx",
    "IdentIdentRequest",
    "IdentIdentRequestFsm",
    "IdentIdentRequestFsmStage",
    "IdentIdentRequestFsmTask",
    "IdentMetaSystem",
    "IdentMetaSystemFsm",
    "IdentMetaSystemFsmStage",
    "IdentMetaSystemFsmTask",
    "IdentMetaVerse",
    "IdentRequestEp",
    "IdentSysInfo",
    "IdentpoolBlockQual",
    "IdentpoolConsumed",
    "IdentpoolDomain",
    "IdentpoolDomainGroupQual",
    "IdentpoolIPQual",
    "IdentpoolIPV6Qual",
    "IdentpoolMetaSystem",
    "IdentpoolMetaVerse",
    "IdentpoolPoolable",
    "InbandPolicy",
    "InitiatorFcInitiatorEp",
    "InitiatorGroupEp",
    "InitiatorIScsiInitiatorEp",
    "InitiatorLunEp",
    "InitiatorMemberEp",
    "InitiatorRequestorEp",
    "InitiatorRequestorGrpEp",
    "InitiatorStoreEp",
    "InitiatorUnitEp",
    "InventoryDomainEp",
    "InventoryEp",
    "InventoryGlobalEp",
    "InventoryHolder",
    "InventoryInventoryMoMeta",
    "IpIPv4Dns",
    "IpIpV4StaticAddr",
    "IpServiceIf",
    "IppoolAddr",
    "IppoolBlock",
    "IppoolIpV6Addr",
    "IppoolIpV6Block",
    "IppoolIpV6Pooled",
    "IppoolPool",
    "IppoolPooled",
    "IppoolUniverse",
    "IqnpoolAddr",
    "IqnpoolBlock",
    "IqnpoolFormat",
    "IqnpoolPool",
    "IqnpoolPooled",
    "IqnpoolTransportBlock",
    "IqnpoolUniverse",
    "IscsiAuthProfile",
    "LicenseContents",
    "LicenseDomain",
    "LicenseDownloader",
    "LicenseDownloaderFsm",
    "LicenseDownloaderFsmStage",
    "LicenseDownloaderFsmTask",
    "LicenseEp",
    "LicenseFeature",
    "LicenseFeatureCapProvider",
    "LicenseFeatureLine",
    "LicenseFile",
    "LicenseFileFsm",
    "LicenseFileFsmStage",
    "LicenseFileFsmTask",
    "LicenseInstance",
    "LicenseInstanceFsm",
    "LicenseInstanceFsmStage",
    "LicenseInstanceFsmTask",
    "LicenseProp",
    "LicenseServerHostId",
    "LicenseSource",
    "LicenseSourceFile",
    "LsBinding",
    "LsFcLocale",
    "LsFcZone",
    "LsFcZoneGroup",
    "LsIdentityInfo",
    "LsIssues",
    "LsPower",
    "LsRequirement",
    "LsSPMeta",
    "LsServer",
    "LsServerAssocCtx",
    "LsServerExtension",
    "LsServerFsm",
    "LsServerFsmStage",
    "LsServerFsmTask",
    "LsServerOperation",
    "LsTier",
    "LsVConAssign",
    "LsWaitingUserAck",
    "LsZoneInitiatorMember",
    "LsZoneTargetMember",
    "LsbootBootSecurity",
    "LsbootDef",
    "LsbootDefaultLocalImage",
    "LsbootEFIShell",
    "LsbootEmbeddedLocalDiskImage",
    "LsbootEmbeddedLocalDiskImagePath",
    "LsbootEmbeddedLocalLunImage",
    "LsbootIScsi",
    "LsbootIScsiImagePath",
    "LsbootLan",
    "LsbootLanImagePath",
    "LsbootLocalDiskImage",
    "LsbootLocalDiskImagePath",
    "LsbootLocalHddImage",
    "LsbootLocalLunImagePath",
    "LsbootLocalStorage",
    "LsbootNvme",
    "LsbootNvmeDiskSsd",
    "LsbootNvmePciSsd",
    "LsbootPolicy",
    "LsbootSan",
    "LsbootSanCatSanImage",
    "LsbootSanCatSanImagePath",
    "LsbootSanImage",
    "LsbootSanImagePath",
    "LsbootStorage",
    "LsbootUEFIBootParam",
    "LsbootUpgradeStatus",
    "LsbootUsbExternalImage",
    "LsbootUsbFlashStorageImage",
    "LsbootUsbInternalImage",
    "LsbootVirtualMedia",
    "LsmaintAck",
    "LsmaintMaintPolicy",
    "LstorageAck",
    "LstorageArrayRequirement",
    "LstorageBlade",
    "LstorageControllerDef",
    "LstorageControllerModeConfig",
    "LstorageControllerQualifier",
    "LstorageControllerRef",
    "LstorageCtrlServiceOperation",
    "LstorageDasScsiLun",
    "LstorageDiskGroupConfigDef",
    "LstorageDiskGroupConfigPolicy",
    "LstorageDiskGroupQualifier",
    "LstorageDiskSlot",
    "LstorageDiskZoningConfigDef",
    "LstorageDiskZoningPolicy",
    "LstorageDriveSecurity",
    "LstorageExtension",
    "LstorageLocal",
    "LstorageLocalDef",
    "LstorageLocalDiskConfigRef",
    "LstorageLocalDiskRef",
    "LstorageLogin",
    "LstorageMeta",
    "LstorageProfile",
    "LstorageProfileBinding",
    "LstorageProfileDef",
    "LstorageRecurrWindow",
    "LstorageRemote",
    "LstorageRemoteDef",
    "LstorageRequestCtx",
    "LstorageSecurity",
    "LstorageVirtualDriveDef",
    "MacpoolAddr",
    "MacpoolBlock",
    "MacpoolFormat",
    "MacpoolPool",
    "MacpoolPooled",
    "MacpoolUniverse",
    "MemoryArray",
    "MemoryArrayEnvStats",
    "MemoryArrayEnvStatsHist",
    "MemoryBufferUnit",
    "MemoryBufferUnitEnvStats",
    "MemoryBufferUnitEnvStatsHist",
    "MemoryErrorStats",
    "MemoryErrorStatsHist",
    "MemoryNvDimm",
    "MemoryNvDimmBattery",
    "MemoryNvDimmController",
    "MemoryQual",
    "MemoryRuntime",
    "MemoryRuntimeHist",
    "MemoryUnit",
    "MemoryUnitEnvStats",
    "MemoryUnitEnvStatsHist",
    "MessageEntry",
    "MessageEp",
    "MgmtBackup",
    "MgmtBackupFsm",
    "MgmtBackupFsmStage",
    "MgmtBackupFsmTask",
    "MgmtBackupOperation",
    "MgmtBackupPolicy",
    "MgmtBackupTrigger",
    "MgmtBackupTriggerFsm",
    "MgmtBackupTriggerFsmStage",
    "MgmtBackupTriggerFsmTask",
    "MgmtCfgExportPolicy",
    "MgmtCmcSecureBoot",
    "MgmtCmcSecureBootOperation",
    "MgmtConnection",
    "MgmtController",
    "MgmtDataExporter",
    "MgmtDataExporterFsm",
    "MgmtDataExporterFsmStage",
    "MgmtDataExporterFsmTask",
    "MgmtDataImporter",
    "MgmtDataImporterFsm",
    "MgmtDataImporterFsmStage",
    "MgmtDataImporterFsmTask",
    "MgmtDataItem",
    "MgmtEntity",
    "MgmtEp",
    "MgmtIPv6IfAddr",
    "MgmtIPv6IfConfig",
    "MgmtIf",
    "MgmtIfFsm",
    "MgmtIfFsmStage",
    "MgmtIfFsmTask",
    "MgmtImportItem",
    "MgmtImporter",
    "MgmtImporterFsm",
    "MgmtImporterFsmStage",
    "MgmtImporterFsmTask",
    "MgmtInbandProfile",
    "MgmtInterface",
    "MgmtKmip",
    "MgmtKmipCertPolicy",
    "MgmtKmipOperation",
    "MgmtNamedKmipCertPolicy",
    "MgmtRegistryInfo",
    "MgmtRegistryInfoFsm",
    "MgmtRegistryInfoFsmStage",
    "MgmtRegistryInfoFsmTask",
    "MgmtSecurity",
    "MgmtSvc",
    "MgmtVnet",
    "NetNetGroupPermit",
    "NetworkElement",
    "NetworkElementFsm",
    "NetworkElementFsmStage",
    "NetworkElementFsmTask",
    "NetworkElementOperation",
    "NetworkSystemCACert",
    "NfsClientDef",
    "NfsClientDefFsm",
    "NfsClientDefFsmStage",
    "NfsClientDefFsmTask",
    "NfsEp",
    "NfsExportDef",
    "NfsExportDefFsm",
    "NfsExportDefFsmStage",
    "NfsExportDefFsmTask",
    "NfsMountDef",
    "NfsRepositorySpecPolicy",
    "NwctrlDefinition",
    "ObserveFilter",
    "ObserveObserved",
    "ObserveObservedCont",
    "ObserveObservedFsm",
    "ObserveObservedFsmStage",
    "ObserveObservedFsmTask",
    "OrgDomainFirmwareInfo",
    "OrgDomainGroup",
    "OrgDomainGroupFirmwareReport",
    "OrgDomainGroupPolicy",
    "OrgDomainGroupPolicyReport",
    "OrgExtension",
    "OrgFirmwareVersionCount",
    "OrgMaintTagFirmwareReport",
    "OrgOrg",
    "OrgOrgFsm",
    "OrgOrgFsmStage",
    "OrgOrgFsmTask",
    "OrgOrgSource",
    "OrgSourceMask",
    "OsController",
    "OsEthBondIntf",
    "OsEthIntf",
    "OsInstance",
    "OsPrimarySlave",
    "PkiCertReq",
    "PkiEp",
    "PkiEpFsm",
    "PkiEpFsmStage",
    "PkiEpFsmTask",
    "PkiKeyRing",
    "PkiTP",
    "PolicyChildClass",
    "PolicyCluster",
    "PolicyCommunication",
    "PolicyCommunicationOp",
    "PolicyConfigBackup",
    "PolicyConfigBackupOp",
    "PolicyConfigError",
    "PolicyContext",
    "PolicyControlEp",
    "PolicyControlEpOp",
    "PolicyControlEpOpFsm",
    "PolicyControlEpOpFsmStage",
    "PolicyControlEpOpFsmTask",
    "PolicyControlEpOperation",
    "PolicyControlledInstance",
    "PolicyControlledType",
    "PolicyDateTime",
    "PolicyDateTimeOp",
    "PolicyDestClass",
    "PolicyDestEp",
    "PolicyDeviceProfile",
    "PolicyDigest",
    "PolicyDiscovery",
    "PolicyDiscoveryOp",
    "PolicyDns",
    "PolicyDnsOp",
    "PolicyElement",
    "PolicyEquipment",
    "PolicyEquipmentOp",
    "PolicyFault",
    "PolicyFaultOp",
    "PolicyIdentifierPolicy",
    "PolicyInfraFirmware",
    "PolicyInfraFirmwareOp",
    "PolicyLocalMap",
    "PolicyLogProfile",
    "PolicyMEp",
    "PolicyMEpOp",
    "PolicyMonitoring",
    "PolicyMonitoringOp",
    "PolicyPolicyDestClass",
    "PolicyPolicyEp",
    "PolicyPolicyRequestor",
    "PolicyPolicyScope",
    "PolicyPolicyScopeCont",
    "PolicyPolicyScopeContext",
    "PolicyPolicyScopeFsm",
    "PolicyPolicyScopeFsmStage",
    "PolicyPolicyScopeFsmTask",
    "PolicyPortConfig",
    "PolicyPortConfigOp",
    "PolicyPowerMgmt",
    "PolicyPowerMgmtOp",
    "PolicyProxyMo",
    "PolicyPsu",
    "PolicyPsuOp",
    "PolicyRequestor",
    "PolicyScope",
    "PolicySecurity",
    "PolicySecurityOp",
    "PolicySource",
    "PolicySourceApp",
    "PolicyStorageAutoConfig",
    "PolicyStorageAutoConfigOp",
    "PolicySystemEp",
    "PolicySystemProfile",
    "PolicyTracker",
    "PolicyUniverse",
    "PortGroup",
    "PortSubGroup",
    "PowerBudget",
    "PowerChassisMember",
    "PowerEp",
    "PowerGroup",
    "PowerGroupQual",
    "PowerGroupStats",
    "PowerGroupStatsHist",
    "PowerMgmtPolicy",
    "PowerPolicy",
    "PowerProfiledPower",
    "ProcDoer",
    "ProcManager",
    "ProcPrt",
    "ProcPrtCounts",
    "ProcStimulusCounts",
    "ProcSvc",
    "ProcTxCounts",
    "ProcessorEnvStats",
    "ProcessorEnvStatsHist",
    "ProcessorErrorStats",
    "ProcessorErrorStatsHist",
    "ProcessorQual",
    "ProcessorRuntime",
    "ProcessorRuntimeHist",
    "ProcessorUnit",
    "ProcessorUnitAssocCtx",
    "QosclassDefinition",
    "QosclassEthBE",
    "QosclassEthClassified",
    "QosclassFc",
    "QosclassPolicy",
    "QueryDependencyContext",
    "QueryDependencyRef",
    "QueryEp",
    "QueryImportContext",
    "QueryUsageContext",
    "QueryresultDependency",
    "QueryresultDomainGroupEp",
    "QueryresultOrgEp",
    "QueryresultUsage",
    "SecurityUnit",
    "SesDiskSlotEp",
    "SesEnclosure",
    "SmartcallhomeHttpProxy",
    "SmartcallhomePeriodicInventoryStatus",
    "SmartcallhomePeriodicSystemInventory",
    "SmartcallhomePolicy",
    "SmartcallhomeProfile",
    "SmartcallhomeSource",
    "SmartcallhomeTransportGateway",
    "SmartlicenseAgent",
    "SmartlicenseAgentFsm",
    "SmartlicenseAgentFsmStage",
    "SmartlicenseAgentFsmTask",
    "SmartlicenseEntitlement",
    "SmartlicenseEntitlementEp",
    "SmartlicenseEntitlementEpFsm",
    "SmartlicenseEntitlementEpFsmStage",
    "SmartlicenseEntitlementEpFsmTask",
    "SmartlicenseEp",
    "SmartlicenseHolder",
    "SmartlicenseHolderFsm",
    "SmartlicenseHolderFsmStage",
    "SmartlicenseHolderFsmTask",
    "SmartlicenseTest",
    "SmartlicenseTestFsm",
    "SmartlicenseTestFsmStage",
    "SmartlicenseTestFsmTask",
    "SolPolicy",
    "StatsChartContainer",
    "StatsCollectionPolicy",
    "StatsCustomChart",
    "StatsCustomEp",
    "StatsDbMigrationStatus",
    "StatsDbSummaryMeta",
    "StatsHolder",
    "StatsInventoryMeta",
    "StatsPasadenaCollectionPolicy",
    "StatsStandardChart",
    "StatsStandardEp",
    "StatsStatsQuery",
    "StatsStatsQueryHolder",
    "StatsThr32Definition",
    "StatsThr32Value",
    "StatsThr64Definition",
    "StatsThr64Value",
    "StatsThrFloatDefinition",
    "StatsThrFloatValue",
    "StatsThresholdClass",
    "StatsThresholdPolicy",
    "StorageArray",
    "StorageAuthKey",
    "StorageBlade",
    "StorageCloud",
    "StorageClusterIdUniverse",
    "StorageComputeBladeOperation",
    "StorageConnectionDef",
    "StorageConnectionPolicy",
    "StorageController",
    "StorageControllerEp",
    "StorageControllerOperation",
    "StorageControllerRef",
    "StorageCtrlStorageStats",
    "StorageCtrlStorageStatsHist",
    "StorageDiskEnvStats",
    "StorageDiskEnvStatsHist",
    "StorageDiskEp",
    "StorageDiskGroup",
    "StorageEmbeddedStorage",
    "StorageEnclosure",
    "StorageEnclosureDiskSlotEp",
    "StorageEnclosureLocalDiskConfig",
    "StorageEpUser",
    "StorageEthLif",
    "StorageEtherIf",
    "StorageFcIf",
    "StorageFcTargetEp",
    "StorageFcTargetIf",
    "StorageFlexFlashCard",
    "StorageFlexFlashController",
    "StorageFlexFlashControllerOperation",
    "StorageFlexFlashDrive",
    "StorageFlexFlashVirtualDrive",
    "StorageHddMotherBoardTempStats",
    "StorageHddMotherBoardTempStatsHist",
    "StorageIScsiInitiatorEp",
    "StorageIScsiTargetIf",
    "StorageIniGroup",
    "StorageInitiator",
    "StorageInitiatorRef",
    "StorageIpV4PooledAddr",
    "StorageIpV4StaticAddr",
    "StorageItem",
    "StorageLocalDisk",
    "StorageLocalDiskConfigDef",
    "StorageLocalDiskConfigPolicy",
    "StorageLocalDiskEp",
    "StorageLocalDiskOperation",
    "StorageLocalDiskPartition",
    "StorageLocalLun",
    "StorageLunCounters",
    "StorageLunDisk",
    "StorageLunMaskGroup",
    "StorageLunReplica",
    "StorageLunResourceSelectionLog",
    "StorageLunSnapshot",
    "StorageMeta",
    "StorageMezzFlashLife",
    "StorageNodeEp",
    "StorageNvmeStats",
    "StorageNvmeStatsHist",
    "StorageNvmeStorage",
    "StorageOnboardDevice",
    "StorageOperation",
    "StoragePartition",
    "StorageProcessor",
    "StorageProcessorEp",
    "StorageProcessorRuntime",
    "StorageQual",
    "StorageRaidBattery",
    "StorageReplicationCtx",
    "StorageSasExpander",
    "StorageSasPort",
    "StorageSasUpLink",
    "StorageScsiDeviceDescriptor",
    "StorageScsiLun",
    "StorageScsiLunCtx",
    "StorageScsiLunInstRef",
    "StorageScsiLunMask",
    "StorageScsiLunRef",
    "StorageSnapshotCtx",
    "StorageSsdHealthStats",
    "StorageSsdHealthStatsHist",
    "StorageStorageStats",
    "StorageStorageStatsHist",
    "StorageSystem",
    "StorageTransportableFlashModule",
    "StorageUsageCounters",
    "StorageVDMemberEp",
    "StorageVirtualDrive",
    "StorageVirtualDriveContainer",
    "StorageVirtualDriveEp",
    "StorageVirtualDriveOperation",
    "StorageVirtualDriveRef",
    "StorageVirtualDriveRefOperation",
    "StorageVolume",
    "StorageVsanRef",
    "StorageVsanRefIvt",
    "SwCardEnvStats",
    "SwCardEnvStatsHist",
    "SwEnvStats",
    "SwEnvStatsHist",
    "SwSystemStats",
    "SwSystemStatsHist",
    "SyntheticDirectory",
    "SyntheticFile",
    "SyntheticFileSystem",
    "SyntheticFsObj",
    "SyntheticTime",
    "SysdebugAutoCoreFileExportTarget",
    "SysdebugAutoCoreFileExportTargetFsm",
    "SysdebugAutoCoreFileExportTargetFsmStage",
    "SysdebugAutoCoreFileExportTargetFsmTask",
    "SysdebugBackupBehavior",
    "SysdebugCore",
    "SysdebugCoreFileRepository",
    "SysdebugDiagnosticLog",
    "SysdebugEp",
    "SysdebugLogControlDestinationFile",
    "SysdebugLogControlDestinationSyslog",
    "SysdebugLogControlDomain",
    "SysdebugLogControlEp",
    "SysdebugLogControlEpFsm",
    "SysdebugLogControlEpFsmStage",
    "SysdebugLogControlEpFsmTask",
    "SysdebugLogControlModule",
    "SysdebugMEpLogPolicy",
    "SysdebugManualCoreFileExportTarget",
    "SysdebugManualCoreFileExportTargetFsm",
    "SysdebugManualCoreFileExportTargetFsmStage",
    "SysdebugManualCoreFileExportTargetFsmTask",
    "SysdebugTechSupFileRepository",
    "SysdebugTechSupport",
    "SysdebugTechSupportCmdOpt",
    "SysdebugTechSupportFsm",
    "SysdebugTechSupportFsmStage",
    "SysdebugTechSupportFsmTask",
    "SysdebugTechSupportOp",
    "SysdebugTechSupportOperation",
    "SysfileDigest",
    "SysfileMutation",
    "SysfileMutationFsm",
    "SysfileMutationFsmStage",
    "SysfileMutationFsmTask",
    "TagDef",
    "TagDefEp",
    "TagDriver",
    "TagInstance",
    "TagInstanceEp",
    "TagInstanceItem",
    "TagItem",
    "TagSoftwareInst",
    "TestingCliPolicy",
    "TestingServiceProfile",
    "TestingServiceProfileFsm",
    "TestingServiceProfileFsmStage",
    "TestingServiceProfileFsmTask",
    "TestingSnmpCommunity",
    "TestingSnmpPolicy",
    "TestingSnmpSupport",
    "TestingSnmpTrap",
    "TopInfoSyncPolicy",
    "TopMetaInf",
    "TopRoot",
    "TopSystem",
    "TopSystemFsm",
    "TopSystemFsmStage",
    "TopSystemFsmTask",
    "TrigAbsWindow",
    "TrigMeta",
    "TrigPendingAckCount",
    "TrigRecurrWindow",
    "TrigSched",
    "TrigServerToken",
    "TrigTest",
    "TrigTokenRequestor",
    "TrigTriggered",
    "UuidpoolAddr",
    "UuidpoolBlock",
    "UuidpoolFormat",
    "UuidpoolPool",
    "UuidpoolPooled",
    "UuidpoolUniverse",
    "VersionApplication",
    "VersionEp",
    "VersionFilter",
    "VersionMatrix",
    "VersionProduct",
    "VmNic",
    "VnicBootIpPolicy",
    "VnicBootTarget",
    "VnicConnDef",
    "VnicDefBeh",
    "VnicDynamicCon",
    "VnicDynamicConPolicy",
    "VnicDynamicConPolicyRef",
    "VnicEthLif",
    "VnicEther",
    "VnicEtherIf",
    "VnicFault",
    "VnicFc",
    "VnicFcGroupDef",
    "VnicFcGroupTempl",
    "VnicFcIf",
    "VnicFcLif",
    "VnicFcNode",
    "VnicFcOEIf",
    "VnicIPv4Dhcp",
    "VnicIPv4Dns",
    "VnicIPv4If",
    "VnicIPv4IscsiAddr",
    "VnicIPv4PooledIscsiAddr",
    "VnicIPv4StaticRoute",
    "VnicIPv6If",
    "VnicIScsi",
    "VnicIScsiAutoTargetIf",
    "VnicIScsiBootParams",
    "VnicIScsiBootVnic",
    "VnicIScsiInitiatorParams",
    "VnicIScsiLCP",
    "VnicIScsiNode",
    "VnicIScsiStaticTargetIf",
    "VnicIScsiTargetParams",
    "VnicIniGrpFc",
    "VnicIniGrpFcB",
    "VnicIniGrpFcBIf",
    "VnicIniGrpFcIf",
    "VnicIpV4MgmtPooledAddr",
    "VnicIpV4PooledAddr",
    "VnicIpV4ProfDerivedAddr",
    "VnicIpV4StaticAddr",
    "VnicIpV6MgmtPooledAddr",
    "VnicIpV6StaticAddr",
    "VnicLanConnPolicy",
    "VnicLanConnTempl",
    "VnicLifVlan",
    "VnicLifVsan",
    "VnicLstorageIScsi",
    "VnicLun",
    "VnicMgmt",
    "VnicMgmtIf",
    "VnicMonSesFc",
    "VnicMonSesFcIf",
    "VnicNetGroup",
    "VnicNetGroupRef",
    "VnicOutbandMgmtEp",
    "VnicOutbandMgmtEpFsm",
    "VnicOutbandMgmtEpFsmStage",
    "VnicOutbandMgmtEpFsmTask",
    "VnicProfileSet",
    "VnicRackServerDiscoveryProfile",
    "VnicSanConnPolicy",
    "VnicSanConnTempl",
    "VnicStorageEthLif",
    "VnicUsnicConPolicy",
    "VnicUsnicConPolicyRef",
    "VnicVhbaBehPolicy",
    "VnicVlan",
    "VnicVmqConPolicy",
    "VnicVmqConPolicyRef",
    "VnicVnicBehPolicy",
    ])

MO_CLASS_META = {
    "AaaAuthRealm": MoMeta("AaaAuthRealm", "aaaAuthRealm", "auth-realm", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'orgDomainGroup', u'policyDeviceProfile', u'topSystem'], [u'aaaAuthRealmFsm', u'aaaConsoleAuth', u'aaaDefaultAuth', u'aaaDomain', u'aaaRealmFsm', u'aaaRealmFsmTask', u'eventInst', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaAuthRealmFsm": MoMeta("AaaAuthRealmFsm", "aaaAuthRealmFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'aaaAuthRealm'], [u'aaaAuthRealmFsmStage'], [None]),
    "AaaAuthRealmFsmStage": MoMeta("AaaAuthRealmFsmStage", "aaaAuthRealmFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'aaaAuthRealmFsm'], [], [None]),
    "AaaConsoleAuth": MoMeta("AaaConsoleAuth", "aaaConsoleAuth", "console-auth", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], [u'aaaAuthRealm'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaDefaultAuth": MoMeta("AaaDefaultAuth", "aaaDefaultAuth", "default-auth", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], [u'aaaAuthRealm'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaDomain": MoMeta("AaaDomain", "aaaDomain", "domain-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], [u'aaaAuthRealm'], [u'aaaDomainAuth'], ["Add", "Get", "Remove", "Set"]),
    "AaaDomainAuth": MoMeta("AaaDomainAuth", "aaaDomainAuth", "domain-auth", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], [u'aaaDomain'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaDomainGroup": MoMeta("AaaDomainGroup", "aaaDomainGroup", "domaingroup-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaLocale'], [], ["Add", "Get", "Remove"]),
    "AaaEpAuthProfile": MoMeta("AaaEpAuthProfile", "aaaEpAuthProfile", "auth-profile-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'orgDomainGroup', u'orgOrg'], [u'aaaEpUser'], ["Add", "Get", "Remove", "Set"]),
    "AaaEpFsm": MoMeta("AaaEpFsm", "aaaEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'aaaLdapEp', u'aaaRadiusEp', u'aaaTacacsPlusEp'], [u'aaaEpFsmStage'], [None]),
    "AaaEpFsmStage": MoMeta("AaaEpFsmStage", "aaaEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'aaaEpFsm'], [], [None]),
    "AaaEpFsmTask": MoMeta("AaaEpFsmTask", "aaaEpFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'aaaLdapEp', u'aaaRadiusEp', u'aaaTacacsPlusEp'], [], [None]),
    "AaaEpLogin": MoMeta("AaaEpLogin", "aaaEpLogin", "ep-login-[name]-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'aaaUserEp'], [], ["Get"]),
    "AaaEpUser": MoMeta("AaaEpUser", "aaaEpUser", "user-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "ls-security", "ls-security-policy"], [u'aaaEpAuthProfile'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaExtMgmtCutThruTkn": MoMeta("AaaExtMgmtCutThruTkn", "aaaExtMgmtCutThruTkn", "cutthrutkn-[token]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaUserEp'], [], ["Get"]),
    "AaaLdapEp": MoMeta("AaaLdapEp", "aaaLdapEp", "ldap-ext", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'orgDomainGroup', u'policyDeviceProfile', u'topSystem'], [u'aaaEpFsm', u'aaaEpFsmTask', u'aaaLdapEpFsm', u'aaaLdapGroup', u'aaaLdapGroupRule', u'aaaLdapProvider', u'aaaProviderGroup', u'eventInst', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaLdapEpFsm": MoMeta("AaaLdapEpFsm", "aaaLdapEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'aaaLdapEp'], [u'aaaLdapEpFsmStage'], [None]),
    "AaaLdapEpFsmStage": MoMeta("AaaLdapEpFsmStage", "aaaLdapEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'aaaLdapEpFsm'], [], [None]),
    "AaaLdapGroup": MoMeta("AaaLdapGroup", "aaaLdapGroup", "ldapgroup-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], [u'aaaLdapEp'], [u'aaaUserLocale', u'aaaUserRole'], ["Add", "Get", "Remove", "Set"]),
    "AaaLdapGroupRule": MoMeta("AaaLdapGroupRule", "aaaLdapGroupRule", "ldapgroup-rule", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], [u'aaaLdapEp', u'aaaLdapProvider'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaLdapProvider": MoMeta("AaaLdapProvider", "aaaLdapProvider", "provider-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaLdapEp'], [u'aaaLdapGroupRule'], ["Add", "Get", "Remove", "Set"]),
    "AaaLocale": MoMeta("AaaLocale", "aaaLocale", "locale-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'orgDomainGroup', u'policyDeviceProfile'], [u'aaaDomainGroup', u'aaaOrg'], ["Add", "Get", "Remove", "Set"]),
    "AaaLog": MoMeta("AaaLog", "aaaLog", "aaa-log", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "operations"], [u'topRoot'], [u'aaaModLR', u'aaaSessionLR'], ["Get"]),
    "AaaModLR": MoMeta("AaaModLR", "aaaModLR", "aaamlr-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'aaaLog'], [], ["Get"]),
    "AaaOrg": MoMeta("AaaOrg", "aaaOrg", "org-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaLocale'], [], ["Add", "Get", "Remove"]),
    "AaaProviderGroup": MoMeta("AaaProviderGroup", "aaaProviderGroup", "providergroup-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], [u'aaaLdapEp', u'aaaRadiusEp', u'aaaTacacsPlusEp'], [u'aaaProviderRef'], ["Add", "Get", "Remove", "Set"]),
    "AaaProviderRef": MoMeta("AaaProviderRef", "aaaProviderRef", "provider-ref-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], [u'aaaProviderGroup'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaPwdProfile": MoMeta("AaaPwdProfile", "aaaPwdProfile", "pwd-profile", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaUserEp', u'orgDomainGroup', u'policyDeviceProfile'], [], ["Get", "Set"]),
    "AaaRadiusEp": MoMeta("AaaRadiusEp", "aaaRadiusEp", "radius-ext", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'orgDomainGroup', u'policyDeviceProfile', u'topSystem'], [u'aaaEpFsm', u'aaaEpFsmTask', u'aaaProviderGroup', u'aaaRadiusEpFsm', u'aaaRadiusProvider', u'eventInst', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaRadiusEpFsm": MoMeta("AaaRadiusEpFsm", "aaaRadiusEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'aaaRadiusEp'], [u'aaaRadiusEpFsmStage'], [None]),
    "AaaRadiusEpFsmStage": MoMeta("AaaRadiusEpFsmStage", "aaaRadiusEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'aaaRadiusEpFsm'], [], [None]),
    "AaaRadiusProvider": MoMeta("AaaRadiusProvider", "aaaRadiusProvider", "provider-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaRadiusEp'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaRealmFsm": MoMeta("AaaRealmFsm", "aaaRealmFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'aaaAuthRealm'], [u'aaaRealmFsmStage'], [None]),
    "AaaRealmFsmStage": MoMeta("AaaRealmFsmStage", "aaaRealmFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'aaaRealmFsm'], [], [None]),
    "AaaRealmFsmTask": MoMeta("AaaRealmFsmTask", "aaaRealmFsmTask", "task-[item]", VersionMeta.Version112a, "OutputOnly", 0x1, [], [""], [u'aaaAuthRealm'], [], [None]),
    "AaaRemoteUser": MoMeta("AaaRemoteUser", "aaaRemoteUser", "remoteuser-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], [u'aaaUserEp'], [u'aaaSession', u'aaaUserLocale', u'aaaUserRole'], ["Get", "Remove"]),
    "AaaRole": MoMeta("AaaRole", "aaaRole", "role-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'orgDomainGroup', u'policyDeviceProfile'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaSession": MoMeta("AaaSession", "aaaSession", "term-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], [u'aaaRemoteUser', u'aaaUser'], [], ["Get", "Remove"]),
    "AaaSessionLR": MoMeta("AaaSessionLR", "aaaSessionLR", "aaaslr-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'aaaLog'], [], ["Get"]),
    "AaaShellLogin": MoMeta("AaaShellLogin", "aaaShellLogin", "sh-login-[name]-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'aaaUserEp'], [], ["Get"]),
    "AaaSshAuth": MoMeta("AaaSshAuth", "aaaSshAuth", "sshauth", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaUser'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaTacacsPlusEp": MoMeta("AaaTacacsPlusEp", "aaaTacacsPlusEp", "tacacs-ext", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'orgDomainGroup', u'policyDeviceProfile', u'topSystem'], [u'aaaEpFsm', u'aaaEpFsmTask', u'aaaProviderGroup', u'aaaTacacsPlusEpFsm', u'aaaTacacsPlusProvider', u'eventInst', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "AaaTacacsPlusEpFsm": MoMeta("AaaTacacsPlusEpFsm", "aaaTacacsPlusEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'aaaTacacsPlusEp'], [u'aaaTacacsPlusEpFsmStage'], [None]),
    "AaaTacacsPlusEpFsmStage": MoMeta("AaaTacacsPlusEpFsmStage", "aaaTacacsPlusEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'aaaTacacsPlusEpFsm'], [], [None]),
    "AaaTacacsPlusProvider": MoMeta("AaaTacacsPlusProvider", "aaaTacacsPlusProvider", "provider-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaTacacsPlusEp'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaUser": MoMeta("AaaUser", "aaaUser", "user-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'orgDomainGroup', u'policyDeviceProfile'], [u'aaaSession', u'aaaSshAuth', u'aaaUserData', u'aaaUserLocale', u'aaaUserRole'], ["Add", "Get", "Remove", "Set"]),
    "AaaUserData": MoMeta("AaaUserData", "aaaUserData", "user-data", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaUser'], [], ["Get"]),
    "AaaUserEp": MoMeta("AaaUserEp", "aaaUserEp", "user-ext", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'topSystem'], [u'aaaEpLogin', u'aaaExtMgmtCutThruTkn', u'aaaLocale', u'aaaPwdProfile', u'aaaRemoteUser', u'aaaRole', u'aaaShellLogin', u'aaaUser', u'aaaUserEpFsm', u'aaaUserEpFsmTask', u'aaaUserPreferences', u'aaaWebLogin', u'eventInst', u'faultInst'], ["Get", "Set"]),
    "AaaUserEpFsm": MoMeta("AaaUserEpFsm", "aaaUserEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'aaaUserEp'], [u'aaaUserEpFsmStage'], [None]),
    "AaaUserEpFsmStage": MoMeta("AaaUserEpFsmStage", "aaaUserEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'aaaUserEpFsm'], [], [None]),
    "AaaUserEpFsmTask": MoMeta("AaaUserEpFsmTask", "aaaUserEpFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'aaaUserEp'], [], ["Get"]),
    "AaaUserLocale": MoMeta("AaaUserLocale", "aaaUserLocale", "locale-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaLdapGroup', u'aaaRemoteUser', u'aaaUser'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaUserPreferences": MoMeta("AaaUserPreferences", "aaaUserPreferences", "pref-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["aaa", "admin", "read-only"], [u'aaaUserEp'], [], ["Get", "Set"]),
    "AaaUserRole": MoMeta("AaaUserRole", "aaaUserRole", "role-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'aaaLdapGroup', u'aaaRemoteUser', u'aaaUser'], [], ["Add", "Get", "Remove", "Set"]),
    "AaaWebLogin": MoMeta("AaaWebLogin", "aaaWebLogin", "web-login-[name]-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'aaaUserEp'], [], ["Get"]),
    "AdaptorCapQual": MoMeta("AdaptorCapQual", "adaptorCapQual", "cap-[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], [u'adaptorQual'], [], ["Add", "Get", "Remove", "Set"]),
    "AdaptorCapSpec": MoMeta("AdaptorCapSpec", "adaptorCapSpec", "cap-[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorEthAdvFilterProfile": MoMeta("AdaptorEthAdvFilterProfile", "adaptorEthAdvFilterProfile", "eth-adv-filter", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIfProfile'], [], ["Get", "Set"]),
    "AdaptorEthArfsProfile": MoMeta("AdaptorEthArfsProfile", "adaptorEthArfsProfile", "eth-arfs", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIfProfile'], [], ["Get", "Set"]),
    "AdaptorEthCompQueueProfile": MoMeta("AdaptorEthCompQueueProfile", "adaptorEthCompQueueProfile", "eth-comp-q", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef', u'adaptorVmmqConnDef'], [], ["Get", "Set"]),
    "AdaptorEthFailoverProfile": MoMeta("AdaptorEthFailoverProfile", "adaptorEthFailoverProfile", "eth-failover", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef'], [], ["Get", "Set"]),
    "AdaptorEthGENEVEProfile": MoMeta("AdaptorEthGENEVEProfile", "adaptorEthGENEVEProfile", "eth-geneve", VersionMeta.Version201m, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIfProfile'], [], [None]),
    "AdaptorEthInterruptProfile": MoMeta("AdaptorEthInterruptProfile", "adaptorEthInterruptProfile", "eth-int", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef', u'adaptorVmmqConnDef'], [], ["Get", "Set"]),
    "AdaptorEthInterruptScalingProfile": MoMeta("AdaptorEthInterruptScalingProfile", "adaptorEthInterruptScalingProfile", "eth-interrupt-scaling", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef'], [], ["Get", "Set"]),
    "AdaptorEthNVGREProfile": MoMeta("AdaptorEthNVGREProfile", "adaptorEthNVGREProfile", "eth-nvgre", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIfProfile'], [], ["Get", "Set"]),
    "AdaptorEthOffloadProfile": MoMeta("AdaptorEthOffloadProfile", "adaptorEthOffloadProfile", "eth-offload", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef'], [], ["Get", "Set"]),
    "AdaptorEthPortBySizeLargeStats": MoMeta("AdaptorEthPortBySizeLargeStats", "adaptorEthPortBySizeLargeStats", "eth-port-by-size-large-stats-[traffic_direction]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorHostEthIf', u'vmNic'], [u'adaptorEthPortBySizeLargeStatsHist'], [None]),
    "AdaptorEthPortBySizeLargeStatsHist": MoMeta("AdaptorEthPortBySizeLargeStatsHist", "adaptorEthPortBySizeLargeStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorEthPortBySizeLargeStats'], [], [None]),
    "AdaptorEthPortBySizeSmallStats": MoMeta("AdaptorEthPortBySizeSmallStats", "adaptorEthPortBySizeSmallStats", "eth-port-by-size-small-stats-[traffic_direction]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorHostEthIf', u'vmNic'], [u'adaptorEthPortBySizeSmallStatsHist'], [None]),
    "AdaptorEthPortBySizeSmallStatsHist": MoMeta("AdaptorEthPortBySizeSmallStatsHist", "adaptorEthPortBySizeSmallStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorEthPortBySizeSmallStats'], [], [None]),
    "AdaptorEthPortErrStats": MoMeta("AdaptorEthPortErrStats", "adaptorEthPortErrStats", "eth-port-err-stats-[traffic_direction]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorHostEthIf', u'vmNic'], [u'adaptorEthPortErrStatsHist'], [None]),
    "AdaptorEthPortErrStatsHist": MoMeta("AdaptorEthPortErrStatsHist", "adaptorEthPortErrStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorEthPortErrStats'], [], [None]),
    "AdaptorEthPortMcastStats": MoMeta("AdaptorEthPortMcastStats", "adaptorEthPortMcastStats", "eth-port-mcast-stats-[traffic_direction]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorHostEthIf', u'vmNic'], [u'adaptorEthPortMcastStatsHist'], [None]),
    "AdaptorEthPortMcastStatsHist": MoMeta("AdaptorEthPortMcastStatsHist", "adaptorEthPortMcastStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorEthPortMcastStats'], [], [None]),
    "AdaptorEthPortOutsizedStats": MoMeta("AdaptorEthPortOutsizedStats", "adaptorEthPortOutsizedStats", "eth-port-outsized-stats-[traffic_direction]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorHostEthIf', u'vmNic'], [u'adaptorEthPortOutsizedStatsHist'], [None]),
    "AdaptorEthPortOutsizedStatsHist": MoMeta("AdaptorEthPortOutsizedStatsHist", "adaptorEthPortOutsizedStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorEthPortOutsizedStats'], [], [None]),
    "AdaptorEthPortStats": MoMeta("AdaptorEthPortStats", "adaptorEthPortStats", "eth-port-stats-[traffic_direction]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorHostEthIf', u'vmNic'], [u'adaptorEthPortStatsHist'], [None]),
    "AdaptorEthPortStatsHist": MoMeta("AdaptorEthPortStatsHist", "adaptorEthPortStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorEthPortStats'], [], [None]),
    "AdaptorEthRecvQueueProfile": MoMeta("AdaptorEthRecvQueueProfile", "adaptorEthRecvQueueProfile", "eth-rcv-q", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef', u'adaptorVmmqConnDef'], [], ["Get", "Set"]),
    "AdaptorEthRoCEProfile": MoMeta("AdaptorEthRoCEProfile", "adaptorEthRoCEProfile", "eth-roce", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIfProfile', u'adaptorVmmqConnDef'], [], ["Get", "Set"]),
    "AdaptorEthVxLANProfile": MoMeta("AdaptorEthVxLANProfile", "adaptorEthVxLANProfile", "eth-vxlan", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIfProfile'], [], ["Get", "Set"]),
    "AdaptorEthWorkQueueProfile": MoMeta("AdaptorEthWorkQueueProfile", "adaptorEthWorkQueueProfile", "eth-work-q", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef', u'adaptorVmmqConnDef'], [], ["Get", "Set"]),
    "AdaptorEtherIfStats": MoMeta("AdaptorEtherIfStats", "adaptorEtherIfStats", "ether-if-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorVlan'], [u'adaptorEtherIfStatsHist'], [None]),
    "AdaptorEtherIfStatsHist": MoMeta("AdaptorEtherIfStatsHist", "adaptorEtherIfStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorEtherIfStats'], [], [None]),
    "AdaptorExtEthIf": MoMeta("AdaptorExtEthIf", "adaptorExtEthIf", "ext-eth-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], [u'adaptorUnit'], [u'adaptorExtEthIfOperation', u'dcxVIf', u'fabricEthMonSrcEp', u'fabricEthMonSrcEpOperation'], ["Get"]),
    "AdaptorExtEthIfOperation": MoMeta("AdaptorExtEthIfOperation", "adaptorExtEthIfOperation", "remote-oper", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance"], [u'adaptorExtEthIf'], [u'faultInst'], ["get", "set"]),
    "AdaptorExtIpV6RssHashProfile": MoMeta("AdaptorExtIpV6RssHashProfile", "adaptorExtIpV6RssHashProfile", "ext-ipv6-rss-hash", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef'], [], ["Get"]),
    "AdaptorFcCdbWorkQueueProfile": MoMeta("AdaptorFcCdbWorkQueueProfile", "adaptorFcCdbWorkQueueProfile", "fc-cdb-work-q", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], [u'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcErrorRecoveryProfile": MoMeta("AdaptorFcErrorRecoveryProfile", "adaptorFcErrorRecoveryProfile", "fc-err-rec", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], [u'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcFnicProfile": MoMeta("AdaptorFcFnicProfile", "adaptorFcFnicProfile", "fc-fnic", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], [u'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcIfEventStats": MoMeta("AdaptorFcIfEventStats", "adaptorFcIfEventStats", "fc-if-event-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorHostFcIf'], [u'adaptorFcIfEventStatsHist'], [None]),
    "AdaptorFcIfEventStatsHist": MoMeta("AdaptorFcIfEventStatsHist", "adaptorFcIfEventStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorFcIfEventStats'], [], [None]),
    "AdaptorFcIfFC4Stats": MoMeta("AdaptorFcIfFC4Stats", "adaptorFcIfFC4Stats", "fc-if-fc4-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorHostFcIf'], [u'adaptorFcIfFC4StatsHist'], [None]),
    "AdaptorFcIfFC4StatsHist": MoMeta("AdaptorFcIfFC4StatsHist", "adaptorFcIfFC4StatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorFcIfFC4Stats'], [], [None]),
    "AdaptorFcIfFrameStats": MoMeta("AdaptorFcIfFrameStats", "adaptorFcIfFrameStats", "fc-if-frame-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorHostFcIf'], [u'adaptorFcIfFrameStatsHist'], [None]),
    "AdaptorFcIfFrameStatsHist": MoMeta("AdaptorFcIfFrameStatsHist", "adaptorFcIfFrameStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorFcIfFrameStats'], [], [None]),
    "AdaptorFcInterruptProfile": MoMeta("AdaptorFcInterruptProfile", "adaptorFcInterruptProfile", "fc-int", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], [u'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcPortFLogiProfile": MoMeta("AdaptorFcPortFLogiProfile", "adaptorFcPortFLogiProfile", "fc-port-flogi", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], [u'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcPortPLogiProfile": MoMeta("AdaptorFcPortPLogiProfile", "adaptorFcPortPLogiProfile", "fc-port-plogi", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], [u'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcPortProfile": MoMeta("AdaptorFcPortProfile", "adaptorFcPortProfile", "fc-port", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], [u'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcPortStats": MoMeta("AdaptorFcPortStats", "adaptorFcPortStats", "fc-port-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorHostFcIf', u'vmNic'], [u'adaptorFcPortStatsHist'], [None]),
    "AdaptorFcPortStatsHist": MoMeta("AdaptorFcPortStatsHist", "adaptorFcPortStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorFcPortStats'], [], [None]),
    "AdaptorFcRecvQueueProfile": MoMeta("AdaptorFcRecvQueueProfile", "adaptorFcRecvQueueProfile", "fc-rcv-q", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], [u'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFcWorkQueueProfile": MoMeta("AdaptorFcWorkQueueProfile", "adaptorFcWorkQueueProfile", "fc-work-q", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage"], [u'adaptorHostFcIfProfile'], [], ["Get", "Set"]),
    "AdaptorFruCapProvider": MoMeta("AdaptorFruCapProvider", "adaptorFruCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [u'adaptorCapSpec', u'adaptorIScsiCap', u'adaptorRnicCapSpec', u'equipmentFruVariant', u'equipmentManufacturingDef', u'equipmentPicture'], ["Get"]),
    "AdaptorHBAVnicStats": MoMeta("AdaptorHBAVnicStats", "adaptorHBAVnicStats", "hba-vnic-stats", VersionMeta.Version111b, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], [u'adaptorHBAVnicStatsHist'], ["Get"]),
    "AdaptorHBAVnicStatsHist": MoMeta("AdaptorHBAVnicStatsHist", "adaptorHBAVnicStatsHist", "[id]", VersionMeta.Version111b, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorHBAVnicStats'], [], ["Get"]),
    "AdaptorHostEthIf": MoMeta("AdaptorHostEthIf", "adaptorHostEthIf", "host-eth-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], [u'adaptorUnit'], [u'adaptorEthPortBySizeLargeStats', u'adaptorEthPortBySizeSmallStats', u'adaptorEthPortErrStats', u'adaptorEthPortMcastStats', u'adaptorEthPortOutsizedStats', u'adaptorEthPortStats', u'adaptorHostEthIfOperation', u'adaptorUsnicConnDef', u'adaptorVlan', u'adaptorVmmqConnDef', u'adaptorVnicStats', u'dcxVIf', u'faultInst'], ["Get", "Set"]),
    "AdaptorHostEthIfOperation": MoMeta("AdaptorHostEthIfOperation", "adaptorHostEthIfOperation", "remote-oper", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance"], [u'adaptorHostEthIf'], [u'faultInst'], ["get", "set"]),
    "AdaptorHostEthIfProfile": MoMeta("AdaptorHostEthIfProfile", "adaptorHostEthIfProfile", "eth-profile-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg', u'policySystemEp'], [u'adaptorEthAdvFilterProfile', u'adaptorEthArfsProfile', u'adaptorEthCompQueueProfile', u'adaptorEthFailoverProfile', u'adaptorEthGENEVEProfile', u'adaptorEthInterruptProfile', u'adaptorEthInterruptScalingProfile', u'adaptorEthNVGREProfile', u'adaptorEthOffloadProfile', u'adaptorEthRecvQueueProfile', u'adaptorEthRoCEProfile', u'adaptorEthVxLANProfile', u'adaptorEthWorkQueueProfile', u'adaptorExtIpV6RssHashProfile', u'adaptorIpV4RssHashProfile', u'adaptorIpV6RssHashProfile', u'adaptorRssProfile'], ["Add", "Get", "Remove", "Set"]),
    "AdaptorHostFcIf": MoMeta("AdaptorHostFcIf", "adaptorHostFcIf", "host-fc-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], [u'adaptorUnit'], [u'adaptorFcIfEventStats', u'adaptorFcIfFC4Stats', u'adaptorFcIfFrameStats', u'adaptorFcPortStats', u'adaptorHostFcIfOperation', u'adaptorVnicStats', u'dcxVIf', u'faultInst'], ["Get", "Set"]),
    "AdaptorHostFcIfOperation": MoMeta("AdaptorHostFcIfOperation", "adaptorHostFcIfOperation", "remote-oper", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance"], [u'adaptorHostFcIf'], [u'faultInst'], ["get", "set"]),
    "AdaptorHostFcIfProfile": MoMeta("AdaptorHostFcIfProfile", "adaptorHostFcIfProfile", "fc-profile-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'adaptorFcCdbWorkQueueProfile', u'adaptorFcErrorRecoveryProfile', u'adaptorFcFnicProfile', u'adaptorFcInterruptProfile', u'adaptorFcPortFLogiProfile', u'adaptorFcPortPLogiProfile', u'adaptorFcPortProfile', u'adaptorFcRecvQueueProfile', u'adaptorFcWorkQueueProfile'], ["Add", "Get", "Remove", "Set"]),
    "AdaptorHostIfConfig": MoMeta("AdaptorHostIfConfig", "adaptorHostIfConfig", "host-if-config-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [], ["Get"]),
    "AdaptorHostIscsiIf": MoMeta("AdaptorHostIscsiIf", "adaptorHostIscsiIf", "host-iscsi-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], [u'adaptorUnit'], [u'adaptorHostIscsiIfOperation', u'adaptorVlan', u'adaptorVnicStats', u'faultInst'], ["get"]),
    "AdaptorHostIscsiIfOperation": MoMeta("AdaptorHostIscsiIfOperation", "adaptorHostIscsiIfOperation", "remote-oper", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance"], [u'adaptorHostIscsiIf'], [u'faultInst'], ["get", "set"]),
    "AdaptorHostIscsiIfProfile": MoMeta("AdaptorHostIscsiIfProfile", "adaptorHostIscsiIfProfile", "iscsi-profile-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'adaptorProtocolProfile'], ["Add", "Get", "Remove", "Set"]),
    "AdaptorHostScsiIf": MoMeta("AdaptorHostScsiIf", "adaptorHostScsiIf", "host-scsi-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "pn-equipment", "pn-maintenance", "read-only"], [u'adaptorUnit'], [u'adaptorHostScsiLunRef', u'adaptorVnicStats', u'faultInst'], ["Get"]),
    "AdaptorHostScsiLunRef": MoMeta("AdaptorHostScsiLunRef", "adaptorHostScsiLunRef", "host-scsi-lun-[lun_order]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'adaptorHostScsiIf'], [], ["Get"]),
    "AdaptorIScsiCap": MoMeta("AdaptorIScsiCap", "adaptorIScsiCap", "iscsi", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorIpV4RssHashProfile": MoMeta("AdaptorIpV4RssHashProfile", "adaptorIpV4RssHashProfile", "ipv4-rss-hash", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef'], [], ["Get"]),
    "AdaptorIpV6RssHashProfile": MoMeta("AdaptorIpV6RssHashProfile", "adaptorIpV6RssHashProfile", "ipv6-rss-hash", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef'], [], ["Get"]),
    "AdaptorMenloBaseErrorStats": MoMeta("AdaptorMenloBaseErrorStats", "adaptorMenloBaseErrorStats", "menlo-base-error-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], [u'adaptorMenloBaseErrorStatsHist'], [None]),
    "AdaptorMenloBaseErrorStatsHist": MoMeta("AdaptorMenloBaseErrorStatsHist", "adaptorMenloBaseErrorStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloBaseErrorStats'], [], [None]),
    "AdaptorMenloDcePortStats": MoMeta("AdaptorMenloDcePortStats", "adaptorMenloDcePortStats", "menlo-dce-port-stats-[menlo_port_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloDcePortStatsHist'], [None]),
    "AdaptorMenloDcePortStatsHist": MoMeta("AdaptorMenloDcePortStatsHist", "adaptorMenloDcePortStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloDcePortStats'], [], [None]),
    "AdaptorMenloEthErrorStats": MoMeta("AdaptorMenloEthErrorStats", "adaptorMenloEthErrorStats", "menlo-eth-error-stats-[menlo_eth_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloEthErrorStatsHist'], [None]),
    "AdaptorMenloEthErrorStatsHist": MoMeta("AdaptorMenloEthErrorStatsHist", "adaptorMenloEthErrorStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloEthErrorStats'], [], [None]),
    "AdaptorMenloEthStats": MoMeta("AdaptorMenloEthStats", "adaptorMenloEthStats", "menlo-eth-stats-[menlo_eth_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloEthStatsHist'], [None]),
    "AdaptorMenloEthStatsHist": MoMeta("AdaptorMenloEthStatsHist", "adaptorMenloEthStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloEthStats'], [], [None]),
    "AdaptorMenloFcErrorStats": MoMeta("AdaptorMenloFcErrorStats", "adaptorMenloFcErrorStats", "menlo-fc-error-stats-[menlo_fc_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloFcErrorStatsHist'], [None]),
    "AdaptorMenloFcErrorStatsHist": MoMeta("AdaptorMenloFcErrorStatsHist", "adaptorMenloFcErrorStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloFcErrorStats'], [], [None]),
    "AdaptorMenloFcStats": MoMeta("AdaptorMenloFcStats", "adaptorMenloFcStats", "menlo-fc-stats-[menlo_fc_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloFcStatsHist'], [None]),
    "AdaptorMenloFcStatsHist": MoMeta("AdaptorMenloFcStatsHist", "adaptorMenloFcStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloFcStats'], [], [None]),
    "AdaptorMenloHostPortStats": MoMeta("AdaptorMenloHostPortStats", "adaptorMenloHostPortStats", "menlo-host-port-stats-[menlo_port_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloHostPortStatsHist'], [None]),
    "AdaptorMenloHostPortStatsHist": MoMeta("AdaptorMenloHostPortStatsHist", "adaptorMenloHostPortStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloHostPortStats'], [], [None]),
    "AdaptorMenloMcpuErrorStats": MoMeta("AdaptorMenloMcpuErrorStats", "adaptorMenloMcpuErrorStats", "menlo-mcpu-error-stats-[menlo_mcpu_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloMcpuErrorStatsHist'], [None]),
    "AdaptorMenloMcpuErrorStatsHist": MoMeta("AdaptorMenloMcpuErrorStatsHist", "adaptorMenloMcpuErrorStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloMcpuErrorStats'], [], [None]),
    "AdaptorMenloMcpuStats": MoMeta("AdaptorMenloMcpuStats", "adaptorMenloMcpuStats", "menlo-mcpu-stats-[menlo_mcpu_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloMcpuStatsHist'], [None]),
    "AdaptorMenloMcpuStatsHist": MoMeta("AdaptorMenloMcpuStatsHist", "adaptorMenloMcpuStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloMcpuStats'], [], [None]),
    "AdaptorMenloNetEgStats": MoMeta("AdaptorMenloNetEgStats", "adaptorMenloNetEgStats", "menlo-net-eg-stats-[menlo_net_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloNetEgStatsHist'], [None]),
    "AdaptorMenloNetEgStatsHist": MoMeta("AdaptorMenloNetEgStatsHist", "adaptorMenloNetEgStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloNetEgStats'], [], [None]),
    "AdaptorMenloNetInStats": MoMeta("AdaptorMenloNetInStats", "adaptorMenloNetInStats", "menlo-net-in-stats-[menlo_net_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloNetInStatsHist'], [None]),
    "AdaptorMenloNetInStatsHist": MoMeta("AdaptorMenloNetInStatsHist", "adaptorMenloNetInStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloNetInStats'], [], [None]),
    "AdaptorMenloQErrorStats": MoMeta("AdaptorMenloQErrorStats", "adaptorMenloQErrorStats", "menlo-q-error-stats-comp-[menlo_queue_component]index-[menlo_queue_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloQErrorStatsHist'], [None]),
    "AdaptorMenloQErrorStatsHist": MoMeta("AdaptorMenloQErrorStatsHist", "adaptorMenloQErrorStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloQErrorStats'], [], [None]),
    "AdaptorMenloQStats": MoMeta("AdaptorMenloQStats", "adaptorMenloQStats", "menlo-q-stats-comp-[menlo_queue_component]index-[menlo_queue_index]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorUnit'], [u'adaptorMenloQStatsHist'], [None]),
    "AdaptorMenloQStatsHist": MoMeta("AdaptorMenloQStatsHist", "adaptorMenloQStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorMenloQStats'], [], [None]),
    "AdaptorNICVnicStats": MoMeta("AdaptorNICVnicStats", "adaptorNICVnicStats", "nic-vnic-stats", VersionMeta.Version111b, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], [u'adaptorNICVnicStatsHist'], ["Get"]),
    "AdaptorNICVnicStatsHist": MoMeta("AdaptorNICVnicStatsHist", "adaptorNICVnicStatsHist", "[id]", VersionMeta.Version111b, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorNICVnicStats'], [], ["Get"]),
    "AdaptorProtocolProfile": MoMeta("AdaptorProtocolProfile", "adaptorProtocolProfile", "iscsi-prot-profile", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostIscsiIfProfile'], [], ["Add", "Get", "Set"]),
    "AdaptorQual": MoMeta("AdaptorQual", "adaptorQual", "adaptor", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], [u'computeQual'], [u'adaptorCapQual'], ["Add", "Get", "Remove"]),
    "AdaptorRnicCapSpec": MoMeta("AdaptorRnicCapSpec", "adaptorRnicCapSpec", "cap-[type]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'adaptorFruCapProvider'], [], ["Get"]),
    "AdaptorRssProfile": MoMeta("AdaptorRssProfile", "adaptorRssProfile", "rss", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-network", "ls-server-policy"], [u'adaptorHostEthIfProfile', u'adaptorUsnicConnDef', u'adaptorVmmqConnDef'], [], ["Get", "Set"]),
    "AdaptorUnit": MoMeta("AdaptorUnit", "adaptorUnit", "adaptor-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [u'adaptorExtEthIf', u'adaptorHostEthIf', u'adaptorHostFcIf', u'adaptorHostIscsiIf', u'adaptorHostScsiIf', u'adaptorMenloDcePortStats', u'adaptorMenloEthErrorStats', u'adaptorMenloEthStats', u'adaptorMenloFcErrorStats', u'adaptorMenloFcStats', u'adaptorMenloHostPortStats', u'adaptorMenloMcpuErrorStats', u'adaptorMenloMcpuStats', u'adaptorMenloNetEgStats', u'adaptorMenloNetInStats', u'adaptorMenloQErrorStats', u'adaptorMenloQStats', u'adaptorUnitExtn', u'faultInst', u'mgmtController'], ["Get"]),
    "AdaptorUnitAssocCtx": MoMeta("AdaptorUnitAssocCtx", "adaptorUnitAssocCtx", "adaptorunit-assoc-ctx-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'lsServerAssocCtx'], [], ["Get"]),
    "AdaptorUnitExtn": MoMeta("AdaptorUnitExtn", "adaptorUnitExtn", "adaptor-extn-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'adaptorUnit'], [], ["get"]),
    "AdaptorUsnicConnDef": MoMeta("AdaptorUsnicConnDef", "adaptorUsnicConnDef", "usnic-conn-def-[con_policy_name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "read-only"], [u'adaptorHostEthIf'], [u'adaptorEthCompQueueProfile', u'adaptorEthFailoverProfile', u'adaptorEthInterruptProfile', u'adaptorEthInterruptScalingProfile', u'adaptorEthOffloadProfile', u'adaptorEthRecvQueueProfile', u'adaptorEthWorkQueueProfile', u'adaptorExtIpV6RssHashProfile', u'adaptorIpV4RssHashProfile', u'adaptorIpV6RssHashProfile', u'adaptorRssProfile'], ["Get"]),
    "AdaptorVlan": MoMeta("AdaptorVlan", "adaptorVlan", "vlan-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'adaptorHostEthIf', u'adaptorHostIscsiIf'], [u'adaptorEtherIfStats', u'fabricConsumer', u'fabricEtherRef', u'faultInst'], ["Get"]),
    "AdaptorVmmqConnDef": MoMeta("AdaptorVmmqConnDef", "adaptorVmmqConnDef", "vmmq-conn-def-[con_policy_name]", VersionMeta.Version201f, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "read-only"], [u'adaptorHostEthIf'], [u'adaptorEthCompQueueProfile', u'adaptorEthInterruptProfile', u'adaptorEthRecvQueueProfile', u'adaptorEthRoCEProfile', u'adaptorEthWorkQueueProfile', u'adaptorRssProfile'], [None]),
    "AdaptorVnicStats": MoMeta("AdaptorVnicStats", "adaptorVnicStats", "virtual-interface-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'adaptorHostEthIf', u'adaptorHostFcIf', u'adaptorHostIscsiIf', u'adaptorHostScsiIf', u'vmNic'], [u'adaptorVnicStatsHist'], [None]),
    "AdaptorVnicStatsHist": MoMeta("AdaptorVnicStatsHist", "adaptorVnicStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'adaptorVnicStats'], [], [None]),
    "BiosBOT": MoMeta("BiosBOT", "biosBOT", "bdgep", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosUnit'], [u'biosBootDevGrp'], ["Get"]),
    "BiosBootDev": MoMeta("BiosBootDev", "biosBootDev", "[order]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosBootDevGrp'], [], ["Get"]),
    "BiosBootDevGrp": MoMeta("BiosBootDevGrp", "biosBootDevGrp", "bdg-[order]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosBOT'], [u'biosBootDev'], ["Get"]),
    "BiosTokenFeatureGroup": MoMeta("BiosTokenFeatureGroup", "biosTokenFeatureGroup", "tokn-featr-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosVProfile'], [u'biosTokenParam'], [None]),
    "BiosTokenParam": MoMeta("BiosTokenParam", "biosTokenParam", "tokn-param-[target_token_name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosTokenFeatureGroup'], [u'biosTokenSettings'], [None]),
    "BiosTokenSettings": MoMeta("BiosTokenSettings", "biosTokenSettings", "tokn-setng-[settings_mo_rn]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-policy"], [u'biosTokenParam'], [], [None]),
    "BiosUnit": MoMeta("BiosUnit", "biosUnit", "bios", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [u'biosBOT', u'firmwareRunning'], ["Get"]),
    "BiosVProfile": MoMeta("BiosVProfile", "biosVProfile", "bios-prof-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'biosTokenFeatureGroup', u'biosVfACPI10Support', u'biosVfASPMSupport', u'biosVfAllUSBDevices', u'biosVfAltitude', u'biosVfAssertNMIOnPERR', u'biosVfAssertNMIOnSERR', u'biosVfBootOptionRetry', u'biosVfCPUHardwarePowerManagement', u'biosVfCPUPerformance', u'biosVfCPUPowerManagement', u'biosVfConsistentDeviceNameControl', u'biosVfConsoleRedirection', u'biosVfCoreMultiProcessing', u'biosVfDDR3VoltageSelection', u'biosVfDRAMClockThrottling', u'biosVfDirectCacheAccess', u'biosVfDramRefreshRate', u'biosVfEnergyPerformanceTuning', u'biosVfEnhancedIntelSpeedStepTech', u'biosVfEnhancedPowerCappingSupport', u'biosVfExecuteDisableBit', u'biosVfFRB2Timer', u'biosVfFrequencyFloorOverride', u'biosVfFrontPanelLockout', u'biosVfIOEMezz1OptionROM', u'biosVfIOENVMe1OptionROM', u'biosVfIOENVMe2OptionROM', u'biosVfIOESlot1OptionROM', u'biosVfIOESlot2OptionROM', u'biosVfIntegratedGraphics', u'biosVfIntegratedGraphicsApertureSize', u'biosVfIntelEntrySASRAIDModule', u'biosVfIntelHyperThreadingTech', u'biosVfIntelTrustedExecutionTechnology', u'biosVfIntelTurboBoostTech', u'biosVfIntelVTForDirectedIO', u'biosVfIntelVirtualizationTechnology', u'biosVfInterleaveConfiguration', u'biosVfLocalX2Apic', u'biosVfLvDIMMSupport', u'biosVfMaxVariableMTRRSetting', u'biosVfMaximumMemoryBelow4GB', u'biosVfMemoryMappedIOAbove4GB', u'biosVfMirroringMode', u'biosVfNUMAOptimized', u'biosVfOSBootWatchdogTimer', u'biosVfOSBootWatchdogTimerPolicy', u'biosVfOSBootWatchdogTimerTimeout', u'biosVfOnboardGraphics', u'biosVfOnboardSATAController', u'biosVfOnboardStorage', u'biosVfOptionROMEnable', u'biosVfOptionROMLoad', u'biosVfOutOfBandManagement', u'biosVfPCHSATAMode', u'biosVfPCILOMPortsConfiguration', u'biosVfPCIROMCLP', u'biosVfPCISlotLinkSpeed', u'biosVfPCISlotOptionROMEnable', u'biosVfPOSTErrorPause', u'biosVfPSTATECoordination', u'biosVfPackageCStateLimit', u'biosVfProcessorC1E', u'biosVfProcessorC3Report', u'biosVfProcessorC6Report', u'biosVfProcessorC7Report', u'biosVfProcessorCMCI', u'biosVfProcessorCState', u'biosVfProcessorEnergyConfiguration', u'biosVfProcessorPrefetchConfig', u'biosVfQPILinkFrequencySelect', u'biosVfQPISnoopMode', u'biosVfQuietBoot', u'biosVfRedirectionAfterBIOSPOST', u'biosVfResumeOnACPowerLoss', u'biosVfSBMezz1OptionROM', u'biosVfSBNVMe1OptionROM', u'biosVfSIOC1OptionROM', u'biosVfSIOC2OptionROM', u'biosVfScrubPolicies', u'biosVfSelectMemoryRASConfiguration', u'biosVfSerialPortAEnable', u'biosVfSparingMode', u'biosVfSriovConfig', u'biosVfTPMPendingOperation', u'biosVfTPMSupport', u'biosVfTrustedPlatformModule', u'biosVfUCSMBootModeControl', u'biosVfUCSMBootOrderRuleControl', u'biosVfUEFIOSUseLegacyVideo', u'biosVfUSBBootConfig', u'biosVfUSBConfiguration', u'biosVfUSBFrontPanelAccessLock', u'biosVfUSBPortConfiguration', u'biosVfUSBSystemIdlePowerOptimizingSetting', u'biosVfVGAPriority', u'biosVfWorkloadConfiguration'], ["Add", "Get", "Remove", "Set"]),
    "BiosVfACPI10Support": MoMeta("BiosVfACPI10Support", "biosVfACPI10Support", "ACPI10-Support", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfASPMSupport": MoMeta("BiosVfASPMSupport", "biosVfASPMSupport", "ASPM-Support", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfAllUSBDevices": MoMeta("BiosVfAllUSBDevices", "biosVfAllUSBDevices", "All-USB-Devices", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfAltitude": MoMeta("BiosVfAltitude", "biosVfAltitude", "Altitude", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfAssertNMIOnPERR": MoMeta("BiosVfAssertNMIOnPERR", "biosVfAssertNMIOnPERR", "Assert-NMI-on-PERR", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfAssertNMIOnSERR": MoMeta("BiosVfAssertNMIOnSERR", "biosVfAssertNMIOnSERR", "Assert-NMI-on-SERR", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfBootOptionRetry": MoMeta("BiosVfBootOptionRetry", "biosVfBootOptionRetry", "Boot-option-retry", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfCPUHardwarePowerManagement": MoMeta("BiosVfCPUHardwarePowerManagement", "biosVfCPUHardwarePowerManagement", "CPU-Hardware-Power-Management", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfCPUPerformance": MoMeta("BiosVfCPUPerformance", "biosVfCPUPerformance", "CPU-Performance", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfCPUPowerManagement": MoMeta("BiosVfCPUPowerManagement", "biosVfCPUPowerManagement", "CPU-Power-Management", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfConsistentDeviceNameControl": MoMeta("BiosVfConsistentDeviceNameControl", "biosVfConsistentDeviceNameControl", "Consistent-Device-Name-Control", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfConsoleRedirection": MoMeta("BiosVfConsoleRedirection", "biosVfConsoleRedirection", "Console-redirection", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfCoreMultiProcessing": MoMeta("BiosVfCoreMultiProcessing", "biosVfCoreMultiProcessing", "Core-MultiProcessing", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfDDR3VoltageSelection": MoMeta("BiosVfDDR3VoltageSelection", "biosVfDDR3VoltageSelection", "DDR3-Voltage-Selection", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfDRAMClockThrottling": MoMeta("BiosVfDRAMClockThrottling", "biosVfDRAMClockThrottling", "DRAM-Clock-Throttling", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfDirectCacheAccess": MoMeta("BiosVfDirectCacheAccess", "biosVfDirectCacheAccess", "Direct-Cache-Access", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfDramRefreshRate": MoMeta("BiosVfDramRefreshRate", "biosVfDramRefreshRate", "Dram-Refresh-Rate", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfEnergyPerformanceTuning": MoMeta("BiosVfEnergyPerformanceTuning", "biosVfEnergyPerformanceTuning", "Energy-Performance-Tuning", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfEnhancedIntelSpeedStepTech": MoMeta("BiosVfEnhancedIntelSpeedStepTech", "biosVfEnhancedIntelSpeedStepTech", "Enhanced-Intel-SpeedStep-Tech", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfEnhancedPowerCappingSupport": MoMeta("BiosVfEnhancedPowerCappingSupport", "biosVfEnhancedPowerCappingSupport", "Enhanced-PowerCapping-Support", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfExecuteDisableBit": MoMeta("BiosVfExecuteDisableBit", "biosVfExecuteDisableBit", "Execute-Disable-Bit", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfFRB2Timer": MoMeta("BiosVfFRB2Timer", "biosVfFRB2Timer", "FRB-2-Timer", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfFrequencyFloorOverride": MoMeta("BiosVfFrequencyFloorOverride", "biosVfFrequencyFloorOverride", "Frequency-Floor-Override", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfFrontPanelLockout": MoMeta("BiosVfFrontPanelLockout", "biosVfFrontPanelLockout", "Front-panel-lockout", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIOEMezz1OptionROM": MoMeta("BiosVfIOEMezz1OptionROM", "biosVfIOEMezz1OptionROM", "IOEMezz1-OptionROM", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfIOENVMe1OptionROM": MoMeta("BiosVfIOENVMe1OptionROM", "biosVfIOENVMe1OptionROM", "IOENVMe1-OptionROM", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfIOENVMe2OptionROM": MoMeta("BiosVfIOENVMe2OptionROM", "biosVfIOENVMe2OptionROM", "IOENVMe2-OptionROM", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfIOESlot1OptionROM": MoMeta("BiosVfIOESlot1OptionROM", "biosVfIOESlot1OptionROM", "IOESlot1-OptionROM", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfIOESlot2OptionROM": MoMeta("BiosVfIOESlot2OptionROM", "biosVfIOESlot2OptionROM", "IOESlot2-OptionROM", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfIntegratedGraphics": MoMeta("BiosVfIntegratedGraphics", "biosVfIntegratedGraphics", "Integrated-Graphics", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfIntegratedGraphicsApertureSize": MoMeta("BiosVfIntegratedGraphicsApertureSize", "biosVfIntegratedGraphicsApertureSize", "Integrated-Graphics-Aperture-Size", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfIntelEntrySASRAIDModule": MoMeta("BiosVfIntelEntrySASRAIDModule", "biosVfIntelEntrySASRAIDModule", "Intel-entry-SAS-RAID-module", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelHyperThreadingTech": MoMeta("BiosVfIntelHyperThreadingTech", "biosVfIntelHyperThreadingTech", "Intel-HyperThreading-Tech", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelTrustedExecutionTechnology": MoMeta("BiosVfIntelTrustedExecutionTechnology", "biosVfIntelTrustedExecutionTechnology", "Intel-Trusted-Execution-Technology", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelTurboBoostTech": MoMeta("BiosVfIntelTurboBoostTech", "biosVfIntelTurboBoostTech", "Intel-Turbo-Boost-Tech", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelVTForDirectedIO": MoMeta("BiosVfIntelVTForDirectedIO", "biosVfIntelVTForDirectedIO", "Intel-VT-for-directed-IO", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfIntelVirtualizationTechnology": MoMeta("BiosVfIntelVirtualizationTechnology", "biosVfIntelVirtualizationTechnology", "Intel-Virtualization-Technology", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfInterleaveConfiguration": MoMeta("BiosVfInterleaveConfiguration", "biosVfInterleaveConfiguration", "Interleave-Configuration", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfLocalX2Apic": MoMeta("BiosVfLocalX2Apic", "biosVfLocalX2Apic", "Local-X2-Apic", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfLvDIMMSupport": MoMeta("BiosVfLvDIMMSupport", "biosVfLvDIMMSupport", "LvDIMM-Support", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfMaxVariableMTRRSetting": MoMeta("BiosVfMaxVariableMTRRSetting", "biosVfMaxVariableMTRRSetting", "Max-Variable-MTRR-Setting", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfMaximumMemoryBelow4GB": MoMeta("BiosVfMaximumMemoryBelow4GB", "biosVfMaximumMemoryBelow4GB", "Maximum-memory-below-4GB", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfMemoryMappedIOAbove4GB": MoMeta("BiosVfMemoryMappedIOAbove4GB", "biosVfMemoryMappedIOAbove4GB", "Memory-mapped-IO-above-4GB", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfMirroringMode": MoMeta("BiosVfMirroringMode", "biosVfMirroringMode", "Mirroring-Mode", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfNUMAOptimized": MoMeta("BiosVfNUMAOptimized", "biosVfNUMAOptimized", "NUMA-optimized", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOSBootWatchdogTimer": MoMeta("BiosVfOSBootWatchdogTimer", "biosVfOSBootWatchdogTimer", "OS-Boot-Watchdog-Timer", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOSBootWatchdogTimerPolicy": MoMeta("BiosVfOSBootWatchdogTimerPolicy", "biosVfOSBootWatchdogTimerPolicy", "OS-Boot-Watchdog-Timer-Policy", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOSBootWatchdogTimerTimeout": MoMeta("BiosVfOSBootWatchdogTimerTimeout", "biosVfOSBootWatchdogTimerTimeout", "OS-Boot-Watchdog-Timer-Timeout", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOnboardGraphics": MoMeta("BiosVfOnboardGraphics", "biosVfOnboardGraphics", "Onboard-Graphics", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfOnboardSATAController": MoMeta("BiosVfOnboardSATAController", "biosVfOnboardSATAController", "Onboard-SATA-controller", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOnboardStorage": MoMeta("BiosVfOnboardStorage", "biosVfOnboardStorage", "Onboard-Storage", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOptionROMEnable": MoMeta("BiosVfOptionROMEnable", "biosVfOptionROMEnable", "OptionROM-Enable", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOptionROMLoad": MoMeta("BiosVfOptionROMLoad", "biosVfOptionROMLoad", "OptionROM-load", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfOutOfBandManagement": MoMeta("BiosVfOutOfBandManagement", "biosVfOutOfBandManagement", "Out-of-Band-Management", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfPCHSATAMode": MoMeta("BiosVfPCHSATAMode", "biosVfPCHSATAMode", "PCH-SATA-Mode", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfPCILOMPortsConfiguration": MoMeta("BiosVfPCILOMPortsConfiguration", "biosVfPCILOMPortsConfiguration", "PCI-LOM-Ports-Configuration", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPCIROMCLP": MoMeta("BiosVfPCIROMCLP", "biosVfPCIROMCLP", "PCI-ROM-CLP", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfPCISlotLinkSpeed": MoMeta("BiosVfPCISlotLinkSpeed", "biosVfPCISlotLinkSpeed", "PCI-Slot-Link-Speed", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPCISlotOptionROMEnable": MoMeta("BiosVfPCISlotOptionROMEnable", "biosVfPCISlotOptionROMEnable", "PCI-Slot-OptionROM-Enable", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPOSTErrorPause": MoMeta("BiosVfPOSTErrorPause", "biosVfPOSTErrorPause", "POST-error-pause", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPSTATECoordination": MoMeta("BiosVfPSTATECoordination", "biosVfPSTATECoordination", "P-STATE-Coordination", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfPackageCStateLimit": MoMeta("BiosVfPackageCStateLimit", "biosVfPackageCStateLimit", "Package-C-State-Limit", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorC1E": MoMeta("BiosVfProcessorC1E", "biosVfProcessorC1E", "Processor-C1E", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorC3Report": MoMeta("BiosVfProcessorC3Report", "biosVfProcessorC3Report", "Processor-C3-Report", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorC6Report": MoMeta("BiosVfProcessorC6Report", "biosVfProcessorC6Report", "Processor-C6-Report", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorC7Report": MoMeta("BiosVfProcessorC7Report", "biosVfProcessorC7Report", "Processor-C7-Report", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorCMCI": MoMeta("BiosVfProcessorCMCI", "biosVfProcessorCMCI", "Processor-CMCI", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfProcessorCState": MoMeta("BiosVfProcessorCState", "biosVfProcessorCState", "Processor-C-State", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorEnergyConfiguration": MoMeta("BiosVfProcessorEnergyConfiguration", "biosVfProcessorEnergyConfiguration", "Processor-Energy-Configuration", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfProcessorPrefetchConfig": MoMeta("BiosVfProcessorPrefetchConfig", "biosVfProcessorPrefetchConfig", "Processor-Prefetch-Config", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfQPILinkFrequencySelect": MoMeta("BiosVfQPILinkFrequencySelect", "biosVfQPILinkFrequencySelect", "QPI-Link-Frequency-Select", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfQPISnoopMode": MoMeta("BiosVfQPISnoopMode", "biosVfQPISnoopMode", "QPI-Snoop-Mode", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfQuietBoot": MoMeta("BiosVfQuietBoot", "biosVfQuietBoot", "Quiet-Boot", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfRedirectionAfterBIOSPOST": MoMeta("BiosVfRedirectionAfterBIOSPOST", "biosVfRedirectionAfterBIOSPOST", "Redirection-After-BIOS-POST", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfResumeOnACPowerLoss": MoMeta("BiosVfResumeOnACPowerLoss", "biosVfResumeOnACPowerLoss", "Resume-on-AC-power-loss", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSBMezz1OptionROM": MoMeta("BiosVfSBMezz1OptionROM", "biosVfSBMezz1OptionROM", "SBMezz1-OptionROM", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfSBNVMe1OptionROM": MoMeta("BiosVfSBNVMe1OptionROM", "biosVfSBNVMe1OptionROM", "SBNVMe1-OptionROM", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfSIOC1OptionROM": MoMeta("BiosVfSIOC1OptionROM", "biosVfSIOC1OptionROM", "SIOC1-OptionROM", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfSIOC2OptionROM": MoMeta("BiosVfSIOC2OptionROM", "biosVfSIOC2OptionROM", "SIOC2-OptionROM", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfScrubPolicies": MoMeta("BiosVfScrubPolicies", "biosVfScrubPolicies", "Scrub-Policies", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSelectMemoryRASConfiguration": MoMeta("BiosVfSelectMemoryRASConfiguration", "biosVfSelectMemoryRASConfiguration", "SelectMemory-RAS-configuration", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSerialPortAEnable": MoMeta("BiosVfSerialPortAEnable", "biosVfSerialPortAEnable", "Serial-port-A-enable", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSparingMode": MoMeta("BiosVfSparingMode", "biosVfSparingMode", "Sparing-Mode", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfSriovConfig": MoMeta("BiosVfSriovConfig", "biosVfSriovConfig", "Sriov-Config", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfTPMPendingOperation": MoMeta("BiosVfTPMPendingOperation", "biosVfTPMPendingOperation", "TPM-Pending-Operation", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfTPMSupport": MoMeta("BiosVfTPMSupport", "biosVfTPMSupport", "TPM-Support", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "BiosVfTrustedPlatformModule": MoMeta("BiosVfTrustedPlatformModule", "biosVfTrustedPlatformModule", "Trusted-Platform-Module", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUCSMBootModeControl": MoMeta("BiosVfUCSMBootModeControl", "biosVfUCSMBootModeControl", "UCSM-Boot-Mode-Control", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUCSMBootOrderRuleControl": MoMeta("BiosVfUCSMBootOrderRuleControl", "biosVfUCSMBootOrderRuleControl", "UCSM-Boot-Order-Rule-Control", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUEFIOSUseLegacyVideo": MoMeta("BiosVfUEFIOSUseLegacyVideo", "biosVfUEFIOSUseLegacyVideo", "UEFI-OS-use-legacy-video", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUSBBootConfig": MoMeta("BiosVfUSBBootConfig", "biosVfUSBBootConfig", "USB-Boot-Config", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUSBConfiguration": MoMeta("BiosVfUSBConfiguration", "biosVfUSBConfiguration", "USB-Configuration", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUSBFrontPanelAccessLock": MoMeta("BiosVfUSBFrontPanelAccessLock", "biosVfUSBFrontPanelAccessLock", "USB-Front-Panel-Access-Lock", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUSBPortConfiguration": MoMeta("BiosVfUSBPortConfiguration", "biosVfUSBPortConfiguration", "USB-port-configuration", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfUSBSystemIdlePowerOptimizingSetting": MoMeta("BiosVfUSBSystemIdlePowerOptimizingSetting", "biosVfUSBSystemIdlePowerOptimizingSetting", "USB-System-Idle-Power-Optimizing-Setting", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfVGAPriority": MoMeta("BiosVfVGAPriority", "biosVfVGAPriority", "VGA-Priority", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], ["Get", "Set"]),
    "BiosVfWorkloadConfiguration": MoMeta("BiosVfWorkloadConfiguration", "biosVfWorkloadConfiguration", "Workload-Configuration", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'biosVProfile'], [], [None]),
    "CallhomeDest": MoMeta("CallhomeDest", "callhomeDest", "email-[email]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'callhomeProfile'], [], ["Add", "Get", "Remove"]),
    "CallhomeEp": MoMeta("CallhomeEp", "callhomeEp", "call-home", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'callhomeHolder', u'orgDomainGroup', u'orgOrg', u'policyDeviceProfile', u'smartlicenseHolder'], [u'callhomeFaultInst', u'callhomeHttp', u'callhomePeriodicSystemInventory', u'callhomePolicy', u'callhomeProfile', u'callhomeSmtp', u'callhomeSource', u'callhomeTestAlert', u'smartcallhomeHttpProxy', u'smartcallhomePeriodicSystemInventory', u'smartcallhomePolicy', u'smartcallhomeProfile', u'smartcallhomeSource', u'smartcallhomeTransportGateway'], ["Add", "Get", "Remove", "Set"]),
    "CallhomeFaultInst": MoMeta("CallhomeFaultInst", "callhomeFaultInst", "call-home-fault", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "fault", "operations"], [u'callhomeEp'], [], ["Get"]),
    "CallhomeHolder": MoMeta("CallhomeHolder", "callhomeHolder", "smartcallhome", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'callhomeEp', u'callhomeHolderFsm', u'callhomeHolderFsmTask', u'eventInst', u'faultInst', u'smartcallhomePeriodicInventoryStatus'], ["Get"]),
    "CallhomeHolderFsm": MoMeta("CallhomeHolderFsm", "callhomeHolderFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'callhomeHolder'], [u'callhomeHolderFsmStage'], ["Get"]),
    "CallhomeHolderFsmStage": MoMeta("CallhomeHolderFsmStage", "callhomeHolderFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'callhomeHolderFsm'], [], ["Get"]),
    "CallhomeHolderFsmTask": MoMeta("CallhomeHolderFsmTask", "callhomeHolderFsmTask", "task-[item]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'callhomeHolder'], [], ["Get"]),
    "CallhomeHttp": MoMeta("CallhomeHttp", "callhomeHttp", "http", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "operations"], [u'callhomeEp'], [], ["Get", "Set"]),
    "CallhomePeriodicSystemInventory": MoMeta("CallhomePeriodicSystemInventory", "callhomePeriodicSystemInventory", "periodicsysteminventory", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'callhomeEp'], [], ["Add", "Get", "Remove", "Set"]),
    "CallhomePolicy": MoMeta("CallhomePolicy", "callhomePolicy", "policy-[cause]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "fault"], [u'callhomeEp'], [], ["Add", "Get", "Remove", "Set"]),
    "CallhomeProfile": MoMeta("CallhomeProfile", "callhomeProfile", "profile-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'callhomeEp'], [u'callhomeDest'], ["Add", "Get", "Remove", "Set"]),
    "CallhomeSmtp": MoMeta("CallhomeSmtp", "callhomeSmtp", "smtp", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'callhomeEp'], [], ["Add", "Get", "Remove", "Set"]),
    "CallhomeSource": MoMeta("CallhomeSource", "callhomeSource", "source", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'callhomeEp'], [], ["Add", "Get", "Remove", "Set"]),
    "CallhomeTestAlert": MoMeta("CallhomeTestAlert", "callhomeTestAlert", "testalert", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'callhomeEp'], [], ["Add", "Get", "Remove", "Set"]),
    "CapabilityCatalogue": MoMeta("CapabilityCatalogue", "capabilityCatalogue", "capabilities", VersionMeta.Version101a, "InputOutput", 0x1, [], [""], [u'topRoot'], [u'adaptorFruCapProvider', u'diagSrvCapProvider', u'domainFamilyCapProvider', u'equipmentBladeCapProvider', u'equipmentChassisCapProvider', u'equipmentFanModuleCapProvider', u'equipmentFexCapProvider', u'equipmentGemCapProvider', u'equipmentHostIfCapProvider', u'equipmentIOCardCapProvider', u'equipmentLocalDiskCapProvider', u'equipmentLocalDiskControllerCapProvider', u'equipmentMemoryUnitCapProvider', u'equipmentProcessorUnitCapProvider', u'equipmentPsuCapProvider', u'equipmentRackUnitCapProvider', u'equipmentServerUnitCapProvider', u'equipmentSwitchCapProvider', u'equipmentSwitchIOCardCapProvider', u'equipmentSystemFruCapProvider', u'firmwareBundleTypeCapProvider', u'firmwareType', u'licenseFeatureCapProvider'], ["Get"]),
    "CertRepairEp": MoMeta("CertRepairEp", "certRepairEp", "cert-repair", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'certRepairEpFsm', u'certRepairEpFsmTask', u'eventInst', u'faultInst'], [None]),
    "CertRepairEpFsm": MoMeta("CertRepairEpFsm", "certRepairEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'certRepairEp'], [u'certRepairEpFsmStage'], [None]),
    "CertRepairEpFsmStage": MoMeta("CertRepairEpFsmStage", "certRepairEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'certRepairEpFsm'], [], [None]),
    "CertRepairEpFsmTask": MoMeta("CertRepairEpFsmTask", "certRepairEpFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'certRepairEp'], [], [None]),
    "ChangeChangedObjectRef": MoMeta("ChangeChangedObjectRef", "changeChangedObjectRef", "ChangedObjectRef[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'changeEp'], [], [None]),
    "ChangeEp": MoMeta("ChangeEp", "changeEp", "syncEp", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'extpolDomain'], [u'changeChangedObjectRef', u'changeEpFsm', u'changeEpFsmTask', u'eventInst', u'faultInst'], [None]),
    "ChangeEpFsm": MoMeta("ChangeEpFsm", "changeEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'changeEp'], [u'changeEpFsmStage'], [None]),
    "ChangeEpFsmStage": MoMeta("ChangeEpFsmStage", "changeEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'changeEpFsm'], [], [None]),
    "ChangeEpFsmTask": MoMeta("ChangeEpFsmTask", "changeEpFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], [u'changeEp'], [], [None]),
    "CimcvmediaActualMountEntry": MoMeta("CimcvmediaActualMountEntry", "cimcvmediaActualMountEntry", "actual-mount-entry-[virtual_disk_id]", VersionMeta.Version121e, "InputOutput", 0x1, [], ["read-only"], [u'cimcvmediaActualMountList'], [], ["Get"]),
    "CimcvmediaActualMountList": MoMeta("CimcvmediaActualMountList", "cimcvmediaActualMountList", "actual-mount-list", VersionMeta.Version121e, "InputOutput", 0x1, [], ["read-only"], [u'mgmtController'], [u'cimcvmediaActualMountEntry', u'cimcvmediaExtMgmtRuleEntry'], ["Get"]),
    "CimcvmediaConfigMountEntry": MoMeta("CimcvmediaConfigMountEntry", "cimcvmediaConfigMountEntry", "cfg-mnt-entry-[mapping_name]", VersionMeta.Version121e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'cimcvmediaMountConfigDef', u'cimcvmediaMountConfigPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "CimcvmediaExtMgmtRuleEntry": MoMeta("CimcvmediaExtMgmtRuleEntry", "cimcvmediaExtMgmtRuleEntry", "ext-mgmt-rule-[mapping_name]", VersionMeta.Version121e, "InputOutput", 0x1, [], ["read-only"], [u'cimcvmediaActualMountList'], [], ["Get"]),
    "CimcvmediaMountConfigDef": MoMeta("CimcvmediaMountConfigDef", "cimcvmediaMountConfigDef", "mnt-cfg-def", VersionMeta.Version121e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsServer'], [u'cimcvmediaConfigMountEntry'], ["Add", "Get", "Remove", "Set"]),
    "CimcvmediaMountConfigPolicy": MoMeta("CimcvmediaMountConfigPolicy", "cimcvmediaMountConfigPolicy", "mnt-cfg-policy-[name]", VersionMeta.Version121e, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'orgOrg'], [u'cimcvmediaConfigMountEntry'], ["Add", "Get", "Remove", "Set"]),
    "ClitestTypeTest": MoMeta("ClitestTypeTest", "clitestTypeTest", "tt-", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [], ["Get"]),
    "ClitestTypeTest2": MoMeta("ClitestTypeTest2", "clitestTypeTest2", "tt2-", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [], ["Get"]),
    "ClitestTypeTestChild": MoMeta("ClitestTypeTestChild", "clitestTypeTestChild", "tt-child", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [], [], ["Get"]),
    "CommCimxml": MoMeta("CommCimxml", "commCimxml", "cimxml-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'orgDomainGroup', u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "CommCoreFile": MoMeta("CommCoreFile", "commCoreFile", "core-file-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'orgDomainGroup', u'orgOrg', u'policyDeviceProfile'], [], [None]),
    "CommDateTime": MoMeta("CommDateTime", "commDateTime", "datetime-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-security", "operations"], [u'commLocale', u'commSvcEp', u'commSvcPolicy', u'orgDomainGroup', u'orgOrg', u'policyDeviceProfile'], [u'commDateTimeFsm', u'commDateTimeFsmTask', u'commNtpProvider', u'eventInst', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "CommDateTimeFsm": MoMeta("CommDateTimeFsm", "commDateTimeFsm", "fsm", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], [u'commDateTime'], [u'commDateTimeFsmStage'], [None]),
    "CommDateTimeFsmStage": MoMeta("CommDateTimeFsmStage", "commDateTimeFsmStage", "stage-[name]", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], [u'commDateTimeFsm'], [], [None]),
    "CommDateTimeFsmTask": MoMeta("CommDateTimeFsmTask", "commDateTimeFsmTask", "task-[item]", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], [u'commDateTime'], [], [None]),
    "CommDns": MoMeta("CommDns", "commDns", "dns-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "ext-lan-config"], [u'commLocale', u'commSvcPolicy', u'orgDomainGroup', u'orgOrg', u'policyDeviceProfile'], [u'commDnsProvider'], ["Add", "Get", "Remove", "Set"]),
    "CommDnsProvider": MoMeta("CommDnsProvider", "commDnsProvider", "dns-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "ext-lan-config"], [u'commDns'], [], ["Add", "Get", "Remove"]),
    "CommEvtChannel": MoMeta("CommEvtChannel", "commEvtChannel", "svc-evt-channel", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'orgDomainGroup', u'orgOrg'], [], ["Get"]),
    "CommHttp": MoMeta("CommHttp", "commHttp", "http-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'orgDomainGroup', u'orgOrg', u'policyDeviceProfile'], [], ["Add", "Get", "Remove", "Set"]),
    "CommHttps": MoMeta("CommHttps", "commHttps", "https-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'commSvcEp', u'orgDomainGroup', u'orgOrg', u'policyDeviceProfile'], [], ["Get", "Set"]),
    "CommLocale": MoMeta("CommLocale", "commLocale", "locale-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageProcessor'], [u'commDateTime', u'commDns', u'commSyslog'], [None]),
    "CommLogComponent": MoMeta("CommLogComponent", "commLogComponent", "log-comp-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'commSyslog'], [], [None]),
    "CommNtp": MoMeta("CommNtp", "commNtp", "ntp-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-security", "operations"], [], [], [None]),
    "CommNtpProvider": MoMeta("CommNtpProvider", "commNtpProvider", "ntp-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-security", "operations"], [u'commDateTime'], [], ["Add", "Get", "Remove"]),
    "CommShellSvcLimits": MoMeta("CommShellSvcLimits", "commShellSvcLimits", "shell-svc-limits", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'orgDomainGroup', u'orgOrg', u'policyDeviceProfile'], [], ["Get"]),
    "CommSmashCLP": MoMeta("CommSmashCLP", "commSmashCLP", "smashclp-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'orgDomainGroup', u'orgOrg'], [], ["Get"]),
    "CommSnmp": MoMeta("CommSnmp", "commSnmp", "snmp-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'orgDomainGroup', u'orgOrg', u'policyDeviceProfile'], [u'commSnmpCommunity', u'commSnmpTrap', u'commSnmpTrapData', u'commSnmpUser'], ["Add", "Get", "Remove", "Set"]),
    "CommSnmpCommunity": MoMeta("CommSnmpCommunity", "commSnmpCommunity", "snmp-community-[community]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'commSnmp'], [], [None]),
    "CommSnmpTrap": MoMeta("CommSnmpTrap", "commSnmpTrap", "snmp-trap[hostname]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'commSnmp'], [], ["Add", "Get", "Remove", "Set"]),
    "CommSnmpTrapData": MoMeta("CommSnmpTrapData", "commSnmpTrapData", "snmp-trap-data[prop_oid]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'commSnmp'], [], [None]),
    "CommSnmpUser": MoMeta("CommSnmpUser", "commSnmpUser", "snmpv3-user-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'commSnmp'], [], ["Add", "Get", "Remove", "Set"]),
    "CommSsh": MoMeta("CommSsh", "commSsh", "ssh-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'orgDomainGroup', u'orgOrg', u'policyDeviceProfile'], [], ["Get"]),
    "CommSvcEp": MoMeta("CommSvcEp", "commSvcEp", "svc-ext", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'computeSystem', u'topSystem'], [u'commDateTime', u'commHttps', u'commSvcEpFsm', u'commSvcEpFsmTask', u'eventInst', u'faultInst'], ["Get"]),
    "CommSvcEpFsm": MoMeta("CommSvcEpFsm", "commSvcEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'commSvcEp'], [u'commSvcEpFsmStage'], [None]),
    "CommSvcEpFsmStage": MoMeta("CommSvcEpFsmStage", "commSvcEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'commSvcEpFsm'], [], [None]),
    "CommSvcEpFsmTask": MoMeta("CommSvcEpFsmTask", "commSvcEpFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'commSvcEp'], [], [None]),
    "CommSvcPolicy": MoMeta("CommSvcPolicy", "commSvcPolicy", "comm-pol-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'commDateTime', u'commDns', u'commSyslog'], [None]),
    "CommSyslog": MoMeta("CommSyslog", "commSyslog", "syslog", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'commLocale', u'commSvcPolicy', u'orgDomainGroup', u'orgOrg', u'policyDeviceProfile'], [u'commLogComponent', u'commSyslogClient', u'commSyslogConsole', u'commSyslogFile', u'commSyslogMonitor', u'commSyslogSource'], ["Add", "Get", "Remove", "Set"]),
    "CommSyslogClient": MoMeta("CommSyslogClient", "commSyslogClient", "client-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'commSyslog'], [], ["Add", "Get", "Set"]),
    "CommSyslogConsole": MoMeta("CommSyslogConsole", "commSyslogConsole", "console", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'commSyslog'], [], ["Add", "Get", "Set"]),
    "CommSyslogFile": MoMeta("CommSyslogFile", "commSyslogFile", "file", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'commSyslog'], [], ["Add", "Get", "Set"]),
    "CommSyslogMonitor": MoMeta("CommSyslogMonitor", "commSyslogMonitor", "monitor", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'commSyslog'], [], ["Add", "Get", "Set"]),
    "CommSyslogSource": MoMeta("CommSyslogSource", "commSyslogSource", "source", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "operations"], [u'commSyslog'], [], ["Add", "Get", "Set"]),
    "CommTelnet": MoMeta("CommTelnet", "commTelnet", "telnet-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'orgDomainGroup', u'orgOrg', u'policyDeviceProfile'], [], ["Add", "Get", "Remove", "Set"]),
    "CommWebChannel": MoMeta("CommWebChannel", "commWebChannel", "svc-web-channel", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'orgDomainGroup', u'orgOrg'], [], ["Get"]),
    "CommWebSvcLimits": MoMeta("CommWebSvcLimits", "commWebSvcLimits", "web-svc-limits", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'orgDomainGroup', u'orgOrg', u'policyDeviceProfile'], [], ["Add", "Get", "Remove", "Set"]),
    "CommWsman": MoMeta("CommWsman", "commWsman", "wsman-svc", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'orgDomainGroup', u'orgOrg'], [], ["Get"]),
    "CommXmlClConnPolicy": MoMeta("CommXmlClConnPolicy", "commXmlClConnPolicy", "xmlclconnpolicy-[client_type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management"], [u'orgDomainGroup'], [], ["Get"]),
    "ComputeAutoconfigPolicy": MoMeta("ComputeAutoconfigPolicy", "computeAutoconfigPolicy", "autoconfig-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgDomainGroup', u'orgOrg'], [u'faultInst'], ["Get", "Set"]),
    "ComputeBlade": MoMeta("ComputeBlade", "computeBlade", "blade-[slot_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassis'], [u'adaptorHostIfConfig', u'adaptorUnit', u'biosUnit', u'computeBoard', u'computeBoardConnector', u'computeBoardController', u'computeExtBoard', u'computeFactoryResetOp', u'computeFactoryResetOperation', u'computePhysicalExtension', u'computePhysicalOperation', u'computePoolable', u'computeRebootLog', u'diagSrvCtrl', u'equipmentBeaconLed', u'equipmentHealthLed', u'equipmentIndicatorLed', u'equipmentLocatorLed', u'faultInst', u'firmwareStatus', u'lsIdentityInfo', u'lsbootDef', u'memoryRuntime', u'mgmtController', u'mgmtSecurity', u'osInstance', u'processorRuntime', u'storageEnclosure', u'storageVirtualDriveContainer', u'sysdebugDiagnosticLog'], ["Get"]),
    "ComputeBladeDiscPolicy": MoMeta("ComputeBladeDiscPolicy", "computeBladeDiscPolicy", "blade-discovery[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-policy", "read-only"], [u'orgDomainGroup', u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputeBladeEp": MoMeta("ComputeBladeEp", "computeBladeEp", "blade-ep-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageBlade'], [], ["Get"]),
    "ComputeBladeInheritPolicy": MoMeta("ComputeBladeInheritPolicy", "computeBladeInheritPolicy", "blade-inherit-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgDomainGroup', u'orgOrg'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "ComputeBoard": MoMeta("ComputeBoard", "computeBoard", "board", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [u'computeIOHub', u'computeMbPowerStats', u'computeMbTempStats', u'computePCIeFatalCompletionStats', u'computePCIeFatalProtocolStats', u'computePCIeFatalReceiveStats', u'computePCIeFatalStats', u'computeRackUnitMbTempStats', u'faultInst', u'graphicsCard', u'lstorageLocal', u'lstorageLocalDef', u'lstorageRemote', u'lstorageRemoteDef', u'memoryArray', u'memoryBufferUnit', u'processorUnit', u'securityUnit', u'storageController', u'storageFlexFlashController', u'storageSasExpander'], ["Get"]),
    "ComputeBoardConnector": MoMeta("ComputeBoardConnector", "computeBoardConnector", "board-conn", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade'], [], ["Get"]),
    "ComputeBoardController": MoMeta("ComputeBoardController", "computeBoardController", "boardController", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeExtBoard', u'computeRackUnit', u'computeServerUnit', u'equipmentChassis', u'equipmentSystemIOController'], [u'mgmtController'], ["Get"]),
    "ComputeCartridge": MoMeta("ComputeCartridge", "computeCartridge", "cartridge-[slot_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassis'], [u'computeCartridgeOperation', u'computeServerUnit'], ["Get", "Set"]),
    "ComputeCartridgeOperation": MoMeta("ComputeCartridgeOperation", "computeCartridgeOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'computeCartridge'], [u'faultInst'], ["Get", "Set"]),
    "ComputeChassisConnPolicy": MoMeta("ComputeChassisConnPolicy", "computeChassisConnPolicy", "chassis-conn-policy-chassis-[chassis_id]-fabric-[switch_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-policy"], [u'computeSystem', u'orgDomainGroup', u'orgOrg'], [u'computeChassisConnPolicyOperation'], ["Get", "Set"]),
    "ComputeChassisConnPolicyOperation": MoMeta("ComputeChassisConnPolicyOperation", "computeChassisConnPolicyOperation", "remote-oper", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'computeChassisConnPolicy'], [u'faultInst'], ["Get", "Set"]),
    "ComputeChassisDiscPolicy": MoMeta("ComputeChassisDiscPolicy", "computeChassisDiscPolicy", "chassis-discovery", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-policy"], [u'orgDomainGroup', u'orgOrg'], [], ["Get", "Set"]),
    "ComputeChassisFeatMask": MoMeta("ComputeChassisFeatMask", "computeChassisFeatMask", "chassis-feat-mask", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'computeSystem', u'equipmentChassis', u'equipmentChassisProfile', u'extpolDomain'], [], ["get"]),
    "ComputeChassisQual": MoMeta("ComputeChassisQual", "computeChassisQual", "chassis-from-[min_id]-to-[max_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], [u'computeDomainQual'], [u'computeSlotQual'], ["Add", "Get", "Remove", "Set"]),
    "ComputeDomainGroupQual": MoMeta("ComputeDomainGroupQual", "computeDomainGroupQual", "domaingroup-qualifier-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], [u'computeDomainQual'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputeDomainHwChangeDiscPolicy": MoMeta("ComputeDomainHwChangeDiscPolicy", "computeDomainHwChangeDiscPolicy", "hw-change-disc-policy-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-policy", "read-only"], [u'orgDomainGroup', u'orgOrg'], [], ["add", "get", "remove", "set"]),
    "ComputeDomainNameQual": MoMeta("ComputeDomainNameQual", "computeDomainNameQual", "domain-name-qualifier-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], [u'computeDomainQual'], [], ["Add", "Get", "Remove"]),
    "ComputeDomainPortDiscPolicy": MoMeta("ComputeDomainPortDiscPolicy", "computeDomainPortDiscPolicy", "port-discovery-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-policy"], [u'orgDomainGroup', u'orgOrg'], [], ["add", "get", "remove", "set"]),
    "ComputeDomainQual": MoMeta("ComputeDomainQual", "computeDomainQual", "Domain-qualifier-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], [u'computeQual'], [u'computeChassisQual', u'computeDomainGroupQual', u'computeDomainNameQual', u'computeOwnerQual', u'computeProductFamilyQual', u'computeRackQual', u'computeSiteQual', u'computeSystemAddrQual'], ["Add", "Get", "Remove"]),
    "ComputeEnvFeatMask": MoMeta("ComputeEnvFeatMask", "computeEnvFeatMask", "env-feat-mask", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [u'computeSystem', u'extpolDomain', u'lsServer'], [], ["Get"]),
    "ComputeExtBoard": MoMeta("ComputeExtBoard", "computeExtBoard", "ext-board-[id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [u'computeBoardController', u'equipmentHealthLed', u'equipmentLocatorLed', u'powerBudget'], ["Get"]),
    "ComputeFabricEthMonSrcEp": MoMeta("ComputeFabricEthMonSrcEp", "computeFabricEthMonSrcEp", "src-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'computeFabricEthMonSrcEpCont'], [], [None]),
    "ComputeFabricEthMonSrcEpCont": MoMeta("ComputeFabricEthMonSrcEpCont", "computeFabricEthMonSrcEpCont", "eth-mon", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "operations"], [u'computeSystem'], [u'computeFabricEthMonSrcEp'], [None]),
    "ComputeFabricFcMonSrcEp": MoMeta("ComputeFabricFcMonSrcEp", "computeFabricFcMonSrcEp", "src-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'computeFabricFcMonSrcEpCont'], [], [None]),
    "ComputeFabricFcMonSrcEpCont": MoMeta("ComputeFabricFcMonSrcEpCont", "computeFabricFcMonSrcEpCont", "fc-mon", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "operations"], [u'computeSystem'], [u'computeFabricFcMonSrcEp'], [None]),
    "ComputeFactoryResetOp": MoMeta("ComputeFactoryResetOp", "computeFactoryResetOp", "factory-reset-remote-oper", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [u'faultInst'], ["get", "set"]),
    "ComputeFactoryResetOperation": MoMeta("ComputeFactoryResetOperation", "computeFactoryResetOperation", "factory-reset", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [], ["Get", "Set"]),
    "ComputeFaultUpgradeFlag": MoMeta("ComputeFaultUpgradeFlag", "computeFaultUpgradeFlag", "fltUpgFlg", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'computeResourceAggrEp'], [], ["Get"]),
    "ComputeGraphicsCardPolicy": MoMeta("ComputeGraphicsCardPolicy", "computeGraphicsCardPolicy", "graphics-card-policy-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-policy", "pn-equipment", "pn-maintenance", "pn-policy"], [u'orgOrg'], [], ["add", "get", "remove", "set"]),
    "ComputeGroupMembership": MoMeta("ComputeGroupMembership", "computeGroupMembership", "membership-[ip]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management"], [u'computeResourceAggrEp'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "ComputeGroupMembershipRef": MoMeta("ComputeGroupMembershipRef", "computeGroupMembershipRef", "membershipref-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'orgDomainGroup'], [], ["get"]),
    "ComputeHwChangeDiscPolicy": MoMeta("ComputeHwChangeDiscPolicy", "computeHwChangeDiscPolicy", "hw-change-disc-policy", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-policy", "read-only"], [u'orgDomainGroup', u'orgOrg'], [], ["add", "get", "remove", "set"]),
    "ComputeIOHub": MoMeta("ComputeIOHub", "computeIOHub", "iohub", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'computeBoard'], [u'computeIOHubEnvStats', u'faultInst'], ["Get"]),
    "ComputeIOHubEnvStats": MoMeta("ComputeIOHubEnvStats", "computeIOHubEnvStats", "iohub-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'computeIOHub'], [u'computeIOHubEnvStatsHist'], [None]),
    "ComputeIOHubEnvStatsHist": MoMeta("ComputeIOHubEnvStatsHist", "computeIOHubEnvStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'computeIOHubEnvStats'], [], [None]),
    "ComputeInstance": MoMeta("ComputeInstance", "computeInstance", "inst-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], [u'computeRequirement'], [u'faultInst', u'lsFcLocale', u'lsIssues', u'lsPower', u'lsServerOperation', u'lsmaintAck', u'mgmtInterface', u'storageIpV4PooledAddr', u'storageIpV4StaticAddr', u'storageVirtualDriveRef', u'vnicEther', u'vnicFc', u'vnicIScsi', u'vnicIpV4MgmtPooledAddr', u'vnicIpV4PooledAddr', u'vnicIpV4StaticAddr'], ["Get"]),
    "ComputeInstanceIdQual": MoMeta("ComputeInstanceIdQual", "computeInstanceIdQual", "inst-from-[min_id]-to-[max_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], [u'computeSlotQual'], [], ["Add", "Get", "Remove"]),
    "ComputeInstanceMapping": MoMeta("ComputeInstanceMapping", "computeInstanceMapping", "instmap-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'computeSystem'], [], [None]),
    "ComputeLocalTemplDef": MoMeta("ComputeLocalTemplDef", "computeLocalTemplDef", "inst-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'computeTemplate'], [u'vnicEther', u'vnicFc', u'vnicIScsi'], ["Get"]),
    "ComputeMbPowerStats": MoMeta("ComputeMbPowerStats", "computeMbPowerStats", "power-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'computeBoard'], [u'computeMbPowerStatsHist'], [None]),
    "ComputeMbPowerStatsHist": MoMeta("ComputeMbPowerStatsHist", "computeMbPowerStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'computeMbPowerStats'], [], [None]),
    "ComputeMbTempStats": MoMeta("ComputeMbTempStats", "computeMbTempStats", "temp-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'computeBoard'], [u'computeMbTempStatsHist'], [None]),
    "ComputeMbTempStatsHist": MoMeta("ComputeMbTempStatsHist", "computeMbTempStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'computeMbTempStats'], [], [None]),
    "ComputeNetworkFeatMask": MoMeta("ComputeNetworkFeatMask", "computeNetworkFeatMask", "net-feat-mask", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [u'computeSystem', u'extpolDomain', u'lsServer'], [], ["Get"]),
    "ComputeOwnerQual": MoMeta("ComputeOwnerQual", "computeOwnerQual", "owner-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], [u'computeDomainQual', u'computeSystemQual'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputePCIeFatalCompletionStats": MoMeta("ComputePCIeFatalCompletionStats", "computePCIeFatalCompletionStats", "pciefat-completion-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'computeBoard'], [u'computePCIeFatalCompletionStatsHist'], [None]),
    "ComputePCIeFatalCompletionStatsHist": MoMeta("ComputePCIeFatalCompletionStatsHist", "computePCIeFatalCompletionStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'computePCIeFatalCompletionStats'], [], [None]),
    "ComputePCIeFatalProtocolStats": MoMeta("ComputePCIeFatalProtocolStats", "computePCIeFatalProtocolStats", "pciefat-protocol-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'computeBoard'], [u'computePCIeFatalProtocolStatsHist'], [None]),
    "ComputePCIeFatalProtocolStatsHist": MoMeta("ComputePCIeFatalProtocolStatsHist", "computePCIeFatalProtocolStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'computePCIeFatalProtocolStats'], [], [None]),
    "ComputePCIeFatalReceiveStats": MoMeta("ComputePCIeFatalReceiveStats", "computePCIeFatalReceiveStats", "pciefat-receive-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'computeBoard'], [u'computePCIeFatalReceiveStatsHist'], [None]),
    "ComputePCIeFatalReceiveStatsHist": MoMeta("ComputePCIeFatalReceiveStatsHist", "computePCIeFatalReceiveStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'computePCIeFatalReceiveStats'], [], [None]),
    "ComputePCIeFatalStats": MoMeta("ComputePCIeFatalStats", "computePCIeFatalStats", "pciefat-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'computeBoard'], [u'computePCIeFatalStatsHist'], [None]),
    "ComputePCIeFatalStatsHist": MoMeta("ComputePCIeFatalStatsHist", "computePCIeFatalStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'computePCIeFatalStats'], [], [None]),
    "ComputePhysicalAssocCtx": MoMeta("ComputePhysicalAssocCtx", "computePhysicalAssocCtx", "pn-assoc-ctx", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'lsServerAssocCtx'], [], ["Get"]),
    "ComputePhysicalExtension": MoMeta("ComputePhysicalExtension", "computePhysicalExtension", "phys-extension", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [], ["get"]),
    "ComputePhysicalOperation": MoMeta("ComputePhysicalOperation", "computePhysicalOperation", "remote-oper", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [u'faultInst'], ["Get", "Set"]),
    "ComputePhysicalQual": MoMeta("ComputePhysicalQual", "computePhysicalQual", "physical", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], [u'computeQual'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputePool": MoMeta("ComputePool", "computePool", "compute-pool-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgOrg'], [u'computePooledEnclosureComputeSlot', u'computePooledRackUnit', u'computePooledSlot', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "ComputePoolPolicyRef": MoMeta("ComputePoolPolicyRef", "computePoolPolicyRef", "poolref-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], [""], [u'computePoolable'], [], ["Get"]),
    "ComputePoolable": MoMeta("ComputePoolable", "computePoolable", "pool-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [u'computePoolPolicyRef'], ["Get"]),
    "ComputePooledEnclosureComputeSlot": MoMeta("ComputePooledEnclosureComputeSlot", "computePooledEnclosureComputeSlot", "system-[system_id]-server-[chassis_id]-[slot_id]-[server_instance_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'computePool'], [], ["Add", "Get", "Remove"]),
    "ComputePooledRackUnit": MoMeta("ComputePooledRackUnit", "computePooledRackUnit", "system-[system_id]-rack-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'computePool'], [], ["Add", "Get", "Remove"]),
    "ComputePooledSlot": MoMeta("ComputePooledSlot", "computePooledSlot", "system-[system_id]-blade-[chassis_id]-[slot_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'computePool'], [], ["Add", "Get", "Remove"]),
    "ComputePoolingPolicy": MoMeta("ComputePoolingPolicy", "computePoolingPolicy", "pooling-policy-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputePortDiscPolicy": MoMeta("ComputePortDiscPolicy", "computePortDiscPolicy", "port-discovery", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-policy", "read-only"], [u'orgDomainGroup', u'orgOrg'], [], ["get", "set"]),
    "ComputePowerSyncDef": MoMeta("ComputePowerSyncDef", "computePowerSyncDef", "power-sync-def", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config-policy", "ls-server", "ls-server-policy"], [u'lsServer'], [], [None]),
    "ComputePowerSyncPolicy": MoMeta("ComputePowerSyncPolicy", "computePowerSyncPolicy", "power-sync-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config-policy", "ls-server", "ls-server-policy"], [u'orgOrg'], [], ["add", "get", "remove", "set"]),
    "ComputeProductFamilyQual": MoMeta("ComputeProductFamilyQual", "computeProductFamilyQual", "product-qualifier-[product_family]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], [u'computeDomainQual'], [], ["Add", "Get", "Remove"]),
    "ComputeProfile": MoMeta("ComputeProfile", "computeProfile", "profile-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'computeResourceAggrEp'], [u'computeUser'], [None]),
    "ComputePsuPolicy": MoMeta("ComputePsuPolicy", "computePsuPolicy", "psu-policy", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-equipment", "pn-policy"], [u'orgDomainGroup'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputeQual": MoMeta("ComputeQual", "computeQual", "blade-qualifier-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'adaptorQual', u'computeDomainQual', u'computePhysicalQual', u'memoryQual', u'powerGroupQual', u'processorQual', u'storageQual'], ["Add", "Get", "Remove", "Set"]),
    "ComputeRackQual": MoMeta("ComputeRackQual", "computeRackQual", "rack-from-[min_id]-to-[max_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], [u'computeDomainQual'], [], ["Add", "Get", "Remove"]),
    "ComputeRackUnit": MoMeta("ComputeRackUnit", "computeRackUnit", "rack-unit-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'computeSystem'], [u'adaptorHostIfConfig', u'adaptorUnit', u'biosUnit', u'computeBoard', u'computeBoardController', u'computeExtBoard', u'computeFactoryResetOp', u'computeFactoryResetOperation', u'computePhysicalExtension', u'computePhysicalOperation', u'computePoolable', u'computeRebootLog', u'diagSrvCtrl', u'equipmentBeaconLed', u'equipmentFanModule', u'equipmentHealthLed', u'equipmentIndicatorLed', u'equipmentLocatorLed', u'equipmentPsu', u'firmwareStatus', u'lsIdentityInfo', u'lsbootDef', u'mgmtController', u'mgmtSecurity', u'storageEnclosure', u'storageVirtualDriveContainer', u'sysdebugDiagnosticLog'], ["Get"]),
    "ComputeRackUnitMbTempStats": MoMeta("ComputeRackUnitMbTempStats", "computeRackUnitMbTempStats", "temp-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'computeBoard'], [u'computeRackUnitMbTempStatsHist'], [None]),
    "ComputeRackUnitMbTempStatsHist": MoMeta("ComputeRackUnitMbTempStatsHist", "computeRackUnitMbTempStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'computeRackUnitMbTempStats'], [], [None]),
    "ComputeRebootLog": MoMeta("ComputeRebootLog", "computeRebootLog", "reboot-log-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [], ["get"]),
    "ComputeRemoteOpStatus": MoMeta("ComputeRemoteOpStatus", "computeRemoteOpStatus", "remote-op-status", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], [u'mgmtBackup'], [u'faultInst'], ["Get"]),
    "ComputeRequirement": MoMeta("ComputeRequirement", "computeRequirement", "req-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'computeInstance'], ["Get"]),
    "ComputeResourceAggrEp": MoMeta("ComputeResourceAggrEp", "computeResourceAggrEp", "compute", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'computeFaultUpgradeFlag', u'computeGroupMembership', u'computeProfile', u'computeResourceSetManager', u'computeSystem', u'faultGlobalSeverityHolder', u'faultGlobalTypedHolder'], ["Get", "Set"]),
    "ComputeResourceSet": MoMeta("ComputeResourceSet", "computeResourceSet", "rsrc-set-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'computeResourceSetManager'], [u'computeResourceSetMember'], [None]),
    "ComputeResourceSetManager": MoMeta("ComputeResourceSetManager", "computeResourceSetManager", "rsrc-set-mgr", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'computeResourceAggrEp'], [u'computeResourceSet'], [None]),
    "ComputeResourceSetMember": MoMeta("ComputeResourceSetMember", "computeResourceSetMember", "rsrc-set-member-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'computeResourceSet'], [], [None]),
    "ComputeScrubPolicy": MoMeta("ComputeScrubPolicy", "computeScrubPolicy", "scrub-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputeServerDiscPolicy": MoMeta("ComputeServerDiscPolicy", "computeServerDiscPolicy", "server-discovery", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-policy"], [u'orgDomainGroup', u'orgOrg'], [], ["Get", "Set"]),
    "ComputeServerFeatMask": MoMeta("ComputeServerFeatMask", "computeServerFeatMask", "serv-feat-mask", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [u'computeSystem', u'extpolDomain', u'lsServer'], [], ["Get"]),
    "ComputeServerMgmtPolicy": MoMeta("ComputeServerMgmtPolicy", "computeServerMgmtPolicy", "server-mgmt-policy", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "pn-policy"], [u'orgDomainGroup', u'orgOrg'], [], ["Get", "Set"]),
    "ComputeServerUnit": MoMeta("ComputeServerUnit", "computeServerUnit", "server-[server_instance_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'computeCartridge'], [u'adaptorHostIfConfig', u'adaptorUnit', u'biosUnit', u'computeBoard', u'computeBoardController', u'computeExtBoard', u'computeFactoryResetOp', u'computeFactoryResetOperation', u'computePhysicalExtension', u'computePhysicalOperation', u'computePoolable', u'computeRebootLog', u'diagSrvCtrl', u'equipmentBeaconLed', u'equipmentHealthLed', u'equipmentIndicatorLed', u'equipmentLocatorLed', u'firmwareStatus', u'lsIdentityInfo', u'lsbootDef', u'mgmtController', u'mgmtSecurity', u'storageEnclosure', u'storageVirtualDriveContainer', u'sysdebugDiagnosticLog'], ["Get", "Set"]),
    "ComputeSession": MoMeta("ComputeSession", "computeSession", "session-[system_name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'computeUser'], [], [None]),
    "ComputeSiteQual": MoMeta("ComputeSiteQual", "computeSiteQual", "site-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], [u'computeDomainQual', u'computeSystemQual'], [], ["Add", "Get", "Remove", "Set"]),
    "ComputeSlotQual": MoMeta("ComputeSlotQual", "computeSlotQual", "slot-from-[min_id]-to-[max_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], [u'computeChassisQual'], [u'computeInstanceIdQual'], ["Add", "Get", "Remove"]),
    "ComputeStorageFeatMask": MoMeta("ComputeStorageFeatMask", "computeStorageFeatMask", "storage-feat-mask", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [u'computeSystem', u'extpolDomain', u'lsServer'], [], ["Get"]),
    "ComputeSystem": MoMeta("ComputeSystem", "computeSystem", "sys-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'computeResourceAggrEp'], [u'commSvcEp', u'computeChassisConnPolicy', u'computeChassisFeatMask', u'computeEnvFeatMask', u'computeFabricEthMonSrcEpCont', u'computeFabricFcMonSrcEpCont', u'computeInstanceMapping', u'computeNetworkFeatMask', u'computeRackUnit', u'computeServerFeatMask', u'computeStorageFeatMask', u'computeSystemFsm', u'computeSystemFsmTask', u'computeTemplateMapping', u'computeUserEp', u'domainChassisFeature', u'domainEnvironmentFeature', u'domainNetworkFeature', u'domainServerFeature', u'domainStorageFeature', u'equipmentChassis', u'equipmentFex', u'equipmentInstanceMapping', u'equipmentTemplateMapping', u'eventInst', u'fabricEp', u'faultDomainEp', u'faultInst', u'faultLocalTypedHolder', u'firmwareCatalogPack', u'firmwareSystem', u'firmwareUpgradeInfo', u'fsmStatus', u'mgmtBackup', u'mgmtBackupOperation', u'mgmtController', u'mgmtEntity', u'networkElement', u'policyControlEp', u'storageCloud', u'sysdebugTechSupFileRepository'], ["Get", "Set"]),
    "ComputeSystemAddrQual": MoMeta("ComputeSystemAddrQual", "computeSystemAddrQual", "ip-from-[min_addr]-to-[max_addr]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], [u'computeDomainQual', u'computeSystemQual'], [], ["Add", "Get", "Remove"]),
    "ComputeSystemFsm": MoMeta("ComputeSystemFsm", "computeSystemFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'computeSystem'], [u'computeSystemFsmStage'], [None]),
    "ComputeSystemFsmStage": MoMeta("ComputeSystemFsmStage", "computeSystemFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'computeSystemFsm'], [], [None]),
    "ComputeSystemFsmTask": MoMeta("ComputeSystemFsmTask", "computeSystemFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], [u'computeSystem'], [], [None]),
    "ComputeSystemQual": MoMeta("ComputeSystemQual", "computeSystemQual", "system-qualifier-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], [""], [u'orgOrg'], [u'computeOwnerQual', u'computeSiteQual', u'computeSystemAddrQual'], ["Add", "Get", "Remove", "Set"]),
    "ComputeTemplate": MoMeta("ComputeTemplate", "computeTemplate", "templ-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'computeLocalTemplDef', u'lsServer'], ["Get"]),
    "ComputeTemplateMapping": MoMeta("ComputeTemplateMapping", "computeTemplateMapping", "templmap-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'computeSystem'], [], [None]),
    "ComputeUser": MoMeta("ComputeUser", "computeUser", "user-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'computeProfile', u'computeUserEp'], [u'computeSession'], [None]),
    "ComputeUserEp": MoMeta("ComputeUserEp", "computeUserEp", "user", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'computeSystem'], [u'computeUser'], [None]),
    "ConfigAckItem": MoMeta("ConfigAckItem", "configAckItem", "ack-item", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigAdaptorItem": MoMeta("ConfigAdaptorItem", "configAdaptorItem", "adaptor-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigAppImpactResponse": MoMeta("ConfigAppImpactResponse", "configAppImpactResponse", "app-id-[app_connector_id]src-id-[source_connector_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'configImpactAnalyzer'], [u'configUCImpact'], [None]),
    "ConfigBackup": MoMeta("ConfigBackup", "configBackup", "type-[backup_type]-ts-[creation_ts]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'configConsumerCatalogue'], [u'configBackupFsm', u'configBackupFsmTask', u'eventInst', u'faultInst'], ["Get", "Set"]),
    "ConfigBackupFsm": MoMeta("ConfigBackupFsm", "configBackupFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'configBackup'], [u'configBackupFsmStage'], [None]),
    "ConfigBackupFsmStage": MoMeta("ConfigBackupFsmStage", "configBackupFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'configBackupFsm'], [], [None]),
    "ConfigBackupFsmTask": MoMeta("ConfigBackupFsmTask", "configBackupFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'configBackup'], [], ["Get"]),
    "ConfigCartridgeFilter": MoMeta("ConfigCartridgeFilter", "configCartridgeFilter", "cartridge-filter", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigCartridgeItem": MoMeta("ConfigCartridgeItem", "configCartridgeItem", "cartridge-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigCatalogue": MoMeta("ConfigCatalogue", "configCatalogue", "config-catalogue", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'configConsumerCatalogue'], ["Get"]),
    "ConfigChassisFilter": MoMeta("ConfigChassisFilter", "configChassisFilter", "chassic-filter", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigChassisItem": MoMeta("ConfigChassisItem", "configChassisItem", "chassis-item", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigComponentsFilter": MoMeta("ConfigComponentsFilter", "configComponentsFilter", "components-filter", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [], [], [None]),
    "ConfigConsumerCatalogue": MoMeta("ConfigConsumerCatalogue", "configConsumerCatalogue", "consumer-catalogue-[internal_name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'configCatalogue', u'consumerInst'], [u'configBackup', u'configConsumerCatalogueFsm', u'configConsumerCatalogueFsmTask', u'eventInst', u'faultInst'], ["Get", "Set"]),
    "ConfigConsumerCatalogueFsm": MoMeta("ConfigConsumerCatalogueFsm", "configConsumerCatalogueFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'configConsumerCatalogue'], [u'configConsumerCatalogueFsmStage'], [None]),
    "ConfigConsumerCatalogueFsmStage": MoMeta("ConfigConsumerCatalogueFsmStage", "configConsumerCatalogueFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'configConsumerCatalogueFsm'], [], [None]),
    "ConfigConsumerCatalogueFsmTask": MoMeta("ConfigConsumerCatalogueFsmTask", "configConsumerCatalogueFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'configConsumerCatalogue'], [], ["Get"]),
    "ConfigControllerItem": MoMeta("ConfigControllerItem", "configControllerItem", "controller-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigCpuInfo": MoMeta("ConfigCpuInfo", "configCpuInfo", "cpu-info-[arch]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'configServerItem'], [], [None]),
    "ConfigCpuItem": MoMeta("ConfigCpuItem", "configCpuItem", "cpu-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigCryptoCardItem": MoMeta("ConfigCryptoCardItem", "configCryptoCardItem", "crypto-card-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigDbConfig": MoMeta("ConfigDbConfig", "configDbConfig", "dbconfig", VersionMeta.Version111b, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'faultInst'], ["Get"]),
    "ConfigDomainFilter": MoMeta("ConfigDomainFilter", "configDomainFilter", "domain-filter", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigDomainItem": MoMeta("ConfigDomainItem", "configDomainItem", "domain-item", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigFabricInterconnectFilter": MoMeta("ConfigFabricInterconnectFilter", "configFabricInterconnectFilter", "fabric-interconnect-filter", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigFabricInterconnectItem": MoMeta("ConfigFabricInterconnectItem", "configFabricInterconnectItem", "fabric-interconnect-item", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigFanItem": MoMeta("ConfigFanItem", "configFanItem", "fan-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigFexFilter": MoMeta("ConfigFexFilter", "configFexFilter", "fex-filter", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigFexItem": MoMeta("ConfigFexItem", "configFexItem", "fex-item", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigFilterGroup": MoMeta("ConfigFilterGroup", "configFilterGroup", "filter-group-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [], [u'configFilterItem'], [None]),
    "ConfigFilterItem": MoMeta("ConfigFilterItem", "configFilterItem", "filter-item-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'configFilterGroup'], [], [None]),
    "ConfigFsm": MoMeta("ConfigFsm", "configFsm", "fsm", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [u'configFsmStage'], [None]),
    "ConfigFsmStage": MoMeta("ConfigFsmStage", "configFsmStage", "stage-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'configFsm'], [], [None]),
    "ConfigGraphicsCardItem": MoMeta("ConfigGraphicsCardItem", "configGraphicsCardItem", "graphics-card-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigIOMItem": MoMeta("ConfigIOMItem", "configIOMItem", "iom-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigImpact": MoMeta("ConfigImpact", "configImpact", "impact-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'configManagedEpImpactResponse'], [], [None]),
    "ConfigImpactAnalyzer": MoMeta("ConfigImpactAnalyzer", "configImpactAnalyzer", "impact-analyzer-[impact_analyzer_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'configImpactAnalyzerEp'], [u'configAppImpactResponse', u'configInputConfigSet', u'configManagedEpImpactResponse'], [None]),
    "ConfigImpactAnalyzerEp": MoMeta("ConfigImpactAnalyzerEp", "configImpactAnalyzerEp", "impactanalyzer-ep", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'configImpactAnalyzer'], [None]),
    "ConfigInputConfig": MoMeta("ConfigInputConfig", "configInputConfig", "name-[input_name]status-[input_config_status]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'configInputConfigSet'], [], [None]),
    "ConfigInputConfigSet": MoMeta("ConfigInputConfigSet", "configInputConfigSet", "InputConfigSet", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'configImpactAnalyzer'], [u'configInputConfig'], [None]),
    "ConfigLocalDiskItem": MoMeta("ConfigLocalDiskItem", "configLocalDiskItem", "local-disk-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigLunItem": MoMeta("ConfigLunItem", "configLunItem", "lun-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigManagedEpImpactResponse": MoMeta("ConfigManagedEpImpactResponse", "configManagedEpImpactResponse", "ManagedEpapp-id-[app_connector_id]src-id-[source_connector_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'configImpactAnalyzer'], [u'configImpact'], [None]),
    "ConfigMemoryItem": MoMeta("ConfigMemoryItem", "configMemoryItem", "memory-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigMotherboardItem": MoMeta("ConfigMotherboardItem", "configMotherboardItem", "motherboard-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigNetRefItem": MoMeta("ConfigNetRefItem", "configNetRefItem", "", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigOrgItem": MoMeta("ConfigOrgItem", "configOrgItem", "org-item-[context]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'fabricVlanPermitItem'], [], [None]),
    "ConfigPSUItem": MoMeta("ConfigPSUItem", "configPSUItem", "psu-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigPolicyUsageItem": MoMeta("ConfigPolicyUsageItem", "configPolicyUsageItem", "policy-usage-item", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigPortItem": MoMeta("ConfigPortItem", "configPortItem", "port-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigSearchOptions": MoMeta("ConfigSearchOptions", "configSearchOptions", "", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "ConfigSearchResult": MoMeta("ConfigSearchResult", "configSearchResult", "policy-[converted_dn]-domain-[domain_id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "ConfigServerFilter": MoMeta("ConfigServerFilter", "configServerFilter", "server-filter", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigServerItem": MoMeta("ConfigServerItem", "configServerItem", "server-item", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [u'configCpuInfo'], [None]),
    "ConfigServiceProfileFilter": MoMeta("ConfigServiceProfileFilter", "configServiceProfileFilter", "service-profile-filter", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigSorter": MoMeta("ConfigSorter", "configSorter", "class-[sort_class]prop-[sort_prop]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigSpotLightItem": MoMeta("ConfigSpotLightItem", "configSpotLightItem", "spotlight-[composite_id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [], [], [None]),
    "ConfigStorageArrayProfileFilter": MoMeta("ConfigStorageArrayProfileFilter", "configStorageArrayProfileFilter", "storage-array-profile-filter", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigStorageBladeFilter": MoMeta("ConfigStorageBladeFilter", "configStorageBladeFilter", "storage-blade-filter", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigStorageItem": MoMeta("ConfigStorageItem", "configStorageItem", "storage-item", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ConfigUCImpact": MoMeta("ConfigUCImpact", "configUCImpact", "ls-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'configAppImpactResponse'], [], [None]),
    "ConsumerInst": MoMeta("ConsumerInst", "consumerInst", "inst-[connector_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'consumerUniverse'], [u'configConsumerCatalogue', u'consumerInstFsm', u'consumerInstFsmTask', u'eventInst', u'faultInst', u'mgmtImporter', u'nfsMountDef'], [None]),
    "ConsumerInstFsm": MoMeta("ConsumerInstFsm", "consumerInstFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'consumerInst'], [u'consumerInstFsmStage'], [None]),
    "ConsumerInstFsmStage": MoMeta("ConsumerInstFsmStage", "consumerInstFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'consumerInstFsm'], [], [None]),
    "ConsumerInstFsmTask": MoMeta("ConsumerInstFsmTask", "consumerInstFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'consumerInst'], [], [None]),
    "ConsumerUniverse": MoMeta("ConsumerUniverse", "consumerUniverse", "universe", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'consumerInst'], [None]),
    "ControllerEp": MoMeta("ControllerEp", "controllerEp", "controller", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'controllerEpFsm', u'controllerEpFsmTask', u'eventInst', u'faultInst'], [None]),
    "ControllerEpFsm": MoMeta("ControllerEpFsm", "controllerEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'controllerEp'], [u'controllerEpFsmStage'], [None]),
    "ControllerEpFsmStage": MoMeta("ControllerEpFsmStage", "controllerEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'controllerEpFsm'], [], [None]),
    "ControllerEpFsmTask": MoMeta("ControllerEpFsmTask", "controllerEpFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], [u'controllerEp'], [], [None]),
    "CpmaintAck": MoMeta("CpmaintAck", "cpmaintAck", "ack", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassisProfile', u'equipmentInstance'], [u'faultInst'], ["Get", "Set"]),
    "CpmaintMaintPolicy": MoMeta("CpmaintMaintPolicy", "cpmaintMaintPolicy", "chassis-profile-maint-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "DcxVIf": MoMeta("DcxVIf", "dcxVIf", "vif-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'adaptorExtEthIf', u'adaptorHostEthIf', u'adaptorHostFcIf'], [], ["get"]),
    "DcxVc": MoMeta("DcxVc", "dcxVc", "vc-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [], [u'fabricNetGroupRef', u'fabricSanGroupRef'], ["Get"]),
    "DiagLogEp": MoMeta("DiagLogEp", "diagLogEp", "logep-[switch_id]", VersionMeta.Version201b, "InputOutput", 0x1, [], [""], [u'diagRslt'], [], ["get"]),
    "DiagMemoryTest": MoMeta("DiagMemoryTest", "diagMemoryTest", "test-[order]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'diagRunPolicy'], [], ["get"]),
    "DiagRslt": MoMeta("DiagRslt", "diagRslt", "rslt-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], [""], [u'diagSrvCtrl'], [u'diagLogEp'], ["get"]),
    "DiagRunPolicy": MoMeta("DiagRunPolicy", "diagRunPolicy", "diag-policy-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'diagSrvCtrl', u'orgDomainGroup', u'orgOrg'], [u'diagMemoryTest'], ["get", "set"]),
    "DiagSrvCapProvider": MoMeta("DiagSrvCapProvider", "diagSrvCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [u'equipmentFruVariant', u'equipmentManufacturingDef', u'equipmentPicture'], ["get"]),
    "DiagSrvCtrl": MoMeta("DiagSrvCtrl", "diagSrvCtrl", "diag", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [u'diagRslt', u'diagRunPolicy', u'diagSrvCtrlOperation', u'etherServerIntFIo'], ["get"]),
    "DiagSrvCtrlOperation": MoMeta("DiagSrvCtrlOperation", "diagSrvCtrlOperation", "remote-oper", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance"], [u'diagSrvCtrl'], [u'diagSrvCtrlOperationFsm', u'diagSrvCtrlOperationFsmTask', u'eventInst', u'faultInst'], ["get", "set"]),
    "DiagSrvCtrlOperationFsm": MoMeta("DiagSrvCtrlOperationFsm", "diagSrvCtrlOperationFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'diagSrvCtrlOperation'], [u'diagSrvCtrlOperationFsmStage'], [None]),
    "DiagSrvCtrlOperationFsmStage": MoMeta("DiagSrvCtrlOperationFsmStage", "diagSrvCtrlOperationFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'diagSrvCtrlOperationFsm'], [], [None]),
    "DiagSrvCtrlOperationFsmTask": MoMeta("DiagSrvCtrlOperationFsmTask", "diagSrvCtrlOperationFsmTask", "task-[item]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'diagSrvCtrlOperation'], [], [None]),
    "DomainChassisFeature": MoMeta("DomainChassisFeature", "domainChassisFeature", "chassis-feature-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], [""], [u'computeSystem', u'domainFeatureCatalog', u'extpolDomain'], [u'domainChassisParam', u'domainEnvironmentParam', u'domainNetworkParam', u'domainServerParam', u'domainStorageParam'], ["get"]),
    "DomainChassisParam": MoMeta("DomainChassisParam", "domainChassisParam", "chassis-param-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'domainChassisFeature', u'domainEnvironmentFeature', u'domainFeatureCatalog', u'domainNetworkFeature', u'domainServerFeature', u'domainStorageFeature', u'featureChassisDef', u'featureEnvDef', u'featureNetworkDef', u'featureServerDef', u'featureStorageDef'], [], ["get"]),
    "DomainChassisProfileItem": MoMeta("DomainChassisProfileItem", "domainChassisProfileItem", "CP[chassis_profile_dn]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-server", "pn-equipment", "pn-maintenance", "pn-policy"], [], [], [None]),
    "DomainEnvironmentFeature": MoMeta("DomainEnvironmentFeature", "domainEnvironmentFeature", "env-feature-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], [""], [u'computeSystem', u'domainFeatureCatalog', u'extpolDomain'], [u'domainChassisParam', u'domainEnvironmentParam', u'domainNetworkParam', u'domainServerParam', u'domainStorageParam'], ["Get"]),
    "DomainEnvironmentParam": MoMeta("DomainEnvironmentParam", "domainEnvironmentParam", "env-param-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'domainChassisFeature', u'domainEnvironmentFeature', u'domainFeatureCatalog', u'domainNetworkFeature', u'domainServerFeature', u'domainStorageFeature', u'featureChassisDef', u'featureEnvDef', u'featureNetworkDef', u'featureServerDef', u'featureStorageDef'], [], ["Get"]),
    "DomainEp": MoMeta("DomainEp", "domainEp", "catalog", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'domainFeatureCatalog'], ["Get"]),
    "DomainFamilyCapProvider": MoMeta("DomainFamilyCapProvider", "domainFamilyCapProvider", "model-[model]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], [u'capabilityCatalogue'], [], ["Get"]),
    "DomainFeatureCatalog": MoMeta("DomainFeatureCatalog", "domainFeatureCatalog", "catalog-[version]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'domainEp'], [u'domainChassisFeature', u'domainChassisParam', u'domainEnvironmentFeature', u'domainEnvironmentParam', u'domainNetworkFeature', u'domainNetworkParam', u'domainServerFeature', u'domainServerParam', u'domainStorageFeature', u'domainStorageParam'], ["Get"]),
    "DomainNetworkFeature": MoMeta("DomainNetworkFeature", "domainNetworkFeature", "network-feature-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], [""], [u'computeSystem', u'domainFeatureCatalog', u'extpolDomain'], [u'domainChassisParam', u'domainEnvironmentParam', u'domainNetworkParam', u'domainServerParam', u'domainStorageParam'], ["Get"]),
    "DomainNetworkParam": MoMeta("DomainNetworkParam", "domainNetworkParam", "network-param-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'domainChassisFeature', u'domainEnvironmentFeature', u'domainFeatureCatalog', u'domainNetworkFeature', u'domainServerFeature', u'domainStorageFeature', u'featureChassisDef', u'featureEnvDef', u'featureNetworkDef', u'featureServerDef', u'featureStorageDef'], [], ["Get"]),
    "DomainProfile": MoMeta("DomainProfile", "domainProfile", "domain-profile-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "domain-group-management"], [u'fabricSystem', u'orgDomainGroup'], [u'domainProfileFsm', u'domainProfileFsmTask', u'eventInst', u'faultInst', u'messageEp'], ["get", "set"]),
    "DomainProfileFsm": MoMeta("DomainProfileFsm", "domainProfileFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'domainProfile'], [u'domainProfileFsmStage'], [None]),
    "DomainProfileFsmStage": MoMeta("DomainProfileFsmStage", "domainProfileFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'domainProfileFsm'], [], [None]),
    "DomainProfileFsmTask": MoMeta("DomainProfileFsmTask", "domainProfileFsmTask", "task-[item]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'domainProfile'], [], [None]),
    "DomainServerFeature": MoMeta("DomainServerFeature", "domainServerFeature", "server-feature-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], [""], [u'computeSystem', u'domainFeatureCatalog', u'extpolDomain'], [u'domainChassisParam', u'domainEnvironmentParam', u'domainNetworkParam', u'domainServerParam', u'domainStorageParam'], ["Get"]),
    "DomainServerParam": MoMeta("DomainServerParam", "domainServerParam", "server-param-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'domainChassisFeature', u'domainEnvironmentFeature', u'domainFeatureCatalog', u'domainNetworkFeature', u'domainServerFeature', u'domainStorageFeature', u'featureChassisDef', u'featureEnvDef', u'featureNetworkDef', u'featureServerDef', u'featureStorageDef'], [], ["Get"]),
    "DomainServiceProfileItem": MoMeta("DomainServiceProfileItem", "domainServiceProfileItem", "SP[service_profile_dn]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-server", "pn-equipment", "pn-maintenance", "pn-policy"], [], [], ["Get"]),
    "DomainStorageFeature": MoMeta("DomainStorageFeature", "domainStorageFeature", "storage-feature-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], [""], [u'computeSystem', u'domainFeatureCatalog', u'extpolDomain'], [u'domainChassisParam', u'domainEnvironmentParam', u'domainNetworkParam', u'domainServerParam', u'domainStorageParam'], ["Get"]),
    "DomainStorageParam": MoMeta("DomainStorageParam", "domainStorageParam", "storage-param-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'domainChassisFeature', u'domainEnvironmentFeature', u'domainFeatureCatalog', u'domainNetworkFeature', u'domainServerFeature', u'domainStorageFeature', u'featureChassisDef', u'featureEnvDef', u'featureNetworkDef', u'featureServerDef', u'featureStorageDef'], [], ["Get"]),
    "DpsecMac": MoMeta("DpsecMac", "dpsecMac", "mac-sec", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'nwctrlDefinition'], [], ["Add", "Get", "Remove", "Set"]),
    "DupeChangeTracker": MoMeta("DupeChangeTracker", "dupeChangeTracker", "changetracker-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'dupeChangeTrackerEp'], [], [None]),
    "DupeChangeTrackerEp": MoMeta("DupeChangeTrackerEp", "dupeChangeTrackerEp", "changetracker-ep", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'dupeEp'], [u'dupeChangeTracker', u'dupeChangeTrackerEpFsm', u'dupeChangeTrackerEpFsmTask', u'eventInst', u'faultInst'], [None]),
    "DupeChangeTrackerEpFsm": MoMeta("DupeChangeTrackerEpFsm", "dupeChangeTrackerEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'dupeChangeTrackerEp'], [u'dupeChangeTrackerEpFsmStage'], [None]),
    "DupeChangeTrackerEpFsmStage": MoMeta("DupeChangeTrackerEpFsmStage", "dupeChangeTrackerEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'dupeChangeTrackerEpFsm'], [], [None]),
    "DupeChangeTrackerEpFsmTask": MoMeta("DupeChangeTrackerEpFsmTask", "dupeChangeTrackerEpFsmTask", "task-[item]", VersionMeta.Version131a, "OutputOnly", 0x1, [], [""], [u'dupeChangeTrackerEp'], [], [None]),
    "DupeEp": MoMeta("DupeEp", "dupeEp", "dup-ep", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'extpolClient', u'extpolController', u'extpolProvider', u'extpolRegistry'], [u'dupeChangeTrackerEp', u'dupeScopeEp'], [None]),
    "DupeExtRequestor": MoMeta("DupeExtRequestor", "dupeExtRequestor", "ext-requestor", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [u'dupeScope'], [], [None]),
    "DupeIntRequestor": MoMeta("DupeIntRequestor", "dupeIntRequestor", "int-requestor-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'dupeScope'], [], [None]),
    "DupeScope": MoMeta("DupeScope", "dupeScope", "scope-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [u'dupeScopeEp'], [u'dupeExtRequestor', u'dupeIntRequestor', u'dupeScopeResult'], [None]),
    "DupeScopeEp": MoMeta("DupeScopeEp", "dupeScopeEp", "scope-ep", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'dupeEp'], [u'dupeScope'], [None]),
    "DupeScopeResult": MoMeta("DupeScopeResult", "dupeScopeResult", "result", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'dupeScope'], [], [None]),
    "EpqosDefinition": MoMeta("EpqosDefinition", "epqosDefinition", "ep-qos-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-qos-policy", "read-only"], [u'orgOrg'], [u'epqosEgress'], ["Add", "Get", "Remove", "Set"]),
    "EpqosEgress": MoMeta("EpqosEgress", "epqosEgress", "egress", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-qos-policy", "read-only"], [u'epqosDefinition'], [], ["Add", "Get", "Remove", "Set"]),
    "EquipmentAdvancedBootOrder": MoMeta("EquipmentAdvancedBootOrder", "equipmentAdvancedBootOrder", "advbootordsupp-[is_supported]", VersionMeta.Version121a, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider', u'equipmentServerUnitCapProvider'], [], ["Get"]),
    "EquipmentBeaconLed": MoMeta("EquipmentBeaconLed", "equipmentBeaconLed", "beacon", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'equipmentChassis', u'equipmentFanModule', u'equipmentFex', u'equipmentIOCard', u'equipmentPsu'], [], ["Get"]),
    "EquipmentBinding": MoMeta("EquipmentBinding", "equipmentBinding", "chassis", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy", "read-only"], [u'equipmentChassisProfile'], [], ["Add", "Get", "Remove", "Set"]),
    "EquipmentBladeCapProvider": MoMeta("EquipmentBladeCapProvider", "equipmentBladeCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [u'equipmentAdvancedBootOrder', u'equipmentCimcVmedia', u'equipmentDriveSecCap', u'equipmentFruVariant', u'equipmentManufacturingDef', u'equipmentPicture', u'equipmentSecureBoot', u'equipmentServerFeatureCap', u'equipmentStorageProcessorCap'], ["Get"]),
    "EquipmentBreakoutCap": MoMeta("EquipmentBreakoutCap", "equipmentBreakoutCap", "breakout-cap", VersionMeta.Version141a, "InputOutput", 0x1, [], [""], [u'equipmentSwitchCapProvider'], [], ["Get"]),
    "EquipmentCPMeta": MoMeta("EquipmentCPMeta", "equipmentCPMeta", "cpmeta", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassisProfile'], [u'messageEp'], ["Get"]),
    "EquipmentChassis": MoMeta("EquipmentChassis", "equipmentChassis", "chassis-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'computeSystem'], [u'computeBlade', u'computeBoardController', u'computeCartridge', u'computeChassisFeatMask', u'equipmentBeaconLed', u'equipmentChassisOperation', u'equipmentChassisStats', u'equipmentComputeConn', u'equipmentFanModule', u'equipmentHealthLed', u'equipmentIOCard', u'equipmentIndicatorLed', u'equipmentLocatorLed', u'equipmentPsu', u'equipmentSharedIOModule', u'equipmentSwitchIOCard', u'equipmentSystemIOController', u'faultInst', u'mgmtController', u'sesEnclosure', u'storageBlade', u'storageController', u'storageEnclosure', u'storageSasExpander', u'storageVirtualDriveContainer'], ["Get"]),
    "EquipmentChassisAssocCtx": MoMeta("EquipmentChassisAssocCtx", "equipmentChassisAssocCtx", "cp-assoc-ctx", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'equipmentChassisProfileAssocCtx'], [], ["Get"]),
    "EquipmentChassisCapProvider": MoMeta("EquipmentChassisCapProvider", "equipmentChassisCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [u'equipmentFruVariant', u'equipmentManufacturingDef', u'equipmentPicture'], ["Get"]),
    "EquipmentChassisIssues": MoMeta("EquipmentChassisIssues", "equipmentChassisIssues", "config-issue", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassisProfile', u'equipmentInstance'], [], ["Get"]),
    "EquipmentChassisOperation": MoMeta("EquipmentChassisOperation", "equipmentChassisOperation", "remote-oper", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassis'], [u'faultInst'], ["Get", "Set"]),
    "EquipmentChassisProfile": MoMeta("EquipmentChassisProfile", "equipmentChassisProfile", "cp-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentTemplate', u'equipmentTier', u'orgOrg'], [u'computeChassisFeatMask', u'cpmaintAck', u'equipmentBinding', u'equipmentCPMeta', u'equipmentChassisIssues', u'equipmentChassisProfileAssocCtx', u'equipmentChassisProfileFsm', u'equipmentChassisProfileFsmTask', u'equipmentRequirement', u'eventInst', u'faultInst', u'lstorageDiskZoningConfigDef'], ["Add", "Get", "Remove", "Set"]),
    "EquipmentChassisProfileAssocCtx": MoMeta("EquipmentChassisProfileAssocCtx", "equipmentChassisProfileAssocCtx", "cp-assoc-ctx", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'equipmentChassisProfile'], [u'equipmentChassisAssocCtx'], ["Get"]),
    "EquipmentChassisProfileFsm": MoMeta("EquipmentChassisProfileFsm", "equipmentChassisProfileFsm", "fsm", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], [u'equipmentChassisProfile'], [u'equipmentChassisProfileFsmStage'], [None]),
    "EquipmentChassisProfileFsmStage": MoMeta("EquipmentChassisProfileFsmStage", "equipmentChassisProfileFsmStage", "stage-[name]", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], [u'equipmentChassisProfileFsm'], [], [None]),
    "EquipmentChassisProfileFsmTask": MoMeta("EquipmentChassisProfileFsmTask", "equipmentChassisProfileFsmTask", "task-[item]", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], [u'equipmentChassisProfile'], [], [None]),
    "EquipmentChassisQual": MoMeta("EquipmentChassisQual", "equipmentChassisQual", "chassis-from-[min_id]-to-[max_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'equipmentQual'], [], [None]),
    "EquipmentChassisRequirement": MoMeta("EquipmentChassisRequirement", "equipmentChassisRequirement", "chassis-req-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'equipmentInstance'], ["Get"]),
    "EquipmentChassisStats": MoMeta("EquipmentChassisStats", "equipmentChassisStats", "stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentChassis'], [u'equipmentChassisStatsHist'], [None]),
    "EquipmentChassisStatsHist": MoMeta("EquipmentChassisStatsHist", "equipmentChassisStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentChassisStats'], [], [None]),
    "EquipmentCimcVmedia": MoMeta("EquipmentCimcVmedia", "equipmentCimcVmedia", "cimcvmediasupp-[is_supported]", VersionMeta.Version121a, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider', u'equipmentServerUnitCapProvider'], [], ["Get"]),
    "EquipmentComputeConn": MoMeta("EquipmentComputeConn", "equipmentComputeConn", "compute-conn", VersionMeta.Version201b, "InputOutput", 0x1, [], [""], [u'equipmentChassis'], [], ["get"]),
    "EquipmentComputeConnPolicy": MoMeta("EquipmentComputeConnPolicy", "equipmentComputeConnPolicy", "compute-conn-policy-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [], ["add", "get", "remove", "set"]),
    "EquipmentDriveSecCap": MoMeta("EquipmentDriveSecCap", "equipmentDriveSecCap", "drive-sec-cap", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'equipmentBladeCapProvider', u'equipmentLocalDiskControllerCapProvider', u'equipmentRackUnitCapProvider'], [], ["get"]),
    "EquipmentFan": MoMeta("EquipmentFan", "equipmentFan", "fan-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'equipmentFanModule', u'equipmentFex', u'networkElement'], [u'equipmentFanStats', u'equipmentNetworkElementFanStats', u'equipmentRackUnitFanStats', u'faultInst'], ["Get"]),
    "EquipmentFanModule": MoMeta("EquipmentFanModule", "equipmentFanModule", "fan-module-[tray]-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'computeRackUnit', u'equipmentChassis', u'networkElement'], [u'equipmentBeaconLed', u'equipmentFan', u'equipmentFanModuleStats', u'equipmentHealthLed', u'equipmentIndicatorLed', u'equipmentLocatorLed', u'faultInst'], ["Get"]),
    "EquipmentFanModuleCapProvider": MoMeta("EquipmentFanModuleCapProvider", "equipmentFanModuleCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [u'equipmentFruVariant', u'equipmentManufacturingDef', u'equipmentPicture'], ["Get"]),
    "EquipmentFanModuleStats": MoMeta("EquipmentFanModuleStats", "equipmentFanModuleStats", "stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentFanModule'], [u'equipmentFanModuleStatsHist'], [None]),
    "EquipmentFanModuleStatsHist": MoMeta("EquipmentFanModuleStatsHist", "equipmentFanModuleStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentFanModuleStats'], [], [None]),
    "EquipmentFanStats": MoMeta("EquipmentFanStats", "equipmentFanStats", "stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentFan'], [u'equipmentFanStatsHist'], [None]),
    "EquipmentFanStatsHist": MoMeta("EquipmentFanStatsHist", "equipmentFanStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentFanStats'], [], [None]),
    "EquipmentFex": MoMeta("EquipmentFex", "equipmentFex", "fex-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], [u'computeSystem'], [u'equipmentBeaconLed', u'equipmentFan', u'equipmentFexEnvStats', u'equipmentFexOperation', u'equipmentFexPowerSummary', u'equipmentHealthLed', u'equipmentIOCard', u'equipmentIndicatorLed', u'equipmentLocatorLed', u'equipmentPsu', u'faultInst', u'firmwareStatus'], ["Get"]),
    "EquipmentFexCapProvider": MoMeta("EquipmentFexCapProvider", "equipmentFexCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [u'equipmentFruVariant', u'equipmentManufacturingDef', u'equipmentPicture'], ["Get"]),
    "EquipmentFexEnvStats": MoMeta("EquipmentFexEnvStats", "equipmentFexEnvStats", "env-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentFex'], [u'equipmentFexEnvStatsHist'], [None]),
    "EquipmentFexEnvStatsHist": MoMeta("EquipmentFexEnvStatsHist", "equipmentFexEnvStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentFexEnvStats'], [], [None]),
    "EquipmentFexOperation": MoMeta("EquipmentFexOperation", "equipmentFexOperation", "remote-oper", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentFex'], [u'faultInst'], ["Get", "Set"]),
    "EquipmentFexPowerSummary": MoMeta("EquipmentFexPowerSummary", "equipmentFexPowerSummary", "power-summary", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentFex'], [u'equipmentFexPowerSummaryHist'], ["Get"]),
    "EquipmentFexPowerSummaryHist": MoMeta("EquipmentFexPowerSummaryHist", "equipmentFexPowerSummaryHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentFexPowerSummary'], [], [None]),
    "EquipmentFexPsuInputStats": MoMeta("EquipmentFexPsuInputStats", "equipmentFexPsuInputStats", "fex-psu-input-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentPsu'], [u'equipmentFexPsuInputStatsHist'], [None]),
    "EquipmentFexPsuInputStatsHist": MoMeta("EquipmentFexPsuInputStatsHist", "equipmentFexPsuInputStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentFexPsuInputStats'], [], [None]),
    "EquipmentFruVariant": MoMeta("EquipmentFruVariant", "equipmentFruVariant", "fruVariant-[type]", VersionMeta.Version201b, "InputOutput", 0x1, [], [""], [u'adaptorFruCapProvider', u'diagSrvCapProvider', u'equipmentBladeCapProvider', u'equipmentChassisCapProvider', u'equipmentFanModuleCapProvider', u'equipmentFexCapProvider', u'equipmentGemCapProvider', u'equipmentHostIfCapProvider', u'equipmentIOCardCapProvider', u'equipmentLocalDiskCapProvider', u'equipmentLocalDiskControllerCapProvider', u'equipmentMemoryUnitCapProvider', u'equipmentProcessorUnitCapProvider', u'equipmentPsuCapProvider', u'equipmentRackUnitCapProvider', u'equipmentServerUnitCapProvider', u'equipmentSwitchCapProvider', u'equipmentSwitchIOCardCapProvider', u'equipmentSystemFruCapProvider'], [], ["get"]),
    "EquipmentGemCapProvider": MoMeta("EquipmentGemCapProvider", "equipmentGemCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [u'equipmentFruVariant', u'equipmentManufacturingDef', u'equipmentPicture', u'equipmentUnifiedPortCapProvider'], ["Get"]),
    "EquipmentHealthLed": MoMeta("EquipmentHealthLed", "equipmentHealthLed", "health-led", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'computeBlade', u'computeExtBoard', u'computeRackUnit', u'computeServerUnit', u'equipmentChassis', u'equipmentFanModule', u'equipmentFex', u'equipmentIOCard', u'equipmentPsu'], [], ["Get"]),
    "EquipmentHostIfCapProvider": MoMeta("EquipmentHostIfCapProvider", "equipmentHostIfCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [u'equipmentFruVariant', u'equipmentManufacturingDef', u'equipmentPicture'], ["Get"]),
    "EquipmentIOCard": MoMeta("EquipmentIOCard", "equipmentIOCard", "slot-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassis', u'equipmentFex'], [u'equipmentBeaconLed', u'equipmentHealthLed', u'equipmentIOCardStats', u'equipmentIndicatorLed', u'equipmentLocatorLed', u'faultInst', u'firmwareStatus', u'mgmtController', u'portGroup'], ["Get", "Set"]),
    "EquipmentIOCardCapProvider": MoMeta("EquipmentIOCardCapProvider", "equipmentIOCardCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [u'equipmentFruVariant', u'equipmentManufacturingDef', u'equipmentPicture'], ["Get"]),
    "EquipmentIOCardStats": MoMeta("EquipmentIOCardStats", "equipmentIOCardStats", "stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentIOCard'], [u'equipmentIOCardStatsHist'], [None]),
    "EquipmentIOCardStatsHist": MoMeta("EquipmentIOCardStatsHist", "equipmentIOCardStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentIOCardStats'], [], [None]),
    "EquipmentImpliedStorageEnclosureDef": MoMeta("EquipmentImpliedStorageEnclosureDef", "equipmentImpliedStorageEnclosureDef", "enclosure-def-[enclosure_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], [""], [u'equipmentStorageProcessorCap'], [], ["Get"]),
    "EquipmentIndicatorLed": MoMeta("EquipmentIndicatorLed", "equipmentIndicatorLed", "indicator-led-[id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy", "read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'equipmentChassis', u'equipmentFanModule', u'equipmentFex', u'equipmentIOCard', u'equipmentPsu'], [], ["Get"]),
    "EquipmentInstance": MoMeta("EquipmentInstance", "equipmentInstance", "inst-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], [u'equipmentChassisRequirement'], [u'cpmaintAck', u'equipmentChassisIssues'], ["Get"]),
    "EquipmentInstanceMapping": MoMeta("EquipmentInstanceMapping", "equipmentInstanceMapping", "instmap-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'computeSystem'], [], ["Get"]),
    "EquipmentLocalDiskCapProvider": MoMeta("EquipmentLocalDiskCapProvider", "equipmentLocalDiskCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [u'equipmentFruVariant', u'equipmentLocalDiskDef', u'equipmentManufacturingDef', u'equipmentPicture'], ["Get"]),
    "EquipmentLocalDiskControllerCapProvider": MoMeta("EquipmentLocalDiskControllerCapProvider", "equipmentLocalDiskControllerCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [u'equipmentDriveSecCap', u'equipmentFruVariant', u'equipmentManufacturingDef', u'equipmentPciDef', u'equipmentPicture'], ["Get"]),
    "EquipmentLocalDiskDef": MoMeta("EquipmentLocalDiskDef", "equipmentLocalDiskDef", "disk", VersionMeta.Version111a, "InputOutput", 0x1, [], [""], [u'equipmentLocalDiskCapProvider'], [], ["Get"]),
    "EquipmentLocalTemplDef": MoMeta("EquipmentLocalTemplDef", "equipmentLocalTemplDef", "inst-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'equipmentTemplate'], [], [None]),
    "EquipmentLocatorLed": MoMeta("EquipmentLocatorLed", "equipmentLocatorLed", "locator-led", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy", "read-only"], [u'computeBlade', u'computeExtBoard', u'computeRackUnit', u'computeServerUnit', u'equipmentChassis', u'equipmentFanModule', u'equipmentFex', u'equipmentIOCard', u'equipmentPsu', u'networkElement', u'storageLocalDisk'], [u'equipmentLocatorLedOperation'], ["Get", "Set"]),
    "EquipmentLocatorLedOperation": MoMeta("EquipmentLocatorLedOperation", "equipmentLocatorLedOperation", "remote-oper", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentLocatorLed'], [u'faultInst'], ["Get", "Set"]),
    "EquipmentManufacturingDef": MoMeta("EquipmentManufacturingDef", "equipmentManufacturingDef", "manufacturing", VersionMeta.Version101a, "InputOutput", 0x1, [], [""], [u'adaptorFruCapProvider', u'diagSrvCapProvider', u'equipmentBladeCapProvider', u'equipmentChassisCapProvider', u'equipmentFanModuleCapProvider', u'equipmentFexCapProvider', u'equipmentGemCapProvider', u'equipmentHostIfCapProvider', u'equipmentIOCardCapProvider', u'equipmentLocalDiskCapProvider', u'equipmentLocalDiskControllerCapProvider', u'equipmentMemoryUnitCapProvider', u'equipmentProcessorUnitCapProvider', u'equipmentPsuCapProvider', u'equipmentRackUnitCapProvider', u'equipmentServerUnitCapProvider', u'equipmentSwitchCapProvider', u'equipmentSwitchIOCardCapProvider', u'equipmentSystemFruCapProvider'], [], ["Get"]),
    "EquipmentMemoryUnitCapProvider": MoMeta("EquipmentMemoryUnitCapProvider", "equipmentMemoryUnitCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [u'equipmentFruVariant', u'equipmentManufacturingDef', u'equipmentPicture'], ["Get"]),
    "EquipmentNetworkElementFanStats": MoMeta("EquipmentNetworkElementFanStats", "equipmentNetworkElementFanStats", "stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentFan'], [u'equipmentNetworkElementFanStatsHist'], [None]),
    "EquipmentNetworkElementFanStatsHist": MoMeta("EquipmentNetworkElementFanStatsHist", "equipmentNetworkElementFanStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentNetworkElementFanStats'], [], [None]),
    "EquipmentPciDef": MoMeta("EquipmentPciDef", "equipmentPciDef", "pci-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], [""], [u'equipmentLocalDiskControllerCapProvider'], [], ["Get"]),
    "EquipmentPhysicalQual": MoMeta("EquipmentPhysicalQual", "equipmentPhysicalQual", "physicalqual", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'equipmentQual'], [], [None]),
    "EquipmentPicture": MoMeta("EquipmentPicture", "equipmentPicture", "picture-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], [""], [u'adaptorFruCapProvider', u'diagSrvCapProvider', u'equipmentBladeCapProvider', u'equipmentChassisCapProvider', u'equipmentFanModuleCapProvider', u'equipmentFexCapProvider', u'equipmentGemCapProvider', u'equipmentHostIfCapProvider', u'equipmentIOCardCapProvider', u'equipmentLocalDiskCapProvider', u'equipmentLocalDiskControllerCapProvider', u'equipmentMemoryUnitCapProvider', u'equipmentProcessorUnitCapProvider', u'equipmentPsuCapProvider', u'equipmentRackUnitCapProvider', u'equipmentServerUnitCapProvider', u'equipmentSwitchCapProvider', u'equipmentSwitchIOCardCapProvider', u'equipmentSystemFruCapProvider'], [], ["Get"]),
    "EquipmentPool": MoMeta("EquipmentPool", "equipmentPool", "equipment-pool-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [], [None]),
    "EquipmentPoolable": MoMeta("EquipmentPoolable", "equipmentPoolable", "chassis-pool-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "EquipmentPoolingPolicy": MoMeta("EquipmentPoolingPolicy", "equipmentPoolingPolicy", "chassis-pooling-policy-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [], [None]),
    "EquipmentProcessorUnitCapProvider": MoMeta("EquipmentProcessorUnitCapProvider", "equipmentProcessorUnitCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [u'equipmentFruVariant', u'equipmentManufacturingDef', u'equipmentPicture'], ["Get"]),
    "EquipmentPsu": MoMeta("EquipmentPsu", "equipmentPsu", "psu-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'computeRackUnit', u'equipmentChassis', u'equipmentFex', u'networkElement'], [u'equipmentBeaconLed', u'equipmentFexPsuInputStats', u'equipmentHealthLed', u'equipmentIndicatorLed', u'equipmentLocatorLed', u'equipmentPsuInputStats', u'equipmentPsuOutputStats', u'equipmentPsuStats', u'equipmentRackUnitPsuStats', u'faultInst', u'firmwareBootDefinition', u'firmwareRunning', u'firmwareStatus', u'firmwareUpdatable'], ["Get"]),
    "EquipmentPsuCapProvider": MoMeta("EquipmentPsuCapProvider", "equipmentPsuCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [u'equipmentFruVariant', u'equipmentManufacturingDef', u'equipmentPicture'], ["Get"]),
    "EquipmentPsuInputStats": MoMeta("EquipmentPsuInputStats", "equipmentPsuInputStats", "input-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentPsu'], [u'equipmentPsuInputStatsHist'], [None]),
    "EquipmentPsuInputStatsHist": MoMeta("EquipmentPsuInputStatsHist", "equipmentPsuInputStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentPsuInputStats'], [], [None]),
    "EquipmentPsuOutputStats": MoMeta("EquipmentPsuOutputStats", "equipmentPsuOutputStats", "output-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentPsu'], [u'equipmentPsuOutputStatsHist'], [None]),
    "EquipmentPsuOutputStatsHist": MoMeta("EquipmentPsuOutputStatsHist", "equipmentPsuOutputStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentPsuOutputStats'], [], [None]),
    "EquipmentPsuStats": MoMeta("EquipmentPsuStats", "equipmentPsuStats", "stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentPsu'], [u'equipmentPsuStatsHist'], [None]),
    "EquipmentPsuStatsHist": MoMeta("EquipmentPsuStatsHist", "equipmentPsuStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentPsuStats'], [], [None]),
    "EquipmentQual": MoMeta("EquipmentQual", "equipmentQual", "chassis-qualifier-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'orgOrg'], [u'equipmentChassisQual', u'equipmentPhysicalQual'], [None]),
    "EquipmentRackUnitCapProvider": MoMeta("EquipmentRackUnitCapProvider", "equipmentRackUnitCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [u'equipmentAdvancedBootOrder', u'equipmentCimcVmedia', u'equipmentDriveSecCap', u'equipmentFruVariant', u'equipmentManufacturingDef', u'equipmentPicture', u'equipmentSecureBoot', u'equipmentServerFeatureCap', u'equipmentStorageProcessorCap'], ["Get"]),
    "EquipmentRackUnitFanStats": MoMeta("EquipmentRackUnitFanStats", "equipmentRackUnitFanStats", "stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentFan'], [u'equipmentRackUnitFanStatsHist'], [None]),
    "EquipmentRackUnitFanStatsHist": MoMeta("EquipmentRackUnitFanStatsHist", "equipmentRackUnitFanStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentRackUnitFanStats'], [], [None]),
    "EquipmentRackUnitPsuStats": MoMeta("EquipmentRackUnitPsuStats", "equipmentRackUnitPsuStats", "rackunit-power-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'equipmentPsu'], [u'equipmentRackUnitPsuStatsHist'], [None]),
    "EquipmentRackUnitPsuStatsHist": MoMeta("EquipmentRackUnitPsuStatsHist", "equipmentRackUnitPsuStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentRackUnitPsuStats'], [], [None]),
    "EquipmentRequirement": MoMeta("EquipmentRequirement", "equipmentRequirement", "chassis-req", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy", "read-only"], [u'equipmentChassisProfile'], [u'faultInst'], ["Get"]),
    "EquipmentSecureBoot": MoMeta("EquipmentSecureBoot", "equipmentSecureBoot", "secBoot", VersionMeta.Version121a, "InputOutput", 0x1, [], [""], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider', u'equipmentServerUnitCapProvider'], [], ["Get"]),
    "EquipmentServerFeatureCap": MoMeta("EquipmentServerFeatureCap", "equipmentServerFeatureCap", "server-feature-cap", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider', u'equipmentServerUnitCapProvider'], [], ["Get"]),
    "EquipmentServerUnitCapProvider": MoMeta("EquipmentServerUnitCapProvider", "equipmentServerUnitCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [u'equipmentAdvancedBootOrder', u'equipmentCimcVmedia', u'equipmentFruVariant', u'equipmentManufacturingDef', u'equipmentPicture', u'equipmentSecureBoot', u'equipmentServerFeatureCap', u'equipmentStorageProcessorCap'], ["Get"]),
    "EquipmentSharedIOModule": MoMeta("EquipmentSharedIOModule", "equipmentSharedIOModule", "shared-io-module", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassis', u'equipmentSystemIOController'], [u'mgmtController', u'portGroup'], ["Get"]),
    "EquipmentSiocTempStats": MoMeta("EquipmentSiocTempStats", "equipmentSiocTempStats", "temp-stats", VersionMeta.Version151a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], [u'equipmentSiocTempStatsHist'], ["Get"]),
    "EquipmentSiocTempStatsHist": MoMeta("EquipmentSiocTempStatsHist", "equipmentSiocTempStatsHist", "[id]", VersionMeta.Version151a, "OutputOnly", 0x1, [], ["read-only"], [u'equipmentSiocTempStats'], [], ["Get"]),
    "EquipmentStorageProcessorCap": MoMeta("EquipmentStorageProcessorCap", "equipmentStorageProcessorCap", "storage-proc-cap", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'equipmentBladeCapProvider', u'equipmentRackUnitCapProvider', u'equipmentServerUnitCapProvider'], [u'equipmentImpliedStorageEnclosureDef'], ["Get"]),
    "EquipmentSwitchCapProvider": MoMeta("EquipmentSwitchCapProvider", "equipmentSwitchCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [u'equipmentBreakoutCap', u'equipmentFruVariant', u'equipmentManufacturingDef', u'equipmentPicture', u'equipmentUnifiedPortCapProvider'], ["Get"]),
    "EquipmentSwitchCard": MoMeta("EquipmentSwitchCard", "equipmentSwitchCard", "slot-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'networkElement'], [u'portGroup'], ["Get"]),
    "EquipmentSwitchIOCard": MoMeta("EquipmentSwitchIOCard", "equipmentSwitchIOCard", "sw-slot-[id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassis'], [u'mgmtController', u'portGroup'], ["Get"]),
    "EquipmentSwitchIOCardCapProvider": MoMeta("EquipmentSwitchIOCardCapProvider", "equipmentSwitchIOCardCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [u'equipmentFruVariant', u'equipmentManufacturingDef', u'equipmentPicture', u'equipmentUnifiedPortCapProvider'], ["Get"]),
    "EquipmentSystemFruCapProvider": MoMeta("EquipmentSystemFruCapProvider", "equipmentSystemFruCapProvider", "manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [u'equipmentFruVariant', u'equipmentManufacturingDef', u'equipmentPicture'], ["Get"]),
    "EquipmentSystemIOController": MoMeta("EquipmentSystemIOController", "equipmentSystemIOController", "slot-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassis'], [u'computeBoardController', u'equipmentSharedIOModule', u'equipmentSystemIOControllerOperation', u'mgmtController'], ["Get"]),
    "EquipmentSystemIOControllerOperation": MoMeta("EquipmentSystemIOControllerOperation", "equipmentSystemIOControllerOperation", "remote-oper", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentSystemIOController'], [u'faultInst'], ["Get", "Set"]),
    "EquipmentTemplate": MoMeta("EquipmentTemplate", "equipmentTemplate", "chassis-templ-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'equipmentChassisProfile', u'equipmentLocalTemplDef'], ["Get"]),
    "EquipmentTemplateMapping": MoMeta("EquipmentTemplateMapping", "equipmentTemplateMapping", "chassis-templmap-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'computeSystem'], [], ["Get"]),
    "EquipmentTier": MoMeta("EquipmentTier", "equipmentTier", "cp-tier-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy"], [u'orgOrg'], [u'equipmentChassisProfile'], [None]),
    "EquipmentUnifiedPortCapProvider": MoMeta("EquipmentUnifiedPortCapProvider", "equipmentUnifiedPortCapProvider", "unified-port-cap", VersionMeta.Version131a, "InputOutput", 0x1, [], [""], [u'equipmentGemCapProvider', u'equipmentSwitchCapProvider', u'equipmentSwitchIOCardCapProvider'], [], ["Get"]),
    "EquipmentXcvr": MoMeta("EquipmentXcvr", "equipmentXcvr", "transceiver", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'etherPIo', u'etherServerIntFIo', u'etherSwitchIntFIo', u'fcPIo'], [], ["Get"]),
    "EtherErrStats": MoMeta("EtherErrStats", "etherErrStats", "err-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'etherServerIntFIo'], [u'etherErrStatsHist'], [None]),
    "EtherErrStatsHist": MoMeta("EtherErrStatsHist", "etherErrStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'etherErrStats'], [], [None]),
    "EtherFcoeInterfaceStats": MoMeta("EtherFcoeInterfaceStats", "etherFcoeInterfaceStats", "fcoe-interface-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'fabricFcoeEstcEp'], [u'etherFcoeInterfaceStatsHist'], [None]),
    "EtherFcoeInterfaceStatsHist": MoMeta("EtherFcoeInterfaceStatsHist", "etherFcoeInterfaceStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'etherFcoeInterfaceStats'], [], [None]),
    "EtherLossStats": MoMeta("EtherLossStats", "etherLossStats", "loss-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'etherServerIntFIo'], [u'etherLossStatsHist'], [None]),
    "EtherLossStatsHist": MoMeta("EtherLossStatsHist", "etherLossStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'etherLossStats'], [], [None]),
    "EtherPIo": MoMeta("EtherPIo", "etherPIo", "port-[port_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'portGroup', u'portSubGroup'], [u'equipmentXcvr'], ["Get"]),
    "EtherPauseStats": MoMeta("EtherPauseStats", "etherPauseStats", "pause-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'etherServerIntFIo'], [u'etherPauseStatsHist'], [None]),
    "EtherPauseStatsHist": MoMeta("EtherPauseStatsHist", "etherPauseStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'etherPauseStats'], [], [None]),
    "EtherRxStats": MoMeta("EtherRxStats", "etherRxStats", "rx-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'etherServerIntFIo'], [u'etherRxStatsHist'], [None]),
    "EtherRxStatsHist": MoMeta("EtherRxStatsHist", "etherRxStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'etherRxStats'], [], [None]),
    "EtherServerIntFIo": MoMeta("EtherServerIntFIo", "etherServerIntFIo", "port-[port_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'diagSrvCtrl', u'portGroup'], [u'equipmentXcvr', u'etherErrStats', u'etherLossStats', u'etherPauseStats', u'etherRxStats', u'etherTxStats', u'faultInst'], ["Get"]),
    "EtherSwitchIntFIo": MoMeta("EtherSwitchIntFIo", "etherSwitchIntFIo", "pc-[port_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'portGroup'], [u'equipmentXcvr'], ["Get"]),
    "EtherTxStats": MoMeta("EtherTxStats", "etherTxStats", "tx-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'etherServerIntFIo'], [u'etherTxStatsHist'], [None]),
    "EtherTxStatsHist": MoMeta("EtherTxStatsHist", "etherTxStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'etherTxStats'], [], [None]),
    "EventApplication": MoMeta("EventApplication", "eventApplication", "type-[type]ip-[ip]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "EventEpCtrl": MoMeta("EventEpCtrl", "eventEpCtrl", "evctrl", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "fault", "operations"], [], [], ["Get"]),
    "EventHolder": MoMeta("EventHolder", "eventHolder", "event", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'eventPolicy'], ["Get"]),
    "EventInst": MoMeta("EventInst", "eventInst", "event-[id]", VersionMeta.Version101a, "OutputOnly", 0x1, [], ["read-only"], [u'aaaAuthRealm', u'aaaLdapEp', u'aaaRadiusEp', u'aaaTacacsPlusEp', u'aaaUserEp', u'callhomeHolder', u'certRepairEp', u'changeEp', u'commDateTime', u'commSvcEp', u'computeSystem', u'configBackup', u'configConsumerCatalogue', u'consumerInst', u'controllerEp', u'diagSrvCtrlOperation', u'domainProfile', u'dupeChangeTrackerEp', u'equipmentChassisProfile', u'extpolClient', u'extpolEp', u'fabricDceSwSrvPcOperation', u'fabricEthEstcEpOperation', u'fabricEthEstcPcOperation', u'fabricEthLanEpOperation', u'fabricEthLanPcOperation', u'fabricEthMonOperation', u'fabricFcEstcEpOperation', u'fabricFcMonOperation', u'fabricFcSanEpOperation', u'fabricFcSanPcOperation', u'fabricFcZoneProfile', u'fabricFcoeEstcEpOperation', u'fabricFcoeSanEpOperation', u'fabricFcoeSanPcOperation', u'fabricVnetEpSyncEp', u'fdBlade', u'fdRackUnit', u'firmwareDistributable', u'firmwareDownloader', u'glIdentCtxResOp', u'glRequest', u'glRequestVnetEp', u'glRequestVnetEpDomainEp', u'identIdentRequest', u'identMetaSystem', u'licenseDownloader', u'licenseFile', u'licenseInstance', u'lsServer', u'mgmtBackup', u'mgmtBackupTrigger', u'mgmtDataExporter', u'mgmtDataImporter', u'mgmtIf', u'mgmtImporter', u'mgmtRegistryInfo', u'networkElement', u'nfsClientDef', u'nfsExportDef', u'observeObserved', u'orgOrg', u'pkiEp', u'policyControlEpOp', u'policyPolicyScope', u'smartlicenseAgent', u'smartlicenseEntitlementEp', u'smartlicenseHolder', u'smartlicenseTest', u'sysdebugAutoCoreFileExportTarget', u'sysdebugLogControlEp', u'sysdebugManualCoreFileExportTarget', u'sysdebugTechSupport', u'sysfileMutation', u'testingServiceProfile', u'topSystem', u'vnicOutbandMgmtEp'], [], ["Get"]),
    "EventLog": MoMeta("EventLog", "eventLog", "event-log", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "fault", "operations"], [u'topRoot'], [u'eventRecord'], ["Get"]),
    "EventPolicy": MoMeta("EventPolicy", "eventPolicy", "event-policy", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "read-only"], [u'eventHolder'], [], ["Get"]),
    "EventRecord": MoMeta("EventRecord", "eventRecord", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'eventLog'], [], ["Get"]),
    "ExtmgmtArpTargets": MoMeta("ExtmgmtArpTargets", "extmgmtArpTargets", "arp-target-policy", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "ext-lan-config"], [u'extmgmtIfMonPolicy'], [], ["Add", "Get", "Set"]),
    "ExtmgmtGatewayPing": MoMeta("ExtmgmtGatewayPing", "extmgmtGatewayPing", "gw-ping-policy", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "ext-lan-config"], [u'extmgmtIfMonPolicy'], [], ["Add", "Get", "Set"]),
    "ExtmgmtIfMonPolicy": MoMeta("ExtmgmtIfMonPolicy", "extmgmtIfMonPolicy", "extmgmt-intf-monitor-policy", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "ext-lan-config"], [u'orgDomainGroup', u'policyDeviceProfile'], [u'extmgmtArpTargets', u'extmgmtGatewayPing', u'extmgmtMiiStatus', u'extmgmtNdiscTargets'], ["Add", "Get", "Remove", "Set"]),
    "ExtmgmtMiiStatus": MoMeta("ExtmgmtMiiStatus", "extmgmtMiiStatus", "mii-status-policy", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "ext-lan-config"], [u'extmgmtIfMonPolicy'], [], ["Add", "Get", "Set"]),
    "ExtmgmtNdiscTargets": MoMeta("ExtmgmtNdiscTargets", "extmgmtNdiscTargets", "ndisc-target-policy", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "ext-lan-config"], [u'extmgmtIfMonPolicy'], [], ["Get", "Set"]),
    "ExtpolClient": MoMeta("ExtpolClient", "extpolClient", "client-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'extpolClientCont'], [u'dupeEp', u'eventInst', u'extpolClientFsm', u'extpolClientFsmTask', u'fabricVnetEpSyncEp', u'faultInst', u'mgmtBackup', u'observeObserved', u'policyConfigError', u'policyPolicyScopeCont', u'statsInventoryMeta'], ["Get", "Remove"]),
    "ExtpolClientCont": MoMeta("ExtpolClientCont", "extpolClientCont", "clients", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'extpolRegistry'], [u'extpolClient', u'extpolDomain', u'extpolHBStatus'], ["Get"]),
    "ExtpolClientFsm": MoMeta("ExtpolClientFsm", "extpolClientFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'extpolClient'], [u'extpolClientFsmStage'], [None]),
    "ExtpolClientFsmStage": MoMeta("ExtpolClientFsmStage", "extpolClientFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'extpolClientFsm'], [], [None]),
    "ExtpolClientFsmTask": MoMeta("ExtpolClientFsmTask", "extpolClientFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], [u'extpolClient'], [], [None]),
    "ExtpolController": MoMeta("ExtpolController", "extpolController", "contro-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'extpolControllerCont'], [u'dupeEp', u'faultInst', u'observeObserved', u'policyPolicyScopeCont'], ["Get"]),
    "ExtpolControllerCont": MoMeta("ExtpolControllerCont", "extpolControllerCont", "controllers", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'extpolRegistry'], [u'extpolController'], ["Get"]),
    "ExtpolDomain": MoMeta("ExtpolDomain", "extpolDomain", "domain-[guid]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'extpolClientCont'], [u'changeEp', u'computeChassisFeatMask', u'computeEnvFeatMask', u'computeNetworkFeatMask', u'computeServerFeatMask', u'computeStorageFeatMask', u'domainChassisFeature', u'domainEnvironmentFeature', u'domainNetworkFeature', u'domainServerFeature', u'domainStorageFeature', u'lstorageBlade'], ["Get"]),
    "ExtpolEp": MoMeta("ExtpolEp", "extpolEp", "extpol", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'eventInst', u'extpolEpFsm', u'extpolEpFsmTask', u'extpolRegistry', u'faultInst', u'faultSummary'], ["Get"]),
    "ExtpolEpFsm": MoMeta("ExtpolEpFsm", "extpolEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'extpolEp'], [u'extpolEpFsmStage'], [None]),
    "ExtpolEpFsmStage": MoMeta("ExtpolEpFsmStage", "extpolEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'extpolEpFsm'], [], [None]),
    "ExtpolEpFsmTask": MoMeta("ExtpolEpFsmTask", "extpolEpFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'extpolEp'], [], [None]),
    "ExtpolHBStatus": MoMeta("ExtpolHBStatus", "extpolHBStatus", "hb-status", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin"], [u'extpolClientCont'], [], [None]),
    "ExtpolProvider": MoMeta("ExtpolProvider", "extpolProvider", "prov-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'extpolProviderCont'], [u'dupeEp', u'faultInst', u'observeObserved', u'policyPolicyScopeCont'], ["Get"]),
    "ExtpolProviderCont": MoMeta("ExtpolProviderCont", "extpolProviderCont", "providers", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'extpolRegistry'], [u'extpolProvider'], ["Get"]),
    "ExtpolRegistry": MoMeta("ExtpolRegistry", "extpolRegistry", "reg", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'extpolEp'], [u'dupeEp', u'extpolClientCont', u'extpolControllerCont', u'extpolProviderCont', u'extpolRegistryCapability', u'faultInst', u'observeObserved', u'policyPolicyScopeCont'], ["Get"]),
    "ExtpolRegistryCapability": MoMeta("ExtpolRegistryCapability", "extpolRegistryCapability", "cap", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], [u'extpolRegistry'], [], ["Get"]),
    "ExtpolSystemContext": MoMeta("ExtpolSystemContext", "extpolSystemContext", "sysctx", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ExtpolVersionHolder": MoMeta("ExtpolVersionHolder", "extpolVersionHolder", "versionHolder-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "ExtvmmNetworkSets": MoMeta("ExtvmmNetworkSets", "extvmmNetworkSets", "network-sets", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'fabricLanCloud'], [], ["Get"]),
    "ExtvmmVMNetworkSets": MoMeta("ExtvmmVMNetworkSets", "extvmmVMNetworkSets", "vm-network-sets", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'fabricLanCloud'], [], ["Get"]),
    "FabricBreakout": MoMeta("FabricBreakout", "fabricBreakout", "breakout-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy"], [u'fabricCablingSw'], [], ["Get"]),
    "FabricBreakoutOperation": MoMeta("FabricBreakoutOperation", "fabricBreakoutOperation", "remoper-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy"], [u'fabricCablingSw'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricCabling": MoMeta("FabricCabling", "fabricCabling", "Cabling", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy"], [u'fabricEp'], [u'fabricCablingSw', u'statsThresholdPolicy'], ["Get"]),
    "FabricCablingSw": MoMeta("FabricCablingSw", "fabricCablingSw", "[id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy"], [u'fabricCabling'], [u'fabricBreakout', u'fabricBreakoutOperation'], ["Get"]),
    "FabricCartridgeSlotEp": MoMeta("FabricCartridgeSlotEp", "fabricCartridgeSlotEp", "cart-slot-[slot_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'fabricChassisEp'], [u'fabricCartridgeSlotEpOperation', u'fabricComputeMSlotEp'], ["Get", "Set"]),
    "FabricCartridgeSlotEpOperation": MoMeta("FabricCartridgeSlotEpOperation", "fabricCartridgeSlotEpOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'fabricCartridgeSlotEp'], [u'faultInst'], ["Get", "Set"]),
    "FabricCdpLinkPolicy": MoMeta("FabricCdpLinkPolicy", "fabricCdpLinkPolicy", "", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "read-only"], [], [], ["Get", "Set"]),
    "FabricChangedObjectRef": MoMeta("FabricChangedObjectRef", "fabricChangedObjectRef", "ChangedObjectRef[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'fabricVnetEpSyncEp'], [u'faultInst'], [None]),
    "FabricChassisEp": MoMeta("FabricChassisEp", "fabricChassisEp", "chassis-[chassis_id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [u'fabricDceSrv'], [u'fabricCartridgeSlotEp', u'fabricComputeSlotEp', u'fabricEnclosureSlotEp'], ["Get"]),
    "FabricComputeMSlotEp": MoMeta("FabricComputeMSlotEp", "fabricComputeMSlotEp", "ins-[server_instance_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'fabricCartridgeSlotEp'], [], ["Get", "Set"]),
    "FabricComputePhEp": MoMeta("FabricComputePhEp", "fabricComputePhEp", "compute-ep-ven-[vendor]-mod-[model]-ser-[serial]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'fabricDceSrv'], [u'fabricComputePhEpOperation'], ["Get", "Set"]),
    "FabricComputePhEpOperation": MoMeta("FabricComputePhEpOperation", "fabricComputePhEpOperation", "remote-oper", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'fabricComputePhEp'], [u'faultInst'], ["Get", "Set"]),
    "FabricComputeSlotEp": MoMeta("FabricComputeSlotEp", "fabricComputeSlotEp", "slot-[slot_id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'fabricChassisEp'], [u'fabricComputeSlotEpOperation'], ["Get", "Set"]),
    "FabricComputeSlotEpOperation": MoMeta("FabricComputeSlotEpOperation", "fabricComputeSlotEpOperation", "remote-oper", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'fabricComputeSlotEp'], [u'faultInst'], ["Get", "Set"]),
    "FabricConsumer": MoMeta("FabricConsumer", "fabricConsumer", "ucsm-[client_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'adaptorVlan', u'fabricVlan', u'fabricVlanEp', u'fabricVsan', u'fabricVsanEp'], [], ["Get", "Remove"]),
    "FabricDceSrv": MoMeta("FabricDceSrv", "fabricDceSrv", "server", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], [u'fabricEp'], [u'fabricChassisEp', u'fabricComputePhEp', u'fabricDceSwSrv', u'fabricEnclosurePhEp', u'fabricSwChPhEp', u'statsThresholdPolicy'], ["Get"]),
    "FabricDceSwSrv": MoMeta("FabricDceSwSrv", "fabricDceSwSrv", "sw-[id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], [u'fabricDceSrv'], [u'fabricDceSwSrvEp', u'fabricDceSwSrvEpOperation', u'fabricDceSwSrvPc', u'fabricDceSwSrvPcOperation', u'fabricSubGroup'], ["Get"]),
    "FabricDceSwSrvEp": MoMeta("FabricDceSwSrvEp", "fabricDceSwSrvEp", "slot-[slot_id]-port-[port_id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'fabricDceSwSrv', u'fabricSubGroup'], [u'fabricEthMonSrcEp', u'fabricEthMonSrcEpOperation'], ["Add", "Get", "Remove", "Set"]),
    "FabricDceSwSrvEpOperation": MoMeta("FabricDceSwSrvEpOperation", "fabricDceSwSrvEpOperation", "remoper-slot-[slot_id]-port-[port_id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'fabricDceSwSrv', u'fabricSubGroup'], [u'faultInst'], ["Get", "Set"]),
    "FabricDceSwSrvPc": MoMeta("FabricDceSwSrvPc", "fabricDceSwSrvPc", "pc-[port_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'fabricDceSwSrv'], [u'fabricDceSwSrvPcEp', u'fabricSubGroup'], ["Get"]),
    "FabricDceSwSrvPcEp": MoMeta("FabricDceSwSrvPcEp", "fabricDceSwSrvPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'fabricDceSwSrvPc', u'fabricSubGroup'], [], ["Get"]),
    "FabricDceSwSrvPcEpOperation": MoMeta("FabricDceSwSrvPcEpOperation", "fabricDceSwSrvPcEpOperation", "remoper-ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'fabricDceSwSrvPcOperation', u'fabricSubGroup'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricDceSwSrvPcOperation": MoMeta("FabricDceSwSrvPcOperation", "fabricDceSwSrvPcOperation", "remoper-pc-[port_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'fabricDceSwSrv'], [u'eventInst', u'fabricDceSwSrvPcEpOperation', u'fabricDceSwSrvPcOperationFsm', u'fabricEthPortOperationFsm', u'fabricFIPortOperationFsm', u'fabricFIPortOperationFsmTask', u'fabricSubGroup', u'faultInst', u'messageEp', u'vnicEther'], ["Add", "Get", "Remove", "Set"]),
    "FabricDceSwSrvPcOperationFsm": MoMeta("FabricDceSwSrvPcOperationFsm", "fabricDceSwSrvPcOperationFsm", "fsm", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], [u'fabricDceSwSrvPcOperation'], [u'fabricDceSwSrvPcOperationFsmStage'], [None]),
    "FabricDceSwSrvPcOperationFsmStage": MoMeta("FabricDceSwSrvPcOperationFsmStage", "fabricDceSwSrvPcOperationFsmStage", "stage-[name]", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], [u'fabricDceSwSrvPcOperationFsm'], [], [None]),
    "FabricDomainEp": MoMeta("FabricDomainEp", "fabricDomainEp", "domain-ep", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'fabricHolder'], [u'fabricSystem', u'policyControlEpOp'], ["Get"]),
    "FabricEnclosurePhEp": MoMeta("FabricEnclosurePhEp", "fabricEnclosurePhEp", "enc-ep-ven-[vendor]-mod-[model]-ser-[serial]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'fabricDceSrv'], [u'fabricEnclosurePhEpOperation', u'fabricLastAckedSlot'], ["Get"]),
    "FabricEnclosurePhEpOperation": MoMeta("FabricEnclosurePhEpOperation", "fabricEnclosurePhEpOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'fabricEnclosurePhEp'], [u'faultInst'], ["Get", "Set"]),
    "FabricEnclosureSlotEp": MoMeta("FabricEnclosureSlotEp", "fabricEnclosureSlotEp", "enc-slot-[slot_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'fabricChassisEp'], [u'fabricEnclosureSlotEpOperation'], ["Get"]),
    "FabricEnclosureSlotEpOperation": MoMeta("FabricEnclosureSlotEpOperation", "fabricEnclosureSlotEpOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'fabricEnclosureSlotEp'], [u'faultInst'], ["Get", "Set"]),
    "FabricEp": MoMeta("FabricEp", "fabricEp", "fabric", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'computeSystem', u'fabricSystem', u'orgDomainGroup'], [u'fabricCabling', u'fabricDceSrv', u'fabricEthEstcCloud', u'fabricFcEstcCloud', u'fabricLanAccessMgr', u'fabricLanCloud', u'fabricLanMonCloud', u'fabricSanCloud', u'fabricSanMonCloud'], ["Get"]),
    "FabricEthEstc": MoMeta("FabricEthEstc", "fabricEthEstc", "[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricEthEstcCloud'], [u'fabricEthEstcEp', u'fabricEthEstcEpOperation', u'fabricEthEstcPc', u'fabricEthEstcPcOperation', u'fabricSubGroup'], ["Get"]),
    "FabricEthEstcCloud": MoMeta("FabricEthEstcCloud", "fabricEthEstcCloud", "eth-estc", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEp'], [u'fabricEthEstc', u'fabricVlan', u'nwctrlDefinition', u'statsThresholdPolicy'], ["Get"]),
    "FabricEthEstcEp": MoMeta("FabricEthEstcEp", "fabricEthEstcEp", "phys-eth-slot-[slot_id]-port-[port_id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthEstc', u'fabricSubGroup'], [u'fabricEthMonSrcEp', u'fabricEthTargetEp', u'fabricVlanEp', u'faultInst'], ["Get", "Set"]),
    "FabricEthEstcEpOperation": MoMeta("FabricEthEstcEpOperation", "fabricEthEstcEpOperation", "remoper-phys-eth-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthEstc', u'fabricSubGroup'], [u'eventInst', u'fabricEthEstcEpOperationFsm', u'fabricEthMonSrcEpOperation', u'fabricEthPortOperationFsm', u'fabricEthTargetEpOperation', u'fabricFIPortOperationFsm', u'fabricFIPortOperationFsmTask', u'faultInst', u'messageEp', u'vnicEther'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthEstcEpOperationFsm": MoMeta("FabricEthEstcEpOperationFsm", "fabricEthEstcEpOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricEthEstcEpOperation'], [u'fabricEthEstcEpOperationFsmStage'], [None]),
    "FabricEthEstcEpOperationFsmStage": MoMeta("FabricEthEstcEpOperationFsmStage", "fabricEthEstcEpOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricEthEstcEpOperationFsm'], [], [None]),
    "FabricEthEstcPc": MoMeta("FabricEthEstcPc", "fabricEthEstcPc", "pc-[port_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthEstc'], [u'fabricEthEstcPcEp', u'fabricEthMonSrcEp', u'fabricEthMonSrcEpOperation', u'fabricEthTargetEp', u'fabricSubGroup', u'fabricVlanEp', u'faultInst'], ["Get"]),
    "FabricEthEstcPcEp": MoMeta("FabricEthEstcPcEp", "fabricEthEstcPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthEstcPc', u'fabricSubGroup'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricEthEstcPcEpOperation": MoMeta("FabricEthEstcPcEpOperation", "fabricEthEstcPcEpOperation", "remoper-ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthEstcPcOperation', u'fabricSubGroup'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthEstcPcOperation": MoMeta("FabricEthEstcPcOperation", "fabricEthEstcPcOperation", "remoper-pc-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthEstc'], [u'eventInst', u'fabricEthEstcPcEpOperation', u'fabricEthEstcPcOperationFsm', u'fabricEthPortOperationFsm', u'fabricEthTargetEpOperation', u'fabricFIPortOperationFsm', u'fabricFIPortOperationFsmTask', u'fabricSubGroup', u'faultInst', u'messageEp', u'vnicEther'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthEstcPcOperationFsm": MoMeta("FabricEthEstcPcOperationFsm", "fabricEthEstcPcOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricEthEstcPcOperation'], [u'fabricEthEstcPcOperationFsmStage'], [None]),
    "FabricEthEstcPcOperationFsmStage": MoMeta("FabricEthEstcPcOperationFsmStage", "fabricEthEstcPcOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricEthEstcPcOperationFsm'], [], [None]),
    "FabricEthLan": MoMeta("FabricEthLan", "fabricEthLan", "[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricLanCloud'], [u'fabricEthLanEp', u'fabricEthLanEpOperation', u'fabricEthLanPc', u'fabricEthLanPcOperation', u'fabricNetGroup', u'fabricSubGroup'], ["Get"]),
    "FabricEthLanEp": MoMeta("FabricEthLanEp", "fabricEthLanEp", "phys-slot-[slot_id]-port-[port_id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthLan', u'fabricSubGroup'], [u'fabricEthMonSrcEp', u'fabricNetGroupEp', u'fabricVlanEp', u'faultInst'], ["Get", "Set"]),
    "FabricEthLanEpOperation": MoMeta("FabricEthLanEpOperation", "fabricEthLanEpOperation", "remoper-phys-slot-[slot_id]-port-[port_id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthLan', u'fabricSubGroup'], [u'eventInst', u'fabricEthLanEpOperationFsm', u'fabricEthMonSrcEpOperation', u'fabricEthPortOperationFsm', u'fabricFIPortOperationFsm', u'fabricFIPortOperationFsmTask', u'faultInst', u'messageEp', u'vnicEther'], ["Get", "Set"]),
    "FabricEthLanEpOperationFsm": MoMeta("FabricEthLanEpOperationFsm", "fabricEthLanEpOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricEthLanEpOperation'], [u'fabricEthLanEpOperationFsmStage'], [None]),
    "FabricEthLanEpOperationFsmStage": MoMeta("FabricEthLanEpOperationFsmStage", "fabricEthLanEpOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricEthLanEpOperationFsm'], [], [None]),
    "FabricEthLanPc": MoMeta("FabricEthLanPc", "fabricEthLanPc", "pc-[port_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthLan'], [u'fabricEthLanPcEp', u'fabricEthMonSrcEp', u'fabricNetGroupEp', u'fabricSubGroup', u'fabricVlanEp', u'faultInst'], ["Get"]),
    "FabricEthLanPcEp": MoMeta("FabricEthLanPcEp", "fabricEthLanPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthLanPc', u'fabricSubGroup'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthLanPcEpOperation": MoMeta("FabricEthLanPcEpOperation", "fabricEthLanPcEpOperation", "remoper-ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthLanPcOperation', u'fabricSubGroup'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthLanPcOperation": MoMeta("FabricEthLanPcOperation", "fabricEthLanPcOperation", "remoper-pc-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthLan'], [u'eventInst', u'fabricEthLanPcEpOperation', u'fabricEthLanPcOperationFsm', u'fabricEthMonSrcEpOperation', u'fabricEthPortOperationFsm', u'fabricFIPortOperationFsm', u'fabricFIPortOperationFsmTask', u'fabricSubGroup', u'faultInst', u'messageEp', u'vnicEther'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthLanPcOperationFsm": MoMeta("FabricEthLanPcOperationFsm", "fabricEthLanPcOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricEthLanPcOperation'], [u'fabricEthLanPcOperationFsmStage'], [None]),
    "FabricEthLanPcOperationFsmStage": MoMeta("FabricEthLanPcOperationFsmStage", "fabricEthLanPcOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricEthLanPcOperationFsm'], [], [None]),
    "FabricEthLinkProfile": MoMeta("FabricEthLinkProfile", "fabricEthLinkProfile", "eth-link-prof-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricLanCloud', u'orgDomainGroup'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthMon": MoMeta("FabricEthMon", "fabricEthMon", "eth-mon-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthMonLan'], [u'fabricEthMonDestEp', u'fabricEthMonSrcRef', u'fabricSubGroup'], ["Get"]),
    "FabricEthMonDestEp": MoMeta("FabricEthMonDestEp", "fabricEthMonDestEp", "dest-slot-[slot_id]-port-[port_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthMon', u'fabricEthMonOperation', u'fabricFcMon', u'fabricSubGroup'], [], ["Get"]),
    "FabricEthMonDestEpOperation": MoMeta("FabricEthMonDestEpOperation", "fabricEthMonDestEpOperation", "remoper-dest-slot-[slot_id]-port-[port_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthMonOperation', u'fabricFcMonOperation', u'fabricSubGroup'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthMonLan": MoMeta("FabricEthMonLan", "fabricEthMonLan", "[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricLanMonCloud'], [u'fabricEthMon', u'fabricEthMonOperation'], ["Get"]),
    "FabricEthMonOperation": MoMeta("FabricEthMonOperation", "fabricEthMonOperation", "remoper-eth-mon-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthMonLan'], [u'eventInst', u'fabricEthMonDestEp', u'fabricEthMonDestEpOperation', u'fabricEthMonOperationFsm', u'fabricEthPortOperationFsm', u'fabricFIPortOperationFsm', u'fabricFIPortOperationFsmTask', u'fabricSubGroup', u'faultInst', u'messageEp', u'vnicEther'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthMonOperationFsm": MoMeta("FabricEthMonOperationFsm", "fabricEthMonOperationFsm", "fsm", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], [u'fabricEthMonOperation'], [u'fabricEthMonOperationFsmStage'], [None]),
    "FabricEthMonOperationFsmStage": MoMeta("FabricEthMonOperationFsmStage", "fabricEthMonOperationFsmStage", "stage-[name]", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], [u'fabricEthMonOperationFsm'], [], [None]),
    "FabricEthMonSrcEp": MoMeta("FabricEthMonSrcEp", "fabricEthMonSrcEp", "mon-src-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'adaptorExtEthIf', u'fabricDceSwSrvEp', u'fabricEthEstcEp', u'fabricEthEstcPc', u'fabricEthLanEp', u'fabricEthLanPc', u'fabricFcoeEstcEp', u'fabricFcoeSanEp', u'fabricFcoeSanPc', u'fabricVlan', u'vmNic', u'vnicEther', u'vnicFc', u'vnicIScsi', u'vnicIScsiLCP', u'vnicIniGrpFc', u'vnicIniGrpFcB', u'vnicLstorageIScsi', u'vnicMgmt', u'vnicMonSesFc'], [], ["Get"]),
    "FabricEthMonSrcEpOperation": MoMeta("FabricEthMonSrcEpOperation", "fabricEthMonSrcEpOperation", "remoper-mon-src-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'adaptorExtEthIf', u'fabricDceSwSrvEp', u'fabricEthEstcEpOperation', u'fabricEthEstcPc', u'fabricEthLanEpOperation', u'fabricEthLanPcOperation', u'fabricFcoeEstcEpOperation', u'fabricFcoeSanEpOperation', u'fabricFcoeSanPcOperation', u'fabricVlan', u'vnicEther'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthMonSrcRef": MoMeta("FabricEthMonSrcRef", "fabricEthMonSrcRef", "src-ref-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthMon'], [], ["Get"]),
    "FabricEthPortOperationFsm": MoMeta("FabricEthPortOperationFsm", "fabricEthPortOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricDceSwSrvPcOperation', u'fabricEthEstcEpOperation', u'fabricEthEstcPcOperation', u'fabricEthLanEpOperation', u'fabricEthLanPcOperation', u'fabricEthMonOperation'], [u'fabricEthPortOperationFsmStage'], [None]),
    "FabricEthPortOperationFsmStage": MoMeta("FabricEthPortOperationFsmStage", "fabricEthPortOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricEthPortOperationFsm'], [], [None]),
    "FabricEthTargetEp": MoMeta("FabricEthTargetEp", "fabricEthTargetEp", "eth-target-ep-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthEstcEp', u'fabricEthEstcPc'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricEthTargetEpOperation": MoMeta("FabricEthTargetEpOperation", "fabricEthTargetEpOperation", "remoper-eth-target-ep-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthEstcEpOperation', u'fabricEthEstcPcOperation'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricEthVlanPc": MoMeta("FabricEthVlanPc", "fabricEthVlanPc", "pc-switch-[switch_id]-pc-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricNetGroup', u'fabricVlan'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricEthVlanPortEp": MoMeta("FabricEthVlanPortEp", "fabricEthVlanPortEp", "phys-switch-[switch_id]-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricNetGroup', u'fabricSwSubGroup', u'fabricVlan'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricEtherRef": MoMeta("FabricEtherRef", "fabricEtherRef", "EtherRef-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ls-network"], [u'adaptorVlan', u'fabricVlan', u'fabricVlanEp', u'fabricVsan', u'fabricVsanEp'], [], [None]),
    "FabricExtension": MoMeta("FabricExtension", "fabricExtension", "extension", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy"], [u'fabricVlan', u'fabricVsan'], [], [None]),
    "FabricFIPortOperationFsm": MoMeta("FabricFIPortOperationFsm", "fabricFIPortOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricDceSwSrvPcOperation', u'fabricEthEstcEpOperation', u'fabricEthEstcPcOperation', u'fabricEthLanEpOperation', u'fabricEthLanPcOperation', u'fabricEthMonOperation', u'fabricFcEstcEpOperation', u'fabricFcMonOperation', u'fabricFcSanEpOperation', u'fabricFcSanPcOperation', u'fabricFcoeEstcEpOperation', u'fabricFcoeSanEpOperation', u'fabricFcoeSanPcOperation'], [u'fabricFIPortOperationFsmStage'], [None]),
    "FabricFIPortOperationFsmStage": MoMeta("FabricFIPortOperationFsmStage", "fabricFIPortOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricFIPortOperationFsm'], [], [None]),
    "FabricFIPortOperationFsmTask": MoMeta("FabricFIPortOperationFsmTask", "fabricFIPortOperationFsmTask", "task-[item]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricDceSwSrvPcOperation', u'fabricEthEstcEpOperation', u'fabricEthEstcPcOperation', u'fabricEthLanEpOperation', u'fabricEthLanPcOperation', u'fabricEthMonOperation', u'fabricFcEstcEpOperation', u'fabricFcMonOperation', u'fabricFcSanEpOperation', u'fabricFcSanPcOperation', u'fabricFcoeEstcEpOperation', u'fabricFcoeSanEpOperation', u'fabricFcoeSanPcOperation'], [], [None]),
    "FabricFcEndpoint": MoMeta("FabricFcEndpoint", "fabricFcEndpoint", "endpoint-[wwpn]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcUserZone'], [], [None]),
    "FabricFcEstc": MoMeta("FabricFcEstc", "fabricFcEstc", "[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcEstcCloud'], [u'fabricFcEstcEp', u'fabricFcEstcEpOperation', u'fabricFcoeEstcEp', u'fabricFcoeEstcEpOperation', u'fabricSubGroup', u'fabricVsan'], ["Get"]),
    "FabricFcEstcCloud": MoMeta("FabricFcEstcCloud", "fabricFcEstcCloud", "fc-estc", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricEp'], [u'fabricFcEstc', u'fabricFcZoneProfile', u'fabricFcZoneProfileIvt', u'fabricVsan', u'statsThresholdPolicy'], ["Get"]),
    "FabricFcEstcEp": MoMeta("FabricFcEstcEp", "fabricFcEstcEp", "phys-fc-slot-[slot_id]-port-[port_id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcEstc'], [u'fabricFcMonSrcEp', u'fabricVsanEp'], ["Get", "Set"]),
    "FabricFcEstcEpOperation": MoMeta("FabricFcEstcEpOperation", "fabricFcEstcEpOperation", "remoper-phys-fc-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcEstc'], [u'eventInst', u'fabricFIPortOperationFsm', u'fabricFIPortOperationFsmTask', u'fabricFcEstcEpOperationFsm', u'fabricFcMonSrcEpOperation', u'fabricFcPortOperationFsm', u'faultInst', u'messageEp', u'vnicFc', u'vnicMonSesFc'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcEstcEpOperationFsm": MoMeta("FabricFcEstcEpOperationFsm", "fabricFcEstcEpOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricFcEstcEpOperation'], [u'fabricFcEstcEpOperationFsmStage'], [None]),
    "FabricFcEstcEpOperationFsmStage": MoMeta("FabricFcEstcEpOperationFsmStage", "fabricFcEstcEpOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricFcEstcEpOperationFsm'], [], [None]),
    "FabricFcMon": MoMeta("FabricFcMon", "fabricFcMon", "fc-mon-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcMonSan'], [u'fabricEthMonDestEp', u'fabricFcMonDestEp', u'fabricFcMonSrcRef', u'fabricSubGroup'], ["Get"]),
    "FabricFcMonDestEp": MoMeta("FabricFcMonDestEp", "fabricFcMonDestEp", "dest-slot-[slot_id]-port-[port_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcMon', u'fabricFcMonOperation'], [], ["Get"]),
    "FabricFcMonDestEpOperation": MoMeta("FabricFcMonDestEpOperation", "fabricFcMonDestEpOperation", "remoper-dest-slot-[slot_id]-port-[port_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricFcMonOperation', u'fabricSubGroup'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcMonOperation": MoMeta("FabricFcMonOperation", "fabricFcMonOperation", "remoper-fc-mon-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcMonSan'], [u'eventInst', u'fabricEthMonDestEpOperation', u'fabricFIPortOperationFsm', u'fabricFIPortOperationFsmTask', u'fabricFcMonDestEp', u'fabricFcMonDestEpOperation', u'fabricFcMonOperationFsm', u'fabricFcPortOperationFsm', u'fabricSubGroup', u'faultInst', u'messageEp', u'vnicFc', u'vnicMonSesFc'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcMonOperationFsm": MoMeta("FabricFcMonOperationFsm", "fabricFcMonOperationFsm", "fsm", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], [u'fabricFcMonOperation'], [u'fabricFcMonOperationFsmStage'], [None]),
    "FabricFcMonOperationFsmStage": MoMeta("FabricFcMonOperationFsmStage", "fabricFcMonOperationFsmStage", "stage-[name]", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], [u'fabricFcMonOperationFsm'], [], [None]),
    "FabricFcMonSan": MoMeta("FabricFcMonSan", "fabricFcMonSan", "[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricSanMonCloud'], [u'fabricFcMon', u'fabricFcMonOperation'], ["Get"]),
    "FabricFcMonSrcEp": MoMeta("FabricFcMonSrcEp", "fabricFcMonSrcEp", "mon-src-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcEstcEp', u'fabricFcSanEp', u'fabricFcSanPc', u'fabricVsan', u'vmNic', u'vnicEther', u'vnicFc', u'vnicIScsi', u'vnicIScsiLCP', u'vnicIniGrpFc', u'vnicIniGrpFcB', u'vnicLstorageIScsi', u'vnicMgmt', u'vnicMonSesFc'], [], ["Get"]),
    "FabricFcMonSrcEpOperation": MoMeta("FabricFcMonSrcEpOperation", "fabricFcMonSrcEpOperation", "remoper-mon-src-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricFcEstcEpOperation', u'fabricFcSanEpOperation', u'fabricFcSanPcOperation', u'fabricVsan', u'vnicFc'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcMonSrcRef": MoMeta("FabricFcMonSrcRef", "fabricFcMonSrcRef", "src-ref-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricFcMon'], [], ["Get"]),
    "FabricFcPortOperationFsm": MoMeta("FabricFcPortOperationFsm", "fabricFcPortOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricFcEstcEpOperation', u'fabricFcMonOperation', u'fabricFcSanEpOperation', u'fabricFcSanPcOperation', u'fabricFcoeEstcEpOperation', u'fabricFcoeSanEpOperation', u'fabricFcoeSanPcOperation'], [u'fabricFcPortOperationFsmStage'], [None]),
    "FabricFcPortOperationFsmStage": MoMeta("FabricFcPortOperationFsmStage", "fabricFcPortOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricFcPortOperationFsm'], [], [None]),
    "FabricFcSan": MoMeta("FabricFcSan", "fabricFcSan", "[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricSanCloud'], [u'fabricFcSanEp', u'fabricFcSanEpOperation', u'fabricFcSanPc', u'fabricFcSanPcOperation', u'fabricFcoeSanEp', u'fabricFcoeSanEpOperation', u'fabricFcoeSanPc', u'fabricFcoeSanPcOperation', u'fabricSubGroup', u'fabricVsan'], ["Get", "Set"]),
    "FabricFcSanEp": MoMeta("FabricFcSanEp", "fabricFcSanEp", "phys-slot-[slot_id]-port-[port_id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcSan'], [u'fabricFcMonSrcEp', u'fabricVsanEp', u'fabricVsanMembership'], ["Add", "Get", "Set"]),
    "FabricFcSanEpOperation": MoMeta("FabricFcSanEpOperation", "fabricFcSanEpOperation", "remoper-phys-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcSan'], [u'eventInst', u'fabricFIPortOperationFsm', u'fabricFIPortOperationFsmTask', u'fabricFcMonSrcEpOperation', u'fabricFcPortOperationFsm', u'fabricFcSanEpOperationFsm', u'faultInst', u'messageEp', u'vnicFc', u'vnicMonSesFc'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcSanEpOperationFsm": MoMeta("FabricFcSanEpOperationFsm", "fabricFcSanEpOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricFcSanEpOperation'], [u'fabricFcSanEpOperationFsmStage'], [None]),
    "FabricFcSanEpOperationFsmStage": MoMeta("FabricFcSanEpOperationFsmStage", "fabricFcSanEpOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricFcSanEpOperationFsm'], [], [None]),
    "FabricFcSanPc": MoMeta("FabricFcSanPc", "fabricFcSanPc", "pc-[port_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcSan'], [u'fabricFcMonSrcEp', u'fabricFcSanPcEp', u'fabricVsanEp'], [None]),
    "FabricFcSanPcEp": MoMeta("FabricFcSanPcEp", "fabricFcSanPcEp", "ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcSanPc'], [], ["Get"]),
    "FabricFcSanPcEpOperation": MoMeta("FabricFcSanPcEpOperation", "fabricFcSanPcEpOperation", "remoper-ep-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcSanPcOperation'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcSanPcOperation": MoMeta("FabricFcSanPcOperation", "fabricFcSanPcOperation", "remoper-pc-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcSan'], [u'eventInst', u'fabricFIPortOperationFsm', u'fabricFIPortOperationFsmTask', u'fabricFcMonSrcEpOperation', u'fabricFcPortOperationFsm', u'fabricFcSanPcEpOperation', u'fabricFcSanPcOperationFsm', u'faultInst', u'messageEp', u'vnicFc', u'vnicMonSesFc'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcSanPcOperationFsm": MoMeta("FabricFcSanPcOperationFsm", "fabricFcSanPcOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricFcSanPcOperation'], [u'fabricFcSanPcOperationFsmStage'], [None]),
    "FabricFcSanPcOperationFsmStage": MoMeta("FabricFcSanPcOperationFsmStage", "fabricFcSanPcOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricFcSanPcOperationFsm'], [], [None]),
    "FabricFcUplinkOperation": MoMeta("FabricFcUplinkOperation", "fabricFcUplinkOperation", "remote-oper", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricSanCloud'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcUserZone": MoMeta("FabricFcUserZone", "fabricFcUserZone", "zone-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcZoneProfile'], [u'fabricFcEndpoint', u'messageEp', u'storageVsanRef'], [None]),
    "FabricFcUserZoneIvt": MoMeta("FabricFcUserZoneIvt", "fabricFcUserZoneIvt", "zone-ivt-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcZoneProfileIvt'], [u'storageVsanRefIvt'], [None]),
    "FabricFcVsanPc": MoMeta("FabricFcVsanPc", "fabricFcVsanPc", "pc-switch-[switch_id]-pc-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricVsan'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricFcVsanPortEp": MoMeta("FabricFcVsanPortEp", "fabricFcVsanPortEp", "phys-switch-[switch_id]-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricVsan'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricFcZoneProfile": MoMeta("FabricFcZoneProfile", "fabricFcZoneProfile", "zone-profile-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcEstcCloud'], [u'eventInst', u'fabricFcUserZone', u'fabricFcZoneProfileFsm', u'fabricFcZoneProfileFsmTask', u'faultInst'], [None]),
    "FabricFcZoneProfileFsm": MoMeta("FabricFcZoneProfileFsm", "fabricFcZoneProfileFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'fabricFcZoneProfile'], [u'fabricFcZoneProfileFsmStage'], [None]),
    "FabricFcZoneProfileFsmStage": MoMeta("FabricFcZoneProfileFsmStage", "fabricFcZoneProfileFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'fabricFcZoneProfileFsm'], [], [None]),
    "FabricFcZoneProfileFsmTask": MoMeta("FabricFcZoneProfileFsmTask", "fabricFcZoneProfileFsmTask", "task-[item]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'fabricFcZoneProfile'], [], [None]),
    "FabricFcZoneProfileIvt": MoMeta("FabricFcZoneProfileIvt", "fabricFcZoneProfileIvt", "zone-profile-ivt-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcEstcCloud'], [u'fabricFcUserZoneIvt'], [None]),
    "FabricFcoeEstcEp": MoMeta("FabricFcoeEstcEp", "fabricFcoeEstcEp", "phys-fcoe-slot-[slot_id]-port-[port_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcEstc', u'fabricSubGroup'], [u'etherFcoeInterfaceStats', u'fabricEthMonSrcEp', u'fabricVsanEp', u'fabricVsanMembership', u'faultInst'], ["Get", "Set"]),
    "FabricFcoeEstcEpOperation": MoMeta("FabricFcoeEstcEpOperation", "fabricFcoeEstcEpOperation", "remoper-phys-fcoe-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcEstc', u'fabricSubGroup'], [u'eventInst', u'fabricEthMonSrcEpOperation', u'fabricFIPortOperationFsm', u'fabricFIPortOperationFsmTask', u'fabricFcPortOperationFsm', u'fabricFcoeEstcEpOperationFsm', u'faultInst', u'messageEp', u'vnicFc', u'vnicMonSesFc'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcoeEstcEpOperationFsm": MoMeta("FabricFcoeEstcEpOperationFsm", "fabricFcoeEstcEpOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricFcoeEstcEpOperation'], [u'fabricFcoeEstcEpOperationFsmStage'], [None]),
    "FabricFcoeEstcEpOperationFsmStage": MoMeta("FabricFcoeEstcEpOperationFsmStage", "fabricFcoeEstcEpOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricFcoeEstcEpOperationFsm'], [], [None]),
    "FabricFcoeSanEp": MoMeta("FabricFcoeSanEp", "fabricFcoeSanEp", "phys-fcoesanep-slot-[slot_id]-port-[port_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcSan', u'fabricSubGroup'], [u'fabricEthMonSrcEp', u'fabricVsanEp', u'fabricVsanMembership', u'faultInst'], ["Get", "Set"]),
    "FabricFcoeSanEpOperation": MoMeta("FabricFcoeSanEpOperation", "fabricFcoeSanEpOperation", "remoper-phys-fcoesanep-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcSan', u'fabricSubGroup'], [u'eventInst', u'fabricEthMonSrcEpOperation', u'fabricFIPortOperationFsm', u'fabricFIPortOperationFsmTask', u'fabricFcPortOperationFsm', u'fabricFcoeSanEpOperationFsm', u'faultInst', u'messageEp', u'vnicFc', u'vnicMonSesFc'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcoeSanEpOperationFsm": MoMeta("FabricFcoeSanEpOperationFsm", "fabricFcoeSanEpOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricFcoeSanEpOperation'], [u'fabricFcoeSanEpOperationFsmStage'], [None]),
    "FabricFcoeSanEpOperationFsmStage": MoMeta("FabricFcoeSanEpOperationFsmStage", "fabricFcoeSanEpOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricFcoeSanEpOperationFsm'], [], [None]),
    "FabricFcoeSanPc": MoMeta("FabricFcoeSanPc", "fabricFcoeSanPc", "fcoesanpc-[port_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcSan'], [u'fabricEthMonSrcEp', u'fabricFcoeSanPcEp', u'fabricSubGroup', u'faultInst'], [None]),
    "FabricFcoeSanPcEp": MoMeta("FabricFcoeSanPcEp", "fabricFcoeSanPcEp", "fcoesanpcep-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcoeSanPc', u'fabricSubGroup'], [u'faultInst'], ["Get"]),
    "FabricFcoeSanPcEpOperation": MoMeta("FabricFcoeSanPcEpOperation", "fabricFcoeSanPcEpOperation", "remoper-fcoesanpcep-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcoeSanPcOperation', u'fabricSubGroup'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcoeSanPcOperation": MoMeta("FabricFcoeSanPcOperation", "fabricFcoeSanPcOperation", "remoper-fcoesanpc-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcSan'], [u'eventInst', u'fabricEthMonSrcEpOperation', u'fabricFIPortOperationFsm', u'fabricFIPortOperationFsmTask', u'fabricFcPortOperationFsm', u'fabricFcoeSanPcEpOperation', u'fabricFcoeSanPcOperationFsm', u'fabricSubGroup', u'faultInst', u'messageEp', u'vnicFc', u'vnicMonSesFc'], ["Add", "Get", "Remove", "Set"]),
    "FabricFcoeSanPcOperationFsm": MoMeta("FabricFcoeSanPcOperationFsm", "fabricFcoeSanPcOperationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricFcoeSanPcOperation'], [u'fabricFcoeSanPcOperationFsmStage'], [None]),
    "FabricFcoeSanPcOperationFsmStage": MoMeta("FabricFcoeSanPcOperationFsmStage", "fabricFcoeSanPcOperationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricFcoeSanPcOperationFsm'], [], [None]),
    "FabricFcoeVsanPc": MoMeta("FabricFcoeVsanPc", "fabricFcoeVsanPc", "fcoepc-switch-[switch_id]-fcoepc-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricVsan'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricFcoeVsanPortEp": MoMeta("FabricFcoeVsanPortEp", "fabricFcoeVsanPortEp", "phys-fcoe-switch-[switch_id]-slot-[slot_id]-port-[port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricSwSubGroup', u'fabricVsan'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricHolder": MoMeta("FabricHolder", "fabricHolder", "holder", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'fabricDomainEp', u'tagDefEp', u'tagInstanceEp'], ["Get"]),
    "FabricIf": MoMeta("FabricIf", "fabricIf", "mgmt-if-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "FabricLacpPolicy": MoMeta("FabricLacpPolicy", "fabricLacpPolicy", "lacp-[name]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'orgDomainGroup', u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricLanAccessMgr": MoMeta("FabricLanAccessMgr", "fabricLanAccessMgr", "lan-access", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'fabricEp'], [], [None]),
    "FabricLanCloud": MoMeta("FabricLanCloud", "fabricLanCloud", "lan", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEp'], [u'extvmmNetworkSets', u'extvmmVMNetworkSets', u'fabricEthLan', u'fabricEthLinkProfile', u'fabricLanPinGroup', u'fabricLanPinGroupOperation', u'fabricNetGroup', u'fabricUdldLinkPolicy', u'fabricVlan', u'firmwareAck', u'flowctrlDefinition', u'mgmtInbandProfile', u'qosclassDefinition', u'statsThresholdPolicy', u'vnicNetGroup', u'vnicProfileSet'], ["Get", "Set"]),
    "FabricLanCloudPolicy": MoMeta("FabricLanCloudPolicy", "fabricLanCloudPolicy", "lan-policy", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'orgDomainGroup', u'orgOrg'], [], ["Get", "Set"]),
    "FabricLanMonCloud": MoMeta("FabricLanMonCloud", "fabricLanMonCloud", "lanmon", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEp'], [u'fabricEthMonLan', u'statsThresholdPolicy'], ["Get"]),
    "FabricLanPinGroup": MoMeta("FabricLanPinGroup", "fabricLanPinGroup", "lan-pin-group-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricLanCloud'], [u'fabricLanPinTarget'], ["Get"]),
    "FabricLanPinGroupOperation": MoMeta("FabricLanPinGroupOperation", "fabricLanPinGroupOperation", "remoper-lan-pin-group-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricLanCloud'], [u'fabricLanPinTargetOperation', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricLanPinTarget": MoMeta("FabricLanPinTarget", "fabricLanPinTarget", "target-[fabric_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricLanPinGroup'], [], ["Get"]),
    "FabricLanPinTargetOperation": MoMeta("FabricLanPinTargetOperation", "fabricLanPinTargetOperation", "remoper-target-[fabric_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricLanPinGroupOperation'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricLastAckedSlot": MoMeta("FabricLastAckedSlot", "fabricLastAckedSlot", "last-acked-slot", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'fabricEnclosurePhEp'], [], ["Get"]),
    "FabricMulticastPolicy": MoMeta("FabricMulticastPolicy", "fabricMulticastPolicy", "mc-policy-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'orgDomainGroup'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricNetGroup": MoMeta("FabricNetGroup", "fabricNetGroup", "net-group-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ls-network"], [u'fabricEthLan', u'fabricLanCloud'], [u'fabricEthVlanPc', u'fabricEthVlanPortEp', u'fabricPooledVlan', u'fabricSwSubGroup'], ["Add", "Get", "Remove", "Set"]),
    "FabricNetGroupEp": MoMeta("FabricNetGroupEp", "fabricNetGroupEp", "ng-ep-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'fabricEthLanEp', u'fabricEthLanPc'], [], [None]),
    "FabricNetGroupPermit": MoMeta("FabricNetGroupPermit", "fabricNetGroupPermit", "ng-permit-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], [""], [u'orgOrg'], [], [None]),
    "FabricNetGroupRef": MoMeta("FabricNetGroupRef", "fabricNetGroupRef", "net-group-ref-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ls-config", "ls-network", "ls-server"], [u'dcxVc', u'vnicEther', u'vnicLanConnTempl', u'vnicSanConnTempl'], [u'faultInst'], [None]),
    "FabricNetGroupReq": MoMeta("FabricNetGroupReq", "fabricNetGroupReq", "ngreq-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ls-network"], [u'orgOrg'], [], [None]),
    "FabricOrgVlanPolicy": MoMeta("FabricOrgVlanPolicy", "fabricOrgVlanPolicy", "org-vlan-policy", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-network"], [u'orgOrg'], [], ["Get", "Set"]),
    "FabricPoolableVlan": MoMeta("FabricPoolableVlan", "fabricPoolableVlan", "pool-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "FabricPooledVlan": MoMeta("FabricPooledVlan", "fabricPooledVlan", "net-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricNetGroup'], [], ["Add", "Get", "Remove"]),
    "FabricSanCloud": MoMeta("FabricSanCloud", "fabricSanCloud", "san", VersionMeta.Version111a, "InputOutput", 0x1, [], [""], [u'fabricEp'], [u'fabricFcSan', u'fabricFcUplinkOperation', u'fabricSanPinGroup', u'fabricSanPinGroupOperation', u'firmwareAck', u'statsThresholdPolicy'], ["Get", "Set"]),
    "FabricSanGroup": MoMeta("FabricSanGroup", "fabricSanGroup", "san-group-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "FabricSanGroupRef": MoMeta("FabricSanGroupRef", "fabricSanGroupRef", "san-group-ref-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [u'dcxVc', u'vnicLanConnTempl', u'vnicSanConnTempl'], [u'faultInst'], [None]),
    "FabricSanMonCloud": MoMeta("FabricSanMonCloud", "fabricSanMonCloud", "sanmon", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricEp'], [u'fabricFcMonSan', u'statsThresholdPolicy'], ["Get"]),
    "FabricSanPinGroup": MoMeta("FabricSanPinGroup", "fabricSanPinGroup", "san-pin-group-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricSanCloud'], [u'fabricSanPinTarget'], ["Get"]),
    "FabricSanPinGroupOperation": MoMeta("FabricSanPinGroupOperation", "fabricSanPinGroupOperation", "remoper-san-pin-group-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricSanCloud'], [u'fabricSanPinTargetOperation', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricSanPinTarget": MoMeta("FabricSanPinTarget", "fabricSanPinTarget", "target-[fabric_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricSanPinGroup'], [], ["Get"]),
    "FabricSanPinTargetOperation": MoMeta("FabricSanPinTargetOperation", "fabricSanPinTargetOperation", "remoper-target-[fabric_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricSanPinGroupOperation'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricSubGroup": MoMeta("FabricSubGroup", "fabricSubGroup", "slot-[slot_id]-aggr-port-[aggr_port_id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy", "ls-network", "ls-network-policy"], [u'fabricDceSwSrv', u'fabricDceSwSrvPc', u'fabricDceSwSrvPcOperation', u'fabricEthEstc', u'fabricEthEstcPc', u'fabricEthEstcPcOperation', u'fabricEthLan', u'fabricEthLanPc', u'fabricEthLanPcOperation', u'fabricEthMon', u'fabricEthMonOperation', u'fabricFcEstc', u'fabricFcMon', u'fabricFcMonOperation', u'fabricFcSan', u'fabricFcoeSanPc', u'fabricFcoeSanPcOperation'], [u'fabricDceSwSrvEp', u'fabricDceSwSrvEpOperation', u'fabricDceSwSrvPcEp', u'fabricDceSwSrvPcEpOperation', u'fabricEthEstcEp', u'fabricEthEstcEpOperation', u'fabricEthEstcPcEp', u'fabricEthEstcPcEpOperation', u'fabricEthLanEp', u'fabricEthLanEpOperation', u'fabricEthLanPcEp', u'fabricEthLanPcEpOperation', u'fabricEthMonDestEp', u'fabricEthMonDestEpOperation', u'fabricFcMonDestEpOperation', u'fabricFcoeEstcEp', u'fabricFcoeEstcEpOperation', u'fabricFcoeSanEp', u'fabricFcoeSanEpOperation', u'fabricFcoeSanPcEp', u'fabricFcoeSanPcEpOperation'], ["Get", "Set"]),
    "FabricSwChPhEp": MoMeta("FabricSwChPhEp", "fabricSwChPhEp", "chassis-ep-ven-[vendor]-mod[model]-ser-[serial]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'fabricDceSrv'], [u'fabricSwChPhEpOperation'], ["Get", "Set"]),
    "FabricSwChPhEpOperation": MoMeta("FabricSwChPhEpOperation", "fabricSwChPhEpOperation", "remote-oper", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'fabricSwChPhEp'], [u'faultInst'], ["Get", "Set"]),
    "FabricSwSubGroup": MoMeta("FabricSwSubGroup", "fabricSwSubGroup", "sw-[switch_id]-slot-[slot_id]-aggr-port-[aggr_port_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'fabricNetGroup', u'fabricVlan', u'fabricVsan'], [u'fabricEthVlanPortEp', u'fabricFcoeVsanPortEp'], ["Get"]),
    "FabricSystem": MoMeta("FabricSystem", "fabricSystem", "system-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'fabricDomainEp'], [u'domainProfile', u'fabricEp', u'fdChassis', u'fdRackUnit', u'policyControlEp'], ["Get"]),
    "FabricUdldLinkPolicy": MoMeta("FabricUdldLinkPolicy", "fabricUdldLinkPolicy", "udld-link-pol-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "read-only"], [u'fabricLanCloud', u'orgDomainGroup'], [], ["Add", "Get", "Remove", "Set"]),
    "FabricUdldPolicy": MoMeta("FabricUdldPolicy", "fabricUdldPolicy", "udld-policy", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'orgOrg'], [], ["Get", "Set"]),
    "FabricVCon": MoMeta("FabricVCon", "fabricVCon", "vcon-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-policy", "ls-network", "ls-network-policy", "ls-server-policy", "ls-storage-policy"], [u'fabricVConProfile', u'lsServer'], [], ["Add", "Get", "Set"]),
    "FabricVConProfile": MoMeta("FabricVConProfile", "fabricVConProfile", "vcon-profile-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'fabricVCon'], ["Add", "Get", "Remove", "Set"]),
    "FabricVlan": MoMeta("FabricVlan", "fabricVlan", "net-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricEthEstcCloud', u'fabricLanCloud'], [u'fabricConsumer', u'fabricEthMonSrcEp', u'fabricEthMonSrcEpOperation', u'fabricEthVlanPc', u'fabricEthVlanPortEp', u'fabricEtherRef', u'fabricExtension', u'fabricSwSubGroup', u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "FabricVlanEp": MoMeta("FabricVlanEp", "fabricVlanEp", "vlan-[id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'fabricEthEstcEp', u'fabricEthEstcPc', u'fabricEthLanEp', u'fabricEthLanPc'], [u'fabricConsumer', u'fabricEtherRef'], ["Get"]),
    "FabricVlanGroupReq": MoMeta("FabricVlanGroupReq", "fabricVlanGroupReq", "vlan-group-req-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-network"], [u'orgOrg'], [], [None]),
    "FabricVlanPermit": MoMeta("FabricVlanPermit", "fabricVlanPermit", "vlan-permit-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], [""], [u'orgOrg'], [], [None]),
    "FabricVlanPermitItem": MoMeta("FabricVlanPermitItem", "fabricVlanPermitItem", "vlan-permit-item-[vlan_name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [], [u'configOrgItem'], [None]),
    "FabricVlanReq": MoMeta("FabricVlanReq", "fabricVlanReq", "vlan-req-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ls-network"], [u'orgOrg'], [], ["Add", "Get", "Remove"]),
    "FabricVnetEpSyncEp": MoMeta("FabricVnetEpSyncEp", "fabricVnetEpSyncEp", "syncEp", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'extpolClient'], [u'eventInst', u'fabricChangedObjectRef', u'fabricVnetEpSyncEpFsm', u'fabricVnetEpSyncEpFsmTask', u'faultInst'], [None]),
    "FabricVnetEpSyncEpFsm": MoMeta("FabricVnetEpSyncEpFsm", "fabricVnetEpSyncEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricVnetEpSyncEp'], [u'fabricVnetEpSyncEpFsmStage'], [None]),
    "FabricVnetEpSyncEpFsmStage": MoMeta("FabricVnetEpSyncEpFsmStage", "fabricVnetEpSyncEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'fabricVnetEpSyncEpFsm'], [], [None]),
    "FabricVnetEpSyncEpFsmTask": MoMeta("FabricVnetEpSyncEpFsmTask", "fabricVnetEpSyncEpFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], [u'fabricVnetEpSyncEp'], [], [None]),
    "FabricVsan": MoMeta("FabricVsan", "fabricVsan", "net-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy"], [u'fabricFcEstc', u'fabricFcEstcCloud', u'fabricFcSan'], [u'fabricConsumer', u'fabricEtherRef', u'fabricExtension', u'fabricFcMonSrcEp', u'fabricFcMonSrcEpOperation', u'fabricFcVsanPc', u'fabricFcVsanPortEp', u'fabricFcoeVsanPc', u'fabricFcoeVsanPortEp', u'fabricSwSubGroup'], ["Add", "Get", "Remove", "Set"]),
    "FabricVsanEp": MoMeta("FabricVsanEp", "fabricVsanEp", "vsan-[id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'fabricFcEstcEp', u'fabricFcSanEp', u'fabricFcSanPc', u'fabricFcoeEstcEp', u'fabricFcoeSanEp'], [u'fabricConsumer', u'fabricEtherRef'], ["Get"]),
    "FabricVsanMembership": MoMeta("FabricVsanMembership", "fabricVsanMembership", "vsanmember-[vsan_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'fabricFcSanEp', u'fabricFcoeEstcEp', u'fabricFcoeSanEp'], [], ["Get"]),
    "FaultDomainEp": MoMeta("FaultDomainEp", "faultDomainEp", "domainEp", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "fault", "operations"], [u'computeSystem'], [u'faultDomainInst', u'faultSummaryInst'], ["Get"]),
    "FaultDomainInst": MoMeta("FaultDomainInst", "faultDomainInst", "domain-fault-[fault_code]-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "fault", "operations"], [u'faultDomainEp'], [], ["Get"]),
    "FaultGlobalSeverityHolder": MoMeta("FaultGlobalSeverityHolder", "faultGlobalSeverityHolder", "faultholder", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'computeResourceAggrEp'], [], ["Get"]),
    "FaultGlobalTypedHolder": MoMeta("FaultGlobalTypedHolder", "faultGlobalTypedHolder", "type-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'computeResourceAggrEp'], [], ["Get"]),
    "FaultHolder": MoMeta("FaultHolder", "faultHolder", "fault", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "fault"], [u'topRoot'], [u'faultTypedHolder'], ["Get"]),
    "FaultInst": MoMeta("FaultInst", "faultInst", "fault-[code]", VersionMeta.Version101a, "OutputOnly", 0x1, [], ["admin", "fault", "operations"], [u'aaaAuthRealm', u'aaaLdapEp', u'aaaRadiusEp', u'aaaTacacsPlusEp', u'aaaUserEp', u'adaptorExtEthIfOperation', u'adaptorHostEthIf', u'adaptorHostEthIfOperation', u'adaptorHostFcIf', u'adaptorHostFcIfOperation', u'adaptorHostIscsiIf', u'adaptorHostIscsiIfOperation', u'adaptorHostScsiIf', u'adaptorUnit', u'adaptorVlan', u'callhomeHolder', u'certRepairEp', u'changeEp', u'commDateTime', u'commSvcEp', u'computeAutoconfigPolicy', u'computeBlade', u'computeBladeInheritPolicy', u'computeBoard', u'computeCartridgeOperation', u'computeChassisConnPolicyOperation', u'computeFactoryResetOp', u'computeGroupMembership', u'computeIOHub', u'computeInstance', u'computePhysicalOperation', u'computePool', u'computeRemoteOpStatus', u'computeSystem', u'configBackup', u'configConsumerCatalogue', u'configDbConfig', u'consumerInst', u'controllerEp', u'cpmaintAck', u'diagSrvCtrlOperation', u'domainProfile', u'dupeChangeTrackerEp', u'equipmentChassis', u'equipmentChassisOperation', u'equipmentChassisProfile', u'equipmentFan', u'equipmentFanModule', u'equipmentFex', u'equipmentFexOperation', u'equipmentIOCard', u'equipmentLocatorLedOperation', u'equipmentPsu', u'equipmentRequirement', u'equipmentSystemIOControllerOperation', u'etherServerIntFIo', u'extpolClient', u'extpolController', u'extpolEp', u'extpolProvider', u'extpolRegistry', u'fabricBreakoutOperation', u'fabricCartridgeSlotEpOperation', u'fabricChangedObjectRef', u'fabricComputePhEpOperation', u'fabricComputeSlotEpOperation', u'fabricDceSwSrvEpOperation', u'fabricDceSwSrvPcEpOperation', u'fabricDceSwSrvPcOperation', u'fabricEnclosurePhEpOperation', u'fabricEnclosureSlotEpOperation', u'fabricEthEstcEp', u'fabricEthEstcEpOperation', u'fabricEthEstcPc', u'fabricEthEstcPcEpOperation', u'fabricEthEstcPcOperation', u'fabricEthLanEp', u'fabricEthLanEpOperation', u'fabricEthLanPc', u'fabricEthLanPcEp', u'fabricEthLanPcEpOperation', u'fabricEthLanPcOperation', u'fabricEthLinkProfile', u'fabricEthMonDestEpOperation', u'fabricEthMonOperation', u'fabricEthMonSrcEpOperation', u'fabricEthTargetEpOperation', u'fabricFcEstcEpOperation', u'fabricFcMonDestEpOperation', u'fabricFcMonOperation', u'fabricFcMonSrcEpOperation', u'fabricFcSanEpOperation', u'fabricFcSanPcEpOperation', u'fabricFcSanPcOperation', u'fabricFcUplinkOperation', u'fabricFcZoneProfile', u'fabricFcoeEstcEp', u'fabricFcoeEstcEpOperation', u'fabricFcoeSanEp', u'fabricFcoeSanEpOperation', u'fabricFcoeSanPc', u'fabricFcoeSanPcEp', u'fabricFcoeSanPcEpOperation', u'fabricFcoeSanPcOperation', u'fabricLanPinGroupOperation', u'fabricLanPinTargetOperation', u'fabricNetGroupRef', u'fabricSanGroupRef', u'fabricSanPinGroupOperation', u'fabricSanPinTargetOperation', u'fabricSwChPhEpOperation', u'fabricVlan', u'fabricVnetEpSyncEp', u'fcpoolAddr', u'fcpoolInitiators', u'fdBlade', u'fdRackUnit', u'firmwareAck', u'firmwareDistributable', u'firmwareDownloadPolicy', u'firmwareDownloader', u'firmwareInfra', u'firmwareSource', u'glIdentCtxResOp', u'glRequest', u'glRequestVnetEp', u'glRequestVnetEpDomainEp', u'identIdentRequest', u'identMetaSystem', u'ippoolAddr', u'ippoolIpV6Addr', u'ippoolPool', u'iqnpoolAddr', u'iqnpoolPool', u'licenseDownloader', u'licenseFile', u'licenseInstance', u'lsBinding', u'lsIdentityInfo', u'lsIssues', u'lsRequirement', u'lsSPMeta', u'lsServer', u'lsServerOperation', u'lsmaintAck', u'lsmaintMaintPolicy', u'lstorageAck', u'lstorageCtrlServiceOperation', u'lstorageDasScsiLun', u'lstorageProfileBinding', u'macpoolAddr', u'macpoolPool', u'memoryArray', u'memoryBufferUnit', u'memoryUnit', u'mgmtBackup', u'mgmtBackupOperation', u'mgmtBackupPolicy', u'mgmtBackupTrigger', u'mgmtCfgExportPolicy', u'mgmtCmcSecureBootOperation', u'mgmtDataExporter', u'mgmtDataImporter', u'mgmtIf', u'mgmtImportItem', u'mgmtImporter', u'mgmtKmipOperation', u'mgmtRegistryInfo', u'networkElement', u'networkElementOperation', u'nfsClientDef', u'nfsExportDef', u'observeObserved', u'orgDomainGroupPolicy', u'orgOrg', u'pkiEp', u'pkiKeyRing', u'pkiTP', u'policyCommunicationOp', u'policyConfigBackupOp', u'policyConfigError', u'policyControlEpOp', u'policyControlEpOperation', u'policyDateTimeOp', u'policyDiscoveryOp', u'policyDnsOp', u'policyEquipmentOp', u'policyFaultOp', u'policyInfraFirmwareOp', u'policyMEpOp', u'policyMonitoringOp', u'policyPolicyScope', u'policyPortConfigOp', u'policyPowerMgmtOp', u'policyPsuOp', u'policySecurityOp', u'policyStorageAutoConfigOp', u'policySystemProfile', u'processorUnit', u'queryDependencyContext', u'queryImportContext', u'queryUsageContext', u'smartlicenseAgent', u'smartlicenseEntitlement', u'smartlicenseEntitlementEp', u'smartlicenseHolder', u'smartlicenseTest', u'storageComputeBladeOperation', u'storageConnectionDef', u'storageConnectionPolicy', u'storageController', u'storageControllerOperation', u'storageFlexFlashControllerOperation', u'storageIniGroup', u'storageInitiator', u'storageIpV4PooledAddr', u'storageItem', u'storageLocalDisk', u'storageLocalDiskOperation', u'storageLunReplica', u'storageLunSnapshot', u'storageMeta', u'storageScsiLun', u'storageVirtualDriveOperation', u'storageVirtualDriveRefOperation', u'storageVsanRef', u'sysdebugAutoCoreFileExportTarget', u'sysdebugCore', u'sysdebugLogControlEp', u'sysdebugManualCoreFileExportTarget', u'sysdebugTechSupport', u'sysdebugTechSupportOp', u'sysdebugTechSupportOperation', u'sysfileMutation', u'testingServiceProfile', u'topSystem', u'trigTest', u'uuidpoolAddr', u'uuidpoolPool', u'vmNic', u'vnicConnDef', u'vnicDynamicConPolicyRef', u'vnicEther', u'vnicEtherIf', u'vnicFault', u'vnicFc', u'vnicFcGroupDef', u'vnicFcGroupTempl', u'vnicFcIf', u'vnicFcNode', u'vnicIPv4PooledIscsiAddr', u'vnicIScsi', u'vnicIScsiBootVnic', u'vnicIScsiLCP', u'vnicIScsiNode', u'vnicIScsiStaticTargetIf', u'vnicIniGrpFc', u'vnicIniGrpFcB', u'vnicIpV4MgmtPooledAddr', u'vnicIpV4PooledAddr', u'vnicIpV6MgmtPooledAddr', u'vnicLanConnTempl', u'vnicLstorageIScsi', u'vnicMgmt', u'vnicMgmtIf', u'vnicMonSesFc', u'vnicOutbandMgmtEp', u'vnicSanConnTempl', u'vnicStorageEthLif', u'vnicUsnicConPolicyRef', u'vnicVmqConPolicyRef'], [], ["Get"]),
    "FaultLocalTypedHolder": MoMeta("FaultLocalTypedHolder", "faultLocalTypedHolder", "type-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "fault"], [u'computeSystem'], [], ["Get"]),
    "FaultPolicy": MoMeta("FaultPolicy", "faultPolicy", "fault-policy", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "fault"], [u'orgDomainGroup', u'orgOrg', u'policyDeviceProfile'], [], ["Add", "Get", "Remove", "Set"]),
    "FaultSummary": MoMeta("FaultSummary", "faultSummary", "fault-summary", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'extpolEp'], [u'faultSvcSummary'], [None]),
    "FaultSummaryInst": MoMeta("FaultSummaryInst", "faultSummaryInst", "fault-summary-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "fault", "operations"], [u'faultDomainEp', u'faultSummaryInst'], [u'faultSummaryInst'], ["Get"]),
    "FaultSvcSummary": MoMeta("FaultSvcSummary", "faultSvcSummary", "fault-svc-summary-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'faultSummary'], [], [None]),
    "FaultTypedHolder": MoMeta("FaultTypedHolder", "faultTypedHolder", "type-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "fault"], [u'faultHolder'], [], ["Get"]),
    "FcErrStats": MoMeta("FcErrStats", "fcErrStats", "err-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], [u'fcErrStatsHist'], [None]),
    "FcErrStatsHist": MoMeta("FcErrStatsHist", "fcErrStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'fcErrStats'], [], [None]),
    "FcPIo": MoMeta("FcPIo", "fcPIo", "port-[port_id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'portGroup', u'portSubGroup'], [u'equipmentXcvr'], ["Get"]),
    "FcStats": MoMeta("FcStats", "fcStats", "stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], [u'fcStatsHist'], [None]),
    "FcStatsHist": MoMeta("FcStatsHist", "fcStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'fcStats'], [], [None]),
    "FcpoolAddr": MoMeta("FcpoolAddr", "fcpoolAddr", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'fcpoolUniverse'], [u'faultInst', u'identpoolConsumed', u'identpoolPoolable'], ["Get"]),
    "FcpoolBlock": MoMeta("FcpoolBlock", "fcpoolBlock", "block-[r_from]-[to]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], [u'fcpoolInitiators'], [u'fcpoolBootTarget'], ["Add", "Get", "Remove"]),
    "FcpoolBootTarget": MoMeta("FcpoolBootTarget", "fcpoolBootTarget", "target-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], [u'fcpoolBlock', u'fcpoolInitiator'], [], ["Get"]),
    "FcpoolFormat": MoMeta("FcpoolFormat", "fcpoolFormat", "format-[format]-[mask]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy", "ls-storage", "ls-storage-policy"], [u'fcpoolUniverse'], [], ["Get"]),
    "FcpoolInitiator": MoMeta("FcpoolInitiator", "fcpoolInitiator", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'fcpoolInitiators'], [u'fcpoolBootTarget', u'fcpoolInitiatorEp'], ["Add", "Get", "Remove", "Set"]),
    "FcpoolInitiatorEp": MoMeta("FcpoolInitiatorEp", "fcpoolInitiatorEp", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'fcpoolInitiator'], [], [None]),
    "FcpoolInitiators": MoMeta("FcpoolInitiators", "fcpoolInitiators", "wwn-pool-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'faultInst', u'fcpoolBlock', u'fcpoolInitiator'], ["Add", "Get", "Remove", "Set"]),
    "FcpoolUniverse": MoMeta("FcpoolUniverse", "fcpoolUniverse", "wwn", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'fcpoolAddr', u'fcpoolFormat'], ["Get"]),
    "FdBlade": MoMeta("FdBlade", "fdBlade", "blade-[slot_id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fdChassis'], [u'eventInst', u'faultInst', u'fdBladeFsm', u'fdPhysicalFsm', u'fdPhysicalFsmTask', u'identRequestEp', u'messageEp', u'vnicMgmt', u'vnicOutbandMgmtEp'], ["get"]),
    "FdBladeFsm": MoMeta("FdBladeFsm", "fdBladeFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'fdBlade'], [u'fdBladeFsmStage'], [None]),
    "FdBladeFsmStage": MoMeta("FdBladeFsmStage", "fdBladeFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'fdBladeFsm'], [], [None]),
    "FdChassis": MoMeta("FdChassis", "fdChassis", "chassis-[chassis_id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricSystem'], [u'fdBlade', u'messageEp'], ["get"]),
    "FdPhysicalFsm": MoMeta("FdPhysicalFsm", "fdPhysicalFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'fdBlade', u'fdRackUnit'], [u'fdPhysicalFsmStage'], [None]),
    "FdPhysicalFsmStage": MoMeta("FdPhysicalFsmStage", "fdPhysicalFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'fdPhysicalFsm'], [], [None]),
    "FdPhysicalFsmTask": MoMeta("FdPhysicalFsmTask", "fdPhysicalFsmTask", "task-[item]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'fdBlade', u'fdRackUnit'], [], [None]),
    "FdRackUnit": MoMeta("FdRackUnit", "fdRackUnit", "rack-unit-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricSystem'], [u'eventInst', u'faultInst', u'fdPhysicalFsm', u'fdPhysicalFsmTask', u'fdRackUnitFsm', u'identRequestEp', u'messageEp', u'vnicMgmt', u'vnicOutbandMgmtEp'], ["get"]),
    "FdRackUnitFsm": MoMeta("FdRackUnitFsm", "fdRackUnitFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'fdRackUnit'], [u'fdRackUnitFsmStage'], [None]),
    "FdRackUnitFsmStage": MoMeta("FdRackUnitFsmStage", "fdRackUnitFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'fdRackUnitFsm'], [], [None]),
    "FeatureCatalogEp": MoMeta("FeatureCatalogEp", "featureCatalogEp", "feature-catalog", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'featureChassisDef', u'featureEnvDef', u'featureNetworkDef', u'featureServerDef', u'featureStorageDef'], ["Get"]),
    "FeatureChassisDef": MoMeta("FeatureChassisDef", "featureChassisDef", "chassis-feature-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'featureCatalogEp'], [u'domainChassisParam', u'domainEnvironmentParam', u'domainNetworkParam', u'domainServerParam', u'domainStorageParam'], ["get"]),
    "FeatureEnvDef": MoMeta("FeatureEnvDef", "featureEnvDef", "env-feature-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'featureCatalogEp'], [u'domainChassisParam', u'domainEnvironmentParam', u'domainNetworkParam', u'domainServerParam', u'domainStorageParam'], ["Get"]),
    "FeatureNetworkDef": MoMeta("FeatureNetworkDef", "featureNetworkDef", "network-feature-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'featureCatalogEp'], [u'domainChassisParam', u'domainEnvironmentParam', u'domainNetworkParam', u'domainServerParam', u'domainStorageParam'], ["Get"]),
    "FeatureServerDef": MoMeta("FeatureServerDef", "featureServerDef", "server-feature-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'featureCatalogEp'], [u'domainChassisParam', u'domainEnvironmentParam', u'domainNetworkParam', u'domainServerParam', u'domainStorageParam'], ["Get"]),
    "FeatureStorageDef": MoMeta("FeatureStorageDef", "featureStorageDef", "storage-feature-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'featureCatalogEp'], [u'domainChassisParam', u'domainEnvironmentParam', u'domainNetworkParam', u'domainServerParam', u'domainStorageParam'], ["Get"]),
    "FirmwareAck": MoMeta("FirmwareAck", "firmwareAck", "ack", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'fabricLanCloud', u'fabricSanCloud', u'firmwareSystem', u'qosclassDefinition'], [u'faultInst'], ["get", "set"]),
    "FirmwareAutoSyncPolicy": MoMeta("FirmwareAutoSyncPolicy", "firmwareAutoSyncPolicy", "fw-auto-sync", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], [u'orgDomainGroup'], [], ["Get", "Set"]),
    "FirmwareBootDefinition": MoMeta("FirmwareBootDefinition", "firmwareBootDefinition", "fw-boot-def", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'equipmentPsu', u'osController', u'storageController', u'storageLocalDisk', u'storageOnboardDevice', u'storageSasExpander'], [u'firmwareBootUnit'], ["Get"]),
    "FirmwareBootUnit": MoMeta("FirmwareBootUnit", "firmwareBootUnit", "bootunit-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'firmwareBootDefinition'], [], ["Get", "Set"]),
    "FirmwareBundleInfo": MoMeta("FirmwareBundleInfo", "firmwareBundleInfo", "bundle-[type]-[version]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "ls-compute", "ls-config-policy", "ls-server-policy"], [], [], [None]),
    "FirmwareBundleInfoDigest": MoMeta("FirmwareBundleInfoDigest", "firmwareBundleInfoDigest", "bundleinfo-[type]-version-[version]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "FirmwareBundleType": MoMeta("FirmwareBundleType", "firmwareBundleType", "-type-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], [""], [u'firmwareBundleTypeCapProvider'], [], ["Get"]),
    "FirmwareBundleTypeCapProvider": MoMeta("FirmwareBundleTypeCapProvider", "firmwareBundleTypeCapProvider", "bundle-type-cap", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [u'firmwareBundleType', u'firmwareChassisComponentSpec', u'firmwareComponentSpec'], ["Get"]),
    "FirmwareCatalogPack": MoMeta("FirmwareCatalogPack", "firmwareCatalogPack", "fw-catalog-pack-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'computeSystem', u'firmwareDomainInfraProfile', u'orgDomainGroup', u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "FirmwareCatalogPackConfig": MoMeta("FirmwareCatalogPackConfig", "firmwareCatalogPackConfig", "fw-catalog-pack-config[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "operations"], [u'firmwareDomainInfraProfile', u'orgDomainGroup', u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "FirmwareCatalogue": MoMeta("FirmwareCatalogue", "firmwareCatalogue", "fw-catalogue", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'firmwareCompSource', u'firmwareDistributable', u'firmwareDownloader', u'firmwareImage', u'firmwareSource'], ["Get", "Set"]),
    "FirmwareChassisComponentSpec": MoMeta("FirmwareChassisComponentSpec", "firmwareChassisComponentSpec", "chassis-component-spec-[type]", VersionMeta.Version151a, "InputOutput", 0x1, [], [""], [u'firmwareBundleTypeCapProvider'], [], ["Get"]),
    "FirmwareChassisPack": MoMeta("FirmwareChassisPack", "firmwareChassisPack", "fw-chassis-pack-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'orgDomainGroup', u'orgOrg'], [u'firmwareExcludeChassisComponent'], ["Add", "Get", "Remove", "Set"]),
    "FirmwareCompSource": MoMeta("FirmwareCompSource", "firmwareCompSource", "source-[inv_tag]-ver-[version]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'firmwareCatalogue', u'firmwareRemoteCatalogue'], [u'firmwareCompTarget'], [None]),
    "FirmwareCompTarget": MoMeta("FirmwareCompTarget", "firmwareCompTarget", "target-[inv_tag]-ver-[version]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'firmwareCompSource'], [], [None]),
    "FirmwareComponentSpec": MoMeta("FirmwareComponentSpec", "firmwareComponentSpec", "component-spec-[type]", VersionMeta.Version141a, "InputOutput", 0x1, [], [""], [u'firmwareBundleTypeCapProvider'], [], ["Get"]),
    "FirmwareComputeHostPack": MoMeta("FirmwareComputeHostPack", "firmwareComputeHostPack", "fw-host-pack-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'orgDomainGroup', u'orgOrg'], [u'firmwareExcludeServerComponent'], ["Add", "Get", "Remove", "Set"]),
    "FirmwareComputeMgmtPack": MoMeta("FirmwareComputeMgmtPack", "firmwareComputeMgmtPack", "fw-mgmt-pack-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config-policy", "ls-server-policy"], [u'orgDomainGroup', u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "FirmwareComputeStoragePack": MoMeta("FirmwareComputeStoragePack", "firmwareComputeStoragePack", "fw-storage-pack-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage", "ls-storage-policy"], [u'orgDomainGroup', u'orgOrg'], [], [None]),
    "FirmwareConnectionPolicy": MoMeta("FirmwareConnectionPolicy", "firmwareConnectionPolicy", "conn-policy-[type]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'orgDomainGroup'], [], ["Get", "Set"]),
    "FirmwareDependency": MoMeta("FirmwareDependency", "firmwareDependency", "dep-[ep]-[inv_tag]-[hw_vendor]|[hw_model]|[hw_revision]", VersionMeta.Version101a, "InputOutput", 0x1, [], [""], [u'firmwareType'], [], ["Get"]),
    "FirmwareDistImage": MoMeta("FirmwareDistImage", "firmwareDistImage", "distimage-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'firmwareDistributable'], [], ["Get"]),
    "FirmwareDistributable": MoMeta("FirmwareDistributable", "firmwareDistributable", "distrib-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'firmwareCatalogue', u'firmwareRemoteCatalogue'], [u'eventInst', u'faultInst', u'firmwareDistImage', u'firmwareDistributableFsm', u'firmwareDistributableFsmTask'], ["Get", "Set"]),
    "FirmwareDistributableFsm": MoMeta("FirmwareDistributableFsm", "firmwareDistributableFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'firmwareDistributable'], [u'firmwareDistributableFsmStage'], [None]),
    "FirmwareDistributableFsmStage": MoMeta("FirmwareDistributableFsmStage", "firmwareDistributableFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'firmwareDistributableFsm'], [], [None]),
    "FirmwareDistributableFsmTask": MoMeta("FirmwareDistributableFsmTask", "firmwareDistributableFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'firmwareDistributable'], [], [None]),
    "FirmwareDomainInfo": MoMeta("FirmwareDomainInfo", "firmwareDomainInfo", "domain-info-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "operations"], [u'firmwareDomainInfraProfile'], [], ["Get"]),
    "FirmwareDomainInfraProfile": MoMeta("FirmwareDomainInfraProfile", "firmwareDomainInfraProfile", "domain-infra-profile-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "operations"], [u'orgOrg'], [u'firmwareCatalogPack', u'firmwareCatalogPackConfig', u'firmwareDomainInfo', u'firmwareProductFamily', u'trigMeta', u'trigSched'], ["Add", "Get", "Remove", "Set"]),
    "FirmwareDownloadPolicy": MoMeta("FirmwareDownloadPolicy", "firmwareDownloadPolicy", "dl-policy-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'firmwareSource', u'orgDomainGroup'], [u'faultInst'], ["Get", "Set"]),
    "FirmwareDownloader": MoMeta("FirmwareDownloader", "firmwareDownloader", "dnld-[file_name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'firmwareCatalogue'], [u'eventInst', u'faultInst', u'firmwareDownloaderFsm', u'firmwareDownloaderFsmTask'], ["Add", "Get", "Remove", "Set"]),
    "FirmwareDownloaderFsm": MoMeta("FirmwareDownloaderFsm", "firmwareDownloaderFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'firmwareDownloader'], [u'firmwareDownloaderFsmStage'], [None]),
    "FirmwareDownloaderFsmStage": MoMeta("FirmwareDownloaderFsmStage", "firmwareDownloaderFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'firmwareDownloaderFsm'], [], [None]),
    "FirmwareDownloaderFsmTask": MoMeta("FirmwareDownloaderFsmTask", "firmwareDownloaderFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'firmwareDownloader'], [], ["Get"]),
    "FirmwareExcludeChassisComponent": MoMeta("FirmwareExcludeChassisComponent", "firmwareExcludeChassisComponent", "exclude-chassis-component-[chassis_component]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'firmwareChassisPack'], [], ["Add", "Get", "Remove"]),
    "FirmwareExcludeServerComponent": MoMeta("FirmwareExcludeServerComponent", "firmwareExcludeServerComponent", "exclude-server-component-[server_component]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config-policy", "ls-server-policy"], [u'firmwareComputeHostPack'], [], ["Add", "Get", "Remove"]),
    "FirmwareImage": MoMeta("FirmwareImage", "firmwareImage", "image-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'firmwareCatalogue', u'firmwareRemoteCatalogue'], [], ["Get", "Set"]),
    "FirmwareInfra": MoMeta("FirmwareInfra", "firmwareInfra", "fw-infra", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'firmwareSystem'], [u'faultInst'], ["Get"]),
    "FirmwareInfraPack": MoMeta("FirmwareInfraPack", "firmwareInfraPack", "fw-infra-pack-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'firmwareProductFamily', u'orgDomainGroup', u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "FirmwareInfraPackConfig": MoMeta("FirmwareInfraPackConfig", "firmwareInfraPackConfig", "fw-infra-pack-config[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "operations"], [u'firmwareProductFamily', u'orgDomainGroup', u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "FirmwareInfraPolicy": MoMeta("FirmwareInfraPolicy", "firmwareInfraPolicy", "fw-infra-policy", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "operations"], [u'orgDomainGroup', u'orgOrg'], [u'firmwareProductFamily'], ["Get", "Set"]),
    "FirmwareInstallImpact": MoMeta("FirmwareInstallImpact", "firmwareInstallImpact", "fw-sys-InstallImpact-[key_dn]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [], [], ["Get"]),
    "FirmwarePolicy": MoMeta("FirmwarePolicy", "firmwarePolicy", "fw-policy", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'orgDomainGroup'], [], [None]),
    "FirmwareProductFamily": MoMeta("FirmwareProductFamily", "firmwareProductFamily", "fw-family-[family_name]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "operations"], [u'firmwareDomainInfraProfile', u'firmwareInfraPolicy'], [u'firmwareInfraPack', u'firmwareInfraPackConfig'], ["Get"]),
    "FirmwareRemoteCatalogue": MoMeta("FirmwareRemoteCatalogue", "firmwareRemoteCatalogue", "remote-fw-catalogue-[server]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'topSystem'], [u'firmwareCompSource', u'firmwareDistributable', u'firmwareImage'], [None]),
    "FirmwareRunning": MoMeta("FirmwareRunning", "firmwareRunning", "fw-[deployment]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'biosUnit', u'equipmentPsu', u'graphicsCard', u'mgmtController', u'osController', u'storageController', u'storageFlexFlashController', u'storageLocalDisk', u'storageOnboardDevice', u'storageSasExpander'], [], ["Get"]),
    "FirmwareSource": MoMeta("FirmwareSource", "firmwareSource", "source-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'firmwareCatalogue'], [u'faultInst', u'firmwareDownloadPolicy'], ["Get", "Set"]),
    "FirmwareStatus": MoMeta("FirmwareStatus", "firmwareStatus", "fw-status", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'equipmentFex', u'equipmentIOCard', u'equipmentPsu', u'networkElement', u'topSystem'], [], ["Get"]),
    "FirmwareStoragePack": MoMeta("FirmwareStoragePack", "firmwareStoragePack", "storage-pack-[vendor]-[model]-[revision]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'orgOrg'], [], [None]),
    "FirmwareSystem": MoMeta("FirmwareSystem", "firmwareSystem", "fw-system", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy"], [u'computeSystem', u'topSystem'], [u'firmwareAck', u'firmwareInfra'], ["Get"]),
    "FirmwareType": MoMeta("FirmwareType", "firmwareType", "fw-type-[inv_tag]", VersionMeta.Version101a, "InputOutput", 0x1, [], [""], [u'capabilityCatalogue'], [u'firmwareDependency'], ["Get"]),
    "FirmwareUpdatable": MoMeta("FirmwareUpdatable", "firmwareUpdatable", "fw-updatable", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'equipmentPsu', u'storageOnboardDevice'], [], ["Get", "Set"]),
    "FirmwareUpgradeDetail": MoMeta("FirmwareUpgradeDetail", "firmwareUpgradeDetail", "id-[id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], [u'firmwareUpgradeInfo'], [], ["Get"]),
    "FirmwareUpgradeInfo": MoMeta("FirmwareUpgradeInfo", "firmwareUpgradeInfo", "validate-upgrade", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], [u'computeSystem'], [u'firmwareUpgradeDetail'], ["Get"]),
    "FlowctrlDefinition": MoMeta("FlowctrlDefinition", "flowctrlDefinition", "flowctrl", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-qos-policy"], [u'fabricLanCloud', u'orgDomainGroup'], [u'flowctrlItem'], ["Get", "Set"]),
    "FlowctrlItem": MoMeta("FlowctrlItem", "flowctrlItem", "policy-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-qos-policy"], [u'flowctrlDefinition'], [], ["Add", "Get", "Remove", "Set"]),
    "FsmStatus": MoMeta("FsmStatus", "fsmStatus", "status-[converted_ep_ref]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'computeSystem', u'topSystem'], [], ["Get"]),
    "GlAppendRule": MoMeta("GlAppendRule", "glAppendRule", "appendrule", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glPolicyNameRuleEp'], [], [None]),
    "GlBlockEp": MoMeta("GlBlockEp", "glBlockEp", "blockep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glPolicyResolutionEp'], [u'glBlockOp'], [None]),
    "GlBlockOp": MoMeta("GlBlockOp", "glBlockOp", "block-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glBlockEp'], [u'glConflictEp', u'glRequestorEp', u'messageEp'], [None]),
    "GlByMo": MoMeta("GlByMo", "glByMo", "by-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glPolicyOp', u'glPolicyResOp', u'glRefsEp'], [], [None]),
    "GlComplexRefEp": MoMeta("GlComplexRefEp", "glComplexRefEp", "crefep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glPolicyResOp'], [u'glIdRefEp', u'glPolicyRefEp'], [None]),
    "GlConflictEp": MoMeta("GlConflictEp", "glConflictEp", "cep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glBlockOp', u'glIdentCtxOp', u'glIdentCtxResOp', u'glPolicyAlgorithmedOp', u'glPolicyOp', u'glPolicyResOp', u'glPoolOp', u'glServerPoolResOp', u'glTemplateOp', u'glTemplateResOp', u'glVxanOp', u'glVxanResOp'], [], [None]),
    "GlConflictResolutionRuleEp": MoMeta("GlConflictResolutionRuleEp", "glConflictResolutionRuleEp", "ruleep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glDomainEp'], [u'glPolicyNameRuleEp'], [None]),
    "GlDomainEp": MoMeta("GlDomainEp", "glDomainEp", "domain-[domain_id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glEp'], [u'glConflictResolutionRuleEp', u'glRequest'], [None]),
    "GlEp": MoMeta("GlEp", "glEp", "gl", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'glDomainEp', u'glRequestVnetEpHolder'], [None]),
    "GlGlobalDefaultPolicyEp": MoMeta("GlGlobalDefaultPolicyEp", "glGlobalDefaultPolicyEp", "gdpep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glPolicyResolutionEp'], [u'glPolicyResOp'], [None]),
    "GlIdRef": MoMeta("GlIdRef", "glIdRef", "iref-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glIdRefEp'], [], [None]),
    "GlIdRefEp": MoMeta("GlIdRefEp", "glIdRefEp", "irefep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glComplexRefEp'], [u'glIdRef'], [None]),
    "GlIdentCtxEp": MoMeta("GlIdentCtxEp", "glIdentCtxEp", "icp", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glOperationEp', u'glPolicyResolutionEp', u'glServiceProfile'], [u'glIdentCtxOp', u'glIdentCtxResOp'], [None]),
    "GlIdentCtxOp": MoMeta("GlIdentCtxOp", "glIdentCtxOp", "icop-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glIdentCtxEp'], [u'glConflictEp', u'glRequestorEp', u'messageEp'], [None]),
    "GlIdentCtxResOp": MoMeta("GlIdentCtxResOp", "glIdentCtxResOp", "icrop-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glIdentCtxEp'], [u'eventInst', u'faultInst', u'glConflictEp', u'glIdentCtxResOpFsm', u'glIdentCtxResOpFsmTask', u'glRefsEp', u'glRequestorEp', u'messageEp'], [None]),
    "GlIdentCtxResOpFsm": MoMeta("GlIdentCtxResOpFsm", "glIdentCtxResOpFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'glIdentCtxResOp'], [u'glIdentCtxResOpFsmStage'], [None]),
    "GlIdentCtxResOpFsmStage": MoMeta("GlIdentCtxResOpFsmStage", "glIdentCtxResOpFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'glIdentCtxResOpFsm'], [], [None]),
    "GlIdentCtxResOpFsmTask": MoMeta("GlIdentCtxResOpFsmTask", "glIdentCtxResOpFsmTask", "task-[item]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'glIdentCtxResOp'], [], [None]),
    "GlInventoryEp": MoMeta("GlInventoryEp", "glInventoryEp", "inv-[internal_id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glPathEp', u'glRequest'], [u'glPolicyInvEp', u'glPoolInvEp', u'glSPInvEp'], [None]),
    "GlLsp": MoMeta("GlLsp", "glLsp", "lsp-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glRequest'], [u'glOperationEp'], [None]),
    "GlMcastPolicy": MoMeta("GlMcastPolicy", "glMcastPolicy", "mc-policy[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glVnetInvHolder'], [u'messageEp'], [None]),
    "GlOperationEp": MoMeta("GlOperationEp", "glOperationEp", "opep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glLsp', u'glPolicy', u'glPool', u'glRequest', u'glServiceProfile', u'glVnicTemplate'], [u'glIdentCtxEp', u'glPolicyEp', u'glPoolEp', u'glTemplateEp', u'glVxanEp'], [None]),
    "GlPathEp": MoMeta("GlPathEp", "glPathEp", "path-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glRequest'], [u'glInventoryEp'], [None]),
    "GlPolicy": MoMeta("GlPolicy", "glPolicy", "policy-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glPolicyInvEp'], [u'glOperationEp', u'glUsageEp', u'messageEp'], [None]),
    "GlPolicyAlgorithmedOp": MoMeta("GlPolicyAlgorithmedOp", "glPolicyAlgorithmedOp", "paop-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glPolicyEp'], [u'glConflictEp', u'glRequestorEp', u'messageEp'], [None]),
    "GlPolicyEp": MoMeta("GlPolicyEp", "glPolicyEp", "paep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glOperationEp', u'glPolicyResolutionEp'], [u'glPolicyAlgorithmedOp', u'glPolicyOp', u'glPolicyResOp'], [None]),
    "GlPolicyInvEp": MoMeta("GlPolicyInvEp", "glPolicyInvEp", "policy", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glInventoryEp'], [u'glPolicy'], [None]),
    "GlPolicyNameRuleEp": MoMeta("GlPolicyNameRuleEp", "glPolicyNameRuleEp", "policyep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glConflictResolutionRuleEp'], [u'glAppendRule'], [None]),
    "GlPolicyOp": MoMeta("GlPolicyOp", "glPolicyOp", "pop-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glPolicyEp'], [u'glByMo', u'glConflictEp', u'glRefsEp', u'glRequestorEp', u'messageEp'], [None]),
    "GlPolicyRef": MoMeta("GlPolicyRef", "glPolicyRef", "pref-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glPolicyRefEp'], [], [None]),
    "GlPolicyRefEp": MoMeta("GlPolicyRefEp", "glPolicyRefEp", "prefep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glComplexRefEp'], [u'glPolicyRef'], [None]),
    "GlPolicyResOp": MoMeta("GlPolicyResOp", "glPolicyResOp", "presp-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glGlobalDefaultPolicyEp', u'glPolicyEp'], [u'glByMo', u'glComplexRefEp', u'glConflictEp', u'glRefsEp', u'glRequestorEp', u'messageEp'], [None]),
    "GlPolicyResolutionEp": MoMeta("GlPolicyResolutionEp", "glPolicyResolutionEp", "prep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glRequest'], [u'glBlockEp', u'glGlobalDefaultPolicyEp', u'glIdentCtxEp', u'glPolicyEp', u'glSpDefEp', u'glVxanEp'], [None]),
    "GlPool": MoMeta("GlPool", "glPool", "pool-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glPoolInvEp'], [u'glOperationEp', u'messageEp'], [None]),
    "GlPoolEp": MoMeta("GlPoolEp", "glPoolEp", "pep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glOperationEp'], [u'glPoolOp'], [None]),
    "GlPoolInvEp": MoMeta("GlPoolInvEp", "glPoolInvEp", "pool", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glInventoryEp'], [u'glPool'], [None]),
    "GlPoolOp": MoMeta("GlPoolOp", "glPoolOp", "", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glPoolEp'], [u'glConflictEp', u'glRequestorEp', u'messageEp'], [None]),
    "GlRefsEp": MoMeta("GlRefsEp", "glRefsEp", "refsep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glIdentCtxResOp', u'glPolicyOp', u'glPolicyResOp'], [u'glByMo'], [None]),
    "GlRequest": MoMeta("GlRequest", "glRequest", "req-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glDomainEp'], [u'eventInst', u'faultInst', u'glInventoryEp', u'glLsp', u'glOperationEp', u'glPathEp', u'glPolicyResolutionEp', u'glRequestFsm', u'glRequestFsmTask', u'glVnicTemplateEp', u'messageEp'], [None]),
    "GlRequestFsm": MoMeta("GlRequestFsm", "glRequestFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'glRequest'], [u'glRequestFsmStage'], [None]),
    "GlRequestFsmStage": MoMeta("GlRequestFsmStage", "glRequestFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'glRequestFsm'], [], [None]),
    "GlRequestFsmTask": MoMeta("GlRequestFsmTask", "glRequestFsmTask", "task-[item]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'glRequest'], [], [None]),
    "GlRequestVnetEp": MoMeta("GlRequestVnetEp", "glRequestVnetEp", "req-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glRequestVnetEpHolder'], [u'eventInst', u'faultInst', u'glRequestVnetEpDomainEp', u'glRequestVnetEpFsm', u'glRequestVnetEpFsmTask'], [None]),
    "GlRequestVnetEpDomainEp": MoMeta("GlRequestVnetEpDomainEp", "glRequestVnetEpDomainEp", "domain-[domain_id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glRequestVnetEp'], [u'eventInst', u'faultInst', u'glRequestVnetEpDomainEpFsm', u'glRequestVnetEpDomainEpFsmTask', u'glVnetInvHolder'], [None]),
    "GlRequestVnetEpDomainEpFsm": MoMeta("GlRequestVnetEpDomainEpFsm", "glRequestVnetEpDomainEpFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'glRequestVnetEpDomainEp'], [u'glRequestVnetEpDomainEpFsmStage'], [None]),
    "GlRequestVnetEpDomainEpFsmStage": MoMeta("GlRequestVnetEpDomainEpFsmStage", "glRequestVnetEpDomainEpFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'glRequestVnetEpDomainEpFsm'], [], [None]),
    "GlRequestVnetEpDomainEpFsmTask": MoMeta("GlRequestVnetEpDomainEpFsmTask", "glRequestVnetEpDomainEpFsmTask", "task-[item]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'glRequestVnetEpDomainEp'], [], [None]),
    "GlRequestVnetEpFsm": MoMeta("GlRequestVnetEpFsm", "glRequestVnetEpFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'glRequestVnetEp'], [u'glRequestVnetEpFsmStage'], [None]),
    "GlRequestVnetEpFsmStage": MoMeta("GlRequestVnetEpFsmStage", "glRequestVnetEpFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'glRequestVnetEpFsm'], [], [None]),
    "GlRequestVnetEpFsmTask": MoMeta("GlRequestVnetEpFsmTask", "glRequestVnetEpFsmTask", "task-[item]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'glRequestVnetEp'], [], [None]),
    "GlRequestVnetEpHolder": MoMeta("GlRequestVnetEpHolder", "glRequestVnetEpHolder", "reqholder", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glEp'], [u'glRequestVnetEp'], [None]),
    "GlRequestor": MoMeta("GlRequestor", "glRequestor", "", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glRequestorEp'], [], [None]),
    "GlRequestorEp": MoMeta("GlRequestorEp", "glRequestorEp", "reqep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glBlockOp', u'glIdentCtxOp', u'glIdentCtxResOp', u'glPolicyAlgorithmedOp', u'glPolicyOp', u'glPolicyResOp', u'glPoolOp', u'glServerPoolResOp', u'glTemplateOp', u'glTemplateResOp', u'glVxanOp', u'glVxanResOp'], [u'glRequestor'], [None]),
    "GlSPInvEp": MoMeta("GlSPInvEp", "glSPInvEp", "sp", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glInventoryEp'], [u'glServiceProfile'], [None]),
    "GlServerPoolResOp": MoMeta("GlServerPoolResOp", "glServerPoolResOp", "svrprp", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glSpDefEp'], [u'glConflictEp', u'glRequestorEp', u'messageEp'], [None]),
    "GlServiceProfile": MoMeta("GlServiceProfile", "glServiceProfile", "sp-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glSPInvEp'], [u'glIdentCtxEp', u'glOperationEp', u'messageEp'], [None]),
    "GlSpDefEp": MoMeta("GlSpDefEp", "glSpDefEp", "spep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glPolicyResolutionEp'], [u'glServerPoolResOp', u'glTemplateResOp'], [None]),
    "GlTemplateEp": MoMeta("GlTemplateEp", "glTemplateEp", "tep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glOperationEp'], [u'glTemplateOp'], [None]),
    "GlTemplateOp": MoMeta("GlTemplateOp", "glTemplateOp", "", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glTemplateEp'], [u'glConflictEp', u'glRequestorEp', u'messageEp'], [None]),
    "GlTemplateResOp": MoMeta("GlTemplateResOp", "glTemplateResOp", "temprp", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glSpDefEp'], [u'glConflictEp', u'glRequestorEp', u'messageEp'], [None]),
    "GlUsage": MoMeta("GlUsage", "glUsage", "sp-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glUsageEp'], [], [None]),
    "GlUsageEp": MoMeta("GlUsageEp", "glUsageEp", "uep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glPolicy'], [u'glUsage'], [None]),
    "GlVlan": MoMeta("GlVlan", "glVlan", "vlan-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glVnetInvHolder'], [u'messageEp'], [None]),
    "GlVnetInvHolder": MoMeta("GlVnetInvHolder", "glVnetInvHolder", "vnet", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glRequestVnetEpDomainEp'], [u'glMcastPolicy', u'glVlan', u'glVsan'], [None]),
    "GlVnicTemplate": MoMeta("GlVnicTemplate", "glVnicTemplate", "vt-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glVnicTemplateEp'], [u'glOperationEp'], [None]),
    "GlVnicTemplateEp": MoMeta("GlVnicTemplateEp", "glVnicTemplateEp", "vtep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glRequest'], [u'glVnicTemplate'], [None]),
    "GlVsan": MoMeta("GlVsan", "glVsan", "vsan-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glVnetInvHolder'], [u'messageEp'], [None]),
    "GlVxanEp": MoMeta("GlVxanEp", "glVxanEp", "vxep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'glOperationEp', u'glPolicyResolutionEp'], [u'glVxanOp', u'glVxanResOp'], [None]),
    "GlVxanOp": MoMeta("GlVxanOp", "glVxanOp", "vxanop-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glVxanEp'], [u'glConflictEp', u'glRequestorEp', u'messageEp'], [None]),
    "GlVxanResOp": MoMeta("GlVxanResOp", "glVxanResOp", "vxanresop-[id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'glVxanEp'], [u'glConflictEp', u'glRequestorEp', u'messageEp'], [None]),
    "GmetaClass": MoMeta("GmetaClass", "gmetaClass", "class-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [], [u'gmetaProp'], [None]),
    "GmetaPolicyMapElement": MoMeta("GmetaPolicyMapElement", "gmetaPolicyMapElement", "policymapelem-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "GmetaProp": MoMeta("GmetaProp", "gmetaProp", "prop-[order]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'gmetaClass'], [], [None]),
    "GraphicsCard": MoMeta("GraphicsCard", "graphicsCard", "graphics-card-[id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'computeBoard'], [u'firmwareRunning', u'graphicsController'], ["Get"]),
    "GraphicsController": MoMeta("GraphicsController", "graphicsController", "graphics-controller-[id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'graphicsCard'], [], ["Get"]),
    "GuiGuiComponent": MoMeta("GuiGuiComponent", "guiGuiComponent", "gui-[app_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'guiGuiCont'], [], [None]),
    "GuiGuiCont": MoMeta("GuiGuiCont", "guiGuiCont", "gui", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'guiGuiComponent'], [None]),
    "HcAdapterFirmwareItem": MoMeta("HcAdapterFirmwareItem", "hcAdapterFirmwareItem", "adapter-firmware-[item_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcServerComponent'], [u'hcItemNote', u'hcSupportedAdapterFirmwareItem'], [None]),
    "HcAdapterItem": MoMeta("HcAdapterItem", "hcAdapterItem", "adapter-[item_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcServerComponent'], [u'hcItemNote', u'hcSupportedAdapterItem'], [None]),
    "HcAdmin": MoMeta("HcAdmin", "hcAdmin", "hc-admin", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'hcHolder'], [u'hcCleanup'], ["Get"]),
    "HcCatalog": MoMeta("HcCatalog", "hcCatalog", "hc-catalog-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcHolder'], [], [None]),
    "HcCatalogList": MoMeta("HcCatalogList", "hcCatalogList", "catalog-list", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcHolder'], [u'hcCatalogSource'], ["Get"]),
    "HcCatalogSource": MoMeta("HcCatalogSource", "hcCatalogSource", "catalog-source-[type]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcCatalogList'], [u'hcDownloadPolicy'], ["Get"]),
    "HcCatalogVersion": MoMeta("HcCatalogVersion", "hcCatalogVersion", "hc-catalog-version-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcHolder'], [], ["Get"]),
    "HcCleanup": MoMeta("HcCleanup", "hcCleanup", "cleanup-[ref_dn]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'hcAdmin'], [], ["Get"]),
    "HcDownloadPolicy": MoMeta("HcDownloadPolicy", "hcDownloadPolicy", "hc-dl-policy-[type]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcCatalogSource', u'orgDomainGroup'], [], ["Get"]),
    "HcDownloader": MoMeta("HcDownloader", "hcDownloader", "dnld-[file_name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcHolder'], [], ["Add", "Get", "Remove", "Set"]),
    "HcDriverInfoItem": MoMeta("HcDriverInfoItem", "hcDriverInfoItem", "driver-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcHolder'], [], [None]),
    "HcDriverItem": MoMeta("HcDriverItem", "hcDriverItem", "driver-[item_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcServerComponent'], [u'hcItemNote', u'hcSupportedDriverItem'], [None]),
    "HcHolder": MoMeta("HcHolder", "hcHolder", "hc-ep", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'hcAdmin', u'hcCatalog', u'hcCatalogList', u'hcCatalogVersion', u'hcDownloader', u'hcDriverInfoItem', u'hcOsInfoItem', u'hcReport', u'hcUcsVersionItem'], ["Get"]),
    "HcItemNote": MoMeta("HcItemNote", "hcItemNote", "note-[ref_item_id]-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcAdapterFirmwareItem', u'hcAdapterItem', u'hcDriverItem', u'hcOsItem'], [], [None]),
    "HcOsInfoItem": MoMeta("HcOsInfoItem", "hcOsInfoItem", "os-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcHolder'], [], [None]),
    "HcOsItem": MoMeta("HcOsItem", "hcOsItem", "os-[item_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcServerComponent'], [u'hcItemNote', u'hcSupportedOsItem'], [None]),
    "HcReport": MoMeta("HcReport", "hcReport", "report-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcHolder'], [u'hcScopeDn', u'hcServerComponent'], ["Add", "Get", "Remove", "Set"]),
    "HcScopeDn": MoMeta("HcScopeDn", "hcScopeDn", "scope-dn-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcReport'], [], ["Add", "Get", "Remove", "Set"]),
    "HcServerComponent": MoMeta("HcServerComponent", "hcServerComponent", "server-[component_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcReport'], [u'hcAdapterFirmwareItem', u'hcAdapterItem', u'hcDriverItem', u'hcOsItem'], [None]),
    "HcSupportedAdapterFirmwareItem": MoMeta("HcSupportedAdapterFirmwareItem", "hcSupportedAdapterFirmwareItem", "supported-adapter-firmware-[item_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcAdapterFirmwareItem'], [], [None]),
    "HcSupportedAdapterItem": MoMeta("HcSupportedAdapterItem", "hcSupportedAdapterItem", "supported-adapter-[item_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcAdapterItem'], [], [None]),
    "HcSupportedDriverItem": MoMeta("HcSupportedDriverItem", "hcSupportedDriverItem", "supported-driver-[item_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcDriverItem'], [], [None]),
    "HcSupportedOsItem": MoMeta("HcSupportedOsItem", "hcSupportedOsItem", "supported-os-[item_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcOsItem'], [], [None]),
    "HcUcsVersionItem": MoMeta("HcUcsVersionItem", "hcUcsVersionItem", "ucsversion-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'hcHolder'], [], [None]),
    "IdentDomainSyncEp": MoMeta("IdentDomainSyncEp", "identDomainSyncEp", "domainsyncep", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [u'identMetaSystem'], [], [None]),
    "IdentExecutionEp": MoMeta("IdentExecutionEp", "identExecutionEp", "executionEp", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [u'identMetaSystem'], [u'identExecutionRequestEp'], [None]),
    "IdentExecutionRequestEp": MoMeta("IdentExecutionRequestEp", "identExecutionRequestEp", "ExeReqestEp-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [u'identExecutionEp'], [], [None]),
    "IdentIdentCtx": MoMeta("IdentIdentCtx", "identIdentCtx", "IdCtx-[seq_num]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'identIdentRequest'], [], [None]),
    "IdentIdentRequest": MoMeta("IdentIdentRequest", "identIdentRequest", "IdentQ-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'identMetaSystem'], [u'eventInst', u'faultInst', u'identIdentCtx', u'identIdentRequestFsm', u'identIdentRequestFsmTask'], [None]),
    "IdentIdentRequestFsm": MoMeta("IdentIdentRequestFsm", "identIdentRequestFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'identIdentRequest'], [u'identIdentRequestFsmStage'], [None]),
    "IdentIdentRequestFsmStage": MoMeta("IdentIdentRequestFsmStage", "identIdentRequestFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'identIdentRequestFsm'], [], [None]),
    "IdentIdentRequestFsmTask": MoMeta("IdentIdentRequestFsmTask", "identIdentRequestFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], [u'identIdentRequest'], [], [None]),
    "IdentMetaSystem": MoMeta("IdentMetaSystem", "identMetaSystem", "metasys", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'identMetaVerse'], [u'eventInst', u'faultInst', u'identDomainSyncEp', u'identExecutionEp', u'identIdentRequest', u'identMetaSystemFsm', u'identMetaSystemFsmTask'], [None]),
    "IdentMetaSystemFsm": MoMeta("IdentMetaSystemFsm", "identMetaSystemFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'identMetaSystem'], [u'identMetaSystemFsmStage'], [None]),
    "IdentMetaSystemFsmStage": MoMeta("IdentMetaSystemFsmStage", "identMetaSystemFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'identMetaSystemFsm'], [], [None]),
    "IdentMetaSystemFsmTask": MoMeta("IdentMetaSystemFsmTask", "identMetaSystemFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], [u'identMetaSystem'], [], [None]),
    "IdentMetaVerse": MoMeta("IdentMetaVerse", "identMetaVerse", "metaverse", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'identMetaSystem'], [None]),
    "IdentRequestEp": MoMeta("IdentRequestEp", "identRequestEp", "IdentQ", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'fdBlade', u'fdRackUnit', u'lsServer'], [], [None]),
    "IdentSysInfo": MoMeta("IdentSysInfo", "identSysInfo", "", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "IdentpoolBlockQual": MoMeta("IdentpoolBlockQual", "identpoolBlockQual", "block-qualifier-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'identpoolDomainGroupQual', u'identpoolIPQual', u'identpoolIPV6Qual'], ["Add", "Get", "Remove", "Set"]),
    "IdentpoolConsumed": MoMeta("IdentpoolConsumed", "identpoolConsumed", "cons-[sys_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'fcpoolAddr', u'ippoolAddr', u'ippoolIpV6Addr', u'iqnpoolAddr', u'macpoolAddr', u'uuidpoolAddr'], [u'identpoolDomain'], [None]),
    "IdentpoolDomain": MoMeta("IdentpoolDomain", "identpoolDomain", "domain", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [u'identpoolConsumed'], [], [None]),
    "IdentpoolDomainGroupQual": MoMeta("IdentpoolDomainGroupQual", "identpoolDomainGroupQual", "domaingroup-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'identpoolBlockQual'], [], ["Add", "Get", "Remove"]),
    "IdentpoolIPQual": MoMeta("IdentpoolIPQual", "identpoolIPQual", "ip-[addr]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'identpoolBlockQual'], [], ["Add", "Get", "Remove"]),
    "IdentpoolIPV6Qual": MoMeta("IdentpoolIPV6Qual", "identpoolIPV6Qual", "ipv6-[addr]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'identpoolBlockQual'], [], ["Add", "Get", "Remove", "Set"]),
    "IdentpoolMetaSystem": MoMeta("IdentpoolMetaSystem", "identpoolMetaSystem", "metasys-[sys_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'identpoolMetaVerse'], [], [None]),
    "IdentpoolMetaVerse": MoMeta("IdentpoolMetaVerse", "identpoolMetaVerse", "metaverse", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'identpoolMetaSystem'], [None]),
    "IdentpoolPoolable": MoMeta("IdentpoolPoolable", "identpoolPoolable", "pool-[sys_id]-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'fcpoolAddr', u'ippoolAddr', u'ippoolIpV6Addr', u'iqnpoolAddr', u'macpoolAddr', u'uuidpoolAddr'], [], [None]),
    "InbandPolicy": MoMeta("InbandPolicy", "inbandPolicy", "inband-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'orgDomainGroup'], [], ["get", "set"]),
    "InitiatorFcInitiatorEp": MoMeta("InitiatorFcInitiatorEp", "initiatorFcInitiatorEp", "fc-ini-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'initiatorGroupEp'], [u'storageEpUser'], [None]),
    "InitiatorGroupEp": MoMeta("InitiatorGroupEp", "initiatorGroupEp", "grp-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'initiatorRequestorEp'], [u'initiatorFcInitiatorEp', u'initiatorIScsiInitiatorEp', u'initiatorStoreEp', u'storageIScsiInitiatorEp', u'storageNodeEp'], [None]),
    "InitiatorIScsiInitiatorEp": MoMeta("InitiatorIScsiInitiatorEp", "initiatorIScsiInitiatorEp", "scsi-ini-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'initiatorGroupEp'], [u'storageEpUser'], [None]),
    "InitiatorLunEp": MoMeta("InitiatorLunEp", "initiatorLunEp", "lun-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageIScsiTargetIf'], [], [None]),
    "InitiatorMemberEp": MoMeta("InitiatorMemberEp", "initiatorMemberEp", "member-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'initiatorRequestorGrpEp'], [], [None]),
    "InitiatorRequestorEp": MoMeta("InitiatorRequestorEp", "initiatorRequestorEp", "req-sysid-[sys_id]-id-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'topSystem'], [u'initiatorGroupEp'], [None]),
    "InitiatorRequestorGrpEp": MoMeta("InitiatorRequestorGrpEp", "initiatorRequestorGrpEp", "req-grp-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'topSystem'], [u'initiatorMemberEp', u'initiatorUnitEp'], [None]),
    "InitiatorStoreEp": MoMeta("InitiatorStoreEp", "initiatorStoreEp", "store-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'initiatorGroupEp'], [], [None]),
    "InitiatorUnitEp": MoMeta("InitiatorUnitEp", "initiatorUnitEp", "unit-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'initiatorRequestorGrpEp'], [], [None]),
    "InventoryDomainEp": MoMeta("InventoryDomainEp", "inventoryDomainEp", "domain-[sys_id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "operations"], [u'inventoryHolder'], [u'inventoryInventoryMoMeta'], ["get", "set"]),
    "InventoryEp": MoMeta("InventoryEp", "inventoryEp", "inventory", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "operations"], [u'topRoot'], [u'inventoryHolder'], ["get"]),
    "InventoryGlobalEp": MoMeta("InventoryGlobalEp", "inventoryGlobalEp", "global-ep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "operations"], [u'inventoryHolder'], [u'inventoryInventoryMoMeta'], [None]),
    "InventoryHolder": MoMeta("InventoryHolder", "inventoryHolder", "holder-[type]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "operations"], [u'inventoryEp'], [u'inventoryDomainEp', u'inventoryGlobalEp'], [None]),
    "InventoryInventoryMoMeta": MoMeta("InventoryInventoryMoMeta", "inventoryInventoryMoMeta", "mo-[inst_id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "operations"], [u'inventoryDomainEp', u'inventoryGlobalEp'], [], [None]),
    "IpIPv4Dns": MoMeta("IpIPv4Dns", "ipIPv4Dns", "ipv4-dns-[pref]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "IpIpV4StaticAddr": MoMeta("IpIpV4StaticAddr", "ipIpV4StaticAddr", "addr-[addr]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [], [], ["Add", "Get", "Remove", "Set"]),
    "IpServiceIf": MoMeta("IpServiceIf", "ipServiceIf", "serv-ip-[addr]-port-[port]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [u'storageEtherIf'], [], [None]),
    "IppoolAddr": MoMeta("IppoolAddr", "ippoolAddr", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'ippoolUniverse'], [u'faultInst', u'identpoolConsumed', u'identpoolPoolable'], ["Get"]),
    "IppoolBlock": MoMeta("IppoolBlock", "ippoolBlock", "block-[r_from]-[to]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "ls-network-policy"], [u'ippoolPool'], [], ["Add", "Get", "Remove", "Set"]),
    "IppoolIpV6Addr": MoMeta("IppoolIpV6Addr", "ippoolIpV6Addr", "[id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [u'ippoolUniverse'], [u'faultInst', u'identpoolConsumed', u'identpoolPoolable'], ["Get"]),
    "IppoolIpV6Block": MoMeta("IppoolIpV6Block", "ippoolIpV6Block", "v6block-[r_from]-[to]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "ls-network-policy"], [u'ippoolPool'], [], ["Add", "Get", "Remove", "Set"]),
    "IppoolIpV6Pooled": MoMeta("IppoolIpV6Pooled", "ippoolIpV6Pooled", "[id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [u'ippoolPool'], [], ["Get"]),
    "IppoolPool": MoMeta("IppoolPool", "ippoolPool", "ip-pool-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'orgDomainGroup', u'orgOrg'], [u'faultInst', u'ippoolBlock', u'ippoolIpV6Block', u'ippoolIpV6Pooled', u'ippoolPooled'], ["Add", "Get", "Remove", "Set"]),
    "IppoolPooled": MoMeta("IppoolPooled", "ippoolPooled", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'ippoolPool'], [], ["Get"]),
    "IppoolUniverse": MoMeta("IppoolUniverse", "ippoolUniverse", "ip", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'ippoolAddr', u'ippoolIpV6Addr'], ["Get"]),
    "IqnpoolAddr": MoMeta("IqnpoolAddr", "iqnpoolAddr", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'iqnpoolUniverse'], [u'faultInst', u'identpoolConsumed', u'identpoolPoolable'], ["Get"]),
    "IqnpoolBlock": MoMeta("IqnpoolBlock", "iqnpoolBlock", "iqn-suffix-[suffix]-from-[r_from]-to-[to]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], [u'iqnpoolPool'], [], ["Add", "Get", "Remove"]),
    "IqnpoolFormat": MoMeta("IqnpoolFormat", "iqnpoolFormat", "format-[format]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'iqnpoolUniverse'], [], ["Get"]),
    "IqnpoolPool": MoMeta("IqnpoolPool", "iqnpoolPool", "iqn-pool-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'faultInst', u'iqnpoolBlock', u'iqnpoolPooled'], ["Add", "Get", "Remove", "Set"]),
    "IqnpoolPooled": MoMeta("IqnpoolPooled", "iqnpoolPooled", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'iqnpoolPool'], [], ["Get"]),
    "IqnpoolTransportBlock": MoMeta("IqnpoolTransportBlock", "iqnpoolTransportBlock", "block-[suffix]-from-[r_from]-to-[to]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-storage-policy"], [], [], ["Get", "Set"]),
    "IqnpoolUniverse": MoMeta("IqnpoolUniverse", "iqnpoolUniverse", "iqn", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'iqnpoolAddr', u'iqnpoolFormat'], ["Get"]),
    "IscsiAuthProfile": MoMeta("IscsiAuthProfile", "iscsiAuthProfile", "iscsi-auth-profile-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "LicenseContents": MoMeta("LicenseContents", "licenseContents", "contents-[feature_name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'licenseFile'], [u'licenseFeatureLine'], ["Get"]),
    "LicenseDomain": MoMeta("LicenseDomain", "licenseDomain", "Domain-[guid]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'licenseEp'], [], [None]),
    "LicenseDownloader": MoMeta("LicenseDownloader", "licenseDownloader", "dnld-[file_name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'licenseEp'], [u'eventInst', u'faultInst', u'licenseDownloaderFsm', u'licenseDownloaderFsmTask', u'licenseProp'], ["Add", "Get", "Remove", "Set"]),
    "LicenseDownloaderFsm": MoMeta("LicenseDownloaderFsm", "licenseDownloaderFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'licenseDownloader'], [u'licenseDownloaderFsmStage'], [None]),
    "LicenseDownloaderFsmStage": MoMeta("LicenseDownloaderFsmStage", "licenseDownloaderFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'licenseDownloaderFsm'], [], [None]),
    "LicenseDownloaderFsmTask": MoMeta("LicenseDownloaderFsmTask", "licenseDownloaderFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], [u'licenseDownloader'], [], [None]),
    "LicenseEp": MoMeta("LicenseEp", "licenseEp", "license", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'licenseDomain', u'licenseDownloader', u'licenseFeature', u'licenseFile', u'licenseServerHostId'], ["Get"]),
    "LicenseFeature": MoMeta("LicenseFeature", "licenseFeature", "feature-[name]-[vendor]-[version]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'licenseEp'], [u'licenseInstance'], ["Get"]),
    "LicenseFeatureCapProvider": MoMeta("LicenseFeatureCapProvider", "licenseFeatureCapProvider", "feature-[feature_name]-[lic_vendor]|[lic_version]manufacturer-[vendor]-model-[model]-revision-[revision]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'capabilityCatalogue'], [], ["Get"]),
    "LicenseFeatureLine": MoMeta("LicenseFeatureLine", "licenseFeatureLine", "FeatureLine-[id]:[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'licenseContents'], [], ["Get"]),
    "LicenseFile": MoMeta("LicenseFile", "licenseFile", "file-[scope]:[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'licenseEp'], [u'eventInst', u'faultInst', u'licenseContents', u'licenseFileFsm', u'licenseFileFsmTask', u'licenseSource'], ["Get"]),
    "LicenseFileFsm": MoMeta("LicenseFileFsm", "licenseFileFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'licenseFile'], [u'licenseFileFsmStage'], [None]),
    "LicenseFileFsmStage": MoMeta("LicenseFileFsmStage", "licenseFileFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'licenseFileFsm'], [], [None]),
    "LicenseFileFsmTask": MoMeta("LicenseFileFsmTask", "licenseFileFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], [u'licenseFile'], [], [None]),
    "LicenseInstance": MoMeta("LicenseInstance", "licenseInstance", "inst-[scope]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'licenseFeature'], [u'eventInst', u'faultInst', u'licenseInstanceFsm', u'licenseInstanceFsmTask', u'licenseProp', u'licenseSourceFile'], ["Get"]),
    "LicenseInstanceFsm": MoMeta("LicenseInstanceFsm", "licenseInstanceFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'licenseInstance'], [u'licenseInstanceFsmStage'], [None]),
    "LicenseInstanceFsmStage": MoMeta("LicenseInstanceFsmStage", "licenseInstanceFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'licenseInstanceFsm'], [], [None]),
    "LicenseInstanceFsmTask": MoMeta("LicenseInstanceFsmTask", "licenseInstanceFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], [u'licenseInstance'], [], [None]),
    "LicenseProp": MoMeta("LicenseProp", "licenseProp", "prop-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'licenseDownloader', u'licenseInstance'], [], ["Get"]),
    "LicenseServerHostId": MoMeta("LicenseServerHostId", "licenseServerHostId", "server-host-id-[scope]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'licenseEp'], [], ["Get"]),
    "LicenseSource": MoMeta("LicenseSource", "licenseSource", "source", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'licenseFile'], [], ["Get"]),
    "LicenseSourceFile": MoMeta("LicenseSourceFile", "licenseSourceFile", "src-[id]:[line]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'licenseInstance'], [], ["Get"]),
    "LsBinding": MoMeta("LsBinding", "lsBinding", "pn", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "read-only"], [u'lsServer'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "LsFcLocale": MoMeta("LsFcLocale", "lsFcLocale", "fc-local-[switch_id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [u'computeInstance', u'lsServer'], [u'lsFcZoneGroup'], ["Get"]),
    "LsFcZone": MoMeta("LsFcZone", "lsFcZone", "zone-[identity]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [u'lsZoneInitiatorMember'], [u'lsZoneTargetMember'], ["Get"]),
    "LsFcZoneGroup": MoMeta("LsFcZoneGroup", "lsFcZoneGroup", "zone-group-[id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [u'lsFcLocale'], [u'lsZoneInitiatorMember'], ["Get"]),
    "LsIdentityInfo": MoMeta("LsIdentityInfo", "lsIdentityInfo", "ls-identity-info", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'lsServer'], [u'faultInst'], ["Get"]),
    "LsIssues": MoMeta("LsIssues", "lsIssues", "config-issue", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], [u'computeInstance', u'lsServer'], [u'faultInst'], ["Get"]),
    "LsPower": MoMeta("LsPower", "lsPower", "power", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-oper", "ls-server-policy"], [u'computeInstance', u'lsServer'], [], ["Get", "Set"]),
    "LsRequirement": MoMeta("LsRequirement", "lsRequirement", "pn-req", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "read-only"], [u'lsServer'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "LsSPMeta": MoMeta("LsSPMeta", "lsSPMeta", "spmeta", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-oper", "ls-server-policy"], [u'lsServer'], [u'faultInst', u'messageEntry', u'messageEp'], ["Get"]),
    "LsServer": MoMeta("LsServer", "lsServer", "ls-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], [u'computeTemplate', u'orgOrg'], [u'cimcvmediaMountConfigDef', u'computeEnvFeatMask', u'computeNetworkFeatMask', u'computePowerSyncDef', u'computeServerFeatMask', u'computeStorageFeatMask', u'eventInst', u'fabricVCon', u'faultInst', u'identRequestEp', u'lsBinding', u'lsFcLocale', u'lsIdentityInfo', u'lsIssues', u'lsPower', u'lsRequirement', u'lsSPMeta', u'lsServerAssocCtx', u'lsServerExtension', u'lsServerFsm', u'lsServerFsmTask', u'lsServerOperation', u'lsVConAssign', u'lsbootDef', u'lsmaintAck', u'lstorageProfileBinding', u'lstorageProfileDef', u'mgmtInterface', u'storageIniGroup', u'storageIpV4PooledAddr', u'storageIpV4StaticAddr', u'storageLocalDiskConfigDef', u'storageScsiLunInstRef', u'storageVirtualDriveRef', u'vnicConnDef', u'vnicDefBeh', u'vnicDynamicCon', u'vnicEther', u'vnicFc', u'vnicFcNode', u'vnicIScsi', u'vnicIScsiBootParams', u'vnicIScsiLCP', u'vnicIScsiNode', u'vnicIniGrpFc', u'vnicIniGrpFcB', u'vnicIpV4MgmtPooledAddr', u'vnicIpV4PooledAddr', u'vnicIpV4StaticAddr', u'vnicLstorageIScsi', u'vnicMgmt', u'vnicMonSesFc'], ["Add", "Get", "Remove", "Set"]),
    "LsServerAssocCtx": MoMeta("LsServerAssocCtx", "lsServerAssocCtx", "ls-assoc-ctx", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'lsServer'], [u'adaptorUnitAssocCtx', u'computePhysicalAssocCtx', u'processorUnitAssocCtx'], ["Get"]),
    "LsServerExtension": MoMeta("LsServerExtension", "lsServerExtension", "extension", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], [u'lsServer'], [], ["Get", "Set"]),
    "LsServerFsm": MoMeta("LsServerFsm", "lsServerFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'lsServer'], [u'lsServerFsmStage'], [None]),
    "LsServerFsmStage": MoMeta("LsServerFsmStage", "lsServerFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'lsServerFsm'], [], [None]),
    "LsServerFsmTask": MoMeta("LsServerFsmTask", "lsServerFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], [u'lsServer'], [], [None]),
    "LsServerOperation": MoMeta("LsServerOperation", "lsServerOperation", "remote-oper", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-server-oper", "ls-server-policy"], [u'computeInstance', u'lsServer'], [u'faultInst'], ["Get", "Set"]),
    "LsTier": MoMeta("LsTier", "lsTier", "tier-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy"], [u'orgOrg'], [], [None]),
    "LsVConAssign": MoMeta("LsVConAssign", "lsVConAssign", "assign-[transport]-vnic-[vnic_name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], [u'lsServer'], [], ["Add", "Get", "Remove", "Set"]),
    "LsWaitingUserAck": MoMeta("LsWaitingUserAck", "lsWaitingUserAck", "waiting-user-ack", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], [u'orgOrg'], [], ["Get"]),
    "LsZoneInitiatorMember": MoMeta("LsZoneInitiatorMember", "lsZoneInitiatorMember", "initiator-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [u'lsFcZoneGroup'], [u'lsFcZone'], ["Get"]),
    "LsZoneTargetMember": MoMeta("LsZoneTargetMember", "lsZoneTargetMember", "target-[wwpn]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [u'lsFcZone'], [], ["Get"]),
    "LsbootBootSecurity": MoMeta("LsbootBootSecurity", "lsbootBootSecurity", "boot-security", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootDef', u'lsbootPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "LsbootDef": MoMeta("LsbootDef", "lsbootDef", "boot-policy", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'lsServer'], [u'lsbootBootSecurity', u'lsbootEFIShell', u'lsbootIScsi', u'lsbootLan', u'lsbootSan', u'lsbootStorage', u'lsbootVirtualMedia'], ["Add", "Get", "Remove", "Set"]),
    "LsbootDefaultLocalImage": MoMeta("LsbootDefaultLocalImage", "lsbootDefaultLocalImage", "local-any", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalStorage'], [u'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootEFIShell": MoMeta("LsbootEFIShell", "lsbootEFIShell", "efi-shell", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootDef', u'lsbootPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "LsbootEmbeddedLocalDiskImage": MoMeta("LsbootEmbeddedLocalDiskImage", "lsbootEmbeddedLocalDiskImage", "embedded-local-jbod", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalStorage'], [u'lsbootEmbeddedLocalDiskImagePath', u'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootEmbeddedLocalDiskImagePath": MoMeta("LsbootEmbeddedLocalDiskImagePath", "lsbootEmbeddedLocalDiskImagePath", "diskimgpath-[type]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootEmbeddedLocalDiskImage'], [u'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootEmbeddedLocalLunImage": MoMeta("LsbootEmbeddedLocalLunImage", "lsbootEmbeddedLocalLunImage", "embedded-local-lun", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalStorage'], [u'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootIScsi": MoMeta("LsbootIScsi", "lsbootIScsi", "iscsi", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootDef', u'lsbootPolicy'], [u'lsbootIScsiImagePath'], ["Add", "Get", "Remove", "Set"]),
    "LsbootIScsiImagePath": MoMeta("LsbootIScsiImagePath", "lsbootIScsiImagePath", "path-[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootIScsi'], [u'lsbootUEFIBootParam', u'vnicIScsiTargetParams'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLan": MoMeta("LsbootLan", "lsbootLan", "lan", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootDef', u'lsbootPolicy'], [u'lsbootLanImagePath'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLanImagePath": MoMeta("LsbootLanImagePath", "lsbootLanImagePath", "path-[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLan'], [u'lsbootUEFIBootParam', u'vnicIpV4StaticAddr'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLocalDiskImage": MoMeta("LsbootLocalDiskImage", "lsbootLocalDiskImage", "local-jbod", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalStorage'], [u'lsbootLocalDiskImagePath', u'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLocalDiskImagePath": MoMeta("LsbootLocalDiskImagePath", "lsbootLocalDiskImagePath", "diskimgpath-[type]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalDiskImage'], [u'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLocalHddImage": MoMeta("LsbootLocalHddImage", "lsbootLocalHddImage", "local-hdd", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalStorage'], [u'lsbootLocalLunImagePath', u'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLocalLunImagePath": MoMeta("LsbootLocalLunImagePath", "lsbootLocalLunImagePath", "lunimgpath-[type]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalHddImage'], [u'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootLocalStorage": MoMeta("LsbootLocalStorage", "lsbootLocalStorage", "local-storage", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootStorage'], [u'lsbootDefaultLocalImage', u'lsbootEmbeddedLocalDiskImage', u'lsbootEmbeddedLocalLunImage', u'lsbootLocalDiskImage', u'lsbootLocalHddImage', u'lsbootNvme', u'lsbootUsbExternalImage', u'lsbootUsbFlashStorageImage', u'lsbootUsbInternalImage'], ["Add", "Get", "Remove"]),
    "LsbootNvme": MoMeta("LsbootNvme", "lsbootNvme", "nvme", VersionMeta.Version201f, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalStorage'], [u'lsbootNvmeDiskSsd', u'lsbootNvmePciSsd', u'lsbootUEFIBootParam'], [None]),
    "LsbootNvmeDiskSsd": MoMeta("LsbootNvmeDiskSsd", "lsbootNvmeDiskSsd", "nvme-disk-ssd", VersionMeta.Version201f, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootNvme'], [], [None]),
    "LsbootNvmePciSsd": MoMeta("LsbootNvmePciSsd", "lsbootNvmePciSsd", "nvme-pci-ssd", VersionMeta.Version201f, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootNvme'], [], [None]),
    "LsbootPolicy": MoMeta("LsbootPolicy", "lsbootPolicy", "boot-policy-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg', u'policySystemEp'], [u'lsbootBootSecurity', u'lsbootEFIShell', u'lsbootIScsi', u'lsbootLan', u'lsbootSan', u'lsbootStorage', u'lsbootUpgradeStatus', u'lsbootVirtualMedia'], ["Add", "Get", "Remove", "Set"]),
    "LsbootSan": MoMeta("LsbootSan", "lsbootSan", "san", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootDef', u'lsbootPolicy'], [u'lsbootSanCatSanImage'], ["Add", "Get", "Remove", "Set"]),
    "LsbootSanCatSanImage": MoMeta("LsbootSanCatSanImage", "lsbootSanCatSanImage", "sanimg-[type]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootSan'], [u'lsbootSanCatSanImagePath'], ["Add", "Get", "Remove", "Set"]),
    "LsbootSanCatSanImagePath": MoMeta("LsbootSanCatSanImagePath", "lsbootSanCatSanImagePath", "sanimgpath-[type]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootSanCatSanImage'], [u'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootSanImage": MoMeta("LsbootSanImage", "lsbootSanImage", "san-[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootStorage'], [u'lsbootSanImagePath'], ["Add", "Get", "Remove", "Set"]),
    "LsbootSanImagePath": MoMeta("LsbootSanImagePath", "lsbootSanImagePath", "path-[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootSanImage'], [u'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootStorage": MoMeta("LsbootStorage", "lsbootStorage", "storage", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootDef', u'lsbootPolicy'], [u'lsbootLocalStorage', u'lsbootSanImage'], ["Add", "Get", "Remove", "Set"]),
    "LsbootUEFIBootParam": MoMeta("LsbootUEFIBootParam", "lsbootUEFIBootParam", "uefi-boot-param", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-config-policy", "ls-server-policy", "ls-storage-policy"], [u'lsbootDefaultLocalImage', u'lsbootEmbeddedLocalDiskImage', u'lsbootEmbeddedLocalDiskImagePath', u'lsbootEmbeddedLocalLunImage', u'lsbootIScsiImagePath', u'lsbootLanImagePath', u'lsbootLocalDiskImage', u'lsbootLocalDiskImagePath', u'lsbootLocalHddImage', u'lsbootLocalLunImagePath', u'lsbootNvme', u'lsbootSanCatSanImagePath', u'lsbootSanImagePath', u'lsbootUsbExternalImage', u'lsbootUsbFlashStorageImage', u'lsbootUsbInternalImage'], [], ["Add", "Get", "Remove", "Set"]),
    "LsbootUpgradeStatus": MoMeta("LsbootUpgradeStatus", "lsbootUpgradeStatus", "UpgradeStatus", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin"], [u'lsbootPolicy'], [], ["Get", "Set"]),
    "LsbootUsbExternalImage": MoMeta("LsbootUsbExternalImage", "lsbootUsbExternalImage", "usb-extern", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalStorage'], [u'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootUsbFlashStorageImage": MoMeta("LsbootUsbFlashStorageImage", "lsbootUsbFlashStorageImage", "sd-card", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalStorage'], [u'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootUsbInternalImage": MoMeta("LsbootUsbInternalImage", "lsbootUsbInternalImage", "usb-intern", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootLocalStorage'], [u'lsbootUEFIBootParam'], ["Add", "Get", "Remove", "Set"]),
    "LsbootVirtualMedia": MoMeta("LsbootVirtualMedia", "lsbootVirtualMedia", "[access]-vm", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-policy", "ls-storage", "ls-storage-policy"], [u'lsbootDef', u'lsbootPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "LsmaintAck": MoMeta("LsmaintAck", "lsmaintAck", "ack", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], [u'computeInstance', u'lsServer'], [u'faultInst'], ["Get", "Set"]),
    "LsmaintMaintPolicy": MoMeta("LsmaintMaintPolicy", "lsmaintMaintPolicy", "maint-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'orgDomainGroup', u'orgOrg'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "LstorageAck": MoMeta("LstorageAck", "lstorageAck", "ack", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [], [u'faultInst'], [None]),
    "LstorageArrayRequirement": MoMeta("LstorageArrayRequirement", "lstorageArrayRequirement", "strreq-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [u'orgOrg'], [], [None]),
    "LstorageBlade": MoMeta("LstorageBlade", "lstorageBlade", "lstorage-blade-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'extpolDomain'], [], [None]),
    "LstorageControllerDef": MoMeta("LstorageControllerDef", "lstorageControllerDef", "controller-def-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'lstorageProfile', u'lstorageProfileDef', u'storageController'], [u'lstorageControllerModeConfig', u'lstorageControllerQualifier'], [None]),
    "LstorageControllerModeConfig": MoMeta("LstorageControllerModeConfig", "lstorageControllerModeConfig", "controller-mode-config", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'lstorageControllerDef'], [], [None]),
    "LstorageControllerQualifier": MoMeta("LstorageControllerQualifier", "lstorageControllerQualifier", "controller-qual", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'lstorageControllerDef'], [], [None]),
    "LstorageControllerRef": MoMeta("LstorageControllerRef", "lstorageControllerRef", "server-[server_id]-controller-[controller_type]-[controller_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'lstorageDiskSlot'], [], ["Add", "Get", "Remove"]),
    "LstorageCtrlServiceOperation": MoMeta("LstorageCtrlServiceOperation", "lstorageCtrlServiceOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage", "pn-equipment", "pn-maintenance", "pn-policy"], [], [u'faultInst'], [None]),
    "LstorageDasScsiLun": MoMeta("LstorageDasScsiLun", "lstorageDasScsiLun", "das-scsi-lun-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], [u'lstorageProfile', u'lstorageProfileDef'], [u'faultInst', u'storageLocalDiskConfigDef'], ["Add", "Get", "Remove", "Set"]),
    "LstorageDiskGroupConfigDef": MoMeta("LstorageDiskGroupConfigDef", "lstorageDiskGroupConfigDef", "disk-group-config", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'storageVirtualDriveRef'], [u'lstorageDiskGroupQualifier', u'lstorageLocalDiskConfigRef', u'lstorageVirtualDriveDef'], ["Get"]),
    "LstorageDiskGroupConfigPolicy": MoMeta("LstorageDiskGroupConfigPolicy", "lstorageDiskGroupConfigPolicy", "disk-group-config-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'orgOrg'], [u'lstorageDiskGroupQualifier', u'lstorageLocalDiskConfigRef', u'lstorageVirtualDriveDef'], ["Add", "Get", "Remove", "Set"]),
    "LstorageDiskGroupQualifier": MoMeta("LstorageDiskGroupQualifier", "lstorageDiskGroupQualifier", "disk-group-qual", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'lstorageDiskGroupConfigDef', u'lstorageDiskGroupConfigPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "LstorageDiskSlot": MoMeta("LstorageDiskSlot", "lstorageDiskSlot", "disk-slot-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'lstorageDiskZoningConfigDef', u'lstorageDiskZoningPolicy'], [u'lstorageControllerRef'], ["Add", "Get", "Remove", "Set"]),
    "LstorageDiskZoningConfigDef": MoMeta("LstorageDiskZoningConfigDef", "lstorageDiskZoningConfigDef", "disk-zoning-def", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassisProfile'], [u'lstorageDiskSlot'], [None]),
    "LstorageDiskZoningPolicy": MoMeta("LstorageDiskZoningPolicy", "lstorageDiskZoningPolicy", "disk-zoning-policy-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'lstorageDiskSlot'], ["Add", "Get", "Remove", "Set"]),
    "LstorageDriveSecurity": MoMeta("LstorageDriveSecurity", "lstorageDriveSecurity", "drive", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'lstorageSecurity'], [u'lstorageLocal', u'lstorageRemote'], ["add", "get", "remove"]),
    "LstorageExtension": MoMeta("LstorageExtension", "lstorageExtension", "extension", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [], [], [None]),
    "LstorageLocal": MoMeta("LstorageLocal", "lstorageLocal", "local", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'computeBoard', u'lstorageDriveSecurity'], [], ["add", "get", "remove", "set"]),
    "LstorageLocalDef": MoMeta("LstorageLocalDef", "lstorageLocalDef", "local-def", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'computeBoard'], [], [None]),
    "LstorageLocalDiskConfigRef": MoMeta("LstorageLocalDiskConfigRef", "lstorageLocalDiskConfigRef", "slot-[slot_num]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'lstorageDiskGroupConfigDef', u'lstorageDiskGroupConfigPolicy'], [], ["Add", "Get", "Remove", "Set"]),
    "LstorageLocalDiskRef": MoMeta("LstorageLocalDiskRef", "lstorageLocalDiskRef", "diskref-[enclosure_id]-slot-[slot_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], ["Add", "Get", "Remove"]),
    "LstorageLogin": MoMeta("LstorageLogin", "lstorageLogin", "login", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'lstorageRemote', u'lstorageRemoteDef'], [], ["add", "get", "remove", "set"]),
    "LstorageMeta": MoMeta("LstorageMeta", "lstorageMeta", "meta", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [], [], [None]),
    "LstorageProfile": MoMeta("LstorageProfile", "lstorageProfile", "profile-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], [u'orgOrg'], [u'lstorageControllerDef', u'lstorageDasScsiLun', u'lstorageSecurity'], ["Add", "Get", "Remove", "Set"]),
    "LstorageProfileBinding": MoMeta("LstorageProfileBinding", "lstorageProfileBinding", "profile-binding", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], [u'lsServer'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "LstorageProfileDef": MoMeta("LstorageProfileDef", "lstorageProfileDef", "profile-def", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], [u'lsServer'], [u'lstorageControllerDef', u'lstorageDasScsiLun', u'lstorageSecurity'], ["Add", "Get", "Remove", "Set"]),
    "LstorageRecurrWindow": MoMeta("LstorageRecurrWindow", "lstorageRecurrWindow", "recurr-window-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage", "ls-storage-policy"], [u'trigSched'], [], [None]),
    "LstorageRemote": MoMeta("LstorageRemote", "lstorageRemote", "remote", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'computeBoard', u'lstorageDriveSecurity'], [u'lstorageLogin'], ["add", "get", "remove", "set"]),
    "LstorageRemoteDef": MoMeta("LstorageRemoteDef", "lstorageRemoteDef", "remote-def", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'computeBoard'], [u'lstorageLogin'], [None]),
    "LstorageRequestCtx": MoMeta("LstorageRequestCtx", "lstorageRequestCtx", "", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "LstorageSecurity": MoMeta("LstorageSecurity", "lstorageSecurity", "security", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'lstorageProfile', u'lstorageProfileDef', u'storageLocalDiskConfigDef', u'storageLocalDiskConfigPolicy'], [u'lstorageDriveSecurity'], ["add", "get", "remove", "set"]),
    "LstorageVirtualDriveDef": MoMeta("LstorageVirtualDriveDef", "lstorageVirtualDriveDef", "virtual-drive-def", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'lstorageDiskGroupConfigDef', u'lstorageDiskGroupConfigPolicy'], [], ["Get", "Set"]),
    "MacpoolAddr": MoMeta("MacpoolAddr", "macpoolAddr", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'macpoolUniverse'], [u'faultInst', u'identpoolConsumed', u'identpoolPoolable'], ["Get"]),
    "MacpoolBlock": MoMeta("MacpoolBlock", "macpoolBlock", "block-[r_from]-[to]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-network-policy"], [u'macpoolPool'], [], ["Add", "Get", "Remove"]),
    "MacpoolFormat": MoMeta("MacpoolFormat", "macpoolFormat", "format-[format]-[mask]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ls-network", "ls-network-policy"], [u'macpoolUniverse'], [], ["Get"]),
    "MacpoolPool": MoMeta("MacpoolPool", "macpoolPool", "mac-pool-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'faultInst', u'macpoolBlock', u'macpoolPooled'], ["Add", "Get", "Remove", "Set"]),
    "MacpoolPooled": MoMeta("MacpoolPooled", "macpoolPooled", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'macpoolPool'], [], ["Get"]),
    "MacpoolUniverse": MoMeta("MacpoolUniverse", "macpoolUniverse", "mac", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'macpoolAddr', u'macpoolFormat'], ["Get"]),
    "MemoryArray": MoMeta("MemoryArray", "memoryArray", "memarray-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'computeBoard'], [u'faultInst', u'memoryArrayEnvStats', u'memoryNvDimmBattery', u'memoryNvDimmController', u'memoryUnit'], ["Get"]),
    "MemoryArrayEnvStats": MoMeta("MemoryArrayEnvStats", "memoryArrayEnvStats", "array-env-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'memoryArray'], [u'memoryArrayEnvStatsHist'], [None]),
    "MemoryArrayEnvStatsHist": MoMeta("MemoryArrayEnvStatsHist", "memoryArrayEnvStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'memoryArrayEnvStats'], [], [None]),
    "MemoryBufferUnit": MoMeta("MemoryBufferUnit", "memoryBufferUnit", "sensor-unit-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'computeBoard'], [u'faultInst', u'memoryBufferUnitEnvStats'], ["Get"]),
    "MemoryBufferUnitEnvStats": MoMeta("MemoryBufferUnitEnvStats", "memoryBufferUnitEnvStats", "buffer-unit-env-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'memoryBufferUnit'], [u'memoryBufferUnitEnvStatsHist'], [None]),
    "MemoryBufferUnitEnvStatsHist": MoMeta("MemoryBufferUnitEnvStatsHist", "memoryBufferUnitEnvStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'memoryBufferUnitEnvStats'], [], [None]),
    "MemoryErrorStats": MoMeta("MemoryErrorStats", "memoryErrorStats", "error-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'memoryUnit'], [u'memoryErrorStatsHist'], [None]),
    "MemoryErrorStatsHist": MoMeta("MemoryErrorStatsHist", "memoryErrorStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'memoryErrorStats'], [], [None]),
    "MemoryNvDimm": MoMeta("MemoryNvDimm", "memoryNvDimm", "nvdimm-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'memoryNvDimmController'], [], ["Get"]),
    "MemoryNvDimmBattery": MoMeta("MemoryNvDimmBattery", "memoryNvDimmBattery", "nvdimm-batt-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'memoryArray'], [], ["Get"]),
    "MemoryNvDimmController": MoMeta("MemoryNvDimmController", "memoryNvDimmController", "mem-controller-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'memoryArray'], [u'memoryNvDimm'], ["Get"]),
    "MemoryQual": MoMeta("MemoryQual", "memoryQual", "memory", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], [u'computeQual'], [], ["Add", "Get", "Remove", "Set"]),
    "MemoryRuntime": MoMeta("MemoryRuntime", "memoryRuntime", "[type]-mem-rt", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'computeBlade'], [u'memoryRuntimeHist'], ["Get"]),
    "MemoryRuntimeHist": MoMeta("MemoryRuntimeHist", "memoryRuntimeHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'memoryRuntime'], [], [None]),
    "MemoryUnit": MoMeta("MemoryUnit", "memoryUnit", "mem-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'memoryArray'], [u'faultInst', u'memoryErrorStats', u'memoryUnitEnvStats'], ["Get"]),
    "MemoryUnitEnvStats": MoMeta("MemoryUnitEnvStats", "memoryUnitEnvStats", "dimm-env-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'memoryUnit'], [u'memoryUnitEnvStatsHist'], [None]),
    "MemoryUnitEnvStatsHist": MoMeta("MemoryUnitEnvStatsHist", "memoryUnitEnvStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'memoryUnitEnvStats'], [], [None]),
    "MessageEntry": MoMeta("MessageEntry", "messageEntry", "entry-[id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], [u'lsSPMeta', u'messageEp'], [], ["Get"]),
    "MessageEp": MoMeta("MessageEp", "messageEp", "ep", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'domainProfile', u'equipmentCPMeta', u'fabricDceSwSrvPcOperation', u'fabricEthEstcEpOperation', u'fabricEthEstcPcOperation', u'fabricEthLanEpOperation', u'fabricEthLanPcOperation', u'fabricEthMonOperation', u'fabricFcEstcEpOperation', u'fabricFcMonOperation', u'fabricFcSanEpOperation', u'fabricFcSanPcOperation', u'fabricFcUserZone', u'fabricFcoeEstcEpOperation', u'fabricFcoeSanEpOperation', u'fabricFcoeSanPcOperation', u'fdBlade', u'fdChassis', u'fdRackUnit', u'glBlockOp', u'glIdentCtxOp', u'glIdentCtxResOp', u'glMcastPolicy', u'glPolicy', u'glPolicyAlgorithmedOp', u'glPolicyOp', u'glPolicyResOp', u'glPool', u'glPoolOp', u'glRequest', u'glServerPoolResOp', u'glServiceProfile', u'glTemplateOp', u'glTemplateResOp', u'glVlan', u'glVsan', u'glVxanOp', u'glVxanResOp', u'lsSPMeta', u'vnicOutbandMgmtEp'], [u'messageEntry'], [None]),
    "MgmtBackup": MoMeta("MgmtBackup", "mgmtBackup", "backup-[hostname]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'computeSystem', u'extpolClient', u'topSystem'], [u'computeRemoteOpStatus', u'eventInst', u'faultInst', u'mgmtBackupFsm', u'mgmtBackupFsmTask'], ["Add", "Get", "Remove", "Set"]),
    "MgmtBackupFsm": MoMeta("MgmtBackupFsm", "mgmtBackupFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'mgmtBackup'], [u'mgmtBackupFsmStage'], [None]),
    "MgmtBackupFsmStage": MoMeta("MgmtBackupFsmStage", "mgmtBackupFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'mgmtBackupFsm'], [], [None]),
    "MgmtBackupFsmTask": MoMeta("MgmtBackupFsmTask", "mgmtBackupFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'mgmtBackup'], [], ["Get"]),
    "MgmtBackupOperation": MoMeta("MgmtBackupOperation", "mgmtBackupOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [u'computeSystem'], [u'faultInst'], ["Get", "Set"]),
    "MgmtBackupPolicy": MoMeta("MgmtBackupPolicy", "mgmtBackupPolicy", "db-backup-policy-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'orgDomainGroup', u'orgOrg', u'policyDeviceProfile'], [u'faultInst', u'mgmtBackupTrigger'], ["Add", "Get", "Remove", "Set"]),
    "MgmtBackupTrigger": MoMeta("MgmtBackupTrigger", "mgmtBackupTrigger", "trigger", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'mgmtBackupPolicy', u'mgmtCfgExportPolicy'], [u'eventInst', u'faultInst', u'mgmtBackupTriggerFsm', u'mgmtBackupTriggerFsmTask'], ["Get", "Set"]),
    "MgmtBackupTriggerFsm": MoMeta("MgmtBackupTriggerFsm", "mgmtBackupTriggerFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'mgmtBackupTrigger'], [u'mgmtBackupTriggerFsmStage'], [None]),
    "MgmtBackupTriggerFsmStage": MoMeta("MgmtBackupTriggerFsmStage", "mgmtBackupTriggerFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'mgmtBackupTriggerFsm'], [], [None]),
    "MgmtBackupTriggerFsmTask": MoMeta("MgmtBackupTriggerFsmTask", "mgmtBackupTriggerFsmTask", "task-[item]", VersionMeta.Version131a, "OutputOnly", 0x1, [], [""], [u'mgmtBackupTrigger'], [], [None]),
    "MgmtCfgExportPolicy": MoMeta("MgmtCfgExportPolicy", "mgmtCfgExportPolicy", "cfg-exp-policy-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'orgDomainGroup', u'orgOrg', u'policyDeviceProfile'], [u'faultInst', u'mgmtBackupTrigger'], ["Add", "Get", "Remove", "Set"]),
    "MgmtCmcSecureBoot": MoMeta("MgmtCmcSecureBoot", "mgmtCmcSecureBoot", "mgmt-cmc-secure-boot", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-compute"], [u'mgmtController'], [u'mgmtCmcSecureBootOperation'], ["Get"]),
    "MgmtCmcSecureBootOperation": MoMeta("MgmtCmcSecureBootOperation", "mgmtCmcSecureBootOperation", "remote-oper", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-compute"], [u'mgmtCmcSecureBoot'], [u'faultInst'], ["Get", "Set"]),
    "MgmtConnection": MoMeta("MgmtConnection", "mgmtConnection", "mgmt-connection-[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'mgmtController'], [], ["Get", "Set"]),
    "MgmtController": MoMeta("MgmtController", "mgmtController", "mgmt", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'adaptorUnit', u'computeBlade', u'computeBoardController', u'computeRackUnit', u'computeServerUnit', u'computeSystem', u'equipmentChassis', u'equipmentIOCard', u'equipmentSharedIOModule', u'equipmentSwitchIOCard', u'equipmentSystemIOController', u'networkElement', u'storageController', u'storageSasExpander', u'topSystem'], [u'cimcvmediaActualMountList', u'firmwareRunning', u'mgmtCmcSecureBoot', u'mgmtConnection', u'mgmtIf', u'mgmtInterface', u'vnicIpV4PooledAddr', u'vnicIpV4ProfDerivedAddr', u'vnicIpV4StaticAddr'], ["Get"]),
    "MgmtDataExporter": MoMeta("MgmtDataExporter", "mgmtDataExporter", "exporter-[hostname]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'eventInst', u'faultInst', u'mgmtDataExporterFsm', u'mgmtDataExporterFsmTask', u'mgmtDataItem'], ["Get", "Remove", "Set"]),
    "MgmtDataExporterFsm": MoMeta("MgmtDataExporterFsm", "mgmtDataExporterFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'mgmtDataExporter'], [u'mgmtDataExporterFsmStage'], [None]),
    "MgmtDataExporterFsmStage": MoMeta("MgmtDataExporterFsmStage", "mgmtDataExporterFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'mgmtDataExporterFsm'], [], [None]),
    "MgmtDataExporterFsmTask": MoMeta("MgmtDataExporterFsmTask", "mgmtDataExporterFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'mgmtDataExporter'], [], ["Get"]),
    "MgmtDataImporter": MoMeta("MgmtDataImporter", "mgmtDataImporter", "importer-[hostname]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [u'eventInst', u'faultInst', u'mgmtDataImporterFsm', u'mgmtDataImporterFsmTask', u'mgmtImportItem'], ["Get", "Remove", "Set"]),
    "MgmtDataImporterFsm": MoMeta("MgmtDataImporterFsm", "mgmtDataImporterFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'mgmtDataImporter'], [u'mgmtDataImporterFsmStage'], [None]),
    "MgmtDataImporterFsmStage": MoMeta("MgmtDataImporterFsmStage", "mgmtDataImporterFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'mgmtDataImporterFsm'], [], [None]),
    "MgmtDataImporterFsmTask": MoMeta("MgmtDataImporterFsmTask", "mgmtDataImporterFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'mgmtDataImporter'], [], ["Get"]),
    "MgmtDataItem": MoMeta("MgmtDataItem", "mgmtDataItem", "exp-provider-[sysid]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'mgmtDataExporter'], [], ["Get"]),
    "MgmtEntity": MoMeta("MgmtEntity", "mgmtEntity", "mgmt-entity-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'computeSystem', u'topSystem'], [], ["Get"]),
    "MgmtEp": MoMeta("MgmtEp", "mgmtEp", "mgmt-ep", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'mgmtSvc'], [None]),
    "MgmtIPv6IfAddr": MoMeta("MgmtIPv6IfAddr", "mgmtIPv6IfAddr", "if-ipv6", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], [u'mgmtIPv6IfConfig', u'networkElement'], [], ["Get", "Set"]),
    "MgmtIPv6IfConfig": MoMeta("MgmtIPv6IfConfig", "mgmtIPv6IfConfig", "ifConfig-ipv6", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], [u'mgmtIf', u'networkElement'], [u'mgmtIPv6IfAddr'], ["Get", "Set"]),
    "MgmtIf": MoMeta("MgmtIf", "mgmtIf", "if-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'mgmtController'], [u'eventInst', u'faultInst', u'mgmtIPv6IfConfig', u'mgmtIfFsm', u'mgmtIfFsmTask'], ["Get"]),
    "MgmtIfFsm": MoMeta("MgmtIfFsm", "mgmtIfFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'mgmtIf'], [u'mgmtIfFsmStage'], [None]),
    "MgmtIfFsmStage": MoMeta("MgmtIfFsmStage", "mgmtIfFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'mgmtIfFsm'], [], [None]),
    "MgmtIfFsmTask": MoMeta("MgmtIfFsmTask", "mgmtIfFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], [u'mgmtIf'], [], [None]),
    "MgmtImportItem": MoMeta("MgmtImportItem", "mgmtImportItem", "imp-provider-[sysid]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'mgmtDataImporter'], [u'faultInst'], ["Get"]),
    "MgmtImporter": MoMeta("MgmtImporter", "mgmtImporter", "import-config-[hostname]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'consumerInst', u'topSystem'], [u'eventInst', u'faultInst', u'mgmtImporterFsm', u'mgmtImporterFsmTask'], ["Add", "Get", "Remove", "Set"]),
    "MgmtImporterFsm": MoMeta("MgmtImporterFsm", "mgmtImporterFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'mgmtImporter'], [u'mgmtImporterFsmStage'], [None]),
    "MgmtImporterFsmStage": MoMeta("MgmtImporterFsmStage", "mgmtImporterFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'mgmtImporterFsm'], [], [None]),
    "MgmtImporterFsmTask": MoMeta("MgmtImporterFsmTask", "mgmtImporterFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'mgmtImporter'], [], ["Get"]),
    "MgmtInbandProfile": MoMeta("MgmtInbandProfile", "mgmtInbandProfile", "ib-profile", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy"], [u'fabricLanCloud'], [], ["Get", "Set"]),
    "MgmtInterface": MoMeta("MgmtInterface", "mgmtInterface", "iface-[mode]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'computeInstance', u'lsServer', u'mgmtController'], [u'mgmtVnet'], ["Add", "Get", "Remove", "Set"]),
    "MgmtKmip": MoMeta("MgmtKmip", "mgmtKmip", "kmip", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'mgmtSecurity'], [u'mgmtKmipOperation'], ["get"]),
    "MgmtKmipCertPolicy": MoMeta("MgmtKmipCertPolicy", "mgmtKmipCertPolicy", "kmip-cert", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-oper", "ls-server-policy", "read-only"], [u'orgDomainGroup'], [], ["add", "get", "remove", "set"]),
    "MgmtKmipOperation": MoMeta("MgmtKmipOperation", "mgmtKmipOperation", "remote-oper", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'mgmtKmip'], [u'faultInst'], ["get", "set"]),
    "MgmtNamedKmipCertPolicy": MoMeta("MgmtNamedKmipCertPolicy", "mgmtNamedKmipCertPolicy", "kmip-cert-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["aaa", "admin", "domain-group-management", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-server-oper", "ls-server-policy", "read-only"], [u'orgDomainGroup'], [], ["add", "get", "remove", "set"]),
    "MgmtRegistryInfo": MoMeta("MgmtRegistryInfo", "mgmtRegistryInfo", "registryinfo", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], [u'topSystem'], [u'eventInst', u'faultInst', u'mgmtRegistryInfoFsm', u'mgmtRegistryInfoFsmTask'], [None]),
    "MgmtRegistryInfoFsm": MoMeta("MgmtRegistryInfoFsm", "mgmtRegistryInfoFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'mgmtRegistryInfo'], [u'mgmtRegistryInfoFsmStage'], [None]),
    "MgmtRegistryInfoFsmStage": MoMeta("MgmtRegistryInfoFsmStage", "mgmtRegistryInfoFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'mgmtRegistryInfoFsm'], [], [None]),
    "MgmtRegistryInfoFsmTask": MoMeta("MgmtRegistryInfoFsmTask", "mgmtRegistryInfoFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'mgmtRegistryInfo'], [], [None]),
    "MgmtSecurity": MoMeta("MgmtSecurity", "mgmtSecurity", "sec", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [u'mgmtKmip'], ["get"]),
    "MgmtSvc": MoMeta("MgmtSvc", "mgmtSvc", "mgmt-svc-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'mgmtEp'], [], [None]),
    "MgmtVnet": MoMeta("MgmtVnet", "mgmtVnet", "network", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'mgmtInterface'], [u'storageIpV4PooledAddr', u'storageIpV4StaticAddr', u'vnicIpV4MgmtPooledAddr', u'vnicIpV4PooledAddr', u'vnicIpV4StaticAddr', u'vnicIpV6MgmtPooledAddr', u'vnicIpV6StaticAddr'], ["Add", "Get", "Remove", "Set"]),
    "NetNetGroupPermit": MoMeta("NetNetGroupPermit", "netNetGroupPermit", "ngperm-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], [""], [u'orgOrg'], [], [None]),
    "NetworkElement": MoMeta("NetworkElement", "networkElement", "switch-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], [u'computeSystem', u'topSystem'], [u'equipmentFan', u'equipmentFanModule', u'equipmentLocatorLed', u'equipmentPsu', u'equipmentSwitchCard', u'eventInst', u'faultInst', u'firmwareStatus', u'mgmtController', u'mgmtIPv6IfAddr', u'mgmtIPv6IfConfig', u'networkElementFsm', u'networkElementFsmTask', u'networkElementOperation', u'networkSystemCACert', u'storageItem', u'swCardEnvStats', u'swEnvStats', u'swSystemStats'], ["Get", "Set"]),
    "NetworkElementFsm": MoMeta("NetworkElementFsm", "networkElementFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'networkElement'], [u'networkElementFsmStage'], [None]),
    "NetworkElementFsmStage": MoMeta("NetworkElementFsmStage", "networkElementFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'networkElementFsm'], [], [None]),
    "NetworkElementFsmTask": MoMeta("NetworkElementFsmTask", "networkElementFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'networkElement'], [], [None]),
    "NetworkElementOperation": MoMeta("NetworkElementOperation", "networkElementOperation", "remote-oper", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], [u'networkElement'], [u'faultInst'], ["get", "set"]),
    "NetworkSystemCACert": MoMeta("NetworkSystemCACert", "networkSystemCACert", "system-ca-cert", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "read-only"], [u'networkElement'], [], [None]),
    "NfsClientDef": MoMeta("NfsClientDef", "nfsClientDef", "nfs-client-def-[ip]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'nfsExportDef'], [u'eventInst', u'faultInst', u'nfsClientDefFsm', u'nfsClientDefFsmTask'], [None]),
    "NfsClientDefFsm": MoMeta("NfsClientDefFsm", "nfsClientDefFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'nfsClientDef'], [u'nfsClientDefFsmStage'], [None]),
    "NfsClientDefFsmStage": MoMeta("NfsClientDefFsmStage", "nfsClientDefFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'nfsClientDefFsm'], [], [None]),
    "NfsClientDefFsmTask": MoMeta("NfsClientDefFsmTask", "nfsClientDefFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'nfsClientDef'], [], [None]),
    "NfsEp": MoMeta("NfsEp", "nfsEp", "nfs-ep", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'nfsExportDef'], [None]),
    "NfsExportDef": MoMeta("NfsExportDef", "nfsExportDef", "nfs-export-def-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'nfsEp'], [u'eventInst', u'faultInst', u'nfsClientDef', u'nfsExportDefFsm', u'nfsExportDefFsmTask', u'storageItem'], [None]),
    "NfsExportDefFsm": MoMeta("NfsExportDefFsm", "nfsExportDefFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'nfsExportDef'], [u'nfsExportDefFsmStage'], [None]),
    "NfsExportDefFsmStage": MoMeta("NfsExportDefFsmStage", "nfsExportDefFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'nfsExportDefFsm'], [], [None]),
    "NfsExportDefFsmTask": MoMeta("NfsExportDefFsmTask", "nfsExportDefFsmTask", "task-[item]", VersionMeta.Version111a, "OutputOnly", 0x1, [], [""], [u'nfsExportDef'], [], [None]),
    "NfsMountDef": MoMeta("NfsMountDef", "nfsMountDef", "nfs-mount-def-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'consumerInst'], [], [None]),
    "NfsRepositorySpecPolicy": MoMeta("NfsRepositorySpecPolicy", "nfsRepositorySpecPolicy", "repository-spec", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "read-only"], [u'orgDomainGroup'], [], [None]),
    "NwctrlDefinition": MoMeta("NwctrlDefinition", "nwctrlDefinition", "nwctrl-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'fabricEthEstcCloud', u'orgDomainGroup', u'orgOrg', u'policySystemEp'], [u'dpsecMac'], ["Add", "Get", "Remove", "Set"]),
    "ObserveFilter": MoMeta("ObserveFilter", "observeFilter", "filter-[filter_class_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'observeObserved'], [], [None]),
    "ObserveObserved": MoMeta("ObserveObserved", "observeObserved", "observed-[data_src_sys_id]-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'extpolClient', u'extpolController', u'extpolProvider', u'extpolRegistry', u'observeObservedCont'], [u'eventInst', u'faultInst', u'observeFilter', u'observeObservedFsm', u'observeObservedFsmTask'], [None]),
    "ObserveObservedCont": MoMeta("ObserveObservedCont", "observeObservedCont", "observe", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'observeObserved'], [None]),
    "ObserveObservedFsm": MoMeta("ObserveObservedFsm", "observeObservedFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'observeObserved'], [u'observeObservedFsmStage'], [None]),
    "ObserveObservedFsmStage": MoMeta("ObserveObservedFsmStage", "observeObservedFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'observeObservedFsm'], [], [None]),
    "ObserveObservedFsmTask": MoMeta("ObserveObservedFsmTask", "observeObservedFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'observeObserved'], [], [None]),
    "OrgDomainFirmwareInfo": MoMeta("OrgDomainFirmwareInfo", "orgDomainFirmwareInfo", "domain-fw-info-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'orgMaintTagFirmwareReport'], [], ["Get"]),
    "OrgDomainGroup": MoMeta("OrgDomainGroup", "orgDomainGroup", "domaingroup-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "read-only"], [u'orgDomainGroup'], [u'aaaAuthRealm', u'aaaEpAuthProfile', u'aaaLdapEp', u'aaaLocale', u'aaaPwdProfile', u'aaaRadiusEp', u'aaaRole', u'aaaTacacsPlusEp', u'aaaUser', u'callhomeEp', u'commCimxml', u'commCoreFile', u'commDateTime', u'commDns', u'commEvtChannel', u'commHttp', u'commHttps', u'commShellSvcLimits', u'commSmashCLP', u'commSnmp', u'commSsh', u'commSyslog', u'commTelnet', u'commWebChannel', u'commWebSvcLimits', u'commWsman', u'commXmlClConnPolicy', u'computeAutoconfigPolicy', u'computeBladeDiscPolicy', u'computeBladeInheritPolicy', u'computeChassisConnPolicy', u'computeChassisDiscPolicy', u'computeDomainHwChangeDiscPolicy', u'computeDomainPortDiscPolicy', u'computeGroupMembershipRef', u'computeHwChangeDiscPolicy', u'computePortDiscPolicy', u'computePsuPolicy', u'computeServerDiscPolicy', u'computeServerMgmtPolicy', u'diagRunPolicy', u'domainProfile', u'extmgmtIfMonPolicy', u'fabricEp', u'fabricEthLinkProfile', u'fabricLacpPolicy', u'fabricLanCloudPolicy', u'fabricMulticastPolicy', u'fabricUdldLinkPolicy', u'faultPolicy', u'firmwareAutoSyncPolicy', u'firmwareCatalogPack', u'firmwareCatalogPackConfig', u'firmwareChassisPack', u'firmwareComputeHostPack', u'firmwareComputeMgmtPack', u'firmwareComputeStoragePack', u'firmwareConnectionPolicy', u'firmwareDownloadPolicy', u'firmwareInfraPack', u'firmwareInfraPackConfig', u'firmwareInfraPolicy', u'firmwarePolicy', u'flowctrlDefinition', u'hcDownloadPolicy', u'inbandPolicy', u'ippoolPool', u'lsmaintMaintPolicy', u'mgmtBackupPolicy', u'mgmtCfgExportPolicy', u'mgmtKmipCertPolicy', u'mgmtNamedKmipCertPolicy', u'nfsRepositorySpecPolicy', u'nwctrlDefinition', u'orgDomainGroup', u'pkiTP', u'policyIdentifierPolicy', u'policyLogProfile', u'powerEp', u'powerMgmtPolicy', u'qosclassDefinition', u'qosclassPolicy', u'sysdebugAutoCoreFileExportTarget', u'sysdebugMEpLogPolicy', u'topInfoSyncPolicy', u'trigMeta', u'trigPendingAckCount', u'trigSched', u'trigTest'], ["Add", "Get", "Remove", "Set"]),
    "OrgDomainGroupFirmwareReport": MoMeta("OrgDomainGroupFirmwareReport", "orgDomainGroupFirmwareReport", "firmware-report-[domain_group_dn]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [u'orgFirmwareVersionCount'], [None]),
    "OrgDomainGroupPolicy": MoMeta("OrgDomainGroupPolicy", "orgDomainGroupPolicy", "domaingroup-policy-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "OrgDomainGroupPolicyReport": MoMeta("OrgDomainGroupPolicyReport", "orgDomainGroupPolicyReport", "policy-report-[domain_group_dn]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "OrgExtension": MoMeta("OrgExtension", "orgExtension", "extension", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [], ["Get"]),
    "OrgFirmwareVersionCount": MoMeta("OrgFirmwareVersionCount", "orgFirmwareVersionCount", "fw-version-count-[firmware_version]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'orgDomainGroupFirmwareReport'], [], [None]),
    "OrgMaintTagFirmwareReport": MoMeta("OrgMaintTagFirmwareReport", "orgMaintTagFirmwareReport", "firmware-report-[maint_tag]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [], [u'orgDomainFirmwareInfo'], ["Get"]),
    "OrgOrg": MoMeta("OrgOrg", "orgOrg", "org-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'aaaEpAuthProfile', u'adaptorHostEthIfProfile', u'adaptorHostFcIfProfile', u'adaptorHostIscsiIfProfile', u'biosVProfile', u'callhomeEp', u'cimcvmediaMountConfigPolicy', u'commCimxml', u'commCoreFile', u'commDateTime', u'commDns', u'commEvtChannel', u'commHttp', u'commHttps', u'commShellSvcLimits', u'commSmashCLP', u'commSnmp', u'commSsh', u'commSvcPolicy', u'commSyslog', u'commTelnet', u'commWebChannel', u'commWebSvcLimits', u'commWsman', u'computeAutoconfigPolicy', u'computeBladeDiscPolicy', u'computeBladeInheritPolicy', u'computeChassisConnPolicy', u'computeChassisDiscPolicy', u'computeDomainHwChangeDiscPolicy', u'computeDomainPortDiscPolicy', u'computeGraphicsCardPolicy', u'computeHwChangeDiscPolicy', u'computePool', u'computePoolingPolicy', u'computePortDiscPolicy', u'computePowerSyncPolicy', u'computeQual', u'computeRequirement', u'computeScrubPolicy', u'computeServerDiscPolicy', u'computeServerMgmtPolicy', u'computeSystemQual', u'computeTemplate', u'cpmaintMaintPolicy', u'diagRunPolicy', u'epqosDefinition', u'equipmentChassisProfile', u'equipmentChassisRequirement', u'equipmentComputeConnPolicy', u'equipmentPool', u'equipmentPoolingPolicy', u'equipmentQual', u'equipmentTemplate', u'equipmentTier', u'eventInst', u'fabricLacpPolicy', u'fabricLanCloudPolicy', u'fabricNetGroupPermit', u'fabricNetGroupReq', u'fabricOrgVlanPolicy', u'fabricUdldPolicy', u'fabricVConProfile', u'fabricVlanGroupReq', u'fabricVlanPermit', u'fabricVlanReq', u'faultInst', u'faultPolicy', u'fcpoolInitiators', u'firmwareCatalogPack', u'firmwareCatalogPackConfig', u'firmwareChassisPack', u'firmwareComputeHostPack', u'firmwareComputeMgmtPack', u'firmwareComputeStoragePack', u'firmwareDomainInfraProfile', u'firmwareInfraPack', u'firmwareInfraPackConfig', u'firmwareInfraPolicy', u'firmwareStoragePack', u'identpoolBlockQual', u'ippoolPool', u'iqnpoolPool', u'iscsiAuthProfile', u'lsServer', u'lsTier', u'lsWaitingUserAck', u'lsbootPolicy', u'lsmaintMaintPolicy', u'lstorageArrayRequirement', u'lstorageDiskGroupConfigPolicy', u'lstorageDiskZoningPolicy', u'lstorageProfile', u'macpoolPool', u'mgmtBackupPolicy', u'mgmtCfgExportPolicy', u'netNetGroupPermit', u'nwctrlDefinition', u'orgDomainGroupPolicy', u'orgExtension', u'orgOrg', u'orgOrgFsm', u'orgOrgFsmTask', u'orgOrgSource', u'orgSourceMask', u'policyDeviceProfile', u'policyIdentifierPolicy', u'policyLogProfile', u'policySystemProfile', u'powerPolicy', u'smartlicenseEp', u'solPolicy', u'statsThresholdPolicy', u'storageConnectionPolicy', u'storageLocalDiskConfigPolicy', u'testingCliPolicy', u'testingServiceProfile', u'testingSnmpPolicy', u'trigTest', u'uuidpoolPool', u'vnicDynamicCon', u'vnicDynamicConPolicy', u'vnicFcGroupTempl', u'vnicLanConnPolicy', u'vnicLanConnTempl', u'vnicSanConnPolicy', u'vnicSanConnTempl', u'vnicUsnicConPolicy', u'vnicVhbaBehPolicy', u'vnicVmqConPolicy', u'vnicVnicBehPolicy'], ["Add", "Get", "Remove", "Set"]),
    "OrgOrgFsm": MoMeta("OrgOrgFsm", "orgOrgFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'orgOrg'], [u'orgOrgFsmStage'], [None]),
    "OrgOrgFsmStage": MoMeta("OrgOrgFsmStage", "orgOrgFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'orgOrgFsm'], [], [None]),
    "OrgOrgFsmTask": MoMeta("OrgOrgFsmTask", "orgOrgFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'orgOrg'], [], ["Get"]),
    "OrgOrgSource": MoMeta("OrgOrgSource", "orgOrgSource", "org-source-[client_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [], ["Get"]),
    "OrgSourceMask": MoMeta("OrgSourceMask", "orgSourceMask", "src-mask", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [], ["Get"]),
    "OsController": MoMeta("OsController", "osController", "os-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageProcessor'], [u'firmwareBootDefinition', u'firmwareRunning'], [None]),
    "OsEthBondIntf": MoMeta("OsEthBondIntf", "osEthBondIntf", "bond-intf-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'osInstance', u'storageEthLif'], [u'osEthIntf'], [None]),
    "OsEthIntf": MoMeta("OsEthIntf", "osEthIntf", "intf-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'osEthBondIntf', u'osInstance', u'storageEthLif'], [], [None]),
    "OsInstance": MoMeta("OsInstance", "osInstance", "os", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade'], [u'osEthBondIntf', u'osEthIntf', u'storageEthLif'], ["Get"]),
    "OsPrimarySlave": MoMeta("OsPrimarySlave", "osPrimarySlave", "slave-intf-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "PkiCertReq": MoMeta("PkiCertReq", "pkiCertReq", "certreq", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'pkiKeyRing'], [], ["Add", "Get", "Remove", "Set"]),
    "PkiEp": MoMeta("PkiEp", "pkiEp", "pki-ext", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'policyDeviceProfile', u'topSystem'], [u'eventInst', u'faultInst', u'pkiEpFsm', u'pkiEpFsmTask', u'pkiKeyRing', u'pkiTP'], ["Get"]),
    "PkiEpFsm": MoMeta("PkiEpFsm", "pkiEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'pkiEp'], [u'pkiEpFsmStage'], [None]),
    "PkiEpFsmStage": MoMeta("PkiEpFsmStage", "pkiEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'pkiEpFsm'], [], [None]),
    "PkiEpFsmTask": MoMeta("PkiEpFsmTask", "pkiEpFsmTask", "task-[item]", VersionMeta.Version112a, "OutputOnly", 0x1, [], [""], [u'pkiEp'], [], [None]),
    "PkiKeyRing": MoMeta("PkiKeyRing", "pkiKeyRing", "keyring-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'pkiEp'], [u'faultInst', u'pkiCertReq'], ["Add", "Get", "Remove", "Set"]),
    "PkiTP": MoMeta("PkiTP", "pkiTP", "tp-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'orgDomainGroup', u'pkiEp'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "PolicyChildClass": MoMeta("PolicyChildClass", "policyChildClass", "child-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'policyDestClass'], [], ["get"]),
    "PolicyCluster": MoMeta("PolicyCluster", "policyCluster", "cluster-[converted_dn]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'policyUniverse'], [u'policySource'], ["Get"]),
    "PolicyCommunication": MoMeta("PolicyCommunication", "policyCommunication", "comm-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyCommunicationOp": MoMeta("PolicyCommunicationOp", "policyCommunicationOp", "comm-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'policyControlEpOp'], [u'faultInst'], ["Get", "Set"]),
    "PolicyConfigBackup": MoMeta("PolicyConfigBackup", "policyConfigBackup", "cfg-backup-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "operations"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyConfigBackupOp": MoMeta("PolicyConfigBackupOp", "policyConfigBackupOp", "cfg-backup-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "operations"], [u'policyControlEpOp'], [u'faultInst'], ["Get", "Set"]),
    "PolicyConfigError": MoMeta("PolicyConfigError", "policyConfigError", "policy-error", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'extpolClient'], [u'faultInst'], ["get"]),
    "PolicyContext": MoMeta("PolicyContext", "policyContext", "context-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'policySourceApp'], [u'policyScope'], ["get"]),
    "PolicyControlEp": MoMeta("PolicyControlEp", "policyControlEp", "control-ep-policy", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin"], [u'computeSystem', u'fabricSystem'], [u'policyCommunication', u'policyConfigBackup', u'policyControlEpOperation', u'policyDateTime', u'policyDestEp', u'policyDiscovery', u'policyDns', u'policyEquipment', u'policyFault', u'policyInfraFirmware', u'policyMEp', u'policyMonitoring', u'policyPortConfig', u'policyPowerMgmt', u'policyPsu', u'policySecurity', u'policySourceApp', u'policyStorageAutoConfig'], ["Add", "Get", "Remove", "Set"]),
    "PolicyControlEpOp": MoMeta("PolicyControlEpOp", "policyControlEpOp", "control-ep-[host_name_or_ip]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin"], [u'fabricDomainEp'], [u'eventInst', u'faultInst', u'policyCommunicationOp', u'policyConfigBackupOp', u'policyControlEpOpFsm', u'policyControlEpOpFsmTask', u'policyDateTimeOp', u'policyDiscoveryOp', u'policyDnsOp', u'policyEquipmentOp', u'policyFaultOp', u'policyInfraFirmwareOp', u'policyMEpOp', u'policyMonitoringOp', u'policyPortConfigOp', u'policyPowerMgmtOp', u'policyPsuOp', u'policySecurityOp', u'policyStorageAutoConfigOp'], ["Add", "Get", "Remove", "Set"]),
    "PolicyControlEpOpFsm": MoMeta("PolicyControlEpOpFsm", "policyControlEpOpFsm", "fsm", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], [u'policyControlEpOp'], [u'policyControlEpOpFsmStage'], [None]),
    "PolicyControlEpOpFsmStage": MoMeta("PolicyControlEpOpFsmStage", "policyControlEpOpFsmStage", "stage-[name]", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], [u'policyControlEpOpFsm'], [], [None]),
    "PolicyControlEpOpFsmTask": MoMeta("PolicyControlEpOpFsmTask", "policyControlEpOpFsmTask", "task-[item]", VersionMeta.Version151a, "OutputOnly", 0x1, [], [""], [u'policyControlEpOp'], [], [None]),
    "PolicyControlEpOperation": MoMeta("PolicyControlEpOperation", "policyControlEpOperation", "remote-oper", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin"], [u'policyControlEp'], [u'faultInst'], ["Get", "Set"]),
    "PolicyControlledInstance": MoMeta("PolicyControlledInstance", "policyControlledInstance", "ctrlled-[type]-inst-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [u'policyCommunication', u'policyConfigBackup', u'policyDateTime', u'policyDiscovery', u'policyDns', u'policyEquipment', u'policyFault', u'policyInfraFirmware', u'policyMEp', u'policyMonitoring', u'policyPortConfig', u'policyPowerMgmt', u'policyPsu', u'policySecurity', u'policyStorageAutoConfig'], [], ["Get"]),
    "PolicyControlledType": MoMeta("PolicyControlledType", "policyControlledType", "ctrlled-type-[type]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [u'policyCommunication', u'policyConfigBackup', u'policyDateTime', u'policyDiscovery', u'policyDns', u'policyEquipment', u'policyFault', u'policyInfraFirmware', u'policyMEp', u'policyMonitoring', u'policyPortConfig', u'policyPowerMgmt', u'policyPsu', u'policySecurity', u'policyStorageAutoConfig'], [], ["Get"]),
    "PolicyDateTime": MoMeta("PolicyDateTime", "policyDateTime", "datetime-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-security", "operations"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyDateTimeOp": MoMeta("PolicyDateTimeOp", "policyDateTimeOp", "datetime-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-security", "operations"], [u'policyControlEpOp'], [u'faultInst'], ["Get", "Set"]),
    "PolicyDestClass": MoMeta("PolicyDestClass", "policyDestClass", "dest-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'policyDestEp', u'policyPolicyDestClass'], [u'policyChildClass'], ["get"]),
    "PolicyDestEp": MoMeta("PolicyDestEp", "policyDestEp", "dest-ep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'policyControlEp'], [u'policyDestClass'], ["get"]),
    "PolicyDeviceProfile": MoMeta("PolicyDeviceProfile", "policyDeviceProfile", "deviceprofile-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'orgOrg'], [u'aaaAuthRealm', u'aaaLdapEp', u'aaaLocale', u'aaaPwdProfile', u'aaaRadiusEp', u'aaaRole', u'aaaTacacsPlusEp', u'aaaUser', u'callhomeEp', u'commCoreFile', u'commDateTime', u'commDns', u'commHttp', u'commHttps', u'commShellSvcLimits', u'commSnmp', u'commSsh', u'commSyslog', u'commTelnet', u'commWebSvcLimits', u'extmgmtIfMonPolicy', u'faultPolicy', u'mgmtBackupPolicy', u'mgmtCfgExportPolicy', u'pkiEp', u'smartlicenseEp', u'sysdebugAutoCoreFileExportTarget'], ["Get", "Set"]),
    "PolicyDigest": MoMeta("PolicyDigest", "policyDigest", "policy-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "PolicyDiscovery": MoMeta("PolicyDiscovery", "policyDiscovery", "discovery-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], [None]),
    "PolicyDiscoveryOp": MoMeta("PolicyDiscoveryOp", "policyDiscoveryOp", "discovery-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'policyControlEpOp'], [u'faultInst'], ["Get", "Set"]),
    "PolicyDns": MoMeta("PolicyDns", "policyDns", "dns-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["aaa", "admin", "ext-lan-config"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyDnsOp": MoMeta("PolicyDnsOp", "policyDnsOp", "dns-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["aaa", "admin", "ext-lan-config"], [u'policyControlEpOp'], [u'faultInst'], ["Get", "Set"]),
    "PolicyElement": MoMeta("PolicyElement", "policyElement", "element-[converted_dn]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'policyLocalMap'], [], ["Get"]),
    "PolicyEquipment": MoMeta("PolicyEquipment", "policyEquipment", "equipment-ctrl", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Get"]),
    "PolicyEquipmentOp": MoMeta("PolicyEquipmentOp", "policyEquipmentOp", "equipment-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], [u'policyControlEpOp'], [u'faultInst'], ["Get", "Set"]),
    "PolicyFault": MoMeta("PolicyFault", "policyFault", "fault-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "fault"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyFaultOp": MoMeta("PolicyFaultOp", "policyFaultOp", "fault-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "fault"], [u'policyControlEpOp'], [u'faultInst'], ["Get", "Set"]),
    "PolicyIdentifierPolicy": MoMeta("PolicyIdentifierPolicy", "policyIdentifierPolicy", "identifier-policy", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-config"], [u'orgDomainGroup', u'orgOrg'], [], ["Get", "Set"]),
    "PolicyInfraFirmware": MoMeta("PolicyInfraFirmware", "policyInfraFirmware", "fabric-fw-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "operations"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyInfraFirmwareOp": MoMeta("PolicyInfraFirmwareOp", "policyInfraFirmwareOp", "fabric-fw-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "operations"], [u'policyControlEpOp'], [u'faultInst'], ["Get", "Set"]),
    "PolicyLocalMap": MoMeta("PolicyLocalMap", "policyLocalMap", "localmap", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'policyElement'], ["Get"]),
    "PolicyLogProfile": MoMeta("PolicyLogProfile", "policyLogProfile", "logprof-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'orgDomainGroup', u'orgOrg'], [], [None]),
    "PolicyMEp": MoMeta("PolicyMEp", "policyMEp", "mep-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "operations"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyMEpOp": MoMeta("PolicyMEpOp", "policyMEpOp", "mep-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "operations"], [u'policyControlEpOp'], [u'faultInst'], ["Get", "Set"]),
    "PolicyMonitoring": MoMeta("PolicyMonitoring", "policyMonitoring", "monitoring-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "operations"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyMonitoringOp": MoMeta("PolicyMonitoringOp", "policyMonitoringOp", "monitoring-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "operations"], [u'policyControlEpOp'], [u'faultInst'], ["Get", "Set"]),
    "PolicyPolicyDestClass": MoMeta("PolicyPolicyDestClass", "policyPolicyDestClass", "destclass", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'policyScope'], [u'policyDestClass'], ["get"]),
    "PolicyPolicyEp": MoMeta("PolicyPolicyEp", "policyPolicyEp", "policy-ep", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'policyPolicyScopeCont', u'policySystemEp'], [None]),
    "PolicyPolicyRequestor": MoMeta("PolicyPolicyRequestor", "policyPolicyRequestor", "requestor-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'policyPolicyScope'], [], [None]),
    "PolicyPolicyScope": MoMeta("PolicyPolicyScope", "policyPolicyScope", "scope-[policy_type]-[resolve_type]-[policy_name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'policyPolicyScopeContext'], [u'eventInst', u'faultInst', u'policyPolicyRequestor', u'policyPolicyScopeFsm', u'policyPolicyScopeFsmTask'], [None]),
    "PolicyPolicyScopeCont": MoMeta("PolicyPolicyScopeCont", "policyPolicyScopeCont", "scope-cont-[app_type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'extpolClient', u'extpolController', u'extpolProvider', u'extpolRegistry', u'policyPolicyEp'], [u'policyPolicyScopeContext'], [None]),
    "PolicyPolicyScopeContext": MoMeta("PolicyPolicyScopeContext", "policyPolicyScopeContext", "context-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'policyPolicyScopeCont'], [u'policyPolicyScope'], [None]),
    "PolicyPolicyScopeFsm": MoMeta("PolicyPolicyScopeFsm", "policyPolicyScopeFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'policyPolicyScope'], [u'policyPolicyScopeFsmStage'], [None]),
    "PolicyPolicyScopeFsmStage": MoMeta("PolicyPolicyScopeFsmStage", "policyPolicyScopeFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'policyPolicyScopeFsm'], [], [None]),
    "PolicyPolicyScopeFsmTask": MoMeta("PolicyPolicyScopeFsmTask", "policyPolicyScopeFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'policyPolicyScope'], [], [None]),
    "PolicyPortConfig": MoMeta("PolicyPortConfig", "policyPortConfig", "portconfig-ctrl", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Get"]),
    "PolicyPortConfigOp": MoMeta("PolicyPortConfigOp", "policyPortConfigOp", "portconfig-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], [u'policyControlEpOp'], [u'faultInst'], ["Get", "Set"]),
    "PolicyPowerMgmt": MoMeta("PolicyPowerMgmt", "policyPowerMgmt", "powermgmt-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "power-mgmt"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyPowerMgmtOp": MoMeta("PolicyPowerMgmtOp", "policyPowerMgmtOp", "powermgmt-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "power-mgmt"], [u'policyControlEpOp'], [u'faultInst'], ["Get", "Set"]),
    "PolicyProxyMo": MoMeta("PolicyProxyMo", "policyProxyMo", "", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [], [], [None]),
    "PolicyPsu": MoMeta("PolicyPsu", "policyPsu", "psu-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicyPsuOp": MoMeta("PolicyPsuOp", "policyPsuOp", "psu-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-policy"], [u'policyControlEpOp'], [u'faultInst'], ["Get", "Set"]),
    "PolicyRequestor": MoMeta("PolicyRequestor", "policyRequestor", "requestor-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'policyScope'], [], ["get"]),
    "PolicyScope": MoMeta("PolicyScope", "policyScope", "scope-[policy_type]-[resolve_type]-[policy_name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'policyContext'], [u'policyPolicyDestClass', u'policyRequestor'], ["get"]),
    "PolicySecurity": MoMeta("PolicySecurity", "policySecurity", "security-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], ["Add", "Get", "Set"]),
    "PolicySecurityOp": MoMeta("PolicySecurityOp", "policySecurityOp", "security-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["aaa", "admin"], [u'policyControlEpOp'], [u'faultInst'], ["Get", "Set"]),
    "PolicySource": MoMeta("PolicySource", "policySource", "source-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'policyCluster'], [], ["Get"]),
    "PolicySourceApp": MoMeta("PolicySourceApp", "policySourceApp", "source-[source_dme]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'policyControlEp'], [u'policyContext'], ["get"]),
    "PolicyStorageAutoConfig": MoMeta("PolicyStorageAutoConfig", "policyStorageAutoConfig", "storage-autoconfig-ctrl", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage", "pn-policy"], [u'policyControlEp'], [u'policyControlledInstance', u'policyControlledType'], [None]),
    "PolicyStorageAutoConfigOp": MoMeta("PolicyStorageAutoConfigOp", "policyStorageAutoConfigOp", "storage-autoconfig-ctrl", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-storage", "pn-policy"], [u'policyControlEpOp'], [u'faultInst'], ["Get", "Set"]),
    "PolicySystemEp": MoMeta("PolicySystemEp", "policySystemEp", "system-policies", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'policyPolicyEp'], [u'adaptorHostEthIfProfile', u'lsbootPolicy', u'nwctrlDefinition', u'powerPolicy', u'solPolicy'], [None]),
    "PolicySystemProfile": MoMeta("PolicySystemProfile", "policySystemProfile", "SystemProfile", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'faultInst'], ["Get", "Set"]),
    "PolicyTracker": MoMeta("PolicyTracker", "policyTracker", "policytracker-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "PolicyUniverse": MoMeta("PolicyUniverse", "policyUniverse", "universe-[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'policyCluster'], ["Get"]),
    "PortGroup": MoMeta("PortGroup", "portGroup", "[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'equipmentIOCard', u'equipmentSharedIOModule', u'equipmentSwitchCard', u'equipmentSwitchIOCard'], [u'etherPIo', u'etherServerIntFIo', u'etherSwitchIntFIo', u'fcPIo', u'portSubGroup'], ["Get"]),
    "PortSubGroup": MoMeta("PortSubGroup", "portSubGroup", "aggr-port-[aggr_port_id]", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], [u'portGroup'], [u'etherPIo', u'fcPIo'], ["Get", "Set"]),
    "PowerBudget": MoMeta("PowerBudget", "powerBudget", "budget", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "power-mgmt"], [u'computeExtBoard', u'storageBlade'], [u'powerProfiledPower'], ["Get", "Set"]),
    "PowerChassisMember": MoMeta("PowerChassisMember", "powerChassisMember", "ch-member-[id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "power-mgmt", "read-only"], [u'powerGroup'], [], ["Add", "Get", "Remove"]),
    "PowerEp": MoMeta("PowerEp", "powerEp", "power-ep", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "power-mgmt"], [u'orgDomainGroup'], [u'powerGroup'], ["Get"]),
    "PowerGroup": MoMeta("PowerGroup", "powerGroup", "group-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-config-policy", "read-only"], [u'powerEp'], [u'powerChassisMember'], ["Get"]),
    "PowerGroupQual": MoMeta("PowerGroupQual", "powerGroupQual", "power-group-[group_name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'computeQual'], [], [None]),
    "PowerGroupStats": MoMeta("PowerGroupStats", "powerGroupStats", "stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], [u'powerGroupStatsHist'], [None]),
    "PowerGroupStatsHist": MoMeta("PowerGroupStatsHist", "powerGroupStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'powerGroupStats'], [], [None]),
    "PowerMgmtPolicy": MoMeta("PowerMgmtPolicy", "powerMgmtPolicy", "pwr-mgmt-policy", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "power-mgmt"], [u'orgDomainGroup'], [], ["Add", "Get", "Remove", "Set"]),
    "PowerPolicy": MoMeta("PowerPolicy", "powerPolicy", "power-policy-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg', u'policySystemEp'], [], ["Add", "Get", "Remove", "Set"]),
    "PowerProfiledPower": MoMeta("PowerProfiledPower", "powerProfiledPower", "prof-power", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "power-mgmt"], [u'powerBudget'], [], ["Get"]),
    "ProcDoer": MoMeta("ProcDoer", "procDoer", "doer[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'procManager'], [], ["Get"]),
    "ProcManager": MoMeta("ProcManager", "procManager", "proc-info", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'procDoer', u'procPrt', u'procPrtCounts', u'procStimulusCounts', u'procSvc', u'procTxCounts'], ["Get"]),
    "ProcPrt": MoMeta("ProcPrt", "procPrt", "prt[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'procManager'], [], ["Get"]),
    "ProcPrtCounts": MoMeta("ProcPrtCounts", "procPrtCounts", "prtCnt", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'procManager'], [], ["Get"]),
    "ProcStimulusCounts": MoMeta("ProcStimulusCounts", "procStimulusCounts", "stim", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'procManager', u'procSvc'], [], ["Get"]),
    "ProcSvc": MoMeta("ProcSvc", "procSvc", "svc-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'procManager'], [u'procStimulusCounts', u'procTxCounts'], ["Get"]),
    "ProcTxCounts": MoMeta("ProcTxCounts", "procTxCounts", "tx", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'procManager', u'procSvc'], [], ["Get"]),
    "ProcessorEnvStats": MoMeta("ProcessorEnvStats", "processorEnvStats", "env-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'processorUnit'], [u'processorEnvStatsHist'], [None]),
    "ProcessorEnvStatsHist": MoMeta("ProcessorEnvStatsHist", "processorEnvStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'processorEnvStats'], [], [None]),
    "ProcessorErrorStats": MoMeta("ProcessorErrorStats", "processorErrorStats", "error-stats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'processorUnit'], [u'processorErrorStatsHist'], [None]),
    "ProcessorErrorStatsHist": MoMeta("ProcessorErrorStatsHist", "processorErrorStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'processorErrorStats'], [], [None]),
    "ProcessorQual": MoMeta("ProcessorQual", "processorQual", "cpu", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], [u'computeQual'], [], ["Add", "Get", "Remove", "Set"]),
    "ProcessorRuntime": MoMeta("ProcessorRuntime", "processorRuntime", "cpu-rt", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'computeBlade'], [u'processorRuntimeHist'], [None]),
    "ProcessorRuntimeHist": MoMeta("ProcessorRuntimeHist", "processorRuntimeHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'processorRuntime'], [], [None]),
    "ProcessorUnit": MoMeta("ProcessorUnit", "processorUnit", "cpu-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'computeBoard'], [u'faultInst', u'processorEnvStats', u'processorErrorStats'], ["Get"]),
    "ProcessorUnitAssocCtx": MoMeta("ProcessorUnitAssocCtx", "processorUnitAssocCtx", "procunit-assoc-ctx", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'lsServerAssocCtx'], [], ["Get"]),
    "QosclassDefinition": MoMeta("QosclassDefinition", "qosclassDefinition", "classes", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-qos", "ext-san-qos", "ls-network", "ls-network-policy", "ls-qos-policy"], [u'fabricLanCloud', u'orgDomainGroup'], [u'firmwareAck', u'qosclassEthBE', u'qosclassEthClassified', u'qosclassFc'], ["Get", "Set"]),
    "QosclassEthBE": MoMeta("QosclassEthBE", "qosclassEthBE", "class-best-effort", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-qos", "ext-san-qos", "ls-network", "ls-network-policy", "ls-qos-policy"], [u'qosclassDefinition', u'qosclassPolicy'], [], ["Get", "Set"]),
    "QosclassEthClassified": MoMeta("QosclassEthClassified", "qosclassEthClassified", "class-[priority]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-qos", "ext-san-qos", "ls-network", "ls-network-policy", "ls-qos-policy"], [u'qosclassDefinition', u'qosclassPolicy'], [], ["Get", "Set"]),
    "QosclassFc": MoMeta("QosclassFc", "qosclassFc", "class-fc", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-qos", "ext-san-qos", "ls-network", "ls-network-policy", "ls-qos-policy"], [u'qosclassDefinition', u'qosclassPolicy'], [], ["Get", "Set"]),
    "QosclassPolicy": MoMeta("QosclassPolicy", "qosclassPolicy", "qosclass-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-lan-qos", "ext-san-qos", "ls-network", "ls-network-policy", "ls-qos-policy"], [u'orgDomainGroup'], [u'qosclassEthBE', u'qosclassEthClassified', u'qosclassFc'], ["add", "get", "remove", "set"]),
    "QueryDependencyContext": MoMeta("QueryDependencyContext", "queryDependencyContext", "dependency-[session_id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'queryEp'], [u'faultInst', u'queryresultDomainGroupEp', u'queryresultOrgEp'], ["Add", "Get", "Remove", "Set"]),
    "QueryDependencyRef": MoMeta("QueryDependencyRef", "queryDependencyRef", "depref-[index]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'queryImportContext'], [], ["Add", "Get", "Remove", "Set"]),
    "QueryEp": MoMeta("QueryEp", "queryEp", "query", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'queryDependencyContext', u'queryImportContext', u'queryUsageContext'], ["Get"]),
    "QueryImportContext": MoMeta("QueryImportContext", "queryImportContext", "import-[session_id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'queryEp'], [u'faultInst', u'queryDependencyRef'], ["Add", "Get", "Remove", "Set"]),
    "QueryUsageContext": MoMeta("QueryUsageContext", "queryUsageContext", "usage-[session_id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'queryEp'], [u'faultInst', u'queryresultUsage'], ["Add", "Get", "Remove", "Set"]),
    "QueryresultDependency": MoMeta("QueryresultDependency", "queryresultDependency", "dependency-[ref_converted_dn]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'queryresultDomainGroupEp', u'queryresultOrgEp'], [], ["Get"]),
    "QueryresultDomainGroupEp": MoMeta("QueryresultDomainGroupEp", "queryresultDomainGroupEp", "dg-ep", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'queryDependencyContext'], [u'queryresultDependency'], ["Get"]),
    "QueryresultOrgEp": MoMeta("QueryresultOrgEp", "queryresultOrgEp", "org-ep", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'queryDependencyContext'], [u'queryresultDependency'], ["Get"]),
    "QueryresultUsage": MoMeta("QueryresultUsage", "queryresultUsage", "usage-[ref_converted_dn]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'queryUsageContext'], [], ["Get"]),
    "SecurityUnit": MoMeta("SecurityUnit", "securityUnit", "security-unit-[id]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'computeBoard'], [], ["Get"]),
    "SesDiskSlotEp": MoMeta("SesDiskSlotEp", "sesDiskSlotEp", "disk-slot-ep-[enc_id]-id-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'sesEnclosure'], [], [None]),
    "SesEnclosure": MoMeta("SesEnclosure", "sesEnclosure", "ses-enc-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'equipmentChassis'], [u'sesDiskSlotEp'], [None]),
    "SmartcallhomeHttpProxy": MoMeta("SmartcallhomeHttpProxy", "smartcallhomeHttpProxy", "proxy", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "operations"], [u'callhomeEp'], [], ["Add", "Get", "Remove", "Set"]),
    "SmartcallhomePeriodicInventoryStatus": MoMeta("SmartcallhomePeriodicInventoryStatus", "smartcallhomePeriodicInventoryStatus", "inventory-status", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'callhomeHolder'], [], ["Get"]),
    "SmartcallhomePeriodicSystemInventory": MoMeta("SmartcallhomePeriodicSystemInventory", "smartcallhomePeriodicSystemInventory", "smart-periodic-inventory", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "operations"], [u'callhomeEp'], [], ["Get", "Set"]),
    "SmartcallhomePolicy": MoMeta("SmartcallhomePolicy", "smartcallhomePolicy", "smart-policy-[cause]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "fault"], [u'callhomeEp'], [], ["Add", "Get", "Remove", "Set"]),
    "SmartcallhomeProfile": MoMeta("SmartcallhomeProfile", "smartcallhomeProfile", "smart-profile-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "operations"], [u'callhomeEp'], [], ["Get"]),
    "SmartcallhomeSource": MoMeta("SmartcallhomeSource", "smartcallhomeSource", "sch-source", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "operations"], [u'callhomeEp'], [], ["Get", "Set"]),
    "SmartcallhomeTransportGateway": MoMeta("SmartcallhomeTransportGateway", "smartcallhomeTransportGateway", "transport-gateway", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "operations"], [u'callhomeEp'], [], ["Add", "Get", "Remove", "Set"]),
    "SmartlicenseAgent": MoMeta("SmartlicenseAgent", "smartlicenseAgent", "Agent", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], [u'smartlicenseHolder'], [u'eventInst', u'faultInst', u'smartlicenseAgentFsm', u'smartlicenseAgentFsmTask', u'smartlicenseTest'], ["Get"]),
    "SmartlicenseAgentFsm": MoMeta("SmartlicenseAgentFsm", "smartlicenseAgentFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'smartlicenseAgent'], [u'smartlicenseAgentFsmStage'], [None]),
    "SmartlicenseAgentFsmStage": MoMeta("SmartlicenseAgentFsmStage", "smartlicenseAgentFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'smartlicenseAgentFsm'], [], [None]),
    "SmartlicenseAgentFsmTask": MoMeta("SmartlicenseAgentFsmTask", "smartlicenseAgentFsmTask", "task-[item]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'smartlicenseAgent'], [], [None]),
    "SmartlicenseEntitlement": MoMeta("SmartlicenseEntitlement", "smartlicenseEntitlement", "entitlement[tag]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], [u'smartlicenseEntitlementEp', u'smartlicenseHolder'], [u'faultInst'], ["Get"]),
    "SmartlicenseEntitlementEp": MoMeta("SmartlicenseEntitlementEp", "smartlicenseEntitlementEp", "entitlement-ep", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], [u'smartlicenseHolder'], [u'eventInst', u'faultInst', u'smartlicenseEntitlement', u'smartlicenseEntitlementEpFsm', u'smartlicenseEntitlementEpFsmTask'], ["Get"]),
    "SmartlicenseEntitlementEpFsm": MoMeta("SmartlicenseEntitlementEpFsm", "smartlicenseEntitlementEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'smartlicenseEntitlementEp'], [u'smartlicenseEntitlementEpFsmStage'], [None]),
    "SmartlicenseEntitlementEpFsmStage": MoMeta("SmartlicenseEntitlementEpFsmStage", "smartlicenseEntitlementEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'smartlicenseEntitlementEpFsm'], [], [None]),
    "SmartlicenseEntitlementEpFsmTask": MoMeta("SmartlicenseEntitlementEpFsmTask", "smartlicenseEntitlementEpFsmTask", "task-[item]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'smartlicenseEntitlementEp'], [], [None]),
    "SmartlicenseEp": MoMeta("SmartlicenseEp", "smartlicenseEp", "smart-license", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], [u'orgOrg', u'policyDeviceProfile', u'smartlicenseHolder'], [], ["Get"]),
    "SmartlicenseHolder": MoMeta("SmartlicenseHolder", "smartlicenseHolder", "smartlicense", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [u'callhomeEp', u'eventInst', u'faultInst', u'smartlicenseAgent', u'smartlicenseEntitlement', u'smartlicenseEntitlementEp', u'smartlicenseEp', u'smartlicenseHolderFsm', u'smartlicenseHolderFsmTask'], ["Get"]),
    "SmartlicenseHolderFsm": MoMeta("SmartlicenseHolderFsm", "smartlicenseHolderFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'smartlicenseHolder'], [u'smartlicenseHolderFsmStage'], [None]),
    "SmartlicenseHolderFsmStage": MoMeta("SmartlicenseHolderFsmStage", "smartlicenseHolderFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'smartlicenseHolderFsm'], [], [None]),
    "SmartlicenseHolderFsmTask": MoMeta("SmartlicenseHolderFsmTask", "smartlicenseHolderFsmTask", "task-[item]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'smartlicenseHolder'], [], [None]),
    "SmartlicenseTest": MoMeta("SmartlicenseTest", "smartlicenseTest", "Test", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin"], [u'smartlicenseAgent'], [u'eventInst', u'faultInst', u'smartlicenseTestFsm', u'smartlicenseTestFsmTask'], [None]),
    "SmartlicenseTestFsm": MoMeta("SmartlicenseTestFsm", "smartlicenseTestFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'smartlicenseTest'], [u'smartlicenseTestFsmStage'], [None]),
    "SmartlicenseTestFsmStage": MoMeta("SmartlicenseTestFsmStage", "smartlicenseTestFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'smartlicenseTestFsm'], [], [None]),
    "SmartlicenseTestFsmTask": MoMeta("SmartlicenseTestFsmTask", "smartlicenseTestFsmTask", "task-[item]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'smartlicenseTest'], [], [None]),
    "SolPolicy": MoMeta("SolPolicy", "solPolicy", "sol-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "read-only"], [u'orgOrg', u'policySystemEp'], [], ["Add", "Get", "Remove", "Set"]),
    "StatsChartContainer": MoMeta("StatsChartContainer", "statsChartContainer", "container-[name]", VersionMeta.Version111b, "InputOutput", 0x1, [], ["admin", "stats-management"], [u'statsChartContainer', u'statsCustomEp'], [u'statsChartContainer', u'statsCustomChart'], ["Get"]),
    "StatsCollectionPolicy": MoMeta("StatsCollectionPolicy", "statsCollectionPolicy", "coll-policy-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'statsHolder'], [], ["Get", "Set"]),
    "StatsCustomChart": MoMeta("StatsCustomChart", "statsCustomChart", "custom-chart-[name]domain-[chart_domain]", VersionMeta.Version111b, "InputOutput", 0x1, [], ["admin", "stats-management"], [u'statsChartContainer', u'statsCustomEp'], [], ["Get"]),
    "StatsCustomEp": MoMeta("StatsCustomEp", "statsCustomEp", "customcharts", VersionMeta.Version111b, "InputOutput", 0x1, [], ["read-only"], [u'topSystem'], [u'statsChartContainer', u'statsCustomChart'], ["Get"]),
    "StatsDbMigrationStatus": MoMeta("StatsDbMigrationStatus", "statsDbMigrationStatus", "dbMigrationStatus", VersionMeta.Version111b, "InputOutput", 0x1, [], ["admin"], [u'statsHolder'], [], ["Get"]),
    "StatsDbSummaryMeta": MoMeta("StatsDbSummaryMeta", "statsDbSummaryMeta", "summary-meta", VersionMeta.Version111b, "InputOutput", 0x1, [], ["admin"], [u'topRoot'], [], ["Get"]),
    "StatsHolder": MoMeta("StatsHolder", "statsHolder", "stats", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'topRoot'], [u'statsCollectionPolicy', u'statsDbMigrationStatus', u'statsPasadenaCollectionPolicy'], ["Get"]),
    "StatsInventoryMeta": MoMeta("StatsInventoryMeta", "statsInventoryMeta", "invMeta", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin"], [u'extpolClient'], [], ["Get", "Set"]),
    "StatsPasadenaCollectionPolicy": MoMeta("StatsPasadenaCollectionPolicy", "statsPasadenaCollectionPolicy", "pasadena-coll-policy", VersionMeta.Version111b, "InputOutput", 0x1, [], ["admin", "operations"], [u'statsHolder'], [], ["Get"]),
    "StatsStandardChart": MoMeta("StatsStandardChart", "statsStandardChart", "standard-chart-[name]domain-[chart_domain]", VersionMeta.Version111b, "InputOutput", 0x1, [], ["admin", "stats-management"], [u'statsStandardEp'], [], ["Get"]),
    "StatsStandardEp": MoMeta("StatsStandardEp", "statsStandardEp", "standardcharts", VersionMeta.Version111b, "InputOutput", 0x1, [], ["read-only"], [u'topSystem'], [u'statsStandardChart'], ["Get"]),
    "StatsStatsQuery": MoMeta("StatsStatsQuery", "statsStatsQuery", "query-[query_id]", VersionMeta.Version111b, "InputOutput", 0x1, [], ["read-only"], [u'statsStatsQueryHolder'], [], ["Get"]),
    "StatsStatsQueryHolder": MoMeta("StatsStatsQueryHolder", "statsStatsQueryHolder", "statsQuery", VersionMeta.Version111b, "InputOutput", 0x1, [], ["admin", "operations"], [u'topRoot'], [u'statsStatsQuery'], ["Get"]),
    "StatsThr32Definition": MoMeta("StatsThr32Definition", "statsThr32Definition", "[prop_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'statsThresholdClass'], [u'statsThr32Value', u'statsThr64Value', u'statsThrFloatValue'], ["Add", "Get", "Remove", "Set"]),
    "StatsThr32Value": MoMeta("StatsThr32Value", "statsThr32Value", "[direction]-[severity]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'statsThr32Definition', u'statsThr64Definition', u'statsThrFloatDefinition'], [], ["Add", "Get", "Set"]),
    "StatsThr64Definition": MoMeta("StatsThr64Definition", "statsThr64Definition", "[prop_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'statsThresholdClass'], [u'statsThr32Value', u'statsThr64Value', u'statsThrFloatValue'], ["Add", "Get", "Remove", "Set"]),
    "StatsThr64Value": MoMeta("StatsThr64Value", "statsThr64Value", "[direction]-[severity]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'statsThr32Definition', u'statsThr64Definition', u'statsThrFloatDefinition'], [], ["Add", "Get", "Set"]),
    "StatsThrFloatDefinition": MoMeta("StatsThrFloatDefinition", "statsThrFloatDefinition", "[prop_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'statsThresholdClass'], [u'statsThr32Value', u'statsThr64Value', u'statsThrFloatValue'], ["Add", "Get", "Remove", "Set"]),
    "StatsThrFloatValue": MoMeta("StatsThrFloatValue", "statsThrFloatValue", "[direction]-[severity]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'statsThr32Definition', u'statsThr64Definition', u'statsThrFloatDefinition'], [], ["Get"]),
    "StatsThresholdClass": MoMeta("StatsThresholdClass", "statsThresholdClass", "[stats_class_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'statsThresholdPolicy'], [u'statsThr32Definition', u'statsThr64Definition', u'statsThrFloatDefinition'], ["Add", "Get", "Remove", "Set"]),
    "StatsThresholdPolicy": MoMeta("StatsThresholdPolicy", "statsThresholdPolicy", "thr-policy-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'fabricCabling', u'fabricDceSrv', u'fabricEthEstcCloud', u'fabricFcEstcCloud', u'fabricLanCloud', u'fabricLanMonCloud', u'fabricSanCloud', u'fabricSanMonCloud', u'orgOrg'], [u'statsThresholdClass'], ["Add", "Get", "Remove", "Set"]),
    "StorageArray": MoMeta("StorageArray", "storageArray", "array-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [u'storageCloud'], [u'storageDiskGroup', u'storagePartition', u'storageProcessor'], ["Get"]),
    "StorageAuthKey": MoMeta("StorageAuthKey", "storageAuthKey", "key-[type]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [u'storageIScsiTargetIf'], [], [None]),
    "StorageBlade": MoMeta("StorageBlade", "storageBlade", "storage-blade-[slot_id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'equipmentChassis'], [u'computeBladeEp', u'powerBudget', u'storageComputeBladeOperation', u'storageEnclosure', u'storageMeta'], ["Get"]),
    "StorageCloud": MoMeta("StorageCloud", "storageCloud", "storage", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [u'computeSystem', u'topRoot'], [u'storageArray', u'storageClusterIdUniverse', u'trigMeta', u'trigSched'], [None]),
    "StorageClusterIdUniverse": MoMeta("StorageClusterIdUniverse", "storageClusterIdUniverse", "cluster-id-universe", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageCloud'], [], [None]),
    "StorageComputeBladeOperation": MoMeta("StorageComputeBladeOperation", "storageComputeBladeOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'storageBlade'], [u'faultInst'], ["Get"]),
    "StorageConnectionDef": MoMeta("StorageConnectionDef", "storageConnectionDef", "storage-conndef", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], [u'vnicFcGroupDef'], [u'faultInst', u'storageFcTargetEp'], ["Add", "Get", "Remove", "Set"]),
    "StorageConnectionPolicy": MoMeta("StorageConnectionPolicy", "storageConnectionPolicy", "storage-connpolicy-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'faultInst', u'storageFcTargetEp'], ["Add", "Get", "Remove", "Set"]),
    "StorageController": MoMeta("StorageController", "storageController", "storage-[type]-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'computeBoard', u'equipmentChassis'], [u'faultInst', u'firmwareBootDefinition', u'firmwareRunning', u'lstorageControllerDef', u'mgmtController', u'storageControllerOperation', u'storageEmbeddedStorage', u'storageEnclosure', u'storageLocalDisk', u'storageLocalDiskConfigDef', u'storageLocalDiskEp', u'storageLocalLun', u'storageMezzFlashLife', u'storageNvmeStats', u'storageNvmeStorage', u'storageOnboardDevice', u'storageOperation', u'storageRaidBattery', u'storageSsdHealthStats', u'storageVirtualDrive', u'storageVirtualDriveEp'], ["Get"]),
    "StorageControllerEp": MoMeta("StorageControllerEp", "storageControllerEp", "controller-ep-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'storageLocalDisk', u'storageVirtualDrive'], [], ["Get"]),
    "StorageControllerOperation": MoMeta("StorageControllerOperation", "storageControllerOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'storageController'], [u'faultInst'], ["Get"]),
    "StorageControllerRef": MoMeta("StorageControllerRef", "storageControllerRef", "server-[server_id]-controller-[controller_type]-[controller_id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'storageEnclosureDiskSlotEp'], [], ["Get"]),
    "StorageCtrlStorageStats": MoMeta("StorageCtrlStorageStats", "storageCtrlStorageStats", "ctrl-storage-stats", VersionMeta.Version131a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], [u'storageCtrlStorageStatsHist'], [None]),
    "StorageCtrlStorageStatsHist": MoMeta("StorageCtrlStorageStatsHist", "storageCtrlStorageStatsHist", "[id]", VersionMeta.Version131a, "OutputOnly", 0x1, [], ["read-only"], [u'storageCtrlStorageStats'], [], [None]),
    "StorageDiskEnvStats": MoMeta("StorageDiskEnvStats", "storageDiskEnvStats", "disk-env-stats", VersionMeta.Version201b, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'storageLocalDisk'], [u'storageDiskEnvStatsHist'], [None]),
    "StorageDiskEnvStatsHist": MoMeta("StorageDiskEnvStatsHist", "storageDiskEnvStatsHist", "[id]", VersionMeta.Version201b, "OutputOnly", 0x1, [], ["read-only"], [u'storageDiskEnvStats'], [], [None]),
    "StorageDiskEp": MoMeta("StorageDiskEp", "storageDiskEp", "disk-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageDiskGroup'], [], ["Get"]),
    "StorageDiskGroup": MoMeta("StorageDiskGroup", "storageDiskGroup", "disk-group-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [u'storageArray'], [u'storageDiskEp'], ["Get", "Set"]),
    "StorageEmbeddedStorage": MoMeta("StorageEmbeddedStorage", "storageEmbeddedStorage", "embedded-storage", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'storageController'], [], ["Get"]),
    "StorageEnclosure": MoMeta("StorageEnclosure", "storageEnclosure", "enc-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'equipmentChassis', u'storageBlade', u'storageController'], [u'storageEnclosureDiskSlotEp', u'storageLocalDisk'], ["Get"]),
    "StorageEnclosureDiskSlotEp": MoMeta("StorageEnclosureDiskSlotEp", "storageEnclosureDiskSlotEp", "disk-slot-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageEnclosure'], [u'storageControllerRef'], ["Get"]),
    "StorageEnclosureLocalDiskConfig": MoMeta("StorageEnclosureLocalDiskConfig", "storageEnclosureLocalDiskConfig", "enc-disk-config-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [], [u'storageSasPort'], ["Get"]),
    "StorageEpUser": MoMeta("StorageEpUser", "storageEpUser", "user-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [u'initiatorFcInitiatorEp', u'initiatorIScsiInitiatorEp', u'storageIScsiInitiatorEp'], [], [None]),
    "StorageEthLif": MoMeta("StorageEthLif", "storageEthLif", "eth-lif-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "read-only"], [u'osInstance', u'storageProcessor'], [u'osEthBondIntf', u'osEthIntf', u'vnicFault', u'vnicIPv4If'], ["Get"]),
    "StorageEtherIf": MoMeta("StorageEtherIf", "storageEtherIf", "ether-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [u'storageIScsiTargetIf'], [u'ipServiceIf'], ["Get"]),
    "StorageFcIf": MoMeta("StorageFcIf", "storageFcIf", "fc-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageFcTargetIf'], [], ["Get"]),
    "StorageFcTargetEp": MoMeta("StorageFcTargetEp", "storageFcTargetEp", "fc-target-ep-[targetwwpn]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy", "ls-storage", "ls-storage-policy"], [u'storageConnectionDef', u'storageConnectionPolicy'], [u'storageVsanRef'], ["Add", "Get", "Remove", "Set"]),
    "StorageFcTargetIf": MoMeta("StorageFcTargetIf", "storageFcTargetIf", "fc-tgt-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [u'storageFcIf'], ["Get"]),
    "StorageFlexFlashCard": MoMeta("StorageFlexFlashCard", "storageFlexFlashCard", "card-[slot_number]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [u'storageFlexFlashController'], [u'storageFlexFlashDrive'], ["Get"]),
    "StorageFlexFlashController": MoMeta("StorageFlexFlashController", "storageFlexFlashController", "storage-flexflash-[id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin"], [u'computeBoard'], [u'firmwareRunning', u'storageFlexFlashCard', u'storageFlexFlashControllerOperation', u'storageFlexFlashVirtualDrive', u'storageLocalDiskConfigDef'], ["Get"]),
    "StorageFlexFlashControllerOperation": MoMeta("StorageFlexFlashControllerOperation", "storageFlexFlashControllerOperation", "remote-oper", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'storageFlexFlashController'], [u'faultInst'], [None]),
    "StorageFlexFlashDrive": MoMeta("StorageFlexFlashDrive", "storageFlexFlashDrive", "drive-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [u'storageFlexFlashCard'], [], ["Get"]),
    "StorageFlexFlashVirtualDrive": MoMeta("StorageFlexFlashVirtualDrive", "storageFlexFlashVirtualDrive", "vd-[id]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [u'storageFlexFlashController'], [], ["Get"]),
    "StorageHddMotherBoardTempStats": MoMeta("StorageHddMotherBoardTempStats", "storageHddMotherBoardTempStats", "hdd-mobo-temp-stats", VersionMeta.Version151a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], [u'storageHddMotherBoardTempStatsHist'], [None]),
    "StorageHddMotherBoardTempStatsHist": MoMeta("StorageHddMotherBoardTempStatsHist", "storageHddMotherBoardTempStatsHist", "[id]", VersionMeta.Version151a, "OutputOnly", 0x1, [], ["read-only"], [u'storageHddMotherBoardTempStats'], [], [None]),
    "StorageIScsiInitiatorEp": MoMeta("StorageIScsiInitiatorEp", "storageIScsiInitiatorEp", "scsi-ini-[iqn]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'initiatorGroupEp', u'storageLunMaskGroup'], [u'storageEpUser'], ["Get"]),
    "StorageIScsiTargetIf": MoMeta("StorageIScsiTargetIf", "storageIScsiTargetIf", "iscsi-tgt-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [u'storageNodeEp'], [u'initiatorLunEp', u'storageAuthKey', u'storageEtherIf'], ["Get"]),
    "StorageIniGroup": MoMeta("StorageIniGroup", "storageIniGroup", "grp-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], [u'lsServer', u'vnicSanConnPolicy'], [u'faultInst', u'storageInitiator', u'vnicFcGroupDef'], ["Add", "Get", "Remove", "Set"]),
    "StorageInitiator": MoMeta("StorageInitiator", "storageInitiator", "ini-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], [u'storageIniGroup'], [u'faultInst'], ["Add", "Get", "Remove"]),
    "StorageInitiatorRef": MoMeta("StorageInitiatorRef", "storageInitiatorRef", "lun-ref-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageScsiLun'], [], ["Get"]),
    "StorageIpV4PooledAddr": MoMeta("StorageIpV4PooledAddr", "storageIpV4PooledAddr", "storage-ipv4-pooled-addr", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [u'computeInstance', u'lsServer', u'mgmtVnet', u'vnicIPv4If', u'vnicMgmtIf'], [u'faultInst'], ["Get"]),
    "StorageIpV4StaticAddr": MoMeta("StorageIpV4StaticAddr", "storageIpV4StaticAddr", "storage-ipv4-addr", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [u'computeInstance', u'lsServer', u'mgmtVnet', u'vnicIPv4If', u'vnicMgmtIf'], [], ["Get"]),
    "StorageItem": MoMeta("StorageItem", "storageItem", "stor-part-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'networkElement', u'nfsExportDef'], [u'faultInst'], ["Get"]),
    "StorageLocalDisk": MoMeta("StorageLocalDisk", "storageLocalDisk", "disk-[id]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'storageController', u'storageEnclosure'], [u'equipmentLocatorLed', u'faultInst', u'firmwareBootDefinition', u'firmwareRunning', u'storageControllerEp', u'storageDiskEnvStats', u'storageLocalDiskOperation', u'storageLocalDiskPartition', u'storageOperation', u'storageSasPort'], ["Get"]),
    "StorageLocalDiskConfigDef": MoMeta("StorageLocalDiskConfigDef", "storageLocalDiskConfigDef", "local-disk-config", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-config-policy", "ls-server", "ls-storage", "ls-storage-policy"], [u'lsServer', u'lstorageDasScsiLun', u'storageController', u'storageFlexFlashController'], [u'lstorageSecurity', u'storageLocalDiskPartition'], ["Add", "Get", "Remove", "Set"]),
    "StorageLocalDiskConfigPolicy": MoMeta("StorageLocalDiskConfigPolicy", "storageLocalDiskConfigPolicy", "local-disk-config-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'lstorageSecurity', u'storageLocalDiskPartition'], ["Add", "Get", "Remove", "Set"]),
    "StorageLocalDiskEp": MoMeta("StorageLocalDiskEp", "storageLocalDiskEp", "disk-ep-[enc_id]-id-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageController'], [], ["Get"]),
    "StorageLocalDiskOperation": MoMeta("StorageLocalDiskOperation", "storageLocalDiskOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'storageLocalDisk'], [u'faultInst'], ["Get", "Set"]),
    "StorageLocalDiskPartition": MoMeta("StorageLocalDiskPartition", "storageLocalDiskPartition", "partition-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageLocalDisk', u'storageLocalDiskConfigDef', u'storageLocalDiskConfigPolicy'], [], ["Get"]),
    "StorageLocalLun": MoMeta("StorageLocalLun", "storageLocalLun", "lun-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageController'], [], ["Get"]),
    "StorageLunCounters": MoMeta("StorageLunCounters", "storageLunCounters", "lun-counters", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storagePartition'], [], [None]),
    "StorageLunDisk": MoMeta("StorageLunDisk", "storageLunDisk", "disk-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageVirtualDrive'], [], ["Get"]),
    "StorageLunMaskGroup": MoMeta("StorageLunMaskGroup", "storageLunMaskGroup", "lunmask-grp-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storagePartition'], [u'storageIScsiInitiatorEp', u'storageScsiLunMask'], ["Get"]),
    "StorageLunReplica": MoMeta("StorageLunReplica", "storageLunReplica", "lun-replica-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'storagePartition'], [u'faultInst', u'storageScsiLunRef'], ["Get"]),
    "StorageLunResourceSelectionLog": MoMeta("StorageLunResourceSelectionLog", "storageLunResourceSelectionLog", "selection-log-[order]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'storageVirtualDriveRef'], [], [None]),
    "StorageLunSnapshot": MoMeta("StorageLunSnapshot", "storageLunSnapshot", "snapshot-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'storagePartition'], [u'faultInst', u'storageScsiLunRef'], ["Get"]),
    "StorageMeta": MoMeta("StorageMeta", "storageMeta", "meta", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin"], [u'storageBlade'], [u'faultInst'], [None]),
    "StorageMezzFlashLife": MoMeta("StorageMezzFlashLife", "storageMezzFlashLife", "flash-life-", VersionMeta.Version121a, "InputOutput", 0x1, [], ["read-only"], [u'storageController'], [], ["Get"]),
    "StorageNodeEp": MoMeta("StorageNodeEp", "storageNodeEp", "node-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'initiatorGroupEp'], [u'storageIScsiTargetIf'], [None]),
    "StorageNvmeStats": MoMeta("StorageNvmeStats", "storageNvmeStats", "nvme-stats", VersionMeta.Version201b, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'storageController'], [u'storageNvmeStatsHist'], [None]),
    "StorageNvmeStatsHist": MoMeta("StorageNvmeStatsHist", "storageNvmeStatsHist", "[id]", VersionMeta.Version201b, "OutputOnly", 0x1, [], ["read-only"], [u'storageNvmeStats'], [], [None]),
    "StorageNvmeStorage": MoMeta("StorageNvmeStorage", "storageNvmeStorage", "nvme-storage", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'storageController'], [], [None]),
    "StorageOnboardDevice": MoMeta("StorageOnboardDevice", "storageOnboardDevice", "onboard-device-[device_type]-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'storageController', u'storageSasExpander'], [u'firmwareBootDefinition', u'firmwareRunning', u'firmwareUpdatable'], ["Get"]),
    "StorageOperation": MoMeta("StorageOperation", "storageOperation", "op-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageController', u'storageLocalDisk', u'storageRaidBattery', u'storageVirtualDrive'], [], ["Get"]),
    "StoragePartition": MoMeta("StoragePartition", "storagePartition", "part-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageArray'], [u'storageLunCounters', u'storageLunMaskGroup', u'storageLunReplica', u'storageLunSnapshot', u'storageScsiLun', u'storageUsageCounters', u'storageVolume'], ["Get"]),
    "StorageProcessor": MoMeta("StorageProcessor", "storageProcessor", "processor-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageArray'], [u'commLocale', u'osController', u'storageEthLif', u'storageProcessorRuntime'], ["Get"]),
    "StorageProcessorEp": MoMeta("StorageProcessorEp", "storageProcessorEp", "proc-ep-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "StorageProcessorRuntime": MoMeta("StorageProcessorRuntime", "storageProcessorRuntime", "proc-runtime", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageProcessor'], [], ["Get"]),
    "StorageQual": MoMeta("StorageQual", "storageQual", "local-storage", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "pn-policy", "read-only"], [u'computeQual'], [], ["Add", "Get", "Remove", "Set"]),
    "StorageRaidBattery": MoMeta("StorageRaidBattery", "storageRaidBattery", "raid-battery", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'storageController'], [u'storageOperation', u'storageTransportableFlashModule'], ["Get"]),
    "StorageReplicationCtx": MoMeta("StorageReplicationCtx", "storageReplicationCtx", "repl-ctx", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'storageScsiLun'], [], ["Get"]),
    "StorageSasExpander": MoMeta("StorageSasExpander", "storageSasExpander", "sas-expander-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'computeBoard', u'equipmentChassis'], [u'firmwareBootDefinition', u'firmwareRunning', u'mgmtController', u'storageOnboardDevice', u'storageSasUpLink'], [None]),
    "StorageSasPort": MoMeta("StorageSasPort", "storageSasPort", "sas-port-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'storageEnclosureLocalDiskConfig', u'storageLocalDisk'], [], ["Get"]),
    "StorageSasUpLink": MoMeta("StorageSasUpLink", "storageSasUpLink", "sas-uplink-server-[server_id]-controller-[controller_type]-[controller_id]-id-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'storageSasExpander'], [], ["Get"]),
    "StorageScsiDeviceDescriptor": MoMeta("StorageScsiDeviceDescriptor", "storageScsiDeviceDescriptor", "scsi-descriptor-[type]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageScsiLun'], [], [None]),
    "StorageScsiLun": MoMeta("StorageScsiLun", "storageScsiLun", "lun-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'storagePartition'], [u'faultInst', u'storageInitiatorRef', u'storageReplicationCtx', u'storageScsiDeviceDescriptor', u'storageScsiLunCtx', u'storageScsiLunRef', u'storageSnapshotCtx'], [None]),
    "StorageScsiLunCtx": MoMeta("StorageScsiLunCtx", "storageScsiLunCtx", "lun-ctx", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'storageScsiLun'], [], [None]),
    "StorageScsiLunInstRef": MoMeta("StorageScsiLunInstRef", "storageScsiLunInstRef", "lun-inst-ref-[lun_item_name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'lsServer'], [], [None]),
    "StorageScsiLunMask": MoMeta("StorageScsiLunMask", "storageScsiLunMask", "lunmask-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageLunMaskGroup'], [], ["Get"]),
    "StorageScsiLunRef": MoMeta("StorageScsiLunRef", "storageScsiLunRef", "scsi-lun-ref-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageLunReplica', u'storageLunSnapshot', u'storageScsiLun', u'storageVirtualDrive'], [], ["Get"]),
    "StorageSnapshotCtx": MoMeta("StorageSnapshotCtx", "storageSnapshotCtx", "snap-ctx", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'storageScsiLun'], [], ["Get"]),
    "StorageSsdHealthStats": MoMeta("StorageSsdHealthStats", "storageSsdHealthStats", "ssd-health-stats-[id]", VersionMeta.Version201b, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'storageController'], [u'storageSsdHealthStatsHist'], [None]),
    "StorageSsdHealthStatsHist": MoMeta("StorageSsdHealthStatsHist", "storageSsdHealthStatsHist", "[id]", VersionMeta.Version201b, "OutputOnly", 0x1, [], ["read-only"], [u'storageSsdHealthStats'], [], [None]),
    "StorageStorageStats": MoMeta("StorageStorageStats", "storageStorageStats", "storage-stats", VersionMeta.Version131a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [], [u'storageStorageStatsHist'], [None]),
    "StorageStorageStatsHist": MoMeta("StorageStorageStatsHist", "storageStorageStatsHist", "[id]", VersionMeta.Version131a, "OutputOnly", 0x1, [], ["read-only"], [u'storageStorageStats'], [], [None]),
    "StorageSystem": MoMeta("StorageSystem", "storageSystem", "system", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "StorageTransportableFlashModule": MoMeta("StorageTransportableFlashModule", "storageTransportableFlashModule", "flash-module", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageRaidBattery'], [], ["Get"]),
    "StorageUsageCounters": MoMeta("StorageUsageCounters", "storageUsageCounters", "storage-usage", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storagePartition'], [], ["Get"]),
    "StorageVDMemberEp": MoMeta("StorageVDMemberEp", "storageVDMemberEp", "member-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storageVirtualDrive'], [], ["Get"]),
    "StorageVirtualDrive": MoMeta("StorageVirtualDrive", "storageVirtualDrive", "vd-[id]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'storageController', u'storageVirtualDriveContainer'], [u'storageControllerEp', u'storageLunDisk', u'storageOperation', u'storageScsiLunRef', u'storageVDMemberEp', u'storageVirtualDriveOperation'], ["Get", "Set"]),
    "StorageVirtualDriveContainer": MoMeta("StorageVirtualDriveContainer", "storageVirtualDriveContainer", "vd-container-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit', u'equipmentChassis'], [u'storageVirtualDrive'], ["Get"]),
    "StorageVirtualDriveEp": MoMeta("StorageVirtualDriveEp", "storageVirtualDriveEp", "vd-ep-[container_id]-id-[id]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'storageController'], [], ["Get"]),
    "StorageVirtualDriveOperation": MoMeta("StorageVirtualDriveOperation", "storageVirtualDriveOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'storageVirtualDrive'], [u'faultInst'], ["Get", "Set"]),
    "StorageVirtualDriveRef": MoMeta("StorageVirtualDriveRef", "storageVirtualDriveRef", "vdrive-ref-[lun_item_name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'computeInstance', u'lsServer'], [u'lstorageDiskGroupConfigDef', u'storageLunResourceSelectionLog', u'storageVirtualDriveRefOperation'], ["Get"]),
    "StorageVirtualDriveRefOperation": MoMeta("StorageVirtualDriveRefOperation", "storageVirtualDriveRefOperation", "remote-oper", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "pn-equipment", "pn-maintenance", "pn-policy"], [u'storageVirtualDriveRef'], [u'faultInst'], ["Get", "Set"]),
    "StorageVolume": MoMeta("StorageVolume", "storageVolume", "vol-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [u'storagePartition'], [], ["Get"]),
    "StorageVsanRef": MoMeta("StorageVsanRef", "storageVsanRef", "vsan-ref", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy", "ls-storage", "ls-storage-policy"], [u'fabricFcUserZone', u'storageFcTargetEp'], [u'faultInst', u'vnicFc'], ["Add", "Get", "Set"]),
    "StorageVsanRefIvt": MoMeta("StorageVsanRefIvt", "storageVsanRefIvt", "vsan-ref-ivt", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ext-san-config", "ext-san-policy", "ls-storage", "ls-storage-policy"], [u'fabricFcUserZoneIvt'], [], [None]),
    "SwCardEnvStats": MoMeta("SwCardEnvStats", "swCardEnvStats", "cardenvstats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'networkElement'], [u'swCardEnvStatsHist'], [None]),
    "SwCardEnvStatsHist": MoMeta("SwCardEnvStatsHist", "swCardEnvStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'swCardEnvStats'], [], [None]),
    "SwEnvStats": MoMeta("SwEnvStats", "swEnvStats", "envstats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'networkElement'], [u'swEnvStatsHist'], [None]),
    "SwEnvStatsHist": MoMeta("SwEnvStatsHist", "swEnvStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'swEnvStats'], [], [None]),
    "SwSystemStats": MoMeta("SwSystemStats", "swSystemStats", "sysstats", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["admin", "operations", "read-only"], [u'networkElement'], [u'swSystemStatsHist'], [None]),
    "SwSystemStatsHist": MoMeta("SwSystemStatsHist", "swSystemStatsHist", "[id]", VersionMeta.Version111a, "OutputOnly", 0x1, [], ["read-only"], [u'swSystemStats'], [], [None]),
    "SyntheticDirectory": MoMeta("SyntheticDirectory", "syntheticDirectory", "dir-[ino]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'syntheticDirectory', u'topSystem'], [u'syntheticDirectory', u'syntheticFile'], ["Get"]),
    "SyntheticFile": MoMeta("SyntheticFile", "syntheticFile", "file-[ino]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'syntheticDirectory'], [], ["Get"]),
    "SyntheticFileSystem": MoMeta("SyntheticFileSystem", "syntheticFileSystem", "FS-", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [], ["Get"]),
    "SyntheticFsObj": MoMeta("SyntheticFsObj", "syntheticFsObj", "file-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'topSystem'], [], ["Get"]),
    "SyntheticTime": MoMeta("SyntheticTime", "syntheticTime", "time-[ts]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [], [], ["Get"]),
    "SysdebugAutoCoreFileExportTarget": MoMeta("SysdebugAutoCoreFileExportTarget", "sysdebugAutoCoreFileExportTarget", "file-export", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'orgDomainGroup', u'policyDeviceProfile', u'sysdebugEp'], [u'eventInst', u'faultInst', u'sysdebugAutoCoreFileExportTargetFsm', u'sysdebugAutoCoreFileExportTargetFsmTask'], ["Add", "Get", "Remove", "Set"]),
    "SysdebugAutoCoreFileExportTargetFsm": MoMeta("SysdebugAutoCoreFileExportTargetFsm", "sysdebugAutoCoreFileExportTargetFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'sysdebugAutoCoreFileExportTarget'], [u'sysdebugAutoCoreFileExportTargetFsmStage'], [None]),
    "SysdebugAutoCoreFileExportTargetFsmStage": MoMeta("SysdebugAutoCoreFileExportTargetFsmStage", "sysdebugAutoCoreFileExportTargetFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'sysdebugAutoCoreFileExportTargetFsm'], [], [None]),
    "SysdebugAutoCoreFileExportTargetFsmTask": MoMeta("SysdebugAutoCoreFileExportTargetFsmTask", "sysdebugAutoCoreFileExportTargetFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'sysdebugAutoCoreFileExportTarget'], [], ["Get"]),
    "SysdebugBackupBehavior": MoMeta("SysdebugBackupBehavior", "sysdebugBackupBehavior", "backup", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "operations"], [u'sysdebugMEpLogPolicy'], [], ["Get", "Set"]),
    "SysdebugCore": MoMeta("SysdebugCore", "sysdebugCore", "file-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugCoreFileRepository'], [u'faultInst', u'sysdebugManualCoreFileExportTarget', u'sysfileMutation'], ["Get"]),
    "SysdebugCoreFileRepository": MoMeta("SysdebugCoreFileRepository", "sysdebugCoreFileRepository", "corefiles", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'topSystem'], [u'sysdebugCore', u'sysfileMutation'], ["Get"]),
    "SysdebugDiagnosticLog": MoMeta("SysdebugDiagnosticLog", "sysdebugDiagnosticLog", "diag-log-[name]-[switch_id]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "operations"], [u'computeBlade', u'computeRackUnit', u'computeServerUnit'], [], [None]),
    "SysdebugEp": MoMeta("SysdebugEp", "sysdebugEp", "sysdebug", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'topSystem'], [u'sysdebugAutoCoreFileExportTarget', u'sysdebugLogControlEp'], ["Get"]),
    "SysdebugLogControlDestinationFile": MoMeta("SysdebugLogControlDestinationFile", "sysdebugLogControlDestinationFile", "file", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugLogControlDomain'], [], ["Get", "Set"]),
    "SysdebugLogControlDestinationSyslog": MoMeta("SysdebugLogControlDestinationSyslog", "sysdebugLogControlDestinationSyslog", "syslog", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugLogControlDomain'], [], ["Get", "Set"]),
    "SysdebugLogControlDomain": MoMeta("SysdebugLogControlDomain", "sysdebugLogControlDomain", "domain-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugLogControlEp'], [u'sysdebugLogControlDestinationFile', u'sysdebugLogControlDestinationSyslog', u'sysdebugLogControlModule'], ["Get", "Set"]),
    "SysdebugLogControlEp": MoMeta("SysdebugLogControlEp", "sysdebugLogControlEp", "logcontrol", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugEp'], [u'eventInst', u'faultInst', u'sysdebugLogControlDomain', u'sysdebugLogControlEpFsm', u'sysdebugLogControlEpFsmTask'], ["Get", "Set"]),
    "SysdebugLogControlEpFsm": MoMeta("SysdebugLogControlEpFsm", "sysdebugLogControlEpFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'sysdebugLogControlEp'], [u'sysdebugLogControlEpFsmStage'], [None]),
    "SysdebugLogControlEpFsmStage": MoMeta("SysdebugLogControlEpFsmStage", "sysdebugLogControlEpFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'sysdebugLogControlEpFsm'], [], [None]),
    "SysdebugLogControlEpFsmTask": MoMeta("SysdebugLogControlEpFsmTask", "sysdebugLogControlEpFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'sysdebugLogControlEp'], [], [None]),
    "SysdebugLogControlModule": MoMeta("SysdebugLogControlModule", "sysdebugLogControlModule", "module-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugLogControlDomain'], [], ["Get", "Set"]),
    "SysdebugMEpLogPolicy": MoMeta("SysdebugMEpLogPolicy", "sysdebugMEpLogPolicy", "log-[type]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "operations"], [u'orgDomainGroup'], [u'sysdebugBackupBehavior'], ["Add", "Get", "Remove", "Set"]),
    "SysdebugManualCoreFileExportTarget": MoMeta("SysdebugManualCoreFileExportTarget", "sysdebugManualCoreFileExportTarget", "export-to-[hostname]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugCore'], [u'eventInst', u'faultInst', u'sysdebugManualCoreFileExportTargetFsm', u'sysdebugManualCoreFileExportTargetFsmTask'], ["Get"]),
    "SysdebugManualCoreFileExportTargetFsm": MoMeta("SysdebugManualCoreFileExportTargetFsm", "sysdebugManualCoreFileExportTargetFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'sysdebugManualCoreFileExportTarget'], [u'sysdebugManualCoreFileExportTargetFsmStage'], [None]),
    "SysdebugManualCoreFileExportTargetFsmStage": MoMeta("SysdebugManualCoreFileExportTargetFsmStage", "sysdebugManualCoreFileExportTargetFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'sysdebugManualCoreFileExportTargetFsm'], [], [None]),
    "SysdebugManualCoreFileExportTargetFsmTask": MoMeta("SysdebugManualCoreFileExportTargetFsmTask", "sysdebugManualCoreFileExportTargetFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'sysdebugManualCoreFileExportTarget'], [], [None]),
    "SysdebugTechSupFileRepository": MoMeta("SysdebugTechSupFileRepository", "sysdebugTechSupFileRepository", "tech-support-files", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'computeSystem', u'topSystem'], [u'sysdebugTechSupport', u'sysdebugTechSupportOp', u'sysdebugTechSupportOperation'], ["Get"]),
    "SysdebugTechSupport": MoMeta("SysdebugTechSupport", "sysdebugTechSupport", "tech-support-[creation_ts]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugTechSupFileRepository'], [u'eventInst', u'faultInst', u'sysdebugTechSupportCmdOpt', u'sysdebugTechSupportFsm', u'sysdebugTechSupportFsmTask'], ["Add", "Get", "Remove", "Set"]),
    "SysdebugTechSupportCmdOpt": MoMeta("SysdebugTechSupportCmdOpt", "sysdebugTechSupportCmdOpt", "tech-support-cmd-opt", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugTechSupport', u'sysdebugTechSupportOp', u'sysdebugTechSupportOperation'], [], ["Add", "Get", "Set"]),
    "SysdebugTechSupportFsm": MoMeta("SysdebugTechSupportFsm", "sysdebugTechSupportFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'sysdebugTechSupport'], [u'sysdebugTechSupportFsmStage'], [None]),
    "SysdebugTechSupportFsmStage": MoMeta("SysdebugTechSupportFsmStage", "sysdebugTechSupportFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'sysdebugTechSupportFsm'], [], [None]),
    "SysdebugTechSupportFsmTask": MoMeta("SysdebugTechSupportFsmTask", "sysdebugTechSupportFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'sysdebugTechSupport'], [], [None]),
    "SysdebugTechSupportOp": MoMeta("SysdebugTechSupportOp", "sysdebugTechSupportOp", "remote-oper-[creation_ts]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugTechSupFileRepository'], [u'faultInst', u'sysdebugTechSupportCmdOpt'], ["Add", "Get", "Remove", "Set"]),
    "SysdebugTechSupportOperation": MoMeta("SysdebugTechSupportOperation", "sysdebugTechSupportOperation", "remote-oper", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugTechSupFileRepository'], [u'faultInst', u'sysdebugTechSupportCmdOpt'], ["Get", "Set"]),
    "SysfileDigest": MoMeta("SysfileDigest", "sysfileDigest", "filedigest-[name]-[creation_ts]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "SysfileMutation": MoMeta("SysfileMutation", "sysfileMutation", "mutation", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "operations"], [u'sysdebugCore', u'sysdebugCoreFileRepository'], [u'eventInst', u'faultInst', u'sysfileMutationFsm', u'sysfileMutationFsmTask'], ["Add", "Get"]),
    "SysfileMutationFsm": MoMeta("SysfileMutationFsm", "sysfileMutationFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'sysfileMutation'], [u'sysfileMutationFsmStage'], [None]),
    "SysfileMutationFsmStage": MoMeta("SysfileMutationFsmStage", "sysfileMutationFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'sysfileMutationFsm'], [], [None]),
    "SysfileMutationFsmTask": MoMeta("SysfileMutationFsmTask", "sysfileMutationFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'sysfileMutation'], [], [None]),
    "TagDef": MoMeta("TagDef", "tagDef", "type-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "tag"], [u'tagDefEp'], [u'tagItem'], ["Add", "Get", "Remove", "Set"]),
    "TagDefEp": MoMeta("TagDefEp", "tagDefEp", "tag-def-ep", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'fabricHolder'], [u'tagDef'], [None]),
    "TagDriver": MoMeta("TagDriver", "tagDriver", "type-[def_name]-inst-[value]-obj-[tagged_object_dn]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["aaa", "admin", "ext-lan-config", "ext-lan-policy", "ext-lan-qos", "ext-lan-security", "ext-san-config", "ext-san-policy", "ext-san-qos", "ext-san-security", "fault", "ls-compute", "ls-config", "ls-config-policy", "ls-ext-access", "ls-network", "ls-network-policy", "ls-qos", "ls-qos-policy", "ls-security", "ls-security-policy", "ls-server", "ls-server-oper", "ls-server-policy", "ls-storage", "ls-storage-policy", "operations", "org-management", "pn-equipment", "pn-maintenance", "pn-policy", "pn-security", "pod-config", "pod-policy", "pod-qos", "pod-security", "read-only", "stats-management", "tag"], [u'tagInstanceEp'], [], ["Add", "Get", "Remove", "Set"]),
    "TagInstance": MoMeta("TagInstance", "tagInstance", "type-[def_name]-inst-[value]-obj-[tagged_object_dn]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["aaa", "admin", "ext-lan-config", "ext-lan-policy", "ext-lan-qos", "ext-lan-security", "ext-san-config", "ext-san-policy", "ext-san-qos", "ext-san-security", "fault", "ls-compute", "ls-config", "ls-config-policy", "ls-ext-access", "ls-network", "ls-network-policy", "ls-qos", "ls-qos-policy", "ls-security", "ls-security-policy", "ls-server", "ls-server-oper", "ls-server-policy", "ls-storage", "ls-storage-policy", "operations", "org-management", "pn-equipment", "pn-maintenance", "pn-policy", "pn-security", "pod-config", "pod-policy", "pod-qos", "pod-security", "read-only", "stats-management", "tag"], [u'tagInstanceEp'], [], ["Add", "Get", "Remove"]),
    "TagInstanceEp": MoMeta("TagInstanceEp", "tagInstanceEp", "tag-ep", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [u'fabricHolder'], [u'tagDriver', u'tagInstance', u'tagSoftwareInst'], [None]),
    "TagInstanceItem": MoMeta("TagInstanceItem", "tagInstanceItem", "tag-instance-item", VersionMeta.Version151a, "InputOutput", 0x1, [], ["read-only"], [], [], [None]),
    "TagItem": MoMeta("TagItem", "tagItem", "tag-[value]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "tag"], [u'tagDef'], [], [None]),
    "TagSoftwareInst": MoMeta("TagSoftwareInst", "tagSoftwareInst", "type-[def_name]-inst-[value]-obj-[tagged_object_dn]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["aaa", "admin", "ext-lan-config", "ext-lan-policy", "ext-lan-qos", "ext-lan-security", "ext-san-config", "ext-san-policy", "ext-san-qos", "ext-san-security", "fault", "ls-compute", "ls-config", "ls-config-policy", "ls-ext-access", "ls-network", "ls-network-policy", "ls-qos", "ls-qos-policy", "ls-security", "ls-security-policy", "ls-server", "ls-server-oper", "ls-server-policy", "ls-storage", "ls-storage-policy", "operations", "org-management", "pn-equipment", "pn-maintenance", "pn-policy", "pn-security", "pod-config", "pod-policy", "pod-qos", "pod-security", "read-only", "stats-management", "tag"], [u'tagInstanceEp'], [], ["Add", "Get", "Remove", "Set"]),
    "TestingCliPolicy": MoMeta("TestingCliPolicy", "testingCliPolicy", "cli-policy-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "read-only"], [u'orgOrg', u'topSystem'], [], [None]),
    "TestingServiceProfile": MoMeta("TestingServiceProfile", "testingServiceProfile", "service-profile-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "read-only"], [u'orgOrg'], [u'eventInst', u'faultInst', u'testingServiceProfileFsm', u'testingServiceProfileFsmTask'], [None]),
    "TestingServiceProfileFsm": MoMeta("TestingServiceProfileFsm", "testingServiceProfileFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'testingServiceProfile'], [u'testingServiceProfileFsmStage'], [None]),
    "TestingServiceProfileFsmStage": MoMeta("TestingServiceProfileFsmStage", "testingServiceProfileFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'testingServiceProfileFsm'], [], [None]),
    "TestingServiceProfileFsmTask": MoMeta("TestingServiceProfileFsmTask", "testingServiceProfileFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'testingServiceProfile'], [], [None]),
    "TestingSnmpCommunity": MoMeta("TestingSnmpCommunity", "testingSnmpCommunity", "snmp-community-[community]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "read-only"], [u'testingSnmpSupport'], [], [None]),
    "TestingSnmpPolicy": MoMeta("TestingSnmpPolicy", "testingSnmpPolicy", "snmp-policy-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "read-only"], [u'orgOrg', u'topSystem'], [u'testingSnmpSupport'], [None]),
    "TestingSnmpSupport": MoMeta("TestingSnmpSupport", "testingSnmpSupport", "snmp-support-[version]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "read-only"], [u'testingSnmpPolicy'], [u'testingSnmpCommunity', u'testingSnmpTrap'], [None]),
    "TestingSnmpTrap": MoMeta("TestingSnmpTrap", "testingSnmpTrap", "snmp-trap-[hostname]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "read-only"], [u'testingSnmpSupport'], [], [None]),
    "TopInfoSyncPolicy": MoMeta("TopInfoSyncPolicy", "topInfoSyncPolicy", "info-sync-policy", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-san-config"], [u'orgDomainGroup'], [], ["Get", "Set"]),
    "TopMetaInf": MoMeta("TopMetaInf", "topMetaInf", "meta", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [], ["Get"]),
    "TopRoot": MoMeta("TopRoot", "topRoot", "", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [], [u'aaaLog', u'callhomeHolder', u'capabilityCatalogue', u'clitestTypeTest', u'clitestTypeTest2', u'computeResourceAggrEp', u'configImpactAnalyzerEp', u'consumerUniverse', u'controllerEp', u'domainEp', u'eventHolder', u'eventLog', u'extpolEp', u'fabricHolder', u'faultHolder', u'fcpoolUniverse', u'glEp', u'guiGuiCont', u'hcHolder', u'identMetaVerse', u'identpoolMetaVerse', u'inventoryEp', u'ippoolUniverse', u'iqnpoolUniverse', u'macpoolUniverse', u'mgmtEp', u'nfsEp', u'observeObservedCont', u'orgDomainGroup', u'orgOrg', u'policyLocalMap', u'policyPolicyEp', u'policyUniverse', u'procManager', u'queryEp', u'smartlicenseHolder', u'statsDbSummaryMeta', u'statsHolder', u'statsStatsQueryHolder', u'storageCloud', u'syntheticFileSystem', u'topMetaInf', u'topSystem', u'uuidpoolUniverse'], ["Get"]),
    "TopSystem": MoMeta("TopSystem", "topSystem", "sys", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ext-lan-config"], [u'topRoot'], [u'aaaAuthRealm', u'aaaLdapEp', u'aaaRadiusEp', u'aaaTacacsPlusEp', u'aaaUserEp', u'certRepairEp', u'commSvcEp', u'configCatalogue', u'configDbConfig', u'eventInst', u'faultInst', u'featureCatalogEp', u'firmwareCatalogue', u'firmwareRemoteCatalogue', u'firmwareStatus', u'firmwareSystem', u'fsmStatus', u'initiatorRequestorEp', u'initiatorRequestorGrpEp', u'licenseEp', u'mgmtBackup', u'mgmtController', u'mgmtDataExporter', u'mgmtDataImporter', u'mgmtEntity', u'mgmtImporter', u'mgmtRegistryInfo', u'networkElement', u'pkiEp', u'statsCustomEp', u'statsStandardEp', u'syntheticDirectory', u'syntheticFsObj', u'sysdebugCoreFileRepository', u'sysdebugEp', u'sysdebugTechSupFileRepository', u'testingCliPolicy', u'testingSnmpPolicy', u'topSystemFsm', u'topSystemFsmTask', u'trigMeta', u'trigSched', u'versionEp'], ["Get", "Set"]),
    "TopSystemFsm": MoMeta("TopSystemFsm", "topSystemFsm", "fsm", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'topSystem'], [u'topSystemFsmStage'], [None]),
    "TopSystemFsmStage": MoMeta("TopSystemFsmStage", "topSystemFsmStage", "stage-[name]", VersionMeta.Version141a, "OutputOnly", 0x1, [], [""], [u'topSystemFsm'], [], [None]),
    "TopSystemFsmTask": MoMeta("TopSystemFsmTask", "topSystemFsmTask", "task-[item]", VersionMeta.Version101a, "OutputOnly", 0x1, [], [""], [u'topSystem'], [], [None]),
    "TrigAbsWindow": MoMeta("TrigAbsWindow", "trigAbsWindow", "abs-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "operations"], [u'trigSched'], [], ["Add", "Get", "Remove", "Set"]),
    "TrigMeta": MoMeta("TrigMeta", "trigMeta", "meta-trig-[sched_name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'firmwareDomainInfraProfile', u'orgDomainGroup', u'storageCloud', u'topSystem'], [u'trigServerToken', u'trigTokenRequestor', u'trigTriggered'], ["Get"]),
    "TrigPendingAckCount": MoMeta("TrigPendingAckCount", "trigPendingAckCount", "pending-ack-count", VersionMeta.Version121a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], [u'orgDomainGroup'], [], ["Get"]),
    "TrigRecurrWindow": MoMeta("TrigRecurrWindow", "trigRecurrWindow", "recurr-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], [u'trigSched'], [], ["Add", "Get", "Remove", "Set"]),
    "TrigSched": MoMeta("TrigSched", "trigSched", "sched-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "operations"], [u'firmwareDomainInfraProfile', u'orgDomainGroup', u'storageCloud', u'topSystem'], [u'lstorageRecurrWindow', u'trigAbsWindow', u'trigRecurrWindow'], ["Add", "Get", "Remove", "Set"]),
    "TrigServerToken": MoMeta("TrigServerToken", "trigServerToken", "servertoken-[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'trigMeta'], [], ["Get"]),
    "TrigTest": MoMeta("TrigTest", "trigTest", "test-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'orgDomainGroup', u'orgOrg'], [u'faultInst'], ["Get"]),
    "TrigTokenRequestor": MoMeta("TrigTokenRequestor", "trigTokenRequestor", "tokenreq-[id]-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "domain-group-management", "ls-compute", "ls-config", "ls-server"], [u'trigMeta'], [], ["Get", "Set"]),
    "TrigTriggered": MoMeta("TrigTriggered", "trigTriggered", "trig-[tr_id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'trigMeta'], [], ["Get"]),
    "UuidpoolAddr": MoMeta("UuidpoolAddr", "uuidpoolAddr", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'uuidpoolUniverse'], [u'faultInst', u'identpoolConsumed', u'identpoolPoolable'], ["Get"]),
    "UuidpoolBlock": MoMeta("UuidpoolBlock", "uuidpoolBlock", "block-from-[r_from]-to-[to]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "pn-policy"], [u'uuidpoolPool'], [], ["Add", "Get", "Remove"]),
    "UuidpoolFormat": MoMeta("UuidpoolFormat", "uuidpoolFormat", "format-[format]-[mask]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-storage", "ls-storage-policy"], [u'uuidpoolUniverse'], [], ["Get"]),
    "UuidpoolPool": MoMeta("UuidpoolPool", "uuidpoolPool", "uuid-pool-[name]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'faultInst', u'uuidpoolBlock', u'uuidpoolPooled'], ["Add", "Get", "Remove", "Set"]),
    "UuidpoolPooled": MoMeta("UuidpoolPooled", "uuidpoolPooled", "[id]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'uuidpoolPool'], [], ["Get"]),
    "UuidpoolUniverse": MoMeta("UuidpoolUniverse", "uuidpoolUniverse", "uuid", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'topRoot'], [u'uuidpoolAddr', u'uuidpoolFormat'], ["Get"]),
    "VersionApplication": MoMeta("VersionApplication", "versionApplication", "application", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'versionEp'], [], ["Get"]),
    "VersionEp": MoMeta("VersionEp", "versionEp", "version", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'topSystem'], [u'versionApplication', u'versionMatrix', u'versionProduct'], [None]),
    "VersionFilter": MoMeta("VersionFilter", "versionFilter", "filter-[capability]", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'versionMatrix'], [], [None]),
    "VersionMatrix": MoMeta("VersionMatrix", "versionMatrix", "matrix", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'versionEp'], [u'versionFilter'], ["Get"]),
    "VersionProduct": MoMeta("VersionProduct", "versionProduct", "product", VersionMeta.Version101a, "InputOutput", 0x1, [], ["read-only"], [u'versionEp'], [], ["Get"]),
    "VmNic": MoMeta("VmNic", "vmNic", "nic-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "read-only"], [], [u'adaptorEthPortBySizeLargeStats', u'adaptorEthPortBySizeSmallStats', u'adaptorEthPortErrStats', u'adaptorEthPortMcastStats', u'adaptorEthPortOutsizedStats', u'adaptorEthPortStats', u'adaptorFcPortStats', u'adaptorVnicStats', u'fabricEthMonSrcEp', u'fabricFcMonSrcEp', u'faultInst'], ["Get"]),
    "VnicBootIpPolicy": MoMeta("VnicBootIpPolicy", "vnicBootIpPolicy", "", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [], [], ["Get"]),
    "VnicBootTarget": MoMeta("VnicBootTarget", "vnicBootTarget", "boot-target", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], [u'vnicFc'], [], ["Get"]),
    "VnicConnDef": MoMeta("VnicConnDef", "vnicConnDef", "conn-def", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server"], [u'lsServer'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "VnicDefBeh": MoMeta("VnicDefBeh", "vnicDefBeh", "def-beh-[type]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server"], [u'lsServer'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicDynamicCon": MoMeta("VnicDynamicCon", "vnicDynamicCon", "dynamic-con", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-network-policy", "ls-server"], [u'lsServer', u'orgOrg'], [], ["Get", "Set"]),
    "VnicDynamicConPolicy": MoMeta("VnicDynamicConPolicy", "vnicDynamicConPolicy", "dynamic-con-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicDynamicConPolicyRef": MoMeta("VnicDynamicConPolicyRef", "vnicDynamicConPolicyRef", "con-ref-[con_policy_name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-network-policy", "ls-server"], [u'vnicEther', u'vnicLanConnTempl'], [u'faultInst'], ["Add", "Get", "Remove"]),
    "VnicEthLif": MoMeta("VnicEthLif", "vnicEthLif", "eth-lif-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-storage"], [], [], ["Get"]),
    "VnicEther": MoMeta("VnicEther", "vnicEther", "ether-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [u'computeInstance', u'computeLocalTemplDef', u'fabricDceSwSrvPcOperation', u'fabricEthEstcEpOperation', u'fabricEthEstcPcOperation', u'fabricEthLanEpOperation', u'fabricEthLanPcOperation', u'fabricEthMonOperation', u'lsServer', u'vnicLanConnPolicy', u'vnicNetGroup', u'vnicNetGroupRef'], [u'fabricEthMonSrcEp', u'fabricEthMonSrcEpOperation', u'fabricFcMonSrcEp', u'fabricNetGroupRef', u'faultInst', u'vnicDynamicConPolicyRef', u'vnicEtherIf', u'vnicFcOEIf', u'vnicLifVlan', u'vnicUsnicConPolicyRef', u'vnicVmqConPolicyRef'], ["Add", "Get", "Remove", "Set"]),
    "VnicEtherIf": MoMeta("VnicEtherIf", "vnicEtherIf", "if-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [u'vnicEther', u'vnicLanConnTempl'], [u'faultInst', u'vnicFault', u'vnicIPv4If'], ["Add", "Get", "Remove", "Set"]),
    "VnicFault": MoMeta("VnicFault", "vnicFault", "fault-if", VersionMeta.Version112a, "InputOutput", 0x1, [], ["read-only"], [u'storageEthLif', u'vnicEtherIf', u'vnicFcIf', u'vnicFcOEIf', u'vnicIPv4If', u'vnicIPv6If', u'vnicIniGrpFcBIf', u'vnicIniGrpFcIf', u'vnicLifVlan', u'vnicLifVsan', u'vnicMgmtIf', u'vnicMonSesFcIf', u'vnicStorageEthLif', u'vnicVlan'], [u'faultInst'], ["Get"]),
    "VnicFc": MoMeta("VnicFc", "vnicFc", "fc-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'computeInstance', u'computeLocalTemplDef', u'fabricFcEstcEpOperation', u'fabricFcMonOperation', u'fabricFcSanEpOperation', u'fabricFcSanPcOperation', u'fabricFcoeEstcEpOperation', u'fabricFcoeSanEpOperation', u'fabricFcoeSanPcOperation', u'lsServer', u'storageVsanRef', u'vnicSanConnPolicy'], [u'fabricEthMonSrcEp', u'fabricFcMonSrcEp', u'fabricFcMonSrcEpOperation', u'faultInst', u'vnicBootTarget', u'vnicFcIf'], ["Add", "Get", "Remove", "Set"]),
    "VnicFcGroupDef": MoMeta("VnicFcGroupDef", "vnicFcGroupDef", "fc-group", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-server", "ls-storage"], [u'storageIniGroup'], [u'faultInst', u'storageConnectionDef', u'vnicIniGrpFc', u'vnicIniGrpFcB'], ["Add", "Get", "Set"]),
    "VnicFcGroupTempl": MoMeta("VnicFcGroupTempl", "vnicFcGroupTempl", "fc-group-templ-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage", "ls-storage-policy"], [u'orgOrg'], [u'faultInst'], [None]),
    "VnicFcIf": MoMeta("VnicFcIf", "vnicFcIf", "if-default", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [u'vnicFc', u'vnicSanConnTempl'], [u'faultInst', u'vnicFault'], ["Add", "Get", "Remove", "Set"]),
    "VnicFcLif": MoMeta("VnicFcLif", "vnicFcLif", "eth-lif-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["read-only"], [], [], ["Get"]),
    "VnicFcNode": MoMeta("VnicFcNode", "vnicFcNode", "fc-node", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], [u'lsServer', u'vnicSanConnPolicy'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "VnicFcOEIf": MoMeta("VnicFcOEIf", "vnicFcOEIf", "fcoe", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ext-lan-config", "ext-lan-policy", "ext-san-config", "ext-san-policy", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'vnicEther', u'vnicLanConnTempl'], [u'vnicFault'], ["Get"]),
    "VnicIPv4Dhcp": MoMeta("VnicIPv4Dhcp", "vnicIPv4Dhcp", "ipv4-dhcp", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'vnicIPv4If'], [], ["Get", "Remove"]),
    "VnicIPv4Dns": MoMeta("VnicIPv4Dns", "vnicIPv4Dns", "ipv4-dns-[pref]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'vnicIPv4If', u'vnicIPv4IscsiAddr', u'vnicIPv4PooledIscsiAddr'], [], ["Get"]),
    "VnicIPv4If": MoMeta("VnicIPv4If", "vnicIPv4If", "ipv4", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'storageEthLif', u'vnicEtherIf', u'vnicIScsiBootVnic', u'vnicStorageEthLif', u'vnicVlan'], [u'storageIpV4PooledAddr', u'storageIpV4StaticAddr', u'vnicFault', u'vnicIPv4Dhcp', u'vnicIPv4Dns', u'vnicIPv4IscsiAddr', u'vnicIPv4PooledIscsiAddr', u'vnicIPv4StaticRoute', u'vnicIpV4MgmtPooledAddr', u'vnicIpV4PooledAddr', u'vnicIpV4ProfDerivedAddr', u'vnicIpV4StaticAddr'], ["Add", "Get", "Remove", "Set"]),
    "VnicIPv4IscsiAddr": MoMeta("VnicIPv4IscsiAddr", "vnicIPv4IscsiAddr", "ipv4iscsi", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'vnicIPv4If', u'vnicIScsi'], [u'vnicIPv4Dns'], ["Add", "Get", "Remove", "Set"]),
    "VnicIPv4PooledIscsiAddr": MoMeta("VnicIPv4PooledIscsiAddr", "vnicIPv4PooledIscsiAddr", "ipv4-pooled-iscsiaddr", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'vnicIPv4If'], [u'faultInst', u'vnicIPv4Dns'], ["Add", "Get", "Remove", "Set"]),
    "VnicIPv4StaticRoute": MoMeta("VnicIPv4StaticRoute", "vnicIPv4StaticRoute", "ipv4-route-[addr]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'vnicIPv4If'], [], ["Get"]),
    "VnicIPv6If": MoMeta("VnicIPv6If", "vnicIPv6If", "", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], [], [u'vnicFault'], [None]),
    "VnicIScsi": MoMeta("VnicIScsi", "vnicIScsi", "iscsi-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'computeInstance', u'computeLocalTemplDef', u'lsServer'], [u'fabricEthMonSrcEp', u'fabricFcMonSrcEp', u'faultInst', u'vnicIPv4IscsiAddr', u'vnicIScsiAutoTargetIf', u'vnicIScsiInitiatorParams', u'vnicIScsiStaticTargetIf', u'vnicVlan'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiAutoTargetIf": MoMeta("VnicIScsiAutoTargetIf", "vnicIScsiAutoTargetIf", "auto", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'vnicIScsi', u'vnicIScsiBootVnic', u'vnicIScsiTargetParams', u'vnicVlan'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiBootParams": MoMeta("VnicIScsiBootParams", "vnicIScsiBootParams", "iscsi-boot-params", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'lsServer'], [u'vnicIScsiBootVnic'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiBootVnic": MoMeta("VnicIScsiBootVnic", "vnicIScsiBootVnic", "boot-vnic-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'vnicIScsiBootParams', u'vnicIScsiInitiatorParams'], [u'faultInst', u'vnicIPv4If', u'vnicIScsiAutoTargetIf', u'vnicIScsiStaticTargetIf'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiInitiatorParams": MoMeta("VnicIScsiInitiatorParams", "vnicIScsiInitiatorParams", "iscsi-initiator-params", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'vnicIScsi', u'vnicIScsiLCP'], [u'vnicIScsiBootVnic'], ["Get"]),
    "VnicIScsiLCP": MoMeta("VnicIScsiLCP", "vnicIScsiLCP", "iscsi-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'lsServer', u'vnicLanConnPolicy'], [u'fabricEthMonSrcEp', u'fabricFcMonSrcEp', u'faultInst', u'vnicIScsiInitiatorParams', u'vnicVlan'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiNode": MoMeta("VnicIScsiNode", "vnicIScsiNode", "iscsi-node", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [u'lsServer', u'vnicLanConnPolicy'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiStaticTargetIf": MoMeta("VnicIScsiStaticTargetIf", "vnicIScsiStaticTargetIf", "[priority]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'vnicIScsi', u'vnicIScsiBootVnic', u'vnicIScsiTargetParams', u'vnicVlan'], [u'faultInst', u'vnicLun'], ["Add", "Get", "Remove", "Set"]),
    "VnicIScsiTargetParams": MoMeta("VnicIScsiTargetParams", "vnicIScsiTargetParams", "iscsi-target-params", VersionMeta.Version131a, "InputOutput", 0x1, [], [""], [u'lsbootIScsiImagePath'], [u'vnicIScsiAutoTargetIf', u'vnicIScsiStaticTargetIf'], [None]),
    "VnicIniGrpFc": MoMeta("VnicIniGrpFc", "vnicIniGrpFc", "inigrp-fc", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'lsServer', u'vnicFcGroupDef'], [u'fabricEthMonSrcEp', u'fabricFcMonSrcEp', u'faultInst', u'vnicIniGrpFcIf'], ["Get"]),
    "VnicIniGrpFcB": MoMeta("VnicIniGrpFcB", "vnicIniGrpFcB", "inigrp-fcb", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], [u'lsServer', u'vnicFcGroupDef'], [u'fabricEthMonSrcEp', u'fabricFcMonSrcEp', u'faultInst', u'vnicIniGrpFcBIf'], ["get"]),
    "VnicIniGrpFcBIf": MoMeta("VnicIniGrpFcBIf", "vnicIniGrpFcBIf", "inigrp-fcb-if-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [u'vnicIniGrpFcB'], [u'vnicFault'], ["get"]),
    "VnicIniGrpFcIf": MoMeta("VnicIniGrpFcIf", "vnicIniGrpFcIf", "inigrp-fc-if-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [u'vnicIniGrpFc'], [u'vnicFault'], ["Get"]),
    "VnicIpV4MgmtPooledAddr": MoMeta("VnicIpV4MgmtPooledAddr", "vnicIpV4MgmtPooledAddr", "ipv4-pooled-addr", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'computeInstance', u'lsServer', u'mgmtVnet', u'vnicIPv4If', u'vnicMgmtIf'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "VnicIpV4PooledAddr": MoMeta("VnicIpV4PooledAddr", "vnicIpV4PooledAddr", "ipv4-pooled-addr", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'computeInstance', u'lsServer', u'mgmtController', u'mgmtVnet', u'vnicIPv4If', u'vnicMgmtIf', u'vnicOutbandMgmtEp'], [u'faultInst'], ["Get"]),
    "VnicIpV4ProfDerivedAddr": MoMeta("VnicIpV4ProfDerivedAddr", "vnicIpV4ProfDerivedAddr", "ipv4-prof-addr", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin"], [u'mgmtController', u'vnicIPv4If'], [], ["Get"]),
    "VnicIpV4StaticAddr": MoMeta("VnicIpV4StaticAddr", "vnicIpV4StaticAddr", "ipv4-static-addr", VersionMeta.Version101a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'computeInstance', u'lsServer', u'lsbootLanImagePath', u'mgmtController', u'mgmtVnet', u'vnicIPv4If', u'vnicMgmtIf', u'vnicOutbandMgmtEp'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicIpV6MgmtPooledAddr": MoMeta("VnicIpV6MgmtPooledAddr", "vnicIpV6MgmtPooledAddr", "ipv6-pooled-addr", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'mgmtVnet', u'vnicMgmtIf'], [u'faultInst'], ["Add", "Get", "Remove", "Set"]),
    "VnicIpV6StaticAddr": MoMeta("VnicIpV6StaticAddr", "vnicIpV6StaticAddr", "ipv6-static-addr", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'mgmtVnet', u'vnicMgmtIf'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicLanConnPolicy": MoMeta("VnicLanConnPolicy", "vnicLanConnPolicy", "lan-conn-pol-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'vnicEther', u'vnicIScsiLCP', u'vnicIScsiNode'], ["Add", "Get", "Remove", "Set"]),
    "VnicLanConnTempl": MoMeta("VnicLanConnTempl", "vnicLanConnTempl", "lan-conn-templ-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'fabricNetGroupRef', u'fabricSanGroupRef', u'faultInst', u'vnicDynamicConPolicyRef', u'vnicEtherIf', u'vnicFcOEIf', u'vnicUsnicConPolicyRef', u'vnicVmqConPolicyRef'], ["Add", "Get", "Remove", "Set"]),
    "VnicLifVlan": MoMeta("VnicLifVlan", "vnicLifVlan", "vlan-[vnet]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "read-only"], [u'vnicEther'], [u'vnicFault'], ["Get"]),
    "VnicLifVsan": MoMeta("VnicLifVsan", "vnicLifVsan", "vsan-[vnet]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "read-only"], [], [u'vnicFault'], ["Get"]),
    "VnicLstorageIScsi": MoMeta("VnicLstorageIScsi", "vnicLstorageIScsi", "lstorageIScsi-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], [u'lsServer'], [u'fabricEthMonSrcEp', u'fabricFcMonSrcEp', u'faultInst', u'vnicVlan'], ["Get"]),
    "VnicLun": MoMeta("VnicLun", "vnicLun", "lun", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], [u'vnicIScsiStaticTargetIf'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicMgmt": MoMeta("VnicMgmt", "vnicMgmt", "mgmt", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], [u'fdBlade', u'fdRackUnit', u'lsServer'], [u'fabricEthMonSrcEp', u'fabricFcMonSrcEp', u'faultInst', u'vnicMgmtIf'], ["Add", "Get", "Remove", "Set"]),
    "VnicMgmtIf": MoMeta("VnicMgmtIf", "vnicMgmtIf", "mgmt-if", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [u'vnicMgmt'], [u'faultInst', u'storageIpV4PooledAddr', u'storageIpV4StaticAddr', u'vnicFault', u'vnicIpV4MgmtPooledAddr', u'vnicIpV4PooledAddr', u'vnicIpV4StaticAddr', u'vnicIpV6MgmtPooledAddr', u'vnicIpV6StaticAddr'], ["Add", "Get", "Remove", "Set"]),
    "VnicMonSesFc": MoMeta("VnicMonSesFc", "vnicMonSesFc", "monses-fc-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-server", "ls-storage"], [u'fabricFcEstcEpOperation', u'fabricFcMonOperation', u'fabricFcSanEpOperation', u'fabricFcSanPcOperation', u'fabricFcoeEstcEpOperation', u'fabricFcoeSanEpOperation', u'fabricFcoeSanPcOperation', u'lsServer'], [u'fabricEthMonSrcEp', u'fabricFcMonSrcEp', u'faultInst', u'vnicMonSesFcIf'], ["Get"]),
    "VnicMonSesFcIf": MoMeta("VnicMonSesFcIf", "vnicMonSesFcIf", "monses-fc-if-[name]", VersionMeta.Version151a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [u'vnicMonSesFc'], [u'vnicFault'], ["Get"]),
    "VnicNetGroup": MoMeta("VnicNetGroup", "vnicNetGroup", "ng-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'fabricLanCloud'], [u'vnicEther', u'vnicNetGroupRef'], [None]),
    "VnicNetGroupRef": MoMeta("VnicNetGroupRef", "vnicNetGroupRef", "ngref-[name]", VersionMeta.Version201b, "InputOutput", 0x1, [], ["admin"], [u'vnicNetGroup'], [u'vnicEther'], [None]),
    "VnicOutbandMgmtEp": MoMeta("VnicOutbandMgmtEp", "vnicOutbandMgmtEp", "outband-ep", VersionMeta.Version201b, "InputOutput", 0x1, [], ["read-only"], [u'fdBlade', u'fdRackUnit'], [u'eventInst', u'faultInst', u'messageEp', u'vnicIpV4PooledAddr', u'vnicIpV4StaticAddr', u'vnicOutbandMgmtEpFsm', u'vnicOutbandMgmtEpFsmTask'], ["get"]),
    "VnicOutbandMgmtEpFsm": MoMeta("VnicOutbandMgmtEpFsm", "vnicOutbandMgmtEpFsm", "fsm", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'vnicOutbandMgmtEp'], [u'vnicOutbandMgmtEpFsmStage'], [None]),
    "VnicOutbandMgmtEpFsmStage": MoMeta("VnicOutbandMgmtEpFsmStage", "vnicOutbandMgmtEpFsmStage", "stage-[name]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'vnicOutbandMgmtEpFsm'], [], [None]),
    "VnicOutbandMgmtEpFsmTask": MoMeta("VnicOutbandMgmtEpFsmTask", "vnicOutbandMgmtEpFsmTask", "task-[item]", VersionMeta.Version201b, "OutputOnly", 0x1, [], [""], [u'vnicOutbandMgmtEp'], [], [None]),
    "VnicProfileSet": MoMeta("VnicProfileSet", "vnicProfileSet", "profiles", VersionMeta.Version141a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy"], [u'fabricLanCloud'], [u'vnicRackServerDiscoveryProfile'], ["Get"]),
    "VnicRackServerDiscoveryProfile": MoMeta("VnicRackServerDiscoveryProfile", "vnicRackServerDiscoveryProfile", "vnic-[name]", VersionMeta.Version141a, "InputOutput", 0x1, [], ["read-only"], [u'vnicProfileSet'], [], ["Get", "Set"]),
    "VnicSanConnPolicy": MoMeta("VnicSanConnPolicy", "vnicSanConnPolicy", "san-conn-pol-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'storageIniGroup', u'vnicFc', u'vnicFcNode'], ["Add", "Get", "Remove", "Set"]),
    "VnicSanConnTempl": MoMeta("VnicSanConnTempl", "vnicSanConnTempl", "san-conn-templ-[name]", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [u'fabricNetGroupRef', u'fabricSanGroupRef', u'faultInst', u'vnicFcIf'], ["Add", "Get", "Remove", "Set"]),
    "VnicStorageEthLif": MoMeta("VnicStorageEthLif", "vnicStorageEthLif", "eth-lif-[name]", VersionMeta.Version131a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server", "ls-storage"], [], [u'faultInst', u'vnicFault', u'vnicIPv4If'], [None]),
    "VnicUsnicConPolicy": MoMeta("VnicUsnicConPolicy", "vnicUsnicConPolicy", "usnic-con-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-network", "ls-network-policy", "ls-server"], [u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicUsnicConPolicyRef": MoMeta("VnicUsnicConPolicyRef", "vnicUsnicConPolicyRef", "usnic-con-ref", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-config", "ls-network", "ls-server"], [u'vnicEther', u'vnicLanConnTempl'], [u'faultInst'], ["Add", "Get", "Remove"]),
    "VnicVhbaBehPolicy": MoMeta("VnicVhbaBehPolicy", "vnicVhbaBehPolicy", "beh-vhba", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [], ["Get", "Set"]),
    "VnicVlan": MoMeta("VnicVlan", "vnicVlan", "vlan", VersionMeta.Version111a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [u'vnicIScsi', u'vnicIScsiLCP', u'vnicLstorageIScsi'], [u'vnicFault', u'vnicIPv4If', u'vnicIScsiAutoTargetIf', u'vnicIScsiStaticTargetIf'], ["Add", "Get", "Remove", "Set"]),
    "VnicVmqConPolicy": MoMeta("VnicVmqConPolicy", "vnicVmqConPolicy", "vmq-con-[name]", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-compute", "ls-network", "ls-network-policy", "ls-server"], [u'orgOrg'], [], ["Add", "Get", "Remove", "Set"]),
    "VnicVmqConPolicyRef": MoMeta("VnicVmqConPolicyRef", "vnicVmqConPolicyRef", "vmq-con-ref", VersionMeta.Version112a, "InputOutput", 0x1, [], ["admin", "ls-config", "ls-network", "ls-server"], [u'vnicEther', u'vnicLanConnTempl'], [u'faultInst'], ["Add", "Get", "Remove"]),
    "VnicVnicBehPolicy": MoMeta("VnicVnicBehPolicy", "vnicVnicBehPolicy", "beh-vnic", VersionMeta.Version111a, "InputOutput", 0x1, [], ["read-only"], [u'orgOrg'], [], ["Get", "Set"]),
}


METHOD_CLASS_ID = frozenset([
    "AaaChangeSelfPassword",
    "AaaCheckComputeAuthToken",
    "AaaCheckComputeExtAccess",
    "AaaGetAuthTokenClient",
    "AaaGetAuthTokenInternal",
    "AaaGetComputeAuthToken",
    "AaaGetKVMLaunchUrlInternal",
    "AaaGetNComputeAuthTokenByDn",
    "AaaGetNComputeAuthTokenInternalByDn",
    "AaaGetRemoteUserRoles",
    "AaaGetUserLocales",
    "AaaKeepAlive",
    "AaaLogin",
    "AaaLoginByToken",
    "AaaLogout",
    "AaaRefresh",
    "AaaTokenLogin",
    "AaaTokenRefresh",
    "CliviewConfMos",
    "ComputeGetQualifiedServers",
    "ComputeGetServerCatalog",
    "ComputeReQualifyMembership",
    "ConfigCheckHardwareCompatibility",
    "ConfigClone",
    "ConfigConfFiltered",
    "ConfigConfMo",
    "ConfigConfMoGroup",
    "ConfigConfMos",
    "ConfigConfRename",
    "ConfigDeleteMo",
    "ConfigFindDependencies",
    "ConfigFindDnsByClassId",
    "ConfigFindPolicyUsage",
    "ConfigGetAckables",
    "ConfigGetConnectedEndpoints",
    "ConfigGetEstimateImpact",
    "ConfigGetIdUniverseUsage",
    "ConfigGetLastBackedUpDomains",
    "ConfigGetNetRefs",
    "ConfigGetPolicyDomainGroup",
    "ConfigGetQualifiedDomains",
    "ConfigGetTokenRequestors",
    "ConfigInstantiateNNamedTemplate",
    "ConfigInstantiateNTemplate",
    "ConfigInstantiateTemplate",
    "ConfigMoChangeEvent",
    "ConfigPublishVlan",
    "ConfigPublishVsan",
    "ConfigRefreshIdentity",
    "ConfigReleaseResolveContext",
    "ConfigRemoteSearch",
    "ConfigRenewResolveContext",
    "ConfigResolveAncestor",
    "ConfigResolveChildren",
    "ConfigResolveChildrenSorted",
    "ConfigResolveClass",
    "ConfigResolveClassDB",
    "ConfigResolveClassFilterIdx",
    "ConfigResolveClassIdx",
    "ConfigResolveClassSorted",
    "ConfigResolveClasses",
    "ConfigResolveClassesSorted",
    "ConfigResolveContext",
    "ConfigResolveDn",
    "ConfigResolveDns",
    "ConfigResolveDomainElements",
    "ConfigResolveParent",
    "ConfigResolveSpotLightIdx",
    "ConfigScope",
    "ConfigSendAppImpactResponse",
    "ConfigTags",
    "ConfigTemplatise",
    "ConfigUCEstimateImpact",
    "EquipmentClone",
    "EquipmentInstantiateNNamedTemplate",
    "EquipmentInstantiateNTemplate",
    "EquipmentInstantiateTemplate",
    "EquipmentTemplatise",
    "EventSendHeartbeat",
    "EventSubscribe",
    "EventSubscribeApps",
    "FabricPermitsForExistingVlanNames",
    "FabricResolveVlanPermits",
    "FabricVnetIdEpOverlapCheck",
    "FaultAckFault",
    "FaultAckFaultByDn",
    "FaultAckFaults",
    "FaultAckFaultsByDn",
    "FaultResolveFault",
    "FirmwareEstimatePackImpact",
    "FirmwareInstallAll",
    "FsmDebugAction",
    "IdentGetBlockReport",
    "IdentGetIdUsage",
    "IdentGetSortedIds",
    "LoggingSyncOcns",
    "LsClone",
    "LsInstantiateNNamedTemplate",
    "LsInstantiateNTemplate",
    "LsInstantiateTemplate",
    "LsTemplatise",
    "LstorageClone",
    "MethodVessel",
    "OrgGetDomainFirmwareReport",
    "OrgGetDomainPolicyReport",
    "OrgGetImpactedDomains",
    "OrgGetNumImpactedDomains",
    "OrgGetSubscribedDomains",
    "OrgResolveElements",
    "OrgResolveInScope",
    "OrgResolveLogicalParents",
    "PolicyResolveNames",
    "PoolResolveInScope",
    "SnmpFindVar",
    "StatsBuildChartResult",
    "StatsBuildCustomChart",
    "StatsBuildStandardChart",
    "StatsClearInterval",
    "StatsSubscribe",
    "SyntheticFSObjInventory",
    "SyntheticFSObjInventoryB",
    "SyntheticTestTx",
])


OTHER_TYPE_CLASS_ID = {
    "Method": "ucscbasetype",
    "MethodSet": "ucscbasetype",
    "AllbitsFilter": "ucscfiltertype",
    "AndFilter": "ucscfiltertype",
    "AnybitFilter": "ucscfiltertype",
    "BwFilter": "ucscfiltertype",
    "ClassId": "ucscbasetype",
    "ClassIdSet": "ucscbasetype",
    "ConfigConfig": "ucscbasetype",
    "ConfigMap": "ucscbasetype",
    "ConfigSet": "ucscbasetype",
    "Dn": "ucscbasetype",
    "DnSet": "ucscbasetype",
    "EqFilter": "ucscfiltertype",
    "FilterFilter": "ucscbasetype",
    "GeFilter": "ucscfiltertype",
    "GtFilter": "ucscfiltertype",
    "Id": "ucscbasetype",
    "IdSet": "ucscbasetype",
    "LeFilter": "ucscfiltertype",
    "LtFilter": "ucscfiltertype",
    "NeFilter": "ucscfiltertype",
    "NotFilter": "ucscfiltertype",
    "OrFilter": "ucscfiltertype",
    "Pair": "ucscbasetype",
    "WcardFilter": "ucscfiltertype",
}
