"""This module contains the general information for PolicyProxyMo ManagedObject."""

from ...ucscmo import ManagedObject
from ...ucsccoremeta import UcscVersion, MoPropertyMeta, MoMeta
from ...ucscmeta import VersionMeta


class PolicyProxyMoConsts():
    OBJECT_TYPE_AAA_AUTH_METHOD = "aaaAuthMethod"
    OBJECT_TYPE_AAA_AUTH_REALM = "aaaAuthRealm"
    OBJECT_TYPE_AAA_AUTH_REALM_FSM = "aaaAuthRealmFsm"
    OBJECT_TYPE_AAA_AUTH_REALM_FSM_STAGE = "aaaAuthRealmFsmStage"
    OBJECT_TYPE_AAA_CONFIG = "aaaConfig"
    OBJECT_TYPE_AAA_CONSOLE_AUTH = "aaaConsoleAuth"
    OBJECT_TYPE_AAA_DEFAULT_AUTH = "aaaDefaultAuth"
    OBJECT_TYPE_AAA_DEFINITION = "aaaDefinition"
    OBJECT_TYPE_AAA_DOMAIN = "aaaDomain"
    OBJECT_TYPE_AAA_DOMAIN_AUTH = "aaaDomainAuth"
    OBJECT_TYPE_AAA_DOMAIN_GROUP = "aaaDomainGroup"
    OBJECT_TYPE_AAA_EP = "aaaEp"
    OBJECT_TYPE_AAA_EP_AUTH_PROFILE = "aaaEpAuthProfile"
    OBJECT_TYPE_AAA_EP_FSM = "aaaEpFsm"
    OBJECT_TYPE_AAA_EP_FSM_STAGE = "aaaEpFsmStage"
    OBJECT_TYPE_AAA_EP_FSM_TASK = "aaaEpFsmTask"
    OBJECT_TYPE_AAA_EP_LOGIN = "aaaEpLogin"
    OBJECT_TYPE_AAA_EP_USER = "aaaEpUser"
    OBJECT_TYPE_AAA_EXT_MGMT_CUT_THRU_TKN = "aaaExtMgmtCutThruTkn"
    OBJECT_TYPE_AAA_ITEM = "aaaItem"
    OBJECT_TYPE_AAA_LDAP_EP = "aaaLdapEp"
    OBJECT_TYPE_AAA_LDAP_EP_FSM = "aaaLdapEpFsm"
    OBJECT_TYPE_AAA_LDAP_EP_FSM_STAGE = "aaaLdapEpFsmStage"
    OBJECT_TYPE_AAA_LDAP_GROUP = "aaaLdapGroup"
    OBJECT_TYPE_AAA_LDAP_GROUP_RULE = "aaaLdapGroupRule"
    OBJECT_TYPE_AAA_LDAP_PROVIDER = "aaaLdapProvider"
    OBJECT_TYPE_AAA_LOCALE = "aaaLocale"
    OBJECT_TYPE_AAA_LOG = "aaaLog"
    OBJECT_TYPE_AAA_MOD_LR = "aaaModLR"
    OBJECT_TYPE_AAA_ORG = "aaaOrg"
    OBJECT_TYPE_AAA_PROVIDER = "aaaProvider"
    OBJECT_TYPE_AAA_PROVIDER_GROUP = "aaaProviderGroup"
    OBJECT_TYPE_AAA_PROVIDER_REF = "aaaProviderRef"
    OBJECT_TYPE_AAA_PWD_PROFILE = "aaaPwdProfile"
    OBJECT_TYPE_AAA_RADIUS_EP = "aaaRadiusEp"
    OBJECT_TYPE_AAA_RADIUS_EP_FSM = "aaaRadiusEpFsm"
    OBJECT_TYPE_AAA_RADIUS_EP_FSM_STAGE = "aaaRadiusEpFsmStage"
    OBJECT_TYPE_AAA_RADIUS_PROVIDER = "aaaRadiusProvider"
    OBJECT_TYPE_AAA_REALM = "aaaRealm"
    OBJECT_TYPE_AAA_REALM_FSM = "aaaRealmFsm"
    OBJECT_TYPE_AAA_REALM_FSM_STAGE = "aaaRealmFsmStage"
    OBJECT_TYPE_AAA_REALM_FSM_TASK = "aaaRealmFsmTask"
    OBJECT_TYPE_AAA_REMOTE_USER = "aaaRemoteUser"
    OBJECT_TYPE_AAA_ROLE = "aaaRole"
    OBJECT_TYPE_AAA_SESSION = "aaaSession"
    OBJECT_TYPE_AAA_SESSION_LR = "aaaSessionLR"
    OBJECT_TYPE_AAA_SHELL_LOGIN = "aaaShellLogin"
    OBJECT_TYPE_AAA_SSH_AUTH = "aaaSshAuth"
    OBJECT_TYPE_AAA_SYSTEM_USER = "aaaSystemUser"
    OBJECT_TYPE_AAA_TACACS_PLUS_EP = "aaaTacacsPlusEp"
    OBJECT_TYPE_AAA_TACACS_PLUS_EP_FSM = "aaaTacacsPlusEpFsm"
    OBJECT_TYPE_AAA_TACACS_PLUS_EP_FSM_STAGE = "aaaTacacsPlusEpFsmStage"
    OBJECT_TYPE_AAA_TACACS_PLUS_PROVIDER = "aaaTacacsPlusProvider"
    OBJECT_TYPE_AAA_USER = "aaaUser"
    OBJECT_TYPE_AAA_USER_ACTION = "aaaUserAction"
    OBJECT_TYPE_AAA_USER_DATA = "aaaUserData"
    OBJECT_TYPE_AAA_USER_EP = "aaaUserEp"
    OBJECT_TYPE_AAA_USER_EP_FSM = "aaaUserEpFsm"
    OBJECT_TYPE_AAA_USER_EP_FSM_STAGE = "aaaUserEpFsmStage"
    OBJECT_TYPE_AAA_USER_EP_FSM_TASK = "aaaUserEpFsmTask"
    OBJECT_TYPE_AAA_USER_GROUP = "aaaUserGroup"
    OBJECT_TYPE_AAA_USER_LOCALE = "aaaUserLocale"
    OBJECT_TYPE_AAA_USER_LOGIN = "aaaUserLogin"
    OBJECT_TYPE_AAA_USER_PREFERENCES = "aaaUserPreferences"
    OBJECT_TYPE_AAA_USER_ROLE = "aaaUserRole"
    OBJECT_TYPE_AAA_WEB_LOGIN = "aaaWebLogin"
    OBJECT_TYPE_ADAPTOR_BEH_CAP = "adaptorBehCap"
    OBJECT_TYPE_ADAPTOR_CAP_DEF = "adaptorCapDef"
    OBJECT_TYPE_ADAPTOR_CAP_QUAL = "adaptorCapQual"
    OBJECT_TYPE_ADAPTOR_CAP_SPEC = "adaptorCapSpec"
    OBJECT_TYPE_ADAPTOR_ETH_ADV_FILTER_PROFILE = "adaptorEthAdvFilterProfile"
    OBJECT_TYPE_ADAPTOR_ETH_ARFS_PROFILE = "adaptorEthArfsProfile"
    OBJECT_TYPE_ADAPTOR_ETH_COMP_QUEUE_PROFILE = "adaptorEthCompQueueProfile"
    OBJECT_TYPE_ADAPTOR_ETH_FAILOVER_PROFILE = "adaptorEthFailoverProfile"
    OBJECT_TYPE_ADAPTOR_ETH_GENEVEPROFILE = "adaptorEthGENEVEProfile"
    OBJECT_TYPE_ADAPTOR_ETH_INTERRUPT_PROFILE = "adaptorEthInterruptProfile"
    OBJECT_TYPE_ADAPTOR_ETH_INTERRUPT_SCALING_PROFILE = "adaptorEthInterruptScalingProfile"
    OBJECT_TYPE_ADAPTOR_ETH_NVGREPROFILE = "adaptorEthNVGREProfile"
    OBJECT_TYPE_ADAPTOR_ETH_OFFLOAD_PROFILE = "adaptorEthOffloadProfile"
    OBJECT_TYPE_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS = "adaptorEthPortBySizeLargeStats"
    OBJECT_TYPE_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST = "adaptorEthPortBySizeLargeStatsHist"
    OBJECT_TYPE_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS = "adaptorEthPortBySizeSmallStats"
    OBJECT_TYPE_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST = "adaptorEthPortBySizeSmallStatsHist"
    OBJECT_TYPE_ADAPTOR_ETH_PORT_ERR_STATS = "adaptorEthPortErrStats"
    OBJECT_TYPE_ADAPTOR_ETH_PORT_ERR_STATS_HIST = "adaptorEthPortErrStatsHist"
    OBJECT_TYPE_ADAPTOR_ETH_PORT_MCAST_STATS = "adaptorEthPortMcastStats"
    OBJECT_TYPE_ADAPTOR_ETH_PORT_MCAST_STATS_HIST = "adaptorEthPortMcastStatsHist"
    OBJECT_TYPE_ADAPTOR_ETH_PORT_OUTSIZED_STATS = "adaptorEthPortOutsizedStats"
    OBJECT_TYPE_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST = "adaptorEthPortOutsizedStatsHist"
    OBJECT_TYPE_ADAPTOR_ETH_PORT_STATS = "adaptorEthPortStats"
    OBJECT_TYPE_ADAPTOR_ETH_PORT_STATS_HIST = "adaptorEthPortStatsHist"
    OBJECT_TYPE_ADAPTOR_ETH_QUEUE_PROFILE = "adaptorEthQueueProfile"
    OBJECT_TYPE_ADAPTOR_ETH_RECV_QUEUE_PROFILE = "adaptorEthRecvQueueProfile"
    OBJECT_TYPE_ADAPTOR_ETH_RO_CEPROFILE = "adaptorEthRoCEProfile"
    OBJECT_TYPE_ADAPTOR_ETH_VX_LANPROFILE = "adaptorEthVxLANProfile"
    OBJECT_TYPE_ADAPTOR_ETH_WORK_QUEUE_PROFILE = "adaptorEthWorkQueueProfile"
    OBJECT_TYPE_ADAPTOR_ETHER_IF_STATS = "adaptorEtherIfStats"
    OBJECT_TYPE_ADAPTOR_ETHER_IF_STATS_HIST = "adaptorEtherIfStatsHist"
    OBJECT_TYPE_ADAPTOR_EXT_ETH_IF = "adaptorExtEthIf"
    OBJECT_TYPE_ADAPTOR_EXT_ETH_IF_OPERATION = "adaptorExtEthIfOperation"
    OBJECT_TYPE_ADAPTOR_EXT_IF = "adaptorExtIf"
    OBJECT_TYPE_ADAPTOR_EXT_IP_V6_RSS_HASH_PROFILE = "adaptorExtIpV6RssHashProfile"
    OBJECT_TYPE_ADAPTOR_FC_CDB_WORK_QUEUE_PROFILE = "adaptorFcCdbWorkQueueProfile"
    OBJECT_TYPE_ADAPTOR_FC_ERROR_RECOVERY_PROFILE = "adaptorFcErrorRecoveryProfile"
    OBJECT_TYPE_ADAPTOR_FC_FNIC_PROFILE = "adaptorFcFnicProfile"
    OBJECT_TYPE_ADAPTOR_FC_IF_EVENT_STATS = "adaptorFcIfEventStats"
    OBJECT_TYPE_ADAPTOR_FC_IF_EVENT_STATS_HIST = "adaptorFcIfEventStatsHist"
    OBJECT_TYPE_ADAPTOR_FC_IF_FC4_STATS = "adaptorFcIfFC4Stats"
    OBJECT_TYPE_ADAPTOR_FC_IF_FC4_STATS_HIST = "adaptorFcIfFC4StatsHist"
    OBJECT_TYPE_ADAPTOR_FC_IF_FRAME_STATS = "adaptorFcIfFrameStats"
    OBJECT_TYPE_ADAPTOR_FC_IF_FRAME_STATS_HIST = "adaptorFcIfFrameStatsHist"
    OBJECT_TYPE_ADAPTOR_FC_INTERRUPT_PROFILE = "adaptorFcInterruptProfile"
    OBJECT_TYPE_ADAPTOR_FC_LOGI_PROFILE = "adaptorFcLogiProfile"
    OBJECT_TYPE_ADAPTOR_FC_PORT_FLOGI_PROFILE = "adaptorFcPortFLogiProfile"
    OBJECT_TYPE_ADAPTOR_FC_PORT_PLOGI_PROFILE = "adaptorFcPortPLogiProfile"
    OBJECT_TYPE_ADAPTOR_FC_PORT_PROFILE = "adaptorFcPortProfile"
    OBJECT_TYPE_ADAPTOR_FC_PORT_STATS = "adaptorFcPortStats"
    OBJECT_TYPE_ADAPTOR_FC_PORT_STATS_HIST = "adaptorFcPortStatsHist"
    OBJECT_TYPE_ADAPTOR_FC_QUEUE_PROFILE = "adaptorFcQueueProfile"
    OBJECT_TYPE_ADAPTOR_FC_RECV_QUEUE_PROFILE = "adaptorFcRecvQueueProfile"
    OBJECT_TYPE_ADAPTOR_FC_WORK_QUEUE_PROFILE = "adaptorFcWorkQueueProfile"
    OBJECT_TYPE_ADAPTOR_FRU_CAP_PROVIDER = "adaptorFruCapProvider"
    OBJECT_TYPE_ADAPTOR_HBAVNIC_STATS = "adaptorHBAVnicStats"
    OBJECT_TYPE_ADAPTOR_HBAVNIC_STATS_HIST = "adaptorHBAVnicStatsHist"
    OBJECT_TYPE_ADAPTOR_HOST_ETH_IF = "adaptorHostEthIf"
    OBJECT_TYPE_ADAPTOR_HOST_ETH_IF_OPERATION = "adaptorHostEthIfOperation"
    OBJECT_TYPE_ADAPTOR_HOST_ETH_IF_PROFILE = "adaptorHostEthIfProfile"
    OBJECT_TYPE_ADAPTOR_HOST_FC_IF = "adaptorHostFcIf"
    OBJECT_TYPE_ADAPTOR_HOST_FC_IF_OPERATION = "adaptorHostFcIfOperation"
    OBJECT_TYPE_ADAPTOR_HOST_FC_IF_PROFILE = "adaptorHostFcIfProfile"
    OBJECT_TYPE_ADAPTOR_HOST_IF = "adaptorHostIf"
    OBJECT_TYPE_ADAPTOR_HOST_IF_CONFIG = "adaptorHostIfConfig"
    OBJECT_TYPE_ADAPTOR_HOST_IF_CONN_DEF = "adaptorHostIfConnDef"
    OBJECT_TYPE_ADAPTOR_HOST_IF_PROFILE = "adaptorHostIfProfile"
    OBJECT_TYPE_ADAPTOR_HOST_ISCSI_IF = "adaptorHostIscsiIf"
    OBJECT_TYPE_ADAPTOR_HOST_ISCSI_IF_OPERATION = "adaptorHostIscsiIfOperation"
    OBJECT_TYPE_ADAPTOR_HOST_ISCSI_IF_PROFILE = "adaptorHostIscsiIfProfile"
    OBJECT_TYPE_ADAPTOR_HOST_SCSI_IF = "adaptorHostScsiIf"
    OBJECT_TYPE_ADAPTOR_HOST_SCSI_LUN_REF = "adaptorHostScsiLunRef"
    OBJECT_TYPE_ADAPTOR_HW_ADDR_CAP = "adaptorHwAddrCap"
    OBJECT_TYPE_ADAPTOR_ISCSI_CAP = "adaptorIScsiCap"
    OBJECT_TYPE_ADAPTOR_IP_V4_RSS_HASH_PROFILE = "adaptorIpV4RssHashProfile"
    OBJECT_TYPE_ADAPTOR_IP_V6_RSS_HASH_PROFILE = "adaptorIpV6RssHashProfile"
    OBJECT_TYPE_ADAPTOR_MENLO_BASE_ERROR_STATS = "adaptorMenloBaseErrorStats"
    OBJECT_TYPE_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST = "adaptorMenloBaseErrorStatsHist"
    OBJECT_TYPE_ADAPTOR_MENLO_DCE_PORT_STATS = "adaptorMenloDcePortStats"
    OBJECT_TYPE_ADAPTOR_MENLO_DCE_PORT_STATS_HIST = "adaptorMenloDcePortStatsHist"
    OBJECT_TYPE_ADAPTOR_MENLO_ETH_ERROR_STATS = "adaptorMenloEthErrorStats"
    OBJECT_TYPE_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST = "adaptorMenloEthErrorStatsHist"
    OBJECT_TYPE_ADAPTOR_MENLO_ETH_STATS = "adaptorMenloEthStats"
    OBJECT_TYPE_ADAPTOR_MENLO_ETH_STATS_HIST = "adaptorMenloEthStatsHist"
    OBJECT_TYPE_ADAPTOR_MENLO_FC_ERROR_STATS = "adaptorMenloFcErrorStats"
    OBJECT_TYPE_ADAPTOR_MENLO_FC_ERROR_STATS_HIST = "adaptorMenloFcErrorStatsHist"
    OBJECT_TYPE_ADAPTOR_MENLO_FC_STATS = "adaptorMenloFcStats"
    OBJECT_TYPE_ADAPTOR_MENLO_FC_STATS_HIST = "adaptorMenloFcStatsHist"
    OBJECT_TYPE_ADAPTOR_MENLO_HOST_PORT_STATS = "adaptorMenloHostPortStats"
    OBJECT_TYPE_ADAPTOR_MENLO_HOST_PORT_STATS_HIST = "adaptorMenloHostPortStatsHist"
    OBJECT_TYPE_ADAPTOR_MENLO_MCPU_ERROR_STATS = "adaptorMenloMcpuErrorStats"
    OBJECT_TYPE_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST = "adaptorMenloMcpuErrorStatsHist"
    OBJECT_TYPE_ADAPTOR_MENLO_MCPU_STATS = "adaptorMenloMcpuStats"
    OBJECT_TYPE_ADAPTOR_MENLO_MCPU_STATS_HIST = "adaptorMenloMcpuStatsHist"
    OBJECT_TYPE_ADAPTOR_MENLO_NET_EG_STATS = "adaptorMenloNetEgStats"
    OBJECT_TYPE_ADAPTOR_MENLO_NET_EG_STATS_HIST = "adaptorMenloNetEgStatsHist"
    OBJECT_TYPE_ADAPTOR_MENLO_NET_IN_STATS = "adaptorMenloNetInStats"
    OBJECT_TYPE_ADAPTOR_MENLO_NET_IN_STATS_HIST = "adaptorMenloNetInStatsHist"
    OBJECT_TYPE_ADAPTOR_MENLO_QERROR_STATS = "adaptorMenloQErrorStats"
    OBJECT_TYPE_ADAPTOR_MENLO_QERROR_STATS_HIST = "adaptorMenloQErrorStatsHist"
    OBJECT_TYPE_ADAPTOR_MENLO_QSTATS = "adaptorMenloQStats"
    OBJECT_TYPE_ADAPTOR_MENLO_QSTATS_HIST = "adaptorMenloQStatsHist"
    OBJECT_TYPE_ADAPTOR_NICVNIC_STATS = "adaptorNICVnicStats"
    OBJECT_TYPE_ADAPTOR_NICVNIC_STATS_HIST = "adaptorNICVnicStatsHist"
    OBJECT_TYPE_ADAPTOR_PROFILE_ITEM = "adaptorProfileItem"
    OBJECT_TYPE_ADAPTOR_PROTOCOL_PROFILE = "adaptorProtocolProfile"
    OBJECT_TYPE_ADAPTOR_QUAL = "adaptorQual"
    OBJECT_TYPE_ADAPTOR_QUEUE_PROFILE = "adaptorQueueProfile"
    OBJECT_TYPE_ADAPTOR_RNIC_CAP_SPEC = "adaptorRnicCapSpec"
    OBJECT_TYPE_ADAPTOR_RSS_HASH_PROFILE = "adaptorRssHashProfile"
    OBJECT_TYPE_ADAPTOR_RSS_PROFILE = "adaptorRssProfile"
    OBJECT_TYPE_ADAPTOR_TCP_IP_RSS_HASH_PROFILE = "adaptorTcpIpRssHashProfile"
    OBJECT_TYPE_ADAPTOR_UNIT = "adaptorUnit"
    OBJECT_TYPE_ADAPTOR_UNIT_ASSOC_CTX = "adaptorUnitAssocCtx"
    OBJECT_TYPE_ADAPTOR_UNIT_EXTN = "adaptorUnitExtn"
    OBJECT_TYPE_ADAPTOR_USNIC_CONN_DEF = "adaptorUsnicConnDef"
    OBJECT_TYPE_ADAPTOR_VLAN = "adaptorVlan"
    OBJECT_TYPE_ADAPTOR_VMMQ_CONN_DEF = "adaptorVmmqConnDef"
    OBJECT_TYPE_ADAPTOR_VNIC_STATS = "adaptorVnicStats"
    OBJECT_TYPE_ADAPTOR_VNIC_STATS_HIST = "adaptorVnicStatsHist"
    OBJECT_TYPE_BIOS_BOT = "biosBOT"
    OBJECT_TYPE_BIOS_BOOT_DEV = "biosBootDev"
    OBJECT_TYPE_BIOS_BOOT_DEV_GRP = "biosBootDevGrp"
    OBJECT_TYPE_BIOS_TOKEN_FEATURE_GROUP = "biosTokenFeatureGroup"
    OBJECT_TYPE_BIOS_TOKEN_PARAM = "biosTokenParam"
    OBJECT_TYPE_BIOS_TOKEN_SETTINGS = "biosTokenSettings"
    OBJECT_TYPE_BIOS_UNIT = "biosUnit"
    OBJECT_TYPE_BIOS_VFEAT = "biosVFeat"
    OBJECT_TYPE_BIOS_VPROFILE = "biosVProfile"
    OBJECT_TYPE_BIOS_VF_ACPI10_SUPPORT = "biosVfACPI10Support"
    OBJECT_TYPE_BIOS_VF_ASPMSUPPORT = "biosVfASPMSupport"
    OBJECT_TYPE_BIOS_VF_ALL_USBDEVICES = "biosVfAllUSBDevices"
    OBJECT_TYPE_BIOS_VF_ALTITUDE = "biosVfAltitude"
    OBJECT_TYPE_BIOS_VF_ASSERT_NMION_PERR = "biosVfAssertNMIOnPERR"
    OBJECT_TYPE_BIOS_VF_ASSERT_NMION_SERR = "biosVfAssertNMIOnSERR"
    OBJECT_TYPE_BIOS_VF_BOOT_OPTION_RETRY = "biosVfBootOptionRetry"
    OBJECT_TYPE_BIOS_VF_CPUHARDWARE_POWER_MANAGEMENT = "biosVfCPUHardwarePowerManagement"
    OBJECT_TYPE_BIOS_VF_CPUPERFORMANCE = "biosVfCPUPerformance"
    OBJECT_TYPE_BIOS_VF_CPUPOWER_MANAGEMENT = "biosVfCPUPowerManagement"
    OBJECT_TYPE_BIOS_VF_CONSISTENT_DEVICE_NAME_CONTROL = "biosVfConsistentDeviceNameControl"
    OBJECT_TYPE_BIOS_VF_CONSOLE_REDIRECTION = "biosVfConsoleRedirection"
    OBJECT_TYPE_BIOS_VF_CORE_MULTI_PROCESSING = "biosVfCoreMultiProcessing"
    OBJECT_TYPE_BIOS_VF_DDR3_VOLTAGE_SELECTION = "biosVfDDR3VoltageSelection"
    OBJECT_TYPE_BIOS_VF_DRAMCLOCK_THROTTLING = "biosVfDRAMClockThrottling"
    OBJECT_TYPE_BIOS_VF_DIRECT_CACHE_ACCESS = "biosVfDirectCacheAccess"
    OBJECT_TYPE_BIOS_VF_DRAM_REFRESH_RATE = "biosVfDramRefreshRate"
    OBJECT_TYPE_BIOS_VF_ENERGY_PERFORMANCE_TUNING = "biosVfEnergyPerformanceTuning"
    OBJECT_TYPE_BIOS_VF_ENHANCED_INTEL_SPEED_STEP_TECH = "biosVfEnhancedIntelSpeedStepTech"
    OBJECT_TYPE_BIOS_VF_ENHANCED_POWER_CAPPING_SUPPORT = "biosVfEnhancedPowerCappingSupport"
    OBJECT_TYPE_BIOS_VF_EXECUTE_DISABLE_BIT = "biosVfExecuteDisableBit"
    OBJECT_TYPE_BIOS_VF_FRB2_TIMER = "biosVfFRB2Timer"
    OBJECT_TYPE_BIOS_VF_FREQUENCY_FLOOR_OVERRIDE = "biosVfFrequencyFloorOverride"
    OBJECT_TYPE_BIOS_VF_FRONT_PANEL_LOCKOUT = "biosVfFrontPanelLockout"
    OBJECT_TYPE_BIOS_VF_IOEMEZZ1_OPTION_ROM = "biosVfIOEMezz1OptionROM"
    OBJECT_TYPE_BIOS_VF_IOENVME1_OPTION_ROM = "biosVfIOENVMe1OptionROM"
    OBJECT_TYPE_BIOS_VF_IOENVME2_OPTION_ROM = "biosVfIOENVMe2OptionROM"
    OBJECT_TYPE_BIOS_VF_IOESLOT1_OPTION_ROM = "biosVfIOESlot1OptionROM"
    OBJECT_TYPE_BIOS_VF_IOESLOT2_OPTION_ROM = "biosVfIOESlot2OptionROM"
    OBJECT_TYPE_BIOS_VF_INTEGRATED_GRAPHICS = "biosVfIntegratedGraphics"
    OBJECT_TYPE_BIOS_VF_INTEGRATED_GRAPHICS_APERTURE_SIZE = "biosVfIntegratedGraphicsApertureSize"
    OBJECT_TYPE_BIOS_VF_INTEL_ENTRY_SASRAIDMODULE = "biosVfIntelEntrySASRAIDModule"
    OBJECT_TYPE_BIOS_VF_INTEL_HYPER_THREADING_TECH = "biosVfIntelHyperThreadingTech"
    OBJECT_TYPE_BIOS_VF_INTEL_TRUSTED_EXECUTION_TECHNOLOGY = "biosVfIntelTrustedExecutionTechnology"
    OBJECT_TYPE_BIOS_VF_INTEL_TURBO_BOOST_TECH = "biosVfIntelTurboBoostTech"
    OBJECT_TYPE_BIOS_VF_INTEL_VTFOR_DIRECTED_IO = "biosVfIntelVTForDirectedIO"
    OBJECT_TYPE_BIOS_VF_INTEL_VIRTUALIZATION_TECHNOLOGY = "biosVfIntelVirtualizationTechnology"
    OBJECT_TYPE_BIOS_VF_INTERLEAVE_CONFIGURATION = "biosVfInterleaveConfiguration"
    OBJECT_TYPE_BIOS_VF_LOCAL_X2_APIC = "biosVfLocalX2Apic"
    OBJECT_TYPE_BIOS_VF_LV_DIMMSUPPORT = "biosVfLvDIMMSupport"
    OBJECT_TYPE_BIOS_VF_MAX_VARIABLE_MTRRSETTING = "biosVfMaxVariableMTRRSetting"
    OBJECT_TYPE_BIOS_VF_MAXIMUM_MEMORY_BELOW4_GB = "biosVfMaximumMemoryBelow4GB"
    OBJECT_TYPE_BIOS_VF_MEMORY_MAPPED_IOABOVE4_GB = "biosVfMemoryMappedIOAbove4GB"
    OBJECT_TYPE_BIOS_VF_MIRRORING_MODE = "biosVfMirroringMode"
    OBJECT_TYPE_BIOS_VF_NUMAOPTIMIZED = "biosVfNUMAOptimized"
    OBJECT_TYPE_BIOS_VF_OSBOOT_WATCHDOG_TIMER = "biosVfOSBootWatchdogTimer"
    OBJECT_TYPE_BIOS_VF_OSBOOT_WATCHDOG_TIMER_POLICY = "biosVfOSBootWatchdogTimerPolicy"
    OBJECT_TYPE_BIOS_VF_OSBOOT_WATCHDOG_TIMER_TIMEOUT = "biosVfOSBootWatchdogTimerTimeout"
    OBJECT_TYPE_BIOS_VF_ONBOARD_GRAPHICS = "biosVfOnboardGraphics"
    OBJECT_TYPE_BIOS_VF_ONBOARD_SATACONTROLLER = "biosVfOnboardSATAController"
    OBJECT_TYPE_BIOS_VF_ONBOARD_STORAGE = "biosVfOnboardStorage"
    OBJECT_TYPE_BIOS_VF_OPTION_ROMENABLE = "biosVfOptionROMEnable"
    OBJECT_TYPE_BIOS_VF_OPTION_ROMLOAD = "biosVfOptionROMLoad"
    OBJECT_TYPE_BIOS_VF_OUT_OF_BAND_MANAGEMENT = "biosVfOutOfBandManagement"
    OBJECT_TYPE_BIOS_VF_PCHSATAMODE = "biosVfPCHSATAMode"
    OBJECT_TYPE_BIOS_VF_PCILOMPORTS_CONFIGURATION = "biosVfPCILOMPortsConfiguration"
    OBJECT_TYPE_BIOS_VF_PCIROMCLP = "biosVfPCIROMCLP"
    OBJECT_TYPE_BIOS_VF_PCISLOT_LINK_SPEED = "biosVfPCISlotLinkSpeed"
    OBJECT_TYPE_BIOS_VF_PCISLOT_OPTION_ROMENABLE = "biosVfPCISlotOptionROMEnable"
    OBJECT_TYPE_BIOS_VF_POSTERROR_PAUSE = "biosVfPOSTErrorPause"
    OBJECT_TYPE_BIOS_VF_PSTATECOORDINATION = "biosVfPSTATECoordination"
    OBJECT_TYPE_BIOS_VF_PACKAGE_CSTATE_LIMIT = "biosVfPackageCStateLimit"
    OBJECT_TYPE_BIOS_VF_PROCESSOR_C1_E = "biosVfProcessorC1E"
    OBJECT_TYPE_BIOS_VF_PROCESSOR_C3_REPORT = "biosVfProcessorC3Report"
    OBJECT_TYPE_BIOS_VF_PROCESSOR_C6_REPORT = "biosVfProcessorC6Report"
    OBJECT_TYPE_BIOS_VF_PROCESSOR_C7_REPORT = "biosVfProcessorC7Report"
    OBJECT_TYPE_BIOS_VF_PROCESSOR_CMCI = "biosVfProcessorCMCI"
    OBJECT_TYPE_BIOS_VF_PROCESSOR_CSTATE = "biosVfProcessorCState"
    OBJECT_TYPE_BIOS_VF_PROCESSOR_ENERGY_CONFIGURATION = "biosVfProcessorEnergyConfiguration"
    OBJECT_TYPE_BIOS_VF_PROCESSOR_PREFETCH_CONFIG = "biosVfProcessorPrefetchConfig"
    OBJECT_TYPE_BIOS_VF_QPILINK_FREQUENCY_SELECT = "biosVfQPILinkFrequencySelect"
    OBJECT_TYPE_BIOS_VF_QPISNOOP_MODE = "biosVfQPISnoopMode"
    OBJECT_TYPE_BIOS_VF_QUIET_BOOT = "biosVfQuietBoot"
    OBJECT_TYPE_BIOS_VF_REDIRECTION_AFTER_BIOSPOST = "biosVfRedirectionAfterBIOSPOST"
    OBJECT_TYPE_BIOS_VF_RESUME_ON_ACPOWER_LOSS = "biosVfResumeOnACPowerLoss"
    OBJECT_TYPE_BIOS_VF_SBMEZZ1_OPTION_ROM = "biosVfSBMezz1OptionROM"
    OBJECT_TYPE_BIOS_VF_SBNVME1_OPTION_ROM = "biosVfSBNVMe1OptionROM"
    OBJECT_TYPE_BIOS_VF_SIOC1_OPTION_ROM = "biosVfSIOC1OptionROM"
    OBJECT_TYPE_BIOS_VF_SIOC2_OPTION_ROM = "biosVfSIOC2OptionROM"
    OBJECT_TYPE_BIOS_VF_SCRUB_POLICIES = "biosVfScrubPolicies"
    OBJECT_TYPE_BIOS_VF_SELECT_MEMORY_RASCONFIGURATION = "biosVfSelectMemoryRASConfiguration"
    OBJECT_TYPE_BIOS_VF_SERIAL_PORT_AENABLE = "biosVfSerialPortAEnable"
    OBJECT_TYPE_BIOS_VF_SPARING_MODE = "biosVfSparingMode"
    OBJECT_TYPE_BIOS_VF_SRIOV_CONFIG = "biosVfSriovConfig"
    OBJECT_TYPE_BIOS_VF_TPMPENDING_OPERATION = "biosVfTPMPendingOperation"
    OBJECT_TYPE_BIOS_VF_TPMSUPPORT = "biosVfTPMSupport"
    OBJECT_TYPE_BIOS_VF_TRUSTED_PLATFORM_MODULE = "biosVfTrustedPlatformModule"
    OBJECT_TYPE_BIOS_VF_UCSMBOOT_MODE_CONTROL = "biosVfUCSMBootModeControl"
    OBJECT_TYPE_BIOS_VF_UCSMBOOT_ORDER_RULE_CONTROL = "biosVfUCSMBootOrderRuleControl"
    OBJECT_TYPE_BIOS_VF_UEFIOSUSE_LEGACY_VIDEO = "biosVfUEFIOSUseLegacyVideo"
    OBJECT_TYPE_BIOS_VF_USBBOOT_CONFIG = "biosVfUSBBootConfig"
    OBJECT_TYPE_BIOS_VF_USBCONFIGURATION = "biosVfUSBConfiguration"
    OBJECT_TYPE_BIOS_VF_USBFRONT_PANEL_ACCESS_LOCK = "biosVfUSBFrontPanelAccessLock"
    OBJECT_TYPE_BIOS_VF_USBPORT_CONFIGURATION = "biosVfUSBPortConfiguration"
    OBJECT_TYPE_BIOS_VF_USBSYSTEM_IDLE_POWER_OPTIMIZING_SETTING = "biosVfUSBSystemIdlePowerOptimizingSetting"
    OBJECT_TYPE_BIOS_VF_VGAPRIORITY = "biosVfVGAPriority"
    OBJECT_TYPE_BIOS_VF_WORKLOAD_CONFIGURATION = "biosVfWorkloadConfiguration"
    OBJECT_TYPE_CALLHOME_DEST = "callhomeDest"
    OBJECT_TYPE_CALLHOME_EP = "callhomeEp"
    OBJECT_TYPE_CALLHOME_FAULT_INST = "callhomeFaultInst"
    OBJECT_TYPE_CALLHOME_HOLDER = "callhomeHolder"
    OBJECT_TYPE_CALLHOME_HOLDER_FSM = "callhomeHolderFsm"
    OBJECT_TYPE_CALLHOME_HOLDER_FSM_STAGE = "callhomeHolderFsmStage"
    OBJECT_TYPE_CALLHOME_HOLDER_FSM_TASK = "callhomeHolderFsmTask"
    OBJECT_TYPE_CALLHOME_HTTP = "callhomeHttp"
    OBJECT_TYPE_CALLHOME_ITEM = "callhomeItem"
    OBJECT_TYPE_CALLHOME_PERIODIC_SYSTEM_INVENTORY = "callhomePeriodicSystemInventory"
    OBJECT_TYPE_CALLHOME_POLICY = "callhomePolicy"
    OBJECT_TYPE_CALLHOME_PROFILE = "callhomeProfile"
    OBJECT_TYPE_CALLHOME_SMTP = "callhomeSmtp"
    OBJECT_TYPE_CALLHOME_SOURCE = "callhomeSource"
    OBJECT_TYPE_CALLHOME_TEST_ALERT = "callhomeTestAlert"
    OBJECT_TYPE_CAPABILITY_CATALOGUE = "capabilityCatalogue"
    OBJECT_TYPE_CAPABILITY_DEF = "capabilityDef"
    OBJECT_TYPE_CAPABILITY_ITEM = "capabilityItem"
    OBJECT_TYPE_CAPABILITY_PROVIDER = "capabilityProvider"
    OBJECT_TYPE_CERT_REPAIR_EP = "certRepairEp"
    OBJECT_TYPE_CERT_REPAIR_EP_FSM = "certRepairEpFsm"
    OBJECT_TYPE_CERT_REPAIR_EP_FSM_STAGE = "certRepairEpFsmStage"
    OBJECT_TYPE_CERT_REPAIR_EP_FSM_TASK = "certRepairEpFsmTask"
    OBJECT_TYPE_CHANGE_CHANGED_OBJECT_REF = "changeChangedObjectRef"
    OBJECT_TYPE_CHANGE_EP = "changeEp"
    OBJECT_TYPE_CHANGE_EP_FSM = "changeEpFsm"
    OBJECT_TYPE_CHANGE_EP_FSM_STAGE = "changeEpFsmStage"
    OBJECT_TYPE_CHANGE_EP_FSM_TASK = "changeEpFsmTask"
    OBJECT_TYPE_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY = "cimcvmediaActualMountEntry"
    OBJECT_TYPE_CIMCVMEDIA_ACTUAL_MOUNT_LIST = "cimcvmediaActualMountList"
    OBJECT_TYPE_CIMCVMEDIA_CONFIG_MOUNT_ENTRY = "cimcvmediaConfigMountEntry"
    OBJECT_TYPE_CIMCVMEDIA_EXT_MGMT_RULE_ENTRY = "cimcvmediaExtMgmtRuleEntry"
    OBJECT_TYPE_CIMCVMEDIA_ITEM = "cimcvmediaItem"
    OBJECT_TYPE_CIMCVMEDIA_MOUNT_CONFIG = "cimcvmediaMountConfig"
    OBJECT_TYPE_CIMCVMEDIA_MOUNT_CONFIG_DEF = "cimcvmediaMountConfigDef"
    OBJECT_TYPE_CIMCVMEDIA_MOUNT_CONFIG_POLICY = "cimcvmediaMountConfigPolicy"
    OBJECT_TYPE_CIMCVMEDIA_MOUNT_INFO = "cimcvmediaMountInfo"
    OBJECT_TYPE_CLITEST_TYPE_TEST = "clitestTypeTest"
    OBJECT_TYPE_CLITEST_TYPE_TEST2 = "clitestTypeTest2"
    OBJECT_TYPE_CLITEST_TYPE_TEST_CHILD = "clitestTypeTestChild"
    OBJECT_TYPE_CLITEST_TYPE_TEST_PARENT = "clitestTypeTestParent"
    OBJECT_TYPE_COMM_CIMXML = "commCimxml"
    OBJECT_TYPE_COMM_CLIENT = "commClient"
    OBJECT_TYPE_COMM_CLIENT_ITEM = "commClientItem"
    OBJECT_TYPE_COMM_CORE_FILE = "commCoreFile"
    OBJECT_TYPE_COMM_DATE_TIME = "commDateTime"
    OBJECT_TYPE_COMM_DATE_TIME_FSM = "commDateTimeFsm"
    OBJECT_TYPE_COMM_DATE_TIME_FSM_STAGE = "commDateTimeFsmStage"
    OBJECT_TYPE_COMM_DATE_TIME_FSM_TASK = "commDateTimeFsmTask"
    OBJECT_TYPE_COMM_DEFINITION = "commDefinition"
    OBJECT_TYPE_COMM_DNS = "commDns"
    OBJECT_TYPE_COMM_DNS_PROVIDER = "commDnsProvider"
    OBJECT_TYPE_COMM_EVT_CHANNEL = "commEvtChannel"
    OBJECT_TYPE_COMM_HTTP = "commHttp"
    OBJECT_TYPE_COMM_HTTPS = "commHttps"
    OBJECT_TYPE_COMM_ITEM = "commItem"
    OBJECT_TYPE_COMM_LOCALE = "commLocale"
    OBJECT_TYPE_COMM_LOG_COMPONENT = "commLogComponent"
    OBJECT_TYPE_COMM_NTP = "commNtp"
    OBJECT_TYPE_COMM_NTP_PROVIDER = "commNtpProvider"
    OBJECT_TYPE_COMM_SHELL = "commShell"
    OBJECT_TYPE_COMM_SHELL_SVC_LIMITS = "commShellSvcLimits"
    OBJECT_TYPE_COMM_SMASH_CLP = "commSmashCLP"
    OBJECT_TYPE_COMM_SNMP = "commSnmp"
    OBJECT_TYPE_COMM_SNMP_COMMUNITY = "commSnmpCommunity"
    OBJECT_TYPE_COMM_SNMP_TRAP = "commSnmpTrap"
    OBJECT_TYPE_COMM_SNMP_TRAP_DATA = "commSnmpTrapData"
    OBJECT_TYPE_COMM_SNMP_USER = "commSnmpUser"
    OBJECT_TYPE_COMM_SSH = "commSsh"
    OBJECT_TYPE_COMM_SVC = "commSvc"
    OBJECT_TYPE_COMM_SVC_CHANNEL = "commSvcChannel"
    OBJECT_TYPE_COMM_SVC_EP = "commSvcEp"
    OBJECT_TYPE_COMM_SVC_EP_FSM = "commSvcEpFsm"
    OBJECT_TYPE_COMM_SVC_EP_FSM_STAGE = "commSvcEpFsmStage"
    OBJECT_TYPE_COMM_SVC_EP_FSM_TASK = "commSvcEpFsmTask"
    OBJECT_TYPE_COMM_SVC_LIMITS = "commSvcLimits"
    OBJECT_TYPE_COMM_SVC_POLICY = "commSvcPolicy"
    OBJECT_TYPE_COMM_SYSLOG = "commSyslog"
    OBJECT_TYPE_COMM_SYSLOG_CLIENT = "commSyslogClient"
    OBJECT_TYPE_COMM_SYSLOG_CONSOLE = "commSyslogConsole"
    OBJECT_TYPE_COMM_SYSLOG_FILE = "commSyslogFile"
    OBJECT_TYPE_COMM_SYSLOG_MONITOR = "commSyslogMonitor"
    OBJECT_TYPE_COMM_SYSLOG_SOURCE = "commSyslogSource"
    OBJECT_TYPE_COMM_TELNET = "commTelnet"
    OBJECT_TYPE_COMM_WEB = "commWeb"
    OBJECT_TYPE_COMM_WEB_CHANNEL = "commWebChannel"
    OBJECT_TYPE_COMM_WEB_SVC_LIMITS = "commWebSvcLimits"
    OBJECT_TYPE_COMM_WSMAN = "commWsman"
    OBJECT_TYPE_COMM_XML_CL_CONN_POLICY = "commXmlClConnPolicy"
    OBJECT_TYPE_COMPUTE_ABOARD = "computeABoard"
    OBJECT_TYPE_COMPUTE_ACHASSIS_DISC_POLICY = "computeAChassisDiscPolicy"
    OBJECT_TYPE_COMPUTE_AOPERATION = "computeAOperation"
    OBJECT_TYPE_COMPUTE_AUTOCONFIG_POLICY = "computeAutoconfigPolicy"
    OBJECT_TYPE_COMPUTE_BASE_SYSTEM = "computeBaseSystem"
    OBJECT_TYPE_COMPUTE_BLADE = "computeBlade"
    OBJECT_TYPE_COMPUTE_BLADE_DISC_POLICY = "computeBladeDiscPolicy"
    OBJECT_TYPE_COMPUTE_BLADE_EP = "computeBladeEp"
    OBJECT_TYPE_COMPUTE_BLADE_INHERIT_POLICY = "computeBladeInheritPolicy"
    OBJECT_TYPE_COMPUTE_BLADE_POS_QUAL = "computeBladePosQual"
    OBJECT_TYPE_COMPUTE_BOARD = "computeBoard"
    OBJECT_TYPE_COMPUTE_BOARD_CONNECTOR = "computeBoardConnector"
    OBJECT_TYPE_COMPUTE_BOARD_CONTROLLER = "computeBoardController"
    OBJECT_TYPE_COMPUTE_CARTRIDGE = "computeCartridge"
    OBJECT_TYPE_COMPUTE_CARTRIDGE_OPERATION = "computeCartridgeOperation"
    OBJECT_TYPE_COMPUTE_CHASSIS_CONN_POLICY = "computeChassisConnPolicy"
    OBJECT_TYPE_COMPUTE_CHASSIS_CONN_POLICY_OPERATION = "computeChassisConnPolicyOperation"
    OBJECT_TYPE_COMPUTE_CHASSIS_DISC_POLICY = "computeChassisDiscPolicy"
    OBJECT_TYPE_COMPUTE_CHASSIS_FEAT_MASK = "computeChassisFeatMask"
    OBJECT_TYPE_COMPUTE_CHASSIS_QUAL = "computeChassisQual"
    OBJECT_TYPE_COMPUTE_COMPUTE_DISC_POLICY = "computeComputeDiscPolicy"
    OBJECT_TYPE_COMPUTE_CONFIG_POLICY = "computeConfigPolicy"
    OBJECT_TYPE_COMPUTE_CONTAINER = "computeContainer"
    OBJECT_TYPE_COMPUTE_DEFINITION = "computeDefinition"
    OBJECT_TYPE_COMPUTE_DISC_POLICY = "computeDiscPolicy"
    OBJECT_TYPE_COMPUTE_DOMAIN_GROUP_QUAL = "computeDomainGroupQual"
    OBJECT_TYPE_COMPUTE_DOMAIN_HW_CHANGE_DISC_POLICY = "computeDomainHwChangeDiscPolicy"
    OBJECT_TYPE_COMPUTE_DOMAIN_NAME_QUAL = "computeDomainNameQual"
    OBJECT_TYPE_COMPUTE_DOMAIN_PORT_DISC_POLICY = "computeDomainPortDiscPolicy"
    OBJECT_TYPE_COMPUTE_DOMAIN_QUAL = "computeDomainQual"
    OBJECT_TYPE_COMPUTE_ENV_FEAT_MASK = "computeEnvFeatMask"
    OBJECT_TYPE_COMPUTE_EXT_BOARD = "computeExtBoard"
    OBJECT_TYPE_COMPUTE_FABRIC_ETH_MON_SRC_EP = "computeFabricEthMonSrcEp"
    OBJECT_TYPE_COMPUTE_FABRIC_ETH_MON_SRC_EP_CONT = "computeFabricEthMonSrcEpCont"
    OBJECT_TYPE_COMPUTE_FABRIC_FC_MON_SRC_EP = "computeFabricFcMonSrcEp"
    OBJECT_TYPE_COMPUTE_FABRIC_FC_MON_SRC_EP_CONT = "computeFabricFcMonSrcEpCont"
    OBJECT_TYPE_COMPUTE_FABRIC_MON_SRC_EP = "computeFabricMonSrcEp"
    OBJECT_TYPE_COMPUTE_FACTORY_RESET_OP = "computeFactoryResetOp"
    OBJECT_TYPE_COMPUTE_FACTORY_RESET_OPERATION = "computeFactoryResetOperation"
    OBJECT_TYPE_COMPUTE_FAULT_UPGRADE_FLAG = "computeFaultUpgradeFlag"
    OBJECT_TYPE_COMPUTE_FEAT_MASK = "computeFeatMask"
    OBJECT_TYPE_COMPUTE_GRAPHICS_CARD_POLICY = "computeGraphicsCardPolicy"
    OBJECT_TYPE_COMPUTE_GROUP_MEMBERSHIP = "computeGroupMembership"
    OBJECT_TYPE_COMPUTE_GROUP_MEMBERSHIP_REF = "computeGroupMembershipRef"
    OBJECT_TYPE_COMPUTE_HW_CHANGE_DISC_POLICY = "computeHwChangeDiscPolicy"
    OBJECT_TYPE_COMPUTE_IOHUB = "computeIOHub"
    OBJECT_TYPE_COMPUTE_IOHUB_ENV_STATS = "computeIOHubEnvStats"
    OBJECT_TYPE_COMPUTE_IOHUB_ENV_STATS_HIST = "computeIOHubEnvStatsHist"
    OBJECT_TYPE_COMPUTE_INIT_CONFIG_POLICY = "computeInitConfigPolicy"
    OBJECT_TYPE_COMPUTE_INSTANCE = "computeInstance"
    OBJECT_TYPE_COMPUTE_INSTANCE_ID_QUAL = "computeInstanceIdQual"
    OBJECT_TYPE_COMPUTE_INSTANCE_MAPPING = "computeInstanceMapping"
    OBJECT_TYPE_COMPUTE_ITEM = "computeItem"
    OBJECT_TYPE_COMPUTE_LOCAL_TEMPL_DEF = "computeLocalTemplDef"
    OBJECT_TYPE_COMPUTE_LOGICAL = "computeLogical"
    OBJECT_TYPE_COMPUTE_MB_POWER_STATS = "computeMbPowerStats"
    OBJECT_TYPE_COMPUTE_MB_POWER_STATS_HIST = "computeMbPowerStatsHist"
    OBJECT_TYPE_COMPUTE_MB_TEMP_STATS = "computeMbTempStats"
    OBJECT_TYPE_COMPUTE_MB_TEMP_STATS_HIST = "computeMbTempStatsHist"
    OBJECT_TYPE_COMPUTE_NETWORK_FEAT_MASK = "computeNetworkFeatMask"
    OBJECT_TYPE_COMPUTE_OWNER_QUAL = "computeOwnerQual"
    OBJECT_TYPE_COMPUTE_PCIE_FATAL_COMPLETION_STATS = "computePCIeFatalCompletionStats"
    OBJECT_TYPE_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST = "computePCIeFatalCompletionStatsHist"
    OBJECT_TYPE_COMPUTE_PCIE_FATAL_PROTOCOL_STATS = "computePCIeFatalProtocolStats"
    OBJECT_TYPE_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_HIST = "computePCIeFatalProtocolStatsHist"
    OBJECT_TYPE_COMPUTE_PCIE_FATAL_RECEIVE_STATS = "computePCIeFatalReceiveStats"
    OBJECT_TYPE_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST = "computePCIeFatalReceiveStatsHist"
    OBJECT_TYPE_COMPUTE_PCIE_FATAL_STATS = "computePCIeFatalStats"
    OBJECT_TYPE_COMPUTE_PCIE_FATAL_STATS_HIST = "computePCIeFatalStatsHist"
    OBJECT_TYPE_COMPUTE_PHYSICAL = "computePhysical"
    OBJECT_TYPE_COMPUTE_PHYSICAL_ASSOC_CTX = "computePhysicalAssocCtx"
    OBJECT_TYPE_COMPUTE_PHYSICAL_EXTENSION = "computePhysicalExtension"
    OBJECT_TYPE_COMPUTE_PHYSICAL_OPERATION = "computePhysicalOperation"
    OBJECT_TYPE_COMPUTE_PHYSICAL_QUAL = "computePhysicalQual"
    OBJECT_TYPE_COMPUTE_PLACEABLE = "computePlaceable"
    OBJECT_TYPE_COMPUTE_PLACED = "computePlaced"
    OBJECT_TYPE_COMPUTE_POOL = "computePool"
    OBJECT_TYPE_COMPUTE_POOL_POLICY_REF = "computePoolPolicyRef"
    OBJECT_TYPE_COMPUTE_POOLABLE = "computePoolable"
    OBJECT_TYPE_COMPUTE_POOLED = "computePooled"
    OBJECT_TYPE_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT = "computePooledEnclosureComputeSlot"
    OBJECT_TYPE_COMPUTE_POOLED_PHYSICAL = "computePooledPhysical"
    OBJECT_TYPE_COMPUTE_POOLED_RACK_UNIT = "computePooledRackUnit"
    OBJECT_TYPE_COMPUTE_POOLED_SLOT = "computePooledSlot"
    OBJECT_TYPE_COMPUTE_POOLING_POLICY = "computePoolingPolicy"
    OBJECT_TYPE_COMPUTE_PORT_DISC_POLICY = "computePortDiscPolicy"
    OBJECT_TYPE_COMPUTE_POWER_SYNC_DEF = "computePowerSyncDef"
    OBJECT_TYPE_COMPUTE_POWER_SYNC_POLICY = "computePowerSyncPolicy"
    OBJECT_TYPE_COMPUTE_PRODUCT_FAMILY_QUAL = "computeProductFamilyQual"
    OBJECT_TYPE_COMPUTE_PROFILE = "computeProfile"
    OBJECT_TYPE_COMPUTE_PSU_DEF = "computePsuDef"
    OBJECT_TYPE_COMPUTE_PSU_POLICY = "computePsuPolicy"
    OBJECT_TYPE_COMPUTE_QUAL = "computeQual"
    OBJECT_TYPE_COMPUTE_QUAL_BASE = "computeQualBase"
    OBJECT_TYPE_COMPUTE_QUAL_ITEM = "computeQualItem"
    OBJECT_TYPE_COMPUTE_QUALIFIED_POLICY = "computeQualifiedPolicy"
    OBJECT_TYPE_COMPUTE_RACK_POS_QUAL = "computeRackPosQual"
    OBJECT_TYPE_COMPUTE_RACK_QUAL = "computeRackQual"
    OBJECT_TYPE_COMPUTE_RACK_UNIT = "computeRackUnit"
    OBJECT_TYPE_COMPUTE_RACK_UNIT_MB_TEMP_STATS = "computeRackUnitMbTempStats"
    OBJECT_TYPE_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST = "computeRackUnitMbTempStatsHist"
    OBJECT_TYPE_COMPUTE_REBOOT_LOG = "computeRebootLog"
    OBJECT_TYPE_COMPUTE_REMOTE_OP_STATUS = "computeRemoteOpStatus"
    OBJECT_TYPE_COMPUTE_REQUIREMENT = "computeRequirement"
    OBJECT_TYPE_COMPUTE_RESOURCE_AGGR_EP = "computeResourceAggrEp"
    OBJECT_TYPE_COMPUTE_RESOURCE_SET = "computeResourceSet"
    OBJECT_TYPE_COMPUTE_RESOURCE_SET_MANAGER = "computeResourceSetManager"
    OBJECT_TYPE_COMPUTE_RESOURCE_SET_MEMBER = "computeResourceSetMember"
    OBJECT_TYPE_COMPUTE_SCRUB_POLICY = "computeScrubPolicy"
    OBJECT_TYPE_COMPUTE_SERVER = "computeServer"
    OBJECT_TYPE_COMPUTE_SERVER_DISC_POLICY = "computeServerDiscPolicy"
    OBJECT_TYPE_COMPUTE_SERVER_FEAT_MASK = "computeServerFeatMask"
    OBJECT_TYPE_COMPUTE_SERVER_MGMT_POLICY = "computeServerMgmtPolicy"
    OBJECT_TYPE_COMPUTE_SERVER_UNIT = "computeServerUnit"
    OBJECT_TYPE_COMPUTE_SESSION = "computeSession"
    OBJECT_TYPE_COMPUTE_SITE_QUAL = "computeSiteQual"
    OBJECT_TYPE_COMPUTE_SLOT_ENTITY = "computeSlotEntity"
    OBJECT_TYPE_COMPUTE_SLOT_QUAL = "computeSlotQual"
    OBJECT_TYPE_COMPUTE_STORAGE_FEAT_MASK = "computeStorageFeatMask"
    OBJECT_TYPE_COMPUTE_SYSTEM = "computeSystem"
    OBJECT_TYPE_COMPUTE_SYSTEM_ADDR_QUAL = "computeSystemAddrQual"
    OBJECT_TYPE_COMPUTE_SYSTEM_FSM = "computeSystemFsm"
    OBJECT_TYPE_COMPUTE_SYSTEM_FSM_STAGE = "computeSystemFsmStage"
    OBJECT_TYPE_COMPUTE_SYSTEM_FSM_TASK = "computeSystemFsmTask"
    OBJECT_TYPE_COMPUTE_SYSTEM_QUAL = "computeSystemQual"
    OBJECT_TYPE_COMPUTE_TEMPLATE = "computeTemplate"
    OBJECT_TYPE_COMPUTE_TEMPLATE_MAPPING = "computeTemplateMapping"
    OBJECT_TYPE_COMPUTE_USER = "computeUser"
    OBJECT_TYPE_COMPUTE_USER_EP = "computeUserEp"
    OBJECT_TYPE_CONDITION_IMMUTABLE = "conditionImmutable"
    OBJECT_TYPE_CONDITION_INFO = "conditionInfo"
    OBJECT_TYPE_CONDITION_LOG = "conditionLog"
    OBJECT_TYPE_CONDITION_LOGGABLE = "conditionLoggable"
    OBJECT_TYPE_CONDITION_MULTI_INSTANCE_IMMUTABLE = "conditionMultiInstanceImmutable"
    OBJECT_TYPE_CONDITION_MUTABLE = "conditionMutable"
    OBJECT_TYPE_CONDITION_POLICY = "conditionPolicy"
    OBJECT_TYPE_CONDITION_REPORTABLE = "conditionReportable"
    OBJECT_TYPE_CONFIG_ABS_DB_CONFIG = "configAbsDbConfig"
    OBJECT_TYPE_CONFIG_ACK_ITEM = "configAckItem"
    OBJECT_TYPE_CONFIG_ADAPTOR_ITEM = "configAdaptorItem"
    OBJECT_TYPE_CONFIG_APP_IMPACT_RESPONSE = "configAppImpactResponse"
    OBJECT_TYPE_CONFIG_BACKUP = "configBackup"
    OBJECT_TYPE_CONFIG_BACKUP_FSM = "configBackupFsm"
    OBJECT_TYPE_CONFIG_BACKUP_FSM_STAGE = "configBackupFsmStage"
    OBJECT_TYPE_CONFIG_BACKUP_FSM_TASK = "configBackupFsmTask"
    OBJECT_TYPE_CONFIG_CARTRIDGE_FILTER = "configCartridgeFilter"
    OBJECT_TYPE_CONFIG_CARTRIDGE_ITEM = "configCartridgeItem"
    OBJECT_TYPE_CONFIG_CATALOGUE = "configCatalogue"
    OBJECT_TYPE_CONFIG_CHASSIS_FILTER = "configChassisFilter"
    OBJECT_TYPE_CONFIG_CHASSIS_ITEM = "configChassisItem"
    OBJECT_TYPE_CONFIG_COMPONENTS_FILTER = "configComponentsFilter"
    OBJECT_TYPE_CONFIG_CONSUMER_CATALOGUE = "configConsumerCatalogue"
    OBJECT_TYPE_CONFIG_CONSUMER_CATALOGUE_FSM = "configConsumerCatalogueFsm"
    OBJECT_TYPE_CONFIG_CONSUMER_CATALOGUE_FSM_STAGE = "configConsumerCatalogueFsmStage"
    OBJECT_TYPE_CONFIG_CONSUMER_CATALOGUE_FSM_TASK = "configConsumerCatalogueFsmTask"
    OBJECT_TYPE_CONFIG_CONTROLLER_ITEM = "configControllerItem"
    OBJECT_TYPE_CONFIG_CPU_INFO = "configCpuInfo"
    OBJECT_TYPE_CONFIG_CPU_ITEM = "configCpuItem"
    OBJECT_TYPE_CONFIG_CRYPTO_CARD_ITEM = "configCryptoCardItem"
    OBJECT_TYPE_CONFIG_DB_CONFIG = "configDbConfig"
    OBJECT_TYPE_CONFIG_DOMAIN_FILTER = "configDomainFilter"
    OBJECT_TYPE_CONFIG_DOMAIN_ITEM = "configDomainItem"
    OBJECT_TYPE_CONFIG_FABRIC_INTERCONNECT_FILTER = "configFabricInterconnectFilter"
    OBJECT_TYPE_CONFIG_FABRIC_INTERCONNECT_ITEM = "configFabricInterconnectItem"
    OBJECT_TYPE_CONFIG_FAN_ITEM = "configFanItem"
    OBJECT_TYPE_CONFIG_FEX_FILTER = "configFexFilter"
    OBJECT_TYPE_CONFIG_FEX_ITEM = "configFexItem"
    OBJECT_TYPE_CONFIG_FILTER_GROUP = "configFilterGroup"
    OBJECT_TYPE_CONFIG_FILTER_ITEM = "configFilterItem"
    OBJECT_TYPE_CONFIG_FSM = "configFsm"
    OBJECT_TYPE_CONFIG_FSM_STAGE = "configFsmStage"
    OBJECT_TYPE_CONFIG_GRAPHICS_CARD_ITEM = "configGraphicsCardItem"
    OBJECT_TYPE_CONFIG_IOMITEM = "configIOMItem"
    OBJECT_TYPE_CONFIG_IMPACT = "configImpact"
    OBJECT_TYPE_CONFIG_IMPACT_ANALYZER = "configImpactAnalyzer"
    OBJECT_TYPE_CONFIG_IMPACT_ANALYZER_EP = "configImpactAnalyzerEp"
    OBJECT_TYPE_CONFIG_IMPACT_RESPONSE = "configImpactResponse"
    OBJECT_TYPE_CONFIG_INPUT_CONFIG = "configInputConfig"
    OBJECT_TYPE_CONFIG_INPUT_CONFIG_SET = "configInputConfigSet"
    OBJECT_TYPE_CONFIG_LOCAL_DISK_ITEM = "configLocalDiskItem"
    OBJECT_TYPE_CONFIG_LUN_ITEM = "configLunItem"
    OBJECT_TYPE_CONFIG_MANAGED_EP_IMPACT_RESPONSE = "configManagedEpImpactResponse"
    OBJECT_TYPE_CONFIG_MEMORY_ITEM = "configMemoryItem"
    OBJECT_TYPE_CONFIG_MOTHERBOARD_ITEM = "configMotherboardItem"
    OBJECT_TYPE_CONFIG_NET_REF_ITEM = "configNetRefItem"
    OBJECT_TYPE_CONFIG_ORG_ITEM = "configOrgItem"
    OBJECT_TYPE_CONFIG_PSUITEM = "configPSUItem"
    OBJECT_TYPE_CONFIG_POLICY_USAGE_ITEM = "configPolicyUsageItem"
    OBJECT_TYPE_CONFIG_PORT_ITEM = "configPortItem"
    OBJECT_TYPE_CONFIG_SEARCH_OPTIONS = "configSearchOptions"
    OBJECT_TYPE_CONFIG_SEARCH_RESULT = "configSearchResult"
    OBJECT_TYPE_CONFIG_SERVER_FILTER = "configServerFilter"
    OBJECT_TYPE_CONFIG_SERVER_ITEM = "configServerItem"
    OBJECT_TYPE_CONFIG_SERVICE_PROFILE_FILTER = "configServiceProfileFilter"
    OBJECT_TYPE_CONFIG_SORTER = "configSorter"
    OBJECT_TYPE_CONFIG_SPOT_LIGHT_ITEM = "configSpotLightItem"
    OBJECT_TYPE_CONFIG_STORAGE_ARRAY_PROFILE_FILTER = "configStorageArrayProfileFilter"
    OBJECT_TYPE_CONFIG_STORAGE_BLADE_FILTER = "configStorageBladeFilter"
    OBJECT_TYPE_CONFIG_STORAGE_ITEM = "configStorageItem"
    OBJECT_TYPE_CONFIG_UCIMPACT = "configUCImpact"
    OBJECT_TYPE_CONSUMER_INST = "consumerInst"
    OBJECT_TYPE_CONSUMER_INST_FSM = "consumerInstFsm"
    OBJECT_TYPE_CONSUMER_INST_FSM_STAGE = "consumerInstFsmStage"
    OBJECT_TYPE_CONSUMER_INST_FSM_TASK = "consumerInstFsmTask"
    OBJECT_TYPE_CONSUMER_UNIVERSE = "consumerUniverse"
    OBJECT_TYPE_CONTROLLER_EP = "controllerEp"
    OBJECT_TYPE_CONTROLLER_EP_FSM = "controllerEpFsm"
    OBJECT_TYPE_CONTROLLER_EP_FSM_STAGE = "controllerEpFsmStage"
    OBJECT_TYPE_CONTROLLER_EP_FSM_TASK = "controllerEpFsmTask"
    OBJECT_TYPE_CPMAINT_ACK = "cpmaintAck"
    OBJECT_TYPE_CPMAINT_MAINT_POLICY = "cpmaintMaintPolicy"
    OBJECT_TYPE_DCX_VIF = "dcxVIf"
    OBJECT_TYPE_DCX_VC = "dcxVc"
    OBJECT_TYPE_DIAG_CTRL = "diagCtrl"
    OBJECT_TYPE_DIAG_LOG_EP = "diagLogEp"
    OBJECT_TYPE_DIAG_MEMORY_TEST = "diagMemoryTest"
    OBJECT_TYPE_DIAG_RSLT = "diagRslt"
    OBJECT_TYPE_DIAG_RUN_POLICY = "diagRunPolicy"
    OBJECT_TYPE_DIAG_SRV_CAP_PROVIDER = "diagSrvCapProvider"
    OBJECT_TYPE_DIAG_SRV_CTRL = "diagSrvCtrl"
    OBJECT_TYPE_DIAG_SRV_CTRL_OPERATION = "diagSrvCtrlOperation"
    OBJECT_TYPE_DIAG_SRV_CTRL_OPERATION_FSM = "diagSrvCtrlOperationFsm"
    OBJECT_TYPE_DIAG_SRV_CTRL_OPERATION_FSM_STAGE = "diagSrvCtrlOperationFsmStage"
    OBJECT_TYPE_DIAG_SRV_CTRL_OPERATION_FSM_TASK = "diagSrvCtrlOperationFsmTask"
    OBJECT_TYPE_DIAG_TEST = "diagTest"
    OBJECT_TYPE_DOMAIN_CHASSIS_FEATURE = "domainChassisFeature"
    OBJECT_TYPE_DOMAIN_CHASSIS_PARAM = "domainChassisParam"
    OBJECT_TYPE_DOMAIN_CHASSIS_PROFILE_ITEM = "domainChassisProfileItem"
    OBJECT_TYPE_DOMAIN_ENVIRONMENT_FEATURE = "domainEnvironmentFeature"
    OBJECT_TYPE_DOMAIN_ENVIRONMENT_PARAM = "domainEnvironmentParam"
    OBJECT_TYPE_DOMAIN_EP = "domainEp"
    OBJECT_TYPE_DOMAIN_FAMILY_CAP_PROVIDER = "domainFamilyCapProvider"
    OBJECT_TYPE_DOMAIN_FEATURE = "domainFeature"
    OBJECT_TYPE_DOMAIN_FEATURE_CATALOG = "domainFeatureCatalog"
    OBJECT_TYPE_DOMAIN_NETWORK_FEATURE = "domainNetworkFeature"
    OBJECT_TYPE_DOMAIN_NETWORK_PARAM = "domainNetworkParam"
    OBJECT_TYPE_DOMAIN_PARAMETER = "domainParameter"
    OBJECT_TYPE_DOMAIN_PROFILE = "domainProfile"
    OBJECT_TYPE_DOMAIN_PROFILE_FSM = "domainProfileFsm"
    OBJECT_TYPE_DOMAIN_PROFILE_FSM_STAGE = "domainProfileFsmStage"
    OBJECT_TYPE_DOMAIN_PROFILE_FSM_TASK = "domainProfileFsmTask"
    OBJECT_TYPE_DOMAIN_SERVER_FEATURE = "domainServerFeature"
    OBJECT_TYPE_DOMAIN_SERVER_PARAM = "domainServerParam"
    OBJECT_TYPE_DOMAIN_SERVICE_PROFILE_ITEM = "domainServiceProfileItem"
    OBJECT_TYPE_DOMAIN_STORAGE_FEATURE = "domainStorageFeature"
    OBJECT_TYPE_DOMAIN_STORAGE_PARAM = "domainStorageParam"
    OBJECT_TYPE_DPSEC_MAC = "dpsecMac"
    OBJECT_TYPE_DUPE_CHANGE_TRACKER = "dupeChangeTracker"
    OBJECT_TYPE_DUPE_CHANGE_TRACKER_EP = "dupeChangeTrackerEp"
    OBJECT_TYPE_DUPE_CHANGE_TRACKER_EP_FSM = "dupeChangeTrackerEpFsm"
    OBJECT_TYPE_DUPE_CHANGE_TRACKER_EP_FSM_STAGE = "dupeChangeTrackerEpFsmStage"
    OBJECT_TYPE_DUPE_CHANGE_TRACKER_EP_FSM_TASK = "dupeChangeTrackerEpFsmTask"
    OBJECT_TYPE_DUPE_EP = "dupeEp"
    OBJECT_TYPE_DUPE_EXT_REQUESTOR = "dupeExtRequestor"
    OBJECT_TYPE_DUPE_INT_REQUESTOR = "dupeIntRequestor"
    OBJECT_TYPE_DUPE_REQUESTOR = "dupeRequestor"
    OBJECT_TYPE_DUPE_SCOPE = "dupeScope"
    OBJECT_TYPE_DUPE_SCOPE_EP = "dupeScopeEp"
    OBJECT_TYPE_DUPE_SCOPE_RESULT = "dupeScopeResult"
    OBJECT_TYPE_EPQOS_DEFINITION = "epqosDefinition"
    OBJECT_TYPE_EPQOS_EGRESS = "epqosEgress"
    OBJECT_TYPE_EPQOS_ITEM = "epqosItem"
    OBJECT_TYPE_EQUIPMENT_ABEH_CAP = "equipmentABehCap"
    OBJECT_TYPE_EQUIPMENT_ADVANCED_BOOT_ORDER = "equipmentAdvancedBootOrder"
    OBJECT_TYPE_EQUIPMENT_ASSOC_CTX = "equipmentAssocCtx"
    OBJECT_TYPE_EQUIPMENT_BEACON_LED = "equipmentBeaconLed"
    OBJECT_TYPE_EQUIPMENT_BEH_CAP = "equipmentBehCap"
    OBJECT_TYPE_EQUIPMENT_BINDING = "equipmentBinding"
    OBJECT_TYPE_EQUIPMENT_BLADE_CAP_PROVIDER = "equipmentBladeCapProvider"
    OBJECT_TYPE_EQUIPMENT_BREAKOUT_CAP = "equipmentBreakoutCap"
    OBJECT_TYPE_EQUIPMENT_CPMETA = "equipmentCPMeta"
    OBJECT_TYPE_EQUIPMENT_CARD = "equipmentCard"
    OBJECT_TYPE_EQUIPMENT_CARTRIDGE_CAP_PROVIDER = "equipmentCartridgeCapProvider"
    OBJECT_TYPE_EQUIPMENT_CHASSIS = "equipmentChassis"
    OBJECT_TYPE_EQUIPMENT_CHASSIS_ASSOC_CTX = "equipmentChassisAssocCtx"
    OBJECT_TYPE_EQUIPMENT_CHASSIS_CAP_PROVIDER = "equipmentChassisCapProvider"
    OBJECT_TYPE_EQUIPMENT_CHASSIS_ISSUES = "equipmentChassisIssues"
    OBJECT_TYPE_EQUIPMENT_CHASSIS_OPERATION = "equipmentChassisOperation"
    OBJECT_TYPE_EQUIPMENT_CHASSIS_POS_QUAL = "equipmentChassisPosQual"
    OBJECT_TYPE_EQUIPMENT_CHASSIS_PROFILE = "equipmentChassisProfile"
    OBJECT_TYPE_EQUIPMENT_CHASSIS_PROFILE_ASSOC_CTX = "equipmentChassisProfileAssocCtx"
    OBJECT_TYPE_EQUIPMENT_CHASSIS_PROFILE_BINDING = "equipmentChassisProfileBinding"
    OBJECT_TYPE_EQUIPMENT_CHASSIS_PROFILE_FSM = "equipmentChassisProfileFsm"
    OBJECT_TYPE_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE = "equipmentChassisProfileFsmStage"
    OBJECT_TYPE_EQUIPMENT_CHASSIS_PROFILE_FSM_TASK = "equipmentChassisProfileFsmTask"
    OBJECT_TYPE_EQUIPMENT_CHASSIS_QUAL = "equipmentChassisQual"
    OBJECT_TYPE_EQUIPMENT_CHASSIS_REQUIREMENT = "equipmentChassisRequirement"
    OBJECT_TYPE_EQUIPMENT_CHASSIS_STATS = "equipmentChassisStats"
    OBJECT_TYPE_EQUIPMENT_CHASSIS_STATS_HIST = "equipmentChassisStatsHist"
    OBJECT_TYPE_EQUIPMENT_CIMC_VMEDIA = "equipmentCimcVmedia"
    OBJECT_TYPE_EQUIPMENT_COMPUTE_CONN = "equipmentComputeConn"
    OBJECT_TYPE_EQUIPMENT_COMPUTE_CONN_POLICY = "equipmentComputeConnPolicy"
    OBJECT_TYPE_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER = "equipmentComputePhysicalCapProvider"
    OBJECT_TYPE_EQUIPMENT_DEFINITION = "equipmentDefinition"
    OBJECT_TYPE_EQUIPMENT_DRIVE_SEC_CAP = "equipmentDriveSecCap"
    OBJECT_TYPE_EQUIPMENT_FAN = "equipmentFan"
    OBJECT_TYPE_EQUIPMENT_FAN_MODULE = "equipmentFanModule"
    OBJECT_TYPE_EQUIPMENT_FAN_MODULE_CAP_PROVIDER = "equipmentFanModuleCapProvider"
    OBJECT_TYPE_EQUIPMENT_FAN_MODULE_STATS = "equipmentFanModuleStats"
    OBJECT_TYPE_EQUIPMENT_FAN_MODULE_STATS_HIST = "equipmentFanModuleStatsHist"
    OBJECT_TYPE_EQUIPMENT_FAN_STATS = "equipmentFanStats"
    OBJECT_TYPE_EQUIPMENT_FAN_STATS_HIST = "equipmentFanStatsHist"
    OBJECT_TYPE_EQUIPMENT_FEX = "equipmentFex"
    OBJECT_TYPE_EQUIPMENT_FEX_CAP_PROVIDER = "equipmentFexCapProvider"
    OBJECT_TYPE_EQUIPMENT_FEX_ENV_STATS = "equipmentFexEnvStats"
    OBJECT_TYPE_EQUIPMENT_FEX_ENV_STATS_HIST = "equipmentFexEnvStatsHist"
    OBJECT_TYPE_EQUIPMENT_FEX_OPERATION = "equipmentFexOperation"
    OBJECT_TYPE_EQUIPMENT_FEX_POWER_SUMMARY = "equipmentFexPowerSummary"
    OBJECT_TYPE_EQUIPMENT_FEX_POWER_SUMMARY_HIST = "equipmentFexPowerSummaryHist"
    OBJECT_TYPE_EQUIPMENT_FEX_PSU_INPUT_STATS = "equipmentFexPsuInputStats"
    OBJECT_TYPE_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST = "equipmentFexPsuInputStatsHist"
    OBJECT_TYPE_EQUIPMENT_FRU_CAP_PROVIDER = "equipmentFruCapProvider"
    OBJECT_TYPE_EQUIPMENT_FRU_VARIANT = "equipmentFruVariant"
    OBJECT_TYPE_EQUIPMENT_GEM_CAP_PROVIDER = "equipmentGemCapProvider"
    OBJECT_TYPE_EQUIPMENT_HEALTH_LED = "equipmentHealthLed"
    OBJECT_TYPE_EQUIPMENT_HOLDER = "equipmentHolder"
    OBJECT_TYPE_EQUIPMENT_HOLDER_CAP_PROVIDER = "equipmentHolderCapProvider"
    OBJECT_TYPE_EQUIPMENT_HOST_IF_CAP_PROVIDER = "equipmentHostIfCapProvider"
    OBJECT_TYPE_EQUIPMENT_HW_CAP_PROVIDER = "equipmentHwCapProvider"
    OBJECT_TYPE_EQUIPMENT_IOCARD = "equipmentIOCard"
    OBJECT_TYPE_EQUIPMENT_IOCARD_BASE = "equipmentIOCardBase"
    OBJECT_TYPE_EQUIPMENT_IOCARD_CAP_PROVIDER = "equipmentIOCardCapProvider"
    OBJECT_TYPE_EQUIPMENT_IOCARD_STATS = "equipmentIOCardStats"
    OBJECT_TYPE_EQUIPMENT_IOCARD_STATS_HIST = "equipmentIOCardStatsHist"
    OBJECT_TYPE_EQUIPMENT_IMPLIED_STORAGE_ENCLOSURE_DEF = "equipmentImpliedStorageEnclosureDef"
    OBJECT_TYPE_EQUIPMENT_INDICATOR_LED = "equipmentIndicatorLed"
    OBJECT_TYPE_EQUIPMENT_INSTANCE = "equipmentInstance"
    OBJECT_TYPE_EQUIPMENT_INSTANCE_MAPPING = "equipmentInstanceMapping"
    OBJECT_TYPE_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER = "equipmentIntegratedComponentCapProvider"
    OBJECT_TYPE_EQUIPMENT_ITEM = "equipmentItem"
    OBJECT_TYPE_EQUIPMENT_LED = "equipmentLed"
    OBJECT_TYPE_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER = "equipmentLocalDiskCapProvider"
    OBJECT_TYPE_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER = "equipmentLocalDiskControllerCapProvider"
    OBJECT_TYPE_EQUIPMENT_LOCAL_DISK_DEF = "equipmentLocalDiskDef"
    OBJECT_TYPE_EQUIPMENT_LOCAL_TEMPL_DEF = "equipmentLocalTemplDef"
    OBJECT_TYPE_EQUIPMENT_LOCATOR_LED = "equipmentLocatorLed"
    OBJECT_TYPE_EQUIPMENT_LOCATOR_LED_OPERATION = "equipmentLocatorLedOperation"
    OBJECT_TYPE_EQUIPMENT_MANUFACTURING_DEF = "equipmentManufacturingDef"
    OBJECT_TYPE_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER = "equipmentMemoryUnitCapProvider"
    OBJECT_TYPE_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS = "equipmentNetworkElementFanStats"
    OBJECT_TYPE_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST = "equipmentNetworkElementFanStatsHist"
    OBJECT_TYPE_EQUIPMENT_PCI_DEF = "equipmentPciDef"
    OBJECT_TYPE_EQUIPMENT_PHYSICAL_QUAL = "equipmentPhysicalQual"
    OBJECT_TYPE_EQUIPMENT_PICTURE = "equipmentPicture"
    OBJECT_TYPE_EQUIPMENT_PLACEABLE = "equipmentPlaceable"
    OBJECT_TYPE_EQUIPMENT_PLACED = "equipmentPlaced"
    OBJECT_TYPE_EQUIPMENT_POOL = "equipmentPool"
    OBJECT_TYPE_EQUIPMENT_POOLABLE = "equipmentPoolable"
    OBJECT_TYPE_EQUIPMENT_POOLED = "equipmentPooled"
    OBJECT_TYPE_EQUIPMENT_POOLING_POLICY = "equipmentPoolingPolicy"
    OBJECT_TYPE_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER = "equipmentProcessorUnitCapProvider"
    OBJECT_TYPE_EQUIPMENT_PSU = "equipmentPsu"
    OBJECT_TYPE_EQUIPMENT_PSU_CAP_PROVIDER = "equipmentPsuCapProvider"
    OBJECT_TYPE_EQUIPMENT_PSU_INPUT_STATS = "equipmentPsuInputStats"
    OBJECT_TYPE_EQUIPMENT_PSU_INPUT_STATS_HIST = "equipmentPsuInputStatsHist"
    OBJECT_TYPE_EQUIPMENT_PSU_OUTPUT_STATS = "equipmentPsuOutputStats"
    OBJECT_TYPE_EQUIPMENT_PSU_OUTPUT_STATS_HIST = "equipmentPsuOutputStatsHist"
    OBJECT_TYPE_EQUIPMENT_PSU_STATS = "equipmentPsuStats"
    OBJECT_TYPE_EQUIPMENT_PSU_STATS_HIST = "equipmentPsuStatsHist"
    OBJECT_TYPE_EQUIPMENT_QUAL = "equipmentQual"
    OBJECT_TYPE_EQUIPMENT_QUAL_BASE = "equipmentQualBase"
    OBJECT_TYPE_EQUIPMENT_QUAL_ITEM = "equipmentQualItem"
    OBJECT_TYPE_EQUIPMENT_QUALIFIED_POLICY = "equipmentQualifiedPolicy"
    OBJECT_TYPE_EQUIPMENT_RACK_UNIT_CAP_PROVIDER = "equipmentRackUnitCapProvider"
    OBJECT_TYPE_EQUIPMENT_RACK_UNIT_FAN_STATS = "equipmentRackUnitFanStats"
    OBJECT_TYPE_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST = "equipmentRackUnitFanStatsHist"
    OBJECT_TYPE_EQUIPMENT_RACK_UNIT_PSU_STATS = "equipmentRackUnitPsuStats"
    OBJECT_TYPE_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST = "equipmentRackUnitPsuStatsHist"
    OBJECT_TYPE_EQUIPMENT_REQUIREMENT = "equipmentRequirement"
    OBJECT_TYPE_EQUIPMENT_SECURE_BOOT = "equipmentSecureBoot"
    OBJECT_TYPE_EQUIPMENT_SERVER_FEATURE_CAP = "equipmentServerFeatureCap"
    OBJECT_TYPE_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER = "equipmentServerUnitCapProvider"
    OBJECT_TYPE_EQUIPMENT_SHARED_IOMODULE = "equipmentSharedIOModule"
    OBJECT_TYPE_EQUIPMENT_SIOC_TEMP_STATS = "equipmentSiocTempStats"
    OBJECT_TYPE_EQUIPMENT_SIOC_TEMP_STATS_HIST = "equipmentSiocTempStatsHist"
    OBJECT_TYPE_EQUIPMENT_SLOT_ENCLOSURE = "equipmentSlotEnclosure"
    OBJECT_TYPE_EQUIPMENT_STATEFUL = "equipmentStateful"
    OBJECT_TYPE_EQUIPMENT_STATEFUL_BLADE_COMP = "equipmentStatefulBladeComp"
    OBJECT_TYPE_EQUIPMENT_STATEFUL_CH_COMP = "equipmentStatefulChComp"
    OBJECT_TYPE_EQUIPMENT_STORAGE_PROCESSOR_CAP = "equipmentStorageProcessorCap"
    OBJECT_TYPE_EQUIPMENT_SWITCH_CAP_PROVIDER = "equipmentSwitchCapProvider"
    OBJECT_TYPE_EQUIPMENT_SWITCH_CARD = "equipmentSwitchCard"
    OBJECT_TYPE_EQUIPMENT_SWITCH_IOCARD = "equipmentSwitchIOCard"
    OBJECT_TYPE_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER = "equipmentSwitchIOCardCapProvider"
    OBJECT_TYPE_EQUIPMENT_SYSTEM_FRU_CAP_PROVIDER = "equipmentSystemFruCapProvider"
    OBJECT_TYPE_EQUIPMENT_SYSTEM_IOCONTROLLER = "equipmentSystemIOController"
    OBJECT_TYPE_EQUIPMENT_SYSTEM_IOCONTROLLER_OPERATION = "equipmentSystemIOControllerOperation"
    OBJECT_TYPE_EQUIPMENT_TEMPLATE = "equipmentTemplate"
    OBJECT_TYPE_EQUIPMENT_TEMPLATE_MAPPING = "equipmentTemplateMapping"
    OBJECT_TYPE_EQUIPMENT_TIER = "equipmentTier"
    OBJECT_TYPE_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER = "equipmentUnifiedPortCapProvider"
    OBJECT_TYPE_EQUIPMENT_XCVR = "equipmentXcvr"
    OBJECT_TYPE_ETHER_ERR_STATS = "etherErrStats"
    OBJECT_TYPE_ETHER_ERR_STATS_HIST = "etherErrStatsHist"
    OBJECT_TYPE_ETHER_FCOE_INTERFACE_STATS = "etherFcoeInterfaceStats"
    OBJECT_TYPE_ETHER_FCOE_INTERFACE_STATS_HIST = "etherFcoeInterfaceStatsHist"
    OBJECT_TYPE_ETHER_LOSS_STATS = "etherLossStats"
    OBJECT_TYPE_ETHER_LOSS_STATS_HIST = "etherLossStatsHist"
    OBJECT_TYPE_ETHER_PIO = "etherPIo"
    OBJECT_TYPE_ETHER_PAUSE_STATS = "etherPauseStats"
    OBJECT_TYPE_ETHER_PAUSE_STATS_HIST = "etherPauseStatsHist"
    OBJECT_TYPE_ETHER_RX_STATS = "etherRxStats"
    OBJECT_TYPE_ETHER_RX_STATS_HIST = "etherRxStatsHist"
    OBJECT_TYPE_ETHER_SERVER_INT_FIO = "etherServerIntFIo"
    OBJECT_TYPE_ETHER_SWITCH_INT_FIO = "etherSwitchIntFIo"
    OBJECT_TYPE_ETHER_TX_STATS = "etherTxStats"
    OBJECT_TYPE_ETHER_TX_STATS_HIST = "etherTxStatsHist"
    OBJECT_TYPE_EVENT_APPLICATION = "eventApplication"
    OBJECT_TYPE_EVENT_EP_CTRL = "eventEpCtrl"
    OBJECT_TYPE_EVENT_HOLDER = "eventHolder"
    OBJECT_TYPE_EVENT_INST = "eventInst"
    OBJECT_TYPE_EVENT_LOG = "eventLog"
    OBJECT_TYPE_EVENT_POLICY = "eventPolicy"
    OBJECT_TYPE_EVENT_RECORD = "eventRecord"
    OBJECT_TYPE_EXTMGMT_ARP_TARGETS = "extmgmtArpTargets"
    OBJECT_TYPE_EXTMGMT_GATEWAY_PING = "extmgmtGatewayPing"
    OBJECT_TYPE_EXTMGMT_IF_MON_POLICY = "extmgmtIfMonPolicy"
    OBJECT_TYPE_EXTMGMT_MII_STATUS = "extmgmtMiiStatus"
    OBJECT_TYPE_EXTMGMT_NDISC_TARGETS = "extmgmtNdiscTargets"
    OBJECT_TYPE_EXTPOL_CLIENT = "extpolClient"
    OBJECT_TYPE_EXTPOL_CLIENT_CONT = "extpolClientCont"
    OBJECT_TYPE_EXTPOL_CLIENT_FSM = "extpolClientFsm"
    OBJECT_TYPE_EXTPOL_CLIENT_FSM_STAGE = "extpolClientFsmStage"
    OBJECT_TYPE_EXTPOL_CLIENT_FSM_TASK = "extpolClientFsmTask"
    OBJECT_TYPE_EXTPOL_CONNECTOR = "extpolConnector"
    OBJECT_TYPE_EXTPOL_CONNECTOR_CONTAINER = "extpolConnectorContainer"
    OBJECT_TYPE_EXTPOL_CONTROLLER = "extpolController"
    OBJECT_TYPE_EXTPOL_CONTROLLER_CONT = "extpolControllerCont"
    OBJECT_TYPE_EXTPOL_DOMAIN = "extpolDomain"
    OBJECT_TYPE_EXTPOL_EP = "extpolEp"
    OBJECT_TYPE_EXTPOL_EP_FSM = "extpolEpFsm"
    OBJECT_TYPE_EXTPOL_EP_FSM_STAGE = "extpolEpFsmStage"
    OBJECT_TYPE_EXTPOL_EP_FSM_TASK = "extpolEpFsmTask"
    OBJECT_TYPE_EXTPOL_HBSTATUS = "extpolHBStatus"
    OBJECT_TYPE_EXTPOL_PROVIDER = "extpolProvider"
    OBJECT_TYPE_EXTPOL_PROVIDER_CONT = "extpolProviderCont"
    OBJECT_TYPE_EXTPOL_REGISTRY = "extpolRegistry"
    OBJECT_TYPE_EXTPOL_REGISTRY_CAPABILITY = "extpolRegistryCapability"
    OBJECT_TYPE_EXTPOL_SVC = "extpolSvc"
    OBJECT_TYPE_EXTPOL_SYSTEM_CONTEXT = "extpolSystemContext"
    OBJECT_TYPE_EXTPOL_VERSION_HOLDER = "extpolVersionHolder"
    OBJECT_TYPE_EXTVMM_NETWORK_SETS = "extvmmNetworkSets"
    OBJECT_TYPE_EXTVMM_VMNETWORK_SETS = "extvmmVMNetworkSets"
    OBJECT_TYPE_FABRIC_ADCE_SW_SRV_EP = "fabricADceSwSrvEp"
    OBJECT_TYPE_FABRIC_AETH_ESTC_EP = "fabricAEthEstcEp"
    OBJECT_TYPE_FABRIC_AETH_LAN_EP = "fabricAEthLanEp"
    OBJECT_TYPE_FABRIC_AFC_ESTC_EP = "fabricAFcEstcEp"
    OBJECT_TYPE_FABRIC_AFC_SAN_EP = "fabricAFcSanEp"
    OBJECT_TYPE_FABRIC_AFCOE_ESTC_EP = "fabricAFcoeEstcEp"
    OBJECT_TYPE_FABRIC_AFCOE_SAN_EP = "fabricAFcoeSanEp"
    OBJECT_TYPE_FABRIC_AGROUP_REQ = "fabricAGroupReq"
    OBJECT_TYPE_FABRIC_ANET_GROUP = "fabricANetGroup"
    OBJECT_TYPE_FABRIC_ANET_GROUP_REF = "fabricANetGroupRef"
    OBJECT_TYPE_FABRIC_ASAN_GROUP = "fabricASanGroup"
    OBJECT_TYPE_FABRIC_AVLAN = "fabricAVlan"
    OBJECT_TYPE_FABRIC_AVSAN = "fabricAVsan"
    OBJECT_TYPE_FABRIC_BASE_NET_GROUP = "fabricBaseNetGroup"
    OBJECT_TYPE_FABRIC_BASE_PH_EP = "fabricBasePhEp"
    OBJECT_TYPE_FABRIC_BASE_SLOT_EP = "fabricBaseSlotEp"
    OBJECT_TYPE_FABRIC_BREAKOUT = "fabricBreakout"
    OBJECT_TYPE_FABRIC_BREAKOUT_OPERATION = "fabricBreakoutOperation"
    OBJECT_TYPE_FABRIC_CIO_EP = "fabricCIoEp"
    OBJECT_TYPE_FABRIC_CABLING = "fabricCabling"
    OBJECT_TYPE_FABRIC_CABLING_SW = "fabricCablingSw"
    OBJECT_TYPE_FABRIC_CARTRIDGE_SLOT_EP = "fabricCartridgeSlotEp"
    OBJECT_TYPE_FABRIC_CARTRIDGE_SLOT_EP_OPERATION = "fabricCartridgeSlotEpOperation"
    OBJECT_TYPE_FABRIC_CDP_LINK_POLICY = "fabricCdpLinkPolicy"
    OBJECT_TYPE_FABRIC_CHANGED_OBJECT_REF = "fabricChangedObjectRef"
    OBJECT_TYPE_FABRIC_CHASSIS_EP = "fabricChassisEp"
    OBJECT_TYPE_FABRIC_CLOUD = "fabricCloud"
    OBJECT_TYPE_FABRIC_COMPUTE_EP = "fabricComputeEp"
    OBJECT_TYPE_FABRIC_COMPUTE_MSLOT_EP = "fabricComputeMSlotEp"
    OBJECT_TYPE_FABRIC_COMPUTE_PH_EP = "fabricComputePhEp"
    OBJECT_TYPE_FABRIC_COMPUTE_PH_EP_OPERATION = "fabricComputePhEpOperation"
    OBJECT_TYPE_FABRIC_COMPUTE_SLOT_EP = "fabricComputeSlotEp"
    OBJECT_TYPE_FABRIC_COMPUTE_SLOT_EP_OPERATION = "fabricComputeSlotEpOperation"
    OBJECT_TYPE_FABRIC_CONSUMER = "fabricConsumer"
    OBJECT_TYPE_FABRIC_DCE_SRV = "fabricDceSrv"
    OBJECT_TYPE_FABRIC_DCE_SW_SRV = "fabricDceSwSrv"
    OBJECT_TYPE_FABRIC_DCE_SW_SRV_EP = "fabricDceSwSrvEp"
    OBJECT_TYPE_FABRIC_DCE_SW_SRV_EP_OPERATION = "fabricDceSwSrvEpOperation"
    OBJECT_TYPE_FABRIC_DCE_SW_SRV_PC = "fabricDceSwSrvPc"
    OBJECT_TYPE_FABRIC_DCE_SW_SRV_PC_EP = "fabricDceSwSrvPcEp"
    OBJECT_TYPE_FABRIC_DCE_SW_SRV_PC_EP_OPERATION = "fabricDceSwSrvPcEpOperation"
    OBJECT_TYPE_FABRIC_DCE_SW_SRV_PC_OPERATION = "fabricDceSwSrvPcOperation"
    OBJECT_TYPE_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM = "fabricDceSwSrvPcOperationFsm"
    OBJECT_TYPE_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_STAGE = "fabricDceSwSrvPcOperationFsmStage"
    OBJECT_TYPE_FABRIC_DOMAIN = "fabricDomain"
    OBJECT_TYPE_FABRIC_DOMAIN_EP = "fabricDomainEp"
    OBJECT_TYPE_FABRIC_ENCLOSURE_PH_EP = "fabricEnclosurePhEp"
    OBJECT_TYPE_FABRIC_ENCLOSURE_PH_EP_OPERATION = "fabricEnclosurePhEpOperation"
    OBJECT_TYPE_FABRIC_ENCLOSURE_SLOT_EP = "fabricEnclosureSlotEp"
    OBJECT_TYPE_FABRIC_ENCLOSURE_SLOT_EP_OPERATION = "fabricEnclosureSlotEpOperation"
    OBJECT_TYPE_FABRIC_EP = "fabricEp"
    OBJECT_TYPE_FABRIC_EP_VLAN = "fabricEpVlan"
    OBJECT_TYPE_FABRIC_EP_VSAN = "fabricEpVsan"
    OBJECT_TYPE_FABRIC_EQUIPMENT_EP = "fabricEquipmentEp"
    OBJECT_TYPE_FABRIC_ESTC_EP = "fabricEstcEp"
    OBJECT_TYPE_FABRIC_ESTC_PC = "fabricEstcPc"
    OBJECT_TYPE_FABRIC_ETH_CDP_POLICY = "fabricEthCdpPolicy"
    OBJECT_TYPE_FABRIC_ETH_ESTC = "fabricEthEstc"
    OBJECT_TYPE_FABRIC_ETH_ESTC_CLOUD = "fabricEthEstcCloud"
    OBJECT_TYPE_FABRIC_ETH_ESTC_EP = "fabricEthEstcEp"
    OBJECT_TYPE_FABRIC_ETH_ESTC_EP_OPERATION = "fabricEthEstcEpOperation"
    OBJECT_TYPE_FABRIC_ETH_ESTC_EP_OPERATION_FSM = "fabricEthEstcEpOperationFsm"
    OBJECT_TYPE_FABRIC_ETH_ESTC_EP_OPERATION_FSM_STAGE = "fabricEthEstcEpOperationFsmStage"
    OBJECT_TYPE_FABRIC_ETH_ESTC_PC = "fabricEthEstcPc"
    OBJECT_TYPE_FABRIC_ETH_ESTC_PC_EP = "fabricEthEstcPcEp"
    OBJECT_TYPE_FABRIC_ETH_ESTC_PC_EP_OPERATION = "fabricEthEstcPcEpOperation"
    OBJECT_TYPE_FABRIC_ETH_ESTC_PC_OPERATION = "fabricEthEstcPcOperation"
    OBJECT_TYPE_FABRIC_ETH_ESTC_PC_OPERATION_FSM = "fabricEthEstcPcOperationFsm"
    OBJECT_TYPE_FABRIC_ETH_ESTC_PC_OPERATION_FSM_STAGE = "fabricEthEstcPcOperationFsmStage"
    OBJECT_TYPE_FABRIC_ETH_LAN = "fabricEthLan"
    OBJECT_TYPE_FABRIC_ETH_LAN_EP = "fabricEthLanEp"
    OBJECT_TYPE_FABRIC_ETH_LAN_EP_OPERATION = "fabricEthLanEpOperation"
    OBJECT_TYPE_FABRIC_ETH_LAN_EP_OPERATION_FSM = "fabricEthLanEpOperationFsm"
    OBJECT_TYPE_FABRIC_ETH_LAN_EP_OPERATION_FSM_STAGE = "fabricEthLanEpOperationFsmStage"
    OBJECT_TYPE_FABRIC_ETH_LAN_PC = "fabricEthLanPc"
    OBJECT_TYPE_FABRIC_ETH_LAN_PC_EP = "fabricEthLanPcEp"
    OBJECT_TYPE_FABRIC_ETH_LAN_PC_EP_OPERATION = "fabricEthLanPcEpOperation"
    OBJECT_TYPE_FABRIC_ETH_LAN_PC_OPERATION = "fabricEthLanPcOperation"
    OBJECT_TYPE_FABRIC_ETH_LAN_PC_OPERATION_FSM = "fabricEthLanPcOperationFsm"
    OBJECT_TYPE_FABRIC_ETH_LAN_PC_OPERATION_FSM_STAGE = "fabricEthLanPcOperationFsmStage"
    OBJECT_TYPE_FABRIC_ETH_LINK_POLICY = "fabricEthLinkPolicy"
    OBJECT_TYPE_FABRIC_ETH_LINK_PROFILE = "fabricEthLinkProfile"
    OBJECT_TYPE_FABRIC_ETH_MON = "fabricEthMon"
    OBJECT_TYPE_FABRIC_ETH_MON_DEST_EP = "fabricEthMonDestEp"
    OBJECT_TYPE_FABRIC_ETH_MON_DEST_EP_OPERATION = "fabricEthMonDestEpOperation"
    OBJECT_TYPE_FABRIC_ETH_MON_LAN = "fabricEthMonLan"
    OBJECT_TYPE_FABRIC_ETH_MON_OPERATION = "fabricEthMonOperation"
    OBJECT_TYPE_FABRIC_ETH_MON_OPERATION_FSM = "fabricEthMonOperationFsm"
    OBJECT_TYPE_FABRIC_ETH_MON_OPERATION_FSM_STAGE = "fabricEthMonOperationFsmStage"
    OBJECT_TYPE_FABRIC_ETH_MON_SRC_EP = "fabricEthMonSrcEp"
    OBJECT_TYPE_FABRIC_ETH_MON_SRC_EP_OPERATION = "fabricEthMonSrcEpOperation"
    OBJECT_TYPE_FABRIC_ETH_MON_SRC_REF = "fabricEthMonSrcRef"
    OBJECT_TYPE_FABRIC_ETH_PORT_OPERATION = "fabricEthPortOperation"
    OBJECT_TYPE_FABRIC_ETH_PORT_OPERATION_FSM = "fabricEthPortOperationFsm"
    OBJECT_TYPE_FABRIC_ETH_PORT_OPERATION_FSM_STAGE = "fabricEthPortOperationFsmStage"
    OBJECT_TYPE_FABRIC_ETH_TARGET_EP = "fabricEthTargetEp"
    OBJECT_TYPE_FABRIC_ETH_TARGET_EP_OPERATION = "fabricEthTargetEpOperation"
    OBJECT_TYPE_FABRIC_ETH_UDLD_POLICY = "fabricEthUdldPolicy"
    OBJECT_TYPE_FABRIC_ETH_VLAN_PC = "fabricEthVlanPc"
    OBJECT_TYPE_FABRIC_ETH_VLAN_PORT_EP = "fabricEthVlanPortEp"
    OBJECT_TYPE_FABRIC_ETHER_REF = "fabricEtherRef"
    OBJECT_TYPE_FABRIC_EXTENSION = "fabricExtension"
    OBJECT_TYPE_FABRIC_EXTERNAL = "fabricExternal"
    OBJECT_TYPE_FABRIC_EXTERNAL_EP = "fabricExternalEp"
    OBJECT_TYPE_FABRIC_EXTERNAL_ESTC = "fabricExternalEstc"
    OBJECT_TYPE_FABRIC_EXTERNAL_PC = "fabricExternalPc"
    OBJECT_TYPE_FABRIC_FIPORT_OPERATION = "fabricFIPortOperation"
    OBJECT_TYPE_FABRIC_FIPORT_OPERATION_FSM = "fabricFIPortOperationFsm"
    OBJECT_TYPE_FABRIC_FIPORT_OPERATION_FSM_STAGE = "fabricFIPortOperationFsmStage"
    OBJECT_TYPE_FABRIC_FIPORT_OPERATION_FSM_TASK = "fabricFIPortOperationFsmTask"
    OBJECT_TYPE_FABRIC_FC_ENDPOINT = "fabricFcEndpoint"
    OBJECT_TYPE_FABRIC_FC_ESTC = "fabricFcEstc"
    OBJECT_TYPE_FABRIC_FC_ESTC_CLOUD = "fabricFcEstcCloud"
    OBJECT_TYPE_FABRIC_FC_ESTC_EP = "fabricFcEstcEp"
    OBJECT_TYPE_FABRIC_FC_ESTC_EP_OPERATION = "fabricFcEstcEpOperation"
    OBJECT_TYPE_FABRIC_FC_ESTC_EP_OPERATION_FSM = "fabricFcEstcEpOperationFsm"
    OBJECT_TYPE_FABRIC_FC_ESTC_EP_OPERATION_FSM_STAGE = "fabricFcEstcEpOperationFsmStage"
    OBJECT_TYPE_FABRIC_FC_MON = "fabricFcMon"
    OBJECT_TYPE_FABRIC_FC_MON_DEST_EP = "fabricFcMonDestEp"
    OBJECT_TYPE_FABRIC_FC_MON_DEST_EP_OPERATION = "fabricFcMonDestEpOperation"
    OBJECT_TYPE_FABRIC_FC_MON_OPERATION = "fabricFcMonOperation"
    OBJECT_TYPE_FABRIC_FC_MON_OPERATION_FSM = "fabricFcMonOperationFsm"
    OBJECT_TYPE_FABRIC_FC_MON_OPERATION_FSM_STAGE = "fabricFcMonOperationFsmStage"
    OBJECT_TYPE_FABRIC_FC_MON_SAN = "fabricFcMonSan"
    OBJECT_TYPE_FABRIC_FC_MON_SRC_EP = "fabricFcMonSrcEp"
    OBJECT_TYPE_FABRIC_FC_MON_SRC_EP_OPERATION = "fabricFcMonSrcEpOperation"
    OBJECT_TYPE_FABRIC_FC_MON_SRC_REF = "fabricFcMonSrcRef"
    OBJECT_TYPE_FABRIC_FC_PORT_OPERATION = "fabricFcPortOperation"
    OBJECT_TYPE_FABRIC_FC_PORT_OPERATION_FSM = "fabricFcPortOperationFsm"
    OBJECT_TYPE_FABRIC_FC_PORT_OPERATION_FSM_STAGE = "fabricFcPortOperationFsmStage"
    OBJECT_TYPE_FABRIC_FC_SAN = "fabricFcSan"
    OBJECT_TYPE_FABRIC_FC_SAN_EP = "fabricFcSanEp"
    OBJECT_TYPE_FABRIC_FC_SAN_EP_OPERATION = "fabricFcSanEpOperation"
    OBJECT_TYPE_FABRIC_FC_SAN_EP_OPERATION_FSM = "fabricFcSanEpOperationFsm"
    OBJECT_TYPE_FABRIC_FC_SAN_EP_OPERATION_FSM_STAGE = "fabricFcSanEpOperationFsmStage"
    OBJECT_TYPE_FABRIC_FC_SAN_PC = "fabricFcSanPc"
    OBJECT_TYPE_FABRIC_FC_SAN_PC_EP = "fabricFcSanPcEp"
    OBJECT_TYPE_FABRIC_FC_SAN_PC_EP_OPERATION = "fabricFcSanPcEpOperation"
    OBJECT_TYPE_FABRIC_FC_SAN_PC_OPERATION = "fabricFcSanPcOperation"
    OBJECT_TYPE_FABRIC_FC_SAN_PC_OPERATION_FSM = "fabricFcSanPcOperationFsm"
    OBJECT_TYPE_FABRIC_FC_SAN_PC_OPERATION_FSM_STAGE = "fabricFcSanPcOperationFsmStage"
    OBJECT_TYPE_FABRIC_FC_UPLINK_OPERATION = "fabricFcUplinkOperation"
    OBJECT_TYPE_FABRIC_FC_USER_ZONE = "fabricFcUserZone"
    OBJECT_TYPE_FABRIC_FC_USER_ZONE_IVT = "fabricFcUserZoneIvt"
    OBJECT_TYPE_FABRIC_FC_VSAN_PC = "fabricFcVsanPc"
    OBJECT_TYPE_FABRIC_FC_VSAN_PORT_EP = "fabricFcVsanPortEp"
    OBJECT_TYPE_FABRIC_FC_ZONE_PROFILE = "fabricFcZoneProfile"
    OBJECT_TYPE_FABRIC_FC_ZONE_PROFILE_FSM = "fabricFcZoneProfileFsm"
    OBJECT_TYPE_FABRIC_FC_ZONE_PROFILE_FSM_STAGE = "fabricFcZoneProfileFsmStage"
    OBJECT_TYPE_FABRIC_FC_ZONE_PROFILE_FSM_TASK = "fabricFcZoneProfileFsmTask"
    OBJECT_TYPE_FABRIC_FC_ZONE_PROFILE_IVT = "fabricFcZoneProfileIvt"
    OBJECT_TYPE_FABRIC_FCOE_ESTC_EP = "fabricFcoeEstcEp"
    OBJECT_TYPE_FABRIC_FCOE_ESTC_EP_OPERATION = "fabricFcoeEstcEpOperation"
    OBJECT_TYPE_FABRIC_FCOE_ESTC_EP_OPERATION_FSM = "fabricFcoeEstcEpOperationFsm"
    OBJECT_TYPE_FABRIC_FCOE_ESTC_EP_OPERATION_FSM_STAGE = "fabricFcoeEstcEpOperationFsmStage"
    OBJECT_TYPE_FABRIC_FCOE_SAN_EP = "fabricFcoeSanEp"
    OBJECT_TYPE_FABRIC_FCOE_SAN_EP_OPERATION = "fabricFcoeSanEpOperation"
    OBJECT_TYPE_FABRIC_FCOE_SAN_EP_OPERATION_FSM = "fabricFcoeSanEpOperationFsm"
    OBJECT_TYPE_FABRIC_FCOE_SAN_EP_OPERATION_FSM_STAGE = "fabricFcoeSanEpOperationFsmStage"
    OBJECT_TYPE_FABRIC_FCOE_SAN_PC = "fabricFcoeSanPc"
    OBJECT_TYPE_FABRIC_FCOE_SAN_PC_EP = "fabricFcoeSanPcEp"
    OBJECT_TYPE_FABRIC_FCOE_SAN_PC_EP_OPERATION = "fabricFcoeSanPcEpOperation"
    OBJECT_TYPE_FABRIC_FCOE_SAN_PC_OPERATION = "fabricFcoeSanPcOperation"
    OBJECT_TYPE_FABRIC_FCOE_SAN_PC_OPERATION_FSM = "fabricFcoeSanPcOperationFsm"
    OBJECT_TYPE_FABRIC_FCOE_SAN_PC_OPERATION_FSM_STAGE = "fabricFcoeSanPcOperationFsmStage"
    OBJECT_TYPE_FABRIC_FCOE_VSAN_PC = "fabricFcoeVsanPc"
    OBJECT_TYPE_FABRIC_FCOE_VSAN_PORT_EP = "fabricFcoeVsanPortEp"
    OBJECT_TYPE_FABRIC_HOLDER = "fabricHolder"
    OBJECT_TYPE_FABRIC_IF = "fabricIf"
    OBJECT_TYPE_FABRIC_INTERNAL = "fabricInternal"
    OBJECT_TYPE_FABRIC_INTERNAL_DCE_SRV = "fabricInternalDceSrv"
    OBJECT_TYPE_FABRIC_INTERNAL_EP = "fabricInternalEp"
    OBJECT_TYPE_FABRIC_INTERNAL_PC = "fabricInternalPc"
    OBJECT_TYPE_FABRIC_LACP_POLICY = "fabricLacpPolicy"
    OBJECT_TYPE_FABRIC_LAN = "fabricLan"
    OBJECT_TYPE_FABRIC_LAN_ACCESS_MGR = "fabricLanAccessMgr"
    OBJECT_TYPE_FABRIC_LAN_CLOUD = "fabricLanCloud"
    OBJECT_TYPE_FABRIC_LAN_CLOUD_POLICY = "fabricLanCloudPolicy"
    OBJECT_TYPE_FABRIC_LAN_EP = "fabricLanEp"
    OBJECT_TYPE_FABRIC_LAN_MON_CLOUD = "fabricLanMonCloud"
    OBJECT_TYPE_FABRIC_LAN_PC = "fabricLanPc"
    OBJECT_TYPE_FABRIC_LAN_PIN_GROUP = "fabricLanPinGroup"
    OBJECT_TYPE_FABRIC_LAN_PIN_GROUP_OPERATION = "fabricLanPinGroupOperation"
    OBJECT_TYPE_FABRIC_LAN_PIN_TARGET = "fabricLanPinTarget"
    OBJECT_TYPE_FABRIC_LAN_PIN_TARGET_OPERATION = "fabricLanPinTargetOperation"
    OBJECT_TYPE_FABRIC_LAST_ACKED_SLOT = "fabricLastAckedSlot"
    OBJECT_TYPE_FABRIC_LINK_POLICY = "fabricLinkPolicy"
    OBJECT_TYPE_FABRIC_MON = "fabricMon"
    OBJECT_TYPE_FABRIC_MON_DEST_EP = "fabricMonDestEp"
    OBJECT_TYPE_FABRIC_MON_SRC_EP = "fabricMonSrcEp"
    OBJECT_TYPE_FABRIC_MON_SRC_REF = "fabricMonSrcRef"
    OBJECT_TYPE_FABRIC_MULTICAST_POLICY = "fabricMulticastPolicy"
    OBJECT_TYPE_FABRIC_NET_GROUP = "fabricNetGroup"
    OBJECT_TYPE_FABRIC_NET_GROUP_EP = "fabricNetGroupEp"
    OBJECT_TYPE_FABRIC_NET_GROUP_PERMIT = "fabricNetGroupPermit"
    OBJECT_TYPE_FABRIC_NET_GROUP_REF = "fabricNetGroupRef"
    OBJECT_TYPE_FABRIC_NET_GROUP_REQ = "fabricNetGroupReq"
    OBJECT_TYPE_FABRIC_ORG_VLAN_POLICY = "fabricOrgVlanPolicy"
    OBJECT_TYPE_FABRIC_PIO_EP = "fabricPIoEp"
    OBJECT_TYPE_FABRIC_PIN_GROUP = "fabricPinGroup"
    OBJECT_TYPE_FABRIC_PIN_TARGET = "fabricPinTarget"
    OBJECT_TYPE_FABRIC_POOLABLE_VLAN = "fabricPoolableVlan"
    OBJECT_TYPE_FABRIC_POOLED_VLAN = "fabricPooledVlan"
    OBJECT_TYPE_FABRIC_SAN = "fabricSan"
    OBJECT_TYPE_FABRIC_SAN_CLOUD = "fabricSanCloud"
    OBJECT_TYPE_FABRIC_SAN_EP = "fabricSanEp"
    OBJECT_TYPE_FABRIC_SAN_GROUP = "fabricSanGroup"
    OBJECT_TYPE_FABRIC_SAN_GROUP_REF = "fabricSanGroupRef"
    OBJECT_TYPE_FABRIC_SAN_MON_CLOUD = "fabricSanMonCloud"
    OBJECT_TYPE_FABRIC_SAN_PC = "fabricSanPc"
    OBJECT_TYPE_FABRIC_SAN_PIN_GROUP = "fabricSanPinGroup"
    OBJECT_TYPE_FABRIC_SAN_PIN_GROUP_OPERATION = "fabricSanPinGroupOperation"
    OBJECT_TYPE_FABRIC_SAN_PIN_TARGET = "fabricSanPinTarget"
    OBJECT_TYPE_FABRIC_SAN_PIN_TARGET_OPERATION = "fabricSanPinTargetOperation"
    OBJECT_TYPE_FABRIC_SUB_GROUP = "fabricSubGroup"
    OBJECT_TYPE_FABRIC_SW_CH_EP = "fabricSwChEp"
    OBJECT_TYPE_FABRIC_SW_CH_PH_EP = "fabricSwChPhEp"
    OBJECT_TYPE_FABRIC_SW_CH_PH_EP_OPERATION = "fabricSwChPhEpOperation"
    OBJECT_TYPE_FABRIC_SW_SRV_EP = "fabricSwSrvEp"
    OBJECT_TYPE_FABRIC_SW_SRV_PC = "fabricSwSrvPc"
    OBJECT_TYPE_FABRIC_SW_SUB_GROUP = "fabricSwSubGroup"
    OBJECT_TYPE_FABRIC_SYSTEM = "fabricSystem"
    OBJECT_TYPE_FABRIC_TARGET_EP = "fabricTargetEp"
    OBJECT_TYPE_FABRIC_UDLD_LINK_POLICY = "fabricUdldLinkPolicy"
    OBJECT_TYPE_FABRIC_UDLD_POLICY = "fabricUdldPolicy"
    OBJECT_TYPE_FABRIC_VCON = "fabricVCon"
    OBJECT_TYPE_FABRIC_VCON_PROFILE = "fabricVConProfile"
    OBJECT_TYPE_FABRIC_VLAN = "fabricVlan"
    OBJECT_TYPE_FABRIC_VLAN_EP = "fabricVlanEp"
    OBJECT_TYPE_FABRIC_VLAN_GROUP_REQ = "fabricVlanGroupReq"
    OBJECT_TYPE_FABRIC_VLAN_PERMIT = "fabricVlanPermit"
    OBJECT_TYPE_FABRIC_VLAN_PERMIT_ITEM = "fabricVlanPermitItem"
    OBJECT_TYPE_FABRIC_VLAN_REQ = "fabricVlanReq"
    OBJECT_TYPE_FABRIC_VNET_EP = "fabricVnetEp"
    OBJECT_TYPE_FABRIC_VNET_EP_SYNC_EP = "fabricVnetEpSyncEp"
    OBJECT_TYPE_FABRIC_VNET_EP_SYNC_EP_FSM = "fabricVnetEpSyncEpFsm"
    OBJECT_TYPE_FABRIC_VNET_EP_SYNC_EP_FSM_STAGE = "fabricVnetEpSyncEpFsmStage"
    OBJECT_TYPE_FABRIC_VNET_EP_SYNC_EP_FSM_TASK = "fabricVnetEpSyncEpFsmTask"
    OBJECT_TYPE_FABRIC_VNET_GROUP_REQ = "fabricVnetGroupReq"
    OBJECT_TYPE_FABRIC_VNET_REQ = "fabricVnetReq"
    OBJECT_TYPE_FABRIC_VSAN = "fabricVsan"
    OBJECT_TYPE_FABRIC_VSAN_EP = "fabricVsanEp"
    OBJECT_TYPE_FABRIC_VSAN_MEMBERSHIP = "fabricVsanMembership"
    OBJECT_TYPE_FAULT_BASE_HOLDER = "faultBaseHolder"
    OBJECT_TYPE_FAULT_BASE_POLICY = "faultBasePolicy"
    OBJECT_TYPE_FAULT_BASE_TYPED_HOLDER = "faultBaseTypedHolder"
    OBJECT_TYPE_FAULT_DOMAIN_EP = "faultDomainEp"
    OBJECT_TYPE_FAULT_DOMAIN_INST = "faultDomainInst"
    OBJECT_TYPE_FAULT_GLOBAL_SEVERITY_HOLDER = "faultGlobalSeverityHolder"
    OBJECT_TYPE_FAULT_GLOBAL_TYPED_HOLDER = "faultGlobalTypedHolder"
    OBJECT_TYPE_FAULT_HOLDER = "faultHolder"
    OBJECT_TYPE_FAULT_INST = "faultInst"
    OBJECT_TYPE_FAULT_LOCAL_BASE_HOLDER = "faultLocalBaseHolder"
    OBJECT_TYPE_FAULT_LOCAL_TYPED_HOLDER = "faultLocalTypedHolder"
    OBJECT_TYPE_FAULT_POLICY = "faultPolicy"
    OBJECT_TYPE_FAULT_SUMMARY = "faultSummary"
    OBJECT_TYPE_FAULT_SUMMARY_INST = "faultSummaryInst"
    OBJECT_TYPE_FAULT_SVC_SUMMARY = "faultSvcSummary"
    OBJECT_TYPE_FAULT_TYPED_HOLDER = "faultTypedHolder"
    OBJECT_TYPE_FC_ERR_STATS = "fcErrStats"
    OBJECT_TYPE_FC_ERR_STATS_HIST = "fcErrStatsHist"
    OBJECT_TYPE_FC_PIO = "fcPIo"
    OBJECT_TYPE_FC_STATS = "fcStats"
    OBJECT_TYPE_FC_STATS_HIST = "fcStatsHist"
    OBJECT_TYPE_FCPOOL_ADDR = "fcpoolAddr"
    OBJECT_TYPE_FCPOOL_BLOCK = "fcpoolBlock"
    OBJECT_TYPE_FCPOOL_BOOT_TARGET = "fcpoolBootTarget"
    OBJECT_TYPE_FCPOOL_FORMAT = "fcpoolFormat"
    OBJECT_TYPE_FCPOOL_INITIATOR = "fcpoolInitiator"
    OBJECT_TYPE_FCPOOL_INITIATOR_EP = "fcpoolInitiatorEp"
    OBJECT_TYPE_FCPOOL_INITIATORS = "fcpoolInitiators"
    OBJECT_TYPE_FCPOOL_UNIVERSE = "fcpoolUniverse"
    OBJECT_TYPE_FD_BLADE = "fdBlade"
    OBJECT_TYPE_FD_BLADE_FSM = "fdBladeFsm"
    OBJECT_TYPE_FD_BLADE_FSM_STAGE = "fdBladeFsmStage"
    OBJECT_TYPE_FD_CHASSIS = "fdChassis"
    OBJECT_TYPE_FD_OPERABLE = "fdOperable"
    OBJECT_TYPE_FD_PHYSICAL = "fdPhysical"
    OBJECT_TYPE_FD_PHYSICAL_FSM = "fdPhysicalFsm"
    OBJECT_TYPE_FD_PHYSICAL_FSM_STAGE = "fdPhysicalFsmStage"
    OBJECT_TYPE_FD_PHYSICAL_FSM_TASK = "fdPhysicalFsmTask"
    OBJECT_TYPE_FD_RACK_UNIT = "fdRackUnit"
    OBJECT_TYPE_FD_RACK_UNIT_FSM = "fdRackUnitFsm"
    OBJECT_TYPE_FD_RACK_UNIT_FSM_STAGE = "fdRackUnitFsmStage"
    OBJECT_TYPE_FEATURE_CATALOG_EP = "featureCatalogEp"
    OBJECT_TYPE_FEATURE_CHASSIS_DEF = "featureChassisDef"
    OBJECT_TYPE_FEATURE_DEFINITION = "featureDefinition"
    OBJECT_TYPE_FEATURE_ENV_DEF = "featureEnvDef"
    OBJECT_TYPE_FEATURE_NETWORK_DEF = "featureNetworkDef"
    OBJECT_TYPE_FEATURE_SERVER_DEF = "featureServerDef"
    OBJECT_TYPE_FEATURE_STORAGE_DEF = "featureStorageDef"
    OBJECT_TYPE_FIRMWARE_ACOMPONENT_SPEC = "firmwareAComponentSpec"
    OBJECT_TYPE_FIRMWARE_AEXCLUDE_COMPONENT = "firmwareAExcludeComponent"
    OBJECT_TYPE_FIRMWARE_AINFRA_PACK = "firmwareAInfraPack"
    OBJECT_TYPE_FIRMWARE_ACK = "firmwareAck"
    OBJECT_TYPE_FIRMWARE_AUTO_SYNC_POLICY = "firmwareAutoSyncPolicy"
    OBJECT_TYPE_FIRMWARE_BOOT_DEFINITION = "firmwareBootDefinition"
    OBJECT_TYPE_FIRMWARE_BOOT_UNIT = "firmwareBootUnit"
    OBJECT_TYPE_FIRMWARE_BUNDLE_INFO = "firmwareBundleInfo"
    OBJECT_TYPE_FIRMWARE_BUNDLE_INFO_DIGEST = "firmwareBundleInfoDigest"
    OBJECT_TYPE_FIRMWARE_BUNDLE_TYPE = "firmwareBundleType"
    OBJECT_TYPE_FIRMWARE_BUNDLE_TYPE_CAP_PROVIDER = "firmwareBundleTypeCapProvider"
    OBJECT_TYPE_FIRMWARE_CAP_PROVIDER = "firmwareCapProvider"
    OBJECT_TYPE_FIRMWARE_CATALOG_PACK = "firmwareCatalogPack"
    OBJECT_TYPE_FIRMWARE_CATALOG_PACK_CONFIG = "firmwareCatalogPackConfig"
    OBJECT_TYPE_FIRMWARE_CATALOGUE = "firmwareCatalogue"
    OBJECT_TYPE_FIRMWARE_CHASSIS_COMPONENT_SPEC = "firmwareChassisComponentSpec"
    OBJECT_TYPE_FIRMWARE_CHASSIS_PACK = "firmwareChassisPack"
    OBJECT_TYPE_FIRMWARE_COMP_ITEM = "firmwareCompItem"
    OBJECT_TYPE_FIRMWARE_COMP_SOURCE = "firmwareCompSource"
    OBJECT_TYPE_FIRMWARE_COMP_TARGET = "firmwareCompTarget"
    OBJECT_TYPE_FIRMWARE_COMPONENT_SPEC = "firmwareComponentSpec"
    OBJECT_TYPE_FIRMWARE_COMPUTE_HOST_PACK = "firmwareComputeHostPack"
    OBJECT_TYPE_FIRMWARE_COMPUTE_MGMT_PACK = "firmwareComputeMgmtPack"
    OBJECT_TYPE_FIRMWARE_COMPUTE_PACK = "firmwareComputePack"
    OBJECT_TYPE_FIRMWARE_COMPUTE_STORAGE_PACK = "firmwareComputeStoragePack"
    OBJECT_TYPE_FIRMWARE_CONNECTION_POLICY = "firmwareConnectionPolicy"
    OBJECT_TYPE_FIRMWARE_DEPENDENCY = "firmwareDependency"
    OBJECT_TYPE_FIRMWARE_DIST_IMAGE = "firmwareDistImage"
    OBJECT_TYPE_FIRMWARE_DISTRIBUTABLE = "firmwareDistributable"
    OBJECT_TYPE_FIRMWARE_DISTRIBUTABLE_FSM = "firmwareDistributableFsm"
    OBJECT_TYPE_FIRMWARE_DISTRIBUTABLE_FSM_STAGE = "firmwareDistributableFsmStage"
    OBJECT_TYPE_FIRMWARE_DISTRIBUTABLE_FSM_TASK = "firmwareDistributableFsmTask"
    OBJECT_TYPE_FIRMWARE_DOMAIN_INFO = "firmwareDomainInfo"
    OBJECT_TYPE_FIRMWARE_DOMAIN_INFRA_PROFILE = "firmwareDomainInfraProfile"
    OBJECT_TYPE_FIRMWARE_DOWNLOAD_POLICY = "firmwareDownloadPolicy"
    OBJECT_TYPE_FIRMWARE_DOWNLOADER = "firmwareDownloader"
    OBJECT_TYPE_FIRMWARE_DOWNLOADER_FSM = "firmwareDownloaderFsm"
    OBJECT_TYPE_FIRMWARE_DOWNLOADER_FSM_STAGE = "firmwareDownloaderFsmStage"
    OBJECT_TYPE_FIRMWARE_DOWNLOADER_FSM_TASK = "firmwareDownloaderFsmTask"
    OBJECT_TYPE_FIRMWARE_EXCLUDE_CHASSIS_COMPONENT = "firmwareExcludeChassisComponent"
    OBJECT_TYPE_FIRMWARE_EXCLUDE_SERVER_COMPONENT = "firmwareExcludeServerComponent"
    OBJECT_TYPE_FIRMWARE_IMAGE = "firmwareImage"
    OBJECT_TYPE_FIRMWARE_INFRA = "firmwareInfra"
    OBJECT_TYPE_FIRMWARE_INFRA_PACK = "firmwareInfraPack"
    OBJECT_TYPE_FIRMWARE_INFRA_PACK_CONFIG = "firmwareInfraPackConfig"
    OBJECT_TYPE_FIRMWARE_INFRA_POLICY = "firmwareInfraPolicy"
    OBJECT_TYPE_FIRMWARE_INSTALL_IMPACT = "firmwareInstallImpact"
    OBJECT_TYPE_FIRMWARE_PACK = "firmwarePack"
    OBJECT_TYPE_FIRMWARE_POLICY = "firmwarePolicy"
    OBJECT_TYPE_FIRMWARE_PRODUCT_FAMILY = "firmwareProductFamily"
    OBJECT_TYPE_FIRMWARE_REMOTE_CATALOGUE = "firmwareRemoteCatalogue"
    OBJECT_TYPE_FIRMWARE_RUNNING = "firmwareRunning"
    OBJECT_TYPE_FIRMWARE_SOURCE = "firmwareSource"
    OBJECT_TYPE_FIRMWARE_STATUS = "firmwareStatus"
    OBJECT_TYPE_FIRMWARE_STORAGE_PACK = "firmwareStoragePack"
    OBJECT_TYPE_FIRMWARE_SYSTEM = "firmwareSystem"
    OBJECT_TYPE_FIRMWARE_TYPE = "firmwareType"
    OBJECT_TYPE_FIRMWARE_UNIT = "firmwareUnit"
    OBJECT_TYPE_FIRMWARE_UPDATABLE = "firmwareUpdatable"
    OBJECT_TYPE_FIRMWARE_UPGRADE_DETAIL = "firmwareUpgradeDetail"
    OBJECT_TYPE_FIRMWARE_UPGRADE_INFO = "firmwareUpgradeInfo"
    OBJECT_TYPE_FLOWCTRL_DEFINITION = "flowctrlDefinition"
    OBJECT_TYPE_FLOWCTRL_ITEM = "flowctrlItem"
    OBJECT_TYPE_FSM_FSM = "fsmFsm"
    OBJECT_TYPE_FSM_STAGE = "fsmStage"
    OBJECT_TYPE_FSM_STATUS = "fsmStatus"
    OBJECT_TYPE_FSM_TASK = "fsmTask"
    OBJECT_TYPE_GL_ABS_CONFLICT = "glAbsConflict"
    OBJECT_TYPE_GL_ABS_EP = "glAbsEp"
    OBJECT_TYPE_GL_ABS_IDENT_CTX_OP = "glAbsIdentCtxOp"
    OBJECT_TYPE_GL_ABS_INV = "glAbsInv"
    OBJECT_TYPE_GL_ABS_OPERATION = "glAbsOperation"
    OBJECT_TYPE_GL_ABS_POLICY_INV = "glAbsPolicyInv"
    OBJECT_TYPE_GL_ABS_POLICY_OP = "glAbsPolicyOp"
    OBJECT_TYPE_GL_ABS_POLICY_RULE = "glAbsPolicyRule"
    OBJECT_TYPE_GL_ABS_REQUEST = "glAbsRequest"
    OBJECT_TYPE_GL_ABS_RES_EP = "glAbsResEp"
    OBJECT_TYPE_GL_ABS_RULE = "glAbsRule"
    OBJECT_TYPE_GL_ABS_VNET_INV = "glAbsVnetInv"
    OBJECT_TYPE_GL_APPEND_RULE = "glAppendRule"
    OBJECT_TYPE_GL_BLOCK_EP = "glBlockEp"
    OBJECT_TYPE_GL_BLOCK_OP = "glBlockOp"
    OBJECT_TYPE_GL_BY_MO = "glByMo"
    OBJECT_TYPE_GL_COMPLEX_REF_EP = "glComplexRefEp"
    OBJECT_TYPE_GL_CONFLICT_EP = "glConflictEp"
    OBJECT_TYPE_GL_CONFLICT_RESOLUTION_RULE_EP = "glConflictResolutionRuleEp"
    OBJECT_TYPE_GL_DOMAIN_EP = "glDomainEp"
    OBJECT_TYPE_GL_EP = "glEp"
    OBJECT_TYPE_GL_GLOBAL_DEFAULT_POLICY_EP = "glGlobalDefaultPolicyEp"
    OBJECT_TYPE_GL_ID_REF = "glIdRef"
    OBJECT_TYPE_GL_ID_REF_EP = "glIdRefEp"
    OBJECT_TYPE_GL_IDABLE = "glIdable"
    OBJECT_TYPE_GL_IDENT_CTX_EP = "glIdentCtxEp"
    OBJECT_TYPE_GL_IDENT_CTX_OP = "glIdentCtxOp"
    OBJECT_TYPE_GL_IDENT_CTX_RES_OP = "glIdentCtxResOp"
    OBJECT_TYPE_GL_IDENT_CTX_RES_OP_FSM = "glIdentCtxResOpFsm"
    OBJECT_TYPE_GL_IDENT_CTX_RES_OP_FSM_STAGE = "glIdentCtxResOpFsmStage"
    OBJECT_TYPE_GL_IDENT_CTX_RES_OP_FSM_TASK = "glIdentCtxResOpFsmTask"
    OBJECT_TYPE_GL_INVENTORY_EP = "glInventoryEp"
    OBJECT_TYPE_GL_LSP = "glLsp"
    OBJECT_TYPE_GL_MCAST_POLICY = "glMcastPolicy"
    OBJECT_TYPE_GL_OPERATION_EP = "glOperationEp"
    OBJECT_TYPE_GL_PATH_EP = "glPathEp"
    OBJECT_TYPE_GL_POLICY = "glPolicy"
    OBJECT_TYPE_GL_POLICY_ALGORITHMED_OP = "glPolicyAlgorithmedOp"
    OBJECT_TYPE_GL_POLICY_EP = "glPolicyEp"
    OBJECT_TYPE_GL_POLICY_INV_EP = "glPolicyInvEp"
    OBJECT_TYPE_GL_POLICY_NAME_RULE_EP = "glPolicyNameRuleEp"
    OBJECT_TYPE_GL_POLICY_OP = "glPolicyOp"
    OBJECT_TYPE_GL_POLICY_REF = "glPolicyRef"
    OBJECT_TYPE_GL_POLICY_REF_EP = "glPolicyRefEp"
    OBJECT_TYPE_GL_POLICY_RES_OP = "glPolicyResOp"
    OBJECT_TYPE_GL_POLICY_RESOLUTION_EP = "glPolicyResolutionEp"
    OBJECT_TYPE_GL_POOL = "glPool"
    OBJECT_TYPE_GL_POOL_EP = "glPoolEp"
    OBJECT_TYPE_GL_POOL_INV_EP = "glPoolInvEp"
    OBJECT_TYPE_GL_POOL_OP = "glPoolOp"
    OBJECT_TYPE_GL_REFABLE = "glRefable"
    OBJECT_TYPE_GL_REFS_EP = "glRefsEp"
    OBJECT_TYPE_GL_REQUEST = "glRequest"
    OBJECT_TYPE_GL_REQUEST_FSM = "glRequestFsm"
    OBJECT_TYPE_GL_REQUEST_FSM_STAGE = "glRequestFsmStage"
    OBJECT_TYPE_GL_REQUEST_FSM_TASK = "glRequestFsmTask"
    OBJECT_TYPE_GL_REQUEST_VNET_EP = "glRequestVnetEp"
    OBJECT_TYPE_GL_REQUEST_VNET_EP_DOMAIN_EP = "glRequestVnetEpDomainEp"
    OBJECT_TYPE_GL_REQUEST_VNET_EP_DOMAIN_EP_FSM = "glRequestVnetEpDomainEpFsm"
    OBJECT_TYPE_GL_REQUEST_VNET_EP_DOMAIN_EP_FSM_STAGE = "glRequestVnetEpDomainEpFsmStage"
    OBJECT_TYPE_GL_REQUEST_VNET_EP_DOMAIN_EP_FSM_TASK = "glRequestVnetEpDomainEpFsmTask"
    OBJECT_TYPE_GL_REQUEST_VNET_EP_FSM = "glRequestVnetEpFsm"
    OBJECT_TYPE_GL_REQUEST_VNET_EP_FSM_STAGE = "glRequestVnetEpFsmStage"
    OBJECT_TYPE_GL_REQUEST_VNET_EP_FSM_TASK = "glRequestVnetEpFsmTask"
    OBJECT_TYPE_GL_REQUEST_VNET_EP_HOLDER = "glRequestVnetEpHolder"
    OBJECT_TYPE_GL_REQUESTOR = "glRequestor"
    OBJECT_TYPE_GL_REQUESTOR_EP = "glRequestorEp"
    OBJECT_TYPE_GL_SPINV_EP = "glSPInvEp"
    OBJECT_TYPE_GL_SERVER_POOL_RES_OP = "glServerPoolResOp"
    OBJECT_TYPE_GL_SERVICE_PROFILE = "glServiceProfile"
    OBJECT_TYPE_GL_SP_DEF_EP = "glSpDefEp"
    OBJECT_TYPE_GL_TEMPLATE_EP = "glTemplateEp"
    OBJECT_TYPE_GL_TEMPLATE_OP = "glTemplateOp"
    OBJECT_TYPE_GL_TEMPLATE_RES_OP = "glTemplateResOp"
    OBJECT_TYPE_GL_USAGE = "glUsage"
    OBJECT_TYPE_GL_USAGE_EP = "glUsageEp"
    OBJECT_TYPE_GL_VLAN = "glVlan"
    OBJECT_TYPE_GL_VNET_INV_HOLDER = "glVnetInvHolder"
    OBJECT_TYPE_GL_VNIC_TEMPLATE = "glVnicTemplate"
    OBJECT_TYPE_GL_VNIC_TEMPLATE_EP = "glVnicTemplateEp"
    OBJECT_TYPE_GL_VSAN = "glVsan"
    OBJECT_TYPE_GL_VXAN_EP = "glVxanEp"
    OBJECT_TYPE_GL_VXAN_OP = "glVxanOp"
    OBJECT_TYPE_GL_VXAN_RES_OP = "glVxanResOp"
    OBJECT_TYPE_GMETA_CLASS = "gmetaClass"
    OBJECT_TYPE_GMETA_POLICY_MAP_ELEMENT = "gmetaPolicyMapElement"
    OBJECT_TYPE_GMETA_PROP = "gmetaProp"
    OBJECT_TYPE_GRAPHICS_CARD = "graphicsCard"
    OBJECT_TYPE_GRAPHICS_CONTROLLER = "graphicsController"
    OBJECT_TYPE_GUI_GUI_COMPONENT = "guiGuiComponent"
    OBJECT_TYPE_GUI_GUI_CONT = "guiGuiCont"
    OBJECT_TYPE_HC_ACOMPONENT = "hcAComponent"
    OBJECT_TYPE_HC_AITEM = "hcAItem"
    OBJECT_TYPE_HC_ASTATUS_ITEM = "hcAStatusItem"
    OBJECT_TYPE_HC_ADAPTER_FIRMWARE_ITEM = "hcAdapterFirmwareItem"
    OBJECT_TYPE_HC_ADAPTER_ITEM = "hcAdapterItem"
    OBJECT_TYPE_HC_ADMIN = "hcAdmin"
    OBJECT_TYPE_HC_CATALOG = "hcCatalog"
    OBJECT_TYPE_HC_CATALOG_LIST = "hcCatalogList"
    OBJECT_TYPE_HC_CATALOG_SOURCE = "hcCatalogSource"
    OBJECT_TYPE_HC_CATALOG_VERSION = "hcCatalogVersion"
    OBJECT_TYPE_HC_CLEANUP = "hcCleanup"
    OBJECT_TYPE_HC_DOWNLOAD_POLICY = "hcDownloadPolicy"
    OBJECT_TYPE_HC_DOWNLOADER = "hcDownloader"
    OBJECT_TYPE_HC_DRIVER_INFO_ITEM = "hcDriverInfoItem"
    OBJECT_TYPE_HC_DRIVER_ITEM = "hcDriverItem"
    OBJECT_TYPE_HC_HOLDER = "hcHolder"
    OBJECT_TYPE_HC_ITEM_NOTE = "hcItemNote"
    OBJECT_TYPE_HC_OS_INFO_ITEM = "hcOsInfoItem"
    OBJECT_TYPE_HC_OS_ITEM = "hcOsItem"
    OBJECT_TYPE_HC_REPORT = "hcReport"
    OBJECT_TYPE_HC_SCOPE_DN = "hcScopeDn"
    OBJECT_TYPE_HC_SERVER_COMPONENT = "hcServerComponent"
    OBJECT_TYPE_HC_SUPPORTED_ADAPTER_FIRMWARE_ITEM = "hcSupportedAdapterFirmwareItem"
    OBJECT_TYPE_HC_SUPPORTED_ADAPTER_ITEM = "hcSupportedAdapterItem"
    OBJECT_TYPE_HC_SUPPORTED_DRIVER_ITEM = "hcSupportedDriverItem"
    OBJECT_TYPE_HC_SUPPORTED_OS_ITEM = "hcSupportedOsItem"
    OBJECT_TYPE_HC_UCS_VERSION_ITEM = "hcUcsVersionItem"
    OBJECT_TYPE_IDENT_DOMAIN_SYNC_EP = "identDomainSyncEp"
    OBJECT_TYPE_IDENT_EXECUTION_EP = "identExecutionEp"
    OBJECT_TYPE_IDENT_EXECUTION_REQUEST_EP = "identExecutionRequestEp"
    OBJECT_TYPE_IDENT_IDENT_CTX = "identIdentCtx"
    OBJECT_TYPE_IDENT_IDENT_REQUEST = "identIdentRequest"
    OBJECT_TYPE_IDENT_IDENT_REQUEST_FSM = "identIdentRequestFsm"
    OBJECT_TYPE_IDENT_IDENT_REQUEST_FSM_STAGE = "identIdentRequestFsmStage"
    OBJECT_TYPE_IDENT_IDENT_REQUEST_FSM_TASK = "identIdentRequestFsmTask"
    OBJECT_TYPE_IDENT_META_SYSTEM = "identMetaSystem"
    OBJECT_TYPE_IDENT_META_SYSTEM_FSM = "identMetaSystemFsm"
    OBJECT_TYPE_IDENT_META_SYSTEM_FSM_STAGE = "identMetaSystemFsmStage"
    OBJECT_TYPE_IDENT_META_SYSTEM_FSM_TASK = "identMetaSystemFsmTask"
    OBJECT_TYPE_IDENT_META_VERSE = "identMetaVerse"
    OBJECT_TYPE_IDENT_REQUEST_EP = "identRequestEp"
    OBJECT_TYPE_IDENT_SYS_INFO = "identSysInfo"
    OBJECT_TYPE_IDENTPOOL_BLOCK_QUAL = "identpoolBlockQual"
    OBJECT_TYPE_IDENTPOOL_CONSUMED = "identpoolConsumed"
    OBJECT_TYPE_IDENTPOOL_DOMAIN = "identpoolDomain"
    OBJECT_TYPE_IDENTPOOL_DOMAIN_GROUP_QUAL = "identpoolDomainGroupQual"
    OBJECT_TYPE_IDENTPOOL_ELEMENT = "identpoolElement"
    OBJECT_TYPE_IDENTPOOL_IPQUAL = "identpoolIPQual"
    OBJECT_TYPE_IDENTPOOL_IPV6_QUAL = "identpoolIPV6Qual"
    OBJECT_TYPE_IDENTPOOL_META_SYSTEM = "identpoolMetaSystem"
    OBJECT_TYPE_IDENTPOOL_META_VERSE = "identpoolMetaVerse"
    OBJECT_TYPE_IDENTPOOL_POOL = "identpoolPool"
    OBJECT_TYPE_IDENTPOOL_POOLABLE = "identpoolPoolable"
    OBJECT_TYPE_IDENTPOOL_QUAL_ITEM = "identpoolQualItem"
    OBJECT_TYPE_IDENTPOOL_UNIVERSE = "identpoolUniverse"
    OBJECT_TYPE_INBAND_POLICY = "inbandPolicy"
    OBJECT_TYPE_INITIATOR_EP = "initiatorEp"
    OBJECT_TYPE_INITIATOR_FC_INITIATOR_EP = "initiatorFcInitiatorEp"
    OBJECT_TYPE_INITIATOR_GROUP_EP = "initiatorGroupEp"
    OBJECT_TYPE_INITIATOR_ISCSI_INITIATOR_EP = "initiatorIScsiInitiatorEp"
    OBJECT_TYPE_INITIATOR_INITIATOR_EP = "initiatorInitiatorEp"
    OBJECT_TYPE_INITIATOR_LUN_EP = "initiatorLunEp"
    OBJECT_TYPE_INITIATOR_MEMBER_EP = "initiatorMemberEp"
    OBJECT_TYPE_INITIATOR_REQUESTOR_EP = "initiatorRequestorEp"
    OBJECT_TYPE_INITIATOR_REQUESTOR_GRP_EP = "initiatorRequestorGrpEp"
    OBJECT_TYPE_INITIATOR_STORE_EP = "initiatorStoreEp"
    OBJECT_TYPE_INITIATOR_UNIT_EP = "initiatorUnitEp"
    OBJECT_TYPE_INVENTORY_DOMAIN_EP = "inventoryDomainEp"
    OBJECT_TYPE_INVENTORY_EP = "inventoryEp"
    OBJECT_TYPE_INVENTORY_GLOBAL_EP = "inventoryGlobalEp"
    OBJECT_TYPE_INVENTORY_HOLDER = "inventoryHolder"
    OBJECT_TYPE_INVENTORY_INVENTORY_EP = "inventoryInventoryEp"
    OBJECT_TYPE_INVENTORY_INVENTORY_MO_META = "inventoryInventoryMoMeta"
    OBJECT_TYPE_IP_IPV4_DNS = "ipIPv4Dns"
    OBJECT_TYPE_IP_IP_V4_ADDR = "ipIpV4Addr"
    OBJECT_TYPE_IP_IP_V4_STATIC_ADDR = "ipIpV4StaticAddr"
    OBJECT_TYPE_IP_SERVICE_IF = "ipServiceIf"
    OBJECT_TYPE_IPPOOL_ADDR = "ippoolAddr"
    OBJECT_TYPE_IPPOOL_BLOCK = "ippoolBlock"
    OBJECT_TYPE_IPPOOL_IP_V6_ADDR = "ippoolIpV6Addr"
    OBJECT_TYPE_IPPOOL_IP_V6_BLOCK = "ippoolIpV6Block"
    OBJECT_TYPE_IPPOOL_IP_V6_POOLED = "ippoolIpV6Pooled"
    OBJECT_TYPE_IPPOOL_POOL = "ippoolPool"
    OBJECT_TYPE_IPPOOL_POOLED = "ippoolPooled"
    OBJECT_TYPE_IPPOOL_UNIVERSE = "ippoolUniverse"
    OBJECT_TYPE_IQNPOOL_ABS_BLOCK = "iqnpoolAbsBlock"
    OBJECT_TYPE_IQNPOOL_ADDR = "iqnpoolAddr"
    OBJECT_TYPE_IQNPOOL_BLOCK = "iqnpoolBlock"
    OBJECT_TYPE_IQNPOOL_FORMAT = "iqnpoolFormat"
    OBJECT_TYPE_IQNPOOL_POOL = "iqnpoolPool"
    OBJECT_TYPE_IQNPOOL_POOLED = "iqnpoolPooled"
    OBJECT_TYPE_IQNPOOL_TRANSPORT_BLOCK = "iqnpoolTransportBlock"
    OBJECT_TYPE_IQNPOOL_UNIVERSE = "iqnpoolUniverse"
    OBJECT_TYPE_ISCSI_AUTH_PROFILE = "iscsiAuthProfile"
    OBJECT_TYPE_LICENSE_CAP_PROVIDER = "licenseCapProvider"
    OBJECT_TYPE_LICENSE_CONTENTS = "licenseContents"
    OBJECT_TYPE_LICENSE_DOMAIN = "licenseDomain"
    OBJECT_TYPE_LICENSE_DOWNLOADER = "licenseDownloader"
    OBJECT_TYPE_LICENSE_DOWNLOADER_FSM = "licenseDownloaderFsm"
    OBJECT_TYPE_LICENSE_DOWNLOADER_FSM_STAGE = "licenseDownloaderFsmStage"
    OBJECT_TYPE_LICENSE_DOWNLOADER_FSM_TASK = "licenseDownloaderFsmTask"
    OBJECT_TYPE_LICENSE_EP = "licenseEp"
    OBJECT_TYPE_LICENSE_FEATURE = "licenseFeature"
    OBJECT_TYPE_LICENSE_FEATURE_CAP_PROVIDER = "licenseFeatureCapProvider"
    OBJECT_TYPE_LICENSE_FEATURE_LINE = "licenseFeatureLine"
    OBJECT_TYPE_LICENSE_FILE = "licenseFile"
    OBJECT_TYPE_LICENSE_FILE_FSM = "licenseFileFsm"
    OBJECT_TYPE_LICENSE_FILE_FSM_STAGE = "licenseFileFsmStage"
    OBJECT_TYPE_LICENSE_FILE_FSM_TASK = "licenseFileFsmTask"
    OBJECT_TYPE_LICENSE_INSTANCE = "licenseInstance"
    OBJECT_TYPE_LICENSE_INSTANCE_FSM = "licenseInstanceFsm"
    OBJECT_TYPE_LICENSE_INSTANCE_FSM_STAGE = "licenseInstanceFsmStage"
    OBJECT_TYPE_LICENSE_INSTANCE_FSM_TASK = "licenseInstanceFsmTask"
    OBJECT_TYPE_LICENSE_LICENSE = "licenseLicense"
    OBJECT_TYPE_LICENSE_PROP = "licenseProp"
    OBJECT_TYPE_LICENSE_SERVER_HOST_ID = "licenseServerHostId"
    OBJECT_TYPE_LICENSE_SOURCE = "licenseSource"
    OBJECT_TYPE_LICENSE_SOURCE_FILE = "licenseSourceFile"
    OBJECT_TYPE_LS_BINDING = "lsBinding"
    OBJECT_TYPE_LS_COMPUTE_BINDING = "lsComputeBinding"
    OBJECT_TYPE_LS_FC_LOCALE = "lsFcLocale"
    OBJECT_TYPE_LS_FC_ZONE = "lsFcZone"
    OBJECT_TYPE_LS_FC_ZONE_GROUP = "lsFcZoneGroup"
    OBJECT_TYPE_LS_FC_ZONE_MEMBER = "lsFcZoneMember"
    OBJECT_TYPE_LS_IDENTITY_INFO = "lsIdentityInfo"
    OBJECT_TYPE_LS_ISSUES = "lsIssues"
    OBJECT_TYPE_LS_POWER = "lsPower"
    OBJECT_TYPE_LS_REQUIREMENT = "lsRequirement"
    OBJECT_TYPE_LS_SPMETA = "lsSPMeta"
    OBJECT_TYPE_LS_SERVER = "lsServer"
    OBJECT_TYPE_LS_SERVER_ASSOC_CTX = "lsServerAssocCtx"
    OBJECT_TYPE_LS_SERVER_EXTENSION = "lsServerExtension"
    OBJECT_TYPE_LS_SERVER_FSM = "lsServerFsm"
    OBJECT_TYPE_LS_SERVER_FSM_STAGE = "lsServerFsmStage"
    OBJECT_TYPE_LS_SERVER_FSM_TASK = "lsServerFsmTask"
    OBJECT_TYPE_LS_SERVER_OPERATION = "lsServerOperation"
    OBJECT_TYPE_LS_TIER = "lsTier"
    OBJECT_TYPE_LS_VCON_ASSIGN = "lsVConAssign"
    OBJECT_TYPE_LS_WAITING_USER_ACK = "lsWaitingUserAck"
    OBJECT_TYPE_LS_ZONE_INITIATOR_MEMBER = "lsZoneInitiatorMember"
    OBJECT_TYPE_LS_ZONE_TARGET_MEMBER = "lsZoneTargetMember"
    OBJECT_TYPE_LSBOOT_ADEF = "lsbootADef"
    OBJECT_TYPE_LSBOOT_BOOT_SECURITY = "lsbootBootSecurity"
    OBJECT_TYPE_LSBOOT_CATEGORY = "lsbootCategory"
    OBJECT_TYPE_LSBOOT_DEF = "lsbootDef"
    OBJECT_TYPE_LSBOOT_DEFAULT_LOCAL_IMAGE = "lsbootDefaultLocalImage"
    OBJECT_TYPE_LSBOOT_EFISHELL = "lsbootEFIShell"
    OBJECT_TYPE_LSBOOT_EMBEDDED_LOCAL_DISK_IMAGE = "lsbootEmbeddedLocalDiskImage"
    OBJECT_TYPE_LSBOOT_EMBEDDED_LOCAL_DISK_IMAGE_PATH = "lsbootEmbeddedLocalDiskImagePath"
    OBJECT_TYPE_LSBOOT_EMBEDDED_LOCAL_LUN_IMAGE = "lsbootEmbeddedLocalLunImage"
    OBJECT_TYPE_LSBOOT_ISCSI = "lsbootIScsi"
    OBJECT_TYPE_LSBOOT_ISCSI_IMAGE_PATH = "lsbootIScsiImagePath"
    OBJECT_TYPE_LSBOOT_IMAGE = "lsbootImage"
    OBJECT_TYPE_LSBOOT_IMAGE_PATH = "lsbootImagePath"
    OBJECT_TYPE_LSBOOT_ITEM = "lsbootItem"
    OBJECT_TYPE_LSBOOT_LAN = "lsbootLan"
    OBJECT_TYPE_LSBOOT_LAN_IMAGE_PATH = "lsbootLanImagePath"
    OBJECT_TYPE_LSBOOT_LOCAL_DISK_IMAGE = "lsbootLocalDiskImage"
    OBJECT_TYPE_LSBOOT_LOCAL_DISK_IMAGE_PATH = "lsbootLocalDiskImagePath"
    OBJECT_TYPE_LSBOOT_LOCAL_HDD_IMAGE = "lsbootLocalHddImage"
    OBJECT_TYPE_LSBOOT_LOCAL_IMAGE = "lsbootLocalImage"
    OBJECT_TYPE_LSBOOT_LOCAL_LUN_IMAGE_PATH = "lsbootLocalLunImagePath"
    OBJECT_TYPE_LSBOOT_LOCAL_MEDIA_ITEM = "lsbootLocalMediaItem"
    OBJECT_TYPE_LSBOOT_LOCAL_STORAGE = "lsbootLocalStorage"
    OBJECT_TYPE_LSBOOT_NVME = "lsbootNvme"
    OBJECT_TYPE_LSBOOT_NVME_DEVICE = "lsbootNvmeDevice"
    OBJECT_TYPE_LSBOOT_NVME_DISK_SSD = "lsbootNvmeDiskSsd"
    OBJECT_TYPE_LSBOOT_NVME_PCI_SSD = "lsbootNvmePciSsd"
    OBJECT_TYPE_LSBOOT_POLICY = "lsbootPolicy"
    OBJECT_TYPE_LSBOOT_REMOTE_IMAGE = "lsbootRemoteImage"
    OBJECT_TYPE_LSBOOT_SAN = "lsbootSan"
    OBJECT_TYPE_LSBOOT_SAN_CAT_SAN_IMAGE = "lsbootSanCatSanImage"
    OBJECT_TYPE_LSBOOT_SAN_CAT_SAN_IMAGE_PATH = "lsbootSanCatSanImagePath"
    OBJECT_TYPE_LSBOOT_SAN_IMAGE = "lsbootSanImage"
    OBJECT_TYPE_LSBOOT_SAN_IMAGE_PATH = "lsbootSanImagePath"
    OBJECT_TYPE_LSBOOT_STORAGE = "lsbootStorage"
    OBJECT_TYPE_LSBOOT_UEFIBOOT_PARAM = "lsbootUEFIBootParam"
    OBJECT_TYPE_LSBOOT_UPGRADE_STATUS = "lsbootUpgradeStatus"
    OBJECT_TYPE_LSBOOT_USB_EXTERNAL_IMAGE = "lsbootUsbExternalImage"
    OBJECT_TYPE_LSBOOT_USB_FLASH_STORAGE_IMAGE = "lsbootUsbFlashStorageImage"
    OBJECT_TYPE_LSBOOT_USB_INTERNAL_IMAGE = "lsbootUsbInternalImage"
    OBJECT_TYPE_LSBOOT_VIRTUAL_MEDIA = "lsbootVirtualMedia"
    OBJECT_TYPE_LSMAINT_ACK = "lsmaintAck"
    OBJECT_TYPE_LSMAINT_MAINT_POLICY = "lsmaintMaintPolicy"
    OBJECT_TYPE_LSTORAGE_ASLOT = "lstorageASlot"
    OBJECT_TYPE_LSTORAGE_ACK = "lstorageAck"
    OBJECT_TYPE_LSTORAGE_ARRAY_REQUIREMENT = "lstorageArrayRequirement"
    OBJECT_TYPE_LSTORAGE_BLADE = "lstorageBlade"
    OBJECT_TYPE_LSTORAGE_CONTROLLER_DEF = "lstorageControllerDef"
    OBJECT_TYPE_LSTORAGE_CONTROLLER_MODE_CONFIG = "lstorageControllerModeConfig"
    OBJECT_TYPE_LSTORAGE_CONTROLLER_QUALIFIER = "lstorageControllerQualifier"
    OBJECT_TYPE_LSTORAGE_CONTROLLER_REF = "lstorageControllerRef"
    OBJECT_TYPE_LSTORAGE_CTRL_SERVICE_OPERATION = "lstorageCtrlServiceOperation"
    OBJECT_TYPE_LSTORAGE_DAS_SCSI_LUN = "lstorageDasScsiLun"
    OBJECT_TYPE_LSTORAGE_DISK_GROUP_CONFIG = "lstorageDiskGroupConfig"
    OBJECT_TYPE_LSTORAGE_DISK_GROUP_CONFIG_DEF = "lstorageDiskGroupConfigDef"
    OBJECT_TYPE_LSTORAGE_DISK_GROUP_CONFIG_POLICY = "lstorageDiskGroupConfigPolicy"
    OBJECT_TYPE_LSTORAGE_DISK_GROUP_QUALIFIER = "lstorageDiskGroupQualifier"
    OBJECT_TYPE_LSTORAGE_DISK_SLOT = "lstorageDiskSlot"
    OBJECT_TYPE_LSTORAGE_DISK_ZONING_CONFIG = "lstorageDiskZoningConfig"
    OBJECT_TYPE_LSTORAGE_DISK_ZONING_CONFIG_DEF = "lstorageDiskZoningConfigDef"
    OBJECT_TYPE_LSTORAGE_DISK_ZONING_POLICY = "lstorageDiskZoningPolicy"
    OBJECT_TYPE_LSTORAGE_DRIVE_SECURITY = "lstorageDriveSecurity"
    OBJECT_TYPE_LSTORAGE_EXTENSION = "lstorageExtension"
    OBJECT_TYPE_LSTORAGE_ITEM = "lstorageItem"
    OBJECT_TYPE_LSTORAGE_LOCAL = "lstorageLocal"
    OBJECT_TYPE_LSTORAGE_LOCAL_CONFIG = "lstorageLocalConfig"
    OBJECT_TYPE_LSTORAGE_LOCAL_DEF = "lstorageLocalDef"
    OBJECT_TYPE_LSTORAGE_LOCAL_DISK_CONFIG_REF = "lstorageLocalDiskConfigRef"
    OBJECT_TYPE_LSTORAGE_LOCAL_DISK_REF = "lstorageLocalDiskRef"
    OBJECT_TYPE_LSTORAGE_LOGIN = "lstorageLogin"
    OBJECT_TYPE_LSTORAGE_META = "lstorageMeta"
    OBJECT_TYPE_LSTORAGE_PROCESSOR_BASE = "lstorageProcessorBase"
    OBJECT_TYPE_LSTORAGE_PROFILE = "lstorageProfile"
    OBJECT_TYPE_LSTORAGE_PROFILE_BASE = "lstorageProfileBase"
    OBJECT_TYPE_LSTORAGE_PROFILE_BINDING = "lstorageProfileBinding"
    OBJECT_TYPE_LSTORAGE_PROFILE_BINDING_BASE = "lstorageProfileBindingBase"
    OBJECT_TYPE_LSTORAGE_PROFILE_DEF = "lstorageProfileDef"
    OBJECT_TYPE_LSTORAGE_QUAL_ITEM = "lstorageQualItem"
    OBJECT_TYPE_LSTORAGE_RECURR_WINDOW = "lstorageRecurrWindow"
    OBJECT_TYPE_LSTORAGE_REMOTE = "lstorageRemote"
    OBJECT_TYPE_LSTORAGE_REMOTE_CONFIG = "lstorageRemoteConfig"
    OBJECT_TYPE_LSTORAGE_REMOTE_DEF = "lstorageRemoteDef"
    OBJECT_TYPE_LSTORAGE_REQUEST_CTX = "lstorageRequestCtx"
    OBJECT_TYPE_LSTORAGE_SCSI_LUN = "lstorageScsiLun"
    OBJECT_TYPE_LSTORAGE_SECURITY = "lstorageSecurity"
    OBJECT_TYPE_LSTORAGE_VIRTUAL_DRIVE_DEF = "lstorageVirtualDriveDef"
    OBJECT_TYPE_MACPOOL_ADDR = "macpoolAddr"
    OBJECT_TYPE_MACPOOL_BLOCK = "macpoolBlock"
    OBJECT_TYPE_MACPOOL_FORMAT = "macpoolFormat"
    OBJECT_TYPE_MACPOOL_POOL = "macpoolPool"
    OBJECT_TYPE_MACPOOL_POOLED = "macpoolPooled"
    OBJECT_TYPE_MACPOOL_UNIVERSE = "macpoolUniverse"
    OBJECT_TYPE_MEMORY_ARRAY = "memoryArray"
    OBJECT_TYPE_MEMORY_ARRAY_ENV_STATS = "memoryArrayEnvStats"
    OBJECT_TYPE_MEMORY_ARRAY_ENV_STATS_HIST = "memoryArrayEnvStatsHist"
    OBJECT_TYPE_MEMORY_BUFFER_UNIT = "memoryBufferUnit"
    OBJECT_TYPE_MEMORY_BUFFER_UNIT_ENV_STATS = "memoryBufferUnitEnvStats"
    OBJECT_TYPE_MEMORY_BUFFER_UNIT_ENV_STATS_HIST = "memoryBufferUnitEnvStatsHist"
    OBJECT_TYPE_MEMORY_CONTROLLER = "memoryController"
    OBJECT_TYPE_MEMORY_ERROR_STATS = "memoryErrorStats"
    OBJECT_TYPE_MEMORY_ERROR_STATS_HIST = "memoryErrorStatsHist"
    OBJECT_TYPE_MEMORY_NV_DIMM = "memoryNvDimm"
    OBJECT_TYPE_MEMORY_NV_DIMM_BATTERY = "memoryNvDimmBattery"
    OBJECT_TYPE_MEMORY_NV_DIMM_CONTROLLER = "memoryNvDimmController"
    OBJECT_TYPE_MEMORY_QUAL = "memoryQual"
    OBJECT_TYPE_MEMORY_RUNTIME = "memoryRuntime"
    OBJECT_TYPE_MEMORY_RUNTIME_HIST = "memoryRuntimeHist"
    OBJECT_TYPE_MEMORY_UNIT = "memoryUnit"
    OBJECT_TYPE_MEMORY_UNIT_ENV_STATS = "memoryUnitEnvStats"
    OBJECT_TYPE_MEMORY_UNIT_ENV_STATS_HIST = "memoryUnitEnvStatsHist"
    OBJECT_TYPE_MESSAGE_ENTRY = "messageEntry"
    OBJECT_TYPE_MESSAGE_EP = "messageEp"
    OBJECT_TYPE_MGMT_AKMIP_CERT_POLICY = "mgmtAKmipCertPolicy"
    OBJECT_TYPE_MGMT_ASECURE_BOOT = "mgmtASecureBoot"
    OBJECT_TYPE_MGMT_ABS_BACKUP = "mgmtAbsBackup"
    OBJECT_TYPE_MGMT_ABS_DATA_ITEM = "mgmtAbsDataItem"
    OBJECT_TYPE_MGMT_ABS_IMPORTER = "mgmtAbsImporter"
    OBJECT_TYPE_MGMT_BACKUP = "mgmtBackup"
    OBJECT_TYPE_MGMT_BACKUP_FSM = "mgmtBackupFsm"
    OBJECT_TYPE_MGMT_BACKUP_FSM_STAGE = "mgmtBackupFsmStage"
    OBJECT_TYPE_MGMT_BACKUP_FSM_TASK = "mgmtBackupFsmTask"
    OBJECT_TYPE_MGMT_BACKUP_OPERATION = "mgmtBackupOperation"
    OBJECT_TYPE_MGMT_BACKUP_POLICY = "mgmtBackupPolicy"
    OBJECT_TYPE_MGMT_BACKUP_TRIGGER = "mgmtBackupTrigger"
    OBJECT_TYPE_MGMT_BACKUP_TRIGGER_FSM = "mgmtBackupTriggerFsm"
    OBJECT_TYPE_MGMT_BACKUP_TRIGGER_FSM_STAGE = "mgmtBackupTriggerFsmStage"
    OBJECT_TYPE_MGMT_BACKUP_TRIGGER_FSM_TASK = "mgmtBackupTriggerFsmTask"
    OBJECT_TYPE_MGMT_CFG_EXPORT_POLICY = "mgmtCfgExportPolicy"
    OBJECT_TYPE_MGMT_CIMC_INTERFACE = "mgmtCimcInterface"
    OBJECT_TYPE_MGMT_CMC_SECURE_BOOT = "mgmtCmcSecureBoot"
    OBJECT_TYPE_MGMT_CMC_SECURE_BOOT_OPERATION = "mgmtCmcSecureBootOperation"
    OBJECT_TYPE_MGMT_CONNECTION = "mgmtConnection"
    OBJECT_TYPE_MGMT_CONTROLLER = "mgmtController"
    OBJECT_TYPE_MGMT_DATA_EXPORTER = "mgmtDataExporter"
    OBJECT_TYPE_MGMT_DATA_EXPORTER_FSM = "mgmtDataExporterFsm"
    OBJECT_TYPE_MGMT_DATA_EXPORTER_FSM_STAGE = "mgmtDataExporterFsmStage"
    OBJECT_TYPE_MGMT_DATA_EXPORTER_FSM_TASK = "mgmtDataExporterFsmTask"
    OBJECT_TYPE_MGMT_DATA_IMPORTER = "mgmtDataImporter"
    OBJECT_TYPE_MGMT_DATA_IMPORTER_FSM = "mgmtDataImporterFsm"
    OBJECT_TYPE_MGMT_DATA_IMPORTER_FSM_STAGE = "mgmtDataImporterFsmStage"
    OBJECT_TYPE_MGMT_DATA_IMPORTER_FSM_TASK = "mgmtDataImporterFsmTask"
    OBJECT_TYPE_MGMT_DATA_ITEM = "mgmtDataItem"
    OBJECT_TYPE_MGMT_ENTITY = "mgmtEntity"
    OBJECT_TYPE_MGMT_EP = "mgmtEp"
    OBJECT_TYPE_MGMT_EXPORT_POLICY = "mgmtExportPolicy"
    OBJECT_TYPE_MGMT_IPV6_ADDR = "mgmtIPv6Addr"
    OBJECT_TYPE_MGMT_IPV6_IF_ADDR = "mgmtIPv6IfAddr"
    OBJECT_TYPE_MGMT_IPV6_IF_CONFIG = "mgmtIPv6IfConfig"
    OBJECT_TYPE_MGMT_IF = "mgmtIf"
    OBJECT_TYPE_MGMT_IF_FSM = "mgmtIfFsm"
    OBJECT_TYPE_MGMT_IF_FSM_STAGE = "mgmtIfFsmStage"
    OBJECT_TYPE_MGMT_IF_FSM_TASK = "mgmtIfFsmTask"
    OBJECT_TYPE_MGMT_IMPORT_ITEM = "mgmtImportItem"
    OBJECT_TYPE_MGMT_IMPORTER = "mgmtImporter"
    OBJECT_TYPE_MGMT_IMPORTER_FSM = "mgmtImporterFsm"
    OBJECT_TYPE_MGMT_IMPORTER_FSM_STAGE = "mgmtImporterFsmStage"
    OBJECT_TYPE_MGMT_IMPORTER_FSM_TASK = "mgmtImporterFsmTask"
    OBJECT_TYPE_MGMT_INBAND_PROFILE = "mgmtInbandProfile"
    OBJECT_TYPE_MGMT_INTERFACE = "mgmtInterface"
    OBJECT_TYPE_MGMT_KMIP = "mgmtKmip"
    OBJECT_TYPE_MGMT_KMIP_CERT_POLICY = "mgmtKmipCertPolicy"
    OBJECT_TYPE_MGMT_KMIP_OPERATION = "mgmtKmipOperation"
    OBJECT_TYPE_MGMT_NAMED_KMIP_CERT_POLICY = "mgmtNamedKmipCertPolicy"
    OBJECT_TYPE_MGMT_REGISTRY_INFO = "mgmtRegistryInfo"
    OBJECT_TYPE_MGMT_REGISTRY_INFO_FSM = "mgmtRegistryInfoFsm"
    OBJECT_TYPE_MGMT_REGISTRY_INFO_FSM_STAGE = "mgmtRegistryInfoFsmStage"
    OBJECT_TYPE_MGMT_REGISTRY_INFO_FSM_TASK = "mgmtRegistryInfoFsmTask"
    OBJECT_TYPE_MGMT_SECURITY = "mgmtSecurity"
    OBJECT_TYPE_MGMT_SVC = "mgmtSvc"
    OBJECT_TYPE_MGMT_VNET = "mgmtVnet"
    OBJECT_TYPE_MO_TOP_PROPS = "moTopProps"
    OBJECT_TYPE_NAMING_BINDING = "namingBinding"
    OBJECT_TYPE_NAMING_DEFINITION = "namingDefinition"
    OBJECT_TYPE_NAMING_HOLDER = "namingHolder"
    OBJECT_TYPE_NAMING_NAMED_IDENTIFIED_OBJECT = "namingNamedIdentifiedObject"
    OBJECT_TYPE_NAMING_NAMED_OBJECT = "namingNamedObject"
    OBJECT_TYPE_NAMING_OBJECT = "namingObject"
    OBJECT_TYPE_NET_NET_GROUP_PERMIT = "netNetGroupPermit"
    OBJECT_TYPE_NETWORK_CACERT = "networkCACert"
    OBJECT_TYPE_NETWORK_CIO_EP = "networkCIoEp"
    OBJECT_TYPE_NETWORK_CONN = "networkConn"
    OBJECT_TYPE_NETWORK_ELEMENT = "networkElement"
    OBJECT_TYPE_NETWORK_ELEMENT_FSM = "networkElementFsm"
    OBJECT_TYPE_NETWORK_ELEMENT_FSM_STAGE = "networkElementFsmStage"
    OBJECT_TYPE_NETWORK_ELEMENT_FSM_TASK = "networkElementFsmTask"
    OBJECT_TYPE_NETWORK_ELEMENT_OPERATION = "networkElementOperation"
    OBJECT_TYPE_NETWORK_EP = "networkEp"
    OBJECT_TYPE_NETWORK_IF_EP = "networkIfEp"
    OBJECT_TYPE_NETWORK_PIO_EP = "networkPIoEp"
    OBJECT_TYPE_NETWORK_PHYS_EP = "networkPhysEp"
    OBJECT_TYPE_NETWORK_SYSTEM_CACERT = "networkSystemCACert"
    OBJECT_TYPE_NETWORK_VNET_EP = "networkVnetEp"
    OBJECT_TYPE_NFS_CLIENT_DEF = "nfsClientDef"
    OBJECT_TYPE_NFS_CLIENT_DEF_FSM = "nfsClientDefFsm"
    OBJECT_TYPE_NFS_CLIENT_DEF_FSM_STAGE = "nfsClientDefFsmStage"
    OBJECT_TYPE_NFS_CLIENT_DEF_FSM_TASK = "nfsClientDefFsmTask"
    OBJECT_TYPE_NFS_EP = "nfsEp"
    OBJECT_TYPE_NFS_EXPORT_DEF = "nfsExportDef"
    OBJECT_TYPE_NFS_EXPORT_DEF_FSM = "nfsExportDefFsm"
    OBJECT_TYPE_NFS_EXPORT_DEF_FSM_STAGE = "nfsExportDefFsmStage"
    OBJECT_TYPE_NFS_EXPORT_DEF_FSM_TASK = "nfsExportDefFsmTask"
    OBJECT_TYPE_NFS_MOUNT_DEF = "nfsMountDef"
    OBJECT_TYPE_NFS_REPOSITORY_SPEC_POLICY = "nfsRepositorySpecPolicy"
    OBJECT_TYPE_NWCTRL_DEFINITION = "nwctrlDefinition"
    OBJECT_TYPE_OBSERVE_FILTER = "observeFilter"
    OBJECT_TYPE_OBSERVE_OBSERVED = "observeObserved"
    OBJECT_TYPE_OBSERVE_OBSERVED_CONT = "observeObservedCont"
    OBJECT_TYPE_OBSERVE_OBSERVED_FSM = "observeObservedFsm"
    OBJECT_TYPE_OBSERVE_OBSERVED_FSM_STAGE = "observeObservedFsmStage"
    OBJECT_TYPE_OBSERVE_OBSERVED_FSM_TASK = "observeObservedFsmTask"
    OBJECT_TYPE_ORG_AORG = "orgAOrg"
    OBJECT_TYPE_ORG_DOMAIN_FIRMWARE_INFO = "orgDomainFirmwareInfo"
    OBJECT_TYPE_ORG_DOMAIN_GROUP = "orgDomainGroup"
    OBJECT_TYPE_ORG_DOMAIN_GROUP_FIRMWARE_REPORT = "orgDomainGroupFirmwareReport"
    OBJECT_TYPE_ORG_DOMAIN_GROUP_POLICY = "orgDomainGroupPolicy"
    OBJECT_TYPE_ORG_DOMAIN_GROUP_POLICY_REPORT = "orgDomainGroupPolicyReport"
    OBJECT_TYPE_ORG_DOMAIN_GROUP_REPORT = "orgDomainGroupReport"
    OBJECT_TYPE_ORG_EXTENSION = "orgExtension"
    OBJECT_TYPE_ORG_FIRMWARE_VERSION_COUNT = "orgFirmwareVersionCount"
    OBJECT_TYPE_ORG_MAINT_TAG_FIRMWARE_REPORT = "orgMaintTagFirmwareReport"
    OBJECT_TYPE_ORG_ORG = "orgOrg"
    OBJECT_TYPE_ORG_ORG_FSM = "orgOrgFsm"
    OBJECT_TYPE_ORG_ORG_FSM_STAGE = "orgOrgFsmStage"
    OBJECT_TYPE_ORG_ORG_FSM_TASK = "orgOrgFsmTask"
    OBJECT_TYPE_ORG_ORG_SOURCE = "orgOrgSource"
    OBJECT_TYPE_ORG_SOURCE_MASK = "orgSourceMask"
    OBJECT_TYPE_OS_CONTROLLER = "osController"
    OBJECT_TYPE_OS_ETH_BOND_INTF = "osEthBondIntf"
    OBJECT_TYPE_OS_ETH_BOND_MODE = "osEthBondMode"
    OBJECT_TYPE_OS_ETH_INTF = "osEthIntf"
    OBJECT_TYPE_OS_INSTANCE = "osInstance"
    OBJECT_TYPE_OS_INTF = "osIntf"
    OBJECT_TYPE_OS_LINK_MONITORING_POLICY = "osLinkMonitoringPolicy"
    OBJECT_TYPE_OS_PRIMARY_SLAVE = "osPrimarySlave"
    OBJECT_TYPE_PCI_CARD = "pciCard"
    OBJECT_TYPE_PKI_CERT_REQ = "pkiCertReq"
    OBJECT_TYPE_PKI_DEFINITION = "pkiDefinition"
    OBJECT_TYPE_PKI_EP = "pkiEp"
    OBJECT_TYPE_PKI_EP_FSM = "pkiEpFsm"
    OBJECT_TYPE_PKI_EP_FSM_STAGE = "pkiEpFsmStage"
    OBJECT_TYPE_PKI_EP_FSM_TASK = "pkiEpFsmTask"
    OBJECT_TYPE_PKI_ITEM = "pkiItem"
    OBJECT_TYPE_PKI_KEY_RING = "pkiKeyRing"
    OBJECT_TYPE_PKI_TP = "pkiTP"
    OBJECT_TYPE_POLICY_ADEST_EP = "policyADestEp"
    OBJECT_TYPE_POLICY_ACK_SUSPEND_OPERATION = "policyAckSuspendOperation"
    OBJECT_TYPE_POLICY_BINDING = "policyBinding"
    OBJECT_TYPE_POLICY_CHILD_CLASS = "policyChildClass"
    OBJECT_TYPE_POLICY_CLUSTER = "policyCluster"
    OBJECT_TYPE_POLICY_COMMUNICATION = "policyCommunication"
    OBJECT_TYPE_POLICY_COMMUNICATION_OP = "policyCommunicationOp"
    OBJECT_TYPE_POLICY_CONFIG_BACKUP = "policyConfigBackup"
    OBJECT_TYPE_POLICY_CONFIG_BACKUP_OP = "policyConfigBackupOp"
    OBJECT_TYPE_POLICY_CONFIG_ERROR = "policyConfigError"
    OBJECT_TYPE_POLICY_CONTEXT = "policyContext"
    OBJECT_TYPE_POLICY_CONTROL = "policyControl"
    OBJECT_TYPE_POLICY_CONTROL_EP = "policyControlEp"
    OBJECT_TYPE_POLICY_CONTROL_EP_OP = "policyControlEpOp"
    OBJECT_TYPE_POLICY_CONTROL_EP_OP_FSM = "policyControlEpOpFsm"
    OBJECT_TYPE_POLICY_CONTROL_EP_OP_FSM_STAGE = "policyControlEpOpFsmStage"
    OBJECT_TYPE_POLICY_CONTROL_EP_OP_FSM_TASK = "policyControlEpOpFsmTask"
    OBJECT_TYPE_POLICY_CONTROL_EP_OPERATION = "policyControlEpOperation"
    OBJECT_TYPE_POLICY_CONTROL_OP = "policyControlOp"
    OBJECT_TYPE_POLICY_CONTROLLED = "policyControlled"
    OBJECT_TYPE_POLICY_CONTROLLED_INSTANCE = "policyControlledInstance"
    OBJECT_TYPE_POLICY_CONTROLLED_TYPE = "policyControlledType"
    OBJECT_TYPE_POLICY_DATE_TIME = "policyDateTime"
    OBJECT_TYPE_POLICY_DATE_TIME_OP = "policyDateTimeOp"
    OBJECT_TYPE_POLICY_DEFINITION = "policyDefinition"
    OBJECT_TYPE_POLICY_DEST_CLASS = "policyDestClass"
    OBJECT_TYPE_POLICY_DEST_EP = "policyDestEp"
    OBJECT_TYPE_POLICY_DEVICE_PROFILE = "policyDeviceProfile"
    OBJECT_TYPE_POLICY_DIGEST = "policyDigest"
    OBJECT_TYPE_POLICY_DISCOVERY = "policyDiscovery"
    OBJECT_TYPE_POLICY_DISCOVERY_OP = "policyDiscoveryOp"
    OBJECT_TYPE_POLICY_DNS = "policyDns"
    OBJECT_TYPE_POLICY_DNS_OP = "policyDnsOp"
    OBJECT_TYPE_POLICY_ELEMENT = "policyElement"
    OBJECT_TYPE_POLICY_EQUIPMENT = "policyEquipment"
    OBJECT_TYPE_POLICY_EQUIPMENT_OP = "policyEquipmentOp"
    OBJECT_TYPE_POLICY_FAULT = "policyFault"
    OBJECT_TYPE_POLICY_FAULT_OP = "policyFaultOp"
    OBJECT_TYPE_POLICY_IDENTIFIER_POLICY = "policyIdentifierPolicy"
    OBJECT_TYPE_POLICY_INFRA_FIRMWARE = "policyInfraFirmware"
    OBJECT_TYPE_POLICY_INFRA_FIRMWARE_OP = "policyInfraFirmwareOp"
    OBJECT_TYPE_POLICY_ITEM = "policyItem"
    OBJECT_TYPE_POLICY_LOCAL_MAP = "policyLocalMap"
    OBJECT_TYPE_POLICY_LOG_PROFILE = "policyLogProfile"
    OBJECT_TYPE_POLICY_MEP = "policyMEp"
    OBJECT_TYPE_POLICY_MEP_OP = "policyMEpOp"
    OBJECT_TYPE_POLICY_MONITORING = "policyMonitoring"
    OBJECT_TYPE_POLICY_MONITORING_OP = "policyMonitoringOp"
    OBJECT_TYPE_POLICY_OBJECT = "policyObject"
    OBJECT_TYPE_POLICY_POLICY_DEST_CLASS = "policyPolicyDestClass"
    OBJECT_TYPE_POLICY_POLICY_EP = "policyPolicyEp"
    OBJECT_TYPE_POLICY_POLICY_REQUESTOR = "policyPolicyRequestor"
    OBJECT_TYPE_POLICY_POLICY_SCOPE = "policyPolicyScope"
    OBJECT_TYPE_POLICY_POLICY_SCOPE_CONT = "policyPolicyScopeCont"
    OBJECT_TYPE_POLICY_POLICY_SCOPE_CONTEXT = "policyPolicyScopeContext"
    OBJECT_TYPE_POLICY_POLICY_SCOPE_FSM = "policyPolicyScopeFsm"
    OBJECT_TYPE_POLICY_POLICY_SCOPE_FSM_STAGE = "policyPolicyScopeFsmStage"
    OBJECT_TYPE_POLICY_POLICY_SCOPE_FSM_TASK = "policyPolicyScopeFsmTask"
    OBJECT_TYPE_POLICY_PORT_CONFIG = "policyPortConfig"
    OBJECT_TYPE_POLICY_PORT_CONFIG_OP = "policyPortConfigOp"
    OBJECT_TYPE_POLICY_POWER_MGMT = "policyPowerMgmt"
    OBJECT_TYPE_POLICY_POWER_MGMT_OP = "policyPowerMgmtOp"
    OBJECT_TYPE_POLICY_PROXY_MO = "policyProxyMo"
    OBJECT_TYPE_POLICY_PSU = "policyPsu"
    OBJECT_TYPE_POLICY_PSU_OP = "policyPsuOp"
    OBJECT_TYPE_POLICY_REQUESTOR = "policyRequestor"
    OBJECT_TYPE_POLICY_SCOPE = "policyScope"
    OBJECT_TYPE_POLICY_SECURITY = "policySecurity"
    OBJECT_TYPE_POLICY_SECURITY_OP = "policySecurityOp"
    OBJECT_TYPE_POLICY_SOURCE = "policySource"
    OBJECT_TYPE_POLICY_SOURCE_APP = "policySourceApp"
    OBJECT_TYPE_POLICY_STORAGE_AUTO_CONFIG = "policyStorageAutoConfig"
    OBJECT_TYPE_POLICY_STORAGE_AUTO_CONFIG_OP = "policyStorageAutoConfigOp"
    OBJECT_TYPE_POLICY_SYSTEM_EP = "policySystemEp"
    OBJECT_TYPE_POLICY_SYSTEM_PROFILE = "policySystemProfile"
    OBJECT_TYPE_POLICY_TRACKED = "policyTracked"
    OBJECT_TYPE_POLICY_TRACKER = "policyTracker"
    OBJECT_TYPE_POLICY_UNIVERSE = "policyUniverse"
    OBJECT_TYPE_POOL_ASNMT = "poolAsnmt"
    OBJECT_TYPE_POOL_ELEMENT = "poolElement"
    OBJECT_TYPE_POOL_ELEMENT_ALLOC = "poolElementAlloc"
    OBJECT_TYPE_POOL_MEMBER = "poolMember"
    OBJECT_TYPE_POOL_POOL = "poolPool"
    OBJECT_TYPE_POOL_POOL_MEMBER = "poolPoolMember"
    OBJECT_TYPE_POOL_POOLABLE = "poolPoolable"
    OBJECT_TYPE_POOL_UNIVERSE = "poolUniverse"
    OBJECT_TYPE_PORT_GROUP = "portGroup"
    OBJECT_TYPE_PORT_INT_FIO = "portIntFIo"
    OBJECT_TYPE_PORT_PIO = "portPIo"
    OBJECT_TYPE_PORT_PHYS_SWITCH_IO = "portPhysSwitchIo"
    OBJECT_TYPE_PORT_SERVER_INT_FIO = "portServerIntFIo"
    OBJECT_TYPE_PORT_SUB_GROUP = "portSubGroup"
    OBJECT_TYPE_PORT_SWITCH_INT_FIO = "portSwitchIntFIo"
    OBJECT_TYPE_POWER_ABUDGET = "powerABudget"
    OBJECT_TYPE_POWER_AGROUP = "powerAGroup"
    OBJECT_TYPE_POWER_BUDGET = "powerBudget"
    OBJECT_TYPE_POWER_CHASSIS_MEMBER = "powerChassisMember"
    OBJECT_TYPE_POWER_EP = "powerEp"
    OBJECT_TYPE_POWER_GROUP = "powerGroup"
    OBJECT_TYPE_POWER_GROUP_MEMBER = "powerGroupMember"
    OBJECT_TYPE_POWER_GROUP_QUAL = "powerGroupQual"
    OBJECT_TYPE_POWER_GROUP_STATS = "powerGroupStats"
    OBJECT_TYPE_POWER_GROUP_STATS_HIST = "powerGroupStatsHist"
    OBJECT_TYPE_POWER_MGMT_POLICY = "powerMgmtPolicy"
    OBJECT_TYPE_POWER_POLICY = "powerPolicy"
    OBJECT_TYPE_POWER_PROFILED_POWER = "powerProfiledPower"
    OBJECT_TYPE_PROC_DOER = "procDoer"
    OBJECT_TYPE_PROC_MANAGER = "procManager"
    OBJECT_TYPE_PROC_PROC_COUNTS = "procProcCounts"
    OBJECT_TYPE_PROC_PROCS = "procProcs"
    OBJECT_TYPE_PROC_PRT = "procPrt"
    OBJECT_TYPE_PROC_PRT_COUNTS = "procPrtCounts"
    OBJECT_TYPE_PROC_STIMULUS_COUNTS = "procStimulusCounts"
    OBJECT_TYPE_PROC_SVC = "procSvc"
    OBJECT_TYPE_PROC_TX_COUNTS = "procTxCounts"
    OBJECT_TYPE_PROCESSOR_ENV_STATS = "processorEnvStats"
    OBJECT_TYPE_PROCESSOR_ENV_STATS_HIST = "processorEnvStatsHist"
    OBJECT_TYPE_PROCESSOR_ERROR_STATS = "processorErrorStats"
    OBJECT_TYPE_PROCESSOR_ERROR_STATS_HIST = "processorErrorStatsHist"
    OBJECT_TYPE_PROCESSOR_QUAL = "processorQual"
    OBJECT_TYPE_PROCESSOR_RUNTIME = "processorRuntime"
    OBJECT_TYPE_PROCESSOR_RUNTIME_HIST = "processorRuntimeHist"
    OBJECT_TYPE_PROCESSOR_UNIT = "processorUnit"
    OBJECT_TYPE_PROCESSOR_UNIT_ASSOC_CTX = "processorUnitAssocCtx"
    OBJECT_TYPE_QOS_DEFINITION = "qosDefinition"
    OBJECT_TYPE_QOS_ITEM = "qosItem"
    OBJECT_TYPE_QOSCLASS_DEFINITION = "qosclassDefinition"
    OBJECT_TYPE_QOSCLASS_ETH = "qosclassEth"
    OBJECT_TYPE_QOSCLASS_ETH_BE = "qosclassEthBE"
    OBJECT_TYPE_QOSCLASS_ETH_CLASSIFIED = "qosclassEthClassified"
    OBJECT_TYPE_QOSCLASS_FC = "qosclassFc"
    OBJECT_TYPE_QOSCLASS_ITEM = "qosclassItem"
    OBJECT_TYPE_QOSCLASS_POLICY = "qosclassPolicy"
    OBJECT_TYPE_QUERY_CONTEXT = "queryContext"
    OBJECT_TYPE_QUERY_DEPENDENCY_CONTEXT = "queryDependencyContext"
    OBJECT_TYPE_QUERY_DEPENDENCY_REF = "queryDependencyRef"
    OBJECT_TYPE_QUERY_EP = "queryEp"
    OBJECT_TYPE_QUERY_IMPORT_CONTEXT = "queryImportContext"
    OBJECT_TYPE_QUERY_USAGE_CONTEXT = "queryUsageContext"
    OBJECT_TYPE_QUERYRESULT_DEPENDENCY = "queryresultDependency"
    OBJECT_TYPE_QUERYRESULT_DEST_ORG_EP = "queryresultDestOrgEp"
    OBJECT_TYPE_QUERYRESULT_DOMAIN_GROUP_EP = "queryresultDomainGroupEp"
    OBJECT_TYPE_QUERYRESULT_ITEM = "queryresultItem"
    OBJECT_TYPE_QUERYRESULT_ORG_EP = "queryresultOrgEp"
    OBJECT_TYPE_QUERYRESULT_USAGE = "queryresultUsage"
    OBJECT_TYPE_RULE_DEFINITION = "ruleDefinition"
    OBJECT_TYPE_RULE_ITEM = "ruleItem"
    OBJECT_TYPE_RULE_REQUIREMENT = "ruleRequirement"
    OBJECT_TYPE_RULE_SIZE_REQUIREMENT = "ruleSizeRequirement"
    OBJECT_TYPE_SECURITY_UNIT = "securityUnit"
    OBJECT_TYPE_SES_DISK_SLOT_EP = "sesDiskSlotEp"
    OBJECT_TYPE_SES_ENCLOSURE = "sesEnclosure"
    OBJECT_TYPE_SMARTCALLHOME_HTTP_PROXY = "smartcallhomeHttpProxy"
    OBJECT_TYPE_SMARTCALLHOME_PERIODIC_INVENTORY_STATUS = "smartcallhomePeriodicInventoryStatus"
    OBJECT_TYPE_SMARTCALLHOME_PERIODIC_SYSTEM_INVENTORY = "smartcallhomePeriodicSystemInventory"
    OBJECT_TYPE_SMARTCALLHOME_POLICY = "smartcallhomePolicy"
    OBJECT_TYPE_SMARTCALLHOME_PROFILE = "smartcallhomeProfile"
    OBJECT_TYPE_SMARTCALLHOME_SOURCE = "smartcallhomeSource"
    OBJECT_TYPE_SMARTCALLHOME_TRANSPORT_GATEWAY = "smartcallhomeTransportGateway"
    OBJECT_TYPE_SMARTLICENSE_AGENT = "smartlicenseAgent"
    OBJECT_TYPE_SMARTLICENSE_AGENT_FSM = "smartlicenseAgentFsm"
    OBJECT_TYPE_SMARTLICENSE_AGENT_FSM_STAGE = "smartlicenseAgentFsmStage"
    OBJECT_TYPE_SMARTLICENSE_AGENT_FSM_TASK = "smartlicenseAgentFsmTask"
    OBJECT_TYPE_SMARTLICENSE_ENTITLEMENT = "smartlicenseEntitlement"
    OBJECT_TYPE_SMARTLICENSE_ENTITLEMENT_EP = "smartlicenseEntitlementEp"
    OBJECT_TYPE_SMARTLICENSE_ENTITLEMENT_EP_FSM = "smartlicenseEntitlementEpFsm"
    OBJECT_TYPE_SMARTLICENSE_ENTITLEMENT_EP_FSM_STAGE = "smartlicenseEntitlementEpFsmStage"
    OBJECT_TYPE_SMARTLICENSE_ENTITLEMENT_EP_FSM_TASK = "smartlicenseEntitlementEpFsmTask"
    OBJECT_TYPE_SMARTLICENSE_EP = "smartlicenseEp"
    OBJECT_TYPE_SMARTLICENSE_HOLDER = "smartlicenseHolder"
    OBJECT_TYPE_SMARTLICENSE_HOLDER_FSM = "smartlicenseHolderFsm"
    OBJECT_TYPE_SMARTLICENSE_HOLDER_FSM_STAGE = "smartlicenseHolderFsmStage"
    OBJECT_TYPE_SMARTLICENSE_HOLDER_FSM_TASK = "smartlicenseHolderFsmTask"
    OBJECT_TYPE_SMARTLICENSE_TEST = "smartlicenseTest"
    OBJECT_TYPE_SMARTLICENSE_TEST_FSM = "smartlicenseTestFsm"
    OBJECT_TYPE_SMARTLICENSE_TEST_FSM_STAGE = "smartlicenseTestFsmStage"
    OBJECT_TYPE_SMARTLICENSE_TEST_FSM_TASK = "smartlicenseTestFsmTask"
    OBJECT_TYPE_SOL_DEF = "solDef"
    OBJECT_TYPE_SOL_POLICY = "solPolicy"
    OBJECT_TYPE_STATS_CHART = "statsChart"
    OBJECT_TYPE_STATS_CHART_CONTAINER = "statsChartContainer"
    OBJECT_TYPE_STATS_COLLECTION_POLICY = "statsCollectionPolicy"
    OBJECT_TYPE_STATS_CURR = "statsCurr"
    OBJECT_TYPE_STATS_CUSTOM_CHART = "statsCustomChart"
    OBJECT_TYPE_STATS_CUSTOM_EP = "statsCustomEp"
    OBJECT_TYPE_STATS_DB_MIGRATION_STATUS = "statsDbMigrationStatus"
    OBJECT_TYPE_STATS_DB_SUMMARY_META = "statsDbSummaryMeta"
    OBJECT_TYPE_STATS_HIST = "statsHist"
    OBJECT_TYPE_STATS_HOLDER = "statsHolder"
    OBJECT_TYPE_STATS_INVENTORY_META = "statsInventoryMeta"
    OBJECT_TYPE_STATS_ITEM = "statsItem"
    OBJECT_TYPE_STATS_PASADENA_COLLECTION_POLICY = "statsPasadenaCollectionPolicy"
    OBJECT_TYPE_STATS_STANDARD_CHART = "statsStandardChart"
    OBJECT_TYPE_STATS_STANDARD_EP = "statsStandardEp"
    OBJECT_TYPE_STATS_STATS_QUERY = "statsStatsQuery"
    OBJECT_TYPE_STATS_STATS_QUERY_HOLDER = "statsStatsQueryHolder"
    OBJECT_TYPE_STATS_THR32_DEFINITION = "statsThr32Definition"
    OBJECT_TYPE_STATS_THR32_VALUE = "statsThr32Value"
    OBJECT_TYPE_STATS_THR64_DEFINITION = "statsThr64Definition"
    OBJECT_TYPE_STATS_THR64_VALUE = "statsThr64Value"
    OBJECT_TYPE_STATS_THR_FLOAT_DEFINITION = "statsThrFloatDefinition"
    OBJECT_TYPE_STATS_THR_FLOAT_VALUE = "statsThrFloatValue"
    OBJECT_TYPE_STATS_THRESHOLD_CLASS = "statsThresholdClass"
    OBJECT_TYPE_STATS_THRESHOLD_DEFINITION = "statsThresholdDefinition"
    OBJECT_TYPE_STATS_THRESHOLD_POLICY = "statsThresholdPolicy"
    OBJECT_TYPE_STATS_THRESHOLD_VALUE = "statsThresholdValue"
    OBJECT_TYPE_STORAGE_ADEF = "storageADef"
    OBJECT_TYPE_STORAGE_ALUN = "storageALun"
    OBJECT_TYPE_STORAGE_ALUN_REF_BASE = "storageALunRefBase"
    OBJECT_TYPE_STORAGE_ASCSI_LUN = "storageAScsiLun"
    OBJECT_TYPE_STORAGE_ASCSI_LUN_CTX = "storageAScsiLunCtx"
    OBJECT_TYPE_STORAGE_ASLOT = "storageASlot"
    OBJECT_TYPE_STORAGE_ASNAP_REPLICA_LUN_CTX = "storageASnapReplicaLunCtx"
    OBJECT_TYPE_STORAGE_AVOLUME = "storageAVolume"
    OBJECT_TYPE_STORAGE_APPLIANCE = "storageAppliance"
    OBJECT_TYPE_STORAGE_ARRAY = "storageArray"
    OBJECT_TYPE_STORAGE_AUTH_KEY = "storageAuthKey"
    OBJECT_TYPE_STORAGE_BACKSTORE = "storageBackstore"
    OBJECT_TYPE_STORAGE_BLADE = "storageBlade"
    OBJECT_TYPE_STORAGE_CLOUD = "storageCloud"
    OBJECT_TYPE_STORAGE_CLUSTER_ID_UNIVERSE = "storageClusterIdUniverse"
    OBJECT_TYPE_STORAGE_COMPUTE_BLADE_OPERATION = "storageComputeBladeOperation"
    OBJECT_TYPE_STORAGE_CONNECTION_DEF = "storageConnectionDef"
    OBJECT_TYPE_STORAGE_CONNECTION_POLICY = "storageConnectionPolicy"
    OBJECT_TYPE_STORAGE_CONTAINER = "storageContainer"
    OBJECT_TYPE_STORAGE_CONTROLLER = "storageController"
    OBJECT_TYPE_STORAGE_CONTROLLER_BASE = "storageControllerBase"
    OBJECT_TYPE_STORAGE_CONTROLLER_EP = "storageControllerEp"
    OBJECT_TYPE_STORAGE_CONTROLLER_OPERATION = "storageControllerOperation"
    OBJECT_TYPE_STORAGE_CONTROLLER_REF = "storageControllerRef"
    OBJECT_TYPE_STORAGE_CTRL_STORAGE_STATS = "storageCtrlStorageStats"
    OBJECT_TYPE_STORAGE_CTRL_STORAGE_STATS_HIST = "storageCtrlStorageStatsHist"
    OBJECT_TYPE_STORAGE_DEVICE = "storageDevice"
    OBJECT_TYPE_STORAGE_DISK_ENV_STATS = "storageDiskEnvStats"
    OBJECT_TYPE_STORAGE_DISK_ENV_STATS_HIST = "storageDiskEnvStatsHist"
    OBJECT_TYPE_STORAGE_DISK_EP = "storageDiskEp"
    OBJECT_TYPE_STORAGE_DISK_GROUP = "storageDiskGroup"
    OBJECT_TYPE_STORAGE_EMBEDDED_STORAGE = "storageEmbeddedStorage"
    OBJECT_TYPE_STORAGE_ENCLOSURE = "storageEnclosure"
    OBJECT_TYPE_STORAGE_ENCLOSURE_DISK_SLOT_EP = "storageEnclosureDiskSlotEp"
    OBJECT_TYPE_STORAGE_ENCLOSURE_LOCAL_DISK_CONFIG = "storageEnclosureLocalDiskConfig"
    OBJECT_TYPE_STORAGE_EP = "storageEp"
    OBJECT_TYPE_STORAGE_EP_USER = "storageEpUser"
    OBJECT_TYPE_STORAGE_ETH_LIF = "storageEthLif"
    OBJECT_TYPE_STORAGE_ETHER_IF = "storageEtherIf"
    OBJECT_TYPE_STORAGE_FC_IF = "storageFcIf"
    OBJECT_TYPE_STORAGE_FC_TARGET_EP = "storageFcTargetEp"
    OBJECT_TYPE_STORAGE_FC_TARGET_IF = "storageFcTargetIf"
    OBJECT_TYPE_STORAGE_FLEX_FLASH_CARD = "storageFlexFlashCard"
    OBJECT_TYPE_STORAGE_FLEX_FLASH_CONTROLLER = "storageFlexFlashController"
    OBJECT_TYPE_STORAGE_FLEX_FLASH_CONTROLLER_OPERATION = "storageFlexFlashControllerOperation"
    OBJECT_TYPE_STORAGE_FLEX_FLASH_DRIVE = "storageFlexFlashDrive"
    OBJECT_TYPE_STORAGE_FLEX_FLASH_VIRTUAL_DRIVE = "storageFlexFlashVirtualDrive"
    OBJECT_TYPE_STORAGE_HDD_MOTHER_BOARD_TEMP_STATS = "storageHddMotherBoardTempStats"
    OBJECT_TYPE_STORAGE_HDD_MOTHER_BOARD_TEMP_STATS_HIST = "storageHddMotherBoardTempStatsHist"
    OBJECT_TYPE_STORAGE_ISCSI_INITIATOR_EP = "storageIScsiInitiatorEp"
    OBJECT_TYPE_STORAGE_ISCSI_TARGET_IF = "storageIScsiTargetIf"
    OBJECT_TYPE_STORAGE_INI_GROUP = "storageIniGroup"
    OBJECT_TYPE_STORAGE_INITIATOR = "storageInitiator"
    OBJECT_TYPE_STORAGE_INITIATOR_REF = "storageInitiatorRef"
    OBJECT_TYPE_STORAGE_IP_V4_POOLED_ADDR = "storageIpV4PooledAddr"
    OBJECT_TYPE_STORAGE_IP_V4_STATIC_ADDR = "storageIpV4StaticAddr"
    OBJECT_TYPE_STORAGE_ITEM = "storageItem"
    OBJECT_TYPE_STORAGE_L2_IF = "storageL2If"
    OBJECT_TYPE_STORAGE_LOCAL_DISK = "storageLocalDisk"
    OBJECT_TYPE_STORAGE_LOCAL_DISK_BASE = "storageLocalDiskBase"
    OBJECT_TYPE_STORAGE_LOCAL_DISK_CONFIG = "storageLocalDiskConfig"
    OBJECT_TYPE_STORAGE_LOCAL_DISK_CONFIG_DEF = "storageLocalDiskConfigDef"
    OBJECT_TYPE_STORAGE_LOCAL_DISK_CONFIG_POLICY = "storageLocalDiskConfigPolicy"
    OBJECT_TYPE_STORAGE_LOCAL_DISK_EP = "storageLocalDiskEp"
    OBJECT_TYPE_STORAGE_LOCAL_DISK_OPERATION = "storageLocalDiskOperation"
    OBJECT_TYPE_STORAGE_LOCAL_DISK_PARTITION = "storageLocalDiskPartition"
    OBJECT_TYPE_STORAGE_LOCAL_LUN = "storageLocalLun"
    OBJECT_TYPE_STORAGE_LOGICAL = "storageLogical"
    OBJECT_TYPE_STORAGE_LUN_COUNTERS = "storageLunCounters"
    OBJECT_TYPE_STORAGE_LUN_DISK = "storageLunDisk"
    OBJECT_TYPE_STORAGE_LUN_MASK_GROUP = "storageLunMaskGroup"
    OBJECT_TYPE_STORAGE_LUN_REPLICA = "storageLunReplica"
    OBJECT_TYPE_STORAGE_LUN_RESOURCE_SELECTION_LOG = "storageLunResourceSelectionLog"
    OBJECT_TYPE_STORAGE_LUN_SNAPSHOT = "storageLunSnapshot"
    OBJECT_TYPE_STORAGE_META = "storageMeta"
    OBJECT_TYPE_STORAGE_MEZZ_FLASH_LIFE = "storageMezzFlashLife"
    OBJECT_TYPE_STORAGE_NODE_EP = "storageNodeEp"
    OBJECT_TYPE_STORAGE_NVME_STATS = "storageNvmeStats"
    OBJECT_TYPE_STORAGE_NVME_STATS_HIST = "storageNvmeStatsHist"
    OBJECT_TYPE_STORAGE_NVME_STORAGE = "storageNvmeStorage"
    OBJECT_TYPE_STORAGE_ONBOARD_DEVICE = "storageOnboardDevice"
    OBJECT_TYPE_STORAGE_OPERATION = "storageOperation"
    OBJECT_TYPE_STORAGE_PARTITION = "storagePartition"
    OBJECT_TYPE_STORAGE_PHYSICAL = "storagePhysical"
    OBJECT_TYPE_STORAGE_PROCESSOR = "storageProcessor"
    OBJECT_TYPE_STORAGE_PROCESSOR_EP = "storageProcessorEp"
    OBJECT_TYPE_STORAGE_PROCESSOR_RUNTIME = "storageProcessorRuntime"
    OBJECT_TYPE_STORAGE_QUAL = "storageQual"
    OBJECT_TYPE_STORAGE_RAID_BATTERY = "storageRaidBattery"
    OBJECT_TYPE_STORAGE_REPLICATION_CTX = "storageReplicationCtx"
    OBJECT_TYPE_STORAGE_SAS_EXPANDER = "storageSasExpander"
    OBJECT_TYPE_STORAGE_SAS_PHY_LINK = "storageSasPhyLink"
    OBJECT_TYPE_STORAGE_SAS_PORT = "storageSasPort"
    OBJECT_TYPE_STORAGE_SAS_UP_LINK = "storageSasUpLink"
    OBJECT_TYPE_STORAGE_SCSI_DEVICE_DESCRIPTOR = "storageScsiDeviceDescriptor"
    OBJECT_TYPE_STORAGE_SCSI_LUN = "storageScsiLun"
    OBJECT_TYPE_STORAGE_SCSI_LUN_CTX = "storageScsiLunCtx"
    OBJECT_TYPE_STORAGE_SCSI_LUN_INST_REF = "storageScsiLunInstRef"
    OBJECT_TYPE_STORAGE_SCSI_LUN_MASK = "storageScsiLunMask"
    OBJECT_TYPE_STORAGE_SCSI_LUN_REF = "storageScsiLunRef"
    OBJECT_TYPE_STORAGE_SNAPSHOT = "storageSnapshot"
    OBJECT_TYPE_STORAGE_SNAPSHOT_CTX = "storageSnapshotCtx"
    OBJECT_TYPE_STORAGE_SSD_HEALTH_STATS = "storageSsdHealthStats"
    OBJECT_TYPE_STORAGE_SSD_HEALTH_STATS_HIST = "storageSsdHealthStatsHist"
    OBJECT_TYPE_STORAGE_STORAGE_STATS = "storageStorageStats"
    OBJECT_TYPE_STORAGE_STORAGE_STATS_HIST = "storageStorageStatsHist"
    OBJECT_TYPE_STORAGE_SYSTEM = "storageSystem"
    OBJECT_TYPE_STORAGE_TARGET = "storageTarget"
    OBJECT_TYPE_STORAGE_TARGET_IF = "storageTargetIf"
    OBJECT_TYPE_STORAGE_TRANSPORT_IF = "storageTransportIf"
    OBJECT_TYPE_STORAGE_TRANSPORTABLE_FLASH_MODULE = "storageTransportableFlashModule"
    OBJECT_TYPE_STORAGE_UNIT = "storageUnit"
    OBJECT_TYPE_STORAGE_USAGE_COUNTERS = "storageUsageCounters"
    OBJECT_TYPE_STORAGE_VDMEMBER_EP = "storageVDMemberEp"
    OBJECT_TYPE_STORAGE_VIRTUAL_DRIVE = "storageVirtualDrive"
    OBJECT_TYPE_STORAGE_VIRTUAL_DRIVE_CONTAINER = "storageVirtualDriveContainer"
    OBJECT_TYPE_STORAGE_VIRTUAL_DRIVE_EP = "storageVirtualDriveEp"
    OBJECT_TYPE_STORAGE_VIRTUAL_DRIVE_OPERATION = "storageVirtualDriveOperation"
    OBJECT_TYPE_STORAGE_VIRTUAL_DRIVE_REF = "storageVirtualDriveRef"
    OBJECT_TYPE_STORAGE_VIRTUAL_DRIVE_REF_OPERATION = "storageVirtualDriveRefOperation"
    OBJECT_TYPE_STORAGE_VOLUME = "storageVolume"
    OBJECT_TYPE_STORAGE_VSAN_REF = "storageVsanRef"
    OBJECT_TYPE_STORAGE_VSAN_REF_IVT = "storageVsanRefIvt"
    OBJECT_TYPE_SW_CARD_ENV_STATS = "swCardEnvStats"
    OBJECT_TYPE_SW_CARD_ENV_STATS_HIST = "swCardEnvStatsHist"
    OBJECT_TYPE_SW_ENV_STATS = "swEnvStats"
    OBJECT_TYPE_SW_ENV_STATS_HIST = "swEnvStatsHist"
    OBJECT_TYPE_SW_MON = "swMon"
    OBJECT_TYPE_SW_SYSTEM_STATS = "swSystemStats"
    OBJECT_TYPE_SW_SYSTEM_STATS_HIST = "swSystemStatsHist"
    OBJECT_TYPE_SW_VLAN = "swVlan"
    OBJECT_TYPE_SW_VLAN_GROUP = "swVlanGroup"
    OBJECT_TYPE_SYNTHETIC_DIRECTORY = "syntheticDirectory"
    OBJECT_TYPE_SYNTHETIC_FILE = "syntheticFile"
    OBJECT_TYPE_SYNTHETIC_FILE_SYSTEM = "syntheticFileSystem"
    OBJECT_TYPE_SYNTHETIC_FS_OBJ = "syntheticFsObj"
    OBJECT_TYPE_SYNTHETIC_TIME = "syntheticTime"
    OBJECT_TYPE_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET = "sysdebugAutoCoreFileExportTarget"
    OBJECT_TYPE_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM = "sysdebugAutoCoreFileExportTargetFsm"
    OBJECT_TYPE_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM_STAGE = "sysdebugAutoCoreFileExportTargetFsmStage"
    OBJECT_TYPE_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM_TASK = "sysdebugAutoCoreFileExportTargetFsmTask"
    OBJECT_TYPE_SYSDEBUG_BACKUP_BEHAVIOR = "sysdebugBackupBehavior"
    OBJECT_TYPE_SYSDEBUG_CORE = "sysdebugCore"
    OBJECT_TYPE_SYSDEBUG_CORE_FILE_EXPORT_TARGET = "sysdebugCoreFileExportTarget"
    OBJECT_TYPE_SYSDEBUG_CORE_FILE_REPOSITORY = "sysdebugCoreFileRepository"
    OBJECT_TYPE_SYSDEBUG_DIAGNOSTIC_LOG = "sysdebugDiagnosticLog"
    OBJECT_TYPE_SYSDEBUG_EP = "sysdebugEp"
    OBJECT_TYPE_SYSDEBUG_EXPORTER = "sysdebugExporter"
    OBJECT_TYPE_SYSDEBUG_FILE = "sysdebugFile"
    OBJECT_TYPE_SYSDEBUG_LOG_BEHAVIOR = "sysdebugLogBehavior"
    OBJECT_TYPE_SYSDEBUG_LOG_CONTROL_DESTINATION_FILE = "sysdebugLogControlDestinationFile"
    OBJECT_TYPE_SYSDEBUG_LOG_CONTROL_DESTINATION_SYSLOG = "sysdebugLogControlDestinationSyslog"
    OBJECT_TYPE_SYSDEBUG_LOG_CONTROL_DOMAIN = "sysdebugLogControlDomain"
    OBJECT_TYPE_SYSDEBUG_LOG_CONTROL_EP = "sysdebugLogControlEp"
    OBJECT_TYPE_SYSDEBUG_LOG_CONTROL_EP_FSM = "sysdebugLogControlEpFsm"
    OBJECT_TYPE_SYSDEBUG_LOG_CONTROL_EP_FSM_STAGE = "sysdebugLogControlEpFsmStage"
    OBJECT_TYPE_SYSDEBUG_LOG_CONTROL_EP_FSM_TASK = "sysdebugLogControlEpFsmTask"
    OBJECT_TYPE_SYSDEBUG_LOG_CONTROL_MODULE = "sysdebugLogControlModule"
    OBJECT_TYPE_SYSDEBUG_MEP_LOG_DEF = "sysdebugMEpLogDef"
    OBJECT_TYPE_SYSDEBUG_MEP_LOG_POLICY = "sysdebugMEpLogPolicy"
    OBJECT_TYPE_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET = "sysdebugManualCoreFileExportTarget"
    OBJECT_TYPE_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM = "sysdebugManualCoreFileExportTargetFsm"
    OBJECT_TYPE_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM_STAGE = "sysdebugManualCoreFileExportTargetFsmStage"
    OBJECT_TYPE_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM_TASK = "sysdebugManualCoreFileExportTargetFsmTask"
    OBJECT_TYPE_SYSDEBUG_REPOSITORY = "sysdebugRepository"
    OBJECT_TYPE_SYSDEBUG_TECH_SUP_FILE_REPOSITORY = "sysdebugTechSupFileRepository"
    OBJECT_TYPE_SYSDEBUG_TECH_SUPPORT = "sysdebugTechSupport"
    OBJECT_TYPE_SYSDEBUG_TECH_SUPPORT_CMD_OPT = "sysdebugTechSupportCmdOpt"
    OBJECT_TYPE_SYSDEBUG_TECH_SUPPORT_FSM = "sysdebugTechSupportFsm"
    OBJECT_TYPE_SYSDEBUG_TECH_SUPPORT_FSM_STAGE = "sysdebugTechSupportFsmStage"
    OBJECT_TYPE_SYSDEBUG_TECH_SUPPORT_FSM_TASK = "sysdebugTechSupportFsmTask"
    OBJECT_TYPE_SYSDEBUG_TECH_SUPPORT_OP = "sysdebugTechSupportOp"
    OBJECT_TYPE_SYSDEBUG_TECH_SUPPORT_OPERATION = "sysdebugTechSupportOperation"
    OBJECT_TYPE_SYSFILE_DIGEST = "sysfileDigest"
    OBJECT_TYPE_SYSFILE_EP = "sysfileEp"
    OBJECT_TYPE_SYSFILE_EXPORTER = "sysfileExporter"
    OBJECT_TYPE_SYSFILE_IMPORTER = "sysfileImporter"
    OBJECT_TYPE_SYSFILE_INSTANCE = "sysfileInstance"
    OBJECT_TYPE_SYSFILE_MUTATION = "sysfileMutation"
    OBJECT_TYPE_SYSFILE_MUTATION_FSM = "sysfileMutationFsm"
    OBJECT_TYPE_SYSFILE_MUTATION_FSM_STAGE = "sysfileMutationFsmStage"
    OBJECT_TYPE_SYSFILE_MUTATION_FSM_TASK = "sysfileMutationFsmTask"
    OBJECT_TYPE_SYSFILE_REPOSITORY = "sysfileRepository"
    OBJECT_TYPE_TAG_ADEF = "tagADef"
    OBJECT_TYPE_TAG_AINSTANCE = "tagAInstance"
    OBJECT_TYPE_TAG_DEF = "tagDef"
    OBJECT_TYPE_TAG_DEF_EP = "tagDefEp"
    OBJECT_TYPE_TAG_DRIVER = "tagDriver"
    OBJECT_TYPE_TAG_INSTANCE = "tagInstance"
    OBJECT_TYPE_TAG_INSTANCE_EP = "tagInstanceEp"
    OBJECT_TYPE_TAG_INSTANCE_ITEM = "tagInstanceItem"
    OBJECT_TYPE_TAG_ITEM = "tagItem"
    OBJECT_TYPE_TAG_SOFTWARE_INST = "tagSoftwareInst"
    OBJECT_TYPE_TESTING_CLI_POLICY = "testingCliPolicy"
    OBJECT_TYPE_TESTING_SERVICE_PROFILE = "testingServiceProfile"
    OBJECT_TYPE_TESTING_SERVICE_PROFILE_FSM = "testingServiceProfileFsm"
    OBJECT_TYPE_TESTING_SERVICE_PROFILE_FSM_STAGE = "testingServiceProfileFsmStage"
    OBJECT_TYPE_TESTING_SERVICE_PROFILE_FSM_TASK = "testingServiceProfileFsmTask"
    OBJECT_TYPE_TESTING_SNMP_COMMUNITY = "testingSnmpCommunity"
    OBJECT_TYPE_TESTING_SNMP_POLICY = "testingSnmpPolicy"
    OBJECT_TYPE_TESTING_SNMP_SUPPORT = "testingSnmpSupport"
    OBJECT_TYPE_TESTING_SNMP_TRAP = "testingSnmpTrap"
    OBJECT_TYPE_TOP_INFO_SYNC_POLICY = "topInfoSyncPolicy"
    OBJECT_TYPE_TOP_META_INF = "topMetaInf"
    OBJECT_TYPE_TOP_ROOT = "topRoot"
    OBJECT_TYPE_TOP_SYSTEM = "topSystem"
    OBJECT_TYPE_TOP_SYSTEM_FSM = "topSystemFsm"
    OBJECT_TYPE_TOP_SYSTEM_FSM_STAGE = "topSystemFsmStage"
    OBJECT_TYPE_TOP_SYSTEM_FSM_TASK = "topSystemFsmTask"
    OBJECT_TYPE_TRIG_ABS_WINDOW = "trigAbsWindow"
    OBJECT_TYPE_TRIG_ACK = "trigAck"
    OBJECT_TYPE_TRIG_BASE_RECURR_WINDOW = "trigBaseRecurrWindow"
    OBJECT_TYPE_TRIG_BASE_SCHED = "trigBaseSched"
    OBJECT_TYPE_TRIG_CONF_ACK = "trigConfAck"
    OBJECT_TYPE_TRIG_INST = "trigInst"
    OBJECT_TYPE_TRIG_META = "trigMeta"
    OBJECT_TYPE_TRIG_PENDING_ACK_COUNT = "trigPendingAckCount"
    OBJECT_TYPE_TRIG_RECURR_WINDOW = "trigRecurrWindow"
    OBJECT_TYPE_TRIG_RES_ACK = "trigResAck"
    OBJECT_TYPE_TRIG_SCHED = "trigSched"
    OBJECT_TYPE_TRIG_SCHED_WINDOW = "trigSchedWindow"
    OBJECT_TYPE_TRIG_SERVER_TOKEN = "trigServerToken"
    OBJECT_TYPE_TRIG_TEST = "trigTest"
    OBJECT_TYPE_TRIG_TOKEN = "trigToken"
    OBJECT_TYPE_TRIG_TOKEN_REQUESTOR = "trigTokenRequestor"
    OBJECT_TYPE_TRIG_TRIGGERABLE = "trigTriggerable"
    OBJECT_TYPE_TRIG_TRIGGERED = "trigTriggered"
    OBJECT_TYPE_TRIG_WINDOW = "trigWindow"
    OBJECT_TYPE_UNSPECIFIED = "unspecified"
    OBJECT_TYPE_UUIDPOOL_ADDR = "uuidpoolAddr"
    OBJECT_TYPE_UUIDPOOL_BLOCK = "uuidpoolBlock"
    OBJECT_TYPE_UUIDPOOL_FORMAT = "uuidpoolFormat"
    OBJECT_TYPE_UUIDPOOL_POOL = "uuidpoolPool"
    OBJECT_TYPE_UUIDPOOL_POOLED = "uuidpoolPooled"
    OBJECT_TYPE_UUIDPOOL_UNIVERSE = "uuidpoolUniverse"
    OBJECT_TYPE_VERSION_APPLICATION = "versionApplication"
    OBJECT_TYPE_VERSION_EP = "versionEp"
    OBJECT_TYPE_VERSION_FILTER = "versionFilter"
    OBJECT_TYPE_VERSION_MATRIX = "versionMatrix"
    OBJECT_TYPE_VERSION_PRODUCT = "versionProduct"
    OBJECT_TYPE_VERSION_VERSION = "versionVersion"
    OBJECT_TYPE_VM_ADAPTOR = "vmAdaptor"
    OBJECT_TYPE_VM_NIC = "vmNic"
    OBJECT_TYPE_VNIC_ABEH = "vnicABeh"
    OBJECT_TYPE_VNIC_AETHER_IF = "vnicAEtherIf"
    OBJECT_TYPE_VNIC_AFC_IF = "vnicAFcIf"
    OBJECT_TYPE_VNIC_AGROUP = "vnicAGroup"
    OBJECT_TYPE_VNIC_BOOT_IP_POLICY = "vnicBootIpPolicy"
    OBJECT_TYPE_VNIC_BOOT_TARGET = "vnicBootTarget"
    OBJECT_TYPE_VNIC_CON_POLICY_REF = "vnicConPolicyRef"
    OBJECT_TYPE_VNIC_CON_REQ = "vnicConReq"
    OBJECT_TYPE_VNIC_CONN_DEF = "vnicConnDef"
    OBJECT_TYPE_VNIC_CONNECTION = "vnicConnection"
    OBJECT_TYPE_VNIC_DEF_BEH = "vnicDefBeh"
    OBJECT_TYPE_VNIC_DYNAMIC_CON = "vnicDynamicCon"
    OBJECT_TYPE_VNIC_DYNAMIC_CON_POLICY = "vnicDynamicConPolicy"
    OBJECT_TYPE_VNIC_DYNAMIC_CON_POLICY_REF = "vnicDynamicConPolicyRef"
    OBJECT_TYPE_VNIC_DYNAMIC_CON_REQ = "vnicDynamicConReq"
    OBJECT_TYPE_VNIC_ETH_LIF = "vnicEthLif"
    OBJECT_TYPE_VNIC_ETHER = "vnicEther"
    OBJECT_TYPE_VNIC_ETHER_BASE = "vnicEtherBase"
    OBJECT_TYPE_VNIC_ETHER_BASE_IF = "vnicEtherBaseIf"
    OBJECT_TYPE_VNIC_ETHER_IF = "vnicEtherIf"
    OBJECT_TYPE_VNIC_FAULT = "vnicFault"
    OBJECT_TYPE_VNIC_FC = "vnicFc"
    OBJECT_TYPE_VNIC_FC_BASE = "vnicFcBase"
    OBJECT_TYPE_VNIC_FC_GROUP_DEF = "vnicFcGroupDef"
    OBJECT_TYPE_VNIC_FC_GROUP_TEMPL = "vnicFcGroupTempl"
    OBJECT_TYPE_VNIC_FC_IF = "vnicFcIf"
    OBJECT_TYPE_VNIC_FC_LIF = "vnicFcLif"
    OBJECT_TYPE_VNIC_FC_NODE = "vnicFcNode"
    OBJECT_TYPE_VNIC_FC_OEIF = "vnicFcOEIf"
    OBJECT_TYPE_VNIC_IPIF = "vnicIPIf"
    OBJECT_TYPE_VNIC_IPV4_DHCP = "vnicIPv4Dhcp"
    OBJECT_TYPE_VNIC_IPV4_DNS = "vnicIPv4Dns"
    OBJECT_TYPE_VNIC_IPV4_IF = "vnicIPv4If"
    OBJECT_TYPE_VNIC_IPV4_ISCSI_ADDR = "vnicIPv4IscsiAddr"
    OBJECT_TYPE_VNIC_IPV4_POOLED_ISCSI_ADDR = "vnicIPv4PooledIscsiAddr"
    OBJECT_TYPE_VNIC_IPV4_STATIC_ROUTE = "vnicIPv4StaticRoute"
    OBJECT_TYPE_VNIC_IPV6_IF = "vnicIPv6If"
    OBJECT_TYPE_VNIC_ISCSI = "vnicIScsi"
    OBJECT_TYPE_VNIC_ISCSI_AUTO_TARGET_IF = "vnicIScsiAutoTargetIf"
    OBJECT_TYPE_VNIC_ISCSI_BASE = "vnicIScsiBase"
    OBJECT_TYPE_VNIC_ISCSI_BOOT_PARAMS = "vnicIScsiBootParams"
    OBJECT_TYPE_VNIC_ISCSI_BOOT_VNIC = "vnicIScsiBootVnic"
    OBJECT_TYPE_VNIC_ISCSI_INITIATOR_PARAMS = "vnicIScsiInitiatorParams"
    OBJECT_TYPE_VNIC_ISCSI_LCP = "vnicIScsiLCP"
    OBJECT_TYPE_VNIC_ISCSI_NODE = "vnicIScsiNode"
    OBJECT_TYPE_VNIC_ISCSI_STATIC_TARGET_IF = "vnicIScsiStaticTargetIf"
    OBJECT_TYPE_VNIC_ISCSI_TARGET_IF = "vnicIScsiTargetIf"
    OBJECT_TYPE_VNIC_ISCSI_TARGET_PARAMS = "vnicIScsiTargetParams"
    OBJECT_TYPE_VNIC_IF = "vnicIf"
    OBJECT_TYPE_VNIC_IF_ROLE = "vnicIfRole"
    OBJECT_TYPE_VNIC_INI_GRP_FC = "vnicIniGrpFc"
    OBJECT_TYPE_VNIC_INI_GRP_FC_B = "vnicIniGrpFcB"
    OBJECT_TYPE_VNIC_INI_GRP_FC_BIF = "vnicIniGrpFcBIf"
    OBJECT_TYPE_VNIC_INI_GRP_FC_BASE = "vnicIniGrpFcBase"
    OBJECT_TYPE_VNIC_INI_GRP_FC_IF = "vnicIniGrpFcIf"
    OBJECT_TYPE_VNIC_IP_ADDR = "vnicIpAddr"
    OBJECT_TYPE_VNIC_IP_V4_ADDR = "vnicIpV4Addr"
    OBJECT_TYPE_VNIC_IP_V4_ADDR_CONF = "vnicIpV4AddrConf"
    OBJECT_TYPE_VNIC_IP_V4_ADDR_EXPL_CONF = "vnicIpV4AddrExplConf"
    OBJECT_TYPE_VNIC_IP_V4_MGMT_POOLED_ADDR = "vnicIpV4MgmtPooledAddr"
    OBJECT_TYPE_VNIC_IP_V4_POOLED_ADDR = "vnicIpV4PooledAddr"
    OBJECT_TYPE_VNIC_IP_V4_PROF_DERIVED_ADDR = "vnicIpV4ProfDerivedAddr"
    OBJECT_TYPE_VNIC_IP_V4_STATIC_ADDR = "vnicIpV4StaticAddr"
    OBJECT_TYPE_VNIC_IP_V6_ADDR = "vnicIpV6Addr"
    OBJECT_TYPE_VNIC_IP_V6_ADDR_CONF = "vnicIpV6AddrConf"
    OBJECT_TYPE_VNIC_IP_V6_ADDR_EXPL_CONF = "vnicIpV6AddrExplConf"
    OBJECT_TYPE_VNIC_IP_V6_MGMT_POOLED_ADDR = "vnicIpV6MgmtPooledAddr"
    OBJECT_TYPE_VNIC_IP_V6_STATIC_ADDR = "vnicIpV6StaticAddr"
    OBJECT_TYPE_VNIC_L2_IF = "vnicL2If"
    OBJECT_TYPE_VNIC_L2_LIF = "vnicL2Lif"
    OBJECT_TYPE_VNIC_L3_IF = "vnicL3If"
    OBJECT_TYPE_VNIC_LAN_CONN_POLICY = "vnicLanConnPolicy"
    OBJECT_TYPE_VNIC_LAN_CONN_TEMPL = "vnicLanConnTempl"
    OBJECT_TYPE_VNIC_LIF_VLAN = "vnicLifVlan"
    OBJECT_TYPE_VNIC_LIF_VSAN = "vnicLifVsan"
    OBJECT_TYPE_VNIC_LSTORAGE_ISCSI = "vnicLstorageIScsi"
    OBJECT_TYPE_VNIC_LUN = "vnicLun"
    OBJECT_TYPE_VNIC_MGMT = "vnicMgmt"
    OBJECT_TYPE_VNIC_MGMT_BASE = "vnicMgmtBase"
    OBJECT_TYPE_VNIC_MGMT_IF = "vnicMgmtIf"
    OBJECT_TYPE_VNIC_MON_SES_FC = "vnicMonSesFc"
    OBJECT_TYPE_VNIC_MON_SES_FC_BASE = "vnicMonSesFcBase"
    OBJECT_TYPE_VNIC_MON_SES_FC_IF = "vnicMonSesFcIf"
    OBJECT_TYPE_VNIC_NET_GROUP = "vnicNetGroup"
    OBJECT_TYPE_VNIC_NET_GROUP_REF = "vnicNetGroupRef"
    OBJECT_TYPE_VNIC_NIC_CONN = "vnicNicConn"
    OBJECT_TYPE_VNIC_OUTBAND_MGMT_EP = "vnicOutbandMgmtEp"
    OBJECT_TYPE_VNIC_OUTBAND_MGMT_EP_FSM = "vnicOutbandMgmtEpFsm"
    OBJECT_TYPE_VNIC_OUTBAND_MGMT_EP_FSM_STAGE = "vnicOutbandMgmtEpFsmStage"
    OBJECT_TYPE_VNIC_OUTBAND_MGMT_EP_FSM_TASK = "vnicOutbandMgmtEpFsmTask"
    OBJECT_TYPE_VNIC_PROFILE_SET = "vnicProfileSet"
    OBJECT_TYPE_VNIC_RACK_SERVER_DISCOVERY_PROFILE = "vnicRackServerDiscoveryProfile"
    OBJECT_TYPE_VNIC_SAN_CONN_POLICY = "vnicSanConnPolicy"
    OBJECT_TYPE_VNIC_SAN_CONN_TEMPL = "vnicSanConnTempl"
    OBJECT_TYPE_VNIC_STORAGE_ETH_LIF = "vnicStorageEthLif"
    OBJECT_TYPE_VNIC_STORAGE_LIF = "vnicStorageLif"
    OBJECT_TYPE_VNIC_TEMPL = "vnicTempl"
    OBJECT_TYPE_VNIC_USNIC_CON_POLICY = "vnicUsnicConPolicy"
    OBJECT_TYPE_VNIC_USNIC_CON_POLICY_REF = "vnicUsnicConPolicyRef"
    OBJECT_TYPE_VNIC_USNIC_CON_REQ = "vnicUsnicConReq"
    OBJECT_TYPE_VNIC_VHBA_BEH_POLICY = "vnicVhbaBehPolicy"
    OBJECT_TYPE_VNIC_VLAN = "vnicVlan"
    OBJECT_TYPE_VNIC_VMQ_CON_POLICY = "vnicVmqConPolicy"
    OBJECT_TYPE_VNIC_VMQ_CON_POLICY_REF = "vnicVmqConPolicyRef"
    OBJECT_TYPE_VNIC_VMQ_CON_REQ = "vnicVmqConReq"
    OBJECT_TYPE_VNIC_VNIC = "vnicVnic"
    OBJECT_TYPE_VNIC_VNIC_BEH_POLICY = "vnicVnicBehPolicy"


class PolicyProxyMo(ManagedObject):
    """This is PolicyProxyMo class."""

    consts = PolicyProxyMoConsts()
    naming_props = set([])

    mo_meta = MoMeta("PolicyProxyMo", "policyProxyMo", "", VersionMeta.Version131a, "InputOutput", 0x7f, [], ["admin"], [], [], [None])

    prop_meta = {
        "child_action": MoPropertyMeta("child_action", "childAction", "string", VersionMeta.Version131a, MoPropertyMeta.INTERNAL, None, None, None, r"""((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], []), 
        "descr": MoPropertyMeta("descr", "descr", "string", VersionMeta.Version131a, MoPropertyMeta.READ_WRITE, 0x2, 0, 510, None, [], []), 
        "dn": MoPropertyMeta("dn", "dn", "string", VersionMeta.Version131a, MoPropertyMeta.READ_ONLY, 0x4, 0, 256, None, [], []), 
        "name": MoPropertyMeta("name", "name", "string", VersionMeta.Version131a, MoPropertyMeta.READ_WRITE, 0x8, 0, 510, None, [], []), 
        "object_type": MoPropertyMeta("object_type", "objectType", "string", VersionMeta.Version131a, MoPropertyMeta.READ_ONLY, None, None, None, None, ["aaaAuthMethod", "aaaAuthRealm", "aaaAuthRealmFsm", "aaaAuthRealmFsmStage", "aaaConfig", "aaaConsoleAuth", "aaaDefaultAuth", "aaaDefinition", "aaaDomain", "aaaDomainAuth", "aaaDomainGroup", "aaaEp", "aaaEpAuthProfile", "aaaEpFsm", "aaaEpFsmStage", "aaaEpFsmTask", "aaaEpLogin", "aaaEpUser", "aaaExtMgmtCutThruTkn", "aaaItem", "aaaLdapEp", "aaaLdapEpFsm", "aaaLdapEpFsmStage", "aaaLdapGroup", "aaaLdapGroupRule", "aaaLdapProvider", "aaaLocale", "aaaLog", "aaaModLR", "aaaOrg", "aaaProvider", "aaaProviderGroup", "aaaProviderRef", "aaaPwdProfile", "aaaRadiusEp", "aaaRadiusEpFsm", "aaaRadiusEpFsmStage", "aaaRadiusProvider", "aaaRealm", "aaaRealmFsm", "aaaRealmFsmStage", "aaaRealmFsmTask", "aaaRemoteUser", "aaaRole", "aaaSession", "aaaSessionLR", "aaaShellLogin", "aaaSshAuth", "aaaSystemUser", "aaaTacacsPlusEp", "aaaTacacsPlusEpFsm", "aaaTacacsPlusEpFsmStage", "aaaTacacsPlusProvider", "aaaUser", "aaaUserAction", "aaaUserData", "aaaUserEp", "aaaUserEpFsm", "aaaUserEpFsmStage", "aaaUserEpFsmTask", "aaaUserGroup", "aaaUserLocale", "aaaUserLogin", "aaaUserPreferences", "aaaUserRole", "aaaWebLogin", "adaptorBehCap", "adaptorCapDef", "adaptorCapQual", "adaptorCapSpec", "adaptorEthAdvFilterProfile", "adaptorEthArfsProfile", "adaptorEthCompQueueProfile", "adaptorEthFailoverProfile", "adaptorEthGENEVEProfile", "adaptorEthInterruptProfile", "adaptorEthInterruptScalingProfile", "adaptorEthNVGREProfile", "adaptorEthOffloadProfile", "adaptorEthPortBySizeLargeStats", "adaptorEthPortBySizeLargeStatsHist", "adaptorEthPortBySizeSmallStats", "adaptorEthPortBySizeSmallStatsHist", "adaptorEthPortErrStats", "adaptorEthPortErrStatsHist", "adaptorEthPortMcastStats", "adaptorEthPortMcastStatsHist", "adaptorEthPortOutsizedStats", "adaptorEthPortOutsizedStatsHist", "adaptorEthPortStats", "adaptorEthPortStatsHist", "adaptorEthQueueProfile", "adaptorEthRecvQueueProfile", "adaptorEthRoCEProfile", "adaptorEthVxLANProfile", "adaptorEthWorkQueueProfile", "adaptorEtherIfStats", "adaptorEtherIfStatsHist", "adaptorExtEthIf", "adaptorExtEthIfOperation", "adaptorExtIf", "adaptorExtIpV6RssHashProfile", "adaptorFcCdbWorkQueueProfile", "adaptorFcErrorRecoveryProfile", "adaptorFcFnicProfile", "adaptorFcIfEventStats", "adaptorFcIfEventStatsHist", "adaptorFcIfFC4Stats", "adaptorFcIfFC4StatsHist", "adaptorFcIfFrameStats", "adaptorFcIfFrameStatsHist", "adaptorFcInterruptProfile", "adaptorFcLogiProfile", "adaptorFcPortFLogiProfile", "adaptorFcPortPLogiProfile", "adaptorFcPortProfile", "adaptorFcPortStats", "adaptorFcPortStatsHist", "adaptorFcQueueProfile", "adaptorFcRecvQueueProfile", "adaptorFcWorkQueueProfile", "adaptorFruCapProvider", "adaptorHBAVnicStats", "adaptorHBAVnicStatsHist", "adaptorHostEthIf", "adaptorHostEthIfOperation", "adaptorHostEthIfProfile", "adaptorHostFcIf", "adaptorHostFcIfOperation", "adaptorHostFcIfProfile", "adaptorHostIf", "adaptorHostIfConfig", "adaptorHostIfConnDef", "adaptorHostIfProfile", "adaptorHostIscsiIf", "adaptorHostIscsiIfOperation", "adaptorHostIscsiIfProfile", "adaptorHostScsiIf", "adaptorHostScsiLunRef", "adaptorHwAddrCap", "adaptorIScsiCap", "adaptorIpV4RssHashProfile", "adaptorIpV6RssHashProfile", "adaptorMenloBaseErrorStats", "adaptorMenloBaseErrorStatsHist", "adaptorMenloDcePortStats", "adaptorMenloDcePortStatsHist", "adaptorMenloEthErrorStats", "adaptorMenloEthErrorStatsHist", "adaptorMenloEthStats", "adaptorMenloEthStatsHist", "adaptorMenloFcErrorStats", "adaptorMenloFcErrorStatsHist", "adaptorMenloFcStats", "adaptorMenloFcStatsHist", "adaptorMenloHostPortStats", "adaptorMenloHostPortStatsHist", "adaptorMenloMcpuErrorStats", "adaptorMenloMcpuErrorStatsHist", "adaptorMenloMcpuStats", "adaptorMenloMcpuStatsHist", "adaptorMenloNetEgStats", "adaptorMenloNetEgStatsHist", "adaptorMenloNetInStats", "adaptorMenloNetInStatsHist", "adaptorMenloQErrorStats", "adaptorMenloQErrorStatsHist", "adaptorMenloQStats", "adaptorMenloQStatsHist", "adaptorNICVnicStats", "adaptorNICVnicStatsHist", "adaptorProfileItem", "adaptorProtocolProfile", "adaptorQual", "adaptorQueueProfile", "adaptorRnicCapSpec", "adaptorRssHashProfile", "adaptorRssProfile", "adaptorTcpIpRssHashProfile", "adaptorUnit", "adaptorUnitAssocCtx", "adaptorUnitExtn", "adaptorUsnicConnDef", "adaptorVlan", "adaptorVmmqConnDef", "adaptorVnicStats", "adaptorVnicStatsHist", "biosBOT", "biosBootDev", "biosBootDevGrp", "biosTokenFeatureGroup", "biosTokenParam", "biosTokenSettings", "biosUnit", "biosVFeat", "biosVProfile", "biosVfACPI10Support", "biosVfASPMSupport", "biosVfAllUSBDevices", "biosVfAltitude", "biosVfAssertNMIOnPERR", "biosVfAssertNMIOnSERR", "biosVfBootOptionRetry", "biosVfCPUHardwarePowerManagement", "biosVfCPUPerformance", "biosVfCPUPowerManagement", "biosVfConsistentDeviceNameControl", "biosVfConsoleRedirection", "biosVfCoreMultiProcessing", "biosVfDDR3VoltageSelection", "biosVfDRAMClockThrottling", "biosVfDirectCacheAccess", "biosVfDramRefreshRate", "biosVfEnergyPerformanceTuning", "biosVfEnhancedIntelSpeedStepTech", "biosVfEnhancedPowerCappingSupport", "biosVfExecuteDisableBit", "biosVfFRB2Timer", "biosVfFrequencyFloorOverride", "biosVfFrontPanelLockout", "biosVfIOEMezz1OptionROM", "biosVfIOENVMe1OptionROM", "biosVfIOENVMe2OptionROM", "biosVfIOESlot1OptionROM", "biosVfIOESlot2OptionROM", "biosVfIntegratedGraphics", "biosVfIntegratedGraphicsApertureSize", "biosVfIntelEntrySASRAIDModule", "biosVfIntelHyperThreadingTech", "biosVfIntelTrustedExecutionTechnology", "biosVfIntelTurboBoostTech", "biosVfIntelVTForDirectedIO", "biosVfIntelVirtualizationTechnology", "biosVfInterleaveConfiguration", "biosVfLocalX2Apic", "biosVfLvDIMMSupport", "biosVfMaxVariableMTRRSetting", "biosVfMaximumMemoryBelow4GB", "biosVfMemoryMappedIOAbove4GB", "biosVfMirroringMode", "biosVfNUMAOptimized", "biosVfOSBootWatchdogTimer", "biosVfOSBootWatchdogTimerPolicy", "biosVfOSBootWatchdogTimerTimeout", "biosVfOnboardGraphics", "biosVfOnboardSATAController", "biosVfOnboardStorage", "biosVfOptionROMEnable", "biosVfOptionROMLoad", "biosVfOutOfBandManagement", "biosVfPCHSATAMode", "biosVfPCILOMPortsConfiguration", "biosVfPCIROMCLP", "biosVfPCISlotLinkSpeed", "biosVfPCISlotOptionROMEnable", "biosVfPOSTErrorPause", "biosVfPSTATECoordination", "biosVfPackageCStateLimit", "biosVfProcessorC1E", "biosVfProcessorC3Report", "biosVfProcessorC6Report", "biosVfProcessorC7Report", "biosVfProcessorCMCI", "biosVfProcessorCState", "biosVfProcessorEnergyConfiguration", "biosVfProcessorPrefetchConfig", "biosVfQPILinkFrequencySelect", "biosVfQPISnoopMode", "biosVfQuietBoot", "biosVfRedirectionAfterBIOSPOST", "biosVfResumeOnACPowerLoss", "biosVfSBMezz1OptionROM", "biosVfSBNVMe1OptionROM", "biosVfSIOC1OptionROM", "biosVfSIOC2OptionROM", "biosVfScrubPolicies", "biosVfSelectMemoryRASConfiguration", "biosVfSerialPortAEnable", "biosVfSparingMode", "biosVfSriovConfig", "biosVfTPMPendingOperation", "biosVfTPMSupport", "biosVfTrustedPlatformModule", "biosVfUCSMBootModeControl", "biosVfUCSMBootOrderRuleControl", "biosVfUEFIOSUseLegacyVideo", "biosVfUSBBootConfig", "biosVfUSBConfiguration", "biosVfUSBFrontPanelAccessLock", "biosVfUSBPortConfiguration", "biosVfUSBSystemIdlePowerOptimizingSetting", "biosVfVGAPriority", "biosVfWorkloadConfiguration", "callhomeDest", "callhomeEp", "callhomeFaultInst", "callhomeHolder", "callhomeHolderFsm", "callhomeHolderFsmStage", "callhomeHolderFsmTask", "callhomeHttp", "callhomeItem", "callhomePeriodicSystemInventory", "callhomePolicy", "callhomeProfile", "callhomeSmtp", "callhomeSource", "callhomeTestAlert", "capabilityCatalogue", "capabilityDef", "capabilityItem", "capabilityProvider", "certRepairEp", "certRepairEpFsm", "certRepairEpFsmStage", "certRepairEpFsmTask", "changeChangedObjectRef", "changeEp", "changeEpFsm", "changeEpFsmStage", "changeEpFsmTask", "cimcvmediaActualMountEntry", "cimcvmediaActualMountList", "cimcvmediaConfigMountEntry", "cimcvmediaExtMgmtRuleEntry", "cimcvmediaItem", "cimcvmediaMountConfig", "cimcvmediaMountConfigDef", "cimcvmediaMountConfigPolicy", "cimcvmediaMountInfo", "clitestTypeTest", "clitestTypeTest2", "clitestTypeTestChild", "clitestTypeTestParent", "commCimxml", "commClient", "commClientItem", "commCoreFile", "commDateTime", "commDateTimeFsm", "commDateTimeFsmStage", "commDateTimeFsmTask", "commDefinition", "commDns", "commDnsProvider", "commEvtChannel", "commHttp", "commHttps", "commItem", "commLocale", "commLogComponent", "commNtp", "commNtpProvider", "commShell", "commShellSvcLimits", "commSmashCLP", "commSnmp", "commSnmpCommunity", "commSnmpTrap", "commSnmpTrapData", "commSnmpUser", "commSsh", "commSvc", "commSvcChannel", "commSvcEp", "commSvcEpFsm", "commSvcEpFsmStage", "commSvcEpFsmTask", "commSvcLimits", "commSvcPolicy", "commSyslog", "commSyslogClient", "commSyslogConsole", "commSyslogFile", "commSyslogMonitor", "commSyslogSource", "commTelnet", "commWeb", "commWebChannel", "commWebSvcLimits", "commWsman", "commXmlClConnPolicy", "computeABoard", "computeAChassisDiscPolicy", "computeAOperation", "computeAutoconfigPolicy", "computeBaseSystem", "computeBlade", "computeBladeDiscPolicy", "computeBladeEp", "computeBladeInheritPolicy", "computeBladePosQual", "computeBoard", "computeBoardConnector", "computeBoardController", "computeCartridge", "computeCartridgeOperation", "computeChassisConnPolicy", "computeChassisConnPolicyOperation", "computeChassisDiscPolicy", "computeChassisFeatMask", "computeChassisQual", "computeComputeDiscPolicy", "computeConfigPolicy", "computeContainer", "computeDefinition", "computeDiscPolicy", "computeDomainGroupQual", "computeDomainHwChangeDiscPolicy", "computeDomainNameQual", "computeDomainPortDiscPolicy", "computeDomainQual", "computeEnvFeatMask", "computeExtBoard", "computeFabricEthMonSrcEp", "computeFabricEthMonSrcEpCont", "computeFabricFcMonSrcEp", "computeFabricFcMonSrcEpCont", "computeFabricMonSrcEp", "computeFactoryResetOp", "computeFactoryResetOperation", "computeFaultUpgradeFlag", "computeFeatMask", "computeGraphicsCardPolicy", "computeGroupMembership", "computeGroupMembershipRef", "computeHwChangeDiscPolicy", "computeIOHub", "computeIOHubEnvStats", "computeIOHubEnvStatsHist", "computeInitConfigPolicy", "computeInstance", "computeInstanceIdQual", "computeInstanceMapping", "computeItem", "computeLocalTemplDef", "computeLogical", "computeMbPowerStats", "computeMbPowerStatsHist", "computeMbTempStats", "computeMbTempStatsHist", "computeNetworkFeatMask", "computeOwnerQual", "computePCIeFatalCompletionStats", "computePCIeFatalCompletionStatsHist", "computePCIeFatalProtocolStats", "computePCIeFatalProtocolStatsHist", "computePCIeFatalReceiveStats", "computePCIeFatalReceiveStatsHist", "computePCIeFatalStats", "computePCIeFatalStatsHist", "computePhysical", "computePhysicalAssocCtx", "computePhysicalExtension", "computePhysicalOperation", "computePhysicalQual", "computePlaceable", "computePlaced", "computePool", "computePoolPolicyRef", "computePoolable", "computePooled", "computePooledEnclosureComputeSlot", "computePooledPhysical", "computePooledRackUnit", "computePooledSlot", "computePoolingPolicy", "computePortDiscPolicy", "computePowerSyncDef", "computePowerSyncPolicy", "computeProductFamilyQual", "computeProfile", "computePsuDef", "computePsuPolicy", "computeQual", "computeQualBase", "computeQualItem", "computeQualifiedPolicy", "computeRackPosQual", "computeRackQual", "computeRackUnit", "computeRackUnitMbTempStats", "computeRackUnitMbTempStatsHist", "computeRebootLog", "computeRemoteOpStatus", "computeRequirement", "computeResourceAggrEp", "computeResourceSet", "computeResourceSetManager", "computeResourceSetMember", "computeScrubPolicy", "computeServer", "computeServerDiscPolicy", "computeServerFeatMask", "computeServerMgmtPolicy", "computeServerUnit", "computeSession", "computeSiteQual", "computeSlotEntity", "computeSlotQual", "computeStorageFeatMask", "computeSystem", "computeSystemAddrQual", "computeSystemFsm", "computeSystemFsmStage", "computeSystemFsmTask", "computeSystemQual", "computeTemplate", "computeTemplateMapping", "computeUser", "computeUserEp", "conditionImmutable", "conditionInfo", "conditionLog", "conditionLoggable", "conditionMultiInstanceImmutable", "conditionMutable", "conditionPolicy", "conditionReportable", "configAbsDbConfig", "configAckItem", "configAdaptorItem", "configAppImpactResponse", "configBackup", "configBackupFsm", "configBackupFsmStage", "configBackupFsmTask", "configCartridgeFilter", "configCartridgeItem", "configCatalogue", "configChassisFilter", "configChassisItem", "configComponentsFilter", "configConsumerCatalogue", "configConsumerCatalogueFsm", "configConsumerCatalogueFsmStage", "configConsumerCatalogueFsmTask", "configControllerItem", "configCpuInfo", "configCpuItem", "configCryptoCardItem", "configDbConfig", "configDomainFilter", "configDomainItem", "configFabricInterconnectFilter", "configFabricInterconnectItem", "configFanItem", "configFexFilter", "configFexItem", "configFilterGroup", "configFilterItem", "configFsm", "configFsmStage", "configGraphicsCardItem", "configIOMItem", "configImpact", "configImpactAnalyzer", "configImpactAnalyzerEp", "configImpactResponse", "configInputConfig", "configInputConfigSet", "configLocalDiskItem", "configLunItem", "configManagedEpImpactResponse", "configMemoryItem", "configMotherboardItem", "configNetRefItem", "configOrgItem", "configPSUItem", "configPolicyUsageItem", "configPortItem", "configSearchOptions", "configSearchResult", "configServerFilter", "configServerItem", "configServiceProfileFilter", "configSorter", "configSpotLightItem", "configStorageArrayProfileFilter", "configStorageBladeFilter", "configStorageItem", "configUCImpact", "consumerInst", "consumerInstFsm", "consumerInstFsmStage", "consumerInstFsmTask", "consumerUniverse", "controllerEp", "controllerEpFsm", "controllerEpFsmStage", "controllerEpFsmTask", "cpmaintAck", "cpmaintMaintPolicy", "dcxVIf", "dcxVc", "diagCtrl", "diagLogEp", "diagMemoryTest", "diagRslt", "diagRunPolicy", "diagSrvCapProvider", "diagSrvCtrl", "diagSrvCtrlOperation", "diagSrvCtrlOperationFsm", "diagSrvCtrlOperationFsmStage", "diagSrvCtrlOperationFsmTask", "diagTest", "domainChassisFeature", "domainChassisParam", "domainChassisProfileItem", "domainEnvironmentFeature", "domainEnvironmentParam", "domainEp", "domainFamilyCapProvider", "domainFeature", "domainFeatureCatalog", "domainNetworkFeature", "domainNetworkParam", "domainParameter", "domainProfile", "domainProfileFsm", "domainProfileFsmStage", "domainProfileFsmTask", "domainServerFeature", "domainServerParam", "domainServiceProfileItem", "domainStorageFeature", "domainStorageParam", "dpsecMac", "dupeChangeTracker", "dupeChangeTrackerEp", "dupeChangeTrackerEpFsm", "dupeChangeTrackerEpFsmStage", "dupeChangeTrackerEpFsmTask", "dupeEp", "dupeExtRequestor", "dupeIntRequestor", "dupeRequestor", "dupeScope", "dupeScopeEp", "dupeScopeResult", "epqosDefinition", "epqosEgress", "epqosItem", "equipmentABehCap", "equipmentAdvancedBootOrder", "equipmentAssocCtx", "equipmentBeaconLed", "equipmentBehCap", "equipmentBinding", "equipmentBladeCapProvider", "equipmentBreakoutCap", "equipmentCPMeta", "equipmentCard", "equipmentCartridgeCapProvider", "equipmentChassis", "equipmentChassisAssocCtx", "equipmentChassisCapProvider", "equipmentChassisIssues", "equipmentChassisOperation", "equipmentChassisPosQual", "equipmentChassisProfile", "equipmentChassisProfileAssocCtx", "equipmentChassisProfileBinding", "equipmentChassisProfileFsm", "equipmentChassisProfileFsmStage", "equipmentChassisProfileFsmTask", "equipmentChassisQual", "equipmentChassisRequirement", "equipmentChassisStats", "equipmentChassisStatsHist", "equipmentCimcVmedia", "equipmentComputeConn", "equipmentComputeConnPolicy", "equipmentComputePhysicalCapProvider", "equipmentDefinition", "equipmentDriveSecCap", "equipmentFan", "equipmentFanModule", "equipmentFanModuleCapProvider", "equipmentFanModuleStats", "equipmentFanModuleStatsHist", "equipmentFanStats", "equipmentFanStatsHist", "equipmentFex", "equipmentFexCapProvider", "equipmentFexEnvStats", "equipmentFexEnvStatsHist", "equipmentFexOperation", "equipmentFexPowerSummary", "equipmentFexPowerSummaryHist", "equipmentFexPsuInputStats", "equipmentFexPsuInputStatsHist", "equipmentFruCapProvider", "equipmentFruVariant", "equipmentGemCapProvider", "equipmentHealthLed", "equipmentHolder", "equipmentHolderCapProvider", "equipmentHostIfCapProvider", "equipmentHwCapProvider", "equipmentIOCard", "equipmentIOCardBase", "equipmentIOCardCapProvider", "equipmentIOCardStats", "equipmentIOCardStatsHist", "equipmentImpliedStorageEnclosureDef", "equipmentIndicatorLed", "equipmentInstance", "equipmentInstanceMapping", "equipmentIntegratedComponentCapProvider", "equipmentItem", "equipmentLed", "equipmentLocalDiskCapProvider", "equipmentLocalDiskControllerCapProvider", "equipmentLocalDiskDef", "equipmentLocalTemplDef", "equipmentLocatorLed", "equipmentLocatorLedOperation", "equipmentManufacturingDef", "equipmentMemoryUnitCapProvider", "equipmentNetworkElementFanStats", "equipmentNetworkElementFanStatsHist", "equipmentPciDef", "equipmentPhysicalQual", "equipmentPicture", "equipmentPlaceable", "equipmentPlaced", "equipmentPool", "equipmentPoolable", "equipmentPooled", "equipmentPoolingPolicy", "equipmentProcessorUnitCapProvider", "equipmentPsu", "equipmentPsuCapProvider", "equipmentPsuInputStats", "equipmentPsuInputStatsHist", "equipmentPsuOutputStats", "equipmentPsuOutputStatsHist", "equipmentPsuStats", "equipmentPsuStatsHist", "equipmentQual", "equipmentQualBase", "equipmentQualItem", "equipmentQualifiedPolicy", "equipmentRackUnitCapProvider", "equipmentRackUnitFanStats", "equipmentRackUnitFanStatsHist", "equipmentRackUnitPsuStats", "equipmentRackUnitPsuStatsHist", "equipmentRequirement", "equipmentSecureBoot", "equipmentServerFeatureCap", "equipmentServerUnitCapProvider", "equipmentSharedIOModule", "equipmentSiocTempStats", "equipmentSiocTempStatsHist", "equipmentSlotEnclosure", "equipmentStateful", "equipmentStatefulBladeComp", "equipmentStatefulChComp", "equipmentStorageProcessorCap", "equipmentSwitchCapProvider", "equipmentSwitchCard", "equipmentSwitchIOCard", "equipmentSwitchIOCardCapProvider", "equipmentSystemFruCapProvider", "equipmentSystemIOController", "equipmentSystemIOControllerOperation", "equipmentTemplate", "equipmentTemplateMapping", "equipmentTier", "equipmentUnifiedPortCapProvider", "equipmentXcvr", "etherErrStats", "etherErrStatsHist", "etherFcoeInterfaceStats", "etherFcoeInterfaceStatsHist", "etherLossStats", "etherLossStatsHist", "etherPIo", "etherPauseStats", "etherPauseStatsHist", "etherRxStats", "etherRxStatsHist", "etherServerIntFIo", "etherSwitchIntFIo", "etherTxStats", "etherTxStatsHist", "eventApplication", "eventEpCtrl", "eventHolder", "eventInst", "eventLog", "eventPolicy", "eventRecord", "extmgmtArpTargets", "extmgmtGatewayPing", "extmgmtIfMonPolicy", "extmgmtMiiStatus", "extmgmtNdiscTargets", "extpolClient", "extpolClientCont", "extpolClientFsm", "extpolClientFsmStage", "extpolClientFsmTask", "extpolConnector", "extpolConnectorContainer", "extpolController", "extpolControllerCont", "extpolDomain", "extpolEp", "extpolEpFsm", "extpolEpFsmStage", "extpolEpFsmTask", "extpolHBStatus", "extpolProvider", "extpolProviderCont", "extpolRegistry", "extpolRegistryCapability", "extpolSvc", "extpolSystemContext", "extpolVersionHolder", "extvmmNetworkSets", "extvmmVMNetworkSets", "fabricADceSwSrvEp", "fabricAEthEstcEp", "fabricAEthLanEp", "fabricAFcEstcEp", "fabricAFcSanEp", "fabricAFcoeEstcEp", "fabricAFcoeSanEp", "fabricAGroupReq", "fabricANetGroup", "fabricANetGroupRef", "fabricASanGroup", "fabricAVlan", "fabricAVsan", "fabricBaseNetGroup", "fabricBasePhEp", "fabricBaseSlotEp", "fabricBreakout", "fabricBreakoutOperation", "fabricCIoEp", "fabricCabling", "fabricCablingSw", "fabricCartridgeSlotEp", "fabricCartridgeSlotEpOperation", "fabricCdpLinkPolicy", "fabricChangedObjectRef", "fabricChassisEp", "fabricCloud", "fabricComputeEp", "fabricComputeMSlotEp", "fabricComputePhEp", "fabricComputePhEpOperation", "fabricComputeSlotEp", "fabricComputeSlotEpOperation", "fabricConsumer", "fabricDceSrv", "fabricDceSwSrv", "fabricDceSwSrvEp", "fabricDceSwSrvEpOperation", "fabricDceSwSrvPc", "fabricDceSwSrvPcEp", "fabricDceSwSrvPcEpOperation", "fabricDceSwSrvPcOperation", "fabricDceSwSrvPcOperationFsm", "fabricDceSwSrvPcOperationFsmStage", "fabricDomain", "fabricDomainEp", "fabricEnclosurePhEp", "fabricEnclosurePhEpOperation", "fabricEnclosureSlotEp", "fabricEnclosureSlotEpOperation", "fabricEp", "fabricEpVlan", "fabricEpVsan", "fabricEquipmentEp", "fabricEstcEp", "fabricEstcPc", "fabricEthCdpPolicy", "fabricEthEstc", "fabricEthEstcCloud", "fabricEthEstcEp", "fabricEthEstcEpOperation", "fabricEthEstcEpOperationFsm", "fabricEthEstcEpOperationFsmStage", "fabricEthEstcPc", "fabricEthEstcPcEp", "fabricEthEstcPcEpOperation", "fabricEthEstcPcOperation", "fabricEthEstcPcOperationFsm", "fabricEthEstcPcOperationFsmStage", "fabricEthLan", "fabricEthLanEp", "fabricEthLanEpOperation", "fabricEthLanEpOperationFsm", "fabricEthLanEpOperationFsmStage", "fabricEthLanPc", "fabricEthLanPcEp", "fabricEthLanPcEpOperation", "fabricEthLanPcOperation", "fabricEthLanPcOperationFsm", "fabricEthLanPcOperationFsmStage", "fabricEthLinkPolicy", "fabricEthLinkProfile", "fabricEthMon", "fabricEthMonDestEp", "fabricEthMonDestEpOperation", "fabricEthMonLan", "fabricEthMonOperation", "fabricEthMonOperationFsm", "fabricEthMonOperationFsmStage", "fabricEthMonSrcEp", "fabricEthMonSrcEpOperation", "fabricEthMonSrcRef", "fabricEthPortOperation", "fabricEthPortOperationFsm", "fabricEthPortOperationFsmStage", "fabricEthTargetEp", "fabricEthTargetEpOperation", "fabricEthUdldPolicy", "fabricEthVlanPc", "fabricEthVlanPortEp", "fabricEtherRef", "fabricExtension", "fabricExternal", "fabricExternalEp", "fabricExternalEstc", "fabricExternalPc", "fabricFIPortOperation", "fabricFIPortOperationFsm", "fabricFIPortOperationFsmStage", "fabricFIPortOperationFsmTask", "fabricFcEndpoint", "fabricFcEstc", "fabricFcEstcCloud", "fabricFcEstcEp", "fabricFcEstcEpOperation", "fabricFcEstcEpOperationFsm", "fabricFcEstcEpOperationFsmStage", "fabricFcMon", "fabricFcMonDestEp", "fabricFcMonDestEpOperation", "fabricFcMonOperation", "fabricFcMonOperationFsm", "fabricFcMonOperationFsmStage", "fabricFcMonSan", "fabricFcMonSrcEp", "fabricFcMonSrcEpOperation", "fabricFcMonSrcRef", "fabricFcPortOperation", "fabricFcPortOperationFsm", "fabricFcPortOperationFsmStage", "fabricFcSan", "fabricFcSanEp", "fabricFcSanEpOperation", "fabricFcSanEpOperationFsm", "fabricFcSanEpOperationFsmStage", "fabricFcSanPc", "fabricFcSanPcEp", "fabricFcSanPcEpOperation", "fabricFcSanPcOperation", "fabricFcSanPcOperationFsm", "fabricFcSanPcOperationFsmStage", "fabricFcUplinkOperation", "fabricFcUserZone", "fabricFcUserZoneIvt", "fabricFcVsanPc", "fabricFcVsanPortEp", "fabricFcZoneProfile", "fabricFcZoneProfileFsm", "fabricFcZoneProfileFsmStage", "fabricFcZoneProfileFsmTask", "fabricFcZoneProfileIvt", "fabricFcoeEstcEp", "fabricFcoeEstcEpOperation", "fabricFcoeEstcEpOperationFsm", "fabricFcoeEstcEpOperationFsmStage", "fabricFcoeSanEp", "fabricFcoeSanEpOperation", "fabricFcoeSanEpOperationFsm", "fabricFcoeSanEpOperationFsmStage", "fabricFcoeSanPc", "fabricFcoeSanPcEp", "fabricFcoeSanPcEpOperation", "fabricFcoeSanPcOperation", "fabricFcoeSanPcOperationFsm", "fabricFcoeSanPcOperationFsmStage", "fabricFcoeVsanPc", "fabricFcoeVsanPortEp", "fabricHolder", "fabricIf", "fabricInternal", "fabricInternalDceSrv", "fabricInternalEp", "fabricInternalPc", "fabricLacpPolicy", "fabricLan", "fabricLanAccessMgr", "fabricLanCloud", "fabricLanCloudPolicy", "fabricLanEp", "fabricLanMonCloud", "fabricLanPc", "fabricLanPinGroup", "fabricLanPinGroupOperation", "fabricLanPinTarget", "fabricLanPinTargetOperation", "fabricLastAckedSlot", "fabricLinkPolicy", "fabricMon", "fabricMonDestEp", "fabricMonSrcEp", "fabricMonSrcRef", "fabricMulticastPolicy", "fabricNetGroup", "fabricNetGroupEp", "fabricNetGroupPermit", "fabricNetGroupRef", "fabricNetGroupReq", "fabricOrgVlanPolicy", "fabricPIoEp", "fabricPinGroup", "fabricPinTarget", "fabricPoolableVlan", "fabricPooledVlan", "fabricSan", "fabricSanCloud", "fabricSanEp", "fabricSanGroup", "fabricSanGroupRef", "fabricSanMonCloud", "fabricSanPc", "fabricSanPinGroup", "fabricSanPinGroupOperation", "fabricSanPinTarget", "fabricSanPinTargetOperation", "fabricSubGroup", "fabricSwChEp", "fabricSwChPhEp", "fabricSwChPhEpOperation", "fabricSwSrvEp", "fabricSwSrvPc", "fabricSwSubGroup", "fabricSystem", "fabricTargetEp", "fabricUdldLinkPolicy", "fabricUdldPolicy", "fabricVCon", "fabricVConProfile", "fabricVlan", "fabricVlanEp", "fabricVlanGroupReq", "fabricVlanPermit", "fabricVlanPermitItem", "fabricVlanReq", "fabricVnetEp", "fabricVnetEpSyncEp", "fabricVnetEpSyncEpFsm", "fabricVnetEpSyncEpFsmStage", "fabricVnetEpSyncEpFsmTask", "fabricVnetGroupReq", "fabricVnetReq", "fabricVsan", "fabricVsanEp", "fabricVsanMembership", "faultBaseHolder", "faultBasePolicy", "faultBaseTypedHolder", "faultDomainEp", "faultDomainInst", "faultGlobalSeverityHolder", "faultGlobalTypedHolder", "faultHolder", "faultInst", "faultLocalBaseHolder", "faultLocalTypedHolder", "faultPolicy", "faultSummary", "faultSummaryInst", "faultSvcSummary", "faultTypedHolder", "fcErrStats", "fcErrStatsHist", "fcPIo", "fcStats", "fcStatsHist", "fcpoolAddr", "fcpoolBlock", "fcpoolBootTarget", "fcpoolFormat", "fcpoolInitiator", "fcpoolInitiatorEp", "fcpoolInitiators", "fcpoolUniverse", "fdBlade", "fdBladeFsm", "fdBladeFsmStage", "fdChassis", "fdOperable", "fdPhysical", "fdPhysicalFsm", "fdPhysicalFsmStage", "fdPhysicalFsmTask", "fdRackUnit", "fdRackUnitFsm", "fdRackUnitFsmStage", "featureCatalogEp", "featureChassisDef", "featureDefinition", "featureEnvDef", "featureNetworkDef", "featureServerDef", "featureStorageDef", "firmwareAComponentSpec", "firmwareAExcludeComponent", "firmwareAInfraPack", "firmwareAck", "firmwareAutoSyncPolicy", "firmwareBootDefinition", "firmwareBootUnit", "firmwareBundleInfo", "firmwareBundleInfoDigest", "firmwareBundleType", "firmwareBundleTypeCapProvider", "firmwareCapProvider", "firmwareCatalogPack", "firmwareCatalogPackConfig", "firmwareCatalogue", "firmwareChassisComponentSpec", "firmwareChassisPack", "firmwareCompItem", "firmwareCompSource", "firmwareCompTarget", "firmwareComponentSpec", "firmwareComputeHostPack", "firmwareComputeMgmtPack", "firmwareComputePack", "firmwareComputeStoragePack", "firmwareConnectionPolicy", "firmwareDependency", "firmwareDistImage", "firmwareDistributable", "firmwareDistributableFsm", "firmwareDistributableFsmStage", "firmwareDistributableFsmTask", "firmwareDomainInfo", "firmwareDomainInfraProfile", "firmwareDownloadPolicy", "firmwareDownloader", "firmwareDownloaderFsm", "firmwareDownloaderFsmStage", "firmwareDownloaderFsmTask", "firmwareExcludeChassisComponent", "firmwareExcludeServerComponent", "firmwareImage", "firmwareInfra", "firmwareInfraPack", "firmwareInfraPackConfig", "firmwareInfraPolicy", "firmwareInstallImpact", "firmwarePack", "firmwarePolicy", "firmwareProductFamily", "firmwareRemoteCatalogue", "firmwareRunning", "firmwareSource", "firmwareStatus", "firmwareStoragePack", "firmwareSystem", "firmwareType", "firmwareUnit", "firmwareUpdatable", "firmwareUpgradeDetail", "firmwareUpgradeInfo", "flowctrlDefinition", "flowctrlItem", "fsmFsm", "fsmStage", "fsmStatus", "fsmTask", "glAbsConflict", "glAbsEp", "glAbsIdentCtxOp", "glAbsInv", "glAbsOperation", "glAbsPolicyInv", "glAbsPolicyOp", "glAbsPolicyRule", "glAbsRequest", "glAbsResEp", "glAbsRule", "glAbsVnetInv", "glAppendRule", "glBlockEp", "glBlockOp", "glByMo", "glComplexRefEp", "glConflictEp", "glConflictResolutionRuleEp", "glDomainEp", "glEp", "glGlobalDefaultPolicyEp", "glIdRef", "glIdRefEp", "glIdable", "glIdentCtxEp", "glIdentCtxOp", "glIdentCtxResOp", "glIdentCtxResOpFsm", "glIdentCtxResOpFsmStage", "glIdentCtxResOpFsmTask", "glInventoryEp", "glLsp", "glMcastPolicy", "glOperationEp", "glPathEp", "glPolicy", "glPolicyAlgorithmedOp", "glPolicyEp", "glPolicyInvEp", "glPolicyNameRuleEp", "glPolicyOp", "glPolicyRef", "glPolicyRefEp", "glPolicyResOp", "glPolicyResolutionEp", "glPool", "glPoolEp", "glPoolInvEp", "glPoolOp", "glRefable", "glRefsEp", "glRequest", "glRequestFsm", "glRequestFsmStage", "glRequestFsmTask", "glRequestVnetEp", "glRequestVnetEpDomainEp", "glRequestVnetEpDomainEpFsm", "glRequestVnetEpDomainEpFsmStage", "glRequestVnetEpDomainEpFsmTask", "glRequestVnetEpFsm", "glRequestVnetEpFsmStage", "glRequestVnetEpFsmTask", "glRequestVnetEpHolder", "glRequestor", "glRequestorEp", "glSPInvEp", "glServerPoolResOp", "glServiceProfile", "glSpDefEp", "glTemplateEp", "glTemplateOp", "glTemplateResOp", "glUsage", "glUsageEp", "glVlan", "glVnetInvHolder", "glVnicTemplate", "glVnicTemplateEp", "glVsan", "glVxanEp", "glVxanOp", "glVxanResOp", "gmetaClass", "gmetaPolicyMapElement", "gmetaProp", "graphicsCard", "graphicsController", "guiGuiComponent", "guiGuiCont", "hcAComponent", "hcAItem", "hcAStatusItem", "hcAdapterFirmwareItem", "hcAdapterItem", "hcAdmin", "hcCatalog", "hcCatalogList", "hcCatalogSource", "hcCatalogVersion", "hcCleanup", "hcDownloadPolicy", "hcDownloader", "hcDriverInfoItem", "hcDriverItem", "hcHolder", "hcItemNote", "hcOsInfoItem", "hcOsItem", "hcReport", "hcScopeDn", "hcServerComponent", "hcSupportedAdapterFirmwareItem", "hcSupportedAdapterItem", "hcSupportedDriverItem", "hcSupportedOsItem", "hcUcsVersionItem", "identDomainSyncEp", "identExecutionEp", "identExecutionRequestEp", "identIdentCtx", "identIdentRequest", "identIdentRequestFsm", "identIdentRequestFsmStage", "identIdentRequestFsmTask", "identMetaSystem", "identMetaSystemFsm", "identMetaSystemFsmStage", "identMetaSystemFsmTask", "identMetaVerse", "identRequestEp", "identSysInfo", "identpoolBlockQual", "identpoolConsumed", "identpoolDomain", "identpoolDomainGroupQual", "identpoolElement", "identpoolIPQual", "identpoolIPV6Qual", "identpoolMetaSystem", "identpoolMetaVerse", "identpoolPool", "identpoolPoolable", "identpoolQualItem", "identpoolUniverse", "inbandPolicy", "initiatorEp", "initiatorFcInitiatorEp", "initiatorGroupEp", "initiatorIScsiInitiatorEp", "initiatorInitiatorEp", "initiatorLunEp", "initiatorMemberEp", "initiatorRequestorEp", "initiatorRequestorGrpEp", "initiatorStoreEp", "initiatorUnitEp", "inventoryDomainEp", "inventoryEp", "inventoryGlobalEp", "inventoryHolder", "inventoryInventoryEp", "inventoryInventoryMoMeta", "ipIPv4Dns", "ipIpV4Addr", "ipIpV4StaticAddr", "ipServiceIf", "ippoolAddr", "ippoolBlock", "ippoolIpV6Addr", "ippoolIpV6Block", "ippoolIpV6Pooled", "ippoolPool", "ippoolPooled", "ippoolUniverse", "iqnpoolAbsBlock", "iqnpoolAddr", "iqnpoolBlock", "iqnpoolFormat", "iqnpoolPool", "iqnpoolPooled", "iqnpoolTransportBlock", "iqnpoolUniverse", "iscsiAuthProfile", "licenseCapProvider", "licenseContents", "licenseDomain", "licenseDownloader", "licenseDownloaderFsm", "licenseDownloaderFsmStage", "licenseDownloaderFsmTask", "licenseEp", "licenseFeature", "licenseFeatureCapProvider", "licenseFeatureLine", "licenseFile", "licenseFileFsm", "licenseFileFsmStage", "licenseFileFsmTask", "licenseInstance", "licenseInstanceFsm", "licenseInstanceFsmStage", "licenseInstanceFsmTask", "licenseLicense", "licenseProp", "licenseServerHostId", "licenseSource", "licenseSourceFile", "lsBinding", "lsComputeBinding", "lsFcLocale", "lsFcZone", "lsFcZoneGroup", "lsFcZoneMember", "lsIdentityInfo", "lsIssues", "lsPower", "lsRequirement", "lsSPMeta", "lsServer", "lsServerAssocCtx", "lsServerExtension", "lsServerFsm", "lsServerFsmStage", "lsServerFsmTask", "lsServerOperation", "lsTier", "lsVConAssign", "lsWaitingUserAck", "lsZoneInitiatorMember", "lsZoneTargetMember", "lsbootADef", "lsbootBootSecurity", "lsbootCategory", "lsbootDef", "lsbootDefaultLocalImage", "lsbootEFIShell", "lsbootEmbeddedLocalDiskImage", "lsbootEmbeddedLocalDiskImagePath", "lsbootEmbeddedLocalLunImage", "lsbootIScsi", "lsbootIScsiImagePath", "lsbootImage", "lsbootImagePath", "lsbootItem", "lsbootLan", "lsbootLanImagePath", "lsbootLocalDiskImage", "lsbootLocalDiskImagePath", "lsbootLocalHddImage", "lsbootLocalImage", "lsbootLocalLunImagePath", "lsbootLocalMediaItem", "lsbootLocalStorage", "lsbootNvme", "lsbootNvmeDevice", "lsbootNvmeDiskSsd", "lsbootNvmePciSsd", "lsbootPolicy", "lsbootRemoteImage", "lsbootSan", "lsbootSanCatSanImage", "lsbootSanCatSanImagePath", "lsbootSanImage", "lsbootSanImagePath", "lsbootStorage", "lsbootUEFIBootParam", "lsbootUpgradeStatus", "lsbootUsbExternalImage", "lsbootUsbFlashStorageImage", "lsbootUsbInternalImage", "lsbootVirtualMedia", "lsmaintAck", "lsmaintMaintPolicy", "lstorageASlot", "lstorageAck", "lstorageArrayRequirement", "lstorageBlade", "lstorageControllerDef", "lstorageControllerModeConfig", "lstorageControllerQualifier", "lstorageControllerRef", "lstorageCtrlServiceOperation", "lstorageDasScsiLun", "lstorageDiskGroupConfig", "lstorageDiskGroupConfigDef", "lstorageDiskGroupConfigPolicy", "lstorageDiskGroupQualifier", "lstorageDiskSlot", "lstorageDiskZoningConfig", "lstorageDiskZoningConfigDef", "lstorageDiskZoningPolicy", "lstorageDriveSecurity", "lstorageExtension", "lstorageItem", "lstorageLocal", "lstorageLocalConfig", "lstorageLocalDef", "lstorageLocalDiskConfigRef", "lstorageLocalDiskRef", "lstorageLogin", "lstorageMeta", "lstorageProcessorBase", "lstorageProfile", "lstorageProfileBase", "lstorageProfileBinding", "lstorageProfileBindingBase", "lstorageProfileDef", "lstorageQualItem", "lstorageRecurrWindow", "lstorageRemote", "lstorageRemoteConfig", "lstorageRemoteDef", "lstorageRequestCtx", "lstorageScsiLun", "lstorageSecurity", "lstorageVirtualDriveDef", "macpoolAddr", "macpoolBlock", "macpoolFormat", "macpoolPool", "macpoolPooled", "macpoolUniverse", "memoryArray", "memoryArrayEnvStats", "memoryArrayEnvStatsHist", "memoryBufferUnit", "memoryBufferUnitEnvStats", "memoryBufferUnitEnvStatsHist", "memoryController", "memoryErrorStats", "memoryErrorStatsHist", "memoryNvDimm", "memoryNvDimmBattery", "memoryNvDimmController", "memoryQual", "memoryRuntime", "memoryRuntimeHist", "memoryUnit", "memoryUnitEnvStats", "memoryUnitEnvStatsHist", "messageEntry", "messageEp", "mgmtAKmipCertPolicy", "mgmtASecureBoot", "mgmtAbsBackup", "mgmtAbsDataItem", "mgmtAbsImporter", "mgmtBackup", "mgmtBackupFsm", "mgmtBackupFsmStage", "mgmtBackupFsmTask", "mgmtBackupOperation", "mgmtBackupPolicy", "mgmtBackupTrigger", "mgmtBackupTriggerFsm", "mgmtBackupTriggerFsmStage", "mgmtBackupTriggerFsmTask", "mgmtCfgExportPolicy", "mgmtCimcInterface", "mgmtCmcSecureBoot", "mgmtCmcSecureBootOperation", "mgmtConnection", "mgmtController", "mgmtDataExporter", "mgmtDataExporterFsm", "mgmtDataExporterFsmStage", "mgmtDataExporterFsmTask", "mgmtDataImporter", "mgmtDataImporterFsm", "mgmtDataImporterFsmStage", "mgmtDataImporterFsmTask", "mgmtDataItem", "mgmtEntity", "mgmtEp", "mgmtExportPolicy", "mgmtIPv6Addr", "mgmtIPv6IfAddr", "mgmtIPv6IfConfig", "mgmtIf", "mgmtIfFsm", "mgmtIfFsmStage", "mgmtIfFsmTask", "mgmtImportItem", "mgmtImporter", "mgmtImporterFsm", "mgmtImporterFsmStage", "mgmtImporterFsmTask", "mgmtInbandProfile", "mgmtInterface", "mgmtKmip", "mgmtKmipCertPolicy", "mgmtKmipOperation", "mgmtNamedKmipCertPolicy", "mgmtRegistryInfo", "mgmtRegistryInfoFsm", "mgmtRegistryInfoFsmStage", "mgmtRegistryInfoFsmTask", "mgmtSecurity", "mgmtSvc", "mgmtVnet", "moTopProps", "namingBinding", "namingDefinition", "namingHolder", "namingNamedIdentifiedObject", "namingNamedObject", "namingObject", "netNetGroupPermit", "networkCACert", "networkCIoEp", "networkConn", "networkElement", "networkElementFsm", "networkElementFsmStage", "networkElementFsmTask", "networkElementOperation", "networkEp", "networkIfEp", "networkPIoEp", "networkPhysEp", "networkSystemCACert", "networkVnetEp", "nfsClientDef", "nfsClientDefFsm", "nfsClientDefFsmStage", "nfsClientDefFsmTask", "nfsEp", "nfsExportDef", "nfsExportDefFsm", "nfsExportDefFsmStage", "nfsExportDefFsmTask", "nfsMountDef", "nfsRepositorySpecPolicy", "nwctrlDefinition", "observeFilter", "observeObserved", "observeObservedCont", "observeObservedFsm", "observeObservedFsmStage", "observeObservedFsmTask", "orgAOrg", "orgDomainFirmwareInfo", "orgDomainGroup", "orgDomainGroupFirmwareReport", "orgDomainGroupPolicy", "orgDomainGroupPolicyReport", "orgDomainGroupReport", "orgExtension", "orgFirmwareVersionCount", "orgMaintTagFirmwareReport", "orgOrg", "orgOrgFsm", "orgOrgFsmStage", "orgOrgFsmTask", "orgOrgSource", "orgSourceMask", "osController", "osEthBondIntf", "osEthBondMode", "osEthIntf", "osInstance", "osIntf", "osLinkMonitoringPolicy", "osPrimarySlave", "pciCard", "pkiCertReq", "pkiDefinition", "pkiEp", "pkiEpFsm", "pkiEpFsmStage", "pkiEpFsmTask", "pkiItem", "pkiKeyRing", "pkiTP", "policyADestEp", "policyAckSuspendOperation", "policyBinding", "policyChildClass", "policyCluster", "policyCommunication", "policyCommunicationOp", "policyConfigBackup", "policyConfigBackupOp", "policyConfigError", "policyContext", "policyControl", "policyControlEp", "policyControlEpOp", "policyControlEpOpFsm", "policyControlEpOpFsmStage", "policyControlEpOpFsmTask", "policyControlEpOperation", "policyControlOp", "policyControlled", "policyControlledInstance", "policyControlledType", "policyDateTime", "policyDateTimeOp", "policyDefinition", "policyDestClass", "policyDestEp", "policyDeviceProfile", "policyDigest", "policyDiscovery", "policyDiscoveryOp", "policyDns", "policyDnsOp", "policyElement", "policyEquipment", "policyEquipmentOp", "policyFault", "policyFaultOp", "policyIdentifierPolicy", "policyInfraFirmware", "policyInfraFirmwareOp", "policyItem", "policyLocalMap", "policyLogProfile", "policyMEp", "policyMEpOp", "policyMonitoring", "policyMonitoringOp", "policyObject", "policyPolicyDestClass", "policyPolicyEp", "policyPolicyRequestor", "policyPolicyScope", "policyPolicyScopeCont", "policyPolicyScopeContext", "policyPolicyScopeFsm", "policyPolicyScopeFsmStage", "policyPolicyScopeFsmTask", "policyPortConfig", "policyPortConfigOp", "policyPowerMgmt", "policyPowerMgmtOp", "policyProxyMo", "policyPsu", "policyPsuOp", "policyRequestor", "policyScope", "policySecurity", "policySecurityOp", "policySource", "policySourceApp", "policyStorageAutoConfig", "policyStorageAutoConfigOp", "policySystemEp", "policySystemProfile", "policyTracked", "policyTracker", "policyUniverse", "poolAsnmt", "poolElement", "poolElementAlloc", "poolMember", "poolPool", "poolPoolMember", "poolPoolable", "poolUniverse", "portGroup", "portIntFIo", "portPIo", "portPhysSwitchIo", "portServerIntFIo", "portSubGroup", "portSwitchIntFIo", "powerABudget", "powerAGroup", "powerBudget", "powerChassisMember", "powerEp", "powerGroup", "powerGroupMember", "powerGroupQual", "powerGroupStats", "powerGroupStatsHist", "powerMgmtPolicy", "powerPolicy", "powerProfiledPower", "procDoer", "procManager", "procProcCounts", "procProcs", "procPrt", "procPrtCounts", "procStimulusCounts", "procSvc", "procTxCounts", "processorEnvStats", "processorEnvStatsHist", "processorErrorStats", "processorErrorStatsHist", "processorQual", "processorRuntime", "processorRuntimeHist", "processorUnit", "processorUnitAssocCtx", "qosDefinition", "qosItem", "qosclassDefinition", "qosclassEth", "qosclassEthBE", "qosclassEthClassified", "qosclassFc", "qosclassItem", "qosclassPolicy", "queryContext", "queryDependencyContext", "queryDependencyRef", "queryEp", "queryImportContext", "queryUsageContext", "queryresultDependency", "queryresultDestOrgEp", "queryresultDomainGroupEp", "queryresultItem", "queryresultOrgEp", "queryresultUsage", "ruleDefinition", "ruleItem", "ruleRequirement", "ruleSizeRequirement", "securityUnit", "sesDiskSlotEp", "sesEnclosure", "smartcallhomeHttpProxy", "smartcallhomePeriodicInventoryStatus", "smartcallhomePeriodicSystemInventory", "smartcallhomePolicy", "smartcallhomeProfile", "smartcallhomeSource", "smartcallhomeTransportGateway", "smartlicenseAgent", "smartlicenseAgentFsm", "smartlicenseAgentFsmStage", "smartlicenseAgentFsmTask", "smartlicenseEntitlement", "smartlicenseEntitlementEp", "smartlicenseEntitlementEpFsm", "smartlicenseEntitlementEpFsmStage", "smartlicenseEntitlementEpFsmTask", "smartlicenseEp", "smartlicenseHolder", "smartlicenseHolderFsm", "smartlicenseHolderFsmStage", "smartlicenseHolderFsmTask", "smartlicenseTest", "smartlicenseTestFsm", "smartlicenseTestFsmStage", "smartlicenseTestFsmTask", "solDef", "solPolicy", "statsChart", "statsChartContainer", "statsCollectionPolicy", "statsCurr", "statsCustomChart", "statsCustomEp", "statsDbMigrationStatus", "statsDbSummaryMeta", "statsHist", "statsHolder", "statsInventoryMeta", "statsItem", "statsPasadenaCollectionPolicy", "statsStandardChart", "statsStandardEp", "statsStatsQuery", "statsStatsQueryHolder", "statsThr32Definition", "statsThr32Value", "statsThr64Definition", "statsThr64Value", "statsThrFloatDefinition", "statsThrFloatValue", "statsThresholdClass", "statsThresholdDefinition", "statsThresholdPolicy", "statsThresholdValue", "storageADef", "storageALun", "storageALunRefBase", "storageAScsiLun", "storageAScsiLunCtx", "storageASlot", "storageASnapReplicaLunCtx", "storageAVolume", "storageAppliance", "storageArray", "storageAuthKey", "storageBackstore", "storageBlade", "storageCloud", "storageClusterIdUniverse", "storageComputeBladeOperation", "storageConnectionDef", "storageConnectionPolicy", "storageContainer", "storageController", "storageControllerBase", "storageControllerEp", "storageControllerOperation", "storageControllerRef", "storageCtrlStorageStats", "storageCtrlStorageStatsHist", "storageDevice", "storageDiskEnvStats", "storageDiskEnvStatsHist", "storageDiskEp", "storageDiskGroup", "storageEmbeddedStorage", "storageEnclosure", "storageEnclosureDiskSlotEp", "storageEnclosureLocalDiskConfig", "storageEp", "storageEpUser", "storageEthLif", "storageEtherIf", "storageFcIf", "storageFcTargetEp", "storageFcTargetIf", "storageFlexFlashCard", "storageFlexFlashController", "storageFlexFlashControllerOperation", "storageFlexFlashDrive", "storageFlexFlashVirtualDrive", "storageHddMotherBoardTempStats", "storageHddMotherBoardTempStatsHist", "storageIScsiInitiatorEp", "storageIScsiTargetIf", "storageIniGroup", "storageInitiator", "storageInitiatorRef", "storageIpV4PooledAddr", "storageIpV4StaticAddr", "storageItem", "storageL2If", "storageLocalDisk", "storageLocalDiskBase", "storageLocalDiskConfig", "storageLocalDiskConfigDef", "storageLocalDiskConfigPolicy", "storageLocalDiskEp", "storageLocalDiskOperation", "storageLocalDiskPartition", "storageLocalLun", "storageLogical", "storageLunCounters", "storageLunDisk", "storageLunMaskGroup", "storageLunReplica", "storageLunResourceSelectionLog", "storageLunSnapshot", "storageMeta", "storageMezzFlashLife", "storageNodeEp", "storageNvmeStats", "storageNvmeStatsHist", "storageNvmeStorage", "storageOnboardDevice", "storageOperation", "storagePartition", "storagePhysical", "storageProcessor", "storageProcessorEp", "storageProcessorRuntime", "storageQual", "storageRaidBattery", "storageReplicationCtx", "storageSasExpander", "storageSasPhyLink", "storageSasPort", "storageSasUpLink", "storageScsiDeviceDescriptor", "storageScsiLun", "storageScsiLunCtx", "storageScsiLunInstRef", "storageScsiLunMask", "storageScsiLunRef", "storageSnapshot", "storageSnapshotCtx", "storageSsdHealthStats", "storageSsdHealthStatsHist", "storageStorageStats", "storageStorageStatsHist", "storageSystem", "storageTarget", "storageTargetIf", "storageTransportIf", "storageTransportableFlashModule", "storageUnit", "storageUsageCounters", "storageVDMemberEp", "storageVirtualDrive", "storageVirtualDriveContainer", "storageVirtualDriveEp", "storageVirtualDriveOperation", "storageVirtualDriveRef", "storageVirtualDriveRefOperation", "storageVolume", "storageVsanRef", "storageVsanRefIvt", "swCardEnvStats", "swCardEnvStatsHist", "swEnvStats", "swEnvStatsHist", "swMon", "swSystemStats", "swSystemStatsHist", "swVlan", "swVlanGroup", "syntheticDirectory", "syntheticFile", "syntheticFileSystem", "syntheticFsObj", "syntheticTime", "sysdebugAutoCoreFileExportTarget", "sysdebugAutoCoreFileExportTargetFsm", "sysdebugAutoCoreFileExportTargetFsmStage", "sysdebugAutoCoreFileExportTargetFsmTask", "sysdebugBackupBehavior", "sysdebugCore", "sysdebugCoreFileExportTarget", "sysdebugCoreFileRepository", "sysdebugDiagnosticLog", "sysdebugEp", "sysdebugExporter", "sysdebugFile", "sysdebugLogBehavior", "sysdebugLogControlDestinationFile", "sysdebugLogControlDestinationSyslog", "sysdebugLogControlDomain", "sysdebugLogControlEp", "sysdebugLogControlEpFsm", "sysdebugLogControlEpFsmStage", "sysdebugLogControlEpFsmTask", "sysdebugLogControlModule", "sysdebugMEpLogDef", "sysdebugMEpLogPolicy", "sysdebugManualCoreFileExportTarget", "sysdebugManualCoreFileExportTargetFsm", "sysdebugManualCoreFileExportTargetFsmStage", "sysdebugManualCoreFileExportTargetFsmTask", "sysdebugRepository", "sysdebugTechSupFileRepository", "sysdebugTechSupport", "sysdebugTechSupportCmdOpt", "sysdebugTechSupportFsm", "sysdebugTechSupportFsmStage", "sysdebugTechSupportFsmTask", "sysdebugTechSupportOp", "sysdebugTechSupportOperation", "sysfileDigest", "sysfileEp", "sysfileExporter", "sysfileImporter", "sysfileInstance", "sysfileMutation", "sysfileMutationFsm", "sysfileMutationFsmStage", "sysfileMutationFsmTask", "sysfileRepository", "tagADef", "tagAInstance", "tagDef", "tagDefEp", "tagDriver", "tagInstance", "tagInstanceEp", "tagInstanceItem", "tagItem", "tagSoftwareInst", "testingCliPolicy", "testingServiceProfile", "testingServiceProfileFsm", "testingServiceProfileFsmStage", "testingServiceProfileFsmTask", "testingSnmpCommunity", "testingSnmpPolicy", "testingSnmpSupport", "testingSnmpTrap", "topInfoSyncPolicy", "topMetaInf", "topRoot", "topSystem", "topSystemFsm", "topSystemFsmStage", "topSystemFsmTask", "trigAbsWindow", "trigAck", "trigBaseRecurrWindow", "trigBaseSched", "trigConfAck", "trigInst", "trigMeta", "trigPendingAckCount", "trigRecurrWindow", "trigResAck", "trigSched", "trigSchedWindow", "trigServerToken", "trigTest", "trigToken", "trigTokenRequestor", "trigTriggerable", "trigTriggered", "trigWindow", "unspecified", "uuidpoolAddr", "uuidpoolBlock", "uuidpoolFormat", "uuidpoolPool", "uuidpoolPooled", "uuidpoolUniverse", "versionApplication", "versionEp", "versionFilter", "versionMatrix", "versionProduct", "versionVersion", "vmAdaptor", "vmNic", "vnicABeh", "vnicAEtherIf", "vnicAFcIf", "vnicAGroup", "vnicBootIpPolicy", "vnicBootTarget", "vnicConPolicyRef", "vnicConReq", "vnicConnDef", "vnicConnection", "vnicDefBeh", "vnicDynamicCon", "vnicDynamicConPolicy", "vnicDynamicConPolicyRef", "vnicDynamicConReq", "vnicEthLif", "vnicEther", "vnicEtherBase", "vnicEtherBaseIf", "vnicEtherIf", "vnicFault", "vnicFc", "vnicFcBase", "vnicFcGroupDef", "vnicFcGroupTempl", "vnicFcIf", "vnicFcLif", "vnicFcNode", "vnicFcOEIf", "vnicIPIf", "vnicIPv4Dhcp", "vnicIPv4Dns", "vnicIPv4If", "vnicIPv4IscsiAddr", "vnicIPv4PooledIscsiAddr", "vnicIPv4StaticRoute", "vnicIPv6If", "vnicIScsi", "vnicIScsiAutoTargetIf", "vnicIScsiBase", "vnicIScsiBootParams", "vnicIScsiBootVnic", "vnicIScsiInitiatorParams", "vnicIScsiLCP", "vnicIScsiNode", "vnicIScsiStaticTargetIf", "vnicIScsiTargetIf", "vnicIScsiTargetParams", "vnicIf", "vnicIfRole", "vnicIniGrpFc", "vnicIniGrpFcB", "vnicIniGrpFcBIf", "vnicIniGrpFcBase", "vnicIniGrpFcIf", "vnicIpAddr", "vnicIpV4Addr", "vnicIpV4AddrConf", "vnicIpV4AddrExplConf", "vnicIpV4MgmtPooledAddr", "vnicIpV4PooledAddr", "vnicIpV4ProfDerivedAddr", "vnicIpV4StaticAddr", "vnicIpV6Addr", "vnicIpV6AddrConf", "vnicIpV6AddrExplConf", "vnicIpV6MgmtPooledAddr", "vnicIpV6StaticAddr", "vnicL2If", "vnicL2Lif", "vnicL3If", "vnicLanConnPolicy", "vnicLanConnTempl", "vnicLifVlan", "vnicLifVsan", "vnicLstorageIScsi", "vnicLun", "vnicMgmt", "vnicMgmtBase", "vnicMgmtIf", "vnicMonSesFc", "vnicMonSesFcBase", "vnicMonSesFcIf", "vnicNetGroup", "vnicNetGroupRef", "vnicNicConn", "vnicOutbandMgmtEp", "vnicOutbandMgmtEpFsm", "vnicOutbandMgmtEpFsmStage", "vnicOutbandMgmtEpFsmTask", "vnicProfileSet", "vnicRackServerDiscoveryProfile", "vnicSanConnPolicy", "vnicSanConnTempl", "vnicStorageEthLif", "vnicStorageLif", "vnicTempl", "vnicUsnicConPolicy", "vnicUsnicConPolicyRef", "vnicUsnicConReq", "vnicVhbaBehPolicy", "vnicVlan", "vnicVmqConPolicy", "vnicVmqConPolicyRef", "vnicVmqConReq", "vnicVnic", "vnicVnicBehPolicy"], []), 
        "proxy_dn": MoPropertyMeta("proxy_dn", "proxyDn", "string", VersionMeta.Version131a, MoPropertyMeta.READ_WRITE, 0x10, 0, 256, None, [], []), 
        "rn": MoPropertyMeta("rn", "rn", "string", VersionMeta.Version131a, MoPropertyMeta.READ_ONLY, 0x20, 0, 256, None, [], []), 
        "status": MoPropertyMeta("status", "status", "string", VersionMeta.Version131a, MoPropertyMeta.READ_WRITE, 0x40, None, None, r"""((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], []), 
    }

    prop_map = {
        "childAction": "child_action", 
        "descr": "descr", 
        "dn": "dn", 
        "name": "name", 
        "objectType": "object_type", 
        "proxyDn": "proxy_dn", 
        "rn": "rn", 
        "status": "status", 
    }

    def __init__(self, parent_mo_or_dn, **kwargs):
        self._dirty_mask = 0
        self.child_action = None
        self.descr = None
        self.name = None
        self.object_type = None
        self.proxy_dn = None
        self.status = None

        ManagedObject.__init__(self, "PolicyProxyMo", parent_mo_or_dn, **kwargs)

