"""This module contains the general information for GmetaClass ManagedObject."""

from ...ucscmo import ManagedObject
from ...ucsccoremeta import UcscVersion, MoPropertyMeta, MoMeta
from ...ucscmeta import VersionMeta


class GmetaClassConsts():
    EP_CLASS_ID_AAA_AUTH_METHOD = "aaaAuthMethod"
    EP_CLASS_ID_AAA_AUTH_REALM = "aaaAuthRealm"
    EP_CLASS_ID_AAA_AUTH_REALM_FSM = "aaaAuthRealmFsm"
    EP_CLASS_ID_AAA_AUTH_REALM_FSM_STAGE = "aaaAuthRealmFsmStage"
    EP_CLASS_ID_AAA_CONFIG = "aaaConfig"
    EP_CLASS_ID_AAA_CONSOLE_AUTH = "aaaConsoleAuth"
    EP_CLASS_ID_AAA_DEFAULT_AUTH = "aaaDefaultAuth"
    EP_CLASS_ID_AAA_DEFINITION = "aaaDefinition"
    EP_CLASS_ID_AAA_DOMAIN = "aaaDomain"
    EP_CLASS_ID_AAA_DOMAIN_AUTH = "aaaDomainAuth"
    EP_CLASS_ID_AAA_DOMAIN_GROUP = "aaaDomainGroup"
    EP_CLASS_ID_AAA_EP = "aaaEp"
    EP_CLASS_ID_AAA_EP_AUTH_PROFILE = "aaaEpAuthProfile"
    EP_CLASS_ID_AAA_EP_FSM = "aaaEpFsm"
    EP_CLASS_ID_AAA_EP_FSM_STAGE = "aaaEpFsmStage"
    EP_CLASS_ID_AAA_EP_FSM_TASK = "aaaEpFsmTask"
    EP_CLASS_ID_AAA_EP_LOGIN = "aaaEpLogin"
    EP_CLASS_ID_AAA_EP_USER = "aaaEpUser"
    EP_CLASS_ID_AAA_EXT_MGMT_CUT_THRU_TKN = "aaaExtMgmtCutThruTkn"
    EP_CLASS_ID_AAA_ITEM = "aaaItem"
    EP_CLASS_ID_AAA_LDAP_EP = "aaaLdapEp"
    EP_CLASS_ID_AAA_LDAP_EP_FSM = "aaaLdapEpFsm"
    EP_CLASS_ID_AAA_LDAP_EP_FSM_STAGE = "aaaLdapEpFsmStage"
    EP_CLASS_ID_AAA_LDAP_GROUP = "aaaLdapGroup"
    EP_CLASS_ID_AAA_LDAP_GROUP_RULE = "aaaLdapGroupRule"
    EP_CLASS_ID_AAA_LDAP_PROVIDER = "aaaLdapProvider"
    EP_CLASS_ID_AAA_LOCALE = "aaaLocale"
    EP_CLASS_ID_AAA_LOG = "aaaLog"
    EP_CLASS_ID_AAA_MOD_LR = "aaaModLR"
    EP_CLASS_ID_AAA_ORG = "aaaOrg"
    EP_CLASS_ID_AAA_PROVIDER = "aaaProvider"
    EP_CLASS_ID_AAA_PROVIDER_GROUP = "aaaProviderGroup"
    EP_CLASS_ID_AAA_PROVIDER_REF = "aaaProviderRef"
    EP_CLASS_ID_AAA_PWD_PROFILE = "aaaPwdProfile"
    EP_CLASS_ID_AAA_RADIUS_EP = "aaaRadiusEp"
    EP_CLASS_ID_AAA_RADIUS_EP_FSM = "aaaRadiusEpFsm"
    EP_CLASS_ID_AAA_RADIUS_EP_FSM_STAGE = "aaaRadiusEpFsmStage"
    EP_CLASS_ID_AAA_RADIUS_PROVIDER = "aaaRadiusProvider"
    EP_CLASS_ID_AAA_REALM = "aaaRealm"
    EP_CLASS_ID_AAA_REALM_FSM = "aaaRealmFsm"
    EP_CLASS_ID_AAA_REALM_FSM_STAGE = "aaaRealmFsmStage"
    EP_CLASS_ID_AAA_REALM_FSM_TASK = "aaaRealmFsmTask"
    EP_CLASS_ID_AAA_REMOTE_USER = "aaaRemoteUser"
    EP_CLASS_ID_AAA_ROLE = "aaaRole"
    EP_CLASS_ID_AAA_SESSION = "aaaSession"
    EP_CLASS_ID_AAA_SESSION_LR = "aaaSessionLR"
    EP_CLASS_ID_AAA_SHELL_LOGIN = "aaaShellLogin"
    EP_CLASS_ID_AAA_SSH_AUTH = "aaaSshAuth"
    EP_CLASS_ID_AAA_SYSTEM_USER = "aaaSystemUser"
    EP_CLASS_ID_AAA_TACACS_PLUS_EP = "aaaTacacsPlusEp"
    EP_CLASS_ID_AAA_TACACS_PLUS_EP_FSM = "aaaTacacsPlusEpFsm"
    EP_CLASS_ID_AAA_TACACS_PLUS_EP_FSM_STAGE = "aaaTacacsPlusEpFsmStage"
    EP_CLASS_ID_AAA_TACACS_PLUS_PROVIDER = "aaaTacacsPlusProvider"
    EP_CLASS_ID_AAA_USER = "aaaUser"
    EP_CLASS_ID_AAA_USER_ACTION = "aaaUserAction"
    EP_CLASS_ID_AAA_USER_DATA = "aaaUserData"
    EP_CLASS_ID_AAA_USER_EP = "aaaUserEp"
    EP_CLASS_ID_AAA_USER_EP_FSM = "aaaUserEpFsm"
    EP_CLASS_ID_AAA_USER_EP_FSM_STAGE = "aaaUserEpFsmStage"
    EP_CLASS_ID_AAA_USER_EP_FSM_TASK = "aaaUserEpFsmTask"
    EP_CLASS_ID_AAA_USER_GROUP = "aaaUserGroup"
    EP_CLASS_ID_AAA_USER_LOCALE = "aaaUserLocale"
    EP_CLASS_ID_AAA_USER_LOGIN = "aaaUserLogin"
    EP_CLASS_ID_AAA_USER_PREFERENCES = "aaaUserPreferences"
    EP_CLASS_ID_AAA_USER_ROLE = "aaaUserRole"
    EP_CLASS_ID_AAA_WEB_LOGIN = "aaaWebLogin"
    EP_CLASS_ID_ADAPTOR_BEH_CAP = "adaptorBehCap"
    EP_CLASS_ID_ADAPTOR_CAP_DEF = "adaptorCapDef"
    EP_CLASS_ID_ADAPTOR_CAP_QUAL = "adaptorCapQual"
    EP_CLASS_ID_ADAPTOR_CAP_SPEC = "adaptorCapSpec"
    EP_CLASS_ID_ADAPTOR_ETH_ADV_FILTER_PROFILE = "adaptorEthAdvFilterProfile"
    EP_CLASS_ID_ADAPTOR_ETH_ARFS_PROFILE = "adaptorEthArfsProfile"
    EP_CLASS_ID_ADAPTOR_ETH_COMP_QUEUE_PROFILE = "adaptorEthCompQueueProfile"
    EP_CLASS_ID_ADAPTOR_ETH_FAILOVER_PROFILE = "adaptorEthFailoverProfile"
    EP_CLASS_ID_ADAPTOR_ETH_GENEVEPROFILE = "adaptorEthGENEVEProfile"
    EP_CLASS_ID_ADAPTOR_ETH_INTERRUPT_PROFILE = "adaptorEthInterruptProfile"
    EP_CLASS_ID_ADAPTOR_ETH_INTERRUPT_SCALING_PROFILE = "adaptorEthInterruptScalingProfile"
    EP_CLASS_ID_ADAPTOR_ETH_NVGREPROFILE = "adaptorEthNVGREProfile"
    EP_CLASS_ID_ADAPTOR_ETH_OFFLOAD_PROFILE = "adaptorEthOffloadProfile"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS = "adaptorEthPortBySizeLargeStats"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST = "adaptorEthPortBySizeLargeStatsHist"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS = "adaptorEthPortBySizeSmallStats"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST = "adaptorEthPortBySizeSmallStatsHist"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_ERR_STATS = "adaptorEthPortErrStats"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST = "adaptorEthPortErrStatsHist"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_MCAST_STATS = "adaptorEthPortMcastStats"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST = "adaptorEthPortMcastStatsHist"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS = "adaptorEthPortOutsizedStats"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST = "adaptorEthPortOutsizedStatsHist"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_STATS = "adaptorEthPortStats"
    EP_CLASS_ID_ADAPTOR_ETH_PORT_STATS_HIST = "adaptorEthPortStatsHist"
    EP_CLASS_ID_ADAPTOR_ETH_QUEUE_PROFILE = "adaptorEthQueueProfile"
    EP_CLASS_ID_ADAPTOR_ETH_RECV_QUEUE_PROFILE = "adaptorEthRecvQueueProfile"
    EP_CLASS_ID_ADAPTOR_ETH_RO_CEPROFILE = "adaptorEthRoCEProfile"
    EP_CLASS_ID_ADAPTOR_ETH_VX_LANPROFILE = "adaptorEthVxLANProfile"
    EP_CLASS_ID_ADAPTOR_ETH_WORK_QUEUE_PROFILE = "adaptorEthWorkQueueProfile"
    EP_CLASS_ID_ADAPTOR_ETHER_IF_STATS = "adaptorEtherIfStats"
    EP_CLASS_ID_ADAPTOR_ETHER_IF_STATS_HIST = "adaptorEtherIfStatsHist"
    EP_CLASS_ID_ADAPTOR_EXT_ETH_IF = "adaptorExtEthIf"
    EP_CLASS_ID_ADAPTOR_EXT_ETH_IF_OPERATION = "adaptorExtEthIfOperation"
    EP_CLASS_ID_ADAPTOR_EXT_IF = "adaptorExtIf"
    EP_CLASS_ID_ADAPTOR_EXT_IP_V6_RSS_HASH_PROFILE = "adaptorExtIpV6RssHashProfile"
    EP_CLASS_ID_ADAPTOR_FC_CDB_WORK_QUEUE_PROFILE = "adaptorFcCdbWorkQueueProfile"
    EP_CLASS_ID_ADAPTOR_FC_ERROR_RECOVERY_PROFILE = "adaptorFcErrorRecoveryProfile"
    EP_CLASS_ID_ADAPTOR_FC_FNIC_PROFILE = "adaptorFcFnicProfile"
    EP_CLASS_ID_ADAPTOR_FC_IF_EVENT_STATS = "adaptorFcIfEventStats"
    EP_CLASS_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST = "adaptorFcIfEventStatsHist"
    EP_CLASS_ID_ADAPTOR_FC_IF_FC4_STATS = "adaptorFcIfFC4Stats"
    EP_CLASS_ID_ADAPTOR_FC_IF_FC4_STATS_HIST = "adaptorFcIfFC4StatsHist"
    EP_CLASS_ID_ADAPTOR_FC_IF_FRAME_STATS = "adaptorFcIfFrameStats"
    EP_CLASS_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST = "adaptorFcIfFrameStatsHist"
    EP_CLASS_ID_ADAPTOR_FC_INTERRUPT_PROFILE = "adaptorFcInterruptProfile"
    EP_CLASS_ID_ADAPTOR_FC_LOGI_PROFILE = "adaptorFcLogiProfile"
    EP_CLASS_ID_ADAPTOR_FC_PORT_FLOGI_PROFILE = "adaptorFcPortFLogiProfile"
    EP_CLASS_ID_ADAPTOR_FC_PORT_PLOGI_PROFILE = "adaptorFcPortPLogiProfile"
    EP_CLASS_ID_ADAPTOR_FC_PORT_PROFILE = "adaptorFcPortProfile"
    EP_CLASS_ID_ADAPTOR_FC_PORT_STATS = "adaptorFcPortStats"
    EP_CLASS_ID_ADAPTOR_FC_PORT_STATS_HIST = "adaptorFcPortStatsHist"
    EP_CLASS_ID_ADAPTOR_FC_QUEUE_PROFILE = "adaptorFcQueueProfile"
    EP_CLASS_ID_ADAPTOR_FC_RECV_QUEUE_PROFILE = "adaptorFcRecvQueueProfile"
    EP_CLASS_ID_ADAPTOR_FC_WORK_QUEUE_PROFILE = "adaptorFcWorkQueueProfile"
    EP_CLASS_ID_ADAPTOR_FRU_CAP_PROVIDER = "adaptorFruCapProvider"
    EP_CLASS_ID_ADAPTOR_HBAVNIC_STATS = "adaptorHBAVnicStats"
    EP_CLASS_ID_ADAPTOR_HBAVNIC_STATS_HIST = "adaptorHBAVnicStatsHist"
    EP_CLASS_ID_ADAPTOR_HOST_ETH_IF = "adaptorHostEthIf"
    EP_CLASS_ID_ADAPTOR_HOST_ETH_IF_OPERATION = "adaptorHostEthIfOperation"
    EP_CLASS_ID_ADAPTOR_HOST_ETH_IF_PROFILE = "adaptorHostEthIfProfile"
    EP_CLASS_ID_ADAPTOR_HOST_FC_IF = "adaptorHostFcIf"
    EP_CLASS_ID_ADAPTOR_HOST_FC_IF_OPERATION = "adaptorHostFcIfOperation"
    EP_CLASS_ID_ADAPTOR_HOST_FC_IF_PROFILE = "adaptorHostFcIfProfile"
    EP_CLASS_ID_ADAPTOR_HOST_IF = "adaptorHostIf"
    EP_CLASS_ID_ADAPTOR_HOST_IF_CONFIG = "adaptorHostIfConfig"
    EP_CLASS_ID_ADAPTOR_HOST_IF_CONN_DEF = "adaptorHostIfConnDef"
    EP_CLASS_ID_ADAPTOR_HOST_IF_PROFILE = "adaptorHostIfProfile"
    EP_CLASS_ID_ADAPTOR_HOST_ISCSI_IF = "adaptorHostIscsiIf"
    EP_CLASS_ID_ADAPTOR_HOST_ISCSI_IF_OPERATION = "adaptorHostIscsiIfOperation"
    EP_CLASS_ID_ADAPTOR_HOST_ISCSI_IF_PROFILE = "adaptorHostIscsiIfProfile"
    EP_CLASS_ID_ADAPTOR_HOST_SCSI_IF = "adaptorHostScsiIf"
    EP_CLASS_ID_ADAPTOR_HOST_SCSI_LUN_REF = "adaptorHostScsiLunRef"
    EP_CLASS_ID_ADAPTOR_HW_ADDR_CAP = "adaptorHwAddrCap"
    EP_CLASS_ID_ADAPTOR_ISCSI_CAP = "adaptorIScsiCap"
    EP_CLASS_ID_ADAPTOR_IP_V4_RSS_HASH_PROFILE = "adaptorIpV4RssHashProfile"
    EP_CLASS_ID_ADAPTOR_IP_V6_RSS_HASH_PROFILE = "adaptorIpV6RssHashProfile"
    EP_CLASS_ID_ADAPTOR_MENLO_BASE_ERROR_STATS = "adaptorMenloBaseErrorStats"
    EP_CLASS_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST = "adaptorMenloBaseErrorStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_DCE_PORT_STATS = "adaptorMenloDcePortStats"
    EP_CLASS_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST = "adaptorMenloDcePortStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_ETH_ERROR_STATS = "adaptorMenloEthErrorStats"
    EP_CLASS_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST = "adaptorMenloEthErrorStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_ETH_STATS = "adaptorMenloEthStats"
    EP_CLASS_ID_ADAPTOR_MENLO_ETH_STATS_HIST = "adaptorMenloEthStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_FC_ERROR_STATS = "adaptorMenloFcErrorStats"
    EP_CLASS_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST = "adaptorMenloFcErrorStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_FC_STATS = "adaptorMenloFcStats"
    EP_CLASS_ID_ADAPTOR_MENLO_FC_STATS_HIST = "adaptorMenloFcStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_HOST_PORT_STATS = "adaptorMenloHostPortStats"
    EP_CLASS_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST = "adaptorMenloHostPortStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS = "adaptorMenloMcpuErrorStats"
    EP_CLASS_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST = "adaptorMenloMcpuErrorStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_MCPU_STATS = "adaptorMenloMcpuStats"
    EP_CLASS_ID_ADAPTOR_MENLO_MCPU_STATS_HIST = "adaptorMenloMcpuStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_NET_EG_STATS = "adaptorMenloNetEgStats"
    EP_CLASS_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST = "adaptorMenloNetEgStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_NET_IN_STATS = "adaptorMenloNetInStats"
    EP_CLASS_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST = "adaptorMenloNetInStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_QERROR_STATS = "adaptorMenloQErrorStats"
    EP_CLASS_ID_ADAPTOR_MENLO_QERROR_STATS_HIST = "adaptorMenloQErrorStatsHist"
    EP_CLASS_ID_ADAPTOR_MENLO_QSTATS = "adaptorMenloQStats"
    EP_CLASS_ID_ADAPTOR_MENLO_QSTATS_HIST = "adaptorMenloQStatsHist"
    EP_CLASS_ID_ADAPTOR_NICVNIC_STATS = "adaptorNICVnicStats"
    EP_CLASS_ID_ADAPTOR_NICVNIC_STATS_HIST = "adaptorNICVnicStatsHist"
    EP_CLASS_ID_ADAPTOR_PROFILE_ITEM = "adaptorProfileItem"
    EP_CLASS_ID_ADAPTOR_PROTOCOL_PROFILE = "adaptorProtocolProfile"
    EP_CLASS_ID_ADAPTOR_QUAL = "adaptorQual"
    EP_CLASS_ID_ADAPTOR_QUEUE_PROFILE = "adaptorQueueProfile"
    EP_CLASS_ID_ADAPTOR_RNIC_CAP_SPEC = "adaptorRnicCapSpec"
    EP_CLASS_ID_ADAPTOR_RSS_HASH_PROFILE = "adaptorRssHashProfile"
    EP_CLASS_ID_ADAPTOR_RSS_PROFILE = "adaptorRssProfile"
    EP_CLASS_ID_ADAPTOR_TCP_IP_RSS_HASH_PROFILE = "adaptorTcpIpRssHashProfile"
    EP_CLASS_ID_ADAPTOR_UNIT = "adaptorUnit"
    EP_CLASS_ID_ADAPTOR_UNIT_ASSOC_CTX = "adaptorUnitAssocCtx"
    EP_CLASS_ID_ADAPTOR_UNIT_EXTN = "adaptorUnitExtn"
    EP_CLASS_ID_ADAPTOR_USNIC_CONN_DEF = "adaptorUsnicConnDef"
    EP_CLASS_ID_ADAPTOR_VLAN = "adaptorVlan"
    EP_CLASS_ID_ADAPTOR_VMMQ_CONN_DEF = "adaptorVmmqConnDef"
    EP_CLASS_ID_ADAPTOR_VNIC_STATS = "adaptorVnicStats"
    EP_CLASS_ID_ADAPTOR_VNIC_STATS_HIST = "adaptorVnicStatsHist"
    EP_CLASS_ID_BIOS_BOT = "biosBOT"
    EP_CLASS_ID_BIOS_BOOT_DEV = "biosBootDev"
    EP_CLASS_ID_BIOS_BOOT_DEV_GRP = "biosBootDevGrp"
    EP_CLASS_ID_BIOS_TOKEN_FEATURE_GROUP = "biosTokenFeatureGroup"
    EP_CLASS_ID_BIOS_TOKEN_PARAM = "biosTokenParam"
    EP_CLASS_ID_BIOS_TOKEN_SETTINGS = "biosTokenSettings"
    EP_CLASS_ID_BIOS_UNIT = "biosUnit"
    EP_CLASS_ID_BIOS_VFEAT = "biosVFeat"
    EP_CLASS_ID_BIOS_VPROFILE = "biosVProfile"
    EP_CLASS_ID_BIOS_VF_ACPI10_SUPPORT = "biosVfACPI10Support"
    EP_CLASS_ID_BIOS_VF_ASPMSUPPORT = "biosVfASPMSupport"
    EP_CLASS_ID_BIOS_VF_ALL_USBDEVICES = "biosVfAllUSBDevices"
    EP_CLASS_ID_BIOS_VF_ALTITUDE = "biosVfAltitude"
    EP_CLASS_ID_BIOS_VF_ASSERT_NMION_PERR = "biosVfAssertNMIOnPERR"
    EP_CLASS_ID_BIOS_VF_ASSERT_NMION_SERR = "biosVfAssertNMIOnSERR"
    EP_CLASS_ID_BIOS_VF_BOOT_OPTION_RETRY = "biosVfBootOptionRetry"
    EP_CLASS_ID_BIOS_VF_CPUHARDWARE_POWER_MANAGEMENT = "biosVfCPUHardwarePowerManagement"
    EP_CLASS_ID_BIOS_VF_CPUPERFORMANCE = "biosVfCPUPerformance"
    EP_CLASS_ID_BIOS_VF_CPUPOWER_MANAGEMENT = "biosVfCPUPowerManagement"
    EP_CLASS_ID_BIOS_VF_CONSISTENT_DEVICE_NAME_CONTROL = "biosVfConsistentDeviceNameControl"
    EP_CLASS_ID_BIOS_VF_CONSOLE_REDIRECTION = "biosVfConsoleRedirection"
    EP_CLASS_ID_BIOS_VF_CORE_MULTI_PROCESSING = "biosVfCoreMultiProcessing"
    EP_CLASS_ID_BIOS_VF_DDR3_VOLTAGE_SELECTION = "biosVfDDR3VoltageSelection"
    EP_CLASS_ID_BIOS_VF_DRAMCLOCK_THROTTLING = "biosVfDRAMClockThrottling"
    EP_CLASS_ID_BIOS_VF_DIRECT_CACHE_ACCESS = "biosVfDirectCacheAccess"
    EP_CLASS_ID_BIOS_VF_DRAM_REFRESH_RATE = "biosVfDramRefreshRate"
    EP_CLASS_ID_BIOS_VF_ENERGY_PERFORMANCE_TUNING = "biosVfEnergyPerformanceTuning"
    EP_CLASS_ID_BIOS_VF_ENHANCED_INTEL_SPEED_STEP_TECH = "biosVfEnhancedIntelSpeedStepTech"
    EP_CLASS_ID_BIOS_VF_ENHANCED_POWER_CAPPING_SUPPORT = "biosVfEnhancedPowerCappingSupport"
    EP_CLASS_ID_BIOS_VF_EXECUTE_DISABLE_BIT = "biosVfExecuteDisableBit"
    EP_CLASS_ID_BIOS_VF_FRB2_TIMER = "biosVfFRB2Timer"
    EP_CLASS_ID_BIOS_VF_FREQUENCY_FLOOR_OVERRIDE = "biosVfFrequencyFloorOverride"
    EP_CLASS_ID_BIOS_VF_FRONT_PANEL_LOCKOUT = "biosVfFrontPanelLockout"
    EP_CLASS_ID_BIOS_VF_IOEMEZZ1_OPTION_ROM = "biosVfIOEMezz1OptionROM"
    EP_CLASS_ID_BIOS_VF_IOENVME1_OPTION_ROM = "biosVfIOENVMe1OptionROM"
    EP_CLASS_ID_BIOS_VF_IOENVME2_OPTION_ROM = "biosVfIOENVMe2OptionROM"
    EP_CLASS_ID_BIOS_VF_IOESLOT1_OPTION_ROM = "biosVfIOESlot1OptionROM"
    EP_CLASS_ID_BIOS_VF_IOESLOT2_OPTION_ROM = "biosVfIOESlot2OptionROM"
    EP_CLASS_ID_BIOS_VF_INTEGRATED_GRAPHICS = "biosVfIntegratedGraphics"
    EP_CLASS_ID_BIOS_VF_INTEGRATED_GRAPHICS_APERTURE_SIZE = "biosVfIntegratedGraphicsApertureSize"
    EP_CLASS_ID_BIOS_VF_INTEL_ENTRY_SASRAIDMODULE = "biosVfIntelEntrySASRAIDModule"
    EP_CLASS_ID_BIOS_VF_INTEL_HYPER_THREADING_TECH = "biosVfIntelHyperThreadingTech"
    EP_CLASS_ID_BIOS_VF_INTEL_TRUSTED_EXECUTION_TECHNOLOGY = "biosVfIntelTrustedExecutionTechnology"
    EP_CLASS_ID_BIOS_VF_INTEL_TURBO_BOOST_TECH = "biosVfIntelTurboBoostTech"
    EP_CLASS_ID_BIOS_VF_INTEL_VTFOR_DIRECTED_IO = "biosVfIntelVTForDirectedIO"
    EP_CLASS_ID_BIOS_VF_INTEL_VIRTUALIZATION_TECHNOLOGY = "biosVfIntelVirtualizationTechnology"
    EP_CLASS_ID_BIOS_VF_INTERLEAVE_CONFIGURATION = "biosVfInterleaveConfiguration"
    EP_CLASS_ID_BIOS_VF_LOCAL_X2_APIC = "biosVfLocalX2Apic"
    EP_CLASS_ID_BIOS_VF_LV_DIMMSUPPORT = "biosVfLvDIMMSupport"
    EP_CLASS_ID_BIOS_VF_MAX_VARIABLE_MTRRSETTING = "biosVfMaxVariableMTRRSetting"
    EP_CLASS_ID_BIOS_VF_MAXIMUM_MEMORY_BELOW4_GB = "biosVfMaximumMemoryBelow4GB"
    EP_CLASS_ID_BIOS_VF_MEMORY_MAPPED_IOABOVE4_GB = "biosVfMemoryMappedIOAbove4GB"
    EP_CLASS_ID_BIOS_VF_MIRRORING_MODE = "biosVfMirroringMode"
    EP_CLASS_ID_BIOS_VF_NUMAOPTIMIZED = "biosVfNUMAOptimized"
    EP_CLASS_ID_BIOS_VF_OSBOOT_WATCHDOG_TIMER = "biosVfOSBootWatchdogTimer"
    EP_CLASS_ID_BIOS_VF_OSBOOT_WATCHDOG_TIMER_POLICY = "biosVfOSBootWatchdogTimerPolicy"
    EP_CLASS_ID_BIOS_VF_OSBOOT_WATCHDOG_TIMER_TIMEOUT = "biosVfOSBootWatchdogTimerTimeout"
    EP_CLASS_ID_BIOS_VF_ONBOARD_GRAPHICS = "biosVfOnboardGraphics"
    EP_CLASS_ID_BIOS_VF_ONBOARD_SATACONTROLLER = "biosVfOnboardSATAController"
    EP_CLASS_ID_BIOS_VF_ONBOARD_STORAGE = "biosVfOnboardStorage"
    EP_CLASS_ID_BIOS_VF_OPTION_ROMENABLE = "biosVfOptionROMEnable"
    EP_CLASS_ID_BIOS_VF_OPTION_ROMLOAD = "biosVfOptionROMLoad"
    EP_CLASS_ID_BIOS_VF_OUT_OF_BAND_MANAGEMENT = "biosVfOutOfBandManagement"
    EP_CLASS_ID_BIOS_VF_PCHSATAMODE = "biosVfPCHSATAMode"
    EP_CLASS_ID_BIOS_VF_PCILOMPORTS_CONFIGURATION = "biosVfPCILOMPortsConfiguration"
    EP_CLASS_ID_BIOS_VF_PCIROMCLP = "biosVfPCIROMCLP"
    EP_CLASS_ID_BIOS_VF_PCISLOT_LINK_SPEED = "biosVfPCISlotLinkSpeed"
    EP_CLASS_ID_BIOS_VF_PCISLOT_OPTION_ROMENABLE = "biosVfPCISlotOptionROMEnable"
    EP_CLASS_ID_BIOS_VF_POSTERROR_PAUSE = "biosVfPOSTErrorPause"
    EP_CLASS_ID_BIOS_VF_PSTATECOORDINATION = "biosVfPSTATECoordination"
    EP_CLASS_ID_BIOS_VF_PACKAGE_CSTATE_LIMIT = "biosVfPackageCStateLimit"
    EP_CLASS_ID_BIOS_VF_PROCESSOR_C1_E = "biosVfProcessorC1E"
    EP_CLASS_ID_BIOS_VF_PROCESSOR_C3_REPORT = "biosVfProcessorC3Report"
    EP_CLASS_ID_BIOS_VF_PROCESSOR_C6_REPORT = "biosVfProcessorC6Report"
    EP_CLASS_ID_BIOS_VF_PROCESSOR_C7_REPORT = "biosVfProcessorC7Report"
    EP_CLASS_ID_BIOS_VF_PROCESSOR_CMCI = "biosVfProcessorCMCI"
    EP_CLASS_ID_BIOS_VF_PROCESSOR_CSTATE = "biosVfProcessorCState"
    EP_CLASS_ID_BIOS_VF_PROCESSOR_ENERGY_CONFIGURATION = "biosVfProcessorEnergyConfiguration"
    EP_CLASS_ID_BIOS_VF_PROCESSOR_PREFETCH_CONFIG = "biosVfProcessorPrefetchConfig"
    EP_CLASS_ID_BIOS_VF_QPILINK_FREQUENCY_SELECT = "biosVfQPILinkFrequencySelect"
    EP_CLASS_ID_BIOS_VF_QPISNOOP_MODE = "biosVfQPISnoopMode"
    EP_CLASS_ID_BIOS_VF_QUIET_BOOT = "biosVfQuietBoot"
    EP_CLASS_ID_BIOS_VF_REDIRECTION_AFTER_BIOSPOST = "biosVfRedirectionAfterBIOSPOST"
    EP_CLASS_ID_BIOS_VF_RESUME_ON_ACPOWER_LOSS = "biosVfResumeOnACPowerLoss"
    EP_CLASS_ID_BIOS_VF_SBMEZZ1_OPTION_ROM = "biosVfSBMezz1OptionROM"
    EP_CLASS_ID_BIOS_VF_SBNVME1_OPTION_ROM = "biosVfSBNVMe1OptionROM"
    EP_CLASS_ID_BIOS_VF_SIOC1_OPTION_ROM = "biosVfSIOC1OptionROM"
    EP_CLASS_ID_BIOS_VF_SIOC2_OPTION_ROM = "biosVfSIOC2OptionROM"
    EP_CLASS_ID_BIOS_VF_SCRUB_POLICIES = "biosVfScrubPolicies"
    EP_CLASS_ID_BIOS_VF_SELECT_MEMORY_RASCONFIGURATION = "biosVfSelectMemoryRASConfiguration"
    EP_CLASS_ID_BIOS_VF_SERIAL_PORT_AENABLE = "biosVfSerialPortAEnable"
    EP_CLASS_ID_BIOS_VF_SPARING_MODE = "biosVfSparingMode"
    EP_CLASS_ID_BIOS_VF_SRIOV_CONFIG = "biosVfSriovConfig"
    EP_CLASS_ID_BIOS_VF_TPMPENDING_OPERATION = "biosVfTPMPendingOperation"
    EP_CLASS_ID_BIOS_VF_TPMSUPPORT = "biosVfTPMSupport"
    EP_CLASS_ID_BIOS_VF_TRUSTED_PLATFORM_MODULE = "biosVfTrustedPlatformModule"
    EP_CLASS_ID_BIOS_VF_UCSMBOOT_MODE_CONTROL = "biosVfUCSMBootModeControl"
    EP_CLASS_ID_BIOS_VF_UCSMBOOT_ORDER_RULE_CONTROL = "biosVfUCSMBootOrderRuleControl"
    EP_CLASS_ID_BIOS_VF_UEFIOSUSE_LEGACY_VIDEO = "biosVfUEFIOSUseLegacyVideo"
    EP_CLASS_ID_BIOS_VF_USBBOOT_CONFIG = "biosVfUSBBootConfig"
    EP_CLASS_ID_BIOS_VF_USBCONFIGURATION = "biosVfUSBConfiguration"
    EP_CLASS_ID_BIOS_VF_USBFRONT_PANEL_ACCESS_LOCK = "biosVfUSBFrontPanelAccessLock"
    EP_CLASS_ID_BIOS_VF_USBPORT_CONFIGURATION = "biosVfUSBPortConfiguration"
    EP_CLASS_ID_BIOS_VF_USBSYSTEM_IDLE_POWER_OPTIMIZING_SETTING = "biosVfUSBSystemIdlePowerOptimizingSetting"
    EP_CLASS_ID_BIOS_VF_VGAPRIORITY = "biosVfVGAPriority"
    EP_CLASS_ID_BIOS_VF_WORKLOAD_CONFIGURATION = "biosVfWorkloadConfiguration"
    EP_CLASS_ID_CALLHOME_DEST = "callhomeDest"
    EP_CLASS_ID_CALLHOME_EP = "callhomeEp"
    EP_CLASS_ID_CALLHOME_FAULT_INST = "callhomeFaultInst"
    EP_CLASS_ID_CALLHOME_HOLDER = "callhomeHolder"
    EP_CLASS_ID_CALLHOME_HOLDER_FSM = "callhomeHolderFsm"
    EP_CLASS_ID_CALLHOME_HOLDER_FSM_STAGE = "callhomeHolderFsmStage"
    EP_CLASS_ID_CALLHOME_HOLDER_FSM_TASK = "callhomeHolderFsmTask"
    EP_CLASS_ID_CALLHOME_HTTP = "callhomeHttp"
    EP_CLASS_ID_CALLHOME_ITEM = "callhomeItem"
    EP_CLASS_ID_CALLHOME_PERIODIC_SYSTEM_INVENTORY = "callhomePeriodicSystemInventory"
    EP_CLASS_ID_CALLHOME_POLICY = "callhomePolicy"
    EP_CLASS_ID_CALLHOME_PROFILE = "callhomeProfile"
    EP_CLASS_ID_CALLHOME_SMTP = "callhomeSmtp"
    EP_CLASS_ID_CALLHOME_SOURCE = "callhomeSource"
    EP_CLASS_ID_CALLHOME_TEST_ALERT = "callhomeTestAlert"
    EP_CLASS_ID_CAPABILITY_CATALOGUE = "capabilityCatalogue"
    EP_CLASS_ID_CAPABILITY_DEF = "capabilityDef"
    EP_CLASS_ID_CAPABILITY_ITEM = "capabilityItem"
    EP_CLASS_ID_CAPABILITY_PROVIDER = "capabilityProvider"
    EP_CLASS_ID_CERT_REPAIR_EP = "certRepairEp"
    EP_CLASS_ID_CERT_REPAIR_EP_FSM = "certRepairEpFsm"
    EP_CLASS_ID_CERT_REPAIR_EP_FSM_STAGE = "certRepairEpFsmStage"
    EP_CLASS_ID_CERT_REPAIR_EP_FSM_TASK = "certRepairEpFsmTask"
    EP_CLASS_ID_CHANGE_CHANGED_OBJECT_REF = "changeChangedObjectRef"
    EP_CLASS_ID_CHANGE_EP = "changeEp"
    EP_CLASS_ID_CHANGE_EP_FSM = "changeEpFsm"
    EP_CLASS_ID_CHANGE_EP_FSM_STAGE = "changeEpFsmStage"
    EP_CLASS_ID_CHANGE_EP_FSM_TASK = "changeEpFsmTask"
    EP_CLASS_ID_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY = "cimcvmediaActualMountEntry"
    EP_CLASS_ID_CIMCVMEDIA_ACTUAL_MOUNT_LIST = "cimcvmediaActualMountList"
    EP_CLASS_ID_CIMCVMEDIA_CONFIG_MOUNT_ENTRY = "cimcvmediaConfigMountEntry"
    EP_CLASS_ID_CIMCVMEDIA_EXT_MGMT_RULE_ENTRY = "cimcvmediaExtMgmtRuleEntry"
    EP_CLASS_ID_CIMCVMEDIA_ITEM = "cimcvmediaItem"
    EP_CLASS_ID_CIMCVMEDIA_MOUNT_CONFIG = "cimcvmediaMountConfig"
    EP_CLASS_ID_CIMCVMEDIA_MOUNT_CONFIG_DEF = "cimcvmediaMountConfigDef"
    EP_CLASS_ID_CIMCVMEDIA_MOUNT_CONFIG_POLICY = "cimcvmediaMountConfigPolicy"
    EP_CLASS_ID_CIMCVMEDIA_MOUNT_INFO = "cimcvmediaMountInfo"
    EP_CLASS_ID_CLITEST_TYPE_TEST = "clitestTypeTest"
    EP_CLASS_ID_CLITEST_TYPE_TEST2 = "clitestTypeTest2"
    EP_CLASS_ID_CLITEST_TYPE_TEST_CHILD = "clitestTypeTestChild"
    EP_CLASS_ID_CLITEST_TYPE_TEST_PARENT = "clitestTypeTestParent"
    EP_CLASS_ID_COMM_CIMXML = "commCimxml"
    EP_CLASS_ID_COMM_CLIENT = "commClient"
    EP_CLASS_ID_COMM_CLIENT_ITEM = "commClientItem"
    EP_CLASS_ID_COMM_CORE_FILE = "commCoreFile"
    EP_CLASS_ID_COMM_DATE_TIME = "commDateTime"
    EP_CLASS_ID_COMM_DATE_TIME_FSM = "commDateTimeFsm"
    EP_CLASS_ID_COMM_DATE_TIME_FSM_STAGE = "commDateTimeFsmStage"
    EP_CLASS_ID_COMM_DATE_TIME_FSM_TASK = "commDateTimeFsmTask"
    EP_CLASS_ID_COMM_DEFINITION = "commDefinition"
    EP_CLASS_ID_COMM_DNS = "commDns"
    EP_CLASS_ID_COMM_DNS_PROVIDER = "commDnsProvider"
    EP_CLASS_ID_COMM_EVT_CHANNEL = "commEvtChannel"
    EP_CLASS_ID_COMM_HTTP = "commHttp"
    EP_CLASS_ID_COMM_HTTPS = "commHttps"
    EP_CLASS_ID_COMM_ITEM = "commItem"
    EP_CLASS_ID_COMM_LOCALE = "commLocale"
    EP_CLASS_ID_COMM_LOG_COMPONENT = "commLogComponent"
    EP_CLASS_ID_COMM_NTP = "commNtp"
    EP_CLASS_ID_COMM_NTP_PROVIDER = "commNtpProvider"
    EP_CLASS_ID_COMM_SHELL = "commShell"
    EP_CLASS_ID_COMM_SHELL_SVC_LIMITS = "commShellSvcLimits"
    EP_CLASS_ID_COMM_SMASH_CLP = "commSmashCLP"
    EP_CLASS_ID_COMM_SNMP = "commSnmp"
    EP_CLASS_ID_COMM_SNMP_COMMUNITY = "commSnmpCommunity"
    EP_CLASS_ID_COMM_SNMP_TRAP = "commSnmpTrap"
    EP_CLASS_ID_COMM_SNMP_TRAP_DATA = "commSnmpTrapData"
    EP_CLASS_ID_COMM_SNMP_USER = "commSnmpUser"
    EP_CLASS_ID_COMM_SSH = "commSsh"
    EP_CLASS_ID_COMM_SVC = "commSvc"
    EP_CLASS_ID_COMM_SVC_CHANNEL = "commSvcChannel"
    EP_CLASS_ID_COMM_SVC_EP = "commSvcEp"
    EP_CLASS_ID_COMM_SVC_EP_FSM = "commSvcEpFsm"
    EP_CLASS_ID_COMM_SVC_EP_FSM_STAGE = "commSvcEpFsmStage"
    EP_CLASS_ID_COMM_SVC_EP_FSM_TASK = "commSvcEpFsmTask"
    EP_CLASS_ID_COMM_SVC_LIMITS = "commSvcLimits"
    EP_CLASS_ID_COMM_SVC_POLICY = "commSvcPolicy"
    EP_CLASS_ID_COMM_SYSLOG = "commSyslog"
    EP_CLASS_ID_COMM_SYSLOG_CLIENT = "commSyslogClient"
    EP_CLASS_ID_COMM_SYSLOG_CONSOLE = "commSyslogConsole"
    EP_CLASS_ID_COMM_SYSLOG_FILE = "commSyslogFile"
    EP_CLASS_ID_COMM_SYSLOG_MONITOR = "commSyslogMonitor"
    EP_CLASS_ID_COMM_SYSLOG_SOURCE = "commSyslogSource"
    EP_CLASS_ID_COMM_TELNET = "commTelnet"
    EP_CLASS_ID_COMM_WEB = "commWeb"
    EP_CLASS_ID_COMM_WEB_CHANNEL = "commWebChannel"
    EP_CLASS_ID_COMM_WEB_SVC_LIMITS = "commWebSvcLimits"
    EP_CLASS_ID_COMM_WSMAN = "commWsman"
    EP_CLASS_ID_COMM_XML_CL_CONN_POLICY = "commXmlClConnPolicy"
    EP_CLASS_ID_COMPUTE_ABOARD = "computeABoard"
    EP_CLASS_ID_COMPUTE_ACHASSIS_DISC_POLICY = "computeAChassisDiscPolicy"
    EP_CLASS_ID_COMPUTE_AOPERATION = "computeAOperation"
    EP_CLASS_ID_COMPUTE_AUTOCONFIG_POLICY = "computeAutoconfigPolicy"
    EP_CLASS_ID_COMPUTE_BASE_SYSTEM = "computeBaseSystem"
    EP_CLASS_ID_COMPUTE_BLADE = "computeBlade"
    EP_CLASS_ID_COMPUTE_BLADE_DISC_POLICY = "computeBladeDiscPolicy"
    EP_CLASS_ID_COMPUTE_BLADE_EP = "computeBladeEp"
    EP_CLASS_ID_COMPUTE_BLADE_INHERIT_POLICY = "computeBladeInheritPolicy"
    EP_CLASS_ID_COMPUTE_BLADE_POS_QUAL = "computeBladePosQual"
    EP_CLASS_ID_COMPUTE_BOARD = "computeBoard"
    EP_CLASS_ID_COMPUTE_BOARD_CONNECTOR = "computeBoardConnector"
    EP_CLASS_ID_COMPUTE_BOARD_CONTROLLER = "computeBoardController"
    EP_CLASS_ID_COMPUTE_CARTRIDGE = "computeCartridge"
    EP_CLASS_ID_COMPUTE_CARTRIDGE_OPERATION = "computeCartridgeOperation"
    EP_CLASS_ID_COMPUTE_CHASSIS_CONN_POLICY = "computeChassisConnPolicy"
    EP_CLASS_ID_COMPUTE_CHASSIS_CONN_POLICY_OPERATION = "computeChassisConnPolicyOperation"
    EP_CLASS_ID_COMPUTE_CHASSIS_DISC_POLICY = "computeChassisDiscPolicy"
    EP_CLASS_ID_COMPUTE_CHASSIS_FEAT_MASK = "computeChassisFeatMask"
    EP_CLASS_ID_COMPUTE_CHASSIS_QUAL = "computeChassisQual"
    EP_CLASS_ID_COMPUTE_COMPUTE_DISC_POLICY = "computeComputeDiscPolicy"
    EP_CLASS_ID_COMPUTE_CONFIG_POLICY = "computeConfigPolicy"
    EP_CLASS_ID_COMPUTE_CONTAINER = "computeContainer"
    EP_CLASS_ID_COMPUTE_DEFINITION = "computeDefinition"
    EP_CLASS_ID_COMPUTE_DISC_POLICY = "computeDiscPolicy"
    EP_CLASS_ID_COMPUTE_DOMAIN_GROUP_QUAL = "computeDomainGroupQual"
    EP_CLASS_ID_COMPUTE_DOMAIN_HW_CHANGE_DISC_POLICY = "computeDomainHwChangeDiscPolicy"
    EP_CLASS_ID_COMPUTE_DOMAIN_NAME_QUAL = "computeDomainNameQual"
    EP_CLASS_ID_COMPUTE_DOMAIN_PORT_DISC_POLICY = "computeDomainPortDiscPolicy"
    EP_CLASS_ID_COMPUTE_DOMAIN_QUAL = "computeDomainQual"
    EP_CLASS_ID_COMPUTE_ENV_FEAT_MASK = "computeEnvFeatMask"
    EP_CLASS_ID_COMPUTE_EXT_BOARD = "computeExtBoard"
    EP_CLASS_ID_COMPUTE_FABRIC_ETH_MON_SRC_EP = "computeFabricEthMonSrcEp"
    EP_CLASS_ID_COMPUTE_FABRIC_ETH_MON_SRC_EP_CONT = "computeFabricEthMonSrcEpCont"
    EP_CLASS_ID_COMPUTE_FABRIC_FC_MON_SRC_EP = "computeFabricFcMonSrcEp"
    EP_CLASS_ID_COMPUTE_FABRIC_FC_MON_SRC_EP_CONT = "computeFabricFcMonSrcEpCont"
    EP_CLASS_ID_COMPUTE_FABRIC_MON_SRC_EP = "computeFabricMonSrcEp"
    EP_CLASS_ID_COMPUTE_FACTORY_RESET_OP = "computeFactoryResetOp"
    EP_CLASS_ID_COMPUTE_FACTORY_RESET_OPERATION = "computeFactoryResetOperation"
    EP_CLASS_ID_COMPUTE_FAULT_UPGRADE_FLAG = "computeFaultUpgradeFlag"
    EP_CLASS_ID_COMPUTE_FEAT_MASK = "computeFeatMask"
    EP_CLASS_ID_COMPUTE_GRAPHICS_CARD_POLICY = "computeGraphicsCardPolicy"
    EP_CLASS_ID_COMPUTE_GROUP_MEMBERSHIP = "computeGroupMembership"
    EP_CLASS_ID_COMPUTE_GROUP_MEMBERSHIP_REF = "computeGroupMembershipRef"
    EP_CLASS_ID_COMPUTE_HW_CHANGE_DISC_POLICY = "computeHwChangeDiscPolicy"
    EP_CLASS_ID_COMPUTE_IOHUB = "computeIOHub"
    EP_CLASS_ID_COMPUTE_IOHUB_ENV_STATS = "computeIOHubEnvStats"
    EP_CLASS_ID_COMPUTE_IOHUB_ENV_STATS_HIST = "computeIOHubEnvStatsHist"
    EP_CLASS_ID_COMPUTE_INIT_CONFIG_POLICY = "computeInitConfigPolicy"
    EP_CLASS_ID_COMPUTE_INSTANCE = "computeInstance"
    EP_CLASS_ID_COMPUTE_INSTANCE_ID_QUAL = "computeInstanceIdQual"
    EP_CLASS_ID_COMPUTE_INSTANCE_MAPPING = "computeInstanceMapping"
    EP_CLASS_ID_COMPUTE_ITEM = "computeItem"
    EP_CLASS_ID_COMPUTE_LOCAL_TEMPL_DEF = "computeLocalTemplDef"
    EP_CLASS_ID_COMPUTE_LOGICAL = "computeLogical"
    EP_CLASS_ID_COMPUTE_MB_POWER_STATS = "computeMbPowerStats"
    EP_CLASS_ID_COMPUTE_MB_POWER_STATS_HIST = "computeMbPowerStatsHist"
    EP_CLASS_ID_COMPUTE_MB_TEMP_STATS = "computeMbTempStats"
    EP_CLASS_ID_COMPUTE_MB_TEMP_STATS_HIST = "computeMbTempStatsHist"
    EP_CLASS_ID_COMPUTE_NETWORK_FEAT_MASK = "computeNetworkFeatMask"
    EP_CLASS_ID_COMPUTE_OWNER_QUAL = "computeOwnerQual"
    EP_CLASS_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS = "computePCIeFatalCompletionStats"
    EP_CLASS_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST = "computePCIeFatalCompletionStatsHist"
    EP_CLASS_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS = "computePCIeFatalProtocolStats"
    EP_CLASS_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_HIST = "computePCIeFatalProtocolStatsHist"
    EP_CLASS_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS = "computePCIeFatalReceiveStats"
    EP_CLASS_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST = "computePCIeFatalReceiveStatsHist"
    EP_CLASS_ID_COMPUTE_PCIE_FATAL_STATS = "computePCIeFatalStats"
    EP_CLASS_ID_COMPUTE_PCIE_FATAL_STATS_HIST = "computePCIeFatalStatsHist"
    EP_CLASS_ID_COMPUTE_PHYSICAL = "computePhysical"
    EP_CLASS_ID_COMPUTE_PHYSICAL_ASSOC_CTX = "computePhysicalAssocCtx"
    EP_CLASS_ID_COMPUTE_PHYSICAL_EXTENSION = "computePhysicalExtension"
    EP_CLASS_ID_COMPUTE_PHYSICAL_OPERATION = "computePhysicalOperation"
    EP_CLASS_ID_COMPUTE_PHYSICAL_QUAL = "computePhysicalQual"
    EP_CLASS_ID_COMPUTE_PLACEABLE = "computePlaceable"
    EP_CLASS_ID_COMPUTE_PLACED = "computePlaced"
    EP_CLASS_ID_COMPUTE_POOL = "computePool"
    EP_CLASS_ID_COMPUTE_POOL_POLICY_REF = "computePoolPolicyRef"
    EP_CLASS_ID_COMPUTE_POOLABLE = "computePoolable"
    EP_CLASS_ID_COMPUTE_POOLED = "computePooled"
    EP_CLASS_ID_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT = "computePooledEnclosureComputeSlot"
    EP_CLASS_ID_COMPUTE_POOLED_PHYSICAL = "computePooledPhysical"
    EP_CLASS_ID_COMPUTE_POOLED_RACK_UNIT = "computePooledRackUnit"
    EP_CLASS_ID_COMPUTE_POOLED_SLOT = "computePooledSlot"
    EP_CLASS_ID_COMPUTE_POOLING_POLICY = "computePoolingPolicy"
    EP_CLASS_ID_COMPUTE_PORT_DISC_POLICY = "computePortDiscPolicy"
    EP_CLASS_ID_COMPUTE_POWER_SYNC_DEF = "computePowerSyncDef"
    EP_CLASS_ID_COMPUTE_POWER_SYNC_POLICY = "computePowerSyncPolicy"
    EP_CLASS_ID_COMPUTE_PRODUCT_FAMILY_QUAL = "computeProductFamilyQual"
    EP_CLASS_ID_COMPUTE_PROFILE = "computeProfile"
    EP_CLASS_ID_COMPUTE_PSU_DEF = "computePsuDef"
    EP_CLASS_ID_COMPUTE_PSU_POLICY = "computePsuPolicy"
    EP_CLASS_ID_COMPUTE_QUAL = "computeQual"
    EP_CLASS_ID_COMPUTE_QUAL_BASE = "computeQualBase"
    EP_CLASS_ID_COMPUTE_QUAL_ITEM = "computeQualItem"
    EP_CLASS_ID_COMPUTE_QUALIFIED_POLICY = "computeQualifiedPolicy"
    EP_CLASS_ID_COMPUTE_RACK_POS_QUAL = "computeRackPosQual"
    EP_CLASS_ID_COMPUTE_RACK_QUAL = "computeRackQual"
    EP_CLASS_ID_COMPUTE_RACK_UNIT = "computeRackUnit"
    EP_CLASS_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS = "computeRackUnitMbTempStats"
    EP_CLASS_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST = "computeRackUnitMbTempStatsHist"
    EP_CLASS_ID_COMPUTE_REBOOT_LOG = "computeRebootLog"
    EP_CLASS_ID_COMPUTE_REMOTE_OP_STATUS = "computeRemoteOpStatus"
    EP_CLASS_ID_COMPUTE_REQUIREMENT = "computeRequirement"
    EP_CLASS_ID_COMPUTE_RESOURCE_AGGR_EP = "computeResourceAggrEp"
    EP_CLASS_ID_COMPUTE_RESOURCE_SET = "computeResourceSet"
    EP_CLASS_ID_COMPUTE_RESOURCE_SET_MANAGER = "computeResourceSetManager"
    EP_CLASS_ID_COMPUTE_RESOURCE_SET_MEMBER = "computeResourceSetMember"
    EP_CLASS_ID_COMPUTE_SCRUB_POLICY = "computeScrubPolicy"
    EP_CLASS_ID_COMPUTE_SERVER = "computeServer"
    EP_CLASS_ID_COMPUTE_SERVER_DISC_POLICY = "computeServerDiscPolicy"
    EP_CLASS_ID_COMPUTE_SERVER_FEAT_MASK = "computeServerFeatMask"
    EP_CLASS_ID_COMPUTE_SERVER_MGMT_POLICY = "computeServerMgmtPolicy"
    EP_CLASS_ID_COMPUTE_SERVER_UNIT = "computeServerUnit"
    EP_CLASS_ID_COMPUTE_SESSION = "computeSession"
    EP_CLASS_ID_COMPUTE_SITE_QUAL = "computeSiteQual"
    EP_CLASS_ID_COMPUTE_SLOT_ENTITY = "computeSlotEntity"
    EP_CLASS_ID_COMPUTE_SLOT_QUAL = "computeSlotQual"
    EP_CLASS_ID_COMPUTE_STORAGE_FEAT_MASK = "computeStorageFeatMask"
    EP_CLASS_ID_COMPUTE_SYSTEM = "computeSystem"
    EP_CLASS_ID_COMPUTE_SYSTEM_ADDR_QUAL = "computeSystemAddrQual"
    EP_CLASS_ID_COMPUTE_SYSTEM_FSM = "computeSystemFsm"
    EP_CLASS_ID_COMPUTE_SYSTEM_FSM_STAGE = "computeSystemFsmStage"
    EP_CLASS_ID_COMPUTE_SYSTEM_FSM_TASK = "computeSystemFsmTask"
    EP_CLASS_ID_COMPUTE_SYSTEM_QUAL = "computeSystemQual"
    EP_CLASS_ID_COMPUTE_TEMPLATE = "computeTemplate"
    EP_CLASS_ID_COMPUTE_TEMPLATE_MAPPING = "computeTemplateMapping"
    EP_CLASS_ID_COMPUTE_USER = "computeUser"
    EP_CLASS_ID_COMPUTE_USER_EP = "computeUserEp"
    EP_CLASS_ID_CONDITION_IMMUTABLE = "conditionImmutable"
    EP_CLASS_ID_CONDITION_INFO = "conditionInfo"
    EP_CLASS_ID_CONDITION_LOG = "conditionLog"
    EP_CLASS_ID_CONDITION_LOGGABLE = "conditionLoggable"
    EP_CLASS_ID_CONDITION_MULTI_INSTANCE_IMMUTABLE = "conditionMultiInstanceImmutable"
    EP_CLASS_ID_CONDITION_MUTABLE = "conditionMutable"
    EP_CLASS_ID_CONDITION_POLICY = "conditionPolicy"
    EP_CLASS_ID_CONDITION_REPORTABLE = "conditionReportable"
    EP_CLASS_ID_CONFIG_ABS_DB_CONFIG = "configAbsDbConfig"
    EP_CLASS_ID_CONFIG_ACK_ITEM = "configAckItem"
    EP_CLASS_ID_CONFIG_ADAPTOR_ITEM = "configAdaptorItem"
    EP_CLASS_ID_CONFIG_APP_IMPACT_RESPONSE = "configAppImpactResponse"
    EP_CLASS_ID_CONFIG_BACKUP = "configBackup"
    EP_CLASS_ID_CONFIG_BACKUP_FSM = "configBackupFsm"
    EP_CLASS_ID_CONFIG_BACKUP_FSM_STAGE = "configBackupFsmStage"
    EP_CLASS_ID_CONFIG_BACKUP_FSM_TASK = "configBackupFsmTask"
    EP_CLASS_ID_CONFIG_CARTRIDGE_FILTER = "configCartridgeFilter"
    EP_CLASS_ID_CONFIG_CARTRIDGE_ITEM = "configCartridgeItem"
    EP_CLASS_ID_CONFIG_CATALOGUE = "configCatalogue"
    EP_CLASS_ID_CONFIG_CHASSIS_FILTER = "configChassisFilter"
    EP_CLASS_ID_CONFIG_CHASSIS_ITEM = "configChassisItem"
    EP_CLASS_ID_CONFIG_COMPONENTS_FILTER = "configComponentsFilter"
    EP_CLASS_ID_CONFIG_CONSUMER_CATALOGUE = "configConsumerCatalogue"
    EP_CLASS_ID_CONFIG_CONSUMER_CATALOGUE_FSM = "configConsumerCatalogueFsm"
    EP_CLASS_ID_CONFIG_CONSUMER_CATALOGUE_FSM_STAGE = "configConsumerCatalogueFsmStage"
    EP_CLASS_ID_CONFIG_CONSUMER_CATALOGUE_FSM_TASK = "configConsumerCatalogueFsmTask"
    EP_CLASS_ID_CONFIG_CONTROLLER_ITEM = "configControllerItem"
    EP_CLASS_ID_CONFIG_CPU_INFO = "configCpuInfo"
    EP_CLASS_ID_CONFIG_CPU_ITEM = "configCpuItem"
    EP_CLASS_ID_CONFIG_CRYPTO_CARD_ITEM = "configCryptoCardItem"
    EP_CLASS_ID_CONFIG_DB_CONFIG = "configDbConfig"
    EP_CLASS_ID_CONFIG_DOMAIN_FILTER = "configDomainFilter"
    EP_CLASS_ID_CONFIG_DOMAIN_ITEM = "configDomainItem"
    EP_CLASS_ID_CONFIG_FABRIC_INTERCONNECT_FILTER = "configFabricInterconnectFilter"
    EP_CLASS_ID_CONFIG_FABRIC_INTERCONNECT_ITEM = "configFabricInterconnectItem"
    EP_CLASS_ID_CONFIG_FAN_ITEM = "configFanItem"
    EP_CLASS_ID_CONFIG_FEX_FILTER = "configFexFilter"
    EP_CLASS_ID_CONFIG_FEX_ITEM = "configFexItem"
    EP_CLASS_ID_CONFIG_FILTER_GROUP = "configFilterGroup"
    EP_CLASS_ID_CONFIG_FILTER_ITEM = "configFilterItem"
    EP_CLASS_ID_CONFIG_FSM = "configFsm"
    EP_CLASS_ID_CONFIG_FSM_STAGE = "configFsmStage"
    EP_CLASS_ID_CONFIG_GRAPHICS_CARD_ITEM = "configGraphicsCardItem"
    EP_CLASS_ID_CONFIG_IOMITEM = "configIOMItem"
    EP_CLASS_ID_CONFIG_IMPACT = "configImpact"
    EP_CLASS_ID_CONFIG_IMPACT_ANALYZER = "configImpactAnalyzer"
    EP_CLASS_ID_CONFIG_IMPACT_ANALYZER_EP = "configImpactAnalyzerEp"
    EP_CLASS_ID_CONFIG_IMPACT_RESPONSE = "configImpactResponse"
    EP_CLASS_ID_CONFIG_INPUT_CONFIG = "configInputConfig"
    EP_CLASS_ID_CONFIG_INPUT_CONFIG_SET = "configInputConfigSet"
    EP_CLASS_ID_CONFIG_LOCAL_DISK_ITEM = "configLocalDiskItem"
    EP_CLASS_ID_CONFIG_LUN_ITEM = "configLunItem"
    EP_CLASS_ID_CONFIG_MANAGED_EP_IMPACT_RESPONSE = "configManagedEpImpactResponse"
    EP_CLASS_ID_CONFIG_MEMORY_ITEM = "configMemoryItem"
    EP_CLASS_ID_CONFIG_MOTHERBOARD_ITEM = "configMotherboardItem"
    EP_CLASS_ID_CONFIG_NET_REF_ITEM = "configNetRefItem"
    EP_CLASS_ID_CONFIG_ORG_ITEM = "configOrgItem"
    EP_CLASS_ID_CONFIG_PSUITEM = "configPSUItem"
    EP_CLASS_ID_CONFIG_POLICY_USAGE_ITEM = "configPolicyUsageItem"
    EP_CLASS_ID_CONFIG_PORT_ITEM = "configPortItem"
    EP_CLASS_ID_CONFIG_SEARCH_OPTIONS = "configSearchOptions"
    EP_CLASS_ID_CONFIG_SEARCH_RESULT = "configSearchResult"
    EP_CLASS_ID_CONFIG_SERVER_FILTER = "configServerFilter"
    EP_CLASS_ID_CONFIG_SERVER_ITEM = "configServerItem"
    EP_CLASS_ID_CONFIG_SERVICE_PROFILE_FILTER = "configServiceProfileFilter"
    EP_CLASS_ID_CONFIG_SORTER = "configSorter"
    EP_CLASS_ID_CONFIG_SPOT_LIGHT_ITEM = "configSpotLightItem"
    EP_CLASS_ID_CONFIG_STORAGE_ARRAY_PROFILE_FILTER = "configStorageArrayProfileFilter"
    EP_CLASS_ID_CONFIG_STORAGE_BLADE_FILTER = "configStorageBladeFilter"
    EP_CLASS_ID_CONFIG_STORAGE_ITEM = "configStorageItem"
    EP_CLASS_ID_CONFIG_UCIMPACT = "configUCImpact"
    EP_CLASS_ID_CONSUMER_INST = "consumerInst"
    EP_CLASS_ID_CONSUMER_INST_FSM = "consumerInstFsm"
    EP_CLASS_ID_CONSUMER_INST_FSM_STAGE = "consumerInstFsmStage"
    EP_CLASS_ID_CONSUMER_INST_FSM_TASK = "consumerInstFsmTask"
    EP_CLASS_ID_CONSUMER_UNIVERSE = "consumerUniverse"
    EP_CLASS_ID_CONTROLLER_EP = "controllerEp"
    EP_CLASS_ID_CONTROLLER_EP_FSM = "controllerEpFsm"
    EP_CLASS_ID_CONTROLLER_EP_FSM_STAGE = "controllerEpFsmStage"
    EP_CLASS_ID_CONTROLLER_EP_FSM_TASK = "controllerEpFsmTask"
    EP_CLASS_ID_CPMAINT_ACK = "cpmaintAck"
    EP_CLASS_ID_CPMAINT_MAINT_POLICY = "cpmaintMaintPolicy"
    EP_CLASS_ID_DCX_VIF = "dcxVIf"
    EP_CLASS_ID_DCX_VC = "dcxVc"
    EP_CLASS_ID_DIAG_CTRL = "diagCtrl"
    EP_CLASS_ID_DIAG_LOG_EP = "diagLogEp"
    EP_CLASS_ID_DIAG_MEMORY_TEST = "diagMemoryTest"
    EP_CLASS_ID_DIAG_RSLT = "diagRslt"
    EP_CLASS_ID_DIAG_RUN_POLICY = "diagRunPolicy"
    EP_CLASS_ID_DIAG_SRV_CAP_PROVIDER = "diagSrvCapProvider"
    EP_CLASS_ID_DIAG_SRV_CTRL = "diagSrvCtrl"
    EP_CLASS_ID_DIAG_SRV_CTRL_OPERATION = "diagSrvCtrlOperation"
    EP_CLASS_ID_DIAG_SRV_CTRL_OPERATION_FSM = "diagSrvCtrlOperationFsm"
    EP_CLASS_ID_DIAG_SRV_CTRL_OPERATION_FSM_STAGE = "diagSrvCtrlOperationFsmStage"
    EP_CLASS_ID_DIAG_SRV_CTRL_OPERATION_FSM_TASK = "diagSrvCtrlOperationFsmTask"
    EP_CLASS_ID_DIAG_TEST = "diagTest"
    EP_CLASS_ID_DOMAIN_CHASSIS_FEATURE = "domainChassisFeature"
    EP_CLASS_ID_DOMAIN_CHASSIS_PARAM = "domainChassisParam"
    EP_CLASS_ID_DOMAIN_CHASSIS_PROFILE_ITEM = "domainChassisProfileItem"
    EP_CLASS_ID_DOMAIN_ENVIRONMENT_FEATURE = "domainEnvironmentFeature"
    EP_CLASS_ID_DOMAIN_ENVIRONMENT_PARAM = "domainEnvironmentParam"
    EP_CLASS_ID_DOMAIN_EP = "domainEp"
    EP_CLASS_ID_DOMAIN_FAMILY_CAP_PROVIDER = "domainFamilyCapProvider"
    EP_CLASS_ID_DOMAIN_FEATURE = "domainFeature"
    EP_CLASS_ID_DOMAIN_FEATURE_CATALOG = "domainFeatureCatalog"
    EP_CLASS_ID_DOMAIN_NETWORK_FEATURE = "domainNetworkFeature"
    EP_CLASS_ID_DOMAIN_NETWORK_PARAM = "domainNetworkParam"
    EP_CLASS_ID_DOMAIN_PARAMETER = "domainParameter"
    EP_CLASS_ID_DOMAIN_PROFILE = "domainProfile"
    EP_CLASS_ID_DOMAIN_PROFILE_FSM = "domainProfileFsm"
    EP_CLASS_ID_DOMAIN_PROFILE_FSM_STAGE = "domainProfileFsmStage"
    EP_CLASS_ID_DOMAIN_PROFILE_FSM_TASK = "domainProfileFsmTask"
    EP_CLASS_ID_DOMAIN_SERVER_FEATURE = "domainServerFeature"
    EP_CLASS_ID_DOMAIN_SERVER_PARAM = "domainServerParam"
    EP_CLASS_ID_DOMAIN_SERVICE_PROFILE_ITEM = "domainServiceProfileItem"
    EP_CLASS_ID_DOMAIN_STORAGE_FEATURE = "domainStorageFeature"
    EP_CLASS_ID_DOMAIN_STORAGE_PARAM = "domainStorageParam"
    EP_CLASS_ID_DPSEC_MAC = "dpsecMac"
    EP_CLASS_ID_DUPE_CHANGE_TRACKER = "dupeChangeTracker"
    EP_CLASS_ID_DUPE_CHANGE_TRACKER_EP = "dupeChangeTrackerEp"
    EP_CLASS_ID_DUPE_CHANGE_TRACKER_EP_FSM = "dupeChangeTrackerEpFsm"
    EP_CLASS_ID_DUPE_CHANGE_TRACKER_EP_FSM_STAGE = "dupeChangeTrackerEpFsmStage"
    EP_CLASS_ID_DUPE_CHANGE_TRACKER_EP_FSM_TASK = "dupeChangeTrackerEpFsmTask"
    EP_CLASS_ID_DUPE_EP = "dupeEp"
    EP_CLASS_ID_DUPE_EXT_REQUESTOR = "dupeExtRequestor"
    EP_CLASS_ID_DUPE_INT_REQUESTOR = "dupeIntRequestor"
    EP_CLASS_ID_DUPE_REQUESTOR = "dupeRequestor"
    EP_CLASS_ID_DUPE_SCOPE = "dupeScope"
    EP_CLASS_ID_DUPE_SCOPE_EP = "dupeScopeEp"
    EP_CLASS_ID_DUPE_SCOPE_RESULT = "dupeScopeResult"
    EP_CLASS_ID_EPQOS_DEFINITION = "epqosDefinition"
    EP_CLASS_ID_EPQOS_EGRESS = "epqosEgress"
    EP_CLASS_ID_EPQOS_ITEM = "epqosItem"
    EP_CLASS_ID_EQUIPMENT_ABEH_CAP = "equipmentABehCap"
    EP_CLASS_ID_EQUIPMENT_ADVANCED_BOOT_ORDER = "equipmentAdvancedBootOrder"
    EP_CLASS_ID_EQUIPMENT_ASSOC_CTX = "equipmentAssocCtx"
    EP_CLASS_ID_EQUIPMENT_BEACON_LED = "equipmentBeaconLed"
    EP_CLASS_ID_EQUIPMENT_BEH_CAP = "equipmentBehCap"
    EP_CLASS_ID_EQUIPMENT_BINDING = "equipmentBinding"
    EP_CLASS_ID_EQUIPMENT_BLADE_CAP_PROVIDER = "equipmentBladeCapProvider"
    EP_CLASS_ID_EQUIPMENT_BREAKOUT_CAP = "equipmentBreakoutCap"
    EP_CLASS_ID_EQUIPMENT_CPMETA = "equipmentCPMeta"
    EP_CLASS_ID_EQUIPMENT_CARD = "equipmentCard"
    EP_CLASS_ID_EQUIPMENT_CARTRIDGE_CAP_PROVIDER = "equipmentCartridgeCapProvider"
    EP_CLASS_ID_EQUIPMENT_CHASSIS = "equipmentChassis"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_ASSOC_CTX = "equipmentChassisAssocCtx"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_CAP_PROVIDER = "equipmentChassisCapProvider"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_ISSUES = "equipmentChassisIssues"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_OPERATION = "equipmentChassisOperation"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_POS_QUAL = "equipmentChassisPosQual"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE = "equipmentChassisProfile"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE_ASSOC_CTX = "equipmentChassisProfileAssocCtx"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE_BINDING = "equipmentChassisProfileBinding"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE_FSM = "equipmentChassisProfileFsm"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE = "equipmentChassisProfileFsmStage"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE_FSM_TASK = "equipmentChassisProfileFsmTask"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_QUAL = "equipmentChassisQual"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_REQUIREMENT = "equipmentChassisRequirement"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_STATS = "equipmentChassisStats"
    EP_CLASS_ID_EQUIPMENT_CHASSIS_STATS_HIST = "equipmentChassisStatsHist"
    EP_CLASS_ID_EQUIPMENT_CIMC_VMEDIA = "equipmentCimcVmedia"
    EP_CLASS_ID_EQUIPMENT_COMPUTE_CONN = "equipmentComputeConn"
    EP_CLASS_ID_EQUIPMENT_COMPUTE_CONN_POLICY = "equipmentComputeConnPolicy"
    EP_CLASS_ID_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER = "equipmentComputePhysicalCapProvider"
    EP_CLASS_ID_EQUIPMENT_DEFINITION = "equipmentDefinition"
    EP_CLASS_ID_EQUIPMENT_DRIVE_SEC_CAP = "equipmentDriveSecCap"
    EP_CLASS_ID_EQUIPMENT_FAN = "equipmentFan"
    EP_CLASS_ID_EQUIPMENT_FAN_MODULE = "equipmentFanModule"
    EP_CLASS_ID_EQUIPMENT_FAN_MODULE_CAP_PROVIDER = "equipmentFanModuleCapProvider"
    EP_CLASS_ID_EQUIPMENT_FAN_MODULE_STATS = "equipmentFanModuleStats"
    EP_CLASS_ID_EQUIPMENT_FAN_MODULE_STATS_HIST = "equipmentFanModuleStatsHist"
    EP_CLASS_ID_EQUIPMENT_FAN_STATS = "equipmentFanStats"
    EP_CLASS_ID_EQUIPMENT_FAN_STATS_HIST = "equipmentFanStatsHist"
    EP_CLASS_ID_EQUIPMENT_FEX = "equipmentFex"
    EP_CLASS_ID_EQUIPMENT_FEX_CAP_PROVIDER = "equipmentFexCapProvider"
    EP_CLASS_ID_EQUIPMENT_FEX_ENV_STATS = "equipmentFexEnvStats"
    EP_CLASS_ID_EQUIPMENT_FEX_ENV_STATS_HIST = "equipmentFexEnvStatsHist"
    EP_CLASS_ID_EQUIPMENT_FEX_OPERATION = "equipmentFexOperation"
    EP_CLASS_ID_EQUIPMENT_FEX_POWER_SUMMARY = "equipmentFexPowerSummary"
    EP_CLASS_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST = "equipmentFexPowerSummaryHist"
    EP_CLASS_ID_EQUIPMENT_FEX_PSU_INPUT_STATS = "equipmentFexPsuInputStats"
    EP_CLASS_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST = "equipmentFexPsuInputStatsHist"
    EP_CLASS_ID_EQUIPMENT_FRU_CAP_PROVIDER = "equipmentFruCapProvider"
    EP_CLASS_ID_EQUIPMENT_FRU_VARIANT = "equipmentFruVariant"
    EP_CLASS_ID_EQUIPMENT_GEM_CAP_PROVIDER = "equipmentGemCapProvider"
    EP_CLASS_ID_EQUIPMENT_HEALTH_LED = "equipmentHealthLed"
    EP_CLASS_ID_EQUIPMENT_HOLDER = "equipmentHolder"
    EP_CLASS_ID_EQUIPMENT_HOLDER_CAP_PROVIDER = "equipmentHolderCapProvider"
    EP_CLASS_ID_EQUIPMENT_HOST_IF_CAP_PROVIDER = "equipmentHostIfCapProvider"
    EP_CLASS_ID_EQUIPMENT_HW_CAP_PROVIDER = "equipmentHwCapProvider"
    EP_CLASS_ID_EQUIPMENT_IOCARD = "equipmentIOCard"
    EP_CLASS_ID_EQUIPMENT_IOCARD_BASE = "equipmentIOCardBase"
    EP_CLASS_ID_EQUIPMENT_IOCARD_CAP_PROVIDER = "equipmentIOCardCapProvider"
    EP_CLASS_ID_EQUIPMENT_IOCARD_STATS = "equipmentIOCardStats"
    EP_CLASS_ID_EQUIPMENT_IOCARD_STATS_HIST = "equipmentIOCardStatsHist"
    EP_CLASS_ID_EQUIPMENT_IMPLIED_STORAGE_ENCLOSURE_DEF = "equipmentImpliedStorageEnclosureDef"
    EP_CLASS_ID_EQUIPMENT_INDICATOR_LED = "equipmentIndicatorLed"
    EP_CLASS_ID_EQUIPMENT_INSTANCE = "equipmentInstance"
    EP_CLASS_ID_EQUIPMENT_INSTANCE_MAPPING = "equipmentInstanceMapping"
    EP_CLASS_ID_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER = "equipmentIntegratedComponentCapProvider"
    EP_CLASS_ID_EQUIPMENT_ITEM = "equipmentItem"
    EP_CLASS_ID_EQUIPMENT_LED = "equipmentLed"
    EP_CLASS_ID_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER = "equipmentLocalDiskCapProvider"
    EP_CLASS_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER = "equipmentLocalDiskControllerCapProvider"
    EP_CLASS_ID_EQUIPMENT_LOCAL_DISK_DEF = "equipmentLocalDiskDef"
    EP_CLASS_ID_EQUIPMENT_LOCAL_TEMPL_DEF = "equipmentLocalTemplDef"
    EP_CLASS_ID_EQUIPMENT_LOCATOR_LED = "equipmentLocatorLed"
    EP_CLASS_ID_EQUIPMENT_LOCATOR_LED_OPERATION = "equipmentLocatorLedOperation"
    EP_CLASS_ID_EQUIPMENT_MANUFACTURING_DEF = "equipmentManufacturingDef"
    EP_CLASS_ID_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER = "equipmentMemoryUnitCapProvider"
    EP_CLASS_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS = "equipmentNetworkElementFanStats"
    EP_CLASS_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST = "equipmentNetworkElementFanStatsHist"
    EP_CLASS_ID_EQUIPMENT_PCI_DEF = "equipmentPciDef"
    EP_CLASS_ID_EQUIPMENT_PHYSICAL_QUAL = "equipmentPhysicalQual"
    EP_CLASS_ID_EQUIPMENT_PICTURE = "equipmentPicture"
    EP_CLASS_ID_EQUIPMENT_PLACEABLE = "equipmentPlaceable"
    EP_CLASS_ID_EQUIPMENT_PLACED = "equipmentPlaced"
    EP_CLASS_ID_EQUIPMENT_POOL = "equipmentPool"
    EP_CLASS_ID_EQUIPMENT_POOLABLE = "equipmentPoolable"
    EP_CLASS_ID_EQUIPMENT_POOLED = "equipmentPooled"
    EP_CLASS_ID_EQUIPMENT_POOLING_POLICY = "equipmentPoolingPolicy"
    EP_CLASS_ID_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER = "equipmentProcessorUnitCapProvider"
    EP_CLASS_ID_EQUIPMENT_PSU = "equipmentPsu"
    EP_CLASS_ID_EQUIPMENT_PSU_CAP_PROVIDER = "equipmentPsuCapProvider"
    EP_CLASS_ID_EQUIPMENT_PSU_INPUT_STATS = "equipmentPsuInputStats"
    EP_CLASS_ID_EQUIPMENT_PSU_INPUT_STATS_HIST = "equipmentPsuInputStatsHist"
    EP_CLASS_ID_EQUIPMENT_PSU_OUTPUT_STATS = "equipmentPsuOutputStats"
    EP_CLASS_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST = "equipmentPsuOutputStatsHist"
    EP_CLASS_ID_EQUIPMENT_PSU_STATS = "equipmentPsuStats"
    EP_CLASS_ID_EQUIPMENT_PSU_STATS_HIST = "equipmentPsuStatsHist"
    EP_CLASS_ID_EQUIPMENT_QUAL = "equipmentQual"
    EP_CLASS_ID_EQUIPMENT_QUAL_BASE = "equipmentQualBase"
    EP_CLASS_ID_EQUIPMENT_QUAL_ITEM = "equipmentQualItem"
    EP_CLASS_ID_EQUIPMENT_QUALIFIED_POLICY = "equipmentQualifiedPolicy"
    EP_CLASS_ID_EQUIPMENT_RACK_UNIT_CAP_PROVIDER = "equipmentRackUnitCapProvider"
    EP_CLASS_ID_EQUIPMENT_RACK_UNIT_FAN_STATS = "equipmentRackUnitFanStats"
    EP_CLASS_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST = "equipmentRackUnitFanStatsHist"
    EP_CLASS_ID_EQUIPMENT_RACK_UNIT_PSU_STATS = "equipmentRackUnitPsuStats"
    EP_CLASS_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST = "equipmentRackUnitPsuStatsHist"
    EP_CLASS_ID_EQUIPMENT_REQUIREMENT = "equipmentRequirement"
    EP_CLASS_ID_EQUIPMENT_SECURE_BOOT = "equipmentSecureBoot"
    EP_CLASS_ID_EQUIPMENT_SERVER_FEATURE_CAP = "equipmentServerFeatureCap"
    EP_CLASS_ID_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER = "equipmentServerUnitCapProvider"
    EP_CLASS_ID_EQUIPMENT_SHARED_IOMODULE = "equipmentSharedIOModule"
    EP_CLASS_ID_EQUIPMENT_SIOC_TEMP_STATS = "equipmentSiocTempStats"
    EP_CLASS_ID_EQUIPMENT_SIOC_TEMP_STATS_HIST = "equipmentSiocTempStatsHist"
    EP_CLASS_ID_EQUIPMENT_SLOT_ENCLOSURE = "equipmentSlotEnclosure"
    EP_CLASS_ID_EQUIPMENT_STATEFUL = "equipmentStateful"
    EP_CLASS_ID_EQUIPMENT_STATEFUL_BLADE_COMP = "equipmentStatefulBladeComp"
    EP_CLASS_ID_EQUIPMENT_STATEFUL_CH_COMP = "equipmentStatefulChComp"
    EP_CLASS_ID_EQUIPMENT_STORAGE_PROCESSOR_CAP = "equipmentStorageProcessorCap"
    EP_CLASS_ID_EQUIPMENT_SWITCH_CAP_PROVIDER = "equipmentSwitchCapProvider"
    EP_CLASS_ID_EQUIPMENT_SWITCH_CARD = "equipmentSwitchCard"
    EP_CLASS_ID_EQUIPMENT_SWITCH_IOCARD = "equipmentSwitchIOCard"
    EP_CLASS_ID_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER = "equipmentSwitchIOCardCapProvider"
    EP_CLASS_ID_EQUIPMENT_SYSTEM_FRU_CAP_PROVIDER = "equipmentSystemFruCapProvider"
    EP_CLASS_ID_EQUIPMENT_SYSTEM_IOCONTROLLER = "equipmentSystemIOController"
    EP_CLASS_ID_EQUIPMENT_SYSTEM_IOCONTROLLER_OPERATION = "equipmentSystemIOControllerOperation"
    EP_CLASS_ID_EQUIPMENT_TEMPLATE = "equipmentTemplate"
    EP_CLASS_ID_EQUIPMENT_TEMPLATE_MAPPING = "equipmentTemplateMapping"
    EP_CLASS_ID_EQUIPMENT_TIER = "equipmentTier"
    EP_CLASS_ID_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER = "equipmentUnifiedPortCapProvider"
    EP_CLASS_ID_EQUIPMENT_XCVR = "equipmentXcvr"
    EP_CLASS_ID_ETHER_ERR_STATS = "etherErrStats"
    EP_CLASS_ID_ETHER_ERR_STATS_HIST = "etherErrStatsHist"
    EP_CLASS_ID_ETHER_FCOE_INTERFACE_STATS = "etherFcoeInterfaceStats"
    EP_CLASS_ID_ETHER_FCOE_INTERFACE_STATS_HIST = "etherFcoeInterfaceStatsHist"
    EP_CLASS_ID_ETHER_LOSS_STATS = "etherLossStats"
    EP_CLASS_ID_ETHER_LOSS_STATS_HIST = "etherLossStatsHist"
    EP_CLASS_ID_ETHER_PIO = "etherPIo"
    EP_CLASS_ID_ETHER_PAUSE_STATS = "etherPauseStats"
    EP_CLASS_ID_ETHER_PAUSE_STATS_HIST = "etherPauseStatsHist"
    EP_CLASS_ID_ETHER_RX_STATS = "etherRxStats"
    EP_CLASS_ID_ETHER_RX_STATS_HIST = "etherRxStatsHist"
    EP_CLASS_ID_ETHER_SERVER_INT_FIO = "etherServerIntFIo"
    EP_CLASS_ID_ETHER_SWITCH_INT_FIO = "etherSwitchIntFIo"
    EP_CLASS_ID_ETHER_TX_STATS = "etherTxStats"
    EP_CLASS_ID_ETHER_TX_STATS_HIST = "etherTxStatsHist"
    EP_CLASS_ID_EVENT_APPLICATION = "eventApplication"
    EP_CLASS_ID_EVENT_EP_CTRL = "eventEpCtrl"
    EP_CLASS_ID_EVENT_HOLDER = "eventHolder"
    EP_CLASS_ID_EVENT_INST = "eventInst"
    EP_CLASS_ID_EVENT_LOG = "eventLog"
    EP_CLASS_ID_EVENT_POLICY = "eventPolicy"
    EP_CLASS_ID_EVENT_RECORD = "eventRecord"
    EP_CLASS_ID_EXTMGMT_ARP_TARGETS = "extmgmtArpTargets"
    EP_CLASS_ID_EXTMGMT_GATEWAY_PING = "extmgmtGatewayPing"
    EP_CLASS_ID_EXTMGMT_IF_MON_POLICY = "extmgmtIfMonPolicy"
    EP_CLASS_ID_EXTMGMT_MII_STATUS = "extmgmtMiiStatus"
    EP_CLASS_ID_EXTMGMT_NDISC_TARGETS = "extmgmtNdiscTargets"
    EP_CLASS_ID_EXTPOL_CLIENT = "extpolClient"
    EP_CLASS_ID_EXTPOL_CLIENT_CONT = "extpolClientCont"
    EP_CLASS_ID_EXTPOL_CLIENT_FSM = "extpolClientFsm"
    EP_CLASS_ID_EXTPOL_CLIENT_FSM_STAGE = "extpolClientFsmStage"
    EP_CLASS_ID_EXTPOL_CLIENT_FSM_TASK = "extpolClientFsmTask"
    EP_CLASS_ID_EXTPOL_CONNECTOR = "extpolConnector"
    EP_CLASS_ID_EXTPOL_CONNECTOR_CONTAINER = "extpolConnectorContainer"
    EP_CLASS_ID_EXTPOL_CONTROLLER = "extpolController"
    EP_CLASS_ID_EXTPOL_CONTROLLER_CONT = "extpolControllerCont"
    EP_CLASS_ID_EXTPOL_DOMAIN = "extpolDomain"
    EP_CLASS_ID_EXTPOL_EP = "extpolEp"
    EP_CLASS_ID_EXTPOL_EP_FSM = "extpolEpFsm"
    EP_CLASS_ID_EXTPOL_EP_FSM_STAGE = "extpolEpFsmStage"
    EP_CLASS_ID_EXTPOL_EP_FSM_TASK = "extpolEpFsmTask"
    EP_CLASS_ID_EXTPOL_HBSTATUS = "extpolHBStatus"
    EP_CLASS_ID_EXTPOL_PROVIDER = "extpolProvider"
    EP_CLASS_ID_EXTPOL_PROVIDER_CONT = "extpolProviderCont"
    EP_CLASS_ID_EXTPOL_REGISTRY = "extpolRegistry"
    EP_CLASS_ID_EXTPOL_REGISTRY_CAPABILITY = "extpolRegistryCapability"
    EP_CLASS_ID_EXTPOL_SVC = "extpolSvc"
    EP_CLASS_ID_EXTPOL_SYSTEM_CONTEXT = "extpolSystemContext"
    EP_CLASS_ID_EXTPOL_VERSION_HOLDER = "extpolVersionHolder"
    EP_CLASS_ID_EXTVMM_NETWORK_SETS = "extvmmNetworkSets"
    EP_CLASS_ID_EXTVMM_VMNETWORK_SETS = "extvmmVMNetworkSets"
    EP_CLASS_ID_FABRIC_ADCE_SW_SRV_EP = "fabricADceSwSrvEp"
    EP_CLASS_ID_FABRIC_AETH_ESTC_EP = "fabricAEthEstcEp"
    EP_CLASS_ID_FABRIC_AETH_LAN_EP = "fabricAEthLanEp"
    EP_CLASS_ID_FABRIC_AFC_ESTC_EP = "fabricAFcEstcEp"
    EP_CLASS_ID_FABRIC_AFC_SAN_EP = "fabricAFcSanEp"
    EP_CLASS_ID_FABRIC_AFCOE_ESTC_EP = "fabricAFcoeEstcEp"
    EP_CLASS_ID_FABRIC_AFCOE_SAN_EP = "fabricAFcoeSanEp"
    EP_CLASS_ID_FABRIC_AGROUP_REQ = "fabricAGroupReq"
    EP_CLASS_ID_FABRIC_ANET_GROUP = "fabricANetGroup"
    EP_CLASS_ID_FABRIC_ANET_GROUP_REF = "fabricANetGroupRef"
    EP_CLASS_ID_FABRIC_ASAN_GROUP = "fabricASanGroup"
    EP_CLASS_ID_FABRIC_AVLAN = "fabricAVlan"
    EP_CLASS_ID_FABRIC_AVSAN = "fabricAVsan"
    EP_CLASS_ID_FABRIC_BASE_NET_GROUP = "fabricBaseNetGroup"
    EP_CLASS_ID_FABRIC_BASE_PH_EP = "fabricBasePhEp"
    EP_CLASS_ID_FABRIC_BASE_SLOT_EP = "fabricBaseSlotEp"
    EP_CLASS_ID_FABRIC_BREAKOUT = "fabricBreakout"
    EP_CLASS_ID_FABRIC_BREAKOUT_OPERATION = "fabricBreakoutOperation"
    EP_CLASS_ID_FABRIC_CIO_EP = "fabricCIoEp"
    EP_CLASS_ID_FABRIC_CABLING = "fabricCabling"
    EP_CLASS_ID_FABRIC_CABLING_SW = "fabricCablingSw"
    EP_CLASS_ID_FABRIC_CARTRIDGE_SLOT_EP = "fabricCartridgeSlotEp"
    EP_CLASS_ID_FABRIC_CARTRIDGE_SLOT_EP_OPERATION = "fabricCartridgeSlotEpOperation"
    EP_CLASS_ID_FABRIC_CDP_LINK_POLICY = "fabricCdpLinkPolicy"
    EP_CLASS_ID_FABRIC_CHANGED_OBJECT_REF = "fabricChangedObjectRef"
    EP_CLASS_ID_FABRIC_CHASSIS_EP = "fabricChassisEp"
    EP_CLASS_ID_FABRIC_CLOUD = "fabricCloud"
    EP_CLASS_ID_FABRIC_COMPUTE_EP = "fabricComputeEp"
    EP_CLASS_ID_FABRIC_COMPUTE_MSLOT_EP = "fabricComputeMSlotEp"
    EP_CLASS_ID_FABRIC_COMPUTE_PH_EP = "fabricComputePhEp"
    EP_CLASS_ID_FABRIC_COMPUTE_PH_EP_OPERATION = "fabricComputePhEpOperation"
    EP_CLASS_ID_FABRIC_COMPUTE_SLOT_EP = "fabricComputeSlotEp"
    EP_CLASS_ID_FABRIC_COMPUTE_SLOT_EP_OPERATION = "fabricComputeSlotEpOperation"
    EP_CLASS_ID_FABRIC_CONSUMER = "fabricConsumer"
    EP_CLASS_ID_FABRIC_DCE_SRV = "fabricDceSrv"
    EP_CLASS_ID_FABRIC_DCE_SW_SRV = "fabricDceSwSrv"
    EP_CLASS_ID_FABRIC_DCE_SW_SRV_EP = "fabricDceSwSrvEp"
    EP_CLASS_ID_FABRIC_DCE_SW_SRV_EP_OPERATION = "fabricDceSwSrvEpOperation"
    EP_CLASS_ID_FABRIC_DCE_SW_SRV_PC = "fabricDceSwSrvPc"
    EP_CLASS_ID_FABRIC_DCE_SW_SRV_PC_EP = "fabricDceSwSrvPcEp"
    EP_CLASS_ID_FABRIC_DCE_SW_SRV_PC_EP_OPERATION = "fabricDceSwSrvPcEpOperation"
    EP_CLASS_ID_FABRIC_DCE_SW_SRV_PC_OPERATION = "fabricDceSwSrvPcOperation"
    EP_CLASS_ID_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM = "fabricDceSwSrvPcOperationFsm"
    EP_CLASS_ID_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_STAGE = "fabricDceSwSrvPcOperationFsmStage"
    EP_CLASS_ID_FABRIC_DOMAIN = "fabricDomain"
    EP_CLASS_ID_FABRIC_DOMAIN_EP = "fabricDomainEp"
    EP_CLASS_ID_FABRIC_ENCLOSURE_PH_EP = "fabricEnclosurePhEp"
    EP_CLASS_ID_FABRIC_ENCLOSURE_PH_EP_OPERATION = "fabricEnclosurePhEpOperation"
    EP_CLASS_ID_FABRIC_ENCLOSURE_SLOT_EP = "fabricEnclosureSlotEp"
    EP_CLASS_ID_FABRIC_ENCLOSURE_SLOT_EP_OPERATION = "fabricEnclosureSlotEpOperation"
    EP_CLASS_ID_FABRIC_EP = "fabricEp"
    EP_CLASS_ID_FABRIC_EP_VLAN = "fabricEpVlan"
    EP_CLASS_ID_FABRIC_EP_VSAN = "fabricEpVsan"
    EP_CLASS_ID_FABRIC_EQUIPMENT_EP = "fabricEquipmentEp"
    EP_CLASS_ID_FABRIC_ESTC_EP = "fabricEstcEp"
    EP_CLASS_ID_FABRIC_ESTC_PC = "fabricEstcPc"
    EP_CLASS_ID_FABRIC_ETH_CDP_POLICY = "fabricEthCdpPolicy"
    EP_CLASS_ID_FABRIC_ETH_ESTC = "fabricEthEstc"
    EP_CLASS_ID_FABRIC_ETH_ESTC_CLOUD = "fabricEthEstcCloud"
    EP_CLASS_ID_FABRIC_ETH_ESTC_EP = "fabricEthEstcEp"
    EP_CLASS_ID_FABRIC_ETH_ESTC_EP_OPERATION = "fabricEthEstcEpOperation"
    EP_CLASS_ID_FABRIC_ETH_ESTC_EP_OPERATION_FSM = "fabricEthEstcEpOperationFsm"
    EP_CLASS_ID_FABRIC_ETH_ESTC_EP_OPERATION_FSM_STAGE = "fabricEthEstcEpOperationFsmStage"
    EP_CLASS_ID_FABRIC_ETH_ESTC_PC = "fabricEthEstcPc"
    EP_CLASS_ID_FABRIC_ETH_ESTC_PC_EP = "fabricEthEstcPcEp"
    EP_CLASS_ID_FABRIC_ETH_ESTC_PC_EP_OPERATION = "fabricEthEstcPcEpOperation"
    EP_CLASS_ID_FABRIC_ETH_ESTC_PC_OPERATION = "fabricEthEstcPcOperation"
    EP_CLASS_ID_FABRIC_ETH_ESTC_PC_OPERATION_FSM = "fabricEthEstcPcOperationFsm"
    EP_CLASS_ID_FABRIC_ETH_ESTC_PC_OPERATION_FSM_STAGE = "fabricEthEstcPcOperationFsmStage"
    EP_CLASS_ID_FABRIC_ETH_LAN = "fabricEthLan"
    EP_CLASS_ID_FABRIC_ETH_LAN_EP = "fabricEthLanEp"
    EP_CLASS_ID_FABRIC_ETH_LAN_EP_OPERATION = "fabricEthLanEpOperation"
    EP_CLASS_ID_FABRIC_ETH_LAN_EP_OPERATION_FSM = "fabricEthLanEpOperationFsm"
    EP_CLASS_ID_FABRIC_ETH_LAN_EP_OPERATION_FSM_STAGE = "fabricEthLanEpOperationFsmStage"
    EP_CLASS_ID_FABRIC_ETH_LAN_PC = "fabricEthLanPc"
    EP_CLASS_ID_FABRIC_ETH_LAN_PC_EP = "fabricEthLanPcEp"
    EP_CLASS_ID_FABRIC_ETH_LAN_PC_EP_OPERATION = "fabricEthLanPcEpOperation"
    EP_CLASS_ID_FABRIC_ETH_LAN_PC_OPERATION = "fabricEthLanPcOperation"
    EP_CLASS_ID_FABRIC_ETH_LAN_PC_OPERATION_FSM = "fabricEthLanPcOperationFsm"
    EP_CLASS_ID_FABRIC_ETH_LAN_PC_OPERATION_FSM_STAGE = "fabricEthLanPcOperationFsmStage"
    EP_CLASS_ID_FABRIC_ETH_LINK_POLICY = "fabricEthLinkPolicy"
    EP_CLASS_ID_FABRIC_ETH_LINK_PROFILE = "fabricEthLinkProfile"
    EP_CLASS_ID_FABRIC_ETH_MON = "fabricEthMon"
    EP_CLASS_ID_FABRIC_ETH_MON_DEST_EP = "fabricEthMonDestEp"
    EP_CLASS_ID_FABRIC_ETH_MON_DEST_EP_OPERATION = "fabricEthMonDestEpOperation"
    EP_CLASS_ID_FABRIC_ETH_MON_LAN = "fabricEthMonLan"
    EP_CLASS_ID_FABRIC_ETH_MON_OPERATION = "fabricEthMonOperation"
    EP_CLASS_ID_FABRIC_ETH_MON_OPERATION_FSM = "fabricEthMonOperationFsm"
    EP_CLASS_ID_FABRIC_ETH_MON_OPERATION_FSM_STAGE = "fabricEthMonOperationFsmStage"
    EP_CLASS_ID_FABRIC_ETH_MON_SRC_EP = "fabricEthMonSrcEp"
    EP_CLASS_ID_FABRIC_ETH_MON_SRC_EP_OPERATION = "fabricEthMonSrcEpOperation"
    EP_CLASS_ID_FABRIC_ETH_MON_SRC_REF = "fabricEthMonSrcRef"
    EP_CLASS_ID_FABRIC_ETH_PORT_OPERATION = "fabricEthPortOperation"
    EP_CLASS_ID_FABRIC_ETH_PORT_OPERATION_FSM = "fabricEthPortOperationFsm"
    EP_CLASS_ID_FABRIC_ETH_PORT_OPERATION_FSM_STAGE = "fabricEthPortOperationFsmStage"
    EP_CLASS_ID_FABRIC_ETH_TARGET_EP = "fabricEthTargetEp"
    EP_CLASS_ID_FABRIC_ETH_TARGET_EP_OPERATION = "fabricEthTargetEpOperation"
    EP_CLASS_ID_FABRIC_ETH_UDLD_POLICY = "fabricEthUdldPolicy"
    EP_CLASS_ID_FABRIC_ETH_VLAN_PC = "fabricEthVlanPc"
    EP_CLASS_ID_FABRIC_ETH_VLAN_PORT_EP = "fabricEthVlanPortEp"
    EP_CLASS_ID_FABRIC_ETHER_REF = "fabricEtherRef"
    EP_CLASS_ID_FABRIC_EXTENSION = "fabricExtension"
    EP_CLASS_ID_FABRIC_EXTERNAL = "fabricExternal"
    EP_CLASS_ID_FABRIC_EXTERNAL_EP = "fabricExternalEp"
    EP_CLASS_ID_FABRIC_EXTERNAL_ESTC = "fabricExternalEstc"
    EP_CLASS_ID_FABRIC_EXTERNAL_PC = "fabricExternalPc"
    EP_CLASS_ID_FABRIC_FIPORT_OPERATION = "fabricFIPortOperation"
    EP_CLASS_ID_FABRIC_FIPORT_OPERATION_FSM = "fabricFIPortOperationFsm"
    EP_CLASS_ID_FABRIC_FIPORT_OPERATION_FSM_STAGE = "fabricFIPortOperationFsmStage"
    EP_CLASS_ID_FABRIC_FIPORT_OPERATION_FSM_TASK = "fabricFIPortOperationFsmTask"
    EP_CLASS_ID_FABRIC_FC_ENDPOINT = "fabricFcEndpoint"
    EP_CLASS_ID_FABRIC_FC_ESTC = "fabricFcEstc"
    EP_CLASS_ID_FABRIC_FC_ESTC_CLOUD = "fabricFcEstcCloud"
    EP_CLASS_ID_FABRIC_FC_ESTC_EP = "fabricFcEstcEp"
    EP_CLASS_ID_FABRIC_FC_ESTC_EP_OPERATION = "fabricFcEstcEpOperation"
    EP_CLASS_ID_FABRIC_FC_ESTC_EP_OPERATION_FSM = "fabricFcEstcEpOperationFsm"
    EP_CLASS_ID_FABRIC_FC_ESTC_EP_OPERATION_FSM_STAGE = "fabricFcEstcEpOperationFsmStage"
    EP_CLASS_ID_FABRIC_FC_MON = "fabricFcMon"
    EP_CLASS_ID_FABRIC_FC_MON_DEST_EP = "fabricFcMonDestEp"
    EP_CLASS_ID_FABRIC_FC_MON_DEST_EP_OPERATION = "fabricFcMonDestEpOperation"
    EP_CLASS_ID_FABRIC_FC_MON_OPERATION = "fabricFcMonOperation"
    EP_CLASS_ID_FABRIC_FC_MON_OPERATION_FSM = "fabricFcMonOperationFsm"
    EP_CLASS_ID_FABRIC_FC_MON_OPERATION_FSM_STAGE = "fabricFcMonOperationFsmStage"
    EP_CLASS_ID_FABRIC_FC_MON_SAN = "fabricFcMonSan"
    EP_CLASS_ID_FABRIC_FC_MON_SRC_EP = "fabricFcMonSrcEp"
    EP_CLASS_ID_FABRIC_FC_MON_SRC_EP_OPERATION = "fabricFcMonSrcEpOperation"
    EP_CLASS_ID_FABRIC_FC_MON_SRC_REF = "fabricFcMonSrcRef"
    EP_CLASS_ID_FABRIC_FC_PORT_OPERATION = "fabricFcPortOperation"
    EP_CLASS_ID_FABRIC_FC_PORT_OPERATION_FSM = "fabricFcPortOperationFsm"
    EP_CLASS_ID_FABRIC_FC_PORT_OPERATION_FSM_STAGE = "fabricFcPortOperationFsmStage"
    EP_CLASS_ID_FABRIC_FC_SAN = "fabricFcSan"
    EP_CLASS_ID_FABRIC_FC_SAN_EP = "fabricFcSanEp"
    EP_CLASS_ID_FABRIC_FC_SAN_EP_OPERATION = "fabricFcSanEpOperation"
    EP_CLASS_ID_FABRIC_FC_SAN_EP_OPERATION_FSM = "fabricFcSanEpOperationFsm"
    EP_CLASS_ID_FABRIC_FC_SAN_EP_OPERATION_FSM_STAGE = "fabricFcSanEpOperationFsmStage"
    EP_CLASS_ID_FABRIC_FC_SAN_PC = "fabricFcSanPc"
    EP_CLASS_ID_FABRIC_FC_SAN_PC_EP = "fabricFcSanPcEp"
    EP_CLASS_ID_FABRIC_FC_SAN_PC_EP_OPERATION = "fabricFcSanPcEpOperation"
    EP_CLASS_ID_FABRIC_FC_SAN_PC_OPERATION = "fabricFcSanPcOperation"
    EP_CLASS_ID_FABRIC_FC_SAN_PC_OPERATION_FSM = "fabricFcSanPcOperationFsm"
    EP_CLASS_ID_FABRIC_FC_SAN_PC_OPERATION_FSM_STAGE = "fabricFcSanPcOperationFsmStage"
    EP_CLASS_ID_FABRIC_FC_UPLINK_OPERATION = "fabricFcUplinkOperation"
    EP_CLASS_ID_FABRIC_FC_USER_ZONE = "fabricFcUserZone"
    EP_CLASS_ID_FABRIC_FC_USER_ZONE_IVT = "fabricFcUserZoneIvt"
    EP_CLASS_ID_FABRIC_FC_VSAN_PC = "fabricFcVsanPc"
    EP_CLASS_ID_FABRIC_FC_VSAN_PORT_EP = "fabricFcVsanPortEp"
    EP_CLASS_ID_FABRIC_FC_ZONE_PROFILE = "fabricFcZoneProfile"
    EP_CLASS_ID_FABRIC_FC_ZONE_PROFILE_FSM = "fabricFcZoneProfileFsm"
    EP_CLASS_ID_FABRIC_FC_ZONE_PROFILE_FSM_STAGE = "fabricFcZoneProfileFsmStage"
    EP_CLASS_ID_FABRIC_FC_ZONE_PROFILE_FSM_TASK = "fabricFcZoneProfileFsmTask"
    EP_CLASS_ID_FABRIC_FC_ZONE_PROFILE_IVT = "fabricFcZoneProfileIvt"
    EP_CLASS_ID_FABRIC_FCOE_ESTC_EP = "fabricFcoeEstcEp"
    EP_CLASS_ID_FABRIC_FCOE_ESTC_EP_OPERATION = "fabricFcoeEstcEpOperation"
    EP_CLASS_ID_FABRIC_FCOE_ESTC_EP_OPERATION_FSM = "fabricFcoeEstcEpOperationFsm"
    EP_CLASS_ID_FABRIC_FCOE_ESTC_EP_OPERATION_FSM_STAGE = "fabricFcoeEstcEpOperationFsmStage"
    EP_CLASS_ID_FABRIC_FCOE_SAN_EP = "fabricFcoeSanEp"
    EP_CLASS_ID_FABRIC_FCOE_SAN_EP_OPERATION = "fabricFcoeSanEpOperation"
    EP_CLASS_ID_FABRIC_FCOE_SAN_EP_OPERATION_FSM = "fabricFcoeSanEpOperationFsm"
    EP_CLASS_ID_FABRIC_FCOE_SAN_EP_OPERATION_FSM_STAGE = "fabricFcoeSanEpOperationFsmStage"
    EP_CLASS_ID_FABRIC_FCOE_SAN_PC = "fabricFcoeSanPc"
    EP_CLASS_ID_FABRIC_FCOE_SAN_PC_EP = "fabricFcoeSanPcEp"
    EP_CLASS_ID_FABRIC_FCOE_SAN_PC_EP_OPERATION = "fabricFcoeSanPcEpOperation"
    EP_CLASS_ID_FABRIC_FCOE_SAN_PC_OPERATION = "fabricFcoeSanPcOperation"
    EP_CLASS_ID_FABRIC_FCOE_SAN_PC_OPERATION_FSM = "fabricFcoeSanPcOperationFsm"
    EP_CLASS_ID_FABRIC_FCOE_SAN_PC_OPERATION_FSM_STAGE = "fabricFcoeSanPcOperationFsmStage"
    EP_CLASS_ID_FABRIC_FCOE_VSAN_PC = "fabricFcoeVsanPc"
    EP_CLASS_ID_FABRIC_FCOE_VSAN_PORT_EP = "fabricFcoeVsanPortEp"
    EP_CLASS_ID_FABRIC_HOLDER = "fabricHolder"
    EP_CLASS_ID_FABRIC_IF = "fabricIf"
    EP_CLASS_ID_FABRIC_INTERNAL = "fabricInternal"
    EP_CLASS_ID_FABRIC_INTERNAL_DCE_SRV = "fabricInternalDceSrv"
    EP_CLASS_ID_FABRIC_INTERNAL_EP = "fabricInternalEp"
    EP_CLASS_ID_FABRIC_INTERNAL_PC = "fabricInternalPc"
    EP_CLASS_ID_FABRIC_LACP_POLICY = "fabricLacpPolicy"
    EP_CLASS_ID_FABRIC_LAN = "fabricLan"
    EP_CLASS_ID_FABRIC_LAN_ACCESS_MGR = "fabricLanAccessMgr"
    EP_CLASS_ID_FABRIC_LAN_CLOUD = "fabricLanCloud"
    EP_CLASS_ID_FABRIC_LAN_CLOUD_POLICY = "fabricLanCloudPolicy"
    EP_CLASS_ID_FABRIC_LAN_EP = "fabricLanEp"
    EP_CLASS_ID_FABRIC_LAN_MON_CLOUD = "fabricLanMonCloud"
    EP_CLASS_ID_FABRIC_LAN_PC = "fabricLanPc"
    EP_CLASS_ID_FABRIC_LAN_PIN_GROUP = "fabricLanPinGroup"
    EP_CLASS_ID_FABRIC_LAN_PIN_GROUP_OPERATION = "fabricLanPinGroupOperation"
    EP_CLASS_ID_FABRIC_LAN_PIN_TARGET = "fabricLanPinTarget"
    EP_CLASS_ID_FABRIC_LAN_PIN_TARGET_OPERATION = "fabricLanPinTargetOperation"
    EP_CLASS_ID_FABRIC_LAST_ACKED_SLOT = "fabricLastAckedSlot"
    EP_CLASS_ID_FABRIC_LINK_POLICY = "fabricLinkPolicy"
    EP_CLASS_ID_FABRIC_MON = "fabricMon"
    EP_CLASS_ID_FABRIC_MON_DEST_EP = "fabricMonDestEp"
    EP_CLASS_ID_FABRIC_MON_SRC_EP = "fabricMonSrcEp"
    EP_CLASS_ID_FABRIC_MON_SRC_REF = "fabricMonSrcRef"
    EP_CLASS_ID_FABRIC_MULTICAST_POLICY = "fabricMulticastPolicy"
    EP_CLASS_ID_FABRIC_NET_GROUP = "fabricNetGroup"
    EP_CLASS_ID_FABRIC_NET_GROUP_EP = "fabricNetGroupEp"
    EP_CLASS_ID_FABRIC_NET_GROUP_PERMIT = "fabricNetGroupPermit"
    EP_CLASS_ID_FABRIC_NET_GROUP_REF = "fabricNetGroupRef"
    EP_CLASS_ID_FABRIC_NET_GROUP_REQ = "fabricNetGroupReq"
    EP_CLASS_ID_FABRIC_ORG_VLAN_POLICY = "fabricOrgVlanPolicy"
    EP_CLASS_ID_FABRIC_PIO_EP = "fabricPIoEp"
    EP_CLASS_ID_FABRIC_PIN_GROUP = "fabricPinGroup"
    EP_CLASS_ID_FABRIC_PIN_TARGET = "fabricPinTarget"
    EP_CLASS_ID_FABRIC_POOLABLE_VLAN = "fabricPoolableVlan"
    EP_CLASS_ID_FABRIC_POOLED_VLAN = "fabricPooledVlan"
    EP_CLASS_ID_FABRIC_SAN = "fabricSan"
    EP_CLASS_ID_FABRIC_SAN_CLOUD = "fabricSanCloud"
    EP_CLASS_ID_FABRIC_SAN_EP = "fabricSanEp"
    EP_CLASS_ID_FABRIC_SAN_GROUP = "fabricSanGroup"
    EP_CLASS_ID_FABRIC_SAN_GROUP_REF = "fabricSanGroupRef"
    EP_CLASS_ID_FABRIC_SAN_MON_CLOUD = "fabricSanMonCloud"
    EP_CLASS_ID_FABRIC_SAN_PC = "fabricSanPc"
    EP_CLASS_ID_FABRIC_SAN_PIN_GROUP = "fabricSanPinGroup"
    EP_CLASS_ID_FABRIC_SAN_PIN_GROUP_OPERATION = "fabricSanPinGroupOperation"
    EP_CLASS_ID_FABRIC_SAN_PIN_TARGET = "fabricSanPinTarget"
    EP_CLASS_ID_FABRIC_SAN_PIN_TARGET_OPERATION = "fabricSanPinTargetOperation"
    EP_CLASS_ID_FABRIC_SUB_GROUP = "fabricSubGroup"
    EP_CLASS_ID_FABRIC_SW_CH_EP = "fabricSwChEp"
    EP_CLASS_ID_FABRIC_SW_CH_PH_EP = "fabricSwChPhEp"
    EP_CLASS_ID_FABRIC_SW_CH_PH_EP_OPERATION = "fabricSwChPhEpOperation"
    EP_CLASS_ID_FABRIC_SW_SRV_EP = "fabricSwSrvEp"
    EP_CLASS_ID_FABRIC_SW_SRV_PC = "fabricSwSrvPc"
    EP_CLASS_ID_FABRIC_SW_SUB_GROUP = "fabricSwSubGroup"
    EP_CLASS_ID_FABRIC_SYSTEM = "fabricSystem"
    EP_CLASS_ID_FABRIC_TARGET_EP = "fabricTargetEp"
    EP_CLASS_ID_FABRIC_UDLD_LINK_POLICY = "fabricUdldLinkPolicy"
    EP_CLASS_ID_FABRIC_UDLD_POLICY = "fabricUdldPolicy"
    EP_CLASS_ID_FABRIC_VCON = "fabricVCon"
    EP_CLASS_ID_FABRIC_VCON_PROFILE = "fabricVConProfile"
    EP_CLASS_ID_FABRIC_VLAN = "fabricVlan"
    EP_CLASS_ID_FABRIC_VLAN_EP = "fabricVlanEp"
    EP_CLASS_ID_FABRIC_VLAN_GROUP_REQ = "fabricVlanGroupReq"
    EP_CLASS_ID_FABRIC_VLAN_PERMIT = "fabricVlanPermit"
    EP_CLASS_ID_FABRIC_VLAN_PERMIT_ITEM = "fabricVlanPermitItem"
    EP_CLASS_ID_FABRIC_VLAN_REQ = "fabricVlanReq"
    EP_CLASS_ID_FABRIC_VNET_EP = "fabricVnetEp"
    EP_CLASS_ID_FABRIC_VNET_EP_SYNC_EP = "fabricVnetEpSyncEp"
    EP_CLASS_ID_FABRIC_VNET_EP_SYNC_EP_FSM = "fabricVnetEpSyncEpFsm"
    EP_CLASS_ID_FABRIC_VNET_EP_SYNC_EP_FSM_STAGE = "fabricVnetEpSyncEpFsmStage"
    EP_CLASS_ID_FABRIC_VNET_EP_SYNC_EP_FSM_TASK = "fabricVnetEpSyncEpFsmTask"
    EP_CLASS_ID_FABRIC_VNET_GROUP_REQ = "fabricVnetGroupReq"
    EP_CLASS_ID_FABRIC_VNET_REQ = "fabricVnetReq"
    EP_CLASS_ID_FABRIC_VSAN = "fabricVsan"
    EP_CLASS_ID_FABRIC_VSAN_EP = "fabricVsanEp"
    EP_CLASS_ID_FABRIC_VSAN_MEMBERSHIP = "fabricVsanMembership"
    EP_CLASS_ID_FAULT_BASE_HOLDER = "faultBaseHolder"
    EP_CLASS_ID_FAULT_BASE_POLICY = "faultBasePolicy"
    EP_CLASS_ID_FAULT_BASE_TYPED_HOLDER = "faultBaseTypedHolder"
    EP_CLASS_ID_FAULT_DOMAIN_EP = "faultDomainEp"
    EP_CLASS_ID_FAULT_DOMAIN_INST = "faultDomainInst"
    EP_CLASS_ID_FAULT_GLOBAL_SEVERITY_HOLDER = "faultGlobalSeverityHolder"
    EP_CLASS_ID_FAULT_GLOBAL_TYPED_HOLDER = "faultGlobalTypedHolder"
    EP_CLASS_ID_FAULT_HOLDER = "faultHolder"
    EP_CLASS_ID_FAULT_INST = "faultInst"
    EP_CLASS_ID_FAULT_LOCAL_BASE_HOLDER = "faultLocalBaseHolder"
    EP_CLASS_ID_FAULT_LOCAL_TYPED_HOLDER = "faultLocalTypedHolder"
    EP_CLASS_ID_FAULT_POLICY = "faultPolicy"
    EP_CLASS_ID_FAULT_SUMMARY = "faultSummary"
    EP_CLASS_ID_FAULT_SUMMARY_INST = "faultSummaryInst"
    EP_CLASS_ID_FAULT_SVC_SUMMARY = "faultSvcSummary"
    EP_CLASS_ID_FAULT_TYPED_HOLDER = "faultTypedHolder"
    EP_CLASS_ID_FC_ERR_STATS = "fcErrStats"
    EP_CLASS_ID_FC_ERR_STATS_HIST = "fcErrStatsHist"
    EP_CLASS_ID_FC_PIO = "fcPIo"
    EP_CLASS_ID_FC_STATS = "fcStats"
    EP_CLASS_ID_FC_STATS_HIST = "fcStatsHist"
    EP_CLASS_ID_FCPOOL_ADDR = "fcpoolAddr"
    EP_CLASS_ID_FCPOOL_BLOCK = "fcpoolBlock"
    EP_CLASS_ID_FCPOOL_BOOT_TARGET = "fcpoolBootTarget"
    EP_CLASS_ID_FCPOOL_FORMAT = "fcpoolFormat"
    EP_CLASS_ID_FCPOOL_INITIATOR = "fcpoolInitiator"
    EP_CLASS_ID_FCPOOL_INITIATOR_EP = "fcpoolInitiatorEp"
    EP_CLASS_ID_FCPOOL_INITIATORS = "fcpoolInitiators"
    EP_CLASS_ID_FCPOOL_UNIVERSE = "fcpoolUniverse"
    EP_CLASS_ID_FD_BLADE = "fdBlade"
    EP_CLASS_ID_FD_BLADE_FSM = "fdBladeFsm"
    EP_CLASS_ID_FD_BLADE_FSM_STAGE = "fdBladeFsmStage"
    EP_CLASS_ID_FD_CHASSIS = "fdChassis"
    EP_CLASS_ID_FD_OPERABLE = "fdOperable"
    EP_CLASS_ID_FD_PHYSICAL = "fdPhysical"
    EP_CLASS_ID_FD_PHYSICAL_FSM = "fdPhysicalFsm"
    EP_CLASS_ID_FD_PHYSICAL_FSM_STAGE = "fdPhysicalFsmStage"
    EP_CLASS_ID_FD_PHYSICAL_FSM_TASK = "fdPhysicalFsmTask"
    EP_CLASS_ID_FD_RACK_UNIT = "fdRackUnit"
    EP_CLASS_ID_FD_RACK_UNIT_FSM = "fdRackUnitFsm"
    EP_CLASS_ID_FD_RACK_UNIT_FSM_STAGE = "fdRackUnitFsmStage"
    EP_CLASS_ID_FEATURE_CATALOG_EP = "featureCatalogEp"
    EP_CLASS_ID_FEATURE_CHASSIS_DEF = "featureChassisDef"
    EP_CLASS_ID_FEATURE_DEFINITION = "featureDefinition"
    EP_CLASS_ID_FEATURE_ENV_DEF = "featureEnvDef"
    EP_CLASS_ID_FEATURE_NETWORK_DEF = "featureNetworkDef"
    EP_CLASS_ID_FEATURE_SERVER_DEF = "featureServerDef"
    EP_CLASS_ID_FEATURE_STORAGE_DEF = "featureStorageDef"
    EP_CLASS_ID_FIRMWARE_ACOMPONENT_SPEC = "firmwareAComponentSpec"
    EP_CLASS_ID_FIRMWARE_AEXCLUDE_COMPONENT = "firmwareAExcludeComponent"
    EP_CLASS_ID_FIRMWARE_AINFRA_PACK = "firmwareAInfraPack"
    EP_CLASS_ID_FIRMWARE_ACK = "firmwareAck"
    EP_CLASS_ID_FIRMWARE_AUTO_SYNC_POLICY = "firmwareAutoSyncPolicy"
    EP_CLASS_ID_FIRMWARE_BOOT_DEFINITION = "firmwareBootDefinition"
    EP_CLASS_ID_FIRMWARE_BOOT_UNIT = "firmwareBootUnit"
    EP_CLASS_ID_FIRMWARE_BUNDLE_INFO = "firmwareBundleInfo"
    EP_CLASS_ID_FIRMWARE_BUNDLE_INFO_DIGEST = "firmwareBundleInfoDigest"
    EP_CLASS_ID_FIRMWARE_BUNDLE_TYPE = "firmwareBundleType"
    EP_CLASS_ID_FIRMWARE_BUNDLE_TYPE_CAP_PROVIDER = "firmwareBundleTypeCapProvider"
    EP_CLASS_ID_FIRMWARE_CAP_PROVIDER = "firmwareCapProvider"
    EP_CLASS_ID_FIRMWARE_CATALOG_PACK = "firmwareCatalogPack"
    EP_CLASS_ID_FIRMWARE_CATALOG_PACK_CONFIG = "firmwareCatalogPackConfig"
    EP_CLASS_ID_FIRMWARE_CATALOGUE = "firmwareCatalogue"
    EP_CLASS_ID_FIRMWARE_CHASSIS_COMPONENT_SPEC = "firmwareChassisComponentSpec"
    EP_CLASS_ID_FIRMWARE_CHASSIS_PACK = "firmwareChassisPack"
    EP_CLASS_ID_FIRMWARE_COMP_ITEM = "firmwareCompItem"
    EP_CLASS_ID_FIRMWARE_COMP_SOURCE = "firmwareCompSource"
    EP_CLASS_ID_FIRMWARE_COMP_TARGET = "firmwareCompTarget"
    EP_CLASS_ID_FIRMWARE_COMPONENT_SPEC = "firmwareComponentSpec"
    EP_CLASS_ID_FIRMWARE_COMPUTE_HOST_PACK = "firmwareComputeHostPack"
    EP_CLASS_ID_FIRMWARE_COMPUTE_MGMT_PACK = "firmwareComputeMgmtPack"
    EP_CLASS_ID_FIRMWARE_COMPUTE_PACK = "firmwareComputePack"
    EP_CLASS_ID_FIRMWARE_COMPUTE_STORAGE_PACK = "firmwareComputeStoragePack"
    EP_CLASS_ID_FIRMWARE_CONNECTION_POLICY = "firmwareConnectionPolicy"
    EP_CLASS_ID_FIRMWARE_DEPENDENCY = "firmwareDependency"
    EP_CLASS_ID_FIRMWARE_DIST_IMAGE = "firmwareDistImage"
    EP_CLASS_ID_FIRMWARE_DISTRIBUTABLE = "firmwareDistributable"
    EP_CLASS_ID_FIRMWARE_DISTRIBUTABLE_FSM = "firmwareDistributableFsm"
    EP_CLASS_ID_FIRMWARE_DISTRIBUTABLE_FSM_STAGE = "firmwareDistributableFsmStage"
    EP_CLASS_ID_FIRMWARE_DISTRIBUTABLE_FSM_TASK = "firmwareDistributableFsmTask"
    EP_CLASS_ID_FIRMWARE_DOMAIN_INFO = "firmwareDomainInfo"
    EP_CLASS_ID_FIRMWARE_DOMAIN_INFRA_PROFILE = "firmwareDomainInfraProfile"
    EP_CLASS_ID_FIRMWARE_DOWNLOAD_POLICY = "firmwareDownloadPolicy"
    EP_CLASS_ID_FIRMWARE_DOWNLOADER = "firmwareDownloader"
    EP_CLASS_ID_FIRMWARE_DOWNLOADER_FSM = "firmwareDownloaderFsm"
    EP_CLASS_ID_FIRMWARE_DOWNLOADER_FSM_STAGE = "firmwareDownloaderFsmStage"
    EP_CLASS_ID_FIRMWARE_DOWNLOADER_FSM_TASK = "firmwareDownloaderFsmTask"
    EP_CLASS_ID_FIRMWARE_EXCLUDE_CHASSIS_COMPONENT = "firmwareExcludeChassisComponent"
    EP_CLASS_ID_FIRMWARE_EXCLUDE_SERVER_COMPONENT = "firmwareExcludeServerComponent"
    EP_CLASS_ID_FIRMWARE_IMAGE = "firmwareImage"
    EP_CLASS_ID_FIRMWARE_INFRA = "firmwareInfra"
    EP_CLASS_ID_FIRMWARE_INFRA_PACK = "firmwareInfraPack"
    EP_CLASS_ID_FIRMWARE_INFRA_PACK_CONFIG = "firmwareInfraPackConfig"
    EP_CLASS_ID_FIRMWARE_INFRA_POLICY = "firmwareInfraPolicy"
    EP_CLASS_ID_FIRMWARE_INSTALL_IMPACT = "firmwareInstallImpact"
    EP_CLASS_ID_FIRMWARE_PACK = "firmwarePack"
    EP_CLASS_ID_FIRMWARE_POLICY = "firmwarePolicy"
    EP_CLASS_ID_FIRMWARE_PRODUCT_FAMILY = "firmwareProductFamily"
    EP_CLASS_ID_FIRMWARE_REMOTE_CATALOGUE = "firmwareRemoteCatalogue"
    EP_CLASS_ID_FIRMWARE_RUNNING = "firmwareRunning"
    EP_CLASS_ID_FIRMWARE_SOURCE = "firmwareSource"
    EP_CLASS_ID_FIRMWARE_STATUS = "firmwareStatus"
    EP_CLASS_ID_FIRMWARE_STORAGE_PACK = "firmwareStoragePack"
    EP_CLASS_ID_FIRMWARE_SYSTEM = "firmwareSystem"
    EP_CLASS_ID_FIRMWARE_TYPE = "firmwareType"
    EP_CLASS_ID_FIRMWARE_UNIT = "firmwareUnit"
    EP_CLASS_ID_FIRMWARE_UPDATABLE = "firmwareUpdatable"
    EP_CLASS_ID_FIRMWARE_UPGRADE_DETAIL = "firmwareUpgradeDetail"
    EP_CLASS_ID_FIRMWARE_UPGRADE_INFO = "firmwareUpgradeInfo"
    EP_CLASS_ID_FLOWCTRL_DEFINITION = "flowctrlDefinition"
    EP_CLASS_ID_FLOWCTRL_ITEM = "flowctrlItem"
    EP_CLASS_ID_FSM_FSM = "fsmFsm"
    EP_CLASS_ID_FSM_STAGE = "fsmStage"
    EP_CLASS_ID_FSM_STATUS = "fsmStatus"
    EP_CLASS_ID_FSM_TASK = "fsmTask"
    EP_CLASS_ID_GL_ABS_CONFLICT = "glAbsConflict"
    EP_CLASS_ID_GL_ABS_EP = "glAbsEp"
    EP_CLASS_ID_GL_ABS_IDENT_CTX_OP = "glAbsIdentCtxOp"
    EP_CLASS_ID_GL_ABS_INV = "glAbsInv"
    EP_CLASS_ID_GL_ABS_OPERATION = "glAbsOperation"
    EP_CLASS_ID_GL_ABS_POLICY_INV = "glAbsPolicyInv"
    EP_CLASS_ID_GL_ABS_POLICY_OP = "glAbsPolicyOp"
    EP_CLASS_ID_GL_ABS_POLICY_RULE = "glAbsPolicyRule"
    EP_CLASS_ID_GL_ABS_REQUEST = "glAbsRequest"
    EP_CLASS_ID_GL_ABS_RES_EP = "glAbsResEp"
    EP_CLASS_ID_GL_ABS_RULE = "glAbsRule"
    EP_CLASS_ID_GL_ABS_VNET_INV = "glAbsVnetInv"
    EP_CLASS_ID_GL_APPEND_RULE = "glAppendRule"
    EP_CLASS_ID_GL_BLOCK_EP = "glBlockEp"
    EP_CLASS_ID_GL_BLOCK_OP = "glBlockOp"
    EP_CLASS_ID_GL_BY_MO = "glByMo"
    EP_CLASS_ID_GL_COMPLEX_REF_EP = "glComplexRefEp"
    EP_CLASS_ID_GL_CONFLICT_EP = "glConflictEp"
    EP_CLASS_ID_GL_CONFLICT_RESOLUTION_RULE_EP = "glConflictResolutionRuleEp"
    EP_CLASS_ID_GL_DOMAIN_EP = "glDomainEp"
    EP_CLASS_ID_GL_EP = "glEp"
    EP_CLASS_ID_GL_GLOBAL_DEFAULT_POLICY_EP = "glGlobalDefaultPolicyEp"
    EP_CLASS_ID_GL_ID_REF = "glIdRef"
    EP_CLASS_ID_GL_ID_REF_EP = "glIdRefEp"
    EP_CLASS_ID_GL_IDABLE = "glIdable"
    EP_CLASS_ID_GL_IDENT_CTX_EP = "glIdentCtxEp"
    EP_CLASS_ID_GL_IDENT_CTX_OP = "glIdentCtxOp"
    EP_CLASS_ID_GL_IDENT_CTX_RES_OP = "glIdentCtxResOp"
    EP_CLASS_ID_GL_IDENT_CTX_RES_OP_FSM = "glIdentCtxResOpFsm"
    EP_CLASS_ID_GL_IDENT_CTX_RES_OP_FSM_STAGE = "glIdentCtxResOpFsmStage"
    EP_CLASS_ID_GL_IDENT_CTX_RES_OP_FSM_TASK = "glIdentCtxResOpFsmTask"
    EP_CLASS_ID_GL_INVENTORY_EP = "glInventoryEp"
    EP_CLASS_ID_GL_LSP = "glLsp"
    EP_CLASS_ID_GL_MCAST_POLICY = "glMcastPolicy"
    EP_CLASS_ID_GL_OPERATION_EP = "glOperationEp"
    EP_CLASS_ID_GL_PATH_EP = "glPathEp"
    EP_CLASS_ID_GL_POLICY = "glPolicy"
    EP_CLASS_ID_GL_POLICY_ALGORITHMED_OP = "glPolicyAlgorithmedOp"
    EP_CLASS_ID_GL_POLICY_EP = "glPolicyEp"
    EP_CLASS_ID_GL_POLICY_INV_EP = "glPolicyInvEp"
    EP_CLASS_ID_GL_POLICY_NAME_RULE_EP = "glPolicyNameRuleEp"
    EP_CLASS_ID_GL_POLICY_OP = "glPolicyOp"
    EP_CLASS_ID_GL_POLICY_REF = "glPolicyRef"
    EP_CLASS_ID_GL_POLICY_REF_EP = "glPolicyRefEp"
    EP_CLASS_ID_GL_POLICY_RES_OP = "glPolicyResOp"
    EP_CLASS_ID_GL_POLICY_RESOLUTION_EP = "glPolicyResolutionEp"
    EP_CLASS_ID_GL_POOL = "glPool"
    EP_CLASS_ID_GL_POOL_EP = "glPoolEp"
    EP_CLASS_ID_GL_POOL_INV_EP = "glPoolInvEp"
    EP_CLASS_ID_GL_POOL_OP = "glPoolOp"
    EP_CLASS_ID_GL_REFABLE = "glRefable"
    EP_CLASS_ID_GL_REFS_EP = "glRefsEp"
    EP_CLASS_ID_GL_REQUEST = "glRequest"
    EP_CLASS_ID_GL_REQUEST_FSM = "glRequestFsm"
    EP_CLASS_ID_GL_REQUEST_FSM_STAGE = "glRequestFsmStage"
    EP_CLASS_ID_GL_REQUEST_FSM_TASK = "glRequestFsmTask"
    EP_CLASS_ID_GL_REQUEST_VNET_EP = "glRequestVnetEp"
    EP_CLASS_ID_GL_REQUEST_VNET_EP_DOMAIN_EP = "glRequestVnetEpDomainEp"
    EP_CLASS_ID_GL_REQUEST_VNET_EP_DOMAIN_EP_FSM = "glRequestVnetEpDomainEpFsm"
    EP_CLASS_ID_GL_REQUEST_VNET_EP_DOMAIN_EP_FSM_STAGE = "glRequestVnetEpDomainEpFsmStage"
    EP_CLASS_ID_GL_REQUEST_VNET_EP_DOMAIN_EP_FSM_TASK = "glRequestVnetEpDomainEpFsmTask"
    EP_CLASS_ID_GL_REQUEST_VNET_EP_FSM = "glRequestVnetEpFsm"
    EP_CLASS_ID_GL_REQUEST_VNET_EP_FSM_STAGE = "glRequestVnetEpFsmStage"
    EP_CLASS_ID_GL_REQUEST_VNET_EP_FSM_TASK = "glRequestVnetEpFsmTask"
    EP_CLASS_ID_GL_REQUEST_VNET_EP_HOLDER = "glRequestVnetEpHolder"
    EP_CLASS_ID_GL_REQUESTOR = "glRequestor"
    EP_CLASS_ID_GL_REQUESTOR_EP = "glRequestorEp"
    EP_CLASS_ID_GL_SPINV_EP = "glSPInvEp"
    EP_CLASS_ID_GL_SERVER_POOL_RES_OP = "glServerPoolResOp"
    EP_CLASS_ID_GL_SERVICE_PROFILE = "glServiceProfile"
    EP_CLASS_ID_GL_SP_DEF_EP = "glSpDefEp"
    EP_CLASS_ID_GL_TEMPLATE_EP = "glTemplateEp"
    EP_CLASS_ID_GL_TEMPLATE_OP = "glTemplateOp"
    EP_CLASS_ID_GL_TEMPLATE_RES_OP = "glTemplateResOp"
    EP_CLASS_ID_GL_USAGE = "glUsage"
    EP_CLASS_ID_GL_USAGE_EP = "glUsageEp"
    EP_CLASS_ID_GL_VLAN = "glVlan"
    EP_CLASS_ID_GL_VNET_INV_HOLDER = "glVnetInvHolder"
    EP_CLASS_ID_GL_VNIC_TEMPLATE = "glVnicTemplate"
    EP_CLASS_ID_GL_VNIC_TEMPLATE_EP = "glVnicTemplateEp"
    EP_CLASS_ID_GL_VSAN = "glVsan"
    EP_CLASS_ID_GL_VXAN_EP = "glVxanEp"
    EP_CLASS_ID_GL_VXAN_OP = "glVxanOp"
    EP_CLASS_ID_GL_VXAN_RES_OP = "glVxanResOp"
    EP_CLASS_ID_GMETA_CLASS = "gmetaClass"
    EP_CLASS_ID_GMETA_POLICY_MAP_ELEMENT = "gmetaPolicyMapElement"
    EP_CLASS_ID_GMETA_PROP = "gmetaProp"
    EP_CLASS_ID_GRAPHICS_CARD = "graphicsCard"
    EP_CLASS_ID_GRAPHICS_CONTROLLER = "graphicsController"
    EP_CLASS_ID_GUI_GUI_COMPONENT = "guiGuiComponent"
    EP_CLASS_ID_GUI_GUI_CONT = "guiGuiCont"
    EP_CLASS_ID_HC_ACOMPONENT = "hcAComponent"
    EP_CLASS_ID_HC_AITEM = "hcAItem"
    EP_CLASS_ID_HC_ASTATUS_ITEM = "hcAStatusItem"
    EP_CLASS_ID_HC_ADAPTER_FIRMWARE_ITEM = "hcAdapterFirmwareItem"
    EP_CLASS_ID_HC_ADAPTER_ITEM = "hcAdapterItem"
    EP_CLASS_ID_HC_ADMIN = "hcAdmin"
    EP_CLASS_ID_HC_CATALOG = "hcCatalog"
    EP_CLASS_ID_HC_CATALOG_LIST = "hcCatalogList"
    EP_CLASS_ID_HC_CATALOG_SOURCE = "hcCatalogSource"
    EP_CLASS_ID_HC_CATALOG_VERSION = "hcCatalogVersion"
    EP_CLASS_ID_HC_CLEANUP = "hcCleanup"
    EP_CLASS_ID_HC_DOWNLOAD_POLICY = "hcDownloadPolicy"
    EP_CLASS_ID_HC_DOWNLOADER = "hcDownloader"
    EP_CLASS_ID_HC_DRIVER_INFO_ITEM = "hcDriverInfoItem"
    EP_CLASS_ID_HC_DRIVER_ITEM = "hcDriverItem"
    EP_CLASS_ID_HC_HOLDER = "hcHolder"
    EP_CLASS_ID_HC_ITEM_NOTE = "hcItemNote"
    EP_CLASS_ID_HC_OS_INFO_ITEM = "hcOsInfoItem"
    EP_CLASS_ID_HC_OS_ITEM = "hcOsItem"
    EP_CLASS_ID_HC_REPORT = "hcReport"
    EP_CLASS_ID_HC_SCOPE_DN = "hcScopeDn"
    EP_CLASS_ID_HC_SERVER_COMPONENT = "hcServerComponent"
    EP_CLASS_ID_HC_SUPPORTED_ADAPTER_FIRMWARE_ITEM = "hcSupportedAdapterFirmwareItem"
    EP_CLASS_ID_HC_SUPPORTED_ADAPTER_ITEM = "hcSupportedAdapterItem"
    EP_CLASS_ID_HC_SUPPORTED_DRIVER_ITEM = "hcSupportedDriverItem"
    EP_CLASS_ID_HC_SUPPORTED_OS_ITEM = "hcSupportedOsItem"
    EP_CLASS_ID_HC_UCS_VERSION_ITEM = "hcUcsVersionItem"
    EP_CLASS_ID_IDENT_DOMAIN_SYNC_EP = "identDomainSyncEp"
    EP_CLASS_ID_IDENT_EXECUTION_EP = "identExecutionEp"
    EP_CLASS_ID_IDENT_EXECUTION_REQUEST_EP = "identExecutionRequestEp"
    EP_CLASS_ID_IDENT_IDENT_CTX = "identIdentCtx"
    EP_CLASS_ID_IDENT_IDENT_REQUEST = "identIdentRequest"
    EP_CLASS_ID_IDENT_IDENT_REQUEST_FSM = "identIdentRequestFsm"
    EP_CLASS_ID_IDENT_IDENT_REQUEST_FSM_STAGE = "identIdentRequestFsmStage"
    EP_CLASS_ID_IDENT_IDENT_REQUEST_FSM_TASK = "identIdentRequestFsmTask"
    EP_CLASS_ID_IDENT_META_SYSTEM = "identMetaSystem"
    EP_CLASS_ID_IDENT_META_SYSTEM_FSM = "identMetaSystemFsm"
    EP_CLASS_ID_IDENT_META_SYSTEM_FSM_STAGE = "identMetaSystemFsmStage"
    EP_CLASS_ID_IDENT_META_SYSTEM_FSM_TASK = "identMetaSystemFsmTask"
    EP_CLASS_ID_IDENT_META_VERSE = "identMetaVerse"
    EP_CLASS_ID_IDENT_REQUEST_EP = "identRequestEp"
    EP_CLASS_ID_IDENT_SYS_INFO = "identSysInfo"
    EP_CLASS_ID_IDENTPOOL_BLOCK_QUAL = "identpoolBlockQual"
    EP_CLASS_ID_IDENTPOOL_CONSUMED = "identpoolConsumed"
    EP_CLASS_ID_IDENTPOOL_DOMAIN = "identpoolDomain"
    EP_CLASS_ID_IDENTPOOL_DOMAIN_GROUP_QUAL = "identpoolDomainGroupQual"
    EP_CLASS_ID_IDENTPOOL_ELEMENT = "identpoolElement"
    EP_CLASS_ID_IDENTPOOL_IPQUAL = "identpoolIPQual"
    EP_CLASS_ID_IDENTPOOL_IPV6_QUAL = "identpoolIPV6Qual"
    EP_CLASS_ID_IDENTPOOL_META_SYSTEM = "identpoolMetaSystem"
    EP_CLASS_ID_IDENTPOOL_META_VERSE = "identpoolMetaVerse"
    EP_CLASS_ID_IDENTPOOL_POOL = "identpoolPool"
    EP_CLASS_ID_IDENTPOOL_POOLABLE = "identpoolPoolable"
    EP_CLASS_ID_IDENTPOOL_QUAL_ITEM = "identpoolQualItem"
    EP_CLASS_ID_IDENTPOOL_UNIVERSE = "identpoolUniverse"
    EP_CLASS_ID_INBAND_POLICY = "inbandPolicy"
    EP_CLASS_ID_INITIATOR_EP = "initiatorEp"
    EP_CLASS_ID_INITIATOR_FC_INITIATOR_EP = "initiatorFcInitiatorEp"
    EP_CLASS_ID_INITIATOR_GROUP_EP = "initiatorGroupEp"
    EP_CLASS_ID_INITIATOR_ISCSI_INITIATOR_EP = "initiatorIScsiInitiatorEp"
    EP_CLASS_ID_INITIATOR_INITIATOR_EP = "initiatorInitiatorEp"
    EP_CLASS_ID_INITIATOR_LUN_EP = "initiatorLunEp"
    EP_CLASS_ID_INITIATOR_MEMBER_EP = "initiatorMemberEp"
    EP_CLASS_ID_INITIATOR_REQUESTOR_EP = "initiatorRequestorEp"
    EP_CLASS_ID_INITIATOR_REQUESTOR_GRP_EP = "initiatorRequestorGrpEp"
    EP_CLASS_ID_INITIATOR_STORE_EP = "initiatorStoreEp"
    EP_CLASS_ID_INITIATOR_UNIT_EP = "initiatorUnitEp"
    EP_CLASS_ID_INVENTORY_DOMAIN_EP = "inventoryDomainEp"
    EP_CLASS_ID_INVENTORY_EP = "inventoryEp"
    EP_CLASS_ID_INVENTORY_GLOBAL_EP = "inventoryGlobalEp"
    EP_CLASS_ID_INVENTORY_HOLDER = "inventoryHolder"
    EP_CLASS_ID_INVENTORY_INVENTORY_EP = "inventoryInventoryEp"
    EP_CLASS_ID_INVENTORY_INVENTORY_MO_META = "inventoryInventoryMoMeta"
    EP_CLASS_ID_IP_IPV4_DNS = "ipIPv4Dns"
    EP_CLASS_ID_IP_IP_V4_ADDR = "ipIpV4Addr"
    EP_CLASS_ID_IP_IP_V4_STATIC_ADDR = "ipIpV4StaticAddr"
    EP_CLASS_ID_IP_SERVICE_IF = "ipServiceIf"
    EP_CLASS_ID_IPPOOL_ADDR = "ippoolAddr"
    EP_CLASS_ID_IPPOOL_BLOCK = "ippoolBlock"
    EP_CLASS_ID_IPPOOL_IP_V6_ADDR = "ippoolIpV6Addr"
    EP_CLASS_ID_IPPOOL_IP_V6_BLOCK = "ippoolIpV6Block"
    EP_CLASS_ID_IPPOOL_IP_V6_POOLED = "ippoolIpV6Pooled"
    EP_CLASS_ID_IPPOOL_POOL = "ippoolPool"
    EP_CLASS_ID_IPPOOL_POOLED = "ippoolPooled"
    EP_CLASS_ID_IPPOOL_UNIVERSE = "ippoolUniverse"
    EP_CLASS_ID_IQNPOOL_ABS_BLOCK = "iqnpoolAbsBlock"
    EP_CLASS_ID_IQNPOOL_ADDR = "iqnpoolAddr"
    EP_CLASS_ID_IQNPOOL_BLOCK = "iqnpoolBlock"
    EP_CLASS_ID_IQNPOOL_FORMAT = "iqnpoolFormat"
    EP_CLASS_ID_IQNPOOL_POOL = "iqnpoolPool"
    EP_CLASS_ID_IQNPOOL_POOLED = "iqnpoolPooled"
    EP_CLASS_ID_IQNPOOL_TRANSPORT_BLOCK = "iqnpoolTransportBlock"
    EP_CLASS_ID_IQNPOOL_UNIVERSE = "iqnpoolUniverse"
    EP_CLASS_ID_ISCSI_AUTH_PROFILE = "iscsiAuthProfile"
    EP_CLASS_ID_LICENSE_CAP_PROVIDER = "licenseCapProvider"
    EP_CLASS_ID_LICENSE_CONTENTS = "licenseContents"
    EP_CLASS_ID_LICENSE_DOMAIN = "licenseDomain"
    EP_CLASS_ID_LICENSE_DOWNLOADER = "licenseDownloader"
    EP_CLASS_ID_LICENSE_DOWNLOADER_FSM = "licenseDownloaderFsm"
    EP_CLASS_ID_LICENSE_DOWNLOADER_FSM_STAGE = "licenseDownloaderFsmStage"
    EP_CLASS_ID_LICENSE_DOWNLOADER_FSM_TASK = "licenseDownloaderFsmTask"
    EP_CLASS_ID_LICENSE_EP = "licenseEp"
    EP_CLASS_ID_LICENSE_FEATURE = "licenseFeature"
    EP_CLASS_ID_LICENSE_FEATURE_CAP_PROVIDER = "licenseFeatureCapProvider"
    EP_CLASS_ID_LICENSE_FEATURE_LINE = "licenseFeatureLine"
    EP_CLASS_ID_LICENSE_FILE = "licenseFile"
    EP_CLASS_ID_LICENSE_FILE_FSM = "licenseFileFsm"
    EP_CLASS_ID_LICENSE_FILE_FSM_STAGE = "licenseFileFsmStage"
    EP_CLASS_ID_LICENSE_FILE_FSM_TASK = "licenseFileFsmTask"
    EP_CLASS_ID_LICENSE_INSTANCE = "licenseInstance"
    EP_CLASS_ID_LICENSE_INSTANCE_FSM = "licenseInstanceFsm"
    EP_CLASS_ID_LICENSE_INSTANCE_FSM_STAGE = "licenseInstanceFsmStage"
    EP_CLASS_ID_LICENSE_INSTANCE_FSM_TASK = "licenseInstanceFsmTask"
    EP_CLASS_ID_LICENSE_LICENSE = "licenseLicense"
    EP_CLASS_ID_LICENSE_PROP = "licenseProp"
    EP_CLASS_ID_LICENSE_SERVER_HOST_ID = "licenseServerHostId"
    EP_CLASS_ID_LICENSE_SOURCE = "licenseSource"
    EP_CLASS_ID_LICENSE_SOURCE_FILE = "licenseSourceFile"
    EP_CLASS_ID_LS_BINDING = "lsBinding"
    EP_CLASS_ID_LS_COMPUTE_BINDING = "lsComputeBinding"
    EP_CLASS_ID_LS_FC_LOCALE = "lsFcLocale"
    EP_CLASS_ID_LS_FC_ZONE = "lsFcZone"
    EP_CLASS_ID_LS_FC_ZONE_GROUP = "lsFcZoneGroup"
    EP_CLASS_ID_LS_FC_ZONE_MEMBER = "lsFcZoneMember"
    EP_CLASS_ID_LS_IDENTITY_INFO = "lsIdentityInfo"
    EP_CLASS_ID_LS_ISSUES = "lsIssues"
    EP_CLASS_ID_LS_POWER = "lsPower"
    EP_CLASS_ID_LS_REQUIREMENT = "lsRequirement"
    EP_CLASS_ID_LS_SPMETA = "lsSPMeta"
    EP_CLASS_ID_LS_SERVER = "lsServer"
    EP_CLASS_ID_LS_SERVER_ASSOC_CTX = "lsServerAssocCtx"
    EP_CLASS_ID_LS_SERVER_EXTENSION = "lsServerExtension"
    EP_CLASS_ID_LS_SERVER_FSM = "lsServerFsm"
    EP_CLASS_ID_LS_SERVER_FSM_STAGE = "lsServerFsmStage"
    EP_CLASS_ID_LS_SERVER_FSM_TASK = "lsServerFsmTask"
    EP_CLASS_ID_LS_SERVER_OPERATION = "lsServerOperation"
    EP_CLASS_ID_LS_TIER = "lsTier"
    EP_CLASS_ID_LS_VCON_ASSIGN = "lsVConAssign"
    EP_CLASS_ID_LS_WAITING_USER_ACK = "lsWaitingUserAck"
    EP_CLASS_ID_LS_ZONE_INITIATOR_MEMBER = "lsZoneInitiatorMember"
    EP_CLASS_ID_LS_ZONE_TARGET_MEMBER = "lsZoneTargetMember"
    EP_CLASS_ID_LSBOOT_ADEF = "lsbootADef"
    EP_CLASS_ID_LSBOOT_BOOT_SECURITY = "lsbootBootSecurity"
    EP_CLASS_ID_LSBOOT_CATEGORY = "lsbootCategory"
    EP_CLASS_ID_LSBOOT_DEF = "lsbootDef"
    EP_CLASS_ID_LSBOOT_DEFAULT_LOCAL_IMAGE = "lsbootDefaultLocalImage"
    EP_CLASS_ID_LSBOOT_EFISHELL = "lsbootEFIShell"
    EP_CLASS_ID_LSBOOT_EMBEDDED_LOCAL_DISK_IMAGE = "lsbootEmbeddedLocalDiskImage"
    EP_CLASS_ID_LSBOOT_EMBEDDED_LOCAL_DISK_IMAGE_PATH = "lsbootEmbeddedLocalDiskImagePath"
    EP_CLASS_ID_LSBOOT_EMBEDDED_LOCAL_LUN_IMAGE = "lsbootEmbeddedLocalLunImage"
    EP_CLASS_ID_LSBOOT_ISCSI = "lsbootIScsi"
    EP_CLASS_ID_LSBOOT_ISCSI_IMAGE_PATH = "lsbootIScsiImagePath"
    EP_CLASS_ID_LSBOOT_IMAGE = "lsbootImage"
    EP_CLASS_ID_LSBOOT_IMAGE_PATH = "lsbootImagePath"
    EP_CLASS_ID_LSBOOT_ITEM = "lsbootItem"
    EP_CLASS_ID_LSBOOT_LAN = "lsbootLan"
    EP_CLASS_ID_LSBOOT_LAN_IMAGE_PATH = "lsbootLanImagePath"
    EP_CLASS_ID_LSBOOT_LOCAL_DISK_IMAGE = "lsbootLocalDiskImage"
    EP_CLASS_ID_LSBOOT_LOCAL_DISK_IMAGE_PATH = "lsbootLocalDiskImagePath"
    EP_CLASS_ID_LSBOOT_LOCAL_HDD_IMAGE = "lsbootLocalHddImage"
    EP_CLASS_ID_LSBOOT_LOCAL_IMAGE = "lsbootLocalImage"
    EP_CLASS_ID_LSBOOT_LOCAL_LUN_IMAGE_PATH = "lsbootLocalLunImagePath"
    EP_CLASS_ID_LSBOOT_LOCAL_MEDIA_ITEM = "lsbootLocalMediaItem"
    EP_CLASS_ID_LSBOOT_LOCAL_STORAGE = "lsbootLocalStorage"
    EP_CLASS_ID_LSBOOT_NVME = "lsbootNvme"
    EP_CLASS_ID_LSBOOT_NVME_DEVICE = "lsbootNvmeDevice"
    EP_CLASS_ID_LSBOOT_NVME_DISK_SSD = "lsbootNvmeDiskSsd"
    EP_CLASS_ID_LSBOOT_NVME_PCI_SSD = "lsbootNvmePciSsd"
    EP_CLASS_ID_LSBOOT_POLICY = "lsbootPolicy"
    EP_CLASS_ID_LSBOOT_REMOTE_IMAGE = "lsbootRemoteImage"
    EP_CLASS_ID_LSBOOT_SAN = "lsbootSan"
    EP_CLASS_ID_LSBOOT_SAN_CAT_SAN_IMAGE = "lsbootSanCatSanImage"
    EP_CLASS_ID_LSBOOT_SAN_CAT_SAN_IMAGE_PATH = "lsbootSanCatSanImagePath"
    EP_CLASS_ID_LSBOOT_SAN_IMAGE = "lsbootSanImage"
    EP_CLASS_ID_LSBOOT_SAN_IMAGE_PATH = "lsbootSanImagePath"
    EP_CLASS_ID_LSBOOT_STORAGE = "lsbootStorage"
    EP_CLASS_ID_LSBOOT_UEFIBOOT_PARAM = "lsbootUEFIBootParam"
    EP_CLASS_ID_LSBOOT_UPGRADE_STATUS = "lsbootUpgradeStatus"
    EP_CLASS_ID_LSBOOT_USB_EXTERNAL_IMAGE = "lsbootUsbExternalImage"
    EP_CLASS_ID_LSBOOT_USB_FLASH_STORAGE_IMAGE = "lsbootUsbFlashStorageImage"
    EP_CLASS_ID_LSBOOT_USB_INTERNAL_IMAGE = "lsbootUsbInternalImage"
    EP_CLASS_ID_LSBOOT_VIRTUAL_MEDIA = "lsbootVirtualMedia"
    EP_CLASS_ID_LSMAINT_ACK = "lsmaintAck"
    EP_CLASS_ID_LSMAINT_MAINT_POLICY = "lsmaintMaintPolicy"
    EP_CLASS_ID_LSTORAGE_ASLOT = "lstorageASlot"
    EP_CLASS_ID_LSTORAGE_ACK = "lstorageAck"
    EP_CLASS_ID_LSTORAGE_ARRAY_REQUIREMENT = "lstorageArrayRequirement"
    EP_CLASS_ID_LSTORAGE_BLADE = "lstorageBlade"
    EP_CLASS_ID_LSTORAGE_CONTROLLER_DEF = "lstorageControllerDef"
    EP_CLASS_ID_LSTORAGE_CONTROLLER_MODE_CONFIG = "lstorageControllerModeConfig"
    EP_CLASS_ID_LSTORAGE_CONTROLLER_QUALIFIER = "lstorageControllerQualifier"
    EP_CLASS_ID_LSTORAGE_CONTROLLER_REF = "lstorageControllerRef"
    EP_CLASS_ID_LSTORAGE_CTRL_SERVICE_OPERATION = "lstorageCtrlServiceOperation"
    EP_CLASS_ID_LSTORAGE_DAS_SCSI_LUN = "lstorageDasScsiLun"
    EP_CLASS_ID_LSTORAGE_DISK_GROUP_CONFIG = "lstorageDiskGroupConfig"
    EP_CLASS_ID_LSTORAGE_DISK_GROUP_CONFIG_DEF = "lstorageDiskGroupConfigDef"
    EP_CLASS_ID_LSTORAGE_DISK_GROUP_CONFIG_POLICY = "lstorageDiskGroupConfigPolicy"
    EP_CLASS_ID_LSTORAGE_DISK_GROUP_QUALIFIER = "lstorageDiskGroupQualifier"
    EP_CLASS_ID_LSTORAGE_DISK_SLOT = "lstorageDiskSlot"
    EP_CLASS_ID_LSTORAGE_DISK_ZONING_CONFIG = "lstorageDiskZoningConfig"
    EP_CLASS_ID_LSTORAGE_DISK_ZONING_CONFIG_DEF = "lstorageDiskZoningConfigDef"
    EP_CLASS_ID_LSTORAGE_DISK_ZONING_POLICY = "lstorageDiskZoningPolicy"
    EP_CLASS_ID_LSTORAGE_DRIVE_SECURITY = "lstorageDriveSecurity"
    EP_CLASS_ID_LSTORAGE_EXTENSION = "lstorageExtension"
    EP_CLASS_ID_LSTORAGE_ITEM = "lstorageItem"
    EP_CLASS_ID_LSTORAGE_LOCAL = "lstorageLocal"
    EP_CLASS_ID_LSTORAGE_LOCAL_CONFIG = "lstorageLocalConfig"
    EP_CLASS_ID_LSTORAGE_LOCAL_DEF = "lstorageLocalDef"
    EP_CLASS_ID_LSTORAGE_LOCAL_DISK_CONFIG_REF = "lstorageLocalDiskConfigRef"
    EP_CLASS_ID_LSTORAGE_LOCAL_DISK_REF = "lstorageLocalDiskRef"
    EP_CLASS_ID_LSTORAGE_LOGIN = "lstorageLogin"
    EP_CLASS_ID_LSTORAGE_META = "lstorageMeta"
    EP_CLASS_ID_LSTORAGE_PROCESSOR_BASE = "lstorageProcessorBase"
    EP_CLASS_ID_LSTORAGE_PROFILE = "lstorageProfile"
    EP_CLASS_ID_LSTORAGE_PROFILE_BASE = "lstorageProfileBase"
    EP_CLASS_ID_LSTORAGE_PROFILE_BINDING = "lstorageProfileBinding"
    EP_CLASS_ID_LSTORAGE_PROFILE_BINDING_BASE = "lstorageProfileBindingBase"
    EP_CLASS_ID_LSTORAGE_PROFILE_DEF = "lstorageProfileDef"
    EP_CLASS_ID_LSTORAGE_QUAL_ITEM = "lstorageQualItem"
    EP_CLASS_ID_LSTORAGE_RECURR_WINDOW = "lstorageRecurrWindow"
    EP_CLASS_ID_LSTORAGE_REMOTE = "lstorageRemote"
    EP_CLASS_ID_LSTORAGE_REMOTE_CONFIG = "lstorageRemoteConfig"
    EP_CLASS_ID_LSTORAGE_REMOTE_DEF = "lstorageRemoteDef"
    EP_CLASS_ID_LSTORAGE_REQUEST_CTX = "lstorageRequestCtx"
    EP_CLASS_ID_LSTORAGE_SCSI_LUN = "lstorageScsiLun"
    EP_CLASS_ID_LSTORAGE_SECURITY = "lstorageSecurity"
    EP_CLASS_ID_LSTORAGE_VIRTUAL_DRIVE_DEF = "lstorageVirtualDriveDef"
    EP_CLASS_ID_MACPOOL_ADDR = "macpoolAddr"
    EP_CLASS_ID_MACPOOL_BLOCK = "macpoolBlock"
    EP_CLASS_ID_MACPOOL_FORMAT = "macpoolFormat"
    EP_CLASS_ID_MACPOOL_POOL = "macpoolPool"
    EP_CLASS_ID_MACPOOL_POOLED = "macpoolPooled"
    EP_CLASS_ID_MACPOOL_UNIVERSE = "macpoolUniverse"
    EP_CLASS_ID_MEMORY_ARRAY = "memoryArray"
    EP_CLASS_ID_MEMORY_ARRAY_ENV_STATS = "memoryArrayEnvStats"
    EP_CLASS_ID_MEMORY_ARRAY_ENV_STATS_HIST = "memoryArrayEnvStatsHist"
    EP_CLASS_ID_MEMORY_BUFFER_UNIT = "memoryBufferUnit"
    EP_CLASS_ID_MEMORY_BUFFER_UNIT_ENV_STATS = "memoryBufferUnitEnvStats"
    EP_CLASS_ID_MEMORY_BUFFER_UNIT_ENV_STATS_HIST = "memoryBufferUnitEnvStatsHist"
    EP_CLASS_ID_MEMORY_CONTROLLER = "memoryController"
    EP_CLASS_ID_MEMORY_ERROR_STATS = "memoryErrorStats"
    EP_CLASS_ID_MEMORY_ERROR_STATS_HIST = "memoryErrorStatsHist"
    EP_CLASS_ID_MEMORY_NV_DIMM = "memoryNvDimm"
    EP_CLASS_ID_MEMORY_NV_DIMM_BATTERY = "memoryNvDimmBattery"
    EP_CLASS_ID_MEMORY_NV_DIMM_CONTROLLER = "memoryNvDimmController"
    EP_CLASS_ID_MEMORY_QUAL = "memoryQual"
    EP_CLASS_ID_MEMORY_RUNTIME = "memoryRuntime"
    EP_CLASS_ID_MEMORY_RUNTIME_HIST = "memoryRuntimeHist"
    EP_CLASS_ID_MEMORY_UNIT = "memoryUnit"
    EP_CLASS_ID_MEMORY_UNIT_ENV_STATS = "memoryUnitEnvStats"
    EP_CLASS_ID_MEMORY_UNIT_ENV_STATS_HIST = "memoryUnitEnvStatsHist"
    EP_CLASS_ID_MESSAGE_ENTRY = "messageEntry"
    EP_CLASS_ID_MESSAGE_EP = "messageEp"
    EP_CLASS_ID_MGMT_AKMIP_CERT_POLICY = "mgmtAKmipCertPolicy"
    EP_CLASS_ID_MGMT_ASECURE_BOOT = "mgmtASecureBoot"
    EP_CLASS_ID_MGMT_ABS_BACKUP = "mgmtAbsBackup"
    EP_CLASS_ID_MGMT_ABS_DATA_ITEM = "mgmtAbsDataItem"
    EP_CLASS_ID_MGMT_ABS_IMPORTER = "mgmtAbsImporter"
    EP_CLASS_ID_MGMT_BACKUP = "mgmtBackup"
    EP_CLASS_ID_MGMT_BACKUP_FSM = "mgmtBackupFsm"
    EP_CLASS_ID_MGMT_BACKUP_FSM_STAGE = "mgmtBackupFsmStage"
    EP_CLASS_ID_MGMT_BACKUP_FSM_TASK = "mgmtBackupFsmTask"
    EP_CLASS_ID_MGMT_BACKUP_OPERATION = "mgmtBackupOperation"
    EP_CLASS_ID_MGMT_BACKUP_POLICY = "mgmtBackupPolicy"
    EP_CLASS_ID_MGMT_BACKUP_TRIGGER = "mgmtBackupTrigger"
    EP_CLASS_ID_MGMT_BACKUP_TRIGGER_FSM = "mgmtBackupTriggerFsm"
    EP_CLASS_ID_MGMT_BACKUP_TRIGGER_FSM_STAGE = "mgmtBackupTriggerFsmStage"
    EP_CLASS_ID_MGMT_BACKUP_TRIGGER_FSM_TASK = "mgmtBackupTriggerFsmTask"
    EP_CLASS_ID_MGMT_CFG_EXPORT_POLICY = "mgmtCfgExportPolicy"
    EP_CLASS_ID_MGMT_CIMC_INTERFACE = "mgmtCimcInterface"
    EP_CLASS_ID_MGMT_CMC_SECURE_BOOT = "mgmtCmcSecureBoot"
    EP_CLASS_ID_MGMT_CMC_SECURE_BOOT_OPERATION = "mgmtCmcSecureBootOperation"
    EP_CLASS_ID_MGMT_CONNECTION = "mgmtConnection"
    EP_CLASS_ID_MGMT_CONTROLLER = "mgmtController"
    EP_CLASS_ID_MGMT_DATA_EXPORTER = "mgmtDataExporter"
    EP_CLASS_ID_MGMT_DATA_EXPORTER_FSM = "mgmtDataExporterFsm"
    EP_CLASS_ID_MGMT_DATA_EXPORTER_FSM_STAGE = "mgmtDataExporterFsmStage"
    EP_CLASS_ID_MGMT_DATA_EXPORTER_FSM_TASK = "mgmtDataExporterFsmTask"
    EP_CLASS_ID_MGMT_DATA_IMPORTER = "mgmtDataImporter"
    EP_CLASS_ID_MGMT_DATA_IMPORTER_FSM = "mgmtDataImporterFsm"
    EP_CLASS_ID_MGMT_DATA_IMPORTER_FSM_STAGE = "mgmtDataImporterFsmStage"
    EP_CLASS_ID_MGMT_DATA_IMPORTER_FSM_TASK = "mgmtDataImporterFsmTask"
    EP_CLASS_ID_MGMT_DATA_ITEM = "mgmtDataItem"
    EP_CLASS_ID_MGMT_ENTITY = "mgmtEntity"
    EP_CLASS_ID_MGMT_EP = "mgmtEp"
    EP_CLASS_ID_MGMT_EXPORT_POLICY = "mgmtExportPolicy"
    EP_CLASS_ID_MGMT_IPV6_ADDR = "mgmtIPv6Addr"
    EP_CLASS_ID_MGMT_IPV6_IF_ADDR = "mgmtIPv6IfAddr"
    EP_CLASS_ID_MGMT_IPV6_IF_CONFIG = "mgmtIPv6IfConfig"
    EP_CLASS_ID_MGMT_IF = "mgmtIf"
    EP_CLASS_ID_MGMT_IF_FSM = "mgmtIfFsm"
    EP_CLASS_ID_MGMT_IF_FSM_STAGE = "mgmtIfFsmStage"
    EP_CLASS_ID_MGMT_IF_FSM_TASK = "mgmtIfFsmTask"
    EP_CLASS_ID_MGMT_IMPORT_ITEM = "mgmtImportItem"
    EP_CLASS_ID_MGMT_IMPORTER = "mgmtImporter"
    EP_CLASS_ID_MGMT_IMPORTER_FSM = "mgmtImporterFsm"
    EP_CLASS_ID_MGMT_IMPORTER_FSM_STAGE = "mgmtImporterFsmStage"
    EP_CLASS_ID_MGMT_IMPORTER_FSM_TASK = "mgmtImporterFsmTask"
    EP_CLASS_ID_MGMT_INBAND_PROFILE = "mgmtInbandProfile"
    EP_CLASS_ID_MGMT_INTERFACE = "mgmtInterface"
    EP_CLASS_ID_MGMT_KMIP = "mgmtKmip"
    EP_CLASS_ID_MGMT_KMIP_CERT_POLICY = "mgmtKmipCertPolicy"
    EP_CLASS_ID_MGMT_KMIP_OPERATION = "mgmtKmipOperation"
    EP_CLASS_ID_MGMT_NAMED_KMIP_CERT_POLICY = "mgmtNamedKmipCertPolicy"
    EP_CLASS_ID_MGMT_REGISTRY_INFO = "mgmtRegistryInfo"
    EP_CLASS_ID_MGMT_REGISTRY_INFO_FSM = "mgmtRegistryInfoFsm"
    EP_CLASS_ID_MGMT_REGISTRY_INFO_FSM_STAGE = "mgmtRegistryInfoFsmStage"
    EP_CLASS_ID_MGMT_REGISTRY_INFO_FSM_TASK = "mgmtRegistryInfoFsmTask"
    EP_CLASS_ID_MGMT_SECURITY = "mgmtSecurity"
    EP_CLASS_ID_MGMT_SVC = "mgmtSvc"
    EP_CLASS_ID_MGMT_VNET = "mgmtVnet"
    EP_CLASS_ID_MO_TOP_PROPS = "moTopProps"
    EP_CLASS_ID_NAMING_BINDING = "namingBinding"
    EP_CLASS_ID_NAMING_DEFINITION = "namingDefinition"
    EP_CLASS_ID_NAMING_HOLDER = "namingHolder"
    EP_CLASS_ID_NAMING_NAMED_IDENTIFIED_OBJECT = "namingNamedIdentifiedObject"
    EP_CLASS_ID_NAMING_NAMED_OBJECT = "namingNamedObject"
    EP_CLASS_ID_NAMING_OBJECT = "namingObject"
    EP_CLASS_ID_NET_NET_GROUP_PERMIT = "netNetGroupPermit"
    EP_CLASS_ID_NETWORK_CACERT = "networkCACert"
    EP_CLASS_ID_NETWORK_CIO_EP = "networkCIoEp"
    EP_CLASS_ID_NETWORK_CONN = "networkConn"
    EP_CLASS_ID_NETWORK_ELEMENT = "networkElement"
    EP_CLASS_ID_NETWORK_ELEMENT_FSM = "networkElementFsm"
    EP_CLASS_ID_NETWORK_ELEMENT_FSM_STAGE = "networkElementFsmStage"
    EP_CLASS_ID_NETWORK_ELEMENT_FSM_TASK = "networkElementFsmTask"
    EP_CLASS_ID_NETWORK_ELEMENT_OPERATION = "networkElementOperation"
    EP_CLASS_ID_NETWORK_EP = "networkEp"
    EP_CLASS_ID_NETWORK_IF_EP = "networkIfEp"
    EP_CLASS_ID_NETWORK_PIO_EP = "networkPIoEp"
    EP_CLASS_ID_NETWORK_PHYS_EP = "networkPhysEp"
    EP_CLASS_ID_NETWORK_SYSTEM_CACERT = "networkSystemCACert"
    EP_CLASS_ID_NETWORK_VNET_EP = "networkVnetEp"
    EP_CLASS_ID_NFS_CLIENT_DEF = "nfsClientDef"
    EP_CLASS_ID_NFS_CLIENT_DEF_FSM = "nfsClientDefFsm"
    EP_CLASS_ID_NFS_CLIENT_DEF_FSM_STAGE = "nfsClientDefFsmStage"
    EP_CLASS_ID_NFS_CLIENT_DEF_FSM_TASK = "nfsClientDefFsmTask"
    EP_CLASS_ID_NFS_EP = "nfsEp"
    EP_CLASS_ID_NFS_EXPORT_DEF = "nfsExportDef"
    EP_CLASS_ID_NFS_EXPORT_DEF_FSM = "nfsExportDefFsm"
    EP_CLASS_ID_NFS_EXPORT_DEF_FSM_STAGE = "nfsExportDefFsmStage"
    EP_CLASS_ID_NFS_EXPORT_DEF_FSM_TASK = "nfsExportDefFsmTask"
    EP_CLASS_ID_NFS_MOUNT_DEF = "nfsMountDef"
    EP_CLASS_ID_NFS_REPOSITORY_SPEC_POLICY = "nfsRepositorySpecPolicy"
    EP_CLASS_ID_NWCTRL_DEFINITION = "nwctrlDefinition"
    EP_CLASS_ID_OBSERVE_FILTER = "observeFilter"
    EP_CLASS_ID_OBSERVE_OBSERVED = "observeObserved"
    EP_CLASS_ID_OBSERVE_OBSERVED_CONT = "observeObservedCont"
    EP_CLASS_ID_OBSERVE_OBSERVED_FSM = "observeObservedFsm"
    EP_CLASS_ID_OBSERVE_OBSERVED_FSM_STAGE = "observeObservedFsmStage"
    EP_CLASS_ID_OBSERVE_OBSERVED_FSM_TASK = "observeObservedFsmTask"
    EP_CLASS_ID_ORG_AORG = "orgAOrg"
    EP_CLASS_ID_ORG_DOMAIN_FIRMWARE_INFO = "orgDomainFirmwareInfo"
    EP_CLASS_ID_ORG_DOMAIN_GROUP = "orgDomainGroup"
    EP_CLASS_ID_ORG_DOMAIN_GROUP_FIRMWARE_REPORT = "orgDomainGroupFirmwareReport"
    EP_CLASS_ID_ORG_DOMAIN_GROUP_POLICY = "orgDomainGroupPolicy"
    EP_CLASS_ID_ORG_DOMAIN_GROUP_POLICY_REPORT = "orgDomainGroupPolicyReport"
    EP_CLASS_ID_ORG_DOMAIN_GROUP_REPORT = "orgDomainGroupReport"
    EP_CLASS_ID_ORG_EXTENSION = "orgExtension"
    EP_CLASS_ID_ORG_FIRMWARE_VERSION_COUNT = "orgFirmwareVersionCount"
    EP_CLASS_ID_ORG_MAINT_TAG_FIRMWARE_REPORT = "orgMaintTagFirmwareReport"
    EP_CLASS_ID_ORG_ORG = "orgOrg"
    EP_CLASS_ID_ORG_ORG_FSM = "orgOrgFsm"
    EP_CLASS_ID_ORG_ORG_FSM_STAGE = "orgOrgFsmStage"
    EP_CLASS_ID_ORG_ORG_FSM_TASK = "orgOrgFsmTask"
    EP_CLASS_ID_ORG_ORG_SOURCE = "orgOrgSource"
    EP_CLASS_ID_ORG_SOURCE_MASK = "orgSourceMask"
    EP_CLASS_ID_OS_CONTROLLER = "osController"
    EP_CLASS_ID_OS_ETH_BOND_INTF = "osEthBondIntf"
    EP_CLASS_ID_OS_ETH_BOND_MODE = "osEthBondMode"
    EP_CLASS_ID_OS_ETH_INTF = "osEthIntf"
    EP_CLASS_ID_OS_INSTANCE = "osInstance"
    EP_CLASS_ID_OS_INTF = "osIntf"
    EP_CLASS_ID_OS_LINK_MONITORING_POLICY = "osLinkMonitoringPolicy"
    EP_CLASS_ID_OS_PRIMARY_SLAVE = "osPrimarySlave"
    EP_CLASS_ID_PCI_CARD = "pciCard"
    EP_CLASS_ID_PKI_CERT_REQ = "pkiCertReq"
    EP_CLASS_ID_PKI_DEFINITION = "pkiDefinition"
    EP_CLASS_ID_PKI_EP = "pkiEp"
    EP_CLASS_ID_PKI_EP_FSM = "pkiEpFsm"
    EP_CLASS_ID_PKI_EP_FSM_STAGE = "pkiEpFsmStage"
    EP_CLASS_ID_PKI_EP_FSM_TASK = "pkiEpFsmTask"
    EP_CLASS_ID_PKI_ITEM = "pkiItem"
    EP_CLASS_ID_PKI_KEY_RING = "pkiKeyRing"
    EP_CLASS_ID_PKI_TP = "pkiTP"
    EP_CLASS_ID_POLICY_ADEST_EP = "policyADestEp"
    EP_CLASS_ID_POLICY_ACK_SUSPEND_OPERATION = "policyAckSuspendOperation"
    EP_CLASS_ID_POLICY_BINDING = "policyBinding"
    EP_CLASS_ID_POLICY_CHILD_CLASS = "policyChildClass"
    EP_CLASS_ID_POLICY_CLUSTER = "policyCluster"
    EP_CLASS_ID_POLICY_COMMUNICATION = "policyCommunication"
    EP_CLASS_ID_POLICY_COMMUNICATION_OP = "policyCommunicationOp"
    EP_CLASS_ID_POLICY_CONFIG_BACKUP = "policyConfigBackup"
    EP_CLASS_ID_POLICY_CONFIG_BACKUP_OP = "policyConfigBackupOp"
    EP_CLASS_ID_POLICY_CONFIG_ERROR = "policyConfigError"
    EP_CLASS_ID_POLICY_CONTEXT = "policyContext"
    EP_CLASS_ID_POLICY_CONTROL = "policyControl"
    EP_CLASS_ID_POLICY_CONTROL_EP = "policyControlEp"
    EP_CLASS_ID_POLICY_CONTROL_EP_OP = "policyControlEpOp"
    EP_CLASS_ID_POLICY_CONTROL_EP_OP_FSM = "policyControlEpOpFsm"
    EP_CLASS_ID_POLICY_CONTROL_EP_OP_FSM_STAGE = "policyControlEpOpFsmStage"
    EP_CLASS_ID_POLICY_CONTROL_EP_OP_FSM_TASK = "policyControlEpOpFsmTask"
    EP_CLASS_ID_POLICY_CONTROL_EP_OPERATION = "policyControlEpOperation"
    EP_CLASS_ID_POLICY_CONTROL_OP = "policyControlOp"
    EP_CLASS_ID_POLICY_CONTROLLED = "policyControlled"
    EP_CLASS_ID_POLICY_CONTROLLED_INSTANCE = "policyControlledInstance"
    EP_CLASS_ID_POLICY_CONTROLLED_TYPE = "policyControlledType"
    EP_CLASS_ID_POLICY_DATE_TIME = "policyDateTime"
    EP_CLASS_ID_POLICY_DATE_TIME_OP = "policyDateTimeOp"
    EP_CLASS_ID_POLICY_DEFINITION = "policyDefinition"
    EP_CLASS_ID_POLICY_DEST_CLASS = "policyDestClass"
    EP_CLASS_ID_POLICY_DEST_EP = "policyDestEp"
    EP_CLASS_ID_POLICY_DEVICE_PROFILE = "policyDeviceProfile"
    EP_CLASS_ID_POLICY_DIGEST = "policyDigest"
    EP_CLASS_ID_POLICY_DISCOVERY = "policyDiscovery"
    EP_CLASS_ID_POLICY_DISCOVERY_OP = "policyDiscoveryOp"
    EP_CLASS_ID_POLICY_DNS = "policyDns"
    EP_CLASS_ID_POLICY_DNS_OP = "policyDnsOp"
    EP_CLASS_ID_POLICY_ELEMENT = "policyElement"
    EP_CLASS_ID_POLICY_EQUIPMENT = "policyEquipment"
    EP_CLASS_ID_POLICY_EQUIPMENT_OP = "policyEquipmentOp"
    EP_CLASS_ID_POLICY_FAULT = "policyFault"
    EP_CLASS_ID_POLICY_FAULT_OP = "policyFaultOp"
    EP_CLASS_ID_POLICY_IDENTIFIER_POLICY = "policyIdentifierPolicy"
    EP_CLASS_ID_POLICY_INFRA_FIRMWARE = "policyInfraFirmware"
    EP_CLASS_ID_POLICY_INFRA_FIRMWARE_OP = "policyInfraFirmwareOp"
    EP_CLASS_ID_POLICY_ITEM = "policyItem"
    EP_CLASS_ID_POLICY_LOCAL_MAP = "policyLocalMap"
    EP_CLASS_ID_POLICY_LOG_PROFILE = "policyLogProfile"
    EP_CLASS_ID_POLICY_MEP = "policyMEp"
    EP_CLASS_ID_POLICY_MEP_OP = "policyMEpOp"
    EP_CLASS_ID_POLICY_MONITORING = "policyMonitoring"
    EP_CLASS_ID_POLICY_MONITORING_OP = "policyMonitoringOp"
    EP_CLASS_ID_POLICY_OBJECT = "policyObject"
    EP_CLASS_ID_POLICY_POLICY_DEST_CLASS = "policyPolicyDestClass"
    EP_CLASS_ID_POLICY_POLICY_EP = "policyPolicyEp"
    EP_CLASS_ID_POLICY_POLICY_REQUESTOR = "policyPolicyRequestor"
    EP_CLASS_ID_POLICY_POLICY_SCOPE = "policyPolicyScope"
    EP_CLASS_ID_POLICY_POLICY_SCOPE_CONT = "policyPolicyScopeCont"
    EP_CLASS_ID_POLICY_POLICY_SCOPE_CONTEXT = "policyPolicyScopeContext"
    EP_CLASS_ID_POLICY_POLICY_SCOPE_FSM = "policyPolicyScopeFsm"
    EP_CLASS_ID_POLICY_POLICY_SCOPE_FSM_STAGE = "policyPolicyScopeFsmStage"
    EP_CLASS_ID_POLICY_POLICY_SCOPE_FSM_TASK = "policyPolicyScopeFsmTask"
    EP_CLASS_ID_POLICY_PORT_CONFIG = "policyPortConfig"
    EP_CLASS_ID_POLICY_PORT_CONFIG_OP = "policyPortConfigOp"
    EP_CLASS_ID_POLICY_POWER_MGMT = "policyPowerMgmt"
    EP_CLASS_ID_POLICY_POWER_MGMT_OP = "policyPowerMgmtOp"
    EP_CLASS_ID_POLICY_PROXY_MO = "policyProxyMo"
    EP_CLASS_ID_POLICY_PSU = "policyPsu"
    EP_CLASS_ID_POLICY_PSU_OP = "policyPsuOp"
    EP_CLASS_ID_POLICY_REQUESTOR = "policyRequestor"
    EP_CLASS_ID_POLICY_SCOPE = "policyScope"
    EP_CLASS_ID_POLICY_SECURITY = "policySecurity"
    EP_CLASS_ID_POLICY_SECURITY_OP = "policySecurityOp"
    EP_CLASS_ID_POLICY_SOURCE = "policySource"
    EP_CLASS_ID_POLICY_SOURCE_APP = "policySourceApp"
    EP_CLASS_ID_POLICY_STORAGE_AUTO_CONFIG = "policyStorageAutoConfig"
    EP_CLASS_ID_POLICY_STORAGE_AUTO_CONFIG_OP = "policyStorageAutoConfigOp"
    EP_CLASS_ID_POLICY_SYSTEM_EP = "policySystemEp"
    EP_CLASS_ID_POLICY_SYSTEM_PROFILE = "policySystemProfile"
    EP_CLASS_ID_POLICY_TRACKED = "policyTracked"
    EP_CLASS_ID_POLICY_TRACKER = "policyTracker"
    EP_CLASS_ID_POLICY_UNIVERSE = "policyUniverse"
    EP_CLASS_ID_POOL_ASNMT = "poolAsnmt"
    EP_CLASS_ID_POOL_ELEMENT = "poolElement"
    EP_CLASS_ID_POOL_ELEMENT_ALLOC = "poolElementAlloc"
    EP_CLASS_ID_POOL_MEMBER = "poolMember"
    EP_CLASS_ID_POOL_POOL = "poolPool"
    EP_CLASS_ID_POOL_POOL_MEMBER = "poolPoolMember"
    EP_CLASS_ID_POOL_POOLABLE = "poolPoolable"
    EP_CLASS_ID_POOL_UNIVERSE = "poolUniverse"
    EP_CLASS_ID_PORT_GROUP = "portGroup"
    EP_CLASS_ID_PORT_INT_FIO = "portIntFIo"
    EP_CLASS_ID_PORT_PIO = "portPIo"
    EP_CLASS_ID_PORT_PHYS_SWITCH_IO = "portPhysSwitchIo"
    EP_CLASS_ID_PORT_SERVER_INT_FIO = "portServerIntFIo"
    EP_CLASS_ID_PORT_SUB_GROUP = "portSubGroup"
    EP_CLASS_ID_PORT_SWITCH_INT_FIO = "portSwitchIntFIo"
    EP_CLASS_ID_POWER_ABUDGET = "powerABudget"
    EP_CLASS_ID_POWER_AGROUP = "powerAGroup"
    EP_CLASS_ID_POWER_BUDGET = "powerBudget"
    EP_CLASS_ID_POWER_CHASSIS_MEMBER = "powerChassisMember"
    EP_CLASS_ID_POWER_EP = "powerEp"
    EP_CLASS_ID_POWER_GROUP = "powerGroup"
    EP_CLASS_ID_POWER_GROUP_MEMBER = "powerGroupMember"
    EP_CLASS_ID_POWER_GROUP_QUAL = "powerGroupQual"
    EP_CLASS_ID_POWER_GROUP_STATS = "powerGroupStats"
    EP_CLASS_ID_POWER_GROUP_STATS_HIST = "powerGroupStatsHist"
    EP_CLASS_ID_POWER_MGMT_POLICY = "powerMgmtPolicy"
    EP_CLASS_ID_POWER_POLICY = "powerPolicy"
    EP_CLASS_ID_POWER_PROFILED_POWER = "powerProfiledPower"
    EP_CLASS_ID_PROC_DOER = "procDoer"
    EP_CLASS_ID_PROC_MANAGER = "procManager"
    EP_CLASS_ID_PROC_PROC_COUNTS = "procProcCounts"
    EP_CLASS_ID_PROC_PROCS = "procProcs"
    EP_CLASS_ID_PROC_PRT = "procPrt"
    EP_CLASS_ID_PROC_PRT_COUNTS = "procPrtCounts"
    EP_CLASS_ID_PROC_STIMULUS_COUNTS = "procStimulusCounts"
    EP_CLASS_ID_PROC_SVC = "procSvc"
    EP_CLASS_ID_PROC_TX_COUNTS = "procTxCounts"
    EP_CLASS_ID_PROCESSOR_ENV_STATS = "processorEnvStats"
    EP_CLASS_ID_PROCESSOR_ENV_STATS_HIST = "processorEnvStatsHist"
    EP_CLASS_ID_PROCESSOR_ERROR_STATS = "processorErrorStats"
    EP_CLASS_ID_PROCESSOR_ERROR_STATS_HIST = "processorErrorStatsHist"
    EP_CLASS_ID_PROCESSOR_QUAL = "processorQual"
    EP_CLASS_ID_PROCESSOR_RUNTIME = "processorRuntime"
    EP_CLASS_ID_PROCESSOR_RUNTIME_HIST = "processorRuntimeHist"
    EP_CLASS_ID_PROCESSOR_UNIT = "processorUnit"
    EP_CLASS_ID_PROCESSOR_UNIT_ASSOC_CTX = "processorUnitAssocCtx"
    EP_CLASS_ID_QOS_DEFINITION = "qosDefinition"
    EP_CLASS_ID_QOS_ITEM = "qosItem"
    EP_CLASS_ID_QOSCLASS_DEFINITION = "qosclassDefinition"
    EP_CLASS_ID_QOSCLASS_ETH = "qosclassEth"
    EP_CLASS_ID_QOSCLASS_ETH_BE = "qosclassEthBE"
    EP_CLASS_ID_QOSCLASS_ETH_CLASSIFIED = "qosclassEthClassified"
    EP_CLASS_ID_QOSCLASS_FC = "qosclassFc"
    EP_CLASS_ID_QOSCLASS_ITEM = "qosclassItem"
    EP_CLASS_ID_QOSCLASS_POLICY = "qosclassPolicy"
    EP_CLASS_ID_QUERY_CONTEXT = "queryContext"
    EP_CLASS_ID_QUERY_DEPENDENCY_CONTEXT = "queryDependencyContext"
    EP_CLASS_ID_QUERY_DEPENDENCY_REF = "queryDependencyRef"
    EP_CLASS_ID_QUERY_EP = "queryEp"
    EP_CLASS_ID_QUERY_IMPORT_CONTEXT = "queryImportContext"
    EP_CLASS_ID_QUERY_USAGE_CONTEXT = "queryUsageContext"
    EP_CLASS_ID_QUERYRESULT_DEPENDENCY = "queryresultDependency"
    EP_CLASS_ID_QUERYRESULT_DEST_ORG_EP = "queryresultDestOrgEp"
    EP_CLASS_ID_QUERYRESULT_DOMAIN_GROUP_EP = "queryresultDomainGroupEp"
    EP_CLASS_ID_QUERYRESULT_ITEM = "queryresultItem"
    EP_CLASS_ID_QUERYRESULT_ORG_EP = "queryresultOrgEp"
    EP_CLASS_ID_QUERYRESULT_USAGE = "queryresultUsage"
    EP_CLASS_ID_RULE_DEFINITION = "ruleDefinition"
    EP_CLASS_ID_RULE_ITEM = "ruleItem"
    EP_CLASS_ID_RULE_REQUIREMENT = "ruleRequirement"
    EP_CLASS_ID_RULE_SIZE_REQUIREMENT = "ruleSizeRequirement"
    EP_CLASS_ID_SECURITY_UNIT = "securityUnit"
    EP_CLASS_ID_SES_DISK_SLOT_EP = "sesDiskSlotEp"
    EP_CLASS_ID_SES_ENCLOSURE = "sesEnclosure"
    EP_CLASS_ID_SMARTCALLHOME_HTTP_PROXY = "smartcallhomeHttpProxy"
    EP_CLASS_ID_SMARTCALLHOME_PERIODIC_INVENTORY_STATUS = "smartcallhomePeriodicInventoryStatus"
    EP_CLASS_ID_SMARTCALLHOME_PERIODIC_SYSTEM_INVENTORY = "smartcallhomePeriodicSystemInventory"
    EP_CLASS_ID_SMARTCALLHOME_POLICY = "smartcallhomePolicy"
    EP_CLASS_ID_SMARTCALLHOME_PROFILE = "smartcallhomeProfile"
    EP_CLASS_ID_SMARTCALLHOME_SOURCE = "smartcallhomeSource"
    EP_CLASS_ID_SMARTCALLHOME_TRANSPORT_GATEWAY = "smartcallhomeTransportGateway"
    EP_CLASS_ID_SMARTLICENSE_AGENT = "smartlicenseAgent"
    EP_CLASS_ID_SMARTLICENSE_AGENT_FSM = "smartlicenseAgentFsm"
    EP_CLASS_ID_SMARTLICENSE_AGENT_FSM_STAGE = "smartlicenseAgentFsmStage"
    EP_CLASS_ID_SMARTLICENSE_AGENT_FSM_TASK = "smartlicenseAgentFsmTask"
    EP_CLASS_ID_SMARTLICENSE_ENTITLEMENT = "smartlicenseEntitlement"
    EP_CLASS_ID_SMARTLICENSE_ENTITLEMENT_EP = "smartlicenseEntitlementEp"
    EP_CLASS_ID_SMARTLICENSE_ENTITLEMENT_EP_FSM = "smartlicenseEntitlementEpFsm"
    EP_CLASS_ID_SMARTLICENSE_ENTITLEMENT_EP_FSM_STAGE = "smartlicenseEntitlementEpFsmStage"
    EP_CLASS_ID_SMARTLICENSE_ENTITLEMENT_EP_FSM_TASK = "smartlicenseEntitlementEpFsmTask"
    EP_CLASS_ID_SMARTLICENSE_EP = "smartlicenseEp"
    EP_CLASS_ID_SMARTLICENSE_HOLDER = "smartlicenseHolder"
    EP_CLASS_ID_SMARTLICENSE_HOLDER_FSM = "smartlicenseHolderFsm"
    EP_CLASS_ID_SMARTLICENSE_HOLDER_FSM_STAGE = "smartlicenseHolderFsmStage"
    EP_CLASS_ID_SMARTLICENSE_HOLDER_FSM_TASK = "smartlicenseHolderFsmTask"
    EP_CLASS_ID_SMARTLICENSE_TEST = "smartlicenseTest"
    EP_CLASS_ID_SMARTLICENSE_TEST_FSM = "smartlicenseTestFsm"
    EP_CLASS_ID_SMARTLICENSE_TEST_FSM_STAGE = "smartlicenseTestFsmStage"
    EP_CLASS_ID_SMARTLICENSE_TEST_FSM_TASK = "smartlicenseTestFsmTask"
    EP_CLASS_ID_SOL_DEF = "solDef"
    EP_CLASS_ID_SOL_POLICY = "solPolicy"
    EP_CLASS_ID_STATS_CHART = "statsChart"
    EP_CLASS_ID_STATS_CHART_CONTAINER = "statsChartContainer"
    EP_CLASS_ID_STATS_COLLECTION_POLICY = "statsCollectionPolicy"
    EP_CLASS_ID_STATS_CURR = "statsCurr"
    EP_CLASS_ID_STATS_CUSTOM_CHART = "statsCustomChart"
    EP_CLASS_ID_STATS_CUSTOM_EP = "statsCustomEp"
    EP_CLASS_ID_STATS_DB_MIGRATION_STATUS = "statsDbMigrationStatus"
    EP_CLASS_ID_STATS_DB_SUMMARY_META = "statsDbSummaryMeta"
    EP_CLASS_ID_STATS_HIST = "statsHist"
    EP_CLASS_ID_STATS_HOLDER = "statsHolder"
    EP_CLASS_ID_STATS_INVENTORY_META = "statsInventoryMeta"
    EP_CLASS_ID_STATS_ITEM = "statsItem"
    EP_CLASS_ID_STATS_PASADENA_COLLECTION_POLICY = "statsPasadenaCollectionPolicy"
    EP_CLASS_ID_STATS_STANDARD_CHART = "statsStandardChart"
    EP_CLASS_ID_STATS_STANDARD_EP = "statsStandardEp"
    EP_CLASS_ID_STATS_STATS_QUERY = "statsStatsQuery"
    EP_CLASS_ID_STATS_STATS_QUERY_HOLDER = "statsStatsQueryHolder"
    EP_CLASS_ID_STATS_THR32_DEFINITION = "statsThr32Definition"
    EP_CLASS_ID_STATS_THR32_VALUE = "statsThr32Value"
    EP_CLASS_ID_STATS_THR64_DEFINITION = "statsThr64Definition"
    EP_CLASS_ID_STATS_THR64_VALUE = "statsThr64Value"
    EP_CLASS_ID_STATS_THR_FLOAT_DEFINITION = "statsThrFloatDefinition"
    EP_CLASS_ID_STATS_THR_FLOAT_VALUE = "statsThrFloatValue"
    EP_CLASS_ID_STATS_THRESHOLD_CLASS = "statsThresholdClass"
    EP_CLASS_ID_STATS_THRESHOLD_DEFINITION = "statsThresholdDefinition"
    EP_CLASS_ID_STATS_THRESHOLD_POLICY = "statsThresholdPolicy"
    EP_CLASS_ID_STATS_THRESHOLD_VALUE = "statsThresholdValue"
    EP_CLASS_ID_STORAGE_ADEF = "storageADef"
    EP_CLASS_ID_STORAGE_ALUN = "storageALun"
    EP_CLASS_ID_STORAGE_ALUN_REF_BASE = "storageALunRefBase"
    EP_CLASS_ID_STORAGE_ASCSI_LUN = "storageAScsiLun"
    EP_CLASS_ID_STORAGE_ASCSI_LUN_CTX = "storageAScsiLunCtx"
    EP_CLASS_ID_STORAGE_ASLOT = "storageASlot"
    EP_CLASS_ID_STORAGE_ASNAP_REPLICA_LUN_CTX = "storageASnapReplicaLunCtx"
    EP_CLASS_ID_STORAGE_AVOLUME = "storageAVolume"
    EP_CLASS_ID_STORAGE_APPLIANCE = "storageAppliance"
    EP_CLASS_ID_STORAGE_ARRAY = "storageArray"
    EP_CLASS_ID_STORAGE_AUTH_KEY = "storageAuthKey"
    EP_CLASS_ID_STORAGE_BACKSTORE = "storageBackstore"
    EP_CLASS_ID_STORAGE_BLADE = "storageBlade"
    EP_CLASS_ID_STORAGE_CLOUD = "storageCloud"
    EP_CLASS_ID_STORAGE_CLUSTER_ID_UNIVERSE = "storageClusterIdUniverse"
    EP_CLASS_ID_STORAGE_COMPUTE_BLADE_OPERATION = "storageComputeBladeOperation"
    EP_CLASS_ID_STORAGE_CONNECTION_DEF = "storageConnectionDef"
    EP_CLASS_ID_STORAGE_CONNECTION_POLICY = "storageConnectionPolicy"
    EP_CLASS_ID_STORAGE_CONTAINER = "storageContainer"
    EP_CLASS_ID_STORAGE_CONTROLLER = "storageController"
    EP_CLASS_ID_STORAGE_CONTROLLER_BASE = "storageControllerBase"
    EP_CLASS_ID_STORAGE_CONTROLLER_EP = "storageControllerEp"
    EP_CLASS_ID_STORAGE_CONTROLLER_OPERATION = "storageControllerOperation"
    EP_CLASS_ID_STORAGE_CONTROLLER_REF = "storageControllerRef"
    EP_CLASS_ID_STORAGE_CTRL_STORAGE_STATS = "storageCtrlStorageStats"
    EP_CLASS_ID_STORAGE_CTRL_STORAGE_STATS_HIST = "storageCtrlStorageStatsHist"
    EP_CLASS_ID_STORAGE_DEVICE = "storageDevice"
    EP_CLASS_ID_STORAGE_DISK_ENV_STATS = "storageDiskEnvStats"
    EP_CLASS_ID_STORAGE_DISK_ENV_STATS_HIST = "storageDiskEnvStatsHist"
    EP_CLASS_ID_STORAGE_DISK_EP = "storageDiskEp"
    EP_CLASS_ID_STORAGE_DISK_GROUP = "storageDiskGroup"
    EP_CLASS_ID_STORAGE_EMBEDDED_STORAGE = "storageEmbeddedStorage"
    EP_CLASS_ID_STORAGE_ENCLOSURE = "storageEnclosure"
    EP_CLASS_ID_STORAGE_ENCLOSURE_DISK_SLOT_EP = "storageEnclosureDiskSlotEp"
    EP_CLASS_ID_STORAGE_ENCLOSURE_LOCAL_DISK_CONFIG = "storageEnclosureLocalDiskConfig"
    EP_CLASS_ID_STORAGE_EP = "storageEp"
    EP_CLASS_ID_STORAGE_EP_USER = "storageEpUser"
    EP_CLASS_ID_STORAGE_ETH_LIF = "storageEthLif"
    EP_CLASS_ID_STORAGE_ETHER_IF = "storageEtherIf"
    EP_CLASS_ID_STORAGE_FC_IF = "storageFcIf"
    EP_CLASS_ID_STORAGE_FC_TARGET_EP = "storageFcTargetEp"
    EP_CLASS_ID_STORAGE_FC_TARGET_IF = "storageFcTargetIf"
    EP_CLASS_ID_STORAGE_FLEX_FLASH_CARD = "storageFlexFlashCard"
    EP_CLASS_ID_STORAGE_FLEX_FLASH_CONTROLLER = "storageFlexFlashController"
    EP_CLASS_ID_STORAGE_FLEX_FLASH_CONTROLLER_OPERATION = "storageFlexFlashControllerOperation"
    EP_CLASS_ID_STORAGE_FLEX_FLASH_DRIVE = "storageFlexFlashDrive"
    EP_CLASS_ID_STORAGE_FLEX_FLASH_VIRTUAL_DRIVE = "storageFlexFlashVirtualDrive"
    EP_CLASS_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATS = "storageHddMotherBoardTempStats"
    EP_CLASS_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATS_HIST = "storageHddMotherBoardTempStatsHist"
    EP_CLASS_ID_STORAGE_ISCSI_INITIATOR_EP = "storageIScsiInitiatorEp"
    EP_CLASS_ID_STORAGE_ISCSI_TARGET_IF = "storageIScsiTargetIf"
    EP_CLASS_ID_STORAGE_INI_GROUP = "storageIniGroup"
    EP_CLASS_ID_STORAGE_INITIATOR = "storageInitiator"
    EP_CLASS_ID_STORAGE_INITIATOR_REF = "storageInitiatorRef"
    EP_CLASS_ID_STORAGE_IP_V4_POOLED_ADDR = "storageIpV4PooledAddr"
    EP_CLASS_ID_STORAGE_IP_V4_STATIC_ADDR = "storageIpV4StaticAddr"
    EP_CLASS_ID_STORAGE_ITEM = "storageItem"
    EP_CLASS_ID_STORAGE_L2_IF = "storageL2If"
    EP_CLASS_ID_STORAGE_LOCAL_DISK = "storageLocalDisk"
    EP_CLASS_ID_STORAGE_LOCAL_DISK_BASE = "storageLocalDiskBase"
    EP_CLASS_ID_STORAGE_LOCAL_DISK_CONFIG = "storageLocalDiskConfig"
    EP_CLASS_ID_STORAGE_LOCAL_DISK_CONFIG_DEF = "storageLocalDiskConfigDef"
    EP_CLASS_ID_STORAGE_LOCAL_DISK_CONFIG_POLICY = "storageLocalDiskConfigPolicy"
    EP_CLASS_ID_STORAGE_LOCAL_DISK_EP = "storageLocalDiskEp"
    EP_CLASS_ID_STORAGE_LOCAL_DISK_OPERATION = "storageLocalDiskOperation"
    EP_CLASS_ID_STORAGE_LOCAL_DISK_PARTITION = "storageLocalDiskPartition"
    EP_CLASS_ID_STORAGE_LOCAL_LUN = "storageLocalLun"
    EP_CLASS_ID_STORAGE_LOGICAL = "storageLogical"
    EP_CLASS_ID_STORAGE_LUN_COUNTERS = "storageLunCounters"
    EP_CLASS_ID_STORAGE_LUN_DISK = "storageLunDisk"
    EP_CLASS_ID_STORAGE_LUN_MASK_GROUP = "storageLunMaskGroup"
    EP_CLASS_ID_STORAGE_LUN_REPLICA = "storageLunReplica"
    EP_CLASS_ID_STORAGE_LUN_RESOURCE_SELECTION_LOG = "storageLunResourceSelectionLog"
    EP_CLASS_ID_STORAGE_LUN_SNAPSHOT = "storageLunSnapshot"
    EP_CLASS_ID_STORAGE_META = "storageMeta"
    EP_CLASS_ID_STORAGE_MEZZ_FLASH_LIFE = "storageMezzFlashLife"
    EP_CLASS_ID_STORAGE_NODE_EP = "storageNodeEp"
    EP_CLASS_ID_STORAGE_NVME_STATS = "storageNvmeStats"
    EP_CLASS_ID_STORAGE_NVME_STATS_HIST = "storageNvmeStatsHist"
    EP_CLASS_ID_STORAGE_NVME_STORAGE = "storageNvmeStorage"
    EP_CLASS_ID_STORAGE_ONBOARD_DEVICE = "storageOnboardDevice"
    EP_CLASS_ID_STORAGE_OPERATION = "storageOperation"
    EP_CLASS_ID_STORAGE_PARTITION = "storagePartition"
    EP_CLASS_ID_STORAGE_PHYSICAL = "storagePhysical"
    EP_CLASS_ID_STORAGE_PROCESSOR = "storageProcessor"
    EP_CLASS_ID_STORAGE_PROCESSOR_EP = "storageProcessorEp"
    EP_CLASS_ID_STORAGE_PROCESSOR_RUNTIME = "storageProcessorRuntime"
    EP_CLASS_ID_STORAGE_QUAL = "storageQual"
    EP_CLASS_ID_STORAGE_RAID_BATTERY = "storageRaidBattery"
    EP_CLASS_ID_STORAGE_REPLICATION_CTX = "storageReplicationCtx"
    EP_CLASS_ID_STORAGE_SAS_EXPANDER = "storageSasExpander"
    EP_CLASS_ID_STORAGE_SAS_PHY_LINK = "storageSasPhyLink"
    EP_CLASS_ID_STORAGE_SAS_PORT = "storageSasPort"
    EP_CLASS_ID_STORAGE_SAS_UP_LINK = "storageSasUpLink"
    EP_CLASS_ID_STORAGE_SCSI_DEVICE_DESCRIPTOR = "storageScsiDeviceDescriptor"
    EP_CLASS_ID_STORAGE_SCSI_LUN = "storageScsiLun"
    EP_CLASS_ID_STORAGE_SCSI_LUN_CTX = "storageScsiLunCtx"
    EP_CLASS_ID_STORAGE_SCSI_LUN_INST_REF = "storageScsiLunInstRef"
    EP_CLASS_ID_STORAGE_SCSI_LUN_MASK = "storageScsiLunMask"
    EP_CLASS_ID_STORAGE_SCSI_LUN_REF = "storageScsiLunRef"
    EP_CLASS_ID_STORAGE_SNAPSHOT = "storageSnapshot"
    EP_CLASS_ID_STORAGE_SNAPSHOT_CTX = "storageSnapshotCtx"
    EP_CLASS_ID_STORAGE_SSD_HEALTH_STATS = "storageSsdHealthStats"
    EP_CLASS_ID_STORAGE_SSD_HEALTH_STATS_HIST = "storageSsdHealthStatsHist"
    EP_CLASS_ID_STORAGE_STORAGE_STATS = "storageStorageStats"
    EP_CLASS_ID_STORAGE_STORAGE_STATS_HIST = "storageStorageStatsHist"
    EP_CLASS_ID_STORAGE_SYSTEM = "storageSystem"
    EP_CLASS_ID_STORAGE_TARGET = "storageTarget"
    EP_CLASS_ID_STORAGE_TARGET_IF = "storageTargetIf"
    EP_CLASS_ID_STORAGE_TRANSPORT_IF = "storageTransportIf"
    EP_CLASS_ID_STORAGE_TRANSPORTABLE_FLASH_MODULE = "storageTransportableFlashModule"
    EP_CLASS_ID_STORAGE_UNIT = "storageUnit"
    EP_CLASS_ID_STORAGE_USAGE_COUNTERS = "storageUsageCounters"
    EP_CLASS_ID_STORAGE_VDMEMBER_EP = "storageVDMemberEp"
    EP_CLASS_ID_STORAGE_VIRTUAL_DRIVE = "storageVirtualDrive"
    EP_CLASS_ID_STORAGE_VIRTUAL_DRIVE_CONTAINER = "storageVirtualDriveContainer"
    EP_CLASS_ID_STORAGE_VIRTUAL_DRIVE_EP = "storageVirtualDriveEp"
    EP_CLASS_ID_STORAGE_VIRTUAL_DRIVE_OPERATION = "storageVirtualDriveOperation"
    EP_CLASS_ID_STORAGE_VIRTUAL_DRIVE_REF = "storageVirtualDriveRef"
    EP_CLASS_ID_STORAGE_VIRTUAL_DRIVE_REF_OPERATION = "storageVirtualDriveRefOperation"
    EP_CLASS_ID_STORAGE_VOLUME = "storageVolume"
    EP_CLASS_ID_STORAGE_VSAN_REF = "storageVsanRef"
    EP_CLASS_ID_STORAGE_VSAN_REF_IVT = "storageVsanRefIvt"
    EP_CLASS_ID_SW_CARD_ENV_STATS = "swCardEnvStats"
    EP_CLASS_ID_SW_CARD_ENV_STATS_HIST = "swCardEnvStatsHist"
    EP_CLASS_ID_SW_ENV_STATS = "swEnvStats"
    EP_CLASS_ID_SW_ENV_STATS_HIST = "swEnvStatsHist"
    EP_CLASS_ID_SW_MON = "swMon"
    EP_CLASS_ID_SW_SYSTEM_STATS = "swSystemStats"
    EP_CLASS_ID_SW_SYSTEM_STATS_HIST = "swSystemStatsHist"
    EP_CLASS_ID_SW_VLAN = "swVlan"
    EP_CLASS_ID_SW_VLAN_GROUP = "swVlanGroup"
    EP_CLASS_ID_SYNTHETIC_DIRECTORY = "syntheticDirectory"
    EP_CLASS_ID_SYNTHETIC_FILE = "syntheticFile"
    EP_CLASS_ID_SYNTHETIC_FILE_SYSTEM = "syntheticFileSystem"
    EP_CLASS_ID_SYNTHETIC_FS_OBJ = "syntheticFsObj"
    EP_CLASS_ID_SYNTHETIC_TIME = "syntheticTime"
    EP_CLASS_ID_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET = "sysdebugAutoCoreFileExportTarget"
    EP_CLASS_ID_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM = "sysdebugAutoCoreFileExportTargetFsm"
    EP_CLASS_ID_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM_STAGE = "sysdebugAutoCoreFileExportTargetFsmStage"
    EP_CLASS_ID_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM_TASK = "sysdebugAutoCoreFileExportTargetFsmTask"
    EP_CLASS_ID_SYSDEBUG_BACKUP_BEHAVIOR = "sysdebugBackupBehavior"
    EP_CLASS_ID_SYSDEBUG_CORE = "sysdebugCore"
    EP_CLASS_ID_SYSDEBUG_CORE_FILE_EXPORT_TARGET = "sysdebugCoreFileExportTarget"
    EP_CLASS_ID_SYSDEBUG_CORE_FILE_REPOSITORY = "sysdebugCoreFileRepository"
    EP_CLASS_ID_SYSDEBUG_DIAGNOSTIC_LOG = "sysdebugDiagnosticLog"
    EP_CLASS_ID_SYSDEBUG_EP = "sysdebugEp"
    EP_CLASS_ID_SYSDEBUG_EXPORTER = "sysdebugExporter"
    EP_CLASS_ID_SYSDEBUG_FILE = "sysdebugFile"
    EP_CLASS_ID_SYSDEBUG_LOG_BEHAVIOR = "sysdebugLogBehavior"
    EP_CLASS_ID_SYSDEBUG_LOG_CONTROL_DESTINATION_FILE = "sysdebugLogControlDestinationFile"
    EP_CLASS_ID_SYSDEBUG_LOG_CONTROL_DESTINATION_SYSLOG = "sysdebugLogControlDestinationSyslog"
    EP_CLASS_ID_SYSDEBUG_LOG_CONTROL_DOMAIN = "sysdebugLogControlDomain"
    EP_CLASS_ID_SYSDEBUG_LOG_CONTROL_EP = "sysdebugLogControlEp"
    EP_CLASS_ID_SYSDEBUG_LOG_CONTROL_EP_FSM = "sysdebugLogControlEpFsm"
    EP_CLASS_ID_SYSDEBUG_LOG_CONTROL_EP_FSM_STAGE = "sysdebugLogControlEpFsmStage"
    EP_CLASS_ID_SYSDEBUG_LOG_CONTROL_EP_FSM_TASK = "sysdebugLogControlEpFsmTask"
    EP_CLASS_ID_SYSDEBUG_LOG_CONTROL_MODULE = "sysdebugLogControlModule"
    EP_CLASS_ID_SYSDEBUG_MEP_LOG_DEF = "sysdebugMEpLogDef"
    EP_CLASS_ID_SYSDEBUG_MEP_LOG_POLICY = "sysdebugMEpLogPolicy"
    EP_CLASS_ID_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET = "sysdebugManualCoreFileExportTarget"
    EP_CLASS_ID_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM = "sysdebugManualCoreFileExportTargetFsm"
    EP_CLASS_ID_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM_STAGE = "sysdebugManualCoreFileExportTargetFsmStage"
    EP_CLASS_ID_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM_TASK = "sysdebugManualCoreFileExportTargetFsmTask"
    EP_CLASS_ID_SYSDEBUG_REPOSITORY = "sysdebugRepository"
    EP_CLASS_ID_SYSDEBUG_TECH_SUP_FILE_REPOSITORY = "sysdebugTechSupFileRepository"
    EP_CLASS_ID_SYSDEBUG_TECH_SUPPORT = "sysdebugTechSupport"
    EP_CLASS_ID_SYSDEBUG_TECH_SUPPORT_CMD_OPT = "sysdebugTechSupportCmdOpt"
    EP_CLASS_ID_SYSDEBUG_TECH_SUPPORT_FSM = "sysdebugTechSupportFsm"
    EP_CLASS_ID_SYSDEBUG_TECH_SUPPORT_FSM_STAGE = "sysdebugTechSupportFsmStage"
    EP_CLASS_ID_SYSDEBUG_TECH_SUPPORT_FSM_TASK = "sysdebugTechSupportFsmTask"
    EP_CLASS_ID_SYSDEBUG_TECH_SUPPORT_OP = "sysdebugTechSupportOp"
    EP_CLASS_ID_SYSDEBUG_TECH_SUPPORT_OPERATION = "sysdebugTechSupportOperation"
    EP_CLASS_ID_SYSFILE_DIGEST = "sysfileDigest"
    EP_CLASS_ID_SYSFILE_EP = "sysfileEp"
    EP_CLASS_ID_SYSFILE_EXPORTER = "sysfileExporter"
    EP_CLASS_ID_SYSFILE_IMPORTER = "sysfileImporter"
    EP_CLASS_ID_SYSFILE_INSTANCE = "sysfileInstance"
    EP_CLASS_ID_SYSFILE_MUTATION = "sysfileMutation"
    EP_CLASS_ID_SYSFILE_MUTATION_FSM = "sysfileMutationFsm"
    EP_CLASS_ID_SYSFILE_MUTATION_FSM_STAGE = "sysfileMutationFsmStage"
    EP_CLASS_ID_SYSFILE_MUTATION_FSM_TASK = "sysfileMutationFsmTask"
    EP_CLASS_ID_SYSFILE_REPOSITORY = "sysfileRepository"
    EP_CLASS_ID_TAG_ADEF = "tagADef"
    EP_CLASS_ID_TAG_AINSTANCE = "tagAInstance"
    EP_CLASS_ID_TAG_DEF = "tagDef"
    EP_CLASS_ID_TAG_DEF_EP = "tagDefEp"
    EP_CLASS_ID_TAG_DRIVER = "tagDriver"
    EP_CLASS_ID_TAG_INSTANCE = "tagInstance"
    EP_CLASS_ID_TAG_INSTANCE_EP = "tagInstanceEp"
    EP_CLASS_ID_TAG_INSTANCE_ITEM = "tagInstanceItem"
    EP_CLASS_ID_TAG_ITEM = "tagItem"
    EP_CLASS_ID_TAG_SOFTWARE_INST = "tagSoftwareInst"
    EP_CLASS_ID_TESTING_CLI_POLICY = "testingCliPolicy"
    EP_CLASS_ID_TESTING_SERVICE_PROFILE = "testingServiceProfile"
    EP_CLASS_ID_TESTING_SERVICE_PROFILE_FSM = "testingServiceProfileFsm"
    EP_CLASS_ID_TESTING_SERVICE_PROFILE_FSM_STAGE = "testingServiceProfileFsmStage"
    EP_CLASS_ID_TESTING_SERVICE_PROFILE_FSM_TASK = "testingServiceProfileFsmTask"
    EP_CLASS_ID_TESTING_SNMP_COMMUNITY = "testingSnmpCommunity"
    EP_CLASS_ID_TESTING_SNMP_POLICY = "testingSnmpPolicy"
    EP_CLASS_ID_TESTING_SNMP_SUPPORT = "testingSnmpSupport"
    EP_CLASS_ID_TESTING_SNMP_TRAP = "testingSnmpTrap"
    EP_CLASS_ID_TOP_INFO_SYNC_POLICY = "topInfoSyncPolicy"
    EP_CLASS_ID_TOP_META_INF = "topMetaInf"
    EP_CLASS_ID_TOP_ROOT = "topRoot"
    EP_CLASS_ID_TOP_SYSTEM = "topSystem"
    EP_CLASS_ID_TOP_SYSTEM_FSM = "topSystemFsm"
    EP_CLASS_ID_TOP_SYSTEM_FSM_STAGE = "topSystemFsmStage"
    EP_CLASS_ID_TOP_SYSTEM_FSM_TASK = "topSystemFsmTask"
    EP_CLASS_ID_TRIG_ABS_WINDOW = "trigAbsWindow"
    EP_CLASS_ID_TRIG_ACK = "trigAck"
    EP_CLASS_ID_TRIG_BASE_RECURR_WINDOW = "trigBaseRecurrWindow"
    EP_CLASS_ID_TRIG_BASE_SCHED = "trigBaseSched"
    EP_CLASS_ID_TRIG_CONF_ACK = "trigConfAck"
    EP_CLASS_ID_TRIG_INST = "trigInst"
    EP_CLASS_ID_TRIG_META = "trigMeta"
    EP_CLASS_ID_TRIG_PENDING_ACK_COUNT = "trigPendingAckCount"
    EP_CLASS_ID_TRIG_RECURR_WINDOW = "trigRecurrWindow"
    EP_CLASS_ID_TRIG_RES_ACK = "trigResAck"
    EP_CLASS_ID_TRIG_SCHED = "trigSched"
    EP_CLASS_ID_TRIG_SCHED_WINDOW = "trigSchedWindow"
    EP_CLASS_ID_TRIG_SERVER_TOKEN = "trigServerToken"
    EP_CLASS_ID_TRIG_TEST = "trigTest"
    EP_CLASS_ID_TRIG_TOKEN = "trigToken"
    EP_CLASS_ID_TRIG_TOKEN_REQUESTOR = "trigTokenRequestor"
    EP_CLASS_ID_TRIG_TRIGGERABLE = "trigTriggerable"
    EP_CLASS_ID_TRIG_TRIGGERED = "trigTriggered"
    EP_CLASS_ID_TRIG_WINDOW = "trigWindow"
    EP_CLASS_ID_UNSPECIFIED = "unspecified"
    EP_CLASS_ID_UUIDPOOL_ADDR = "uuidpoolAddr"
    EP_CLASS_ID_UUIDPOOL_BLOCK = "uuidpoolBlock"
    EP_CLASS_ID_UUIDPOOL_FORMAT = "uuidpoolFormat"
    EP_CLASS_ID_UUIDPOOL_POOL = "uuidpoolPool"
    EP_CLASS_ID_UUIDPOOL_POOLED = "uuidpoolPooled"
    EP_CLASS_ID_UUIDPOOL_UNIVERSE = "uuidpoolUniverse"
    EP_CLASS_ID_VERSION_APPLICATION = "versionApplication"
    EP_CLASS_ID_VERSION_EP = "versionEp"
    EP_CLASS_ID_VERSION_FILTER = "versionFilter"
    EP_CLASS_ID_VERSION_MATRIX = "versionMatrix"
    EP_CLASS_ID_VERSION_PRODUCT = "versionProduct"
    EP_CLASS_ID_VERSION_VERSION = "versionVersion"
    EP_CLASS_ID_VM_ADAPTOR = "vmAdaptor"
    EP_CLASS_ID_VM_NIC = "vmNic"
    EP_CLASS_ID_VNIC_ABEH = "vnicABeh"
    EP_CLASS_ID_VNIC_AETHER_IF = "vnicAEtherIf"
    EP_CLASS_ID_VNIC_AFC_IF = "vnicAFcIf"
    EP_CLASS_ID_VNIC_AGROUP = "vnicAGroup"
    EP_CLASS_ID_VNIC_BOOT_IP_POLICY = "vnicBootIpPolicy"
    EP_CLASS_ID_VNIC_BOOT_TARGET = "vnicBootTarget"
    EP_CLASS_ID_VNIC_CON_POLICY_REF = "vnicConPolicyRef"
    EP_CLASS_ID_VNIC_CON_REQ = "vnicConReq"
    EP_CLASS_ID_VNIC_CONN_DEF = "vnicConnDef"
    EP_CLASS_ID_VNIC_CONNECTION = "vnicConnection"
    EP_CLASS_ID_VNIC_DEF_BEH = "vnicDefBeh"
    EP_CLASS_ID_VNIC_DYNAMIC_CON = "vnicDynamicCon"
    EP_CLASS_ID_VNIC_DYNAMIC_CON_POLICY = "vnicDynamicConPolicy"
    EP_CLASS_ID_VNIC_DYNAMIC_CON_POLICY_REF = "vnicDynamicConPolicyRef"
    EP_CLASS_ID_VNIC_DYNAMIC_CON_REQ = "vnicDynamicConReq"
    EP_CLASS_ID_VNIC_ETH_LIF = "vnicEthLif"
    EP_CLASS_ID_VNIC_ETHER = "vnicEther"
    EP_CLASS_ID_VNIC_ETHER_BASE = "vnicEtherBase"
    EP_CLASS_ID_VNIC_ETHER_BASE_IF = "vnicEtherBaseIf"
    EP_CLASS_ID_VNIC_ETHER_IF = "vnicEtherIf"
    EP_CLASS_ID_VNIC_FAULT = "vnicFault"
    EP_CLASS_ID_VNIC_FC = "vnicFc"
    EP_CLASS_ID_VNIC_FC_BASE = "vnicFcBase"
    EP_CLASS_ID_VNIC_FC_GROUP_DEF = "vnicFcGroupDef"
    EP_CLASS_ID_VNIC_FC_GROUP_TEMPL = "vnicFcGroupTempl"
    EP_CLASS_ID_VNIC_FC_IF = "vnicFcIf"
    EP_CLASS_ID_VNIC_FC_LIF = "vnicFcLif"
    EP_CLASS_ID_VNIC_FC_NODE = "vnicFcNode"
    EP_CLASS_ID_VNIC_FC_OEIF = "vnicFcOEIf"
    EP_CLASS_ID_VNIC_IPIF = "vnicIPIf"
    EP_CLASS_ID_VNIC_IPV4_DHCP = "vnicIPv4Dhcp"
    EP_CLASS_ID_VNIC_IPV4_DNS = "vnicIPv4Dns"
    EP_CLASS_ID_VNIC_IPV4_IF = "vnicIPv4If"
    EP_CLASS_ID_VNIC_IPV4_ISCSI_ADDR = "vnicIPv4IscsiAddr"
    EP_CLASS_ID_VNIC_IPV4_POOLED_ISCSI_ADDR = "vnicIPv4PooledIscsiAddr"
    EP_CLASS_ID_VNIC_IPV4_STATIC_ROUTE = "vnicIPv4StaticRoute"
    EP_CLASS_ID_VNIC_IPV6_IF = "vnicIPv6If"
    EP_CLASS_ID_VNIC_ISCSI = "vnicIScsi"
    EP_CLASS_ID_VNIC_ISCSI_AUTO_TARGET_IF = "vnicIScsiAutoTargetIf"
    EP_CLASS_ID_VNIC_ISCSI_BASE = "vnicIScsiBase"
    EP_CLASS_ID_VNIC_ISCSI_BOOT_PARAMS = "vnicIScsiBootParams"
    EP_CLASS_ID_VNIC_ISCSI_BOOT_VNIC = "vnicIScsiBootVnic"
    EP_CLASS_ID_VNIC_ISCSI_INITIATOR_PARAMS = "vnicIScsiInitiatorParams"
    EP_CLASS_ID_VNIC_ISCSI_LCP = "vnicIScsiLCP"
    EP_CLASS_ID_VNIC_ISCSI_NODE = "vnicIScsiNode"
    EP_CLASS_ID_VNIC_ISCSI_STATIC_TARGET_IF = "vnicIScsiStaticTargetIf"
    EP_CLASS_ID_VNIC_ISCSI_TARGET_IF = "vnicIScsiTargetIf"
    EP_CLASS_ID_VNIC_ISCSI_TARGET_PARAMS = "vnicIScsiTargetParams"
    EP_CLASS_ID_VNIC_IF = "vnicIf"
    EP_CLASS_ID_VNIC_IF_ROLE = "vnicIfRole"
    EP_CLASS_ID_VNIC_INI_GRP_FC = "vnicIniGrpFc"
    EP_CLASS_ID_VNIC_INI_GRP_FC_B = "vnicIniGrpFcB"
    EP_CLASS_ID_VNIC_INI_GRP_FC_BIF = "vnicIniGrpFcBIf"
    EP_CLASS_ID_VNIC_INI_GRP_FC_BASE = "vnicIniGrpFcBase"
    EP_CLASS_ID_VNIC_INI_GRP_FC_IF = "vnicIniGrpFcIf"
    EP_CLASS_ID_VNIC_IP_ADDR = "vnicIpAddr"
    EP_CLASS_ID_VNIC_IP_V4_ADDR = "vnicIpV4Addr"
    EP_CLASS_ID_VNIC_IP_V4_ADDR_CONF = "vnicIpV4AddrConf"
    EP_CLASS_ID_VNIC_IP_V4_ADDR_EXPL_CONF = "vnicIpV4AddrExplConf"
    EP_CLASS_ID_VNIC_IP_V4_MGMT_POOLED_ADDR = "vnicIpV4MgmtPooledAddr"
    EP_CLASS_ID_VNIC_IP_V4_POOLED_ADDR = "vnicIpV4PooledAddr"
    EP_CLASS_ID_VNIC_IP_V4_PROF_DERIVED_ADDR = "vnicIpV4ProfDerivedAddr"
    EP_CLASS_ID_VNIC_IP_V4_STATIC_ADDR = "vnicIpV4StaticAddr"
    EP_CLASS_ID_VNIC_IP_V6_ADDR = "vnicIpV6Addr"
    EP_CLASS_ID_VNIC_IP_V6_ADDR_CONF = "vnicIpV6AddrConf"
    EP_CLASS_ID_VNIC_IP_V6_ADDR_EXPL_CONF = "vnicIpV6AddrExplConf"
    EP_CLASS_ID_VNIC_IP_V6_MGMT_POOLED_ADDR = "vnicIpV6MgmtPooledAddr"
    EP_CLASS_ID_VNIC_IP_V6_STATIC_ADDR = "vnicIpV6StaticAddr"
    EP_CLASS_ID_VNIC_L2_IF = "vnicL2If"
    EP_CLASS_ID_VNIC_L2_LIF = "vnicL2Lif"
    EP_CLASS_ID_VNIC_L3_IF = "vnicL3If"
    EP_CLASS_ID_VNIC_LAN_CONN_POLICY = "vnicLanConnPolicy"
    EP_CLASS_ID_VNIC_LAN_CONN_TEMPL = "vnicLanConnTempl"
    EP_CLASS_ID_VNIC_LIF_VLAN = "vnicLifVlan"
    EP_CLASS_ID_VNIC_LIF_VSAN = "vnicLifVsan"
    EP_CLASS_ID_VNIC_LSTORAGE_ISCSI = "vnicLstorageIScsi"
    EP_CLASS_ID_VNIC_LUN = "vnicLun"
    EP_CLASS_ID_VNIC_MGMT = "vnicMgmt"
    EP_CLASS_ID_VNIC_MGMT_BASE = "vnicMgmtBase"
    EP_CLASS_ID_VNIC_MGMT_IF = "vnicMgmtIf"
    EP_CLASS_ID_VNIC_MON_SES_FC = "vnicMonSesFc"
    EP_CLASS_ID_VNIC_MON_SES_FC_BASE = "vnicMonSesFcBase"
    EP_CLASS_ID_VNIC_MON_SES_FC_IF = "vnicMonSesFcIf"
    EP_CLASS_ID_VNIC_NET_GROUP = "vnicNetGroup"
    EP_CLASS_ID_VNIC_NET_GROUP_REF = "vnicNetGroupRef"
    EP_CLASS_ID_VNIC_NIC_CONN = "vnicNicConn"
    EP_CLASS_ID_VNIC_OUTBAND_MGMT_EP = "vnicOutbandMgmtEp"
    EP_CLASS_ID_VNIC_OUTBAND_MGMT_EP_FSM = "vnicOutbandMgmtEpFsm"
    EP_CLASS_ID_VNIC_OUTBAND_MGMT_EP_FSM_STAGE = "vnicOutbandMgmtEpFsmStage"
    EP_CLASS_ID_VNIC_OUTBAND_MGMT_EP_FSM_TASK = "vnicOutbandMgmtEpFsmTask"
    EP_CLASS_ID_VNIC_PROFILE_SET = "vnicProfileSet"
    EP_CLASS_ID_VNIC_RACK_SERVER_DISCOVERY_PROFILE = "vnicRackServerDiscoveryProfile"
    EP_CLASS_ID_VNIC_SAN_CONN_POLICY = "vnicSanConnPolicy"
    EP_CLASS_ID_VNIC_SAN_CONN_TEMPL = "vnicSanConnTempl"
    EP_CLASS_ID_VNIC_STORAGE_ETH_LIF = "vnicStorageEthLif"
    EP_CLASS_ID_VNIC_STORAGE_LIF = "vnicStorageLif"
    EP_CLASS_ID_VNIC_TEMPL = "vnicTempl"
    EP_CLASS_ID_VNIC_USNIC_CON_POLICY = "vnicUsnicConPolicy"
    EP_CLASS_ID_VNIC_USNIC_CON_POLICY_REF = "vnicUsnicConPolicyRef"
    EP_CLASS_ID_VNIC_USNIC_CON_REQ = "vnicUsnicConReq"
    EP_CLASS_ID_VNIC_VHBA_BEH_POLICY = "vnicVhbaBehPolicy"
    EP_CLASS_ID_VNIC_VLAN = "vnicVlan"
    EP_CLASS_ID_VNIC_VMQ_CON_POLICY = "vnicVmqConPolicy"
    EP_CLASS_ID_VNIC_VMQ_CON_POLICY_REF = "vnicVmqConPolicyRef"
    EP_CLASS_ID_VNIC_VMQ_CON_REQ = "vnicVmqConReq"
    EP_CLASS_ID_VNIC_VNIC = "vnicVnic"
    EP_CLASS_ID_VNIC_VNIC_BEH_POLICY = "vnicVnicBehPolicy"


class GmetaClass(ManagedObject):
    """This is GmetaClass class."""

    consts = GmetaClassConsts()
    naming_props = set([u'id'])

    mo_meta = MoMeta("GmetaClass", "gmetaClass", "class-[id]", VersionMeta.Version111a, "InputOutput", 0x3f, [], ["read-only"], [], [u'gmetaProp'], [None])

    prop_meta = {
        "admin_prop_mask": MoPropertyMeta("admin_prop_mask", "adminPropMask", "string", VersionMeta.Version111a, MoPropertyMeta.READ_ONLY, None, None, None, None, [], []), 
        "child_action": MoPropertyMeta("child_action", "childAction", "string", VersionMeta.Version111a, MoPropertyMeta.INTERNAL, None, None, None, r"""((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], []), 
        "dn": MoPropertyMeta("dn", "dn", "string", VersionMeta.Version111a, MoPropertyMeta.READ_ONLY, 0x2, 0, 256, None, [], []), 
        "ep_class_id": MoPropertyMeta("ep_class_id", "epClassId", "string", VersionMeta.Version111a, MoPropertyMeta.READ_ONLY, None, None, None, None, ["aaaAuthMethod", "aaaAuthRealm", "aaaAuthRealmFsm", "aaaAuthRealmFsmStage", "aaaConfig", "aaaConsoleAuth", "aaaDefaultAuth", "aaaDefinition", "aaaDomain", "aaaDomainAuth", "aaaDomainGroup", "aaaEp", "aaaEpAuthProfile", "aaaEpFsm", "aaaEpFsmStage", "aaaEpFsmTask", "aaaEpLogin", "aaaEpUser", "aaaExtMgmtCutThruTkn", "aaaItem", "aaaLdapEp", "aaaLdapEpFsm", "aaaLdapEpFsmStage", "aaaLdapGroup", "aaaLdapGroupRule", "aaaLdapProvider", "aaaLocale", "aaaLog", "aaaModLR", "aaaOrg", "aaaProvider", "aaaProviderGroup", "aaaProviderRef", "aaaPwdProfile", "aaaRadiusEp", "aaaRadiusEpFsm", "aaaRadiusEpFsmStage", "aaaRadiusProvider", "aaaRealm", "aaaRealmFsm", "aaaRealmFsmStage", "aaaRealmFsmTask", "aaaRemoteUser", "aaaRole", "aaaSession", "aaaSessionLR", "aaaShellLogin", "aaaSshAuth", "aaaSystemUser", "aaaTacacsPlusEp", "aaaTacacsPlusEpFsm", "aaaTacacsPlusEpFsmStage", "aaaTacacsPlusProvider", "aaaUser", "aaaUserAction", "aaaUserData", "aaaUserEp", "aaaUserEpFsm", "aaaUserEpFsmStage", "aaaUserEpFsmTask", "aaaUserGroup", "aaaUserLocale", "aaaUserLogin", "aaaUserPreferences", "aaaUserRole", "aaaWebLogin", "adaptorBehCap", "adaptorCapDef", "adaptorCapQual", "adaptorCapSpec", "adaptorEthAdvFilterProfile", "adaptorEthArfsProfile", "adaptorEthCompQueueProfile", "adaptorEthFailoverProfile", "adaptorEthGENEVEProfile", "adaptorEthInterruptProfile", "adaptorEthInterruptScalingProfile", "adaptorEthNVGREProfile", "adaptorEthOffloadProfile", "adaptorEthPortBySizeLargeStats", "adaptorEthPortBySizeLargeStatsHist", "adaptorEthPortBySizeSmallStats", "adaptorEthPortBySizeSmallStatsHist", "adaptorEthPortErrStats", "adaptorEthPortErrStatsHist", "adaptorEthPortMcastStats", "adaptorEthPortMcastStatsHist", "adaptorEthPortOutsizedStats", "adaptorEthPortOutsizedStatsHist", "adaptorEthPortStats", "adaptorEthPortStatsHist", "adaptorEthQueueProfile", "adaptorEthRecvQueueProfile", "adaptorEthRoCEProfile", "adaptorEthVxLANProfile", "adaptorEthWorkQueueProfile", "adaptorEtherIfStats", "adaptorEtherIfStatsHist", "adaptorExtEthIf", "adaptorExtEthIfOperation", "adaptorExtIf", "adaptorExtIpV6RssHashProfile", "adaptorFcCdbWorkQueueProfile", "adaptorFcErrorRecoveryProfile", "adaptorFcFnicProfile", "adaptorFcIfEventStats", "adaptorFcIfEventStatsHist", "adaptorFcIfFC4Stats", "adaptorFcIfFC4StatsHist", "adaptorFcIfFrameStats", "adaptorFcIfFrameStatsHist", "adaptorFcInterruptProfile", "adaptorFcLogiProfile", "adaptorFcPortFLogiProfile", "adaptorFcPortPLogiProfile", "adaptorFcPortProfile", "adaptorFcPortStats", "adaptorFcPortStatsHist", "adaptorFcQueueProfile", "adaptorFcRecvQueueProfile", "adaptorFcWorkQueueProfile", "adaptorFruCapProvider", "adaptorHBAVnicStats", "adaptorHBAVnicStatsHist", "adaptorHostEthIf", "adaptorHostEthIfOperation", "adaptorHostEthIfProfile", "adaptorHostFcIf", "adaptorHostFcIfOperation", "adaptorHostFcIfProfile", "adaptorHostIf", "adaptorHostIfConfig", "adaptorHostIfConnDef", "adaptorHostIfProfile", "adaptorHostIscsiIf", "adaptorHostIscsiIfOperation", "adaptorHostIscsiIfProfile", "adaptorHostScsiIf", "adaptorHostScsiLunRef", "adaptorHwAddrCap", "adaptorIScsiCap", "adaptorIpV4RssHashProfile", "adaptorIpV6RssHashProfile", "adaptorMenloBaseErrorStats", "adaptorMenloBaseErrorStatsHist", "adaptorMenloDcePortStats", "adaptorMenloDcePortStatsHist", "adaptorMenloEthErrorStats", "adaptorMenloEthErrorStatsHist", "adaptorMenloEthStats", "adaptorMenloEthStatsHist", "adaptorMenloFcErrorStats", "adaptorMenloFcErrorStatsHist", "adaptorMenloFcStats", "adaptorMenloFcStatsHist", "adaptorMenloHostPortStats", "adaptorMenloHostPortStatsHist", "adaptorMenloMcpuErrorStats", "adaptorMenloMcpuErrorStatsHist", "adaptorMenloMcpuStats", "adaptorMenloMcpuStatsHist", "adaptorMenloNetEgStats", "adaptorMenloNetEgStatsHist", "adaptorMenloNetInStats", "adaptorMenloNetInStatsHist", "adaptorMenloQErrorStats", "adaptorMenloQErrorStatsHist", "adaptorMenloQStats", "adaptorMenloQStatsHist", "adaptorNICVnicStats", "adaptorNICVnicStatsHist", "adaptorProfileItem", "adaptorProtocolProfile", "adaptorQual", "adaptorQueueProfile", "adaptorRnicCapSpec", "adaptorRssHashProfile", "adaptorRssProfile", "adaptorTcpIpRssHashProfile", "adaptorUnit", "adaptorUnitAssocCtx", "adaptorUnitExtn", "adaptorUsnicConnDef", "adaptorVlan", "adaptorVmmqConnDef", "adaptorVnicStats", "adaptorVnicStatsHist", "biosBOT", "biosBootDev", "biosBootDevGrp", "biosTokenFeatureGroup", "biosTokenParam", "biosTokenSettings", "biosUnit", "biosVFeat", "biosVProfile", "biosVfACPI10Support", "biosVfASPMSupport", "biosVfAllUSBDevices", "biosVfAltitude", "biosVfAssertNMIOnPERR", "biosVfAssertNMIOnSERR", "biosVfBootOptionRetry", "biosVfCPUHardwarePowerManagement", "biosVfCPUPerformance", "biosVfCPUPowerManagement", "biosVfConsistentDeviceNameControl", "biosVfConsoleRedirection", "biosVfCoreMultiProcessing", "biosVfDDR3VoltageSelection", "biosVfDRAMClockThrottling", "biosVfDirectCacheAccess", "biosVfDramRefreshRate", "biosVfEnergyPerformanceTuning", "biosVfEnhancedIntelSpeedStepTech", "biosVfEnhancedPowerCappingSupport", "biosVfExecuteDisableBit", "biosVfFRB2Timer", "biosVfFrequencyFloorOverride", "biosVfFrontPanelLockout", "biosVfIOEMezz1OptionROM", "biosVfIOENVMe1OptionROM", "biosVfIOENVMe2OptionROM", "biosVfIOESlot1OptionROM", "biosVfIOESlot2OptionROM", "biosVfIntegratedGraphics", "biosVfIntegratedGraphicsApertureSize", "biosVfIntelEntrySASRAIDModule", "biosVfIntelHyperThreadingTech", "biosVfIntelTrustedExecutionTechnology", "biosVfIntelTurboBoostTech", "biosVfIntelVTForDirectedIO", "biosVfIntelVirtualizationTechnology", "biosVfInterleaveConfiguration", "biosVfLocalX2Apic", "biosVfLvDIMMSupport", "biosVfMaxVariableMTRRSetting", "biosVfMaximumMemoryBelow4GB", "biosVfMemoryMappedIOAbove4GB", "biosVfMirroringMode", "biosVfNUMAOptimized", "biosVfOSBootWatchdogTimer", "biosVfOSBootWatchdogTimerPolicy", "biosVfOSBootWatchdogTimerTimeout", "biosVfOnboardGraphics", "biosVfOnboardSATAController", "biosVfOnboardStorage", "biosVfOptionROMEnable", "biosVfOptionROMLoad", "biosVfOutOfBandManagement", "biosVfPCHSATAMode", "biosVfPCILOMPortsConfiguration", "biosVfPCIROMCLP", "biosVfPCISlotLinkSpeed", "biosVfPCISlotOptionROMEnable", "biosVfPOSTErrorPause", "biosVfPSTATECoordination", "biosVfPackageCStateLimit", "biosVfProcessorC1E", "biosVfProcessorC3Report", "biosVfProcessorC6Report", "biosVfProcessorC7Report", "biosVfProcessorCMCI", "biosVfProcessorCState", "biosVfProcessorEnergyConfiguration", "biosVfProcessorPrefetchConfig", "biosVfQPILinkFrequencySelect", "biosVfQPISnoopMode", "biosVfQuietBoot", "biosVfRedirectionAfterBIOSPOST", "biosVfResumeOnACPowerLoss", "biosVfSBMezz1OptionROM", "biosVfSBNVMe1OptionROM", "biosVfSIOC1OptionROM", "biosVfSIOC2OptionROM", "biosVfScrubPolicies", "biosVfSelectMemoryRASConfiguration", "biosVfSerialPortAEnable", "biosVfSparingMode", "biosVfSriovConfig", "biosVfTPMPendingOperation", "biosVfTPMSupport", "biosVfTrustedPlatformModule", "biosVfUCSMBootModeControl", "biosVfUCSMBootOrderRuleControl", "biosVfUEFIOSUseLegacyVideo", "biosVfUSBBootConfig", "biosVfUSBConfiguration", "biosVfUSBFrontPanelAccessLock", "biosVfUSBPortConfiguration", "biosVfUSBSystemIdlePowerOptimizingSetting", "biosVfVGAPriority", "biosVfWorkloadConfiguration", "callhomeDest", "callhomeEp", "callhomeFaultInst", "callhomeHolder", "callhomeHolderFsm", "callhomeHolderFsmStage", "callhomeHolderFsmTask", "callhomeHttp", "callhomeItem", "callhomePeriodicSystemInventory", "callhomePolicy", "callhomeProfile", "callhomeSmtp", "callhomeSource", "callhomeTestAlert", "capabilityCatalogue", "capabilityDef", "capabilityItem", "capabilityProvider", "certRepairEp", "certRepairEpFsm", "certRepairEpFsmStage", "certRepairEpFsmTask", "changeChangedObjectRef", "changeEp", "changeEpFsm", "changeEpFsmStage", "changeEpFsmTask", "cimcvmediaActualMountEntry", "cimcvmediaActualMountList", "cimcvmediaConfigMountEntry", "cimcvmediaExtMgmtRuleEntry", "cimcvmediaItem", "cimcvmediaMountConfig", "cimcvmediaMountConfigDef", "cimcvmediaMountConfigPolicy", "cimcvmediaMountInfo", "clitestTypeTest", "clitestTypeTest2", "clitestTypeTestChild", "clitestTypeTestParent", "commCimxml", "commClient", "commClientItem", "commCoreFile", "commDateTime", "commDateTimeFsm", "commDateTimeFsmStage", "commDateTimeFsmTask", "commDefinition", "commDns", "commDnsProvider", "commEvtChannel", "commHttp", "commHttps", "commItem", "commLocale", "commLogComponent", "commNtp", "commNtpProvider", "commShell", "commShellSvcLimits", "commSmashCLP", "commSnmp", "commSnmpCommunity", "commSnmpTrap", "commSnmpTrapData", "commSnmpUser", "commSsh", "commSvc", "commSvcChannel", "commSvcEp", "commSvcEpFsm", "commSvcEpFsmStage", "commSvcEpFsmTask", "commSvcLimits", "commSvcPolicy", "commSyslog", "commSyslogClient", "commSyslogConsole", "commSyslogFile", "commSyslogMonitor", "commSyslogSource", "commTelnet", "commWeb", "commWebChannel", "commWebSvcLimits", "commWsman", "commXmlClConnPolicy", "computeABoard", "computeAChassisDiscPolicy", "computeAOperation", "computeAutoconfigPolicy", "computeBaseSystem", "computeBlade", "computeBladeDiscPolicy", "computeBladeEp", "computeBladeInheritPolicy", "computeBladePosQual", "computeBoard", "computeBoardConnector", "computeBoardController", "computeCartridge", "computeCartridgeOperation", "computeChassisConnPolicy", "computeChassisConnPolicyOperation", "computeChassisDiscPolicy", "computeChassisFeatMask", "computeChassisQual", "computeComputeDiscPolicy", "computeConfigPolicy", "computeContainer", "computeDefinition", "computeDiscPolicy", "computeDomainGroupQual", "computeDomainHwChangeDiscPolicy", "computeDomainNameQual", "computeDomainPortDiscPolicy", "computeDomainQual", "computeEnvFeatMask", "computeExtBoard", "computeFabricEthMonSrcEp", "computeFabricEthMonSrcEpCont", "computeFabricFcMonSrcEp", "computeFabricFcMonSrcEpCont", "computeFabricMonSrcEp", "computeFactoryResetOp", "computeFactoryResetOperation", "computeFaultUpgradeFlag", "computeFeatMask", "computeGraphicsCardPolicy", "computeGroupMembership", "computeGroupMembershipRef", "computeHwChangeDiscPolicy", "computeIOHub", "computeIOHubEnvStats", "computeIOHubEnvStatsHist", "computeInitConfigPolicy", "computeInstance", "computeInstanceIdQual", "computeInstanceMapping", "computeItem", "computeLocalTemplDef", "computeLogical", "computeMbPowerStats", "computeMbPowerStatsHist", "computeMbTempStats", "computeMbTempStatsHist", "computeNetworkFeatMask", "computeOwnerQual", "computePCIeFatalCompletionStats", "computePCIeFatalCompletionStatsHist", "computePCIeFatalProtocolStats", "computePCIeFatalProtocolStatsHist", "computePCIeFatalReceiveStats", "computePCIeFatalReceiveStatsHist", "computePCIeFatalStats", "computePCIeFatalStatsHist", "computePhysical", "computePhysicalAssocCtx", "computePhysicalExtension", "computePhysicalOperation", "computePhysicalQual", "computePlaceable", "computePlaced", "computePool", "computePoolPolicyRef", "computePoolable", "computePooled", "computePooledEnclosureComputeSlot", "computePooledPhysical", "computePooledRackUnit", "computePooledSlot", "computePoolingPolicy", "computePortDiscPolicy", "computePowerSyncDef", "computePowerSyncPolicy", "computeProductFamilyQual", "computeProfile", "computePsuDef", "computePsuPolicy", "computeQual", "computeQualBase", "computeQualItem", "computeQualifiedPolicy", "computeRackPosQual", "computeRackQual", "computeRackUnit", "computeRackUnitMbTempStats", "computeRackUnitMbTempStatsHist", "computeRebootLog", "computeRemoteOpStatus", "computeRequirement", "computeResourceAggrEp", "computeResourceSet", "computeResourceSetManager", "computeResourceSetMember", "computeScrubPolicy", "computeServer", "computeServerDiscPolicy", "computeServerFeatMask", "computeServerMgmtPolicy", "computeServerUnit", "computeSession", "computeSiteQual", "computeSlotEntity", "computeSlotQual", "computeStorageFeatMask", "computeSystem", "computeSystemAddrQual", "computeSystemFsm", "computeSystemFsmStage", "computeSystemFsmTask", "computeSystemQual", "computeTemplate", "computeTemplateMapping", "computeUser", "computeUserEp", "conditionImmutable", "conditionInfo", "conditionLog", "conditionLoggable", "conditionMultiInstanceImmutable", "conditionMutable", "conditionPolicy", "conditionReportable", "configAbsDbConfig", "configAckItem", "configAdaptorItem", "configAppImpactResponse", "configBackup", "configBackupFsm", "configBackupFsmStage", "configBackupFsmTask", "configCartridgeFilter", "configCartridgeItem", "configCatalogue", "configChassisFilter", "configChassisItem", "configComponentsFilter", "configConsumerCatalogue", "configConsumerCatalogueFsm", "configConsumerCatalogueFsmStage", "configConsumerCatalogueFsmTask", "configControllerItem", "configCpuInfo", "configCpuItem", "configCryptoCardItem", "configDbConfig", "configDomainFilter", "configDomainItem", "configFabricInterconnectFilter", "configFabricInterconnectItem", "configFanItem", "configFexFilter", "configFexItem", "configFilterGroup", "configFilterItem", "configFsm", "configFsmStage", "configGraphicsCardItem", "configIOMItem", "configImpact", "configImpactAnalyzer", "configImpactAnalyzerEp", "configImpactResponse", "configInputConfig", "configInputConfigSet", "configLocalDiskItem", "configLunItem", "configManagedEpImpactResponse", "configMemoryItem", "configMotherboardItem", "configNetRefItem", "configOrgItem", "configPSUItem", "configPolicyUsageItem", "configPortItem", "configSearchOptions", "configSearchResult", "configServerFilter", "configServerItem", "configServiceProfileFilter", "configSorter", "configSpotLightItem", "configStorageArrayProfileFilter", "configStorageBladeFilter", "configStorageItem", "configUCImpact", "consumerInst", "consumerInstFsm", "consumerInstFsmStage", "consumerInstFsmTask", "consumerUniverse", "controllerEp", "controllerEpFsm", "controllerEpFsmStage", "controllerEpFsmTask", "cpmaintAck", "cpmaintMaintPolicy", "dcxVIf", "dcxVc", "diagCtrl", "diagLogEp", "diagMemoryTest", "diagRslt", "diagRunPolicy", "diagSrvCapProvider", "diagSrvCtrl", "diagSrvCtrlOperation", "diagSrvCtrlOperationFsm", "diagSrvCtrlOperationFsmStage", "diagSrvCtrlOperationFsmTask", "diagTest", "domainChassisFeature", "domainChassisParam", "domainChassisProfileItem", "domainEnvironmentFeature", "domainEnvironmentParam", "domainEp", "domainFamilyCapProvider", "domainFeature", "domainFeatureCatalog", "domainNetworkFeature", "domainNetworkParam", "domainParameter", "domainProfile", "domainProfileFsm", "domainProfileFsmStage", "domainProfileFsmTask", "domainServerFeature", "domainServerParam", "domainServiceProfileItem", "domainStorageFeature", "domainStorageParam", "dpsecMac", "dupeChangeTracker", "dupeChangeTrackerEp", "dupeChangeTrackerEpFsm", "dupeChangeTrackerEpFsmStage", "dupeChangeTrackerEpFsmTask", "dupeEp", "dupeExtRequestor", "dupeIntRequestor", "dupeRequestor", "dupeScope", "dupeScopeEp", "dupeScopeResult", "epqosDefinition", "epqosEgress", "epqosItem", "equipmentABehCap", "equipmentAdvancedBootOrder", "equipmentAssocCtx", "equipmentBeaconLed", "equipmentBehCap", "equipmentBinding", "equipmentBladeCapProvider", "equipmentBreakoutCap", "equipmentCPMeta", "equipmentCard", "equipmentCartridgeCapProvider", "equipmentChassis", "equipmentChassisAssocCtx", "equipmentChassisCapProvider", "equipmentChassisIssues", "equipmentChassisOperation", "equipmentChassisPosQual", "equipmentChassisProfile", "equipmentChassisProfileAssocCtx", "equipmentChassisProfileBinding", "equipmentChassisProfileFsm", "equipmentChassisProfileFsmStage", "equipmentChassisProfileFsmTask", "equipmentChassisQual", "equipmentChassisRequirement", "equipmentChassisStats", "equipmentChassisStatsHist", "equipmentCimcVmedia", "equipmentComputeConn", "equipmentComputeConnPolicy", "equipmentComputePhysicalCapProvider", "equipmentDefinition", "equipmentDriveSecCap", "equipmentFan", "equipmentFanModule", "equipmentFanModuleCapProvider", "equipmentFanModuleStats", "equipmentFanModuleStatsHist", "equipmentFanStats", "equipmentFanStatsHist", "equipmentFex", "equipmentFexCapProvider", "equipmentFexEnvStats", "equipmentFexEnvStatsHist", "equipmentFexOperation", "equipmentFexPowerSummary", "equipmentFexPowerSummaryHist", "equipmentFexPsuInputStats", "equipmentFexPsuInputStatsHist", "equipmentFruCapProvider", "equipmentFruVariant", "equipmentGemCapProvider", "equipmentHealthLed", "equipmentHolder", "equipmentHolderCapProvider", "equipmentHostIfCapProvider", "equipmentHwCapProvider", "equipmentIOCard", "equipmentIOCardBase", "equipmentIOCardCapProvider", "equipmentIOCardStats", "equipmentIOCardStatsHist", "equipmentImpliedStorageEnclosureDef", "equipmentIndicatorLed", "equipmentInstance", "equipmentInstanceMapping", "equipmentIntegratedComponentCapProvider", "equipmentItem", "equipmentLed", "equipmentLocalDiskCapProvider", "equipmentLocalDiskControllerCapProvider", "equipmentLocalDiskDef", "equipmentLocalTemplDef", "equipmentLocatorLed", "equipmentLocatorLedOperation", "equipmentManufacturingDef", "equipmentMemoryUnitCapProvider", "equipmentNetworkElementFanStats", "equipmentNetworkElementFanStatsHist", "equipmentPciDef", "equipmentPhysicalQual", "equipmentPicture", "equipmentPlaceable", "equipmentPlaced", "equipmentPool", "equipmentPoolable", "equipmentPooled", "equipmentPoolingPolicy", "equipmentProcessorUnitCapProvider", "equipmentPsu", "equipmentPsuCapProvider", "equipmentPsuInputStats", "equipmentPsuInputStatsHist", "equipmentPsuOutputStats", "equipmentPsuOutputStatsHist", "equipmentPsuStats", "equipmentPsuStatsHist", "equipmentQual", "equipmentQualBase", "equipmentQualItem", "equipmentQualifiedPolicy", "equipmentRackUnitCapProvider", "equipmentRackUnitFanStats", "equipmentRackUnitFanStatsHist", "equipmentRackUnitPsuStats", "equipmentRackUnitPsuStatsHist", "equipmentRequirement", "equipmentSecureBoot", "equipmentServerFeatureCap", "equipmentServerUnitCapProvider", "equipmentSharedIOModule", "equipmentSiocTempStats", "equipmentSiocTempStatsHist", "equipmentSlotEnclosure", "equipmentStateful", "equipmentStatefulBladeComp", "equipmentStatefulChComp", "equipmentStorageProcessorCap", "equipmentSwitchCapProvider", "equipmentSwitchCard", "equipmentSwitchIOCard", "equipmentSwitchIOCardCapProvider", "equipmentSystemFruCapProvider", "equipmentSystemIOController", "equipmentSystemIOControllerOperation", "equipmentTemplate", "equipmentTemplateMapping", "equipmentTier", "equipmentUnifiedPortCapProvider", "equipmentXcvr", "etherErrStats", "etherErrStatsHist", "etherFcoeInterfaceStats", "etherFcoeInterfaceStatsHist", "etherLossStats", "etherLossStatsHist", "etherPIo", "etherPauseStats", "etherPauseStatsHist", "etherRxStats", "etherRxStatsHist", "etherServerIntFIo", "etherSwitchIntFIo", "etherTxStats", "etherTxStatsHist", "eventApplication", "eventEpCtrl", "eventHolder", "eventInst", "eventLog", "eventPolicy", "eventRecord", "extmgmtArpTargets", "extmgmtGatewayPing", "extmgmtIfMonPolicy", "extmgmtMiiStatus", "extmgmtNdiscTargets", "extpolClient", "extpolClientCont", "extpolClientFsm", "extpolClientFsmStage", "extpolClientFsmTask", "extpolConnector", "extpolConnectorContainer", "extpolController", "extpolControllerCont", "extpolDomain", "extpolEp", "extpolEpFsm", "extpolEpFsmStage", "extpolEpFsmTask", "extpolHBStatus", "extpolProvider", "extpolProviderCont", "extpolRegistry", "extpolRegistryCapability", "extpolSvc", "extpolSystemContext", "extpolVersionHolder", "extvmmNetworkSets", "extvmmVMNetworkSets", "fabricADceSwSrvEp", "fabricAEthEstcEp", "fabricAEthLanEp", "fabricAFcEstcEp", "fabricAFcSanEp", "fabricAFcoeEstcEp", "fabricAFcoeSanEp", "fabricAGroupReq", "fabricANetGroup", "fabricANetGroupRef", "fabricASanGroup", "fabricAVlan", "fabricAVsan", "fabricBaseNetGroup", "fabricBasePhEp", "fabricBaseSlotEp", "fabricBreakout", "fabricBreakoutOperation", "fabricCIoEp", "fabricCabling", "fabricCablingSw", "fabricCartridgeSlotEp", "fabricCartridgeSlotEpOperation", "fabricCdpLinkPolicy", "fabricChangedObjectRef", "fabricChassisEp", "fabricCloud", "fabricComputeEp", "fabricComputeMSlotEp", "fabricComputePhEp", "fabricComputePhEpOperation", "fabricComputeSlotEp", "fabricComputeSlotEpOperation", "fabricConsumer", "fabricDceSrv", "fabricDceSwSrv", "fabricDceSwSrvEp", "fabricDceSwSrvEpOperation", "fabricDceSwSrvPc", "fabricDceSwSrvPcEp", "fabricDceSwSrvPcEpOperation", "fabricDceSwSrvPcOperation", "fabricDceSwSrvPcOperationFsm", "fabricDceSwSrvPcOperationFsmStage", "fabricDomain", "fabricDomainEp", "fabricEnclosurePhEp", "fabricEnclosurePhEpOperation", "fabricEnclosureSlotEp", "fabricEnclosureSlotEpOperation", "fabricEp", "fabricEpVlan", "fabricEpVsan", "fabricEquipmentEp", "fabricEstcEp", "fabricEstcPc", "fabricEthCdpPolicy", "fabricEthEstc", "fabricEthEstcCloud", "fabricEthEstcEp", "fabricEthEstcEpOperation", "fabricEthEstcEpOperationFsm", "fabricEthEstcEpOperationFsmStage", "fabricEthEstcPc", "fabricEthEstcPcEp", "fabricEthEstcPcEpOperation", "fabricEthEstcPcOperation", "fabricEthEstcPcOperationFsm", "fabricEthEstcPcOperationFsmStage", "fabricEthLan", "fabricEthLanEp", "fabricEthLanEpOperation", "fabricEthLanEpOperationFsm", "fabricEthLanEpOperationFsmStage", "fabricEthLanPc", "fabricEthLanPcEp", "fabricEthLanPcEpOperation", "fabricEthLanPcOperation", "fabricEthLanPcOperationFsm", "fabricEthLanPcOperationFsmStage", "fabricEthLinkPolicy", "fabricEthLinkProfile", "fabricEthMon", "fabricEthMonDestEp", "fabricEthMonDestEpOperation", "fabricEthMonLan", "fabricEthMonOperation", "fabricEthMonOperationFsm", "fabricEthMonOperationFsmStage", "fabricEthMonSrcEp", "fabricEthMonSrcEpOperation", "fabricEthMonSrcRef", "fabricEthPortOperation", "fabricEthPortOperationFsm", "fabricEthPortOperationFsmStage", "fabricEthTargetEp", "fabricEthTargetEpOperation", "fabricEthUdldPolicy", "fabricEthVlanPc", "fabricEthVlanPortEp", "fabricEtherRef", "fabricExtension", "fabricExternal", "fabricExternalEp", "fabricExternalEstc", "fabricExternalPc", "fabricFIPortOperation", "fabricFIPortOperationFsm", "fabricFIPortOperationFsmStage", "fabricFIPortOperationFsmTask", "fabricFcEndpoint", "fabricFcEstc", "fabricFcEstcCloud", "fabricFcEstcEp", "fabricFcEstcEpOperation", "fabricFcEstcEpOperationFsm", "fabricFcEstcEpOperationFsmStage", "fabricFcMon", "fabricFcMonDestEp", "fabricFcMonDestEpOperation", "fabricFcMonOperation", "fabricFcMonOperationFsm", "fabricFcMonOperationFsmStage", "fabricFcMonSan", "fabricFcMonSrcEp", "fabricFcMonSrcEpOperation", "fabricFcMonSrcRef", "fabricFcPortOperation", "fabricFcPortOperationFsm", "fabricFcPortOperationFsmStage", "fabricFcSan", "fabricFcSanEp", "fabricFcSanEpOperation", "fabricFcSanEpOperationFsm", "fabricFcSanEpOperationFsmStage", "fabricFcSanPc", "fabricFcSanPcEp", "fabricFcSanPcEpOperation", "fabricFcSanPcOperation", "fabricFcSanPcOperationFsm", "fabricFcSanPcOperationFsmStage", "fabricFcUplinkOperation", "fabricFcUserZone", "fabricFcUserZoneIvt", "fabricFcVsanPc", "fabricFcVsanPortEp", "fabricFcZoneProfile", "fabricFcZoneProfileFsm", "fabricFcZoneProfileFsmStage", "fabricFcZoneProfileFsmTask", "fabricFcZoneProfileIvt", "fabricFcoeEstcEp", "fabricFcoeEstcEpOperation", "fabricFcoeEstcEpOperationFsm", "fabricFcoeEstcEpOperationFsmStage", "fabricFcoeSanEp", "fabricFcoeSanEpOperation", "fabricFcoeSanEpOperationFsm", "fabricFcoeSanEpOperationFsmStage", "fabricFcoeSanPc", "fabricFcoeSanPcEp", "fabricFcoeSanPcEpOperation", "fabricFcoeSanPcOperation", "fabricFcoeSanPcOperationFsm", "fabricFcoeSanPcOperationFsmStage", "fabricFcoeVsanPc", "fabricFcoeVsanPortEp", "fabricHolder", "fabricIf", "fabricInternal", "fabricInternalDceSrv", "fabricInternalEp", "fabricInternalPc", "fabricLacpPolicy", "fabricLan", "fabricLanAccessMgr", "fabricLanCloud", "fabricLanCloudPolicy", "fabricLanEp", "fabricLanMonCloud", "fabricLanPc", "fabricLanPinGroup", "fabricLanPinGroupOperation", "fabricLanPinTarget", "fabricLanPinTargetOperation", "fabricLastAckedSlot", "fabricLinkPolicy", "fabricMon", "fabricMonDestEp", "fabricMonSrcEp", "fabricMonSrcRef", "fabricMulticastPolicy", "fabricNetGroup", "fabricNetGroupEp", "fabricNetGroupPermit", "fabricNetGroupRef", "fabricNetGroupReq", "fabricOrgVlanPolicy", "fabricPIoEp", "fabricPinGroup", "fabricPinTarget", "fabricPoolableVlan", "fabricPooledVlan", "fabricSan", "fabricSanCloud", "fabricSanEp", "fabricSanGroup", "fabricSanGroupRef", "fabricSanMonCloud", "fabricSanPc", "fabricSanPinGroup", "fabricSanPinGroupOperation", "fabricSanPinTarget", "fabricSanPinTargetOperation", "fabricSubGroup", "fabricSwChEp", "fabricSwChPhEp", "fabricSwChPhEpOperation", "fabricSwSrvEp", "fabricSwSrvPc", "fabricSwSubGroup", "fabricSystem", "fabricTargetEp", "fabricUdldLinkPolicy", "fabricUdldPolicy", "fabricVCon", "fabricVConProfile", "fabricVlan", "fabricVlanEp", "fabricVlanGroupReq", "fabricVlanPermit", "fabricVlanPermitItem", "fabricVlanReq", "fabricVnetEp", "fabricVnetEpSyncEp", "fabricVnetEpSyncEpFsm", "fabricVnetEpSyncEpFsmStage", "fabricVnetEpSyncEpFsmTask", "fabricVnetGroupReq", "fabricVnetReq", "fabricVsan", "fabricVsanEp", "fabricVsanMembership", "faultBaseHolder", "faultBasePolicy", "faultBaseTypedHolder", "faultDomainEp", "faultDomainInst", "faultGlobalSeverityHolder", "faultGlobalTypedHolder", "faultHolder", "faultInst", "faultLocalBaseHolder", "faultLocalTypedHolder", "faultPolicy", "faultSummary", "faultSummaryInst", "faultSvcSummary", "faultTypedHolder", "fcErrStats", "fcErrStatsHist", "fcPIo", "fcStats", "fcStatsHist", "fcpoolAddr", "fcpoolBlock", "fcpoolBootTarget", "fcpoolFormat", "fcpoolInitiator", "fcpoolInitiatorEp", "fcpoolInitiators", "fcpoolUniverse", "fdBlade", "fdBladeFsm", "fdBladeFsmStage", "fdChassis", "fdOperable", "fdPhysical", "fdPhysicalFsm", "fdPhysicalFsmStage", "fdPhysicalFsmTask", "fdRackUnit", "fdRackUnitFsm", "fdRackUnitFsmStage", "featureCatalogEp", "featureChassisDef", "featureDefinition", "featureEnvDef", "featureNetworkDef", "featureServerDef", "featureStorageDef", "firmwareAComponentSpec", "firmwareAExcludeComponent", "firmwareAInfraPack", "firmwareAck", "firmwareAutoSyncPolicy", "firmwareBootDefinition", "firmwareBootUnit", "firmwareBundleInfo", "firmwareBundleInfoDigest", "firmwareBundleType", "firmwareBundleTypeCapProvider", "firmwareCapProvider", "firmwareCatalogPack", "firmwareCatalogPackConfig", "firmwareCatalogue", "firmwareChassisComponentSpec", "firmwareChassisPack", "firmwareCompItem", "firmwareCompSource", "firmwareCompTarget", "firmwareComponentSpec", "firmwareComputeHostPack", "firmwareComputeMgmtPack", "firmwareComputePack", "firmwareComputeStoragePack", "firmwareConnectionPolicy", "firmwareDependency", "firmwareDistImage", "firmwareDistributable", "firmwareDistributableFsm", "firmwareDistributableFsmStage", "firmwareDistributableFsmTask", "firmwareDomainInfo", "firmwareDomainInfraProfile", "firmwareDownloadPolicy", "firmwareDownloader", "firmwareDownloaderFsm", "firmwareDownloaderFsmStage", "firmwareDownloaderFsmTask", "firmwareExcludeChassisComponent", "firmwareExcludeServerComponent", "firmwareImage", "firmwareInfra", "firmwareInfraPack", "firmwareInfraPackConfig", "firmwareInfraPolicy", "firmwareInstallImpact", "firmwarePack", "firmwarePolicy", "firmwareProductFamily", "firmwareRemoteCatalogue", "firmwareRunning", "firmwareSource", "firmwareStatus", "firmwareStoragePack", "firmwareSystem", "firmwareType", "firmwareUnit", "firmwareUpdatable", "firmwareUpgradeDetail", "firmwareUpgradeInfo", "flowctrlDefinition", "flowctrlItem", "fsmFsm", "fsmStage", "fsmStatus", "fsmTask", "glAbsConflict", "glAbsEp", "glAbsIdentCtxOp", "glAbsInv", "glAbsOperation", "glAbsPolicyInv", "glAbsPolicyOp", "glAbsPolicyRule", "glAbsRequest", "glAbsResEp", "glAbsRule", "glAbsVnetInv", "glAppendRule", "glBlockEp", "glBlockOp", "glByMo", "glComplexRefEp", "glConflictEp", "glConflictResolutionRuleEp", "glDomainEp", "glEp", "glGlobalDefaultPolicyEp", "glIdRef", "glIdRefEp", "glIdable", "glIdentCtxEp", "glIdentCtxOp", "glIdentCtxResOp", "glIdentCtxResOpFsm", "glIdentCtxResOpFsmStage", "glIdentCtxResOpFsmTask", "glInventoryEp", "glLsp", "glMcastPolicy", "glOperationEp", "glPathEp", "glPolicy", "glPolicyAlgorithmedOp", "glPolicyEp", "glPolicyInvEp", "glPolicyNameRuleEp", "glPolicyOp", "glPolicyRef", "glPolicyRefEp", "glPolicyResOp", "glPolicyResolutionEp", "glPool", "glPoolEp", "glPoolInvEp", "glPoolOp", "glRefable", "glRefsEp", "glRequest", "glRequestFsm", "glRequestFsmStage", "glRequestFsmTask", "glRequestVnetEp", "glRequestVnetEpDomainEp", "glRequestVnetEpDomainEpFsm", "glRequestVnetEpDomainEpFsmStage", "glRequestVnetEpDomainEpFsmTask", "glRequestVnetEpFsm", "glRequestVnetEpFsmStage", "glRequestVnetEpFsmTask", "glRequestVnetEpHolder", "glRequestor", "glRequestorEp", "glSPInvEp", "glServerPoolResOp", "glServiceProfile", "glSpDefEp", "glTemplateEp", "glTemplateOp", "glTemplateResOp", "glUsage", "glUsageEp", "glVlan", "glVnetInvHolder", "glVnicTemplate", "glVnicTemplateEp", "glVsan", "glVxanEp", "glVxanOp", "glVxanResOp", "gmetaClass", "gmetaPolicyMapElement", "gmetaProp", "graphicsCard", "graphicsController", "guiGuiComponent", "guiGuiCont", "hcAComponent", "hcAItem", "hcAStatusItem", "hcAdapterFirmwareItem", "hcAdapterItem", "hcAdmin", "hcCatalog", "hcCatalogList", "hcCatalogSource", "hcCatalogVersion", "hcCleanup", "hcDownloadPolicy", "hcDownloader", "hcDriverInfoItem", "hcDriverItem", "hcHolder", "hcItemNote", "hcOsInfoItem", "hcOsItem", "hcReport", "hcScopeDn", "hcServerComponent", "hcSupportedAdapterFirmwareItem", "hcSupportedAdapterItem", "hcSupportedDriverItem", "hcSupportedOsItem", "hcUcsVersionItem", "identDomainSyncEp", "identExecutionEp", "identExecutionRequestEp", "identIdentCtx", "identIdentRequest", "identIdentRequestFsm", "identIdentRequestFsmStage", "identIdentRequestFsmTask", "identMetaSystem", "identMetaSystemFsm", "identMetaSystemFsmStage", "identMetaSystemFsmTask", "identMetaVerse", "identRequestEp", "identSysInfo", "identpoolBlockQual", "identpoolConsumed", "identpoolDomain", "identpoolDomainGroupQual", "identpoolElement", "identpoolIPQual", "identpoolIPV6Qual", "identpoolMetaSystem", "identpoolMetaVerse", "identpoolPool", "identpoolPoolable", "identpoolQualItem", "identpoolUniverse", "inbandPolicy", "initiatorEp", "initiatorFcInitiatorEp", "initiatorGroupEp", "initiatorIScsiInitiatorEp", "initiatorInitiatorEp", "initiatorLunEp", "initiatorMemberEp", "initiatorRequestorEp", "initiatorRequestorGrpEp", "initiatorStoreEp", "initiatorUnitEp", "inventoryDomainEp", "inventoryEp", "inventoryGlobalEp", "inventoryHolder", "inventoryInventoryEp", "inventoryInventoryMoMeta", "ipIPv4Dns", "ipIpV4Addr", "ipIpV4StaticAddr", "ipServiceIf", "ippoolAddr", "ippoolBlock", "ippoolIpV6Addr", "ippoolIpV6Block", "ippoolIpV6Pooled", "ippoolPool", "ippoolPooled", "ippoolUniverse", "iqnpoolAbsBlock", "iqnpoolAddr", "iqnpoolBlock", "iqnpoolFormat", "iqnpoolPool", "iqnpoolPooled", "iqnpoolTransportBlock", "iqnpoolUniverse", "iscsiAuthProfile", "licenseCapProvider", "licenseContents", "licenseDomain", "licenseDownloader", "licenseDownloaderFsm", "licenseDownloaderFsmStage", "licenseDownloaderFsmTask", "licenseEp", "licenseFeature", "licenseFeatureCapProvider", "licenseFeatureLine", "licenseFile", "licenseFileFsm", "licenseFileFsmStage", "licenseFileFsmTask", "licenseInstance", "licenseInstanceFsm", "licenseInstanceFsmStage", "licenseInstanceFsmTask", "licenseLicense", "licenseProp", "licenseServerHostId", "licenseSource", "licenseSourceFile", "lsBinding", "lsComputeBinding", "lsFcLocale", "lsFcZone", "lsFcZoneGroup", "lsFcZoneMember", "lsIdentityInfo", "lsIssues", "lsPower", "lsRequirement", "lsSPMeta", "lsServer", "lsServerAssocCtx", "lsServerExtension", "lsServerFsm", "lsServerFsmStage", "lsServerFsmTask", "lsServerOperation", "lsTier", "lsVConAssign", "lsWaitingUserAck", "lsZoneInitiatorMember", "lsZoneTargetMember", "lsbootADef", "lsbootBootSecurity", "lsbootCategory", "lsbootDef", "lsbootDefaultLocalImage", "lsbootEFIShell", "lsbootEmbeddedLocalDiskImage", "lsbootEmbeddedLocalDiskImagePath", "lsbootEmbeddedLocalLunImage", "lsbootIScsi", "lsbootIScsiImagePath", "lsbootImage", "lsbootImagePath", "lsbootItem", "lsbootLan", "lsbootLanImagePath", "lsbootLocalDiskImage", "lsbootLocalDiskImagePath", "lsbootLocalHddImage", "lsbootLocalImage", "lsbootLocalLunImagePath", "lsbootLocalMediaItem", "lsbootLocalStorage", "lsbootNvme", "lsbootNvmeDevice", "lsbootNvmeDiskSsd", "lsbootNvmePciSsd", "lsbootPolicy", "lsbootRemoteImage", "lsbootSan", "lsbootSanCatSanImage", "lsbootSanCatSanImagePath", "lsbootSanImage", "lsbootSanImagePath", "lsbootStorage", "lsbootUEFIBootParam", "lsbootUpgradeStatus", "lsbootUsbExternalImage", "lsbootUsbFlashStorageImage", "lsbootUsbInternalImage", "lsbootVirtualMedia", "lsmaintAck", "lsmaintMaintPolicy", "lstorageASlot", "lstorageAck", "lstorageArrayRequirement", "lstorageBlade", "lstorageControllerDef", "lstorageControllerModeConfig", "lstorageControllerQualifier", "lstorageControllerRef", "lstorageCtrlServiceOperation", "lstorageDasScsiLun", "lstorageDiskGroupConfig", "lstorageDiskGroupConfigDef", "lstorageDiskGroupConfigPolicy", "lstorageDiskGroupQualifier", "lstorageDiskSlot", "lstorageDiskZoningConfig", "lstorageDiskZoningConfigDef", "lstorageDiskZoningPolicy", "lstorageDriveSecurity", "lstorageExtension", "lstorageItem", "lstorageLocal", "lstorageLocalConfig", "lstorageLocalDef", "lstorageLocalDiskConfigRef", "lstorageLocalDiskRef", "lstorageLogin", "lstorageMeta", "lstorageProcessorBase", "lstorageProfile", "lstorageProfileBase", "lstorageProfileBinding", "lstorageProfileBindingBase", "lstorageProfileDef", "lstorageQualItem", "lstorageRecurrWindow", "lstorageRemote", "lstorageRemoteConfig", "lstorageRemoteDef", "lstorageRequestCtx", "lstorageScsiLun", "lstorageSecurity", "lstorageVirtualDriveDef", "macpoolAddr", "macpoolBlock", "macpoolFormat", "macpoolPool", "macpoolPooled", "macpoolUniverse", "memoryArray", "memoryArrayEnvStats", "memoryArrayEnvStatsHist", "memoryBufferUnit", "memoryBufferUnitEnvStats", "memoryBufferUnitEnvStatsHist", "memoryController", "memoryErrorStats", "memoryErrorStatsHist", "memoryNvDimm", "memoryNvDimmBattery", "memoryNvDimmController", "memoryQual", "memoryRuntime", "memoryRuntimeHist", "memoryUnit", "memoryUnitEnvStats", "memoryUnitEnvStatsHist", "messageEntry", "messageEp", "mgmtAKmipCertPolicy", "mgmtASecureBoot", "mgmtAbsBackup", "mgmtAbsDataItem", "mgmtAbsImporter", "mgmtBackup", "mgmtBackupFsm", "mgmtBackupFsmStage", "mgmtBackupFsmTask", "mgmtBackupOperation", "mgmtBackupPolicy", "mgmtBackupTrigger", "mgmtBackupTriggerFsm", "mgmtBackupTriggerFsmStage", "mgmtBackupTriggerFsmTask", "mgmtCfgExportPolicy", "mgmtCimcInterface", "mgmtCmcSecureBoot", "mgmtCmcSecureBootOperation", "mgmtConnection", "mgmtController", "mgmtDataExporter", "mgmtDataExporterFsm", "mgmtDataExporterFsmStage", "mgmtDataExporterFsmTask", "mgmtDataImporter", "mgmtDataImporterFsm", "mgmtDataImporterFsmStage", "mgmtDataImporterFsmTask", "mgmtDataItem", "mgmtEntity", "mgmtEp", "mgmtExportPolicy", "mgmtIPv6Addr", "mgmtIPv6IfAddr", "mgmtIPv6IfConfig", "mgmtIf", "mgmtIfFsm", "mgmtIfFsmStage", "mgmtIfFsmTask", "mgmtImportItem", "mgmtImporter", "mgmtImporterFsm", "mgmtImporterFsmStage", "mgmtImporterFsmTask", "mgmtInbandProfile", "mgmtInterface", "mgmtKmip", "mgmtKmipCertPolicy", "mgmtKmipOperation", "mgmtNamedKmipCertPolicy", "mgmtRegistryInfo", "mgmtRegistryInfoFsm", "mgmtRegistryInfoFsmStage", "mgmtRegistryInfoFsmTask", "mgmtSecurity", "mgmtSvc", "mgmtVnet", "moTopProps", "namingBinding", "namingDefinition", "namingHolder", "namingNamedIdentifiedObject", "namingNamedObject", "namingObject", "netNetGroupPermit", "networkCACert", "networkCIoEp", "networkConn", "networkElement", "networkElementFsm", "networkElementFsmStage", "networkElementFsmTask", "networkElementOperation", "networkEp", "networkIfEp", "networkPIoEp", "networkPhysEp", "networkSystemCACert", "networkVnetEp", "nfsClientDef", "nfsClientDefFsm", "nfsClientDefFsmStage", "nfsClientDefFsmTask", "nfsEp", "nfsExportDef", "nfsExportDefFsm", "nfsExportDefFsmStage", "nfsExportDefFsmTask", "nfsMountDef", "nfsRepositorySpecPolicy", "nwctrlDefinition", "observeFilter", "observeObserved", "observeObservedCont", "observeObservedFsm", "observeObservedFsmStage", "observeObservedFsmTask", "orgAOrg", "orgDomainFirmwareInfo", "orgDomainGroup", "orgDomainGroupFirmwareReport", "orgDomainGroupPolicy", "orgDomainGroupPolicyReport", "orgDomainGroupReport", "orgExtension", "orgFirmwareVersionCount", "orgMaintTagFirmwareReport", "orgOrg", "orgOrgFsm", "orgOrgFsmStage", "orgOrgFsmTask", "orgOrgSource", "orgSourceMask", "osController", "osEthBondIntf", "osEthBondMode", "osEthIntf", "osInstance", "osIntf", "osLinkMonitoringPolicy", "osPrimarySlave", "pciCard", "pkiCertReq", "pkiDefinition", "pkiEp", "pkiEpFsm", "pkiEpFsmStage", "pkiEpFsmTask", "pkiItem", "pkiKeyRing", "pkiTP", "policyADestEp", "policyAckSuspendOperation", "policyBinding", "policyChildClass", "policyCluster", "policyCommunication", "policyCommunicationOp", "policyConfigBackup", "policyConfigBackupOp", "policyConfigError", "policyContext", "policyControl", "policyControlEp", "policyControlEpOp", "policyControlEpOpFsm", "policyControlEpOpFsmStage", "policyControlEpOpFsmTask", "policyControlEpOperation", "policyControlOp", "policyControlled", "policyControlledInstance", "policyControlledType", "policyDateTime", "policyDateTimeOp", "policyDefinition", "policyDestClass", "policyDestEp", "policyDeviceProfile", "policyDigest", "policyDiscovery", "policyDiscoveryOp", "policyDns", "policyDnsOp", "policyElement", "policyEquipment", "policyEquipmentOp", "policyFault", "policyFaultOp", "policyIdentifierPolicy", "policyInfraFirmware", "policyInfraFirmwareOp", "policyItem", "policyLocalMap", "policyLogProfile", "policyMEp", "policyMEpOp", "policyMonitoring", "policyMonitoringOp", "policyObject", "policyPolicyDestClass", "policyPolicyEp", "policyPolicyRequestor", "policyPolicyScope", "policyPolicyScopeCont", "policyPolicyScopeContext", "policyPolicyScopeFsm", "policyPolicyScopeFsmStage", "policyPolicyScopeFsmTask", "policyPortConfig", "policyPortConfigOp", "policyPowerMgmt", "policyPowerMgmtOp", "policyProxyMo", "policyPsu", "policyPsuOp", "policyRequestor", "policyScope", "policySecurity", "policySecurityOp", "policySource", "policySourceApp", "policyStorageAutoConfig", "policyStorageAutoConfigOp", "policySystemEp", "policySystemProfile", "policyTracked", "policyTracker", "policyUniverse", "poolAsnmt", "poolElement", "poolElementAlloc", "poolMember", "poolPool", "poolPoolMember", "poolPoolable", "poolUniverse", "portGroup", "portIntFIo", "portPIo", "portPhysSwitchIo", "portServerIntFIo", "portSubGroup", "portSwitchIntFIo", "powerABudget", "powerAGroup", "powerBudget", "powerChassisMember", "powerEp", "powerGroup", "powerGroupMember", "powerGroupQual", "powerGroupStats", "powerGroupStatsHist", "powerMgmtPolicy", "powerPolicy", "powerProfiledPower", "procDoer", "procManager", "procProcCounts", "procProcs", "procPrt", "procPrtCounts", "procStimulusCounts", "procSvc", "procTxCounts", "processorEnvStats", "processorEnvStatsHist", "processorErrorStats", "processorErrorStatsHist", "processorQual", "processorRuntime", "processorRuntimeHist", "processorUnit", "processorUnitAssocCtx", "qosDefinition", "qosItem", "qosclassDefinition", "qosclassEth", "qosclassEthBE", "qosclassEthClassified", "qosclassFc", "qosclassItem", "qosclassPolicy", "queryContext", "queryDependencyContext", "queryDependencyRef", "queryEp", "queryImportContext", "queryUsageContext", "queryresultDependency", "queryresultDestOrgEp", "queryresultDomainGroupEp", "queryresultItem", "queryresultOrgEp", "queryresultUsage", "ruleDefinition", "ruleItem", "ruleRequirement", "ruleSizeRequirement", "securityUnit", "sesDiskSlotEp", "sesEnclosure", "smartcallhomeHttpProxy", "smartcallhomePeriodicInventoryStatus", "smartcallhomePeriodicSystemInventory", "smartcallhomePolicy", "smartcallhomeProfile", "smartcallhomeSource", "smartcallhomeTransportGateway", "smartlicenseAgent", "smartlicenseAgentFsm", "smartlicenseAgentFsmStage", "smartlicenseAgentFsmTask", "smartlicenseEntitlement", "smartlicenseEntitlementEp", "smartlicenseEntitlementEpFsm", "smartlicenseEntitlementEpFsmStage", "smartlicenseEntitlementEpFsmTask", "smartlicenseEp", "smartlicenseHolder", "smartlicenseHolderFsm", "smartlicenseHolderFsmStage", "smartlicenseHolderFsmTask", "smartlicenseTest", "smartlicenseTestFsm", "smartlicenseTestFsmStage", "smartlicenseTestFsmTask", "solDef", "solPolicy", "statsChart", "statsChartContainer", "statsCollectionPolicy", "statsCurr", "statsCustomChart", "statsCustomEp", "statsDbMigrationStatus", "statsDbSummaryMeta", "statsHist", "statsHolder", "statsInventoryMeta", "statsItem", "statsPasadenaCollectionPolicy", "statsStandardChart", "statsStandardEp", "statsStatsQuery", "statsStatsQueryHolder", "statsThr32Definition", "statsThr32Value", "statsThr64Definition", "statsThr64Value", "statsThrFloatDefinition", "statsThrFloatValue", "statsThresholdClass", "statsThresholdDefinition", "statsThresholdPolicy", "statsThresholdValue", "storageADef", "storageALun", "storageALunRefBase", "storageAScsiLun", "storageAScsiLunCtx", "storageASlot", "storageASnapReplicaLunCtx", "storageAVolume", "storageAppliance", "storageArray", "storageAuthKey", "storageBackstore", "storageBlade", "storageCloud", "storageClusterIdUniverse", "storageComputeBladeOperation", "storageConnectionDef", "storageConnectionPolicy", "storageContainer", "storageController", "storageControllerBase", "storageControllerEp", "storageControllerOperation", "storageControllerRef", "storageCtrlStorageStats", "storageCtrlStorageStatsHist", "storageDevice", "storageDiskEnvStats", "storageDiskEnvStatsHist", "storageDiskEp", "storageDiskGroup", "storageEmbeddedStorage", "storageEnclosure", "storageEnclosureDiskSlotEp", "storageEnclosureLocalDiskConfig", "storageEp", "storageEpUser", "storageEthLif", "storageEtherIf", "storageFcIf", "storageFcTargetEp", "storageFcTargetIf", "storageFlexFlashCard", "storageFlexFlashController", "storageFlexFlashControllerOperation", "storageFlexFlashDrive", "storageFlexFlashVirtualDrive", "storageHddMotherBoardTempStats", "storageHddMotherBoardTempStatsHist", "storageIScsiInitiatorEp", "storageIScsiTargetIf", "storageIniGroup", "storageInitiator", "storageInitiatorRef", "storageIpV4PooledAddr", "storageIpV4StaticAddr", "storageItem", "storageL2If", "storageLocalDisk", "storageLocalDiskBase", "storageLocalDiskConfig", "storageLocalDiskConfigDef", "storageLocalDiskConfigPolicy", "storageLocalDiskEp", "storageLocalDiskOperation", "storageLocalDiskPartition", "storageLocalLun", "storageLogical", "storageLunCounters", "storageLunDisk", "storageLunMaskGroup", "storageLunReplica", "storageLunResourceSelectionLog", "storageLunSnapshot", "storageMeta", "storageMezzFlashLife", "storageNodeEp", "storageNvmeStats", "storageNvmeStatsHist", "storageNvmeStorage", "storageOnboardDevice", "storageOperation", "storagePartition", "storagePhysical", "storageProcessor", "storageProcessorEp", "storageProcessorRuntime", "storageQual", "storageRaidBattery", "storageReplicationCtx", "storageSasExpander", "storageSasPhyLink", "storageSasPort", "storageSasUpLink", "storageScsiDeviceDescriptor", "storageScsiLun", "storageScsiLunCtx", "storageScsiLunInstRef", "storageScsiLunMask", "storageScsiLunRef", "storageSnapshot", "storageSnapshotCtx", "storageSsdHealthStats", "storageSsdHealthStatsHist", "storageStorageStats", "storageStorageStatsHist", "storageSystem", "storageTarget", "storageTargetIf", "storageTransportIf", "storageTransportableFlashModule", "storageUnit", "storageUsageCounters", "storageVDMemberEp", "storageVirtualDrive", "storageVirtualDriveContainer", "storageVirtualDriveEp", "storageVirtualDriveOperation", "storageVirtualDriveRef", "storageVirtualDriveRefOperation", "storageVolume", "storageVsanRef", "storageVsanRefIvt", "swCardEnvStats", "swCardEnvStatsHist", "swEnvStats", "swEnvStatsHist", "swMon", "swSystemStats", "swSystemStatsHist", "swVlan", "swVlanGroup", "syntheticDirectory", "syntheticFile", "syntheticFileSystem", "syntheticFsObj", "syntheticTime", "sysdebugAutoCoreFileExportTarget", "sysdebugAutoCoreFileExportTargetFsm", "sysdebugAutoCoreFileExportTargetFsmStage", "sysdebugAutoCoreFileExportTargetFsmTask", "sysdebugBackupBehavior", "sysdebugCore", "sysdebugCoreFileExportTarget", "sysdebugCoreFileRepository", "sysdebugDiagnosticLog", "sysdebugEp", "sysdebugExporter", "sysdebugFile", "sysdebugLogBehavior", "sysdebugLogControlDestinationFile", "sysdebugLogControlDestinationSyslog", "sysdebugLogControlDomain", "sysdebugLogControlEp", "sysdebugLogControlEpFsm", "sysdebugLogControlEpFsmStage", "sysdebugLogControlEpFsmTask", "sysdebugLogControlModule", "sysdebugMEpLogDef", "sysdebugMEpLogPolicy", "sysdebugManualCoreFileExportTarget", "sysdebugManualCoreFileExportTargetFsm", "sysdebugManualCoreFileExportTargetFsmStage", "sysdebugManualCoreFileExportTargetFsmTask", "sysdebugRepository", "sysdebugTechSupFileRepository", "sysdebugTechSupport", "sysdebugTechSupportCmdOpt", "sysdebugTechSupportFsm", "sysdebugTechSupportFsmStage", "sysdebugTechSupportFsmTask", "sysdebugTechSupportOp", "sysdebugTechSupportOperation", "sysfileDigest", "sysfileEp", "sysfileExporter", "sysfileImporter", "sysfileInstance", "sysfileMutation", "sysfileMutationFsm", "sysfileMutationFsmStage", "sysfileMutationFsmTask", "sysfileRepository", "tagADef", "tagAInstance", "tagDef", "tagDefEp", "tagDriver", "tagInstance", "tagInstanceEp", "tagInstanceItem", "tagItem", "tagSoftwareInst", "testingCliPolicy", "testingServiceProfile", "testingServiceProfileFsm", "testingServiceProfileFsmStage", "testingServiceProfileFsmTask", "testingSnmpCommunity", "testingSnmpPolicy", "testingSnmpSupport", "testingSnmpTrap", "topInfoSyncPolicy", "topMetaInf", "topRoot", "topSystem", "topSystemFsm", "topSystemFsmStage", "topSystemFsmTask", "trigAbsWindow", "trigAck", "trigBaseRecurrWindow", "trigBaseSched", "trigConfAck", "trigInst", "trigMeta", "trigPendingAckCount", "trigRecurrWindow", "trigResAck", "trigSched", "trigSchedWindow", "trigServerToken", "trigTest", "trigToken", "trigTokenRequestor", "trigTriggerable", "trigTriggered", "trigWindow", "unspecified", "uuidpoolAddr", "uuidpoolBlock", "uuidpoolFormat", "uuidpoolPool", "uuidpoolPooled", "uuidpoolUniverse", "versionApplication", "versionEp", "versionFilter", "versionMatrix", "versionProduct", "versionVersion", "vmAdaptor", "vmNic", "vnicABeh", "vnicAEtherIf", "vnicAFcIf", "vnicAGroup", "vnicBootIpPolicy", "vnicBootTarget", "vnicConPolicyRef", "vnicConReq", "vnicConnDef", "vnicConnection", "vnicDefBeh", "vnicDynamicCon", "vnicDynamicConPolicy", "vnicDynamicConPolicyRef", "vnicDynamicConReq", "vnicEthLif", "vnicEther", "vnicEtherBase", "vnicEtherBaseIf", "vnicEtherIf", "vnicFault", "vnicFc", "vnicFcBase", "vnicFcGroupDef", "vnicFcGroupTempl", "vnicFcIf", "vnicFcLif", "vnicFcNode", "vnicFcOEIf", "vnicIPIf", "vnicIPv4Dhcp", "vnicIPv4Dns", "vnicIPv4If", "vnicIPv4IscsiAddr", "vnicIPv4PooledIscsiAddr", "vnicIPv4StaticRoute", "vnicIPv6If", "vnicIScsi", "vnicIScsiAutoTargetIf", "vnicIScsiBase", "vnicIScsiBootParams", "vnicIScsiBootVnic", "vnicIScsiInitiatorParams", "vnicIScsiLCP", "vnicIScsiNode", "vnicIScsiStaticTargetIf", "vnicIScsiTargetIf", "vnicIScsiTargetParams", "vnicIf", "vnicIfRole", "vnicIniGrpFc", "vnicIniGrpFcB", "vnicIniGrpFcBIf", "vnicIniGrpFcBase", "vnicIniGrpFcIf", "vnicIpAddr", "vnicIpV4Addr", "vnicIpV4AddrConf", "vnicIpV4AddrExplConf", "vnicIpV4MgmtPooledAddr", "vnicIpV4PooledAddr", "vnicIpV4ProfDerivedAddr", "vnicIpV4StaticAddr", "vnicIpV6Addr", "vnicIpV6AddrConf", "vnicIpV6AddrExplConf", "vnicIpV6MgmtPooledAddr", "vnicIpV6StaticAddr", "vnicL2If", "vnicL2Lif", "vnicL3If", "vnicLanConnPolicy", "vnicLanConnTempl", "vnicLifVlan", "vnicLifVsan", "vnicLstorageIScsi", "vnicLun", "vnicMgmt", "vnicMgmtBase", "vnicMgmtIf", "vnicMonSesFc", "vnicMonSesFcBase", "vnicMonSesFcIf", "vnicNetGroup", "vnicNetGroupRef", "vnicNicConn", "vnicOutbandMgmtEp", "vnicOutbandMgmtEpFsm", "vnicOutbandMgmtEpFsmStage", "vnicOutbandMgmtEpFsmTask", "vnicProfileSet", "vnicRackServerDiscoveryProfile", "vnicSanConnPolicy", "vnicSanConnTempl", "vnicStorageEthLif", "vnicStorageLif", "vnicTempl", "vnicUsnicConPolicy", "vnicUsnicConPolicyRef", "vnicUsnicConReq", "vnicVhbaBehPolicy", "vnicVlan", "vnicVmqConPolicy", "vnicVmqConPolicyRef", "vnicVmqConReq", "vnicVnic", "vnicVnicBehPolicy"], []), 
        "id": MoPropertyMeta("id", "id", "uint", VersionMeta.Version111a, MoPropertyMeta.NAMING, 0x4, None, None, None, [], []), 
        "name": MoPropertyMeta("name", "name", "string", VersionMeta.Version111a, MoPropertyMeta.CREATE_ONLY, 0x8, 0, 510, None, [], []), 
        "oper_prop_mask": MoPropertyMeta("oper_prop_mask", "operPropMask", "string", VersionMeta.Version111a, MoPropertyMeta.READ_ONLY, None, None, None, None, [], []), 
        "rn": MoPropertyMeta("rn", "rn", "string", VersionMeta.Version111a, MoPropertyMeta.READ_ONLY, 0x10, 0, 256, None, [], []), 
        "status": MoPropertyMeta("status", "status", "string", VersionMeta.Version111a, MoPropertyMeta.READ_WRITE, 0x20, None, None, r"""((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], []), 
    }

    prop_map = {
        "adminPropMask": "admin_prop_mask", 
        "childAction": "child_action", 
        "dn": "dn", 
        "epClassId": "ep_class_id", 
        "id": "id", 
        "name": "name", 
        "operPropMask": "oper_prop_mask", 
        "rn": "rn", 
        "status": "status", 
    }

    def __init__(self, parent_mo_or_dn, id, **kwargs):
        self._dirty_mask = 0
        self.id = id
        self.admin_prop_mask = None
        self.child_action = None
        self.ep_class_id = None
        self.name = None
        self.oper_prop_mask = None
        self.status = None

        ManagedObject.__init__(self, "GmetaClass", parent_mo_or_dn, **kwargs)

