"""This module contains the general information for DupeScope ManagedObject."""

from ...ucscmo import ManagedObject
from ...ucsccoremeta import UcscVersion, MoPropertyMeta, MoMeta
from ...ucscmeta import VersionMeta


class DupeScopeConsts():
    IS_SYSTEM_FALSE = "false"
    IS_SYSTEM_NO = "no"
    IS_SYSTEM_TRUE = "true"
    IS_SYSTEM_YES = "yes"
    MO_CLASS_ID_AAA_AUTH_METHOD = "aaaAuthMethod"
    MO_CLASS_ID_AAA_AUTH_REALM = "aaaAuthRealm"
    MO_CLASS_ID_AAA_AUTH_REALM_FSM = "aaaAuthRealmFsm"
    MO_CLASS_ID_AAA_AUTH_REALM_FSM_STAGE = "aaaAuthRealmFsmStage"
    MO_CLASS_ID_AAA_CONFIG = "aaaConfig"
    MO_CLASS_ID_AAA_CONSOLE_AUTH = "aaaConsoleAuth"
    MO_CLASS_ID_AAA_DEFAULT_AUTH = "aaaDefaultAuth"
    MO_CLASS_ID_AAA_DEFINITION = "aaaDefinition"
    MO_CLASS_ID_AAA_DOMAIN = "aaaDomain"
    MO_CLASS_ID_AAA_DOMAIN_AUTH = "aaaDomainAuth"
    MO_CLASS_ID_AAA_DOMAIN_GROUP = "aaaDomainGroup"
    MO_CLASS_ID_AAA_EP = "aaaEp"
    MO_CLASS_ID_AAA_EP_AUTH_PROFILE = "aaaEpAuthProfile"
    MO_CLASS_ID_AAA_EP_FSM = "aaaEpFsm"
    MO_CLASS_ID_AAA_EP_FSM_STAGE = "aaaEpFsmStage"
    MO_CLASS_ID_AAA_EP_FSM_TASK = "aaaEpFsmTask"
    MO_CLASS_ID_AAA_EP_LOGIN = "aaaEpLogin"
    MO_CLASS_ID_AAA_EP_USER = "aaaEpUser"
    MO_CLASS_ID_AAA_EXT_MGMT_CUT_THRU_TKN = "aaaExtMgmtCutThruTkn"
    MO_CLASS_ID_AAA_ITEM = "aaaItem"
    MO_CLASS_ID_AAA_LDAP_EP = "aaaLdapEp"
    MO_CLASS_ID_AAA_LDAP_EP_FSM = "aaaLdapEpFsm"
    MO_CLASS_ID_AAA_LDAP_EP_FSM_STAGE = "aaaLdapEpFsmStage"
    MO_CLASS_ID_AAA_LDAP_GROUP = "aaaLdapGroup"
    MO_CLASS_ID_AAA_LDAP_GROUP_RULE = "aaaLdapGroupRule"
    MO_CLASS_ID_AAA_LDAP_PROVIDER = "aaaLdapProvider"
    MO_CLASS_ID_AAA_LOCALE = "aaaLocale"
    MO_CLASS_ID_AAA_LOG = "aaaLog"
    MO_CLASS_ID_AAA_MOD_LR = "aaaModLR"
    MO_CLASS_ID_AAA_ORG = "aaaOrg"
    MO_CLASS_ID_AAA_PROVIDER = "aaaProvider"
    MO_CLASS_ID_AAA_PROVIDER_GROUP = "aaaProviderGroup"
    MO_CLASS_ID_AAA_PROVIDER_REF = "aaaProviderRef"
    MO_CLASS_ID_AAA_PWD_PROFILE = "aaaPwdProfile"
    MO_CLASS_ID_AAA_RADIUS_EP = "aaaRadiusEp"
    MO_CLASS_ID_AAA_RADIUS_EP_FSM = "aaaRadiusEpFsm"
    MO_CLASS_ID_AAA_RADIUS_EP_FSM_STAGE = "aaaRadiusEpFsmStage"
    MO_CLASS_ID_AAA_RADIUS_PROVIDER = "aaaRadiusProvider"
    MO_CLASS_ID_AAA_REALM = "aaaRealm"
    MO_CLASS_ID_AAA_REALM_FSM = "aaaRealmFsm"
    MO_CLASS_ID_AAA_REALM_FSM_STAGE = "aaaRealmFsmStage"
    MO_CLASS_ID_AAA_REALM_FSM_TASK = "aaaRealmFsmTask"
    MO_CLASS_ID_AAA_REMOTE_USER = "aaaRemoteUser"
    MO_CLASS_ID_AAA_ROLE = "aaaRole"
    MO_CLASS_ID_AAA_SESSION = "aaaSession"
    MO_CLASS_ID_AAA_SESSION_LR = "aaaSessionLR"
    MO_CLASS_ID_AAA_SHELL_LOGIN = "aaaShellLogin"
    MO_CLASS_ID_AAA_SSH_AUTH = "aaaSshAuth"
    MO_CLASS_ID_AAA_SYSTEM_USER = "aaaSystemUser"
    MO_CLASS_ID_AAA_TACACS_PLUS_EP = "aaaTacacsPlusEp"
    MO_CLASS_ID_AAA_TACACS_PLUS_EP_FSM = "aaaTacacsPlusEpFsm"
    MO_CLASS_ID_AAA_TACACS_PLUS_EP_FSM_STAGE = "aaaTacacsPlusEpFsmStage"
    MO_CLASS_ID_AAA_TACACS_PLUS_PROVIDER = "aaaTacacsPlusProvider"
    MO_CLASS_ID_AAA_USER = "aaaUser"
    MO_CLASS_ID_AAA_USER_ACTION = "aaaUserAction"
    MO_CLASS_ID_AAA_USER_DATA = "aaaUserData"
    MO_CLASS_ID_AAA_USER_EP = "aaaUserEp"
    MO_CLASS_ID_AAA_USER_EP_FSM = "aaaUserEpFsm"
    MO_CLASS_ID_AAA_USER_EP_FSM_STAGE = "aaaUserEpFsmStage"
    MO_CLASS_ID_AAA_USER_EP_FSM_TASK = "aaaUserEpFsmTask"
    MO_CLASS_ID_AAA_USER_GROUP = "aaaUserGroup"
    MO_CLASS_ID_AAA_USER_LOCALE = "aaaUserLocale"
    MO_CLASS_ID_AAA_USER_LOGIN = "aaaUserLogin"
    MO_CLASS_ID_AAA_USER_PREFERENCES = "aaaUserPreferences"
    MO_CLASS_ID_AAA_USER_ROLE = "aaaUserRole"
    MO_CLASS_ID_AAA_WEB_LOGIN = "aaaWebLogin"
    MO_CLASS_ID_ADAPTOR_BEH_CAP = "adaptorBehCap"
    MO_CLASS_ID_ADAPTOR_CAP_DEF = "adaptorCapDef"
    MO_CLASS_ID_ADAPTOR_CAP_QUAL = "adaptorCapQual"
    MO_CLASS_ID_ADAPTOR_CAP_SPEC = "adaptorCapSpec"
    MO_CLASS_ID_ADAPTOR_ETH_ADV_FILTER_PROFILE = "adaptorEthAdvFilterProfile"
    MO_CLASS_ID_ADAPTOR_ETH_ARFS_PROFILE = "adaptorEthArfsProfile"
    MO_CLASS_ID_ADAPTOR_ETH_COMP_QUEUE_PROFILE = "adaptorEthCompQueueProfile"
    MO_CLASS_ID_ADAPTOR_ETH_FAILOVER_PROFILE = "adaptorEthFailoverProfile"
    MO_CLASS_ID_ADAPTOR_ETH_GENEVEPROFILE = "adaptorEthGENEVEProfile"
    MO_CLASS_ID_ADAPTOR_ETH_INTERRUPT_PROFILE = "adaptorEthInterruptProfile"
    MO_CLASS_ID_ADAPTOR_ETH_INTERRUPT_SCALING_PROFILE = "adaptorEthInterruptScalingProfile"
    MO_CLASS_ID_ADAPTOR_ETH_NVGREPROFILE = "adaptorEthNVGREProfile"
    MO_CLASS_ID_ADAPTOR_ETH_OFFLOAD_PROFILE = "adaptorEthOffloadProfile"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS = "adaptorEthPortBySizeLargeStats"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST = "adaptorEthPortBySizeLargeStatsHist"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS = "adaptorEthPortBySizeSmallStats"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST = "adaptorEthPortBySizeSmallStatsHist"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_ERR_STATS = "adaptorEthPortErrStats"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_ERR_STATS_HIST = "adaptorEthPortErrStatsHist"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_MCAST_STATS = "adaptorEthPortMcastStats"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_MCAST_STATS_HIST = "adaptorEthPortMcastStatsHist"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS = "adaptorEthPortOutsizedStats"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST = "adaptorEthPortOutsizedStatsHist"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_STATS = "adaptorEthPortStats"
    MO_CLASS_ID_ADAPTOR_ETH_PORT_STATS_HIST = "adaptorEthPortStatsHist"
    MO_CLASS_ID_ADAPTOR_ETH_QUEUE_PROFILE = "adaptorEthQueueProfile"
    MO_CLASS_ID_ADAPTOR_ETH_RECV_QUEUE_PROFILE = "adaptorEthRecvQueueProfile"
    MO_CLASS_ID_ADAPTOR_ETH_RO_CEPROFILE = "adaptorEthRoCEProfile"
    MO_CLASS_ID_ADAPTOR_ETH_VX_LANPROFILE = "adaptorEthVxLANProfile"
    MO_CLASS_ID_ADAPTOR_ETH_WORK_QUEUE_PROFILE = "adaptorEthWorkQueueProfile"
    MO_CLASS_ID_ADAPTOR_ETHER_IF_STATS = "adaptorEtherIfStats"
    MO_CLASS_ID_ADAPTOR_ETHER_IF_STATS_HIST = "adaptorEtherIfStatsHist"
    MO_CLASS_ID_ADAPTOR_EXT_ETH_IF = "adaptorExtEthIf"
    MO_CLASS_ID_ADAPTOR_EXT_ETH_IF_OPERATION = "adaptorExtEthIfOperation"
    MO_CLASS_ID_ADAPTOR_EXT_IF = "adaptorExtIf"
    MO_CLASS_ID_ADAPTOR_EXT_IP_V6_RSS_HASH_PROFILE = "adaptorExtIpV6RssHashProfile"
    MO_CLASS_ID_ADAPTOR_FC_CDB_WORK_QUEUE_PROFILE = "adaptorFcCdbWorkQueueProfile"
    MO_CLASS_ID_ADAPTOR_FC_ERROR_RECOVERY_PROFILE = "adaptorFcErrorRecoveryProfile"
    MO_CLASS_ID_ADAPTOR_FC_FNIC_PROFILE = "adaptorFcFnicProfile"
    MO_CLASS_ID_ADAPTOR_FC_IF_EVENT_STATS = "adaptorFcIfEventStats"
    MO_CLASS_ID_ADAPTOR_FC_IF_EVENT_STATS_HIST = "adaptorFcIfEventStatsHist"
    MO_CLASS_ID_ADAPTOR_FC_IF_FC4_STATS = "adaptorFcIfFC4Stats"
    MO_CLASS_ID_ADAPTOR_FC_IF_FC4_STATS_HIST = "adaptorFcIfFC4StatsHist"
    MO_CLASS_ID_ADAPTOR_FC_IF_FRAME_STATS = "adaptorFcIfFrameStats"
    MO_CLASS_ID_ADAPTOR_FC_IF_FRAME_STATS_HIST = "adaptorFcIfFrameStatsHist"
    MO_CLASS_ID_ADAPTOR_FC_INTERRUPT_PROFILE = "adaptorFcInterruptProfile"
    MO_CLASS_ID_ADAPTOR_FC_LOGI_PROFILE = "adaptorFcLogiProfile"
    MO_CLASS_ID_ADAPTOR_FC_PORT_FLOGI_PROFILE = "adaptorFcPortFLogiProfile"
    MO_CLASS_ID_ADAPTOR_FC_PORT_PLOGI_PROFILE = "adaptorFcPortPLogiProfile"
    MO_CLASS_ID_ADAPTOR_FC_PORT_PROFILE = "adaptorFcPortProfile"
    MO_CLASS_ID_ADAPTOR_FC_PORT_STATS = "adaptorFcPortStats"
    MO_CLASS_ID_ADAPTOR_FC_PORT_STATS_HIST = "adaptorFcPortStatsHist"
    MO_CLASS_ID_ADAPTOR_FC_QUEUE_PROFILE = "adaptorFcQueueProfile"
    MO_CLASS_ID_ADAPTOR_FC_RECV_QUEUE_PROFILE = "adaptorFcRecvQueueProfile"
    MO_CLASS_ID_ADAPTOR_FC_WORK_QUEUE_PROFILE = "adaptorFcWorkQueueProfile"
    MO_CLASS_ID_ADAPTOR_FRU_CAP_PROVIDER = "adaptorFruCapProvider"
    MO_CLASS_ID_ADAPTOR_HBAVNIC_STATS = "adaptorHBAVnicStats"
    MO_CLASS_ID_ADAPTOR_HBAVNIC_STATS_HIST = "adaptorHBAVnicStatsHist"
    MO_CLASS_ID_ADAPTOR_HOST_ETH_IF = "adaptorHostEthIf"
    MO_CLASS_ID_ADAPTOR_HOST_ETH_IF_OPERATION = "adaptorHostEthIfOperation"
    MO_CLASS_ID_ADAPTOR_HOST_ETH_IF_PROFILE = "adaptorHostEthIfProfile"
    MO_CLASS_ID_ADAPTOR_HOST_FC_IF = "adaptorHostFcIf"
    MO_CLASS_ID_ADAPTOR_HOST_FC_IF_OPERATION = "adaptorHostFcIfOperation"
    MO_CLASS_ID_ADAPTOR_HOST_FC_IF_PROFILE = "adaptorHostFcIfProfile"
    MO_CLASS_ID_ADAPTOR_HOST_IF = "adaptorHostIf"
    MO_CLASS_ID_ADAPTOR_HOST_IF_CONFIG = "adaptorHostIfConfig"
    MO_CLASS_ID_ADAPTOR_HOST_IF_CONN_DEF = "adaptorHostIfConnDef"
    MO_CLASS_ID_ADAPTOR_HOST_IF_PROFILE = "adaptorHostIfProfile"
    MO_CLASS_ID_ADAPTOR_HOST_ISCSI_IF = "adaptorHostIscsiIf"
    MO_CLASS_ID_ADAPTOR_HOST_ISCSI_IF_OPERATION = "adaptorHostIscsiIfOperation"
    MO_CLASS_ID_ADAPTOR_HOST_ISCSI_IF_PROFILE = "adaptorHostIscsiIfProfile"
    MO_CLASS_ID_ADAPTOR_HOST_SCSI_IF = "adaptorHostScsiIf"
    MO_CLASS_ID_ADAPTOR_HOST_SCSI_LUN_REF = "adaptorHostScsiLunRef"
    MO_CLASS_ID_ADAPTOR_HW_ADDR_CAP = "adaptorHwAddrCap"
    MO_CLASS_ID_ADAPTOR_ISCSI_CAP = "adaptorIScsiCap"
    MO_CLASS_ID_ADAPTOR_IP_V4_RSS_HASH_PROFILE = "adaptorIpV4RssHashProfile"
    MO_CLASS_ID_ADAPTOR_IP_V6_RSS_HASH_PROFILE = "adaptorIpV6RssHashProfile"
    MO_CLASS_ID_ADAPTOR_MENLO_BASE_ERROR_STATS = "adaptorMenloBaseErrorStats"
    MO_CLASS_ID_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST = "adaptorMenloBaseErrorStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_DCE_PORT_STATS = "adaptorMenloDcePortStats"
    MO_CLASS_ID_ADAPTOR_MENLO_DCE_PORT_STATS_HIST = "adaptorMenloDcePortStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_ETH_ERROR_STATS = "adaptorMenloEthErrorStats"
    MO_CLASS_ID_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST = "adaptorMenloEthErrorStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_ETH_STATS = "adaptorMenloEthStats"
    MO_CLASS_ID_ADAPTOR_MENLO_ETH_STATS_HIST = "adaptorMenloEthStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_FC_ERROR_STATS = "adaptorMenloFcErrorStats"
    MO_CLASS_ID_ADAPTOR_MENLO_FC_ERROR_STATS_HIST = "adaptorMenloFcErrorStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_FC_STATS = "adaptorMenloFcStats"
    MO_CLASS_ID_ADAPTOR_MENLO_FC_STATS_HIST = "adaptorMenloFcStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_HOST_PORT_STATS = "adaptorMenloHostPortStats"
    MO_CLASS_ID_ADAPTOR_MENLO_HOST_PORT_STATS_HIST = "adaptorMenloHostPortStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS = "adaptorMenloMcpuErrorStats"
    MO_CLASS_ID_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST = "adaptorMenloMcpuErrorStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_MCPU_STATS = "adaptorMenloMcpuStats"
    MO_CLASS_ID_ADAPTOR_MENLO_MCPU_STATS_HIST = "adaptorMenloMcpuStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_NET_EG_STATS = "adaptorMenloNetEgStats"
    MO_CLASS_ID_ADAPTOR_MENLO_NET_EG_STATS_HIST = "adaptorMenloNetEgStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_NET_IN_STATS = "adaptorMenloNetInStats"
    MO_CLASS_ID_ADAPTOR_MENLO_NET_IN_STATS_HIST = "adaptorMenloNetInStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_QERROR_STATS = "adaptorMenloQErrorStats"
    MO_CLASS_ID_ADAPTOR_MENLO_QERROR_STATS_HIST = "adaptorMenloQErrorStatsHist"
    MO_CLASS_ID_ADAPTOR_MENLO_QSTATS = "adaptorMenloQStats"
    MO_CLASS_ID_ADAPTOR_MENLO_QSTATS_HIST = "adaptorMenloQStatsHist"
    MO_CLASS_ID_ADAPTOR_NICVNIC_STATS = "adaptorNICVnicStats"
    MO_CLASS_ID_ADAPTOR_NICVNIC_STATS_HIST = "adaptorNICVnicStatsHist"
    MO_CLASS_ID_ADAPTOR_PROFILE_ITEM = "adaptorProfileItem"
    MO_CLASS_ID_ADAPTOR_PROTOCOL_PROFILE = "adaptorProtocolProfile"
    MO_CLASS_ID_ADAPTOR_QUAL = "adaptorQual"
    MO_CLASS_ID_ADAPTOR_QUEUE_PROFILE = "adaptorQueueProfile"
    MO_CLASS_ID_ADAPTOR_RNIC_CAP_SPEC = "adaptorRnicCapSpec"
    MO_CLASS_ID_ADAPTOR_RSS_HASH_PROFILE = "adaptorRssHashProfile"
    MO_CLASS_ID_ADAPTOR_RSS_PROFILE = "adaptorRssProfile"
    MO_CLASS_ID_ADAPTOR_TCP_IP_RSS_HASH_PROFILE = "adaptorTcpIpRssHashProfile"
    MO_CLASS_ID_ADAPTOR_UNIT = "adaptorUnit"
    MO_CLASS_ID_ADAPTOR_UNIT_ASSOC_CTX = "adaptorUnitAssocCtx"
    MO_CLASS_ID_ADAPTOR_UNIT_EXTN = "adaptorUnitExtn"
    MO_CLASS_ID_ADAPTOR_USNIC_CONN_DEF = "adaptorUsnicConnDef"
    MO_CLASS_ID_ADAPTOR_VLAN = "adaptorVlan"
    MO_CLASS_ID_ADAPTOR_VMMQ_CONN_DEF = "adaptorVmmqConnDef"
    MO_CLASS_ID_ADAPTOR_VNIC_STATS = "adaptorVnicStats"
    MO_CLASS_ID_ADAPTOR_VNIC_STATS_HIST = "adaptorVnicStatsHist"
    MO_CLASS_ID_BIOS_BOT = "biosBOT"
    MO_CLASS_ID_BIOS_BOOT_DEV = "biosBootDev"
    MO_CLASS_ID_BIOS_BOOT_DEV_GRP = "biosBootDevGrp"
    MO_CLASS_ID_BIOS_TOKEN_FEATURE_GROUP = "biosTokenFeatureGroup"
    MO_CLASS_ID_BIOS_TOKEN_PARAM = "biosTokenParam"
    MO_CLASS_ID_BIOS_TOKEN_SETTINGS = "biosTokenSettings"
    MO_CLASS_ID_BIOS_UNIT = "biosUnit"
    MO_CLASS_ID_BIOS_VFEAT = "biosVFeat"
    MO_CLASS_ID_BIOS_VPROFILE = "biosVProfile"
    MO_CLASS_ID_BIOS_VF_ACPI10_SUPPORT = "biosVfACPI10Support"
    MO_CLASS_ID_BIOS_VF_ASPMSUPPORT = "biosVfASPMSupport"
    MO_CLASS_ID_BIOS_VF_ALL_USBDEVICES = "biosVfAllUSBDevices"
    MO_CLASS_ID_BIOS_VF_ALTITUDE = "biosVfAltitude"
    MO_CLASS_ID_BIOS_VF_ASSERT_NMION_PERR = "biosVfAssertNMIOnPERR"
    MO_CLASS_ID_BIOS_VF_ASSERT_NMION_SERR = "biosVfAssertNMIOnSERR"
    MO_CLASS_ID_BIOS_VF_BOOT_OPTION_RETRY = "biosVfBootOptionRetry"
    MO_CLASS_ID_BIOS_VF_CPUHARDWARE_POWER_MANAGEMENT = "biosVfCPUHardwarePowerManagement"
    MO_CLASS_ID_BIOS_VF_CPUPERFORMANCE = "biosVfCPUPerformance"
    MO_CLASS_ID_BIOS_VF_CPUPOWER_MANAGEMENT = "biosVfCPUPowerManagement"
    MO_CLASS_ID_BIOS_VF_CONSISTENT_DEVICE_NAME_CONTROL = "biosVfConsistentDeviceNameControl"
    MO_CLASS_ID_BIOS_VF_CONSOLE_REDIRECTION = "biosVfConsoleRedirection"
    MO_CLASS_ID_BIOS_VF_CORE_MULTI_PROCESSING = "biosVfCoreMultiProcessing"
    MO_CLASS_ID_BIOS_VF_DDR3_VOLTAGE_SELECTION = "biosVfDDR3VoltageSelection"
    MO_CLASS_ID_BIOS_VF_DRAMCLOCK_THROTTLING = "biosVfDRAMClockThrottling"
    MO_CLASS_ID_BIOS_VF_DIRECT_CACHE_ACCESS = "biosVfDirectCacheAccess"
    MO_CLASS_ID_BIOS_VF_DRAM_REFRESH_RATE = "biosVfDramRefreshRate"
    MO_CLASS_ID_BIOS_VF_ENERGY_PERFORMANCE_TUNING = "biosVfEnergyPerformanceTuning"
    MO_CLASS_ID_BIOS_VF_ENHANCED_INTEL_SPEED_STEP_TECH = "biosVfEnhancedIntelSpeedStepTech"
    MO_CLASS_ID_BIOS_VF_ENHANCED_POWER_CAPPING_SUPPORT = "biosVfEnhancedPowerCappingSupport"
    MO_CLASS_ID_BIOS_VF_EXECUTE_DISABLE_BIT = "biosVfExecuteDisableBit"
    MO_CLASS_ID_BIOS_VF_FRB2_TIMER = "biosVfFRB2Timer"
    MO_CLASS_ID_BIOS_VF_FREQUENCY_FLOOR_OVERRIDE = "biosVfFrequencyFloorOverride"
    MO_CLASS_ID_BIOS_VF_FRONT_PANEL_LOCKOUT = "biosVfFrontPanelLockout"
    MO_CLASS_ID_BIOS_VF_IOEMEZZ1_OPTION_ROM = "biosVfIOEMezz1OptionROM"
    MO_CLASS_ID_BIOS_VF_IOENVME1_OPTION_ROM = "biosVfIOENVMe1OptionROM"
    MO_CLASS_ID_BIOS_VF_IOENVME2_OPTION_ROM = "biosVfIOENVMe2OptionROM"
    MO_CLASS_ID_BIOS_VF_IOESLOT1_OPTION_ROM = "biosVfIOESlot1OptionROM"
    MO_CLASS_ID_BIOS_VF_IOESLOT2_OPTION_ROM = "biosVfIOESlot2OptionROM"
    MO_CLASS_ID_BIOS_VF_INTEGRATED_GRAPHICS = "biosVfIntegratedGraphics"
    MO_CLASS_ID_BIOS_VF_INTEGRATED_GRAPHICS_APERTURE_SIZE = "biosVfIntegratedGraphicsApertureSize"
    MO_CLASS_ID_BIOS_VF_INTEL_ENTRY_SASRAIDMODULE = "biosVfIntelEntrySASRAIDModule"
    MO_CLASS_ID_BIOS_VF_INTEL_HYPER_THREADING_TECH = "biosVfIntelHyperThreadingTech"
    MO_CLASS_ID_BIOS_VF_INTEL_TRUSTED_EXECUTION_TECHNOLOGY = "biosVfIntelTrustedExecutionTechnology"
    MO_CLASS_ID_BIOS_VF_INTEL_TURBO_BOOST_TECH = "biosVfIntelTurboBoostTech"
    MO_CLASS_ID_BIOS_VF_INTEL_VTFOR_DIRECTED_IO = "biosVfIntelVTForDirectedIO"
    MO_CLASS_ID_BIOS_VF_INTEL_VIRTUALIZATION_TECHNOLOGY = "biosVfIntelVirtualizationTechnology"
    MO_CLASS_ID_BIOS_VF_INTERLEAVE_CONFIGURATION = "biosVfInterleaveConfiguration"
    MO_CLASS_ID_BIOS_VF_LOCAL_X2_APIC = "biosVfLocalX2Apic"
    MO_CLASS_ID_BIOS_VF_LV_DIMMSUPPORT = "biosVfLvDIMMSupport"
    MO_CLASS_ID_BIOS_VF_MAX_VARIABLE_MTRRSETTING = "biosVfMaxVariableMTRRSetting"
    MO_CLASS_ID_BIOS_VF_MAXIMUM_MEMORY_BELOW4_GB = "biosVfMaximumMemoryBelow4GB"
    MO_CLASS_ID_BIOS_VF_MEMORY_MAPPED_IOABOVE4_GB = "biosVfMemoryMappedIOAbove4GB"
    MO_CLASS_ID_BIOS_VF_MIRRORING_MODE = "biosVfMirroringMode"
    MO_CLASS_ID_BIOS_VF_NUMAOPTIMIZED = "biosVfNUMAOptimized"
    MO_CLASS_ID_BIOS_VF_OSBOOT_WATCHDOG_TIMER = "biosVfOSBootWatchdogTimer"
    MO_CLASS_ID_BIOS_VF_OSBOOT_WATCHDOG_TIMER_POLICY = "biosVfOSBootWatchdogTimerPolicy"
    MO_CLASS_ID_BIOS_VF_OSBOOT_WATCHDOG_TIMER_TIMEOUT = "biosVfOSBootWatchdogTimerTimeout"
    MO_CLASS_ID_BIOS_VF_ONBOARD_GRAPHICS = "biosVfOnboardGraphics"
    MO_CLASS_ID_BIOS_VF_ONBOARD_SATACONTROLLER = "biosVfOnboardSATAController"
    MO_CLASS_ID_BIOS_VF_ONBOARD_STORAGE = "biosVfOnboardStorage"
    MO_CLASS_ID_BIOS_VF_OPTION_ROMENABLE = "biosVfOptionROMEnable"
    MO_CLASS_ID_BIOS_VF_OPTION_ROMLOAD = "biosVfOptionROMLoad"
    MO_CLASS_ID_BIOS_VF_OUT_OF_BAND_MANAGEMENT = "biosVfOutOfBandManagement"
    MO_CLASS_ID_BIOS_VF_PCHSATAMODE = "biosVfPCHSATAMode"
    MO_CLASS_ID_BIOS_VF_PCILOMPORTS_CONFIGURATION = "biosVfPCILOMPortsConfiguration"
    MO_CLASS_ID_BIOS_VF_PCIROMCLP = "biosVfPCIROMCLP"
    MO_CLASS_ID_BIOS_VF_PCISLOT_LINK_SPEED = "biosVfPCISlotLinkSpeed"
    MO_CLASS_ID_BIOS_VF_PCISLOT_OPTION_ROMENABLE = "biosVfPCISlotOptionROMEnable"
    MO_CLASS_ID_BIOS_VF_POSTERROR_PAUSE = "biosVfPOSTErrorPause"
    MO_CLASS_ID_BIOS_VF_PSTATECOORDINATION = "biosVfPSTATECoordination"
    MO_CLASS_ID_BIOS_VF_PACKAGE_CSTATE_LIMIT = "biosVfPackageCStateLimit"
    MO_CLASS_ID_BIOS_VF_PROCESSOR_C1_E = "biosVfProcessorC1E"
    MO_CLASS_ID_BIOS_VF_PROCESSOR_C3_REPORT = "biosVfProcessorC3Report"
    MO_CLASS_ID_BIOS_VF_PROCESSOR_C6_REPORT = "biosVfProcessorC6Report"
    MO_CLASS_ID_BIOS_VF_PROCESSOR_C7_REPORT = "biosVfProcessorC7Report"
    MO_CLASS_ID_BIOS_VF_PROCESSOR_CMCI = "biosVfProcessorCMCI"
    MO_CLASS_ID_BIOS_VF_PROCESSOR_CSTATE = "biosVfProcessorCState"
    MO_CLASS_ID_BIOS_VF_PROCESSOR_ENERGY_CONFIGURATION = "biosVfProcessorEnergyConfiguration"
    MO_CLASS_ID_BIOS_VF_PROCESSOR_PREFETCH_CONFIG = "biosVfProcessorPrefetchConfig"
    MO_CLASS_ID_BIOS_VF_QPILINK_FREQUENCY_SELECT = "biosVfQPILinkFrequencySelect"
    MO_CLASS_ID_BIOS_VF_QPISNOOP_MODE = "biosVfQPISnoopMode"
    MO_CLASS_ID_BIOS_VF_QUIET_BOOT = "biosVfQuietBoot"
    MO_CLASS_ID_BIOS_VF_REDIRECTION_AFTER_BIOSPOST = "biosVfRedirectionAfterBIOSPOST"
    MO_CLASS_ID_BIOS_VF_RESUME_ON_ACPOWER_LOSS = "biosVfResumeOnACPowerLoss"
    MO_CLASS_ID_BIOS_VF_SBMEZZ1_OPTION_ROM = "biosVfSBMezz1OptionROM"
    MO_CLASS_ID_BIOS_VF_SBNVME1_OPTION_ROM = "biosVfSBNVMe1OptionROM"
    MO_CLASS_ID_BIOS_VF_SIOC1_OPTION_ROM = "biosVfSIOC1OptionROM"
    MO_CLASS_ID_BIOS_VF_SIOC2_OPTION_ROM = "biosVfSIOC2OptionROM"
    MO_CLASS_ID_BIOS_VF_SCRUB_POLICIES = "biosVfScrubPolicies"
    MO_CLASS_ID_BIOS_VF_SELECT_MEMORY_RASCONFIGURATION = "biosVfSelectMemoryRASConfiguration"
    MO_CLASS_ID_BIOS_VF_SERIAL_PORT_AENABLE = "biosVfSerialPortAEnable"
    MO_CLASS_ID_BIOS_VF_SPARING_MODE = "biosVfSparingMode"
    MO_CLASS_ID_BIOS_VF_SRIOV_CONFIG = "biosVfSriovConfig"
    MO_CLASS_ID_BIOS_VF_TPMPENDING_OPERATION = "biosVfTPMPendingOperation"
    MO_CLASS_ID_BIOS_VF_TPMSUPPORT = "biosVfTPMSupport"
    MO_CLASS_ID_BIOS_VF_TRUSTED_PLATFORM_MODULE = "biosVfTrustedPlatformModule"
    MO_CLASS_ID_BIOS_VF_UCSMBOOT_MODE_CONTROL = "biosVfUCSMBootModeControl"
    MO_CLASS_ID_BIOS_VF_UCSMBOOT_ORDER_RULE_CONTROL = "biosVfUCSMBootOrderRuleControl"
    MO_CLASS_ID_BIOS_VF_UEFIOSUSE_LEGACY_VIDEO = "biosVfUEFIOSUseLegacyVideo"
    MO_CLASS_ID_BIOS_VF_USBBOOT_CONFIG = "biosVfUSBBootConfig"
    MO_CLASS_ID_BIOS_VF_USBCONFIGURATION = "biosVfUSBConfiguration"
    MO_CLASS_ID_BIOS_VF_USBFRONT_PANEL_ACCESS_LOCK = "biosVfUSBFrontPanelAccessLock"
    MO_CLASS_ID_BIOS_VF_USBPORT_CONFIGURATION = "biosVfUSBPortConfiguration"
    MO_CLASS_ID_BIOS_VF_USBSYSTEM_IDLE_POWER_OPTIMIZING_SETTING = "biosVfUSBSystemIdlePowerOptimizingSetting"
    MO_CLASS_ID_BIOS_VF_VGAPRIORITY = "biosVfVGAPriority"
    MO_CLASS_ID_BIOS_VF_WORKLOAD_CONFIGURATION = "biosVfWorkloadConfiguration"
    MO_CLASS_ID_CALLHOME_DEST = "callhomeDest"
    MO_CLASS_ID_CALLHOME_EP = "callhomeEp"
    MO_CLASS_ID_CALLHOME_FAULT_INST = "callhomeFaultInst"
    MO_CLASS_ID_CALLHOME_HOLDER = "callhomeHolder"
    MO_CLASS_ID_CALLHOME_HOLDER_FSM = "callhomeHolderFsm"
    MO_CLASS_ID_CALLHOME_HOLDER_FSM_STAGE = "callhomeHolderFsmStage"
    MO_CLASS_ID_CALLHOME_HOLDER_FSM_TASK = "callhomeHolderFsmTask"
    MO_CLASS_ID_CALLHOME_HTTP = "callhomeHttp"
    MO_CLASS_ID_CALLHOME_ITEM = "callhomeItem"
    MO_CLASS_ID_CALLHOME_PERIODIC_SYSTEM_INVENTORY = "callhomePeriodicSystemInventory"
    MO_CLASS_ID_CALLHOME_POLICY = "callhomePolicy"
    MO_CLASS_ID_CALLHOME_PROFILE = "callhomeProfile"
    MO_CLASS_ID_CALLHOME_SMTP = "callhomeSmtp"
    MO_CLASS_ID_CALLHOME_SOURCE = "callhomeSource"
    MO_CLASS_ID_CALLHOME_TEST_ALERT = "callhomeTestAlert"
    MO_CLASS_ID_CAPABILITY_CATALOGUE = "capabilityCatalogue"
    MO_CLASS_ID_CAPABILITY_DEF = "capabilityDef"
    MO_CLASS_ID_CAPABILITY_ITEM = "capabilityItem"
    MO_CLASS_ID_CAPABILITY_PROVIDER = "capabilityProvider"
    MO_CLASS_ID_CERT_REPAIR_EP = "certRepairEp"
    MO_CLASS_ID_CERT_REPAIR_EP_FSM = "certRepairEpFsm"
    MO_CLASS_ID_CERT_REPAIR_EP_FSM_STAGE = "certRepairEpFsmStage"
    MO_CLASS_ID_CERT_REPAIR_EP_FSM_TASK = "certRepairEpFsmTask"
    MO_CLASS_ID_CHANGE_CHANGED_OBJECT_REF = "changeChangedObjectRef"
    MO_CLASS_ID_CHANGE_EP = "changeEp"
    MO_CLASS_ID_CHANGE_EP_FSM = "changeEpFsm"
    MO_CLASS_ID_CHANGE_EP_FSM_STAGE = "changeEpFsmStage"
    MO_CLASS_ID_CHANGE_EP_FSM_TASK = "changeEpFsmTask"
    MO_CLASS_ID_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY = "cimcvmediaActualMountEntry"
    MO_CLASS_ID_CIMCVMEDIA_ACTUAL_MOUNT_LIST = "cimcvmediaActualMountList"
    MO_CLASS_ID_CIMCVMEDIA_CONFIG_MOUNT_ENTRY = "cimcvmediaConfigMountEntry"
    MO_CLASS_ID_CIMCVMEDIA_EXT_MGMT_RULE_ENTRY = "cimcvmediaExtMgmtRuleEntry"
    MO_CLASS_ID_CIMCVMEDIA_ITEM = "cimcvmediaItem"
    MO_CLASS_ID_CIMCVMEDIA_MOUNT_CONFIG = "cimcvmediaMountConfig"
    MO_CLASS_ID_CIMCVMEDIA_MOUNT_CONFIG_DEF = "cimcvmediaMountConfigDef"
    MO_CLASS_ID_CIMCVMEDIA_MOUNT_CONFIG_POLICY = "cimcvmediaMountConfigPolicy"
    MO_CLASS_ID_CIMCVMEDIA_MOUNT_INFO = "cimcvmediaMountInfo"
    MO_CLASS_ID_CLITEST_TYPE_TEST = "clitestTypeTest"
    MO_CLASS_ID_CLITEST_TYPE_TEST2 = "clitestTypeTest2"
    MO_CLASS_ID_CLITEST_TYPE_TEST_CHILD = "clitestTypeTestChild"
    MO_CLASS_ID_CLITEST_TYPE_TEST_PARENT = "clitestTypeTestParent"
    MO_CLASS_ID_COMM_CIMXML = "commCimxml"
    MO_CLASS_ID_COMM_CLIENT = "commClient"
    MO_CLASS_ID_COMM_CLIENT_ITEM = "commClientItem"
    MO_CLASS_ID_COMM_CORE_FILE = "commCoreFile"
    MO_CLASS_ID_COMM_DATE_TIME = "commDateTime"
    MO_CLASS_ID_COMM_DATE_TIME_FSM = "commDateTimeFsm"
    MO_CLASS_ID_COMM_DATE_TIME_FSM_STAGE = "commDateTimeFsmStage"
    MO_CLASS_ID_COMM_DATE_TIME_FSM_TASK = "commDateTimeFsmTask"
    MO_CLASS_ID_COMM_DEFINITION = "commDefinition"
    MO_CLASS_ID_COMM_DNS = "commDns"
    MO_CLASS_ID_COMM_DNS_PROVIDER = "commDnsProvider"
    MO_CLASS_ID_COMM_EVT_CHANNEL = "commEvtChannel"
    MO_CLASS_ID_COMM_HTTP = "commHttp"
    MO_CLASS_ID_COMM_HTTPS = "commHttps"
    MO_CLASS_ID_COMM_ITEM = "commItem"
    MO_CLASS_ID_COMM_LOCALE = "commLocale"
    MO_CLASS_ID_COMM_LOG_COMPONENT = "commLogComponent"
    MO_CLASS_ID_COMM_NTP = "commNtp"
    MO_CLASS_ID_COMM_NTP_PROVIDER = "commNtpProvider"
    MO_CLASS_ID_COMM_SHELL = "commShell"
    MO_CLASS_ID_COMM_SHELL_SVC_LIMITS = "commShellSvcLimits"
    MO_CLASS_ID_COMM_SMASH_CLP = "commSmashCLP"
    MO_CLASS_ID_COMM_SNMP = "commSnmp"
    MO_CLASS_ID_COMM_SNMP_COMMUNITY = "commSnmpCommunity"
    MO_CLASS_ID_COMM_SNMP_TRAP = "commSnmpTrap"
    MO_CLASS_ID_COMM_SNMP_TRAP_DATA = "commSnmpTrapData"
    MO_CLASS_ID_COMM_SNMP_USER = "commSnmpUser"
    MO_CLASS_ID_COMM_SSH = "commSsh"
    MO_CLASS_ID_COMM_SVC = "commSvc"
    MO_CLASS_ID_COMM_SVC_CHANNEL = "commSvcChannel"
    MO_CLASS_ID_COMM_SVC_EP = "commSvcEp"
    MO_CLASS_ID_COMM_SVC_EP_FSM = "commSvcEpFsm"
    MO_CLASS_ID_COMM_SVC_EP_FSM_STAGE = "commSvcEpFsmStage"
    MO_CLASS_ID_COMM_SVC_EP_FSM_TASK = "commSvcEpFsmTask"
    MO_CLASS_ID_COMM_SVC_LIMITS = "commSvcLimits"
    MO_CLASS_ID_COMM_SVC_POLICY = "commSvcPolicy"
    MO_CLASS_ID_COMM_SYSLOG = "commSyslog"
    MO_CLASS_ID_COMM_SYSLOG_CLIENT = "commSyslogClient"
    MO_CLASS_ID_COMM_SYSLOG_CONSOLE = "commSyslogConsole"
    MO_CLASS_ID_COMM_SYSLOG_FILE = "commSyslogFile"
    MO_CLASS_ID_COMM_SYSLOG_MONITOR = "commSyslogMonitor"
    MO_CLASS_ID_COMM_SYSLOG_SOURCE = "commSyslogSource"
    MO_CLASS_ID_COMM_TELNET = "commTelnet"
    MO_CLASS_ID_COMM_WEB = "commWeb"
    MO_CLASS_ID_COMM_WEB_CHANNEL = "commWebChannel"
    MO_CLASS_ID_COMM_WEB_SVC_LIMITS = "commWebSvcLimits"
    MO_CLASS_ID_COMM_WSMAN = "commWsman"
    MO_CLASS_ID_COMM_XML_CL_CONN_POLICY = "commXmlClConnPolicy"
    MO_CLASS_ID_COMPUTE_ABOARD = "computeABoard"
    MO_CLASS_ID_COMPUTE_ACHASSIS_DISC_POLICY = "computeAChassisDiscPolicy"
    MO_CLASS_ID_COMPUTE_AOPERATION = "computeAOperation"
    MO_CLASS_ID_COMPUTE_AUTOCONFIG_POLICY = "computeAutoconfigPolicy"
    MO_CLASS_ID_COMPUTE_BASE_SYSTEM = "computeBaseSystem"
    MO_CLASS_ID_COMPUTE_BLADE = "computeBlade"
    MO_CLASS_ID_COMPUTE_BLADE_DISC_POLICY = "computeBladeDiscPolicy"
    MO_CLASS_ID_COMPUTE_BLADE_EP = "computeBladeEp"
    MO_CLASS_ID_COMPUTE_BLADE_INHERIT_POLICY = "computeBladeInheritPolicy"
    MO_CLASS_ID_COMPUTE_BLADE_POS_QUAL = "computeBladePosQual"
    MO_CLASS_ID_COMPUTE_BOARD = "computeBoard"
    MO_CLASS_ID_COMPUTE_BOARD_CONNECTOR = "computeBoardConnector"
    MO_CLASS_ID_COMPUTE_BOARD_CONTROLLER = "computeBoardController"
    MO_CLASS_ID_COMPUTE_CARTRIDGE = "computeCartridge"
    MO_CLASS_ID_COMPUTE_CARTRIDGE_OPERATION = "computeCartridgeOperation"
    MO_CLASS_ID_COMPUTE_CHASSIS_CONN_POLICY = "computeChassisConnPolicy"
    MO_CLASS_ID_COMPUTE_CHASSIS_CONN_POLICY_OPERATION = "computeChassisConnPolicyOperation"
    MO_CLASS_ID_COMPUTE_CHASSIS_DISC_POLICY = "computeChassisDiscPolicy"
    MO_CLASS_ID_COMPUTE_CHASSIS_FEAT_MASK = "computeChassisFeatMask"
    MO_CLASS_ID_COMPUTE_CHASSIS_QUAL = "computeChassisQual"
    MO_CLASS_ID_COMPUTE_COMPUTE_DISC_POLICY = "computeComputeDiscPolicy"
    MO_CLASS_ID_COMPUTE_CONFIG_POLICY = "computeConfigPolicy"
    MO_CLASS_ID_COMPUTE_CONTAINER = "computeContainer"
    MO_CLASS_ID_COMPUTE_DEFINITION = "computeDefinition"
    MO_CLASS_ID_COMPUTE_DISC_POLICY = "computeDiscPolicy"
    MO_CLASS_ID_COMPUTE_DOMAIN_GROUP_QUAL = "computeDomainGroupQual"
    MO_CLASS_ID_COMPUTE_DOMAIN_HW_CHANGE_DISC_POLICY = "computeDomainHwChangeDiscPolicy"
    MO_CLASS_ID_COMPUTE_DOMAIN_NAME_QUAL = "computeDomainNameQual"
    MO_CLASS_ID_COMPUTE_DOMAIN_PORT_DISC_POLICY = "computeDomainPortDiscPolicy"
    MO_CLASS_ID_COMPUTE_DOMAIN_QUAL = "computeDomainQual"
    MO_CLASS_ID_COMPUTE_ENV_FEAT_MASK = "computeEnvFeatMask"
    MO_CLASS_ID_COMPUTE_EXT_BOARD = "computeExtBoard"
    MO_CLASS_ID_COMPUTE_FABRIC_ETH_MON_SRC_EP = "computeFabricEthMonSrcEp"
    MO_CLASS_ID_COMPUTE_FABRIC_ETH_MON_SRC_EP_CONT = "computeFabricEthMonSrcEpCont"
    MO_CLASS_ID_COMPUTE_FABRIC_FC_MON_SRC_EP = "computeFabricFcMonSrcEp"
    MO_CLASS_ID_COMPUTE_FABRIC_FC_MON_SRC_EP_CONT = "computeFabricFcMonSrcEpCont"
    MO_CLASS_ID_COMPUTE_FABRIC_MON_SRC_EP = "computeFabricMonSrcEp"
    MO_CLASS_ID_COMPUTE_FACTORY_RESET_OP = "computeFactoryResetOp"
    MO_CLASS_ID_COMPUTE_FACTORY_RESET_OPERATION = "computeFactoryResetOperation"
    MO_CLASS_ID_COMPUTE_FAULT_UPGRADE_FLAG = "computeFaultUpgradeFlag"
    MO_CLASS_ID_COMPUTE_FEAT_MASK = "computeFeatMask"
    MO_CLASS_ID_COMPUTE_GRAPHICS_CARD_POLICY = "computeGraphicsCardPolicy"
    MO_CLASS_ID_COMPUTE_GROUP_MEMBERSHIP = "computeGroupMembership"
    MO_CLASS_ID_COMPUTE_GROUP_MEMBERSHIP_REF = "computeGroupMembershipRef"
    MO_CLASS_ID_COMPUTE_HW_CHANGE_DISC_POLICY = "computeHwChangeDiscPolicy"
    MO_CLASS_ID_COMPUTE_IOHUB = "computeIOHub"
    MO_CLASS_ID_COMPUTE_IOHUB_ENV_STATS = "computeIOHubEnvStats"
    MO_CLASS_ID_COMPUTE_IOHUB_ENV_STATS_HIST = "computeIOHubEnvStatsHist"
    MO_CLASS_ID_COMPUTE_INIT_CONFIG_POLICY = "computeInitConfigPolicy"
    MO_CLASS_ID_COMPUTE_INSTANCE = "computeInstance"
    MO_CLASS_ID_COMPUTE_INSTANCE_ID_QUAL = "computeInstanceIdQual"
    MO_CLASS_ID_COMPUTE_INSTANCE_MAPPING = "computeInstanceMapping"
    MO_CLASS_ID_COMPUTE_ITEM = "computeItem"
    MO_CLASS_ID_COMPUTE_LOCAL_TEMPL_DEF = "computeLocalTemplDef"
    MO_CLASS_ID_COMPUTE_LOGICAL = "computeLogical"
    MO_CLASS_ID_COMPUTE_MB_POWER_STATS = "computeMbPowerStats"
    MO_CLASS_ID_COMPUTE_MB_POWER_STATS_HIST = "computeMbPowerStatsHist"
    MO_CLASS_ID_COMPUTE_MB_TEMP_STATS = "computeMbTempStats"
    MO_CLASS_ID_COMPUTE_MB_TEMP_STATS_HIST = "computeMbTempStatsHist"
    MO_CLASS_ID_COMPUTE_NETWORK_FEAT_MASK = "computeNetworkFeatMask"
    MO_CLASS_ID_COMPUTE_OWNER_QUAL = "computeOwnerQual"
    MO_CLASS_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS = "computePCIeFatalCompletionStats"
    MO_CLASS_ID_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST = "computePCIeFatalCompletionStatsHist"
    MO_CLASS_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS = "computePCIeFatalProtocolStats"
    MO_CLASS_ID_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_HIST = "computePCIeFatalProtocolStatsHist"
    MO_CLASS_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS = "computePCIeFatalReceiveStats"
    MO_CLASS_ID_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST = "computePCIeFatalReceiveStatsHist"
    MO_CLASS_ID_COMPUTE_PCIE_FATAL_STATS = "computePCIeFatalStats"
    MO_CLASS_ID_COMPUTE_PCIE_FATAL_STATS_HIST = "computePCIeFatalStatsHist"
    MO_CLASS_ID_COMPUTE_PHYSICAL = "computePhysical"
    MO_CLASS_ID_COMPUTE_PHYSICAL_ASSOC_CTX = "computePhysicalAssocCtx"
    MO_CLASS_ID_COMPUTE_PHYSICAL_EXTENSION = "computePhysicalExtension"
    MO_CLASS_ID_COMPUTE_PHYSICAL_OPERATION = "computePhysicalOperation"
    MO_CLASS_ID_COMPUTE_PHYSICAL_QUAL = "computePhysicalQual"
    MO_CLASS_ID_COMPUTE_PLACEABLE = "computePlaceable"
    MO_CLASS_ID_COMPUTE_PLACED = "computePlaced"
    MO_CLASS_ID_COMPUTE_POOL = "computePool"
    MO_CLASS_ID_COMPUTE_POOL_POLICY_REF = "computePoolPolicyRef"
    MO_CLASS_ID_COMPUTE_POOLABLE = "computePoolable"
    MO_CLASS_ID_COMPUTE_POOLED = "computePooled"
    MO_CLASS_ID_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT = "computePooledEnclosureComputeSlot"
    MO_CLASS_ID_COMPUTE_POOLED_PHYSICAL = "computePooledPhysical"
    MO_CLASS_ID_COMPUTE_POOLED_RACK_UNIT = "computePooledRackUnit"
    MO_CLASS_ID_COMPUTE_POOLED_SLOT = "computePooledSlot"
    MO_CLASS_ID_COMPUTE_POOLING_POLICY = "computePoolingPolicy"
    MO_CLASS_ID_COMPUTE_PORT_DISC_POLICY = "computePortDiscPolicy"
    MO_CLASS_ID_COMPUTE_POWER_SYNC_DEF = "computePowerSyncDef"
    MO_CLASS_ID_COMPUTE_POWER_SYNC_POLICY = "computePowerSyncPolicy"
    MO_CLASS_ID_COMPUTE_PRODUCT_FAMILY_QUAL = "computeProductFamilyQual"
    MO_CLASS_ID_COMPUTE_PROFILE = "computeProfile"
    MO_CLASS_ID_COMPUTE_PSU_DEF = "computePsuDef"
    MO_CLASS_ID_COMPUTE_PSU_POLICY = "computePsuPolicy"
    MO_CLASS_ID_COMPUTE_QUAL = "computeQual"
    MO_CLASS_ID_COMPUTE_QUAL_BASE = "computeQualBase"
    MO_CLASS_ID_COMPUTE_QUAL_ITEM = "computeQualItem"
    MO_CLASS_ID_COMPUTE_QUALIFIED_POLICY = "computeQualifiedPolicy"
    MO_CLASS_ID_COMPUTE_RACK_POS_QUAL = "computeRackPosQual"
    MO_CLASS_ID_COMPUTE_RACK_QUAL = "computeRackQual"
    MO_CLASS_ID_COMPUTE_RACK_UNIT = "computeRackUnit"
    MO_CLASS_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS = "computeRackUnitMbTempStats"
    MO_CLASS_ID_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST = "computeRackUnitMbTempStatsHist"
    MO_CLASS_ID_COMPUTE_REBOOT_LOG = "computeRebootLog"
    MO_CLASS_ID_COMPUTE_REMOTE_OP_STATUS = "computeRemoteOpStatus"
    MO_CLASS_ID_COMPUTE_REQUIREMENT = "computeRequirement"
    MO_CLASS_ID_COMPUTE_RESOURCE_AGGR_EP = "computeResourceAggrEp"
    MO_CLASS_ID_COMPUTE_RESOURCE_SET = "computeResourceSet"
    MO_CLASS_ID_COMPUTE_RESOURCE_SET_MANAGER = "computeResourceSetManager"
    MO_CLASS_ID_COMPUTE_RESOURCE_SET_MEMBER = "computeResourceSetMember"
    MO_CLASS_ID_COMPUTE_SCRUB_POLICY = "computeScrubPolicy"
    MO_CLASS_ID_COMPUTE_SERVER = "computeServer"
    MO_CLASS_ID_COMPUTE_SERVER_DISC_POLICY = "computeServerDiscPolicy"
    MO_CLASS_ID_COMPUTE_SERVER_FEAT_MASK = "computeServerFeatMask"
    MO_CLASS_ID_COMPUTE_SERVER_MGMT_POLICY = "computeServerMgmtPolicy"
    MO_CLASS_ID_COMPUTE_SERVER_UNIT = "computeServerUnit"
    MO_CLASS_ID_COMPUTE_SESSION = "computeSession"
    MO_CLASS_ID_COMPUTE_SITE_QUAL = "computeSiteQual"
    MO_CLASS_ID_COMPUTE_SLOT_ENTITY = "computeSlotEntity"
    MO_CLASS_ID_COMPUTE_SLOT_QUAL = "computeSlotQual"
    MO_CLASS_ID_COMPUTE_STORAGE_FEAT_MASK = "computeStorageFeatMask"
    MO_CLASS_ID_COMPUTE_SYSTEM = "computeSystem"
    MO_CLASS_ID_COMPUTE_SYSTEM_ADDR_QUAL = "computeSystemAddrQual"
    MO_CLASS_ID_COMPUTE_SYSTEM_FSM = "computeSystemFsm"
    MO_CLASS_ID_COMPUTE_SYSTEM_FSM_STAGE = "computeSystemFsmStage"
    MO_CLASS_ID_COMPUTE_SYSTEM_FSM_TASK = "computeSystemFsmTask"
    MO_CLASS_ID_COMPUTE_SYSTEM_QUAL = "computeSystemQual"
    MO_CLASS_ID_COMPUTE_TEMPLATE = "computeTemplate"
    MO_CLASS_ID_COMPUTE_TEMPLATE_MAPPING = "computeTemplateMapping"
    MO_CLASS_ID_COMPUTE_USER = "computeUser"
    MO_CLASS_ID_COMPUTE_USER_EP = "computeUserEp"
    MO_CLASS_ID_CONDITION_IMMUTABLE = "conditionImmutable"
    MO_CLASS_ID_CONDITION_INFO = "conditionInfo"
    MO_CLASS_ID_CONDITION_LOG = "conditionLog"
    MO_CLASS_ID_CONDITION_LOGGABLE = "conditionLoggable"
    MO_CLASS_ID_CONDITION_MULTI_INSTANCE_IMMUTABLE = "conditionMultiInstanceImmutable"
    MO_CLASS_ID_CONDITION_MUTABLE = "conditionMutable"
    MO_CLASS_ID_CONDITION_POLICY = "conditionPolicy"
    MO_CLASS_ID_CONDITION_REPORTABLE = "conditionReportable"
    MO_CLASS_ID_CONFIG_ABS_DB_CONFIG = "configAbsDbConfig"
    MO_CLASS_ID_CONFIG_ACK_ITEM = "configAckItem"
    MO_CLASS_ID_CONFIG_ADAPTOR_ITEM = "configAdaptorItem"
    MO_CLASS_ID_CONFIG_APP_IMPACT_RESPONSE = "configAppImpactResponse"
    MO_CLASS_ID_CONFIG_BACKUP = "configBackup"
    MO_CLASS_ID_CONFIG_BACKUP_FSM = "configBackupFsm"
    MO_CLASS_ID_CONFIG_BACKUP_FSM_STAGE = "configBackupFsmStage"
    MO_CLASS_ID_CONFIG_BACKUP_FSM_TASK = "configBackupFsmTask"
    MO_CLASS_ID_CONFIG_CARTRIDGE_FILTER = "configCartridgeFilter"
    MO_CLASS_ID_CONFIG_CARTRIDGE_ITEM = "configCartridgeItem"
    MO_CLASS_ID_CONFIG_CATALOGUE = "configCatalogue"
    MO_CLASS_ID_CONFIG_CHASSIS_FILTER = "configChassisFilter"
    MO_CLASS_ID_CONFIG_CHASSIS_ITEM = "configChassisItem"
    MO_CLASS_ID_CONFIG_COMPONENTS_FILTER = "configComponentsFilter"
    MO_CLASS_ID_CONFIG_CONSUMER_CATALOGUE = "configConsumerCatalogue"
    MO_CLASS_ID_CONFIG_CONSUMER_CATALOGUE_FSM = "configConsumerCatalogueFsm"
    MO_CLASS_ID_CONFIG_CONSUMER_CATALOGUE_FSM_STAGE = "configConsumerCatalogueFsmStage"
    MO_CLASS_ID_CONFIG_CONSUMER_CATALOGUE_FSM_TASK = "configConsumerCatalogueFsmTask"
    MO_CLASS_ID_CONFIG_CONTROLLER_ITEM = "configControllerItem"
    MO_CLASS_ID_CONFIG_CPU_INFO = "configCpuInfo"
    MO_CLASS_ID_CONFIG_CPU_ITEM = "configCpuItem"
    MO_CLASS_ID_CONFIG_CRYPTO_CARD_ITEM = "configCryptoCardItem"
    MO_CLASS_ID_CONFIG_DB_CONFIG = "configDbConfig"
    MO_CLASS_ID_CONFIG_DOMAIN_FILTER = "configDomainFilter"
    MO_CLASS_ID_CONFIG_DOMAIN_ITEM = "configDomainItem"
    MO_CLASS_ID_CONFIG_FABRIC_INTERCONNECT_FILTER = "configFabricInterconnectFilter"
    MO_CLASS_ID_CONFIG_FABRIC_INTERCONNECT_ITEM = "configFabricInterconnectItem"
    MO_CLASS_ID_CONFIG_FAN_ITEM = "configFanItem"
    MO_CLASS_ID_CONFIG_FEX_FILTER = "configFexFilter"
    MO_CLASS_ID_CONFIG_FEX_ITEM = "configFexItem"
    MO_CLASS_ID_CONFIG_FILTER_GROUP = "configFilterGroup"
    MO_CLASS_ID_CONFIG_FILTER_ITEM = "configFilterItem"
    MO_CLASS_ID_CONFIG_FSM = "configFsm"
    MO_CLASS_ID_CONFIG_FSM_STAGE = "configFsmStage"
    MO_CLASS_ID_CONFIG_GRAPHICS_CARD_ITEM = "configGraphicsCardItem"
    MO_CLASS_ID_CONFIG_IOMITEM = "configIOMItem"
    MO_CLASS_ID_CONFIG_IMPACT = "configImpact"
    MO_CLASS_ID_CONFIG_IMPACT_ANALYZER = "configImpactAnalyzer"
    MO_CLASS_ID_CONFIG_IMPACT_ANALYZER_EP = "configImpactAnalyzerEp"
    MO_CLASS_ID_CONFIG_IMPACT_RESPONSE = "configImpactResponse"
    MO_CLASS_ID_CONFIG_INPUT_CONFIG = "configInputConfig"
    MO_CLASS_ID_CONFIG_INPUT_CONFIG_SET = "configInputConfigSet"
    MO_CLASS_ID_CONFIG_LOCAL_DISK_ITEM = "configLocalDiskItem"
    MO_CLASS_ID_CONFIG_LUN_ITEM = "configLunItem"
    MO_CLASS_ID_CONFIG_MANAGED_EP_IMPACT_RESPONSE = "configManagedEpImpactResponse"
    MO_CLASS_ID_CONFIG_MEMORY_ITEM = "configMemoryItem"
    MO_CLASS_ID_CONFIG_MOTHERBOARD_ITEM = "configMotherboardItem"
    MO_CLASS_ID_CONFIG_NET_REF_ITEM = "configNetRefItem"
    MO_CLASS_ID_CONFIG_ORG_ITEM = "configOrgItem"
    MO_CLASS_ID_CONFIG_PSUITEM = "configPSUItem"
    MO_CLASS_ID_CONFIG_POLICY_USAGE_ITEM = "configPolicyUsageItem"
    MO_CLASS_ID_CONFIG_PORT_ITEM = "configPortItem"
    MO_CLASS_ID_CONFIG_SEARCH_OPTIONS = "configSearchOptions"
    MO_CLASS_ID_CONFIG_SEARCH_RESULT = "configSearchResult"
    MO_CLASS_ID_CONFIG_SERVER_FILTER = "configServerFilter"
    MO_CLASS_ID_CONFIG_SERVER_ITEM = "configServerItem"
    MO_CLASS_ID_CONFIG_SERVICE_PROFILE_FILTER = "configServiceProfileFilter"
    MO_CLASS_ID_CONFIG_SORTER = "configSorter"
    MO_CLASS_ID_CONFIG_SPOT_LIGHT_ITEM = "configSpotLightItem"
    MO_CLASS_ID_CONFIG_STORAGE_ARRAY_PROFILE_FILTER = "configStorageArrayProfileFilter"
    MO_CLASS_ID_CONFIG_STORAGE_BLADE_FILTER = "configStorageBladeFilter"
    MO_CLASS_ID_CONFIG_STORAGE_ITEM = "configStorageItem"
    MO_CLASS_ID_CONFIG_UCIMPACT = "configUCImpact"
    MO_CLASS_ID_CONSUMER_INST = "consumerInst"
    MO_CLASS_ID_CONSUMER_INST_FSM = "consumerInstFsm"
    MO_CLASS_ID_CONSUMER_INST_FSM_STAGE = "consumerInstFsmStage"
    MO_CLASS_ID_CONSUMER_INST_FSM_TASK = "consumerInstFsmTask"
    MO_CLASS_ID_CONSUMER_UNIVERSE = "consumerUniverse"
    MO_CLASS_ID_CONTROLLER_EP = "controllerEp"
    MO_CLASS_ID_CONTROLLER_EP_FSM = "controllerEpFsm"
    MO_CLASS_ID_CONTROLLER_EP_FSM_STAGE = "controllerEpFsmStage"
    MO_CLASS_ID_CONTROLLER_EP_FSM_TASK = "controllerEpFsmTask"
    MO_CLASS_ID_CPMAINT_ACK = "cpmaintAck"
    MO_CLASS_ID_CPMAINT_MAINT_POLICY = "cpmaintMaintPolicy"
    MO_CLASS_ID_DCX_VIF = "dcxVIf"
    MO_CLASS_ID_DCX_VC = "dcxVc"
    MO_CLASS_ID_DIAG_CTRL = "diagCtrl"
    MO_CLASS_ID_DIAG_LOG_EP = "diagLogEp"
    MO_CLASS_ID_DIAG_MEMORY_TEST = "diagMemoryTest"
    MO_CLASS_ID_DIAG_RSLT = "diagRslt"
    MO_CLASS_ID_DIAG_RUN_POLICY = "diagRunPolicy"
    MO_CLASS_ID_DIAG_SRV_CAP_PROVIDER = "diagSrvCapProvider"
    MO_CLASS_ID_DIAG_SRV_CTRL = "diagSrvCtrl"
    MO_CLASS_ID_DIAG_SRV_CTRL_OPERATION = "diagSrvCtrlOperation"
    MO_CLASS_ID_DIAG_SRV_CTRL_OPERATION_FSM = "diagSrvCtrlOperationFsm"
    MO_CLASS_ID_DIAG_SRV_CTRL_OPERATION_FSM_STAGE = "diagSrvCtrlOperationFsmStage"
    MO_CLASS_ID_DIAG_SRV_CTRL_OPERATION_FSM_TASK = "diagSrvCtrlOperationFsmTask"
    MO_CLASS_ID_DIAG_TEST = "diagTest"
    MO_CLASS_ID_DOMAIN_CHASSIS_FEATURE = "domainChassisFeature"
    MO_CLASS_ID_DOMAIN_CHASSIS_PARAM = "domainChassisParam"
    MO_CLASS_ID_DOMAIN_CHASSIS_PROFILE_ITEM = "domainChassisProfileItem"
    MO_CLASS_ID_DOMAIN_ENVIRONMENT_FEATURE = "domainEnvironmentFeature"
    MO_CLASS_ID_DOMAIN_ENVIRONMENT_PARAM = "domainEnvironmentParam"
    MO_CLASS_ID_DOMAIN_EP = "domainEp"
    MO_CLASS_ID_DOMAIN_FAMILY_CAP_PROVIDER = "domainFamilyCapProvider"
    MO_CLASS_ID_DOMAIN_FEATURE = "domainFeature"
    MO_CLASS_ID_DOMAIN_FEATURE_CATALOG = "domainFeatureCatalog"
    MO_CLASS_ID_DOMAIN_NETWORK_FEATURE = "domainNetworkFeature"
    MO_CLASS_ID_DOMAIN_NETWORK_PARAM = "domainNetworkParam"
    MO_CLASS_ID_DOMAIN_PARAMETER = "domainParameter"
    MO_CLASS_ID_DOMAIN_PROFILE = "domainProfile"
    MO_CLASS_ID_DOMAIN_PROFILE_FSM = "domainProfileFsm"
    MO_CLASS_ID_DOMAIN_PROFILE_FSM_STAGE = "domainProfileFsmStage"
    MO_CLASS_ID_DOMAIN_PROFILE_FSM_TASK = "domainProfileFsmTask"
    MO_CLASS_ID_DOMAIN_SERVER_FEATURE = "domainServerFeature"
    MO_CLASS_ID_DOMAIN_SERVER_PARAM = "domainServerParam"
    MO_CLASS_ID_DOMAIN_SERVICE_PROFILE_ITEM = "domainServiceProfileItem"
    MO_CLASS_ID_DOMAIN_STORAGE_FEATURE = "domainStorageFeature"
    MO_CLASS_ID_DOMAIN_STORAGE_PARAM = "domainStorageParam"
    MO_CLASS_ID_DPSEC_MAC = "dpsecMac"
    MO_CLASS_ID_DUPE_CHANGE_TRACKER = "dupeChangeTracker"
    MO_CLASS_ID_DUPE_CHANGE_TRACKER_EP = "dupeChangeTrackerEp"
    MO_CLASS_ID_DUPE_CHANGE_TRACKER_EP_FSM = "dupeChangeTrackerEpFsm"
    MO_CLASS_ID_DUPE_CHANGE_TRACKER_EP_FSM_STAGE = "dupeChangeTrackerEpFsmStage"
    MO_CLASS_ID_DUPE_CHANGE_TRACKER_EP_FSM_TASK = "dupeChangeTrackerEpFsmTask"
    MO_CLASS_ID_DUPE_EP = "dupeEp"
    MO_CLASS_ID_DUPE_EXT_REQUESTOR = "dupeExtRequestor"
    MO_CLASS_ID_DUPE_INT_REQUESTOR = "dupeIntRequestor"
    MO_CLASS_ID_DUPE_REQUESTOR = "dupeRequestor"
    MO_CLASS_ID_DUPE_SCOPE = "dupeScope"
    MO_CLASS_ID_DUPE_SCOPE_EP = "dupeScopeEp"
    MO_CLASS_ID_DUPE_SCOPE_RESULT = "dupeScopeResult"
    MO_CLASS_ID_EPQOS_DEFINITION = "epqosDefinition"
    MO_CLASS_ID_EPQOS_EGRESS = "epqosEgress"
    MO_CLASS_ID_EPQOS_ITEM = "epqosItem"
    MO_CLASS_ID_EQUIPMENT_ABEH_CAP = "equipmentABehCap"
    MO_CLASS_ID_EQUIPMENT_ADVANCED_BOOT_ORDER = "equipmentAdvancedBootOrder"
    MO_CLASS_ID_EQUIPMENT_ASSOC_CTX = "equipmentAssocCtx"
    MO_CLASS_ID_EQUIPMENT_BEACON_LED = "equipmentBeaconLed"
    MO_CLASS_ID_EQUIPMENT_BEH_CAP = "equipmentBehCap"
    MO_CLASS_ID_EQUIPMENT_BINDING = "equipmentBinding"
    MO_CLASS_ID_EQUIPMENT_BLADE_CAP_PROVIDER = "equipmentBladeCapProvider"
    MO_CLASS_ID_EQUIPMENT_BREAKOUT_CAP = "equipmentBreakoutCap"
    MO_CLASS_ID_EQUIPMENT_CPMETA = "equipmentCPMeta"
    MO_CLASS_ID_EQUIPMENT_CARD = "equipmentCard"
    MO_CLASS_ID_EQUIPMENT_CARTRIDGE_CAP_PROVIDER = "equipmentCartridgeCapProvider"
    MO_CLASS_ID_EQUIPMENT_CHASSIS = "equipmentChassis"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_ASSOC_CTX = "equipmentChassisAssocCtx"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_CAP_PROVIDER = "equipmentChassisCapProvider"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_ISSUES = "equipmentChassisIssues"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_OPERATION = "equipmentChassisOperation"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_POS_QUAL = "equipmentChassisPosQual"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE = "equipmentChassisProfile"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE_ASSOC_CTX = "equipmentChassisProfileAssocCtx"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE_BINDING = "equipmentChassisProfileBinding"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE_FSM = "equipmentChassisProfileFsm"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE = "equipmentChassisProfileFsmStage"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_PROFILE_FSM_TASK = "equipmentChassisProfileFsmTask"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_QUAL = "equipmentChassisQual"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_REQUIREMENT = "equipmentChassisRequirement"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_STATS = "equipmentChassisStats"
    MO_CLASS_ID_EQUIPMENT_CHASSIS_STATS_HIST = "equipmentChassisStatsHist"
    MO_CLASS_ID_EQUIPMENT_CIMC_VMEDIA = "equipmentCimcVmedia"
    MO_CLASS_ID_EQUIPMENT_COMPUTE_CONN = "equipmentComputeConn"
    MO_CLASS_ID_EQUIPMENT_COMPUTE_CONN_POLICY = "equipmentComputeConnPolicy"
    MO_CLASS_ID_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER = "equipmentComputePhysicalCapProvider"
    MO_CLASS_ID_EQUIPMENT_DEFINITION = "equipmentDefinition"
    MO_CLASS_ID_EQUIPMENT_DRIVE_SEC_CAP = "equipmentDriveSecCap"
    MO_CLASS_ID_EQUIPMENT_FAN = "equipmentFan"
    MO_CLASS_ID_EQUIPMENT_FAN_MODULE = "equipmentFanModule"
    MO_CLASS_ID_EQUIPMENT_FAN_MODULE_CAP_PROVIDER = "equipmentFanModuleCapProvider"
    MO_CLASS_ID_EQUIPMENT_FAN_MODULE_STATS = "equipmentFanModuleStats"
    MO_CLASS_ID_EQUIPMENT_FAN_MODULE_STATS_HIST = "equipmentFanModuleStatsHist"
    MO_CLASS_ID_EQUIPMENT_FAN_STATS = "equipmentFanStats"
    MO_CLASS_ID_EQUIPMENT_FAN_STATS_HIST = "equipmentFanStatsHist"
    MO_CLASS_ID_EQUIPMENT_FEX = "equipmentFex"
    MO_CLASS_ID_EQUIPMENT_FEX_CAP_PROVIDER = "equipmentFexCapProvider"
    MO_CLASS_ID_EQUIPMENT_FEX_ENV_STATS = "equipmentFexEnvStats"
    MO_CLASS_ID_EQUIPMENT_FEX_ENV_STATS_HIST = "equipmentFexEnvStatsHist"
    MO_CLASS_ID_EQUIPMENT_FEX_OPERATION = "equipmentFexOperation"
    MO_CLASS_ID_EQUIPMENT_FEX_POWER_SUMMARY = "equipmentFexPowerSummary"
    MO_CLASS_ID_EQUIPMENT_FEX_POWER_SUMMARY_HIST = "equipmentFexPowerSummaryHist"
    MO_CLASS_ID_EQUIPMENT_FEX_PSU_INPUT_STATS = "equipmentFexPsuInputStats"
    MO_CLASS_ID_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST = "equipmentFexPsuInputStatsHist"
    MO_CLASS_ID_EQUIPMENT_FRU_CAP_PROVIDER = "equipmentFruCapProvider"
    MO_CLASS_ID_EQUIPMENT_FRU_VARIANT = "equipmentFruVariant"
    MO_CLASS_ID_EQUIPMENT_GEM_CAP_PROVIDER = "equipmentGemCapProvider"
    MO_CLASS_ID_EQUIPMENT_HEALTH_LED = "equipmentHealthLed"
    MO_CLASS_ID_EQUIPMENT_HOLDER = "equipmentHolder"
    MO_CLASS_ID_EQUIPMENT_HOLDER_CAP_PROVIDER = "equipmentHolderCapProvider"
    MO_CLASS_ID_EQUIPMENT_HOST_IF_CAP_PROVIDER = "equipmentHostIfCapProvider"
    MO_CLASS_ID_EQUIPMENT_HW_CAP_PROVIDER = "equipmentHwCapProvider"
    MO_CLASS_ID_EQUIPMENT_IOCARD = "equipmentIOCard"
    MO_CLASS_ID_EQUIPMENT_IOCARD_BASE = "equipmentIOCardBase"
    MO_CLASS_ID_EQUIPMENT_IOCARD_CAP_PROVIDER = "equipmentIOCardCapProvider"
    MO_CLASS_ID_EQUIPMENT_IOCARD_STATS = "equipmentIOCardStats"
    MO_CLASS_ID_EQUIPMENT_IOCARD_STATS_HIST = "equipmentIOCardStatsHist"
    MO_CLASS_ID_EQUIPMENT_IMPLIED_STORAGE_ENCLOSURE_DEF = "equipmentImpliedStorageEnclosureDef"
    MO_CLASS_ID_EQUIPMENT_INDICATOR_LED = "equipmentIndicatorLed"
    MO_CLASS_ID_EQUIPMENT_INSTANCE = "equipmentInstance"
    MO_CLASS_ID_EQUIPMENT_INSTANCE_MAPPING = "equipmentInstanceMapping"
    MO_CLASS_ID_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER = "equipmentIntegratedComponentCapProvider"
    MO_CLASS_ID_EQUIPMENT_ITEM = "equipmentItem"
    MO_CLASS_ID_EQUIPMENT_LED = "equipmentLed"
    MO_CLASS_ID_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER = "equipmentLocalDiskCapProvider"
    MO_CLASS_ID_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER = "equipmentLocalDiskControllerCapProvider"
    MO_CLASS_ID_EQUIPMENT_LOCAL_DISK_DEF = "equipmentLocalDiskDef"
    MO_CLASS_ID_EQUIPMENT_LOCAL_TEMPL_DEF = "equipmentLocalTemplDef"
    MO_CLASS_ID_EQUIPMENT_LOCATOR_LED = "equipmentLocatorLed"
    MO_CLASS_ID_EQUIPMENT_LOCATOR_LED_OPERATION = "equipmentLocatorLedOperation"
    MO_CLASS_ID_EQUIPMENT_MANUFACTURING_DEF = "equipmentManufacturingDef"
    MO_CLASS_ID_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER = "equipmentMemoryUnitCapProvider"
    MO_CLASS_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS = "equipmentNetworkElementFanStats"
    MO_CLASS_ID_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST = "equipmentNetworkElementFanStatsHist"
    MO_CLASS_ID_EQUIPMENT_PCI_DEF = "equipmentPciDef"
    MO_CLASS_ID_EQUIPMENT_PHYSICAL_QUAL = "equipmentPhysicalQual"
    MO_CLASS_ID_EQUIPMENT_PICTURE = "equipmentPicture"
    MO_CLASS_ID_EQUIPMENT_PLACEABLE = "equipmentPlaceable"
    MO_CLASS_ID_EQUIPMENT_PLACED = "equipmentPlaced"
    MO_CLASS_ID_EQUIPMENT_POOL = "equipmentPool"
    MO_CLASS_ID_EQUIPMENT_POOLABLE = "equipmentPoolable"
    MO_CLASS_ID_EQUIPMENT_POOLED = "equipmentPooled"
    MO_CLASS_ID_EQUIPMENT_POOLING_POLICY = "equipmentPoolingPolicy"
    MO_CLASS_ID_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER = "equipmentProcessorUnitCapProvider"
    MO_CLASS_ID_EQUIPMENT_PSU = "equipmentPsu"
    MO_CLASS_ID_EQUIPMENT_PSU_CAP_PROVIDER = "equipmentPsuCapProvider"
    MO_CLASS_ID_EQUIPMENT_PSU_INPUT_STATS = "equipmentPsuInputStats"
    MO_CLASS_ID_EQUIPMENT_PSU_INPUT_STATS_HIST = "equipmentPsuInputStatsHist"
    MO_CLASS_ID_EQUIPMENT_PSU_OUTPUT_STATS = "equipmentPsuOutputStats"
    MO_CLASS_ID_EQUIPMENT_PSU_OUTPUT_STATS_HIST = "equipmentPsuOutputStatsHist"
    MO_CLASS_ID_EQUIPMENT_PSU_STATS = "equipmentPsuStats"
    MO_CLASS_ID_EQUIPMENT_PSU_STATS_HIST = "equipmentPsuStatsHist"
    MO_CLASS_ID_EQUIPMENT_QUAL = "equipmentQual"
    MO_CLASS_ID_EQUIPMENT_QUAL_BASE = "equipmentQualBase"
    MO_CLASS_ID_EQUIPMENT_QUAL_ITEM = "equipmentQualItem"
    MO_CLASS_ID_EQUIPMENT_QUALIFIED_POLICY = "equipmentQualifiedPolicy"
    MO_CLASS_ID_EQUIPMENT_RACK_UNIT_CAP_PROVIDER = "equipmentRackUnitCapProvider"
    MO_CLASS_ID_EQUIPMENT_RACK_UNIT_FAN_STATS = "equipmentRackUnitFanStats"
    MO_CLASS_ID_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST = "equipmentRackUnitFanStatsHist"
    MO_CLASS_ID_EQUIPMENT_RACK_UNIT_PSU_STATS = "equipmentRackUnitPsuStats"
    MO_CLASS_ID_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST = "equipmentRackUnitPsuStatsHist"
    MO_CLASS_ID_EQUIPMENT_REQUIREMENT = "equipmentRequirement"
    MO_CLASS_ID_EQUIPMENT_SECURE_BOOT = "equipmentSecureBoot"
    MO_CLASS_ID_EQUIPMENT_SERVER_FEATURE_CAP = "equipmentServerFeatureCap"
    MO_CLASS_ID_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER = "equipmentServerUnitCapProvider"
    MO_CLASS_ID_EQUIPMENT_SHARED_IOMODULE = "equipmentSharedIOModule"
    MO_CLASS_ID_EQUIPMENT_SIOC_TEMP_STATS = "equipmentSiocTempStats"
    MO_CLASS_ID_EQUIPMENT_SIOC_TEMP_STATS_HIST = "equipmentSiocTempStatsHist"
    MO_CLASS_ID_EQUIPMENT_SLOT_ENCLOSURE = "equipmentSlotEnclosure"
    MO_CLASS_ID_EQUIPMENT_STATEFUL = "equipmentStateful"
    MO_CLASS_ID_EQUIPMENT_STATEFUL_BLADE_COMP = "equipmentStatefulBladeComp"
    MO_CLASS_ID_EQUIPMENT_STATEFUL_CH_COMP = "equipmentStatefulChComp"
    MO_CLASS_ID_EQUIPMENT_STORAGE_PROCESSOR_CAP = "equipmentStorageProcessorCap"
    MO_CLASS_ID_EQUIPMENT_SWITCH_CAP_PROVIDER = "equipmentSwitchCapProvider"
    MO_CLASS_ID_EQUIPMENT_SWITCH_CARD = "equipmentSwitchCard"
    MO_CLASS_ID_EQUIPMENT_SWITCH_IOCARD = "equipmentSwitchIOCard"
    MO_CLASS_ID_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER = "equipmentSwitchIOCardCapProvider"
    MO_CLASS_ID_EQUIPMENT_SYSTEM_FRU_CAP_PROVIDER = "equipmentSystemFruCapProvider"
    MO_CLASS_ID_EQUIPMENT_SYSTEM_IOCONTROLLER = "equipmentSystemIOController"
    MO_CLASS_ID_EQUIPMENT_SYSTEM_IOCONTROLLER_OPERATION = "equipmentSystemIOControllerOperation"
    MO_CLASS_ID_EQUIPMENT_TEMPLATE = "equipmentTemplate"
    MO_CLASS_ID_EQUIPMENT_TEMPLATE_MAPPING = "equipmentTemplateMapping"
    MO_CLASS_ID_EQUIPMENT_TIER = "equipmentTier"
    MO_CLASS_ID_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER = "equipmentUnifiedPortCapProvider"
    MO_CLASS_ID_EQUIPMENT_XCVR = "equipmentXcvr"
    MO_CLASS_ID_ETHER_ERR_STATS = "etherErrStats"
    MO_CLASS_ID_ETHER_ERR_STATS_HIST = "etherErrStatsHist"
    MO_CLASS_ID_ETHER_FCOE_INTERFACE_STATS = "etherFcoeInterfaceStats"
    MO_CLASS_ID_ETHER_FCOE_INTERFACE_STATS_HIST = "etherFcoeInterfaceStatsHist"
    MO_CLASS_ID_ETHER_LOSS_STATS = "etherLossStats"
    MO_CLASS_ID_ETHER_LOSS_STATS_HIST = "etherLossStatsHist"
    MO_CLASS_ID_ETHER_PIO = "etherPIo"
    MO_CLASS_ID_ETHER_PAUSE_STATS = "etherPauseStats"
    MO_CLASS_ID_ETHER_PAUSE_STATS_HIST = "etherPauseStatsHist"
    MO_CLASS_ID_ETHER_RX_STATS = "etherRxStats"
    MO_CLASS_ID_ETHER_RX_STATS_HIST = "etherRxStatsHist"
    MO_CLASS_ID_ETHER_SERVER_INT_FIO = "etherServerIntFIo"
    MO_CLASS_ID_ETHER_SWITCH_INT_FIO = "etherSwitchIntFIo"
    MO_CLASS_ID_ETHER_TX_STATS = "etherTxStats"
    MO_CLASS_ID_ETHER_TX_STATS_HIST = "etherTxStatsHist"
    MO_CLASS_ID_EVENT_APPLICATION = "eventApplication"
    MO_CLASS_ID_EVENT_EP_CTRL = "eventEpCtrl"
    MO_CLASS_ID_EVENT_HOLDER = "eventHolder"
    MO_CLASS_ID_EVENT_INST = "eventInst"
    MO_CLASS_ID_EVENT_LOG = "eventLog"
    MO_CLASS_ID_EVENT_POLICY = "eventPolicy"
    MO_CLASS_ID_EVENT_RECORD = "eventRecord"
    MO_CLASS_ID_EXTMGMT_ARP_TARGETS = "extmgmtArpTargets"
    MO_CLASS_ID_EXTMGMT_GATEWAY_PING = "extmgmtGatewayPing"
    MO_CLASS_ID_EXTMGMT_IF_MON_POLICY = "extmgmtIfMonPolicy"
    MO_CLASS_ID_EXTMGMT_MII_STATUS = "extmgmtMiiStatus"
    MO_CLASS_ID_EXTMGMT_NDISC_TARGETS = "extmgmtNdiscTargets"
    MO_CLASS_ID_EXTPOL_CLIENT = "extpolClient"
    MO_CLASS_ID_EXTPOL_CLIENT_CONT = "extpolClientCont"
    MO_CLASS_ID_EXTPOL_CLIENT_FSM = "extpolClientFsm"
    MO_CLASS_ID_EXTPOL_CLIENT_FSM_STAGE = "extpolClientFsmStage"
    MO_CLASS_ID_EXTPOL_CLIENT_FSM_TASK = "extpolClientFsmTask"
    MO_CLASS_ID_EXTPOL_CONNECTOR = "extpolConnector"
    MO_CLASS_ID_EXTPOL_CONNECTOR_CONTAINER = "extpolConnectorContainer"
    MO_CLASS_ID_EXTPOL_CONTROLLER = "extpolController"
    MO_CLASS_ID_EXTPOL_CONTROLLER_CONT = "extpolControllerCont"
    MO_CLASS_ID_EXTPOL_DOMAIN = "extpolDomain"
    MO_CLASS_ID_EXTPOL_EP = "extpolEp"
    MO_CLASS_ID_EXTPOL_EP_FSM = "extpolEpFsm"
    MO_CLASS_ID_EXTPOL_EP_FSM_STAGE = "extpolEpFsmStage"
    MO_CLASS_ID_EXTPOL_EP_FSM_TASK = "extpolEpFsmTask"
    MO_CLASS_ID_EXTPOL_HBSTATUS = "extpolHBStatus"
    MO_CLASS_ID_EXTPOL_PROVIDER = "extpolProvider"
    MO_CLASS_ID_EXTPOL_PROVIDER_CONT = "extpolProviderCont"
    MO_CLASS_ID_EXTPOL_REGISTRY = "extpolRegistry"
    MO_CLASS_ID_EXTPOL_REGISTRY_CAPABILITY = "extpolRegistryCapability"
    MO_CLASS_ID_EXTPOL_SVC = "extpolSvc"
    MO_CLASS_ID_EXTPOL_SYSTEM_CONTEXT = "extpolSystemContext"
    MO_CLASS_ID_EXTPOL_VERSION_HOLDER = "extpolVersionHolder"
    MO_CLASS_ID_EXTVMM_NETWORK_SETS = "extvmmNetworkSets"
    MO_CLASS_ID_EXTVMM_VMNETWORK_SETS = "extvmmVMNetworkSets"
    MO_CLASS_ID_FABRIC_ADCE_SW_SRV_EP = "fabricADceSwSrvEp"
    MO_CLASS_ID_FABRIC_AETH_ESTC_EP = "fabricAEthEstcEp"
    MO_CLASS_ID_FABRIC_AETH_LAN_EP = "fabricAEthLanEp"
    MO_CLASS_ID_FABRIC_AFC_ESTC_EP = "fabricAFcEstcEp"
    MO_CLASS_ID_FABRIC_AFC_SAN_EP = "fabricAFcSanEp"
    MO_CLASS_ID_FABRIC_AFCOE_ESTC_EP = "fabricAFcoeEstcEp"
    MO_CLASS_ID_FABRIC_AFCOE_SAN_EP = "fabricAFcoeSanEp"
    MO_CLASS_ID_FABRIC_AGROUP_REQ = "fabricAGroupReq"
    MO_CLASS_ID_FABRIC_ANET_GROUP = "fabricANetGroup"
    MO_CLASS_ID_FABRIC_ANET_GROUP_REF = "fabricANetGroupRef"
    MO_CLASS_ID_FABRIC_ASAN_GROUP = "fabricASanGroup"
    MO_CLASS_ID_FABRIC_AVLAN = "fabricAVlan"
    MO_CLASS_ID_FABRIC_AVSAN = "fabricAVsan"
    MO_CLASS_ID_FABRIC_BASE_NET_GROUP = "fabricBaseNetGroup"
    MO_CLASS_ID_FABRIC_BASE_PH_EP = "fabricBasePhEp"
    MO_CLASS_ID_FABRIC_BASE_SLOT_EP = "fabricBaseSlotEp"
    MO_CLASS_ID_FABRIC_BREAKOUT = "fabricBreakout"
    MO_CLASS_ID_FABRIC_BREAKOUT_OPERATION = "fabricBreakoutOperation"
    MO_CLASS_ID_FABRIC_CIO_EP = "fabricCIoEp"
    MO_CLASS_ID_FABRIC_CABLING = "fabricCabling"
    MO_CLASS_ID_FABRIC_CABLING_SW = "fabricCablingSw"
    MO_CLASS_ID_FABRIC_CARTRIDGE_SLOT_EP = "fabricCartridgeSlotEp"
    MO_CLASS_ID_FABRIC_CARTRIDGE_SLOT_EP_OPERATION = "fabricCartridgeSlotEpOperation"
    MO_CLASS_ID_FABRIC_CDP_LINK_POLICY = "fabricCdpLinkPolicy"
    MO_CLASS_ID_FABRIC_CHANGED_OBJECT_REF = "fabricChangedObjectRef"
    MO_CLASS_ID_FABRIC_CHASSIS_EP = "fabricChassisEp"
    MO_CLASS_ID_FABRIC_CLOUD = "fabricCloud"
    MO_CLASS_ID_FABRIC_COMPUTE_EP = "fabricComputeEp"
    MO_CLASS_ID_FABRIC_COMPUTE_MSLOT_EP = "fabricComputeMSlotEp"
    MO_CLASS_ID_FABRIC_COMPUTE_PH_EP = "fabricComputePhEp"
    MO_CLASS_ID_FABRIC_COMPUTE_PH_EP_OPERATION = "fabricComputePhEpOperation"
    MO_CLASS_ID_FABRIC_COMPUTE_SLOT_EP = "fabricComputeSlotEp"
    MO_CLASS_ID_FABRIC_COMPUTE_SLOT_EP_OPERATION = "fabricComputeSlotEpOperation"
    MO_CLASS_ID_FABRIC_CONSUMER = "fabricConsumer"
    MO_CLASS_ID_FABRIC_DCE_SRV = "fabricDceSrv"
    MO_CLASS_ID_FABRIC_DCE_SW_SRV = "fabricDceSwSrv"
    MO_CLASS_ID_FABRIC_DCE_SW_SRV_EP = "fabricDceSwSrvEp"
    MO_CLASS_ID_FABRIC_DCE_SW_SRV_EP_OPERATION = "fabricDceSwSrvEpOperation"
    MO_CLASS_ID_FABRIC_DCE_SW_SRV_PC = "fabricDceSwSrvPc"
    MO_CLASS_ID_FABRIC_DCE_SW_SRV_PC_EP = "fabricDceSwSrvPcEp"
    MO_CLASS_ID_FABRIC_DCE_SW_SRV_PC_EP_OPERATION = "fabricDceSwSrvPcEpOperation"
    MO_CLASS_ID_FABRIC_DCE_SW_SRV_PC_OPERATION = "fabricDceSwSrvPcOperation"
    MO_CLASS_ID_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM = "fabricDceSwSrvPcOperationFsm"
    MO_CLASS_ID_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_STAGE = "fabricDceSwSrvPcOperationFsmStage"
    MO_CLASS_ID_FABRIC_DOMAIN = "fabricDomain"
    MO_CLASS_ID_FABRIC_DOMAIN_EP = "fabricDomainEp"
    MO_CLASS_ID_FABRIC_ENCLOSURE_PH_EP = "fabricEnclosurePhEp"
    MO_CLASS_ID_FABRIC_ENCLOSURE_PH_EP_OPERATION = "fabricEnclosurePhEpOperation"
    MO_CLASS_ID_FABRIC_ENCLOSURE_SLOT_EP = "fabricEnclosureSlotEp"
    MO_CLASS_ID_FABRIC_ENCLOSURE_SLOT_EP_OPERATION = "fabricEnclosureSlotEpOperation"
    MO_CLASS_ID_FABRIC_EP = "fabricEp"
    MO_CLASS_ID_FABRIC_EP_VLAN = "fabricEpVlan"
    MO_CLASS_ID_FABRIC_EP_VSAN = "fabricEpVsan"
    MO_CLASS_ID_FABRIC_EQUIPMENT_EP = "fabricEquipmentEp"
    MO_CLASS_ID_FABRIC_ESTC_EP = "fabricEstcEp"
    MO_CLASS_ID_FABRIC_ESTC_PC = "fabricEstcPc"
    MO_CLASS_ID_FABRIC_ETH_CDP_POLICY = "fabricEthCdpPolicy"
    MO_CLASS_ID_FABRIC_ETH_ESTC = "fabricEthEstc"
    MO_CLASS_ID_FABRIC_ETH_ESTC_CLOUD = "fabricEthEstcCloud"
    MO_CLASS_ID_FABRIC_ETH_ESTC_EP = "fabricEthEstcEp"
    MO_CLASS_ID_FABRIC_ETH_ESTC_EP_OPERATION = "fabricEthEstcEpOperation"
    MO_CLASS_ID_FABRIC_ETH_ESTC_EP_OPERATION_FSM = "fabricEthEstcEpOperationFsm"
    MO_CLASS_ID_FABRIC_ETH_ESTC_EP_OPERATION_FSM_STAGE = "fabricEthEstcEpOperationFsmStage"
    MO_CLASS_ID_FABRIC_ETH_ESTC_PC = "fabricEthEstcPc"
    MO_CLASS_ID_FABRIC_ETH_ESTC_PC_EP = "fabricEthEstcPcEp"
    MO_CLASS_ID_FABRIC_ETH_ESTC_PC_EP_OPERATION = "fabricEthEstcPcEpOperation"
    MO_CLASS_ID_FABRIC_ETH_ESTC_PC_OPERATION = "fabricEthEstcPcOperation"
    MO_CLASS_ID_FABRIC_ETH_ESTC_PC_OPERATION_FSM = "fabricEthEstcPcOperationFsm"
    MO_CLASS_ID_FABRIC_ETH_ESTC_PC_OPERATION_FSM_STAGE = "fabricEthEstcPcOperationFsmStage"
    MO_CLASS_ID_FABRIC_ETH_LAN = "fabricEthLan"
    MO_CLASS_ID_FABRIC_ETH_LAN_EP = "fabricEthLanEp"
    MO_CLASS_ID_FABRIC_ETH_LAN_EP_OPERATION = "fabricEthLanEpOperation"
    MO_CLASS_ID_FABRIC_ETH_LAN_EP_OPERATION_FSM = "fabricEthLanEpOperationFsm"
    MO_CLASS_ID_FABRIC_ETH_LAN_EP_OPERATION_FSM_STAGE = "fabricEthLanEpOperationFsmStage"
    MO_CLASS_ID_FABRIC_ETH_LAN_PC = "fabricEthLanPc"
    MO_CLASS_ID_FABRIC_ETH_LAN_PC_EP = "fabricEthLanPcEp"
    MO_CLASS_ID_FABRIC_ETH_LAN_PC_EP_OPERATION = "fabricEthLanPcEpOperation"
    MO_CLASS_ID_FABRIC_ETH_LAN_PC_OPERATION = "fabricEthLanPcOperation"
    MO_CLASS_ID_FABRIC_ETH_LAN_PC_OPERATION_FSM = "fabricEthLanPcOperationFsm"
    MO_CLASS_ID_FABRIC_ETH_LAN_PC_OPERATION_FSM_STAGE = "fabricEthLanPcOperationFsmStage"
    MO_CLASS_ID_FABRIC_ETH_LINK_POLICY = "fabricEthLinkPolicy"
    MO_CLASS_ID_FABRIC_ETH_LINK_PROFILE = "fabricEthLinkProfile"
    MO_CLASS_ID_FABRIC_ETH_MON = "fabricEthMon"
    MO_CLASS_ID_FABRIC_ETH_MON_DEST_EP = "fabricEthMonDestEp"
    MO_CLASS_ID_FABRIC_ETH_MON_DEST_EP_OPERATION = "fabricEthMonDestEpOperation"
    MO_CLASS_ID_FABRIC_ETH_MON_LAN = "fabricEthMonLan"
    MO_CLASS_ID_FABRIC_ETH_MON_OPERATION = "fabricEthMonOperation"
    MO_CLASS_ID_FABRIC_ETH_MON_OPERATION_FSM = "fabricEthMonOperationFsm"
    MO_CLASS_ID_FABRIC_ETH_MON_OPERATION_FSM_STAGE = "fabricEthMonOperationFsmStage"
    MO_CLASS_ID_FABRIC_ETH_MON_SRC_EP = "fabricEthMonSrcEp"
    MO_CLASS_ID_FABRIC_ETH_MON_SRC_EP_OPERATION = "fabricEthMonSrcEpOperation"
    MO_CLASS_ID_FABRIC_ETH_MON_SRC_REF = "fabricEthMonSrcRef"
    MO_CLASS_ID_FABRIC_ETH_PORT_OPERATION = "fabricEthPortOperation"
    MO_CLASS_ID_FABRIC_ETH_PORT_OPERATION_FSM = "fabricEthPortOperationFsm"
    MO_CLASS_ID_FABRIC_ETH_PORT_OPERATION_FSM_STAGE = "fabricEthPortOperationFsmStage"
    MO_CLASS_ID_FABRIC_ETH_TARGET_EP = "fabricEthTargetEp"
    MO_CLASS_ID_FABRIC_ETH_TARGET_EP_OPERATION = "fabricEthTargetEpOperation"
    MO_CLASS_ID_FABRIC_ETH_UDLD_POLICY = "fabricEthUdldPolicy"
    MO_CLASS_ID_FABRIC_ETH_VLAN_PC = "fabricEthVlanPc"
    MO_CLASS_ID_FABRIC_ETH_VLAN_PORT_EP = "fabricEthVlanPortEp"
    MO_CLASS_ID_FABRIC_ETHER_REF = "fabricEtherRef"
    MO_CLASS_ID_FABRIC_EXTENSION = "fabricExtension"
    MO_CLASS_ID_FABRIC_EXTERNAL = "fabricExternal"
    MO_CLASS_ID_FABRIC_EXTERNAL_EP = "fabricExternalEp"
    MO_CLASS_ID_FABRIC_EXTERNAL_ESTC = "fabricExternalEstc"
    MO_CLASS_ID_FABRIC_EXTERNAL_PC = "fabricExternalPc"
    MO_CLASS_ID_FABRIC_FIPORT_OPERATION = "fabricFIPortOperation"
    MO_CLASS_ID_FABRIC_FIPORT_OPERATION_FSM = "fabricFIPortOperationFsm"
    MO_CLASS_ID_FABRIC_FIPORT_OPERATION_FSM_STAGE = "fabricFIPortOperationFsmStage"
    MO_CLASS_ID_FABRIC_FIPORT_OPERATION_FSM_TASK = "fabricFIPortOperationFsmTask"
    MO_CLASS_ID_FABRIC_FC_ENDPOINT = "fabricFcEndpoint"
    MO_CLASS_ID_FABRIC_FC_ESTC = "fabricFcEstc"
    MO_CLASS_ID_FABRIC_FC_ESTC_CLOUD = "fabricFcEstcCloud"
    MO_CLASS_ID_FABRIC_FC_ESTC_EP = "fabricFcEstcEp"
    MO_CLASS_ID_FABRIC_FC_ESTC_EP_OPERATION = "fabricFcEstcEpOperation"
    MO_CLASS_ID_FABRIC_FC_ESTC_EP_OPERATION_FSM = "fabricFcEstcEpOperationFsm"
    MO_CLASS_ID_FABRIC_FC_ESTC_EP_OPERATION_FSM_STAGE = "fabricFcEstcEpOperationFsmStage"
    MO_CLASS_ID_FABRIC_FC_MON = "fabricFcMon"
    MO_CLASS_ID_FABRIC_FC_MON_DEST_EP = "fabricFcMonDestEp"
    MO_CLASS_ID_FABRIC_FC_MON_DEST_EP_OPERATION = "fabricFcMonDestEpOperation"
    MO_CLASS_ID_FABRIC_FC_MON_OPERATION = "fabricFcMonOperation"
    MO_CLASS_ID_FABRIC_FC_MON_OPERATION_FSM = "fabricFcMonOperationFsm"
    MO_CLASS_ID_FABRIC_FC_MON_OPERATION_FSM_STAGE = "fabricFcMonOperationFsmStage"
    MO_CLASS_ID_FABRIC_FC_MON_SAN = "fabricFcMonSan"
    MO_CLASS_ID_FABRIC_FC_MON_SRC_EP = "fabricFcMonSrcEp"
    MO_CLASS_ID_FABRIC_FC_MON_SRC_EP_OPERATION = "fabricFcMonSrcEpOperation"
    MO_CLASS_ID_FABRIC_FC_MON_SRC_REF = "fabricFcMonSrcRef"
    MO_CLASS_ID_FABRIC_FC_PORT_OPERATION = "fabricFcPortOperation"
    MO_CLASS_ID_FABRIC_FC_PORT_OPERATION_FSM = "fabricFcPortOperationFsm"
    MO_CLASS_ID_FABRIC_FC_PORT_OPERATION_FSM_STAGE = "fabricFcPortOperationFsmStage"
    MO_CLASS_ID_FABRIC_FC_SAN = "fabricFcSan"
    MO_CLASS_ID_FABRIC_FC_SAN_EP = "fabricFcSanEp"
    MO_CLASS_ID_FABRIC_FC_SAN_EP_OPERATION = "fabricFcSanEpOperation"
    MO_CLASS_ID_FABRIC_FC_SAN_EP_OPERATION_FSM = "fabricFcSanEpOperationFsm"
    MO_CLASS_ID_FABRIC_FC_SAN_EP_OPERATION_FSM_STAGE = "fabricFcSanEpOperationFsmStage"
    MO_CLASS_ID_FABRIC_FC_SAN_PC = "fabricFcSanPc"
    MO_CLASS_ID_FABRIC_FC_SAN_PC_EP = "fabricFcSanPcEp"
    MO_CLASS_ID_FABRIC_FC_SAN_PC_EP_OPERATION = "fabricFcSanPcEpOperation"
    MO_CLASS_ID_FABRIC_FC_SAN_PC_OPERATION = "fabricFcSanPcOperation"
    MO_CLASS_ID_FABRIC_FC_SAN_PC_OPERATION_FSM = "fabricFcSanPcOperationFsm"
    MO_CLASS_ID_FABRIC_FC_SAN_PC_OPERATION_FSM_STAGE = "fabricFcSanPcOperationFsmStage"
    MO_CLASS_ID_FABRIC_FC_UPLINK_OPERATION = "fabricFcUplinkOperation"
    MO_CLASS_ID_FABRIC_FC_USER_ZONE = "fabricFcUserZone"
    MO_CLASS_ID_FABRIC_FC_USER_ZONE_IVT = "fabricFcUserZoneIvt"
    MO_CLASS_ID_FABRIC_FC_VSAN_PC = "fabricFcVsanPc"
    MO_CLASS_ID_FABRIC_FC_VSAN_PORT_EP = "fabricFcVsanPortEp"
    MO_CLASS_ID_FABRIC_FC_ZONE_PROFILE = "fabricFcZoneProfile"
    MO_CLASS_ID_FABRIC_FC_ZONE_PROFILE_FSM = "fabricFcZoneProfileFsm"
    MO_CLASS_ID_FABRIC_FC_ZONE_PROFILE_FSM_STAGE = "fabricFcZoneProfileFsmStage"
    MO_CLASS_ID_FABRIC_FC_ZONE_PROFILE_FSM_TASK = "fabricFcZoneProfileFsmTask"
    MO_CLASS_ID_FABRIC_FC_ZONE_PROFILE_IVT = "fabricFcZoneProfileIvt"
    MO_CLASS_ID_FABRIC_FCOE_ESTC_EP = "fabricFcoeEstcEp"
    MO_CLASS_ID_FABRIC_FCOE_ESTC_EP_OPERATION = "fabricFcoeEstcEpOperation"
    MO_CLASS_ID_FABRIC_FCOE_ESTC_EP_OPERATION_FSM = "fabricFcoeEstcEpOperationFsm"
    MO_CLASS_ID_FABRIC_FCOE_ESTC_EP_OPERATION_FSM_STAGE = "fabricFcoeEstcEpOperationFsmStage"
    MO_CLASS_ID_FABRIC_FCOE_SAN_EP = "fabricFcoeSanEp"
    MO_CLASS_ID_FABRIC_FCOE_SAN_EP_OPERATION = "fabricFcoeSanEpOperation"
    MO_CLASS_ID_FABRIC_FCOE_SAN_EP_OPERATION_FSM = "fabricFcoeSanEpOperationFsm"
    MO_CLASS_ID_FABRIC_FCOE_SAN_EP_OPERATION_FSM_STAGE = "fabricFcoeSanEpOperationFsmStage"
    MO_CLASS_ID_FABRIC_FCOE_SAN_PC = "fabricFcoeSanPc"
    MO_CLASS_ID_FABRIC_FCOE_SAN_PC_EP = "fabricFcoeSanPcEp"
    MO_CLASS_ID_FABRIC_FCOE_SAN_PC_EP_OPERATION = "fabricFcoeSanPcEpOperation"
    MO_CLASS_ID_FABRIC_FCOE_SAN_PC_OPERATION = "fabricFcoeSanPcOperation"
    MO_CLASS_ID_FABRIC_FCOE_SAN_PC_OPERATION_FSM = "fabricFcoeSanPcOperationFsm"
    MO_CLASS_ID_FABRIC_FCOE_SAN_PC_OPERATION_FSM_STAGE = "fabricFcoeSanPcOperationFsmStage"
    MO_CLASS_ID_FABRIC_FCOE_VSAN_PC = "fabricFcoeVsanPc"
    MO_CLASS_ID_FABRIC_FCOE_VSAN_PORT_EP = "fabricFcoeVsanPortEp"
    MO_CLASS_ID_FABRIC_HOLDER = "fabricHolder"
    MO_CLASS_ID_FABRIC_IF = "fabricIf"
    MO_CLASS_ID_FABRIC_INTERNAL = "fabricInternal"
    MO_CLASS_ID_FABRIC_INTERNAL_DCE_SRV = "fabricInternalDceSrv"
    MO_CLASS_ID_FABRIC_INTERNAL_EP = "fabricInternalEp"
    MO_CLASS_ID_FABRIC_INTERNAL_PC = "fabricInternalPc"
    MO_CLASS_ID_FABRIC_LACP_POLICY = "fabricLacpPolicy"
    MO_CLASS_ID_FABRIC_LAN = "fabricLan"
    MO_CLASS_ID_FABRIC_LAN_ACCESS_MGR = "fabricLanAccessMgr"
    MO_CLASS_ID_FABRIC_LAN_CLOUD = "fabricLanCloud"
    MO_CLASS_ID_FABRIC_LAN_CLOUD_POLICY = "fabricLanCloudPolicy"
    MO_CLASS_ID_FABRIC_LAN_EP = "fabricLanEp"
    MO_CLASS_ID_FABRIC_LAN_MON_CLOUD = "fabricLanMonCloud"
    MO_CLASS_ID_FABRIC_LAN_PC = "fabricLanPc"
    MO_CLASS_ID_FABRIC_LAN_PIN_GROUP = "fabricLanPinGroup"
    MO_CLASS_ID_FABRIC_LAN_PIN_GROUP_OPERATION = "fabricLanPinGroupOperation"
    MO_CLASS_ID_FABRIC_LAN_PIN_TARGET = "fabricLanPinTarget"
    MO_CLASS_ID_FABRIC_LAN_PIN_TARGET_OPERATION = "fabricLanPinTargetOperation"
    MO_CLASS_ID_FABRIC_LAST_ACKED_SLOT = "fabricLastAckedSlot"
    MO_CLASS_ID_FABRIC_LINK_POLICY = "fabricLinkPolicy"
    MO_CLASS_ID_FABRIC_MON = "fabricMon"
    MO_CLASS_ID_FABRIC_MON_DEST_EP = "fabricMonDestEp"
    MO_CLASS_ID_FABRIC_MON_SRC_EP = "fabricMonSrcEp"
    MO_CLASS_ID_FABRIC_MON_SRC_REF = "fabricMonSrcRef"
    MO_CLASS_ID_FABRIC_MULTICAST_POLICY = "fabricMulticastPolicy"
    MO_CLASS_ID_FABRIC_NET_GROUP = "fabricNetGroup"
    MO_CLASS_ID_FABRIC_NET_GROUP_EP = "fabricNetGroupEp"
    MO_CLASS_ID_FABRIC_NET_GROUP_PERMIT = "fabricNetGroupPermit"
    MO_CLASS_ID_FABRIC_NET_GROUP_REF = "fabricNetGroupRef"
    MO_CLASS_ID_FABRIC_NET_GROUP_REQ = "fabricNetGroupReq"
    MO_CLASS_ID_FABRIC_ORG_VLAN_POLICY = "fabricOrgVlanPolicy"
    MO_CLASS_ID_FABRIC_PIO_EP = "fabricPIoEp"
    MO_CLASS_ID_FABRIC_PIN_GROUP = "fabricPinGroup"
    MO_CLASS_ID_FABRIC_PIN_TARGET = "fabricPinTarget"
    MO_CLASS_ID_FABRIC_POOLABLE_VLAN = "fabricPoolableVlan"
    MO_CLASS_ID_FABRIC_POOLED_VLAN = "fabricPooledVlan"
    MO_CLASS_ID_FABRIC_SAN = "fabricSan"
    MO_CLASS_ID_FABRIC_SAN_CLOUD = "fabricSanCloud"
    MO_CLASS_ID_FABRIC_SAN_EP = "fabricSanEp"
    MO_CLASS_ID_FABRIC_SAN_GROUP = "fabricSanGroup"
    MO_CLASS_ID_FABRIC_SAN_GROUP_REF = "fabricSanGroupRef"
    MO_CLASS_ID_FABRIC_SAN_MON_CLOUD = "fabricSanMonCloud"
    MO_CLASS_ID_FABRIC_SAN_PC = "fabricSanPc"
    MO_CLASS_ID_FABRIC_SAN_PIN_GROUP = "fabricSanPinGroup"
    MO_CLASS_ID_FABRIC_SAN_PIN_GROUP_OPERATION = "fabricSanPinGroupOperation"
    MO_CLASS_ID_FABRIC_SAN_PIN_TARGET = "fabricSanPinTarget"
    MO_CLASS_ID_FABRIC_SAN_PIN_TARGET_OPERATION = "fabricSanPinTargetOperation"
    MO_CLASS_ID_FABRIC_SUB_GROUP = "fabricSubGroup"
    MO_CLASS_ID_FABRIC_SW_CH_EP = "fabricSwChEp"
    MO_CLASS_ID_FABRIC_SW_CH_PH_EP = "fabricSwChPhEp"
    MO_CLASS_ID_FABRIC_SW_CH_PH_EP_OPERATION = "fabricSwChPhEpOperation"
    MO_CLASS_ID_FABRIC_SW_SRV_EP = "fabricSwSrvEp"
    MO_CLASS_ID_FABRIC_SW_SRV_PC = "fabricSwSrvPc"
    MO_CLASS_ID_FABRIC_SW_SUB_GROUP = "fabricSwSubGroup"
    MO_CLASS_ID_FABRIC_SYSTEM = "fabricSystem"
    MO_CLASS_ID_FABRIC_TARGET_EP = "fabricTargetEp"
    MO_CLASS_ID_FABRIC_UDLD_LINK_POLICY = "fabricUdldLinkPolicy"
    MO_CLASS_ID_FABRIC_UDLD_POLICY = "fabricUdldPolicy"
    MO_CLASS_ID_FABRIC_VCON = "fabricVCon"
    MO_CLASS_ID_FABRIC_VCON_PROFILE = "fabricVConProfile"
    MO_CLASS_ID_FABRIC_VLAN = "fabricVlan"
    MO_CLASS_ID_FABRIC_VLAN_EP = "fabricVlanEp"
    MO_CLASS_ID_FABRIC_VLAN_GROUP_REQ = "fabricVlanGroupReq"
    MO_CLASS_ID_FABRIC_VLAN_PERMIT = "fabricVlanPermit"
    MO_CLASS_ID_FABRIC_VLAN_PERMIT_ITEM = "fabricVlanPermitItem"
    MO_CLASS_ID_FABRIC_VLAN_REQ = "fabricVlanReq"
    MO_CLASS_ID_FABRIC_VNET_EP = "fabricVnetEp"
    MO_CLASS_ID_FABRIC_VNET_EP_SYNC_EP = "fabricVnetEpSyncEp"
    MO_CLASS_ID_FABRIC_VNET_EP_SYNC_EP_FSM = "fabricVnetEpSyncEpFsm"
    MO_CLASS_ID_FABRIC_VNET_EP_SYNC_EP_FSM_STAGE = "fabricVnetEpSyncEpFsmStage"
    MO_CLASS_ID_FABRIC_VNET_EP_SYNC_EP_FSM_TASK = "fabricVnetEpSyncEpFsmTask"
    MO_CLASS_ID_FABRIC_VNET_GROUP_REQ = "fabricVnetGroupReq"
    MO_CLASS_ID_FABRIC_VNET_REQ = "fabricVnetReq"
    MO_CLASS_ID_FABRIC_VSAN = "fabricVsan"
    MO_CLASS_ID_FABRIC_VSAN_EP = "fabricVsanEp"
    MO_CLASS_ID_FABRIC_VSAN_MEMBERSHIP = "fabricVsanMembership"
    MO_CLASS_ID_FAULT_BASE_HOLDER = "faultBaseHolder"
    MO_CLASS_ID_FAULT_BASE_POLICY = "faultBasePolicy"
    MO_CLASS_ID_FAULT_BASE_TYPED_HOLDER = "faultBaseTypedHolder"
    MO_CLASS_ID_FAULT_DOMAIN_EP = "faultDomainEp"
    MO_CLASS_ID_FAULT_DOMAIN_INST = "faultDomainInst"
    MO_CLASS_ID_FAULT_GLOBAL_SEVERITY_HOLDER = "faultGlobalSeverityHolder"
    MO_CLASS_ID_FAULT_GLOBAL_TYPED_HOLDER = "faultGlobalTypedHolder"
    MO_CLASS_ID_FAULT_HOLDER = "faultHolder"
    MO_CLASS_ID_FAULT_INST = "faultInst"
    MO_CLASS_ID_FAULT_LOCAL_BASE_HOLDER = "faultLocalBaseHolder"
    MO_CLASS_ID_FAULT_LOCAL_TYPED_HOLDER = "faultLocalTypedHolder"
    MO_CLASS_ID_FAULT_POLICY = "faultPolicy"
    MO_CLASS_ID_FAULT_SUMMARY = "faultSummary"
    MO_CLASS_ID_FAULT_SUMMARY_INST = "faultSummaryInst"
    MO_CLASS_ID_FAULT_SVC_SUMMARY = "faultSvcSummary"
    MO_CLASS_ID_FAULT_TYPED_HOLDER = "faultTypedHolder"
    MO_CLASS_ID_FC_ERR_STATS = "fcErrStats"
    MO_CLASS_ID_FC_ERR_STATS_HIST = "fcErrStatsHist"
    MO_CLASS_ID_FC_PIO = "fcPIo"
    MO_CLASS_ID_FC_STATS = "fcStats"
    MO_CLASS_ID_FC_STATS_HIST = "fcStatsHist"
    MO_CLASS_ID_FCPOOL_ADDR = "fcpoolAddr"
    MO_CLASS_ID_FCPOOL_BLOCK = "fcpoolBlock"
    MO_CLASS_ID_FCPOOL_BOOT_TARGET = "fcpoolBootTarget"
    MO_CLASS_ID_FCPOOL_FORMAT = "fcpoolFormat"
    MO_CLASS_ID_FCPOOL_INITIATOR = "fcpoolInitiator"
    MO_CLASS_ID_FCPOOL_INITIATOR_EP = "fcpoolInitiatorEp"
    MO_CLASS_ID_FCPOOL_INITIATORS = "fcpoolInitiators"
    MO_CLASS_ID_FCPOOL_UNIVERSE = "fcpoolUniverse"
    MO_CLASS_ID_FD_BLADE = "fdBlade"
    MO_CLASS_ID_FD_BLADE_FSM = "fdBladeFsm"
    MO_CLASS_ID_FD_BLADE_FSM_STAGE = "fdBladeFsmStage"
    MO_CLASS_ID_FD_CHASSIS = "fdChassis"
    MO_CLASS_ID_FD_OPERABLE = "fdOperable"
    MO_CLASS_ID_FD_PHYSICAL = "fdPhysical"
    MO_CLASS_ID_FD_PHYSICAL_FSM = "fdPhysicalFsm"
    MO_CLASS_ID_FD_PHYSICAL_FSM_STAGE = "fdPhysicalFsmStage"
    MO_CLASS_ID_FD_PHYSICAL_FSM_TASK = "fdPhysicalFsmTask"
    MO_CLASS_ID_FD_RACK_UNIT = "fdRackUnit"
    MO_CLASS_ID_FD_RACK_UNIT_FSM = "fdRackUnitFsm"
    MO_CLASS_ID_FD_RACK_UNIT_FSM_STAGE = "fdRackUnitFsmStage"
    MO_CLASS_ID_FEATURE_CATALOG_EP = "featureCatalogEp"
    MO_CLASS_ID_FEATURE_CHASSIS_DEF = "featureChassisDef"
    MO_CLASS_ID_FEATURE_DEFINITION = "featureDefinition"
    MO_CLASS_ID_FEATURE_ENV_DEF = "featureEnvDef"
    MO_CLASS_ID_FEATURE_NETWORK_DEF = "featureNetworkDef"
    MO_CLASS_ID_FEATURE_SERVER_DEF = "featureServerDef"
    MO_CLASS_ID_FEATURE_STORAGE_DEF = "featureStorageDef"
    MO_CLASS_ID_FIRMWARE_ACOMPONENT_SPEC = "firmwareAComponentSpec"
    MO_CLASS_ID_FIRMWARE_AEXCLUDE_COMPONENT = "firmwareAExcludeComponent"
    MO_CLASS_ID_FIRMWARE_AINFRA_PACK = "firmwareAInfraPack"
    MO_CLASS_ID_FIRMWARE_ACK = "firmwareAck"
    MO_CLASS_ID_FIRMWARE_AUTO_SYNC_POLICY = "firmwareAutoSyncPolicy"
    MO_CLASS_ID_FIRMWARE_BOOT_DEFINITION = "firmwareBootDefinition"
    MO_CLASS_ID_FIRMWARE_BOOT_UNIT = "firmwareBootUnit"
    MO_CLASS_ID_FIRMWARE_BUNDLE_INFO = "firmwareBundleInfo"
    MO_CLASS_ID_FIRMWARE_BUNDLE_INFO_DIGEST = "firmwareBundleInfoDigest"
    MO_CLASS_ID_FIRMWARE_BUNDLE_TYPE = "firmwareBundleType"
    MO_CLASS_ID_FIRMWARE_BUNDLE_TYPE_CAP_PROVIDER = "firmwareBundleTypeCapProvider"
    MO_CLASS_ID_FIRMWARE_CAP_PROVIDER = "firmwareCapProvider"
    MO_CLASS_ID_FIRMWARE_CATALOG_PACK = "firmwareCatalogPack"
    MO_CLASS_ID_FIRMWARE_CATALOG_PACK_CONFIG = "firmwareCatalogPackConfig"
    MO_CLASS_ID_FIRMWARE_CATALOGUE = "firmwareCatalogue"
    MO_CLASS_ID_FIRMWARE_CHASSIS_COMPONENT_SPEC = "firmwareChassisComponentSpec"
    MO_CLASS_ID_FIRMWARE_CHASSIS_PACK = "firmwareChassisPack"
    MO_CLASS_ID_FIRMWARE_COMP_ITEM = "firmwareCompItem"
    MO_CLASS_ID_FIRMWARE_COMP_SOURCE = "firmwareCompSource"
    MO_CLASS_ID_FIRMWARE_COMP_TARGET = "firmwareCompTarget"
    MO_CLASS_ID_FIRMWARE_COMPONENT_SPEC = "firmwareComponentSpec"
    MO_CLASS_ID_FIRMWARE_COMPUTE_HOST_PACK = "firmwareComputeHostPack"
    MO_CLASS_ID_FIRMWARE_COMPUTE_MGMT_PACK = "firmwareComputeMgmtPack"
    MO_CLASS_ID_FIRMWARE_COMPUTE_PACK = "firmwareComputePack"
    MO_CLASS_ID_FIRMWARE_COMPUTE_STORAGE_PACK = "firmwareComputeStoragePack"
    MO_CLASS_ID_FIRMWARE_CONNECTION_POLICY = "firmwareConnectionPolicy"
    MO_CLASS_ID_FIRMWARE_DEPENDENCY = "firmwareDependency"
    MO_CLASS_ID_FIRMWARE_DIST_IMAGE = "firmwareDistImage"
    MO_CLASS_ID_FIRMWARE_DISTRIBUTABLE = "firmwareDistributable"
    MO_CLASS_ID_FIRMWARE_DISTRIBUTABLE_FSM = "firmwareDistributableFsm"
    MO_CLASS_ID_FIRMWARE_DISTRIBUTABLE_FSM_STAGE = "firmwareDistributableFsmStage"
    MO_CLASS_ID_FIRMWARE_DISTRIBUTABLE_FSM_TASK = "firmwareDistributableFsmTask"
    MO_CLASS_ID_FIRMWARE_DOMAIN_INFO = "firmwareDomainInfo"
    MO_CLASS_ID_FIRMWARE_DOMAIN_INFRA_PROFILE = "firmwareDomainInfraProfile"
    MO_CLASS_ID_FIRMWARE_DOWNLOAD_POLICY = "firmwareDownloadPolicy"
    MO_CLASS_ID_FIRMWARE_DOWNLOADER = "firmwareDownloader"
    MO_CLASS_ID_FIRMWARE_DOWNLOADER_FSM = "firmwareDownloaderFsm"
    MO_CLASS_ID_FIRMWARE_DOWNLOADER_FSM_STAGE = "firmwareDownloaderFsmStage"
    MO_CLASS_ID_FIRMWARE_DOWNLOADER_FSM_TASK = "firmwareDownloaderFsmTask"
    MO_CLASS_ID_FIRMWARE_EXCLUDE_CHASSIS_COMPONENT = "firmwareExcludeChassisComponent"
    MO_CLASS_ID_FIRMWARE_EXCLUDE_SERVER_COMPONENT = "firmwareExcludeServerComponent"
    MO_CLASS_ID_FIRMWARE_IMAGE = "firmwareImage"
    MO_CLASS_ID_FIRMWARE_INFRA = "firmwareInfra"
    MO_CLASS_ID_FIRMWARE_INFRA_PACK = "firmwareInfraPack"
    MO_CLASS_ID_FIRMWARE_INFRA_PACK_CONFIG = "firmwareInfraPackConfig"
    MO_CLASS_ID_FIRMWARE_INFRA_POLICY = "firmwareInfraPolicy"
    MO_CLASS_ID_FIRMWARE_INSTALL_IMPACT = "firmwareInstallImpact"
    MO_CLASS_ID_FIRMWARE_PACK = "firmwarePack"
    MO_CLASS_ID_FIRMWARE_POLICY = "firmwarePolicy"
    MO_CLASS_ID_FIRMWARE_PRODUCT_FAMILY = "firmwareProductFamily"
    MO_CLASS_ID_FIRMWARE_REMOTE_CATALOGUE = "firmwareRemoteCatalogue"
    MO_CLASS_ID_FIRMWARE_RUNNING = "firmwareRunning"
    MO_CLASS_ID_FIRMWARE_SOURCE = "firmwareSource"
    MO_CLASS_ID_FIRMWARE_STATUS = "firmwareStatus"
    MO_CLASS_ID_FIRMWARE_STORAGE_PACK = "firmwareStoragePack"
    MO_CLASS_ID_FIRMWARE_SYSTEM = "firmwareSystem"
    MO_CLASS_ID_FIRMWARE_TYPE = "firmwareType"
    MO_CLASS_ID_FIRMWARE_UNIT = "firmwareUnit"
    MO_CLASS_ID_FIRMWARE_UPDATABLE = "firmwareUpdatable"
    MO_CLASS_ID_FIRMWARE_UPGRADE_DETAIL = "firmwareUpgradeDetail"
    MO_CLASS_ID_FIRMWARE_UPGRADE_INFO = "firmwareUpgradeInfo"
    MO_CLASS_ID_FLOWCTRL_DEFINITION = "flowctrlDefinition"
    MO_CLASS_ID_FLOWCTRL_ITEM = "flowctrlItem"
    MO_CLASS_ID_FSM_FSM = "fsmFsm"
    MO_CLASS_ID_FSM_STAGE = "fsmStage"
    MO_CLASS_ID_FSM_STATUS = "fsmStatus"
    MO_CLASS_ID_FSM_TASK = "fsmTask"
    MO_CLASS_ID_GL_ABS_CONFLICT = "glAbsConflict"
    MO_CLASS_ID_GL_ABS_EP = "glAbsEp"
    MO_CLASS_ID_GL_ABS_IDENT_CTX_OP = "glAbsIdentCtxOp"
    MO_CLASS_ID_GL_ABS_INV = "glAbsInv"
    MO_CLASS_ID_GL_ABS_OPERATION = "glAbsOperation"
    MO_CLASS_ID_GL_ABS_POLICY_INV = "glAbsPolicyInv"
    MO_CLASS_ID_GL_ABS_POLICY_OP = "glAbsPolicyOp"
    MO_CLASS_ID_GL_ABS_POLICY_RULE = "glAbsPolicyRule"
    MO_CLASS_ID_GL_ABS_REQUEST = "glAbsRequest"
    MO_CLASS_ID_GL_ABS_RES_EP = "glAbsResEp"
    MO_CLASS_ID_GL_ABS_RULE = "glAbsRule"
    MO_CLASS_ID_GL_ABS_VNET_INV = "glAbsVnetInv"
    MO_CLASS_ID_GL_APPEND_RULE = "glAppendRule"
    MO_CLASS_ID_GL_BLOCK_EP = "glBlockEp"
    MO_CLASS_ID_GL_BLOCK_OP = "glBlockOp"
    MO_CLASS_ID_GL_BY_MO = "glByMo"
    MO_CLASS_ID_GL_COMPLEX_REF_EP = "glComplexRefEp"
    MO_CLASS_ID_GL_CONFLICT_EP = "glConflictEp"
    MO_CLASS_ID_GL_CONFLICT_RESOLUTION_RULE_EP = "glConflictResolutionRuleEp"
    MO_CLASS_ID_GL_DOMAIN_EP = "glDomainEp"
    MO_CLASS_ID_GL_EP = "glEp"
    MO_CLASS_ID_GL_GLOBAL_DEFAULT_POLICY_EP = "glGlobalDefaultPolicyEp"
    MO_CLASS_ID_GL_ID_REF = "glIdRef"
    MO_CLASS_ID_GL_ID_REF_EP = "glIdRefEp"
    MO_CLASS_ID_GL_IDABLE = "glIdable"
    MO_CLASS_ID_GL_IDENT_CTX_EP = "glIdentCtxEp"
    MO_CLASS_ID_GL_IDENT_CTX_OP = "glIdentCtxOp"
    MO_CLASS_ID_GL_IDENT_CTX_RES_OP = "glIdentCtxResOp"
    MO_CLASS_ID_GL_IDENT_CTX_RES_OP_FSM = "glIdentCtxResOpFsm"
    MO_CLASS_ID_GL_IDENT_CTX_RES_OP_FSM_STAGE = "glIdentCtxResOpFsmStage"
    MO_CLASS_ID_GL_IDENT_CTX_RES_OP_FSM_TASK = "glIdentCtxResOpFsmTask"
    MO_CLASS_ID_GL_INVENTORY_EP = "glInventoryEp"
    MO_CLASS_ID_GL_LSP = "glLsp"
    MO_CLASS_ID_GL_MCAST_POLICY = "glMcastPolicy"
    MO_CLASS_ID_GL_OPERATION_EP = "glOperationEp"
    MO_CLASS_ID_GL_PATH_EP = "glPathEp"
    MO_CLASS_ID_GL_POLICY = "glPolicy"
    MO_CLASS_ID_GL_POLICY_ALGORITHMED_OP = "glPolicyAlgorithmedOp"
    MO_CLASS_ID_GL_POLICY_EP = "glPolicyEp"
    MO_CLASS_ID_GL_POLICY_INV_EP = "glPolicyInvEp"
    MO_CLASS_ID_GL_POLICY_NAME_RULE_EP = "glPolicyNameRuleEp"
    MO_CLASS_ID_GL_POLICY_OP = "glPolicyOp"
    MO_CLASS_ID_GL_POLICY_REF = "glPolicyRef"
    MO_CLASS_ID_GL_POLICY_REF_EP = "glPolicyRefEp"
    MO_CLASS_ID_GL_POLICY_RES_OP = "glPolicyResOp"
    MO_CLASS_ID_GL_POLICY_RESOLUTION_EP = "glPolicyResolutionEp"
    MO_CLASS_ID_GL_POOL = "glPool"
    MO_CLASS_ID_GL_POOL_EP = "glPoolEp"
    MO_CLASS_ID_GL_POOL_INV_EP = "glPoolInvEp"
    MO_CLASS_ID_GL_POOL_OP = "glPoolOp"
    MO_CLASS_ID_GL_REFABLE = "glRefable"
    MO_CLASS_ID_GL_REFS_EP = "glRefsEp"
    MO_CLASS_ID_GL_REQUEST = "glRequest"
    MO_CLASS_ID_GL_REQUEST_FSM = "glRequestFsm"
    MO_CLASS_ID_GL_REQUEST_FSM_STAGE = "glRequestFsmStage"
    MO_CLASS_ID_GL_REQUEST_FSM_TASK = "glRequestFsmTask"
    MO_CLASS_ID_GL_REQUEST_VNET_EP = "glRequestVnetEp"
    MO_CLASS_ID_GL_REQUEST_VNET_EP_DOMAIN_EP = "glRequestVnetEpDomainEp"
    MO_CLASS_ID_GL_REQUEST_VNET_EP_DOMAIN_EP_FSM = "glRequestVnetEpDomainEpFsm"
    MO_CLASS_ID_GL_REQUEST_VNET_EP_DOMAIN_EP_FSM_STAGE = "glRequestVnetEpDomainEpFsmStage"
    MO_CLASS_ID_GL_REQUEST_VNET_EP_DOMAIN_EP_FSM_TASK = "glRequestVnetEpDomainEpFsmTask"
    MO_CLASS_ID_GL_REQUEST_VNET_EP_FSM = "glRequestVnetEpFsm"
    MO_CLASS_ID_GL_REQUEST_VNET_EP_FSM_STAGE = "glRequestVnetEpFsmStage"
    MO_CLASS_ID_GL_REQUEST_VNET_EP_FSM_TASK = "glRequestVnetEpFsmTask"
    MO_CLASS_ID_GL_REQUEST_VNET_EP_HOLDER = "glRequestVnetEpHolder"
    MO_CLASS_ID_GL_REQUESTOR = "glRequestor"
    MO_CLASS_ID_GL_REQUESTOR_EP = "glRequestorEp"
    MO_CLASS_ID_GL_SPINV_EP = "glSPInvEp"
    MO_CLASS_ID_GL_SERVER_POOL_RES_OP = "glServerPoolResOp"
    MO_CLASS_ID_GL_SERVICE_PROFILE = "glServiceProfile"
    MO_CLASS_ID_GL_SP_DEF_EP = "glSpDefEp"
    MO_CLASS_ID_GL_TEMPLATE_EP = "glTemplateEp"
    MO_CLASS_ID_GL_TEMPLATE_OP = "glTemplateOp"
    MO_CLASS_ID_GL_TEMPLATE_RES_OP = "glTemplateResOp"
    MO_CLASS_ID_GL_USAGE = "glUsage"
    MO_CLASS_ID_GL_USAGE_EP = "glUsageEp"
    MO_CLASS_ID_GL_VLAN = "glVlan"
    MO_CLASS_ID_GL_VNET_INV_HOLDER = "glVnetInvHolder"
    MO_CLASS_ID_GL_VNIC_TEMPLATE = "glVnicTemplate"
    MO_CLASS_ID_GL_VNIC_TEMPLATE_EP = "glVnicTemplateEp"
    MO_CLASS_ID_GL_VSAN = "glVsan"
    MO_CLASS_ID_GL_VXAN_EP = "glVxanEp"
    MO_CLASS_ID_GL_VXAN_OP = "glVxanOp"
    MO_CLASS_ID_GL_VXAN_RES_OP = "glVxanResOp"
    MO_CLASS_ID_GMETA_CLASS = "gmetaClass"
    MO_CLASS_ID_GMETA_POLICY_MAP_ELEMENT = "gmetaPolicyMapElement"
    MO_CLASS_ID_GMETA_PROP = "gmetaProp"
    MO_CLASS_ID_GRAPHICS_CARD = "graphicsCard"
    MO_CLASS_ID_GRAPHICS_CONTROLLER = "graphicsController"
    MO_CLASS_ID_GUI_GUI_COMPONENT = "guiGuiComponent"
    MO_CLASS_ID_GUI_GUI_CONT = "guiGuiCont"
    MO_CLASS_ID_HC_ACOMPONENT = "hcAComponent"
    MO_CLASS_ID_HC_AITEM = "hcAItem"
    MO_CLASS_ID_HC_ASTATUS_ITEM = "hcAStatusItem"
    MO_CLASS_ID_HC_ADAPTER_FIRMWARE_ITEM = "hcAdapterFirmwareItem"
    MO_CLASS_ID_HC_ADAPTER_ITEM = "hcAdapterItem"
    MO_CLASS_ID_HC_ADMIN = "hcAdmin"
    MO_CLASS_ID_HC_CATALOG = "hcCatalog"
    MO_CLASS_ID_HC_CATALOG_LIST = "hcCatalogList"
    MO_CLASS_ID_HC_CATALOG_SOURCE = "hcCatalogSource"
    MO_CLASS_ID_HC_CATALOG_VERSION = "hcCatalogVersion"
    MO_CLASS_ID_HC_CLEANUP = "hcCleanup"
    MO_CLASS_ID_HC_DOWNLOAD_POLICY = "hcDownloadPolicy"
    MO_CLASS_ID_HC_DOWNLOADER = "hcDownloader"
    MO_CLASS_ID_HC_DRIVER_INFO_ITEM = "hcDriverInfoItem"
    MO_CLASS_ID_HC_DRIVER_ITEM = "hcDriverItem"
    MO_CLASS_ID_HC_HOLDER = "hcHolder"
    MO_CLASS_ID_HC_ITEM_NOTE = "hcItemNote"
    MO_CLASS_ID_HC_OS_INFO_ITEM = "hcOsInfoItem"
    MO_CLASS_ID_HC_OS_ITEM = "hcOsItem"
    MO_CLASS_ID_HC_REPORT = "hcReport"
    MO_CLASS_ID_HC_SCOPE_DN = "hcScopeDn"
    MO_CLASS_ID_HC_SERVER_COMPONENT = "hcServerComponent"
    MO_CLASS_ID_HC_SUPPORTED_ADAPTER_FIRMWARE_ITEM = "hcSupportedAdapterFirmwareItem"
    MO_CLASS_ID_HC_SUPPORTED_ADAPTER_ITEM = "hcSupportedAdapterItem"
    MO_CLASS_ID_HC_SUPPORTED_DRIVER_ITEM = "hcSupportedDriverItem"
    MO_CLASS_ID_HC_SUPPORTED_OS_ITEM = "hcSupportedOsItem"
    MO_CLASS_ID_HC_UCS_VERSION_ITEM = "hcUcsVersionItem"
    MO_CLASS_ID_IDENT_DOMAIN_SYNC_EP = "identDomainSyncEp"
    MO_CLASS_ID_IDENT_EXECUTION_EP = "identExecutionEp"
    MO_CLASS_ID_IDENT_EXECUTION_REQUEST_EP = "identExecutionRequestEp"
    MO_CLASS_ID_IDENT_IDENT_CTX = "identIdentCtx"
    MO_CLASS_ID_IDENT_IDENT_REQUEST = "identIdentRequest"
    MO_CLASS_ID_IDENT_IDENT_REQUEST_FSM = "identIdentRequestFsm"
    MO_CLASS_ID_IDENT_IDENT_REQUEST_FSM_STAGE = "identIdentRequestFsmStage"
    MO_CLASS_ID_IDENT_IDENT_REQUEST_FSM_TASK = "identIdentRequestFsmTask"
    MO_CLASS_ID_IDENT_META_SYSTEM = "identMetaSystem"
    MO_CLASS_ID_IDENT_META_SYSTEM_FSM = "identMetaSystemFsm"
    MO_CLASS_ID_IDENT_META_SYSTEM_FSM_STAGE = "identMetaSystemFsmStage"
    MO_CLASS_ID_IDENT_META_SYSTEM_FSM_TASK = "identMetaSystemFsmTask"
    MO_CLASS_ID_IDENT_META_VERSE = "identMetaVerse"
    MO_CLASS_ID_IDENT_REQUEST_EP = "identRequestEp"
    MO_CLASS_ID_IDENT_SYS_INFO = "identSysInfo"
    MO_CLASS_ID_IDENTPOOL_BLOCK_QUAL = "identpoolBlockQual"
    MO_CLASS_ID_IDENTPOOL_CONSUMED = "identpoolConsumed"
    MO_CLASS_ID_IDENTPOOL_DOMAIN = "identpoolDomain"
    MO_CLASS_ID_IDENTPOOL_DOMAIN_GROUP_QUAL = "identpoolDomainGroupQual"
    MO_CLASS_ID_IDENTPOOL_ELEMENT = "identpoolElement"
    MO_CLASS_ID_IDENTPOOL_IPQUAL = "identpoolIPQual"
    MO_CLASS_ID_IDENTPOOL_IPV6_QUAL = "identpoolIPV6Qual"
    MO_CLASS_ID_IDENTPOOL_META_SYSTEM = "identpoolMetaSystem"
    MO_CLASS_ID_IDENTPOOL_META_VERSE = "identpoolMetaVerse"
    MO_CLASS_ID_IDENTPOOL_POOL = "identpoolPool"
    MO_CLASS_ID_IDENTPOOL_POOLABLE = "identpoolPoolable"
    MO_CLASS_ID_IDENTPOOL_QUAL_ITEM = "identpoolQualItem"
    MO_CLASS_ID_IDENTPOOL_UNIVERSE = "identpoolUniverse"
    MO_CLASS_ID_INBAND_POLICY = "inbandPolicy"
    MO_CLASS_ID_INITIATOR_EP = "initiatorEp"
    MO_CLASS_ID_INITIATOR_FC_INITIATOR_EP = "initiatorFcInitiatorEp"
    MO_CLASS_ID_INITIATOR_GROUP_EP = "initiatorGroupEp"
    MO_CLASS_ID_INITIATOR_ISCSI_INITIATOR_EP = "initiatorIScsiInitiatorEp"
    MO_CLASS_ID_INITIATOR_INITIATOR_EP = "initiatorInitiatorEp"
    MO_CLASS_ID_INITIATOR_LUN_EP = "initiatorLunEp"
    MO_CLASS_ID_INITIATOR_MEMBER_EP = "initiatorMemberEp"
    MO_CLASS_ID_INITIATOR_REQUESTOR_EP = "initiatorRequestorEp"
    MO_CLASS_ID_INITIATOR_REQUESTOR_GRP_EP = "initiatorRequestorGrpEp"
    MO_CLASS_ID_INITIATOR_STORE_EP = "initiatorStoreEp"
    MO_CLASS_ID_INITIATOR_UNIT_EP = "initiatorUnitEp"
    MO_CLASS_ID_INVENTORY_DOMAIN_EP = "inventoryDomainEp"
    MO_CLASS_ID_INVENTORY_EP = "inventoryEp"
    MO_CLASS_ID_INVENTORY_GLOBAL_EP = "inventoryGlobalEp"
    MO_CLASS_ID_INVENTORY_HOLDER = "inventoryHolder"
    MO_CLASS_ID_INVENTORY_INVENTORY_EP = "inventoryInventoryEp"
    MO_CLASS_ID_INVENTORY_INVENTORY_MO_META = "inventoryInventoryMoMeta"
    MO_CLASS_ID_IP_IPV4_DNS = "ipIPv4Dns"
    MO_CLASS_ID_IP_IP_V4_ADDR = "ipIpV4Addr"
    MO_CLASS_ID_IP_IP_V4_STATIC_ADDR = "ipIpV4StaticAddr"
    MO_CLASS_ID_IP_SERVICE_IF = "ipServiceIf"
    MO_CLASS_ID_IPPOOL_ADDR = "ippoolAddr"
    MO_CLASS_ID_IPPOOL_BLOCK = "ippoolBlock"
    MO_CLASS_ID_IPPOOL_IP_V6_ADDR = "ippoolIpV6Addr"
    MO_CLASS_ID_IPPOOL_IP_V6_BLOCK = "ippoolIpV6Block"
    MO_CLASS_ID_IPPOOL_IP_V6_POOLED = "ippoolIpV6Pooled"
    MO_CLASS_ID_IPPOOL_POOL = "ippoolPool"
    MO_CLASS_ID_IPPOOL_POOLED = "ippoolPooled"
    MO_CLASS_ID_IPPOOL_UNIVERSE = "ippoolUniverse"
    MO_CLASS_ID_IQNPOOL_ABS_BLOCK = "iqnpoolAbsBlock"
    MO_CLASS_ID_IQNPOOL_ADDR = "iqnpoolAddr"
    MO_CLASS_ID_IQNPOOL_BLOCK = "iqnpoolBlock"
    MO_CLASS_ID_IQNPOOL_FORMAT = "iqnpoolFormat"
    MO_CLASS_ID_IQNPOOL_POOL = "iqnpoolPool"
    MO_CLASS_ID_IQNPOOL_POOLED = "iqnpoolPooled"
    MO_CLASS_ID_IQNPOOL_TRANSPORT_BLOCK = "iqnpoolTransportBlock"
    MO_CLASS_ID_IQNPOOL_UNIVERSE = "iqnpoolUniverse"
    MO_CLASS_ID_ISCSI_AUTH_PROFILE = "iscsiAuthProfile"
    MO_CLASS_ID_LICENSE_CAP_PROVIDER = "licenseCapProvider"
    MO_CLASS_ID_LICENSE_CONTENTS = "licenseContents"
    MO_CLASS_ID_LICENSE_DOMAIN = "licenseDomain"
    MO_CLASS_ID_LICENSE_DOWNLOADER = "licenseDownloader"
    MO_CLASS_ID_LICENSE_DOWNLOADER_FSM = "licenseDownloaderFsm"
    MO_CLASS_ID_LICENSE_DOWNLOADER_FSM_STAGE = "licenseDownloaderFsmStage"
    MO_CLASS_ID_LICENSE_DOWNLOADER_FSM_TASK = "licenseDownloaderFsmTask"
    MO_CLASS_ID_LICENSE_EP = "licenseEp"
    MO_CLASS_ID_LICENSE_FEATURE = "licenseFeature"
    MO_CLASS_ID_LICENSE_FEATURE_CAP_PROVIDER = "licenseFeatureCapProvider"
    MO_CLASS_ID_LICENSE_FEATURE_LINE = "licenseFeatureLine"
    MO_CLASS_ID_LICENSE_FILE = "licenseFile"
    MO_CLASS_ID_LICENSE_FILE_FSM = "licenseFileFsm"
    MO_CLASS_ID_LICENSE_FILE_FSM_STAGE = "licenseFileFsmStage"
    MO_CLASS_ID_LICENSE_FILE_FSM_TASK = "licenseFileFsmTask"
    MO_CLASS_ID_LICENSE_INSTANCE = "licenseInstance"
    MO_CLASS_ID_LICENSE_INSTANCE_FSM = "licenseInstanceFsm"
    MO_CLASS_ID_LICENSE_INSTANCE_FSM_STAGE = "licenseInstanceFsmStage"
    MO_CLASS_ID_LICENSE_INSTANCE_FSM_TASK = "licenseInstanceFsmTask"
    MO_CLASS_ID_LICENSE_LICENSE = "licenseLicense"
    MO_CLASS_ID_LICENSE_PROP = "licenseProp"
    MO_CLASS_ID_LICENSE_SERVER_HOST_ID = "licenseServerHostId"
    MO_CLASS_ID_LICENSE_SOURCE = "licenseSource"
    MO_CLASS_ID_LICENSE_SOURCE_FILE = "licenseSourceFile"
    MO_CLASS_ID_LS_BINDING = "lsBinding"
    MO_CLASS_ID_LS_COMPUTE_BINDING = "lsComputeBinding"
    MO_CLASS_ID_LS_FC_LOCALE = "lsFcLocale"
    MO_CLASS_ID_LS_FC_ZONE = "lsFcZone"
    MO_CLASS_ID_LS_FC_ZONE_GROUP = "lsFcZoneGroup"
    MO_CLASS_ID_LS_FC_ZONE_MEMBER = "lsFcZoneMember"
    MO_CLASS_ID_LS_IDENTITY_INFO = "lsIdentityInfo"
    MO_CLASS_ID_LS_ISSUES = "lsIssues"
    MO_CLASS_ID_LS_POWER = "lsPower"
    MO_CLASS_ID_LS_REQUIREMENT = "lsRequirement"
    MO_CLASS_ID_LS_SPMETA = "lsSPMeta"
    MO_CLASS_ID_LS_SERVER = "lsServer"
    MO_CLASS_ID_LS_SERVER_ASSOC_CTX = "lsServerAssocCtx"
    MO_CLASS_ID_LS_SERVER_EXTENSION = "lsServerExtension"
    MO_CLASS_ID_LS_SERVER_FSM = "lsServerFsm"
    MO_CLASS_ID_LS_SERVER_FSM_STAGE = "lsServerFsmStage"
    MO_CLASS_ID_LS_SERVER_FSM_TASK = "lsServerFsmTask"
    MO_CLASS_ID_LS_SERVER_OPERATION = "lsServerOperation"
    MO_CLASS_ID_LS_TIER = "lsTier"
    MO_CLASS_ID_LS_VCON_ASSIGN = "lsVConAssign"
    MO_CLASS_ID_LS_WAITING_USER_ACK = "lsWaitingUserAck"
    MO_CLASS_ID_LS_ZONE_INITIATOR_MEMBER = "lsZoneInitiatorMember"
    MO_CLASS_ID_LS_ZONE_TARGET_MEMBER = "lsZoneTargetMember"
    MO_CLASS_ID_LSBOOT_ADEF = "lsbootADef"
    MO_CLASS_ID_LSBOOT_BOOT_SECURITY = "lsbootBootSecurity"
    MO_CLASS_ID_LSBOOT_CATEGORY = "lsbootCategory"
    MO_CLASS_ID_LSBOOT_DEF = "lsbootDef"
    MO_CLASS_ID_LSBOOT_DEFAULT_LOCAL_IMAGE = "lsbootDefaultLocalImage"
    MO_CLASS_ID_LSBOOT_EFISHELL = "lsbootEFIShell"
    MO_CLASS_ID_LSBOOT_EMBEDDED_LOCAL_DISK_IMAGE = "lsbootEmbeddedLocalDiskImage"
    MO_CLASS_ID_LSBOOT_EMBEDDED_LOCAL_DISK_IMAGE_PATH = "lsbootEmbeddedLocalDiskImagePath"
    MO_CLASS_ID_LSBOOT_EMBEDDED_LOCAL_LUN_IMAGE = "lsbootEmbeddedLocalLunImage"
    MO_CLASS_ID_LSBOOT_ISCSI = "lsbootIScsi"
    MO_CLASS_ID_LSBOOT_ISCSI_IMAGE_PATH = "lsbootIScsiImagePath"
    MO_CLASS_ID_LSBOOT_IMAGE = "lsbootImage"
    MO_CLASS_ID_LSBOOT_IMAGE_PATH = "lsbootImagePath"
    MO_CLASS_ID_LSBOOT_ITEM = "lsbootItem"
    MO_CLASS_ID_LSBOOT_LAN = "lsbootLan"
    MO_CLASS_ID_LSBOOT_LAN_IMAGE_PATH = "lsbootLanImagePath"
    MO_CLASS_ID_LSBOOT_LOCAL_DISK_IMAGE = "lsbootLocalDiskImage"
    MO_CLASS_ID_LSBOOT_LOCAL_DISK_IMAGE_PATH = "lsbootLocalDiskImagePath"
    MO_CLASS_ID_LSBOOT_LOCAL_HDD_IMAGE = "lsbootLocalHddImage"
    MO_CLASS_ID_LSBOOT_LOCAL_IMAGE = "lsbootLocalImage"
    MO_CLASS_ID_LSBOOT_LOCAL_LUN_IMAGE_PATH = "lsbootLocalLunImagePath"
    MO_CLASS_ID_LSBOOT_LOCAL_MEDIA_ITEM = "lsbootLocalMediaItem"
    MO_CLASS_ID_LSBOOT_LOCAL_STORAGE = "lsbootLocalStorage"
    MO_CLASS_ID_LSBOOT_NVME = "lsbootNvme"
    MO_CLASS_ID_LSBOOT_NVME_DEVICE = "lsbootNvmeDevice"
    MO_CLASS_ID_LSBOOT_NVME_DISK_SSD = "lsbootNvmeDiskSsd"
    MO_CLASS_ID_LSBOOT_NVME_PCI_SSD = "lsbootNvmePciSsd"
    MO_CLASS_ID_LSBOOT_POLICY = "lsbootPolicy"
    MO_CLASS_ID_LSBOOT_REMOTE_IMAGE = "lsbootRemoteImage"
    MO_CLASS_ID_LSBOOT_SAN = "lsbootSan"
    MO_CLASS_ID_LSBOOT_SAN_CAT_SAN_IMAGE = "lsbootSanCatSanImage"
    MO_CLASS_ID_LSBOOT_SAN_CAT_SAN_IMAGE_PATH = "lsbootSanCatSanImagePath"
    MO_CLASS_ID_LSBOOT_SAN_IMAGE = "lsbootSanImage"
    MO_CLASS_ID_LSBOOT_SAN_IMAGE_PATH = "lsbootSanImagePath"
    MO_CLASS_ID_LSBOOT_STORAGE = "lsbootStorage"
    MO_CLASS_ID_LSBOOT_UEFIBOOT_PARAM = "lsbootUEFIBootParam"
    MO_CLASS_ID_LSBOOT_UPGRADE_STATUS = "lsbootUpgradeStatus"
    MO_CLASS_ID_LSBOOT_USB_EXTERNAL_IMAGE = "lsbootUsbExternalImage"
    MO_CLASS_ID_LSBOOT_USB_FLASH_STORAGE_IMAGE = "lsbootUsbFlashStorageImage"
    MO_CLASS_ID_LSBOOT_USB_INTERNAL_IMAGE = "lsbootUsbInternalImage"
    MO_CLASS_ID_LSBOOT_VIRTUAL_MEDIA = "lsbootVirtualMedia"
    MO_CLASS_ID_LSMAINT_ACK = "lsmaintAck"
    MO_CLASS_ID_LSMAINT_MAINT_POLICY = "lsmaintMaintPolicy"
    MO_CLASS_ID_LSTORAGE_ASLOT = "lstorageASlot"
    MO_CLASS_ID_LSTORAGE_ACK = "lstorageAck"
    MO_CLASS_ID_LSTORAGE_ARRAY_REQUIREMENT = "lstorageArrayRequirement"
    MO_CLASS_ID_LSTORAGE_BLADE = "lstorageBlade"
    MO_CLASS_ID_LSTORAGE_CONTROLLER_DEF = "lstorageControllerDef"
    MO_CLASS_ID_LSTORAGE_CONTROLLER_MODE_CONFIG = "lstorageControllerModeConfig"
    MO_CLASS_ID_LSTORAGE_CONTROLLER_QUALIFIER = "lstorageControllerQualifier"
    MO_CLASS_ID_LSTORAGE_CONTROLLER_REF = "lstorageControllerRef"
    MO_CLASS_ID_LSTORAGE_CTRL_SERVICE_OPERATION = "lstorageCtrlServiceOperation"
    MO_CLASS_ID_LSTORAGE_DAS_SCSI_LUN = "lstorageDasScsiLun"
    MO_CLASS_ID_LSTORAGE_DISK_GROUP_CONFIG = "lstorageDiskGroupConfig"
    MO_CLASS_ID_LSTORAGE_DISK_GROUP_CONFIG_DEF = "lstorageDiskGroupConfigDef"
    MO_CLASS_ID_LSTORAGE_DISK_GROUP_CONFIG_POLICY = "lstorageDiskGroupConfigPolicy"
    MO_CLASS_ID_LSTORAGE_DISK_GROUP_QUALIFIER = "lstorageDiskGroupQualifier"
    MO_CLASS_ID_LSTORAGE_DISK_SLOT = "lstorageDiskSlot"
    MO_CLASS_ID_LSTORAGE_DISK_ZONING_CONFIG = "lstorageDiskZoningConfig"
    MO_CLASS_ID_LSTORAGE_DISK_ZONING_CONFIG_DEF = "lstorageDiskZoningConfigDef"
    MO_CLASS_ID_LSTORAGE_DISK_ZONING_POLICY = "lstorageDiskZoningPolicy"
    MO_CLASS_ID_LSTORAGE_DRIVE_SECURITY = "lstorageDriveSecurity"
    MO_CLASS_ID_LSTORAGE_EXTENSION = "lstorageExtension"
    MO_CLASS_ID_LSTORAGE_ITEM = "lstorageItem"
    MO_CLASS_ID_LSTORAGE_LOCAL = "lstorageLocal"
    MO_CLASS_ID_LSTORAGE_LOCAL_CONFIG = "lstorageLocalConfig"
    MO_CLASS_ID_LSTORAGE_LOCAL_DEF = "lstorageLocalDef"
    MO_CLASS_ID_LSTORAGE_LOCAL_DISK_CONFIG_REF = "lstorageLocalDiskConfigRef"
    MO_CLASS_ID_LSTORAGE_LOCAL_DISK_REF = "lstorageLocalDiskRef"
    MO_CLASS_ID_LSTORAGE_LOGIN = "lstorageLogin"
    MO_CLASS_ID_LSTORAGE_META = "lstorageMeta"
    MO_CLASS_ID_LSTORAGE_PROCESSOR_BASE = "lstorageProcessorBase"
    MO_CLASS_ID_LSTORAGE_PROFILE = "lstorageProfile"
    MO_CLASS_ID_LSTORAGE_PROFILE_BASE = "lstorageProfileBase"
    MO_CLASS_ID_LSTORAGE_PROFILE_BINDING = "lstorageProfileBinding"
    MO_CLASS_ID_LSTORAGE_PROFILE_BINDING_BASE = "lstorageProfileBindingBase"
    MO_CLASS_ID_LSTORAGE_PROFILE_DEF = "lstorageProfileDef"
    MO_CLASS_ID_LSTORAGE_QUAL_ITEM = "lstorageQualItem"
    MO_CLASS_ID_LSTORAGE_RECURR_WINDOW = "lstorageRecurrWindow"
    MO_CLASS_ID_LSTORAGE_REMOTE = "lstorageRemote"
    MO_CLASS_ID_LSTORAGE_REMOTE_CONFIG = "lstorageRemoteConfig"
    MO_CLASS_ID_LSTORAGE_REMOTE_DEF = "lstorageRemoteDef"
    MO_CLASS_ID_LSTORAGE_REQUEST_CTX = "lstorageRequestCtx"
    MO_CLASS_ID_LSTORAGE_SCSI_LUN = "lstorageScsiLun"
    MO_CLASS_ID_LSTORAGE_SECURITY = "lstorageSecurity"
    MO_CLASS_ID_LSTORAGE_VIRTUAL_DRIVE_DEF = "lstorageVirtualDriveDef"
    MO_CLASS_ID_MACPOOL_ADDR = "macpoolAddr"
    MO_CLASS_ID_MACPOOL_BLOCK = "macpoolBlock"
    MO_CLASS_ID_MACPOOL_FORMAT = "macpoolFormat"
    MO_CLASS_ID_MACPOOL_POOL = "macpoolPool"
    MO_CLASS_ID_MACPOOL_POOLED = "macpoolPooled"
    MO_CLASS_ID_MACPOOL_UNIVERSE = "macpoolUniverse"
    MO_CLASS_ID_MEMORY_ARRAY = "memoryArray"
    MO_CLASS_ID_MEMORY_ARRAY_ENV_STATS = "memoryArrayEnvStats"
    MO_CLASS_ID_MEMORY_ARRAY_ENV_STATS_HIST = "memoryArrayEnvStatsHist"
    MO_CLASS_ID_MEMORY_BUFFER_UNIT = "memoryBufferUnit"
    MO_CLASS_ID_MEMORY_BUFFER_UNIT_ENV_STATS = "memoryBufferUnitEnvStats"
    MO_CLASS_ID_MEMORY_BUFFER_UNIT_ENV_STATS_HIST = "memoryBufferUnitEnvStatsHist"
    MO_CLASS_ID_MEMORY_CONTROLLER = "memoryController"
    MO_CLASS_ID_MEMORY_ERROR_STATS = "memoryErrorStats"
    MO_CLASS_ID_MEMORY_ERROR_STATS_HIST = "memoryErrorStatsHist"
    MO_CLASS_ID_MEMORY_NV_DIMM = "memoryNvDimm"
    MO_CLASS_ID_MEMORY_NV_DIMM_BATTERY = "memoryNvDimmBattery"
    MO_CLASS_ID_MEMORY_NV_DIMM_CONTROLLER = "memoryNvDimmController"
    MO_CLASS_ID_MEMORY_QUAL = "memoryQual"
    MO_CLASS_ID_MEMORY_RUNTIME = "memoryRuntime"
    MO_CLASS_ID_MEMORY_RUNTIME_HIST = "memoryRuntimeHist"
    MO_CLASS_ID_MEMORY_UNIT = "memoryUnit"
    MO_CLASS_ID_MEMORY_UNIT_ENV_STATS = "memoryUnitEnvStats"
    MO_CLASS_ID_MEMORY_UNIT_ENV_STATS_HIST = "memoryUnitEnvStatsHist"
    MO_CLASS_ID_MESSAGE_ENTRY = "messageEntry"
    MO_CLASS_ID_MESSAGE_EP = "messageEp"
    MO_CLASS_ID_MGMT_AKMIP_CERT_POLICY = "mgmtAKmipCertPolicy"
    MO_CLASS_ID_MGMT_ASECURE_BOOT = "mgmtASecureBoot"
    MO_CLASS_ID_MGMT_ABS_BACKUP = "mgmtAbsBackup"
    MO_CLASS_ID_MGMT_ABS_DATA_ITEM = "mgmtAbsDataItem"
    MO_CLASS_ID_MGMT_ABS_IMPORTER = "mgmtAbsImporter"
    MO_CLASS_ID_MGMT_BACKUP = "mgmtBackup"
    MO_CLASS_ID_MGMT_BACKUP_FSM = "mgmtBackupFsm"
    MO_CLASS_ID_MGMT_BACKUP_FSM_STAGE = "mgmtBackupFsmStage"
    MO_CLASS_ID_MGMT_BACKUP_FSM_TASK = "mgmtBackupFsmTask"
    MO_CLASS_ID_MGMT_BACKUP_OPERATION = "mgmtBackupOperation"
    MO_CLASS_ID_MGMT_BACKUP_POLICY = "mgmtBackupPolicy"
    MO_CLASS_ID_MGMT_BACKUP_TRIGGER = "mgmtBackupTrigger"
    MO_CLASS_ID_MGMT_BACKUP_TRIGGER_FSM = "mgmtBackupTriggerFsm"
    MO_CLASS_ID_MGMT_BACKUP_TRIGGER_FSM_STAGE = "mgmtBackupTriggerFsmStage"
    MO_CLASS_ID_MGMT_BACKUP_TRIGGER_FSM_TASK = "mgmtBackupTriggerFsmTask"
    MO_CLASS_ID_MGMT_CFG_EXPORT_POLICY = "mgmtCfgExportPolicy"
    MO_CLASS_ID_MGMT_CIMC_INTERFACE = "mgmtCimcInterface"
    MO_CLASS_ID_MGMT_CMC_SECURE_BOOT = "mgmtCmcSecureBoot"
    MO_CLASS_ID_MGMT_CMC_SECURE_BOOT_OPERATION = "mgmtCmcSecureBootOperation"
    MO_CLASS_ID_MGMT_CONNECTION = "mgmtConnection"
    MO_CLASS_ID_MGMT_CONTROLLER = "mgmtController"
    MO_CLASS_ID_MGMT_DATA_EXPORTER = "mgmtDataExporter"
    MO_CLASS_ID_MGMT_DATA_EXPORTER_FSM = "mgmtDataExporterFsm"
    MO_CLASS_ID_MGMT_DATA_EXPORTER_FSM_STAGE = "mgmtDataExporterFsmStage"
    MO_CLASS_ID_MGMT_DATA_EXPORTER_FSM_TASK = "mgmtDataExporterFsmTask"
    MO_CLASS_ID_MGMT_DATA_IMPORTER = "mgmtDataImporter"
    MO_CLASS_ID_MGMT_DATA_IMPORTER_FSM = "mgmtDataImporterFsm"
    MO_CLASS_ID_MGMT_DATA_IMPORTER_FSM_STAGE = "mgmtDataImporterFsmStage"
    MO_CLASS_ID_MGMT_DATA_IMPORTER_FSM_TASK = "mgmtDataImporterFsmTask"
    MO_CLASS_ID_MGMT_DATA_ITEM = "mgmtDataItem"
    MO_CLASS_ID_MGMT_ENTITY = "mgmtEntity"
    MO_CLASS_ID_MGMT_EP = "mgmtEp"
    MO_CLASS_ID_MGMT_EXPORT_POLICY = "mgmtExportPolicy"
    MO_CLASS_ID_MGMT_IPV6_ADDR = "mgmtIPv6Addr"
    MO_CLASS_ID_MGMT_IPV6_IF_ADDR = "mgmtIPv6IfAddr"
    MO_CLASS_ID_MGMT_IPV6_IF_CONFIG = "mgmtIPv6IfConfig"
    MO_CLASS_ID_MGMT_IF = "mgmtIf"
    MO_CLASS_ID_MGMT_IF_FSM = "mgmtIfFsm"
    MO_CLASS_ID_MGMT_IF_FSM_STAGE = "mgmtIfFsmStage"
    MO_CLASS_ID_MGMT_IF_FSM_TASK = "mgmtIfFsmTask"
    MO_CLASS_ID_MGMT_IMPORT_ITEM = "mgmtImportItem"
    MO_CLASS_ID_MGMT_IMPORTER = "mgmtImporter"
    MO_CLASS_ID_MGMT_IMPORTER_FSM = "mgmtImporterFsm"
    MO_CLASS_ID_MGMT_IMPORTER_FSM_STAGE = "mgmtImporterFsmStage"
    MO_CLASS_ID_MGMT_IMPORTER_FSM_TASK = "mgmtImporterFsmTask"
    MO_CLASS_ID_MGMT_INBAND_PROFILE = "mgmtInbandProfile"
    MO_CLASS_ID_MGMT_INTERFACE = "mgmtInterface"
    MO_CLASS_ID_MGMT_KMIP = "mgmtKmip"
    MO_CLASS_ID_MGMT_KMIP_CERT_POLICY = "mgmtKmipCertPolicy"
    MO_CLASS_ID_MGMT_KMIP_OPERATION = "mgmtKmipOperation"
    MO_CLASS_ID_MGMT_NAMED_KMIP_CERT_POLICY = "mgmtNamedKmipCertPolicy"
    MO_CLASS_ID_MGMT_REGISTRY_INFO = "mgmtRegistryInfo"
    MO_CLASS_ID_MGMT_REGISTRY_INFO_FSM = "mgmtRegistryInfoFsm"
    MO_CLASS_ID_MGMT_REGISTRY_INFO_FSM_STAGE = "mgmtRegistryInfoFsmStage"
    MO_CLASS_ID_MGMT_REGISTRY_INFO_FSM_TASK = "mgmtRegistryInfoFsmTask"
    MO_CLASS_ID_MGMT_SECURITY = "mgmtSecurity"
    MO_CLASS_ID_MGMT_SVC = "mgmtSvc"
    MO_CLASS_ID_MGMT_VNET = "mgmtVnet"
    MO_CLASS_ID_MO_TOP_PROPS = "moTopProps"
    MO_CLASS_ID_NAMING_BINDING = "namingBinding"
    MO_CLASS_ID_NAMING_DEFINITION = "namingDefinition"
    MO_CLASS_ID_NAMING_HOLDER = "namingHolder"
    MO_CLASS_ID_NAMING_NAMED_IDENTIFIED_OBJECT = "namingNamedIdentifiedObject"
    MO_CLASS_ID_NAMING_NAMED_OBJECT = "namingNamedObject"
    MO_CLASS_ID_NAMING_OBJECT = "namingObject"
    MO_CLASS_ID_NET_NET_GROUP_PERMIT = "netNetGroupPermit"
    MO_CLASS_ID_NETWORK_CACERT = "networkCACert"
    MO_CLASS_ID_NETWORK_CIO_EP = "networkCIoEp"
    MO_CLASS_ID_NETWORK_CONN = "networkConn"
    MO_CLASS_ID_NETWORK_ELEMENT = "networkElement"
    MO_CLASS_ID_NETWORK_ELEMENT_FSM = "networkElementFsm"
    MO_CLASS_ID_NETWORK_ELEMENT_FSM_STAGE = "networkElementFsmStage"
    MO_CLASS_ID_NETWORK_ELEMENT_FSM_TASK = "networkElementFsmTask"
    MO_CLASS_ID_NETWORK_ELEMENT_OPERATION = "networkElementOperation"
    MO_CLASS_ID_NETWORK_EP = "networkEp"
    MO_CLASS_ID_NETWORK_IF_EP = "networkIfEp"
    MO_CLASS_ID_NETWORK_PIO_EP = "networkPIoEp"
    MO_CLASS_ID_NETWORK_PHYS_EP = "networkPhysEp"
    MO_CLASS_ID_NETWORK_SYSTEM_CACERT = "networkSystemCACert"
    MO_CLASS_ID_NETWORK_VNET_EP = "networkVnetEp"
    MO_CLASS_ID_NFS_CLIENT_DEF = "nfsClientDef"
    MO_CLASS_ID_NFS_CLIENT_DEF_FSM = "nfsClientDefFsm"
    MO_CLASS_ID_NFS_CLIENT_DEF_FSM_STAGE = "nfsClientDefFsmStage"
    MO_CLASS_ID_NFS_CLIENT_DEF_FSM_TASK = "nfsClientDefFsmTask"
    MO_CLASS_ID_NFS_EP = "nfsEp"
    MO_CLASS_ID_NFS_EXPORT_DEF = "nfsExportDef"
    MO_CLASS_ID_NFS_EXPORT_DEF_FSM = "nfsExportDefFsm"
    MO_CLASS_ID_NFS_EXPORT_DEF_FSM_STAGE = "nfsExportDefFsmStage"
    MO_CLASS_ID_NFS_EXPORT_DEF_FSM_TASK = "nfsExportDefFsmTask"
    MO_CLASS_ID_NFS_MOUNT_DEF = "nfsMountDef"
    MO_CLASS_ID_NFS_REPOSITORY_SPEC_POLICY = "nfsRepositorySpecPolicy"
    MO_CLASS_ID_NWCTRL_DEFINITION = "nwctrlDefinition"
    MO_CLASS_ID_OBSERVE_FILTER = "observeFilter"
    MO_CLASS_ID_OBSERVE_OBSERVED = "observeObserved"
    MO_CLASS_ID_OBSERVE_OBSERVED_CONT = "observeObservedCont"
    MO_CLASS_ID_OBSERVE_OBSERVED_FSM = "observeObservedFsm"
    MO_CLASS_ID_OBSERVE_OBSERVED_FSM_STAGE = "observeObservedFsmStage"
    MO_CLASS_ID_OBSERVE_OBSERVED_FSM_TASK = "observeObservedFsmTask"
    MO_CLASS_ID_ORG_AORG = "orgAOrg"
    MO_CLASS_ID_ORG_DOMAIN_FIRMWARE_INFO = "orgDomainFirmwareInfo"
    MO_CLASS_ID_ORG_DOMAIN_GROUP = "orgDomainGroup"
    MO_CLASS_ID_ORG_DOMAIN_GROUP_FIRMWARE_REPORT = "orgDomainGroupFirmwareReport"
    MO_CLASS_ID_ORG_DOMAIN_GROUP_POLICY = "orgDomainGroupPolicy"
    MO_CLASS_ID_ORG_DOMAIN_GROUP_POLICY_REPORT = "orgDomainGroupPolicyReport"
    MO_CLASS_ID_ORG_DOMAIN_GROUP_REPORT = "orgDomainGroupReport"
    MO_CLASS_ID_ORG_EXTENSION = "orgExtension"
    MO_CLASS_ID_ORG_FIRMWARE_VERSION_COUNT = "orgFirmwareVersionCount"
    MO_CLASS_ID_ORG_MAINT_TAG_FIRMWARE_REPORT = "orgMaintTagFirmwareReport"
    MO_CLASS_ID_ORG_ORG = "orgOrg"
    MO_CLASS_ID_ORG_ORG_FSM = "orgOrgFsm"
    MO_CLASS_ID_ORG_ORG_FSM_STAGE = "orgOrgFsmStage"
    MO_CLASS_ID_ORG_ORG_FSM_TASK = "orgOrgFsmTask"
    MO_CLASS_ID_ORG_ORG_SOURCE = "orgOrgSource"
    MO_CLASS_ID_ORG_SOURCE_MASK = "orgSourceMask"
    MO_CLASS_ID_OS_CONTROLLER = "osController"
    MO_CLASS_ID_OS_ETH_BOND_INTF = "osEthBondIntf"
    MO_CLASS_ID_OS_ETH_BOND_MODE = "osEthBondMode"
    MO_CLASS_ID_OS_ETH_INTF = "osEthIntf"
    MO_CLASS_ID_OS_INSTANCE = "osInstance"
    MO_CLASS_ID_OS_INTF = "osIntf"
    MO_CLASS_ID_OS_LINK_MONITORING_POLICY = "osLinkMonitoringPolicy"
    MO_CLASS_ID_OS_PRIMARY_SLAVE = "osPrimarySlave"
    MO_CLASS_ID_PCI_CARD = "pciCard"
    MO_CLASS_ID_PKI_CERT_REQ = "pkiCertReq"
    MO_CLASS_ID_PKI_DEFINITION = "pkiDefinition"
    MO_CLASS_ID_PKI_EP = "pkiEp"
    MO_CLASS_ID_PKI_EP_FSM = "pkiEpFsm"
    MO_CLASS_ID_PKI_EP_FSM_STAGE = "pkiEpFsmStage"
    MO_CLASS_ID_PKI_EP_FSM_TASK = "pkiEpFsmTask"
    MO_CLASS_ID_PKI_ITEM = "pkiItem"
    MO_CLASS_ID_PKI_KEY_RING = "pkiKeyRing"
    MO_CLASS_ID_PKI_TP = "pkiTP"
    MO_CLASS_ID_POLICY_ADEST_EP = "policyADestEp"
    MO_CLASS_ID_POLICY_ACK_SUSPEND_OPERATION = "policyAckSuspendOperation"
    MO_CLASS_ID_POLICY_BINDING = "policyBinding"
    MO_CLASS_ID_POLICY_CHILD_CLASS = "policyChildClass"
    MO_CLASS_ID_POLICY_CLUSTER = "policyCluster"
    MO_CLASS_ID_POLICY_COMMUNICATION = "policyCommunication"
    MO_CLASS_ID_POLICY_COMMUNICATION_OP = "policyCommunicationOp"
    MO_CLASS_ID_POLICY_CONFIG_BACKUP = "policyConfigBackup"
    MO_CLASS_ID_POLICY_CONFIG_BACKUP_OP = "policyConfigBackupOp"
    MO_CLASS_ID_POLICY_CONFIG_ERROR = "policyConfigError"
    MO_CLASS_ID_POLICY_CONTEXT = "policyContext"
    MO_CLASS_ID_POLICY_CONTROL = "policyControl"
    MO_CLASS_ID_POLICY_CONTROL_EP = "policyControlEp"
    MO_CLASS_ID_POLICY_CONTROL_EP_OP = "policyControlEpOp"
    MO_CLASS_ID_POLICY_CONTROL_EP_OP_FSM = "policyControlEpOpFsm"
    MO_CLASS_ID_POLICY_CONTROL_EP_OP_FSM_STAGE = "policyControlEpOpFsmStage"
    MO_CLASS_ID_POLICY_CONTROL_EP_OP_FSM_TASK = "policyControlEpOpFsmTask"
    MO_CLASS_ID_POLICY_CONTROL_EP_OPERATION = "policyControlEpOperation"
    MO_CLASS_ID_POLICY_CONTROL_OP = "policyControlOp"
    MO_CLASS_ID_POLICY_CONTROLLED = "policyControlled"
    MO_CLASS_ID_POLICY_CONTROLLED_INSTANCE = "policyControlledInstance"
    MO_CLASS_ID_POLICY_CONTROLLED_TYPE = "policyControlledType"
    MO_CLASS_ID_POLICY_DATE_TIME = "policyDateTime"
    MO_CLASS_ID_POLICY_DATE_TIME_OP = "policyDateTimeOp"
    MO_CLASS_ID_POLICY_DEFINITION = "policyDefinition"
    MO_CLASS_ID_POLICY_DEST_CLASS = "policyDestClass"
    MO_CLASS_ID_POLICY_DEST_EP = "policyDestEp"
    MO_CLASS_ID_POLICY_DEVICE_PROFILE = "policyDeviceProfile"
    MO_CLASS_ID_POLICY_DIGEST = "policyDigest"
    MO_CLASS_ID_POLICY_DISCOVERY = "policyDiscovery"
    MO_CLASS_ID_POLICY_DISCOVERY_OP = "policyDiscoveryOp"
    MO_CLASS_ID_POLICY_DNS = "policyDns"
    MO_CLASS_ID_POLICY_DNS_OP = "policyDnsOp"
    MO_CLASS_ID_POLICY_ELEMENT = "policyElement"
    MO_CLASS_ID_POLICY_EQUIPMENT = "policyEquipment"
    MO_CLASS_ID_POLICY_EQUIPMENT_OP = "policyEquipmentOp"
    MO_CLASS_ID_POLICY_FAULT = "policyFault"
    MO_CLASS_ID_POLICY_FAULT_OP = "policyFaultOp"
    MO_CLASS_ID_POLICY_IDENTIFIER_POLICY = "policyIdentifierPolicy"
    MO_CLASS_ID_POLICY_INFRA_FIRMWARE = "policyInfraFirmware"
    MO_CLASS_ID_POLICY_INFRA_FIRMWARE_OP = "policyInfraFirmwareOp"
    MO_CLASS_ID_POLICY_ITEM = "policyItem"
    MO_CLASS_ID_POLICY_LOCAL_MAP = "policyLocalMap"
    MO_CLASS_ID_POLICY_LOG_PROFILE = "policyLogProfile"
    MO_CLASS_ID_POLICY_MEP = "policyMEp"
    MO_CLASS_ID_POLICY_MEP_OP = "policyMEpOp"
    MO_CLASS_ID_POLICY_MONITORING = "policyMonitoring"
    MO_CLASS_ID_POLICY_MONITORING_OP = "policyMonitoringOp"
    MO_CLASS_ID_POLICY_OBJECT = "policyObject"
    MO_CLASS_ID_POLICY_POLICY_DEST_CLASS = "policyPolicyDestClass"
    MO_CLASS_ID_POLICY_POLICY_EP = "policyPolicyEp"
    MO_CLASS_ID_POLICY_POLICY_REQUESTOR = "policyPolicyRequestor"
    MO_CLASS_ID_POLICY_POLICY_SCOPE = "policyPolicyScope"
    MO_CLASS_ID_POLICY_POLICY_SCOPE_CONT = "policyPolicyScopeCont"
    MO_CLASS_ID_POLICY_POLICY_SCOPE_CONTEXT = "policyPolicyScopeContext"
    MO_CLASS_ID_POLICY_POLICY_SCOPE_FSM = "policyPolicyScopeFsm"
    MO_CLASS_ID_POLICY_POLICY_SCOPE_FSM_STAGE = "policyPolicyScopeFsmStage"
    MO_CLASS_ID_POLICY_POLICY_SCOPE_FSM_TASK = "policyPolicyScopeFsmTask"
    MO_CLASS_ID_POLICY_PORT_CONFIG = "policyPortConfig"
    MO_CLASS_ID_POLICY_PORT_CONFIG_OP = "policyPortConfigOp"
    MO_CLASS_ID_POLICY_POWER_MGMT = "policyPowerMgmt"
    MO_CLASS_ID_POLICY_POWER_MGMT_OP = "policyPowerMgmtOp"
    MO_CLASS_ID_POLICY_PROXY_MO = "policyProxyMo"
    MO_CLASS_ID_POLICY_PSU = "policyPsu"
    MO_CLASS_ID_POLICY_PSU_OP = "policyPsuOp"
    MO_CLASS_ID_POLICY_REQUESTOR = "policyRequestor"
    MO_CLASS_ID_POLICY_SCOPE = "policyScope"
    MO_CLASS_ID_POLICY_SECURITY = "policySecurity"
    MO_CLASS_ID_POLICY_SECURITY_OP = "policySecurityOp"
    MO_CLASS_ID_POLICY_SOURCE = "policySource"
    MO_CLASS_ID_POLICY_SOURCE_APP = "policySourceApp"
    MO_CLASS_ID_POLICY_STORAGE_AUTO_CONFIG = "policyStorageAutoConfig"
    MO_CLASS_ID_POLICY_STORAGE_AUTO_CONFIG_OP = "policyStorageAutoConfigOp"
    MO_CLASS_ID_POLICY_SYSTEM_EP = "policySystemEp"
    MO_CLASS_ID_POLICY_SYSTEM_PROFILE = "policySystemProfile"
    MO_CLASS_ID_POLICY_TRACKED = "policyTracked"
    MO_CLASS_ID_POLICY_TRACKER = "policyTracker"
    MO_CLASS_ID_POLICY_UNIVERSE = "policyUniverse"
    MO_CLASS_ID_POOL_ASNMT = "poolAsnmt"
    MO_CLASS_ID_POOL_ELEMENT = "poolElement"
    MO_CLASS_ID_POOL_ELEMENT_ALLOC = "poolElementAlloc"
    MO_CLASS_ID_POOL_MEMBER = "poolMember"
    MO_CLASS_ID_POOL_POOL = "poolPool"
    MO_CLASS_ID_POOL_POOL_MEMBER = "poolPoolMember"
    MO_CLASS_ID_POOL_POOLABLE = "poolPoolable"
    MO_CLASS_ID_POOL_UNIVERSE = "poolUniverse"
    MO_CLASS_ID_PORT_GROUP = "portGroup"
    MO_CLASS_ID_PORT_INT_FIO = "portIntFIo"
    MO_CLASS_ID_PORT_PIO = "portPIo"
    MO_CLASS_ID_PORT_PHYS_SWITCH_IO = "portPhysSwitchIo"
    MO_CLASS_ID_PORT_SERVER_INT_FIO = "portServerIntFIo"
    MO_CLASS_ID_PORT_SUB_GROUP = "portSubGroup"
    MO_CLASS_ID_PORT_SWITCH_INT_FIO = "portSwitchIntFIo"
    MO_CLASS_ID_POWER_ABUDGET = "powerABudget"
    MO_CLASS_ID_POWER_AGROUP = "powerAGroup"
    MO_CLASS_ID_POWER_BUDGET = "powerBudget"
    MO_CLASS_ID_POWER_CHASSIS_MEMBER = "powerChassisMember"
    MO_CLASS_ID_POWER_EP = "powerEp"
    MO_CLASS_ID_POWER_GROUP = "powerGroup"
    MO_CLASS_ID_POWER_GROUP_MEMBER = "powerGroupMember"
    MO_CLASS_ID_POWER_GROUP_QUAL = "powerGroupQual"
    MO_CLASS_ID_POWER_GROUP_STATS = "powerGroupStats"
    MO_CLASS_ID_POWER_GROUP_STATS_HIST = "powerGroupStatsHist"
    MO_CLASS_ID_POWER_MGMT_POLICY = "powerMgmtPolicy"
    MO_CLASS_ID_POWER_POLICY = "powerPolicy"
    MO_CLASS_ID_POWER_PROFILED_POWER = "powerProfiledPower"
    MO_CLASS_ID_PROC_DOER = "procDoer"
    MO_CLASS_ID_PROC_MANAGER = "procManager"
    MO_CLASS_ID_PROC_PROC_COUNTS = "procProcCounts"
    MO_CLASS_ID_PROC_PROCS = "procProcs"
    MO_CLASS_ID_PROC_PRT = "procPrt"
    MO_CLASS_ID_PROC_PRT_COUNTS = "procPrtCounts"
    MO_CLASS_ID_PROC_STIMULUS_COUNTS = "procStimulusCounts"
    MO_CLASS_ID_PROC_SVC = "procSvc"
    MO_CLASS_ID_PROC_TX_COUNTS = "procTxCounts"
    MO_CLASS_ID_PROCESSOR_ENV_STATS = "processorEnvStats"
    MO_CLASS_ID_PROCESSOR_ENV_STATS_HIST = "processorEnvStatsHist"
    MO_CLASS_ID_PROCESSOR_ERROR_STATS = "processorErrorStats"
    MO_CLASS_ID_PROCESSOR_ERROR_STATS_HIST = "processorErrorStatsHist"
    MO_CLASS_ID_PROCESSOR_QUAL = "processorQual"
    MO_CLASS_ID_PROCESSOR_RUNTIME = "processorRuntime"
    MO_CLASS_ID_PROCESSOR_RUNTIME_HIST = "processorRuntimeHist"
    MO_CLASS_ID_PROCESSOR_UNIT = "processorUnit"
    MO_CLASS_ID_PROCESSOR_UNIT_ASSOC_CTX = "processorUnitAssocCtx"
    MO_CLASS_ID_QOS_DEFINITION = "qosDefinition"
    MO_CLASS_ID_QOS_ITEM = "qosItem"
    MO_CLASS_ID_QOSCLASS_DEFINITION = "qosclassDefinition"
    MO_CLASS_ID_QOSCLASS_ETH = "qosclassEth"
    MO_CLASS_ID_QOSCLASS_ETH_BE = "qosclassEthBE"
    MO_CLASS_ID_QOSCLASS_ETH_CLASSIFIED = "qosclassEthClassified"
    MO_CLASS_ID_QOSCLASS_FC = "qosclassFc"
    MO_CLASS_ID_QOSCLASS_ITEM = "qosclassItem"
    MO_CLASS_ID_QOSCLASS_POLICY = "qosclassPolicy"
    MO_CLASS_ID_QUERY_CONTEXT = "queryContext"
    MO_CLASS_ID_QUERY_DEPENDENCY_CONTEXT = "queryDependencyContext"
    MO_CLASS_ID_QUERY_DEPENDENCY_REF = "queryDependencyRef"
    MO_CLASS_ID_QUERY_EP = "queryEp"
    MO_CLASS_ID_QUERY_IMPORT_CONTEXT = "queryImportContext"
    MO_CLASS_ID_QUERY_USAGE_CONTEXT = "queryUsageContext"
    MO_CLASS_ID_QUERYRESULT_DEPENDENCY = "queryresultDependency"
    MO_CLASS_ID_QUERYRESULT_DEST_ORG_EP = "queryresultDestOrgEp"
    MO_CLASS_ID_QUERYRESULT_DOMAIN_GROUP_EP = "queryresultDomainGroupEp"
    MO_CLASS_ID_QUERYRESULT_ITEM = "queryresultItem"
    MO_CLASS_ID_QUERYRESULT_ORG_EP = "queryresultOrgEp"
    MO_CLASS_ID_QUERYRESULT_USAGE = "queryresultUsage"
    MO_CLASS_ID_RULE_DEFINITION = "ruleDefinition"
    MO_CLASS_ID_RULE_ITEM = "ruleItem"
    MO_CLASS_ID_RULE_REQUIREMENT = "ruleRequirement"
    MO_CLASS_ID_RULE_SIZE_REQUIREMENT = "ruleSizeRequirement"
    MO_CLASS_ID_SECURITY_UNIT = "securityUnit"
    MO_CLASS_ID_SES_DISK_SLOT_EP = "sesDiskSlotEp"
    MO_CLASS_ID_SES_ENCLOSURE = "sesEnclosure"
    MO_CLASS_ID_SMARTCALLHOME_HTTP_PROXY = "smartcallhomeHttpProxy"
    MO_CLASS_ID_SMARTCALLHOME_PERIODIC_INVENTORY_STATUS = "smartcallhomePeriodicInventoryStatus"
    MO_CLASS_ID_SMARTCALLHOME_PERIODIC_SYSTEM_INVENTORY = "smartcallhomePeriodicSystemInventory"
    MO_CLASS_ID_SMARTCALLHOME_POLICY = "smartcallhomePolicy"
    MO_CLASS_ID_SMARTCALLHOME_PROFILE = "smartcallhomeProfile"
    MO_CLASS_ID_SMARTCALLHOME_SOURCE = "smartcallhomeSource"
    MO_CLASS_ID_SMARTCALLHOME_TRANSPORT_GATEWAY = "smartcallhomeTransportGateway"
    MO_CLASS_ID_SMARTLICENSE_AGENT = "smartlicenseAgent"
    MO_CLASS_ID_SMARTLICENSE_AGENT_FSM = "smartlicenseAgentFsm"
    MO_CLASS_ID_SMARTLICENSE_AGENT_FSM_STAGE = "smartlicenseAgentFsmStage"
    MO_CLASS_ID_SMARTLICENSE_AGENT_FSM_TASK = "smartlicenseAgentFsmTask"
    MO_CLASS_ID_SMARTLICENSE_ENTITLEMENT = "smartlicenseEntitlement"
    MO_CLASS_ID_SMARTLICENSE_ENTITLEMENT_EP = "smartlicenseEntitlementEp"
    MO_CLASS_ID_SMARTLICENSE_ENTITLEMENT_EP_FSM = "smartlicenseEntitlementEpFsm"
    MO_CLASS_ID_SMARTLICENSE_ENTITLEMENT_EP_FSM_STAGE = "smartlicenseEntitlementEpFsmStage"
    MO_CLASS_ID_SMARTLICENSE_ENTITLEMENT_EP_FSM_TASK = "smartlicenseEntitlementEpFsmTask"
    MO_CLASS_ID_SMARTLICENSE_EP = "smartlicenseEp"
    MO_CLASS_ID_SMARTLICENSE_HOLDER = "smartlicenseHolder"
    MO_CLASS_ID_SMARTLICENSE_HOLDER_FSM = "smartlicenseHolderFsm"
    MO_CLASS_ID_SMARTLICENSE_HOLDER_FSM_STAGE = "smartlicenseHolderFsmStage"
    MO_CLASS_ID_SMARTLICENSE_HOLDER_FSM_TASK = "smartlicenseHolderFsmTask"
    MO_CLASS_ID_SMARTLICENSE_TEST = "smartlicenseTest"
    MO_CLASS_ID_SMARTLICENSE_TEST_FSM = "smartlicenseTestFsm"
    MO_CLASS_ID_SMARTLICENSE_TEST_FSM_STAGE = "smartlicenseTestFsmStage"
    MO_CLASS_ID_SMARTLICENSE_TEST_FSM_TASK = "smartlicenseTestFsmTask"
    MO_CLASS_ID_SOL_DEF = "solDef"
    MO_CLASS_ID_SOL_POLICY = "solPolicy"
    MO_CLASS_ID_STATS_CHART = "statsChart"
    MO_CLASS_ID_STATS_CHART_CONTAINER = "statsChartContainer"
    MO_CLASS_ID_STATS_COLLECTION_POLICY = "statsCollectionPolicy"
    MO_CLASS_ID_STATS_CURR = "statsCurr"
    MO_CLASS_ID_STATS_CUSTOM_CHART = "statsCustomChart"
    MO_CLASS_ID_STATS_CUSTOM_EP = "statsCustomEp"
    MO_CLASS_ID_STATS_DB_MIGRATION_STATUS = "statsDbMigrationStatus"
    MO_CLASS_ID_STATS_DB_SUMMARY_META = "statsDbSummaryMeta"
    MO_CLASS_ID_STATS_HIST = "statsHist"
    MO_CLASS_ID_STATS_HOLDER = "statsHolder"
    MO_CLASS_ID_STATS_INVENTORY_META = "statsInventoryMeta"
    MO_CLASS_ID_STATS_ITEM = "statsItem"
    MO_CLASS_ID_STATS_PASADENA_COLLECTION_POLICY = "statsPasadenaCollectionPolicy"
    MO_CLASS_ID_STATS_STANDARD_CHART = "statsStandardChart"
    MO_CLASS_ID_STATS_STANDARD_EP = "statsStandardEp"
    MO_CLASS_ID_STATS_STATS_QUERY = "statsStatsQuery"
    MO_CLASS_ID_STATS_STATS_QUERY_HOLDER = "statsStatsQueryHolder"
    MO_CLASS_ID_STATS_THR32_DEFINITION = "statsThr32Definition"
    MO_CLASS_ID_STATS_THR32_VALUE = "statsThr32Value"
    MO_CLASS_ID_STATS_THR64_DEFINITION = "statsThr64Definition"
    MO_CLASS_ID_STATS_THR64_VALUE = "statsThr64Value"
    MO_CLASS_ID_STATS_THR_FLOAT_DEFINITION = "statsThrFloatDefinition"
    MO_CLASS_ID_STATS_THR_FLOAT_VALUE = "statsThrFloatValue"
    MO_CLASS_ID_STATS_THRESHOLD_CLASS = "statsThresholdClass"
    MO_CLASS_ID_STATS_THRESHOLD_DEFINITION = "statsThresholdDefinition"
    MO_CLASS_ID_STATS_THRESHOLD_POLICY = "statsThresholdPolicy"
    MO_CLASS_ID_STATS_THRESHOLD_VALUE = "statsThresholdValue"
    MO_CLASS_ID_STORAGE_ADEF = "storageADef"
    MO_CLASS_ID_STORAGE_ALUN = "storageALun"
    MO_CLASS_ID_STORAGE_ALUN_REF_BASE = "storageALunRefBase"
    MO_CLASS_ID_STORAGE_ASCSI_LUN = "storageAScsiLun"
    MO_CLASS_ID_STORAGE_ASCSI_LUN_CTX = "storageAScsiLunCtx"
    MO_CLASS_ID_STORAGE_ASLOT = "storageASlot"
    MO_CLASS_ID_STORAGE_ASNAP_REPLICA_LUN_CTX = "storageASnapReplicaLunCtx"
    MO_CLASS_ID_STORAGE_AVOLUME = "storageAVolume"
    MO_CLASS_ID_STORAGE_APPLIANCE = "storageAppliance"
    MO_CLASS_ID_STORAGE_ARRAY = "storageArray"
    MO_CLASS_ID_STORAGE_AUTH_KEY = "storageAuthKey"
    MO_CLASS_ID_STORAGE_BACKSTORE = "storageBackstore"
    MO_CLASS_ID_STORAGE_BLADE = "storageBlade"
    MO_CLASS_ID_STORAGE_CLOUD = "storageCloud"
    MO_CLASS_ID_STORAGE_CLUSTER_ID_UNIVERSE = "storageClusterIdUniverse"
    MO_CLASS_ID_STORAGE_COMPUTE_BLADE_OPERATION = "storageComputeBladeOperation"
    MO_CLASS_ID_STORAGE_CONNECTION_DEF = "storageConnectionDef"
    MO_CLASS_ID_STORAGE_CONNECTION_POLICY = "storageConnectionPolicy"
    MO_CLASS_ID_STORAGE_CONTAINER = "storageContainer"
    MO_CLASS_ID_STORAGE_CONTROLLER = "storageController"
    MO_CLASS_ID_STORAGE_CONTROLLER_BASE = "storageControllerBase"
    MO_CLASS_ID_STORAGE_CONTROLLER_EP = "storageControllerEp"
    MO_CLASS_ID_STORAGE_CONTROLLER_OPERATION = "storageControllerOperation"
    MO_CLASS_ID_STORAGE_CONTROLLER_REF = "storageControllerRef"
    MO_CLASS_ID_STORAGE_CTRL_STORAGE_STATS = "storageCtrlStorageStats"
    MO_CLASS_ID_STORAGE_CTRL_STORAGE_STATS_HIST = "storageCtrlStorageStatsHist"
    MO_CLASS_ID_STORAGE_DEVICE = "storageDevice"
    MO_CLASS_ID_STORAGE_DISK_ENV_STATS = "storageDiskEnvStats"
    MO_CLASS_ID_STORAGE_DISK_ENV_STATS_HIST = "storageDiskEnvStatsHist"
    MO_CLASS_ID_STORAGE_DISK_EP = "storageDiskEp"
    MO_CLASS_ID_STORAGE_DISK_GROUP = "storageDiskGroup"
    MO_CLASS_ID_STORAGE_EMBEDDED_STORAGE = "storageEmbeddedStorage"
    MO_CLASS_ID_STORAGE_ENCLOSURE = "storageEnclosure"
    MO_CLASS_ID_STORAGE_ENCLOSURE_DISK_SLOT_EP = "storageEnclosureDiskSlotEp"
    MO_CLASS_ID_STORAGE_ENCLOSURE_LOCAL_DISK_CONFIG = "storageEnclosureLocalDiskConfig"
    MO_CLASS_ID_STORAGE_EP = "storageEp"
    MO_CLASS_ID_STORAGE_EP_USER = "storageEpUser"
    MO_CLASS_ID_STORAGE_ETH_LIF = "storageEthLif"
    MO_CLASS_ID_STORAGE_ETHER_IF = "storageEtherIf"
    MO_CLASS_ID_STORAGE_FC_IF = "storageFcIf"
    MO_CLASS_ID_STORAGE_FC_TARGET_EP = "storageFcTargetEp"
    MO_CLASS_ID_STORAGE_FC_TARGET_IF = "storageFcTargetIf"
    MO_CLASS_ID_STORAGE_FLEX_FLASH_CARD = "storageFlexFlashCard"
    MO_CLASS_ID_STORAGE_FLEX_FLASH_CONTROLLER = "storageFlexFlashController"
    MO_CLASS_ID_STORAGE_FLEX_FLASH_CONTROLLER_OPERATION = "storageFlexFlashControllerOperation"
    MO_CLASS_ID_STORAGE_FLEX_FLASH_DRIVE = "storageFlexFlashDrive"
    MO_CLASS_ID_STORAGE_FLEX_FLASH_VIRTUAL_DRIVE = "storageFlexFlashVirtualDrive"
    MO_CLASS_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATS = "storageHddMotherBoardTempStats"
    MO_CLASS_ID_STORAGE_HDD_MOTHER_BOARD_TEMP_STATS_HIST = "storageHddMotherBoardTempStatsHist"
    MO_CLASS_ID_STORAGE_ISCSI_INITIATOR_EP = "storageIScsiInitiatorEp"
    MO_CLASS_ID_STORAGE_ISCSI_TARGET_IF = "storageIScsiTargetIf"
    MO_CLASS_ID_STORAGE_INI_GROUP = "storageIniGroup"
    MO_CLASS_ID_STORAGE_INITIATOR = "storageInitiator"
    MO_CLASS_ID_STORAGE_INITIATOR_REF = "storageInitiatorRef"
    MO_CLASS_ID_STORAGE_IP_V4_POOLED_ADDR = "storageIpV4PooledAddr"
    MO_CLASS_ID_STORAGE_IP_V4_STATIC_ADDR = "storageIpV4StaticAddr"
    MO_CLASS_ID_STORAGE_ITEM = "storageItem"
    MO_CLASS_ID_STORAGE_L2_IF = "storageL2If"
    MO_CLASS_ID_STORAGE_LOCAL_DISK = "storageLocalDisk"
    MO_CLASS_ID_STORAGE_LOCAL_DISK_BASE = "storageLocalDiskBase"
    MO_CLASS_ID_STORAGE_LOCAL_DISK_CONFIG = "storageLocalDiskConfig"
    MO_CLASS_ID_STORAGE_LOCAL_DISK_CONFIG_DEF = "storageLocalDiskConfigDef"
    MO_CLASS_ID_STORAGE_LOCAL_DISK_CONFIG_POLICY = "storageLocalDiskConfigPolicy"
    MO_CLASS_ID_STORAGE_LOCAL_DISK_EP = "storageLocalDiskEp"
    MO_CLASS_ID_STORAGE_LOCAL_DISK_OPERATION = "storageLocalDiskOperation"
    MO_CLASS_ID_STORAGE_LOCAL_DISK_PARTITION = "storageLocalDiskPartition"
    MO_CLASS_ID_STORAGE_LOCAL_LUN = "storageLocalLun"
    MO_CLASS_ID_STORAGE_LOGICAL = "storageLogical"
    MO_CLASS_ID_STORAGE_LUN_COUNTERS = "storageLunCounters"
    MO_CLASS_ID_STORAGE_LUN_DISK = "storageLunDisk"
    MO_CLASS_ID_STORAGE_LUN_MASK_GROUP = "storageLunMaskGroup"
    MO_CLASS_ID_STORAGE_LUN_REPLICA = "storageLunReplica"
    MO_CLASS_ID_STORAGE_LUN_RESOURCE_SELECTION_LOG = "storageLunResourceSelectionLog"
    MO_CLASS_ID_STORAGE_LUN_SNAPSHOT = "storageLunSnapshot"
    MO_CLASS_ID_STORAGE_META = "storageMeta"
    MO_CLASS_ID_STORAGE_MEZZ_FLASH_LIFE = "storageMezzFlashLife"
    MO_CLASS_ID_STORAGE_NODE_EP = "storageNodeEp"
    MO_CLASS_ID_STORAGE_NVME_STATS = "storageNvmeStats"
    MO_CLASS_ID_STORAGE_NVME_STATS_HIST = "storageNvmeStatsHist"
    MO_CLASS_ID_STORAGE_NVME_STORAGE = "storageNvmeStorage"
    MO_CLASS_ID_STORAGE_ONBOARD_DEVICE = "storageOnboardDevice"
    MO_CLASS_ID_STORAGE_OPERATION = "storageOperation"
    MO_CLASS_ID_STORAGE_PARTITION = "storagePartition"
    MO_CLASS_ID_STORAGE_PHYSICAL = "storagePhysical"
    MO_CLASS_ID_STORAGE_PROCESSOR = "storageProcessor"
    MO_CLASS_ID_STORAGE_PROCESSOR_EP = "storageProcessorEp"
    MO_CLASS_ID_STORAGE_PROCESSOR_RUNTIME = "storageProcessorRuntime"
    MO_CLASS_ID_STORAGE_QUAL = "storageQual"
    MO_CLASS_ID_STORAGE_RAID_BATTERY = "storageRaidBattery"
    MO_CLASS_ID_STORAGE_REPLICATION_CTX = "storageReplicationCtx"
    MO_CLASS_ID_STORAGE_SAS_EXPANDER = "storageSasExpander"
    MO_CLASS_ID_STORAGE_SAS_PHY_LINK = "storageSasPhyLink"
    MO_CLASS_ID_STORAGE_SAS_PORT = "storageSasPort"
    MO_CLASS_ID_STORAGE_SAS_UP_LINK = "storageSasUpLink"
    MO_CLASS_ID_STORAGE_SCSI_DEVICE_DESCRIPTOR = "storageScsiDeviceDescriptor"
    MO_CLASS_ID_STORAGE_SCSI_LUN = "storageScsiLun"
    MO_CLASS_ID_STORAGE_SCSI_LUN_CTX = "storageScsiLunCtx"
    MO_CLASS_ID_STORAGE_SCSI_LUN_INST_REF = "storageScsiLunInstRef"
    MO_CLASS_ID_STORAGE_SCSI_LUN_MASK = "storageScsiLunMask"
    MO_CLASS_ID_STORAGE_SCSI_LUN_REF = "storageScsiLunRef"
    MO_CLASS_ID_STORAGE_SNAPSHOT = "storageSnapshot"
    MO_CLASS_ID_STORAGE_SNAPSHOT_CTX = "storageSnapshotCtx"
    MO_CLASS_ID_STORAGE_SSD_HEALTH_STATS = "storageSsdHealthStats"
    MO_CLASS_ID_STORAGE_SSD_HEALTH_STATS_HIST = "storageSsdHealthStatsHist"
    MO_CLASS_ID_STORAGE_STORAGE_STATS = "storageStorageStats"
    MO_CLASS_ID_STORAGE_STORAGE_STATS_HIST = "storageStorageStatsHist"
    MO_CLASS_ID_STORAGE_SYSTEM = "storageSystem"
    MO_CLASS_ID_STORAGE_TARGET = "storageTarget"
    MO_CLASS_ID_STORAGE_TARGET_IF = "storageTargetIf"
    MO_CLASS_ID_STORAGE_TRANSPORT_IF = "storageTransportIf"
    MO_CLASS_ID_STORAGE_TRANSPORTABLE_FLASH_MODULE = "storageTransportableFlashModule"
    MO_CLASS_ID_STORAGE_UNIT = "storageUnit"
    MO_CLASS_ID_STORAGE_USAGE_COUNTERS = "storageUsageCounters"
    MO_CLASS_ID_STORAGE_VDMEMBER_EP = "storageVDMemberEp"
    MO_CLASS_ID_STORAGE_VIRTUAL_DRIVE = "storageVirtualDrive"
    MO_CLASS_ID_STORAGE_VIRTUAL_DRIVE_CONTAINER = "storageVirtualDriveContainer"
    MO_CLASS_ID_STORAGE_VIRTUAL_DRIVE_EP = "storageVirtualDriveEp"
    MO_CLASS_ID_STORAGE_VIRTUAL_DRIVE_OPERATION = "storageVirtualDriveOperation"
    MO_CLASS_ID_STORAGE_VIRTUAL_DRIVE_REF = "storageVirtualDriveRef"
    MO_CLASS_ID_STORAGE_VIRTUAL_DRIVE_REF_OPERATION = "storageVirtualDriveRefOperation"
    MO_CLASS_ID_STORAGE_VOLUME = "storageVolume"
    MO_CLASS_ID_STORAGE_VSAN_REF = "storageVsanRef"
    MO_CLASS_ID_STORAGE_VSAN_REF_IVT = "storageVsanRefIvt"
    MO_CLASS_ID_SW_CARD_ENV_STATS = "swCardEnvStats"
    MO_CLASS_ID_SW_CARD_ENV_STATS_HIST = "swCardEnvStatsHist"
    MO_CLASS_ID_SW_ENV_STATS = "swEnvStats"
    MO_CLASS_ID_SW_ENV_STATS_HIST = "swEnvStatsHist"
    MO_CLASS_ID_SW_MON = "swMon"
    MO_CLASS_ID_SW_SYSTEM_STATS = "swSystemStats"
    MO_CLASS_ID_SW_SYSTEM_STATS_HIST = "swSystemStatsHist"
    MO_CLASS_ID_SW_VLAN = "swVlan"
    MO_CLASS_ID_SW_VLAN_GROUP = "swVlanGroup"
    MO_CLASS_ID_SYNTHETIC_DIRECTORY = "syntheticDirectory"
    MO_CLASS_ID_SYNTHETIC_FILE = "syntheticFile"
    MO_CLASS_ID_SYNTHETIC_FILE_SYSTEM = "syntheticFileSystem"
    MO_CLASS_ID_SYNTHETIC_FS_OBJ = "syntheticFsObj"
    MO_CLASS_ID_SYNTHETIC_TIME = "syntheticTime"
    MO_CLASS_ID_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET = "sysdebugAutoCoreFileExportTarget"
    MO_CLASS_ID_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM = "sysdebugAutoCoreFileExportTargetFsm"
    MO_CLASS_ID_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM_STAGE = "sysdebugAutoCoreFileExportTargetFsmStage"
    MO_CLASS_ID_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM_TASK = "sysdebugAutoCoreFileExportTargetFsmTask"
    MO_CLASS_ID_SYSDEBUG_BACKUP_BEHAVIOR = "sysdebugBackupBehavior"
    MO_CLASS_ID_SYSDEBUG_CORE = "sysdebugCore"
    MO_CLASS_ID_SYSDEBUG_CORE_FILE_EXPORT_TARGET = "sysdebugCoreFileExportTarget"
    MO_CLASS_ID_SYSDEBUG_CORE_FILE_REPOSITORY = "sysdebugCoreFileRepository"
    MO_CLASS_ID_SYSDEBUG_DIAGNOSTIC_LOG = "sysdebugDiagnosticLog"
    MO_CLASS_ID_SYSDEBUG_EP = "sysdebugEp"
    MO_CLASS_ID_SYSDEBUG_EXPORTER = "sysdebugExporter"
    MO_CLASS_ID_SYSDEBUG_FILE = "sysdebugFile"
    MO_CLASS_ID_SYSDEBUG_LOG_BEHAVIOR = "sysdebugLogBehavior"
    MO_CLASS_ID_SYSDEBUG_LOG_CONTROL_DESTINATION_FILE = "sysdebugLogControlDestinationFile"
    MO_CLASS_ID_SYSDEBUG_LOG_CONTROL_DESTINATION_SYSLOG = "sysdebugLogControlDestinationSyslog"
    MO_CLASS_ID_SYSDEBUG_LOG_CONTROL_DOMAIN = "sysdebugLogControlDomain"
    MO_CLASS_ID_SYSDEBUG_LOG_CONTROL_EP = "sysdebugLogControlEp"
    MO_CLASS_ID_SYSDEBUG_LOG_CONTROL_EP_FSM = "sysdebugLogControlEpFsm"
    MO_CLASS_ID_SYSDEBUG_LOG_CONTROL_EP_FSM_STAGE = "sysdebugLogControlEpFsmStage"
    MO_CLASS_ID_SYSDEBUG_LOG_CONTROL_EP_FSM_TASK = "sysdebugLogControlEpFsmTask"
    MO_CLASS_ID_SYSDEBUG_LOG_CONTROL_MODULE = "sysdebugLogControlModule"
    MO_CLASS_ID_SYSDEBUG_MEP_LOG_DEF = "sysdebugMEpLogDef"
    MO_CLASS_ID_SYSDEBUG_MEP_LOG_POLICY = "sysdebugMEpLogPolicy"
    MO_CLASS_ID_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET = "sysdebugManualCoreFileExportTarget"
    MO_CLASS_ID_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM = "sysdebugManualCoreFileExportTargetFsm"
    MO_CLASS_ID_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM_STAGE = "sysdebugManualCoreFileExportTargetFsmStage"
    MO_CLASS_ID_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM_TASK = "sysdebugManualCoreFileExportTargetFsmTask"
    MO_CLASS_ID_SYSDEBUG_REPOSITORY = "sysdebugRepository"
    MO_CLASS_ID_SYSDEBUG_TECH_SUP_FILE_REPOSITORY = "sysdebugTechSupFileRepository"
    MO_CLASS_ID_SYSDEBUG_TECH_SUPPORT = "sysdebugTechSupport"
    MO_CLASS_ID_SYSDEBUG_TECH_SUPPORT_CMD_OPT = "sysdebugTechSupportCmdOpt"
    MO_CLASS_ID_SYSDEBUG_TECH_SUPPORT_FSM = "sysdebugTechSupportFsm"
    MO_CLASS_ID_SYSDEBUG_TECH_SUPPORT_FSM_STAGE = "sysdebugTechSupportFsmStage"
    MO_CLASS_ID_SYSDEBUG_TECH_SUPPORT_FSM_TASK = "sysdebugTechSupportFsmTask"
    MO_CLASS_ID_SYSDEBUG_TECH_SUPPORT_OP = "sysdebugTechSupportOp"
    MO_CLASS_ID_SYSDEBUG_TECH_SUPPORT_OPERATION = "sysdebugTechSupportOperation"
    MO_CLASS_ID_SYSFILE_DIGEST = "sysfileDigest"
    MO_CLASS_ID_SYSFILE_EP = "sysfileEp"
    MO_CLASS_ID_SYSFILE_EXPORTER = "sysfileExporter"
    MO_CLASS_ID_SYSFILE_IMPORTER = "sysfileImporter"
    MO_CLASS_ID_SYSFILE_INSTANCE = "sysfileInstance"
    MO_CLASS_ID_SYSFILE_MUTATION = "sysfileMutation"
    MO_CLASS_ID_SYSFILE_MUTATION_FSM = "sysfileMutationFsm"
    MO_CLASS_ID_SYSFILE_MUTATION_FSM_STAGE = "sysfileMutationFsmStage"
    MO_CLASS_ID_SYSFILE_MUTATION_FSM_TASK = "sysfileMutationFsmTask"
    MO_CLASS_ID_SYSFILE_REPOSITORY = "sysfileRepository"
    MO_CLASS_ID_TAG_ADEF = "tagADef"
    MO_CLASS_ID_TAG_AINSTANCE = "tagAInstance"
    MO_CLASS_ID_TAG_DEF = "tagDef"
    MO_CLASS_ID_TAG_DEF_EP = "tagDefEp"
    MO_CLASS_ID_TAG_DRIVER = "tagDriver"
    MO_CLASS_ID_TAG_INSTANCE = "tagInstance"
    MO_CLASS_ID_TAG_INSTANCE_EP = "tagInstanceEp"
    MO_CLASS_ID_TAG_INSTANCE_ITEM = "tagInstanceItem"
    MO_CLASS_ID_TAG_ITEM = "tagItem"
    MO_CLASS_ID_TAG_SOFTWARE_INST = "tagSoftwareInst"
    MO_CLASS_ID_TESTING_CLI_POLICY = "testingCliPolicy"
    MO_CLASS_ID_TESTING_SERVICE_PROFILE = "testingServiceProfile"
    MO_CLASS_ID_TESTING_SERVICE_PROFILE_FSM = "testingServiceProfileFsm"
    MO_CLASS_ID_TESTING_SERVICE_PROFILE_FSM_STAGE = "testingServiceProfileFsmStage"
    MO_CLASS_ID_TESTING_SERVICE_PROFILE_FSM_TASK = "testingServiceProfileFsmTask"
    MO_CLASS_ID_TESTING_SNMP_COMMUNITY = "testingSnmpCommunity"
    MO_CLASS_ID_TESTING_SNMP_POLICY = "testingSnmpPolicy"
    MO_CLASS_ID_TESTING_SNMP_SUPPORT = "testingSnmpSupport"
    MO_CLASS_ID_TESTING_SNMP_TRAP = "testingSnmpTrap"
    MO_CLASS_ID_TOP_INFO_SYNC_POLICY = "topInfoSyncPolicy"
    MO_CLASS_ID_TOP_META_INF = "topMetaInf"
    MO_CLASS_ID_TOP_ROOT = "topRoot"
    MO_CLASS_ID_TOP_SYSTEM = "topSystem"
    MO_CLASS_ID_TOP_SYSTEM_FSM = "topSystemFsm"
    MO_CLASS_ID_TOP_SYSTEM_FSM_STAGE = "topSystemFsmStage"
    MO_CLASS_ID_TOP_SYSTEM_FSM_TASK = "topSystemFsmTask"
    MO_CLASS_ID_TRIG_ABS_WINDOW = "trigAbsWindow"
    MO_CLASS_ID_TRIG_ACK = "trigAck"
    MO_CLASS_ID_TRIG_BASE_RECURR_WINDOW = "trigBaseRecurrWindow"
    MO_CLASS_ID_TRIG_BASE_SCHED = "trigBaseSched"
    MO_CLASS_ID_TRIG_CONF_ACK = "trigConfAck"
    MO_CLASS_ID_TRIG_INST = "trigInst"
    MO_CLASS_ID_TRIG_META = "trigMeta"
    MO_CLASS_ID_TRIG_PENDING_ACK_COUNT = "trigPendingAckCount"
    MO_CLASS_ID_TRIG_RECURR_WINDOW = "trigRecurrWindow"
    MO_CLASS_ID_TRIG_RES_ACK = "trigResAck"
    MO_CLASS_ID_TRIG_SCHED = "trigSched"
    MO_CLASS_ID_TRIG_SCHED_WINDOW = "trigSchedWindow"
    MO_CLASS_ID_TRIG_SERVER_TOKEN = "trigServerToken"
    MO_CLASS_ID_TRIG_TEST = "trigTest"
    MO_CLASS_ID_TRIG_TOKEN = "trigToken"
    MO_CLASS_ID_TRIG_TOKEN_REQUESTOR = "trigTokenRequestor"
    MO_CLASS_ID_TRIG_TRIGGERABLE = "trigTriggerable"
    MO_CLASS_ID_TRIG_TRIGGERED = "trigTriggered"
    MO_CLASS_ID_TRIG_WINDOW = "trigWindow"
    MO_CLASS_ID_UNSPECIFIED = "unspecified"
    MO_CLASS_ID_UUIDPOOL_ADDR = "uuidpoolAddr"
    MO_CLASS_ID_UUIDPOOL_BLOCK = "uuidpoolBlock"
    MO_CLASS_ID_UUIDPOOL_FORMAT = "uuidpoolFormat"
    MO_CLASS_ID_UUIDPOOL_POOL = "uuidpoolPool"
    MO_CLASS_ID_UUIDPOOL_POOLED = "uuidpoolPooled"
    MO_CLASS_ID_UUIDPOOL_UNIVERSE = "uuidpoolUniverse"
    MO_CLASS_ID_VERSION_APPLICATION = "versionApplication"
    MO_CLASS_ID_VERSION_EP = "versionEp"
    MO_CLASS_ID_VERSION_FILTER = "versionFilter"
    MO_CLASS_ID_VERSION_MATRIX = "versionMatrix"
    MO_CLASS_ID_VERSION_PRODUCT = "versionProduct"
    MO_CLASS_ID_VERSION_VERSION = "versionVersion"
    MO_CLASS_ID_VM_ADAPTOR = "vmAdaptor"
    MO_CLASS_ID_VM_NIC = "vmNic"
    MO_CLASS_ID_VNIC_ABEH = "vnicABeh"
    MO_CLASS_ID_VNIC_AETHER_IF = "vnicAEtherIf"
    MO_CLASS_ID_VNIC_AFC_IF = "vnicAFcIf"
    MO_CLASS_ID_VNIC_AGROUP = "vnicAGroup"
    MO_CLASS_ID_VNIC_BOOT_IP_POLICY = "vnicBootIpPolicy"
    MO_CLASS_ID_VNIC_BOOT_TARGET = "vnicBootTarget"
    MO_CLASS_ID_VNIC_CON_POLICY_REF = "vnicConPolicyRef"
    MO_CLASS_ID_VNIC_CON_REQ = "vnicConReq"
    MO_CLASS_ID_VNIC_CONN_DEF = "vnicConnDef"
    MO_CLASS_ID_VNIC_CONNECTION = "vnicConnection"
    MO_CLASS_ID_VNIC_DEF_BEH = "vnicDefBeh"
    MO_CLASS_ID_VNIC_DYNAMIC_CON = "vnicDynamicCon"
    MO_CLASS_ID_VNIC_DYNAMIC_CON_POLICY = "vnicDynamicConPolicy"
    MO_CLASS_ID_VNIC_DYNAMIC_CON_POLICY_REF = "vnicDynamicConPolicyRef"
    MO_CLASS_ID_VNIC_DYNAMIC_CON_REQ = "vnicDynamicConReq"
    MO_CLASS_ID_VNIC_ETH_LIF = "vnicEthLif"
    MO_CLASS_ID_VNIC_ETHER = "vnicEther"
    MO_CLASS_ID_VNIC_ETHER_BASE = "vnicEtherBase"
    MO_CLASS_ID_VNIC_ETHER_BASE_IF = "vnicEtherBaseIf"
    MO_CLASS_ID_VNIC_ETHER_IF = "vnicEtherIf"
    MO_CLASS_ID_VNIC_FAULT = "vnicFault"
    MO_CLASS_ID_VNIC_FC = "vnicFc"
    MO_CLASS_ID_VNIC_FC_BASE = "vnicFcBase"
    MO_CLASS_ID_VNIC_FC_GROUP_DEF = "vnicFcGroupDef"
    MO_CLASS_ID_VNIC_FC_GROUP_TEMPL = "vnicFcGroupTempl"
    MO_CLASS_ID_VNIC_FC_IF = "vnicFcIf"
    MO_CLASS_ID_VNIC_FC_LIF = "vnicFcLif"
    MO_CLASS_ID_VNIC_FC_NODE = "vnicFcNode"
    MO_CLASS_ID_VNIC_FC_OEIF = "vnicFcOEIf"
    MO_CLASS_ID_VNIC_IPIF = "vnicIPIf"
    MO_CLASS_ID_VNIC_IPV4_DHCP = "vnicIPv4Dhcp"
    MO_CLASS_ID_VNIC_IPV4_DNS = "vnicIPv4Dns"
    MO_CLASS_ID_VNIC_IPV4_IF = "vnicIPv4If"
    MO_CLASS_ID_VNIC_IPV4_ISCSI_ADDR = "vnicIPv4IscsiAddr"
    MO_CLASS_ID_VNIC_IPV4_POOLED_ISCSI_ADDR = "vnicIPv4PooledIscsiAddr"
    MO_CLASS_ID_VNIC_IPV4_STATIC_ROUTE = "vnicIPv4StaticRoute"
    MO_CLASS_ID_VNIC_IPV6_IF = "vnicIPv6If"
    MO_CLASS_ID_VNIC_ISCSI = "vnicIScsi"
    MO_CLASS_ID_VNIC_ISCSI_AUTO_TARGET_IF = "vnicIScsiAutoTargetIf"
    MO_CLASS_ID_VNIC_ISCSI_BASE = "vnicIScsiBase"
    MO_CLASS_ID_VNIC_ISCSI_BOOT_PARAMS = "vnicIScsiBootParams"
    MO_CLASS_ID_VNIC_ISCSI_BOOT_VNIC = "vnicIScsiBootVnic"
    MO_CLASS_ID_VNIC_ISCSI_INITIATOR_PARAMS = "vnicIScsiInitiatorParams"
    MO_CLASS_ID_VNIC_ISCSI_LCP = "vnicIScsiLCP"
    MO_CLASS_ID_VNIC_ISCSI_NODE = "vnicIScsiNode"
    MO_CLASS_ID_VNIC_ISCSI_STATIC_TARGET_IF = "vnicIScsiStaticTargetIf"
    MO_CLASS_ID_VNIC_ISCSI_TARGET_IF = "vnicIScsiTargetIf"
    MO_CLASS_ID_VNIC_ISCSI_TARGET_PARAMS = "vnicIScsiTargetParams"
    MO_CLASS_ID_VNIC_IF = "vnicIf"
    MO_CLASS_ID_VNIC_IF_ROLE = "vnicIfRole"
    MO_CLASS_ID_VNIC_INI_GRP_FC = "vnicIniGrpFc"
    MO_CLASS_ID_VNIC_INI_GRP_FC_B = "vnicIniGrpFcB"
    MO_CLASS_ID_VNIC_INI_GRP_FC_BIF = "vnicIniGrpFcBIf"
    MO_CLASS_ID_VNIC_INI_GRP_FC_BASE = "vnicIniGrpFcBase"
    MO_CLASS_ID_VNIC_INI_GRP_FC_IF = "vnicIniGrpFcIf"
    MO_CLASS_ID_VNIC_IP_ADDR = "vnicIpAddr"
    MO_CLASS_ID_VNIC_IP_V4_ADDR = "vnicIpV4Addr"
    MO_CLASS_ID_VNIC_IP_V4_ADDR_CONF = "vnicIpV4AddrConf"
    MO_CLASS_ID_VNIC_IP_V4_ADDR_EXPL_CONF = "vnicIpV4AddrExplConf"
    MO_CLASS_ID_VNIC_IP_V4_MGMT_POOLED_ADDR = "vnicIpV4MgmtPooledAddr"
    MO_CLASS_ID_VNIC_IP_V4_POOLED_ADDR = "vnicIpV4PooledAddr"
    MO_CLASS_ID_VNIC_IP_V4_PROF_DERIVED_ADDR = "vnicIpV4ProfDerivedAddr"
    MO_CLASS_ID_VNIC_IP_V4_STATIC_ADDR = "vnicIpV4StaticAddr"
    MO_CLASS_ID_VNIC_IP_V6_ADDR = "vnicIpV6Addr"
    MO_CLASS_ID_VNIC_IP_V6_ADDR_CONF = "vnicIpV6AddrConf"
    MO_CLASS_ID_VNIC_IP_V6_ADDR_EXPL_CONF = "vnicIpV6AddrExplConf"
    MO_CLASS_ID_VNIC_IP_V6_MGMT_POOLED_ADDR = "vnicIpV6MgmtPooledAddr"
    MO_CLASS_ID_VNIC_IP_V6_STATIC_ADDR = "vnicIpV6StaticAddr"
    MO_CLASS_ID_VNIC_L2_IF = "vnicL2If"
    MO_CLASS_ID_VNIC_L2_LIF = "vnicL2Lif"
    MO_CLASS_ID_VNIC_L3_IF = "vnicL3If"
    MO_CLASS_ID_VNIC_LAN_CONN_POLICY = "vnicLanConnPolicy"
    MO_CLASS_ID_VNIC_LAN_CONN_TEMPL = "vnicLanConnTempl"
    MO_CLASS_ID_VNIC_LIF_VLAN = "vnicLifVlan"
    MO_CLASS_ID_VNIC_LIF_VSAN = "vnicLifVsan"
    MO_CLASS_ID_VNIC_LSTORAGE_ISCSI = "vnicLstorageIScsi"
    MO_CLASS_ID_VNIC_LUN = "vnicLun"
    MO_CLASS_ID_VNIC_MGMT = "vnicMgmt"
    MO_CLASS_ID_VNIC_MGMT_BASE = "vnicMgmtBase"
    MO_CLASS_ID_VNIC_MGMT_IF = "vnicMgmtIf"
    MO_CLASS_ID_VNIC_MON_SES_FC = "vnicMonSesFc"
    MO_CLASS_ID_VNIC_MON_SES_FC_BASE = "vnicMonSesFcBase"
    MO_CLASS_ID_VNIC_MON_SES_FC_IF = "vnicMonSesFcIf"
    MO_CLASS_ID_VNIC_NET_GROUP = "vnicNetGroup"
    MO_CLASS_ID_VNIC_NET_GROUP_REF = "vnicNetGroupRef"
    MO_CLASS_ID_VNIC_NIC_CONN = "vnicNicConn"
    MO_CLASS_ID_VNIC_OUTBAND_MGMT_EP = "vnicOutbandMgmtEp"
    MO_CLASS_ID_VNIC_OUTBAND_MGMT_EP_FSM = "vnicOutbandMgmtEpFsm"
    MO_CLASS_ID_VNIC_OUTBAND_MGMT_EP_FSM_STAGE = "vnicOutbandMgmtEpFsmStage"
    MO_CLASS_ID_VNIC_OUTBAND_MGMT_EP_FSM_TASK = "vnicOutbandMgmtEpFsmTask"
    MO_CLASS_ID_VNIC_PROFILE_SET = "vnicProfileSet"
    MO_CLASS_ID_VNIC_RACK_SERVER_DISCOVERY_PROFILE = "vnicRackServerDiscoveryProfile"
    MO_CLASS_ID_VNIC_SAN_CONN_POLICY = "vnicSanConnPolicy"
    MO_CLASS_ID_VNIC_SAN_CONN_TEMPL = "vnicSanConnTempl"
    MO_CLASS_ID_VNIC_STORAGE_ETH_LIF = "vnicStorageEthLif"
    MO_CLASS_ID_VNIC_STORAGE_LIF = "vnicStorageLif"
    MO_CLASS_ID_VNIC_TEMPL = "vnicTempl"
    MO_CLASS_ID_VNIC_USNIC_CON_POLICY = "vnicUsnicConPolicy"
    MO_CLASS_ID_VNIC_USNIC_CON_POLICY_REF = "vnicUsnicConPolicyRef"
    MO_CLASS_ID_VNIC_USNIC_CON_REQ = "vnicUsnicConReq"
    MO_CLASS_ID_VNIC_VHBA_BEH_POLICY = "vnicVhbaBehPolicy"
    MO_CLASS_ID_VNIC_VLAN = "vnicVlan"
    MO_CLASS_ID_VNIC_VMQ_CON_POLICY = "vnicVmqConPolicy"
    MO_CLASS_ID_VNIC_VMQ_CON_POLICY_REF = "vnicVmqConPolicyRef"
    MO_CLASS_ID_VNIC_VMQ_CON_REQ = "vnicVmqConReq"
    MO_CLASS_ID_VNIC_VNIC = "vnicVnic"
    MO_CLASS_ID_VNIC_VNIC_BEH_POLICY = "vnicVnicBehPolicy"
    OPER_CODE_CREATE = "create"
    OPER_CODE_DELETE = "delete"


class DupeScope(ManagedObject):
    """This is DupeScope class."""

    consts = DupeScopeConsts()
    naming_props = set([u'id'])

    mo_meta = MoMeta("DupeScope", "dupeScope", "scope-[id]", VersionMeta.Version131a, "InputOutput", 0x7f, [], ["admin"], [u'dupeScopeEp'], [u'dupeExtRequestor', u'dupeIntRequestor', u'dupeScopeResult'], [None])

    prop_meta = {
        "child_action": MoPropertyMeta("child_action", "childAction", "string", VersionMeta.Version131a, MoPropertyMeta.INTERNAL, None, None, None, r"""((deleteAll|ignore|deleteNonPresent),){0,2}(deleteAll|ignore|deleteNonPresent){0,1}""", [], []), 
        "client_mo_dn": MoPropertyMeta("client_mo_dn", "clientMoDn", "string", VersionMeta.Version131a, MoPropertyMeta.READ_ONLY, None, 0, 256, None, [], []), 
        "dn": MoPropertyMeta("dn", "dn", "string", VersionMeta.Version131a, MoPropertyMeta.READ_ONLY, 0x2, 0, 256, None, [], []), 
        "id": MoPropertyMeta("id", "id", "uint", VersionMeta.Version131a, MoPropertyMeta.NAMING, 0x4, None, None, None, [], []), 
        "is_system": MoPropertyMeta("is_system", "isSystem", "string", VersionMeta.Version131a, MoPropertyMeta.READ_ONLY, None, None, None, None, ["false", "no", "true", "yes"], []), 
        "mo_class_id": MoPropertyMeta("mo_class_id", "moClassId", "string", VersionMeta.Version131a, MoPropertyMeta.READ_ONLY, None, None, None, None, ["aaaAuthMethod", "aaaAuthRealm", "aaaAuthRealmFsm", "aaaAuthRealmFsmStage", "aaaConfig", "aaaConsoleAuth", "aaaDefaultAuth", "aaaDefinition", "aaaDomain", "aaaDomainAuth", "aaaDomainGroup", "aaaEp", "aaaEpAuthProfile", "aaaEpFsm", "aaaEpFsmStage", "aaaEpFsmTask", "aaaEpLogin", "aaaEpUser", "aaaExtMgmtCutThruTkn", "aaaItem", "aaaLdapEp", "aaaLdapEpFsm", "aaaLdapEpFsmStage", "aaaLdapGroup", "aaaLdapGroupRule", "aaaLdapProvider", "aaaLocale", "aaaLog", "aaaModLR", "aaaOrg", "aaaProvider", "aaaProviderGroup", "aaaProviderRef", "aaaPwdProfile", "aaaRadiusEp", "aaaRadiusEpFsm", "aaaRadiusEpFsmStage", "aaaRadiusProvider", "aaaRealm", "aaaRealmFsm", "aaaRealmFsmStage", "aaaRealmFsmTask", "aaaRemoteUser", "aaaRole", "aaaSession", "aaaSessionLR", "aaaShellLogin", "aaaSshAuth", "aaaSystemUser", "aaaTacacsPlusEp", "aaaTacacsPlusEpFsm", "aaaTacacsPlusEpFsmStage", "aaaTacacsPlusProvider", "aaaUser", "aaaUserAction", "aaaUserData", "aaaUserEp", "aaaUserEpFsm", "aaaUserEpFsmStage", "aaaUserEpFsmTask", "aaaUserGroup", "aaaUserLocale", "aaaUserLogin", "aaaUserPreferences", "aaaUserRole", "aaaWebLogin", "adaptorBehCap", "adaptorCapDef", "adaptorCapQual", "adaptorCapSpec", "adaptorEthAdvFilterProfile", "adaptorEthArfsProfile", "adaptorEthCompQueueProfile", "adaptorEthFailoverProfile", "adaptorEthGENEVEProfile", "adaptorEthInterruptProfile", "adaptorEthInterruptScalingProfile", "adaptorEthNVGREProfile", "adaptorEthOffloadProfile", "adaptorEthPortBySizeLargeStats", "adaptorEthPortBySizeLargeStatsHist", "adaptorEthPortBySizeSmallStats", "adaptorEthPortBySizeSmallStatsHist", "adaptorEthPortErrStats", "adaptorEthPortErrStatsHist", "adaptorEthPortMcastStats", "adaptorEthPortMcastStatsHist", "adaptorEthPortOutsizedStats", "adaptorEthPortOutsizedStatsHist", "adaptorEthPortStats", "adaptorEthPortStatsHist", "adaptorEthQueueProfile", "adaptorEthRecvQueueProfile", "adaptorEthRoCEProfile", "adaptorEthVxLANProfile", "adaptorEthWorkQueueProfile", "adaptorEtherIfStats", "adaptorEtherIfStatsHist", "adaptorExtEthIf", "adaptorExtEthIfOperation", "adaptorExtIf", "adaptorExtIpV6RssHashProfile", "adaptorFcCdbWorkQueueProfile", "adaptorFcErrorRecoveryProfile", "adaptorFcFnicProfile", "adaptorFcIfEventStats", "adaptorFcIfEventStatsHist", "adaptorFcIfFC4Stats", "adaptorFcIfFC4StatsHist", "adaptorFcIfFrameStats", "adaptorFcIfFrameStatsHist", "adaptorFcInterruptProfile", "adaptorFcLogiProfile", "adaptorFcPortFLogiProfile", "adaptorFcPortPLogiProfile", "adaptorFcPortProfile", "adaptorFcPortStats", "adaptorFcPortStatsHist", "adaptorFcQueueProfile", "adaptorFcRecvQueueProfile", "adaptorFcWorkQueueProfile", "adaptorFruCapProvider", "adaptorHBAVnicStats", "adaptorHBAVnicStatsHist", "adaptorHostEthIf", "adaptorHostEthIfOperation", "adaptorHostEthIfProfile", "adaptorHostFcIf", "adaptorHostFcIfOperation", "adaptorHostFcIfProfile", "adaptorHostIf", "adaptorHostIfConfig", "adaptorHostIfConnDef", "adaptorHostIfProfile", "adaptorHostIscsiIf", "adaptorHostIscsiIfOperation", "adaptorHostIscsiIfProfile", "adaptorHostScsiIf", "adaptorHostScsiLunRef", "adaptorHwAddrCap", "adaptorIScsiCap", "adaptorIpV4RssHashProfile", "adaptorIpV6RssHashProfile", "adaptorMenloBaseErrorStats", "adaptorMenloBaseErrorStatsHist", "adaptorMenloDcePortStats", "adaptorMenloDcePortStatsHist", "adaptorMenloEthErrorStats", "adaptorMenloEthErrorStatsHist", "adaptorMenloEthStats", "adaptorMenloEthStatsHist", "adaptorMenloFcErrorStats", "adaptorMenloFcErrorStatsHist", "adaptorMenloFcStats", "adaptorMenloFcStatsHist", "adaptorMenloHostPortStats", "adaptorMenloHostPortStatsHist", "adaptorMenloMcpuErrorStats", "adaptorMenloMcpuErrorStatsHist", "adaptorMenloMcpuStats", "adaptorMenloMcpuStatsHist", "adaptorMenloNetEgStats", "adaptorMenloNetEgStatsHist", "adaptorMenloNetInStats", "adaptorMenloNetInStatsHist", "adaptorMenloQErrorStats", "adaptorMenloQErrorStatsHist", "adaptorMenloQStats", "adaptorMenloQStatsHist", "adaptorNICVnicStats", "adaptorNICVnicStatsHist", "adaptorProfileItem", "adaptorProtocolProfile", "adaptorQual", "adaptorQueueProfile", "adaptorRnicCapSpec", "adaptorRssHashProfile", "adaptorRssProfile", "adaptorTcpIpRssHashProfile", "adaptorUnit", "adaptorUnitAssocCtx", "adaptorUnitExtn", "adaptorUsnicConnDef", "adaptorVlan", "adaptorVmmqConnDef", "adaptorVnicStats", "adaptorVnicStatsHist", "biosBOT", "biosBootDev", "biosBootDevGrp", "biosTokenFeatureGroup", "biosTokenParam", "biosTokenSettings", "biosUnit", "biosVFeat", "biosVProfile", "biosVfACPI10Support", "biosVfASPMSupport", "biosVfAllUSBDevices", "biosVfAltitude", "biosVfAssertNMIOnPERR", "biosVfAssertNMIOnSERR", "biosVfBootOptionRetry", "biosVfCPUHardwarePowerManagement", "biosVfCPUPerformance", "biosVfCPUPowerManagement", "biosVfConsistentDeviceNameControl", "biosVfConsoleRedirection", "biosVfCoreMultiProcessing", "biosVfDDR3VoltageSelection", "biosVfDRAMClockThrottling", "biosVfDirectCacheAccess", "biosVfDramRefreshRate", "biosVfEnergyPerformanceTuning", "biosVfEnhancedIntelSpeedStepTech", "biosVfEnhancedPowerCappingSupport", "biosVfExecuteDisableBit", "biosVfFRB2Timer", "biosVfFrequencyFloorOverride", "biosVfFrontPanelLockout", "biosVfIOEMezz1OptionROM", "biosVfIOENVMe1OptionROM", "biosVfIOENVMe2OptionROM", "biosVfIOESlot1OptionROM", "biosVfIOESlot2OptionROM", "biosVfIntegratedGraphics", "biosVfIntegratedGraphicsApertureSize", "biosVfIntelEntrySASRAIDModule", "biosVfIntelHyperThreadingTech", "biosVfIntelTrustedExecutionTechnology", "biosVfIntelTurboBoostTech", "biosVfIntelVTForDirectedIO", "biosVfIntelVirtualizationTechnology", "biosVfInterleaveConfiguration", "biosVfLocalX2Apic", "biosVfLvDIMMSupport", "biosVfMaxVariableMTRRSetting", "biosVfMaximumMemoryBelow4GB", "biosVfMemoryMappedIOAbove4GB", "biosVfMirroringMode", "biosVfNUMAOptimized", "biosVfOSBootWatchdogTimer", "biosVfOSBootWatchdogTimerPolicy", "biosVfOSBootWatchdogTimerTimeout", "biosVfOnboardGraphics", "biosVfOnboardSATAController", "biosVfOnboardStorage", "biosVfOptionROMEnable", "biosVfOptionROMLoad", "biosVfOutOfBandManagement", "biosVfPCHSATAMode", "biosVfPCILOMPortsConfiguration", "biosVfPCIROMCLP", "biosVfPCISlotLinkSpeed", "biosVfPCISlotOptionROMEnable", "biosVfPOSTErrorPause", "biosVfPSTATECoordination", "biosVfPackageCStateLimit", "biosVfProcessorC1E", "biosVfProcessorC3Report", "biosVfProcessorC6Report", "biosVfProcessorC7Report", "biosVfProcessorCMCI", "biosVfProcessorCState", "biosVfProcessorEnergyConfiguration", "biosVfProcessorPrefetchConfig", "biosVfQPILinkFrequencySelect", "biosVfQPISnoopMode", "biosVfQuietBoot", "biosVfRedirectionAfterBIOSPOST", "biosVfResumeOnACPowerLoss", "biosVfSBMezz1OptionROM", "biosVfSBNVMe1OptionROM", "biosVfSIOC1OptionROM", "biosVfSIOC2OptionROM", "biosVfScrubPolicies", "biosVfSelectMemoryRASConfiguration", "biosVfSerialPortAEnable", "biosVfSparingMode", "biosVfSriovConfig", "biosVfTPMPendingOperation", "biosVfTPMSupport", "biosVfTrustedPlatformModule", "biosVfUCSMBootModeControl", "biosVfUCSMBootOrderRuleControl", "biosVfUEFIOSUseLegacyVideo", "biosVfUSBBootConfig", "biosVfUSBConfiguration", "biosVfUSBFrontPanelAccessLock", "biosVfUSBPortConfiguration", "biosVfUSBSystemIdlePowerOptimizingSetting", "biosVfVGAPriority", "biosVfWorkloadConfiguration", "callhomeDest", "callhomeEp", "callhomeFaultInst", "callhomeHolder", "callhomeHolderFsm", "callhomeHolderFsmStage", "callhomeHolderFsmTask", "callhomeHttp", "callhomeItem", "callhomePeriodicSystemInventory", "callhomePolicy", "callhomeProfile", "callhomeSmtp", "callhomeSource", "callhomeTestAlert", "capabilityCatalogue", "capabilityDef", "capabilityItem", "capabilityProvider", "certRepairEp", "certRepairEpFsm", "certRepairEpFsmStage", "certRepairEpFsmTask", "changeChangedObjectRef", "changeEp", "changeEpFsm", "changeEpFsmStage", "changeEpFsmTask", "cimcvmediaActualMountEntry", "cimcvmediaActualMountList", "cimcvmediaConfigMountEntry", "cimcvmediaExtMgmtRuleEntry", "cimcvmediaItem", "cimcvmediaMountConfig", "cimcvmediaMountConfigDef", "cimcvmediaMountConfigPolicy", "cimcvmediaMountInfo", "clitestTypeTest", "clitestTypeTest2", "clitestTypeTestChild", "clitestTypeTestParent", "commCimxml", "commClient", "commClientItem", "commCoreFile", "commDateTime", "commDateTimeFsm", "commDateTimeFsmStage", "commDateTimeFsmTask", "commDefinition", "commDns", "commDnsProvider", "commEvtChannel", "commHttp", "commHttps", "commItem", "commLocale", "commLogComponent", "commNtp", "commNtpProvider", "commShell", "commShellSvcLimits", "commSmashCLP", "commSnmp", "commSnmpCommunity", "commSnmpTrap", "commSnmpTrapData", "commSnmpUser", "commSsh", "commSvc", "commSvcChannel", "commSvcEp", "commSvcEpFsm", "commSvcEpFsmStage", "commSvcEpFsmTask", "commSvcLimits", "commSvcPolicy", "commSyslog", "commSyslogClient", "commSyslogConsole", "commSyslogFile", "commSyslogMonitor", "commSyslogSource", "commTelnet", "commWeb", "commWebChannel", "commWebSvcLimits", "commWsman", "commXmlClConnPolicy", "computeABoard", "computeAChassisDiscPolicy", "computeAOperation", "computeAutoconfigPolicy", "computeBaseSystem", "computeBlade", "computeBladeDiscPolicy", "computeBladeEp", "computeBladeInheritPolicy", "computeBladePosQual", "computeBoard", "computeBoardConnector", "computeBoardController", "computeCartridge", "computeCartridgeOperation", "computeChassisConnPolicy", "computeChassisConnPolicyOperation", "computeChassisDiscPolicy", "computeChassisFeatMask", "computeChassisQual", "computeComputeDiscPolicy", "computeConfigPolicy", "computeContainer", "computeDefinition", "computeDiscPolicy", "computeDomainGroupQual", "computeDomainHwChangeDiscPolicy", "computeDomainNameQual", "computeDomainPortDiscPolicy", "computeDomainQual", "computeEnvFeatMask", "computeExtBoard", "computeFabricEthMonSrcEp", "computeFabricEthMonSrcEpCont", "computeFabricFcMonSrcEp", "computeFabricFcMonSrcEpCont", "computeFabricMonSrcEp", "computeFactoryResetOp", "computeFactoryResetOperation", "computeFaultUpgradeFlag", "computeFeatMask", "computeGraphicsCardPolicy", "computeGroupMembership", "computeGroupMembershipRef", "computeHwChangeDiscPolicy", "computeIOHub", "computeIOHubEnvStats", "computeIOHubEnvStatsHist", "computeInitConfigPolicy", "computeInstance", "computeInstanceIdQual", "computeInstanceMapping", "computeItem", "computeLocalTemplDef", "computeLogical", "computeMbPowerStats", "computeMbPowerStatsHist", "computeMbTempStats", "computeMbTempStatsHist", "computeNetworkFeatMask", "computeOwnerQual", "computePCIeFatalCompletionStats", "computePCIeFatalCompletionStatsHist", "computePCIeFatalProtocolStats", "computePCIeFatalProtocolStatsHist", "computePCIeFatalReceiveStats", "computePCIeFatalReceiveStatsHist", "computePCIeFatalStats", "computePCIeFatalStatsHist", "computePhysical", "computePhysicalAssocCtx", "computePhysicalExtension", "computePhysicalOperation", "computePhysicalQual", "computePlaceable", "computePlaced", "computePool", "computePoolPolicyRef", "computePoolable", "computePooled", "computePooledEnclosureComputeSlot", "computePooledPhysical", "computePooledRackUnit", "computePooledSlot", "computePoolingPolicy", "computePortDiscPolicy", "computePowerSyncDef", "computePowerSyncPolicy", "computeProductFamilyQual", "computeProfile", "computePsuDef", "computePsuPolicy", "computeQual", "computeQualBase", "computeQualItem", "computeQualifiedPolicy", "computeRackPosQual", "computeRackQual", "computeRackUnit", "computeRackUnitMbTempStats", "computeRackUnitMbTempStatsHist", "computeRebootLog", "computeRemoteOpStatus", "computeRequirement", "computeResourceAggrEp", "computeResourceSet", "computeResourceSetManager", "computeResourceSetMember", "computeScrubPolicy", "computeServer", "computeServerDiscPolicy", "computeServerFeatMask", "computeServerMgmtPolicy", "computeServerUnit", "computeSession", "computeSiteQual", "computeSlotEntity", "computeSlotQual", "computeStorageFeatMask", "computeSystem", "computeSystemAddrQual", "computeSystemFsm", "computeSystemFsmStage", "computeSystemFsmTask", "computeSystemQual", "computeTemplate", "computeTemplateMapping", "computeUser", "computeUserEp", "conditionImmutable", "conditionInfo", "conditionLog", "conditionLoggable", "conditionMultiInstanceImmutable", "conditionMutable", "conditionPolicy", "conditionReportable", "configAbsDbConfig", "configAckItem", "configAdaptorItem", "configAppImpactResponse", "configBackup", "configBackupFsm", "configBackupFsmStage", "configBackupFsmTask", "configCartridgeFilter", "configCartridgeItem", "configCatalogue", "configChassisFilter", "configChassisItem", "configComponentsFilter", "configConsumerCatalogue", "configConsumerCatalogueFsm", "configConsumerCatalogueFsmStage", "configConsumerCatalogueFsmTask", "configControllerItem", "configCpuInfo", "configCpuItem", "configCryptoCardItem", "configDbConfig", "configDomainFilter", "configDomainItem", "configFabricInterconnectFilter", "configFabricInterconnectItem", "configFanItem", "configFexFilter", "configFexItem", "configFilterGroup", "configFilterItem", "configFsm", "configFsmStage", "configGraphicsCardItem", "configIOMItem", "configImpact", "configImpactAnalyzer", "configImpactAnalyzerEp", "configImpactResponse", "configInputConfig", "configInputConfigSet", "configLocalDiskItem", "configLunItem", "configManagedEpImpactResponse", "configMemoryItem", "configMotherboardItem", "configNetRefItem", "configOrgItem", "configPSUItem", "configPolicyUsageItem", "configPortItem", "configSearchOptions", "configSearchResult", "configServerFilter", "configServerItem", "configServiceProfileFilter", "configSorter", "configSpotLightItem", "configStorageArrayProfileFilter", "configStorageBladeFilter", "configStorageItem", "configUCImpact", "consumerInst", "consumerInstFsm", "consumerInstFsmStage", "consumerInstFsmTask", "consumerUniverse", "controllerEp", "controllerEpFsm", "controllerEpFsmStage", "controllerEpFsmTask", "cpmaintAck", "cpmaintMaintPolicy", "dcxVIf", "dcxVc", "diagCtrl", "diagLogEp", "diagMemoryTest", "diagRslt", "diagRunPolicy", "diagSrvCapProvider", "diagSrvCtrl", "diagSrvCtrlOperation", "diagSrvCtrlOperationFsm", "diagSrvCtrlOperationFsmStage", "diagSrvCtrlOperationFsmTask", "diagTest", "domainChassisFeature", "domainChassisParam", "domainChassisProfileItem", "domainEnvironmentFeature", "domainEnvironmentParam", "domainEp", "domainFamilyCapProvider", "domainFeature", "domainFeatureCatalog", "domainNetworkFeature", "domainNetworkParam", "domainParameter", "domainProfile", "domainProfileFsm", "domainProfileFsmStage", "domainProfileFsmTask", "domainServerFeature", "domainServerParam", "domainServiceProfileItem", "domainStorageFeature", "domainStorageParam", "dpsecMac", "dupeChangeTracker", "dupeChangeTrackerEp", "dupeChangeTrackerEpFsm", "dupeChangeTrackerEpFsmStage", "dupeChangeTrackerEpFsmTask", "dupeEp", "dupeExtRequestor", "dupeIntRequestor", "dupeRequestor", "dupeScope", "dupeScopeEp", "dupeScopeResult", "epqosDefinition", "epqosEgress", "epqosItem", "equipmentABehCap", "equipmentAdvancedBootOrder", "equipmentAssocCtx", "equipmentBeaconLed", "equipmentBehCap", "equipmentBinding", "equipmentBladeCapProvider", "equipmentBreakoutCap", "equipmentCPMeta", "equipmentCard", "equipmentCartridgeCapProvider", "equipmentChassis", "equipmentChassisAssocCtx", "equipmentChassisCapProvider", "equipmentChassisIssues", "equipmentChassisOperation", "equipmentChassisPosQual", "equipmentChassisProfile", "equipmentChassisProfileAssocCtx", "equipmentChassisProfileBinding", "equipmentChassisProfileFsm", "equipmentChassisProfileFsmStage", "equipmentChassisProfileFsmTask", "equipmentChassisQual", "equipmentChassisRequirement", "equipmentChassisStats", "equipmentChassisStatsHist", "equipmentCimcVmedia", "equipmentComputeConn", "equipmentComputeConnPolicy", "equipmentComputePhysicalCapProvider", "equipmentDefinition", "equipmentDriveSecCap", "equipmentFan", "equipmentFanModule", "equipmentFanModuleCapProvider", "equipmentFanModuleStats", "equipmentFanModuleStatsHist", "equipmentFanStats", "equipmentFanStatsHist", "equipmentFex", "equipmentFexCapProvider", "equipmentFexEnvStats", "equipmentFexEnvStatsHist", "equipmentFexOperation", "equipmentFexPowerSummary", "equipmentFexPowerSummaryHist", "equipmentFexPsuInputStats", "equipmentFexPsuInputStatsHist", "equipmentFruCapProvider", "equipmentFruVariant", "equipmentGemCapProvider", "equipmentHealthLed", "equipmentHolder", "equipmentHolderCapProvider", "equipmentHostIfCapProvider", "equipmentHwCapProvider", "equipmentIOCard", "equipmentIOCardBase", "equipmentIOCardCapProvider", "equipmentIOCardStats", "equipmentIOCardStatsHist", "equipmentImpliedStorageEnclosureDef", "equipmentIndicatorLed", "equipmentInstance", "equipmentInstanceMapping", "equipmentIntegratedComponentCapProvider", "equipmentItem", "equipmentLed", "equipmentLocalDiskCapProvider", "equipmentLocalDiskControllerCapProvider", "equipmentLocalDiskDef", "equipmentLocalTemplDef", "equipmentLocatorLed", "equipmentLocatorLedOperation", "equipmentManufacturingDef", "equipmentMemoryUnitCapProvider", "equipmentNetworkElementFanStats", "equipmentNetworkElementFanStatsHist", "equipmentPciDef", "equipmentPhysicalQual", "equipmentPicture", "equipmentPlaceable", "equipmentPlaced", "equipmentPool", "equipmentPoolable", "equipmentPooled", "equipmentPoolingPolicy", "equipmentProcessorUnitCapProvider", "equipmentPsu", "equipmentPsuCapProvider", "equipmentPsuInputStats", "equipmentPsuInputStatsHist", "equipmentPsuOutputStats", "equipmentPsuOutputStatsHist", "equipmentPsuStats", "equipmentPsuStatsHist", "equipmentQual", "equipmentQualBase", "equipmentQualItem", "equipmentQualifiedPolicy", "equipmentRackUnitCapProvider", "equipmentRackUnitFanStats", "equipmentRackUnitFanStatsHist", "equipmentRackUnitPsuStats", "equipmentRackUnitPsuStatsHist", "equipmentRequirement", "equipmentSecureBoot", "equipmentServerFeatureCap", "equipmentServerUnitCapProvider", "equipmentSharedIOModule", "equipmentSiocTempStats", "equipmentSiocTempStatsHist", "equipmentSlotEnclosure", "equipmentStateful", "equipmentStatefulBladeComp", "equipmentStatefulChComp", "equipmentStorageProcessorCap", "equipmentSwitchCapProvider", "equipmentSwitchCard", "equipmentSwitchIOCard", "equipmentSwitchIOCardCapProvider", "equipmentSystemFruCapProvider", "equipmentSystemIOController", "equipmentSystemIOControllerOperation", "equipmentTemplate", "equipmentTemplateMapping", "equipmentTier", "equipmentUnifiedPortCapProvider", "equipmentXcvr", "etherErrStats", "etherErrStatsHist", "etherFcoeInterfaceStats", "etherFcoeInterfaceStatsHist", "etherLossStats", "etherLossStatsHist", "etherPIo", "etherPauseStats", "etherPauseStatsHist", "etherRxStats", "etherRxStatsHist", "etherServerIntFIo", "etherSwitchIntFIo", "etherTxStats", "etherTxStatsHist", "eventApplication", "eventEpCtrl", "eventHolder", "eventInst", "eventLog", "eventPolicy", "eventRecord", "extmgmtArpTargets", "extmgmtGatewayPing", "extmgmtIfMonPolicy", "extmgmtMiiStatus", "extmgmtNdiscTargets", "extpolClient", "extpolClientCont", "extpolClientFsm", "extpolClientFsmStage", "extpolClientFsmTask", "extpolConnector", "extpolConnectorContainer", "extpolController", "extpolControllerCont", "extpolDomain", "extpolEp", "extpolEpFsm", "extpolEpFsmStage", "extpolEpFsmTask", "extpolHBStatus", "extpolProvider", "extpolProviderCont", "extpolRegistry", "extpolRegistryCapability", "extpolSvc", "extpolSystemContext", "extpolVersionHolder", "extvmmNetworkSets", "extvmmVMNetworkSets", "fabricADceSwSrvEp", "fabricAEthEstcEp", "fabricAEthLanEp", "fabricAFcEstcEp", "fabricAFcSanEp", "fabricAFcoeEstcEp", "fabricAFcoeSanEp", "fabricAGroupReq", "fabricANetGroup", "fabricANetGroupRef", "fabricASanGroup", "fabricAVlan", "fabricAVsan", "fabricBaseNetGroup", "fabricBasePhEp", "fabricBaseSlotEp", "fabricBreakout", "fabricBreakoutOperation", "fabricCIoEp", "fabricCabling", "fabricCablingSw", "fabricCartridgeSlotEp", "fabricCartridgeSlotEpOperation", "fabricCdpLinkPolicy", "fabricChangedObjectRef", "fabricChassisEp", "fabricCloud", "fabricComputeEp", "fabricComputeMSlotEp", "fabricComputePhEp", "fabricComputePhEpOperation", "fabricComputeSlotEp", "fabricComputeSlotEpOperation", "fabricConsumer", "fabricDceSrv", "fabricDceSwSrv", "fabricDceSwSrvEp", "fabricDceSwSrvEpOperation", "fabricDceSwSrvPc", "fabricDceSwSrvPcEp", "fabricDceSwSrvPcEpOperation", "fabricDceSwSrvPcOperation", "fabricDceSwSrvPcOperationFsm", "fabricDceSwSrvPcOperationFsmStage", "fabricDomain", "fabricDomainEp", "fabricEnclosurePhEp", "fabricEnclosurePhEpOperation", "fabricEnclosureSlotEp", "fabricEnclosureSlotEpOperation", "fabricEp", "fabricEpVlan", "fabricEpVsan", "fabricEquipmentEp", "fabricEstcEp", "fabricEstcPc", "fabricEthCdpPolicy", "fabricEthEstc", "fabricEthEstcCloud", "fabricEthEstcEp", "fabricEthEstcEpOperation", "fabricEthEstcEpOperationFsm", "fabricEthEstcEpOperationFsmStage", "fabricEthEstcPc", "fabricEthEstcPcEp", "fabricEthEstcPcEpOperation", "fabricEthEstcPcOperation", "fabricEthEstcPcOperationFsm", "fabricEthEstcPcOperationFsmStage", "fabricEthLan", "fabricEthLanEp", "fabricEthLanEpOperation", "fabricEthLanEpOperationFsm", "fabricEthLanEpOperationFsmStage", "fabricEthLanPc", "fabricEthLanPcEp", "fabricEthLanPcEpOperation", "fabricEthLanPcOperation", "fabricEthLanPcOperationFsm", "fabricEthLanPcOperationFsmStage", "fabricEthLinkPolicy", "fabricEthLinkProfile", "fabricEthMon", "fabricEthMonDestEp", "fabricEthMonDestEpOperation", "fabricEthMonLan", "fabricEthMonOperation", "fabricEthMonOperationFsm", "fabricEthMonOperationFsmStage", "fabricEthMonSrcEp", "fabricEthMonSrcEpOperation", "fabricEthMonSrcRef", "fabricEthPortOperation", "fabricEthPortOperationFsm", "fabricEthPortOperationFsmStage", "fabricEthTargetEp", "fabricEthTargetEpOperation", "fabricEthUdldPolicy", "fabricEthVlanPc", "fabricEthVlanPortEp", "fabricEtherRef", "fabricExtension", "fabricExternal", "fabricExternalEp", "fabricExternalEstc", "fabricExternalPc", "fabricFIPortOperation", "fabricFIPortOperationFsm", "fabricFIPortOperationFsmStage", "fabricFIPortOperationFsmTask", "fabricFcEndpoint", "fabricFcEstc", "fabricFcEstcCloud", "fabricFcEstcEp", "fabricFcEstcEpOperation", "fabricFcEstcEpOperationFsm", "fabricFcEstcEpOperationFsmStage", "fabricFcMon", "fabricFcMonDestEp", "fabricFcMonDestEpOperation", "fabricFcMonOperation", "fabricFcMonOperationFsm", "fabricFcMonOperationFsmStage", "fabricFcMonSan", "fabricFcMonSrcEp", "fabricFcMonSrcEpOperation", "fabricFcMonSrcRef", "fabricFcPortOperation", "fabricFcPortOperationFsm", "fabricFcPortOperationFsmStage", "fabricFcSan", "fabricFcSanEp", "fabricFcSanEpOperation", "fabricFcSanEpOperationFsm", "fabricFcSanEpOperationFsmStage", "fabricFcSanPc", "fabricFcSanPcEp", "fabricFcSanPcEpOperation", "fabricFcSanPcOperation", "fabricFcSanPcOperationFsm", "fabricFcSanPcOperationFsmStage", "fabricFcUplinkOperation", "fabricFcUserZone", "fabricFcUserZoneIvt", "fabricFcVsanPc", "fabricFcVsanPortEp", "fabricFcZoneProfile", "fabricFcZoneProfileFsm", "fabricFcZoneProfileFsmStage", "fabricFcZoneProfileFsmTask", "fabricFcZoneProfileIvt", "fabricFcoeEstcEp", "fabricFcoeEstcEpOperation", "fabricFcoeEstcEpOperationFsm", "fabricFcoeEstcEpOperationFsmStage", "fabricFcoeSanEp", "fabricFcoeSanEpOperation", "fabricFcoeSanEpOperationFsm", "fabricFcoeSanEpOperationFsmStage", "fabricFcoeSanPc", "fabricFcoeSanPcEp", "fabricFcoeSanPcEpOperation", "fabricFcoeSanPcOperation", "fabricFcoeSanPcOperationFsm", "fabricFcoeSanPcOperationFsmStage", "fabricFcoeVsanPc", "fabricFcoeVsanPortEp", "fabricHolder", "fabricIf", "fabricInternal", "fabricInternalDceSrv", "fabricInternalEp", "fabricInternalPc", "fabricLacpPolicy", "fabricLan", "fabricLanAccessMgr", "fabricLanCloud", "fabricLanCloudPolicy", "fabricLanEp", "fabricLanMonCloud", "fabricLanPc", "fabricLanPinGroup", "fabricLanPinGroupOperation", "fabricLanPinTarget", "fabricLanPinTargetOperation", "fabricLastAckedSlot", "fabricLinkPolicy", "fabricMon", "fabricMonDestEp", "fabricMonSrcEp", "fabricMonSrcRef", "fabricMulticastPolicy", "fabricNetGroup", "fabricNetGroupEp", "fabricNetGroupPermit", "fabricNetGroupRef", "fabricNetGroupReq", "fabricOrgVlanPolicy", "fabricPIoEp", "fabricPinGroup", "fabricPinTarget", "fabricPoolableVlan", "fabricPooledVlan", "fabricSan", "fabricSanCloud", "fabricSanEp", "fabricSanGroup", "fabricSanGroupRef", "fabricSanMonCloud", "fabricSanPc", "fabricSanPinGroup", "fabricSanPinGroupOperation", "fabricSanPinTarget", "fabricSanPinTargetOperation", "fabricSubGroup", "fabricSwChEp", "fabricSwChPhEp", "fabricSwChPhEpOperation", "fabricSwSrvEp", "fabricSwSrvPc", "fabricSwSubGroup", "fabricSystem", "fabricTargetEp", "fabricUdldLinkPolicy", "fabricUdldPolicy", "fabricVCon", "fabricVConProfile", "fabricVlan", "fabricVlanEp", "fabricVlanGroupReq", "fabricVlanPermit", "fabricVlanPermitItem", "fabricVlanReq", "fabricVnetEp", "fabricVnetEpSyncEp", "fabricVnetEpSyncEpFsm", "fabricVnetEpSyncEpFsmStage", "fabricVnetEpSyncEpFsmTask", "fabricVnetGroupReq", "fabricVnetReq", "fabricVsan", "fabricVsanEp", "fabricVsanMembership", "faultBaseHolder", "faultBasePolicy", "faultBaseTypedHolder", "faultDomainEp", "faultDomainInst", "faultGlobalSeverityHolder", "faultGlobalTypedHolder", "faultHolder", "faultInst", "faultLocalBaseHolder", "faultLocalTypedHolder", "faultPolicy", "faultSummary", "faultSummaryInst", "faultSvcSummary", "faultTypedHolder", "fcErrStats", "fcErrStatsHist", "fcPIo", "fcStats", "fcStatsHist", "fcpoolAddr", "fcpoolBlock", "fcpoolBootTarget", "fcpoolFormat", "fcpoolInitiator", "fcpoolInitiatorEp", "fcpoolInitiators", "fcpoolUniverse", "fdBlade", "fdBladeFsm", "fdBladeFsmStage", "fdChassis", "fdOperable", "fdPhysical", "fdPhysicalFsm", "fdPhysicalFsmStage", "fdPhysicalFsmTask", "fdRackUnit", "fdRackUnitFsm", "fdRackUnitFsmStage", "featureCatalogEp", "featureChassisDef", "featureDefinition", "featureEnvDef", "featureNetworkDef", "featureServerDef", "featureStorageDef", "firmwareAComponentSpec", "firmwareAExcludeComponent", "firmwareAInfraPack", "firmwareAck", "firmwareAutoSyncPolicy", "firmwareBootDefinition", "firmwareBootUnit", "firmwareBundleInfo", "firmwareBundleInfoDigest", "firmwareBundleType", "firmwareBundleTypeCapProvider", "firmwareCapProvider", "firmwareCatalogPack", "firmwareCatalogPackConfig", "firmwareCatalogue", "firmwareChassisComponentSpec", "firmwareChassisPack", "firmwareCompItem", "firmwareCompSource", "firmwareCompTarget", "firmwareComponentSpec", "firmwareComputeHostPack", "firmwareComputeMgmtPack", "firmwareComputePack", "firmwareComputeStoragePack", "firmwareConnectionPolicy", "firmwareDependency", "firmwareDistImage", "firmwareDistributable", "firmwareDistributableFsm", "firmwareDistributableFsmStage", "firmwareDistributableFsmTask", "firmwareDomainInfo", "firmwareDomainInfraProfile", "firmwareDownloadPolicy", "firmwareDownloader", "firmwareDownloaderFsm", "firmwareDownloaderFsmStage", "firmwareDownloaderFsmTask", "firmwareExcludeChassisComponent", "firmwareExcludeServerComponent", "firmwareImage", "firmwareInfra", "firmwareInfraPack", "firmwareInfraPackConfig", "firmwareInfraPolicy", "firmwareInstallImpact", "firmwarePack", "firmwarePolicy", "firmwareProductFamily", "firmwareRemoteCatalogue", "firmwareRunning", "firmwareSource", "firmwareStatus", "firmwareStoragePack", "firmwareSystem", "firmwareType", "firmwareUnit", "firmwareUpdatable", "firmwareUpgradeDetail", "firmwareUpgradeInfo", "flowctrlDefinition", "flowctrlItem", "fsmFsm", "fsmStage", "fsmStatus", "fsmTask", "glAbsConflict", "glAbsEp", "glAbsIdentCtxOp", "glAbsInv", "glAbsOperation", "glAbsPolicyInv", "glAbsPolicyOp", "glAbsPolicyRule", "glAbsRequest", "glAbsResEp", "glAbsRule", "glAbsVnetInv", "glAppendRule", "glBlockEp", "glBlockOp", "glByMo", "glComplexRefEp", "glConflictEp", "glConflictResolutionRuleEp", "glDomainEp", "glEp", "glGlobalDefaultPolicyEp", "glIdRef", "glIdRefEp", "glIdable", "glIdentCtxEp", "glIdentCtxOp", "glIdentCtxResOp", "glIdentCtxResOpFsm", "glIdentCtxResOpFsmStage", "glIdentCtxResOpFsmTask", "glInventoryEp", "glLsp", "glMcastPolicy", "glOperationEp", "glPathEp", "glPolicy", "glPolicyAlgorithmedOp", "glPolicyEp", "glPolicyInvEp", "glPolicyNameRuleEp", "glPolicyOp", "glPolicyRef", "glPolicyRefEp", "glPolicyResOp", "glPolicyResolutionEp", "glPool", "glPoolEp", "glPoolInvEp", "glPoolOp", "glRefable", "glRefsEp", "glRequest", "glRequestFsm", "glRequestFsmStage", "glRequestFsmTask", "glRequestVnetEp", "glRequestVnetEpDomainEp", "glRequestVnetEpDomainEpFsm", "glRequestVnetEpDomainEpFsmStage", "glRequestVnetEpDomainEpFsmTask", "glRequestVnetEpFsm", "glRequestVnetEpFsmStage", "glRequestVnetEpFsmTask", "glRequestVnetEpHolder", "glRequestor", "glRequestorEp", "glSPInvEp", "glServerPoolResOp", "glServiceProfile", "glSpDefEp", "glTemplateEp", "glTemplateOp", "glTemplateResOp", "glUsage", "glUsageEp", "glVlan", "glVnetInvHolder", "glVnicTemplate", "glVnicTemplateEp", "glVsan", "glVxanEp", "glVxanOp", "glVxanResOp", "gmetaClass", "gmetaPolicyMapElement", "gmetaProp", "graphicsCard", "graphicsController", "guiGuiComponent", "guiGuiCont", "hcAComponent", "hcAItem", "hcAStatusItem", "hcAdapterFirmwareItem", "hcAdapterItem", "hcAdmin", "hcCatalog", "hcCatalogList", "hcCatalogSource", "hcCatalogVersion", "hcCleanup", "hcDownloadPolicy", "hcDownloader", "hcDriverInfoItem", "hcDriverItem", "hcHolder", "hcItemNote", "hcOsInfoItem", "hcOsItem", "hcReport", "hcScopeDn", "hcServerComponent", "hcSupportedAdapterFirmwareItem", "hcSupportedAdapterItem", "hcSupportedDriverItem", "hcSupportedOsItem", "hcUcsVersionItem", "identDomainSyncEp", "identExecutionEp", "identExecutionRequestEp", "identIdentCtx", "identIdentRequest", "identIdentRequestFsm", "identIdentRequestFsmStage", "identIdentRequestFsmTask", "identMetaSystem", "identMetaSystemFsm", "identMetaSystemFsmStage", "identMetaSystemFsmTask", "identMetaVerse", "identRequestEp", "identSysInfo", "identpoolBlockQual", "identpoolConsumed", "identpoolDomain", "identpoolDomainGroupQual", "identpoolElement", "identpoolIPQual", "identpoolIPV6Qual", "identpoolMetaSystem", "identpoolMetaVerse", "identpoolPool", "identpoolPoolable", "identpoolQualItem", "identpoolUniverse", "inbandPolicy", "initiatorEp", "initiatorFcInitiatorEp", "initiatorGroupEp", "initiatorIScsiInitiatorEp", "initiatorInitiatorEp", "initiatorLunEp", "initiatorMemberEp", "initiatorRequestorEp", "initiatorRequestorGrpEp", "initiatorStoreEp", "initiatorUnitEp", "inventoryDomainEp", "inventoryEp", "inventoryGlobalEp", "inventoryHolder", "inventoryInventoryEp", "inventoryInventoryMoMeta", "ipIPv4Dns", "ipIpV4Addr", "ipIpV4StaticAddr", "ipServiceIf", "ippoolAddr", "ippoolBlock", "ippoolIpV6Addr", "ippoolIpV6Block", "ippoolIpV6Pooled", "ippoolPool", "ippoolPooled", "ippoolUniverse", "iqnpoolAbsBlock", "iqnpoolAddr", "iqnpoolBlock", "iqnpoolFormat", "iqnpoolPool", "iqnpoolPooled", "iqnpoolTransportBlock", "iqnpoolUniverse", "iscsiAuthProfile", "licenseCapProvider", "licenseContents", "licenseDomain", "licenseDownloader", "licenseDownloaderFsm", "licenseDownloaderFsmStage", "licenseDownloaderFsmTask", "licenseEp", "licenseFeature", "licenseFeatureCapProvider", "licenseFeatureLine", "licenseFile", "licenseFileFsm", "licenseFileFsmStage", "licenseFileFsmTask", "licenseInstance", "licenseInstanceFsm", "licenseInstanceFsmStage", "licenseInstanceFsmTask", "licenseLicense", "licenseProp", "licenseServerHostId", "licenseSource", "licenseSourceFile", "lsBinding", "lsComputeBinding", "lsFcLocale", "lsFcZone", "lsFcZoneGroup", "lsFcZoneMember", "lsIdentityInfo", "lsIssues", "lsPower", "lsRequirement", "lsSPMeta", "lsServer", "lsServerAssocCtx", "lsServerExtension", "lsServerFsm", "lsServerFsmStage", "lsServerFsmTask", "lsServerOperation", "lsTier", "lsVConAssign", "lsWaitingUserAck", "lsZoneInitiatorMember", "lsZoneTargetMember", "lsbootADef", "lsbootBootSecurity", "lsbootCategory", "lsbootDef", "lsbootDefaultLocalImage", "lsbootEFIShell", "lsbootEmbeddedLocalDiskImage", "lsbootEmbeddedLocalDiskImagePath", "lsbootEmbeddedLocalLunImage", "lsbootIScsi", "lsbootIScsiImagePath", "lsbootImage", "lsbootImagePath", "lsbootItem", "lsbootLan", "lsbootLanImagePath", "lsbootLocalDiskImage", "lsbootLocalDiskImagePath", "lsbootLocalHddImage", "lsbootLocalImage", "lsbootLocalLunImagePath", "lsbootLocalMediaItem", "lsbootLocalStorage", "lsbootNvme", "lsbootNvmeDevice", "lsbootNvmeDiskSsd", "lsbootNvmePciSsd", "lsbootPolicy", "lsbootRemoteImage", "lsbootSan", "lsbootSanCatSanImage", "lsbootSanCatSanImagePath", "lsbootSanImage", "lsbootSanImagePath", "lsbootStorage", "lsbootUEFIBootParam", "lsbootUpgradeStatus", "lsbootUsbExternalImage", "lsbootUsbFlashStorageImage", "lsbootUsbInternalImage", "lsbootVirtualMedia", "lsmaintAck", "lsmaintMaintPolicy", "lstorageASlot", "lstorageAck", "lstorageArrayRequirement", "lstorageBlade", "lstorageControllerDef", "lstorageControllerModeConfig", "lstorageControllerQualifier", "lstorageControllerRef", "lstorageCtrlServiceOperation", "lstorageDasScsiLun", "lstorageDiskGroupConfig", "lstorageDiskGroupConfigDef", "lstorageDiskGroupConfigPolicy", "lstorageDiskGroupQualifier", "lstorageDiskSlot", "lstorageDiskZoningConfig", "lstorageDiskZoningConfigDef", "lstorageDiskZoningPolicy", "lstorageDriveSecurity", "lstorageExtension", "lstorageItem", "lstorageLocal", "lstorageLocalConfig", "lstorageLocalDef", "lstorageLocalDiskConfigRef", "lstorageLocalDiskRef", "lstorageLogin", "lstorageMeta", "lstorageProcessorBase", "lstorageProfile", "lstorageProfileBase", "lstorageProfileBinding", "lstorageProfileBindingBase", "lstorageProfileDef", "lstorageQualItem", "lstorageRecurrWindow", "lstorageRemote", "lstorageRemoteConfig", "lstorageRemoteDef", "lstorageRequestCtx", "lstorageScsiLun", "lstorageSecurity", "lstorageVirtualDriveDef", "macpoolAddr", "macpoolBlock", "macpoolFormat", "macpoolPool", "macpoolPooled", "macpoolUniverse", "memoryArray", "memoryArrayEnvStats", "memoryArrayEnvStatsHist", "memoryBufferUnit", "memoryBufferUnitEnvStats", "memoryBufferUnitEnvStatsHist", "memoryController", "memoryErrorStats", "memoryErrorStatsHist", "memoryNvDimm", "memoryNvDimmBattery", "memoryNvDimmController", "memoryQual", "memoryRuntime", "memoryRuntimeHist", "memoryUnit", "memoryUnitEnvStats", "memoryUnitEnvStatsHist", "messageEntry", "messageEp", "mgmtAKmipCertPolicy", "mgmtASecureBoot", "mgmtAbsBackup", "mgmtAbsDataItem", "mgmtAbsImporter", "mgmtBackup", "mgmtBackupFsm", "mgmtBackupFsmStage", "mgmtBackupFsmTask", "mgmtBackupOperation", "mgmtBackupPolicy", "mgmtBackupTrigger", "mgmtBackupTriggerFsm", "mgmtBackupTriggerFsmStage", "mgmtBackupTriggerFsmTask", "mgmtCfgExportPolicy", "mgmtCimcInterface", "mgmtCmcSecureBoot", "mgmtCmcSecureBootOperation", "mgmtConnection", "mgmtController", "mgmtDataExporter", "mgmtDataExporterFsm", "mgmtDataExporterFsmStage", "mgmtDataExporterFsmTask", "mgmtDataImporter", "mgmtDataImporterFsm", "mgmtDataImporterFsmStage", "mgmtDataImporterFsmTask", "mgmtDataItem", "mgmtEntity", "mgmtEp", "mgmtExportPolicy", "mgmtIPv6Addr", "mgmtIPv6IfAddr", "mgmtIPv6IfConfig", "mgmtIf", "mgmtIfFsm", "mgmtIfFsmStage", "mgmtIfFsmTask", "mgmtImportItem", "mgmtImporter", "mgmtImporterFsm", "mgmtImporterFsmStage", "mgmtImporterFsmTask", "mgmtInbandProfile", "mgmtInterface", "mgmtKmip", "mgmtKmipCertPolicy", "mgmtKmipOperation", "mgmtNamedKmipCertPolicy", "mgmtRegistryInfo", "mgmtRegistryInfoFsm", "mgmtRegistryInfoFsmStage", "mgmtRegistryInfoFsmTask", "mgmtSecurity", "mgmtSvc", "mgmtVnet", "moTopProps", "namingBinding", "namingDefinition", "namingHolder", "namingNamedIdentifiedObject", "namingNamedObject", "namingObject", "netNetGroupPermit", "networkCACert", "networkCIoEp", "networkConn", "networkElement", "networkElementFsm", "networkElementFsmStage", "networkElementFsmTask", "networkElementOperation", "networkEp", "networkIfEp", "networkPIoEp", "networkPhysEp", "networkSystemCACert", "networkVnetEp", "nfsClientDef", "nfsClientDefFsm", "nfsClientDefFsmStage", "nfsClientDefFsmTask", "nfsEp", "nfsExportDef", "nfsExportDefFsm", "nfsExportDefFsmStage", "nfsExportDefFsmTask", "nfsMountDef", "nfsRepositorySpecPolicy", "nwctrlDefinition", "observeFilter", "observeObserved", "observeObservedCont", "observeObservedFsm", "observeObservedFsmStage", "observeObservedFsmTask", "orgAOrg", "orgDomainFirmwareInfo", "orgDomainGroup", "orgDomainGroupFirmwareReport", "orgDomainGroupPolicy", "orgDomainGroupPolicyReport", "orgDomainGroupReport", "orgExtension", "orgFirmwareVersionCount", "orgMaintTagFirmwareReport", "orgOrg", "orgOrgFsm", "orgOrgFsmStage", "orgOrgFsmTask", "orgOrgSource", "orgSourceMask", "osController", "osEthBondIntf", "osEthBondMode", "osEthIntf", "osInstance", "osIntf", "osLinkMonitoringPolicy", "osPrimarySlave", "pciCard", "pkiCertReq", "pkiDefinition", "pkiEp", "pkiEpFsm", "pkiEpFsmStage", "pkiEpFsmTask", "pkiItem", "pkiKeyRing", "pkiTP", "policyADestEp", "policyAckSuspendOperation", "policyBinding", "policyChildClass", "policyCluster", "policyCommunication", "policyCommunicationOp", "policyConfigBackup", "policyConfigBackupOp", "policyConfigError", "policyContext", "policyControl", "policyControlEp", "policyControlEpOp", "policyControlEpOpFsm", "policyControlEpOpFsmStage", "policyControlEpOpFsmTask", "policyControlEpOperation", "policyControlOp", "policyControlled", "policyControlledInstance", "policyControlledType", "policyDateTime", "policyDateTimeOp", "policyDefinition", "policyDestClass", "policyDestEp", "policyDeviceProfile", "policyDigest", "policyDiscovery", "policyDiscoveryOp", "policyDns", "policyDnsOp", "policyElement", "policyEquipment", "policyEquipmentOp", "policyFault", "policyFaultOp", "policyIdentifierPolicy", "policyInfraFirmware", "policyInfraFirmwareOp", "policyItem", "policyLocalMap", "policyLogProfile", "policyMEp", "policyMEpOp", "policyMonitoring", "policyMonitoringOp", "policyObject", "policyPolicyDestClass", "policyPolicyEp", "policyPolicyRequestor", "policyPolicyScope", "policyPolicyScopeCont", "policyPolicyScopeContext", "policyPolicyScopeFsm", "policyPolicyScopeFsmStage", "policyPolicyScopeFsmTask", "policyPortConfig", "policyPortConfigOp", "policyPowerMgmt", "policyPowerMgmtOp", "policyProxyMo", "policyPsu", "policyPsuOp", "policyRequestor", "policyScope", "policySecurity", "policySecurityOp", "policySource", "policySourceApp", "policyStorageAutoConfig", "policyStorageAutoConfigOp", "policySystemEp", "policySystemProfile", "policyTracked", "policyTracker", "policyUniverse", "poolAsnmt", "poolElement", "poolElementAlloc", "poolMember", "poolPool", "poolPoolMember", "poolPoolable", "poolUniverse", "portGroup", "portIntFIo", "portPIo", "portPhysSwitchIo", "portServerIntFIo", "portSubGroup", "portSwitchIntFIo", "powerABudget", "powerAGroup", "powerBudget", "powerChassisMember", "powerEp", "powerGroup", "powerGroupMember", "powerGroupQual", "powerGroupStats", "powerGroupStatsHist", "powerMgmtPolicy", "powerPolicy", "powerProfiledPower", "procDoer", "procManager", "procProcCounts", "procProcs", "procPrt", "procPrtCounts", "procStimulusCounts", "procSvc", "procTxCounts", "processorEnvStats", "processorEnvStatsHist", "processorErrorStats", "processorErrorStatsHist", "processorQual", "processorRuntime", "processorRuntimeHist", "processorUnit", "processorUnitAssocCtx", "qosDefinition", "qosItem", "qosclassDefinition", "qosclassEth", "qosclassEthBE", "qosclassEthClassified", "qosclassFc", "qosclassItem", "qosclassPolicy", "queryContext", "queryDependencyContext", "queryDependencyRef", "queryEp", "queryImportContext", "queryUsageContext", "queryresultDependency", "queryresultDestOrgEp", "queryresultDomainGroupEp", "queryresultItem", "queryresultOrgEp", "queryresultUsage", "ruleDefinition", "ruleItem", "ruleRequirement", "ruleSizeRequirement", "securityUnit", "sesDiskSlotEp", "sesEnclosure", "smartcallhomeHttpProxy", "smartcallhomePeriodicInventoryStatus", "smartcallhomePeriodicSystemInventory", "smartcallhomePolicy", "smartcallhomeProfile", "smartcallhomeSource", "smartcallhomeTransportGateway", "smartlicenseAgent", "smartlicenseAgentFsm", "smartlicenseAgentFsmStage", "smartlicenseAgentFsmTask", "smartlicenseEntitlement", "smartlicenseEntitlementEp", "smartlicenseEntitlementEpFsm", "smartlicenseEntitlementEpFsmStage", "smartlicenseEntitlementEpFsmTask", "smartlicenseEp", "smartlicenseHolder", "smartlicenseHolderFsm", "smartlicenseHolderFsmStage", "smartlicenseHolderFsmTask", "smartlicenseTest", "smartlicenseTestFsm", "smartlicenseTestFsmStage", "smartlicenseTestFsmTask", "solDef", "solPolicy", "statsChart", "statsChartContainer", "statsCollectionPolicy", "statsCurr", "statsCustomChart", "statsCustomEp", "statsDbMigrationStatus", "statsDbSummaryMeta", "statsHist", "statsHolder", "statsInventoryMeta", "statsItem", "statsPasadenaCollectionPolicy", "statsStandardChart", "statsStandardEp", "statsStatsQuery", "statsStatsQueryHolder", "statsThr32Definition", "statsThr32Value", "statsThr64Definition", "statsThr64Value", "statsThrFloatDefinition", "statsThrFloatValue", "statsThresholdClass", "statsThresholdDefinition", "statsThresholdPolicy", "statsThresholdValue", "storageADef", "storageALun", "storageALunRefBase", "storageAScsiLun", "storageAScsiLunCtx", "storageASlot", "storageASnapReplicaLunCtx", "storageAVolume", "storageAppliance", "storageArray", "storageAuthKey", "storageBackstore", "storageBlade", "storageCloud", "storageClusterIdUniverse", "storageComputeBladeOperation", "storageConnectionDef", "storageConnectionPolicy", "storageContainer", "storageController", "storageControllerBase", "storageControllerEp", "storageControllerOperation", "storageControllerRef", "storageCtrlStorageStats", "storageCtrlStorageStatsHist", "storageDevice", "storageDiskEnvStats", "storageDiskEnvStatsHist", "storageDiskEp", "storageDiskGroup", "storageEmbeddedStorage", "storageEnclosure", "storageEnclosureDiskSlotEp", "storageEnclosureLocalDiskConfig", "storageEp", "storageEpUser", "storageEthLif", "storageEtherIf", "storageFcIf", "storageFcTargetEp", "storageFcTargetIf", "storageFlexFlashCard", "storageFlexFlashController", "storageFlexFlashControllerOperation", "storageFlexFlashDrive", "storageFlexFlashVirtualDrive", "storageHddMotherBoardTempStats", "storageHddMotherBoardTempStatsHist", "storageIScsiInitiatorEp", "storageIScsiTargetIf", "storageIniGroup", "storageInitiator", "storageInitiatorRef", "storageIpV4PooledAddr", "storageIpV4StaticAddr", "storageItem", "storageL2If", "storageLocalDisk", "storageLocalDiskBase", "storageLocalDiskConfig", "storageLocalDiskConfigDef", "storageLocalDiskConfigPolicy", "storageLocalDiskEp", "storageLocalDiskOperation", "storageLocalDiskPartition", "storageLocalLun", "storageLogical", "storageLunCounters", "storageLunDisk", "storageLunMaskGroup", "storageLunReplica", "storageLunResourceSelectionLog", "storageLunSnapshot", "storageMeta", "storageMezzFlashLife", "storageNodeEp", "storageNvmeStats", "storageNvmeStatsHist", "storageNvmeStorage", "storageOnboardDevice", "storageOperation", "storagePartition", "storagePhysical", "storageProcessor", "storageProcessorEp", "storageProcessorRuntime", "storageQual", "storageRaidBattery", "storageReplicationCtx", "storageSasExpander", "storageSasPhyLink", "storageSasPort", "storageSasUpLink", "storageScsiDeviceDescriptor", "storageScsiLun", "storageScsiLunCtx", "storageScsiLunInstRef", "storageScsiLunMask", "storageScsiLunRef", "storageSnapshot", "storageSnapshotCtx", "storageSsdHealthStats", "storageSsdHealthStatsHist", "storageStorageStats", "storageStorageStatsHist", "storageSystem", "storageTarget", "storageTargetIf", "storageTransportIf", "storageTransportableFlashModule", "storageUnit", "storageUsageCounters", "storageVDMemberEp", "storageVirtualDrive", "storageVirtualDriveContainer", "storageVirtualDriveEp", "storageVirtualDriveOperation", "storageVirtualDriveRef", "storageVirtualDriveRefOperation", "storageVolume", "storageVsanRef", "storageVsanRefIvt", "swCardEnvStats", "swCardEnvStatsHist", "swEnvStats", "swEnvStatsHist", "swMon", "swSystemStats", "swSystemStatsHist", "swVlan", "swVlanGroup", "syntheticDirectory", "syntheticFile", "syntheticFileSystem", "syntheticFsObj", "syntheticTime", "sysdebugAutoCoreFileExportTarget", "sysdebugAutoCoreFileExportTargetFsm", "sysdebugAutoCoreFileExportTargetFsmStage", "sysdebugAutoCoreFileExportTargetFsmTask", "sysdebugBackupBehavior", "sysdebugCore", "sysdebugCoreFileExportTarget", "sysdebugCoreFileRepository", "sysdebugDiagnosticLog", "sysdebugEp", "sysdebugExporter", "sysdebugFile", "sysdebugLogBehavior", "sysdebugLogControlDestinationFile", "sysdebugLogControlDestinationSyslog", "sysdebugLogControlDomain", "sysdebugLogControlEp", "sysdebugLogControlEpFsm", "sysdebugLogControlEpFsmStage", "sysdebugLogControlEpFsmTask", "sysdebugLogControlModule", "sysdebugMEpLogDef", "sysdebugMEpLogPolicy", "sysdebugManualCoreFileExportTarget", "sysdebugManualCoreFileExportTargetFsm", "sysdebugManualCoreFileExportTargetFsmStage", "sysdebugManualCoreFileExportTargetFsmTask", "sysdebugRepository", "sysdebugTechSupFileRepository", "sysdebugTechSupport", "sysdebugTechSupportCmdOpt", "sysdebugTechSupportFsm", "sysdebugTechSupportFsmStage", "sysdebugTechSupportFsmTask", "sysdebugTechSupportOp", "sysdebugTechSupportOperation", "sysfileDigest", "sysfileEp", "sysfileExporter", "sysfileImporter", "sysfileInstance", "sysfileMutation", "sysfileMutationFsm", "sysfileMutationFsmStage", "sysfileMutationFsmTask", "sysfileRepository", "tagADef", "tagAInstance", "tagDef", "tagDefEp", "tagDriver", "tagInstance", "tagInstanceEp", "tagInstanceItem", "tagItem", "tagSoftwareInst", "testingCliPolicy", "testingServiceProfile", "testingServiceProfileFsm", "testingServiceProfileFsmStage", "testingServiceProfileFsmTask", "testingSnmpCommunity", "testingSnmpPolicy", "testingSnmpSupport", "testingSnmpTrap", "topInfoSyncPolicy", "topMetaInf", "topRoot", "topSystem", "topSystemFsm", "topSystemFsmStage", "topSystemFsmTask", "trigAbsWindow", "trigAck", "trigBaseRecurrWindow", "trigBaseSched", "trigConfAck", "trigInst", "trigMeta", "trigPendingAckCount", "trigRecurrWindow", "trigResAck", "trigSched", "trigSchedWindow", "trigServerToken", "trigTest", "trigToken", "trigTokenRequestor", "trigTriggerable", "trigTriggered", "trigWindow", "unspecified", "uuidpoolAddr", "uuidpoolBlock", "uuidpoolFormat", "uuidpoolPool", "uuidpoolPooled", "uuidpoolUniverse", "versionApplication", "versionEp", "versionFilter", "versionMatrix", "versionProduct", "versionVersion", "vmAdaptor", "vmNic", "vnicABeh", "vnicAEtherIf", "vnicAFcIf", "vnicAGroup", "vnicBootIpPolicy", "vnicBootTarget", "vnicConPolicyRef", "vnicConReq", "vnicConnDef", "vnicConnection", "vnicDefBeh", "vnicDynamicCon", "vnicDynamicConPolicy", "vnicDynamicConPolicyRef", "vnicDynamicConReq", "vnicEthLif", "vnicEther", "vnicEtherBase", "vnicEtherBaseIf", "vnicEtherIf", "vnicFault", "vnicFc", "vnicFcBase", "vnicFcGroupDef", "vnicFcGroupTempl", "vnicFcIf", "vnicFcLif", "vnicFcNode", "vnicFcOEIf", "vnicIPIf", "vnicIPv4Dhcp", "vnicIPv4Dns", "vnicIPv4If", "vnicIPv4IscsiAddr", "vnicIPv4PooledIscsiAddr", "vnicIPv4StaticRoute", "vnicIPv6If", "vnicIScsi", "vnicIScsiAutoTargetIf", "vnicIScsiBase", "vnicIScsiBootParams", "vnicIScsiBootVnic", "vnicIScsiInitiatorParams", "vnicIScsiLCP", "vnicIScsiNode", "vnicIScsiStaticTargetIf", "vnicIScsiTargetIf", "vnicIScsiTargetParams", "vnicIf", "vnicIfRole", "vnicIniGrpFc", "vnicIniGrpFcB", "vnicIniGrpFcBIf", "vnicIniGrpFcBase", "vnicIniGrpFcIf", "vnicIpAddr", "vnicIpV4Addr", "vnicIpV4AddrConf", "vnicIpV4AddrExplConf", "vnicIpV4MgmtPooledAddr", "vnicIpV4PooledAddr", "vnicIpV4ProfDerivedAddr", "vnicIpV4StaticAddr", "vnicIpV6Addr", "vnicIpV6AddrConf", "vnicIpV6AddrExplConf", "vnicIpV6MgmtPooledAddr", "vnicIpV6StaticAddr", "vnicL2If", "vnicL2Lif", "vnicL3If", "vnicLanConnPolicy", "vnicLanConnTempl", "vnicLifVlan", "vnicLifVsan", "vnicLstorageIScsi", "vnicLun", "vnicMgmt", "vnicMgmtBase", "vnicMgmtIf", "vnicMonSesFc", "vnicMonSesFcBase", "vnicMonSesFcIf", "vnicNetGroup", "vnicNetGroupRef", "vnicNicConn", "vnicOutbandMgmtEp", "vnicOutbandMgmtEpFsm", "vnicOutbandMgmtEpFsmStage", "vnicOutbandMgmtEpFsmTask", "vnicProfileSet", "vnicRackServerDiscoveryProfile", "vnicSanConnPolicy", "vnicSanConnTempl", "vnicStorageEthLif", "vnicStorageLif", "vnicTempl", "vnicUsnicConPolicy", "vnicUsnicConPolicyRef", "vnicUsnicConReq", "vnicVhbaBehPolicy", "vnicVlan", "vnicVmqConPolicy", "vnicVmqConPolicyRef", "vnicVmqConReq", "vnicVnic", "vnicVnicBehPolicy"], []), 
        "oper_code": MoPropertyMeta("oper_code", "operCode", "string", VersionMeta.Version131a, MoPropertyMeta.READ_WRITE, 0x8, None, None, None, ["create", "delete"], []), 
        "rn": MoPropertyMeta("rn", "rn", "string", VersionMeta.Version131a, MoPropertyMeta.READ_ONLY, 0x10, 0, 256, None, [], []), 
        "secondary_key": MoPropertyMeta("secondary_key", "secondaryKey", "string", VersionMeta.Version131a, MoPropertyMeta.READ_ONLY, None, 0, 510, None, [], []), 
        "source_mo_dn": MoPropertyMeta("source_mo_dn", "sourceMoDn", "string", VersionMeta.Version131a, MoPropertyMeta.READ_WRITE, 0x20, 0, 256, None, [], []), 
        "status": MoPropertyMeta("status", "status", "string", VersionMeta.Version131a, MoPropertyMeta.READ_WRITE, 0x40, None, None, r"""((removed|created|modified|deleted),){0,3}(removed|created|modified|deleted){0,1}""", [], []), 
    }

    prop_map = {
        "childAction": "child_action", 
        "clientMoDn": "client_mo_dn", 
        "dn": "dn", 
        "id": "id", 
        "isSystem": "is_system", 
        "moClassId": "mo_class_id", 
        "operCode": "oper_code", 
        "rn": "rn", 
        "secondaryKey": "secondary_key", 
        "sourceMoDn": "source_mo_dn", 
        "status": "status", 
    }

    def __init__(self, parent_mo_or_dn, id, **kwargs):
        self._dirty_mask = 0
        self.id = id
        self.child_action = None
        self.client_mo_dn = None
        self.is_system = None
        self.mo_class_id = None
        self.oper_code = None
        self.secondary_key = None
        self.source_mo_dn = None
        self.status = None

        ManagedObject.__init__(self, "DupeScope", parent_mo_or_dn, **kwargs)

