"""This module contains the general information for ConfigSorter ManagedObject."""

from ...ucscmo import ManagedObject
from ...ucsccoremeta import UcscVersion, MoPropertyMeta, MoMeta
from ...ucscmeta import VersionMeta


class ConfigSorterConsts():
    SORT_CLASS_AAA_AUTH_METHOD = "aaaAuthMethod"
    SORT_CLASS_AAA_AUTH_REALM = "aaaAuthRealm"
    SORT_CLASS_AAA_AUTH_REALM_FSM = "aaaAuthRealmFsm"
    SORT_CLASS_AAA_AUTH_REALM_FSM_STAGE = "aaaAuthRealmFsmStage"
    SORT_CLASS_AAA_CONFIG = "aaaConfig"
    SORT_CLASS_AAA_CONSOLE_AUTH = "aaaConsoleAuth"
    SORT_CLASS_AAA_DEFAULT_AUTH = "aaaDefaultAuth"
    SORT_CLASS_AAA_DEFINITION = "aaaDefinition"
    SORT_CLASS_AAA_DOMAIN = "aaaDomain"
    SORT_CLASS_AAA_DOMAIN_AUTH = "aaaDomainAuth"
    SORT_CLASS_AAA_DOMAIN_GROUP = "aaaDomainGroup"
    SORT_CLASS_AAA_EP = "aaaEp"
    SORT_CLASS_AAA_EP_AUTH_PROFILE = "aaaEpAuthProfile"
    SORT_CLASS_AAA_EP_FSM = "aaaEpFsm"
    SORT_CLASS_AAA_EP_FSM_STAGE = "aaaEpFsmStage"
    SORT_CLASS_AAA_EP_FSM_TASK = "aaaEpFsmTask"
    SORT_CLASS_AAA_EP_LOGIN = "aaaEpLogin"
    SORT_CLASS_AAA_EP_USER = "aaaEpUser"
    SORT_CLASS_AAA_EXT_MGMT_CUT_THRU_TKN = "aaaExtMgmtCutThruTkn"
    SORT_CLASS_AAA_ITEM = "aaaItem"
    SORT_CLASS_AAA_LDAP_EP = "aaaLdapEp"
    SORT_CLASS_AAA_LDAP_EP_FSM = "aaaLdapEpFsm"
    SORT_CLASS_AAA_LDAP_EP_FSM_STAGE = "aaaLdapEpFsmStage"
    SORT_CLASS_AAA_LDAP_GROUP = "aaaLdapGroup"
    SORT_CLASS_AAA_LDAP_GROUP_RULE = "aaaLdapGroupRule"
    SORT_CLASS_AAA_LDAP_PROVIDER = "aaaLdapProvider"
    SORT_CLASS_AAA_LOCALE = "aaaLocale"
    SORT_CLASS_AAA_LOG = "aaaLog"
    SORT_CLASS_AAA_MOD_LR = "aaaModLR"
    SORT_CLASS_AAA_ORG = "aaaOrg"
    SORT_CLASS_AAA_PROVIDER = "aaaProvider"
    SORT_CLASS_AAA_PROVIDER_GROUP = "aaaProviderGroup"
    SORT_CLASS_AAA_PROVIDER_REF = "aaaProviderRef"
    SORT_CLASS_AAA_PWD_PROFILE = "aaaPwdProfile"
    SORT_CLASS_AAA_RADIUS_EP = "aaaRadiusEp"
    SORT_CLASS_AAA_RADIUS_EP_FSM = "aaaRadiusEpFsm"
    SORT_CLASS_AAA_RADIUS_EP_FSM_STAGE = "aaaRadiusEpFsmStage"
    SORT_CLASS_AAA_RADIUS_PROVIDER = "aaaRadiusProvider"
    SORT_CLASS_AAA_REALM = "aaaRealm"
    SORT_CLASS_AAA_REALM_FSM = "aaaRealmFsm"
    SORT_CLASS_AAA_REALM_FSM_STAGE = "aaaRealmFsmStage"
    SORT_CLASS_AAA_REALM_FSM_TASK = "aaaRealmFsmTask"
    SORT_CLASS_AAA_REMOTE_USER = "aaaRemoteUser"
    SORT_CLASS_AAA_ROLE = "aaaRole"
    SORT_CLASS_AAA_SESSION = "aaaSession"
    SORT_CLASS_AAA_SESSION_LR = "aaaSessionLR"
    SORT_CLASS_AAA_SHELL_LOGIN = "aaaShellLogin"
    SORT_CLASS_AAA_SSH_AUTH = "aaaSshAuth"
    SORT_CLASS_AAA_SYSTEM_USER = "aaaSystemUser"
    SORT_CLASS_AAA_TACACS_PLUS_EP = "aaaTacacsPlusEp"
    SORT_CLASS_AAA_TACACS_PLUS_EP_FSM = "aaaTacacsPlusEpFsm"
    SORT_CLASS_AAA_TACACS_PLUS_EP_FSM_STAGE = "aaaTacacsPlusEpFsmStage"
    SORT_CLASS_AAA_TACACS_PLUS_PROVIDER = "aaaTacacsPlusProvider"
    SORT_CLASS_AAA_USER = "aaaUser"
    SORT_CLASS_AAA_USER_ACTION = "aaaUserAction"
    SORT_CLASS_AAA_USER_DATA = "aaaUserData"
    SORT_CLASS_AAA_USER_EP = "aaaUserEp"
    SORT_CLASS_AAA_USER_EP_FSM = "aaaUserEpFsm"
    SORT_CLASS_AAA_USER_EP_FSM_STAGE = "aaaUserEpFsmStage"
    SORT_CLASS_AAA_USER_EP_FSM_TASK = "aaaUserEpFsmTask"
    SORT_CLASS_AAA_USER_GROUP = "aaaUserGroup"
    SORT_CLASS_AAA_USER_LOCALE = "aaaUserLocale"
    SORT_CLASS_AAA_USER_LOGIN = "aaaUserLogin"
    SORT_CLASS_AAA_USER_PREFERENCES = "aaaUserPreferences"
    SORT_CLASS_AAA_USER_ROLE = "aaaUserRole"
    SORT_CLASS_AAA_WEB_LOGIN = "aaaWebLogin"
    SORT_CLASS_ADAPTOR_BEH_CAP = "adaptorBehCap"
    SORT_CLASS_ADAPTOR_CAP_DEF = "adaptorCapDef"
    SORT_CLASS_ADAPTOR_CAP_QUAL = "adaptorCapQual"
    SORT_CLASS_ADAPTOR_CAP_SPEC = "adaptorCapSpec"
    SORT_CLASS_ADAPTOR_ETH_ADV_FILTER_PROFILE = "adaptorEthAdvFilterProfile"
    SORT_CLASS_ADAPTOR_ETH_ARFS_PROFILE = "adaptorEthArfsProfile"
    SORT_CLASS_ADAPTOR_ETH_COMP_QUEUE_PROFILE = "adaptorEthCompQueueProfile"
    SORT_CLASS_ADAPTOR_ETH_FAILOVER_PROFILE = "adaptorEthFailoverProfile"
    SORT_CLASS_ADAPTOR_ETH_GENEVEPROFILE = "adaptorEthGENEVEProfile"
    SORT_CLASS_ADAPTOR_ETH_INTERRUPT_PROFILE = "adaptorEthInterruptProfile"
    SORT_CLASS_ADAPTOR_ETH_INTERRUPT_SCALING_PROFILE = "adaptorEthInterruptScalingProfile"
    SORT_CLASS_ADAPTOR_ETH_NVGREPROFILE = "adaptorEthNVGREProfile"
    SORT_CLASS_ADAPTOR_ETH_OFFLOAD_PROFILE = "adaptorEthOffloadProfile"
    SORT_CLASS_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS = "adaptorEthPortBySizeLargeStats"
    SORT_CLASS_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST = "adaptorEthPortBySizeLargeStatsHist"
    SORT_CLASS_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS = "adaptorEthPortBySizeSmallStats"
    SORT_CLASS_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST = "adaptorEthPortBySizeSmallStatsHist"
    SORT_CLASS_ADAPTOR_ETH_PORT_ERR_STATS = "adaptorEthPortErrStats"
    SORT_CLASS_ADAPTOR_ETH_PORT_ERR_STATS_HIST = "adaptorEthPortErrStatsHist"
    SORT_CLASS_ADAPTOR_ETH_PORT_MCAST_STATS = "adaptorEthPortMcastStats"
    SORT_CLASS_ADAPTOR_ETH_PORT_MCAST_STATS_HIST = "adaptorEthPortMcastStatsHist"
    SORT_CLASS_ADAPTOR_ETH_PORT_OUTSIZED_STATS = "adaptorEthPortOutsizedStats"
    SORT_CLASS_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST = "adaptorEthPortOutsizedStatsHist"
    SORT_CLASS_ADAPTOR_ETH_PORT_STATS = "adaptorEthPortStats"
    SORT_CLASS_ADAPTOR_ETH_PORT_STATS_HIST = "adaptorEthPortStatsHist"
    SORT_CLASS_ADAPTOR_ETH_QUEUE_PROFILE = "adaptorEthQueueProfile"
    SORT_CLASS_ADAPTOR_ETH_RECV_QUEUE_PROFILE = "adaptorEthRecvQueueProfile"
    SORT_CLASS_ADAPTOR_ETH_RO_CEPROFILE = "adaptorEthRoCEProfile"
    SORT_CLASS_ADAPTOR_ETH_VX_LANPROFILE = "adaptorEthVxLANProfile"
    SORT_CLASS_ADAPTOR_ETH_WORK_QUEUE_PROFILE = "adaptorEthWorkQueueProfile"
    SORT_CLASS_ADAPTOR_ETHER_IF_STATS = "adaptorEtherIfStats"
    SORT_CLASS_ADAPTOR_ETHER_IF_STATS_HIST = "adaptorEtherIfStatsHist"
    SORT_CLASS_ADAPTOR_EXT_ETH_IF = "adaptorExtEthIf"
    SORT_CLASS_ADAPTOR_EXT_ETH_IF_OPERATION = "adaptorExtEthIfOperation"
    SORT_CLASS_ADAPTOR_EXT_IF = "adaptorExtIf"
    SORT_CLASS_ADAPTOR_EXT_IP_V6_RSS_HASH_PROFILE = "adaptorExtIpV6RssHashProfile"
    SORT_CLASS_ADAPTOR_FC_CDB_WORK_QUEUE_PROFILE = "adaptorFcCdbWorkQueueProfile"
    SORT_CLASS_ADAPTOR_FC_ERROR_RECOVERY_PROFILE = "adaptorFcErrorRecoveryProfile"
    SORT_CLASS_ADAPTOR_FC_FNIC_PROFILE = "adaptorFcFnicProfile"
    SORT_CLASS_ADAPTOR_FC_IF_EVENT_STATS = "adaptorFcIfEventStats"
    SORT_CLASS_ADAPTOR_FC_IF_EVENT_STATS_HIST = "adaptorFcIfEventStatsHist"
    SORT_CLASS_ADAPTOR_FC_IF_FC4_STATS = "adaptorFcIfFC4Stats"
    SORT_CLASS_ADAPTOR_FC_IF_FC4_STATS_HIST = "adaptorFcIfFC4StatsHist"
    SORT_CLASS_ADAPTOR_FC_IF_FRAME_STATS = "adaptorFcIfFrameStats"
    SORT_CLASS_ADAPTOR_FC_IF_FRAME_STATS_HIST = "adaptorFcIfFrameStatsHist"
    SORT_CLASS_ADAPTOR_FC_INTERRUPT_PROFILE = "adaptorFcInterruptProfile"
    SORT_CLASS_ADAPTOR_FC_LOGI_PROFILE = "adaptorFcLogiProfile"
    SORT_CLASS_ADAPTOR_FC_PORT_FLOGI_PROFILE = "adaptorFcPortFLogiProfile"
    SORT_CLASS_ADAPTOR_FC_PORT_PLOGI_PROFILE = "adaptorFcPortPLogiProfile"
    SORT_CLASS_ADAPTOR_FC_PORT_PROFILE = "adaptorFcPortProfile"
    SORT_CLASS_ADAPTOR_FC_PORT_STATS = "adaptorFcPortStats"
    SORT_CLASS_ADAPTOR_FC_PORT_STATS_HIST = "adaptorFcPortStatsHist"
    SORT_CLASS_ADAPTOR_FC_QUEUE_PROFILE = "adaptorFcQueueProfile"
    SORT_CLASS_ADAPTOR_FC_RECV_QUEUE_PROFILE = "adaptorFcRecvQueueProfile"
    SORT_CLASS_ADAPTOR_FC_WORK_QUEUE_PROFILE = "adaptorFcWorkQueueProfile"
    SORT_CLASS_ADAPTOR_FRU_CAP_PROVIDER = "adaptorFruCapProvider"
    SORT_CLASS_ADAPTOR_HBAVNIC_STATS = "adaptorHBAVnicStats"
    SORT_CLASS_ADAPTOR_HBAVNIC_STATS_HIST = "adaptorHBAVnicStatsHist"
    SORT_CLASS_ADAPTOR_HOST_ETH_IF = "adaptorHostEthIf"
    SORT_CLASS_ADAPTOR_HOST_ETH_IF_OPERATION = "adaptorHostEthIfOperation"
    SORT_CLASS_ADAPTOR_HOST_ETH_IF_PROFILE = "adaptorHostEthIfProfile"
    SORT_CLASS_ADAPTOR_HOST_FC_IF = "adaptorHostFcIf"
    SORT_CLASS_ADAPTOR_HOST_FC_IF_OPERATION = "adaptorHostFcIfOperation"
    SORT_CLASS_ADAPTOR_HOST_FC_IF_PROFILE = "adaptorHostFcIfProfile"
    SORT_CLASS_ADAPTOR_HOST_IF = "adaptorHostIf"
    SORT_CLASS_ADAPTOR_HOST_IF_CONFIG = "adaptorHostIfConfig"
    SORT_CLASS_ADAPTOR_HOST_IF_CONN_DEF = "adaptorHostIfConnDef"
    SORT_CLASS_ADAPTOR_HOST_IF_PROFILE = "adaptorHostIfProfile"
    SORT_CLASS_ADAPTOR_HOST_ISCSI_IF = "adaptorHostIscsiIf"
    SORT_CLASS_ADAPTOR_HOST_ISCSI_IF_OPERATION = "adaptorHostIscsiIfOperation"
    SORT_CLASS_ADAPTOR_HOST_ISCSI_IF_PROFILE = "adaptorHostIscsiIfProfile"
    SORT_CLASS_ADAPTOR_HOST_SCSI_IF = "adaptorHostScsiIf"
    SORT_CLASS_ADAPTOR_HOST_SCSI_LUN_REF = "adaptorHostScsiLunRef"
    SORT_CLASS_ADAPTOR_HW_ADDR_CAP = "adaptorHwAddrCap"
    SORT_CLASS_ADAPTOR_ISCSI_CAP = "adaptorIScsiCap"
    SORT_CLASS_ADAPTOR_IP_V4_RSS_HASH_PROFILE = "adaptorIpV4RssHashProfile"
    SORT_CLASS_ADAPTOR_IP_V6_RSS_HASH_PROFILE = "adaptorIpV6RssHashProfile"
    SORT_CLASS_ADAPTOR_MENLO_BASE_ERROR_STATS = "adaptorMenloBaseErrorStats"
    SORT_CLASS_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST = "adaptorMenloBaseErrorStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_DCE_PORT_STATS = "adaptorMenloDcePortStats"
    SORT_CLASS_ADAPTOR_MENLO_DCE_PORT_STATS_HIST = "adaptorMenloDcePortStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_ETH_ERROR_STATS = "adaptorMenloEthErrorStats"
    SORT_CLASS_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST = "adaptorMenloEthErrorStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_ETH_STATS = "adaptorMenloEthStats"
    SORT_CLASS_ADAPTOR_MENLO_ETH_STATS_HIST = "adaptorMenloEthStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_FC_ERROR_STATS = "adaptorMenloFcErrorStats"
    SORT_CLASS_ADAPTOR_MENLO_FC_ERROR_STATS_HIST = "adaptorMenloFcErrorStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_FC_STATS = "adaptorMenloFcStats"
    SORT_CLASS_ADAPTOR_MENLO_FC_STATS_HIST = "adaptorMenloFcStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_HOST_PORT_STATS = "adaptorMenloHostPortStats"
    SORT_CLASS_ADAPTOR_MENLO_HOST_PORT_STATS_HIST = "adaptorMenloHostPortStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_MCPU_ERROR_STATS = "adaptorMenloMcpuErrorStats"
    SORT_CLASS_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST = "adaptorMenloMcpuErrorStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_MCPU_STATS = "adaptorMenloMcpuStats"
    SORT_CLASS_ADAPTOR_MENLO_MCPU_STATS_HIST = "adaptorMenloMcpuStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_NET_EG_STATS = "adaptorMenloNetEgStats"
    SORT_CLASS_ADAPTOR_MENLO_NET_EG_STATS_HIST = "adaptorMenloNetEgStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_NET_IN_STATS = "adaptorMenloNetInStats"
    SORT_CLASS_ADAPTOR_MENLO_NET_IN_STATS_HIST = "adaptorMenloNetInStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_QERROR_STATS = "adaptorMenloQErrorStats"
    SORT_CLASS_ADAPTOR_MENLO_QERROR_STATS_HIST = "adaptorMenloQErrorStatsHist"
    SORT_CLASS_ADAPTOR_MENLO_QSTATS = "adaptorMenloQStats"
    SORT_CLASS_ADAPTOR_MENLO_QSTATS_HIST = "adaptorMenloQStatsHist"
    SORT_CLASS_ADAPTOR_NICVNIC_STATS = "adaptorNICVnicStats"
    SORT_CLASS_ADAPTOR_NICVNIC_STATS_HIST = "adaptorNICVnicStatsHist"
    SORT_CLASS_ADAPTOR_PROFILE_ITEM = "adaptorProfileItem"
    SORT_CLASS_ADAPTOR_PROTOCOL_PROFILE = "adaptorProtocolProfile"
    SORT_CLASS_ADAPTOR_QUAL = "adaptorQual"
    SORT_CLASS_ADAPTOR_QUEUE_PROFILE = "adaptorQueueProfile"
    SORT_CLASS_ADAPTOR_RNIC_CAP_SPEC = "adaptorRnicCapSpec"
    SORT_CLASS_ADAPTOR_RSS_HASH_PROFILE = "adaptorRssHashProfile"
    SORT_CLASS_ADAPTOR_RSS_PROFILE = "adaptorRssProfile"
    SORT_CLASS_ADAPTOR_TCP_IP_RSS_HASH_PROFILE = "adaptorTcpIpRssHashProfile"
    SORT_CLASS_ADAPTOR_UNIT = "adaptorUnit"
    SORT_CLASS_ADAPTOR_UNIT_ASSOC_CTX = "adaptorUnitAssocCtx"
    SORT_CLASS_ADAPTOR_UNIT_EXTN = "adaptorUnitExtn"
    SORT_CLASS_ADAPTOR_USNIC_CONN_DEF = "adaptorUsnicConnDef"
    SORT_CLASS_ADAPTOR_VLAN = "adaptorVlan"
    SORT_CLASS_ADAPTOR_VMMQ_CONN_DEF = "adaptorVmmqConnDef"
    SORT_CLASS_ADAPTOR_VNIC_STATS = "adaptorVnicStats"
    SORT_CLASS_ADAPTOR_VNIC_STATS_HIST = "adaptorVnicStatsHist"
    SORT_CLASS_BIOS_BOT = "biosBOT"
    SORT_CLASS_BIOS_BOOT_DEV = "biosBootDev"
    SORT_CLASS_BIOS_BOOT_DEV_GRP = "biosBootDevGrp"
    SORT_CLASS_BIOS_TOKEN_FEATURE_GROUP = "biosTokenFeatureGroup"
    SORT_CLASS_BIOS_TOKEN_PARAM = "biosTokenParam"
    SORT_CLASS_BIOS_TOKEN_SETTINGS = "biosTokenSettings"
    SORT_CLASS_BIOS_UNIT = "biosUnit"
    SORT_CLASS_BIOS_VFEAT = "biosVFeat"
    SORT_CLASS_BIOS_VPROFILE = "biosVProfile"
    SORT_CLASS_BIOS_VF_ACPI10_SUPPORT = "biosVfACPI10Support"
    SORT_CLASS_BIOS_VF_ASPMSUPPORT = "biosVfASPMSupport"
    SORT_CLASS_BIOS_VF_ALL_USBDEVICES = "biosVfAllUSBDevices"
    SORT_CLASS_BIOS_VF_ALTITUDE = "biosVfAltitude"
    SORT_CLASS_BIOS_VF_ASSERT_NMION_PERR = "biosVfAssertNMIOnPERR"
    SORT_CLASS_BIOS_VF_ASSERT_NMION_SERR = "biosVfAssertNMIOnSERR"
    SORT_CLASS_BIOS_VF_BOOT_OPTION_RETRY = "biosVfBootOptionRetry"
    SORT_CLASS_BIOS_VF_CPUHARDWARE_POWER_MANAGEMENT = "biosVfCPUHardwarePowerManagement"
    SORT_CLASS_BIOS_VF_CPUPERFORMANCE = "biosVfCPUPerformance"
    SORT_CLASS_BIOS_VF_CPUPOWER_MANAGEMENT = "biosVfCPUPowerManagement"
    SORT_CLASS_BIOS_VF_CONSISTENT_DEVICE_NAME_CONTROL = "biosVfConsistentDeviceNameControl"
    SORT_CLASS_BIOS_VF_CONSOLE_REDIRECTION = "biosVfConsoleRedirection"
    SORT_CLASS_BIOS_VF_CORE_MULTI_PROCESSING = "biosVfCoreMultiProcessing"
    SORT_CLASS_BIOS_VF_DDR3_VOLTAGE_SELECTION = "biosVfDDR3VoltageSelection"
    SORT_CLASS_BIOS_VF_DRAMCLOCK_THROTTLING = "biosVfDRAMClockThrottling"
    SORT_CLASS_BIOS_VF_DIRECT_CACHE_ACCESS = "biosVfDirectCacheAccess"
    SORT_CLASS_BIOS_VF_DRAM_REFRESH_RATE = "biosVfDramRefreshRate"
    SORT_CLASS_BIOS_VF_ENERGY_PERFORMANCE_TUNING = "biosVfEnergyPerformanceTuning"
    SORT_CLASS_BIOS_VF_ENHANCED_INTEL_SPEED_STEP_TECH = "biosVfEnhancedIntelSpeedStepTech"
    SORT_CLASS_BIOS_VF_ENHANCED_POWER_CAPPING_SUPPORT = "biosVfEnhancedPowerCappingSupport"
    SORT_CLASS_BIOS_VF_EXECUTE_DISABLE_BIT = "biosVfExecuteDisableBit"
    SORT_CLASS_BIOS_VF_FRB2_TIMER = "biosVfFRB2Timer"
    SORT_CLASS_BIOS_VF_FREQUENCY_FLOOR_OVERRIDE = "biosVfFrequencyFloorOverride"
    SORT_CLASS_BIOS_VF_FRONT_PANEL_LOCKOUT = "biosVfFrontPanelLockout"
    SORT_CLASS_BIOS_VF_IOEMEZZ1_OPTION_ROM = "biosVfIOEMezz1OptionROM"
    SORT_CLASS_BIOS_VF_IOENVME1_OPTION_ROM = "biosVfIOENVMe1OptionROM"
    SORT_CLASS_BIOS_VF_IOENVME2_OPTION_ROM = "biosVfIOENVMe2OptionROM"
    SORT_CLASS_BIOS_VF_IOESLOT1_OPTION_ROM = "biosVfIOESlot1OptionROM"
    SORT_CLASS_BIOS_VF_IOESLOT2_OPTION_ROM = "biosVfIOESlot2OptionROM"
    SORT_CLASS_BIOS_VF_INTEGRATED_GRAPHICS = "biosVfIntegratedGraphics"
    SORT_CLASS_BIOS_VF_INTEGRATED_GRAPHICS_APERTURE_SIZE = "biosVfIntegratedGraphicsApertureSize"
    SORT_CLASS_BIOS_VF_INTEL_ENTRY_SASRAIDMODULE = "biosVfIntelEntrySASRAIDModule"
    SORT_CLASS_BIOS_VF_INTEL_HYPER_THREADING_TECH = "biosVfIntelHyperThreadingTech"
    SORT_CLASS_BIOS_VF_INTEL_TRUSTED_EXECUTION_TECHNOLOGY = "biosVfIntelTrustedExecutionTechnology"
    SORT_CLASS_BIOS_VF_INTEL_TURBO_BOOST_TECH = "biosVfIntelTurboBoostTech"
    SORT_CLASS_BIOS_VF_INTEL_VTFOR_DIRECTED_IO = "biosVfIntelVTForDirectedIO"
    SORT_CLASS_BIOS_VF_INTEL_VIRTUALIZATION_TECHNOLOGY = "biosVfIntelVirtualizationTechnology"
    SORT_CLASS_BIOS_VF_INTERLEAVE_CONFIGURATION = "biosVfInterleaveConfiguration"
    SORT_CLASS_BIOS_VF_LOCAL_X2_APIC = "biosVfLocalX2Apic"
    SORT_CLASS_BIOS_VF_LV_DIMMSUPPORT = "biosVfLvDIMMSupport"
    SORT_CLASS_BIOS_VF_MAX_VARIABLE_MTRRSETTING = "biosVfMaxVariableMTRRSetting"
    SORT_CLASS_BIOS_VF_MAXIMUM_MEMORY_BELOW4_GB = "biosVfMaximumMemoryBelow4GB"
    SORT_CLASS_BIOS_VF_MEMORY_MAPPED_IOABOVE4_GB = "biosVfMemoryMappedIOAbove4GB"
    SORT_CLASS_BIOS_VF_MIRRORING_MODE = "biosVfMirroringMode"
    SORT_CLASS_BIOS_VF_NUMAOPTIMIZED = "biosVfNUMAOptimized"
    SORT_CLASS_BIOS_VF_OSBOOT_WATCHDOG_TIMER = "biosVfOSBootWatchdogTimer"
    SORT_CLASS_BIOS_VF_OSBOOT_WATCHDOG_TIMER_POLICY = "biosVfOSBootWatchdogTimerPolicy"
    SORT_CLASS_BIOS_VF_OSBOOT_WATCHDOG_TIMER_TIMEOUT = "biosVfOSBootWatchdogTimerTimeout"
    SORT_CLASS_BIOS_VF_ONBOARD_GRAPHICS = "biosVfOnboardGraphics"
    SORT_CLASS_BIOS_VF_ONBOARD_SATACONTROLLER = "biosVfOnboardSATAController"
    SORT_CLASS_BIOS_VF_ONBOARD_STORAGE = "biosVfOnboardStorage"
    SORT_CLASS_BIOS_VF_OPTION_ROMENABLE = "biosVfOptionROMEnable"
    SORT_CLASS_BIOS_VF_OPTION_ROMLOAD = "biosVfOptionROMLoad"
    SORT_CLASS_BIOS_VF_OUT_OF_BAND_MANAGEMENT = "biosVfOutOfBandManagement"
    SORT_CLASS_BIOS_VF_PCHSATAMODE = "biosVfPCHSATAMode"
    SORT_CLASS_BIOS_VF_PCILOMPORTS_CONFIGURATION = "biosVfPCILOMPortsConfiguration"
    SORT_CLASS_BIOS_VF_PCIROMCLP = "biosVfPCIROMCLP"
    SORT_CLASS_BIOS_VF_PCISLOT_LINK_SPEED = "biosVfPCISlotLinkSpeed"
    SORT_CLASS_BIOS_VF_PCISLOT_OPTION_ROMENABLE = "biosVfPCISlotOptionROMEnable"
    SORT_CLASS_BIOS_VF_POSTERROR_PAUSE = "biosVfPOSTErrorPause"
    SORT_CLASS_BIOS_VF_PSTATECOORDINATION = "biosVfPSTATECoordination"
    SORT_CLASS_BIOS_VF_PACKAGE_CSTATE_LIMIT = "biosVfPackageCStateLimit"
    SORT_CLASS_BIOS_VF_PROCESSOR_C1_E = "biosVfProcessorC1E"
    SORT_CLASS_BIOS_VF_PROCESSOR_C3_REPORT = "biosVfProcessorC3Report"
    SORT_CLASS_BIOS_VF_PROCESSOR_C6_REPORT = "biosVfProcessorC6Report"
    SORT_CLASS_BIOS_VF_PROCESSOR_C7_REPORT = "biosVfProcessorC7Report"
    SORT_CLASS_BIOS_VF_PROCESSOR_CMCI = "biosVfProcessorCMCI"
    SORT_CLASS_BIOS_VF_PROCESSOR_CSTATE = "biosVfProcessorCState"
    SORT_CLASS_BIOS_VF_PROCESSOR_ENERGY_CONFIGURATION = "biosVfProcessorEnergyConfiguration"
    SORT_CLASS_BIOS_VF_PROCESSOR_PREFETCH_CONFIG = "biosVfProcessorPrefetchConfig"
    SORT_CLASS_BIOS_VF_QPILINK_FREQUENCY_SELECT = "biosVfQPILinkFrequencySelect"
    SORT_CLASS_BIOS_VF_QPISNOOP_MODE = "biosVfQPISnoopMode"
    SORT_CLASS_BIOS_VF_QUIET_BOOT = "biosVfQuietBoot"
    SORT_CLASS_BIOS_VF_REDIRECTION_AFTER_BIOSPOST = "biosVfRedirectionAfterBIOSPOST"
    SORT_CLASS_BIOS_VF_RESUME_ON_ACPOWER_LOSS = "biosVfResumeOnACPowerLoss"
    SORT_CLASS_BIOS_VF_SBMEZZ1_OPTION_ROM = "biosVfSBMezz1OptionROM"
    SORT_CLASS_BIOS_VF_SBNVME1_OPTION_ROM = "biosVfSBNVMe1OptionROM"
    SORT_CLASS_BIOS_VF_SIOC1_OPTION_ROM = "biosVfSIOC1OptionROM"
    SORT_CLASS_BIOS_VF_SIOC2_OPTION_ROM = "biosVfSIOC2OptionROM"
    SORT_CLASS_BIOS_VF_SCRUB_POLICIES = "biosVfScrubPolicies"
    SORT_CLASS_BIOS_VF_SELECT_MEMORY_RASCONFIGURATION = "biosVfSelectMemoryRASConfiguration"
    SORT_CLASS_BIOS_VF_SERIAL_PORT_AENABLE = "biosVfSerialPortAEnable"
    SORT_CLASS_BIOS_VF_SPARING_MODE = "biosVfSparingMode"
    SORT_CLASS_BIOS_VF_SRIOV_CONFIG = "biosVfSriovConfig"
    SORT_CLASS_BIOS_VF_TPMPENDING_OPERATION = "biosVfTPMPendingOperation"
    SORT_CLASS_BIOS_VF_TPMSUPPORT = "biosVfTPMSupport"
    SORT_CLASS_BIOS_VF_TRUSTED_PLATFORM_MODULE = "biosVfTrustedPlatformModule"
    SORT_CLASS_BIOS_VF_UCSMBOOT_MODE_CONTROL = "biosVfUCSMBootModeControl"
    SORT_CLASS_BIOS_VF_UCSMBOOT_ORDER_RULE_CONTROL = "biosVfUCSMBootOrderRuleControl"
    SORT_CLASS_BIOS_VF_UEFIOSUSE_LEGACY_VIDEO = "biosVfUEFIOSUseLegacyVideo"
    SORT_CLASS_BIOS_VF_USBBOOT_CONFIG = "biosVfUSBBootConfig"
    SORT_CLASS_BIOS_VF_USBCONFIGURATION = "biosVfUSBConfiguration"
    SORT_CLASS_BIOS_VF_USBFRONT_PANEL_ACCESS_LOCK = "biosVfUSBFrontPanelAccessLock"
    SORT_CLASS_BIOS_VF_USBPORT_CONFIGURATION = "biosVfUSBPortConfiguration"
    SORT_CLASS_BIOS_VF_USBSYSTEM_IDLE_POWER_OPTIMIZING_SETTING = "biosVfUSBSystemIdlePowerOptimizingSetting"
    SORT_CLASS_BIOS_VF_VGAPRIORITY = "biosVfVGAPriority"
    SORT_CLASS_BIOS_VF_WORKLOAD_CONFIGURATION = "biosVfWorkloadConfiguration"
    SORT_CLASS_CALLHOME_DEST = "callhomeDest"
    SORT_CLASS_CALLHOME_EP = "callhomeEp"
    SORT_CLASS_CALLHOME_FAULT_INST = "callhomeFaultInst"
    SORT_CLASS_CALLHOME_HOLDER = "callhomeHolder"
    SORT_CLASS_CALLHOME_HOLDER_FSM = "callhomeHolderFsm"
    SORT_CLASS_CALLHOME_HOLDER_FSM_STAGE = "callhomeHolderFsmStage"
    SORT_CLASS_CALLHOME_HOLDER_FSM_TASK = "callhomeHolderFsmTask"
    SORT_CLASS_CALLHOME_HTTP = "callhomeHttp"
    SORT_CLASS_CALLHOME_ITEM = "callhomeItem"
    SORT_CLASS_CALLHOME_PERIODIC_SYSTEM_INVENTORY = "callhomePeriodicSystemInventory"
    SORT_CLASS_CALLHOME_POLICY = "callhomePolicy"
    SORT_CLASS_CALLHOME_PROFILE = "callhomeProfile"
    SORT_CLASS_CALLHOME_SMTP = "callhomeSmtp"
    SORT_CLASS_CALLHOME_SOURCE = "callhomeSource"
    SORT_CLASS_CALLHOME_TEST_ALERT = "callhomeTestAlert"
    SORT_CLASS_CAPABILITY_CATALOGUE = "capabilityCatalogue"
    SORT_CLASS_CAPABILITY_DEF = "capabilityDef"
    SORT_CLASS_CAPABILITY_ITEM = "capabilityItem"
    SORT_CLASS_CAPABILITY_PROVIDER = "capabilityProvider"
    SORT_CLASS_CERT_REPAIR_EP = "certRepairEp"
    SORT_CLASS_CERT_REPAIR_EP_FSM = "certRepairEpFsm"
    SORT_CLASS_CERT_REPAIR_EP_FSM_STAGE = "certRepairEpFsmStage"
    SORT_CLASS_CERT_REPAIR_EP_FSM_TASK = "certRepairEpFsmTask"
    SORT_CLASS_CHANGE_CHANGED_OBJECT_REF = "changeChangedObjectRef"
    SORT_CLASS_CHANGE_EP = "changeEp"
    SORT_CLASS_CHANGE_EP_FSM = "changeEpFsm"
    SORT_CLASS_CHANGE_EP_FSM_STAGE = "changeEpFsmStage"
    SORT_CLASS_CHANGE_EP_FSM_TASK = "changeEpFsmTask"
    SORT_CLASS_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY = "cimcvmediaActualMountEntry"
    SORT_CLASS_CIMCVMEDIA_ACTUAL_MOUNT_LIST = "cimcvmediaActualMountList"
    SORT_CLASS_CIMCVMEDIA_CONFIG_MOUNT_ENTRY = "cimcvmediaConfigMountEntry"
    SORT_CLASS_CIMCVMEDIA_EXT_MGMT_RULE_ENTRY = "cimcvmediaExtMgmtRuleEntry"
    SORT_CLASS_CIMCVMEDIA_ITEM = "cimcvmediaItem"
    SORT_CLASS_CIMCVMEDIA_MOUNT_CONFIG = "cimcvmediaMountConfig"
    SORT_CLASS_CIMCVMEDIA_MOUNT_CONFIG_DEF = "cimcvmediaMountConfigDef"
    SORT_CLASS_CIMCVMEDIA_MOUNT_CONFIG_POLICY = "cimcvmediaMountConfigPolicy"
    SORT_CLASS_CIMCVMEDIA_MOUNT_INFO = "cimcvmediaMountInfo"
    SORT_CLASS_CLITEST_TYPE_TEST = "clitestTypeTest"
    SORT_CLASS_CLITEST_TYPE_TEST2 = "clitestTypeTest2"
    SORT_CLASS_CLITEST_TYPE_TEST_CHILD = "clitestTypeTestChild"
    SORT_CLASS_CLITEST_TYPE_TEST_PARENT = "clitestTypeTestParent"
    SORT_CLASS_COMM_CIMXML = "commCimxml"
    SORT_CLASS_COMM_CLIENT = "commClient"
    SORT_CLASS_COMM_CLIENT_ITEM = "commClientItem"
    SORT_CLASS_COMM_CORE_FILE = "commCoreFile"
    SORT_CLASS_COMM_DATE_TIME = "commDateTime"
    SORT_CLASS_COMM_DATE_TIME_FSM = "commDateTimeFsm"
    SORT_CLASS_COMM_DATE_TIME_FSM_STAGE = "commDateTimeFsmStage"
    SORT_CLASS_COMM_DATE_TIME_FSM_TASK = "commDateTimeFsmTask"
    SORT_CLASS_COMM_DEFINITION = "commDefinition"
    SORT_CLASS_COMM_DNS = "commDns"
    SORT_CLASS_COMM_DNS_PROVIDER = "commDnsProvider"
    SORT_CLASS_COMM_EVT_CHANNEL = "commEvtChannel"
    SORT_CLASS_COMM_HTTP = "commHttp"
    SORT_CLASS_COMM_HTTPS = "commHttps"
    SORT_CLASS_COMM_ITEM = "commItem"
    SORT_CLASS_COMM_LOCALE = "commLocale"
    SORT_CLASS_COMM_LOG_COMPONENT = "commLogComponent"
    SORT_CLASS_COMM_NTP = "commNtp"
    SORT_CLASS_COMM_NTP_PROVIDER = "commNtpProvider"
    SORT_CLASS_COMM_SHELL = "commShell"
    SORT_CLASS_COMM_SHELL_SVC_LIMITS = "commShellSvcLimits"
    SORT_CLASS_COMM_SMASH_CLP = "commSmashCLP"
    SORT_CLASS_COMM_SNMP = "commSnmp"
    SORT_CLASS_COMM_SNMP_COMMUNITY = "commSnmpCommunity"
    SORT_CLASS_COMM_SNMP_TRAP = "commSnmpTrap"
    SORT_CLASS_COMM_SNMP_TRAP_DATA = "commSnmpTrapData"
    SORT_CLASS_COMM_SNMP_USER = "commSnmpUser"
    SORT_CLASS_COMM_SSH = "commSsh"
    SORT_CLASS_COMM_SVC = "commSvc"
    SORT_CLASS_COMM_SVC_CHANNEL = "commSvcChannel"
    SORT_CLASS_COMM_SVC_EP = "commSvcEp"
    SORT_CLASS_COMM_SVC_EP_FSM = "commSvcEpFsm"
    SORT_CLASS_COMM_SVC_EP_FSM_STAGE = "commSvcEpFsmStage"
    SORT_CLASS_COMM_SVC_EP_FSM_TASK = "commSvcEpFsmTask"
    SORT_CLASS_COMM_SVC_LIMITS = "commSvcLimits"
    SORT_CLASS_COMM_SVC_POLICY = "commSvcPolicy"
    SORT_CLASS_COMM_SYSLOG = "commSyslog"
    SORT_CLASS_COMM_SYSLOG_CLIENT = "commSyslogClient"
    SORT_CLASS_COMM_SYSLOG_CONSOLE = "commSyslogConsole"
    SORT_CLASS_COMM_SYSLOG_FILE = "commSyslogFile"
    SORT_CLASS_COMM_SYSLOG_MONITOR = "commSyslogMonitor"
    SORT_CLASS_COMM_SYSLOG_SOURCE = "commSyslogSource"
    SORT_CLASS_COMM_TELNET = "commTelnet"
    SORT_CLASS_COMM_WEB = "commWeb"
    SORT_CLASS_COMM_WEB_CHANNEL = "commWebChannel"
    SORT_CLASS_COMM_WEB_SVC_LIMITS = "commWebSvcLimits"
    SORT_CLASS_COMM_WSMAN = "commWsman"
    SORT_CLASS_COMM_XML_CL_CONN_POLICY = "commXmlClConnPolicy"
    SORT_CLASS_COMPUTE_ABOARD = "computeABoard"
    SORT_CLASS_COMPUTE_ACHASSIS_DISC_POLICY = "computeAChassisDiscPolicy"
    SORT_CLASS_COMPUTE_AOPERATION = "computeAOperation"
    SORT_CLASS_COMPUTE_AUTOCONFIG_POLICY = "computeAutoconfigPolicy"
    SORT_CLASS_COMPUTE_BASE_SYSTEM = "computeBaseSystem"
    SORT_CLASS_COMPUTE_BLADE = "computeBlade"
    SORT_CLASS_COMPUTE_BLADE_DISC_POLICY = "computeBladeDiscPolicy"
    SORT_CLASS_COMPUTE_BLADE_EP = "computeBladeEp"
    SORT_CLASS_COMPUTE_BLADE_INHERIT_POLICY = "computeBladeInheritPolicy"
    SORT_CLASS_COMPUTE_BLADE_POS_QUAL = "computeBladePosQual"
    SORT_CLASS_COMPUTE_BOARD = "computeBoard"
    SORT_CLASS_COMPUTE_BOARD_CONNECTOR = "computeBoardConnector"
    SORT_CLASS_COMPUTE_BOARD_CONTROLLER = "computeBoardController"
    SORT_CLASS_COMPUTE_CARTRIDGE = "computeCartridge"
    SORT_CLASS_COMPUTE_CARTRIDGE_OPERATION = "computeCartridgeOperation"
    SORT_CLASS_COMPUTE_CHASSIS_CONN_POLICY = "computeChassisConnPolicy"
    SORT_CLASS_COMPUTE_CHASSIS_CONN_POLICY_OPERATION = "computeChassisConnPolicyOperation"
    SORT_CLASS_COMPUTE_CHASSIS_DISC_POLICY = "computeChassisDiscPolicy"
    SORT_CLASS_COMPUTE_CHASSIS_FEAT_MASK = "computeChassisFeatMask"
    SORT_CLASS_COMPUTE_CHASSIS_QUAL = "computeChassisQual"
    SORT_CLASS_COMPUTE_COMPUTE_DISC_POLICY = "computeComputeDiscPolicy"
    SORT_CLASS_COMPUTE_CONFIG_POLICY = "computeConfigPolicy"
    SORT_CLASS_COMPUTE_CONTAINER = "computeContainer"
    SORT_CLASS_COMPUTE_DEFINITION = "computeDefinition"
    SORT_CLASS_COMPUTE_DISC_POLICY = "computeDiscPolicy"
    SORT_CLASS_COMPUTE_DOMAIN_GROUP_QUAL = "computeDomainGroupQual"
    SORT_CLASS_COMPUTE_DOMAIN_HW_CHANGE_DISC_POLICY = "computeDomainHwChangeDiscPolicy"
    SORT_CLASS_COMPUTE_DOMAIN_NAME_QUAL = "computeDomainNameQual"
    SORT_CLASS_COMPUTE_DOMAIN_PORT_DISC_POLICY = "computeDomainPortDiscPolicy"
    SORT_CLASS_COMPUTE_DOMAIN_QUAL = "computeDomainQual"
    SORT_CLASS_COMPUTE_ENV_FEAT_MASK = "computeEnvFeatMask"
    SORT_CLASS_COMPUTE_EXT_BOARD = "computeExtBoard"
    SORT_CLASS_COMPUTE_FABRIC_ETH_MON_SRC_EP = "computeFabricEthMonSrcEp"
    SORT_CLASS_COMPUTE_FABRIC_ETH_MON_SRC_EP_CONT = "computeFabricEthMonSrcEpCont"
    SORT_CLASS_COMPUTE_FABRIC_FC_MON_SRC_EP = "computeFabricFcMonSrcEp"
    SORT_CLASS_COMPUTE_FABRIC_FC_MON_SRC_EP_CONT = "computeFabricFcMonSrcEpCont"
    SORT_CLASS_COMPUTE_FABRIC_MON_SRC_EP = "computeFabricMonSrcEp"
    SORT_CLASS_COMPUTE_FACTORY_RESET_OP = "computeFactoryResetOp"
    SORT_CLASS_COMPUTE_FACTORY_RESET_OPERATION = "computeFactoryResetOperation"
    SORT_CLASS_COMPUTE_FAULT_UPGRADE_FLAG = "computeFaultUpgradeFlag"
    SORT_CLASS_COMPUTE_FEAT_MASK = "computeFeatMask"
    SORT_CLASS_COMPUTE_GRAPHICS_CARD_POLICY = "computeGraphicsCardPolicy"
    SORT_CLASS_COMPUTE_GROUP_MEMBERSHIP = "computeGroupMembership"
    SORT_CLASS_COMPUTE_GROUP_MEMBERSHIP_REF = "computeGroupMembershipRef"
    SORT_CLASS_COMPUTE_HW_CHANGE_DISC_POLICY = "computeHwChangeDiscPolicy"
    SORT_CLASS_COMPUTE_IOHUB = "computeIOHub"
    SORT_CLASS_COMPUTE_IOHUB_ENV_STATS = "computeIOHubEnvStats"
    SORT_CLASS_COMPUTE_IOHUB_ENV_STATS_HIST = "computeIOHubEnvStatsHist"
    SORT_CLASS_COMPUTE_INIT_CONFIG_POLICY = "computeInitConfigPolicy"
    SORT_CLASS_COMPUTE_INSTANCE = "computeInstance"
    SORT_CLASS_COMPUTE_INSTANCE_ID_QUAL = "computeInstanceIdQual"
    SORT_CLASS_COMPUTE_INSTANCE_MAPPING = "computeInstanceMapping"
    SORT_CLASS_COMPUTE_ITEM = "computeItem"
    SORT_CLASS_COMPUTE_LOCAL_TEMPL_DEF = "computeLocalTemplDef"
    SORT_CLASS_COMPUTE_LOGICAL = "computeLogical"
    SORT_CLASS_COMPUTE_MB_POWER_STATS = "computeMbPowerStats"
    SORT_CLASS_COMPUTE_MB_POWER_STATS_HIST = "computeMbPowerStatsHist"
    SORT_CLASS_COMPUTE_MB_TEMP_STATS = "computeMbTempStats"
    SORT_CLASS_COMPUTE_MB_TEMP_STATS_HIST = "computeMbTempStatsHist"
    SORT_CLASS_COMPUTE_NETWORK_FEAT_MASK = "computeNetworkFeatMask"
    SORT_CLASS_COMPUTE_OWNER_QUAL = "computeOwnerQual"
    SORT_CLASS_COMPUTE_PCIE_FATAL_COMPLETION_STATS = "computePCIeFatalCompletionStats"
    SORT_CLASS_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST = "computePCIeFatalCompletionStatsHist"
    SORT_CLASS_COMPUTE_PCIE_FATAL_PROTOCOL_STATS = "computePCIeFatalProtocolStats"
    SORT_CLASS_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_HIST = "computePCIeFatalProtocolStatsHist"
    SORT_CLASS_COMPUTE_PCIE_FATAL_RECEIVE_STATS = "computePCIeFatalReceiveStats"
    SORT_CLASS_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST = "computePCIeFatalReceiveStatsHist"
    SORT_CLASS_COMPUTE_PCIE_FATAL_STATS = "computePCIeFatalStats"
    SORT_CLASS_COMPUTE_PCIE_FATAL_STATS_HIST = "computePCIeFatalStatsHist"
    SORT_CLASS_COMPUTE_PHYSICAL = "computePhysical"
    SORT_CLASS_COMPUTE_PHYSICAL_ASSOC_CTX = "computePhysicalAssocCtx"
    SORT_CLASS_COMPUTE_PHYSICAL_EXTENSION = "computePhysicalExtension"
    SORT_CLASS_COMPUTE_PHYSICAL_OPERATION = "computePhysicalOperation"
    SORT_CLASS_COMPUTE_PHYSICAL_QUAL = "computePhysicalQual"
    SORT_CLASS_COMPUTE_PLACEABLE = "computePlaceable"
    SORT_CLASS_COMPUTE_PLACED = "computePlaced"
    SORT_CLASS_COMPUTE_POOL = "computePool"
    SORT_CLASS_COMPUTE_POOL_POLICY_REF = "computePoolPolicyRef"
    SORT_CLASS_COMPUTE_POOLABLE = "computePoolable"
    SORT_CLASS_COMPUTE_POOLED = "computePooled"
    SORT_CLASS_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT = "computePooledEnclosureComputeSlot"
    SORT_CLASS_COMPUTE_POOLED_PHYSICAL = "computePooledPhysical"
    SORT_CLASS_COMPUTE_POOLED_RACK_UNIT = "computePooledRackUnit"
    SORT_CLASS_COMPUTE_POOLED_SLOT = "computePooledSlot"
    SORT_CLASS_COMPUTE_POOLING_POLICY = "computePoolingPolicy"
    SORT_CLASS_COMPUTE_PORT_DISC_POLICY = "computePortDiscPolicy"
    SORT_CLASS_COMPUTE_POWER_SYNC_DEF = "computePowerSyncDef"
    SORT_CLASS_COMPUTE_POWER_SYNC_POLICY = "computePowerSyncPolicy"
    SORT_CLASS_COMPUTE_PRODUCT_FAMILY_QUAL = "computeProductFamilyQual"
    SORT_CLASS_COMPUTE_PROFILE = "computeProfile"
    SORT_CLASS_COMPUTE_PSU_DEF = "computePsuDef"
    SORT_CLASS_COMPUTE_PSU_POLICY = "computePsuPolicy"
    SORT_CLASS_COMPUTE_QUAL = "computeQual"
    SORT_CLASS_COMPUTE_QUAL_BASE = "computeQualBase"
    SORT_CLASS_COMPUTE_QUAL_ITEM = "computeQualItem"
    SORT_CLASS_COMPUTE_QUALIFIED_POLICY = "computeQualifiedPolicy"
    SORT_CLASS_COMPUTE_RACK_POS_QUAL = "computeRackPosQual"
    SORT_CLASS_COMPUTE_RACK_QUAL = "computeRackQual"
    SORT_CLASS_COMPUTE_RACK_UNIT = "computeRackUnit"
    SORT_CLASS_COMPUTE_RACK_UNIT_MB_TEMP_STATS = "computeRackUnitMbTempStats"
    SORT_CLASS_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST = "computeRackUnitMbTempStatsHist"
    SORT_CLASS_COMPUTE_REBOOT_LOG = "computeRebootLog"
    SORT_CLASS_COMPUTE_REMOTE_OP_STATUS = "computeRemoteOpStatus"
    SORT_CLASS_COMPUTE_REQUIREMENT = "computeRequirement"
    SORT_CLASS_COMPUTE_RESOURCE_AGGR_EP = "computeResourceAggrEp"
    SORT_CLASS_COMPUTE_RESOURCE_SET = "computeResourceSet"
    SORT_CLASS_COMPUTE_RESOURCE_SET_MANAGER = "computeResourceSetManager"
    SORT_CLASS_COMPUTE_RESOURCE_SET_MEMBER = "computeResourceSetMember"
    SORT_CLASS_COMPUTE_SCRUB_POLICY = "computeScrubPolicy"
    SORT_CLASS_COMPUTE_SERVER = "computeServer"
    SORT_CLASS_COMPUTE_SERVER_DISC_POLICY = "computeServerDiscPolicy"
    SORT_CLASS_COMPUTE_SERVER_FEAT_MASK = "computeServerFeatMask"
    SORT_CLASS_COMPUTE_SERVER_MGMT_POLICY = "computeServerMgmtPolicy"
    SORT_CLASS_COMPUTE_SERVER_UNIT = "computeServerUnit"
    SORT_CLASS_COMPUTE_SESSION = "computeSession"
    SORT_CLASS_COMPUTE_SITE_QUAL = "computeSiteQual"
    SORT_CLASS_COMPUTE_SLOT_ENTITY = "computeSlotEntity"
    SORT_CLASS_COMPUTE_SLOT_QUAL = "computeSlotQual"
    SORT_CLASS_COMPUTE_STORAGE_FEAT_MASK = "computeStorageFeatMask"
    SORT_CLASS_COMPUTE_SYSTEM = "computeSystem"
    SORT_CLASS_COMPUTE_SYSTEM_ADDR_QUAL = "computeSystemAddrQual"
    SORT_CLASS_COMPUTE_SYSTEM_FSM = "computeSystemFsm"
    SORT_CLASS_COMPUTE_SYSTEM_FSM_STAGE = "computeSystemFsmStage"
    SORT_CLASS_COMPUTE_SYSTEM_FSM_TASK = "computeSystemFsmTask"
    SORT_CLASS_COMPUTE_SYSTEM_QUAL = "computeSystemQual"
    SORT_CLASS_COMPUTE_TEMPLATE = "computeTemplate"
    SORT_CLASS_COMPUTE_TEMPLATE_MAPPING = "computeTemplateMapping"
    SORT_CLASS_COMPUTE_USER = "computeUser"
    SORT_CLASS_COMPUTE_USER_EP = "computeUserEp"
    SORT_CLASS_CONDITION_IMMUTABLE = "conditionImmutable"
    SORT_CLASS_CONDITION_INFO = "conditionInfo"
    SORT_CLASS_CONDITION_LOG = "conditionLog"
    SORT_CLASS_CONDITION_LOGGABLE = "conditionLoggable"
    SORT_CLASS_CONDITION_MULTI_INSTANCE_IMMUTABLE = "conditionMultiInstanceImmutable"
    SORT_CLASS_CONDITION_MUTABLE = "conditionMutable"
    SORT_CLASS_CONDITION_POLICY = "conditionPolicy"
    SORT_CLASS_CONDITION_REPORTABLE = "conditionReportable"
    SORT_CLASS_CONFIG_ABS_DB_CONFIG = "configAbsDbConfig"
    SORT_CLASS_CONFIG_ACK_ITEM = "configAckItem"
    SORT_CLASS_CONFIG_ADAPTOR_ITEM = "configAdaptorItem"
    SORT_CLASS_CONFIG_APP_IMPACT_RESPONSE = "configAppImpactResponse"
    SORT_CLASS_CONFIG_BACKUP = "configBackup"
    SORT_CLASS_CONFIG_BACKUP_FSM = "configBackupFsm"
    SORT_CLASS_CONFIG_BACKUP_FSM_STAGE = "configBackupFsmStage"
    SORT_CLASS_CONFIG_BACKUP_FSM_TASK = "configBackupFsmTask"
    SORT_CLASS_CONFIG_CARTRIDGE_FILTER = "configCartridgeFilter"
    SORT_CLASS_CONFIG_CARTRIDGE_ITEM = "configCartridgeItem"
    SORT_CLASS_CONFIG_CATALOGUE = "configCatalogue"
    SORT_CLASS_CONFIG_CHASSIS_FILTER = "configChassisFilter"
    SORT_CLASS_CONFIG_CHASSIS_ITEM = "configChassisItem"
    SORT_CLASS_CONFIG_COMPONENTS_FILTER = "configComponentsFilter"
    SORT_CLASS_CONFIG_CONSUMER_CATALOGUE = "configConsumerCatalogue"
    SORT_CLASS_CONFIG_CONSUMER_CATALOGUE_FSM = "configConsumerCatalogueFsm"
    SORT_CLASS_CONFIG_CONSUMER_CATALOGUE_FSM_STAGE = "configConsumerCatalogueFsmStage"
    SORT_CLASS_CONFIG_CONSUMER_CATALOGUE_FSM_TASK = "configConsumerCatalogueFsmTask"
    SORT_CLASS_CONFIG_CONTROLLER_ITEM = "configControllerItem"
    SORT_CLASS_CONFIG_CPU_INFO = "configCpuInfo"
    SORT_CLASS_CONFIG_CPU_ITEM = "configCpuItem"
    SORT_CLASS_CONFIG_CRYPTO_CARD_ITEM = "configCryptoCardItem"
    SORT_CLASS_CONFIG_DB_CONFIG = "configDbConfig"
    SORT_CLASS_CONFIG_DOMAIN_FILTER = "configDomainFilter"
    SORT_CLASS_CONFIG_DOMAIN_ITEM = "configDomainItem"
    SORT_CLASS_CONFIG_FABRIC_INTERCONNECT_FILTER = "configFabricInterconnectFilter"
    SORT_CLASS_CONFIG_FABRIC_INTERCONNECT_ITEM = "configFabricInterconnectItem"
    SORT_CLASS_CONFIG_FAN_ITEM = "configFanItem"
    SORT_CLASS_CONFIG_FEX_FILTER = "configFexFilter"
    SORT_CLASS_CONFIG_FEX_ITEM = "configFexItem"
    SORT_CLASS_CONFIG_FILTER_GROUP = "configFilterGroup"
    SORT_CLASS_CONFIG_FILTER_ITEM = "configFilterItem"
    SORT_CLASS_CONFIG_FSM = "configFsm"
    SORT_CLASS_CONFIG_FSM_STAGE = "configFsmStage"
    SORT_CLASS_CONFIG_GRAPHICS_CARD_ITEM = "configGraphicsCardItem"
    SORT_CLASS_CONFIG_IOMITEM = "configIOMItem"
    SORT_CLASS_CONFIG_IMPACT = "configImpact"
    SORT_CLASS_CONFIG_IMPACT_ANALYZER = "configImpactAnalyzer"
    SORT_CLASS_CONFIG_IMPACT_ANALYZER_EP = "configImpactAnalyzerEp"
    SORT_CLASS_CONFIG_IMPACT_RESPONSE = "configImpactResponse"
    SORT_CLASS_CONFIG_INPUT_CONFIG = "configInputConfig"
    SORT_CLASS_CONFIG_INPUT_CONFIG_SET = "configInputConfigSet"
    SORT_CLASS_CONFIG_LOCAL_DISK_ITEM = "configLocalDiskItem"
    SORT_CLASS_CONFIG_LUN_ITEM = "configLunItem"
    SORT_CLASS_CONFIG_MANAGED_EP_IMPACT_RESPONSE = "configManagedEpImpactResponse"
    SORT_CLASS_CONFIG_MEMORY_ITEM = "configMemoryItem"
    SORT_CLASS_CONFIG_MOTHERBOARD_ITEM = "configMotherboardItem"
    SORT_CLASS_CONFIG_NET_REF_ITEM = "configNetRefItem"
    SORT_CLASS_CONFIG_ORG_ITEM = "configOrgItem"
    SORT_CLASS_CONFIG_PSUITEM = "configPSUItem"
    SORT_CLASS_CONFIG_POLICY_USAGE_ITEM = "configPolicyUsageItem"
    SORT_CLASS_CONFIG_PORT_ITEM = "configPortItem"
    SORT_CLASS_CONFIG_SEARCH_OPTIONS = "configSearchOptions"
    SORT_CLASS_CONFIG_SEARCH_RESULT = "configSearchResult"
    SORT_CLASS_CONFIG_SERVER_FILTER = "configServerFilter"
    SORT_CLASS_CONFIG_SERVER_ITEM = "configServerItem"
    SORT_CLASS_CONFIG_SERVICE_PROFILE_FILTER = "configServiceProfileFilter"
    SORT_CLASS_CONFIG_SORTER = "configSorter"
    SORT_CLASS_CONFIG_SPOT_LIGHT_ITEM = "configSpotLightItem"
    SORT_CLASS_CONFIG_STORAGE_ARRAY_PROFILE_FILTER = "configStorageArrayProfileFilter"
    SORT_CLASS_CONFIG_STORAGE_BLADE_FILTER = "configStorageBladeFilter"
    SORT_CLASS_CONFIG_STORAGE_ITEM = "configStorageItem"
    SORT_CLASS_CONFIG_UCIMPACT = "configUCImpact"
    SORT_CLASS_CONSUMER_INST = "consumerInst"
    SORT_CLASS_CONSUMER_INST_FSM = "consumerInstFsm"
    SORT_CLASS_CONSUMER_INST_FSM_STAGE = "consumerInstFsmStage"
    SORT_CLASS_CONSUMER_INST_FSM_TASK = "consumerInstFsmTask"
    SORT_CLASS_CONSUMER_UNIVERSE = "consumerUniverse"
    SORT_CLASS_CONTROLLER_EP = "controllerEp"
    SORT_CLASS_CONTROLLER_EP_FSM = "controllerEpFsm"
    SORT_CLASS_CONTROLLER_EP_FSM_STAGE = "controllerEpFsmStage"
    SORT_CLASS_CONTROLLER_EP_FSM_TASK = "controllerEpFsmTask"
    SORT_CLASS_CPMAINT_ACK = "cpmaintAck"
    SORT_CLASS_CPMAINT_MAINT_POLICY = "cpmaintMaintPolicy"
    SORT_CLASS_DCX_VIF = "dcxVIf"
    SORT_CLASS_DCX_VC = "dcxVc"
    SORT_CLASS_DIAG_CTRL = "diagCtrl"
    SORT_CLASS_DIAG_LOG_EP = "diagLogEp"
    SORT_CLASS_DIAG_MEMORY_TEST = "diagMemoryTest"
    SORT_CLASS_DIAG_RSLT = "diagRslt"
    SORT_CLASS_DIAG_RUN_POLICY = "diagRunPolicy"
    SORT_CLASS_DIAG_SRV_CAP_PROVIDER = "diagSrvCapProvider"
    SORT_CLASS_DIAG_SRV_CTRL = "diagSrvCtrl"
    SORT_CLASS_DIAG_SRV_CTRL_OPERATION = "diagSrvCtrlOperation"
    SORT_CLASS_DIAG_SRV_CTRL_OPERATION_FSM = "diagSrvCtrlOperationFsm"
    SORT_CLASS_DIAG_SRV_CTRL_OPERATION_FSM_STAGE = "diagSrvCtrlOperationFsmStage"
    SORT_CLASS_DIAG_SRV_CTRL_OPERATION_FSM_TASK = "diagSrvCtrlOperationFsmTask"
    SORT_CLASS_DIAG_TEST = "diagTest"
    SORT_CLASS_DOMAIN_CHASSIS_FEATURE = "domainChassisFeature"
    SORT_CLASS_DOMAIN_CHASSIS_PARAM = "domainChassisParam"
    SORT_CLASS_DOMAIN_CHASSIS_PROFILE_ITEM = "domainChassisProfileItem"
    SORT_CLASS_DOMAIN_ENVIRONMENT_FEATURE = "domainEnvironmentFeature"
    SORT_CLASS_DOMAIN_ENVIRONMENT_PARAM = "domainEnvironmentParam"
    SORT_CLASS_DOMAIN_EP = "domainEp"
    SORT_CLASS_DOMAIN_FAMILY_CAP_PROVIDER = "domainFamilyCapProvider"
    SORT_CLASS_DOMAIN_FEATURE = "domainFeature"
    SORT_CLASS_DOMAIN_FEATURE_CATALOG = "domainFeatureCatalog"
    SORT_CLASS_DOMAIN_NETWORK_FEATURE = "domainNetworkFeature"
    SORT_CLASS_DOMAIN_NETWORK_PARAM = "domainNetworkParam"
    SORT_CLASS_DOMAIN_PARAMETER = "domainParameter"
    SORT_CLASS_DOMAIN_PROFILE = "domainProfile"
    SORT_CLASS_DOMAIN_PROFILE_FSM = "domainProfileFsm"
    SORT_CLASS_DOMAIN_PROFILE_FSM_STAGE = "domainProfileFsmStage"
    SORT_CLASS_DOMAIN_PROFILE_FSM_TASK = "domainProfileFsmTask"
    SORT_CLASS_DOMAIN_SERVER_FEATURE = "domainServerFeature"
    SORT_CLASS_DOMAIN_SERVER_PARAM = "domainServerParam"
    SORT_CLASS_DOMAIN_SERVICE_PROFILE_ITEM = "domainServiceProfileItem"
    SORT_CLASS_DOMAIN_STORAGE_FEATURE = "domainStorageFeature"
    SORT_CLASS_DOMAIN_STORAGE_PARAM = "domainStorageParam"
    SORT_CLASS_DPSEC_MAC = "dpsecMac"
    SORT_CLASS_DUPE_CHANGE_TRACKER = "dupeChangeTracker"
    SORT_CLASS_DUPE_CHANGE_TRACKER_EP = "dupeChangeTrackerEp"
    SORT_CLASS_DUPE_CHANGE_TRACKER_EP_FSM = "dupeChangeTrackerEpFsm"
    SORT_CLASS_DUPE_CHANGE_TRACKER_EP_FSM_STAGE = "dupeChangeTrackerEpFsmStage"
    SORT_CLASS_DUPE_CHANGE_TRACKER_EP_FSM_TASK = "dupeChangeTrackerEpFsmTask"
    SORT_CLASS_DUPE_EP = "dupeEp"
    SORT_CLASS_DUPE_EXT_REQUESTOR = "dupeExtRequestor"
    SORT_CLASS_DUPE_INT_REQUESTOR = "dupeIntRequestor"
    SORT_CLASS_DUPE_REQUESTOR = "dupeRequestor"
    SORT_CLASS_DUPE_SCOPE = "dupeScope"
    SORT_CLASS_DUPE_SCOPE_EP = "dupeScopeEp"
    SORT_CLASS_DUPE_SCOPE_RESULT = "dupeScopeResult"
    SORT_CLASS_EPQOS_DEFINITION = "epqosDefinition"
    SORT_CLASS_EPQOS_EGRESS = "epqosEgress"
    SORT_CLASS_EPQOS_ITEM = "epqosItem"
    SORT_CLASS_EQUIPMENT_ABEH_CAP = "equipmentABehCap"
    SORT_CLASS_EQUIPMENT_ADVANCED_BOOT_ORDER = "equipmentAdvancedBootOrder"
    SORT_CLASS_EQUIPMENT_ASSOC_CTX = "equipmentAssocCtx"
    SORT_CLASS_EQUIPMENT_BEACON_LED = "equipmentBeaconLed"
    SORT_CLASS_EQUIPMENT_BEH_CAP = "equipmentBehCap"
    SORT_CLASS_EQUIPMENT_BINDING = "equipmentBinding"
    SORT_CLASS_EQUIPMENT_BLADE_CAP_PROVIDER = "equipmentBladeCapProvider"
    SORT_CLASS_EQUIPMENT_BREAKOUT_CAP = "equipmentBreakoutCap"
    SORT_CLASS_EQUIPMENT_CPMETA = "equipmentCPMeta"
    SORT_CLASS_EQUIPMENT_CARD = "equipmentCard"
    SORT_CLASS_EQUIPMENT_CARTRIDGE_CAP_PROVIDER = "equipmentCartridgeCapProvider"
    SORT_CLASS_EQUIPMENT_CHASSIS = "equipmentChassis"
    SORT_CLASS_EQUIPMENT_CHASSIS_ASSOC_CTX = "equipmentChassisAssocCtx"
    SORT_CLASS_EQUIPMENT_CHASSIS_CAP_PROVIDER = "equipmentChassisCapProvider"
    SORT_CLASS_EQUIPMENT_CHASSIS_ISSUES = "equipmentChassisIssues"
    SORT_CLASS_EQUIPMENT_CHASSIS_OPERATION = "equipmentChassisOperation"
    SORT_CLASS_EQUIPMENT_CHASSIS_POS_QUAL = "equipmentChassisPosQual"
    SORT_CLASS_EQUIPMENT_CHASSIS_PROFILE = "equipmentChassisProfile"
    SORT_CLASS_EQUIPMENT_CHASSIS_PROFILE_ASSOC_CTX = "equipmentChassisProfileAssocCtx"
    SORT_CLASS_EQUIPMENT_CHASSIS_PROFILE_BINDING = "equipmentChassisProfileBinding"
    SORT_CLASS_EQUIPMENT_CHASSIS_PROFILE_FSM = "equipmentChassisProfileFsm"
    SORT_CLASS_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE = "equipmentChassisProfileFsmStage"
    SORT_CLASS_EQUIPMENT_CHASSIS_PROFILE_FSM_TASK = "equipmentChassisProfileFsmTask"
    SORT_CLASS_EQUIPMENT_CHASSIS_QUAL = "equipmentChassisQual"
    SORT_CLASS_EQUIPMENT_CHASSIS_REQUIREMENT = "equipmentChassisRequirement"
    SORT_CLASS_EQUIPMENT_CHASSIS_STATS = "equipmentChassisStats"
    SORT_CLASS_EQUIPMENT_CHASSIS_STATS_HIST = "equipmentChassisStatsHist"
    SORT_CLASS_EQUIPMENT_CIMC_VMEDIA = "equipmentCimcVmedia"
    SORT_CLASS_EQUIPMENT_COMPUTE_CONN = "equipmentComputeConn"
    SORT_CLASS_EQUIPMENT_COMPUTE_CONN_POLICY = "equipmentComputeConnPolicy"
    SORT_CLASS_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER = "equipmentComputePhysicalCapProvider"
    SORT_CLASS_EQUIPMENT_DEFINITION = "equipmentDefinition"
    SORT_CLASS_EQUIPMENT_DRIVE_SEC_CAP = "equipmentDriveSecCap"
    SORT_CLASS_EQUIPMENT_FAN = "equipmentFan"
    SORT_CLASS_EQUIPMENT_FAN_MODULE = "equipmentFanModule"
    SORT_CLASS_EQUIPMENT_FAN_MODULE_CAP_PROVIDER = "equipmentFanModuleCapProvider"
    SORT_CLASS_EQUIPMENT_FAN_MODULE_STATS = "equipmentFanModuleStats"
    SORT_CLASS_EQUIPMENT_FAN_MODULE_STATS_HIST = "equipmentFanModuleStatsHist"
    SORT_CLASS_EQUIPMENT_FAN_STATS = "equipmentFanStats"
    SORT_CLASS_EQUIPMENT_FAN_STATS_HIST = "equipmentFanStatsHist"
    SORT_CLASS_EQUIPMENT_FEX = "equipmentFex"
    SORT_CLASS_EQUIPMENT_FEX_CAP_PROVIDER = "equipmentFexCapProvider"
    SORT_CLASS_EQUIPMENT_FEX_ENV_STATS = "equipmentFexEnvStats"
    SORT_CLASS_EQUIPMENT_FEX_ENV_STATS_HIST = "equipmentFexEnvStatsHist"
    SORT_CLASS_EQUIPMENT_FEX_OPERATION = "equipmentFexOperation"
    SORT_CLASS_EQUIPMENT_FEX_POWER_SUMMARY = "equipmentFexPowerSummary"
    SORT_CLASS_EQUIPMENT_FEX_POWER_SUMMARY_HIST = "equipmentFexPowerSummaryHist"
    SORT_CLASS_EQUIPMENT_FEX_PSU_INPUT_STATS = "equipmentFexPsuInputStats"
    SORT_CLASS_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST = "equipmentFexPsuInputStatsHist"
    SORT_CLASS_EQUIPMENT_FRU_CAP_PROVIDER = "equipmentFruCapProvider"
    SORT_CLASS_EQUIPMENT_FRU_VARIANT = "equipmentFruVariant"
    SORT_CLASS_EQUIPMENT_GEM_CAP_PROVIDER = "equipmentGemCapProvider"
    SORT_CLASS_EQUIPMENT_HEALTH_LED = "equipmentHealthLed"
    SORT_CLASS_EQUIPMENT_HOLDER = "equipmentHolder"
    SORT_CLASS_EQUIPMENT_HOLDER_CAP_PROVIDER = "equipmentHolderCapProvider"
    SORT_CLASS_EQUIPMENT_HOST_IF_CAP_PROVIDER = "equipmentHostIfCapProvider"
    SORT_CLASS_EQUIPMENT_HW_CAP_PROVIDER = "equipmentHwCapProvider"
    SORT_CLASS_EQUIPMENT_IOCARD = "equipmentIOCard"
    SORT_CLASS_EQUIPMENT_IOCARD_BASE = "equipmentIOCardBase"
    SORT_CLASS_EQUIPMENT_IOCARD_CAP_PROVIDER = "equipmentIOCardCapProvider"
    SORT_CLASS_EQUIPMENT_IOCARD_STATS = "equipmentIOCardStats"
    SORT_CLASS_EQUIPMENT_IOCARD_STATS_HIST = "equipmentIOCardStatsHist"
    SORT_CLASS_EQUIPMENT_IMPLIED_STORAGE_ENCLOSURE_DEF = "equipmentImpliedStorageEnclosureDef"
    SORT_CLASS_EQUIPMENT_INDICATOR_LED = "equipmentIndicatorLed"
    SORT_CLASS_EQUIPMENT_INSTANCE = "equipmentInstance"
    SORT_CLASS_EQUIPMENT_INSTANCE_MAPPING = "equipmentInstanceMapping"
    SORT_CLASS_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER = "equipmentIntegratedComponentCapProvider"
    SORT_CLASS_EQUIPMENT_ITEM = "equipmentItem"
    SORT_CLASS_EQUIPMENT_LED = "equipmentLed"
    SORT_CLASS_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER = "equipmentLocalDiskCapProvider"
    SORT_CLASS_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER = "equipmentLocalDiskControllerCapProvider"
    SORT_CLASS_EQUIPMENT_LOCAL_DISK_DEF = "equipmentLocalDiskDef"
    SORT_CLASS_EQUIPMENT_LOCAL_TEMPL_DEF = "equipmentLocalTemplDef"
    SORT_CLASS_EQUIPMENT_LOCATOR_LED = "equipmentLocatorLed"
    SORT_CLASS_EQUIPMENT_LOCATOR_LED_OPERATION = "equipmentLocatorLedOperation"
    SORT_CLASS_EQUIPMENT_MANUFACTURING_DEF = "equipmentManufacturingDef"
    SORT_CLASS_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER = "equipmentMemoryUnitCapProvider"
    SORT_CLASS_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS = "equipmentNetworkElementFanStats"
    SORT_CLASS_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST = "equipmentNetworkElementFanStatsHist"
    SORT_CLASS_EQUIPMENT_PCI_DEF = "equipmentPciDef"
    SORT_CLASS_EQUIPMENT_PHYSICAL_QUAL = "equipmentPhysicalQual"
    SORT_CLASS_EQUIPMENT_PICTURE = "equipmentPicture"
    SORT_CLASS_EQUIPMENT_PLACEABLE = "equipmentPlaceable"
    SORT_CLASS_EQUIPMENT_PLACED = "equipmentPlaced"
    SORT_CLASS_EQUIPMENT_POOL = "equipmentPool"
    SORT_CLASS_EQUIPMENT_POOLABLE = "equipmentPoolable"
    SORT_CLASS_EQUIPMENT_POOLED = "equipmentPooled"
    SORT_CLASS_EQUIPMENT_POOLING_POLICY = "equipmentPoolingPolicy"
    SORT_CLASS_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER = "equipmentProcessorUnitCapProvider"
    SORT_CLASS_EQUIPMENT_PSU = "equipmentPsu"
    SORT_CLASS_EQUIPMENT_PSU_CAP_PROVIDER = "equipmentPsuCapProvider"
    SORT_CLASS_EQUIPMENT_PSU_INPUT_STATS = "equipmentPsuInputStats"
    SORT_CLASS_EQUIPMENT_PSU_INPUT_STATS_HIST = "equipmentPsuInputStatsHist"
    SORT_CLASS_EQUIPMENT_PSU_OUTPUT_STATS = "equipmentPsuOutputStats"
    SORT_CLASS_EQUIPMENT_PSU_OUTPUT_STATS_HIST = "equipmentPsuOutputStatsHist"
    SORT_CLASS_EQUIPMENT_PSU_STATS = "equipmentPsuStats"
    SORT_CLASS_EQUIPMENT_PSU_STATS_HIST = "equipmentPsuStatsHist"
    SORT_CLASS_EQUIPMENT_QUAL = "equipmentQual"
    SORT_CLASS_EQUIPMENT_QUAL_BASE = "equipmentQualBase"
    SORT_CLASS_EQUIPMENT_QUAL_ITEM = "equipmentQualItem"
    SORT_CLASS_EQUIPMENT_QUALIFIED_POLICY = "equipmentQualifiedPolicy"
    SORT_CLASS_EQUIPMENT_RACK_UNIT_CAP_PROVIDER = "equipmentRackUnitCapProvider"
    SORT_CLASS_EQUIPMENT_RACK_UNIT_FAN_STATS = "equipmentRackUnitFanStats"
    SORT_CLASS_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST = "equipmentRackUnitFanStatsHist"
    SORT_CLASS_EQUIPMENT_RACK_UNIT_PSU_STATS = "equipmentRackUnitPsuStats"
    SORT_CLASS_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST = "equipmentRackUnitPsuStatsHist"
    SORT_CLASS_EQUIPMENT_REQUIREMENT = "equipmentRequirement"
    SORT_CLASS_EQUIPMENT_SECURE_BOOT = "equipmentSecureBoot"
    SORT_CLASS_EQUIPMENT_SERVER_FEATURE_CAP = "equipmentServerFeatureCap"
    SORT_CLASS_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER = "equipmentServerUnitCapProvider"
    SORT_CLASS_EQUIPMENT_SHARED_IOMODULE = "equipmentSharedIOModule"
    SORT_CLASS_EQUIPMENT_SIOC_TEMP_STATS = "equipmentSiocTempStats"
    SORT_CLASS_EQUIPMENT_SIOC_TEMP_STATS_HIST = "equipmentSiocTempStatsHist"
    SORT_CLASS_EQUIPMENT_SLOT_ENCLOSURE = "equipmentSlotEnclosure"
    SORT_CLASS_EQUIPMENT_STATEFUL = "equipmentStateful"
    SORT_CLASS_EQUIPMENT_STATEFUL_BLADE_COMP = "equipmentStatefulBladeComp"
    SORT_CLASS_EQUIPMENT_STATEFUL_CH_COMP = "equipmentStatefulChComp"
    SORT_CLASS_EQUIPMENT_STORAGE_PROCESSOR_CAP = "equipmentStorageProcessorCap"
    SORT_CLASS_EQUIPMENT_SWITCH_CAP_PROVIDER = "equipmentSwitchCapProvider"
    SORT_CLASS_EQUIPMENT_SWITCH_CARD = "equipmentSwitchCard"
    SORT_CLASS_EQUIPMENT_SWITCH_IOCARD = "equipmentSwitchIOCard"
    SORT_CLASS_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER = "equipmentSwitchIOCardCapProvider"
    SORT_CLASS_EQUIPMENT_SYSTEM_FRU_CAP_PROVIDER = "equipmentSystemFruCapProvider"
    SORT_CLASS_EQUIPMENT_SYSTEM_IOCONTROLLER = "equipmentSystemIOController"
    SORT_CLASS_EQUIPMENT_SYSTEM_IOCONTROLLER_OPERATION = "equipmentSystemIOControllerOperation"
    SORT_CLASS_EQUIPMENT_TEMPLATE = "equipmentTemplate"
    SORT_CLASS_EQUIPMENT_TEMPLATE_MAPPING = "equipmentTemplateMapping"
    SORT_CLASS_EQUIPMENT_TIER = "equipmentTier"
    SORT_CLASS_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER = "equipmentUnifiedPortCapProvider"
    SORT_CLASS_EQUIPMENT_XCVR = "equipmentXcvr"
    SORT_CLASS_ETHER_ERR_STATS = "etherErrStats"
    SORT_CLASS_ETHER_ERR_STATS_HIST = "etherErrStatsHist"
    SORT_CLASS_ETHER_FCOE_INTERFACE_STATS = "etherFcoeInterfaceStats"
    SORT_CLASS_ETHER_FCOE_INTERFACE_STATS_HIST = "etherFcoeInterfaceStatsHist"
    SORT_CLASS_ETHER_LOSS_STATS = "etherLossStats"
    SORT_CLASS_ETHER_LOSS_STATS_HIST = "etherLossStatsHist"
    SORT_CLASS_ETHER_PIO = "etherPIo"
    SORT_CLASS_ETHER_PAUSE_STATS = "etherPauseStats"
    SORT_CLASS_ETHER_PAUSE_STATS_HIST = "etherPauseStatsHist"
    SORT_CLASS_ETHER_RX_STATS = "etherRxStats"
    SORT_CLASS_ETHER_RX_STATS_HIST = "etherRxStatsHist"
    SORT_CLASS_ETHER_SERVER_INT_FIO = "etherServerIntFIo"
    SORT_CLASS_ETHER_SWITCH_INT_FIO = "etherSwitchIntFIo"
    SORT_CLASS_ETHER_TX_STATS = "etherTxStats"
    SORT_CLASS_ETHER_TX_STATS_HIST = "etherTxStatsHist"
    SORT_CLASS_EVENT_APPLICATION = "eventApplication"
    SORT_CLASS_EVENT_EP_CTRL = "eventEpCtrl"
    SORT_CLASS_EVENT_HOLDER = "eventHolder"
    SORT_CLASS_EVENT_INST = "eventInst"
    SORT_CLASS_EVENT_LOG = "eventLog"
    SORT_CLASS_EVENT_POLICY = "eventPolicy"
    SORT_CLASS_EVENT_RECORD = "eventRecord"
    SORT_CLASS_EXTMGMT_ARP_TARGETS = "extmgmtArpTargets"
    SORT_CLASS_EXTMGMT_GATEWAY_PING = "extmgmtGatewayPing"
    SORT_CLASS_EXTMGMT_IF_MON_POLICY = "extmgmtIfMonPolicy"
    SORT_CLASS_EXTMGMT_MII_STATUS = "extmgmtMiiStatus"
    SORT_CLASS_EXTMGMT_NDISC_TARGETS = "extmgmtNdiscTargets"
    SORT_CLASS_EXTPOL_CLIENT = "extpolClient"
    SORT_CLASS_EXTPOL_CLIENT_CONT = "extpolClientCont"
    SORT_CLASS_EXTPOL_CLIENT_FSM = "extpolClientFsm"
    SORT_CLASS_EXTPOL_CLIENT_FSM_STAGE = "extpolClientFsmStage"
    SORT_CLASS_EXTPOL_CLIENT_FSM_TASK = "extpolClientFsmTask"
    SORT_CLASS_EXTPOL_CONNECTOR = "extpolConnector"
    SORT_CLASS_EXTPOL_CONNECTOR_CONTAINER = "extpolConnectorContainer"
    SORT_CLASS_EXTPOL_CONTROLLER = "extpolController"
    SORT_CLASS_EXTPOL_CONTROLLER_CONT = "extpolControllerCont"
    SORT_CLASS_EXTPOL_DOMAIN = "extpolDomain"
    SORT_CLASS_EXTPOL_EP = "extpolEp"
    SORT_CLASS_EXTPOL_EP_FSM = "extpolEpFsm"
    SORT_CLASS_EXTPOL_EP_FSM_STAGE = "extpolEpFsmStage"
    SORT_CLASS_EXTPOL_EP_FSM_TASK = "extpolEpFsmTask"
    SORT_CLASS_EXTPOL_HBSTATUS = "extpolHBStatus"
    SORT_CLASS_EXTPOL_PROVIDER = "extpolProvider"
    SORT_CLASS_EXTPOL_PROVIDER_CONT = "extpolProviderCont"
    SORT_CLASS_EXTPOL_REGISTRY = "extpolRegistry"
    SORT_CLASS_EXTPOL_REGISTRY_CAPABILITY = "extpolRegistryCapability"
    SORT_CLASS_EXTPOL_SVC = "extpolSvc"
    SORT_CLASS_EXTPOL_SYSTEM_CONTEXT = "extpolSystemContext"
    SORT_CLASS_EXTPOL_VERSION_HOLDER = "extpolVersionHolder"
    SORT_CLASS_EXTVMM_NETWORK_SETS = "extvmmNetworkSets"
    SORT_CLASS_EXTVMM_VMNETWORK_SETS = "extvmmVMNetworkSets"
    SORT_CLASS_FABRIC_ADCE_SW_SRV_EP = "fabricADceSwSrvEp"
    SORT_CLASS_FABRIC_AETH_ESTC_EP = "fabricAEthEstcEp"
    SORT_CLASS_FABRIC_AETH_LAN_EP = "fabricAEthLanEp"
    SORT_CLASS_FABRIC_AFC_ESTC_EP = "fabricAFcEstcEp"
    SORT_CLASS_FABRIC_AFC_SAN_EP = "fabricAFcSanEp"
    SORT_CLASS_FABRIC_AFCOE_ESTC_EP = "fabricAFcoeEstcEp"
    SORT_CLASS_FABRIC_AFCOE_SAN_EP = "fabricAFcoeSanEp"
    SORT_CLASS_FABRIC_AGROUP_REQ = "fabricAGroupReq"
    SORT_CLASS_FABRIC_ANET_GROUP = "fabricANetGroup"
    SORT_CLASS_FABRIC_ANET_GROUP_REF = "fabricANetGroupRef"
    SORT_CLASS_FABRIC_ASAN_GROUP = "fabricASanGroup"
    SORT_CLASS_FABRIC_AVLAN = "fabricAVlan"
    SORT_CLASS_FABRIC_AVSAN = "fabricAVsan"
    SORT_CLASS_FABRIC_BASE_NET_GROUP = "fabricBaseNetGroup"
    SORT_CLASS_FABRIC_BASE_PH_EP = "fabricBasePhEp"
    SORT_CLASS_FABRIC_BASE_SLOT_EP = "fabricBaseSlotEp"
    SORT_CLASS_FABRIC_BREAKOUT = "fabricBreakout"
    SORT_CLASS_FABRIC_BREAKOUT_OPERATION = "fabricBreakoutOperation"
    SORT_CLASS_FABRIC_CIO_EP = "fabricCIoEp"
    SORT_CLASS_FABRIC_CABLING = "fabricCabling"
    SORT_CLASS_FABRIC_CABLING_SW = "fabricCablingSw"
    SORT_CLASS_FABRIC_CARTRIDGE_SLOT_EP = "fabricCartridgeSlotEp"
    SORT_CLASS_FABRIC_CARTRIDGE_SLOT_EP_OPERATION = "fabricCartridgeSlotEpOperation"
    SORT_CLASS_FABRIC_CDP_LINK_POLICY = "fabricCdpLinkPolicy"
    SORT_CLASS_FABRIC_CHANGED_OBJECT_REF = "fabricChangedObjectRef"
    SORT_CLASS_FABRIC_CHASSIS_EP = "fabricChassisEp"
    SORT_CLASS_FABRIC_CLOUD = "fabricCloud"
    SORT_CLASS_FABRIC_COMPUTE_EP = "fabricComputeEp"
    SORT_CLASS_FABRIC_COMPUTE_MSLOT_EP = "fabricComputeMSlotEp"
    SORT_CLASS_FABRIC_COMPUTE_PH_EP = "fabricComputePhEp"
    SORT_CLASS_FABRIC_COMPUTE_PH_EP_OPERATION = "fabricComputePhEpOperation"
    SORT_CLASS_FABRIC_COMPUTE_SLOT_EP = "fabricComputeSlotEp"
    SORT_CLASS_FABRIC_COMPUTE_SLOT_EP_OPERATION = "fabricComputeSlotEpOperation"
    SORT_CLASS_FABRIC_CONSUMER = "fabricConsumer"
    SORT_CLASS_FABRIC_DCE_SRV = "fabricDceSrv"
    SORT_CLASS_FABRIC_DCE_SW_SRV = "fabricDceSwSrv"
    SORT_CLASS_FABRIC_DCE_SW_SRV_EP = "fabricDceSwSrvEp"
    SORT_CLASS_FABRIC_DCE_SW_SRV_EP_OPERATION = "fabricDceSwSrvEpOperation"
    SORT_CLASS_FABRIC_DCE_SW_SRV_PC = "fabricDceSwSrvPc"
    SORT_CLASS_FABRIC_DCE_SW_SRV_PC_EP = "fabricDceSwSrvPcEp"
    SORT_CLASS_FABRIC_DCE_SW_SRV_PC_EP_OPERATION = "fabricDceSwSrvPcEpOperation"
    SORT_CLASS_FABRIC_DCE_SW_SRV_PC_OPERATION = "fabricDceSwSrvPcOperation"
    SORT_CLASS_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM = "fabricDceSwSrvPcOperationFsm"
    SORT_CLASS_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_STAGE = "fabricDceSwSrvPcOperationFsmStage"
    SORT_CLASS_FABRIC_DOMAIN = "fabricDomain"
    SORT_CLASS_FABRIC_DOMAIN_EP = "fabricDomainEp"
    SORT_CLASS_FABRIC_ENCLOSURE_PH_EP = "fabricEnclosurePhEp"
    SORT_CLASS_FABRIC_ENCLOSURE_PH_EP_OPERATION = "fabricEnclosurePhEpOperation"
    SORT_CLASS_FABRIC_ENCLOSURE_SLOT_EP = "fabricEnclosureSlotEp"
    SORT_CLASS_FABRIC_ENCLOSURE_SLOT_EP_OPERATION = "fabricEnclosureSlotEpOperation"
    SORT_CLASS_FABRIC_EP = "fabricEp"
    SORT_CLASS_FABRIC_EP_VLAN = "fabricEpVlan"
    SORT_CLASS_FABRIC_EP_VSAN = "fabricEpVsan"
    SORT_CLASS_FABRIC_EQUIPMENT_EP = "fabricEquipmentEp"
    SORT_CLASS_FABRIC_ESTC_EP = "fabricEstcEp"
    SORT_CLASS_FABRIC_ESTC_PC = "fabricEstcPc"
    SORT_CLASS_FABRIC_ETH_CDP_POLICY = "fabricEthCdpPolicy"
    SORT_CLASS_FABRIC_ETH_ESTC = "fabricEthEstc"
    SORT_CLASS_FABRIC_ETH_ESTC_CLOUD = "fabricEthEstcCloud"
    SORT_CLASS_FABRIC_ETH_ESTC_EP = "fabricEthEstcEp"
    SORT_CLASS_FABRIC_ETH_ESTC_EP_OPERATION = "fabricEthEstcEpOperation"
    SORT_CLASS_FABRIC_ETH_ESTC_EP_OPERATION_FSM = "fabricEthEstcEpOperationFsm"
    SORT_CLASS_FABRIC_ETH_ESTC_EP_OPERATION_FSM_STAGE = "fabricEthEstcEpOperationFsmStage"
    SORT_CLASS_FABRIC_ETH_ESTC_PC = "fabricEthEstcPc"
    SORT_CLASS_FABRIC_ETH_ESTC_PC_EP = "fabricEthEstcPcEp"
    SORT_CLASS_FABRIC_ETH_ESTC_PC_EP_OPERATION = "fabricEthEstcPcEpOperation"
    SORT_CLASS_FABRIC_ETH_ESTC_PC_OPERATION = "fabricEthEstcPcOperation"
    SORT_CLASS_FABRIC_ETH_ESTC_PC_OPERATION_FSM = "fabricEthEstcPcOperationFsm"
    SORT_CLASS_FABRIC_ETH_ESTC_PC_OPERATION_FSM_STAGE = "fabricEthEstcPcOperationFsmStage"
    SORT_CLASS_FABRIC_ETH_LAN = "fabricEthLan"
    SORT_CLASS_FABRIC_ETH_LAN_EP = "fabricEthLanEp"
    SORT_CLASS_FABRIC_ETH_LAN_EP_OPERATION = "fabricEthLanEpOperation"
    SORT_CLASS_FABRIC_ETH_LAN_EP_OPERATION_FSM = "fabricEthLanEpOperationFsm"
    SORT_CLASS_FABRIC_ETH_LAN_EP_OPERATION_FSM_STAGE = "fabricEthLanEpOperationFsmStage"
    SORT_CLASS_FABRIC_ETH_LAN_PC = "fabricEthLanPc"
    SORT_CLASS_FABRIC_ETH_LAN_PC_EP = "fabricEthLanPcEp"
    SORT_CLASS_FABRIC_ETH_LAN_PC_EP_OPERATION = "fabricEthLanPcEpOperation"
    SORT_CLASS_FABRIC_ETH_LAN_PC_OPERATION = "fabricEthLanPcOperation"
    SORT_CLASS_FABRIC_ETH_LAN_PC_OPERATION_FSM = "fabricEthLanPcOperationFsm"
    SORT_CLASS_FABRIC_ETH_LAN_PC_OPERATION_FSM_STAGE = "fabricEthLanPcOperationFsmStage"
    SORT_CLASS_FABRIC_ETH_LINK_POLICY = "fabricEthLinkPolicy"
    SORT_CLASS_FABRIC_ETH_LINK_PROFILE = "fabricEthLinkProfile"
    SORT_CLASS_FABRIC_ETH_MON = "fabricEthMon"
    SORT_CLASS_FABRIC_ETH_MON_DEST_EP = "fabricEthMonDestEp"
    SORT_CLASS_FABRIC_ETH_MON_DEST_EP_OPERATION = "fabricEthMonDestEpOperation"
    SORT_CLASS_FABRIC_ETH_MON_LAN = "fabricEthMonLan"
    SORT_CLASS_FABRIC_ETH_MON_OPERATION = "fabricEthMonOperation"
    SORT_CLASS_FABRIC_ETH_MON_OPERATION_FSM = "fabricEthMonOperationFsm"
    SORT_CLASS_FABRIC_ETH_MON_OPERATION_FSM_STAGE = "fabricEthMonOperationFsmStage"
    SORT_CLASS_FABRIC_ETH_MON_SRC_EP = "fabricEthMonSrcEp"
    SORT_CLASS_FABRIC_ETH_MON_SRC_EP_OPERATION = "fabricEthMonSrcEpOperation"
    SORT_CLASS_FABRIC_ETH_MON_SRC_REF = "fabricEthMonSrcRef"
    SORT_CLASS_FABRIC_ETH_PORT_OPERATION = "fabricEthPortOperation"
    SORT_CLASS_FABRIC_ETH_PORT_OPERATION_FSM = "fabricEthPortOperationFsm"
    SORT_CLASS_FABRIC_ETH_PORT_OPERATION_FSM_STAGE = "fabricEthPortOperationFsmStage"
    SORT_CLASS_FABRIC_ETH_TARGET_EP = "fabricEthTargetEp"
    SORT_CLASS_FABRIC_ETH_TARGET_EP_OPERATION = "fabricEthTargetEpOperation"
    SORT_CLASS_FABRIC_ETH_UDLD_POLICY = "fabricEthUdldPolicy"
    SORT_CLASS_FABRIC_ETH_VLAN_PC = "fabricEthVlanPc"
    SORT_CLASS_FABRIC_ETH_VLAN_PORT_EP = "fabricEthVlanPortEp"
    SORT_CLASS_FABRIC_ETHER_REF = "fabricEtherRef"
    SORT_CLASS_FABRIC_EXTENSION = "fabricExtension"
    SORT_CLASS_FABRIC_EXTERNAL = "fabricExternal"
    SORT_CLASS_FABRIC_EXTERNAL_EP = "fabricExternalEp"
    SORT_CLASS_FABRIC_EXTERNAL_ESTC = "fabricExternalEstc"
    SORT_CLASS_FABRIC_EXTERNAL_PC = "fabricExternalPc"
    SORT_CLASS_FABRIC_FIPORT_OPERATION = "fabricFIPortOperation"
    SORT_CLASS_FABRIC_FIPORT_OPERATION_FSM = "fabricFIPortOperationFsm"
    SORT_CLASS_FABRIC_FIPORT_OPERATION_FSM_STAGE = "fabricFIPortOperationFsmStage"
    SORT_CLASS_FABRIC_FIPORT_OPERATION_FSM_TASK = "fabricFIPortOperationFsmTask"
    SORT_CLASS_FABRIC_FC_ENDPOINT = "fabricFcEndpoint"
    SORT_CLASS_FABRIC_FC_ESTC = "fabricFcEstc"
    SORT_CLASS_FABRIC_FC_ESTC_CLOUD = "fabricFcEstcCloud"
    SORT_CLASS_FABRIC_FC_ESTC_EP = "fabricFcEstcEp"
    SORT_CLASS_FABRIC_FC_ESTC_EP_OPERATION = "fabricFcEstcEpOperation"
    SORT_CLASS_FABRIC_FC_ESTC_EP_OPERATION_FSM = "fabricFcEstcEpOperationFsm"
    SORT_CLASS_FABRIC_FC_ESTC_EP_OPERATION_FSM_STAGE = "fabricFcEstcEpOperationFsmStage"
    SORT_CLASS_FABRIC_FC_MON = "fabricFcMon"
    SORT_CLASS_FABRIC_FC_MON_DEST_EP = "fabricFcMonDestEp"
    SORT_CLASS_FABRIC_FC_MON_DEST_EP_OPERATION = "fabricFcMonDestEpOperation"
    SORT_CLASS_FABRIC_FC_MON_OPERATION = "fabricFcMonOperation"
    SORT_CLASS_FABRIC_FC_MON_OPERATION_FSM = "fabricFcMonOperationFsm"
    SORT_CLASS_FABRIC_FC_MON_OPERATION_FSM_STAGE = "fabricFcMonOperationFsmStage"
    SORT_CLASS_FABRIC_FC_MON_SAN = "fabricFcMonSan"
    SORT_CLASS_FABRIC_FC_MON_SRC_EP = "fabricFcMonSrcEp"
    SORT_CLASS_FABRIC_FC_MON_SRC_EP_OPERATION = "fabricFcMonSrcEpOperation"
    SORT_CLASS_FABRIC_FC_MON_SRC_REF = "fabricFcMonSrcRef"
    SORT_CLASS_FABRIC_FC_PORT_OPERATION = "fabricFcPortOperation"
    SORT_CLASS_FABRIC_FC_PORT_OPERATION_FSM = "fabricFcPortOperationFsm"
    SORT_CLASS_FABRIC_FC_PORT_OPERATION_FSM_STAGE = "fabricFcPortOperationFsmStage"
    SORT_CLASS_FABRIC_FC_SAN = "fabricFcSan"
    SORT_CLASS_FABRIC_FC_SAN_EP = "fabricFcSanEp"
    SORT_CLASS_FABRIC_FC_SAN_EP_OPERATION = "fabricFcSanEpOperation"
    SORT_CLASS_FABRIC_FC_SAN_EP_OPERATION_FSM = "fabricFcSanEpOperationFsm"
    SORT_CLASS_FABRIC_FC_SAN_EP_OPERATION_FSM_STAGE = "fabricFcSanEpOperationFsmStage"
    SORT_CLASS_FABRIC_FC_SAN_PC = "fabricFcSanPc"
    SORT_CLASS_FABRIC_FC_SAN_PC_EP = "fabricFcSanPcEp"
    SORT_CLASS_FABRIC_FC_SAN_PC_EP_OPERATION = "fabricFcSanPcEpOperation"
    SORT_CLASS_FABRIC_FC_SAN_PC_OPERATION = "fabricFcSanPcOperation"
    SORT_CLASS_FABRIC_FC_SAN_PC_OPERATION_FSM = "fabricFcSanPcOperationFsm"
    SORT_CLASS_FABRIC_FC_SAN_PC_OPERATION_FSM_STAGE = "fabricFcSanPcOperationFsmStage"
    SORT_CLASS_FABRIC_FC_UPLINK_OPERATION = "fabricFcUplinkOperation"
    SORT_CLASS_FABRIC_FC_USER_ZONE = "fabricFcUserZone"
    SORT_CLASS_FABRIC_FC_USER_ZONE_IVT = "fabricFcUserZoneIvt"
    SORT_CLASS_FABRIC_FC_VSAN_PC = "fabricFcVsanPc"
    SORT_CLASS_FABRIC_FC_VSAN_PORT_EP = "fabricFcVsanPortEp"
    SORT_CLASS_FABRIC_FC_ZONE_PROFILE = "fabricFcZoneProfile"
    SORT_CLASS_FABRIC_FC_ZONE_PROFILE_FSM = "fabricFcZoneProfileFsm"
    SORT_CLASS_FABRIC_FC_ZONE_PROFILE_FSM_STAGE = "fabricFcZoneProfileFsmStage"
    SORT_CLASS_FABRIC_FC_ZONE_PROFILE_FSM_TASK = "fabricFcZoneProfileFsmTask"
    SORT_CLASS_FABRIC_FC_ZONE_PROFILE_IVT = "fabricFcZoneProfileIvt"
    SORT_CLASS_FABRIC_FCOE_ESTC_EP = "fabricFcoeEstcEp"
    SORT_CLASS_FABRIC_FCOE_ESTC_EP_OPERATION = "fabricFcoeEstcEpOperation"
    SORT_CLASS_FABRIC_FCOE_ESTC_EP_OPERATION_FSM = "fabricFcoeEstcEpOperationFsm"
    SORT_CLASS_FABRIC_FCOE_ESTC_EP_OPERATION_FSM_STAGE = "fabricFcoeEstcEpOperationFsmStage"
    SORT_CLASS_FABRIC_FCOE_SAN_EP = "fabricFcoeSanEp"
    SORT_CLASS_FABRIC_FCOE_SAN_EP_OPERATION = "fabricFcoeSanEpOperation"
    SORT_CLASS_FABRIC_FCOE_SAN_EP_OPERATION_FSM = "fabricFcoeSanEpOperationFsm"
    SORT_CLASS_FABRIC_FCOE_SAN_EP_OPERATION_FSM_STAGE = "fabricFcoeSanEpOperationFsmStage"
    SORT_CLASS_FABRIC_FCOE_SAN_PC = "fabricFcoeSanPc"
    SORT_CLASS_FABRIC_FCOE_SAN_PC_EP = "fabricFcoeSanPcEp"
    SORT_CLASS_FABRIC_FCOE_SAN_PC_EP_OPERATION = "fabricFcoeSanPcEpOperation"
    SORT_CLASS_FABRIC_FCOE_SAN_PC_OPERATION = "fabricFcoeSanPcOperation"
    SORT_CLASS_FABRIC_FCOE_SAN_PC_OPERATION_FSM = "fabricFcoeSanPcOperationFsm"
    SORT_CLASS_FABRIC_FCOE_SAN_PC_OPERATION_FSM_STAGE = "fabricFcoeSanPcOperationFsmStage"
    SORT_CLASS_FABRIC_FCOE_VSAN_PC = "fabricFcoeVsanPc"
    SORT_CLASS_FABRIC_FCOE_VSAN_PORT_EP = "fabricFcoeVsanPortEp"
    SORT_CLASS_FABRIC_HOLDER = "fabricHolder"
    SORT_CLASS_FABRIC_IF = "fabricIf"
    SORT_CLASS_FABRIC_INTERNAL = "fabricInternal"
    SORT_CLASS_FABRIC_INTERNAL_DCE_SRV = "fabricInternalDceSrv"
    SORT_CLASS_FABRIC_INTERNAL_EP = "fabricInternalEp"
    SORT_CLASS_FABRIC_INTERNAL_PC = "fabricInternalPc"
    SORT_CLASS_FABRIC_LACP_POLICY = "fabricLacpPolicy"
    SORT_CLASS_FABRIC_LAN = "fabricLan"
    SORT_CLASS_FABRIC_LAN_ACCESS_MGR = "fabricLanAccessMgr"
    SORT_CLASS_FABRIC_LAN_CLOUD = "fabricLanCloud"
    SORT_CLASS_FABRIC_LAN_CLOUD_POLICY = "fabricLanCloudPolicy"
    SORT_CLASS_FABRIC_LAN_EP = "fabricLanEp"
    SORT_CLASS_FABRIC_LAN_MON_CLOUD = "fabricLanMonCloud"
    SORT_CLASS_FABRIC_LAN_PC = "fabricLanPc"
    SORT_CLASS_FABRIC_LAN_PIN_GROUP = "fabricLanPinGroup"
    SORT_CLASS_FABRIC_LAN_PIN_GROUP_OPERATION = "fabricLanPinGroupOperation"
    SORT_CLASS_FABRIC_LAN_PIN_TARGET = "fabricLanPinTarget"
    SORT_CLASS_FABRIC_LAN_PIN_TARGET_OPERATION = "fabricLanPinTargetOperation"
    SORT_CLASS_FABRIC_LAST_ACKED_SLOT = "fabricLastAckedSlot"
    SORT_CLASS_FABRIC_LINK_POLICY = "fabricLinkPolicy"
    SORT_CLASS_FABRIC_MON = "fabricMon"
    SORT_CLASS_FABRIC_MON_DEST_EP = "fabricMonDestEp"
    SORT_CLASS_FABRIC_MON_SRC_EP = "fabricMonSrcEp"
    SORT_CLASS_FABRIC_MON_SRC_REF = "fabricMonSrcRef"
    SORT_CLASS_FABRIC_MULTICAST_POLICY = "fabricMulticastPolicy"
    SORT_CLASS_FABRIC_NET_GROUP = "fabricNetGroup"
    SORT_CLASS_FABRIC_NET_GROUP_EP = "fabricNetGroupEp"
    SORT_CLASS_FABRIC_NET_GROUP_PERMIT = "fabricNetGroupPermit"
    SORT_CLASS_FABRIC_NET_GROUP_REF = "fabricNetGroupRef"
    SORT_CLASS_FABRIC_NET_GROUP_REQ = "fabricNetGroupReq"
    SORT_CLASS_FABRIC_ORG_VLAN_POLICY = "fabricOrgVlanPolicy"
    SORT_CLASS_FABRIC_PIO_EP = "fabricPIoEp"
    SORT_CLASS_FABRIC_PIN_GROUP = "fabricPinGroup"
    SORT_CLASS_FABRIC_PIN_TARGET = "fabricPinTarget"
    SORT_CLASS_FABRIC_POOLABLE_VLAN = "fabricPoolableVlan"
    SORT_CLASS_FABRIC_POOLED_VLAN = "fabricPooledVlan"
    SORT_CLASS_FABRIC_SAN = "fabricSan"
    SORT_CLASS_FABRIC_SAN_CLOUD = "fabricSanCloud"
    SORT_CLASS_FABRIC_SAN_EP = "fabricSanEp"
    SORT_CLASS_FABRIC_SAN_GROUP = "fabricSanGroup"
    SORT_CLASS_FABRIC_SAN_GROUP_REF = "fabricSanGroupRef"
    SORT_CLASS_FABRIC_SAN_MON_CLOUD = "fabricSanMonCloud"
    SORT_CLASS_FABRIC_SAN_PC = "fabricSanPc"
    SORT_CLASS_FABRIC_SAN_PIN_GROUP = "fabricSanPinGroup"
    SORT_CLASS_FABRIC_SAN_PIN_GROUP_OPERATION = "fabricSanPinGroupOperation"
    SORT_CLASS_FABRIC_SAN_PIN_TARGET = "fabricSanPinTarget"
    SORT_CLASS_FABRIC_SAN_PIN_TARGET_OPERATION = "fabricSanPinTargetOperation"
    SORT_CLASS_FABRIC_SUB_GROUP = "fabricSubGroup"
    SORT_CLASS_FABRIC_SW_CH_EP = "fabricSwChEp"
    SORT_CLASS_FABRIC_SW_CH_PH_EP = "fabricSwChPhEp"
    SORT_CLASS_FABRIC_SW_CH_PH_EP_OPERATION = "fabricSwChPhEpOperation"
    SORT_CLASS_FABRIC_SW_SRV_EP = "fabricSwSrvEp"
    SORT_CLASS_FABRIC_SW_SRV_PC = "fabricSwSrvPc"
    SORT_CLASS_FABRIC_SW_SUB_GROUP = "fabricSwSubGroup"
    SORT_CLASS_FABRIC_SYSTEM = "fabricSystem"
    SORT_CLASS_FABRIC_TARGET_EP = "fabricTargetEp"
    SORT_CLASS_FABRIC_UDLD_LINK_POLICY = "fabricUdldLinkPolicy"
    SORT_CLASS_FABRIC_UDLD_POLICY = "fabricUdldPolicy"
    SORT_CLASS_FABRIC_VCON = "fabricVCon"
    SORT_CLASS_FABRIC_VCON_PROFILE = "fabricVConProfile"
    SORT_CLASS_FABRIC_VLAN = "fabricVlan"
    SORT_CLASS_FABRIC_VLAN_EP = "fabricVlanEp"
    SORT_CLASS_FABRIC_VLAN_GROUP_REQ = "fabricVlanGroupReq"
    SORT_CLASS_FABRIC_VLAN_PERMIT = "fabricVlanPermit"
    SORT_CLASS_FABRIC_VLAN_PERMIT_ITEM = "fabricVlanPermitItem"
    SORT_CLASS_FABRIC_VLAN_REQ = "fabricVlanReq"
    SORT_CLASS_FABRIC_VNET_EP = "fabricVnetEp"
    SORT_CLASS_FABRIC_VNET_EP_SYNC_EP = "fabricVnetEpSyncEp"
    SORT_CLASS_FABRIC_VNET_EP_SYNC_EP_FSM = "fabricVnetEpSyncEpFsm"
    SORT_CLASS_FABRIC_VNET_EP_SYNC_EP_FSM_STAGE = "fabricVnetEpSyncEpFsmStage"
    SORT_CLASS_FABRIC_VNET_EP_SYNC_EP_FSM_TASK = "fabricVnetEpSyncEpFsmTask"
    SORT_CLASS_FABRIC_VNET_GROUP_REQ = "fabricVnetGroupReq"
    SORT_CLASS_FABRIC_VNET_REQ = "fabricVnetReq"
    SORT_CLASS_FABRIC_VSAN = "fabricVsan"
    SORT_CLASS_FABRIC_VSAN_EP = "fabricVsanEp"
    SORT_CLASS_FABRIC_VSAN_MEMBERSHIP = "fabricVsanMembership"
    SORT_CLASS_FAULT_BASE_HOLDER = "faultBaseHolder"
    SORT_CLASS_FAULT_BASE_POLICY = "faultBasePolicy"
    SORT_CLASS_FAULT_BASE_TYPED_HOLDER = "faultBaseTypedHolder"
    SORT_CLASS_FAULT_DOMAIN_EP = "faultDomainEp"
    SORT_CLASS_FAULT_DOMAIN_INST = "faultDomainInst"
    SORT_CLASS_FAULT_GLOBAL_SEVERITY_HOLDER = "faultGlobalSeverityHolder"
    SORT_CLASS_FAULT_GLOBAL_TYPED_HOLDER = "faultGlobalTypedHolder"
    SORT_CLASS_FAULT_HOLDER = "faultHolder"
    SORT_CLASS_FAULT_INST = "faultInst"
    SORT_CLASS_FAULT_LOCAL_BASE_HOLDER = "faultLocalBaseHolder"
    SORT_CLASS_FAULT_LOCAL_TYPED_HOLDER = "faultLocalTypedHolder"
    SORT_CLASS_FAULT_POLICY = "faultPolicy"
    SORT_CLASS_FAULT_SUMMARY = "faultSummary"
    SORT_CLASS_FAULT_SUMMARY_INST = "faultSummaryInst"
    SORT_CLASS_FAULT_SVC_SUMMARY = "faultSvcSummary"
    SORT_CLASS_FAULT_TYPED_HOLDER = "faultTypedHolder"
    SORT_CLASS_FC_ERR_STATS = "fcErrStats"
    SORT_CLASS_FC_ERR_STATS_HIST = "fcErrStatsHist"
    SORT_CLASS_FC_PIO = "fcPIo"
    SORT_CLASS_FC_STATS = "fcStats"
    SORT_CLASS_FC_STATS_HIST = "fcStatsHist"
    SORT_CLASS_FCPOOL_ADDR = "fcpoolAddr"
    SORT_CLASS_FCPOOL_BLOCK = "fcpoolBlock"
    SORT_CLASS_FCPOOL_BOOT_TARGET = "fcpoolBootTarget"
    SORT_CLASS_FCPOOL_FORMAT = "fcpoolFormat"
    SORT_CLASS_FCPOOL_INITIATOR = "fcpoolInitiator"
    SORT_CLASS_FCPOOL_INITIATOR_EP = "fcpoolInitiatorEp"
    SORT_CLASS_FCPOOL_INITIATORS = "fcpoolInitiators"
    SORT_CLASS_FCPOOL_UNIVERSE = "fcpoolUniverse"
    SORT_CLASS_FD_BLADE = "fdBlade"
    SORT_CLASS_FD_BLADE_FSM = "fdBladeFsm"
    SORT_CLASS_FD_BLADE_FSM_STAGE = "fdBladeFsmStage"
    SORT_CLASS_FD_CHASSIS = "fdChassis"
    SORT_CLASS_FD_OPERABLE = "fdOperable"
    SORT_CLASS_FD_PHYSICAL = "fdPhysical"
    SORT_CLASS_FD_PHYSICAL_FSM = "fdPhysicalFsm"
    SORT_CLASS_FD_PHYSICAL_FSM_STAGE = "fdPhysicalFsmStage"
    SORT_CLASS_FD_PHYSICAL_FSM_TASK = "fdPhysicalFsmTask"
    SORT_CLASS_FD_RACK_UNIT = "fdRackUnit"
    SORT_CLASS_FD_RACK_UNIT_FSM = "fdRackUnitFsm"
    SORT_CLASS_FD_RACK_UNIT_FSM_STAGE = "fdRackUnitFsmStage"
    SORT_CLASS_FEATURE_CATALOG_EP = "featureCatalogEp"
    SORT_CLASS_FEATURE_CHASSIS_DEF = "featureChassisDef"
    SORT_CLASS_FEATURE_DEFINITION = "featureDefinition"
    SORT_CLASS_FEATURE_ENV_DEF = "featureEnvDef"
    SORT_CLASS_FEATURE_NETWORK_DEF = "featureNetworkDef"
    SORT_CLASS_FEATURE_SERVER_DEF = "featureServerDef"
    SORT_CLASS_FEATURE_STORAGE_DEF = "featureStorageDef"
    SORT_CLASS_FIRMWARE_ACOMPONENT_SPEC = "firmwareAComponentSpec"
    SORT_CLASS_FIRMWARE_AEXCLUDE_COMPONENT = "firmwareAExcludeComponent"
    SORT_CLASS_FIRMWARE_AINFRA_PACK = "firmwareAInfraPack"
    SORT_CLASS_FIRMWARE_ACK = "firmwareAck"
    SORT_CLASS_FIRMWARE_AUTO_SYNC_POLICY = "firmwareAutoSyncPolicy"
    SORT_CLASS_FIRMWARE_BOOT_DEFINITION = "firmwareBootDefinition"
    SORT_CLASS_FIRMWARE_BOOT_UNIT = "firmwareBootUnit"
    SORT_CLASS_FIRMWARE_BUNDLE_INFO = "firmwareBundleInfo"
    SORT_CLASS_FIRMWARE_BUNDLE_INFO_DIGEST = "firmwareBundleInfoDigest"
    SORT_CLASS_FIRMWARE_BUNDLE_TYPE = "firmwareBundleType"
    SORT_CLASS_FIRMWARE_BUNDLE_TYPE_CAP_PROVIDER = "firmwareBundleTypeCapProvider"
    SORT_CLASS_FIRMWARE_CAP_PROVIDER = "firmwareCapProvider"
    SORT_CLASS_FIRMWARE_CATALOG_PACK = "firmwareCatalogPack"
    SORT_CLASS_FIRMWARE_CATALOG_PACK_CONFIG = "firmwareCatalogPackConfig"
    SORT_CLASS_FIRMWARE_CATALOGUE = "firmwareCatalogue"
    SORT_CLASS_FIRMWARE_CHASSIS_COMPONENT_SPEC = "firmwareChassisComponentSpec"
    SORT_CLASS_FIRMWARE_CHASSIS_PACK = "firmwareChassisPack"
    SORT_CLASS_FIRMWARE_COMP_ITEM = "firmwareCompItem"
    SORT_CLASS_FIRMWARE_COMP_SOURCE = "firmwareCompSource"
    SORT_CLASS_FIRMWARE_COMP_TARGET = "firmwareCompTarget"
    SORT_CLASS_FIRMWARE_COMPONENT_SPEC = "firmwareComponentSpec"
    SORT_CLASS_FIRMWARE_COMPUTE_HOST_PACK = "firmwareComputeHostPack"
    SORT_CLASS_FIRMWARE_COMPUTE_MGMT_PACK = "firmwareComputeMgmtPack"
    SORT_CLASS_FIRMWARE_COMPUTE_PACK = "firmwareComputePack"
    SORT_CLASS_FIRMWARE_COMPUTE_STORAGE_PACK = "firmwareComputeStoragePack"
    SORT_CLASS_FIRMWARE_CONNECTION_POLICY = "firmwareConnectionPolicy"
    SORT_CLASS_FIRMWARE_DEPENDENCY = "firmwareDependency"
    SORT_CLASS_FIRMWARE_DIST_IMAGE = "firmwareDistImage"
    SORT_CLASS_FIRMWARE_DISTRIBUTABLE = "firmwareDistributable"
    SORT_CLASS_FIRMWARE_DISTRIBUTABLE_FSM = "firmwareDistributableFsm"
    SORT_CLASS_FIRMWARE_DISTRIBUTABLE_FSM_STAGE = "firmwareDistributableFsmStage"
    SORT_CLASS_FIRMWARE_DISTRIBUTABLE_FSM_TASK = "firmwareDistributableFsmTask"
    SORT_CLASS_FIRMWARE_DOMAIN_INFO = "firmwareDomainInfo"
    SORT_CLASS_FIRMWARE_DOMAIN_INFRA_PROFILE = "firmwareDomainInfraProfile"
    SORT_CLASS_FIRMWARE_DOWNLOAD_POLICY = "firmwareDownloadPolicy"
    SORT_CLASS_FIRMWARE_DOWNLOADER = "firmwareDownloader"
    SORT_CLASS_FIRMWARE_DOWNLOADER_FSM = "firmwareDownloaderFsm"
    SORT_CLASS_FIRMWARE_DOWNLOADER_FSM_STAGE = "firmwareDownloaderFsmStage"
    SORT_CLASS_FIRMWARE_DOWNLOADER_FSM_TASK = "firmwareDownloaderFsmTask"
    SORT_CLASS_FIRMWARE_EXCLUDE_CHASSIS_COMPONENT = "firmwareExcludeChassisComponent"
    SORT_CLASS_FIRMWARE_EXCLUDE_SERVER_COMPONENT = "firmwareExcludeServerComponent"
    SORT_CLASS_FIRMWARE_IMAGE = "firmwareImage"
    SORT_CLASS_FIRMWARE_INFRA = "firmwareInfra"
    SORT_CLASS_FIRMWARE_INFRA_PACK = "firmwareInfraPack"
    SORT_CLASS_FIRMWARE_INFRA_PACK_CONFIG = "firmwareInfraPackConfig"
    SORT_CLASS_FIRMWARE_INFRA_POLICY = "firmwareInfraPolicy"
    SORT_CLASS_FIRMWARE_INSTALL_IMPACT = "firmwareInstallImpact"
    SORT_CLASS_FIRMWARE_PACK = "firmwarePack"
    SORT_CLASS_FIRMWARE_POLICY = "firmwarePolicy"
    SORT_CLASS_FIRMWARE_PRODUCT_FAMILY = "firmwareProductFamily"
    SORT_CLASS_FIRMWARE_REMOTE_CATALOGUE = "firmwareRemoteCatalogue"
    SORT_CLASS_FIRMWARE_RUNNING = "firmwareRunning"
    SORT_CLASS_FIRMWARE_SOURCE = "firmwareSource"
    SORT_CLASS_FIRMWARE_STATUS = "firmwareStatus"
    SORT_CLASS_FIRMWARE_STORAGE_PACK = "firmwareStoragePack"
    SORT_CLASS_FIRMWARE_SYSTEM = "firmwareSystem"
    SORT_CLASS_FIRMWARE_TYPE = "firmwareType"
    SORT_CLASS_FIRMWARE_UNIT = "firmwareUnit"
    SORT_CLASS_FIRMWARE_UPDATABLE = "firmwareUpdatable"
    SORT_CLASS_FIRMWARE_UPGRADE_DETAIL = "firmwareUpgradeDetail"
    SORT_CLASS_FIRMWARE_UPGRADE_INFO = "firmwareUpgradeInfo"
    SORT_CLASS_FLOWCTRL_DEFINITION = "flowctrlDefinition"
    SORT_CLASS_FLOWCTRL_ITEM = "flowctrlItem"
    SORT_CLASS_FSM_FSM = "fsmFsm"
    SORT_CLASS_FSM_STAGE = "fsmStage"
    SORT_CLASS_FSM_STATUS = "fsmStatus"
    SORT_CLASS_FSM_TASK = "fsmTask"
    SORT_CLASS_GL_ABS_CONFLICT = "glAbsConflict"
    SORT_CLASS_GL_ABS_EP = "glAbsEp"
    SORT_CLASS_GL_ABS_IDENT_CTX_OP = "glAbsIdentCtxOp"
    SORT_CLASS_GL_ABS_INV = "glAbsInv"
    SORT_CLASS_GL_ABS_OPERATION = "glAbsOperation"
    SORT_CLASS_GL_ABS_POLICY_INV = "glAbsPolicyInv"
    SORT_CLASS_GL_ABS_POLICY_OP = "glAbsPolicyOp"
    SORT_CLASS_GL_ABS_POLICY_RULE = "glAbsPolicyRule"
    SORT_CLASS_GL_ABS_REQUEST = "glAbsRequest"
    SORT_CLASS_GL_ABS_RES_EP = "glAbsResEp"
    SORT_CLASS_GL_ABS_RULE = "glAbsRule"
    SORT_CLASS_GL_ABS_VNET_INV = "glAbsVnetInv"
    SORT_CLASS_GL_APPEND_RULE = "glAppendRule"
    SORT_CLASS_GL_BLOCK_EP = "glBlockEp"
    SORT_CLASS_GL_BLOCK_OP = "glBlockOp"
    SORT_CLASS_GL_BY_MO = "glByMo"
    SORT_CLASS_GL_COMPLEX_REF_EP = "glComplexRefEp"
    SORT_CLASS_GL_CONFLICT_EP = "glConflictEp"
    SORT_CLASS_GL_CONFLICT_RESOLUTION_RULE_EP = "glConflictResolutionRuleEp"
    SORT_CLASS_GL_DOMAIN_EP = "glDomainEp"
    SORT_CLASS_GL_EP = "glEp"
    SORT_CLASS_GL_GLOBAL_DEFAULT_POLICY_EP = "glGlobalDefaultPolicyEp"
    SORT_CLASS_GL_ID_REF = "glIdRef"
    SORT_CLASS_GL_ID_REF_EP = "glIdRefEp"
    SORT_CLASS_GL_IDABLE = "glIdable"
    SORT_CLASS_GL_IDENT_CTX_EP = "glIdentCtxEp"
    SORT_CLASS_GL_IDENT_CTX_OP = "glIdentCtxOp"
    SORT_CLASS_GL_IDENT_CTX_RES_OP = "glIdentCtxResOp"
    SORT_CLASS_GL_IDENT_CTX_RES_OP_FSM = "glIdentCtxResOpFsm"
    SORT_CLASS_GL_IDENT_CTX_RES_OP_FSM_STAGE = "glIdentCtxResOpFsmStage"
    SORT_CLASS_GL_IDENT_CTX_RES_OP_FSM_TASK = "glIdentCtxResOpFsmTask"
    SORT_CLASS_GL_INVENTORY_EP = "glInventoryEp"
    SORT_CLASS_GL_LSP = "glLsp"
    SORT_CLASS_GL_MCAST_POLICY = "glMcastPolicy"
    SORT_CLASS_GL_OPERATION_EP = "glOperationEp"
    SORT_CLASS_GL_PATH_EP = "glPathEp"
    SORT_CLASS_GL_POLICY = "glPolicy"
    SORT_CLASS_GL_POLICY_ALGORITHMED_OP = "glPolicyAlgorithmedOp"
    SORT_CLASS_GL_POLICY_EP = "glPolicyEp"
    SORT_CLASS_GL_POLICY_INV_EP = "glPolicyInvEp"
    SORT_CLASS_GL_POLICY_NAME_RULE_EP = "glPolicyNameRuleEp"
    SORT_CLASS_GL_POLICY_OP = "glPolicyOp"
    SORT_CLASS_GL_POLICY_REF = "glPolicyRef"
    SORT_CLASS_GL_POLICY_REF_EP = "glPolicyRefEp"
    SORT_CLASS_GL_POLICY_RES_OP = "glPolicyResOp"
    SORT_CLASS_GL_POLICY_RESOLUTION_EP = "glPolicyResolutionEp"
    SORT_CLASS_GL_POOL = "glPool"
    SORT_CLASS_GL_POOL_EP = "glPoolEp"
    SORT_CLASS_GL_POOL_INV_EP = "glPoolInvEp"
    SORT_CLASS_GL_POOL_OP = "glPoolOp"
    SORT_CLASS_GL_REFABLE = "glRefable"
    SORT_CLASS_GL_REFS_EP = "glRefsEp"
    SORT_CLASS_GL_REQUEST = "glRequest"
    SORT_CLASS_GL_REQUEST_FSM = "glRequestFsm"
    SORT_CLASS_GL_REQUEST_FSM_STAGE = "glRequestFsmStage"
    SORT_CLASS_GL_REQUEST_FSM_TASK = "glRequestFsmTask"
    SORT_CLASS_GL_REQUEST_VNET_EP = "glRequestVnetEp"
    SORT_CLASS_GL_REQUEST_VNET_EP_DOMAIN_EP = "glRequestVnetEpDomainEp"
    SORT_CLASS_GL_REQUEST_VNET_EP_DOMAIN_EP_FSM = "glRequestVnetEpDomainEpFsm"
    SORT_CLASS_GL_REQUEST_VNET_EP_DOMAIN_EP_FSM_STAGE = "glRequestVnetEpDomainEpFsmStage"
    SORT_CLASS_GL_REQUEST_VNET_EP_DOMAIN_EP_FSM_TASK = "glRequestVnetEpDomainEpFsmTask"
    SORT_CLASS_GL_REQUEST_VNET_EP_FSM = "glRequestVnetEpFsm"
    SORT_CLASS_GL_REQUEST_VNET_EP_FSM_STAGE = "glRequestVnetEpFsmStage"
    SORT_CLASS_GL_REQUEST_VNET_EP_FSM_TASK = "glRequestVnetEpFsmTask"
    SORT_CLASS_GL_REQUEST_VNET_EP_HOLDER = "glRequestVnetEpHolder"
    SORT_CLASS_GL_REQUESTOR = "glRequestor"
    SORT_CLASS_GL_REQUESTOR_EP = "glRequestorEp"
    SORT_CLASS_GL_SPINV_EP = "glSPInvEp"
    SORT_CLASS_GL_SERVER_POOL_RES_OP = "glServerPoolResOp"
    SORT_CLASS_GL_SERVICE_PROFILE = "glServiceProfile"
    SORT_CLASS_GL_SP_DEF_EP = "glSpDefEp"
    SORT_CLASS_GL_TEMPLATE_EP = "glTemplateEp"
    SORT_CLASS_GL_TEMPLATE_OP = "glTemplateOp"
    SORT_CLASS_GL_TEMPLATE_RES_OP = "glTemplateResOp"
    SORT_CLASS_GL_USAGE = "glUsage"
    SORT_CLASS_GL_USAGE_EP = "glUsageEp"
    SORT_CLASS_GL_VLAN = "glVlan"
    SORT_CLASS_GL_VNET_INV_HOLDER = "glVnetInvHolder"
    SORT_CLASS_GL_VNIC_TEMPLATE = "glVnicTemplate"
    SORT_CLASS_GL_VNIC_TEMPLATE_EP = "glVnicTemplateEp"
    SORT_CLASS_GL_VSAN = "glVsan"
    SORT_CLASS_GL_VXAN_EP = "glVxanEp"
    SORT_CLASS_GL_VXAN_OP = "glVxanOp"
    SORT_CLASS_GL_VXAN_RES_OP = "glVxanResOp"
    SORT_CLASS_GMETA_CLASS = "gmetaClass"
    SORT_CLASS_GMETA_POLICY_MAP_ELEMENT = "gmetaPolicyMapElement"
    SORT_CLASS_GMETA_PROP = "gmetaProp"
    SORT_CLASS_GRAPHICS_CARD = "graphicsCard"
    SORT_CLASS_GRAPHICS_CONTROLLER = "graphicsController"
    SORT_CLASS_GUI_GUI_COMPONENT = "guiGuiComponent"
    SORT_CLASS_GUI_GUI_CONT = "guiGuiCont"
    SORT_CLASS_HC_ACOMPONENT = "hcAComponent"
    SORT_CLASS_HC_AITEM = "hcAItem"
    SORT_CLASS_HC_ASTATUS_ITEM = "hcAStatusItem"
    SORT_CLASS_HC_ADAPTER_FIRMWARE_ITEM = "hcAdapterFirmwareItem"
    SORT_CLASS_HC_ADAPTER_ITEM = "hcAdapterItem"
    SORT_CLASS_HC_ADMIN = "hcAdmin"
    SORT_CLASS_HC_CATALOG = "hcCatalog"
    SORT_CLASS_HC_CATALOG_LIST = "hcCatalogList"
    SORT_CLASS_HC_CATALOG_SOURCE = "hcCatalogSource"
    SORT_CLASS_HC_CATALOG_VERSION = "hcCatalogVersion"
    SORT_CLASS_HC_CLEANUP = "hcCleanup"
    SORT_CLASS_HC_DOWNLOAD_POLICY = "hcDownloadPolicy"
    SORT_CLASS_HC_DOWNLOADER = "hcDownloader"
    SORT_CLASS_HC_DRIVER_INFO_ITEM = "hcDriverInfoItem"
    SORT_CLASS_HC_DRIVER_ITEM = "hcDriverItem"
    SORT_CLASS_HC_HOLDER = "hcHolder"
    SORT_CLASS_HC_ITEM_NOTE = "hcItemNote"
    SORT_CLASS_HC_OS_INFO_ITEM = "hcOsInfoItem"
    SORT_CLASS_HC_OS_ITEM = "hcOsItem"
    SORT_CLASS_HC_REPORT = "hcReport"
    SORT_CLASS_HC_SCOPE_DN = "hcScopeDn"
    SORT_CLASS_HC_SERVER_COMPONENT = "hcServerComponent"
    SORT_CLASS_HC_SUPPORTED_ADAPTER_FIRMWARE_ITEM = "hcSupportedAdapterFirmwareItem"
    SORT_CLASS_HC_SUPPORTED_ADAPTER_ITEM = "hcSupportedAdapterItem"
    SORT_CLASS_HC_SUPPORTED_DRIVER_ITEM = "hcSupportedDriverItem"
    SORT_CLASS_HC_SUPPORTED_OS_ITEM = "hcSupportedOsItem"
    SORT_CLASS_HC_UCS_VERSION_ITEM = "hcUcsVersionItem"
    SORT_CLASS_IDENT_DOMAIN_SYNC_EP = "identDomainSyncEp"
    SORT_CLASS_IDENT_EXECUTION_EP = "identExecutionEp"
    SORT_CLASS_IDENT_EXECUTION_REQUEST_EP = "identExecutionRequestEp"
    SORT_CLASS_IDENT_IDENT_CTX = "identIdentCtx"
    SORT_CLASS_IDENT_IDENT_REQUEST = "identIdentRequest"
    SORT_CLASS_IDENT_IDENT_REQUEST_FSM = "identIdentRequestFsm"
    SORT_CLASS_IDENT_IDENT_REQUEST_FSM_STAGE = "identIdentRequestFsmStage"
    SORT_CLASS_IDENT_IDENT_REQUEST_FSM_TASK = "identIdentRequestFsmTask"
    SORT_CLASS_IDENT_META_SYSTEM = "identMetaSystem"
    SORT_CLASS_IDENT_META_SYSTEM_FSM = "identMetaSystemFsm"
    SORT_CLASS_IDENT_META_SYSTEM_FSM_STAGE = "identMetaSystemFsmStage"
    SORT_CLASS_IDENT_META_SYSTEM_FSM_TASK = "identMetaSystemFsmTask"
    SORT_CLASS_IDENT_META_VERSE = "identMetaVerse"
    SORT_CLASS_IDENT_REQUEST_EP = "identRequestEp"
    SORT_CLASS_IDENT_SYS_INFO = "identSysInfo"
    SORT_CLASS_IDENTPOOL_BLOCK_QUAL = "identpoolBlockQual"
    SORT_CLASS_IDENTPOOL_CONSUMED = "identpoolConsumed"
    SORT_CLASS_IDENTPOOL_DOMAIN = "identpoolDomain"
    SORT_CLASS_IDENTPOOL_DOMAIN_GROUP_QUAL = "identpoolDomainGroupQual"
    SORT_CLASS_IDENTPOOL_ELEMENT = "identpoolElement"
    SORT_CLASS_IDENTPOOL_IPQUAL = "identpoolIPQual"
    SORT_CLASS_IDENTPOOL_IPV6_QUAL = "identpoolIPV6Qual"
    SORT_CLASS_IDENTPOOL_META_SYSTEM = "identpoolMetaSystem"
    SORT_CLASS_IDENTPOOL_META_VERSE = "identpoolMetaVerse"
    SORT_CLASS_IDENTPOOL_POOL = "identpoolPool"
    SORT_CLASS_IDENTPOOL_POOLABLE = "identpoolPoolable"
    SORT_CLASS_IDENTPOOL_QUAL_ITEM = "identpoolQualItem"
    SORT_CLASS_IDENTPOOL_UNIVERSE = "identpoolUniverse"
    SORT_CLASS_INBAND_POLICY = "inbandPolicy"
    SORT_CLASS_INITIATOR_EP = "initiatorEp"
    SORT_CLASS_INITIATOR_FC_INITIATOR_EP = "initiatorFcInitiatorEp"
    SORT_CLASS_INITIATOR_GROUP_EP = "initiatorGroupEp"
    SORT_CLASS_INITIATOR_ISCSI_INITIATOR_EP = "initiatorIScsiInitiatorEp"
    SORT_CLASS_INITIATOR_INITIATOR_EP = "initiatorInitiatorEp"
    SORT_CLASS_INITIATOR_LUN_EP = "initiatorLunEp"
    SORT_CLASS_INITIATOR_MEMBER_EP = "initiatorMemberEp"
    SORT_CLASS_INITIATOR_REQUESTOR_EP = "initiatorRequestorEp"
    SORT_CLASS_INITIATOR_REQUESTOR_GRP_EP = "initiatorRequestorGrpEp"
    SORT_CLASS_INITIATOR_STORE_EP = "initiatorStoreEp"
    SORT_CLASS_INITIATOR_UNIT_EP = "initiatorUnitEp"
    SORT_CLASS_INVENTORY_DOMAIN_EP = "inventoryDomainEp"
    SORT_CLASS_INVENTORY_EP = "inventoryEp"
    SORT_CLASS_INVENTORY_GLOBAL_EP = "inventoryGlobalEp"
    SORT_CLASS_INVENTORY_HOLDER = "inventoryHolder"
    SORT_CLASS_INVENTORY_INVENTORY_EP = "inventoryInventoryEp"
    SORT_CLASS_INVENTORY_INVENTORY_MO_META = "inventoryInventoryMoMeta"
    SORT_CLASS_IP_IPV4_DNS = "ipIPv4Dns"
    SORT_CLASS_IP_IP_V4_ADDR = "ipIpV4Addr"
    SORT_CLASS_IP_IP_V4_STATIC_ADDR = "ipIpV4StaticAddr"
    SORT_CLASS_IP_SERVICE_IF = "ipServiceIf"
    SORT_CLASS_IPPOOL_ADDR = "ippoolAddr"
    SORT_CLASS_IPPOOL_BLOCK = "ippoolBlock"
    SORT_CLASS_IPPOOL_IP_V6_ADDR = "ippoolIpV6Addr"
    SORT_CLASS_IPPOOL_IP_V6_BLOCK = "ippoolIpV6Block"
    SORT_CLASS_IPPOOL_IP_V6_POOLED = "ippoolIpV6Pooled"
    SORT_CLASS_IPPOOL_POOL = "ippoolPool"
    SORT_CLASS_IPPOOL_POOLED = "ippoolPooled"
    SORT_CLASS_IPPOOL_UNIVERSE = "ippoolUniverse"
    SORT_CLASS_IQNPOOL_ABS_BLOCK = "iqnpoolAbsBlock"
    SORT_CLASS_IQNPOOL_ADDR = "iqnpoolAddr"
    SORT_CLASS_IQNPOOL_BLOCK = "iqnpoolBlock"
    SORT_CLASS_IQNPOOL_FORMAT = "iqnpoolFormat"
    SORT_CLASS_IQNPOOL_POOL = "iqnpoolPool"
    SORT_CLASS_IQNPOOL_POOLED = "iqnpoolPooled"
    SORT_CLASS_IQNPOOL_TRANSPORT_BLOCK = "iqnpoolTransportBlock"
    SORT_CLASS_IQNPOOL_UNIVERSE = "iqnpoolUniverse"
    SORT_CLASS_ISCSI_AUTH_PROFILE = "iscsiAuthProfile"
    SORT_CLASS_LICENSE_CAP_PROVIDER = "licenseCapProvider"
    SORT_CLASS_LICENSE_CONTENTS = "licenseContents"
    SORT_CLASS_LICENSE_DOMAIN = "licenseDomain"
    SORT_CLASS_LICENSE_DOWNLOADER = "licenseDownloader"
    SORT_CLASS_LICENSE_DOWNLOADER_FSM = "licenseDownloaderFsm"
    SORT_CLASS_LICENSE_DOWNLOADER_FSM_STAGE = "licenseDownloaderFsmStage"
    SORT_CLASS_LICENSE_DOWNLOADER_FSM_TASK = "licenseDownloaderFsmTask"
    SORT_CLASS_LICENSE_EP = "licenseEp"
    SORT_CLASS_LICENSE_FEATURE = "licenseFeature"
    SORT_CLASS_LICENSE_FEATURE_CAP_PROVIDER = "licenseFeatureCapProvider"
    SORT_CLASS_LICENSE_FEATURE_LINE = "licenseFeatureLine"
    SORT_CLASS_LICENSE_FILE = "licenseFile"
    SORT_CLASS_LICENSE_FILE_FSM = "licenseFileFsm"
    SORT_CLASS_LICENSE_FILE_FSM_STAGE = "licenseFileFsmStage"
    SORT_CLASS_LICENSE_FILE_FSM_TASK = "licenseFileFsmTask"
    SORT_CLASS_LICENSE_INSTANCE = "licenseInstance"
    SORT_CLASS_LICENSE_INSTANCE_FSM = "licenseInstanceFsm"
    SORT_CLASS_LICENSE_INSTANCE_FSM_STAGE = "licenseInstanceFsmStage"
    SORT_CLASS_LICENSE_INSTANCE_FSM_TASK = "licenseInstanceFsmTask"
    SORT_CLASS_LICENSE_LICENSE = "licenseLicense"
    SORT_CLASS_LICENSE_PROP = "licenseProp"
    SORT_CLASS_LICENSE_SERVER_HOST_ID = "licenseServerHostId"
    SORT_CLASS_LICENSE_SOURCE = "licenseSource"
    SORT_CLASS_LICENSE_SOURCE_FILE = "licenseSourceFile"
    SORT_CLASS_LS_BINDING = "lsBinding"
    SORT_CLASS_LS_COMPUTE_BINDING = "lsComputeBinding"
    SORT_CLASS_LS_FC_LOCALE = "lsFcLocale"
    SORT_CLASS_LS_FC_ZONE = "lsFcZone"
    SORT_CLASS_LS_FC_ZONE_GROUP = "lsFcZoneGroup"
    SORT_CLASS_LS_FC_ZONE_MEMBER = "lsFcZoneMember"
    SORT_CLASS_LS_IDENTITY_INFO = "lsIdentityInfo"
    SORT_CLASS_LS_ISSUES = "lsIssues"
    SORT_CLASS_LS_POWER = "lsPower"
    SORT_CLASS_LS_REQUIREMENT = "lsRequirement"
    SORT_CLASS_LS_SPMETA = "lsSPMeta"
    SORT_CLASS_LS_SERVER = "lsServer"
    SORT_CLASS_LS_SERVER_ASSOC_CTX = "lsServerAssocCtx"
    SORT_CLASS_LS_SERVER_EXTENSION = "lsServerExtension"
    SORT_CLASS_LS_SERVER_FSM = "lsServerFsm"
    SORT_CLASS_LS_SERVER_FSM_STAGE = "lsServerFsmStage"
    SORT_CLASS_LS_SERVER_FSM_TASK = "lsServerFsmTask"
    SORT_CLASS_LS_SERVER_OPERATION = "lsServerOperation"
    SORT_CLASS_LS_TIER = "lsTier"
    SORT_CLASS_LS_VCON_ASSIGN = "lsVConAssign"
    SORT_CLASS_LS_WAITING_USER_ACK = "lsWaitingUserAck"
    SORT_CLASS_LS_ZONE_INITIATOR_MEMBER = "lsZoneInitiatorMember"
    SORT_CLASS_LS_ZONE_TARGET_MEMBER = "lsZoneTargetMember"
    SORT_CLASS_LSBOOT_ADEF = "lsbootADef"
    SORT_CLASS_LSBOOT_BOOT_SECURITY = "lsbootBootSecurity"
    SORT_CLASS_LSBOOT_CATEGORY = "lsbootCategory"
    SORT_CLASS_LSBOOT_DEF = "lsbootDef"
    SORT_CLASS_LSBOOT_DEFAULT_LOCAL_IMAGE = "lsbootDefaultLocalImage"
    SORT_CLASS_LSBOOT_EFISHELL = "lsbootEFIShell"
    SORT_CLASS_LSBOOT_EMBEDDED_LOCAL_DISK_IMAGE = "lsbootEmbeddedLocalDiskImage"
    SORT_CLASS_LSBOOT_EMBEDDED_LOCAL_DISK_IMAGE_PATH = "lsbootEmbeddedLocalDiskImagePath"
    SORT_CLASS_LSBOOT_EMBEDDED_LOCAL_LUN_IMAGE = "lsbootEmbeddedLocalLunImage"
    SORT_CLASS_LSBOOT_ISCSI = "lsbootIScsi"
    SORT_CLASS_LSBOOT_ISCSI_IMAGE_PATH = "lsbootIScsiImagePath"
    SORT_CLASS_LSBOOT_IMAGE = "lsbootImage"
    SORT_CLASS_LSBOOT_IMAGE_PATH = "lsbootImagePath"
    SORT_CLASS_LSBOOT_ITEM = "lsbootItem"
    SORT_CLASS_LSBOOT_LAN = "lsbootLan"
    SORT_CLASS_LSBOOT_LAN_IMAGE_PATH = "lsbootLanImagePath"
    SORT_CLASS_LSBOOT_LOCAL_DISK_IMAGE = "lsbootLocalDiskImage"
    SORT_CLASS_LSBOOT_LOCAL_DISK_IMAGE_PATH = "lsbootLocalDiskImagePath"
    SORT_CLASS_LSBOOT_LOCAL_HDD_IMAGE = "lsbootLocalHddImage"
    SORT_CLASS_LSBOOT_LOCAL_IMAGE = "lsbootLocalImage"
    SORT_CLASS_LSBOOT_LOCAL_LUN_IMAGE_PATH = "lsbootLocalLunImagePath"
    SORT_CLASS_LSBOOT_LOCAL_MEDIA_ITEM = "lsbootLocalMediaItem"
    SORT_CLASS_LSBOOT_LOCAL_STORAGE = "lsbootLocalStorage"
    SORT_CLASS_LSBOOT_NVME = "lsbootNvme"
    SORT_CLASS_LSBOOT_NVME_DEVICE = "lsbootNvmeDevice"
    SORT_CLASS_LSBOOT_NVME_DISK_SSD = "lsbootNvmeDiskSsd"
    SORT_CLASS_LSBOOT_NVME_PCI_SSD = "lsbootNvmePciSsd"
    SORT_CLASS_LSBOOT_POLICY = "lsbootPolicy"
    SORT_CLASS_LSBOOT_REMOTE_IMAGE = "lsbootRemoteImage"
    SORT_CLASS_LSBOOT_SAN = "lsbootSan"
    SORT_CLASS_LSBOOT_SAN_CAT_SAN_IMAGE = "lsbootSanCatSanImage"
    SORT_CLASS_LSBOOT_SAN_CAT_SAN_IMAGE_PATH = "lsbootSanCatSanImagePath"
    SORT_CLASS_LSBOOT_SAN_IMAGE = "lsbootSanImage"
    SORT_CLASS_LSBOOT_SAN_IMAGE_PATH = "lsbootSanImagePath"
    SORT_CLASS_LSBOOT_STORAGE = "lsbootStorage"
    SORT_CLASS_LSBOOT_UEFIBOOT_PARAM = "lsbootUEFIBootParam"
    SORT_CLASS_LSBOOT_UPGRADE_STATUS = "lsbootUpgradeStatus"
    SORT_CLASS_LSBOOT_USB_EXTERNAL_IMAGE = "lsbootUsbExternalImage"
    SORT_CLASS_LSBOOT_USB_FLASH_STORAGE_IMAGE = "lsbootUsbFlashStorageImage"
    SORT_CLASS_LSBOOT_USB_INTERNAL_IMAGE = "lsbootUsbInternalImage"
    SORT_CLASS_LSBOOT_VIRTUAL_MEDIA = "lsbootVirtualMedia"
    SORT_CLASS_LSMAINT_ACK = "lsmaintAck"
    SORT_CLASS_LSMAINT_MAINT_POLICY = "lsmaintMaintPolicy"
    SORT_CLASS_LSTORAGE_ASLOT = "lstorageASlot"
    SORT_CLASS_LSTORAGE_ACK = "lstorageAck"
    SORT_CLASS_LSTORAGE_ARRAY_REQUIREMENT = "lstorageArrayRequirement"
    SORT_CLASS_LSTORAGE_BLADE = "lstorageBlade"
    SORT_CLASS_LSTORAGE_CONTROLLER_DEF = "lstorageControllerDef"
    SORT_CLASS_LSTORAGE_CONTROLLER_MODE_CONFIG = "lstorageControllerModeConfig"
    SORT_CLASS_LSTORAGE_CONTROLLER_QUALIFIER = "lstorageControllerQualifier"
    SORT_CLASS_LSTORAGE_CONTROLLER_REF = "lstorageControllerRef"
    SORT_CLASS_LSTORAGE_CTRL_SERVICE_OPERATION = "lstorageCtrlServiceOperation"
    SORT_CLASS_LSTORAGE_DAS_SCSI_LUN = "lstorageDasScsiLun"
    SORT_CLASS_LSTORAGE_DISK_GROUP_CONFIG = "lstorageDiskGroupConfig"
    SORT_CLASS_LSTORAGE_DISK_GROUP_CONFIG_DEF = "lstorageDiskGroupConfigDef"
    SORT_CLASS_LSTORAGE_DISK_GROUP_CONFIG_POLICY = "lstorageDiskGroupConfigPolicy"
    SORT_CLASS_LSTORAGE_DISK_GROUP_QUALIFIER = "lstorageDiskGroupQualifier"
    SORT_CLASS_LSTORAGE_DISK_SLOT = "lstorageDiskSlot"
    SORT_CLASS_LSTORAGE_DISK_ZONING_CONFIG = "lstorageDiskZoningConfig"
    SORT_CLASS_LSTORAGE_DISK_ZONING_CONFIG_DEF = "lstorageDiskZoningConfigDef"
    SORT_CLASS_LSTORAGE_DISK_ZONING_POLICY = "lstorageDiskZoningPolicy"
    SORT_CLASS_LSTORAGE_DRIVE_SECURITY = "lstorageDriveSecurity"
    SORT_CLASS_LSTORAGE_EXTENSION = "lstorageExtension"
    SORT_CLASS_LSTORAGE_ITEM = "lstorageItem"
    SORT_CLASS_LSTORAGE_LOCAL = "lstorageLocal"
    SORT_CLASS_LSTORAGE_LOCAL_CONFIG = "lstorageLocalConfig"
    SORT_CLASS_LSTORAGE_LOCAL_DEF = "lstorageLocalDef"
    SORT_CLASS_LSTORAGE_LOCAL_DISK_CONFIG_REF = "lstorageLocalDiskConfigRef"
    SORT_CLASS_LSTORAGE_LOCAL_DISK_REF = "lstorageLocalDiskRef"
    SORT_CLASS_LSTORAGE_LOGIN = "lstorageLogin"
    SORT_CLASS_LSTORAGE_META = "lstorageMeta"
    SORT_CLASS_LSTORAGE_PROCESSOR_BASE = "lstorageProcessorBase"
    SORT_CLASS_LSTORAGE_PROFILE = "lstorageProfile"
    SORT_CLASS_LSTORAGE_PROFILE_BASE = "lstorageProfileBase"
    SORT_CLASS_LSTORAGE_PROFILE_BINDING = "lstorageProfileBinding"
    SORT_CLASS_LSTORAGE_PROFILE_BINDING_BASE = "lstorageProfileBindingBase"
    SORT_CLASS_LSTORAGE_PROFILE_DEF = "lstorageProfileDef"
    SORT_CLASS_LSTORAGE_QUAL_ITEM = "lstorageQualItem"
    SORT_CLASS_LSTORAGE_RECURR_WINDOW = "lstorageRecurrWindow"
    SORT_CLASS_LSTORAGE_REMOTE = "lstorageRemote"
    SORT_CLASS_LSTORAGE_REMOTE_CONFIG = "lstorageRemoteConfig"
    SORT_CLASS_LSTORAGE_REMOTE_DEF = "lstorageRemoteDef"
    SORT_CLASS_LSTORAGE_REQUEST_CTX = "lstorageRequestCtx"
    SORT_CLASS_LSTORAGE_SCSI_LUN = "lstorageScsiLun"
    SORT_CLASS_LSTORAGE_SECURITY = "lstorageSecurity"
    SORT_CLASS_LSTORAGE_VIRTUAL_DRIVE_DEF = "lstorageVirtualDriveDef"
    SORT_CLASS_MACPOOL_ADDR = "macpoolAddr"
    SORT_CLASS_MACPOOL_BLOCK = "macpoolBlock"
    SORT_CLASS_MACPOOL_FORMAT = "macpoolFormat"
    SORT_CLASS_MACPOOL_POOL = "macpoolPool"
    SORT_CLASS_MACPOOL_POOLED = "macpoolPooled"
    SORT_CLASS_MACPOOL_UNIVERSE = "macpoolUniverse"
    SORT_CLASS_MEMORY_ARRAY = "memoryArray"
    SORT_CLASS_MEMORY_ARRAY_ENV_STATS = "memoryArrayEnvStats"
    SORT_CLASS_MEMORY_ARRAY_ENV_STATS_HIST = "memoryArrayEnvStatsHist"
    SORT_CLASS_MEMORY_BUFFER_UNIT = "memoryBufferUnit"
    SORT_CLASS_MEMORY_BUFFER_UNIT_ENV_STATS = "memoryBufferUnitEnvStats"
    SORT_CLASS_MEMORY_BUFFER_UNIT_ENV_STATS_HIST = "memoryBufferUnitEnvStatsHist"
    SORT_CLASS_MEMORY_CONTROLLER = "memoryController"
    SORT_CLASS_MEMORY_ERROR_STATS = "memoryErrorStats"
    SORT_CLASS_MEMORY_ERROR_STATS_HIST = "memoryErrorStatsHist"
    SORT_CLASS_MEMORY_NV_DIMM = "memoryNvDimm"
    SORT_CLASS_MEMORY_NV_DIMM_BATTERY = "memoryNvDimmBattery"
    SORT_CLASS_MEMORY_NV_DIMM_CONTROLLER = "memoryNvDimmController"
    SORT_CLASS_MEMORY_QUAL = "memoryQual"
    SORT_CLASS_MEMORY_RUNTIME = "memoryRuntime"
    SORT_CLASS_MEMORY_RUNTIME_HIST = "memoryRuntimeHist"
    SORT_CLASS_MEMORY_UNIT = "memoryUnit"
    SORT_CLASS_MEMORY_UNIT_ENV_STATS = "memoryUnitEnvStats"
    SORT_CLASS_MEMORY_UNIT_ENV_STATS_HIST = "memoryUnitEnvStatsHist"
    SORT_CLASS_MESSAGE_ENTRY = "messageEntry"
    SORT_CLASS_MESSAGE_EP = "messageEp"
    SORT_CLASS_MGMT_AKMIP_CERT_POLICY = "mgmtAKmipCertPolicy"
    SORT_CLASS_MGMT_ASECURE_BOOT = "mgmtASecureBoot"
    SORT_CLASS_MGMT_ABS_BACKUP = "mgmtAbsBackup"
    SORT_CLASS_MGMT_ABS_DATA_ITEM = "mgmtAbsDataItem"
    SORT_CLASS_MGMT_ABS_IMPORTER = "mgmtAbsImporter"
    SORT_CLASS_MGMT_BACKUP = "mgmtBackup"
    SORT_CLASS_MGMT_BACKUP_FSM = "mgmtBackupFsm"
    SORT_CLASS_MGMT_BACKUP_FSM_STAGE = "mgmtBackupFsmStage"
    SORT_CLASS_MGMT_BACKUP_FSM_TASK = "mgmtBackupFsmTask"
    SORT_CLASS_MGMT_BACKUP_OPERATION = "mgmtBackupOperation"
    SORT_CLASS_MGMT_BACKUP_POLICY = "mgmtBackupPolicy"
    SORT_CLASS_MGMT_BACKUP_TRIGGER = "mgmtBackupTrigger"
    SORT_CLASS_MGMT_BACKUP_TRIGGER_FSM = "mgmtBackupTriggerFsm"
    SORT_CLASS_MGMT_BACKUP_TRIGGER_FSM_STAGE = "mgmtBackupTriggerFsmStage"
    SORT_CLASS_MGMT_BACKUP_TRIGGER_FSM_TASK = "mgmtBackupTriggerFsmTask"
    SORT_CLASS_MGMT_CFG_EXPORT_POLICY = "mgmtCfgExportPolicy"
    SORT_CLASS_MGMT_CIMC_INTERFACE = "mgmtCimcInterface"
    SORT_CLASS_MGMT_CMC_SECURE_BOOT = "mgmtCmcSecureBoot"
    SORT_CLASS_MGMT_CMC_SECURE_BOOT_OPERATION = "mgmtCmcSecureBootOperation"
    SORT_CLASS_MGMT_CONNECTION = "mgmtConnection"
    SORT_CLASS_MGMT_CONTROLLER = "mgmtController"
    SORT_CLASS_MGMT_DATA_EXPORTER = "mgmtDataExporter"
    SORT_CLASS_MGMT_DATA_EXPORTER_FSM = "mgmtDataExporterFsm"
    SORT_CLASS_MGMT_DATA_EXPORTER_FSM_STAGE = "mgmtDataExporterFsmStage"
    SORT_CLASS_MGMT_DATA_EXPORTER_FSM_TASK = "mgmtDataExporterFsmTask"
    SORT_CLASS_MGMT_DATA_IMPORTER = "mgmtDataImporter"
    SORT_CLASS_MGMT_DATA_IMPORTER_FSM = "mgmtDataImporterFsm"
    SORT_CLASS_MGMT_DATA_IMPORTER_FSM_STAGE = "mgmtDataImporterFsmStage"
    SORT_CLASS_MGMT_DATA_IMPORTER_FSM_TASK = "mgmtDataImporterFsmTask"
    SORT_CLASS_MGMT_DATA_ITEM = "mgmtDataItem"
    SORT_CLASS_MGMT_ENTITY = "mgmtEntity"
    SORT_CLASS_MGMT_EP = "mgmtEp"
    SORT_CLASS_MGMT_EXPORT_POLICY = "mgmtExportPolicy"
    SORT_CLASS_MGMT_IPV6_ADDR = "mgmtIPv6Addr"
    SORT_CLASS_MGMT_IPV6_IF_ADDR = "mgmtIPv6IfAddr"
    SORT_CLASS_MGMT_IPV6_IF_CONFIG = "mgmtIPv6IfConfig"
    SORT_CLASS_MGMT_IF = "mgmtIf"
    SORT_CLASS_MGMT_IF_FSM = "mgmtIfFsm"
    SORT_CLASS_MGMT_IF_FSM_STAGE = "mgmtIfFsmStage"
    SORT_CLASS_MGMT_IF_FSM_TASK = "mgmtIfFsmTask"
    SORT_CLASS_MGMT_IMPORT_ITEM = "mgmtImportItem"
    SORT_CLASS_MGMT_IMPORTER = "mgmtImporter"
    SORT_CLASS_MGMT_IMPORTER_FSM = "mgmtImporterFsm"
    SORT_CLASS_MGMT_IMPORTER_FSM_STAGE = "mgmtImporterFsmStage"
    SORT_CLASS_MGMT_IMPORTER_FSM_TASK = "mgmtImporterFsmTask"
    SORT_CLASS_MGMT_INBAND_PROFILE = "mgmtInbandProfile"
    SORT_CLASS_MGMT_INTERFACE = "mgmtInterface"
    SORT_CLASS_MGMT_KMIP = "mgmtKmip"
    SORT_CLASS_MGMT_KMIP_CERT_POLICY = "mgmtKmipCertPolicy"
    SORT_CLASS_MGMT_KMIP_OPERATION = "mgmtKmipOperation"
    SORT_CLASS_MGMT_NAMED_KMIP_CERT_POLICY = "mgmtNamedKmipCertPolicy"
    SORT_CLASS_MGMT_REGISTRY_INFO = "mgmtRegistryInfo"
    SORT_CLASS_MGMT_REGISTRY_INFO_FSM = "mgmtRegistryInfoFsm"
    SORT_CLASS_MGMT_REGISTRY_INFO_FSM_STAGE = "mgmtRegistryInfoFsmStage"
    SORT_CLASS_MGMT_REGISTRY_INFO_FSM_TASK = "mgmtRegistryInfoFsmTask"
    SORT_CLASS_MGMT_SECURITY = "mgmtSecurity"
    SORT_CLASS_MGMT_SVC = "mgmtSvc"
    SORT_CLASS_MGMT_VNET = "mgmtVnet"
    SORT_CLASS_MO_TOP_PROPS = "moTopProps"
    SORT_CLASS_NAMING_BINDING = "namingBinding"
    SORT_CLASS_NAMING_DEFINITION = "namingDefinition"
    SORT_CLASS_NAMING_HOLDER = "namingHolder"
    SORT_CLASS_NAMING_NAMED_IDENTIFIED_OBJECT = "namingNamedIdentifiedObject"
    SORT_CLASS_NAMING_NAMED_OBJECT = "namingNamedObject"
    SORT_CLASS_NAMING_OBJECT = "namingObject"
    SORT_CLASS_NET_NET_GROUP_PERMIT = "netNetGroupPermit"
    SORT_CLASS_NETWORK_CACERT = "networkCACert"
    SORT_CLASS_NETWORK_CIO_EP = "networkCIoEp"
    SORT_CLASS_NETWORK_CONN = "networkConn"
    SORT_CLASS_NETWORK_ELEMENT = "networkElement"
    SORT_CLASS_NETWORK_ELEMENT_FSM = "networkElementFsm"
    SORT_CLASS_NETWORK_ELEMENT_FSM_STAGE = "networkElementFsmStage"
    SORT_CLASS_NETWORK_ELEMENT_FSM_TASK = "networkElementFsmTask"
    SORT_CLASS_NETWORK_ELEMENT_OPERATION = "networkElementOperation"
    SORT_CLASS_NETWORK_EP = "networkEp"
    SORT_CLASS_NETWORK_IF_EP = "networkIfEp"
    SORT_CLASS_NETWORK_PIO_EP = "networkPIoEp"
    SORT_CLASS_NETWORK_PHYS_EP = "networkPhysEp"
    SORT_CLASS_NETWORK_SYSTEM_CACERT = "networkSystemCACert"
    SORT_CLASS_NETWORK_VNET_EP = "networkVnetEp"
    SORT_CLASS_NFS_CLIENT_DEF = "nfsClientDef"
    SORT_CLASS_NFS_CLIENT_DEF_FSM = "nfsClientDefFsm"
    SORT_CLASS_NFS_CLIENT_DEF_FSM_STAGE = "nfsClientDefFsmStage"
    SORT_CLASS_NFS_CLIENT_DEF_FSM_TASK = "nfsClientDefFsmTask"
    SORT_CLASS_NFS_EP = "nfsEp"
    SORT_CLASS_NFS_EXPORT_DEF = "nfsExportDef"
    SORT_CLASS_NFS_EXPORT_DEF_FSM = "nfsExportDefFsm"
    SORT_CLASS_NFS_EXPORT_DEF_FSM_STAGE = "nfsExportDefFsmStage"
    SORT_CLASS_NFS_EXPORT_DEF_FSM_TASK = "nfsExportDefFsmTask"
    SORT_CLASS_NFS_MOUNT_DEF = "nfsMountDef"
    SORT_CLASS_NFS_REPOSITORY_SPEC_POLICY = "nfsRepositorySpecPolicy"
    SORT_CLASS_NWCTRL_DEFINITION = "nwctrlDefinition"
    SORT_CLASS_OBSERVE_FILTER = "observeFilter"
    SORT_CLASS_OBSERVE_OBSERVED = "observeObserved"
    SORT_CLASS_OBSERVE_OBSERVED_CONT = "observeObservedCont"
    SORT_CLASS_OBSERVE_OBSERVED_FSM = "observeObservedFsm"
    SORT_CLASS_OBSERVE_OBSERVED_FSM_STAGE = "observeObservedFsmStage"
    SORT_CLASS_OBSERVE_OBSERVED_FSM_TASK = "observeObservedFsmTask"
    SORT_CLASS_ORG_AORG = "orgAOrg"
    SORT_CLASS_ORG_DOMAIN_FIRMWARE_INFO = "orgDomainFirmwareInfo"
    SORT_CLASS_ORG_DOMAIN_GROUP = "orgDomainGroup"
    SORT_CLASS_ORG_DOMAIN_GROUP_FIRMWARE_REPORT = "orgDomainGroupFirmwareReport"
    SORT_CLASS_ORG_DOMAIN_GROUP_POLICY = "orgDomainGroupPolicy"
    SORT_CLASS_ORG_DOMAIN_GROUP_POLICY_REPORT = "orgDomainGroupPolicyReport"
    SORT_CLASS_ORG_DOMAIN_GROUP_REPORT = "orgDomainGroupReport"
    SORT_CLASS_ORG_EXTENSION = "orgExtension"
    SORT_CLASS_ORG_FIRMWARE_VERSION_COUNT = "orgFirmwareVersionCount"
    SORT_CLASS_ORG_MAINT_TAG_FIRMWARE_REPORT = "orgMaintTagFirmwareReport"
    SORT_CLASS_ORG_ORG = "orgOrg"
    SORT_CLASS_ORG_ORG_FSM = "orgOrgFsm"
    SORT_CLASS_ORG_ORG_FSM_STAGE = "orgOrgFsmStage"
    SORT_CLASS_ORG_ORG_FSM_TASK = "orgOrgFsmTask"
    SORT_CLASS_ORG_ORG_SOURCE = "orgOrgSource"
    SORT_CLASS_ORG_SOURCE_MASK = "orgSourceMask"
    SORT_CLASS_OS_CONTROLLER = "osController"
    SORT_CLASS_OS_ETH_BOND_INTF = "osEthBondIntf"
    SORT_CLASS_OS_ETH_BOND_MODE = "osEthBondMode"
    SORT_CLASS_OS_ETH_INTF = "osEthIntf"
    SORT_CLASS_OS_INSTANCE = "osInstance"
    SORT_CLASS_OS_INTF = "osIntf"
    SORT_CLASS_OS_LINK_MONITORING_POLICY = "osLinkMonitoringPolicy"
    SORT_CLASS_OS_PRIMARY_SLAVE = "osPrimarySlave"
    SORT_CLASS_PCI_CARD = "pciCard"
    SORT_CLASS_PKI_CERT_REQ = "pkiCertReq"
    SORT_CLASS_PKI_DEFINITION = "pkiDefinition"
    SORT_CLASS_PKI_EP = "pkiEp"
    SORT_CLASS_PKI_EP_FSM = "pkiEpFsm"
    SORT_CLASS_PKI_EP_FSM_STAGE = "pkiEpFsmStage"
    SORT_CLASS_PKI_EP_FSM_TASK = "pkiEpFsmTask"
    SORT_CLASS_PKI_ITEM = "pkiItem"
    SORT_CLASS_PKI_KEY_RING = "pkiKeyRing"
    SORT_CLASS_PKI_TP = "pkiTP"
    SORT_CLASS_POLICY_ADEST_EP = "policyADestEp"
    SORT_CLASS_POLICY_ACK_SUSPEND_OPERATION = "policyAckSuspendOperation"
    SORT_CLASS_POLICY_BINDING = "policyBinding"
    SORT_CLASS_POLICY_CHILD_CLASS = "policyChildClass"
    SORT_CLASS_POLICY_CLUSTER = "policyCluster"
    SORT_CLASS_POLICY_COMMUNICATION = "policyCommunication"
    SORT_CLASS_POLICY_COMMUNICATION_OP = "policyCommunicationOp"
    SORT_CLASS_POLICY_CONFIG_BACKUP = "policyConfigBackup"
    SORT_CLASS_POLICY_CONFIG_BACKUP_OP = "policyConfigBackupOp"
    SORT_CLASS_POLICY_CONFIG_ERROR = "policyConfigError"
    SORT_CLASS_POLICY_CONTEXT = "policyContext"
    SORT_CLASS_POLICY_CONTROL = "policyControl"
    SORT_CLASS_POLICY_CONTROL_EP = "policyControlEp"
    SORT_CLASS_POLICY_CONTROL_EP_OP = "policyControlEpOp"
    SORT_CLASS_POLICY_CONTROL_EP_OP_FSM = "policyControlEpOpFsm"
    SORT_CLASS_POLICY_CONTROL_EP_OP_FSM_STAGE = "policyControlEpOpFsmStage"
    SORT_CLASS_POLICY_CONTROL_EP_OP_FSM_TASK = "policyControlEpOpFsmTask"
    SORT_CLASS_POLICY_CONTROL_EP_OPERATION = "policyControlEpOperation"
    SORT_CLASS_POLICY_CONTROL_OP = "policyControlOp"
    SORT_CLASS_POLICY_CONTROLLED = "policyControlled"
    SORT_CLASS_POLICY_CONTROLLED_INSTANCE = "policyControlledInstance"
    SORT_CLASS_POLICY_CONTROLLED_TYPE = "policyControlledType"
    SORT_CLASS_POLICY_DATE_TIME = "policyDateTime"
    SORT_CLASS_POLICY_DATE_TIME_OP = "policyDateTimeOp"
    SORT_CLASS_POLICY_DEFINITION = "policyDefinition"
    SORT_CLASS_POLICY_DEST_CLASS = "policyDestClass"
    SORT_CLASS_POLICY_DEST_EP = "policyDestEp"
    SORT_CLASS_POLICY_DEVICE_PROFILE = "policyDeviceProfile"
    SORT_CLASS_POLICY_DIGEST = "policyDigest"
    SORT_CLASS_POLICY_DISCOVERY = "policyDiscovery"
    SORT_CLASS_POLICY_DISCOVERY_OP = "policyDiscoveryOp"
    SORT_CLASS_POLICY_DNS = "policyDns"
    SORT_CLASS_POLICY_DNS_OP = "policyDnsOp"
    SORT_CLASS_POLICY_ELEMENT = "policyElement"
    SORT_CLASS_POLICY_EQUIPMENT = "policyEquipment"
    SORT_CLASS_POLICY_EQUIPMENT_OP = "policyEquipmentOp"
    SORT_CLASS_POLICY_FAULT = "policyFault"
    SORT_CLASS_POLICY_FAULT_OP = "policyFaultOp"
    SORT_CLASS_POLICY_IDENTIFIER_POLICY = "policyIdentifierPolicy"
    SORT_CLASS_POLICY_INFRA_FIRMWARE = "policyInfraFirmware"
    SORT_CLASS_POLICY_INFRA_FIRMWARE_OP = "policyInfraFirmwareOp"
    SORT_CLASS_POLICY_ITEM = "policyItem"
    SORT_CLASS_POLICY_LOCAL_MAP = "policyLocalMap"
    SORT_CLASS_POLICY_LOG_PROFILE = "policyLogProfile"
    SORT_CLASS_POLICY_MEP = "policyMEp"
    SORT_CLASS_POLICY_MEP_OP = "policyMEpOp"
    SORT_CLASS_POLICY_MONITORING = "policyMonitoring"
    SORT_CLASS_POLICY_MONITORING_OP = "policyMonitoringOp"
    SORT_CLASS_POLICY_OBJECT = "policyObject"
    SORT_CLASS_POLICY_POLICY_DEST_CLASS = "policyPolicyDestClass"
    SORT_CLASS_POLICY_POLICY_EP = "policyPolicyEp"
    SORT_CLASS_POLICY_POLICY_REQUESTOR = "policyPolicyRequestor"
    SORT_CLASS_POLICY_POLICY_SCOPE = "policyPolicyScope"
    SORT_CLASS_POLICY_POLICY_SCOPE_CONT = "policyPolicyScopeCont"
    SORT_CLASS_POLICY_POLICY_SCOPE_CONTEXT = "policyPolicyScopeContext"
    SORT_CLASS_POLICY_POLICY_SCOPE_FSM = "policyPolicyScopeFsm"
    SORT_CLASS_POLICY_POLICY_SCOPE_FSM_STAGE = "policyPolicyScopeFsmStage"
    SORT_CLASS_POLICY_POLICY_SCOPE_FSM_TASK = "policyPolicyScopeFsmTask"
    SORT_CLASS_POLICY_PORT_CONFIG = "policyPortConfig"
    SORT_CLASS_POLICY_PORT_CONFIG_OP = "policyPortConfigOp"
    SORT_CLASS_POLICY_POWER_MGMT = "policyPowerMgmt"
    SORT_CLASS_POLICY_POWER_MGMT_OP = "policyPowerMgmtOp"
    SORT_CLASS_POLICY_PROXY_MO = "policyProxyMo"
    SORT_CLASS_POLICY_PSU = "policyPsu"
    SORT_CLASS_POLICY_PSU_OP = "policyPsuOp"
    SORT_CLASS_POLICY_REQUESTOR = "policyRequestor"
    SORT_CLASS_POLICY_SCOPE = "policyScope"
    SORT_CLASS_POLICY_SECURITY = "policySecurity"
    SORT_CLASS_POLICY_SECURITY_OP = "policySecurityOp"
    SORT_CLASS_POLICY_SOURCE = "policySource"
    SORT_CLASS_POLICY_SOURCE_APP = "policySourceApp"
    SORT_CLASS_POLICY_STORAGE_AUTO_CONFIG = "policyStorageAutoConfig"
    SORT_CLASS_POLICY_STORAGE_AUTO_CONFIG_OP = "policyStorageAutoConfigOp"
    SORT_CLASS_POLICY_SYSTEM_EP = "policySystemEp"
    SORT_CLASS_POLICY_SYSTEM_PROFILE = "policySystemProfile"
    SORT_CLASS_POLICY_TRACKED = "policyTracked"
    SORT_CLASS_POLICY_TRACKER = "policyTracker"
    SORT_CLASS_POLICY_UNIVERSE = "policyUniverse"
    SORT_CLASS_POOL_ASNMT = "poolAsnmt"
    SORT_CLASS_POOL_ELEMENT = "poolElement"
    SORT_CLASS_POOL_ELEMENT_ALLOC = "poolElementAlloc"
    SORT_CLASS_POOL_MEMBER = "poolMember"
    SORT_CLASS_POOL_POOL = "poolPool"
    SORT_CLASS_POOL_POOL_MEMBER = "poolPoolMember"
    SORT_CLASS_POOL_POOLABLE = "poolPoolable"
    SORT_CLASS_POOL_UNIVERSE = "poolUniverse"
    SORT_CLASS_PORT_GROUP = "portGroup"
    SORT_CLASS_PORT_INT_FIO = "portIntFIo"
    SORT_CLASS_PORT_PIO = "portPIo"
    SORT_CLASS_PORT_PHYS_SWITCH_IO = "portPhysSwitchIo"
    SORT_CLASS_PORT_SERVER_INT_FIO = "portServerIntFIo"
    SORT_CLASS_PORT_SUB_GROUP = "portSubGroup"
    SORT_CLASS_PORT_SWITCH_INT_FIO = "portSwitchIntFIo"
    SORT_CLASS_POWER_ABUDGET = "powerABudget"
    SORT_CLASS_POWER_AGROUP = "powerAGroup"
    SORT_CLASS_POWER_BUDGET = "powerBudget"
    SORT_CLASS_POWER_CHASSIS_MEMBER = "powerChassisMember"
    SORT_CLASS_POWER_EP = "powerEp"
    SORT_CLASS_POWER_GROUP = "powerGroup"
    SORT_CLASS_POWER_GROUP_MEMBER = "powerGroupMember"
    SORT_CLASS_POWER_GROUP_QUAL = "powerGroupQual"
    SORT_CLASS_POWER_GROUP_STATS = "powerGroupStats"
    SORT_CLASS_POWER_GROUP_STATS_HIST = "powerGroupStatsHist"
    SORT_CLASS_POWER_MGMT_POLICY = "powerMgmtPolicy"
    SORT_CLASS_POWER_POLICY = "powerPolicy"
    SORT_CLASS_POWER_PROFILED_POWER = "powerProfiledPower"
    SORT_CLASS_PROC_DOER = "procDoer"
    SORT_CLASS_PROC_MANAGER = "procManager"
    SORT_CLASS_PROC_PROC_COUNTS = "procProcCounts"
    SORT_CLASS_PROC_PROCS = "procProcs"
    SORT_CLASS_PROC_PRT = "procPrt"
    SORT_CLASS_PROC_PRT_COUNTS = "procPrtCounts"
    SORT_CLASS_PROC_STIMULUS_COUNTS = "procStimulusCounts"
    SORT_CLASS_PROC_SVC = "procSvc"
    SORT_CLASS_PROC_TX_COUNTS = "procTxCounts"
    SORT_CLASS_PROCESSOR_ENV_STATS = "processorEnvStats"
    SORT_CLASS_PROCESSOR_ENV_STATS_HIST = "processorEnvStatsHist"
    SORT_CLASS_PROCESSOR_ERROR_STATS = "processorErrorStats"
    SORT_CLASS_PROCESSOR_ERROR_STATS_HIST = "processorErrorStatsHist"
    SORT_CLASS_PROCESSOR_QUAL = "processorQual"
    SORT_CLASS_PROCESSOR_RUNTIME = "processorRuntime"
    SORT_CLASS_PROCESSOR_RUNTIME_HIST = "processorRuntimeHist"
    SORT_CLASS_PROCESSOR_UNIT = "processorUnit"
    SORT_CLASS_PROCESSOR_UNIT_ASSOC_CTX = "processorUnitAssocCtx"
    SORT_CLASS_QOS_DEFINITION = "qosDefinition"
    SORT_CLASS_QOS_ITEM = "qosItem"
    SORT_CLASS_QOSCLASS_DEFINITION = "qosclassDefinition"
    SORT_CLASS_QOSCLASS_ETH = "qosclassEth"
    SORT_CLASS_QOSCLASS_ETH_BE = "qosclassEthBE"
    SORT_CLASS_QOSCLASS_ETH_CLASSIFIED = "qosclassEthClassified"
    SORT_CLASS_QOSCLASS_FC = "qosclassFc"
    SORT_CLASS_QOSCLASS_ITEM = "qosclassItem"
    SORT_CLASS_QOSCLASS_POLICY = "qosclassPolicy"
    SORT_CLASS_QUERY_CONTEXT = "queryContext"
    SORT_CLASS_QUERY_DEPENDENCY_CONTEXT = "queryDependencyContext"
    SORT_CLASS_QUERY_DEPENDENCY_REF = "queryDependencyRef"
    SORT_CLASS_QUERY_EP = "queryEp"
    SORT_CLASS_QUERY_IMPORT_CONTEXT = "queryImportContext"
    SORT_CLASS_QUERY_USAGE_CONTEXT = "queryUsageContext"
    SORT_CLASS_QUERYRESULT_DEPENDENCY = "queryresultDependency"
    SORT_CLASS_QUERYRESULT_DEST_ORG_EP = "queryresultDestOrgEp"
    SORT_CLASS_QUERYRESULT_DOMAIN_GROUP_EP = "queryresultDomainGroupEp"
    SORT_CLASS_QUERYRESULT_ITEM = "queryresultItem"
    SORT_CLASS_QUERYRESULT_ORG_EP = "queryresultOrgEp"
    SORT_CLASS_QUERYRESULT_USAGE = "queryresultUsage"
    SORT_CLASS_RULE_DEFINITION = "ruleDefinition"
    SORT_CLASS_RULE_ITEM = "ruleItem"
    SORT_CLASS_RULE_REQUIREMENT = "ruleRequirement"
    SORT_CLASS_RULE_SIZE_REQUIREMENT = "ruleSizeRequirement"
    SORT_CLASS_SECURITY_UNIT = "securityUnit"
    SORT_CLASS_SES_DISK_SLOT_EP = "sesDiskSlotEp"
    SORT_CLASS_SES_ENCLOSURE = "sesEnclosure"
    SORT_CLASS_SMARTCALLHOME_HTTP_PROXY = "smartcallhomeHttpProxy"
    SORT_CLASS_SMARTCALLHOME_PERIODIC_INVENTORY_STATUS = "smartcallhomePeriodicInventoryStatus"
    SORT_CLASS_SMARTCALLHOME_PERIODIC_SYSTEM_INVENTORY = "smartcallhomePeriodicSystemInventory"
    SORT_CLASS_SMARTCALLHOME_POLICY = "smartcallhomePolicy"
    SORT_CLASS_SMARTCALLHOME_PROFILE = "smartcallhomeProfile"
    SORT_CLASS_SMARTCALLHOME_SOURCE = "smartcallhomeSource"
    SORT_CLASS_SMARTCALLHOME_TRANSPORT_GATEWAY = "smartcallhomeTransportGateway"
    SORT_CLASS_SMARTLICENSE_AGENT = "smartlicenseAgent"
    SORT_CLASS_SMARTLICENSE_AGENT_FSM = "smartlicenseAgentFsm"
    SORT_CLASS_SMARTLICENSE_AGENT_FSM_STAGE = "smartlicenseAgentFsmStage"
    SORT_CLASS_SMARTLICENSE_AGENT_FSM_TASK = "smartlicenseAgentFsmTask"
    SORT_CLASS_SMARTLICENSE_ENTITLEMENT = "smartlicenseEntitlement"
    SORT_CLASS_SMARTLICENSE_ENTITLEMENT_EP = "smartlicenseEntitlementEp"
    SORT_CLASS_SMARTLICENSE_ENTITLEMENT_EP_FSM = "smartlicenseEntitlementEpFsm"
    SORT_CLASS_SMARTLICENSE_ENTITLEMENT_EP_FSM_STAGE = "smartlicenseEntitlementEpFsmStage"
    SORT_CLASS_SMARTLICENSE_ENTITLEMENT_EP_FSM_TASK = "smartlicenseEntitlementEpFsmTask"
    SORT_CLASS_SMARTLICENSE_EP = "smartlicenseEp"
    SORT_CLASS_SMARTLICENSE_HOLDER = "smartlicenseHolder"
    SORT_CLASS_SMARTLICENSE_HOLDER_FSM = "smartlicenseHolderFsm"
    SORT_CLASS_SMARTLICENSE_HOLDER_FSM_STAGE = "smartlicenseHolderFsmStage"
    SORT_CLASS_SMARTLICENSE_HOLDER_FSM_TASK = "smartlicenseHolderFsmTask"
    SORT_CLASS_SMARTLICENSE_TEST = "smartlicenseTest"
    SORT_CLASS_SMARTLICENSE_TEST_FSM = "smartlicenseTestFsm"
    SORT_CLASS_SMARTLICENSE_TEST_FSM_STAGE = "smartlicenseTestFsmStage"
    SORT_CLASS_SMARTLICENSE_TEST_FSM_TASK = "smartlicenseTestFsmTask"
    SORT_CLASS_SOL_DEF = "solDef"
    SORT_CLASS_SOL_POLICY = "solPolicy"
    SORT_CLASS_STATS_CHART = "statsChart"
    SORT_CLASS_STATS_CHART_CONTAINER = "statsChartContainer"
    SORT_CLASS_STATS_COLLECTION_POLICY = "statsCollectionPolicy"
    SORT_CLASS_STATS_CURR = "statsCurr"
    SORT_CLASS_STATS_CUSTOM_CHART = "statsCustomChart"
    SORT_CLASS_STATS_CUSTOM_EP = "statsCustomEp"
    SORT_CLASS_STATS_DB_MIGRATION_STATUS = "statsDbMigrationStatus"
    SORT_CLASS_STATS_DB_SUMMARY_META = "statsDbSummaryMeta"
    SORT_CLASS_STATS_HIST = "statsHist"
    SORT_CLASS_STATS_HOLDER = "statsHolder"
    SORT_CLASS_STATS_INVENTORY_META = "statsInventoryMeta"
    SORT_CLASS_STATS_ITEM = "statsItem"
    SORT_CLASS_STATS_PASADENA_COLLECTION_POLICY = "statsPasadenaCollectionPolicy"
    SORT_CLASS_STATS_STANDARD_CHART = "statsStandardChart"
    SORT_CLASS_STATS_STANDARD_EP = "statsStandardEp"
    SORT_CLASS_STATS_STATS_QUERY = "statsStatsQuery"
    SORT_CLASS_STATS_STATS_QUERY_HOLDER = "statsStatsQueryHolder"
    SORT_CLASS_STATS_THR32_DEFINITION = "statsThr32Definition"
    SORT_CLASS_STATS_THR32_VALUE = "statsThr32Value"
    SORT_CLASS_STATS_THR64_DEFINITION = "statsThr64Definition"
    SORT_CLASS_STATS_THR64_VALUE = "statsThr64Value"
    SORT_CLASS_STATS_THR_FLOAT_DEFINITION = "statsThrFloatDefinition"
    SORT_CLASS_STATS_THR_FLOAT_VALUE = "statsThrFloatValue"
    SORT_CLASS_STATS_THRESHOLD_CLASS = "statsThresholdClass"
    SORT_CLASS_STATS_THRESHOLD_DEFINITION = "statsThresholdDefinition"
    SORT_CLASS_STATS_THRESHOLD_POLICY = "statsThresholdPolicy"
    SORT_CLASS_STATS_THRESHOLD_VALUE = "statsThresholdValue"
    SORT_CLASS_STORAGE_ADEF = "storageADef"
    SORT_CLASS_STORAGE_ALUN = "storageALun"
    SORT_CLASS_STORAGE_ALUN_REF_BASE = "storageALunRefBase"
    SORT_CLASS_STORAGE_ASCSI_LUN = "storageAScsiLun"
    SORT_CLASS_STORAGE_ASCSI_LUN_CTX = "storageAScsiLunCtx"
    SORT_CLASS_STORAGE_ASLOT = "storageASlot"
    SORT_CLASS_STORAGE_ASNAP_REPLICA_LUN_CTX = "storageASnapReplicaLunCtx"
    SORT_CLASS_STORAGE_AVOLUME = "storageAVolume"
    SORT_CLASS_STORAGE_APPLIANCE = "storageAppliance"
    SORT_CLASS_STORAGE_ARRAY = "storageArray"
    SORT_CLASS_STORAGE_AUTH_KEY = "storageAuthKey"
    SORT_CLASS_STORAGE_BACKSTORE = "storageBackstore"
    SORT_CLASS_STORAGE_BLADE = "storageBlade"
    SORT_CLASS_STORAGE_CLOUD = "storageCloud"
    SORT_CLASS_STORAGE_CLUSTER_ID_UNIVERSE = "storageClusterIdUniverse"
    SORT_CLASS_STORAGE_COMPUTE_BLADE_OPERATION = "storageComputeBladeOperation"
    SORT_CLASS_STORAGE_CONNECTION_DEF = "storageConnectionDef"
    SORT_CLASS_STORAGE_CONNECTION_POLICY = "storageConnectionPolicy"
    SORT_CLASS_STORAGE_CONTAINER = "storageContainer"
    SORT_CLASS_STORAGE_CONTROLLER = "storageController"
    SORT_CLASS_STORAGE_CONTROLLER_BASE = "storageControllerBase"
    SORT_CLASS_STORAGE_CONTROLLER_EP = "storageControllerEp"
    SORT_CLASS_STORAGE_CONTROLLER_OPERATION = "storageControllerOperation"
    SORT_CLASS_STORAGE_CONTROLLER_REF = "storageControllerRef"
    SORT_CLASS_STORAGE_CTRL_STORAGE_STATS = "storageCtrlStorageStats"
    SORT_CLASS_STORAGE_CTRL_STORAGE_STATS_HIST = "storageCtrlStorageStatsHist"
    SORT_CLASS_STORAGE_DEVICE = "storageDevice"
    SORT_CLASS_STORAGE_DISK_ENV_STATS = "storageDiskEnvStats"
    SORT_CLASS_STORAGE_DISK_ENV_STATS_HIST = "storageDiskEnvStatsHist"
    SORT_CLASS_STORAGE_DISK_EP = "storageDiskEp"
    SORT_CLASS_STORAGE_DISK_GROUP = "storageDiskGroup"
    SORT_CLASS_STORAGE_EMBEDDED_STORAGE = "storageEmbeddedStorage"
    SORT_CLASS_STORAGE_ENCLOSURE = "storageEnclosure"
    SORT_CLASS_STORAGE_ENCLOSURE_DISK_SLOT_EP = "storageEnclosureDiskSlotEp"
    SORT_CLASS_STORAGE_ENCLOSURE_LOCAL_DISK_CONFIG = "storageEnclosureLocalDiskConfig"
    SORT_CLASS_STORAGE_EP = "storageEp"
    SORT_CLASS_STORAGE_EP_USER = "storageEpUser"
    SORT_CLASS_STORAGE_ETH_LIF = "storageEthLif"
    SORT_CLASS_STORAGE_ETHER_IF = "storageEtherIf"
    SORT_CLASS_STORAGE_FC_IF = "storageFcIf"
    SORT_CLASS_STORAGE_FC_TARGET_EP = "storageFcTargetEp"
    SORT_CLASS_STORAGE_FC_TARGET_IF = "storageFcTargetIf"
    SORT_CLASS_STORAGE_FLEX_FLASH_CARD = "storageFlexFlashCard"
    SORT_CLASS_STORAGE_FLEX_FLASH_CONTROLLER = "storageFlexFlashController"
    SORT_CLASS_STORAGE_FLEX_FLASH_CONTROLLER_OPERATION = "storageFlexFlashControllerOperation"
    SORT_CLASS_STORAGE_FLEX_FLASH_DRIVE = "storageFlexFlashDrive"
    SORT_CLASS_STORAGE_FLEX_FLASH_VIRTUAL_DRIVE = "storageFlexFlashVirtualDrive"
    SORT_CLASS_STORAGE_HDD_MOTHER_BOARD_TEMP_STATS = "storageHddMotherBoardTempStats"
    SORT_CLASS_STORAGE_HDD_MOTHER_BOARD_TEMP_STATS_HIST = "storageHddMotherBoardTempStatsHist"
    SORT_CLASS_STORAGE_ISCSI_INITIATOR_EP = "storageIScsiInitiatorEp"
    SORT_CLASS_STORAGE_ISCSI_TARGET_IF = "storageIScsiTargetIf"
    SORT_CLASS_STORAGE_INI_GROUP = "storageIniGroup"
    SORT_CLASS_STORAGE_INITIATOR = "storageInitiator"
    SORT_CLASS_STORAGE_INITIATOR_REF = "storageInitiatorRef"
    SORT_CLASS_STORAGE_IP_V4_POOLED_ADDR = "storageIpV4PooledAddr"
    SORT_CLASS_STORAGE_IP_V4_STATIC_ADDR = "storageIpV4StaticAddr"
    SORT_CLASS_STORAGE_ITEM = "storageItem"
    SORT_CLASS_STORAGE_L2_IF = "storageL2If"
    SORT_CLASS_STORAGE_LOCAL_DISK = "storageLocalDisk"
    SORT_CLASS_STORAGE_LOCAL_DISK_BASE = "storageLocalDiskBase"
    SORT_CLASS_STORAGE_LOCAL_DISK_CONFIG = "storageLocalDiskConfig"
    SORT_CLASS_STORAGE_LOCAL_DISK_CONFIG_DEF = "storageLocalDiskConfigDef"
    SORT_CLASS_STORAGE_LOCAL_DISK_CONFIG_POLICY = "storageLocalDiskConfigPolicy"
    SORT_CLASS_STORAGE_LOCAL_DISK_EP = "storageLocalDiskEp"
    SORT_CLASS_STORAGE_LOCAL_DISK_OPERATION = "storageLocalDiskOperation"
    SORT_CLASS_STORAGE_LOCAL_DISK_PARTITION = "storageLocalDiskPartition"
    SORT_CLASS_STORAGE_LOCAL_LUN = "storageLocalLun"
    SORT_CLASS_STORAGE_LOGICAL = "storageLogical"
    SORT_CLASS_STORAGE_LUN_COUNTERS = "storageLunCounters"
    SORT_CLASS_STORAGE_LUN_DISK = "storageLunDisk"
    SORT_CLASS_STORAGE_LUN_MASK_GROUP = "storageLunMaskGroup"
    SORT_CLASS_STORAGE_LUN_REPLICA = "storageLunReplica"
    SORT_CLASS_STORAGE_LUN_RESOURCE_SELECTION_LOG = "storageLunResourceSelectionLog"
    SORT_CLASS_STORAGE_LUN_SNAPSHOT = "storageLunSnapshot"
    SORT_CLASS_STORAGE_META = "storageMeta"
    SORT_CLASS_STORAGE_MEZZ_FLASH_LIFE = "storageMezzFlashLife"
    SORT_CLASS_STORAGE_NODE_EP = "storageNodeEp"
    SORT_CLASS_STORAGE_NVME_STATS = "storageNvmeStats"
    SORT_CLASS_STORAGE_NVME_STATS_HIST = "storageNvmeStatsHist"
    SORT_CLASS_STORAGE_NVME_STORAGE = "storageNvmeStorage"
    SORT_CLASS_STORAGE_ONBOARD_DEVICE = "storageOnboardDevice"
    SORT_CLASS_STORAGE_OPERATION = "storageOperation"
    SORT_CLASS_STORAGE_PARTITION = "storagePartition"
    SORT_CLASS_STORAGE_PHYSICAL = "storagePhysical"
    SORT_CLASS_STORAGE_PROCESSOR = "storageProcessor"
    SORT_CLASS_STORAGE_PROCESSOR_EP = "storageProcessorEp"
    SORT_CLASS_STORAGE_PROCESSOR_RUNTIME = "storageProcessorRuntime"
    SORT_CLASS_STORAGE_QUAL = "storageQual"
    SORT_CLASS_STORAGE_RAID_BATTERY = "storageRaidBattery"
    SORT_CLASS_STORAGE_REPLICATION_CTX = "storageReplicationCtx"
    SORT_CLASS_STORAGE_SAS_EXPANDER = "storageSasExpander"
    SORT_CLASS_STORAGE_SAS_PHY_LINK = "storageSasPhyLink"
    SORT_CLASS_STORAGE_SAS_PORT = "storageSasPort"
    SORT_CLASS_STORAGE_SAS_UP_LINK = "storageSasUpLink"
    SORT_CLASS_STORAGE_SCSI_DEVICE_DESCRIPTOR = "storageScsiDeviceDescriptor"
    SORT_CLASS_STORAGE_SCSI_LUN = "storageScsiLun"
    SORT_CLASS_STORAGE_SCSI_LUN_CTX = "storageScsiLunCtx"
    SORT_CLASS_STORAGE_SCSI_LUN_INST_REF = "storageScsiLunInstRef"
    SORT_CLASS_STORAGE_SCSI_LUN_MASK = "storageScsiLunMask"
    SORT_CLASS_STORAGE_SCSI_LUN_REF = "storageScsiLunRef"
    SORT_CLASS_STORAGE_SNAPSHOT = "storageSnapshot"
    SORT_CLASS_STORAGE_SNAPSHOT_CTX = "storageSnapshotCtx"
    SORT_CLASS_STORAGE_SSD_HEALTH_STATS = "storageSsdHealthStats"
    SORT_CLASS_STORAGE_SSD_HEALTH_STATS_HIST = "storageSsdHealthStatsHist"
    SORT_CLASS_STORAGE_STORAGE_STATS = "storageStorageStats"
    SORT_CLASS_STORAGE_STORAGE_STATS_HIST = "storageStorageStatsHist"
    SORT_CLASS_STORAGE_SYSTEM = "storageSystem"
    SORT_CLASS_STORAGE_TARGET = "storageTarget"
    SORT_CLASS_STORAGE_TARGET_IF = "storageTargetIf"
    SORT_CLASS_STORAGE_TRANSPORT_IF = "storageTransportIf"
    SORT_CLASS_STORAGE_TRANSPORTABLE_FLASH_MODULE = "storageTransportableFlashModule"
    SORT_CLASS_STORAGE_UNIT = "storageUnit"
    SORT_CLASS_STORAGE_USAGE_COUNTERS = "storageUsageCounters"
    SORT_CLASS_STORAGE_VDMEMBER_EP = "storageVDMemberEp"
    SORT_CLASS_STORAGE_VIRTUAL_DRIVE = "storageVirtualDrive"
    SORT_CLASS_STORAGE_VIRTUAL_DRIVE_CONTAINER = "storageVirtualDriveContainer"
    SORT_CLASS_STORAGE_VIRTUAL_DRIVE_EP = "storageVirtualDriveEp"
    SORT_CLASS_STORAGE_VIRTUAL_DRIVE_OPERATION = "storageVirtualDriveOperation"
    SORT_CLASS_STORAGE_VIRTUAL_DRIVE_REF = "storageVirtualDriveRef"
    SORT_CLASS_STORAGE_VIRTUAL_DRIVE_REF_OPERATION = "storageVirtualDriveRefOperation"
    SORT_CLASS_STORAGE_VOLUME = "storageVolume"
    SORT_CLASS_STORAGE_VSAN_REF = "storageVsanRef"
    SORT_CLASS_STORAGE_VSAN_REF_IVT = "storageVsanRefIvt"
    SORT_CLASS_SW_CARD_ENV_STATS = "swCardEnvStats"
    SORT_CLASS_SW_CARD_ENV_STATS_HIST = "swCardEnvStatsHist"
    SORT_CLASS_SW_ENV_STATS = "swEnvStats"
    SORT_CLASS_SW_ENV_STATS_HIST = "swEnvStatsHist"
    SORT_CLASS_SW_MON = "swMon"
    SORT_CLASS_SW_SYSTEM_STATS = "swSystemStats"
    SORT_CLASS_SW_SYSTEM_STATS_HIST = "swSystemStatsHist"
    SORT_CLASS_SW_VLAN = "swVlan"
    SORT_CLASS_SW_VLAN_GROUP = "swVlanGroup"
    SORT_CLASS_SYNTHETIC_DIRECTORY = "syntheticDirectory"
    SORT_CLASS_SYNTHETIC_FILE = "syntheticFile"
    SORT_CLASS_SYNTHETIC_FILE_SYSTEM = "syntheticFileSystem"
    SORT_CLASS_SYNTHETIC_FS_OBJ = "syntheticFsObj"
    SORT_CLASS_SYNTHETIC_TIME = "syntheticTime"
    SORT_CLASS_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET = "sysdebugAutoCoreFileExportTarget"
    SORT_CLASS_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM = "sysdebugAutoCoreFileExportTargetFsm"
    SORT_CLASS_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM_STAGE = "sysdebugAutoCoreFileExportTargetFsmStage"
    SORT_CLASS_SYSDEBUG_AUTO_CORE_FILE_EXPORT_TARGET_FSM_TASK = "sysdebugAutoCoreFileExportTargetFsmTask"
    SORT_CLASS_SYSDEBUG_BACKUP_BEHAVIOR = "sysdebugBackupBehavior"
    SORT_CLASS_SYSDEBUG_CORE = "sysdebugCore"
    SORT_CLASS_SYSDEBUG_CORE_FILE_EXPORT_TARGET = "sysdebugCoreFileExportTarget"
    SORT_CLASS_SYSDEBUG_CORE_FILE_REPOSITORY = "sysdebugCoreFileRepository"
    SORT_CLASS_SYSDEBUG_DIAGNOSTIC_LOG = "sysdebugDiagnosticLog"
    SORT_CLASS_SYSDEBUG_EP = "sysdebugEp"
    SORT_CLASS_SYSDEBUG_EXPORTER = "sysdebugExporter"
    SORT_CLASS_SYSDEBUG_FILE = "sysdebugFile"
    SORT_CLASS_SYSDEBUG_LOG_BEHAVIOR = "sysdebugLogBehavior"
    SORT_CLASS_SYSDEBUG_LOG_CONTROL_DESTINATION_FILE = "sysdebugLogControlDestinationFile"
    SORT_CLASS_SYSDEBUG_LOG_CONTROL_DESTINATION_SYSLOG = "sysdebugLogControlDestinationSyslog"
    SORT_CLASS_SYSDEBUG_LOG_CONTROL_DOMAIN = "sysdebugLogControlDomain"
    SORT_CLASS_SYSDEBUG_LOG_CONTROL_EP = "sysdebugLogControlEp"
    SORT_CLASS_SYSDEBUG_LOG_CONTROL_EP_FSM = "sysdebugLogControlEpFsm"
    SORT_CLASS_SYSDEBUG_LOG_CONTROL_EP_FSM_STAGE = "sysdebugLogControlEpFsmStage"
    SORT_CLASS_SYSDEBUG_LOG_CONTROL_EP_FSM_TASK = "sysdebugLogControlEpFsmTask"
    SORT_CLASS_SYSDEBUG_LOG_CONTROL_MODULE = "sysdebugLogControlModule"
    SORT_CLASS_SYSDEBUG_MEP_LOG_DEF = "sysdebugMEpLogDef"
    SORT_CLASS_SYSDEBUG_MEP_LOG_POLICY = "sysdebugMEpLogPolicy"
    SORT_CLASS_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET = "sysdebugManualCoreFileExportTarget"
    SORT_CLASS_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM = "sysdebugManualCoreFileExportTargetFsm"
    SORT_CLASS_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM_STAGE = "sysdebugManualCoreFileExportTargetFsmStage"
    SORT_CLASS_SYSDEBUG_MANUAL_CORE_FILE_EXPORT_TARGET_FSM_TASK = "sysdebugManualCoreFileExportTargetFsmTask"
    SORT_CLASS_SYSDEBUG_REPOSITORY = "sysdebugRepository"
    SORT_CLASS_SYSDEBUG_TECH_SUP_FILE_REPOSITORY = "sysdebugTechSupFileRepository"
    SORT_CLASS_SYSDEBUG_TECH_SUPPORT = "sysdebugTechSupport"
    SORT_CLASS_SYSDEBUG_TECH_SUPPORT_CMD_OPT = "sysdebugTechSupportCmdOpt"
    SORT_CLASS_SYSDEBUG_TECH_SUPPORT_FSM = "sysdebugTechSupportFsm"
    SORT_CLASS_SYSDEBUG_TECH_SUPPORT_FSM_STAGE = "sysdebugTechSupportFsmStage"
    SORT_CLASS_SYSDEBUG_TECH_SUPPORT_FSM_TASK = "sysdebugTechSupportFsmTask"
    SORT_CLASS_SYSDEBUG_TECH_SUPPORT_OP = "sysdebugTechSupportOp"
    SORT_CLASS_SYSDEBUG_TECH_SUPPORT_OPERATION = "sysdebugTechSupportOperation"
    SORT_CLASS_SYSFILE_DIGEST = "sysfileDigest"
    SORT_CLASS_SYSFILE_EP = "sysfileEp"
    SORT_CLASS_SYSFILE_EXPORTER = "sysfileExporter"
    SORT_CLASS_SYSFILE_IMPORTER = "sysfileImporter"
    SORT_CLASS_SYSFILE_INSTANCE = "sysfileInstance"
    SORT_CLASS_SYSFILE_MUTATION = "sysfileMutation"
    SORT_CLASS_SYSFILE_MUTATION_FSM = "sysfileMutationFsm"
    SORT_CLASS_SYSFILE_MUTATION_FSM_STAGE = "sysfileMutationFsmStage"
    SORT_CLASS_SYSFILE_MUTATION_FSM_TASK = "sysfileMutationFsmTask"
    SORT_CLASS_SYSFILE_REPOSITORY = "sysfileRepository"
    SORT_CLASS_TAG_ADEF = "tagADef"
    SORT_CLASS_TAG_AINSTANCE = "tagAInstance"
    SORT_CLASS_TAG_DEF = "tagDef"
    SORT_CLASS_TAG_DEF_EP = "tagDefEp"
    SORT_CLASS_TAG_DRIVER = "tagDriver"
    SORT_CLASS_TAG_INSTANCE = "tagInstance"
    SORT_CLASS_TAG_INSTANCE_EP = "tagInstanceEp"
    SORT_CLASS_TAG_INSTANCE_ITEM = "tagInstanceItem"
    SORT_CLASS_TAG_ITEM = "tagItem"
    SORT_CLASS_TAG_SOFTWARE_INST = "tagSoftwareInst"
    SORT_CLASS_TESTING_CLI_POLICY = "testingCliPolicy"
    SORT_CLASS_TESTING_SERVICE_PROFILE = "testingServiceProfile"
    SORT_CLASS_TESTING_SERVICE_PROFILE_FSM = "testingServiceProfileFsm"
    SORT_CLASS_TESTING_SERVICE_PROFILE_FSM_STAGE = "testingServiceProfileFsmStage"
    SORT_CLASS_TESTING_SERVICE_PROFILE_FSM_TASK = "testingServiceProfileFsmTask"
    SORT_CLASS_TESTING_SNMP_COMMUNITY = "testingSnmpCommunity"
    SORT_CLASS_TESTING_SNMP_POLICY = "testingSnmpPolicy"
    SORT_CLASS_TESTING_SNMP_SUPPORT = "testingSnmpSupport"
    SORT_CLASS_TESTING_SNMP_TRAP = "testingSnmpTrap"
    SORT_CLASS_TOP_INFO_SYNC_POLICY = "topInfoSyncPolicy"
    SORT_CLASS_TOP_META_INF = "topMetaInf"
    SORT_CLASS_TOP_ROOT = "topRoot"
    SORT_CLASS_TOP_SYSTEM = "topSystem"
    SORT_CLASS_TOP_SYSTEM_FSM = "topSystemFsm"
    SORT_CLASS_TOP_SYSTEM_FSM_STAGE = "topSystemFsmStage"
    SORT_CLASS_TOP_SYSTEM_FSM_TASK = "topSystemFsmTask"
    SORT_CLASS_TRIG_ABS_WINDOW = "trigAbsWindow"
    SORT_CLASS_TRIG_ACK = "trigAck"
    SORT_CLASS_TRIG_BASE_RECURR_WINDOW = "trigBaseRecurrWindow"
    SORT_CLASS_TRIG_BASE_SCHED = "trigBaseSched"
    SORT_CLASS_TRIG_CONF_ACK = "trigConfAck"
    SORT_CLASS_TRIG_INST = "trigInst"
    SORT_CLASS_TRIG_META = "trigMeta"
    SORT_CLASS_TRIG_PENDING_ACK_COUNT = "trigPendingAckCount"
    SORT_CLASS_TRIG_RECURR_WINDOW = "trigRecurrWindow"
    SORT_CLASS_TRIG_RES_ACK = "trigResAck"
    SORT_CLASS_TRIG_SCHED = "trigSched"
    SORT_CLASS_TRIG_SCHED_WINDOW = "trigSchedWindow"
    SORT_CLASS_TRIG_SERVER_TOKEN = "trigServerToken"
    SORT_CLASS_TRIG_TEST = "trigTest"
    SORT_CLASS_TRIG_TOKEN = "trigToken"
    SORT_CLASS_TRIG_TOKEN_REQUESTOR = "trigTokenRequestor"
    SORT_CLASS_TRIG_TRIGGERABLE = "trigTriggerable"
    SORT_CLASS_TRIG_TRIGGERED = "trigTriggered"
    SORT_CLASS_TRIG_WINDOW = "trigWindow"
    SORT_CLASS_UNSPECIFIED = "unspecified"
    SORT_CLASS_UUIDPOOL_ADDR = "uuidpoolAddr"
    SORT_CLASS_UUIDPOOL_BLOCK = "uuidpoolBlock"
    SORT_CLASS_UUIDPOOL_FORMAT = "uuidpoolFormat"
    SORT_CLASS_UUIDPOOL_POOL = "uuidpoolPool"
    SORT_CLASS_UUIDPOOL_POOLED = "uuidpoolPooled"
    SORT_CLASS_UUIDPOOL_UNIVERSE = "uuidpoolUniverse"
    SORT_CLASS_VERSION_APPLICATION = "versionApplication"
    SORT_CLASS_VERSION_EP = "versionEp"
    SORT_CLASS_VERSION_FILTER = "versionFilter"
    SORT_CLASS_VERSION_MATRIX = "versionMatrix"
    SORT_CLASS_VERSION_PRODUCT = "versionProduct"
    SORT_CLASS_VERSION_VERSION = "versionVersion"
    SORT_CLASS_VM_ADAPTOR = "vmAdaptor"
    SORT_CLASS_VM_NIC = "vmNic"
    SORT_CLASS_VNIC_ABEH = "vnicABeh"
    SORT_CLASS_VNIC_AETHER_IF = "vnicAEtherIf"
    SORT_CLASS_VNIC_AFC_IF = "vnicAFcIf"
    SORT_CLASS_VNIC_AGROUP = "vnicAGroup"
    SORT_CLASS_VNIC_BOOT_IP_POLICY = "vnicBootIpPolicy"
    SORT_CLASS_VNIC_BOOT_TARGET = "vnicBootTarget"
    SORT_CLASS_VNIC_CON_POLICY_REF = "vnicConPolicyRef"
    SORT_CLASS_VNIC_CON_REQ = "vnicConReq"
    SORT_CLASS_VNIC_CONN_DEF = "vnicConnDef"
    SORT_CLASS_VNIC_CONNECTION = "vnicConnection"
    SORT_CLASS_VNIC_DEF_BEH = "vnicDefBeh"
    SORT_CLASS_VNIC_DYNAMIC_CON = "vnicDynamicCon"
    SORT_CLASS_VNIC_DYNAMIC_CON_POLICY = "vnicDynamicConPolicy"
    SORT_CLASS_VNIC_DYNAMIC_CON_POLICY_REF = "vnicDynamicConPolicyRef"
    SORT_CLASS_VNIC_DYNAMIC_CON_REQ = "vnicDynamicConReq"
    SORT_CLASS_VNIC_ETH_LIF = "vnicEthLif"
    SORT_CLASS_VNIC_ETHER = "vnicEther"
    SORT_CLASS_VNIC_ETHER_BASE = "vnicEtherBase"
    SORT_CLASS_VNIC_ETHER_BASE_IF = "vnicEtherBaseIf"
    SORT_CLASS_VNIC_ETHER_IF = "vnicEtherIf"
    SORT_CLASS_VNIC_FAULT = "vnicFault"
    SORT_CLASS_VNIC_FC = "vnicFc"
    SORT_CLASS_VNIC_FC_BASE = "vnicFcBase"
    SORT_CLASS_VNIC_FC_GROUP_DEF = "vnicFcGroupDef"
    SORT_CLASS_VNIC_FC_GROUP_TEMPL = "vnicFcGroupTempl"
    SORT_CLASS_VNIC_FC_IF = "vnicFcIf"
    SORT_CLASS_VNIC_FC_LIF = "vnicFcLif"
    SORT_CLASS_VNIC_FC_NODE = "vnicFcNode"
    SORT_CLASS_VNIC_FC_OEIF = "vnicFcOEIf"
    SORT_CLASS_VNIC_IPIF = "vnicIPIf"
    SORT_CLASS_VNIC_IPV4_DHCP = "vnicIPv4Dhcp"
    SORT_CLASS_VNIC_IPV4_DNS = "vnicIPv4Dns"
    SORT_CLASS_VNIC_IPV4_IF = "vnicIPv4If"
    SORT_CLASS_VNIC_IPV4_ISCSI_ADDR = "vnicIPv4IscsiAddr"
    SORT_CLASS_VNIC_IPV4_POOLED_ISCSI_ADDR = "vnicIPv4PooledIscsiAddr"
    SORT_CLASS_VNIC_IPV4_STATIC_ROUTE = "vnicIPv4StaticRoute"
    SORT_CLASS_VNIC_IPV6_IF = "vnicIPv6If"
    SORT_CLASS_VNIC_ISCSI = "vnicIScsi"
    SORT_CLASS_VNIC_ISCSI_AUTO_TARGET_IF = "vnicIScsiAutoTargetIf"
    SORT_CLASS_VNIC_ISCSI_BASE = "vnicIScsiBase"
    SORT_CLASS_VNIC_ISCSI_BOOT_PARAMS = "vnicIScsiBootParams"
    SORT_CLASS_VNIC_ISCSI_BOOT_VNIC = "vnicIScsiBootVnic"
    SORT_CLASS_VNIC_ISCSI_INITIATOR_PARAMS = "vnicIScsiInitiatorParams"
    SORT_CLASS_VNIC_ISCSI_LCP = "vnicIScsiLCP"
    SORT_CLASS_VNIC_ISCSI_NODE = "vnicIScsiNode"
    SORT_CLASS_VNIC_ISCSI_STATIC_TARGET_IF = "vnicIScsiStaticTargetIf"
    SORT_CLASS_VNIC_ISCSI_TARGET_IF = "vnicIScsiTargetIf"
    SORT_CLASS_VNIC_ISCSI_TARGET_PARAMS = "vnicIScsiTargetParams"
    SORT_CLASS_VNIC_IF = "vnicIf"
    SORT_CLASS_VNIC_IF_ROLE = "vnicIfRole"
    SORT_CLASS_VNIC_INI_GRP_FC = "vnicIniGrpFc"
    SORT_CLASS_VNIC_INI_GRP_FC_B = "vnicIniGrpFcB"
    SORT_CLASS_VNIC_INI_GRP_FC_BIF = "vnicIniGrpFcBIf"
    SORT_CLASS_VNIC_INI_GRP_FC_BASE = "vnicIniGrpFcBase"
    SORT_CLASS_VNIC_INI_GRP_FC_IF = "vnicIniGrpFcIf"
    SORT_CLASS_VNIC_IP_ADDR = "vnicIpAddr"
    SORT_CLASS_VNIC_IP_V4_ADDR = "vnicIpV4Addr"
    SORT_CLASS_VNIC_IP_V4_ADDR_CONF = "vnicIpV4AddrConf"
    SORT_CLASS_VNIC_IP_V4_ADDR_EXPL_CONF = "vnicIpV4AddrExplConf"
    SORT_CLASS_VNIC_IP_V4_MGMT_POOLED_ADDR = "vnicIpV4MgmtPooledAddr"
    SORT_CLASS_VNIC_IP_V4_POOLED_ADDR = "vnicIpV4PooledAddr"
    SORT_CLASS_VNIC_IP_V4_PROF_DERIVED_ADDR = "vnicIpV4ProfDerivedAddr"
    SORT_CLASS_VNIC_IP_V4_STATIC_ADDR = "vnicIpV4StaticAddr"
    SORT_CLASS_VNIC_IP_V6_ADDR = "vnicIpV6Addr"
    SORT_CLASS_VNIC_IP_V6_ADDR_CONF = "vnicIpV6AddrConf"
    SORT_CLASS_VNIC_IP_V6_ADDR_EXPL_CONF = "vnicIpV6AddrExplConf"
    SORT_CLASS_VNIC_IP_V6_MGMT_POOLED_ADDR = "vnicIpV6MgmtPooledAddr"
    SORT_CLASS_VNIC_IP_V6_STATIC_ADDR = "vnicIpV6StaticAddr"
    SORT_CLASS_VNIC_L2_IF = "vnicL2If"
    SORT_CLASS_VNIC_L2_LIF = "vnicL2Lif"
    SORT_CLASS_VNIC_L3_IF = "vnicL3If"
    SORT_CLASS_VNIC_LAN_CONN_POLICY = "vnicLanConnPolicy"
    SORT_CLASS_VNIC_LAN_CONN_TEMPL = "vnicLanConnTempl"
    SORT_CLASS_VNIC_LIF_VLAN = "vnicLifVlan"
    SORT_CLASS_VNIC_LIF_VSAN = "vnicLifVsan"
    SORT_CLASS_VNIC_LSTORAGE_ISCSI = "vnicLstorageIScsi"
    SORT_CLASS_VNIC_LUN = "vnicLun"
    SORT_CLASS_VNIC_MGMT = "vnicMgmt"
    SORT_CLASS_VNIC_MGMT_BASE = "vnicMgmtBase"
    SORT_CLASS_VNIC_MGMT_IF = "vnicMgmtIf"
    SORT_CLASS_VNIC_MON_SES_FC = "vnicMonSesFc"
    SORT_CLASS_VNIC_MON_SES_FC_BASE = "vnicMonSesFcBase"
    SORT_CLASS_VNIC_MON_SES_FC_IF = "vnicMonSesFcIf"
    SORT_CLASS_VNIC_NET_GROUP = "vnicNetGroup"
    SORT_CLASS_VNIC_NET_GROUP_REF = "vnicNetGroupRef"
    SORT_CLASS_VNIC_NIC_CONN = "vnicNicConn"
    SORT_CLASS_VNIC_OUTBAND_MGMT_EP = "vnicOutbandMgmtEp"
    SORT_CLASS_VNIC_OUTBAND_MGMT_EP_FSM = "vnicOutbandMgmtEpFsm"
    SORT_CLASS_VNIC_OUTBAND_MGMT_EP_FSM_STAGE = "vnicOutbandMgmtEpFsmStage"
    SORT_CLASS_VNIC_OUTBAND_MGMT_EP_FSM_TASK = "vnicOutbandMgmtEpFsmTask"
    SORT_CLASS_VNIC_PROFILE_SET = "vnicProfileSet"
    SORT_CLASS_VNIC_RACK_SERVER_DISCOVERY_PROFILE = "vnicRackServerDiscoveryProfile"
    SORT_CLASS_VNIC_SAN_CONN_POLICY = "vnicSanConnPolicy"
    SORT_CLASS_VNIC_SAN_CONN_TEMPL = "vnicSanConnTempl"
    SORT_CLASS_VNIC_STORAGE_ETH_LIF = "vnicStorageEthLif"
    SORT_CLASS_VNIC_STORAGE_LIF = "vnicStorageLif"
    SORT_CLASS_VNIC_TEMPL = "vnicTempl"
    SORT_CLASS_VNIC_USNIC_CON_POLICY = "vnicUsnicConPolicy"
    SORT_CLASS_VNIC_USNIC_CON_POLICY_REF = "vnicUsnicConPolicyRef"
    SORT_CLASS_VNIC_USNIC_CON_REQ = "vnicUsnicConReq"
    SORT_CLASS_VNIC_VHBA_BEH_POLICY = "vnicVhbaBehPolicy"
    SORT_CLASS_VNIC_VLAN = "vnicVlan"
    SORT_CLASS_VNIC_VMQ_CON_POLICY = "vnicVmqConPolicy"
    SORT_CLASS_VNIC_VMQ_CON_POLICY_REF = "vnicVmqConPolicyRef"
    SORT_CLASS_VNIC_VMQ_CON_REQ = "vnicVmqConReq"
    SORT_CLASS_VNIC_VNIC = "vnicVnic"
    SORT_CLASS_VNIC_VNIC_BEH_POLICY = "vnicVnicBehPolicy"
    SORT_PROP_AAA_AUTH_METHOD_DESCR = "aaa_AuthMethod_descr"
    SORT_PROP_AAA_AUTH_METHOD_NAME = "aaa_AuthMethod_name"
    SORT_PROP_AAA_AUTH_METHOD_PROVIDER_GROUP = "aaa_AuthMethod_providerGroup"
    SORT_PROP_AAA_AUTH_METHOD_REALM = "aaa_AuthMethod_realm"
    SORT_PROP_AAA_AUTH_REALM_FSM_STAGE_DESCR = "aaa_AuthRealmFsmStage_descr"
    SORT_PROP_AAA_AUTH_REALM_FSM_STAGE_LAST_UPDATE_TIME = "aaa_AuthRealmFsmStage_lastUpdateTime"
    SORT_PROP_AAA_AUTH_REALM_FSM_STAGE_NAME = "aaa_AuthRealmFsmStage_name"
    SORT_PROP_AAA_AUTH_REALM_FSM_STAGE_ORDER = "aaa_AuthRealmFsmStage_order"
    SORT_PROP_AAA_AUTH_REALM_FSM_STAGE_RETRY = "aaa_AuthRealmFsmStage_retry"
    SORT_PROP_AAA_AUTH_REALM_FSM_STAGE_STAGE_STATUS = "aaa_AuthRealmFsmStage_stageStatus"
    SORT_PROP_AAA_AUTH_REALM_FSM_COMPLETION_TIME = "aaa_AuthRealmFsm_completionTime"
    SORT_PROP_AAA_AUTH_REALM_FSM_CURRENT_FSM = "aaa_AuthRealmFsm_currentFsm"
    SORT_PROP_AAA_AUTH_REALM_FSM_DESCR = "aaa_AuthRealmFsm_descr"
    SORT_PROP_AAA_AUTH_REALM_FSM_FSM_INSTANCE_ID = "aaa_AuthRealmFsm_fsmInstanceId"
    SORT_PROP_AAA_AUTH_REALM_FSM_FSM_STATUS = "aaa_AuthRealmFsm_fsmStatus"
    SORT_PROP_AAA_AUTH_REALM_FSM_PROGRESS = "aaa_AuthRealmFsm_progress"
    SORT_PROP_AAA_AUTH_REALM_FSM_RMT_ERR_CODE = "aaa_AuthRealmFsm_rmtErrCode"
    SORT_PROP_AAA_AUTH_REALM_FSM_RMT_ERR_DESCR = "aaa_AuthRealmFsm_rmtErrDescr"
    SORT_PROP_AAA_AUTH_REALM_FSM_RMT_RSLT = "aaa_AuthRealmFsm_rmtRslt"
    SORT_PROP_AAA_AUTH_REALM_CON_LOGIN = "aaa_AuthRealm_conLogin"
    SORT_PROP_AAA_AUTH_REALM_DEF_LOGIN = "aaa_AuthRealm_defLogin"
    SORT_PROP_AAA_AUTH_REALM_DEF_ROLE_POLICY = "aaa_AuthRealm_defRolePolicy"
    SORT_PROP_AAA_AUTH_REALM_DESCR = "aaa_AuthRealm_descr"
    SORT_PROP_AAA_AUTH_REALM_FSM_DESCR = "aaa_AuthRealm_fsmDescr"
    SORT_PROP_AAA_AUTH_REALM_FSM_PREV = "aaa_AuthRealm_fsmPrev"
    SORT_PROP_AAA_AUTH_REALM_FSM_PROGR = "aaa_AuthRealm_fsmProgr"
    SORT_PROP_AAA_AUTH_REALM_FSM_RMT_INV_ERR_CODE = "aaa_AuthRealm_fsmRmtInvErrCode"
    SORT_PROP_AAA_AUTH_REALM_FSM_RMT_INV_ERR_DESCR = "aaa_AuthRealm_fsmRmtInvErrDescr"
    SORT_PROP_AAA_AUTH_REALM_FSM_RMT_INV_RSLT = "aaa_AuthRealm_fsmRmtInvRslt"
    SORT_PROP_AAA_AUTH_REALM_FSM_STAGE_DESCR = "aaa_AuthRealm_fsmStageDescr"
    SORT_PROP_AAA_AUTH_REALM_FSM_STAMP = "aaa_AuthRealm_fsmStamp"
    SORT_PROP_AAA_AUTH_REALM_FSM_STATUS = "aaa_AuthRealm_fsmStatus"
    SORT_PROP_AAA_AUTH_REALM_FSM_TRY = "aaa_AuthRealm_fsmTry"
    SORT_PROP_AAA_AUTH_REALM_INT_ID = "aaa_AuthRealm_intId"
    SORT_PROP_AAA_AUTH_REALM_NAME = "aaa_AuthRealm_name"
    SORT_PROP_AAA_AUTH_REALM_POLICY_LEVEL = "aaa_AuthRealm_policyLevel"
    SORT_PROP_AAA_AUTH_REALM_POLICY_OWNER = "aaa_AuthRealm_policyOwner"
    SORT_PROP_AAA_CONFIG_DESCR = "aaa_Config_descr"
    SORT_PROP_AAA_CONFIG_NAME = "aaa_Config_name"
    SORT_PROP_AAA_CONFIG_PROVIDER_GROUP = "aaa_Config_providerGroup"
    SORT_PROP_AAA_CONFIG_REALM = "aaa_Config_realm"
    SORT_PROP_AAA_CONSOLE_AUTH_DESCR = "aaa_ConsoleAuth_descr"
    SORT_PROP_AAA_CONSOLE_AUTH_NAME = "aaa_ConsoleAuth_name"
    SORT_PROP_AAA_CONSOLE_AUTH_PROVIDER_GROUP = "aaa_ConsoleAuth_providerGroup"
    SORT_PROP_AAA_CONSOLE_AUTH_REALM = "aaa_ConsoleAuth_realm"
    SORT_PROP_AAA_DEFAULT_AUTH_DESCR = "aaa_DefaultAuth_descr"
    SORT_PROP_AAA_DEFAULT_AUTH_NAME = "aaa_DefaultAuth_name"
    SORT_PROP_AAA_DEFAULT_AUTH_PROVIDER_GROUP = "aaa_DefaultAuth_providerGroup"
    SORT_PROP_AAA_DEFAULT_AUTH_REALM = "aaa_DefaultAuth_realm"
    SORT_PROP_AAA_DEFAULT_AUTH_REFRESH_PERIOD = "aaa_DefaultAuth_refreshPeriod"
    SORT_PROP_AAA_DEFAULT_AUTH_SESSION_TIMEOUT = "aaa_DefaultAuth_sessionTimeout"
    SORT_PROP_AAA_DEFINITION_DESCR = "aaa_Definition_descr"
    SORT_PROP_AAA_DEFINITION_INT_ID = "aaa_Definition_intId"
    SORT_PROP_AAA_DEFINITION_NAME = "aaa_Definition_name"
    SORT_PROP_AAA_DEFINITION_POLICY_LEVEL = "aaa_Definition_policyLevel"
    SORT_PROP_AAA_DEFINITION_POLICY_OWNER = "aaa_Definition_policyOwner"
    SORT_PROP_AAA_DOMAIN_AUTH_DESCR = "aaa_DomainAuth_descr"
    SORT_PROP_AAA_DOMAIN_AUTH_NAME = "aaa_DomainAuth_name"
    SORT_PROP_AAA_DOMAIN_AUTH_PROVIDER_GROUP = "aaa_DomainAuth_providerGroup"
    SORT_PROP_AAA_DOMAIN_AUTH_REALM = "aaa_DomainAuth_realm"
    SORT_PROP_AAA_DOMAIN_GROUP_DESCR = "aaa_DomainGroup_descr"
    SORT_PROP_AAA_DOMAIN_GROUP_DOMAINGROUP_DN = "aaa_DomainGroup_domaingroupDn"
    SORT_PROP_AAA_DOMAIN_GROUP_NAME = "aaa_DomainGroup_name"
    SORT_PROP_AAA_DOMAIN_DESCR = "aaa_Domain_descr"
    SORT_PROP_AAA_DOMAIN_NAME = "aaa_Domain_name"
    SORT_PROP_AAA_DOMAIN_REFRESH_PERIOD = "aaa_Domain_refreshPeriod"
    SORT_PROP_AAA_DOMAIN_SESSION_TIMEOUT = "aaa_Domain_sessionTimeout"
    SORT_PROP_AAA_EP_AUTH_PROFILE_DESCR = "aaa_EpAuthProfile_descr"
    SORT_PROP_AAA_EP_AUTH_PROFILE_INT_ID = "aaa_EpAuthProfile_intId"
    SORT_PROP_AAA_EP_AUTH_PROFILE_IPMI_OVER_LAN = "aaa_EpAuthProfile_ipmiOverLan"
    SORT_PROP_AAA_EP_AUTH_PROFILE_NAME = "aaa_EpAuthProfile_name"
    SORT_PROP_AAA_EP_AUTH_PROFILE_POLICY_LEVEL = "aaa_EpAuthProfile_policyLevel"
    SORT_PROP_AAA_EP_AUTH_PROFILE_POLICY_OWNER = "aaa_EpAuthProfile_policyOwner"
    SORT_PROP_AAA_EP_FSM_STAGE_DESCR = "aaa_EpFsmStage_descr"
    SORT_PROP_AAA_EP_FSM_STAGE_LAST_UPDATE_TIME = "aaa_EpFsmStage_lastUpdateTime"
    SORT_PROP_AAA_EP_FSM_STAGE_NAME = "aaa_EpFsmStage_name"
    SORT_PROP_AAA_EP_FSM_STAGE_ORDER = "aaa_EpFsmStage_order"
    SORT_PROP_AAA_EP_FSM_STAGE_RETRY = "aaa_EpFsmStage_retry"
    SORT_PROP_AAA_EP_FSM_STAGE_STAGE_STATUS = "aaa_EpFsmStage_stageStatus"
    SORT_PROP_AAA_EP_FSM_TASK_COMPLETION = "aaa_EpFsmTask_completion"
    SORT_PROP_AAA_EP_FSM_TASK_FLAGS = "aaa_EpFsmTask_flags"
    SORT_PROP_AAA_EP_FSM_TASK_ITEM = "aaa_EpFsmTask_item"
    SORT_PROP_AAA_EP_FSM_TASK_SEQ_ID = "aaa_EpFsmTask_seqId"
    SORT_PROP_AAA_EP_FSM_COMPLETION_TIME = "aaa_EpFsm_completionTime"
    SORT_PROP_AAA_EP_FSM_CURRENT_FSM = "aaa_EpFsm_currentFsm"
    SORT_PROP_AAA_EP_FSM_DESCR = "aaa_EpFsm_descr"
    SORT_PROP_AAA_EP_FSM_FSM_INSTANCE_ID = "aaa_EpFsm_fsmInstanceId"
    SORT_PROP_AAA_EP_FSM_FSM_STATUS = "aaa_EpFsm_fsmStatus"
    SORT_PROP_AAA_EP_FSM_PROGRESS = "aaa_EpFsm_progress"
    SORT_PROP_AAA_EP_FSM_RMT_ERR_CODE = "aaa_EpFsm_rmtErrCode"
    SORT_PROP_AAA_EP_FSM_RMT_ERR_DESCR = "aaa_EpFsm_rmtErrDescr"
    SORT_PROP_AAA_EP_FSM_RMT_RSLT = "aaa_EpFsm_rmtRslt"
    SORT_PROP_AAA_EP_LOGIN_DESCR = "aaa_EpLogin_descr"
    SORT_PROP_AAA_EP_LOGIN_ID = "aaa_EpLogin_id"
    SORT_PROP_AAA_EP_LOGIN_INT_ID = "aaa_EpLogin_intId"
    SORT_PROP_AAA_EP_LOGIN_LOCAL_HOST = "aaa_EpLogin_localHost"
    SORT_PROP_AAA_EP_LOGIN_NAME = "aaa_EpLogin_name"
    SORT_PROP_AAA_EP_LOGIN_POLICY_LEVEL = "aaa_EpLogin_policyLevel"
    SORT_PROP_AAA_EP_LOGIN_POLICY_OWNER = "aaa_EpLogin_policyOwner"
    SORT_PROP_AAA_EP_LOGIN_REMOTE_HOST = "aaa_EpLogin_remoteHost"
    SORT_PROP_AAA_EP_LOGIN_SESSION = "aaa_EpLogin_session"
    SORT_PROP_AAA_EP_USER_DESCR = "aaa_EpUser_descr"
    SORT_PROP_AAA_EP_USER_INT_ID = "aaa_EpUser_intId"
    SORT_PROP_AAA_EP_USER_NAME = "aaa_EpUser_name"
    SORT_PROP_AAA_EP_USER_POLICY_LEVEL = "aaa_EpUser_policyLevel"
    SORT_PROP_AAA_EP_USER_POLICY_OWNER = "aaa_EpUser_policyOwner"
    SORT_PROP_AAA_EP_USER_PRIV = "aaa_EpUser_priv"
    SORT_PROP_AAA_EP_USER_PWD = "aaa_EpUser_pwd"
    SORT_PROP_AAA_EP_USER_PWD_SET = "aaa_EpUser_pwdSet"
    SORT_PROP_AAA_EP_DESCR = "aaa_Ep_descr"
    SORT_PROP_AAA_EP_FSM_DESCR = "aaa_Ep_fsmDescr"
    SORT_PROP_AAA_EP_FSM_PREV = "aaa_Ep_fsmPrev"
    SORT_PROP_AAA_EP_FSM_PROGR = "aaa_Ep_fsmProgr"
    SORT_PROP_AAA_EP_FSM_RMT_INV_ERR_CODE = "aaa_Ep_fsmRmtInvErrCode"
    SORT_PROP_AAA_EP_FSM_RMT_INV_ERR_DESCR = "aaa_Ep_fsmRmtInvErrDescr"
    SORT_PROP_AAA_EP_FSM_RMT_INV_RSLT = "aaa_Ep_fsmRmtInvRslt"
    SORT_PROP_AAA_EP_FSM_STAGE_DESCR = "aaa_Ep_fsmStageDescr"
    SORT_PROP_AAA_EP_FSM_STAMP = "aaa_Ep_fsmStamp"
    SORT_PROP_AAA_EP_FSM_STATUS = "aaa_Ep_fsmStatus"
    SORT_PROP_AAA_EP_FSM_TRY = "aaa_Ep_fsmTry"
    SORT_PROP_AAA_EP_INT_ID = "aaa_Ep_intId"
    SORT_PROP_AAA_EP_NAME = "aaa_Ep_name"
    SORT_PROP_AAA_EP_POLICY_LEVEL = "aaa_Ep_policyLevel"
    SORT_PROP_AAA_EP_POLICY_OWNER = "aaa_Ep_policyOwner"
    SORT_PROP_AAA_EP_RETRIES = "aaa_Ep_retries"
    SORT_PROP_AAA_EP_TIMEOUT = "aaa_Ep_timeout"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_AUTH_USER = "aaa_ExtMgmtCutThruTkn_authUser"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_DESCR = "aaa_ExtMgmtCutThruTkn_descr"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_INT_ID = "aaa_ExtMgmtCutThruTkn_intId"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_LOCALES = "aaa_ExtMgmtCutThruTkn_locales"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_NAME = "aaa_ExtMgmtCutThruTkn_name"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_POLICY_LEVEL = "aaa_ExtMgmtCutThruTkn_policyLevel"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_POLICY_OWNER = "aaa_ExtMgmtCutThruTkn_policyOwner"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_PRIV = "aaa_ExtMgmtCutThruTkn_priv"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_REMOTE = "aaa_ExtMgmtCutThruTkn_remote"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_TOKEN = "aaa_ExtMgmtCutThruTkn_token"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_TYPE = "aaa_ExtMgmtCutThruTkn_type"
    SORT_PROP_AAA_EXT_MGMT_CUT_THRU_TKN_USER = "aaa_ExtMgmtCutThruTkn_user"
    SORT_PROP_AAA_ITEM_DESCR = "aaa_Item_descr"
    SORT_PROP_AAA_ITEM_NAME = "aaa_Item_name"
    SORT_PROP_AAA_LDAP_EP_FSM_STAGE_DESCR = "aaa_LdapEpFsmStage_descr"
    SORT_PROP_AAA_LDAP_EP_FSM_STAGE_LAST_UPDATE_TIME = "aaa_LdapEpFsmStage_lastUpdateTime"
    SORT_PROP_AAA_LDAP_EP_FSM_STAGE_NAME = "aaa_LdapEpFsmStage_name"
    SORT_PROP_AAA_LDAP_EP_FSM_STAGE_ORDER = "aaa_LdapEpFsmStage_order"
    SORT_PROP_AAA_LDAP_EP_FSM_STAGE_RETRY = "aaa_LdapEpFsmStage_retry"
    SORT_PROP_AAA_LDAP_EP_FSM_STAGE_STAGE_STATUS = "aaa_LdapEpFsmStage_stageStatus"
    SORT_PROP_AAA_LDAP_EP_FSM_COMPLETION_TIME = "aaa_LdapEpFsm_completionTime"
    SORT_PROP_AAA_LDAP_EP_FSM_CURRENT_FSM = "aaa_LdapEpFsm_currentFsm"
    SORT_PROP_AAA_LDAP_EP_FSM_DESCR = "aaa_LdapEpFsm_descr"
    SORT_PROP_AAA_LDAP_EP_FSM_FSM_INSTANCE_ID = "aaa_LdapEpFsm_fsmInstanceId"
    SORT_PROP_AAA_LDAP_EP_FSM_FSM_STATUS = "aaa_LdapEpFsm_fsmStatus"
    SORT_PROP_AAA_LDAP_EP_FSM_PROGRESS = "aaa_LdapEpFsm_progress"
    SORT_PROP_AAA_LDAP_EP_FSM_RMT_ERR_CODE = "aaa_LdapEpFsm_rmtErrCode"
    SORT_PROP_AAA_LDAP_EP_FSM_RMT_ERR_DESCR = "aaa_LdapEpFsm_rmtErrDescr"
    SORT_PROP_AAA_LDAP_EP_FSM_RMT_RSLT = "aaa_LdapEpFsm_rmtRslt"
    SORT_PROP_AAA_LDAP_EP_ATTRIBUTE = "aaa_LdapEp_attribute"
    SORT_PROP_AAA_LDAP_EP_BASEDN = "aaa_LdapEp_basedn"
    SORT_PROP_AAA_LDAP_EP_DESCR = "aaa_LdapEp_descr"
    SORT_PROP_AAA_LDAP_EP_FILTER = "aaa_LdapEp_filter"
    SORT_PROP_AAA_LDAP_EP_FSM_DESCR = "aaa_LdapEp_fsmDescr"
    SORT_PROP_AAA_LDAP_EP_FSM_PREV = "aaa_LdapEp_fsmPrev"
    SORT_PROP_AAA_LDAP_EP_FSM_PROGR = "aaa_LdapEp_fsmProgr"
    SORT_PROP_AAA_LDAP_EP_FSM_RMT_INV_ERR_CODE = "aaa_LdapEp_fsmRmtInvErrCode"
    SORT_PROP_AAA_LDAP_EP_FSM_RMT_INV_ERR_DESCR = "aaa_LdapEp_fsmRmtInvErrDescr"
    SORT_PROP_AAA_LDAP_EP_FSM_RMT_INV_RSLT = "aaa_LdapEp_fsmRmtInvRslt"
    SORT_PROP_AAA_LDAP_EP_FSM_STAGE_DESCR = "aaa_LdapEp_fsmStageDescr"
    SORT_PROP_AAA_LDAP_EP_FSM_STAMP = "aaa_LdapEp_fsmStamp"
    SORT_PROP_AAA_LDAP_EP_FSM_STATUS = "aaa_LdapEp_fsmStatus"
    SORT_PROP_AAA_LDAP_EP_FSM_TRY = "aaa_LdapEp_fsmTry"
    SORT_PROP_AAA_LDAP_EP_INT_ID = "aaa_LdapEp_intId"
    SORT_PROP_AAA_LDAP_EP_NAME = "aaa_LdapEp_name"
    SORT_PROP_AAA_LDAP_EP_POLICY_LEVEL = "aaa_LdapEp_policyLevel"
    SORT_PROP_AAA_LDAP_EP_POLICY_OWNER = "aaa_LdapEp_policyOwner"
    SORT_PROP_AAA_LDAP_EP_RETRIES = "aaa_LdapEp_retries"
    SORT_PROP_AAA_LDAP_EP_TIMEOUT = "aaa_LdapEp_timeout"
    SORT_PROP_AAA_LDAP_GROUP_RULE_AUTHORIZATION = "aaa_LdapGroupRule_authorization"
    SORT_PROP_AAA_LDAP_GROUP_RULE_DESCR = "aaa_LdapGroupRule_descr"
    SORT_PROP_AAA_LDAP_GROUP_RULE_NAME = "aaa_LdapGroupRule_name"
    SORT_PROP_AAA_LDAP_GROUP_RULE_TARGET_ATTR = "aaa_LdapGroupRule_targetAttr"
    SORT_PROP_AAA_LDAP_GROUP_RULE_TRAVERSAL = "aaa_LdapGroupRule_traversal"
    SORT_PROP_AAA_LDAP_GROUP_DESCR = "aaa_LdapGroup_descr"
    SORT_PROP_AAA_LDAP_GROUP_NAME = "aaa_LdapGroup_name"
    SORT_PROP_AAA_LDAP_PROVIDER_ATTRIBUTE = "aaa_LdapProvider_attribute"
    SORT_PROP_AAA_LDAP_PROVIDER_BASEDN = "aaa_LdapProvider_basedn"
    SORT_PROP_AAA_LDAP_PROVIDER_DESCR = "aaa_LdapProvider_descr"
    SORT_PROP_AAA_LDAP_PROVIDER_ENABLE_SSL = "aaa_LdapProvider_enableSSL"
    SORT_PROP_AAA_LDAP_PROVIDER_ENC_KEY = "aaa_LdapProvider_encKey"
    SORT_PROP_AAA_LDAP_PROVIDER_FILTER = "aaa_LdapProvider_filter"
    SORT_PROP_AAA_LDAP_PROVIDER_KEY = "aaa_LdapProvider_key"
    SORT_PROP_AAA_LDAP_PROVIDER_KEY_SET = "aaa_LdapProvider_keySet"
    SORT_PROP_AAA_LDAP_PROVIDER_NAME = "aaa_LdapProvider_name"
    SORT_PROP_AAA_LDAP_PROVIDER_ORDER = "aaa_LdapProvider_order"
    SORT_PROP_AAA_LDAP_PROVIDER_PORT = "aaa_LdapProvider_port"
    SORT_PROP_AAA_LDAP_PROVIDER_RETRIES = "aaa_LdapProvider_retries"
    SORT_PROP_AAA_LDAP_PROVIDER_ROOTDN = "aaa_LdapProvider_rootdn"
    SORT_PROP_AAA_LDAP_PROVIDER_TIMEOUT = "aaa_LdapProvider_timeout"
    SORT_PROP_AAA_LDAP_PROVIDER_VENDOR = "aaa_LdapProvider_vendor"
    SORT_PROP_AAA_LOCALE_CONFIG_STATE = "aaa_Locale_configState"
    SORT_PROP_AAA_LOCALE_CONFIG_STATUS_MESSAGE = "aaa_Locale_configStatusMessage"
    SORT_PROP_AAA_LOCALE_DESCR = "aaa_Locale_descr"
    SORT_PROP_AAA_LOCALE_INT_ID = "aaa_Locale_intId"
    SORT_PROP_AAA_LOCALE_NAME = "aaa_Locale_name"
    SORT_PROP_AAA_LOCALE_POLICY_LEVEL = "aaa_Locale_policyLevel"
    SORT_PROP_AAA_LOCALE_POLICY_OWNER = "aaa_Locale_policyOwner"
    SORT_PROP_AAA_LOG_MAX_SIZE = "aaa_Log_maxSize"
    SORT_PROP_AAA_LOG_PURGE_WINDOW = "aaa_Log_purgeWindow"
    SORT_PROP_AAA_LOG_SIZE = "aaa_Log_size"
    SORT_PROP_AAA_MOD_LR_AFFECTED = "aaa_ModLR_affected"
    SORT_PROP_AAA_MOD_LR_CAUSE = "aaa_ModLR_cause"
    SORT_PROP_AAA_MOD_LR_CHANGE_SET = "aaa_ModLR_changeSet"
    SORT_PROP_AAA_MOD_LR_CODE = "aaa_ModLR_code"
    SORT_PROP_AAA_MOD_LR_CREATED = "aaa_ModLR_created"
    SORT_PROP_AAA_MOD_LR_DESCR = "aaa_ModLR_descr"
    SORT_PROP_AAA_MOD_LR_ID = "aaa_ModLR_id"
    SORT_PROP_AAA_MOD_LR_IND = "aaa_ModLR_ind"
    SORT_PROP_AAA_MOD_LR_SEVERITY = "aaa_ModLR_severity"
    SORT_PROP_AAA_MOD_LR_SRC_DME = "aaa_ModLR_srcDme"
    SORT_PROP_AAA_MOD_LR_TRIG = "aaa_ModLR_trig"
    SORT_PROP_AAA_MOD_LR_TX_ID = "aaa_ModLR_txId"
    SORT_PROP_AAA_MOD_LR_USER = "aaa_ModLR_user"
    SORT_PROP_AAA_ORG_DESCR = "aaa_Org_descr"
    SORT_PROP_AAA_ORG_NAME = "aaa_Org_name"
    SORT_PROP_AAA_ORG_ORG_DN = "aaa_Org_orgDn"
    SORT_PROP_AAA_PROVIDER_GROUP_DESCR = "aaa_ProviderGroup_descr"
    SORT_PROP_AAA_PROVIDER_GROUP_NAME = "aaa_ProviderGroup_name"
    SORT_PROP_AAA_PROVIDER_REF_DESCR = "aaa_ProviderRef_descr"
    SORT_PROP_AAA_PROVIDER_REF_NAME = "aaa_ProviderRef_name"
    SORT_PROP_AAA_PROVIDER_REF_ORDER = "aaa_ProviderRef_order"
    SORT_PROP_AAA_PROVIDER_DESCR = "aaa_Provider_descr"
    SORT_PROP_AAA_PROVIDER_ENC_KEY = "aaa_Provider_encKey"
    SORT_PROP_AAA_PROVIDER_KEY = "aaa_Provider_key"
    SORT_PROP_AAA_PROVIDER_KEY_SET = "aaa_Provider_keySet"
    SORT_PROP_AAA_PROVIDER_NAME = "aaa_Provider_name"
    SORT_PROP_AAA_PROVIDER_ORDER = "aaa_Provider_order"
    SORT_PROP_AAA_PROVIDER_RETRIES = "aaa_Provider_retries"
    SORT_PROP_AAA_PROVIDER_TIMEOUT = "aaa_Provider_timeout"
    SORT_PROP_AAA_PWD_PROFILE_CHANGE_COUNT = "aaa_PwdProfile_changeCount"
    SORT_PROP_AAA_PWD_PROFILE_CHANGE_DURING_INTERVAL = "aaa_PwdProfile_changeDuringInterval"
    SORT_PROP_AAA_PWD_PROFILE_CHANGE_INTERVAL = "aaa_PwdProfile_changeInterval"
    SORT_PROP_AAA_PWD_PROFILE_DESCR = "aaa_PwdProfile_descr"
    SORT_PROP_AAA_PWD_PROFILE_EXPIRATION_WARN_TIME = "aaa_PwdProfile_expirationWarnTime"
    SORT_PROP_AAA_PWD_PROFILE_HISTORY_COUNT = "aaa_PwdProfile_historyCount"
    SORT_PROP_AAA_PWD_PROFILE_INT_ID = "aaa_PwdProfile_intId"
    SORT_PROP_AAA_PWD_PROFILE_NAME = "aaa_PwdProfile_name"
    SORT_PROP_AAA_PWD_PROFILE_NO_CHANGE_INTERVAL = "aaa_PwdProfile_noChangeInterval"
    SORT_PROP_AAA_PWD_PROFILE_POLICY_LEVEL = "aaa_PwdProfile_policyLevel"
    SORT_PROP_AAA_PWD_PROFILE_POLICY_OWNER = "aaa_PwdProfile_policyOwner"
    SORT_PROP_AAA_PWD_PROFILE_PWD_STRENGTH_CHECK = "aaa_PwdProfile_pwdStrengthCheck"
    SORT_PROP_AAA_RADIUS_EP_FSM_STAGE_DESCR = "aaa_RadiusEpFsmStage_descr"
    SORT_PROP_AAA_RADIUS_EP_FSM_STAGE_LAST_UPDATE_TIME = "aaa_RadiusEpFsmStage_lastUpdateTime"
    SORT_PROP_AAA_RADIUS_EP_FSM_STAGE_NAME = "aaa_RadiusEpFsmStage_name"
    SORT_PROP_AAA_RADIUS_EP_FSM_STAGE_ORDER = "aaa_RadiusEpFsmStage_order"
    SORT_PROP_AAA_RADIUS_EP_FSM_STAGE_RETRY = "aaa_RadiusEpFsmStage_retry"
    SORT_PROP_AAA_RADIUS_EP_FSM_STAGE_STAGE_STATUS = "aaa_RadiusEpFsmStage_stageStatus"
    SORT_PROP_AAA_RADIUS_EP_FSM_COMPLETION_TIME = "aaa_RadiusEpFsm_completionTime"
    SORT_PROP_AAA_RADIUS_EP_FSM_CURRENT_FSM = "aaa_RadiusEpFsm_currentFsm"
    SORT_PROP_AAA_RADIUS_EP_FSM_DESCR = "aaa_RadiusEpFsm_descr"
    SORT_PROP_AAA_RADIUS_EP_FSM_FSM_INSTANCE_ID = "aaa_RadiusEpFsm_fsmInstanceId"
    SORT_PROP_AAA_RADIUS_EP_FSM_FSM_STATUS = "aaa_RadiusEpFsm_fsmStatus"
    SORT_PROP_AAA_RADIUS_EP_FSM_PROGRESS = "aaa_RadiusEpFsm_progress"
    SORT_PROP_AAA_RADIUS_EP_FSM_RMT_ERR_CODE = "aaa_RadiusEpFsm_rmtErrCode"
    SORT_PROP_AAA_RADIUS_EP_FSM_RMT_ERR_DESCR = "aaa_RadiusEpFsm_rmtErrDescr"
    SORT_PROP_AAA_RADIUS_EP_FSM_RMT_RSLT = "aaa_RadiusEpFsm_rmtRslt"
    SORT_PROP_AAA_RADIUS_EP_DESCR = "aaa_RadiusEp_descr"
    SORT_PROP_AAA_RADIUS_EP_FSM_DESCR = "aaa_RadiusEp_fsmDescr"
    SORT_PROP_AAA_RADIUS_EP_FSM_PREV = "aaa_RadiusEp_fsmPrev"
    SORT_PROP_AAA_RADIUS_EP_FSM_PROGR = "aaa_RadiusEp_fsmProgr"
    SORT_PROP_AAA_RADIUS_EP_FSM_RMT_INV_ERR_CODE = "aaa_RadiusEp_fsmRmtInvErrCode"
    SORT_PROP_AAA_RADIUS_EP_FSM_RMT_INV_ERR_DESCR = "aaa_RadiusEp_fsmRmtInvErrDescr"
    SORT_PROP_AAA_RADIUS_EP_FSM_RMT_INV_RSLT = "aaa_RadiusEp_fsmRmtInvRslt"
    SORT_PROP_AAA_RADIUS_EP_FSM_STAGE_DESCR = "aaa_RadiusEp_fsmStageDescr"
    SORT_PROP_AAA_RADIUS_EP_FSM_STAMP = "aaa_RadiusEp_fsmStamp"
    SORT_PROP_AAA_RADIUS_EP_FSM_STATUS = "aaa_RadiusEp_fsmStatus"
    SORT_PROP_AAA_RADIUS_EP_FSM_TRY = "aaa_RadiusEp_fsmTry"
    SORT_PROP_AAA_RADIUS_EP_INT_ID = "aaa_RadiusEp_intId"
    SORT_PROP_AAA_RADIUS_EP_NAME = "aaa_RadiusEp_name"
    SORT_PROP_AAA_RADIUS_EP_POLICY_LEVEL = "aaa_RadiusEp_policyLevel"
    SORT_PROP_AAA_RADIUS_EP_POLICY_OWNER = "aaa_RadiusEp_policyOwner"
    SORT_PROP_AAA_RADIUS_EP_RETRIES = "aaa_RadiusEp_retries"
    SORT_PROP_AAA_RADIUS_EP_TIMEOUT = "aaa_RadiusEp_timeout"
    SORT_PROP_AAA_RADIUS_PROVIDER_AUTH_PORT = "aaa_RadiusProvider_authPort"
    SORT_PROP_AAA_RADIUS_PROVIDER_DESCR = "aaa_RadiusProvider_descr"
    SORT_PROP_AAA_RADIUS_PROVIDER_ENC_KEY = "aaa_RadiusProvider_encKey"
    SORT_PROP_AAA_RADIUS_PROVIDER_KEY = "aaa_RadiusProvider_key"
    SORT_PROP_AAA_RADIUS_PROVIDER_KEY_SET = "aaa_RadiusProvider_keySet"
    SORT_PROP_AAA_RADIUS_PROVIDER_NAME = "aaa_RadiusProvider_name"
    SORT_PROP_AAA_RADIUS_PROVIDER_ORDER = "aaa_RadiusProvider_order"
    SORT_PROP_AAA_RADIUS_PROVIDER_RETRIES = "aaa_RadiusProvider_retries"
    SORT_PROP_AAA_RADIUS_PROVIDER_SERVICE = "aaa_RadiusProvider_service"
    SORT_PROP_AAA_RADIUS_PROVIDER_TIMEOUT = "aaa_RadiusProvider_timeout"
    SORT_PROP_AAA_REALM_FSM_STAGE_DESCR = "aaa_RealmFsmStage_descr"
    SORT_PROP_AAA_REALM_FSM_STAGE_LAST_UPDATE_TIME = "aaa_RealmFsmStage_lastUpdateTime"
    SORT_PROP_AAA_REALM_FSM_STAGE_NAME = "aaa_RealmFsmStage_name"
    SORT_PROP_AAA_REALM_FSM_STAGE_ORDER = "aaa_RealmFsmStage_order"
    SORT_PROP_AAA_REALM_FSM_STAGE_RETRY = "aaa_RealmFsmStage_retry"
    SORT_PROP_AAA_REALM_FSM_STAGE_STAGE_STATUS = "aaa_RealmFsmStage_stageStatus"
    SORT_PROP_AAA_REALM_FSM_TASK_COMPLETION = "aaa_RealmFsmTask_completion"
    SORT_PROP_AAA_REALM_FSM_TASK_FLAGS = "aaa_RealmFsmTask_flags"
    SORT_PROP_AAA_REALM_FSM_TASK_ITEM = "aaa_RealmFsmTask_item"
    SORT_PROP_AAA_REALM_FSM_TASK_SEQ_ID = "aaa_RealmFsmTask_seqId"
    SORT_PROP_AAA_REALM_FSM_COMPLETION_TIME = "aaa_RealmFsm_completionTime"
    SORT_PROP_AAA_REALM_FSM_CURRENT_FSM = "aaa_RealmFsm_currentFsm"
    SORT_PROP_AAA_REALM_FSM_DESCR = "aaa_RealmFsm_descr"
    SORT_PROP_AAA_REALM_FSM_FSM_INSTANCE_ID = "aaa_RealmFsm_fsmInstanceId"
    SORT_PROP_AAA_REALM_FSM_FSM_STATUS = "aaa_RealmFsm_fsmStatus"
    SORT_PROP_AAA_REALM_FSM_PROGRESS = "aaa_RealmFsm_progress"
    SORT_PROP_AAA_REALM_FSM_RMT_ERR_CODE = "aaa_RealmFsm_rmtErrCode"
    SORT_PROP_AAA_REALM_FSM_RMT_ERR_DESCR = "aaa_RealmFsm_rmtErrDescr"
    SORT_PROP_AAA_REALM_FSM_RMT_RSLT = "aaa_RealmFsm_rmtRslt"
    SORT_PROP_AAA_REALM_DESCR = "aaa_Realm_descr"
    SORT_PROP_AAA_REALM_FSM_DESCR = "aaa_Realm_fsmDescr"
    SORT_PROP_AAA_REALM_FSM_PREV = "aaa_Realm_fsmPrev"
    SORT_PROP_AAA_REALM_FSM_PROGR = "aaa_Realm_fsmProgr"
    SORT_PROP_AAA_REALM_FSM_RMT_INV_ERR_CODE = "aaa_Realm_fsmRmtInvErrCode"
    SORT_PROP_AAA_REALM_FSM_RMT_INV_ERR_DESCR = "aaa_Realm_fsmRmtInvErrDescr"
    SORT_PROP_AAA_REALM_FSM_RMT_INV_RSLT = "aaa_Realm_fsmRmtInvRslt"
    SORT_PROP_AAA_REALM_FSM_STAGE_DESCR = "aaa_Realm_fsmStageDescr"
    SORT_PROP_AAA_REALM_FSM_STAMP = "aaa_Realm_fsmStamp"
    SORT_PROP_AAA_REALM_FSM_STATUS = "aaa_Realm_fsmStatus"
    SORT_PROP_AAA_REALM_FSM_TRY = "aaa_Realm_fsmTry"
    SORT_PROP_AAA_REALM_INT_ID = "aaa_Realm_intId"
    SORT_PROP_AAA_REALM_NAME = "aaa_Realm_name"
    SORT_PROP_AAA_REALM_POLICY_LEVEL = "aaa_Realm_policyLevel"
    SORT_PROP_AAA_REALM_POLICY_OWNER = "aaa_Realm_policyOwner"
    SORT_PROP_AAA_REMOTE_USER_DESCR = "aaa_RemoteUser_descr"
    SORT_PROP_AAA_REMOTE_USER_INT_ID = "aaa_RemoteUser_intId"
    SORT_PROP_AAA_REMOTE_USER_NAME = "aaa_RemoteUser_name"
    SORT_PROP_AAA_REMOTE_USER_POLICY_LEVEL = "aaa_RemoteUser_policyLevel"
    SORT_PROP_AAA_REMOTE_USER_POLICY_OWNER = "aaa_RemoteUser_policyOwner"
    SORT_PROP_AAA_REMOTE_USER_PWD = "aaa_RemoteUser_pwd"
    SORT_PROP_AAA_REMOTE_USER_PWD_SET = "aaa_RemoteUser_pwdSet"
    SORT_PROP_AAA_ROLE_CONFIG_STATE = "aaa_Role_configState"
    SORT_PROP_AAA_ROLE_CONFIG_STATUS_MESSAGE = "aaa_Role_configStatusMessage"
    SORT_PROP_AAA_ROLE_DESCR = "aaa_Role_descr"
    SORT_PROP_AAA_ROLE_INT_ID = "aaa_Role_intId"
    SORT_PROP_AAA_ROLE_NAME = "aaa_Role_name"
    SORT_PROP_AAA_ROLE_POLICY_LEVEL = "aaa_Role_policyLevel"
    SORT_PROP_AAA_ROLE_POLICY_OWNER = "aaa_Role_policyOwner"
    SORT_PROP_AAA_ROLE_PRIV = "aaa_Role_priv"
    SORT_PROP_AAA_SESSION_LR_AFFECTED = "aaa_SessionLR_affected"
    SORT_PROP_AAA_SESSION_LR_CAUSE = "aaa_SessionLR_cause"
    SORT_PROP_AAA_SESSION_LR_CHANGE_SET = "aaa_SessionLR_changeSet"
    SORT_PROP_AAA_SESSION_LR_CODE = "aaa_SessionLR_code"
    SORT_PROP_AAA_SESSION_LR_CREATED = "aaa_SessionLR_created"
    SORT_PROP_AAA_SESSION_LR_DESCR = "aaa_SessionLR_descr"
    SORT_PROP_AAA_SESSION_LR_ID = "aaa_SessionLR_id"
    SORT_PROP_AAA_SESSION_LR_IND = "aaa_SessionLR_ind"
    SORT_PROP_AAA_SESSION_LR_SEVERITY = "aaa_SessionLR_severity"
    SORT_PROP_AAA_SESSION_LR_SRC_DME = "aaa_SessionLR_srcDme"
    SORT_PROP_AAA_SESSION_LR_TRIG = "aaa_SessionLR_trig"
    SORT_PROP_AAA_SESSION_LR_TX_ID = "aaa_SessionLR_txId"
    SORT_PROP_AAA_SESSION_LR_USER = "aaa_SessionLR_user"
    SORT_PROP_AAA_SESSION_HOST = "aaa_Session_host"
    SORT_PROP_AAA_SESSION_ID = "aaa_Session_id"
    SORT_PROP_AAA_SESSION_INT_DEL = "aaa_Session_intDel"
    SORT_PROP_AAA_SESSION_LOGIN_TIME = "aaa_Session_loginTime"
    SORT_PROP_AAA_SESSION_PID = "aaa_Session_pid"
    SORT_PROP_AAA_SESSION_TERM = "aaa_Session_term"
    SORT_PROP_AAA_SESSION_UI = "aaa_Session_ui"
    SORT_PROP_AAA_SESSION_USER = "aaa_Session_user"
    SORT_PROP_AAA_SHELL_LOGIN_DESCR = "aaa_ShellLogin_descr"
    SORT_PROP_AAA_SHELL_LOGIN_ID = "aaa_ShellLogin_id"
    SORT_PROP_AAA_SHELL_LOGIN_INT_ID = "aaa_ShellLogin_intId"
    SORT_PROP_AAA_SHELL_LOGIN_LOCAL_HOST = "aaa_ShellLogin_localHost"
    SORT_PROP_AAA_SHELL_LOGIN_NAME = "aaa_ShellLogin_name"
    SORT_PROP_AAA_SHELL_LOGIN_POLICY_LEVEL = "aaa_ShellLogin_policyLevel"
    SORT_PROP_AAA_SHELL_LOGIN_POLICY_OWNER = "aaa_ShellLogin_policyOwner"
    SORT_PROP_AAA_SHELL_LOGIN_REMOTE_HOST = "aaa_ShellLogin_remoteHost"
    SORT_PROP_AAA_SHELL_LOGIN_SESSION = "aaa_ShellLogin_session"
    SORT_PROP_AAA_SSH_AUTH_DATA = "aaa_SshAuth_data"
    SORT_PROP_AAA_SSH_AUTH_OLD_STR_TYPE = "aaa_SshAuth_oldStrType"
    SORT_PROP_AAA_SSH_AUTH_STR_TYPE = "aaa_SshAuth_strType"
    SORT_PROP_AAA_SYSTEM_USER_DESCR = "aaa_SystemUser_descr"
    SORT_PROP_AAA_SYSTEM_USER_INT_ID = "aaa_SystemUser_intId"
    SORT_PROP_AAA_SYSTEM_USER_NAME = "aaa_SystemUser_name"
    SORT_PROP_AAA_SYSTEM_USER_POLICY_LEVEL = "aaa_SystemUser_policyLevel"
    SORT_PROP_AAA_SYSTEM_USER_POLICY_OWNER = "aaa_SystemUser_policyOwner"
    SORT_PROP_AAA_SYSTEM_USER_PWD = "aaa_SystemUser_pwd"
    SORT_PROP_AAA_SYSTEM_USER_PWD_SET = "aaa_SystemUser_pwdSet"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_STAGE_DESCR = "aaa_TacacsPlusEpFsmStage_descr"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_STAGE_LAST_UPDATE_TIME = "aaa_TacacsPlusEpFsmStage_lastUpdateTime"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_STAGE_NAME = "aaa_TacacsPlusEpFsmStage_name"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_STAGE_ORDER = "aaa_TacacsPlusEpFsmStage_order"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_STAGE_RETRY = "aaa_TacacsPlusEpFsmStage_retry"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_STAGE_STAGE_STATUS = "aaa_TacacsPlusEpFsmStage_stageStatus"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_COMPLETION_TIME = "aaa_TacacsPlusEpFsm_completionTime"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_CURRENT_FSM = "aaa_TacacsPlusEpFsm_currentFsm"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_DESCR = "aaa_TacacsPlusEpFsm_descr"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_FSM_INSTANCE_ID = "aaa_TacacsPlusEpFsm_fsmInstanceId"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_FSM_STATUS = "aaa_TacacsPlusEpFsm_fsmStatus"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_PROGRESS = "aaa_TacacsPlusEpFsm_progress"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_RMT_ERR_CODE = "aaa_TacacsPlusEpFsm_rmtErrCode"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_RMT_ERR_DESCR = "aaa_TacacsPlusEpFsm_rmtErrDescr"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_RMT_RSLT = "aaa_TacacsPlusEpFsm_rmtRslt"
    SORT_PROP_AAA_TACACS_PLUS_EP_DESCR = "aaa_TacacsPlusEp_descr"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_DESCR = "aaa_TacacsPlusEp_fsmDescr"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_PREV = "aaa_TacacsPlusEp_fsmPrev"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_PROGR = "aaa_TacacsPlusEp_fsmProgr"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_RMT_INV_ERR_CODE = "aaa_TacacsPlusEp_fsmRmtInvErrCode"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_RMT_INV_ERR_DESCR = "aaa_TacacsPlusEp_fsmRmtInvErrDescr"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_RMT_INV_RSLT = "aaa_TacacsPlusEp_fsmRmtInvRslt"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_STAGE_DESCR = "aaa_TacacsPlusEp_fsmStageDescr"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_STAMP = "aaa_TacacsPlusEp_fsmStamp"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_STATUS = "aaa_TacacsPlusEp_fsmStatus"
    SORT_PROP_AAA_TACACS_PLUS_EP_FSM_TRY = "aaa_TacacsPlusEp_fsmTry"
    SORT_PROP_AAA_TACACS_PLUS_EP_INT_ID = "aaa_TacacsPlusEp_intId"
    SORT_PROP_AAA_TACACS_PLUS_EP_NAME = "aaa_TacacsPlusEp_name"
    SORT_PROP_AAA_TACACS_PLUS_EP_POLICY_LEVEL = "aaa_TacacsPlusEp_policyLevel"
    SORT_PROP_AAA_TACACS_PLUS_EP_POLICY_OWNER = "aaa_TacacsPlusEp_policyOwner"
    SORT_PROP_AAA_TACACS_PLUS_EP_RETRIES = "aaa_TacacsPlusEp_retries"
    SORT_PROP_AAA_TACACS_PLUS_EP_TIMEOUT = "aaa_TacacsPlusEp_timeout"
    SORT_PROP_AAA_TACACS_PLUS_PROVIDER_DESCR = "aaa_TacacsPlusProvider_descr"
    SORT_PROP_AAA_TACACS_PLUS_PROVIDER_ENC_KEY = "aaa_TacacsPlusProvider_encKey"
    SORT_PROP_AAA_TACACS_PLUS_PROVIDER_KEY = "aaa_TacacsPlusProvider_key"
    SORT_PROP_AAA_TACACS_PLUS_PROVIDER_KEY_SET = "aaa_TacacsPlusProvider_keySet"
    SORT_PROP_AAA_TACACS_PLUS_PROVIDER_NAME = "aaa_TacacsPlusProvider_name"
    SORT_PROP_AAA_TACACS_PLUS_PROVIDER_ORDER = "aaa_TacacsPlusProvider_order"
    SORT_PROP_AAA_TACACS_PLUS_PROVIDER_PORT = "aaa_TacacsPlusProvider_port"
    SORT_PROP_AAA_TACACS_PLUS_PROVIDER_RETRIES = "aaa_TacacsPlusProvider_retries"
    SORT_PROP_AAA_TACACS_PLUS_PROVIDER_TIMEOUT = "aaa_TacacsPlusProvider_timeout"
    SORT_PROP_AAA_USER_ACTION_AFFECTED = "aaa_UserAction_affected"
    SORT_PROP_AAA_USER_ACTION_CAUSE = "aaa_UserAction_cause"
    SORT_PROP_AAA_USER_ACTION_CHANGE_SET = "aaa_UserAction_changeSet"
    SORT_PROP_AAA_USER_ACTION_CODE = "aaa_UserAction_code"
    SORT_PROP_AAA_USER_ACTION_CREATED = "aaa_UserAction_created"
    SORT_PROP_AAA_USER_ACTION_DESCR = "aaa_UserAction_descr"
    SORT_PROP_AAA_USER_ACTION_ID = "aaa_UserAction_id"
    SORT_PROP_AAA_USER_ACTION_IND = "aaa_UserAction_ind"
    SORT_PROP_AAA_USER_ACTION_SEVERITY = "aaa_UserAction_severity"
    SORT_PROP_AAA_USER_ACTION_SRC_DME = "aaa_UserAction_srcDme"
    SORT_PROP_AAA_USER_ACTION_TRIG = "aaa_UserAction_trig"
    SORT_PROP_AAA_USER_ACTION_TX_ID = "aaa_UserAction_txId"
    SORT_PROP_AAA_USER_ACTION_USER = "aaa_UserAction_user"
    SORT_PROP_AAA_USER_DATA_DESCR = "aaa_UserData_descr"
    SORT_PROP_AAA_USER_DATA_INT_ID = "aaa_UserData_intId"
    SORT_PROP_AAA_USER_DATA_NAME = "aaa_UserData_name"
    SORT_PROP_AAA_USER_DATA_POLICY_LEVEL = "aaa_UserData_policyLevel"
    SORT_PROP_AAA_USER_DATA_POLICY_OWNER = "aaa_UserData_policyOwner"
    SORT_PROP_AAA_USER_DATA_PWD_CHANGE_COUNT = "aaa_UserData_pwdChangeCount"
    SORT_PROP_AAA_USER_DATA_PWD_CHANGE_INTERVAL_BEGIN = "aaa_UserData_pwdChangeIntervalBegin"
    SORT_PROP_AAA_USER_DATA_PWD_CHANGED_DATE = "aaa_UserData_pwdChangedDate"
    SORT_PROP_AAA_USER_DATA_PWD_HISTORY = "aaa_UserData_pwdHistory"
    SORT_PROP_AAA_USER_EP_FSM_STAGE_DESCR = "aaa_UserEpFsmStage_descr"
    SORT_PROP_AAA_USER_EP_FSM_STAGE_LAST_UPDATE_TIME = "aaa_UserEpFsmStage_lastUpdateTime"
    SORT_PROP_AAA_USER_EP_FSM_STAGE_NAME = "aaa_UserEpFsmStage_name"
    SORT_PROP_AAA_USER_EP_FSM_STAGE_ORDER = "aaa_UserEpFsmStage_order"
    SORT_PROP_AAA_USER_EP_FSM_STAGE_RETRY = "aaa_UserEpFsmStage_retry"
    SORT_PROP_AAA_USER_EP_FSM_STAGE_STAGE_STATUS = "aaa_UserEpFsmStage_stageStatus"
    SORT_PROP_AAA_USER_EP_FSM_TASK_COMPLETION = "aaa_UserEpFsmTask_completion"
    SORT_PROP_AAA_USER_EP_FSM_TASK_FLAGS = "aaa_UserEpFsmTask_flags"
    SORT_PROP_AAA_USER_EP_FSM_TASK_ITEM = "aaa_UserEpFsmTask_item"
    SORT_PROP_AAA_USER_EP_FSM_TASK_SEQ_ID = "aaa_UserEpFsmTask_seqId"
    SORT_PROP_AAA_USER_EP_FSM_COMPLETION_TIME = "aaa_UserEpFsm_completionTime"
    SORT_PROP_AAA_USER_EP_FSM_CURRENT_FSM = "aaa_UserEpFsm_currentFsm"
    SORT_PROP_AAA_USER_EP_FSM_DESCR = "aaa_UserEpFsm_descr"
    SORT_PROP_AAA_USER_EP_FSM_FSM_INSTANCE_ID = "aaa_UserEpFsm_fsmInstanceId"
    SORT_PROP_AAA_USER_EP_FSM_FSM_STATUS = "aaa_UserEpFsm_fsmStatus"
    SORT_PROP_AAA_USER_EP_FSM_PROGRESS = "aaa_UserEpFsm_progress"
    SORT_PROP_AAA_USER_EP_FSM_RMT_ERR_CODE = "aaa_UserEpFsm_rmtErrCode"
    SORT_PROP_AAA_USER_EP_FSM_RMT_ERR_DESCR = "aaa_UserEpFsm_rmtErrDescr"
    SORT_PROP_AAA_USER_EP_FSM_RMT_RSLT = "aaa_UserEpFsm_rmtRslt"
    SORT_PROP_AAA_USER_EP_DESCR = "aaa_UserEp_descr"
    SORT_PROP_AAA_USER_EP_FSM_DESCR = "aaa_UserEp_fsmDescr"
    SORT_PROP_AAA_USER_EP_FSM_PREV = "aaa_UserEp_fsmPrev"
    SORT_PROP_AAA_USER_EP_FSM_PROGR = "aaa_UserEp_fsmProgr"
    SORT_PROP_AAA_USER_EP_FSM_RMT_INV_ERR_CODE = "aaa_UserEp_fsmRmtInvErrCode"
    SORT_PROP_AAA_USER_EP_FSM_RMT_INV_ERR_DESCR = "aaa_UserEp_fsmRmtInvErrDescr"
    SORT_PROP_AAA_USER_EP_FSM_RMT_INV_RSLT = "aaa_UserEp_fsmRmtInvRslt"
    SORT_PROP_AAA_USER_EP_FSM_STAGE_DESCR = "aaa_UserEp_fsmStageDescr"
    SORT_PROP_AAA_USER_EP_FSM_STAMP = "aaa_UserEp_fsmStamp"
    SORT_PROP_AAA_USER_EP_FSM_STATUS = "aaa_UserEp_fsmStatus"
    SORT_PROP_AAA_USER_EP_FSM_TRY = "aaa_UserEp_fsmTry"
    SORT_PROP_AAA_USER_EP_INT_ID = "aaa_UserEp_intId"
    SORT_PROP_AAA_USER_EP_NAME = "aaa_UserEp_name"
    SORT_PROP_AAA_USER_EP_POLICY_LEVEL = "aaa_UserEp_policyLevel"
    SORT_PROP_AAA_USER_EP_POLICY_OWNER = "aaa_UserEp_policyOwner"
    SORT_PROP_AAA_USER_EP_PWD_STRENGTH_CHECK = "aaa_UserEp_pwdStrengthCheck"
    SORT_PROP_AAA_USER_GROUP_DESCR = "aaa_UserGroup_descr"
    SORT_PROP_AAA_USER_GROUP_NAME = "aaa_UserGroup_name"
    SORT_PROP_AAA_USER_LOCALE_CONFIG_STATE = "aaa_UserLocale_configState"
    SORT_PROP_AAA_USER_LOCALE_CONFIG_STATUS_MESSAGE = "aaa_UserLocale_configStatusMessage"
    SORT_PROP_AAA_USER_LOCALE_DESCR = "aaa_UserLocale_descr"
    SORT_PROP_AAA_USER_LOCALE_NAME = "aaa_UserLocale_name"
    SORT_PROP_AAA_USER_LOGIN_DESCR = "aaa_UserLogin_descr"
    SORT_PROP_AAA_USER_LOGIN_ID = "aaa_UserLogin_id"
    SORT_PROP_AAA_USER_LOGIN_INT_ID = "aaa_UserLogin_intId"
    SORT_PROP_AAA_USER_LOGIN_LOCAL_HOST = "aaa_UserLogin_localHost"
    SORT_PROP_AAA_USER_LOGIN_NAME = "aaa_UserLogin_name"
    SORT_PROP_AAA_USER_LOGIN_POLICY_LEVEL = "aaa_UserLogin_policyLevel"
    SORT_PROP_AAA_USER_LOGIN_POLICY_OWNER = "aaa_UserLogin_policyOwner"
    SORT_PROP_AAA_USER_LOGIN_REMOTE_HOST = "aaa_UserLogin_remoteHost"
    SORT_PROP_AAA_USER_LOGIN_SESSION = "aaa_UserLogin_session"
    SORT_PROP_AAA_USER_PREFERENCES_BASIC_WIDGET_DISABLED = "aaa_UserPreferences_basicWidgetDisabled"
    SORT_PROP_AAA_USER_PREFERENCES_DASHBOARD = "aaa_UserPreferences_dashboard"
    SORT_PROP_AAA_USER_PREFERENCES_DESCR = "aaa_UserPreferences_descr"
    SORT_PROP_AAA_USER_PREFERENCES_FAVORITES = "aaa_UserPreferences_favorites"
    SORT_PROP_AAA_USER_PREFERENCES_FEATURE_TOUR_DISABLED = "aaa_UserPreferences_featureTourDisabled"
    SORT_PROP_AAA_USER_PREFERENCES_FONT_SIZE = "aaa_UserPreferences_fontSize"
    SORT_PROP_AAA_USER_PREFERENCES_FORCE_ESTIMATE_IMPACT = "aaa_UserPreferences_forceEstimateImpact"
    SORT_PROP_AAA_USER_PREFERENCES_LANGUAGE = "aaa_UserPreferences_language"
    SORT_PROP_AAA_USER_PREFERENCES_NAME = "aaa_UserPreferences_name"
    SORT_PROP_AAA_USER_PREFERENCES_RESTORED_TABS = "aaa_UserPreferences_restoredTabs"
    SORT_PROP_AAA_USER_PREFERENCES_SAVED_QUERIES = "aaa_UserPreferences_savedQueries"
    SORT_PROP_AAA_USER_PREFERENCES_SESSION_TIMEOUT = "aaa_UserPreferences_sessionTimeout"
    SORT_PROP_AAA_USER_PREFERENCES_TAB_RESTORE_MODE = "aaa_UserPreferences_tabRestoreMode"
    SORT_PROP_AAA_USER_PREFERENCES_WELCOME_WIDGET_DISABLED = "aaa_UserPreferences_welcomeWidgetDisabled"
    SORT_PROP_AAA_USER_ROLE_CONFIG_STATE = "aaa_UserRole_configState"
    SORT_PROP_AAA_USER_ROLE_CONFIG_STATUS_MESSAGE = "aaa_UserRole_configStatusMessage"
    SORT_PROP_AAA_USER_ROLE_DESCR = "aaa_UserRole_descr"
    SORT_PROP_AAA_USER_ROLE_NAME = "aaa_UserRole_name"
    SORT_PROP_AAA_USER_ACCOUNT_STATUS = "aaa_User_accountStatus"
    SORT_PROP_AAA_USER_CLEAR_PWD_HISTORY = "aaa_User_clearPwdHistory"
    SORT_PROP_AAA_USER_DESCR = "aaa_User_descr"
    SORT_PROP_AAA_USER_EMAIL = "aaa_User_email"
    SORT_PROP_AAA_USER_ENC_PWD = "aaa_User_encPwd"
    SORT_PROP_AAA_USER_EXPIRATION = "aaa_User_expiration"
    SORT_PROP_AAA_USER_EXPIRES = "aaa_User_expires"
    SORT_PROP_AAA_USER_FIRST_NAME = "aaa_User_firstName"
    SORT_PROP_AAA_USER_INT_ID = "aaa_User_intId"
    SORT_PROP_AAA_USER_LAST_NAME = "aaa_User_lastName"
    SORT_PROP_AAA_USER_NAME = "aaa_User_name"
    SORT_PROP_AAA_USER_PHONE = "aaa_User_phone"
    SORT_PROP_AAA_USER_POLICY_LEVEL = "aaa_User_policyLevel"
    SORT_PROP_AAA_USER_POLICY_OWNER = "aaa_User_policyOwner"
    SORT_PROP_AAA_USER_PRIV = "aaa_User_priv"
    SORT_PROP_AAA_USER_PWD = "aaa_User_pwd"
    SORT_PROP_AAA_USER_PWD_LIFE_TIME = "aaa_User_pwdLifeTime"
    SORT_PROP_AAA_USER_PWD_SET = "aaa_User_pwdSet"
    SORT_PROP_AAA_WEB_LOGIN_DESCR = "aaa_WebLogin_descr"
    SORT_PROP_AAA_WEB_LOGIN_ID = "aaa_WebLogin_id"
    SORT_PROP_AAA_WEB_LOGIN_INT_ID = "aaa_WebLogin_intId"
    SORT_PROP_AAA_WEB_LOGIN_LOCAL_HOST = "aaa_WebLogin_localHost"
    SORT_PROP_AAA_WEB_LOGIN_NAME = "aaa_WebLogin_name"
    SORT_PROP_AAA_WEB_LOGIN_POLICY_LEVEL = "aaa_WebLogin_policyLevel"
    SORT_PROP_AAA_WEB_LOGIN_POLICY_OWNER = "aaa_WebLogin_policyOwner"
    SORT_PROP_AAA_WEB_LOGIN_REMOTE_HOST = "aaa_WebLogin_remoteHost"
    SORT_PROP_AAA_WEB_LOGIN_SESSION = "aaa_WebLogin_session"
    SORT_PROP_ADAPTOR_CAP_DEF_FW_VERSION_HI = "adaptor_CapDef_fwVersionHi"
    SORT_PROP_ADAPTOR_CAP_DEF_FW_VERSION_LO = "adaptor_CapDef_fwVersionLo"
    SORT_PROP_ADAPTOR_CAP_DEF_FW_VERSION_OPR = "adaptor_CapDef_fwVersionOpr"
    SORT_PROP_ADAPTOR_CAP_DEF_MAXIMUM = "adaptor_CapDef_maximum"
    SORT_PROP_ADAPTOR_CAP_DEF_NF_VERSION_LO = "adaptor_CapDef_nfVersionLo"
    SORT_PROP_ADAPTOR_CAP_DEF_TYPE = "adaptor_CapDef_type"
    SORT_PROP_ADAPTOR_CAP_QUAL_FW_VERSION_HI = "adaptor_CapQual_fwVersionHi"
    SORT_PROP_ADAPTOR_CAP_QUAL_FW_VERSION_LO = "adaptor_CapQual_fwVersionLo"
    SORT_PROP_ADAPTOR_CAP_QUAL_FW_VERSION_OPR = "adaptor_CapQual_fwVersionOpr"
    SORT_PROP_ADAPTOR_CAP_QUAL_MAXIMUM = "adaptor_CapQual_maximum"
    SORT_PROP_ADAPTOR_CAP_QUAL_MODEL = "adaptor_CapQual_model"
    SORT_PROP_ADAPTOR_CAP_QUAL_NF_VERSION_LO = "adaptor_CapQual_nfVersionLo"
    SORT_PROP_ADAPTOR_CAP_QUAL_TYPE = "adaptor_CapQual_type"
    SORT_PROP_ADAPTOR_CAP_SPEC_FW_VERSION_HI = "adaptor_CapSpec_fwVersionHi"
    SORT_PROP_ADAPTOR_CAP_SPEC_FW_VERSION_LO = "adaptor_CapSpec_fwVersionLo"
    SORT_PROP_ADAPTOR_CAP_SPEC_FW_VERSION_OPR = "adaptor_CapSpec_fwVersionOpr"
    SORT_PROP_ADAPTOR_CAP_SPEC_MAXIMUM = "adaptor_CapSpec_maximum"
    SORT_PROP_ADAPTOR_CAP_SPEC_NF_VERSION_LO = "adaptor_CapSpec_nfVersionLo"
    SORT_PROP_ADAPTOR_CAP_SPEC_TYPE = "adaptor_CapSpec_type"
    SORT_PROP_ADAPTOR_ETH_ADV_FILTER_PROFILE_ADMIN_STATE = "adaptor_EthAdvFilterProfile_adminState"
    SORT_PROP_ADAPTOR_ETH_ARFS_PROFILE_ACCELARATED_RFS = "adaptor_EthArfsProfile_accelaratedRFS"
    SORT_PROP_ADAPTOR_ETH_COMP_QUEUE_PROFILE_COUNT = "adaptor_EthCompQueueProfile_count"
    SORT_PROP_ADAPTOR_ETH_COMP_QUEUE_PROFILE_RING_SIZE = "adaptor_EthCompQueueProfile_ringSize"
    SORT_PROP_ADAPTOR_ETH_FAILOVER_PROFILE_TIMEOUT = "adaptor_EthFailoverProfile_timeout"
    SORT_PROP_ADAPTOR_ETH_GENEVEPROFILE_OFFLOAD = "adaptor_EthGENEVEProfile_Offload"
    SORT_PROP_ADAPTOR_ETH_INTERRUPT_PROFILE_COALESCING_TIME = "adaptor_EthInterruptProfile_coalescingTime"
    SORT_PROP_ADAPTOR_ETH_INTERRUPT_PROFILE_COALESCING_TYPE = "adaptor_EthInterruptProfile_coalescingType"
    SORT_PROP_ADAPTOR_ETH_INTERRUPT_PROFILE_COUNT = "adaptor_EthInterruptProfile_count"
    SORT_PROP_ADAPTOR_ETH_INTERRUPT_PROFILE_MODE = "adaptor_EthInterruptProfile_mode"
    SORT_PROP_ADAPTOR_ETH_INTERRUPT_SCALING_PROFILE_ADMIN_STATE = "adaptor_EthInterruptScalingProfile_adminState"
    SORT_PROP_ADAPTOR_ETH_NVGREPROFILE_ADMIN_STATE = "adaptor_EthNVGREProfile_adminState"
    SORT_PROP_ADAPTOR_ETH_OFFLOAD_PROFILE_LARGE_RECEIVE = "adaptor_EthOffloadProfile_largeReceive"
    SORT_PROP_ADAPTOR_ETH_OFFLOAD_PROFILE_TCP_RX_CHECKSUM = "adaptor_EthOffloadProfile_tcpRxChecksum"
    SORT_PROP_ADAPTOR_ETH_OFFLOAD_PROFILE_TCP_SEGMENT = "adaptor_EthOffloadProfile_tcpSegment"
    SORT_PROP_ADAPTOR_ETH_OFFLOAD_PROFILE_TCP_TX_CHECKSUM = "adaptor_EthOffloadProfile_tcpTxChecksum"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_GREATER_THAN_OR_EQUAL_TO9216 = "adaptor_EthPortBySizeLargeStatsHist_greaterThanOrEqualTo9216"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_GREATER_THAN_OR_EQUAL_TO9216_DELTA = "adaptor_EthPortBySizeLargeStatsHist_greaterThanOrEqualTo9216Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_GREATER_THAN_OR_EQUAL_TO9216_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_greaterThanOrEqualTo9216DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_GREATER_THAN_OR_EQUAL_TO9216_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_greaterThanOrEqualTo9216DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_GREATER_THAN_OR_EQUAL_TO9216_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_greaterThanOrEqualTo9216DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_ID = "adaptor_EthPortBySizeLargeStatsHist_id"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN2048 = "adaptor_EthPortBySizeLargeStatsHist_lessThan2048"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN2048_DELTA = "adaptor_EthPortBySizeLargeStatsHist_lessThan2048Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN2048_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_lessThan2048DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN2048_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_lessThan2048DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN2048_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_lessThan2048DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN4096 = "adaptor_EthPortBySizeLargeStatsHist_lessThan4096"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN4096_DELTA = "adaptor_EthPortBySizeLargeStatsHist_lessThan4096Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN4096_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_lessThan4096DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN4096_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_lessThan4096DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN4096_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_lessThan4096DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN8192 = "adaptor_EthPortBySizeLargeStatsHist_lessThan8192"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN8192_DELTA = "adaptor_EthPortBySizeLargeStatsHist_lessThan8192Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN8192_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_lessThan8192DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN8192_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_lessThan8192DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN8192_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_lessThan8192DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN9216 = "adaptor_EthPortBySizeLargeStatsHist_lessThan9216"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN9216_DELTA = "adaptor_EthPortBySizeLargeStatsHist_lessThan9216Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN9216_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_lessThan9216DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN9216_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_lessThan9216DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN9216_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_lessThan9216DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN_OR_EQUAL_TO1518 = "adaptor_EthPortBySizeLargeStatsHist_lessThanOrEqualTo1518"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN_OR_EQUAL_TO1518_DELTA = "adaptor_EthPortBySizeLargeStatsHist_lessThanOrEqualTo1518Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN_OR_EQUAL_TO1518_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_lessThanOrEqualTo1518DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN_OR_EQUAL_TO1518_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_lessThanOrEqualTo1518DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_LESS_THAN_OR_EQUAL_TO1518_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_lessThanOrEqualTo1518DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_MOST_RECENT = "adaptor_EthPortBySizeLargeStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_NO_BREAKDOWN_GREATER_THAN1518 = "adaptor_EthPortBySizeLargeStatsHist_noBreakdownGreaterThan1518"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_NO_BREAKDOWN_GREATER_THAN1518_DELTA = "adaptor_EthPortBySizeLargeStatsHist_noBreakdownGreaterThan1518Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_NO_BREAKDOWN_GREATER_THAN1518_DELTA_AVG = "adaptor_EthPortBySizeLargeStatsHist_noBreakdownGreaterThan1518DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_NO_BREAKDOWN_GREATER_THAN1518_DELTA_MAX = "adaptor_EthPortBySizeLargeStatsHist_noBreakdownGreaterThan1518DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_NO_BREAKDOWN_GREATER_THAN1518_DELTA_MIN = "adaptor_EthPortBySizeLargeStatsHist_noBreakdownGreaterThan1518DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_SUSPECT = "adaptor_EthPortBySizeLargeStatsHist_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_THRESHOLDED = "adaptor_EthPortBySizeLargeStatsHist_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_HIST_TIME_COLLECTED = "adaptor_EthPortBySizeLargeStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_GREATER_THAN_OR_EQUAL_TO9216 = "adaptor_EthPortBySizeLargeStats_greaterThanOrEqualTo9216"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_GREATER_THAN_OR_EQUAL_TO9216_DELTA = "adaptor_EthPortBySizeLargeStats_greaterThanOrEqualTo9216Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_GREATER_THAN_OR_EQUAL_TO9216_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_greaterThanOrEqualTo9216DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_GREATER_THAN_OR_EQUAL_TO9216_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_greaterThanOrEqualTo9216DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_GREATER_THAN_OR_EQUAL_TO9216_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_greaterThanOrEqualTo9216DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_INTERVALS = "adaptor_EthPortBySizeLargeStats_intervals"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN2048 = "adaptor_EthPortBySizeLargeStats_lessThan2048"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN2048_DELTA = "adaptor_EthPortBySizeLargeStats_lessThan2048Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN2048_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_lessThan2048DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN2048_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_lessThan2048DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN2048_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_lessThan2048DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN4096 = "adaptor_EthPortBySizeLargeStats_lessThan4096"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN4096_DELTA = "adaptor_EthPortBySizeLargeStats_lessThan4096Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN4096_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_lessThan4096DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN4096_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_lessThan4096DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN4096_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_lessThan4096DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN8192 = "adaptor_EthPortBySizeLargeStats_lessThan8192"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN8192_DELTA = "adaptor_EthPortBySizeLargeStats_lessThan8192Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN8192_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_lessThan8192DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN8192_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_lessThan8192DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN8192_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_lessThan8192DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN9216 = "adaptor_EthPortBySizeLargeStats_lessThan9216"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN9216_DELTA = "adaptor_EthPortBySizeLargeStats_lessThan9216Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN9216_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_lessThan9216DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN9216_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_lessThan9216DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN9216_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_lessThan9216DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN_OR_EQUAL_TO1518 = "adaptor_EthPortBySizeLargeStats_lessThanOrEqualTo1518"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN_OR_EQUAL_TO1518_DELTA = "adaptor_EthPortBySizeLargeStats_lessThanOrEqualTo1518Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN_OR_EQUAL_TO1518_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_lessThanOrEqualTo1518DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN_OR_EQUAL_TO1518_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_lessThanOrEqualTo1518DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_LESS_THAN_OR_EQUAL_TO1518_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_lessThanOrEqualTo1518DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_NO_BREAKDOWN_GREATER_THAN1518 = "adaptor_EthPortBySizeLargeStats_noBreakdownGreaterThan1518"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_NO_BREAKDOWN_GREATER_THAN1518_DELTA = "adaptor_EthPortBySizeLargeStats_noBreakdownGreaterThan1518Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_NO_BREAKDOWN_GREATER_THAN1518_DELTA_AVG = "adaptor_EthPortBySizeLargeStats_noBreakdownGreaterThan1518DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_NO_BREAKDOWN_GREATER_THAN1518_DELTA_MAX = "adaptor_EthPortBySizeLargeStats_noBreakdownGreaterThan1518DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_NO_BREAKDOWN_GREATER_THAN1518_DELTA_MIN = "adaptor_EthPortBySizeLargeStats_noBreakdownGreaterThan1518DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_NORMALIZED_TIME_COL = "adaptor_EthPortBySizeLargeStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_STATS_REPORTED = "adaptor_EthPortBySizeLargeStats_statsReported"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_SUSPECT = "adaptor_EthPortBySizeLargeStats_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_THRESHOLDED = "adaptor_EthPortBySizeLargeStats_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_TIME_COLLECTED = "adaptor_EthPortBySizeLargeStats_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_TRAFFIC_DIRECTION = "adaptor_EthPortBySizeLargeStats_trafficDirection"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_LARGE_STATS_UPDATE = "adaptor_EthPortBySizeLargeStats_update"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_EQUALS64 = "adaptor_EthPortBySizeSmallStatsHist_equals64"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_EQUALS64_DELTA = "adaptor_EthPortBySizeSmallStatsHist_equals64Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_EQUALS64_DELTA_AVG = "adaptor_EthPortBySizeSmallStatsHist_equals64DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_EQUALS64_DELTA_MAX = "adaptor_EthPortBySizeSmallStatsHist_equals64DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_EQUALS64_DELTA_MIN = "adaptor_EthPortBySizeSmallStatsHist_equals64DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_ID = "adaptor_EthPortBySizeSmallStatsHist_id"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN1024 = "adaptor_EthPortBySizeSmallStatsHist_lessThan1024"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN1024_DELTA = "adaptor_EthPortBySizeSmallStatsHist_lessThan1024Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN1024_DELTA_AVG = "adaptor_EthPortBySizeSmallStatsHist_lessThan1024DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN1024_DELTA_MAX = "adaptor_EthPortBySizeSmallStatsHist_lessThan1024DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN1024_DELTA_MIN = "adaptor_EthPortBySizeSmallStatsHist_lessThan1024DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN128 = "adaptor_EthPortBySizeSmallStatsHist_lessThan128"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN128_DELTA = "adaptor_EthPortBySizeSmallStatsHist_lessThan128Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN128_DELTA_AVG = "adaptor_EthPortBySizeSmallStatsHist_lessThan128DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN128_DELTA_MAX = "adaptor_EthPortBySizeSmallStatsHist_lessThan128DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN128_DELTA_MIN = "adaptor_EthPortBySizeSmallStatsHist_lessThan128DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN256 = "adaptor_EthPortBySizeSmallStatsHist_lessThan256"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN256_DELTA = "adaptor_EthPortBySizeSmallStatsHist_lessThan256Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN256_DELTA_AVG = "adaptor_EthPortBySizeSmallStatsHist_lessThan256DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN256_DELTA_MAX = "adaptor_EthPortBySizeSmallStatsHist_lessThan256DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN256_DELTA_MIN = "adaptor_EthPortBySizeSmallStatsHist_lessThan256DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN512 = "adaptor_EthPortBySizeSmallStatsHist_lessThan512"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN512_DELTA = "adaptor_EthPortBySizeSmallStatsHist_lessThan512Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN512_DELTA_AVG = "adaptor_EthPortBySizeSmallStatsHist_lessThan512DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN512_DELTA_MAX = "adaptor_EthPortBySizeSmallStatsHist_lessThan512DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN512_DELTA_MIN = "adaptor_EthPortBySizeSmallStatsHist_lessThan512DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN64 = "adaptor_EthPortBySizeSmallStatsHist_lessThan64"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN64_DELTA = "adaptor_EthPortBySizeSmallStatsHist_lessThan64Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN64_DELTA_AVG = "adaptor_EthPortBySizeSmallStatsHist_lessThan64DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN64_DELTA_MAX = "adaptor_EthPortBySizeSmallStatsHist_lessThan64DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_LESS_THAN64_DELTA_MIN = "adaptor_EthPortBySizeSmallStatsHist_lessThan64DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_MOST_RECENT = "adaptor_EthPortBySizeSmallStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_SUSPECT = "adaptor_EthPortBySizeSmallStatsHist_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_THRESHOLDED = "adaptor_EthPortBySizeSmallStatsHist_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_HIST_TIME_COLLECTED = "adaptor_EthPortBySizeSmallStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_EQUALS64 = "adaptor_EthPortBySizeSmallStats_equals64"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_EQUALS64_DELTA = "adaptor_EthPortBySizeSmallStats_equals64Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_EQUALS64_DELTA_AVG = "adaptor_EthPortBySizeSmallStats_equals64DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_EQUALS64_DELTA_MAX = "adaptor_EthPortBySizeSmallStats_equals64DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_EQUALS64_DELTA_MIN = "adaptor_EthPortBySizeSmallStats_equals64DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_INTERVALS = "adaptor_EthPortBySizeSmallStats_intervals"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN1024 = "adaptor_EthPortBySizeSmallStats_lessThan1024"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN1024_DELTA = "adaptor_EthPortBySizeSmallStats_lessThan1024Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN1024_DELTA_AVG = "adaptor_EthPortBySizeSmallStats_lessThan1024DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN1024_DELTA_MAX = "adaptor_EthPortBySizeSmallStats_lessThan1024DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN1024_DELTA_MIN = "adaptor_EthPortBySizeSmallStats_lessThan1024DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN128 = "adaptor_EthPortBySizeSmallStats_lessThan128"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN128_DELTA = "adaptor_EthPortBySizeSmallStats_lessThan128Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN128_DELTA_AVG = "adaptor_EthPortBySizeSmallStats_lessThan128DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN128_DELTA_MAX = "adaptor_EthPortBySizeSmallStats_lessThan128DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN128_DELTA_MIN = "adaptor_EthPortBySizeSmallStats_lessThan128DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN256 = "adaptor_EthPortBySizeSmallStats_lessThan256"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN256_DELTA = "adaptor_EthPortBySizeSmallStats_lessThan256Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN256_DELTA_AVG = "adaptor_EthPortBySizeSmallStats_lessThan256DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN256_DELTA_MAX = "adaptor_EthPortBySizeSmallStats_lessThan256DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN256_DELTA_MIN = "adaptor_EthPortBySizeSmallStats_lessThan256DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN512 = "adaptor_EthPortBySizeSmallStats_lessThan512"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN512_DELTA = "adaptor_EthPortBySizeSmallStats_lessThan512Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN512_DELTA_AVG = "adaptor_EthPortBySizeSmallStats_lessThan512DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN512_DELTA_MAX = "adaptor_EthPortBySizeSmallStats_lessThan512DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN512_DELTA_MIN = "adaptor_EthPortBySizeSmallStats_lessThan512DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN64 = "adaptor_EthPortBySizeSmallStats_lessThan64"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN64_DELTA = "adaptor_EthPortBySizeSmallStats_lessThan64Delta"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN64_DELTA_AVG = "adaptor_EthPortBySizeSmallStats_lessThan64DeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN64_DELTA_MAX = "adaptor_EthPortBySizeSmallStats_lessThan64DeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_LESS_THAN64_DELTA_MIN = "adaptor_EthPortBySizeSmallStats_lessThan64DeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_NORMALIZED_TIME_COL = "adaptor_EthPortBySizeSmallStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_STATS_REPORTED = "adaptor_EthPortBySizeSmallStats_statsReported"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_SUSPECT = "adaptor_EthPortBySizeSmallStats_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_THRESHOLDED = "adaptor_EthPortBySizeSmallStats_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_TIME_COLLECTED = "adaptor_EthPortBySizeSmallStats_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_TRAFFIC_DIRECTION = "adaptor_EthPortBySizeSmallStats_trafficDirection"
    SORT_PROP_ADAPTOR_ETH_PORT_BY_SIZE_SMALL_STATS_UPDATE = "adaptor_EthPortBySizeSmallStats_update"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_CRC_PACKETS = "adaptor_EthPortErrStatsHist_badCrcPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_CRC_PACKETS_DELTA = "adaptor_EthPortErrStatsHist_badCrcPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortErrStatsHist_badCrcPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortErrStatsHist_badCrcPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortErrStatsHist_badCrcPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_LENGTH_PACKETS = "adaptor_EthPortErrStatsHist_badLengthPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_LENGTH_PACKETS_DELTA = "adaptor_EthPortErrStatsHist_badLengthPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_LENGTH_PACKETS_DELTA_AVG = "adaptor_EthPortErrStatsHist_badLengthPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_LENGTH_PACKETS_DELTA_MAX = "adaptor_EthPortErrStatsHist_badLengthPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_BAD_LENGTH_PACKETS_DELTA_MIN = "adaptor_EthPortErrStatsHist_badLengthPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_ID = "adaptor_EthPortErrStatsHist_id"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_MAC_DISCARDED_PACKETS = "adaptor_EthPortErrStatsHist_macDiscardedPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_MAC_DISCARDED_PACKETS_DELTA = "adaptor_EthPortErrStatsHist_macDiscardedPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_MAC_DISCARDED_PACKETS_DELTA_AVG = "adaptor_EthPortErrStatsHist_macDiscardedPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_MAC_DISCARDED_PACKETS_DELTA_MAX = "adaptor_EthPortErrStatsHist_macDiscardedPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_MAC_DISCARDED_PACKETS_DELTA_MIN = "adaptor_EthPortErrStatsHist_macDiscardedPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_MOST_RECENT = "adaptor_EthPortErrStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_SUSPECT = "adaptor_EthPortErrStatsHist_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_THRESHOLDED = "adaptor_EthPortErrStatsHist_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_HIST_TIME_COLLECTED = "adaptor_EthPortErrStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_BAD_CRC_PACKETS = "adaptor_EthPortErrStats_badCrcPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_BAD_CRC_PACKETS_DELTA = "adaptor_EthPortErrStats_badCrcPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_BAD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortErrStats_badCrcPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_BAD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortErrStats_badCrcPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_BAD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortErrStats_badCrcPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_BAD_LENGTH_PACKETS = "adaptor_EthPortErrStats_badLengthPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_BAD_LENGTH_PACKETS_DELTA = "adaptor_EthPortErrStats_badLengthPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_BAD_LENGTH_PACKETS_DELTA_AVG = "adaptor_EthPortErrStats_badLengthPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_BAD_LENGTH_PACKETS_DELTA_MAX = "adaptor_EthPortErrStats_badLengthPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_BAD_LENGTH_PACKETS_DELTA_MIN = "adaptor_EthPortErrStats_badLengthPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_INTERVALS = "adaptor_EthPortErrStats_intervals"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_MAC_DISCARDED_PACKETS = "adaptor_EthPortErrStats_macDiscardedPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_MAC_DISCARDED_PACKETS_DELTA = "adaptor_EthPortErrStats_macDiscardedPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_MAC_DISCARDED_PACKETS_DELTA_AVG = "adaptor_EthPortErrStats_macDiscardedPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_MAC_DISCARDED_PACKETS_DELTA_MAX = "adaptor_EthPortErrStats_macDiscardedPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_MAC_DISCARDED_PACKETS_DELTA_MIN = "adaptor_EthPortErrStats_macDiscardedPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_NORMALIZED_TIME_COL = "adaptor_EthPortErrStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_STATS_REPORTED = "adaptor_EthPortErrStats_statsReported"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_SUSPECT = "adaptor_EthPortErrStats_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_THRESHOLDED = "adaptor_EthPortErrStats_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_TIME_COLLECTED = "adaptor_EthPortErrStats_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_TRAFFIC_DIRECTION = "adaptor_EthPortErrStats_trafficDirection"
    SORT_PROP_ADAPTOR_ETH_PORT_ERR_STATS_UPDATE = "adaptor_EthPortErrStats_update"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_BROADCAST_PACKETS = "adaptor_EthPortMcastStatsHist_broadcastPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_BROADCAST_PACKETS_DELTA = "adaptor_EthPortMcastStatsHist_broadcastPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_BROADCAST_PACKETS_DELTA_AVG = "adaptor_EthPortMcastStatsHist_broadcastPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_BROADCAST_PACKETS_DELTA_MAX = "adaptor_EthPortMcastStatsHist_broadcastPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_BROADCAST_PACKETS_DELTA_MIN = "adaptor_EthPortMcastStatsHist_broadcastPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_ID = "adaptor_EthPortMcastStatsHist_id"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_MOST_RECENT = "adaptor_EthPortMcastStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_MULTICAST_PACKETS = "adaptor_EthPortMcastStatsHist_multicastPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_MULTICAST_PACKETS_DELTA = "adaptor_EthPortMcastStatsHist_multicastPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_MULTICAST_PACKETS_DELTA_AVG = "adaptor_EthPortMcastStatsHist_multicastPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_MULTICAST_PACKETS_DELTA_MAX = "adaptor_EthPortMcastStatsHist_multicastPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_MULTICAST_PACKETS_DELTA_MIN = "adaptor_EthPortMcastStatsHist_multicastPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_SUSPECT = "adaptor_EthPortMcastStatsHist_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_THRESHOLDED = "adaptor_EthPortMcastStatsHist_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_TIME_COLLECTED = "adaptor_EthPortMcastStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_UNICAST_PACKETS = "adaptor_EthPortMcastStatsHist_unicastPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_UNICAST_PACKETS_DELTA = "adaptor_EthPortMcastStatsHist_unicastPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_UNICAST_PACKETS_DELTA_AVG = "adaptor_EthPortMcastStatsHist_unicastPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_UNICAST_PACKETS_DELTA_MAX = "adaptor_EthPortMcastStatsHist_unicastPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_HIST_UNICAST_PACKETS_DELTA_MIN = "adaptor_EthPortMcastStatsHist_unicastPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_BROADCAST_PACKETS = "adaptor_EthPortMcastStats_broadcastPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_BROADCAST_PACKETS_DELTA = "adaptor_EthPortMcastStats_broadcastPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_BROADCAST_PACKETS_DELTA_AVG = "adaptor_EthPortMcastStats_broadcastPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_BROADCAST_PACKETS_DELTA_MAX = "adaptor_EthPortMcastStats_broadcastPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_BROADCAST_PACKETS_DELTA_MIN = "adaptor_EthPortMcastStats_broadcastPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_INTERVALS = "adaptor_EthPortMcastStats_intervals"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_MULTICAST_PACKETS = "adaptor_EthPortMcastStats_multicastPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_MULTICAST_PACKETS_DELTA = "adaptor_EthPortMcastStats_multicastPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_MULTICAST_PACKETS_DELTA_AVG = "adaptor_EthPortMcastStats_multicastPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_MULTICAST_PACKETS_DELTA_MAX = "adaptor_EthPortMcastStats_multicastPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_MULTICAST_PACKETS_DELTA_MIN = "adaptor_EthPortMcastStats_multicastPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_NORMALIZED_TIME_COL = "adaptor_EthPortMcastStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_STATS_REPORTED = "adaptor_EthPortMcastStats_statsReported"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_SUSPECT = "adaptor_EthPortMcastStats_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_THRESHOLDED = "adaptor_EthPortMcastStats_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_TIME_COLLECTED = "adaptor_EthPortMcastStats_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_TRAFFIC_DIRECTION = "adaptor_EthPortMcastStats_trafficDirection"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_UNICAST_PACKETS = "adaptor_EthPortMcastStats_unicastPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_UNICAST_PACKETS_DELTA = "adaptor_EthPortMcastStats_unicastPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_UNICAST_PACKETS_DELTA_AVG = "adaptor_EthPortMcastStats_unicastPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_UNICAST_PACKETS_DELTA_MAX = "adaptor_EthPortMcastStats_unicastPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_UNICAST_PACKETS_DELTA_MIN = "adaptor_EthPortMcastStats_unicastPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_MCAST_STATS_UPDATE = "adaptor_EthPortMcastStats_update"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_ID = "adaptor_EthPortOutsizedStatsHist_id"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_MOST_RECENT = "adaptor_EthPortOutsizedStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_BAD_CRC_PACKETS = "adaptor_EthPortOutsizedStatsHist_oversizedBadCrcPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_BAD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStatsHist_oversizedBadCrcPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_BAD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStatsHist_oversizedBadCrcPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_BAD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStatsHist_oversizedBadCrcPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_BAD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStatsHist_oversizedBadCrcPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_GOOD_CRC_PACKETS = "adaptor_EthPortOutsizedStatsHist_oversizedGoodCrcPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_GOOD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStatsHist_oversizedGoodCrcPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_GOOD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStatsHist_oversizedGoodCrcPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_GOOD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStatsHist_oversizedGoodCrcPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_GOOD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStatsHist_oversizedGoodCrcPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_PACKETS = "adaptor_EthPortOutsizedStatsHist_oversizedPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_PACKETS_DELTA = "adaptor_EthPortOutsizedStatsHist_oversizedPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStatsHist_oversizedPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStatsHist_oversizedPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_OVERSIZED_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStatsHist_oversizedPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_SUSPECT = "adaptor_EthPortOutsizedStatsHist_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_THRESHOLDED = "adaptor_EthPortOutsizedStatsHist_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_TIME_COLLECTED = "adaptor_EthPortOutsizedStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_BAD_CRC_PACKETS = "adaptor_EthPortOutsizedStatsHist_undersizedBadCrcPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_BAD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStatsHist_undersizedBadCrcPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_BAD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStatsHist_undersizedBadCrcPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_BAD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStatsHist_undersizedBadCrcPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_BAD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStatsHist_undersizedBadCrcPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_GOOD_CRC_PACKETS = "adaptor_EthPortOutsizedStatsHist_undersizedGoodCrcPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_GOOD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStatsHist_undersizedGoodCrcPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_GOOD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStatsHist_undersizedGoodCrcPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_GOOD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStatsHist_undersizedGoodCrcPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_HIST_UNDERSIZED_GOOD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStatsHist_undersizedGoodCrcPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_INTERVALS = "adaptor_EthPortOutsizedStats_intervals"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_NORMALIZED_TIME_COL = "adaptor_EthPortOutsizedStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_BAD_CRC_PACKETS = "adaptor_EthPortOutsizedStats_oversizedBadCrcPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_BAD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStats_oversizedBadCrcPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_BAD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStats_oversizedBadCrcPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_BAD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStats_oversizedBadCrcPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_BAD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStats_oversizedBadCrcPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_GOOD_CRC_PACKETS = "adaptor_EthPortOutsizedStats_oversizedGoodCrcPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_GOOD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStats_oversizedGoodCrcPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_GOOD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStats_oversizedGoodCrcPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_GOOD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStats_oversizedGoodCrcPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_GOOD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStats_oversizedGoodCrcPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_PACKETS = "adaptor_EthPortOutsizedStats_oversizedPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_PACKETS_DELTA = "adaptor_EthPortOutsizedStats_oversizedPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStats_oversizedPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStats_oversizedPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_OVERSIZED_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStats_oversizedPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_STATS_REPORTED = "adaptor_EthPortOutsizedStats_statsReported"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_SUSPECT = "adaptor_EthPortOutsizedStats_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_THRESHOLDED = "adaptor_EthPortOutsizedStats_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_TIME_COLLECTED = "adaptor_EthPortOutsizedStats_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_TRAFFIC_DIRECTION = "adaptor_EthPortOutsizedStats_trafficDirection"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_BAD_CRC_PACKETS = "adaptor_EthPortOutsizedStats_undersizedBadCrcPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_BAD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStats_undersizedBadCrcPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_BAD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStats_undersizedBadCrcPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_BAD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStats_undersizedBadCrcPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_BAD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStats_undersizedBadCrcPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_GOOD_CRC_PACKETS = "adaptor_EthPortOutsizedStats_undersizedGoodCrcPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_GOOD_CRC_PACKETS_DELTA = "adaptor_EthPortOutsizedStats_undersizedGoodCrcPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_GOOD_CRC_PACKETS_DELTA_AVG = "adaptor_EthPortOutsizedStats_undersizedGoodCrcPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_GOOD_CRC_PACKETS_DELTA_MAX = "adaptor_EthPortOutsizedStats_undersizedGoodCrcPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UNDERSIZED_GOOD_CRC_PACKETS_DELTA_MIN = "adaptor_EthPortOutsizedStats_undersizedGoodCrcPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_OUTSIZED_STATS_UPDATE = "adaptor_EthPortOutsizedStats_update"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_GOOD_PACKETS = "adaptor_EthPortStatsHist_goodPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_GOOD_PACKETS_DELTA = "adaptor_EthPortStatsHist_goodPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_GOOD_PACKETS_DELTA_AVG = "adaptor_EthPortStatsHist_goodPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_GOOD_PACKETS_DELTA_MAX = "adaptor_EthPortStatsHist_goodPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_GOOD_PACKETS_DELTA_MIN = "adaptor_EthPortStatsHist_goodPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_ID = "adaptor_EthPortStatsHist_id"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_MOST_RECENT = "adaptor_EthPortStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PAUSE_PACKETS = "adaptor_EthPortStatsHist_pausePackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PAUSE_PACKETS_DELTA = "adaptor_EthPortStatsHist_pausePacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PAUSE_PACKETS_DELTA_AVG = "adaptor_EthPortStatsHist_pausePacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PAUSE_PACKETS_DELTA_MAX = "adaptor_EthPortStatsHist_pausePacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PAUSE_PACKETS_DELTA_MIN = "adaptor_EthPortStatsHist_pausePacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PER_PRIORITY_PAUSE_PACKETS = "adaptor_EthPortStatsHist_perPriorityPausePackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PER_PRIORITY_PAUSE_PACKETS_DELTA = "adaptor_EthPortStatsHist_perPriorityPausePacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PER_PRIORITY_PAUSE_PACKETS_DELTA_AVG = "adaptor_EthPortStatsHist_perPriorityPausePacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PER_PRIORITY_PAUSE_PACKETS_DELTA_MAX = "adaptor_EthPortStatsHist_perPriorityPausePacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PER_PRIORITY_PAUSE_PACKETS_DELTA_MIN = "adaptor_EthPortStatsHist_perPriorityPausePacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PPP_PACKETS = "adaptor_EthPortStatsHist_pppPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PPP_PACKETS_DELTA = "adaptor_EthPortStatsHist_pppPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PPP_PACKETS_DELTA_AVG = "adaptor_EthPortStatsHist_pppPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PPP_PACKETS_DELTA_MAX = "adaptor_EthPortStatsHist_pppPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_PPP_PACKETS_DELTA_MIN = "adaptor_EthPortStatsHist_pppPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_SUSPECT = "adaptor_EthPortStatsHist_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_THRESHOLDED = "adaptor_EthPortStatsHist_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_TIME_COLLECTED = "adaptor_EthPortStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_TOTAL_PACKETS = "adaptor_EthPortStatsHist_totalPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_TOTAL_PACKETS_DELTA = "adaptor_EthPortStatsHist_totalPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_TOTAL_PACKETS_DELTA_AVG = "adaptor_EthPortStatsHist_totalPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_TOTAL_PACKETS_DELTA_MAX = "adaptor_EthPortStatsHist_totalPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_TOTAL_PACKETS_DELTA_MIN = "adaptor_EthPortStatsHist_totalPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_VLAN_PACKETS = "adaptor_EthPortStatsHist_vlanPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_VLAN_PACKETS_DELTA = "adaptor_EthPortStatsHist_vlanPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_VLAN_PACKETS_DELTA_AVG = "adaptor_EthPortStatsHist_vlanPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_VLAN_PACKETS_DELTA_MAX = "adaptor_EthPortStatsHist_vlanPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_HIST_VLAN_PACKETS_DELTA_MIN = "adaptor_EthPortStatsHist_vlanPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_GOOD_PACKETS = "adaptor_EthPortStats_goodPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_GOOD_PACKETS_DELTA = "adaptor_EthPortStats_goodPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_GOOD_PACKETS_DELTA_AVG = "adaptor_EthPortStats_goodPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_GOOD_PACKETS_DELTA_MAX = "adaptor_EthPortStats_goodPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_GOOD_PACKETS_DELTA_MIN = "adaptor_EthPortStats_goodPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_INTERVALS = "adaptor_EthPortStats_intervals"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_NORMALIZED_TIME_COL = "adaptor_EthPortStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PAUSE_PACKETS = "adaptor_EthPortStats_pausePackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PAUSE_PACKETS_DELTA = "adaptor_EthPortStats_pausePacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PAUSE_PACKETS_DELTA_AVG = "adaptor_EthPortStats_pausePacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PAUSE_PACKETS_DELTA_MAX = "adaptor_EthPortStats_pausePacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PAUSE_PACKETS_DELTA_MIN = "adaptor_EthPortStats_pausePacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PER_PRIORITY_PAUSE_PACKETS = "adaptor_EthPortStats_perPriorityPausePackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PER_PRIORITY_PAUSE_PACKETS_DELTA = "adaptor_EthPortStats_perPriorityPausePacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PER_PRIORITY_PAUSE_PACKETS_DELTA_AVG = "adaptor_EthPortStats_perPriorityPausePacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PER_PRIORITY_PAUSE_PACKETS_DELTA_MAX = "adaptor_EthPortStats_perPriorityPausePacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PER_PRIORITY_PAUSE_PACKETS_DELTA_MIN = "adaptor_EthPortStats_perPriorityPausePacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PPP_PACKETS = "adaptor_EthPortStats_pppPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PPP_PACKETS_DELTA = "adaptor_EthPortStats_pppPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PPP_PACKETS_DELTA_AVG = "adaptor_EthPortStats_pppPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PPP_PACKETS_DELTA_MAX = "adaptor_EthPortStats_pppPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_PPP_PACKETS_DELTA_MIN = "adaptor_EthPortStats_pppPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_STATS_REPORTED = "adaptor_EthPortStats_statsReported"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_SUSPECT = "adaptor_EthPortStats_suspect"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_THRESHOLDED = "adaptor_EthPortStats_thresholded"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_TIME_COLLECTED = "adaptor_EthPortStats_timeCollected"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_TOTAL_PACKETS = "adaptor_EthPortStats_totalPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_TOTAL_PACKETS_DELTA = "adaptor_EthPortStats_totalPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_TOTAL_PACKETS_DELTA_AVG = "adaptor_EthPortStats_totalPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_TOTAL_PACKETS_DELTA_MAX = "adaptor_EthPortStats_totalPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_TOTAL_PACKETS_DELTA_MIN = "adaptor_EthPortStats_totalPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_TRAFFIC_DIRECTION = "adaptor_EthPortStats_trafficDirection"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_UPDATE = "adaptor_EthPortStats_update"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_VLAN_PACKETS = "adaptor_EthPortStats_vlanPackets"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_VLAN_PACKETS_DELTA = "adaptor_EthPortStats_vlanPacketsDelta"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_VLAN_PACKETS_DELTA_AVG = "adaptor_EthPortStats_vlanPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_VLAN_PACKETS_DELTA_MAX = "adaptor_EthPortStats_vlanPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETH_PORT_STATS_VLAN_PACKETS_DELTA_MIN = "adaptor_EthPortStats_vlanPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETH_QUEUE_PROFILE_COUNT = "adaptor_EthQueueProfile_count"
    SORT_PROP_ADAPTOR_ETH_QUEUE_PROFILE_RING_SIZE = "adaptor_EthQueueProfile_ringSize"
    SORT_PROP_ADAPTOR_ETH_RECV_QUEUE_PROFILE_COUNT = "adaptor_EthRecvQueueProfile_count"
    SORT_PROP_ADAPTOR_ETH_RECV_QUEUE_PROFILE_RING_SIZE = "adaptor_EthRecvQueueProfile_ringSize"
    SORT_PROP_ADAPTOR_ETH_RO_CEPROFILE_ADMIN_STATE = "adaptor_EthRoCEProfile_adminState"
    SORT_PROP_ADAPTOR_ETH_RO_CEPROFILE_COS = "adaptor_EthRoCEProfile_cos"
    SORT_PROP_ADAPTOR_ETH_RO_CEPROFILE_MEMORY_REGIONS = "adaptor_EthRoCEProfile_memoryRegions"
    SORT_PROP_ADAPTOR_ETH_RO_CEPROFILE_PRIO = "adaptor_EthRoCEProfile_prio"
    SORT_PROP_ADAPTOR_ETH_RO_CEPROFILE_QUEUE_PAIRS = "adaptor_EthRoCEProfile_queuePairs"
    SORT_PROP_ADAPTOR_ETH_RO_CEPROFILE_RESOURCE_GROUPS = "adaptor_EthRoCEProfile_resourceGroups"
    SORT_PROP_ADAPTOR_ETH_RO_CEPROFILE_V1 = "adaptor_EthRoCEProfile_v1"
    SORT_PROP_ADAPTOR_ETH_RO_CEPROFILE_V2 = "adaptor_EthRoCEProfile_v2"
    SORT_PROP_ADAPTOR_ETH_VX_LANPROFILE_ADMIN_STATE = "adaptor_EthVxLANProfile_adminState"
    SORT_PROP_ADAPTOR_ETH_WORK_QUEUE_PROFILE_COUNT = "adaptor_EthWorkQueueProfile_count"
    SORT_PROP_ADAPTOR_ETH_WORK_QUEUE_PROFILE_RING_SIZE = "adaptor_EthWorkQueueProfile_ringSize"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_ID = "adaptor_EtherIfStatsHist_id"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_MOST_RECENT = "adaptor_EtherIfStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_BYTES = "adaptor_EtherIfStatsHist_rxBytes"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_BYTES_DELTA = "adaptor_EtherIfStatsHist_rxBytesDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_BYTES_DELTA_AVG = "adaptor_EtherIfStatsHist_rxBytesDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_BYTES_DELTA_MAX = "adaptor_EtherIfStatsHist_rxBytesDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_BYTES_DELTA_MIN = "adaptor_EtherIfStatsHist_rxBytesDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_DROPPED = "adaptor_EtherIfStatsHist_rxDropped"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_DROPPED_DELTA = "adaptor_EtherIfStatsHist_rxDroppedDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_DROPPED_DELTA_AVG = "adaptor_EtherIfStatsHist_rxDroppedDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_DROPPED_DELTA_MAX = "adaptor_EtherIfStatsHist_rxDroppedDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_DROPPED_DELTA_MIN = "adaptor_EtherIfStatsHist_rxDroppedDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_ERRORS = "adaptor_EtherIfStatsHist_rxErrors"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_ERRORS_DELTA = "adaptor_EtherIfStatsHist_rxErrorsDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_ERRORS_DELTA_AVG = "adaptor_EtherIfStatsHist_rxErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_ERRORS_DELTA_MAX = "adaptor_EtherIfStatsHist_rxErrorsDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_ERRORS_DELTA_MIN = "adaptor_EtherIfStatsHist_rxErrorsDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_PACKETS = "adaptor_EtherIfStatsHist_rxPackets"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_PACKETS_DELTA = "adaptor_EtherIfStatsHist_rxPacketsDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_PACKETS_DELTA_AVG = "adaptor_EtherIfStatsHist_rxPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_PACKETS_DELTA_MAX = "adaptor_EtherIfStatsHist_rxPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_RX_PACKETS_DELTA_MIN = "adaptor_EtherIfStatsHist_rxPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_SUSPECT = "adaptor_EtherIfStatsHist_suspect"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_THRESHOLDED = "adaptor_EtherIfStatsHist_thresholded"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TIME_COLLECTED = "adaptor_EtherIfStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_BYTES = "adaptor_EtherIfStatsHist_txBytes"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_BYTES_DELTA = "adaptor_EtherIfStatsHist_txBytesDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_BYTES_DELTA_AVG = "adaptor_EtherIfStatsHist_txBytesDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_BYTES_DELTA_MAX = "adaptor_EtherIfStatsHist_txBytesDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_BYTES_DELTA_MIN = "adaptor_EtherIfStatsHist_txBytesDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_DROPPED = "adaptor_EtherIfStatsHist_txDropped"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_DROPPED_DELTA = "adaptor_EtherIfStatsHist_txDroppedDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_DROPPED_DELTA_AVG = "adaptor_EtherIfStatsHist_txDroppedDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_DROPPED_DELTA_MAX = "adaptor_EtherIfStatsHist_txDroppedDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_DROPPED_DELTA_MIN = "adaptor_EtherIfStatsHist_txDroppedDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_ERRORS = "adaptor_EtherIfStatsHist_txErrors"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_ERRORS_DELTA = "adaptor_EtherIfStatsHist_txErrorsDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_ERRORS_DELTA_AVG = "adaptor_EtherIfStatsHist_txErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_ERRORS_DELTA_MAX = "adaptor_EtherIfStatsHist_txErrorsDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_ERRORS_DELTA_MIN = "adaptor_EtherIfStatsHist_txErrorsDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_PACKETS = "adaptor_EtherIfStatsHist_txPackets"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_PACKETS_DELTA = "adaptor_EtherIfStatsHist_txPacketsDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_PACKETS_DELTA_AVG = "adaptor_EtherIfStatsHist_txPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_PACKETS_DELTA_MAX = "adaptor_EtherIfStatsHist_txPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_HIST_TX_PACKETS_DELTA_MIN = "adaptor_EtherIfStatsHist_txPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_INTERVALS = "adaptor_EtherIfStats_intervals"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_NORMALIZED_TIME_COL = "adaptor_EtherIfStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_BYTES = "adaptor_EtherIfStats_rxBytes"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_BYTES_DELTA = "adaptor_EtherIfStats_rxBytesDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_BYTES_DELTA_AVG = "adaptor_EtherIfStats_rxBytesDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_BYTES_DELTA_MAX = "adaptor_EtherIfStats_rxBytesDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_BYTES_DELTA_MIN = "adaptor_EtherIfStats_rxBytesDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_DROPPED = "adaptor_EtherIfStats_rxDropped"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_DROPPED_DELTA = "adaptor_EtherIfStats_rxDroppedDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_DROPPED_DELTA_AVG = "adaptor_EtherIfStats_rxDroppedDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_DROPPED_DELTA_MAX = "adaptor_EtherIfStats_rxDroppedDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_DROPPED_DELTA_MIN = "adaptor_EtherIfStats_rxDroppedDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_ERRORS = "adaptor_EtherIfStats_rxErrors"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_ERRORS_DELTA = "adaptor_EtherIfStats_rxErrorsDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_ERRORS_DELTA_AVG = "adaptor_EtherIfStats_rxErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_ERRORS_DELTA_MAX = "adaptor_EtherIfStats_rxErrorsDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_ERRORS_DELTA_MIN = "adaptor_EtherIfStats_rxErrorsDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_PACKETS = "adaptor_EtherIfStats_rxPackets"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_PACKETS_DELTA = "adaptor_EtherIfStats_rxPacketsDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_PACKETS_DELTA_AVG = "adaptor_EtherIfStats_rxPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_PACKETS_DELTA_MAX = "adaptor_EtherIfStats_rxPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_RX_PACKETS_DELTA_MIN = "adaptor_EtherIfStats_rxPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_STATS_REPORTED = "adaptor_EtherIfStats_statsReported"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_SUSPECT = "adaptor_EtherIfStats_suspect"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_THRESHOLDED = "adaptor_EtherIfStats_thresholded"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TIME_COLLECTED = "adaptor_EtherIfStats_timeCollected"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_BYTES = "adaptor_EtherIfStats_txBytes"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_BYTES_DELTA = "adaptor_EtherIfStats_txBytesDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_BYTES_DELTA_AVG = "adaptor_EtherIfStats_txBytesDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_BYTES_DELTA_MAX = "adaptor_EtherIfStats_txBytesDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_BYTES_DELTA_MIN = "adaptor_EtherIfStats_txBytesDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_DROPPED = "adaptor_EtherIfStats_txDropped"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_DROPPED_DELTA = "adaptor_EtherIfStats_txDroppedDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_DROPPED_DELTA_AVG = "adaptor_EtherIfStats_txDroppedDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_DROPPED_DELTA_MAX = "adaptor_EtherIfStats_txDroppedDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_DROPPED_DELTA_MIN = "adaptor_EtherIfStats_txDroppedDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_ERRORS = "adaptor_EtherIfStats_txErrors"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_ERRORS_DELTA = "adaptor_EtherIfStats_txErrorsDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_ERRORS_DELTA_AVG = "adaptor_EtherIfStats_txErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_ERRORS_DELTA_MAX = "adaptor_EtherIfStats_txErrorsDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_ERRORS_DELTA_MIN = "adaptor_EtherIfStats_txErrorsDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_PACKETS = "adaptor_EtherIfStats_txPackets"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_PACKETS_DELTA = "adaptor_EtherIfStats_txPacketsDelta"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_PACKETS_DELTA_AVG = "adaptor_EtherIfStats_txPacketsDeltaAvg"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_PACKETS_DELTA_MAX = "adaptor_EtherIfStats_txPacketsDeltaMax"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_TX_PACKETS_DELTA_MIN = "adaptor_EtherIfStats_txPacketsDeltaMin"
    SORT_PROP_ADAPTOR_ETHER_IF_STATS_UPDATE = "adaptor_EtherIfStats_update"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_OPERATION_ADMIN_STATE = "adaptor_ExtEthIfOperation_adminState"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_OPERATION_LAST_MODIFIED = "adaptor_ExtEthIfOperation_lastModified"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_OPERATION_REMOTE_ERROR_CODE = "adaptor_ExtEthIfOperation_remoteErrorCode"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_OPERATION_REMOTE_ERROR_DESCR = "adaptor_ExtEthIfOperation_remoteErrorDescr"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_OPERATION_TRIGGER_STATUS = "adaptor_ExtEthIfOperation_triggerStatus"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_ADAPTER_ID = "adaptor_ExtEthIf_adapterId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_ADMIN_STATE = "adaptor_ExtEthIf_adminState"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_AGGR_PORT_ID = "adaptor_ExtEthIf_aggrPortId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_CHASSIS_ID = "adaptor_ExtEthIf_chassisId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_DISCOVERY = "adaptor_ExtEthIf_discovery"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_EP_DN = "adaptor_ExtEthIf_epDn"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_ID = "adaptor_ExtEthIf_id"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_IF_ROLE = "adaptor_ExtEthIf_ifRole"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_IF_TYPE = "adaptor_ExtEthIf_ifType"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_LINK_STATE = "adaptor_ExtEthIf_linkState"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_LLDP_MAC = "adaptor_ExtEthIf_lldpMac"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_LOCALE = "adaptor_ExtEthIf_locale"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_MAC = "adaptor_ExtEthIf_mac"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_MAC_ADDR_TYPE = "adaptor_ExtEthIf_macAddrType"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_NAME = "adaptor_ExtEthIf_name"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_OPER_STATE = "adaptor_ExtEthIf_operState"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_OPER_STATE_DESC = "adaptor_ExtEthIf_operStateDesc"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PEER_AGGR_PORT_ID = "adaptor_ExtEthIf_peerAggrPortId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PEER_CHASSIS_ID = "adaptor_ExtEthIf_peerChassisId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PEER_DN = "adaptor_ExtEthIf_peerDn"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PEER_PORT_ID = "adaptor_ExtEthIf_peerPortId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PEER_SLOT_ID = "adaptor_ExtEthIf_peerSlotId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PHYS_EP_DN = "adaptor_ExtEthIf_physEpDn"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PORT_ID = "adaptor_ExtEthIf_portId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_PURPOSE = "adaptor_ExtEthIf_purpose"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_SIDE = "adaptor_ExtEthIf_side"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_SLOT_ID = "adaptor_ExtEthIf_slotId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_SWITCH_ID = "adaptor_ExtEthIf_switchId"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_TRANSPORT = "adaptor_ExtEthIf_transport"
    SORT_PROP_ADAPTOR_EXT_ETH_IF_TYPE = "adaptor_ExtEthIf_type"
    SORT_PROP_ADAPTOR_EXT_IF_ADAPTER_ID = "adaptor_ExtIf_adapterId"
    SORT_PROP_ADAPTOR_EXT_IF_ADMIN_STATE = "adaptor_ExtIf_adminState"
    SORT_PROP_ADAPTOR_EXT_IF_AGGR_PORT_ID = "adaptor_ExtIf_aggrPortId"
    SORT_PROP_ADAPTOR_EXT_IF_CHASSIS_ID = "adaptor_ExtIf_chassisId"
    SORT_PROP_ADAPTOR_EXT_IF_DISCOVERY = "adaptor_ExtIf_discovery"
    SORT_PROP_ADAPTOR_EXT_IF_EP_DN = "adaptor_ExtIf_epDn"
    SORT_PROP_ADAPTOR_EXT_IF_ID = "adaptor_ExtIf_id"
    SORT_PROP_ADAPTOR_EXT_IF_IF_ROLE = "adaptor_ExtIf_ifRole"
    SORT_PROP_ADAPTOR_EXT_IF_IF_TYPE = "adaptor_ExtIf_ifType"
    SORT_PROP_ADAPTOR_EXT_IF_LINK_STATE = "adaptor_ExtIf_linkState"
    SORT_PROP_ADAPTOR_EXT_IF_LLDP_MAC = "adaptor_ExtIf_lldpMac"
    SORT_PROP_ADAPTOR_EXT_IF_LOCALE = "adaptor_ExtIf_locale"
    SORT_PROP_ADAPTOR_EXT_IF_MAC = "adaptor_ExtIf_mac"
    SORT_PROP_ADAPTOR_EXT_IF_NAME = "adaptor_ExtIf_name"
    SORT_PROP_ADAPTOR_EXT_IF_OPER_STATE = "adaptor_ExtIf_operState"
    SORT_PROP_ADAPTOR_EXT_IF_OPER_STATE_DESC = "adaptor_ExtIf_operStateDesc"
    SORT_PROP_ADAPTOR_EXT_IF_PEER_AGGR_PORT_ID = "adaptor_ExtIf_peerAggrPortId"
    SORT_PROP_ADAPTOR_EXT_IF_PEER_CHASSIS_ID = "adaptor_ExtIf_peerChassisId"
    SORT_PROP_ADAPTOR_EXT_IF_PEER_DN = "adaptor_ExtIf_peerDn"
    SORT_PROP_ADAPTOR_EXT_IF_PEER_PORT_ID = "adaptor_ExtIf_peerPortId"
    SORT_PROP_ADAPTOR_EXT_IF_PEER_SLOT_ID = "adaptor_ExtIf_peerSlotId"
    SORT_PROP_ADAPTOR_EXT_IF_PHYS_EP_DN = "adaptor_ExtIf_physEpDn"
    SORT_PROP_ADAPTOR_EXT_IF_PORT_ID = "adaptor_ExtIf_portId"
    SORT_PROP_ADAPTOR_EXT_IF_PURPOSE = "adaptor_ExtIf_purpose"
    SORT_PROP_ADAPTOR_EXT_IF_SIDE = "adaptor_ExtIf_side"
    SORT_PROP_ADAPTOR_EXT_IF_SLOT_ID = "adaptor_ExtIf_slotId"
    SORT_PROP_ADAPTOR_EXT_IF_SWITCH_ID = "adaptor_ExtIf_switchId"
    SORT_PROP_ADAPTOR_EXT_IF_TRANSPORT = "adaptor_ExtIf_transport"
    SORT_PROP_ADAPTOR_EXT_IF_TYPE = "adaptor_ExtIf_type"
    SORT_PROP_ADAPTOR_EXT_IP_V6_RSS_HASH_PROFILE_IP_HASH = "adaptor_ExtIpV6RssHashProfile_ipHash"
    SORT_PROP_ADAPTOR_EXT_IP_V6_RSS_HASH_PROFILE_TCP_HASH = "adaptor_ExtIpV6RssHashProfile_tcpHash"
    SORT_PROP_ADAPTOR_FC_CDB_WORK_QUEUE_PROFILE_COUNT = "adaptor_FcCdbWorkQueueProfile_count"
    SORT_PROP_ADAPTOR_FC_CDB_WORK_QUEUE_PROFILE_RING_SIZE = "adaptor_FcCdbWorkQueueProfile_ringSize"
    SORT_PROP_ADAPTOR_FC_ERROR_RECOVERY_PROFILE_ERROR_DETECT_TIMEOUT = "adaptor_FcErrorRecoveryProfile_errorDetectTimeout"
    SORT_PROP_ADAPTOR_FC_ERROR_RECOVERY_PROFILE_FCP_ERROR_RECOVERY = "adaptor_FcErrorRecoveryProfile_fcpErrorRecovery"
    SORT_PROP_ADAPTOR_FC_ERROR_RECOVERY_PROFILE_LINK_DOWN_TIMEOUT = "adaptor_FcErrorRecoveryProfile_linkDownTimeout"
    SORT_PROP_ADAPTOR_FC_ERROR_RECOVERY_PROFILE_PORT_DOWN_IO_RETRY_COUNT = "adaptor_FcErrorRecoveryProfile_portDownIoRetryCount"
    SORT_PROP_ADAPTOR_FC_ERROR_RECOVERY_PROFILE_PORT_DOWN_TIMEOUT = "adaptor_FcErrorRecoveryProfile_portDownTimeout"
    SORT_PROP_ADAPTOR_FC_ERROR_RECOVERY_PROFILE_RESOURCE_ALLOCATION_TIMEOUT = "adaptor_FcErrorRecoveryProfile_resourceAllocationTimeout"
    SORT_PROP_ADAPTOR_FC_FNIC_PROFILE_IO_RETRY_TIMEOUT = "adaptor_FcFnicProfile_ioRetryTimeout"
    SORT_PROP_ADAPTOR_FC_FNIC_PROFILE_LUN_QUEUE_DEPTH = "adaptor_FcFnicProfile_lunQueueDepth"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_ID = "adaptor_FcIfEventStatsHist_id"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_INVALID_CRCCOUNT = "adaptor_FcIfEventStatsHist_invalidCRCCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_INVALID_CRCCOUNT_DELTA = "adaptor_FcIfEventStatsHist_invalidCRCCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_INVALID_CRCCOUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_invalidCRCCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_INVALID_CRCCOUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_invalidCRCCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_INVALID_CRCCOUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_invalidCRCCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LINK_FAILURE_COUNT = "adaptor_FcIfEventStatsHist_linkFailureCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LINK_FAILURE_COUNT_DELTA = "adaptor_FcIfEventStatsHist_linkFailureCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LINK_FAILURE_COUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_linkFailureCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LINK_FAILURE_COUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_linkFailureCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LINK_FAILURE_COUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_linkFailureCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LIP_COUNT = "adaptor_FcIfEventStatsHist_lipCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LIP_COUNT_DELTA = "adaptor_FcIfEventStatsHist_lipCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LIP_COUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_lipCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LIP_COUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_lipCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LIP_COUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_lipCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SIGNAL_COUNT = "adaptor_FcIfEventStatsHist_lossOfSignalCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SIGNAL_COUNT_DELTA = "adaptor_FcIfEventStatsHist_lossOfSignalCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SIGNAL_COUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_lossOfSignalCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SIGNAL_COUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_lossOfSignalCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SIGNAL_COUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_lossOfSignalCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SYNC_COUNT = "adaptor_FcIfEventStatsHist_lossOfSyncCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SYNC_COUNT_DELTA = "adaptor_FcIfEventStatsHist_lossOfSyncCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SYNC_COUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_lossOfSyncCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SYNC_COUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_lossOfSyncCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_LOSS_OF_SYNC_COUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_lossOfSyncCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_MOST_RECENT = "adaptor_FcIfEventStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_N_OSCOUNT = "adaptor_FcIfEventStatsHist_nOSCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_N_OSCOUNT_DELTA = "adaptor_FcIfEventStatsHist_nOSCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_N_OSCOUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_nOSCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_N_OSCOUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_nOSCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_N_OSCOUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_nOSCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SECONDS_SINCE_LAST_RESET = "adaptor_FcIfEventStatsHist_secondsSinceLastReset"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SECONDS_SINCE_LAST_RESET_DELTA = "adaptor_FcIfEventStatsHist_secondsSinceLastResetDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SECONDS_SINCE_LAST_RESET_DELTA_AVG = "adaptor_FcIfEventStatsHist_secondsSinceLastResetDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SECONDS_SINCE_LAST_RESET_DELTA_MAX = "adaptor_FcIfEventStatsHist_secondsSinceLastResetDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SECONDS_SINCE_LAST_RESET_DELTA_MIN = "adaptor_FcIfEventStatsHist_secondsSinceLastResetDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SEQ_PROTOCOL_ERR_COUNT = "adaptor_FcIfEventStatsHist_seqProtocolErrCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SEQ_PROTOCOL_ERR_COUNT_DELTA = "adaptor_FcIfEventStatsHist_seqProtocolErrCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SEQ_PROTOCOL_ERR_COUNT_DELTA_AVG = "adaptor_FcIfEventStatsHist_seqProtocolErrCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SEQ_PROTOCOL_ERR_COUNT_DELTA_MAX = "adaptor_FcIfEventStatsHist_seqProtocolErrCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SEQ_PROTOCOL_ERR_COUNT_DELTA_MIN = "adaptor_FcIfEventStatsHist_seqProtocolErrCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_SUSPECT = "adaptor_FcIfEventStatsHist_suspect"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_THRESHOLDED = "adaptor_FcIfEventStatsHist_thresholded"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_HIST_TIME_COLLECTED = "adaptor_FcIfEventStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_INTERVALS = "adaptor_FcIfEventStats_intervals"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_INVALID_CRCCOUNT = "adaptor_FcIfEventStats_invalidCRCCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_INVALID_CRCCOUNT_DELTA = "adaptor_FcIfEventStats_invalidCRCCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_INVALID_CRCCOUNT_DELTA_AVG = "adaptor_FcIfEventStats_invalidCRCCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_INVALID_CRCCOUNT_DELTA_MAX = "adaptor_FcIfEventStats_invalidCRCCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_INVALID_CRCCOUNT_DELTA_MIN = "adaptor_FcIfEventStats_invalidCRCCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LINK_FAILURE_COUNT = "adaptor_FcIfEventStats_linkFailureCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LINK_FAILURE_COUNT_DELTA = "adaptor_FcIfEventStats_linkFailureCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LINK_FAILURE_COUNT_DELTA_AVG = "adaptor_FcIfEventStats_linkFailureCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LINK_FAILURE_COUNT_DELTA_MAX = "adaptor_FcIfEventStats_linkFailureCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LINK_FAILURE_COUNT_DELTA_MIN = "adaptor_FcIfEventStats_linkFailureCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LIP_COUNT = "adaptor_FcIfEventStats_lipCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LIP_COUNT_DELTA = "adaptor_FcIfEventStats_lipCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LIP_COUNT_DELTA_AVG = "adaptor_FcIfEventStats_lipCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LIP_COUNT_DELTA_MAX = "adaptor_FcIfEventStats_lipCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LIP_COUNT_DELTA_MIN = "adaptor_FcIfEventStats_lipCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SIGNAL_COUNT = "adaptor_FcIfEventStats_lossOfSignalCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SIGNAL_COUNT_DELTA = "adaptor_FcIfEventStats_lossOfSignalCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SIGNAL_COUNT_DELTA_AVG = "adaptor_FcIfEventStats_lossOfSignalCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SIGNAL_COUNT_DELTA_MAX = "adaptor_FcIfEventStats_lossOfSignalCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SIGNAL_COUNT_DELTA_MIN = "adaptor_FcIfEventStats_lossOfSignalCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SYNC_COUNT = "adaptor_FcIfEventStats_lossOfSyncCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SYNC_COUNT_DELTA = "adaptor_FcIfEventStats_lossOfSyncCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SYNC_COUNT_DELTA_AVG = "adaptor_FcIfEventStats_lossOfSyncCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SYNC_COUNT_DELTA_MAX = "adaptor_FcIfEventStats_lossOfSyncCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_LOSS_OF_SYNC_COUNT_DELTA_MIN = "adaptor_FcIfEventStats_lossOfSyncCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_N_OSCOUNT = "adaptor_FcIfEventStats_nOSCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_N_OSCOUNT_DELTA = "adaptor_FcIfEventStats_nOSCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_N_OSCOUNT_DELTA_AVG = "adaptor_FcIfEventStats_nOSCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_N_OSCOUNT_DELTA_MAX = "adaptor_FcIfEventStats_nOSCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_N_OSCOUNT_DELTA_MIN = "adaptor_FcIfEventStats_nOSCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_NORMALIZED_TIME_COL = "adaptor_FcIfEventStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SECONDS_SINCE_LAST_RESET = "adaptor_FcIfEventStats_secondsSinceLastReset"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SECONDS_SINCE_LAST_RESET_DELTA = "adaptor_FcIfEventStats_secondsSinceLastResetDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SECONDS_SINCE_LAST_RESET_DELTA_AVG = "adaptor_FcIfEventStats_secondsSinceLastResetDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SECONDS_SINCE_LAST_RESET_DELTA_MAX = "adaptor_FcIfEventStats_secondsSinceLastResetDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SECONDS_SINCE_LAST_RESET_DELTA_MIN = "adaptor_FcIfEventStats_secondsSinceLastResetDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SEQ_PROTOCOL_ERR_COUNT = "adaptor_FcIfEventStats_seqProtocolErrCount"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SEQ_PROTOCOL_ERR_COUNT_DELTA = "adaptor_FcIfEventStats_seqProtocolErrCountDelta"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SEQ_PROTOCOL_ERR_COUNT_DELTA_AVG = "adaptor_FcIfEventStats_seqProtocolErrCountDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SEQ_PROTOCOL_ERR_COUNT_DELTA_MAX = "adaptor_FcIfEventStats_seqProtocolErrCountDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SEQ_PROTOCOL_ERR_COUNT_DELTA_MIN = "adaptor_FcIfEventStats_seqProtocolErrCountDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_STATS_REPORTED = "adaptor_FcIfEventStats_statsReported"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_SUSPECT = "adaptor_FcIfEventStats_suspect"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_THRESHOLDED = "adaptor_FcIfEventStats_thresholded"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_TIME_COLLECTED = "adaptor_FcIfEventStats_timeCollected"
    SORT_PROP_ADAPTOR_FC_IF_EVENT_STATS_UPDATE = "adaptor_FcIfEventStats_update"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_CONTROL_REQUESTS = "adaptor_FcIfFC4StatsHist_controlRequests"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_CONTROL_REQUESTS_DELTA = "adaptor_FcIfFC4StatsHist_controlRequestsDelta"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_CONTROL_REQUESTS_DELTA_AVG = "adaptor_FcIfFC4StatsHist_controlRequestsDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_CONTROL_REQUESTS_DELTA_MAX = "adaptor_FcIfFC4StatsHist_controlRequestsDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_CONTROL_REQUESTS_DELTA_MIN = "adaptor_FcIfFC4StatsHist_controlRequestsDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_ID = "adaptor_FcIfFC4StatsHist_id"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_MEGABYTES = "adaptor_FcIfFC4StatsHist_inputMegabytes"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_MEGABYTES_DELTA = "adaptor_FcIfFC4StatsHist_inputMegabytesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_MEGABYTES_DELTA_AVG = "adaptor_FcIfFC4StatsHist_inputMegabytesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_MEGABYTES_DELTA_MAX = "adaptor_FcIfFC4StatsHist_inputMegabytesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_MEGABYTES_DELTA_MIN = "adaptor_FcIfFC4StatsHist_inputMegabytesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_REQUESTS = "adaptor_FcIfFC4StatsHist_inputRequests"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_REQUESTS_DELTA = "adaptor_FcIfFC4StatsHist_inputRequestsDelta"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_REQUESTS_DELTA_AVG = "adaptor_FcIfFC4StatsHist_inputRequestsDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_REQUESTS_DELTA_MAX = "adaptor_FcIfFC4StatsHist_inputRequestsDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_INPUT_REQUESTS_DELTA_MIN = "adaptor_FcIfFC4StatsHist_inputRequestsDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_MOST_RECENT = "adaptor_FcIfFC4StatsHist_mostRecent"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_MEGABYTES = "adaptor_FcIfFC4StatsHist_outputMegabytes"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_MEGABYTES_DELTA = "adaptor_FcIfFC4StatsHist_outputMegabytesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_MEGABYTES_DELTA_AVG = "adaptor_FcIfFC4StatsHist_outputMegabytesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_MEGABYTES_DELTA_MAX = "adaptor_FcIfFC4StatsHist_outputMegabytesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_MEGABYTES_DELTA_MIN = "adaptor_FcIfFC4StatsHist_outputMegabytesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_REQUESTS = "adaptor_FcIfFC4StatsHist_outputRequests"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_REQUESTS_DELTA = "adaptor_FcIfFC4StatsHist_outputRequestsDelta"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_REQUESTS_DELTA_AVG = "adaptor_FcIfFC4StatsHist_outputRequestsDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_REQUESTS_DELTA_MAX = "adaptor_FcIfFC4StatsHist_outputRequestsDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_OUTPUT_REQUESTS_DELTA_MIN = "adaptor_FcIfFC4StatsHist_outputRequestsDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_SUSPECT = "adaptor_FcIfFC4StatsHist_suspect"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_THRESHOLDED = "adaptor_FcIfFC4StatsHist_thresholded"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_HIST_TIME_COLLECTED = "adaptor_FcIfFC4StatsHist_timeCollected"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_CONTROL_REQUESTS = "adaptor_FcIfFC4Stats_controlRequests"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_CONTROL_REQUESTS_DELTA = "adaptor_FcIfFC4Stats_controlRequestsDelta"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_CONTROL_REQUESTS_DELTA_AVG = "adaptor_FcIfFC4Stats_controlRequestsDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_CONTROL_REQUESTS_DELTA_MAX = "adaptor_FcIfFC4Stats_controlRequestsDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_CONTROL_REQUESTS_DELTA_MIN = "adaptor_FcIfFC4Stats_controlRequestsDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INPUT_MEGABYTES = "adaptor_FcIfFC4Stats_inputMegabytes"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INPUT_MEGABYTES_DELTA = "adaptor_FcIfFC4Stats_inputMegabytesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INPUT_MEGABYTES_DELTA_AVG = "adaptor_FcIfFC4Stats_inputMegabytesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INPUT_MEGABYTES_DELTA_MAX = "adaptor_FcIfFC4Stats_inputMegabytesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INPUT_MEGABYTES_DELTA_MIN = "adaptor_FcIfFC4Stats_inputMegabytesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INPUT_REQUESTS = "adaptor_FcIfFC4Stats_inputRequests"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INPUT_REQUESTS_DELTA = "adaptor_FcIfFC4Stats_inputRequestsDelta"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INPUT_REQUESTS_DELTA_AVG = "adaptor_FcIfFC4Stats_inputRequestsDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INPUT_REQUESTS_DELTA_MAX = "adaptor_FcIfFC4Stats_inputRequestsDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INPUT_REQUESTS_DELTA_MIN = "adaptor_FcIfFC4Stats_inputRequestsDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_INTERVALS = "adaptor_FcIfFC4Stats_intervals"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_NORMALIZED_TIME_COL = "adaptor_FcIfFC4Stats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_MEGABYTES = "adaptor_FcIfFC4Stats_outputMegabytes"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_MEGABYTES_DELTA = "adaptor_FcIfFC4Stats_outputMegabytesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_MEGABYTES_DELTA_AVG = "adaptor_FcIfFC4Stats_outputMegabytesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_MEGABYTES_DELTA_MAX = "adaptor_FcIfFC4Stats_outputMegabytesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_MEGABYTES_DELTA_MIN = "adaptor_FcIfFC4Stats_outputMegabytesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_REQUESTS = "adaptor_FcIfFC4Stats_outputRequests"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_REQUESTS_DELTA = "adaptor_FcIfFC4Stats_outputRequestsDelta"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_REQUESTS_DELTA_AVG = "adaptor_FcIfFC4Stats_outputRequestsDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_REQUESTS_DELTA_MAX = "adaptor_FcIfFC4Stats_outputRequestsDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_OUTPUT_REQUESTS_DELTA_MIN = "adaptor_FcIfFC4Stats_outputRequestsDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_STATS_REPORTED = "adaptor_FcIfFC4Stats_statsReported"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_SUSPECT = "adaptor_FcIfFC4Stats_suspect"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_THRESHOLDED = "adaptor_FcIfFC4Stats_thresholded"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_TIME_COLLECTED = "adaptor_FcIfFC4Stats_timeCollected"
    SORT_PROP_ADAPTOR_FC_IF_FC4_STATS_UPDATE = "adaptor_FcIfFC4Stats_update"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_DUMPED_FRAMES = "adaptor_FcIfFrameStatsHist_dumpedFrames"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_DUMPED_FRAMES_DELTA = "adaptor_FcIfFrameStatsHist_dumpedFramesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_DUMPED_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStatsHist_dumpedFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_DUMPED_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStatsHist_dumpedFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_DUMPED_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStatsHist_dumpedFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_ERROR_FRAMES = "adaptor_FcIfFrameStatsHist_errorFrames"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_ERROR_FRAMES_DELTA = "adaptor_FcIfFrameStatsHist_errorFramesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_ERROR_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStatsHist_errorFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_ERROR_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStatsHist_errorFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_ERROR_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStatsHist_errorFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_ID = "adaptor_FcIfFrameStatsHist_id"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_MOST_RECENT = "adaptor_FcIfFrameStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_RX_FRAMES = "adaptor_FcIfFrameStatsHist_rxFrames"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_RX_FRAMES_DELTA = "adaptor_FcIfFrameStatsHist_rxFramesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_RX_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStatsHist_rxFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_RX_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStatsHist_rxFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_RX_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStatsHist_rxFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_SUSPECT = "adaptor_FcIfFrameStatsHist_suspect"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_THRESHOLDED = "adaptor_FcIfFrameStatsHist_thresholded"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_TIME_COLLECTED = "adaptor_FcIfFrameStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_TX_FRAMES = "adaptor_FcIfFrameStatsHist_txFrames"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_TX_FRAMES_DELTA = "adaptor_FcIfFrameStatsHist_txFramesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_TX_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStatsHist_txFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_TX_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStatsHist_txFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_HIST_TX_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStatsHist_txFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_DUMPED_FRAMES = "adaptor_FcIfFrameStats_dumpedFrames"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_DUMPED_FRAMES_DELTA = "adaptor_FcIfFrameStats_dumpedFramesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_DUMPED_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStats_dumpedFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_DUMPED_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStats_dumpedFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_DUMPED_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStats_dumpedFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_ERROR_FRAMES = "adaptor_FcIfFrameStats_errorFrames"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_ERROR_FRAMES_DELTA = "adaptor_FcIfFrameStats_errorFramesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_ERROR_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStats_errorFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_ERROR_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStats_errorFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_ERROR_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStats_errorFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_INTERVALS = "adaptor_FcIfFrameStats_intervals"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_NORMALIZED_TIME_COL = "adaptor_FcIfFrameStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_RX_FRAMES = "adaptor_FcIfFrameStats_rxFrames"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_RX_FRAMES_DELTA = "adaptor_FcIfFrameStats_rxFramesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_RX_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStats_rxFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_RX_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStats_rxFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_RX_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStats_rxFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_STATS_REPORTED = "adaptor_FcIfFrameStats_statsReported"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_SUSPECT = "adaptor_FcIfFrameStats_suspect"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_THRESHOLDED = "adaptor_FcIfFrameStats_thresholded"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_TIME_COLLECTED = "adaptor_FcIfFrameStats_timeCollected"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_TX_FRAMES = "adaptor_FcIfFrameStats_txFrames"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_TX_FRAMES_DELTA = "adaptor_FcIfFrameStats_txFramesDelta"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_TX_FRAMES_DELTA_AVG = "adaptor_FcIfFrameStats_txFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_TX_FRAMES_DELTA_MAX = "adaptor_FcIfFrameStats_txFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_TX_FRAMES_DELTA_MIN = "adaptor_FcIfFrameStats_txFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_IF_FRAME_STATS_UPDATE = "adaptor_FcIfFrameStats_update"
    SORT_PROP_ADAPTOR_FC_INTERRUPT_PROFILE_MODE = "adaptor_FcInterruptProfile_mode"
    SORT_PROP_ADAPTOR_FC_LOGI_PROFILE_RETRIES = "adaptor_FcLogiProfile_retries"
    SORT_PROP_ADAPTOR_FC_LOGI_PROFILE_TIMEOUT = "adaptor_FcLogiProfile_timeout"
    SORT_PROP_ADAPTOR_FC_PORT_FLOGI_PROFILE_RETRIES = "adaptor_FcPortFLogiProfile_retries"
    SORT_PROP_ADAPTOR_FC_PORT_FLOGI_PROFILE_TIMEOUT = "adaptor_FcPortFLogiProfile_timeout"
    SORT_PROP_ADAPTOR_FC_PORT_PLOGI_PROFILE_RETRIES = "adaptor_FcPortPLogiProfile_retries"
    SORT_PROP_ADAPTOR_FC_PORT_PLOGI_PROFILE_TIMEOUT = "adaptor_FcPortPLogiProfile_timeout"
    SORT_PROP_ADAPTOR_FC_PORT_PROFILE_IO_THROTTLE_COUNT = "adaptor_FcPortProfile_ioThrottleCount"
    SORT_PROP_ADAPTOR_FC_PORT_PROFILE_LUNS_PER_TARGET = "adaptor_FcPortProfile_lunsPerTarget"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_ID = "adaptor_FcPortStatsHist_id"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_MOST_RECENT = "adaptor_FcPortStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_RX_BAD_FRAMES = "adaptor_FcPortStatsHist_rxBadFrames"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_RX_BAD_FRAMES_DELTA = "adaptor_FcPortStatsHist_rxBadFramesDelta"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_RX_BAD_FRAMES_DELTA_AVG = "adaptor_FcPortStatsHist_rxBadFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_RX_BAD_FRAMES_DELTA_MAX = "adaptor_FcPortStatsHist_rxBadFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_RX_BAD_FRAMES_DELTA_MIN = "adaptor_FcPortStatsHist_rxBadFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_RX_FRAMES = "adaptor_FcPortStatsHist_rxFrames"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_RX_FRAMES_DELTA = "adaptor_FcPortStatsHist_rxFramesDelta"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_RX_FRAMES_DELTA_AVG = "adaptor_FcPortStatsHist_rxFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_RX_FRAMES_DELTA_MAX = "adaptor_FcPortStatsHist_rxFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_RX_FRAMES_DELTA_MIN = "adaptor_FcPortStatsHist_rxFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_SUSPECT = "adaptor_FcPortStatsHist_suspect"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_THRESHOLDED = "adaptor_FcPortStatsHist_thresholded"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TIME_COLLECTED = "adaptor_FcPortStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TX_BAD_FRAMES = "adaptor_FcPortStatsHist_txBadFrames"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TX_BAD_FRAMES_DELTA = "adaptor_FcPortStatsHist_txBadFramesDelta"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TX_BAD_FRAMES_DELTA_AVG = "adaptor_FcPortStatsHist_txBadFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TX_BAD_FRAMES_DELTA_MAX = "adaptor_FcPortStatsHist_txBadFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TX_BAD_FRAMES_DELTA_MIN = "adaptor_FcPortStatsHist_txBadFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TX_FRAMES = "adaptor_FcPortStatsHist_txFrames"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TX_FRAMES_DELTA = "adaptor_FcPortStatsHist_txFramesDelta"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TX_FRAMES_DELTA_AVG = "adaptor_FcPortStatsHist_txFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TX_FRAMES_DELTA_MAX = "adaptor_FcPortStatsHist_txFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_HIST_TX_FRAMES_DELTA_MIN = "adaptor_FcPortStatsHist_txFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_INTERVALS = "adaptor_FcPortStats_intervals"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_NORMALIZED_TIME_COL = "adaptor_FcPortStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_RX_BAD_FRAMES = "adaptor_FcPortStats_rxBadFrames"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_RX_BAD_FRAMES_DELTA = "adaptor_FcPortStats_rxBadFramesDelta"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_RX_BAD_FRAMES_DELTA_AVG = "adaptor_FcPortStats_rxBadFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_RX_BAD_FRAMES_DELTA_MAX = "adaptor_FcPortStats_rxBadFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_RX_BAD_FRAMES_DELTA_MIN = "adaptor_FcPortStats_rxBadFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_RX_FRAMES = "adaptor_FcPortStats_rxFrames"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_RX_FRAMES_DELTA = "adaptor_FcPortStats_rxFramesDelta"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_RX_FRAMES_DELTA_AVG = "adaptor_FcPortStats_rxFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_RX_FRAMES_DELTA_MAX = "adaptor_FcPortStats_rxFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_RX_FRAMES_DELTA_MIN = "adaptor_FcPortStats_rxFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_STATS_REPORTED = "adaptor_FcPortStats_statsReported"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_SUSPECT = "adaptor_FcPortStats_suspect"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_THRESHOLDED = "adaptor_FcPortStats_thresholded"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TIME_COLLECTED = "adaptor_FcPortStats_timeCollected"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TX_BAD_FRAMES = "adaptor_FcPortStats_txBadFrames"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TX_BAD_FRAMES_DELTA = "adaptor_FcPortStats_txBadFramesDelta"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TX_BAD_FRAMES_DELTA_AVG = "adaptor_FcPortStats_txBadFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TX_BAD_FRAMES_DELTA_MAX = "adaptor_FcPortStats_txBadFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TX_BAD_FRAMES_DELTA_MIN = "adaptor_FcPortStats_txBadFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TX_FRAMES = "adaptor_FcPortStats_txFrames"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TX_FRAMES_DELTA = "adaptor_FcPortStats_txFramesDelta"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TX_FRAMES_DELTA_AVG = "adaptor_FcPortStats_txFramesDeltaAvg"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TX_FRAMES_DELTA_MAX = "adaptor_FcPortStats_txFramesDeltaMax"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_TX_FRAMES_DELTA_MIN = "adaptor_FcPortStats_txFramesDeltaMin"
    SORT_PROP_ADAPTOR_FC_PORT_STATS_UPDATE = "adaptor_FcPortStats_update"
    SORT_PROP_ADAPTOR_FC_QUEUE_PROFILE_COUNT = "adaptor_FcQueueProfile_count"
    SORT_PROP_ADAPTOR_FC_QUEUE_PROFILE_RING_SIZE = "adaptor_FcQueueProfile_ringSize"
    SORT_PROP_ADAPTOR_FC_RECV_QUEUE_PROFILE_COUNT = "adaptor_FcRecvQueueProfile_count"
    SORT_PROP_ADAPTOR_FC_RECV_QUEUE_PROFILE_RING_SIZE = "adaptor_FcRecvQueueProfile_ringSize"
    SORT_PROP_ADAPTOR_FC_WORK_QUEUE_PROFILE_COUNT = "adaptor_FcWorkQueueProfile_count"
    SORT_PROP_ADAPTOR_FC_WORK_QUEUE_PROFILE_RING_SIZE = "adaptor_FcWorkQueueProfile_ringSize"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_DEPRECATED = "adaptor_FruCapProvider_deprecated"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_FORM = "adaptor_FruCapProvider_form"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_GENCOUNT = "adaptor_FruCapProvider_gencount"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_MGMT_PLANE_VER = "adaptor_FruCapProvider_mgmtPlaneVer"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_MODEL = "adaptor_FruCapProvider_model"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_PROM_CARD_TYPE = "adaptor_FruCapProvider_promCardType"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_REVISION = "adaptor_FruCapProvider_revision"
    SORT_PROP_ADAPTOR_FRU_CAP_PROVIDER_VENDOR = "adaptor_FruCapProvider_vendor"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_BYTES_RX = "adaptor_HBAVnicStatsHist_bytesRx"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_BYTES_RX_DELTA = "adaptor_HBAVnicStatsHist_bytesRxDelta"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_BYTES_RX_DELTA_AVG = "adaptor_HBAVnicStatsHist_bytesRxDeltaAvg"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_BYTES_RX_DELTA_MAX = "adaptor_HBAVnicStatsHist_bytesRxDeltaMax"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_BYTES_RX_DELTA_MIN = "adaptor_HBAVnicStatsHist_bytesRxDeltaMin"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_BYTES_TX = "adaptor_HBAVnicStatsHist_bytesTx"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_BYTES_TX_DELTA = "adaptor_HBAVnicStatsHist_bytesTxDelta"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_BYTES_TX_DELTA_AVG = "adaptor_HBAVnicStatsHist_bytesTxDeltaAvg"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_BYTES_TX_DELTA_MAX = "adaptor_HBAVnicStatsHist_bytesTxDeltaMax"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_BYTES_TX_DELTA_MIN = "adaptor_HBAVnicStatsHist_bytesTxDeltaMin"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_DROPPED_RX = "adaptor_HBAVnicStatsHist_droppedRx"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_DROPPED_RX_DELTA = "adaptor_HBAVnicStatsHist_droppedRxDelta"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_DROPPED_RX_DELTA_AVG = "adaptor_HBAVnicStatsHist_droppedRxDeltaAvg"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_DROPPED_RX_DELTA_MAX = "adaptor_HBAVnicStatsHist_droppedRxDeltaMax"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_DROPPED_RX_DELTA_MIN = "adaptor_HBAVnicStatsHist_droppedRxDeltaMin"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_DROPPED_TX = "adaptor_HBAVnicStatsHist_droppedTx"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_DROPPED_TX_DELTA = "adaptor_HBAVnicStatsHist_droppedTxDelta"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_DROPPED_TX_DELTA_AVG = "adaptor_HBAVnicStatsHist_droppedTxDeltaAvg"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_DROPPED_TX_DELTA_MAX = "adaptor_HBAVnicStatsHist_droppedTxDeltaMax"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_DROPPED_TX_DELTA_MIN = "adaptor_HBAVnicStatsHist_droppedTxDeltaMin"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_ERRORS_RX = "adaptor_HBAVnicStatsHist_errorsRx"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_ERRORS_RX_DELTA = "adaptor_HBAVnicStatsHist_errorsRxDelta"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_ERRORS_RX_DELTA_AVG = "adaptor_HBAVnicStatsHist_errorsRxDeltaAvg"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_ERRORS_RX_DELTA_MAX = "adaptor_HBAVnicStatsHist_errorsRxDeltaMax"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_ERRORS_RX_DELTA_MIN = "adaptor_HBAVnicStatsHist_errorsRxDeltaMin"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_ERRORS_TX = "adaptor_HBAVnicStatsHist_errorsTx"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_ERRORS_TX_DELTA = "adaptor_HBAVnicStatsHist_errorsTxDelta"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_ERRORS_TX_DELTA_AVG = "adaptor_HBAVnicStatsHist_errorsTxDeltaAvg"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_ERRORS_TX_DELTA_MAX = "adaptor_HBAVnicStatsHist_errorsTxDeltaMax"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_ERRORS_TX_DELTA_MIN = "adaptor_HBAVnicStatsHist_errorsTxDeltaMin"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_ID = "adaptor_HBAVnicStatsHist_id"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_MOST_RECENT = "adaptor_HBAVnicStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_PACKETS_RX = "adaptor_HBAVnicStatsHist_packetsRx"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_PACKETS_RX_DELTA = "adaptor_HBAVnicStatsHist_packetsRxDelta"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_PACKETS_RX_DELTA_AVG = "adaptor_HBAVnicStatsHist_packetsRxDeltaAvg"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_PACKETS_RX_DELTA_MAX = "adaptor_HBAVnicStatsHist_packetsRxDeltaMax"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_PACKETS_RX_DELTA_MIN = "adaptor_HBAVnicStatsHist_packetsRxDeltaMin"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_PACKETS_TX = "adaptor_HBAVnicStatsHist_packetsTx"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_PACKETS_TX_DELTA = "adaptor_HBAVnicStatsHist_packetsTxDelta"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_PACKETS_TX_DELTA_AVG = "adaptor_HBAVnicStatsHist_packetsTxDeltaAvg"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_PACKETS_TX_DELTA_MAX = "adaptor_HBAVnicStatsHist_packetsTxDeltaMax"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_PACKETS_TX_DELTA_MIN = "adaptor_HBAVnicStatsHist_packetsTxDeltaMin"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_SUSPECT = "adaptor_HBAVnicStatsHist_suspect"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_THRESHOLDED = "adaptor_HBAVnicStatsHist_thresholded"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_HIST_TIME_COLLECTED = "adaptor_HBAVnicStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_BYTES_RX = "adaptor_HBAVnicStats_bytesRx"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_BYTES_RX_DELTA = "adaptor_HBAVnicStats_bytesRxDelta"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_BYTES_RX_DELTA_AVG = "adaptor_HBAVnicStats_bytesRxDeltaAvg"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_BYTES_RX_DELTA_MAX = "adaptor_HBAVnicStats_bytesRxDeltaMax"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_BYTES_RX_DELTA_MIN = "adaptor_HBAVnicStats_bytesRxDeltaMin"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_BYTES_TX = "adaptor_HBAVnicStats_bytesTx"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_BYTES_TX_DELTA = "adaptor_HBAVnicStats_bytesTxDelta"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_BYTES_TX_DELTA_AVG = "adaptor_HBAVnicStats_bytesTxDeltaAvg"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_BYTES_TX_DELTA_MAX = "adaptor_HBAVnicStats_bytesTxDeltaMax"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_BYTES_TX_DELTA_MIN = "adaptor_HBAVnicStats_bytesTxDeltaMin"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_DROPPED_RX = "adaptor_HBAVnicStats_droppedRx"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_DROPPED_RX_DELTA = "adaptor_HBAVnicStats_droppedRxDelta"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_DROPPED_RX_DELTA_AVG = "adaptor_HBAVnicStats_droppedRxDeltaAvg"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_DROPPED_RX_DELTA_MAX = "adaptor_HBAVnicStats_droppedRxDeltaMax"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_DROPPED_RX_DELTA_MIN = "adaptor_HBAVnicStats_droppedRxDeltaMin"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_DROPPED_TX = "adaptor_HBAVnicStats_droppedTx"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_DROPPED_TX_DELTA = "adaptor_HBAVnicStats_droppedTxDelta"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_DROPPED_TX_DELTA_AVG = "adaptor_HBAVnicStats_droppedTxDeltaAvg"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_DROPPED_TX_DELTA_MAX = "adaptor_HBAVnicStats_droppedTxDeltaMax"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_DROPPED_TX_DELTA_MIN = "adaptor_HBAVnicStats_droppedTxDeltaMin"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_ERRORS_RX = "adaptor_HBAVnicStats_errorsRx"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_ERRORS_RX_DELTA = "adaptor_HBAVnicStats_errorsRxDelta"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_ERRORS_RX_DELTA_AVG = "adaptor_HBAVnicStats_errorsRxDeltaAvg"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_ERRORS_RX_DELTA_MAX = "adaptor_HBAVnicStats_errorsRxDeltaMax"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_ERRORS_RX_DELTA_MIN = "adaptor_HBAVnicStats_errorsRxDeltaMin"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_ERRORS_TX = "adaptor_HBAVnicStats_errorsTx"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_ERRORS_TX_DELTA = "adaptor_HBAVnicStats_errorsTxDelta"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_ERRORS_TX_DELTA_AVG = "adaptor_HBAVnicStats_errorsTxDeltaAvg"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_ERRORS_TX_DELTA_MAX = "adaptor_HBAVnicStats_errorsTxDeltaMax"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_ERRORS_TX_DELTA_MIN = "adaptor_HBAVnicStats_errorsTxDeltaMin"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_INTERVALS = "adaptor_HBAVnicStats_intervals"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_NORMALIZED_TIME_COL = "adaptor_HBAVnicStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_PACKETS_RX = "adaptor_HBAVnicStats_packetsRx"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_PACKETS_RX_DELTA = "adaptor_HBAVnicStats_packetsRxDelta"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_PACKETS_RX_DELTA_AVG = "adaptor_HBAVnicStats_packetsRxDeltaAvg"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_PACKETS_RX_DELTA_MAX = "adaptor_HBAVnicStats_packetsRxDeltaMax"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_PACKETS_RX_DELTA_MIN = "adaptor_HBAVnicStats_packetsRxDeltaMin"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_PACKETS_TX = "adaptor_HBAVnicStats_packetsTx"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_PACKETS_TX_DELTA = "adaptor_HBAVnicStats_packetsTxDelta"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_PACKETS_TX_DELTA_AVG = "adaptor_HBAVnicStats_packetsTxDeltaAvg"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_PACKETS_TX_DELTA_MAX = "adaptor_HBAVnicStats_packetsTxDeltaMax"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_PACKETS_TX_DELTA_MIN = "adaptor_HBAVnicStats_packetsTxDeltaMin"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_STATS_REPORTED = "adaptor_HBAVnicStats_statsReported"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_SUSPECT = "adaptor_HBAVnicStats_suspect"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_THRESHOLDED = "adaptor_HBAVnicStats_thresholded"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_TIME_COLLECTED = "adaptor_HBAVnicStats_timeCollected"
    SORT_PROP_ADAPTOR_HBAVNIC_STATS_UPDATE = "adaptor_HBAVnicStats_update"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_OPERATION_ADMIN_STATE = "adaptor_HostEthIfOperation_adminState"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_OPERATION_LAST_MODIFIED = "adaptor_HostEthIfOperation_lastModified"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_OPERATION_REMOTE_ERROR_CODE = "adaptor_HostEthIfOperation_remoteErrorCode"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_OPERATION_REMOTE_ERROR_DESCR = "adaptor_HostEthIfOperation_remoteErrorDescr"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_OPERATION_TRIGGER_STATUS = "adaptor_HostEthIfOperation_triggerStatus"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PROFILE_DESCR = "adaptor_HostEthIfProfile_descr"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PROFILE_INT_ID = "adaptor_HostEthIfProfile_intId"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PROFILE_NAME = "adaptor_HostEthIfProfile_name"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PROFILE_POLICY_LEVEL = "adaptor_HostEthIfProfile_policyLevel"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PROFILE_POLICY_OWNER = "adaptor_HostEthIfProfile_policyOwner"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PROFILE_POOLED_RESOURCES = "adaptor_HostEthIfProfile_pooledResources"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_ADMIN_STATE = "adaptor_HostEthIf_adminState"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_BOOT_DEV = "adaptor_HostEthIf_bootDev"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_CDN_NAME = "adaptor_HostEthIf_cdnName"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_CHASSIS_ID = "adaptor_HostEthIf_chassisId"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_DISCOVERY = "adaptor_HostEthIf_discovery"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_EP_DN = "adaptor_HostEthIf_epDn"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_HOST_PORT = "adaptor_HostEthIf_hostPort"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_ID = "adaptor_HostEthIf_id"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_IF_ROLE = "adaptor_HostEthIf_ifRole"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_IF_TYPE = "adaptor_HostEthIf_ifType"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_LC = "adaptor_HostEthIf_lc"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_LINK_STATE = "adaptor_HostEthIf_linkState"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_LOCALE = "adaptor_HostEthIf_locale"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_MAC = "adaptor_HostEthIf_mac"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_MODEL = "adaptor_HostEthIf_model"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_MTU = "adaptor_HostEthIf_mtu"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_NAME = "adaptor_HostEthIf_name"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_OPER_QUALIFIER_REASON = "adaptor_HostEthIf_operQualifierReason"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_OPER_STATE = "adaptor_HostEthIf_operState"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_OPERABILITY = "adaptor_HostEthIf_operability"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_ORDER = "adaptor_HostEthIf_order"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_ORIGINAL_MAC = "adaptor_HostEthIf_originalMac"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PCI_ADDR = "adaptor_HostEthIf_pciAddr"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PCI_FUNC = "adaptor_HostEthIf_pciFunc"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PCI_SLOT = "adaptor_HostEthIf_pciSlot"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PEER_CHASSIS_ID = "adaptor_HostEthIf_peerChassisId"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PEER_DN = "adaptor_HostEthIf_peerDn"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PEER_PORT_ID = "adaptor_HostEthIf_peerPortId"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PEER_SLOT_ID = "adaptor_HostEthIf_peerSlotId"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PERF = "adaptor_HostEthIf_perf"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PF_DN = "adaptor_HostEthIf_pfDn"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PORT_ID = "adaptor_HostEthIf_portId"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_POWER = "adaptor_HostEthIf_power"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PRESENCE = "adaptor_HostEthIf_presence"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_PURPOSE = "adaptor_HostEthIf_purpose"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_REVISION = "adaptor_HostEthIf_revision"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_SERIAL = "adaptor_HostEthIf_serial"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_SIDE = "adaptor_HostEthIf_side"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_SLOT_ID = "adaptor_HostEthIf_slotId"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_SWITCH_ID = "adaptor_HostEthIf_switchId"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_THERMAL = "adaptor_HostEthIf_thermal"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_TRANSPORT = "adaptor_HostEthIf_transport"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_TYPE = "adaptor_HostEthIf_type"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_VENDOR = "adaptor_HostEthIf_vendor"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_VIRTUALIZATION_PREFERENCE = "adaptor_HostEthIf_virtualizationPreference"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_VNIC_DN = "adaptor_HostEthIf_vnicDn"
    SORT_PROP_ADAPTOR_HOST_ETH_IF_VOLTAGE = "adaptor_HostEthIf_voltage"
    SORT_PROP_ADAPTOR_HOST_FC_IF_OPERATION_ADMIN_STATE = "adaptor_HostFcIfOperation_adminState"
    SORT_PROP_ADAPTOR_HOST_FC_IF_OPERATION_LAST_MODIFIED = "adaptor_HostFcIfOperation_lastModified"
    SORT_PROP_ADAPTOR_HOST_FC_IF_OPERATION_REMOTE_ERROR_CODE = "adaptor_HostFcIfOperation_remoteErrorCode"
    SORT_PROP_ADAPTOR_HOST_FC_IF_OPERATION_REMOTE_ERROR_DESCR = "adaptor_HostFcIfOperation_remoteErrorDescr"
    SORT_PROP_ADAPTOR_HOST_FC_IF_OPERATION_TRIGGER_STATUS = "adaptor_HostFcIfOperation_triggerStatus"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PROFILE_DESCR = "adaptor_HostFcIfProfile_descr"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PROFILE_INT_ID = "adaptor_HostFcIfProfile_intId"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PROFILE_NAME = "adaptor_HostFcIfProfile_name"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PROFILE_POLICY_LEVEL = "adaptor_HostFcIfProfile_policyLevel"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PROFILE_POLICY_OWNER = "adaptor_HostFcIfProfile_policyOwner"
    SORT_PROP_ADAPTOR_HOST_FC_IF_ADMIN_STATE = "adaptor_HostFcIf_adminState"
    SORT_PROP_ADAPTOR_HOST_FC_IF_BOOT_DEV = "adaptor_HostFcIf_bootDev"
    SORT_PROP_ADAPTOR_HOST_FC_IF_CDN_NAME = "adaptor_HostFcIf_cdnName"
    SORT_PROP_ADAPTOR_HOST_FC_IF_CHASSIS_ID = "adaptor_HostFcIf_chassisId"
    SORT_PROP_ADAPTOR_HOST_FC_IF_DISCOVERY = "adaptor_HostFcIf_discovery"
    SORT_PROP_ADAPTOR_HOST_FC_IF_EP_DN = "adaptor_HostFcIf_epDn"
    SORT_PROP_ADAPTOR_HOST_FC_IF_HOST_PORT = "adaptor_HostFcIf_hostPort"
    SORT_PROP_ADAPTOR_HOST_FC_IF_ID = "adaptor_HostFcIf_id"
    SORT_PROP_ADAPTOR_HOST_FC_IF_IF_ROLE = "adaptor_HostFcIf_ifRole"
    SORT_PROP_ADAPTOR_HOST_FC_IF_IF_TYPE = "adaptor_HostFcIf_ifType"
    SORT_PROP_ADAPTOR_HOST_FC_IF_LC = "adaptor_HostFcIf_lc"
    SORT_PROP_ADAPTOR_HOST_FC_IF_LINK_STATE = "adaptor_HostFcIf_linkState"
    SORT_PROP_ADAPTOR_HOST_FC_IF_LOCALE = "adaptor_HostFcIf_locale"
    SORT_PROP_ADAPTOR_HOST_FC_IF_MAX_DATA_FIELD_SIZE = "adaptor_HostFcIf_maxDataFieldSize"
    SORT_PROP_ADAPTOR_HOST_FC_IF_MODEL = "adaptor_HostFcIf_model"
    SORT_PROP_ADAPTOR_HOST_FC_IF_NAME = "adaptor_HostFcIf_name"
    SORT_PROP_ADAPTOR_HOST_FC_IF_NODE_WWN = "adaptor_HostFcIf_nodeWwn"
    SORT_PROP_ADAPTOR_HOST_FC_IF_OPER_QUALIFIER_REASON = "adaptor_HostFcIf_operQualifierReason"
    SORT_PROP_ADAPTOR_HOST_FC_IF_OPER_STATE = "adaptor_HostFcIf_operState"
    SORT_PROP_ADAPTOR_HOST_FC_IF_OPERABILITY = "adaptor_HostFcIf_operability"
    SORT_PROP_ADAPTOR_HOST_FC_IF_ORDER = "adaptor_HostFcIf_order"
    SORT_PROP_ADAPTOR_HOST_FC_IF_ORIGINAL_NODE_WWN = "adaptor_HostFcIf_originalNodeWwn"
    SORT_PROP_ADAPTOR_HOST_FC_IF_ORIGINAL_WWN = "adaptor_HostFcIf_originalWwn"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PCI_ADDR = "adaptor_HostFcIf_pciAddr"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PCI_FUNC = "adaptor_HostFcIf_pciFunc"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PCI_SLOT = "adaptor_HostFcIf_pciSlot"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PEER_CHASSIS_ID = "adaptor_HostFcIf_peerChassisId"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PEER_DN = "adaptor_HostFcIf_peerDn"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PEER_PORT_ID = "adaptor_HostFcIf_peerPortId"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PEER_SLOT_ID = "adaptor_HostFcIf_peerSlotId"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PERF = "adaptor_HostFcIf_perf"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PERS_BIND = "adaptor_HostFcIf_persBind"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PORT_ID = "adaptor_HostFcIf_portId"
    SORT_PROP_ADAPTOR_HOST_FC_IF_POWER = "adaptor_HostFcIf_power"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PRESENCE = "adaptor_HostFcIf_presence"
    SORT_PROP_ADAPTOR_HOST_FC_IF_PURPOSE = "adaptor_HostFcIf_purpose"
    SORT_PROP_ADAPTOR_HOST_FC_IF_REVISION = "adaptor_HostFcIf_revision"
    SORT_PROP_ADAPTOR_HOST_FC_IF_SERIAL = "adaptor_HostFcIf_serial"
    SORT_PROP_ADAPTOR_HOST_FC_IF_SIDE = "adaptor_HostFcIf_side"
    SORT_PROP_ADAPTOR_HOST_FC_IF_SLOT_ID = "adaptor_HostFcIf_slotId"
    SORT_PROP_ADAPTOR_HOST_FC_IF_SWITCH_ID = "adaptor_HostFcIf_switchId"
    SORT_PROP_ADAPTOR_HOST_FC_IF_THERMAL = "adaptor_HostFcIf_thermal"
    SORT_PROP_ADAPTOR_HOST_FC_IF_TRANSPORT = "adaptor_HostFcIf_transport"
    SORT_PROP_ADAPTOR_HOST_FC_IF_TYPE = "adaptor_HostFcIf_type"
    SORT_PROP_ADAPTOR_HOST_FC_IF_VENDOR = "adaptor_HostFcIf_vendor"
    SORT_PROP_ADAPTOR_HOST_FC_IF_VNIC_DN = "adaptor_HostFcIf_vnicDn"
    SORT_PROP_ADAPTOR_HOST_FC_IF_VOLTAGE = "adaptor_HostFcIf_voltage"
    SORT_PROP_ADAPTOR_HOST_FC_IF_WWN = "adaptor_HostFcIf_wwn"
    SORT_PROP_ADAPTOR_HOST_IF_CONFIG_ADMIN_STATE = "adaptor_HostIfConfig_adminState"
    SORT_PROP_ADAPTOR_HOST_IF_CONFIG_ID = "adaptor_HostIfConfig_id"
    SORT_PROP_ADAPTOR_HOST_IF_CONFIG_NAME = "adaptor_HostIfConfig_name"
    SORT_PROP_ADAPTOR_HOST_IF_CONFIG_TRANSPORT = "adaptor_HostIfConfig_transport"
    SORT_PROP_ADAPTOR_HOST_IF_CONN_DEF_CON_POLICY_NAME = "adaptor_HostIfConnDef_conPolicyName"
    SORT_PROP_ADAPTOR_HOST_IF_PROFILE_DESCR = "adaptor_HostIfProfile_descr"
    SORT_PROP_ADAPTOR_HOST_IF_PROFILE_INT_ID = "adaptor_HostIfProfile_intId"
    SORT_PROP_ADAPTOR_HOST_IF_PROFILE_NAME = "adaptor_HostIfProfile_name"
    SORT_PROP_ADAPTOR_HOST_IF_PROFILE_POLICY_LEVEL = "adaptor_HostIfProfile_policyLevel"
    SORT_PROP_ADAPTOR_HOST_IF_PROFILE_POLICY_OWNER = "adaptor_HostIfProfile_policyOwner"
    SORT_PROP_ADAPTOR_HOST_IF_ADMIN_STATE = "adaptor_HostIf_adminState"
    SORT_PROP_ADAPTOR_HOST_IF_BOOT_DEV = "adaptor_HostIf_bootDev"
    SORT_PROP_ADAPTOR_HOST_IF_CDN_NAME = "adaptor_HostIf_cdnName"
    SORT_PROP_ADAPTOR_HOST_IF_CHASSIS_ID = "adaptor_HostIf_chassisId"
    SORT_PROP_ADAPTOR_HOST_IF_DISCOVERY = "adaptor_HostIf_discovery"
    SORT_PROP_ADAPTOR_HOST_IF_EP_DN = "adaptor_HostIf_epDn"
    SORT_PROP_ADAPTOR_HOST_IF_ID = "adaptor_HostIf_id"
    SORT_PROP_ADAPTOR_HOST_IF_IF_ROLE = "adaptor_HostIf_ifRole"
    SORT_PROP_ADAPTOR_HOST_IF_IF_TYPE = "adaptor_HostIf_ifType"
    SORT_PROP_ADAPTOR_HOST_IF_LC = "adaptor_HostIf_lc"
    SORT_PROP_ADAPTOR_HOST_IF_LINK_STATE = "adaptor_HostIf_linkState"
    SORT_PROP_ADAPTOR_HOST_IF_LOCALE = "adaptor_HostIf_locale"
    SORT_PROP_ADAPTOR_HOST_IF_MODEL = "adaptor_HostIf_model"
    SORT_PROP_ADAPTOR_HOST_IF_NAME = "adaptor_HostIf_name"
    SORT_PROP_ADAPTOR_HOST_IF_OPER_QUALIFIER_REASON = "adaptor_HostIf_operQualifierReason"
    SORT_PROP_ADAPTOR_HOST_IF_OPER_STATE = "adaptor_HostIf_operState"
    SORT_PROP_ADAPTOR_HOST_IF_OPERABILITY = "adaptor_HostIf_operability"
    SORT_PROP_ADAPTOR_HOST_IF_ORDER = "adaptor_HostIf_order"
    SORT_PROP_ADAPTOR_HOST_IF_PCI_ADDR = "adaptor_HostIf_pciAddr"
    SORT_PROP_ADAPTOR_HOST_IF_PCI_FUNC = "adaptor_HostIf_pciFunc"
    SORT_PROP_ADAPTOR_HOST_IF_PCI_SLOT = "adaptor_HostIf_pciSlot"
    SORT_PROP_ADAPTOR_HOST_IF_PEER_CHASSIS_ID = "adaptor_HostIf_peerChassisId"
    SORT_PROP_ADAPTOR_HOST_IF_PEER_DN = "adaptor_HostIf_peerDn"
    SORT_PROP_ADAPTOR_HOST_IF_PEER_PORT_ID = "adaptor_HostIf_peerPortId"
    SORT_PROP_ADAPTOR_HOST_IF_PEER_SLOT_ID = "adaptor_HostIf_peerSlotId"
    SORT_PROP_ADAPTOR_HOST_IF_PERF = "adaptor_HostIf_perf"
    SORT_PROP_ADAPTOR_HOST_IF_PORT_ID = "adaptor_HostIf_portId"
    SORT_PROP_ADAPTOR_HOST_IF_POWER = "adaptor_HostIf_power"
    SORT_PROP_ADAPTOR_HOST_IF_PRESENCE = "adaptor_HostIf_presence"
    SORT_PROP_ADAPTOR_HOST_IF_PURPOSE = "adaptor_HostIf_purpose"
    SORT_PROP_ADAPTOR_HOST_IF_REVISION = "adaptor_HostIf_revision"
    SORT_PROP_ADAPTOR_HOST_IF_SERIAL = "adaptor_HostIf_serial"
    SORT_PROP_ADAPTOR_HOST_IF_SIDE = "adaptor_HostIf_side"
    SORT_PROP_ADAPTOR_HOST_IF_SLOT_ID = "adaptor_HostIf_slotId"
    SORT_PROP_ADAPTOR_HOST_IF_SWITCH_ID = "adaptor_HostIf_switchId"
    SORT_PROP_ADAPTOR_HOST_IF_THERMAL = "adaptor_HostIf_thermal"
    SORT_PROP_ADAPTOR_HOST_IF_TRANSPORT = "adaptor_HostIf_transport"
    SORT_PROP_ADAPTOR_HOST_IF_TYPE = "adaptor_HostIf_type"
    SORT_PROP_ADAPTOR_HOST_IF_VENDOR = "adaptor_HostIf_vendor"
    SORT_PROP_ADAPTOR_HOST_IF_VNIC_DN = "adaptor_HostIf_vnicDn"
    SORT_PROP_ADAPTOR_HOST_IF_VOLTAGE = "adaptor_HostIf_voltage"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_OPERATION_ADMIN_STATE = "adaptor_HostIscsiIfOperation_adminState"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_OPERATION_LAST_MODIFIED = "adaptor_HostIscsiIfOperation_lastModified"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_OPERATION_REMOTE_ERROR_CODE = "adaptor_HostIscsiIfOperation_remoteErrorCode"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_OPERATION_REMOTE_ERROR_DESCR = "adaptor_HostIscsiIfOperation_remoteErrorDescr"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_OPERATION_TRIGGER_STATUS = "adaptor_HostIscsiIfOperation_triggerStatus"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PROFILE_DESCR = "adaptor_HostIscsiIfProfile_descr"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PROFILE_INT_ID = "adaptor_HostIscsiIfProfile_intId"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PROFILE_NAME = "adaptor_HostIscsiIfProfile_name"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PROFILE_POLICY_LEVEL = "adaptor_HostIscsiIfProfile_policyLevel"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PROFILE_POLICY_OWNER = "adaptor_HostIscsiIfProfile_policyOwner"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_ADMIN_STATE = "adaptor_HostIscsiIf_adminState"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_BOOT_DEV = "adaptor_HostIscsiIf_bootDev"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_CDN_NAME = "adaptor_HostIscsiIf_cdnName"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_CHASSIS_ID = "adaptor_HostIscsiIf_chassisId"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_DISCOVERY = "adaptor_HostIscsiIf_discovery"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_EP_DN = "adaptor_HostIscsiIf_epDn"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_ETH_EP_DN = "adaptor_HostIscsiIf_ethEpDn"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_HOST_VISIBLE = "adaptor_HostIscsiIf_hostVisible"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_ID = "adaptor_HostIscsiIf_id"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_IF_ROLE = "adaptor_HostIscsiIf_ifRole"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_IF_TYPE = "adaptor_HostIscsiIf_ifType"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_INITIATOR_NAME = "adaptor_HostIscsiIf_initiatorName"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_LC = "adaptor_HostIscsiIf_lc"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_LINK_STATE = "adaptor_HostIscsiIf_linkState"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_LOCALE = "adaptor_HostIscsiIf_locale"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_MAC = "adaptor_HostIscsiIf_mac"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_MODEL = "adaptor_HostIscsiIf_model"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_NAME = "adaptor_HostIscsiIf_name"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_OPER_QUALIFIER_REASON = "adaptor_HostIscsiIf_operQualifierReason"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_OPER_STATE = "adaptor_HostIscsiIf_operState"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_OPERABILITY = "adaptor_HostIscsiIf_operability"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_ORDER = "adaptor_HostIscsiIf_order"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_ORIGINAL_MAC = "adaptor_HostIscsiIf_originalMac"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PCI_ADDR = "adaptor_HostIscsiIf_pciAddr"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PCI_FUNC = "adaptor_HostIscsiIf_pciFunc"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PCI_SLOT = "adaptor_HostIscsiIf_pciSlot"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PEER_CHASSIS_ID = "adaptor_HostIscsiIf_peerChassisId"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PEER_DN = "adaptor_HostIscsiIf_peerDn"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PEER_PORT_ID = "adaptor_HostIscsiIf_peerPortId"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PEER_SLOT_ID = "adaptor_HostIscsiIf_peerSlotId"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PERF = "adaptor_HostIscsiIf_perf"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PORT_ID = "adaptor_HostIscsiIf_portId"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_POWER = "adaptor_HostIscsiIf_power"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PRESENCE = "adaptor_HostIscsiIf_presence"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_PURPOSE = "adaptor_HostIscsiIf_purpose"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_REVISION = "adaptor_HostIscsiIf_revision"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_SERIAL = "adaptor_HostIscsiIf_serial"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_SIDE = "adaptor_HostIscsiIf_side"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_SLOT_ID = "adaptor_HostIscsiIf_slotId"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_SWITCH_ID = "adaptor_HostIscsiIf_switchId"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_THERMAL = "adaptor_HostIscsiIf_thermal"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_TRANSPORT = "adaptor_HostIscsiIf_transport"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_TYPE = "adaptor_HostIscsiIf_type"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_VENDOR = "adaptor_HostIscsiIf_vendor"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_VNIC_DN = "adaptor_HostIscsiIf_vnicDn"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_VNIC_NAME = "adaptor_HostIscsiIf_vnicName"
    SORT_PROP_ADAPTOR_HOST_ISCSI_IF_VOLTAGE = "adaptor_HostIscsiIf_voltage"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_ADMIN_STATE = "adaptor_HostScsiIf_adminState"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_BOOT_DEV = "adaptor_HostScsiIf_bootDev"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_CDN_NAME = "adaptor_HostScsiIf_cdnName"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_CHASSIS_ID = "adaptor_HostScsiIf_chassisId"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_DISCOVERY = "adaptor_HostScsiIf_discovery"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_EP_DN = "adaptor_HostScsiIf_epDn"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_ID = "adaptor_HostScsiIf_id"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_IF_ROLE = "adaptor_HostScsiIf_ifRole"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_IF_TYPE = "adaptor_HostScsiIf_ifType"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_LC = "adaptor_HostScsiIf_lc"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_LINK_STATE = "adaptor_HostScsiIf_linkState"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_LOCALE = "adaptor_HostScsiIf_locale"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_MODEL = "adaptor_HostScsiIf_model"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_NAME = "adaptor_HostScsiIf_name"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_OPER_QUALIFIER_REASON = "adaptor_HostScsiIf_operQualifierReason"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_OPER_STATE = "adaptor_HostScsiIf_operState"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_OPERABILITY = "adaptor_HostScsiIf_operability"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_ORDER = "adaptor_HostScsiIf_order"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PCI_ADDR = "adaptor_HostScsiIf_pciAddr"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PCI_FUNC = "adaptor_HostScsiIf_pciFunc"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PCI_SLOT = "adaptor_HostScsiIf_pciSlot"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PEER_CHASSIS_ID = "adaptor_HostScsiIf_peerChassisId"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PEER_DN = "adaptor_HostScsiIf_peerDn"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PEER_PORT_ID = "adaptor_HostScsiIf_peerPortId"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PEER_SLOT_ID = "adaptor_HostScsiIf_peerSlotId"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PERF = "adaptor_HostScsiIf_perf"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PORT_ID = "adaptor_HostScsiIf_portId"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_POWER = "adaptor_HostScsiIf_power"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PRESENCE = "adaptor_HostScsiIf_presence"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_PURPOSE = "adaptor_HostScsiIf_purpose"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_REVISION = "adaptor_HostScsiIf_revision"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_SERIAL = "adaptor_HostScsiIf_serial"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_SIDE = "adaptor_HostScsiIf_side"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_SLOT_ID = "adaptor_HostScsiIf_slotId"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_SWITCH_ID = "adaptor_HostScsiIf_switchId"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_THERMAL = "adaptor_HostScsiIf_thermal"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_TRANSPORT = "adaptor_HostScsiIf_transport"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_TYPE = "adaptor_HostScsiIf_type"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_VENDOR = "adaptor_HostScsiIf_vendor"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_VNIC_DN = "adaptor_HostScsiIf_vnicDn"
    SORT_PROP_ADAPTOR_HOST_SCSI_IF_VOLTAGE = "adaptor_HostScsiIf_voltage"
    SORT_PROP_ADAPTOR_HOST_SCSI_LUN_REF_BOOT_DEV = "adaptor_HostScsiLunRef_bootDev"
    SORT_PROP_ADAPTOR_HOST_SCSI_LUN_REF_LUN_ID = "adaptor_HostScsiLunRef_lunId"
    SORT_PROP_ADAPTOR_HOST_SCSI_LUN_REF_LUN_ORDER = "adaptor_HostScsiLunRef_lunOrder"
    SORT_PROP_ADAPTOR_HOST_SCSI_LUN_REF_OPER_LUN_ID = "adaptor_HostScsiLunRef_operLunId"
    SORT_PROP_ADAPTOR_HW_ADDR_CAP_MAC_OFFSET1 = "adaptor_HwAddrCap_macOffset1"
    SORT_PROP_ADAPTOR_HW_ADDR_CAP_MAC_OFFSET2 = "adaptor_HwAddrCap_macOffset2"
    SORT_PROP_ADAPTOR_ISCSI_CAP_BOOT_ORDER_TYPE = "adaptor_IScsiCap_bootOrderType"
    SORT_PROP_ADAPTOR_ISCSI_CAP_MAC_OFFSET1 = "adaptor_IScsiCap_macOffset1"
    SORT_PROP_ADAPTOR_ISCSI_CAP_MAC_OFFSET2 = "adaptor_IScsiCap_macOffset2"
    SORT_PROP_ADAPTOR_ISCSI_CAP_OFFLOAD_SUPPORT = "adaptor_IScsiCap_offloadSupport"
    SORT_PROP_ADAPTOR_ISCSI_CAP_OFFLOAD_TYPE = "adaptor_IScsiCap_offloadType"
    SORT_PROP_ADAPTOR_ISCSI_CAP_VLAN_FOR_BOOT = "adaptor_IScsiCap_vlanForBoot"
    SORT_PROP_ADAPTOR_IP_V4_RSS_HASH_PROFILE_IP_HASH = "adaptor_IpV4RssHashProfile_ipHash"
    SORT_PROP_ADAPTOR_IP_V4_RSS_HASH_PROFILE_TCP_HASH = "adaptor_IpV4RssHashProfile_tcpHash"
    SORT_PROP_ADAPTOR_IP_V6_RSS_HASH_PROFILE_IP_HASH = "adaptor_IpV6RssHashProfile_ipHash"
    SORT_PROP_ADAPTOR_IP_V6_RSS_HASH_PROFILE_TCP_HASH = "adaptor_IpV6RssHashProfile_tcpHash"
    SORT_PROP_ADAPTOR_LINK_STATE_HOLDER_LINK_STATE = "adaptor_LinkStateHolder_linkState"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_CORRECTABLE_ERRORS = "adaptor_MenloBaseErrorStatsHist_correctableErrors"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloBaseErrorStatsHist_correctableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloBaseErrorStatsHist_correctableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloBaseErrorStatsHist_correctableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloBaseErrorStatsHist_correctableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_ID = "adaptor_MenloBaseErrorStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_MOST_RECENT = "adaptor_MenloBaseErrorStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_SUSPECT = "adaptor_MenloBaseErrorStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_THRESHOLDED = "adaptor_MenloBaseErrorStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_TIME_COLLECTED = "adaptor_MenloBaseErrorStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS = "adaptor_MenloBaseErrorStatsHist_uncorrectableErrors"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloBaseErrorStatsHist_uncorrectableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloBaseErrorStatsHist_uncorrectableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloBaseErrorStatsHist_uncorrectableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloBaseErrorStatsHist_uncorrectableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_CORRECTABLE_ERRORS = "adaptor_MenloBaseErrorStats_correctableErrors"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloBaseErrorStats_correctableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloBaseErrorStats_correctableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloBaseErrorStats_correctableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloBaseErrorStats_correctableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_INTERVALS = "adaptor_MenloBaseErrorStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_NORMALIZED_TIME_COL = "adaptor_MenloBaseErrorStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_STATS_REPORTED = "adaptor_MenloBaseErrorStats_statsReported"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_SUSPECT = "adaptor_MenloBaseErrorStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_THRESHOLDED = "adaptor_MenloBaseErrorStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_TIME_COLLECTED = "adaptor_MenloBaseErrorStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_UNCORRECTABLE_ERRORS = "adaptor_MenloBaseErrorStats_uncorrectableErrors"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloBaseErrorStats_uncorrectableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloBaseErrorStats_uncorrectableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloBaseErrorStats_uncorrectableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloBaseErrorStats_uncorrectableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_BASE_ERROR_STATS_UPDATE = "adaptor_MenloBaseErrorStats_update"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_ID = "adaptor_MenloDcePortStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_MOST_RECENT = "adaptor_MenloDcePortStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_CFC = "adaptor_MenloDcePortStatsHist_rxPauseCFC"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_CFCDELTA = "adaptor_MenloDcePortStatsHist_rxPauseCFCDelta"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_CFCDELTA_AVG = "adaptor_MenloDcePortStatsHist_rxPauseCFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_CFCDELTA_MAX = "adaptor_MenloDcePortStatsHist_rxPauseCFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_CFCDELTA_MIN = "adaptor_MenloDcePortStatsHist_rxPauseCFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_PFC = "adaptor_MenloDcePortStatsHist_rxPausePFC"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_PFCDELTA = "adaptor_MenloDcePortStatsHist_rxPausePFCDelta"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_PFCDELTA_AVG = "adaptor_MenloDcePortStatsHist_rxPausePFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_PFCDELTA_MAX = "adaptor_MenloDcePortStatsHist_rxPausePFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_RX_PAUSE_PFCDELTA_MIN = "adaptor_MenloDcePortStatsHist_rxPausePFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_SUSPECT = "adaptor_MenloDcePortStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_THRESHOLDED = "adaptor_MenloDcePortStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TIME_COLLECTED = "adaptor_MenloDcePortStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_CFC = "adaptor_MenloDcePortStatsHist_txPauseCFC"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_CFCDELTA = "adaptor_MenloDcePortStatsHist_txPauseCFCDelta"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_CFCDELTA_AVG = "adaptor_MenloDcePortStatsHist_txPauseCFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_CFCDELTA_MAX = "adaptor_MenloDcePortStatsHist_txPauseCFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_CFCDELTA_MIN = "adaptor_MenloDcePortStatsHist_txPauseCFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_PFC = "adaptor_MenloDcePortStatsHist_txPausePFC"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_PFCDELTA = "adaptor_MenloDcePortStatsHist_txPausePFCDelta"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_PFCDELTA_AVG = "adaptor_MenloDcePortStatsHist_txPausePFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_PFCDELTA_MAX = "adaptor_MenloDcePortStatsHist_txPausePFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_HIST_TX_PAUSE_PFCDELTA_MIN = "adaptor_MenloDcePortStatsHist_txPausePFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_INTERVALS = "adaptor_MenloDcePortStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_MENLO_PORT_INDEX = "adaptor_MenloDcePortStats_menloPortIndex"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_NORMALIZED_TIME_COL = "adaptor_MenloDcePortStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_CFC = "adaptor_MenloDcePortStats_rxPauseCFC"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_CFCDELTA = "adaptor_MenloDcePortStats_rxPauseCFCDelta"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_CFCDELTA_AVG = "adaptor_MenloDcePortStats_rxPauseCFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_CFCDELTA_MAX = "adaptor_MenloDcePortStats_rxPauseCFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_CFCDELTA_MIN = "adaptor_MenloDcePortStats_rxPauseCFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_PFC = "adaptor_MenloDcePortStats_rxPausePFC"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_PFCDELTA = "adaptor_MenloDcePortStats_rxPausePFCDelta"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_PFCDELTA_AVG = "adaptor_MenloDcePortStats_rxPausePFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_PFCDELTA_MAX = "adaptor_MenloDcePortStats_rxPausePFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_RX_PAUSE_PFCDELTA_MIN = "adaptor_MenloDcePortStats_rxPausePFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_STATS_REPORTED = "adaptor_MenloDcePortStats_statsReported"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_SUSPECT = "adaptor_MenloDcePortStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_THRESHOLDED = "adaptor_MenloDcePortStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TIME_COLLECTED = "adaptor_MenloDcePortStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_CFC = "adaptor_MenloDcePortStats_txPauseCFC"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_CFCDELTA = "adaptor_MenloDcePortStats_txPauseCFCDelta"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_CFCDELTA_AVG = "adaptor_MenloDcePortStats_txPauseCFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_CFCDELTA_MAX = "adaptor_MenloDcePortStats_txPauseCFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_CFCDELTA_MIN = "adaptor_MenloDcePortStats_txPauseCFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_PFC = "adaptor_MenloDcePortStats_txPausePFC"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_PFCDELTA = "adaptor_MenloDcePortStats_txPausePFCDelta"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_PFCDELTA_AVG = "adaptor_MenloDcePortStats_txPausePFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_PFCDELTA_MAX = "adaptor_MenloDcePortStats_txPausePFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_TX_PAUSE_PFCDELTA_MIN = "adaptor_MenloDcePortStats_txPausePFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_DCE_PORT_STATS_UPDATE = "adaptor_MenloDcePortStats_update"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_CORRECTABLE_ERRORS = "adaptor_MenloEthErrorStatsHist_correctableErrors"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloEthErrorStatsHist_correctableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStatsHist_correctableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStatsHist_correctableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStatsHist_correctableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_DROP_ACL = "adaptor_MenloEthErrorStatsHist_dropAcl"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_DROP_ACL_DELTA = "adaptor_MenloEthErrorStatsHist_dropAclDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_DROP_ACL_DELTA_AVG = "adaptor_MenloEthErrorStatsHist_dropAclDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_DROP_ACL_DELTA_MAX = "adaptor_MenloEthErrorStatsHist_dropAclDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_DROP_ACL_DELTA_MIN = "adaptor_MenloEthErrorStatsHist_dropAclDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_ID = "adaptor_MenloEthErrorStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_MOST_RECENT = "adaptor_MenloEthErrorStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_POP_ERRORS = "adaptor_MenloEthErrorStatsHist_popErrors"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_POP_ERRORS_DELTA = "adaptor_MenloEthErrorStatsHist_popErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_POP_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStatsHist_popErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_POP_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStatsHist_popErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_POP_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStatsHist_popErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_PUSH_ERRORS = "adaptor_MenloEthErrorStatsHist_pushErrors"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_PUSH_ERRORS_DELTA = "adaptor_MenloEthErrorStatsHist_pushErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStatsHist_pushErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStatsHist_pushErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStatsHist_pushErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_SUSPECT = "adaptor_MenloEthErrorStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_THRESHOLDED = "adaptor_MenloEthErrorStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_TIME_COLLECTED = "adaptor_MenloEthErrorStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS = "adaptor_MenloEthErrorStatsHist_uncorrectableErrors"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloEthErrorStatsHist_uncorrectableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStatsHist_uncorrectableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStatsHist_uncorrectableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStatsHist_uncorrectableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_CORRECTABLE_ERRORS = "adaptor_MenloEthErrorStats_correctableErrors"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloEthErrorStats_correctableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStats_correctableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStats_correctableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStats_correctableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_DROP_ACL = "adaptor_MenloEthErrorStats_dropAcl"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_DROP_ACL_DELTA = "adaptor_MenloEthErrorStats_dropAclDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_DROP_ACL_DELTA_AVG = "adaptor_MenloEthErrorStats_dropAclDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_DROP_ACL_DELTA_MAX = "adaptor_MenloEthErrorStats_dropAclDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_DROP_ACL_DELTA_MIN = "adaptor_MenloEthErrorStats_dropAclDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_INTERVALS = "adaptor_MenloEthErrorStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_MENLO_ETH_INDEX = "adaptor_MenloEthErrorStats_menloEthIndex"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_NORMALIZED_TIME_COL = "adaptor_MenloEthErrorStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_POP_ERRORS = "adaptor_MenloEthErrorStats_popErrors"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_POP_ERRORS_DELTA = "adaptor_MenloEthErrorStats_popErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_POP_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStats_popErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_POP_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStats_popErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_POP_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStats_popErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_PUSH_ERRORS = "adaptor_MenloEthErrorStats_pushErrors"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_PUSH_ERRORS_DELTA = "adaptor_MenloEthErrorStats_pushErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStats_pushErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStats_pushErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStats_pushErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_STATS_REPORTED = "adaptor_MenloEthErrorStats_statsReported"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_SUSPECT = "adaptor_MenloEthErrorStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_THRESHOLDED = "adaptor_MenloEthErrorStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_TIME_COLLECTED = "adaptor_MenloEthErrorStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_UNCORRECTABLE_ERRORS = "adaptor_MenloEthErrorStats_uncorrectableErrors"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloEthErrorStats_uncorrectableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloEthErrorStats_uncorrectableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloEthErrorStats_uncorrectableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloEthErrorStats_uncorrectableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_ERROR_STATS_UPDATE = "adaptor_MenloEthErrorStats_update"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_OVERRUN = "adaptor_MenloEthStatsHist_dropOverrun"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_OVERRUN_DELTA = "adaptor_MenloEthStatsHist_dropOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_OVERRUN_DELTA_AVG = "adaptor_MenloEthStatsHist_dropOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_OVERRUN_DELTA_MAX = "adaptor_MenloEthStatsHist_dropOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_OVERRUN_DELTA_MIN = "adaptor_MenloEthStatsHist_dropOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_RUNT = "adaptor_MenloEthStatsHist_dropRunt"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_RUNT_DELTA = "adaptor_MenloEthStatsHist_dropRuntDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_RUNT_DELTA_AVG = "adaptor_MenloEthStatsHist_dropRuntDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_RUNT_DELTA_MAX = "adaptor_MenloEthStatsHist_dropRuntDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_DROP_RUNT_DELTA_MIN = "adaptor_MenloEthStatsHist_dropRuntDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_ID = "adaptor_MenloEthStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_MOST_RECENT = "adaptor_MenloEthStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_SUSPECT = "adaptor_MenloEthStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_THRESHOLDED = "adaptor_MenloEthStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_TIME_COLLECTED = "adaptor_MenloEthStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_TRUNCATE_OVERRUN = "adaptor_MenloEthStatsHist_truncateOverrun"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_TRUNCATE_OVERRUN_DELTA = "adaptor_MenloEthStatsHist_truncateOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_TRUNCATE_OVERRUN_DELTA_AVG = "adaptor_MenloEthStatsHist_truncateOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_TRUNCATE_OVERRUN_DELTA_MAX = "adaptor_MenloEthStatsHist_truncateOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_HIST_TRUNCATE_OVERRUN_DELTA_MIN = "adaptor_MenloEthStatsHist_truncateOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_DROP_OVERRUN = "adaptor_MenloEthStats_dropOverrun"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_DROP_OVERRUN_DELTA = "adaptor_MenloEthStats_dropOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_DROP_OVERRUN_DELTA_AVG = "adaptor_MenloEthStats_dropOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_DROP_OVERRUN_DELTA_MAX = "adaptor_MenloEthStats_dropOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_DROP_OVERRUN_DELTA_MIN = "adaptor_MenloEthStats_dropOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_DROP_RUNT = "adaptor_MenloEthStats_dropRunt"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_DROP_RUNT_DELTA = "adaptor_MenloEthStats_dropRuntDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_DROP_RUNT_DELTA_AVG = "adaptor_MenloEthStats_dropRuntDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_DROP_RUNT_DELTA_MAX = "adaptor_MenloEthStats_dropRuntDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_DROP_RUNT_DELTA_MIN = "adaptor_MenloEthStats_dropRuntDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_INTERVALS = "adaptor_MenloEthStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_MENLO_ETH_INDEX = "adaptor_MenloEthStats_menloEthIndex"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_NORMALIZED_TIME_COL = "adaptor_MenloEthStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_STATS_REPORTED = "adaptor_MenloEthStats_statsReported"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_SUSPECT = "adaptor_MenloEthStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_THRESHOLDED = "adaptor_MenloEthStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_TIME_COLLECTED = "adaptor_MenloEthStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_TRUNCATE_OVERRUN = "adaptor_MenloEthStats_truncateOverrun"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_TRUNCATE_OVERRUN_DELTA = "adaptor_MenloEthStats_truncateOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_TRUNCATE_OVERRUN_DELTA_AVG = "adaptor_MenloEthStats_truncateOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_TRUNCATE_OVERRUN_DELTA_MAX = "adaptor_MenloEthStats_truncateOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_TRUNCATE_OVERRUN_DELTA_MIN = "adaptor_MenloEthStats_truncateOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_ETH_STATS_UPDATE = "adaptor_MenloEthStats_update"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_CORRECTABLE_ERRORS = "adaptor_MenloFcErrorStatsHist_correctableErrors"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloFcErrorStatsHist_correctableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStatsHist_correctableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStatsHist_correctableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStatsHist_correctableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_ID = "adaptor_MenloFcErrorStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_MOST_RECENT = "adaptor_MenloFcErrorStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_POP_ERRORS = "adaptor_MenloFcErrorStatsHist_popErrors"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_POP_ERRORS_DELTA = "adaptor_MenloFcErrorStatsHist_popErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_POP_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStatsHist_popErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_POP_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStatsHist_popErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_POP_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStatsHist_popErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_PUSH_ERRORS = "adaptor_MenloFcErrorStatsHist_pushErrors"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_PUSH_ERRORS_DELTA = "adaptor_MenloFcErrorStatsHist_pushErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStatsHist_pushErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStatsHist_pushErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStatsHist_pushErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_SUSPECT = "adaptor_MenloFcErrorStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_THRESHOLDED = "adaptor_MenloFcErrorStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_TIME_COLLECTED = "adaptor_MenloFcErrorStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS = "adaptor_MenloFcErrorStatsHist_uncorrectableErrors"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloFcErrorStatsHist_uncorrectableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStatsHist_uncorrectableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStatsHist_uncorrectableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStatsHist_uncorrectableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_CORRECTABLE_ERRORS = "adaptor_MenloFcErrorStats_correctableErrors"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloFcErrorStats_correctableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStats_correctableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStats_correctableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStats_correctableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_INTERVALS = "adaptor_MenloFcErrorStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_MENLO_FC_INDEX = "adaptor_MenloFcErrorStats_menloFcIndex"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_NORMALIZED_TIME_COL = "adaptor_MenloFcErrorStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_POP_ERRORS = "adaptor_MenloFcErrorStats_popErrors"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_POP_ERRORS_DELTA = "adaptor_MenloFcErrorStats_popErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_POP_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStats_popErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_POP_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStats_popErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_POP_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStats_popErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_PUSH_ERRORS = "adaptor_MenloFcErrorStats_pushErrors"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_PUSH_ERRORS_DELTA = "adaptor_MenloFcErrorStats_pushErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStats_pushErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStats_pushErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStats_pushErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_STATS_REPORTED = "adaptor_MenloFcErrorStats_statsReported"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_SUSPECT = "adaptor_MenloFcErrorStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_THRESHOLDED = "adaptor_MenloFcErrorStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_TIME_COLLECTED = "adaptor_MenloFcErrorStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_UNCORRECTABLE_ERRORS = "adaptor_MenloFcErrorStats_uncorrectableErrors"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloFcErrorStats_uncorrectableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloFcErrorStats_uncorrectableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloFcErrorStats_uncorrectableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloFcErrorStats_uncorrectableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_ERROR_STATS_UPDATE = "adaptor_MenloFcErrorStats_update"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_ACL = "adaptor_MenloFcStatsHist_dropAcl"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_ACL_DELTA = "adaptor_MenloFcStatsHist_dropAclDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_ACL_DELTA_AVG = "adaptor_MenloFcStatsHist_dropAclDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_ACL_DELTA_MAX = "adaptor_MenloFcStatsHist_dropAclDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_ACL_DELTA_MIN = "adaptor_MenloFcStatsHist_dropAclDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_OVERRUN = "adaptor_MenloFcStatsHist_dropOverrun"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_OVERRUN_DELTA = "adaptor_MenloFcStatsHist_dropOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_OVERRUN_DELTA_AVG = "adaptor_MenloFcStatsHist_dropOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_OVERRUN_DELTA_MAX = "adaptor_MenloFcStatsHist_dropOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_OVERRUN_DELTA_MIN = "adaptor_MenloFcStatsHist_dropOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_RUNT = "adaptor_MenloFcStatsHist_dropRunt"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_RUNT_DELTA = "adaptor_MenloFcStatsHist_dropRuntDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_RUNT_DELTA_AVG = "adaptor_MenloFcStatsHist_dropRuntDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_RUNT_DELTA_MAX = "adaptor_MenloFcStatsHist_dropRuntDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_DROP_RUNT_DELTA_MIN = "adaptor_MenloFcStatsHist_dropRuntDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_ID = "adaptor_MenloFcStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_MOST_RECENT = "adaptor_MenloFcStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_SUSPECT = "adaptor_MenloFcStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_THRESHOLDED = "adaptor_MenloFcStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_TIME_COLLECTED = "adaptor_MenloFcStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_TRUNCATE_OVERRUN = "adaptor_MenloFcStatsHist_truncateOverrun"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_TRUNCATE_OVERRUN_DELTA = "adaptor_MenloFcStatsHist_truncateOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_TRUNCATE_OVERRUN_DELTA_AVG = "adaptor_MenloFcStatsHist_truncateOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_TRUNCATE_OVERRUN_DELTA_MAX = "adaptor_MenloFcStatsHist_truncateOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_HIST_TRUNCATE_OVERRUN_DELTA_MIN = "adaptor_MenloFcStatsHist_truncateOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_ACL = "adaptor_MenloFcStats_dropAcl"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_ACL_DELTA = "adaptor_MenloFcStats_dropAclDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_ACL_DELTA_AVG = "adaptor_MenloFcStats_dropAclDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_ACL_DELTA_MAX = "adaptor_MenloFcStats_dropAclDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_ACL_DELTA_MIN = "adaptor_MenloFcStats_dropAclDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_OVERRUN = "adaptor_MenloFcStats_dropOverrun"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_OVERRUN_DELTA = "adaptor_MenloFcStats_dropOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_OVERRUN_DELTA_AVG = "adaptor_MenloFcStats_dropOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_OVERRUN_DELTA_MAX = "adaptor_MenloFcStats_dropOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_OVERRUN_DELTA_MIN = "adaptor_MenloFcStats_dropOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_RUNT = "adaptor_MenloFcStats_dropRunt"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_RUNT_DELTA = "adaptor_MenloFcStats_dropRuntDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_RUNT_DELTA_AVG = "adaptor_MenloFcStats_dropRuntDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_RUNT_DELTA_MAX = "adaptor_MenloFcStats_dropRuntDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_DROP_RUNT_DELTA_MIN = "adaptor_MenloFcStats_dropRuntDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_INTERVALS = "adaptor_MenloFcStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_MENLO_FC_INDEX = "adaptor_MenloFcStats_menloFcIndex"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_NORMALIZED_TIME_COL = "adaptor_MenloFcStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_STATS_REPORTED = "adaptor_MenloFcStats_statsReported"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_SUSPECT = "adaptor_MenloFcStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_THRESHOLDED = "adaptor_MenloFcStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_TIME_COLLECTED = "adaptor_MenloFcStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_TRUNCATE_OVERRUN = "adaptor_MenloFcStats_truncateOverrun"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_TRUNCATE_OVERRUN_DELTA = "adaptor_MenloFcStats_truncateOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_TRUNCATE_OVERRUN_DELTA_AVG = "adaptor_MenloFcStats_truncateOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_TRUNCATE_OVERRUN_DELTA_MAX = "adaptor_MenloFcStats_truncateOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_TRUNCATE_OVERRUN_DELTA_MIN = "adaptor_MenloFcStats_truncateOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_FC_STATS_UPDATE = "adaptor_MenloFcStats_update"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_ID = "adaptor_MenloHostPortStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_MOST_RECENT = "adaptor_MenloHostPortStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_CFC = "adaptor_MenloHostPortStatsHist_rxPauseCFC"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_CFCDELTA = "adaptor_MenloHostPortStatsHist_rxPauseCFCDelta"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_CFCDELTA_AVG = "adaptor_MenloHostPortStatsHist_rxPauseCFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_CFCDELTA_MAX = "adaptor_MenloHostPortStatsHist_rxPauseCFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_CFCDELTA_MIN = "adaptor_MenloHostPortStatsHist_rxPauseCFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_PFC = "adaptor_MenloHostPortStatsHist_rxPausePFC"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_PFCDELTA = "adaptor_MenloHostPortStatsHist_rxPausePFCDelta"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_PFCDELTA_AVG = "adaptor_MenloHostPortStatsHist_rxPausePFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_PFCDELTA_MAX = "adaptor_MenloHostPortStatsHist_rxPausePFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_RX_PAUSE_PFCDELTA_MIN = "adaptor_MenloHostPortStatsHist_rxPausePFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_SUSPECT = "adaptor_MenloHostPortStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_THRESHOLDED = "adaptor_MenloHostPortStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TIME_COLLECTED = "adaptor_MenloHostPortStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_CFC = "adaptor_MenloHostPortStatsHist_txPauseCFC"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_CFCDELTA = "adaptor_MenloHostPortStatsHist_txPauseCFCDelta"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_CFCDELTA_AVG = "adaptor_MenloHostPortStatsHist_txPauseCFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_CFCDELTA_MAX = "adaptor_MenloHostPortStatsHist_txPauseCFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_CFCDELTA_MIN = "adaptor_MenloHostPortStatsHist_txPauseCFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_PFC = "adaptor_MenloHostPortStatsHist_txPausePFC"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_PFCDELTA = "adaptor_MenloHostPortStatsHist_txPausePFCDelta"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_PFCDELTA_AVG = "adaptor_MenloHostPortStatsHist_txPausePFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_PFCDELTA_MAX = "adaptor_MenloHostPortStatsHist_txPausePFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_HIST_TX_PAUSE_PFCDELTA_MIN = "adaptor_MenloHostPortStatsHist_txPausePFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_INTERVALS = "adaptor_MenloHostPortStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_MENLO_PORT_INDEX = "adaptor_MenloHostPortStats_menloPortIndex"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_NORMALIZED_TIME_COL = "adaptor_MenloHostPortStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_CFC = "adaptor_MenloHostPortStats_rxPauseCFC"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_CFCDELTA = "adaptor_MenloHostPortStats_rxPauseCFCDelta"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_CFCDELTA_AVG = "adaptor_MenloHostPortStats_rxPauseCFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_CFCDELTA_MAX = "adaptor_MenloHostPortStats_rxPauseCFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_CFCDELTA_MIN = "adaptor_MenloHostPortStats_rxPauseCFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_PFC = "adaptor_MenloHostPortStats_rxPausePFC"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_PFCDELTA = "adaptor_MenloHostPortStats_rxPausePFCDelta"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_PFCDELTA_AVG = "adaptor_MenloHostPortStats_rxPausePFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_PFCDELTA_MAX = "adaptor_MenloHostPortStats_rxPausePFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_RX_PAUSE_PFCDELTA_MIN = "adaptor_MenloHostPortStats_rxPausePFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_STATS_REPORTED = "adaptor_MenloHostPortStats_statsReported"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_SUSPECT = "adaptor_MenloHostPortStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_THRESHOLDED = "adaptor_MenloHostPortStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TIME_COLLECTED = "adaptor_MenloHostPortStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_CFC = "adaptor_MenloHostPortStats_txPauseCFC"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_CFCDELTA = "adaptor_MenloHostPortStats_txPauseCFCDelta"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_CFCDELTA_AVG = "adaptor_MenloHostPortStats_txPauseCFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_CFCDELTA_MAX = "adaptor_MenloHostPortStats_txPauseCFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_CFCDELTA_MIN = "adaptor_MenloHostPortStats_txPauseCFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_PFC = "adaptor_MenloHostPortStats_txPausePFC"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_PFCDELTA = "adaptor_MenloHostPortStats_txPausePFCDelta"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_PFCDELTA_AVG = "adaptor_MenloHostPortStats_txPausePFCDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_PFCDELTA_MAX = "adaptor_MenloHostPortStats_txPausePFCDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_TX_PAUSE_PFCDELTA_MIN = "adaptor_MenloHostPortStats_txPausePFCDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_HOST_PORT_STATS_UPDATE = "adaptor_MenloHostPortStats_update"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_CORRECTABLE_ERRORS = "adaptor_MenloMcpuErrorStatsHist_correctableErrors"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloMcpuErrorStatsHist_correctableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStatsHist_correctableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStatsHist_correctableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStatsHist_correctableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_ID = "adaptor_MenloMcpuErrorStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_MOST_RECENT = "adaptor_MenloMcpuErrorStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_POP_ERRORS = "adaptor_MenloMcpuErrorStatsHist_popErrors"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_POP_ERRORS_DELTA = "adaptor_MenloMcpuErrorStatsHist_popErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_POP_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStatsHist_popErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_POP_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStatsHist_popErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_POP_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStatsHist_popErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_PUSH_ERRORS = "adaptor_MenloMcpuErrorStatsHist_pushErrors"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_PUSH_ERRORS_DELTA = "adaptor_MenloMcpuErrorStatsHist_pushErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStatsHist_pushErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStatsHist_pushErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStatsHist_pushErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_SUSPECT = "adaptor_MenloMcpuErrorStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_THRESHOLDED = "adaptor_MenloMcpuErrorStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_TIME_COLLECTED = "adaptor_MenloMcpuErrorStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS = "adaptor_MenloMcpuErrorStatsHist_uncorrectableErrors"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloMcpuErrorStatsHist_uncorrectableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStatsHist_uncorrectableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStatsHist_uncorrectableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStatsHist_uncorrectableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_CORRECTABLE_ERRORS = "adaptor_MenloMcpuErrorStats_correctableErrors"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloMcpuErrorStats_correctableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStats_correctableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStats_correctableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStats_correctableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_INTERVALS = "adaptor_MenloMcpuErrorStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_MENLO_MCPU_INDEX = "adaptor_MenloMcpuErrorStats_menloMcpuIndex"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_NORMALIZED_TIME_COL = "adaptor_MenloMcpuErrorStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_POP_ERRORS = "adaptor_MenloMcpuErrorStats_popErrors"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_POP_ERRORS_DELTA = "adaptor_MenloMcpuErrorStats_popErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_POP_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStats_popErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_POP_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStats_popErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_POP_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStats_popErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_PUSH_ERRORS = "adaptor_MenloMcpuErrorStats_pushErrors"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_PUSH_ERRORS_DELTA = "adaptor_MenloMcpuErrorStats_pushErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStats_pushErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStats_pushErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStats_pushErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_STATS_REPORTED = "adaptor_MenloMcpuErrorStats_statsReported"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_SUSPECT = "adaptor_MenloMcpuErrorStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_THRESHOLDED = "adaptor_MenloMcpuErrorStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_TIME_COLLECTED = "adaptor_MenloMcpuErrorStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_UNCORRECTABLE_ERRORS = "adaptor_MenloMcpuErrorStats_uncorrectableErrors"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloMcpuErrorStats_uncorrectableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloMcpuErrorStats_uncorrectableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloMcpuErrorStats_uncorrectableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloMcpuErrorStats_uncorrectableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_ERROR_STATS_UPDATE = "adaptor_MenloMcpuErrorStats_update"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_ACL = "adaptor_MenloMcpuStatsHist_dropAcl"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_ACL_DELTA = "adaptor_MenloMcpuStatsHist_dropAclDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_ACL_DELTA_AVG = "adaptor_MenloMcpuStatsHist_dropAclDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_ACL_DELTA_MAX = "adaptor_MenloMcpuStatsHist_dropAclDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_ACL_DELTA_MIN = "adaptor_MenloMcpuStatsHist_dropAclDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_OVERRUN = "adaptor_MenloMcpuStatsHist_dropOverrun"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_OVERRUN_DELTA = "adaptor_MenloMcpuStatsHist_dropOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_OVERRUN_DELTA_AVG = "adaptor_MenloMcpuStatsHist_dropOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_OVERRUN_DELTA_MAX = "adaptor_MenloMcpuStatsHist_dropOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_OVERRUN_DELTA_MIN = "adaptor_MenloMcpuStatsHist_dropOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_RUNT = "adaptor_MenloMcpuStatsHist_dropRunt"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_RUNT_DELTA = "adaptor_MenloMcpuStatsHist_dropRuntDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_RUNT_DELTA_AVG = "adaptor_MenloMcpuStatsHist_dropRuntDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_RUNT_DELTA_MAX = "adaptor_MenloMcpuStatsHist_dropRuntDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_DROP_RUNT_DELTA_MIN = "adaptor_MenloMcpuStatsHist_dropRuntDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_ID = "adaptor_MenloMcpuStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_MOST_RECENT = "adaptor_MenloMcpuStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_SUSPECT = "adaptor_MenloMcpuStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_THRESHOLDED = "adaptor_MenloMcpuStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_TIME_COLLECTED = "adaptor_MenloMcpuStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_TRUNCATE_OVERRUN = "adaptor_MenloMcpuStatsHist_truncateOverrun"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_TRUNCATE_OVERRUN_DELTA = "adaptor_MenloMcpuStatsHist_truncateOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_TRUNCATE_OVERRUN_DELTA_AVG = "adaptor_MenloMcpuStatsHist_truncateOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_TRUNCATE_OVERRUN_DELTA_MAX = "adaptor_MenloMcpuStatsHist_truncateOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_HIST_TRUNCATE_OVERRUN_DELTA_MIN = "adaptor_MenloMcpuStatsHist_truncateOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_ACL = "adaptor_MenloMcpuStats_dropAcl"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_ACL_DELTA = "adaptor_MenloMcpuStats_dropAclDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_ACL_DELTA_AVG = "adaptor_MenloMcpuStats_dropAclDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_ACL_DELTA_MAX = "adaptor_MenloMcpuStats_dropAclDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_ACL_DELTA_MIN = "adaptor_MenloMcpuStats_dropAclDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_OVERRUN = "adaptor_MenloMcpuStats_dropOverrun"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_OVERRUN_DELTA = "adaptor_MenloMcpuStats_dropOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_OVERRUN_DELTA_AVG = "adaptor_MenloMcpuStats_dropOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_OVERRUN_DELTA_MAX = "adaptor_MenloMcpuStats_dropOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_OVERRUN_DELTA_MIN = "adaptor_MenloMcpuStats_dropOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_RUNT = "adaptor_MenloMcpuStats_dropRunt"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_RUNT_DELTA = "adaptor_MenloMcpuStats_dropRuntDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_RUNT_DELTA_AVG = "adaptor_MenloMcpuStats_dropRuntDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_RUNT_DELTA_MAX = "adaptor_MenloMcpuStats_dropRuntDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_DROP_RUNT_DELTA_MIN = "adaptor_MenloMcpuStats_dropRuntDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_INTERVALS = "adaptor_MenloMcpuStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_MENLO_MCPU_INDEX = "adaptor_MenloMcpuStats_menloMcpuIndex"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_NORMALIZED_TIME_COL = "adaptor_MenloMcpuStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_STATS_REPORTED = "adaptor_MenloMcpuStats_statsReported"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_SUSPECT = "adaptor_MenloMcpuStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_THRESHOLDED = "adaptor_MenloMcpuStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_TIME_COLLECTED = "adaptor_MenloMcpuStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_TRUNCATE_OVERRUN = "adaptor_MenloMcpuStats_truncateOverrun"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_TRUNCATE_OVERRUN_DELTA = "adaptor_MenloMcpuStats_truncateOverrunDelta"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_TRUNCATE_OVERRUN_DELTA_AVG = "adaptor_MenloMcpuStats_truncateOverrunDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_TRUNCATE_OVERRUN_DELTA_MAX = "adaptor_MenloMcpuStats_truncateOverrunDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_TRUNCATE_OVERRUN_DELTA_MIN = "adaptor_MenloMcpuStats_truncateOverrunDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_MCPU_STATS_UPDATE = "adaptor_MenloMcpuStats_update"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_CMD = "adaptor_MenloNetEgStatsHist_dropCmd"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_CMD_DELTA = "adaptor_MenloNetEgStatsHist_dropCmdDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_CMD_DELTA_AVG = "adaptor_MenloNetEgStatsHist_dropCmdDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_CMD_DELTA_MAX = "adaptor_MenloNetEgStatsHist_dropCmdDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_CMD_DELTA_MIN = "adaptor_MenloNetEgStatsHist_dropCmdDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_CFG_INVALID = "adaptor_MenloNetEgStatsHist_dropLifCfgInvalid"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_CFG_INVALID_DELTA = "adaptor_MenloNetEgStatsHist_dropLifCfgInvalidDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_CFG_INVALID_DELTA_AVG = "adaptor_MenloNetEgStatsHist_dropLifCfgInvalidDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_CFG_INVALID_DELTA_MAX = "adaptor_MenloNetEgStatsHist_dropLifCfgInvalidDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_CFG_INVALID_DELTA_MIN = "adaptor_MenloNetEgStatsHist_dropLifCfgInvalidDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_MAP_NO_HIT = "adaptor_MenloNetEgStatsHist_dropLifMapNoHit"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_MAP_NO_HIT_DELTA = "adaptor_MenloNetEgStatsHist_dropLifMapNoHitDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_MAP_NO_HIT_DELTA_AVG = "adaptor_MenloNetEgStatsHist_dropLifMapNoHitDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_MAP_NO_HIT_DELTA_MAX = "adaptor_MenloNetEgStatsHist_dropLifMapNoHitDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_LIF_MAP_NO_HIT_DELTA_MIN = "adaptor_MenloNetEgStatsHist_dropLifMapNoHitDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_SRC_BIND = "adaptor_MenloNetEgStatsHist_dropSrcBind"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_SRC_BIND_DELTA = "adaptor_MenloNetEgStatsHist_dropSrcBindDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_SRC_BIND_DELTA_AVG = "adaptor_MenloNetEgStatsHist_dropSrcBindDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_SRC_BIND_DELTA_MAX = "adaptor_MenloNetEgStatsHist_dropSrcBindDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_DROP_SRC_BIND_DELTA_MIN = "adaptor_MenloNetEgStatsHist_dropSrcBindDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_ID = "adaptor_MenloNetEgStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_LEARN_REQ_DROP = "adaptor_MenloNetEgStatsHist_learnReqDrop"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_LEARN_REQ_DROP_DELTA = "adaptor_MenloNetEgStatsHist_learnReqDropDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_LEARN_REQ_DROP_DELTA_AVG = "adaptor_MenloNetEgStatsHist_learnReqDropDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_LEARN_REQ_DROP_DELTA_MAX = "adaptor_MenloNetEgStatsHist_learnReqDropDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_LEARN_REQ_DROP_DELTA_MIN = "adaptor_MenloNetEgStatsHist_learnReqDropDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_MOST_RECENT = "adaptor_MenloNetEgStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_SUSPECT = "adaptor_MenloNetEgStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_THRESHOLDED = "adaptor_MenloNetEgStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_HIST_TIME_COLLECTED = "adaptor_MenloNetEgStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_CMD = "adaptor_MenloNetEgStats_dropCmd"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_CMD_DELTA = "adaptor_MenloNetEgStats_dropCmdDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_CMD_DELTA_AVG = "adaptor_MenloNetEgStats_dropCmdDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_CMD_DELTA_MAX = "adaptor_MenloNetEgStats_dropCmdDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_CMD_DELTA_MIN = "adaptor_MenloNetEgStats_dropCmdDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_CFG_INVALID = "adaptor_MenloNetEgStats_dropLifCfgInvalid"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_CFG_INVALID_DELTA = "adaptor_MenloNetEgStats_dropLifCfgInvalidDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_CFG_INVALID_DELTA_AVG = "adaptor_MenloNetEgStats_dropLifCfgInvalidDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_CFG_INVALID_DELTA_MAX = "adaptor_MenloNetEgStats_dropLifCfgInvalidDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_CFG_INVALID_DELTA_MIN = "adaptor_MenloNetEgStats_dropLifCfgInvalidDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_MAP_NO_HIT = "adaptor_MenloNetEgStats_dropLifMapNoHit"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_MAP_NO_HIT_DELTA = "adaptor_MenloNetEgStats_dropLifMapNoHitDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_MAP_NO_HIT_DELTA_AVG = "adaptor_MenloNetEgStats_dropLifMapNoHitDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_MAP_NO_HIT_DELTA_MAX = "adaptor_MenloNetEgStats_dropLifMapNoHitDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_LIF_MAP_NO_HIT_DELTA_MIN = "adaptor_MenloNetEgStats_dropLifMapNoHitDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_SRC_BIND = "adaptor_MenloNetEgStats_dropSrcBind"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_SRC_BIND_DELTA = "adaptor_MenloNetEgStats_dropSrcBindDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_SRC_BIND_DELTA_AVG = "adaptor_MenloNetEgStats_dropSrcBindDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_SRC_BIND_DELTA_MAX = "adaptor_MenloNetEgStats_dropSrcBindDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_DROP_SRC_BIND_DELTA_MIN = "adaptor_MenloNetEgStats_dropSrcBindDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_INTERVALS = "adaptor_MenloNetEgStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_LEARN_REQ_DROP = "adaptor_MenloNetEgStats_learnReqDrop"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_LEARN_REQ_DROP_DELTA = "adaptor_MenloNetEgStats_learnReqDropDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_LEARN_REQ_DROP_DELTA_AVG = "adaptor_MenloNetEgStats_learnReqDropDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_LEARN_REQ_DROP_DELTA_MAX = "adaptor_MenloNetEgStats_learnReqDropDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_LEARN_REQ_DROP_DELTA_MIN = "adaptor_MenloNetEgStats_learnReqDropDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_MENLO_NET_INDEX = "adaptor_MenloNetEgStats_menloNetIndex"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_NORMALIZED_TIME_COL = "adaptor_MenloNetEgStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_STATS_REPORTED = "adaptor_MenloNetEgStats_statsReported"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_SUSPECT = "adaptor_MenloNetEgStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_THRESHOLDED = "adaptor_MenloNetEgStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_TIME_COLLECTED = "adaptor_MenloNetEgStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_NET_EG_STATS_UPDATE = "adaptor_MenloNetEgStats_update"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_LIF_INVALID = "adaptor_MenloNetInStatsHist_dropFcLifInvalid"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_LIF_INVALID_DELTA = "adaptor_MenloNetInStatsHist_dropFcLifInvalidDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_LIF_INVALID_DELTA_AVG = "adaptor_MenloNetInStatsHist_dropFcLifInvalidDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_LIF_INVALID_DELTA_MAX = "adaptor_MenloNetInStatsHist_dropFcLifInvalidDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_LIF_INVALID_DELTA_MIN = "adaptor_MenloNetInStatsHist_dropFcLifInvalidDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_MULTICAST = "adaptor_MenloNetInStatsHist_dropFcMulticast"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_MULTICAST_DELTA = "adaptor_MenloNetInStatsHist_dropFcMulticastDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_MULTICAST_DELTA_AVG = "adaptor_MenloNetInStatsHist_dropFcMulticastDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_MULTICAST_DELTA_MAX = "adaptor_MenloNetInStatsHist_dropFcMulticastDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_FC_MULTICAST_DELTA_MIN = "adaptor_MenloNetInStatsHist_dropFcMulticastDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_NULL_PIF = "adaptor_MenloNetInStatsHist_dropNullPif"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_NULL_PIF_DELTA = "adaptor_MenloNetInStatsHist_dropNullPifDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_NULL_PIF_DELTA_AVG = "adaptor_MenloNetInStatsHist_dropNullPifDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_NULL_PIF_DELTA_MAX = "adaptor_MenloNetInStatsHist_dropNullPifDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_DROP_NULL_PIF_DELTA_MIN = "adaptor_MenloNetInStatsHist_dropNullPifDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_FWD_LOOKUP_NO_HIT = "adaptor_MenloNetInStatsHist_fwdLookupNoHit"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_FWD_LOOKUP_NO_HIT_DELTA = "adaptor_MenloNetInStatsHist_fwdLookupNoHitDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_FWD_LOOKUP_NO_HIT_DELTA_AVG = "adaptor_MenloNetInStatsHist_fwdLookupNoHitDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_FWD_LOOKUP_NO_HIT_DELTA_MAX = "adaptor_MenloNetInStatsHist_fwdLookupNoHitDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_FWD_LOOKUP_NO_HIT_DELTA_MIN = "adaptor_MenloNetInStatsHist_fwdLookupNoHitDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_ID = "adaptor_MenloNetInStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_MOST_RECENT = "adaptor_MenloNetInStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_SUSPECT = "adaptor_MenloNetInStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_THRESHOLDED = "adaptor_MenloNetInStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_HIST_TIME_COLLECTED = "adaptor_MenloNetInStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_LIF_INVALID = "adaptor_MenloNetInStats_dropFcLifInvalid"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_LIF_INVALID_DELTA = "adaptor_MenloNetInStats_dropFcLifInvalidDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_LIF_INVALID_DELTA_AVG = "adaptor_MenloNetInStats_dropFcLifInvalidDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_LIF_INVALID_DELTA_MAX = "adaptor_MenloNetInStats_dropFcLifInvalidDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_LIF_INVALID_DELTA_MIN = "adaptor_MenloNetInStats_dropFcLifInvalidDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_MULTICAST = "adaptor_MenloNetInStats_dropFcMulticast"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_MULTICAST_DELTA = "adaptor_MenloNetInStats_dropFcMulticastDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_MULTICAST_DELTA_AVG = "adaptor_MenloNetInStats_dropFcMulticastDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_MULTICAST_DELTA_MAX = "adaptor_MenloNetInStats_dropFcMulticastDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_FC_MULTICAST_DELTA_MIN = "adaptor_MenloNetInStats_dropFcMulticastDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_NULL_PIF = "adaptor_MenloNetInStats_dropNullPif"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_NULL_PIF_DELTA = "adaptor_MenloNetInStats_dropNullPifDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_NULL_PIF_DELTA_AVG = "adaptor_MenloNetInStats_dropNullPifDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_NULL_PIF_DELTA_MAX = "adaptor_MenloNetInStats_dropNullPifDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_DROP_NULL_PIF_DELTA_MIN = "adaptor_MenloNetInStats_dropNullPifDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_FWD_LOOKUP_NO_HIT = "adaptor_MenloNetInStats_fwdLookupNoHit"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_FWD_LOOKUP_NO_HIT_DELTA = "adaptor_MenloNetInStats_fwdLookupNoHitDelta"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_FWD_LOOKUP_NO_HIT_DELTA_AVG = "adaptor_MenloNetInStats_fwdLookupNoHitDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_FWD_LOOKUP_NO_HIT_DELTA_MAX = "adaptor_MenloNetInStats_fwdLookupNoHitDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_FWD_LOOKUP_NO_HIT_DELTA_MIN = "adaptor_MenloNetInStats_fwdLookupNoHitDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_INTERVALS = "adaptor_MenloNetInStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_MENLO_NET_INDEX = "adaptor_MenloNetInStats_menloNetIndex"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_NORMALIZED_TIME_COL = "adaptor_MenloNetInStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_STATS_REPORTED = "adaptor_MenloNetInStats_statsReported"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_SUSPECT = "adaptor_MenloNetInStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_THRESHOLDED = "adaptor_MenloNetInStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_TIME_COLLECTED = "adaptor_MenloNetInStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_NET_IN_STATS_UPDATE = "adaptor_MenloNetInStats_update"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_CORRECTABLE_ERRORS = "adaptor_MenloQErrorStatsHist_correctableErrors"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloQErrorStatsHist_correctableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStatsHist_correctableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStatsHist_correctableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStatsHist_correctableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_ID = "adaptor_MenloQErrorStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_MOST_RECENT = "adaptor_MenloQErrorStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_POP_ERRORS = "adaptor_MenloQErrorStatsHist_popErrors"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_POP_ERRORS_DELTA = "adaptor_MenloQErrorStatsHist_popErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_POP_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStatsHist_popErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_POP_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStatsHist_popErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_POP_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStatsHist_popErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_PUSH_ERRORS = "adaptor_MenloQErrorStatsHist_pushErrors"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_PUSH_ERRORS_DELTA = "adaptor_MenloQErrorStatsHist_pushErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStatsHist_pushErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStatsHist_pushErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStatsHist_pushErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_SUSPECT = "adaptor_MenloQErrorStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_THRESHOLDED = "adaptor_MenloQErrorStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_TIME_COLLECTED = "adaptor_MenloQErrorStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_UNCORRECTABLE_ERRORS = "adaptor_MenloQErrorStatsHist_uncorrectableErrors"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloQErrorStatsHist_uncorrectableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStatsHist_uncorrectableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStatsHist_uncorrectableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_HIST_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStatsHist_uncorrectableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_CORRECTABLE_ERRORS = "adaptor_MenloQErrorStats_correctableErrors"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_CORRECTABLE_ERRORS_DELTA = "adaptor_MenloQErrorStats_correctableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_CORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStats_correctableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_CORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStats_correctableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_CORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStats_correctableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_INTERVALS = "adaptor_MenloQErrorStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_MENLO_QUEUE_COMPONENT = "adaptor_MenloQErrorStats_menloQueueComponent"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_MENLO_QUEUE_INDEX = "adaptor_MenloQErrorStats_menloQueueIndex"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_NORMALIZED_TIME_COL = "adaptor_MenloQErrorStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_POP_ERRORS = "adaptor_MenloQErrorStats_popErrors"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_POP_ERRORS_DELTA = "adaptor_MenloQErrorStats_popErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_POP_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStats_popErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_POP_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStats_popErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_POP_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStats_popErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_PUSH_ERRORS = "adaptor_MenloQErrorStats_pushErrors"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_PUSH_ERRORS_DELTA = "adaptor_MenloQErrorStats_pushErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_PUSH_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStats_pushErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_PUSH_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStats_pushErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_PUSH_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStats_pushErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_STATS_REPORTED = "adaptor_MenloQErrorStats_statsReported"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_SUSPECT = "adaptor_MenloQErrorStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_THRESHOLDED = "adaptor_MenloQErrorStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_TIME_COLLECTED = "adaptor_MenloQErrorStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_UNCORRECTABLE_ERRORS = "adaptor_MenloQErrorStats_uncorrectableErrors"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_UNCORRECTABLE_ERRORS_DELTA = "adaptor_MenloQErrorStats_uncorrectableErrorsDelta"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_AVG = "adaptor_MenloQErrorStats_uncorrectableErrorsDeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MAX = "adaptor_MenloQErrorStats_uncorrectableErrorsDeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_UNCORRECTABLE_ERRORS_DELTA_MIN = "adaptor_MenloQErrorStats_uncorrectableErrorsDeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QERROR_STATS_UPDATE = "adaptor_MenloQErrorStats_update"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N0 = "adaptor_MenloQStatsHist_dropOverrunN0"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N0_DELTA = "adaptor_MenloQStatsHist_dropOverrunN0Delta"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N0_DELTA_AVG = "adaptor_MenloQStatsHist_dropOverrunN0DeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N0_DELTA_MAX = "adaptor_MenloQStatsHist_dropOverrunN0DeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N0_DELTA_MIN = "adaptor_MenloQStatsHist_dropOverrunN0DeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N1 = "adaptor_MenloQStatsHist_dropOverrunN1"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N1_DELTA = "adaptor_MenloQStatsHist_dropOverrunN1Delta"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N1_DELTA_AVG = "adaptor_MenloQStatsHist_dropOverrunN1DeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N1_DELTA_MAX = "adaptor_MenloQStatsHist_dropOverrunN1DeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_DROP_OVERRUN_N1_DELTA_MIN = "adaptor_MenloQStatsHist_dropOverrunN1DeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_ID = "adaptor_MenloQStatsHist_id"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_MOST_RECENT = "adaptor_MenloQStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_SUSPECT = "adaptor_MenloQStatsHist_suspect"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_THRESHOLDED = "adaptor_MenloQStatsHist_thresholded"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TIME_COLLECTED = "adaptor_MenloQStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N0 = "adaptor_MenloQStatsHist_truncateOverrunN0"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N0_DELTA = "adaptor_MenloQStatsHist_truncateOverrunN0Delta"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N0_DELTA_AVG = "adaptor_MenloQStatsHist_truncateOverrunN0DeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N0_DELTA_MAX = "adaptor_MenloQStatsHist_truncateOverrunN0DeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N0_DELTA_MIN = "adaptor_MenloQStatsHist_truncateOverrunN0DeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N1 = "adaptor_MenloQStatsHist_truncateOverrunN1"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N1_DELTA = "adaptor_MenloQStatsHist_truncateOverrunN1Delta"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N1_DELTA_AVG = "adaptor_MenloQStatsHist_truncateOverrunN1DeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N1_DELTA_MAX = "adaptor_MenloQStatsHist_truncateOverrunN1DeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_HIST_TRUNCATE_OVERRUN_N1_DELTA_MIN = "adaptor_MenloQStatsHist_truncateOverrunN1DeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N0 = "adaptor_MenloQStats_dropOverrunN0"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N0_DELTA = "adaptor_MenloQStats_dropOverrunN0Delta"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N0_DELTA_AVG = "adaptor_MenloQStats_dropOverrunN0DeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N0_DELTA_MAX = "adaptor_MenloQStats_dropOverrunN0DeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N0_DELTA_MIN = "adaptor_MenloQStats_dropOverrunN0DeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N1 = "adaptor_MenloQStats_dropOverrunN1"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N1_DELTA = "adaptor_MenloQStats_dropOverrunN1Delta"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N1_DELTA_AVG = "adaptor_MenloQStats_dropOverrunN1DeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N1_DELTA_MAX = "adaptor_MenloQStats_dropOverrunN1DeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_DROP_OVERRUN_N1_DELTA_MIN = "adaptor_MenloQStats_dropOverrunN1DeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_INTERVALS = "adaptor_MenloQStats_intervals"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_MENLO_QUEUE_COMPONENT = "adaptor_MenloQStats_menloQueueComponent"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_MENLO_QUEUE_INDEX = "adaptor_MenloQStats_menloQueueIndex"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_NORMALIZED_TIME_COL = "adaptor_MenloQStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_STATS_REPORTED = "adaptor_MenloQStats_statsReported"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_SUSPECT = "adaptor_MenloQStats_suspect"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_THRESHOLDED = "adaptor_MenloQStats_thresholded"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TIME_COLLECTED = "adaptor_MenloQStats_timeCollected"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N0 = "adaptor_MenloQStats_truncateOverrunN0"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N0_DELTA = "adaptor_MenloQStats_truncateOverrunN0Delta"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N0_DELTA_AVG = "adaptor_MenloQStats_truncateOverrunN0DeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N0_DELTA_MAX = "adaptor_MenloQStats_truncateOverrunN0DeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N0_DELTA_MIN = "adaptor_MenloQStats_truncateOverrunN0DeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N1 = "adaptor_MenloQStats_truncateOverrunN1"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N1_DELTA = "adaptor_MenloQStats_truncateOverrunN1Delta"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N1_DELTA_AVG = "adaptor_MenloQStats_truncateOverrunN1DeltaAvg"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N1_DELTA_MAX = "adaptor_MenloQStats_truncateOverrunN1DeltaMax"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_TRUNCATE_OVERRUN_N1_DELTA_MIN = "adaptor_MenloQStats_truncateOverrunN1DeltaMin"
    SORT_PROP_ADAPTOR_MENLO_QSTATS_UPDATE = "adaptor_MenloQStats_update"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_BYTES_RX = "adaptor_NICVnicStatsHist_bytesRx"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_BYTES_RX_DELTA = "adaptor_NICVnicStatsHist_bytesRxDelta"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_BYTES_RX_DELTA_AVG = "adaptor_NICVnicStatsHist_bytesRxDeltaAvg"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_BYTES_RX_DELTA_MAX = "adaptor_NICVnicStatsHist_bytesRxDeltaMax"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_BYTES_RX_DELTA_MIN = "adaptor_NICVnicStatsHist_bytesRxDeltaMin"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_BYTES_TX = "adaptor_NICVnicStatsHist_bytesTx"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_BYTES_TX_DELTA = "adaptor_NICVnicStatsHist_bytesTxDelta"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_BYTES_TX_DELTA_AVG = "adaptor_NICVnicStatsHist_bytesTxDeltaAvg"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_BYTES_TX_DELTA_MAX = "adaptor_NICVnicStatsHist_bytesTxDeltaMax"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_BYTES_TX_DELTA_MIN = "adaptor_NICVnicStatsHist_bytesTxDeltaMin"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_DROPPED_RX = "adaptor_NICVnicStatsHist_droppedRx"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_DROPPED_RX_DELTA = "adaptor_NICVnicStatsHist_droppedRxDelta"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_DROPPED_RX_DELTA_AVG = "adaptor_NICVnicStatsHist_droppedRxDeltaAvg"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_DROPPED_RX_DELTA_MAX = "adaptor_NICVnicStatsHist_droppedRxDeltaMax"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_DROPPED_RX_DELTA_MIN = "adaptor_NICVnicStatsHist_droppedRxDeltaMin"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_DROPPED_TX = "adaptor_NICVnicStatsHist_droppedTx"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_DROPPED_TX_DELTA = "adaptor_NICVnicStatsHist_droppedTxDelta"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_DROPPED_TX_DELTA_AVG = "adaptor_NICVnicStatsHist_droppedTxDeltaAvg"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_DROPPED_TX_DELTA_MAX = "adaptor_NICVnicStatsHist_droppedTxDeltaMax"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_DROPPED_TX_DELTA_MIN = "adaptor_NICVnicStatsHist_droppedTxDeltaMin"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_ERRORS_RX = "adaptor_NICVnicStatsHist_errorsRx"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_ERRORS_RX_DELTA = "adaptor_NICVnicStatsHist_errorsRxDelta"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_ERRORS_RX_DELTA_AVG = "adaptor_NICVnicStatsHist_errorsRxDeltaAvg"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_ERRORS_RX_DELTA_MAX = "adaptor_NICVnicStatsHist_errorsRxDeltaMax"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_ERRORS_RX_DELTA_MIN = "adaptor_NICVnicStatsHist_errorsRxDeltaMin"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_ERRORS_TX = "adaptor_NICVnicStatsHist_errorsTx"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_ERRORS_TX_DELTA = "adaptor_NICVnicStatsHist_errorsTxDelta"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_ERRORS_TX_DELTA_AVG = "adaptor_NICVnicStatsHist_errorsTxDeltaAvg"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_ERRORS_TX_DELTA_MAX = "adaptor_NICVnicStatsHist_errorsTxDeltaMax"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_ERRORS_TX_DELTA_MIN = "adaptor_NICVnicStatsHist_errorsTxDeltaMin"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_ID = "adaptor_NICVnicStatsHist_id"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_MOST_RECENT = "adaptor_NICVnicStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_PACKETS_RX = "adaptor_NICVnicStatsHist_packetsRx"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_PACKETS_RX_DELTA = "adaptor_NICVnicStatsHist_packetsRxDelta"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_PACKETS_RX_DELTA_AVG = "adaptor_NICVnicStatsHist_packetsRxDeltaAvg"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_PACKETS_RX_DELTA_MAX = "adaptor_NICVnicStatsHist_packetsRxDeltaMax"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_PACKETS_RX_DELTA_MIN = "adaptor_NICVnicStatsHist_packetsRxDeltaMin"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_PACKETS_TX = "adaptor_NICVnicStatsHist_packetsTx"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_PACKETS_TX_DELTA = "adaptor_NICVnicStatsHist_packetsTxDelta"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_PACKETS_TX_DELTA_AVG = "adaptor_NICVnicStatsHist_packetsTxDeltaAvg"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_PACKETS_TX_DELTA_MAX = "adaptor_NICVnicStatsHist_packetsTxDeltaMax"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_PACKETS_TX_DELTA_MIN = "adaptor_NICVnicStatsHist_packetsTxDeltaMin"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_SUSPECT = "adaptor_NICVnicStatsHist_suspect"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_THRESHOLDED = "adaptor_NICVnicStatsHist_thresholded"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_HIST_TIME_COLLECTED = "adaptor_NICVnicStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_BYTES_RX = "adaptor_NICVnicStats_bytesRx"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_BYTES_RX_DELTA = "adaptor_NICVnicStats_bytesRxDelta"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_BYTES_RX_DELTA_AVG = "adaptor_NICVnicStats_bytesRxDeltaAvg"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_BYTES_RX_DELTA_MAX = "adaptor_NICVnicStats_bytesRxDeltaMax"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_BYTES_RX_DELTA_MIN = "adaptor_NICVnicStats_bytesRxDeltaMin"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_BYTES_TX = "adaptor_NICVnicStats_bytesTx"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_BYTES_TX_DELTA = "adaptor_NICVnicStats_bytesTxDelta"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_BYTES_TX_DELTA_AVG = "adaptor_NICVnicStats_bytesTxDeltaAvg"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_BYTES_TX_DELTA_MAX = "adaptor_NICVnicStats_bytesTxDeltaMax"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_BYTES_TX_DELTA_MIN = "adaptor_NICVnicStats_bytesTxDeltaMin"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_DROPPED_RX = "adaptor_NICVnicStats_droppedRx"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_DROPPED_RX_DELTA = "adaptor_NICVnicStats_droppedRxDelta"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_DROPPED_RX_DELTA_AVG = "adaptor_NICVnicStats_droppedRxDeltaAvg"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_DROPPED_RX_DELTA_MAX = "adaptor_NICVnicStats_droppedRxDeltaMax"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_DROPPED_RX_DELTA_MIN = "adaptor_NICVnicStats_droppedRxDeltaMin"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_DROPPED_TX = "adaptor_NICVnicStats_droppedTx"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_DROPPED_TX_DELTA = "adaptor_NICVnicStats_droppedTxDelta"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_DROPPED_TX_DELTA_AVG = "adaptor_NICVnicStats_droppedTxDeltaAvg"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_DROPPED_TX_DELTA_MAX = "adaptor_NICVnicStats_droppedTxDeltaMax"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_DROPPED_TX_DELTA_MIN = "adaptor_NICVnicStats_droppedTxDeltaMin"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_ERRORS_RX = "adaptor_NICVnicStats_errorsRx"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_ERRORS_RX_DELTA = "adaptor_NICVnicStats_errorsRxDelta"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_ERRORS_RX_DELTA_AVG = "adaptor_NICVnicStats_errorsRxDeltaAvg"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_ERRORS_RX_DELTA_MAX = "adaptor_NICVnicStats_errorsRxDeltaMax"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_ERRORS_RX_DELTA_MIN = "adaptor_NICVnicStats_errorsRxDeltaMin"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_ERRORS_TX = "adaptor_NICVnicStats_errorsTx"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_ERRORS_TX_DELTA = "adaptor_NICVnicStats_errorsTxDelta"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_ERRORS_TX_DELTA_AVG = "adaptor_NICVnicStats_errorsTxDeltaAvg"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_ERRORS_TX_DELTA_MAX = "adaptor_NICVnicStats_errorsTxDeltaMax"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_ERRORS_TX_DELTA_MIN = "adaptor_NICVnicStats_errorsTxDeltaMin"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_INTERVALS = "adaptor_NICVnicStats_intervals"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_NORMALIZED_TIME_COL = "adaptor_NICVnicStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_PACKETS_RX = "adaptor_NICVnicStats_packetsRx"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_PACKETS_RX_DELTA = "adaptor_NICVnicStats_packetsRxDelta"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_PACKETS_RX_DELTA_AVG = "adaptor_NICVnicStats_packetsRxDeltaAvg"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_PACKETS_RX_DELTA_MAX = "adaptor_NICVnicStats_packetsRxDeltaMax"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_PACKETS_RX_DELTA_MIN = "adaptor_NICVnicStats_packetsRxDeltaMin"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_PACKETS_TX = "adaptor_NICVnicStats_packetsTx"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_PACKETS_TX_DELTA = "adaptor_NICVnicStats_packetsTxDelta"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_PACKETS_TX_DELTA_AVG = "adaptor_NICVnicStats_packetsTxDeltaAvg"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_PACKETS_TX_DELTA_MAX = "adaptor_NICVnicStats_packetsTxDeltaMax"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_PACKETS_TX_DELTA_MIN = "adaptor_NICVnicStats_packetsTxDeltaMin"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_STATS_REPORTED = "adaptor_NICVnicStats_statsReported"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_SUSPECT = "adaptor_NICVnicStats_suspect"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_THRESHOLDED = "adaptor_NICVnicStats_thresholded"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_TIME_COLLECTED = "adaptor_NICVnicStats_timeCollected"
    SORT_PROP_ADAPTOR_NICVNIC_STATS_UPDATE = "adaptor_NICVnicStats_update"
    SORT_PROP_ADAPTOR_PROTOCOL_PROFILE_BOOT_TO_TARGET = "adaptor_ProtocolProfile_bootToTarget"
    SORT_PROP_ADAPTOR_PROTOCOL_PROFILE_CONNECTION_TIME_OUT = "adaptor_ProtocolProfile_connectionTimeOut"
    SORT_PROP_ADAPTOR_PROTOCOL_PROFILE_DHCP_TIME_OUT = "adaptor_ProtocolProfile_dhcpTimeOut"
    SORT_PROP_ADAPTOR_PROTOCOL_PROFILE_HBA_MODE = "adaptor_ProtocolProfile_hbaMode"
    SORT_PROP_ADAPTOR_PROTOCOL_PROFILE_LUN_BUSY_RETRY_COUNT = "adaptor_ProtocolProfile_lunBusyRetryCount"
    SORT_PROP_ADAPTOR_PROTOCOL_PROFILE_TCP_TIME_STAMP = "adaptor_ProtocolProfile_tcpTimeStamp"
    SORT_PROP_ADAPTOR_QUEUE_PROFILE_COUNT = "adaptor_QueueProfile_count"
    SORT_PROP_ADAPTOR_QUEUE_PROFILE_RING_SIZE = "adaptor_QueueProfile_ringSize"
    SORT_PROP_ADAPTOR_RNIC_CAP_SPEC_FW_VERSION_HI = "adaptor_RnicCapSpec_fwVersionHi"
    SORT_PROP_ADAPTOR_RNIC_CAP_SPEC_FW_VERSION_LO = "adaptor_RnicCapSpec_fwVersionLo"
    SORT_PROP_ADAPTOR_RNIC_CAP_SPEC_FW_VERSION_OPR = "adaptor_RnicCapSpec_fwVersionOpr"
    SORT_PROP_ADAPTOR_RNIC_CAP_SPEC_MAXIMUM = "adaptor_RnicCapSpec_maximum"
    SORT_PROP_ADAPTOR_RNIC_CAP_SPEC_MAXIMUM_MR = "adaptor_RnicCapSpec_maximumMR"
    SORT_PROP_ADAPTOR_RNIC_CAP_SPEC_MAXIMUM_QP = "adaptor_RnicCapSpec_maximumQP"
    SORT_PROP_ADAPTOR_RNIC_CAP_SPEC_NF_VERSION_LO = "adaptor_RnicCapSpec_nfVersionLo"
    SORT_PROP_ADAPTOR_RNIC_CAP_SPEC_TYPE = "adaptor_RnicCapSpec_type"
    SORT_PROP_ADAPTOR_RSS_PROFILE_RECEIVE_SIDE_SCALING = "adaptor_RssProfile_receiveSideScaling"
    SORT_PROP_ADAPTOR_TCP_IP_RSS_HASH_PROFILE_IP_HASH = "adaptor_TcpIpRssHashProfile_ipHash"
    SORT_PROP_ADAPTOR_TCP_IP_RSS_HASH_PROFILE_TCP_HASH = "adaptor_TcpIpRssHashProfile_tcpHash"
    SORT_PROP_ADAPTOR_UNIT_ASSOC_CTX_FRU_CAP_DN = "adaptor_UnitAssocCtx_fruCapDn"
    SORT_PROP_ADAPTOR_UNIT_ASSOC_CTX_ID = "adaptor_UnitAssocCtx_id"
    SORT_PROP_ADAPTOR_UNIT_ASSOC_CTX_PCI_ADDR = "adaptor_UnitAssocCtx_pciAddr"
    SORT_PROP_ADAPTOR_UNIT_EXTN_ADAPTOR_ID = "adaptor_UnitExtn_adaptorId"
    SORT_PROP_ADAPTOR_UNIT_EXTN_ASSET_TAG = "adaptor_UnitExtn_assetTag"
    SORT_PROP_ADAPTOR_UNIT_EXTN_BLADE_ID = "adaptor_UnitExtn_bladeId"
    SORT_PROP_ADAPTOR_UNIT_EXTN_CHASSIS_ID = "adaptor_UnitExtn_chassisId"
    SORT_PROP_ADAPTOR_UNIT_EXTN_ID = "adaptor_UnitExtn_id"
    SORT_PROP_ADAPTOR_UNIT_EXTN_LOCATION_DN = "adaptor_UnitExtn_locationDn"
    SORT_PROP_ADAPTOR_UNIT_EXTN_MODEL = "adaptor_UnitExtn_model"
    SORT_PROP_ADAPTOR_UNIT_EXTN_OPER_QUALIFIER_REASON = "adaptor_UnitExtn_operQualifierReason"
    SORT_PROP_ADAPTOR_UNIT_EXTN_OPER_STATE = "adaptor_UnitExtn_operState"
    SORT_PROP_ADAPTOR_UNIT_EXTN_OPERABILITY = "adaptor_UnitExtn_operability"
    SORT_PROP_ADAPTOR_UNIT_EXTN_PART_NUMBER = "adaptor_UnitExtn_partNumber"
    SORT_PROP_ADAPTOR_UNIT_EXTN_PERF = "adaptor_UnitExtn_perf"
    SORT_PROP_ADAPTOR_UNIT_EXTN_POWER = "adaptor_UnitExtn_power"
    SORT_PROP_ADAPTOR_UNIT_EXTN_PRESENCE = "adaptor_UnitExtn_presence"
    SORT_PROP_ADAPTOR_UNIT_EXTN_REVISION = "adaptor_UnitExtn_revision"
    SORT_PROP_ADAPTOR_UNIT_EXTN_SERIAL = "adaptor_UnitExtn_serial"
    SORT_PROP_ADAPTOR_UNIT_EXTN_THERMAL = "adaptor_UnitExtn_thermal"
    SORT_PROP_ADAPTOR_UNIT_EXTN_VENDOR = "adaptor_UnitExtn_vendor"
    SORT_PROP_ADAPTOR_UNIT_EXTN_VID = "adaptor_UnitExtn_vid"
    SORT_PROP_ADAPTOR_UNIT_EXTN_VOLTAGE = "adaptor_UnitExtn_voltage"
    SORT_PROP_ADAPTOR_UNIT_ADMIN_POWER_STATE = "adaptor_Unit_adminPowerState"
    SORT_PROP_ADAPTOR_UNIT_ASSET_TAG = "adaptor_Unit_assetTag"
    SORT_PROP_ADAPTOR_UNIT_BASE_MAC = "adaptor_Unit_baseMac"
    SORT_PROP_ADAPTOR_UNIT_BLADE_ID = "adaptor_Unit_bladeId"
    SORT_PROP_ADAPTOR_UNIT_CARTRIDGE_ID = "adaptor_Unit_cartridgeId"
    SORT_PROP_ADAPTOR_UNIT_CHASSIS_ID = "adaptor_Unit_chassisId"
    SORT_PROP_ADAPTOR_UNIT_CONN_PATH = "adaptor_Unit_connPath"
    SORT_PROP_ADAPTOR_UNIT_CONN_STATUS = "adaptor_Unit_connStatus"
    SORT_PROP_ADAPTOR_UNIT_DISCOVERY_STATUS = "adaptor_Unit_discoveryStatus"
    SORT_PROP_ADAPTOR_UNIT_ID = "adaptor_Unit_id"
    SORT_PROP_ADAPTOR_UNIT_INTEGRATED = "adaptor_Unit_integrated"
    SORT_PROP_ADAPTOR_UNIT_LOCATION_DN = "adaptor_Unit_locationDn"
    SORT_PROP_ADAPTOR_UNIT_MANAGING_INST = "adaptor_Unit_managingInst"
    SORT_PROP_ADAPTOR_UNIT_MFG_TIME = "adaptor_Unit_mfgTime"
    SORT_PROP_ADAPTOR_UNIT_MODEL = "adaptor_Unit_model"
    SORT_PROP_ADAPTOR_UNIT_MULTI_PORT_CONNECTION_STATUS = "adaptor_Unit_multiPortConnectionStatus"
    SORT_PROP_ADAPTOR_UNIT_OPER_QUALIFIER_REASON = "adaptor_Unit_operQualifierReason"
    SORT_PROP_ADAPTOR_UNIT_OPER_STATE = "adaptor_Unit_operState"
    SORT_PROP_ADAPTOR_UNIT_OPERABILITY = "adaptor_Unit_operability"
    SORT_PROP_ADAPTOR_UNIT_PART_NUMBER = "adaptor_Unit_partNumber"
    SORT_PROP_ADAPTOR_UNIT_PCI_ADDR = "adaptor_Unit_pciAddr"
    SORT_PROP_ADAPTOR_UNIT_PCI_SLOT = "adaptor_Unit_pciSlot"
    SORT_PROP_ADAPTOR_UNIT_PERF = "adaptor_Unit_perf"
    SORT_PROP_ADAPTOR_UNIT_POWER = "adaptor_Unit_power"
    SORT_PROP_ADAPTOR_UNIT_PRESENCE = "adaptor_Unit_presence"
    SORT_PROP_ADAPTOR_UNIT_REACHABILITY = "adaptor_Unit_reachability"
    SORT_PROP_ADAPTOR_UNIT_REVISION = "adaptor_Unit_revision"
    SORT_PROP_ADAPTOR_UNIT_SERIAL = "adaptor_Unit_serial"
    SORT_PROP_ADAPTOR_UNIT_THERMAL = "adaptor_Unit_thermal"
    SORT_PROP_ADAPTOR_UNIT_VENDOR = "adaptor_Unit_vendor"
    SORT_PROP_ADAPTOR_UNIT_VID = "adaptor_Unit_vid"
    SORT_PROP_ADAPTOR_UNIT_VISIBILITY = "adaptor_Unit_visibility"
    SORT_PROP_ADAPTOR_UNIT_VOLTAGE = "adaptor_Unit_voltage"
    SORT_PROP_ADAPTOR_USNIC_CONN_DEF_CON_POLICY_NAME = "adaptor_UsnicConnDef_conPolicyName"
    SORT_PROP_ADAPTOR_USNIC_CONN_DEF_USNIC_COUNT = "adaptor_UsnicConnDef_usnicCount"
    SORT_PROP_ADAPTOR_VLAN_ASSOC_PRIMARY_VLAN_STATE = "adaptor_Vlan_assocPrimaryVlanState"
    SORT_PROP_ADAPTOR_VLAN_ASSOC_PRIMARY_VLAN_SWITCH_ID = "adaptor_Vlan_assocPrimaryVlanSwitchId"
    SORT_PROP_ADAPTOR_VLAN_EP_DN = "adaptor_Vlan_epDn"
    SORT_PROP_ADAPTOR_VLAN_ID = "adaptor_Vlan_id"
    SORT_PROP_ADAPTOR_VLAN_IF_ROLE = "adaptor_Vlan_ifRole"
    SORT_PROP_ADAPTOR_VLAN_IF_TYPE = "adaptor_Vlan_ifType"
    SORT_PROP_ADAPTOR_VLAN_LC = "adaptor_Vlan_lc"
    SORT_PROP_ADAPTOR_VLAN_LOCALE = "adaptor_Vlan_locale"
    SORT_PROP_ADAPTOR_VLAN_NAME = "adaptor_Vlan_name"
    SORT_PROP_ADAPTOR_VLAN_OPER_STATE = "adaptor_Vlan_operState"
    SORT_PROP_ADAPTOR_VLAN_OVERLAP_STATE_FOR_A = "adaptor_Vlan_overlapStateForA"
    SORT_PROP_ADAPTOR_VLAN_OVERLAP_STATE_FOR_B = "adaptor_Vlan_overlapStateForB"
    SORT_PROP_ADAPTOR_VLAN_PEER_DN = "adaptor_Vlan_peerDn"
    SORT_PROP_ADAPTOR_VLAN_POLICY_OWNER = "adaptor_Vlan_policyOwner"
    SORT_PROP_ADAPTOR_VLAN_PUB_NW_DN = "adaptor_Vlan_pubNwDn"
    SORT_PROP_ADAPTOR_VLAN_PUB_NW_ID = "adaptor_Vlan_pubNwId"
    SORT_PROP_ADAPTOR_VLAN_PUB_NW_NAME = "adaptor_Vlan_pubNwName"
    SORT_PROP_ADAPTOR_VLAN_SHARING = "adaptor_Vlan_sharing"
    SORT_PROP_ADAPTOR_VLAN_SWITCH_ID = "adaptor_Vlan_switchId"
    SORT_PROP_ADAPTOR_VLAN_TRANSPORT = "adaptor_Vlan_transport"
    SORT_PROP_ADAPTOR_VLAN_TYPE = "adaptor_Vlan_type"
    SORT_PROP_ADAPTOR_VLAN_VLAN_TYPE = "adaptor_Vlan_vlanType"
    SORT_PROP_ADAPTOR_VMMQ_CONN_DEF_VMMQ_SUB_VNIC_COUNT = "adaptor_VmmqConnDef_VmmqSubVnicCount"
    SORT_PROP_ADAPTOR_VMMQ_CONN_DEF_CON_POLICY_NAME = "adaptor_VmmqConnDef_conPolicyName"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_BYTES_RX = "adaptor_VnicStatsHist_bytesRx"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_BYTES_RX_DELTA = "adaptor_VnicStatsHist_bytesRxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_BYTES_RX_DELTA_AVG = "adaptor_VnicStatsHist_bytesRxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_BYTES_RX_DELTA_MAX = "adaptor_VnicStatsHist_bytesRxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_BYTES_RX_DELTA_MIN = "adaptor_VnicStatsHist_bytesRxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_BYTES_TX = "adaptor_VnicStatsHist_bytesTx"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_BYTES_TX_DELTA = "adaptor_VnicStatsHist_bytesTxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_BYTES_TX_DELTA_AVG = "adaptor_VnicStatsHist_bytesTxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_BYTES_TX_DELTA_MAX = "adaptor_VnicStatsHist_bytesTxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_BYTES_TX_DELTA_MIN = "adaptor_VnicStatsHist_bytesTxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_DROPPED_RX = "adaptor_VnicStatsHist_droppedRx"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_DROPPED_RX_DELTA = "adaptor_VnicStatsHist_droppedRxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_DROPPED_RX_DELTA_AVG = "adaptor_VnicStatsHist_droppedRxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_DROPPED_RX_DELTA_MAX = "adaptor_VnicStatsHist_droppedRxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_DROPPED_RX_DELTA_MIN = "adaptor_VnicStatsHist_droppedRxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_DROPPED_TX = "adaptor_VnicStatsHist_droppedTx"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_DROPPED_TX_DELTA = "adaptor_VnicStatsHist_droppedTxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_DROPPED_TX_DELTA_AVG = "adaptor_VnicStatsHist_droppedTxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_DROPPED_TX_DELTA_MAX = "adaptor_VnicStatsHist_droppedTxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_DROPPED_TX_DELTA_MIN = "adaptor_VnicStatsHist_droppedTxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ERRORS_RX = "adaptor_VnicStatsHist_errorsRx"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ERRORS_RX_DELTA = "adaptor_VnicStatsHist_errorsRxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ERRORS_RX_DELTA_AVG = "adaptor_VnicStatsHist_errorsRxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ERRORS_RX_DELTA_MAX = "adaptor_VnicStatsHist_errorsRxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ERRORS_RX_DELTA_MIN = "adaptor_VnicStatsHist_errorsRxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ERRORS_TX = "adaptor_VnicStatsHist_errorsTx"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ERRORS_TX_DELTA = "adaptor_VnicStatsHist_errorsTxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ERRORS_TX_DELTA_AVG = "adaptor_VnicStatsHist_errorsTxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ERRORS_TX_DELTA_MAX = "adaptor_VnicStatsHist_errorsTxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ERRORS_TX_DELTA_MIN = "adaptor_VnicStatsHist_errorsTxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_ID = "adaptor_VnicStatsHist_id"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_MOST_RECENT = "adaptor_VnicStatsHist_mostRecent"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_PACKETS_RX = "adaptor_VnicStatsHist_packetsRx"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_PACKETS_RX_DELTA = "adaptor_VnicStatsHist_packetsRxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_PACKETS_RX_DELTA_AVG = "adaptor_VnicStatsHist_packetsRxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_PACKETS_RX_DELTA_MAX = "adaptor_VnicStatsHist_packetsRxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_PACKETS_RX_DELTA_MIN = "adaptor_VnicStatsHist_packetsRxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_PACKETS_TX = "adaptor_VnicStatsHist_packetsTx"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_PACKETS_TX_DELTA = "adaptor_VnicStatsHist_packetsTxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_PACKETS_TX_DELTA_AVG = "adaptor_VnicStatsHist_packetsTxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_PACKETS_TX_DELTA_MAX = "adaptor_VnicStatsHist_packetsTxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_PACKETS_TX_DELTA_MIN = "adaptor_VnicStatsHist_packetsTxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_SUSPECT = "adaptor_VnicStatsHist_suspect"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_THRESHOLDED = "adaptor_VnicStatsHist_thresholded"
    SORT_PROP_ADAPTOR_VNIC_STATS_HIST_TIME_COLLECTED = "adaptor_VnicStatsHist_timeCollected"
    SORT_PROP_ADAPTOR_VNIC_STATS_BYTES_RX = "adaptor_VnicStats_bytesRx"
    SORT_PROP_ADAPTOR_VNIC_STATS_BYTES_RX_DELTA = "adaptor_VnicStats_bytesRxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_BYTES_RX_DELTA_AVG = "adaptor_VnicStats_bytesRxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_BYTES_RX_DELTA_MAX = "adaptor_VnicStats_bytesRxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_BYTES_RX_DELTA_MIN = "adaptor_VnicStats_bytesRxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_BYTES_TX = "adaptor_VnicStats_bytesTx"
    SORT_PROP_ADAPTOR_VNIC_STATS_BYTES_TX_DELTA = "adaptor_VnicStats_bytesTxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_BYTES_TX_DELTA_AVG = "adaptor_VnicStats_bytesTxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_BYTES_TX_DELTA_MAX = "adaptor_VnicStats_bytesTxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_BYTES_TX_DELTA_MIN = "adaptor_VnicStats_bytesTxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_DROPPED_RX = "adaptor_VnicStats_droppedRx"
    SORT_PROP_ADAPTOR_VNIC_STATS_DROPPED_RX_DELTA = "adaptor_VnicStats_droppedRxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_DROPPED_RX_DELTA_AVG = "adaptor_VnicStats_droppedRxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_DROPPED_RX_DELTA_MAX = "adaptor_VnicStats_droppedRxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_DROPPED_RX_DELTA_MIN = "adaptor_VnicStats_droppedRxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_DROPPED_TX = "adaptor_VnicStats_droppedTx"
    SORT_PROP_ADAPTOR_VNIC_STATS_DROPPED_TX_DELTA = "adaptor_VnicStats_droppedTxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_DROPPED_TX_DELTA_AVG = "adaptor_VnicStats_droppedTxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_DROPPED_TX_DELTA_MAX = "adaptor_VnicStats_droppedTxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_DROPPED_TX_DELTA_MIN = "adaptor_VnicStats_droppedTxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_ERRORS_RX = "adaptor_VnicStats_errorsRx"
    SORT_PROP_ADAPTOR_VNIC_STATS_ERRORS_RX_DELTA = "adaptor_VnicStats_errorsRxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_ERRORS_RX_DELTA_AVG = "adaptor_VnicStats_errorsRxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_ERRORS_RX_DELTA_MAX = "adaptor_VnicStats_errorsRxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_ERRORS_RX_DELTA_MIN = "adaptor_VnicStats_errorsRxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_ERRORS_TX = "adaptor_VnicStats_errorsTx"
    SORT_PROP_ADAPTOR_VNIC_STATS_ERRORS_TX_DELTA = "adaptor_VnicStats_errorsTxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_ERRORS_TX_DELTA_AVG = "adaptor_VnicStats_errorsTxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_ERRORS_TX_DELTA_MAX = "adaptor_VnicStats_errorsTxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_ERRORS_TX_DELTA_MIN = "adaptor_VnicStats_errorsTxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_INTERVALS = "adaptor_VnicStats_intervals"
    SORT_PROP_ADAPTOR_VNIC_STATS_NORMALIZED_TIME_COL = "adaptor_VnicStats_normalizedTimeCol"
    SORT_PROP_ADAPTOR_VNIC_STATS_PACKETS_RX = "adaptor_VnicStats_packetsRx"
    SORT_PROP_ADAPTOR_VNIC_STATS_PACKETS_RX_DELTA = "adaptor_VnicStats_packetsRxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_PACKETS_RX_DELTA_AVG = "adaptor_VnicStats_packetsRxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_PACKETS_RX_DELTA_MAX = "adaptor_VnicStats_packetsRxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_PACKETS_RX_DELTA_MIN = "adaptor_VnicStats_packetsRxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_PACKETS_TX = "adaptor_VnicStats_packetsTx"
    SORT_PROP_ADAPTOR_VNIC_STATS_PACKETS_TX_DELTA = "adaptor_VnicStats_packetsTxDelta"
    SORT_PROP_ADAPTOR_VNIC_STATS_PACKETS_TX_DELTA_AVG = "adaptor_VnicStats_packetsTxDeltaAvg"
    SORT_PROP_ADAPTOR_VNIC_STATS_PACKETS_TX_DELTA_MAX = "adaptor_VnicStats_packetsTxDeltaMax"
    SORT_PROP_ADAPTOR_VNIC_STATS_PACKETS_TX_DELTA_MIN = "adaptor_VnicStats_packetsTxDeltaMin"
    SORT_PROP_ADAPTOR_VNIC_STATS_STATS_REPORTED = "adaptor_VnicStats_statsReported"
    SORT_PROP_ADAPTOR_VNIC_STATS_SUSPECT = "adaptor_VnicStats_suspect"
    SORT_PROP_ADAPTOR_VNIC_STATS_THRESHOLDED = "adaptor_VnicStats_thresholded"
    SORT_PROP_ADAPTOR_VNIC_STATS_TIME_COLLECTED = "adaptor_VnicStats_timeCollected"
    SORT_PROP_ADAPTOR_VNIC_STATS_UPDATE = "adaptor_VnicStats_update"
    SORT_PROP_BIOS_BOT_LAST_UPDATE = "bios_BOT_lastUpdate"
    SORT_PROP_BIOS_BOOT_DEV_GRP_DESCR = "bios_BootDevGrp_descr"
    SORT_PROP_BIOS_BOOT_DEV_GRP_DEVICE_NAME = "bios_BootDevGrp_deviceName"
    SORT_PROP_BIOS_BOOT_DEV_GRP_ERR_VAL = "bios_BootDevGrp_errVal"
    SORT_PROP_BIOS_BOOT_DEV_GRP_ORDER = "bios_BootDevGrp_order"
    SORT_PROP_BIOS_BOOT_DEV_GRP_TYPE = "bios_BootDevGrp_type"
    SORT_PROP_BIOS_BOOT_DEV_DESCR = "bios_BootDev_descr"
    SORT_PROP_BIOS_BOOT_DEV_DEVICE_NAME = "bios_BootDev_deviceName"
    SORT_PROP_BIOS_BOOT_DEV_ERR_VALUE = "bios_BootDev_errValue"
    SORT_PROP_BIOS_BOOT_DEV_ORDER = "bios_BootDev_order"
    SORT_PROP_BIOS_TOKEN_FEATURE_GROUP_NAME = "bios_TokenFeatureGroup_name"
    SORT_PROP_BIOS_TOKEN_FEATURE_GROUP_SUPPORTED_BY_DEFAULT = "bios_TokenFeatureGroup_supportedByDefault"
    SORT_PROP_BIOS_TOKEN_PARAM_TYPE = "bios_TokenParam_Type"
    SORT_PROP_BIOS_TOKEN_PARAM_LEGACY_PROP_ID = "bios_TokenParam_legacyPropId"
    SORT_PROP_BIOS_TOKEN_PARAM_PARAM_NAME = "bios_TokenParam_paramName"
    SORT_PROP_BIOS_TOKEN_PARAM_TARGET_TOKEN_NAME = "bios_TokenParam_targetTokenName"
    SORT_PROP_BIOS_TOKEN_PARAM_UI_GROUP_NAME = "bios_TokenParam_uiGroupName"
    SORT_PROP_BIOS_TOKEN_SETTINGS_MAXIMUM = "bios_TokenSettings_Maximum"
    SORT_PROP_BIOS_TOKEN_SETTINGS_MINIMUM = "bios_TokenSettings_Minimum"
    SORT_PROP_BIOS_TOKEN_SETTINGS_STEP = "bios_TokenSettings_Step"
    SORT_PROP_BIOS_TOKEN_SETTINGS_UNIT = "bios_TokenSettings_Unit"
    SORT_PROP_BIOS_TOKEN_SETTINGS_BIOS_RET_SETTING_NAME = "bios_TokenSettings_biosRetSettingName"
    SORT_PROP_BIOS_TOKEN_SETTINGS_IS_ASSIGNED = "bios_TokenSettings_isAssigned"
    SORT_PROP_BIOS_TOKEN_SETTINGS_LEGACY_PROP_VAL = "bios_TokenSettings_legacyPropVal"
    SORT_PROP_BIOS_TOKEN_SETTINGS_SETTINGS_MO_RN = "bios_TokenSettings_settingsMoRn"
    SORT_PROP_BIOS_TOKEN_SETTINGS_TARGET_TOKEN_VALUE = "bios_TokenSettings_targetTokenValue"
    SORT_PROP_BIOS_UNIT_INIT_SEQ = "bios_Unit_initSeq"
    SORT_PROP_BIOS_UNIT_INIT_TS = "bios_Unit_initTs"
    SORT_PROP_BIOS_UNIT_MODEL = "bios_Unit_model"
    SORT_PROP_BIOS_UNIT_REVISION = "bios_Unit_revision"
    SORT_PROP_BIOS_UNIT_SERIAL = "bios_Unit_serial"
    SORT_PROP_BIOS_UNIT_VENDOR = "bios_Unit_vendor"
    SORT_PROP_BIOS_VFEAT_SUPPORTED_BY_DEFAULT = "bios_VFeat_supportedByDefault"
    SORT_PROP_BIOS_VPROFILE_DESCR = "bios_VProfile_descr"
    SORT_PROP_BIOS_VPROFILE_INT_ID = "bios_VProfile_intId"
    SORT_PROP_BIOS_VPROFILE_NAME = "bios_VProfile_name"
    SORT_PROP_BIOS_VPROFILE_POLICY_LEVEL = "bios_VProfile_policyLevel"
    SORT_PROP_BIOS_VPROFILE_POLICY_OWNER = "bios_VProfile_policyOwner"
    SORT_PROP_BIOS_VPROFILE_REBOOT_ON_UPDATE = "bios_VProfile_rebootOnUpdate"
    SORT_PROP_BIOS_VF_ACPI10_SUPPORT_SUPPORTED_BY_DEFAULT = "bios_VfACPI10Support_supportedByDefault"
    SORT_PROP_BIOS_VF_ACPI10_SUPPORT_VP_ACPI10_SUPPORT = "bios_VfACPI10Support_vpACPI10Support"
    SORT_PROP_BIOS_VF_ASPMSUPPORT_SUPPORTED_BY_DEFAULT = "bios_VfASPMSupport_supportedByDefault"
    SORT_PROP_BIOS_VF_ASPMSUPPORT_VP_ASPMSUPPORT = "bios_VfASPMSupport_vpASPMSupport"
    SORT_PROP_BIOS_VF_ALL_USBDEVICES_SUPPORTED_BY_DEFAULT = "bios_VfAllUSBDevices_supportedByDefault"
    SORT_PROP_BIOS_VF_ALL_USBDEVICES_VP_ALL_USBDEVICES = "bios_VfAllUSBDevices_vpAllUSBDevices"
    SORT_PROP_BIOS_VF_ALTITUDE_SUPPORTED_BY_DEFAULT = "bios_VfAltitude_supportedByDefault"
    SORT_PROP_BIOS_VF_ALTITUDE_VP_ALTITUDE = "bios_VfAltitude_vpAltitude"
    SORT_PROP_BIOS_VF_ASSERT_NMION_PERR_SUPPORTED_BY_DEFAULT = "bios_VfAssertNMIOnPERR_supportedByDefault"
    SORT_PROP_BIOS_VF_ASSERT_NMION_PERR_VP_ASSERT_NMION_PERR = "bios_VfAssertNMIOnPERR_vpAssertNMIOnPERR"
    SORT_PROP_BIOS_VF_ASSERT_NMION_SERR_SUPPORTED_BY_DEFAULT = "bios_VfAssertNMIOnSERR_supportedByDefault"
    SORT_PROP_BIOS_VF_ASSERT_NMION_SERR_VP_ASSERT_NMION_SERR = "bios_VfAssertNMIOnSERR_vpAssertNMIOnSERR"
    SORT_PROP_BIOS_VF_BOOT_OPTION_RETRY_SUPPORTED_BY_DEFAULT = "bios_VfBootOptionRetry_supportedByDefault"
    SORT_PROP_BIOS_VF_BOOT_OPTION_RETRY_VP_BOOT_OPTION_RETRY = "bios_VfBootOptionRetry_vpBootOptionRetry"
    SORT_PROP_BIOS_VF_CPUHARDWARE_POWER_MANAGEMENT_SUPPORTED_BY_DEFAULT = "bios_VfCPUHardwarePowerManagement_supportedByDefault"
    SORT_PROP_BIOS_VF_CPUHARDWARE_POWER_MANAGEMENT_VP_CPUHARDWARE_POWER_MANAGEMENT = "bios_VfCPUHardwarePowerManagement_vpCPUHardwarePowerManagement"
    SORT_PROP_BIOS_VF_CPUPERFORMANCE_SUPPORTED_BY_DEFAULT = "bios_VfCPUPerformance_supportedByDefault"
    SORT_PROP_BIOS_VF_CPUPERFORMANCE_VP_CPUPERFORMANCE = "bios_VfCPUPerformance_vpCPUPerformance"
    SORT_PROP_BIOS_VF_CPUPOWER_MANAGEMENT_SUPPORTED_BY_DEFAULT = "bios_VfCPUPowerManagement_supportedByDefault"
    SORT_PROP_BIOS_VF_CPUPOWER_MANAGEMENT_VP_CPUPOWER_MANAGEMENT = "bios_VfCPUPowerManagement_vpCPUPowerManagement"
    SORT_PROP_BIOS_VF_CONSISTENT_DEVICE_NAME_CONTROL_SUPPORTED_BY_DEFAULT = "bios_VfConsistentDeviceNameControl_supportedByDefault"
    SORT_PROP_BIOS_VF_CONSISTENT_DEVICE_NAME_CONTROL_VP_CDNCONTROL = "bios_VfConsistentDeviceNameControl_vpCDNControl"
    SORT_PROP_BIOS_VF_CONSOLE_REDIRECTION_SUPPORTED_BY_DEFAULT = "bios_VfConsoleRedirection_supportedByDefault"
    SORT_PROP_BIOS_VF_CONSOLE_REDIRECTION_VP_BAUD_RATE = "bios_VfConsoleRedirection_vpBaudRate"
    SORT_PROP_BIOS_VF_CONSOLE_REDIRECTION_VP_CONSOLE_REDIRECTION = "bios_VfConsoleRedirection_vpConsoleRedirection"
    SORT_PROP_BIOS_VF_CONSOLE_REDIRECTION_VP_FLOW_CONTROL = "bios_VfConsoleRedirection_vpFlowControl"
    SORT_PROP_BIOS_VF_CONSOLE_REDIRECTION_VP_LEGACY_OSREDIRECTION = "bios_VfConsoleRedirection_vpLegacyOSRedirection"
    SORT_PROP_BIOS_VF_CONSOLE_REDIRECTION_VP_PUTTY_KEY_PAD = "bios_VfConsoleRedirection_vpPuttyKeyPad"
    SORT_PROP_BIOS_VF_CONSOLE_REDIRECTION_VP_TERMINAL_TYPE = "bios_VfConsoleRedirection_vpTerminalType"
    SORT_PROP_BIOS_VF_CORE_MULTI_PROCESSING_SUPPORTED_BY_DEFAULT = "bios_VfCoreMultiProcessing_supportedByDefault"
    SORT_PROP_BIOS_VF_CORE_MULTI_PROCESSING_VP_CORE_MULTI_PROCESSING = "bios_VfCoreMultiProcessing_vpCoreMultiProcessing"
    SORT_PROP_BIOS_VF_DDR3_VOLTAGE_SELECTION_SUPPORTED_BY_DEFAULT = "bios_VfDDR3VoltageSelection_supportedByDefault"
    SORT_PROP_BIOS_VF_DDR3_VOLTAGE_SELECTION_VP_DDR3_VOLTAGE_SELECTION = "bios_VfDDR3VoltageSelection_vpDDR3VoltageSelection"
    SORT_PROP_BIOS_VF_DRAMCLOCK_THROTTLING_SUPPORTED_BY_DEFAULT = "bios_VfDRAMClockThrottling_supportedByDefault"
    SORT_PROP_BIOS_VF_DRAMCLOCK_THROTTLING_VP_DRAMCLOCK_THROTTLING = "bios_VfDRAMClockThrottling_vpDRAMClockThrottling"
    SORT_PROP_BIOS_VF_DIRECT_CACHE_ACCESS_SUPPORTED_BY_DEFAULT = "bios_VfDirectCacheAccess_supportedByDefault"
    SORT_PROP_BIOS_VF_DIRECT_CACHE_ACCESS_VP_DIRECT_CACHE_ACCESS = "bios_VfDirectCacheAccess_vpDirectCacheAccess"
    SORT_PROP_BIOS_VF_DRAM_REFRESH_RATE_SUPPORTED_BY_DEFAULT = "bios_VfDramRefreshRate_supportedByDefault"
    SORT_PROP_BIOS_VF_DRAM_REFRESH_RATE_VP_DRAM_REFRESH_RATE = "bios_VfDramRefreshRate_vpDramRefreshRate"
    SORT_PROP_BIOS_VF_ENERGY_PERFORMANCE_TUNING_SUPPORTED_BY_DEFAULT = "bios_VfEnergyPerformanceTuning_supportedByDefault"
    SORT_PROP_BIOS_VF_ENERGY_PERFORMANCE_TUNING_VP_PWR_PERF_TUNING = "bios_VfEnergyPerformanceTuning_vpPwrPerfTuning"
    SORT_PROP_BIOS_VF_ENHANCED_INTEL_SPEED_STEP_TECH_SUPPORTED_BY_DEFAULT = "bios_VfEnhancedIntelSpeedStepTech_supportedByDefault"
    SORT_PROP_BIOS_VF_ENHANCED_INTEL_SPEED_STEP_TECH_VP_ENHANCED_INTEL_SPEED_STEP_TECH = "bios_VfEnhancedIntelSpeedStepTech_vpEnhancedIntelSpeedStepTech"
    SORT_PROP_BIOS_VF_ENHANCED_POWER_CAPPING_SUPPORT_SUPPORTED_BY_DEFAULT = "bios_VfEnhancedPowerCappingSupport_supportedByDefault"
    SORT_PROP_BIOS_VF_ENHANCED_POWER_CAPPING_SUPPORT_VP_ENHANCED_POWER_CAPPING = "bios_VfEnhancedPowerCappingSupport_vpEnhancedPowerCapping"
    SORT_PROP_BIOS_VF_EXECUTE_DISABLE_BIT_SUPPORTED_BY_DEFAULT = "bios_VfExecuteDisableBit_supportedByDefault"
    SORT_PROP_BIOS_VF_EXECUTE_DISABLE_BIT_VP_EXECUTE_DISABLE_BIT = "bios_VfExecuteDisableBit_vpExecuteDisableBit"
    SORT_PROP_BIOS_VF_FRB2_TIMER_SUPPORTED_BY_DEFAULT = "bios_VfFRB2Timer_supportedByDefault"
    SORT_PROP_BIOS_VF_FRB2_TIMER_VP_FRB2_TIMER = "bios_VfFRB2Timer_vpFRB2Timer"
    SORT_PROP_BIOS_VF_FREQUENCY_FLOOR_OVERRIDE_SUPPORTED_BY_DEFAULT = "bios_VfFrequencyFloorOverride_supportedByDefault"
    SORT_PROP_BIOS_VF_FREQUENCY_FLOOR_OVERRIDE_VP_FREQUENCY_FLOOR_OVERRIDE = "bios_VfFrequencyFloorOverride_vpFrequencyFloorOverride"
    SORT_PROP_BIOS_VF_FRONT_PANEL_LOCKOUT_SUPPORTED_BY_DEFAULT = "bios_VfFrontPanelLockout_supportedByDefault"
    SORT_PROP_BIOS_VF_FRONT_PANEL_LOCKOUT_VP_FRONT_PANEL_LOCKOUT = "bios_VfFrontPanelLockout_vpFrontPanelLockout"
    SORT_PROP_BIOS_VF_IOEMEZZ1_OPTION_ROM_SUPPORTED_BY_DEFAULT = "bios_VfIOEMezz1OptionROM_supportedByDefault"
    SORT_PROP_BIOS_VF_IOEMEZZ1_OPTION_ROM_VP_IOEMEZZ1_OPTION_ROM = "bios_VfIOEMezz1OptionROM_vpIOEMezz1OptionROM"
    SORT_PROP_BIOS_VF_IOENVME1_OPTION_ROM_SUPPORTED_BY_DEFAULT = "bios_VfIOENVMe1OptionROM_supportedByDefault"
    SORT_PROP_BIOS_VF_IOENVME1_OPTION_ROM_VP_IOENVME1_OPTION_ROM = "bios_VfIOENVMe1OptionROM_vpIOENVMe1OptionROM"
    SORT_PROP_BIOS_VF_IOENVME2_OPTION_ROM_SUPPORTED_BY_DEFAULT = "bios_VfIOENVMe2OptionROM_supportedByDefault"
    SORT_PROP_BIOS_VF_IOENVME2_OPTION_ROM_VP_IOENVME2_OPTION_ROM = "bios_VfIOENVMe2OptionROM_vpIOENVMe2OptionROM"
    SORT_PROP_BIOS_VF_IOESLOT1_OPTION_ROM_SUPPORTED_BY_DEFAULT = "bios_VfIOESlot1OptionROM_supportedByDefault"
    SORT_PROP_BIOS_VF_IOESLOT1_OPTION_ROM_VP_IOESLOT1_OPTION_ROM = "bios_VfIOESlot1OptionROM_vpIOESlot1OptionROM"
    SORT_PROP_BIOS_VF_IOESLOT2_OPTION_ROM_SUPPORTED_BY_DEFAULT = "bios_VfIOESlot2OptionROM_supportedByDefault"
    SORT_PROP_BIOS_VF_IOESLOT2_OPTION_ROM_VP_IOESLOT2_OPTION_ROM = "bios_VfIOESlot2OptionROM_vpIOESlot2OptionROM"
    SORT_PROP_BIOS_VF_INTEGRATED_GRAPHICS_APERTURE_SIZE_SUPPORTED_BY_DEFAULT = "bios_VfIntegratedGraphicsApertureSize_supportedByDefault"
    SORT_PROP_BIOS_VF_INTEGRATED_GRAPHICS_APERTURE_SIZE_VP_INTEGRATED_GRAPHICS_APERTURE_SIZE = "bios_VfIntegratedGraphicsApertureSize_vpIntegratedGraphicsApertureSize"
    SORT_PROP_BIOS_VF_INTEGRATED_GRAPHICS_SUPPORTED_BY_DEFAULT = "bios_VfIntegratedGraphics_supportedByDefault"
    SORT_PROP_BIOS_VF_INTEGRATED_GRAPHICS_VP_INTEGRATED_GRAPHICS = "bios_VfIntegratedGraphics_vpIntegratedGraphics"
    SORT_PROP_BIOS_VF_INTEL_ENTRY_SASRAIDMODULE_SUPPORTED_BY_DEFAULT = "bios_VfIntelEntrySASRAIDModule_supportedByDefault"
    SORT_PROP_BIOS_VF_INTEL_ENTRY_SASRAIDMODULE_VP_SASRAID = "bios_VfIntelEntrySASRAIDModule_vpSASRAID"
    SORT_PROP_BIOS_VF_INTEL_ENTRY_SASRAIDMODULE_VP_SASRAIDMODULE = "bios_VfIntelEntrySASRAIDModule_vpSASRAIDModule"
    SORT_PROP_BIOS_VF_INTEL_HYPER_THREADING_TECH_SUPPORTED_BY_DEFAULT = "bios_VfIntelHyperThreadingTech_supportedByDefault"
    SORT_PROP_BIOS_VF_INTEL_HYPER_THREADING_TECH_VP_INTEL_HYPER_THREADING_TECH = "bios_VfIntelHyperThreadingTech_vpIntelHyperThreadingTech"
    SORT_PROP_BIOS_VF_INTEL_TRUSTED_EXECUTION_TECHNOLOGY_SUPPORTED_BY_DEFAULT = "bios_VfIntelTrustedExecutionTechnology_supportedByDefault"
    SORT_PROP_BIOS_VF_INTEL_TRUSTED_EXECUTION_TECHNOLOGY_VP_INTEL_TRUSTED_EXECUTION_TECHNOLOGY_SUPPORT = "bios_VfIntelTrustedExecutionTechnology_vpIntelTrustedExecutionTechnologySupport"
    SORT_PROP_BIOS_VF_INTEL_TURBO_BOOST_TECH_SUPPORTED_BY_DEFAULT = "bios_VfIntelTurboBoostTech_supportedByDefault"
    SORT_PROP_BIOS_VF_INTEL_TURBO_BOOST_TECH_VP_INTEL_TURBO_BOOST_TECH = "bios_VfIntelTurboBoostTech_vpIntelTurboBoostTech"
    SORT_PROP_BIOS_VF_INTEL_VTFOR_DIRECTED_IO_SUPPORTED_BY_DEFAULT = "bios_VfIntelVTForDirectedIO_supportedByDefault"
    SORT_PROP_BIOS_VF_INTEL_VTFOR_DIRECTED_IO_VP_INTEL_VTDATSSUPPORT = "bios_VfIntelVTForDirectedIO_vpIntelVTDATSSupport"
    SORT_PROP_BIOS_VF_INTEL_VTFOR_DIRECTED_IO_VP_INTEL_VTDCOHERENCY_SUPPORT = "bios_VfIntelVTForDirectedIO_vpIntelVTDCoherencySupport"
    SORT_PROP_BIOS_VF_INTEL_VTFOR_DIRECTED_IO_VP_INTEL_VTDINTERRUPT_REMAPPING = "bios_VfIntelVTForDirectedIO_vpIntelVTDInterruptRemapping"
    SORT_PROP_BIOS_VF_INTEL_VTFOR_DIRECTED_IO_VP_INTEL_VTDPASS_THROUGH_DMASUPPORT = "bios_VfIntelVTForDirectedIO_vpIntelVTDPassThroughDMASupport"
    SORT_PROP_BIOS_VF_INTEL_VTFOR_DIRECTED_IO_VP_INTEL_VTFOR_DIRECTED_IO = "bios_VfIntelVTForDirectedIO_vpIntelVTForDirectedIO"
    SORT_PROP_BIOS_VF_INTEL_VIRTUALIZATION_TECHNOLOGY_SUPPORTED_BY_DEFAULT = "bios_VfIntelVirtualizationTechnology_supportedByDefault"
    SORT_PROP_BIOS_VF_INTEL_VIRTUALIZATION_TECHNOLOGY_VP_INTEL_VIRTUALIZATION_TECHNOLOGY = "bios_VfIntelVirtualizationTechnology_vpIntelVirtualizationTechnology"
    SORT_PROP_BIOS_VF_INTERLEAVE_CONFIGURATION_SUPPORTED_BY_DEFAULT = "bios_VfInterleaveConfiguration_supportedByDefault"
    SORT_PROP_BIOS_VF_INTERLEAVE_CONFIGURATION_VP_CHANNEL_INTERLEAVING = "bios_VfInterleaveConfiguration_vpChannelInterleaving"
    SORT_PROP_BIOS_VF_INTERLEAVE_CONFIGURATION_VP_MEMORY_INTERLEAVING = "bios_VfInterleaveConfiguration_vpMemoryInterleaving"
    SORT_PROP_BIOS_VF_INTERLEAVE_CONFIGURATION_VP_RANK_INTERLEAVING = "bios_VfInterleaveConfiguration_vpRankInterleaving"
    SORT_PROP_BIOS_VF_LOCAL_X2_APIC_SUPPORTED_BY_DEFAULT = "bios_VfLocalX2Apic_supportedByDefault"
    SORT_PROP_BIOS_VF_LOCAL_X2_APIC_VP_LOCAL_X2_APIC = "bios_VfLocalX2Apic_vpLocalX2Apic"
    SORT_PROP_BIOS_VF_LV_DIMMSUPPORT_SUPPORTED_BY_DEFAULT = "bios_VfLvDIMMSupport_supportedByDefault"
    SORT_PROP_BIOS_VF_LV_DIMMSUPPORT_VP_LV_DDRMODE = "bios_VfLvDIMMSupport_vpLvDDRMode"
    SORT_PROP_BIOS_VF_MAX_VARIABLE_MTRRSETTING_SUPPORTED_BY_DEFAULT = "bios_VfMaxVariableMTRRSetting_supportedByDefault"
    SORT_PROP_BIOS_VF_MAX_VARIABLE_MTRRSETTING_VP_PROCESSOR_MTRR = "bios_VfMaxVariableMTRRSetting_vpProcessorMtrr"
    SORT_PROP_BIOS_VF_MAXIMUM_MEMORY_BELOW4_GB_SUPPORTED_BY_DEFAULT = "bios_VfMaximumMemoryBelow4GB_supportedByDefault"
    SORT_PROP_BIOS_VF_MAXIMUM_MEMORY_BELOW4_GB_VP_MAXIMUM_MEMORY_BELOW4_GB = "bios_VfMaximumMemoryBelow4GB_vpMaximumMemoryBelow4GB"
    SORT_PROP_BIOS_VF_MEMORY_MAPPED_IOABOVE4_GB_SUPPORTED_BY_DEFAULT = "bios_VfMemoryMappedIOAbove4GB_supportedByDefault"
    SORT_PROP_BIOS_VF_MEMORY_MAPPED_IOABOVE4_GB_VP_MEMORY_MAPPED_IOABOVE4_GB = "bios_VfMemoryMappedIOAbove4GB_vpMemoryMappedIOAbove4GB"
    SORT_PROP_BIOS_VF_MIRRORING_MODE_SUPPORTED_BY_DEFAULT = "bios_VfMirroringMode_supportedByDefault"
    SORT_PROP_BIOS_VF_MIRRORING_MODE_VP_MIRRORING_MODE = "bios_VfMirroringMode_vpMirroringMode"
    SORT_PROP_BIOS_VF_NUMAOPTIMIZED_SUPPORTED_BY_DEFAULT = "bios_VfNUMAOptimized_supportedByDefault"
    SORT_PROP_BIOS_VF_NUMAOPTIMIZED_VP_NUMAOPTIMIZED = "bios_VfNUMAOptimized_vpNUMAOptimized"
    SORT_PROP_BIOS_VF_OSBOOT_WATCHDOG_TIMER_POLICY_SUPPORTED_BY_DEFAULT = "bios_VfOSBootWatchdogTimerPolicy_supportedByDefault"
    SORT_PROP_BIOS_VF_OSBOOT_WATCHDOG_TIMER_POLICY_VP_OSBOOT_WATCHDOG_TIMER_POLICY = "bios_VfOSBootWatchdogTimerPolicy_vpOSBootWatchdogTimerPolicy"
    SORT_PROP_BIOS_VF_OSBOOT_WATCHDOG_TIMER_TIMEOUT_SUPPORTED_BY_DEFAULT = "bios_VfOSBootWatchdogTimerTimeout_supportedByDefault"
    SORT_PROP_BIOS_VF_OSBOOT_WATCHDOG_TIMER_TIMEOUT_VP_OSBOOT_WATCHDOG_TIMER_TIMEOUT = "bios_VfOSBootWatchdogTimerTimeout_vpOSBootWatchdogTimerTimeout"
    SORT_PROP_BIOS_VF_OSBOOT_WATCHDOG_TIMER_SUPPORTED_BY_DEFAULT = "bios_VfOSBootWatchdogTimer_supportedByDefault"
    SORT_PROP_BIOS_VF_OSBOOT_WATCHDOG_TIMER_VP_OSBOOT_WATCHDOG_TIMER = "bios_VfOSBootWatchdogTimer_vpOSBootWatchdogTimer"
    SORT_PROP_BIOS_VF_ONBOARD_GRAPHICS_SUPPORTED_BY_DEFAULT = "bios_VfOnboardGraphics_supportedByDefault"
    SORT_PROP_BIOS_VF_ONBOARD_GRAPHICS_VP_ONBOARD_GRAPHICS = "bios_VfOnboardGraphics_vpOnboardGraphics"
    SORT_PROP_BIOS_VF_ONBOARD_SATACONTROLLER_SUPPORTED_BY_DEFAULT = "bios_VfOnboardSATAController_supportedByDefault"
    SORT_PROP_BIOS_VF_ONBOARD_SATACONTROLLER_VP_ONBOARD_SATACONTROLLER = "bios_VfOnboardSATAController_vpOnboardSATAController"
    SORT_PROP_BIOS_VF_ONBOARD_SATACONTROLLER_VP_SATAMODE = "bios_VfOnboardSATAController_vpSATAMode"
    SORT_PROP_BIOS_VF_ONBOARD_STORAGE_SUPPORTED_BY_DEFAULT = "bios_VfOnboardStorage_supportedByDefault"
    SORT_PROP_BIOS_VF_ONBOARD_STORAGE_VP_ONBOARD_SCUSTORAGE_SUPPORT = "bios_VfOnboardStorage_vpOnboardSCUStorageSupport"
    SORT_PROP_BIOS_VF_OPTION_ROMENABLE_SUPPORTED_BY_DEFAULT = "bios_VfOptionROMEnable_supportedByDefault"
    SORT_PROP_BIOS_VF_OPTION_ROMENABLE_VP_STATE = "bios_VfOptionROMEnable_vpState"
    SORT_PROP_BIOS_VF_OPTION_ROMLOAD_SUPPORTED_BY_DEFAULT = "bios_VfOptionROMLoad_supportedByDefault"
    SORT_PROP_BIOS_VF_OPTION_ROMLOAD_VP_LOAD = "bios_VfOptionROMLoad_vpLoad"
    SORT_PROP_BIOS_VF_OUT_OF_BAND_MANAGEMENT_SUPPORTED_BY_DEFAULT = "bios_VfOutOfBandManagement_supportedByDefault"
    SORT_PROP_BIOS_VF_OUT_OF_BAND_MANAGEMENT_VP_COM_SPCR_ENABLE = "bios_VfOutOfBandManagement_vpComSpcrEnable"
    SORT_PROP_BIOS_VF_PCHSATAMODE_SUPPORTED_BY_DEFAULT = "bios_VfPCHSATAMode_supportedByDefault"
    SORT_PROP_BIOS_VF_PCHSATAMODE_VP_SATAMODE = "bios_VfPCHSATAMode_vpSATAMode"
    SORT_PROP_BIOS_VF_PCILOMPORTS_CONFIGURATION_SUPPORTED_BY_DEFAULT = "bios_VfPCILOMPortsConfiguration_supportedByDefault"
    SORT_PROP_BIOS_VF_PCILOMPORTS_CONFIGURATION_VP_PCIE10_GLOM2_LINK = "bios_VfPCILOMPortsConfiguration_vpPCIe10GLOM2Link"
    SORT_PROP_BIOS_VF_PCIROMCLP_SUPPORTED_BY_DEFAULT = "bios_VfPCIROMCLP_supportedByDefault"
    SORT_PROP_BIOS_VF_PCIROMCLP_VP_PCIROMCLP = "bios_VfPCIROMCLP_vpPCIROMCLP"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_SUPPORTED_BY_DEFAULT = "bios_VfPCISlotLinkSpeed_supportedByDefault"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_VP_PCIE_SLOT10_LINK_SPEED = "bios_VfPCISlotLinkSpeed_vpPCIeSlot10LinkSpeed"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_VP_PCIE_SLOT1_LINK_SPEED = "bios_VfPCISlotLinkSpeed_vpPCIeSlot1LinkSpeed"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_VP_PCIE_SLOT2_LINK_SPEED = "bios_VfPCISlotLinkSpeed_vpPCIeSlot2LinkSpeed"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_VP_PCIE_SLOT3_LINK_SPEED = "bios_VfPCISlotLinkSpeed_vpPCIeSlot3LinkSpeed"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_VP_PCIE_SLOT4_LINK_SPEED = "bios_VfPCISlotLinkSpeed_vpPCIeSlot4LinkSpeed"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_VP_PCIE_SLOT5_LINK_SPEED = "bios_VfPCISlotLinkSpeed_vpPCIeSlot5LinkSpeed"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_VP_PCIE_SLOT6_LINK_SPEED = "bios_VfPCISlotLinkSpeed_vpPCIeSlot6LinkSpeed"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_VP_PCIE_SLOT7_LINK_SPEED = "bios_VfPCISlotLinkSpeed_vpPCIeSlot7LinkSpeed"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_VP_PCIE_SLOT8_LINK_SPEED = "bios_VfPCISlotLinkSpeed_vpPCIeSlot8LinkSpeed"
    SORT_PROP_BIOS_VF_PCISLOT_LINK_SPEED_VP_PCIE_SLOT9_LINK_SPEED = "bios_VfPCISlotLinkSpeed_vpPCIeSlot9LinkSpeed"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_SUPPORTED_BY_DEFAULT = "bios_VfPCISlotOptionROMEnable_supportedByDefault"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_PCIE_SLOT_HBAOPTION_ROM = "bios_VfPCISlotOptionROMEnable_vpPCIeSlotHBAOptionROM"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_PCIE_SLOT_MLOMOPTION_ROM = "bios_VfPCISlotOptionROMEnable_vpPCIeSlotMLOMOptionROM"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_PCIE_SLOT_N1_OPTION_ROM = "bios_VfPCISlotOptionROMEnable_vpPCIeSlotN1OptionROM"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_PCIE_SLOT_N2_OPTION_ROM = "bios_VfPCISlotOptionROMEnable_vpPCIeSlotN2OptionROM"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_PCIE_SLOT_SASOPTION_ROM = "bios_VfPCISlotOptionROMEnable_vpPCIeSlotSASOptionROM"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT10_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot10State"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT1_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot1State"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT2_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot2State"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT3_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot3State"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT4_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot4State"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT5_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot5State"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT6_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot6State"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT7_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot7State"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT8_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot8State"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT9_STATE = "bios_VfPCISlotOptionROMEnable_vpSlot9State"
    SORT_PROP_BIOS_VF_PCISLOT_OPTION_ROMENABLE_VP_SLOT_MEZZ_STATE = "bios_VfPCISlotOptionROMEnable_vpSlotMezzState"
    SORT_PROP_BIOS_VF_POSTERROR_PAUSE_SUPPORTED_BY_DEFAULT = "bios_VfPOSTErrorPause_supportedByDefault"
    SORT_PROP_BIOS_VF_POSTERROR_PAUSE_VP_POSTERROR_PAUSE = "bios_VfPOSTErrorPause_vpPOSTErrorPause"
    SORT_PROP_BIOS_VF_PSTATECOORDINATION_SUPPORTED_BY_DEFAULT = "bios_VfPSTATECoordination_supportedByDefault"
    SORT_PROP_BIOS_VF_PSTATECOORDINATION_VP_PSTATECOORDINATION = "bios_VfPSTATECoordination_vpPSTATECoordination"
    SORT_PROP_BIOS_VF_PACKAGE_CSTATE_LIMIT_SUPPORTED_BY_DEFAULT = "bios_VfPackageCStateLimit_supportedByDefault"
    SORT_PROP_BIOS_VF_PACKAGE_CSTATE_LIMIT_VP_PACKAGE_CSTATE_LIMIT = "bios_VfPackageCStateLimit_vpPackageCStateLimit"
    SORT_PROP_BIOS_VF_PROCESSOR_C1_E_SUPPORTED_BY_DEFAULT = "bios_VfProcessorC1E_supportedByDefault"
    SORT_PROP_BIOS_VF_PROCESSOR_C1_E_VP_PROCESSOR_C1_E = "bios_VfProcessorC1E_vpProcessorC1E"
    SORT_PROP_BIOS_VF_PROCESSOR_C3_REPORT_SUPPORTED_BY_DEFAULT = "bios_VfProcessorC3Report_supportedByDefault"
    SORT_PROP_BIOS_VF_PROCESSOR_C3_REPORT_VP_PROCESSOR_C3_REPORT = "bios_VfProcessorC3Report_vpProcessorC3Report"
    SORT_PROP_BIOS_VF_PROCESSOR_C6_REPORT_SUPPORTED_BY_DEFAULT = "bios_VfProcessorC6Report_supportedByDefault"
    SORT_PROP_BIOS_VF_PROCESSOR_C6_REPORT_VP_PROCESSOR_C6_REPORT = "bios_VfProcessorC6Report_vpProcessorC6Report"
    SORT_PROP_BIOS_VF_PROCESSOR_C7_REPORT_SUPPORTED_BY_DEFAULT = "bios_VfProcessorC7Report_supportedByDefault"
    SORT_PROP_BIOS_VF_PROCESSOR_C7_REPORT_VP_PROCESSOR_C7_REPORT = "bios_VfProcessorC7Report_vpProcessorC7Report"
    SORT_PROP_BIOS_VF_PROCESSOR_CMCI_SUPPORTED_BY_DEFAULT = "bios_VfProcessorCMCI_supportedByDefault"
    SORT_PROP_BIOS_VF_PROCESSOR_CMCI_VP_PROCESSOR_CMCI = "bios_VfProcessorCMCI_vpProcessorCMCI"
    SORT_PROP_BIOS_VF_PROCESSOR_CSTATE_SUPPORTED_BY_DEFAULT = "bios_VfProcessorCState_supportedByDefault"
    SORT_PROP_BIOS_VF_PROCESSOR_CSTATE_VP_PROCESSOR_CSTATE = "bios_VfProcessorCState_vpProcessorCState"
    SORT_PROP_BIOS_VF_PROCESSOR_ENERGY_CONFIGURATION_SUPPORTED_BY_DEFAULT = "bios_VfProcessorEnergyConfiguration_supportedByDefault"
    SORT_PROP_BIOS_VF_PROCESSOR_ENERGY_CONFIGURATION_VP_ENERGY_PERFORMANCE = "bios_VfProcessorEnergyConfiguration_vpEnergyPerformance"
    SORT_PROP_BIOS_VF_PROCESSOR_ENERGY_CONFIGURATION_VP_POWER_TECHNOLOGY = "bios_VfProcessorEnergyConfiguration_vpPowerTechnology"
    SORT_PROP_BIOS_VF_PROCESSOR_PREFETCH_CONFIG_SUPPORTED_BY_DEFAULT = "bios_VfProcessorPrefetchConfig_supportedByDefault"
    SORT_PROP_BIOS_VF_PROCESSOR_PREFETCH_CONFIG_VP_ADJACENT_CACHE_LINE_PREFETCHER = "bios_VfProcessorPrefetchConfig_vpAdjacentCacheLinePrefetcher"
    SORT_PROP_BIOS_VF_PROCESSOR_PREFETCH_CONFIG_VP_DCUIPPREFETCHER = "bios_VfProcessorPrefetchConfig_vpDCUIPPrefetcher"
    SORT_PROP_BIOS_VF_PROCESSOR_PREFETCH_CONFIG_VP_DCUSTREAMER_PREFETCH = "bios_VfProcessorPrefetchConfig_vpDCUStreamerPrefetch"
    SORT_PROP_BIOS_VF_PROCESSOR_PREFETCH_CONFIG_VP_HARDWARE_PREFETCHER = "bios_VfProcessorPrefetchConfig_vpHardwarePrefetcher"
    SORT_PROP_BIOS_VF_QPILINK_FREQUENCY_SELECT_SUPPORTED_BY_DEFAULT = "bios_VfQPILinkFrequencySelect_supportedByDefault"
    SORT_PROP_BIOS_VF_QPILINK_FREQUENCY_SELECT_VP_QPILINK_FREQUENCY_SELECT = "bios_VfQPILinkFrequencySelect_vpQPILinkFrequencySelect"
    SORT_PROP_BIOS_VF_QPISNOOP_MODE_SUPPORTED_BY_DEFAULT = "bios_VfQPISnoopMode_supportedByDefault"
    SORT_PROP_BIOS_VF_QPISNOOP_MODE_VP_QPISNOOP_MODE = "bios_VfQPISnoopMode_vpQPISnoopMode"
    SORT_PROP_BIOS_VF_QUIET_BOOT_SUPPORTED_BY_DEFAULT = "bios_VfQuietBoot_supportedByDefault"
    SORT_PROP_BIOS_VF_QUIET_BOOT_VP_QUIET_BOOT = "bios_VfQuietBoot_vpQuietBoot"
    SORT_PROP_BIOS_VF_REDIRECTION_AFTER_BIOSPOST_SUPPORTED_BY_DEFAULT = "bios_VfRedirectionAfterBIOSPOST_supportedByDefault"
    SORT_PROP_BIOS_VF_REDIRECTION_AFTER_BIOSPOST_VP_REDIRECTION_AFTER_POST = "bios_VfRedirectionAfterBIOSPOST_vpRedirectionAfterPOST"
    SORT_PROP_BIOS_VF_RESUME_ON_ACPOWER_LOSS_SUPPORTED_BY_DEFAULT = "bios_VfResumeOnACPowerLoss_supportedByDefault"
    SORT_PROP_BIOS_VF_RESUME_ON_ACPOWER_LOSS_VP_RESUME_ON_ACPOWER_LOSS = "bios_VfResumeOnACPowerLoss_vpResumeOnACPowerLoss"
    SORT_PROP_BIOS_VF_SBMEZZ1_OPTION_ROM_SUPPORTED_BY_DEFAULT = "bios_VfSBMezz1OptionROM_supportedByDefault"
    SORT_PROP_BIOS_VF_SBMEZZ1_OPTION_ROM_VP_SBMEZZ1_OPTION_ROM = "bios_VfSBMezz1OptionROM_vpSBMezz1OptionROM"
    SORT_PROP_BIOS_VF_SBNVME1_OPTION_ROM_SUPPORTED_BY_DEFAULT = "bios_VfSBNVMe1OptionROM_supportedByDefault"
    SORT_PROP_BIOS_VF_SBNVME1_OPTION_ROM_VP_SBNVME1_OPTION_ROM = "bios_VfSBNVMe1OptionROM_vpSBNVMe1OptionROM"
    SORT_PROP_BIOS_VF_SIOC1_OPTION_ROM_SUPPORTED_BY_DEFAULT = "bios_VfSIOC1OptionROM_supportedByDefault"
    SORT_PROP_BIOS_VF_SIOC1_OPTION_ROM_VP_SIOC1_OPTION_ROM = "bios_VfSIOC1OptionROM_vpSIOC1OptionROM"
    SORT_PROP_BIOS_VF_SIOC2_OPTION_ROM_SUPPORTED_BY_DEFAULT = "bios_VfSIOC2OptionROM_supportedByDefault"
    SORT_PROP_BIOS_VF_SIOC2_OPTION_ROM_VP_SIOC2_OPTION_ROM = "bios_VfSIOC2OptionROM_vpSIOC2OptionROM"
    SORT_PROP_BIOS_VF_SCRUB_POLICIES_SUPPORTED_BY_DEFAULT = "bios_VfScrubPolicies_supportedByDefault"
    SORT_PROP_BIOS_VF_SCRUB_POLICIES_VP_DEMAND_SCRUB = "bios_VfScrubPolicies_vpDemandScrub"
    SORT_PROP_BIOS_VF_SCRUB_POLICIES_VP_PATROL_SCRUB = "bios_VfScrubPolicies_vpPatrolScrub"
    SORT_PROP_BIOS_VF_SELECT_MEMORY_RASCONFIGURATION_SUPPORTED_BY_DEFAULT = "bios_VfSelectMemoryRASConfiguration_supportedByDefault"
    SORT_PROP_BIOS_VF_SELECT_MEMORY_RASCONFIGURATION_VP_SELECT_MEMORY_RASCONFIGURATION = "bios_VfSelectMemoryRASConfiguration_vpSelectMemoryRASConfiguration"
    SORT_PROP_BIOS_VF_SERIAL_PORT_AENABLE_SUPPORTED_BY_DEFAULT = "bios_VfSerialPortAEnable_supportedByDefault"
    SORT_PROP_BIOS_VF_SERIAL_PORT_AENABLE_VP_SERIAL_PORT_AENABLE = "bios_VfSerialPortAEnable_vpSerialPortAEnable"
    SORT_PROP_BIOS_VF_SPARING_MODE_SUPPORTED_BY_DEFAULT = "bios_VfSparingMode_supportedByDefault"
    SORT_PROP_BIOS_VF_SPARING_MODE_VP_SPARING_MODE = "bios_VfSparingMode_vpSparingMode"
    SORT_PROP_BIOS_VF_SRIOV_CONFIG_SUPPORTED_BY_DEFAULT = "bios_VfSriovConfig_supportedByDefault"
    SORT_PROP_BIOS_VF_SRIOV_CONFIG_VP_SRIOV = "bios_VfSriovConfig_vpSriov"
    SORT_PROP_BIOS_VF_TPMPENDING_OPERATION_SUPPORTED_BY_DEFAULT = "bios_VfTPMPendingOperation_supportedByDefault"
    SORT_PROP_BIOS_VF_TPMPENDING_OPERATION_VP_TPMPENDING_OPERATION = "bios_VfTPMPendingOperation_vpTPMPendingOperation"
    SORT_PROP_BIOS_VF_TPMSUPPORT_SUPPORTED_BY_DEFAULT = "bios_VfTPMSupport_supportedByDefault"
    SORT_PROP_BIOS_VF_TPMSUPPORT_VP_TPMSUPPORT = "bios_VfTPMSupport_vpTPMSupport"
    SORT_PROP_BIOS_VF_TRUSTED_PLATFORM_MODULE_SUPPORTED_BY_DEFAULT = "bios_VfTrustedPlatformModule_supportedByDefault"
    SORT_PROP_BIOS_VF_TRUSTED_PLATFORM_MODULE_VP_TRUSTED_PLATFORM_MODULE_SUPPORT = "bios_VfTrustedPlatformModule_vpTrustedPlatformModuleSupport"
    SORT_PROP_BIOS_VF_UCSMBOOT_MODE_CONTROL_SUPPORTED_BY_DEFAULT = "bios_VfUCSMBootModeControl_supportedByDefault"
    SORT_PROP_BIOS_VF_UCSMBOOT_MODE_CONTROL_VP_UEFIBOOT_MODE = "bios_VfUCSMBootModeControl_vpUEFIBootMode"
    SORT_PROP_BIOS_VF_UCSMBOOT_ORDER_RULE_CONTROL_SUPPORTED_BY_DEFAULT = "bios_VfUCSMBootOrderRuleControl_supportedByDefault"
    SORT_PROP_BIOS_VF_UCSMBOOT_ORDER_RULE_CONTROL_VP_UCSMBOOT_ORDER_RULE = "bios_VfUCSMBootOrderRuleControl_vpUCSMBootOrderRule"
    SORT_PROP_BIOS_VF_UEFIOSUSE_LEGACY_VIDEO_SUPPORTED_BY_DEFAULT = "bios_VfUEFIOSUseLegacyVideo_supportedByDefault"
    SORT_PROP_BIOS_VF_UEFIOSUSE_LEGACY_VIDEO_VP_UEFIOSUSE_LEGACY_VIDEO = "bios_VfUEFIOSUseLegacyVideo_vpUEFIOSUseLegacyVideo"
    SORT_PROP_BIOS_VF_USBBOOT_CONFIG_SUPPORTED_BY_DEFAULT = "bios_VfUSBBootConfig_supportedByDefault"
    SORT_PROP_BIOS_VF_USBBOOT_CONFIG_VP_LEGACY_USBSUPPORT = "bios_VfUSBBootConfig_vpLegacyUSBSupport"
    SORT_PROP_BIOS_VF_USBBOOT_CONFIG_VP_MAKE_DEVICE_NON_BOOTABLE = "bios_VfUSBBootConfig_vpMakeDeviceNonBootable"
    SORT_PROP_BIOS_VF_USBCONFIGURATION_SUPPORTED_BY_DEFAULT = "bios_VfUSBConfiguration_supportedByDefault"
    SORT_PROP_BIOS_VF_USBCONFIGURATION_VP_LEGACY_USBSUPPORT = "bios_VfUSBConfiguration_vpLegacyUSBSupport"
    SORT_PROP_BIOS_VF_USBCONFIGURATION_VP_XHCIMODE = "bios_VfUSBConfiguration_vpXHCIMode"
    SORT_PROP_BIOS_VF_USBFRONT_PANEL_ACCESS_LOCK_SUPPORTED_BY_DEFAULT = "bios_VfUSBFrontPanelAccessLock_supportedByDefault"
    SORT_PROP_BIOS_VF_USBFRONT_PANEL_ACCESS_LOCK_VP_USBFRONT_PANEL_LOCK = "bios_VfUSBFrontPanelAccessLock_vpUSBFrontPanelLock"
    SORT_PROP_BIOS_VF_USBPORT_CONFIGURATION_SUPPORTED_BY_DEFAULT = "bios_VfUSBPortConfiguration_supportedByDefault"
    SORT_PROP_BIOS_VF_USBPORT_CONFIGURATION_VP_PORT6064_EMULATION = "bios_VfUSBPortConfiguration_vpPort6064Emulation"
    SORT_PROP_BIOS_VF_USBPORT_CONFIGURATION_VP_USBPORT_FRONT = "bios_VfUSBPortConfiguration_vpUSBPortFront"
    SORT_PROP_BIOS_VF_USBPORT_CONFIGURATION_VP_USBPORT_INTERNAL = "bios_VfUSBPortConfiguration_vpUSBPortInternal"
    SORT_PROP_BIOS_VF_USBPORT_CONFIGURATION_VP_USBPORT_KVM = "bios_VfUSBPortConfiguration_vpUSBPortKVM"
    SORT_PROP_BIOS_VF_USBPORT_CONFIGURATION_VP_USBPORT_REAR = "bios_VfUSBPortConfiguration_vpUSBPortRear"
    SORT_PROP_BIOS_VF_USBPORT_CONFIGURATION_VP_USBPORT_SDCARD = "bios_VfUSBPortConfiguration_vpUSBPortSDCard"
    SORT_PROP_BIOS_VF_USBPORT_CONFIGURATION_VP_USBPORT_VMEDIA = "bios_VfUSBPortConfiguration_vpUSBPortVMedia"
    SORT_PROP_BIOS_VF_USBSYSTEM_IDLE_POWER_OPTIMIZING_SETTING_SUPPORTED_BY_DEFAULT = "bios_VfUSBSystemIdlePowerOptimizingSetting_supportedByDefault"
    SORT_PROP_BIOS_VF_USBSYSTEM_IDLE_POWER_OPTIMIZING_SETTING_VP_USBIDLE_POWER_OPTIMIZING = "bios_VfUSBSystemIdlePowerOptimizingSetting_vpUSBIdlePowerOptimizing"
    SORT_PROP_BIOS_VF_VGAPRIORITY_SUPPORTED_BY_DEFAULT = "bios_VfVGAPriority_supportedByDefault"
    SORT_PROP_BIOS_VF_VGAPRIORITY_VP_VGAPRIORITY = "bios_VfVGAPriority_vpVGAPriority"
    SORT_PROP_BIOS_VF_WORKLOAD_CONFIGURATION_SUPPORTED_BY_DEFAULT = "bios_VfWorkloadConfiguration_supportedByDefault"
    SORT_PROP_BIOS_VF_WORKLOAD_CONFIGURATION_VP_WORKLOAD_CONFIGURATION = "bios_VfWorkloadConfiguration_vpWorkloadConfiguration"
    SORT_PROP_CALLHOME_DEST_EMAIL = "callhome_Dest_email"
    SORT_PROP_CALLHOME_EP_ADMIN_STATE = "callhome_Ep_adminState"
    SORT_PROP_CALLHOME_EP_ALERT_THROTTLING_ADMIN_STATE = "callhome_Ep_alertThrottlingAdminState"
    SORT_PROP_CALLHOME_EP_CONFIG_STATE = "callhome_Ep_configState"
    SORT_PROP_CALLHOME_EP_DESCR = "callhome_Ep_descr"
    SORT_PROP_CALLHOME_EP_INT_ID = "callhome_Ep_intId"
    SORT_PROP_CALLHOME_EP_NAME = "callhome_Ep_name"
    SORT_PROP_CALLHOME_EP_POLICY_LEVEL = "callhome_Ep_policyLevel"
    SORT_PROP_CALLHOME_EP_POLICY_OWNER = "callhome_Ep_policyOwner"
    SORT_PROP_CALLHOME_FAULT_INST_DESCR = "callhome_FaultInst_descr"
    SORT_PROP_CALLHOME_FAULT_INST_EXPAND_INFO = "callhome_FaultInst_expandInfo"
    SORT_PROP_CALLHOME_FAULT_INST_FAULT_CODE = "callhome_FaultInst_faultCode"
    SORT_PROP_CALLHOME_FAULT_INST_SEVERITY = "callhome_FaultInst_severity"
    SORT_PROP_CALLHOME_FAULT_INST_TIME_STAMP = "callhome_FaultInst_timeStamp"
    SORT_PROP_CALLHOME_FAULT_INST_TYPE = "callhome_FaultInst_type"
    SORT_PROP_CALLHOME_HOLDER_FSM_STAGE_DESCR = "callhome_HolderFsmStage_descr"
    SORT_PROP_CALLHOME_HOLDER_FSM_STAGE_LAST_UPDATE_TIME = "callhome_HolderFsmStage_lastUpdateTime"
    SORT_PROP_CALLHOME_HOLDER_FSM_STAGE_NAME = "callhome_HolderFsmStage_name"
    SORT_PROP_CALLHOME_HOLDER_FSM_STAGE_ORDER = "callhome_HolderFsmStage_order"
    SORT_PROP_CALLHOME_HOLDER_FSM_STAGE_RETRY = "callhome_HolderFsmStage_retry"
    SORT_PROP_CALLHOME_HOLDER_FSM_STAGE_STAGE_STATUS = "callhome_HolderFsmStage_stageStatus"
    SORT_PROP_CALLHOME_HOLDER_FSM_TASK_COMPLETION = "callhome_HolderFsmTask_completion"
    SORT_PROP_CALLHOME_HOLDER_FSM_TASK_FLAGS = "callhome_HolderFsmTask_flags"
    SORT_PROP_CALLHOME_HOLDER_FSM_TASK_ITEM = "callhome_HolderFsmTask_item"
    SORT_PROP_CALLHOME_HOLDER_FSM_TASK_SEQ_ID = "callhome_HolderFsmTask_seqId"
    SORT_PROP_CALLHOME_HOLDER_FSM_COMPLETION_TIME = "callhome_HolderFsm_completionTime"
    SORT_PROP_CALLHOME_HOLDER_FSM_CURRENT_FSM = "callhome_HolderFsm_currentFsm"
    SORT_PROP_CALLHOME_HOLDER_FSM_DESCR = "callhome_HolderFsm_descr"
    SORT_PROP_CALLHOME_HOLDER_FSM_FSM_INSTANCE_ID = "callhome_HolderFsm_fsmInstanceId"
    SORT_PROP_CALLHOME_HOLDER_FSM_FSM_STATUS = "callhome_HolderFsm_fsmStatus"
    SORT_PROP_CALLHOME_HOLDER_FSM_PROGRESS = "callhome_HolderFsm_progress"
    SORT_PROP_CALLHOME_HOLDER_FSM_RMT_ERR_CODE = "callhome_HolderFsm_rmtErrCode"
    SORT_PROP_CALLHOME_HOLDER_FSM_RMT_ERR_DESCR = "callhome_HolderFsm_rmtErrDescr"
    SORT_PROP_CALLHOME_HOLDER_FSM_RMT_RSLT = "callhome_HolderFsm_rmtRslt"
    SORT_PROP_CALLHOME_HOLDER_CONFIG_STATE = "callhome_Holder_configState"
    SORT_PROP_CALLHOME_HOLDER_FSM_DESCR = "callhome_Holder_fsmDescr"
    SORT_PROP_CALLHOME_HOLDER_FSM_FLAGS = "callhome_Holder_fsmFlags"
    SORT_PROP_CALLHOME_HOLDER_FSM_PREV = "callhome_Holder_fsmPrev"
    SORT_PROP_CALLHOME_HOLDER_FSM_PROGR = "callhome_Holder_fsmProgr"
    SORT_PROP_CALLHOME_HOLDER_FSM_RMT_INV_ERR_CODE = "callhome_Holder_fsmRmtInvErrCode"
    SORT_PROP_CALLHOME_HOLDER_FSM_RMT_INV_ERR_DESCR = "callhome_Holder_fsmRmtInvErrDescr"
    SORT_PROP_CALLHOME_HOLDER_FSM_RMT_INV_RSLT = "callhome_Holder_fsmRmtInvRslt"
    SORT_PROP_CALLHOME_HOLDER_FSM_STAGE_DESCR = "callhome_Holder_fsmStageDescr"
    SORT_PROP_CALLHOME_HOLDER_FSM_STAMP = "callhome_Holder_fsmStamp"
    SORT_PROP_CALLHOME_HOLDER_FSM_STATUS = "callhome_Holder_fsmStatus"
    SORT_PROP_CALLHOME_HOLDER_FSM_TRY = "callhome_Holder_fsmTry"
    SORT_PROP_CALLHOME_HOLDER_INVENTORY_STATUS = "callhome_Holder_inventoryStatus"
    SORT_PROP_CALLHOME_HTTP_URL = "callhome_Http_url"
    SORT_PROP_CALLHOME_ITEM_DESCR = "callhome_Item_descr"
    SORT_PROP_CALLHOME_ITEM_NAME = "callhome_Item_name"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_ADMIN_STATE = "callhome_PeriodicSystemInventory_adminState"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_INTERVAL_DAYS = "callhome_PeriodicSystemInventory_intervalDays"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_LAST_DEADLINE = "callhome_PeriodicSystemInventory_lastDeadline"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_MAXIMUM_RETRY_COUNT = "callhome_PeriodicSystemInventory_maximumRetryCount"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_MINIMUM_SEND_NOW_INTERVAL_SECONDS = "callhome_PeriodicSystemInventory_minimumSendNowIntervalSeconds"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_NEXT_DEADLINE = "callhome_PeriodicSystemInventory_nextDeadline"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_POLL_INTERVAL_SECONDS = "callhome_PeriodicSystemInventory_pollIntervalSeconds"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_RETRY_COUNT = "callhome_PeriodicSystemInventory_retryCount"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_RETRY_DELAY_MINUTES = "callhome_PeriodicSystemInventory_retryDelayMinutes"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_SEND_NOW = "callhome_PeriodicSystemInventory_sendNow"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_TIME_OF_DAY_HOUR = "callhome_PeriodicSystemInventory_timeOfDayHour"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_TIME_OF_DAY_MINUTE = "callhome_PeriodicSystemInventory_timeOfDayMinute"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_TIME_OF_LAST_ATTEMPT = "callhome_PeriodicSystemInventory_timeOfLastAttempt"
    SORT_PROP_CALLHOME_PERIODIC_SYSTEM_INVENTORY_TIME_OF_LAST_SUCCESS = "callhome_PeriodicSystemInventory_timeOfLastSuccess"
    SORT_PROP_CALLHOME_POLICY_ADMIN_STATE = "callhome_Policy_adminState"
    SORT_PROP_CALLHOME_POLICY_CAUSE = "callhome_Policy_cause"
    SORT_PROP_CALLHOME_POLICY_DESCR = "callhome_Policy_descr"
    SORT_PROP_CALLHOME_POLICY_NAME = "callhome_Policy_name"
    SORT_PROP_CALLHOME_PROFILE_ALERT_GROUPS = "callhome_Profile_alertGroups"
    SORT_PROP_CALLHOME_PROFILE_DESCR = "callhome_Profile_descr"
    SORT_PROP_CALLHOME_PROFILE_FORMAT = "callhome_Profile_format"
    SORT_PROP_CALLHOME_PROFILE_LEVEL = "callhome_Profile_level"
    SORT_PROP_CALLHOME_PROFILE_MAX_SIZE = "callhome_Profile_maxSize"
    SORT_PROP_CALLHOME_PROFILE_NAME = "callhome_Profile_name"
    SORT_PROP_CALLHOME_SMTP_HOST = "callhome_Smtp_host"
    SORT_PROP_CALLHOME_SMTP_PORT = "callhome_Smtp_port"
    SORT_PROP_CALLHOME_SOURCE_ADDR = "callhome_Source_addr"
    SORT_PROP_CALLHOME_SOURCE_CONTACT = "callhome_Source_contact"
    SORT_PROP_CALLHOME_SOURCE_CONTRACT = "callhome_Source_contract"
    SORT_PROP_CALLHOME_SOURCE_CUSTOMER = "callhome_Source_customer"
    SORT_PROP_CALLHOME_SOURCE_EMAIL = "callhome_Source_email"
    SORT_PROP_CALLHOME_SOURCE_FROM = "callhome_Source_from"
    SORT_PROP_CALLHOME_SOURCE_PHONE = "callhome_Source_phone"
    SORT_PROP_CALLHOME_SOURCE_REPLY_TO = "callhome_Source_replyTo"
    SORT_PROP_CALLHOME_SOURCE_SITE = "callhome_Source_site"
    SORT_PROP_CALLHOME_SOURCE_URGENCY = "callhome_Source_urgency"
    SORT_PROP_CALLHOME_TEST_ALERT_DESCRIPTION = "callhome_TestAlert_description"
    SORT_PROP_CALLHOME_TEST_ALERT_GROUP = "callhome_TestAlert_group"
    SORT_PROP_CALLHOME_TEST_ALERT_LEVEL = "callhome_TestAlert_level"
    SORT_PROP_CALLHOME_TEST_ALERT_MESSAGE_SUBTYPE = "callhome_TestAlert_messageSubtype"
    SORT_PROP_CALLHOME_TEST_ALERT_MESSAGE_TYPE = "callhome_TestAlert_messageType"
    SORT_PROP_CALLHOME_TEST_ALERT_SEND_NOW = "callhome_TestAlert_sendNow"
    SORT_PROP_CAPABILITY_DEF_NAME = "capability_Def_name"
    SORT_PROP_CAPABILITY_PROVIDER_DEPRECATED = "capability_Provider_deprecated"
    SORT_PROP_CAPABILITY_PROVIDER_GENCOUNT = "capability_Provider_gencount"
    SORT_PROP_CAPABILITY_PROVIDER_MGMT_PLANE_VER = "capability_Provider_mgmtPlaneVer"
    SORT_PROP_CAPABILITY_PROVIDER_MODEL = "capability_Provider_model"
    SORT_PROP_CAPABILITY_PROVIDER_VENDOR = "capability_Provider_vendor"
    SORT_PROP_CERT_REPAIR_EP_FSM_STAGE_DESCR = "cert_RepairEpFsmStage_descr"
    SORT_PROP_CERT_REPAIR_EP_FSM_STAGE_LAST_UPDATE_TIME = "cert_RepairEpFsmStage_lastUpdateTime"
    SORT_PROP_CERT_REPAIR_EP_FSM_STAGE_NAME = "cert_RepairEpFsmStage_name"
    SORT_PROP_CERT_REPAIR_EP_FSM_STAGE_ORDER = "cert_RepairEpFsmStage_order"
    SORT_PROP_CERT_REPAIR_EP_FSM_STAGE_RETRY = "cert_RepairEpFsmStage_retry"
    SORT_PROP_CERT_REPAIR_EP_FSM_STAGE_STAGE_STATUS = "cert_RepairEpFsmStage_stageStatus"
    SORT_PROP_CERT_REPAIR_EP_FSM_TASK_COMPLETION = "cert_RepairEpFsmTask_completion"
    SORT_PROP_CERT_REPAIR_EP_FSM_TASK_FLAGS = "cert_RepairEpFsmTask_flags"
    SORT_PROP_CERT_REPAIR_EP_FSM_TASK_ITEM = "cert_RepairEpFsmTask_item"
    SORT_PROP_CERT_REPAIR_EP_FSM_TASK_SEQ_ID = "cert_RepairEpFsmTask_seqId"
    SORT_PROP_CERT_REPAIR_EP_FSM_COMPLETION_TIME = "cert_RepairEpFsm_completionTime"
    SORT_PROP_CERT_REPAIR_EP_FSM_CURRENT_FSM = "cert_RepairEpFsm_currentFsm"
    SORT_PROP_CERT_REPAIR_EP_FSM_DESCR = "cert_RepairEpFsm_descr"
    SORT_PROP_CERT_REPAIR_EP_FSM_FSM_INSTANCE_ID = "cert_RepairEpFsm_fsmInstanceId"
    SORT_PROP_CERT_REPAIR_EP_FSM_FSM_STATUS = "cert_RepairEpFsm_fsmStatus"
    SORT_PROP_CERT_REPAIR_EP_FSM_PROGRESS = "cert_RepairEpFsm_progress"
    SORT_PROP_CERT_REPAIR_EP_FSM_RMT_ERR_CODE = "cert_RepairEpFsm_rmtErrCode"
    SORT_PROP_CERT_REPAIR_EP_FSM_RMT_ERR_DESCR = "cert_RepairEpFsm_rmtErrDescr"
    SORT_PROP_CERT_REPAIR_EP_FSM_RMT_RSLT = "cert_RepairEpFsm_rmtRslt"
    SORT_PROP_CERT_REPAIR_EP_FSM_DESCR = "cert_RepairEp_fsmDescr"
    SORT_PROP_CERT_REPAIR_EP_FSM_PREV = "cert_RepairEp_fsmPrev"
    SORT_PROP_CERT_REPAIR_EP_FSM_PROGR = "cert_RepairEp_fsmProgr"
    SORT_PROP_CERT_REPAIR_EP_FSM_RMT_INV_ERR_CODE = "cert_RepairEp_fsmRmtInvErrCode"
    SORT_PROP_CERT_REPAIR_EP_FSM_RMT_INV_ERR_DESCR = "cert_RepairEp_fsmRmtInvErrDescr"
    SORT_PROP_CERT_REPAIR_EP_FSM_RMT_INV_RSLT = "cert_RepairEp_fsmRmtInvRslt"
    SORT_PROP_CERT_REPAIR_EP_FSM_STAGE_DESCR = "cert_RepairEp_fsmStageDescr"
    SORT_PROP_CERT_REPAIR_EP_FSM_STAMP = "cert_RepairEp_fsmStamp"
    SORT_PROP_CERT_REPAIR_EP_FSM_STATUS = "cert_RepairEp_fsmStatus"
    SORT_PROP_CERT_REPAIR_EP_FSM_TRY = "cert_RepairEp_fsmTry"
    SORT_PROP_CERT_REPAIR_EP_REPAIR_STATE = "cert_RepairEp_repairState"
    SORT_PROP_CHANGE_CHANGED_OBJECT_REF_CENTRALE_MO_DN = "change_ChangedObjectRef_centraleMoDn"
    SORT_PROP_CHANGE_CHANGED_OBJECT_REF_CHANGED_MO_CLASS_ID = "change_ChangedObjectRef_changedMoClassId"
    SORT_PROP_CHANGE_CHANGED_OBJECT_REF_GUID = "change_ChangedObjectRef_guid"
    SORT_PROP_CHANGE_CHANGED_OBJECT_REF_ID = "change_ChangedObjectRef_id"
    SORT_PROP_CHANGE_CHANGED_OBJECT_REF_OLD_CENTRALE_MO_DN = "change_ChangedObjectRef_oldCentraleMoDn"
    SORT_PROP_CHANGE_CHANGED_OBJECT_REF_REF_OBJ_STATUS = "change_ChangedObjectRef_refObjStatus"
    SORT_PROP_CHANGE_CHANGED_OBJECT_REF_UCSM_MO_DN = "change_ChangedObjectRef_ucsmMoDn"
    SORT_PROP_CHANGE_EP_FSM_STAGE_DESCR = "change_EpFsmStage_descr"
    SORT_PROP_CHANGE_EP_FSM_STAGE_LAST_UPDATE_TIME = "change_EpFsmStage_lastUpdateTime"
    SORT_PROP_CHANGE_EP_FSM_STAGE_NAME = "change_EpFsmStage_name"
    SORT_PROP_CHANGE_EP_FSM_STAGE_ORDER = "change_EpFsmStage_order"
    SORT_PROP_CHANGE_EP_FSM_STAGE_RETRY = "change_EpFsmStage_retry"
    SORT_PROP_CHANGE_EP_FSM_STAGE_STAGE_STATUS = "change_EpFsmStage_stageStatus"
    SORT_PROP_CHANGE_EP_FSM_TASK_COMPLETION = "change_EpFsmTask_completion"
    SORT_PROP_CHANGE_EP_FSM_TASK_FLAGS = "change_EpFsmTask_flags"
    SORT_PROP_CHANGE_EP_FSM_TASK_ITEM = "change_EpFsmTask_item"
    SORT_PROP_CHANGE_EP_FSM_TASK_SEQ_ID = "change_EpFsmTask_seqId"
    SORT_PROP_CHANGE_EP_FSM_COMPLETION_TIME = "change_EpFsm_completionTime"
    SORT_PROP_CHANGE_EP_FSM_CURRENT_FSM = "change_EpFsm_currentFsm"
    SORT_PROP_CHANGE_EP_FSM_DESCR = "change_EpFsm_descr"
    SORT_PROP_CHANGE_EP_FSM_FSM_INSTANCE_ID = "change_EpFsm_fsmInstanceId"
    SORT_PROP_CHANGE_EP_FSM_FSM_STATUS = "change_EpFsm_fsmStatus"
    SORT_PROP_CHANGE_EP_FSM_PROGRESS = "change_EpFsm_progress"
    SORT_PROP_CHANGE_EP_FSM_RMT_ERR_CODE = "change_EpFsm_rmtErrCode"
    SORT_PROP_CHANGE_EP_FSM_RMT_ERR_DESCR = "change_EpFsm_rmtErrDescr"
    SORT_PROP_CHANGE_EP_FSM_RMT_RSLT = "change_EpFsm_rmtRslt"
    SORT_PROP_CHANGE_EP_FSM_DESCR = "change_Ep_fsmDescr"
    SORT_PROP_CHANGE_EP_FSM_PREV = "change_Ep_fsmPrev"
    SORT_PROP_CHANGE_EP_FSM_PROGR = "change_Ep_fsmProgr"
    SORT_PROP_CHANGE_EP_FSM_RMT_INV_ERR_CODE = "change_Ep_fsmRmtInvErrCode"
    SORT_PROP_CHANGE_EP_FSM_RMT_INV_ERR_DESCR = "change_Ep_fsmRmtInvErrDescr"
    SORT_PROP_CHANGE_EP_FSM_RMT_INV_RSLT = "change_Ep_fsmRmtInvRslt"
    SORT_PROP_CHANGE_EP_FSM_STAGE_DESCR = "change_Ep_fsmStageDescr"
    SORT_PROP_CHANGE_EP_FSM_STAMP = "change_Ep_fsmStamp"
    SORT_PROP_CHANGE_EP_FSM_STATUS = "change_Ep_fsmStatus"
    SORT_PROP_CHANGE_EP_FSM_TRY = "change_Ep_fsmTry"
    SORT_PROP_CHANGE_EP_GEN_NUM_SYNC = "change_Ep_genNumSync"
    SORT_PROP_CHANGE_EP_ID = "change_Ep_id"
    SORT_PROP_CHANGE_EP_IS_CHANGED_OBJECT_UPDATE = "change_Ep_isChangedObjectUpdate"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_AUTH_OPTION = "cimcvmedia_ActualMountEntry_authOption"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_DEVICE_TYPE = "cimcvmedia_ActualMountEntry_deviceType"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_ENC_PWD = "cimcvmedia_ActualMountEntry_encPwd"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_ERROR_TYPE = "cimcvmedia_ActualMountEntry_errorType"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_IMAGE_FILE_NAME = "cimcvmedia_ActualMountEntry_imageFileName"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_IMAGE_NAME_VARIABLE = "cimcvmedia_ActualMountEntry_imageNameVariable"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_IMAGE_PATH = "cimcvmedia_ActualMountEntry_imagePath"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_MAPPING_NAME = "cimcvmedia_ActualMountEntry_mappingName"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_MOUNT_PROTOCOL = "cimcvmedia_ActualMountEntry_mountProtocol"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_OPER_MOUNT_STATUS = "cimcvmedia_ActualMountEntry_operMountStatus"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_PASSWORD = "cimcvmedia_ActualMountEntry_password"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_PWD_SET = "cimcvmedia_ActualMountEntry_pwdSet"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_REMOTE_HOST = "cimcvmedia_ActualMountEntry_remoteHost"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_REMOTE_IP_ADDRESS = "cimcvmedia_ActualMountEntry_remoteIpAddress"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_REMOTE_PORT = "cimcvmedia_ActualMountEntry_remotePort"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_USER_ID = "cimcvmedia_ActualMountEntry_userId"
    SORT_PROP_CIMCVMEDIA_ACTUAL_MOUNT_ENTRY_VIRTUAL_DISK_ID = "cimcvmedia_ActualMountEntry_virtualDiskId"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_AUTH_OPTION = "cimcvmedia_ConfigMountEntry_authOption"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_DESCRIPTION = "cimcvmedia_ConfigMountEntry_description"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_DEVICE_TYPE = "cimcvmedia_ConfigMountEntry_deviceType"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_ENC_PWD = "cimcvmedia_ConfigMountEntry_encPwd"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_IMAGE_FILE_NAME = "cimcvmedia_ConfigMountEntry_imageFileName"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_IMAGE_NAME_VARIABLE = "cimcvmedia_ConfigMountEntry_imageNameVariable"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_IMAGE_PATH = "cimcvmedia_ConfigMountEntry_imagePath"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_MAPPING_NAME = "cimcvmedia_ConfigMountEntry_mappingName"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_MOUNT_PROTOCOL = "cimcvmedia_ConfigMountEntry_mountProtocol"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_PASSWORD = "cimcvmedia_ConfigMountEntry_password"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_PWD_SET = "cimcvmedia_ConfigMountEntry_pwdSet"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_REMOTE_HOST = "cimcvmedia_ConfigMountEntry_remoteHost"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_REMOTE_IP_ADDRESS = "cimcvmedia_ConfigMountEntry_remoteIpAddress"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_REMOTE_PORT = "cimcvmedia_ConfigMountEntry_remotePort"
    SORT_PROP_CIMCVMEDIA_CONFIG_MOUNT_ENTRY_USER_ID = "cimcvmedia_ConfigMountEntry_userId"
    SORT_PROP_CIMCVMEDIA_EXT_MGMT_RULE_ENTRY_EXT_MGMT_IP_ADDR = "cimcvmedia_ExtMgmtRuleEntry_extMgmtIpAddr"
    SORT_PROP_CIMCVMEDIA_EXT_MGMT_RULE_ENTRY_MAPPING_NAME = "cimcvmedia_ExtMgmtRuleEntry_mappingName"
    SORT_PROP_CIMCVMEDIA_EXT_MGMT_RULE_ENTRY_MGMT_IF_IP_ADDR = "cimcvmedia_ExtMgmtRuleEntry_mgmtIfIpAddr"
    SORT_PROP_CIMCVMEDIA_EXT_MGMT_RULE_ENTRY_MOUNT_PROTOCOL = "cimcvmedia_ExtMgmtRuleEntry_mountProtocol"
    SORT_PROP_CIMCVMEDIA_EXT_MGMT_RULE_ENTRY_REMOTE_IP_ADDR = "cimcvmedia_ExtMgmtRuleEntry_remoteIpAddr"
    SORT_PROP_CIMCVMEDIA_EXT_MGMT_RULE_ENTRY_REMOTE_PORT = "cimcvmedia_ExtMgmtRuleEntry_remotePort"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_DEF_DESCR = "cimcvmedia_MountConfigDef_descr"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_DEF_INT_ID = "cimcvmedia_MountConfigDef_intId"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_DEF_NAME = "cimcvmedia_MountConfigDef_name"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_DEF_POLICY_LEVEL = "cimcvmedia_MountConfigDef_policyLevel"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_DEF_POLICY_OWNER = "cimcvmedia_MountConfigDef_policyOwner"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_DEF_RETRY_ON_MOUNT_FAIL = "cimcvmedia_MountConfigDef_retryOnMountFail"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_POLICY_DESCR = "cimcvmedia_MountConfigPolicy_descr"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_POLICY_INT_ID = "cimcvmedia_MountConfigPolicy_intId"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_POLICY_NAME = "cimcvmedia_MountConfigPolicy_name"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_POLICY_POLICY_LEVEL = "cimcvmedia_MountConfigPolicy_policyLevel"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_POLICY_POLICY_OWNER = "cimcvmedia_MountConfigPolicy_policyOwner"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_POLICY_RETRY_ON_MOUNT_FAIL = "cimcvmedia_MountConfigPolicy_retryOnMountFail"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_DESCR = "cimcvmedia_MountConfig_descr"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_INT_ID = "cimcvmedia_MountConfig_intId"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_NAME = "cimcvmedia_MountConfig_name"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_POLICY_LEVEL = "cimcvmedia_MountConfig_policyLevel"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_POLICY_OWNER = "cimcvmedia_MountConfig_policyOwner"
    SORT_PROP_CIMCVMEDIA_MOUNT_CONFIG_RETRY_ON_MOUNT_FAIL = "cimcvmedia_MountConfig_retryOnMountFail"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_AUTH_OPTION = "cimcvmedia_MountInfo_authOption"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_DEVICE_TYPE = "cimcvmedia_MountInfo_deviceType"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_ENC_PWD = "cimcvmedia_MountInfo_encPwd"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_IMAGE_FILE_NAME = "cimcvmedia_MountInfo_imageFileName"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_IMAGE_NAME_VARIABLE = "cimcvmedia_MountInfo_imageNameVariable"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_IMAGE_PATH = "cimcvmedia_MountInfo_imagePath"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_MAPPING_NAME = "cimcvmedia_MountInfo_mappingName"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_MOUNT_PROTOCOL = "cimcvmedia_MountInfo_mountProtocol"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_PASSWORD = "cimcvmedia_MountInfo_password"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_PWD_SET = "cimcvmedia_MountInfo_pwdSet"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_REMOTE_HOST = "cimcvmedia_MountInfo_remoteHost"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_REMOTE_IP_ADDRESS = "cimcvmedia_MountInfo_remoteIpAddress"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_REMOTE_PORT = "cimcvmedia_MountInfo_remotePort"
    SORT_PROP_CIMCVMEDIA_MOUNT_INFO_USER_ID = "cimcvmedia_MountInfo_userId"
    SORT_PROP_CLITEST_TYPE_TEST2_A_PARTIAL_ENUM = "clitest_TypeTest2_aPartialEnum"
    SORT_PROP_CLITEST_TYPE_TEST2_ABITMASK = "clitest_TypeTest2_abitmask"
    SORT_PROP_CLITEST_TYPE_TEST2_ACHARBUF = "clitest_TypeTest2_acharbuf"
    SORT_PROP_CLITEST_TYPE_TEST2_FILE_DIR = "clitest_TypeTest2_fileDir"
    SORT_PROP_CLITEST_TYPE_TEST2_FILE_HOST = "clitest_TypeTest2_fileHost"
    SORT_PROP_CLITEST_TYPE_TEST2_FILE_NAME = "clitest_TypeTest2_fileName"
    SORT_PROP_CLITEST_TYPE_TEST2_FILE_PASSWD = "clitest_TypeTest2_filePasswd"
    SORT_PROP_CLITEST_TYPE_TEST2_FILE_PATH = "clitest_TypeTest2_filePath"
    SORT_PROP_CLITEST_TYPE_TEST2_FILE_PORT = "clitest_TypeTest2_filePort"
    SORT_PROP_CLITEST_TYPE_TEST2_FILE_PROTO = "clitest_TypeTest2_fileProto"
    SORT_PROP_CLITEST_TYPE_TEST2_FILE_USER = "clitest_TypeTest2_fileUser"
    SORT_PROP_CLITEST_TYPE_TEST_CHILD_ASTRING = "clitest_TypeTestChild_astring"
    SORT_PROP_CLITEST_TYPE_TEST_CHILD_DESCR = "clitest_TypeTestChild_descr"
    SORT_PROP_CLITEST_TYPE_TEST_CHILD_INT_ID = "clitest_TypeTestChild_intId"
    SORT_PROP_CLITEST_TYPE_TEST_CHILD_NAME = "clitest_TypeTestChild_name"
    SORT_PROP_CLITEST_TYPE_TEST_PARENT_ASTRING = "clitest_TypeTestParent_astring"
    SORT_PROP_CLITEST_TYPE_TEST_PARENT_DESCR = "clitest_TypeTestParent_descr"
    SORT_PROP_CLITEST_TYPE_TEST_PARENT_INT_ID = "clitest_TypeTestParent_intId"
    SORT_PROP_CLITEST_TYPE_TEST_PARENT_NAME = "clitest_TypeTestParent_name"
    SORT_PROP_CLITEST_TYPE_TEST_ACHAR = "clitest_TypeTest_achar"
    SORT_PROP_CLITEST_TYPE_TEST_ADATE = "clitest_TypeTest_adate"
    SORT_PROP_CLITEST_TYPE_TEST_ADATETIME = "clitest_TypeTest_adatetime"
    SORT_PROP_CLITEST_TYPE_TEST_AFLOAT = "clitest_TypeTest_afloat"
    SORT_PROP_CLITEST_TYPE_TEST_AMAC = "clitest_TypeTest_amac"
    SORT_PROP_CLITEST_TYPE_TEST_ANENUM = "clitest_TypeTest_anenum"
    SORT_PROP_CLITEST_TYPE_TEST_ANIPV4 = "clitest_TypeTest_anipv4"
    SORT_PROP_CLITEST_TYPE_TEST_ANIPV6 = "clitest_TypeTest_anipv6"
    SORT_PROP_CLITEST_TYPE_TEST_ANSBYTE = "clitest_TypeTest_ansbyte"
    SORT_PROP_CLITEST_TYPE_TEST_ANSINT16 = "clitest_TypeTest_ansint16"
    SORT_PROP_CLITEST_TYPE_TEST_ANSINT32 = "clitest_TypeTest_ansint32"
    SORT_PROP_CLITEST_TYPE_TEST_ANSINT64 = "clitest_TypeTest_ansint64"
    SORT_PROP_CLITEST_TYPE_TEST_APASSWORD = "clitest_TypeTest_apassword"
    SORT_PROP_CLITEST_TYPE_TEST_ARANGE = "clitest_TypeTest_arange"
    SORT_PROP_CLITEST_TYPE_TEST_ARCSTRING = "clitest_TypeTest_arcstring"
    SORT_PROP_CLITEST_TYPE_TEST_ARXSTRING = "clitest_TypeTest_arxstring"
    SORT_PROP_CLITEST_TYPE_TEST_ASTRING = "clitest_TypeTest_astring"
    SORT_PROP_CLITEST_TYPE_TEST_ATIME = "clitest_TypeTest_atime"
    SORT_PROP_CLITEST_TYPE_TEST_AUBYTE = "clitest_TypeTest_aubyte"
    SORT_PROP_CLITEST_TYPE_TEST_AUINT16 = "clitest_TypeTest_auint16"
    SORT_PROP_CLITEST_TYPE_TEST_AUINT32 = "clitest_TypeTest_auint32"
    SORT_PROP_CLITEST_TYPE_TEST_AUINT64 = "clitest_TypeTest_auint64"
    SORT_PROP_CLITEST_TYPE_TEST_AWWN = "clitest_TypeTest_awwn"
    SORT_PROP_COMM_CIMXML_ADMIN_STATE = "comm_Cimxml_adminState"
    SORT_PROP_COMM_CIMXML_DESCR = "comm_Cimxml_descr"
    SORT_PROP_COMM_CIMXML_INT_ID = "comm_Cimxml_intId"
    SORT_PROP_COMM_CIMXML_NAME = "comm_Cimxml_name"
    SORT_PROP_COMM_CIMXML_OPER_PORT = "comm_Cimxml_operPort"
    SORT_PROP_COMM_CIMXML_POLICY_LEVEL = "comm_Cimxml_policyLevel"
    SORT_PROP_COMM_CIMXML_POLICY_OWNER = "comm_Cimxml_policyOwner"
    SORT_PROP_COMM_CIMXML_PORT = "comm_Cimxml_port"
    SORT_PROP_COMM_CIMXML_PROTO = "comm_Cimxml_proto"
    SORT_PROP_COMM_CLIENT_ITEM_ADMIN_STATE = "comm_ClientItem_adminState"
    SORT_PROP_COMM_CLIENT_ITEM_DESCR = "comm_ClientItem_descr"
    SORT_PROP_COMM_CLIENT_ITEM_HOSTNAME = "comm_ClientItem_hostname"
    SORT_PROP_COMM_CLIENT_ITEM_NAME = "comm_ClientItem_name"
    SORT_PROP_COMM_CLIENT_ADMIN_STATE = "comm_Client_adminState"
    SORT_PROP_COMM_CLIENT_DESCR = "comm_Client_descr"
    SORT_PROP_COMM_CLIENT_HOSTNAME = "comm_Client_hostname"
    SORT_PROP_COMM_CLIENT_INT_ID = "comm_Client_intId"
    SORT_PROP_COMM_CLIENT_NAME = "comm_Client_name"
    SORT_PROP_COMM_CLIENT_POLICY_LEVEL = "comm_Client_policyLevel"
    SORT_PROP_COMM_CLIENT_POLICY_OWNER = "comm_Client_policyOwner"
    SORT_PROP_COMM_CORE_FILE_ADMIN_STATE = "comm_CoreFile_adminState"
    SORT_PROP_COMM_CORE_FILE_DESCR = "comm_CoreFile_descr"
    SORT_PROP_COMM_CORE_FILE_FILE_TRANSFER_PROTO = "comm_CoreFile_fileTransferProto"
    SORT_PROP_COMM_CORE_FILE_HOSTNAME = "comm_CoreFile_hostname"
    SORT_PROP_COMM_CORE_FILE_INT_ID = "comm_CoreFile_intId"
    SORT_PROP_COMM_CORE_FILE_NAME = "comm_CoreFile_name"
    SORT_PROP_COMM_CORE_FILE_OPER_PORT = "comm_CoreFile_operPort"
    SORT_PROP_COMM_CORE_FILE_PATH = "comm_CoreFile_path"
    SORT_PROP_COMM_CORE_FILE_POLICY_LEVEL = "comm_CoreFile_policyLevel"
    SORT_PROP_COMM_CORE_FILE_POLICY_OWNER = "comm_CoreFile_policyOwner"
    SORT_PROP_COMM_CORE_FILE_PORT = "comm_CoreFile_port"
    SORT_PROP_COMM_CORE_FILE_PROTO = "comm_CoreFile_proto"
    SORT_PROP_COMM_DATE_TIME_FSM_STAGE_DESCR = "comm_DateTimeFsmStage_descr"
    SORT_PROP_COMM_DATE_TIME_FSM_STAGE_LAST_UPDATE_TIME = "comm_DateTimeFsmStage_lastUpdateTime"
    SORT_PROP_COMM_DATE_TIME_FSM_STAGE_NAME = "comm_DateTimeFsmStage_name"
    SORT_PROP_COMM_DATE_TIME_FSM_STAGE_ORDER = "comm_DateTimeFsmStage_order"
    SORT_PROP_COMM_DATE_TIME_FSM_STAGE_RETRY = "comm_DateTimeFsmStage_retry"
    SORT_PROP_COMM_DATE_TIME_FSM_STAGE_STAGE_STATUS = "comm_DateTimeFsmStage_stageStatus"
    SORT_PROP_COMM_DATE_TIME_FSM_TASK_COMPLETION = "comm_DateTimeFsmTask_completion"
    SORT_PROP_COMM_DATE_TIME_FSM_TASK_FLAGS = "comm_DateTimeFsmTask_flags"
    SORT_PROP_COMM_DATE_TIME_FSM_TASK_ITEM = "comm_DateTimeFsmTask_item"
    SORT_PROP_COMM_DATE_TIME_FSM_TASK_SEQ_ID = "comm_DateTimeFsmTask_seqId"
    SORT_PROP_COMM_DATE_TIME_FSM_COMPLETION_TIME = "comm_DateTimeFsm_completionTime"
    SORT_PROP_COMM_DATE_TIME_FSM_CURRENT_FSM = "comm_DateTimeFsm_currentFsm"
    SORT_PROP_COMM_DATE_TIME_FSM_DESCR = "comm_DateTimeFsm_descr"
    SORT_PROP_COMM_DATE_TIME_FSM_FSM_INSTANCE_ID = "comm_DateTimeFsm_fsmInstanceId"
    SORT_PROP_COMM_DATE_TIME_FSM_FSM_STATUS = "comm_DateTimeFsm_fsmStatus"
    SORT_PROP_COMM_DATE_TIME_FSM_PROGRESS = "comm_DateTimeFsm_progress"
    SORT_PROP_COMM_DATE_TIME_FSM_RMT_ERR_CODE = "comm_DateTimeFsm_rmtErrCode"
    SORT_PROP_COMM_DATE_TIME_FSM_RMT_ERR_DESCR = "comm_DateTimeFsm_rmtErrDescr"
    SORT_PROP_COMM_DATE_TIME_FSM_RMT_RSLT = "comm_DateTimeFsm_rmtRslt"
    SORT_PROP_COMM_DATE_TIME_ADMIN_STATE = "comm_DateTime_adminState"
    SORT_PROP_COMM_DATE_TIME_DATE = "comm_DateTime_date"
    SORT_PROP_COMM_DATE_TIME_DESCR = "comm_DateTime_descr"
    SORT_PROP_COMM_DATE_TIME_FSM_DESCR = "comm_DateTime_fsmDescr"
    SORT_PROP_COMM_DATE_TIME_FSM_PREV = "comm_DateTime_fsmPrev"
    SORT_PROP_COMM_DATE_TIME_FSM_PROGR = "comm_DateTime_fsmProgr"
    SORT_PROP_COMM_DATE_TIME_FSM_RMT_INV_ERR_CODE = "comm_DateTime_fsmRmtInvErrCode"
    SORT_PROP_COMM_DATE_TIME_FSM_RMT_INV_ERR_DESCR = "comm_DateTime_fsmRmtInvErrDescr"
    SORT_PROP_COMM_DATE_TIME_FSM_RMT_INV_RSLT = "comm_DateTime_fsmRmtInvRslt"
    SORT_PROP_COMM_DATE_TIME_FSM_STAGE_DESCR = "comm_DateTime_fsmStageDescr"
    SORT_PROP_COMM_DATE_TIME_FSM_STAMP = "comm_DateTime_fsmStamp"
    SORT_PROP_COMM_DATE_TIME_FSM_STATUS = "comm_DateTime_fsmStatus"
    SORT_PROP_COMM_DATE_TIME_FSM_TRY = "comm_DateTime_fsmTry"
    SORT_PROP_COMM_DATE_TIME_INT_ID = "comm_DateTime_intId"
    SORT_PROP_COMM_DATE_TIME_NAME = "comm_DateTime_name"
    SORT_PROP_COMM_DATE_TIME_OPER_PORT = "comm_DateTime_operPort"
    SORT_PROP_COMM_DATE_TIME_POLICY_LEVEL = "comm_DateTime_policyLevel"
    SORT_PROP_COMM_DATE_TIME_POLICY_OWNER = "comm_DateTime_policyOwner"
    SORT_PROP_COMM_DATE_TIME_PORT = "comm_DateTime_port"
    SORT_PROP_COMM_DATE_TIME_PROTO = "comm_DateTime_proto"
    SORT_PROP_COMM_DATE_TIME_TIMEZONE = "comm_DateTime_timezone"
    SORT_PROP_COMM_DEFINITION_DESCR = "comm_Definition_descr"
    SORT_PROP_COMM_DEFINITION_INT_ID = "comm_Definition_intId"
    SORT_PROP_COMM_DEFINITION_NAME = "comm_Definition_name"
    SORT_PROP_COMM_DEFINITION_POLICY_LEVEL = "comm_Definition_policyLevel"
    SORT_PROP_COMM_DEFINITION_POLICY_OWNER = "comm_Definition_policyOwner"
    SORT_PROP_COMM_DNS_PROVIDER_ADMIN_STATE = "comm_DnsProvider_adminState"
    SORT_PROP_COMM_DNS_PROVIDER_DESCR = "comm_DnsProvider_descr"
    SORT_PROP_COMM_DNS_PROVIDER_HOSTNAME = "comm_DnsProvider_hostname"
    SORT_PROP_COMM_DNS_PROVIDER_NAME = "comm_DnsProvider_name"
    SORT_PROP_COMM_DNS_ADMIN_STATE = "comm_Dns_adminState"
    SORT_PROP_COMM_DNS_DESCR = "comm_Dns_descr"
    SORT_PROP_COMM_DNS_DOMAIN = "comm_Dns_domain"
    SORT_PROP_COMM_DNS_INT_ID = "comm_Dns_intId"
    SORT_PROP_COMM_DNS_NAME = "comm_Dns_name"
    SORT_PROP_COMM_DNS_OPER_PORT = "comm_Dns_operPort"
    SORT_PROP_COMM_DNS_POLICY_LEVEL = "comm_Dns_policyLevel"
    SORT_PROP_COMM_DNS_POLICY_OWNER = "comm_Dns_policyOwner"
    SORT_PROP_COMM_DNS_PORT = "comm_Dns_port"
    SORT_PROP_COMM_DNS_PROTO = "comm_Dns_proto"
    SORT_PROP_COMM_EVT_CHANNEL_CHANNEL_STATE = "comm_EvtChannel_channelState"
    SORT_PROP_COMM_EVT_CHANNEL_DESCR = "comm_EvtChannel_descr"
    SORT_PROP_COMM_EVT_CHANNEL_INT_ID = "comm_EvtChannel_intId"
    SORT_PROP_COMM_EVT_CHANNEL_NAME = "comm_EvtChannel_name"
    SORT_PROP_COMM_EVT_CHANNEL_POLICY_LEVEL = "comm_EvtChannel_policyLevel"
    SORT_PROP_COMM_EVT_CHANNEL_POLICY_OWNER = "comm_EvtChannel_policyOwner"
    SORT_PROP_COMM_HTTP_ADMIN_STATE = "comm_Http_adminState"
    SORT_PROP_COMM_HTTP_DESCR = "comm_Http_descr"
    SORT_PROP_COMM_HTTP_INT_ID = "comm_Http_intId"
    SORT_PROP_COMM_HTTP_NAME = "comm_Http_name"
    SORT_PROP_COMM_HTTP_OPER_PORT = "comm_Http_operPort"
    SORT_PROP_COMM_HTTP_POLICY_LEVEL = "comm_Http_policyLevel"
    SORT_PROP_COMM_HTTP_POLICY_OWNER = "comm_Http_policyOwner"
    SORT_PROP_COMM_HTTP_PORT = "comm_Http_port"
    SORT_PROP_COMM_HTTP_PROTO = "comm_Http_proto"
    SORT_PROP_COMM_HTTP_REDIRECT_STATE = "comm_Http_redirectState"
    SORT_PROP_COMM_HTTPS_ADMIN_STATE = "comm_Https_adminState"
    SORT_PROP_COMM_HTTPS_DESCR = "comm_Https_descr"
    SORT_PROP_COMM_HTTPS_INT_ID = "comm_Https_intId"
    SORT_PROP_COMM_HTTPS_KEY_RING = "comm_Https_keyRing"
    SORT_PROP_COMM_HTTPS_KEYRING_CERT = "comm_Https_keyringCert"
    SORT_PROP_COMM_HTTPS_NAME = "comm_Https_name"
    SORT_PROP_COMM_HTTPS_OPER_PORT = "comm_Https_operPort"
    SORT_PROP_COMM_HTTPS_POLICY_LEVEL = "comm_Https_policyLevel"
    SORT_PROP_COMM_HTTPS_POLICY_OWNER = "comm_Https_policyOwner"
    SORT_PROP_COMM_HTTPS_PORT = "comm_Https_port"
    SORT_PROP_COMM_HTTPS_PROTO = "comm_Https_proto"
    SORT_PROP_COMM_HTTPS_TP = "comm_Https_tp"
    SORT_PROP_COMM_ITEM_DESCR = "comm_Item_descr"
    SORT_PROP_COMM_ITEM_NAME = "comm_Item_name"
    SORT_PROP_COMM_LOCALE_DESCR = "comm_Locale_descr"
    SORT_PROP_COMM_LOCALE_NAME = "comm_Locale_name"
    SORT_PROP_COMM_LOG_COMPONENT_NAME = "comm_LogComponent_name"
    SORT_PROP_COMM_LOG_COMPONENT_SEVERITY = "comm_LogComponent_severity"
    SORT_PROP_COMM_NTP_PROVIDER_ADMIN_STATE = "comm_NtpProvider_adminState"
    SORT_PROP_COMM_NTP_PROVIDER_DESCR = "comm_NtpProvider_descr"
    SORT_PROP_COMM_NTP_PROVIDER_HOSTNAME = "comm_NtpProvider_hostname"
    SORT_PROP_COMM_NTP_PROVIDER_NAME = "comm_NtpProvider_name"
    SORT_PROP_COMM_NTP_ADMIN_STATE = "comm_Ntp_adminState"
    SORT_PROP_COMM_NTP_DESCR = "comm_Ntp_descr"
    SORT_PROP_COMM_NTP_INT_ID = "comm_Ntp_intId"
    SORT_PROP_COMM_NTP_NAME = "comm_Ntp_name"
    SORT_PROP_COMM_NTP_OPER_PORT = "comm_Ntp_operPort"
    SORT_PROP_COMM_NTP_POLICY_LEVEL = "comm_Ntp_policyLevel"
    SORT_PROP_COMM_NTP_POLICY_OWNER = "comm_Ntp_policyOwner"
    SORT_PROP_COMM_NTP_PORT = "comm_Ntp_port"
    SORT_PROP_COMM_NTP_PROTO = "comm_Ntp_proto"
    SORT_PROP_COMM_SHELL_SVC_LIMITS_DESCR = "comm_ShellSvcLimits_descr"
    SORT_PROP_COMM_SHELL_SVC_LIMITS_INT_ID = "comm_ShellSvcLimits_intId"
    SORT_PROP_COMM_SHELL_SVC_LIMITS_NAME = "comm_ShellSvcLimits_name"
    SORT_PROP_COMM_SHELL_SVC_LIMITS_POLICY_LEVEL = "comm_ShellSvcLimits_policyLevel"
    SORT_PROP_COMM_SHELL_SVC_LIMITS_POLICY_OWNER = "comm_ShellSvcLimits_policyOwner"
    SORT_PROP_COMM_SHELL_SVC_LIMITS_SESSIONS_PER_USER = "comm_ShellSvcLimits_sessionsPerUser"
    SORT_PROP_COMM_SHELL_SVC_LIMITS_TOTAL_SESSIONS = "comm_ShellSvcLimits_totalSessions"
    SORT_PROP_COMM_SHELL_ADMIN_STATE = "comm_Shell_adminState"
    SORT_PROP_COMM_SHELL_DESCR = "comm_Shell_descr"
    SORT_PROP_COMM_SHELL_INT_ID = "comm_Shell_intId"
    SORT_PROP_COMM_SHELL_NAME = "comm_Shell_name"
    SORT_PROP_COMM_SHELL_OPER_PORT = "comm_Shell_operPort"
    SORT_PROP_COMM_SHELL_POLICY_LEVEL = "comm_Shell_policyLevel"
    SORT_PROP_COMM_SHELL_POLICY_OWNER = "comm_Shell_policyOwner"
    SORT_PROP_COMM_SHELL_PORT = "comm_Shell_port"
    SORT_PROP_COMM_SHELL_PROTO = "comm_Shell_proto"
    SORT_PROP_COMM_SMASH_CLP_ADMIN_STATE = "comm_SmashCLP_adminState"
    SORT_PROP_COMM_SMASH_CLP_DESCR = "comm_SmashCLP_descr"
    SORT_PROP_COMM_SMASH_CLP_INT_ID = "comm_SmashCLP_intId"
    SORT_PROP_COMM_SMASH_CLP_NAME = "comm_SmashCLP_name"
    SORT_PROP_COMM_SMASH_CLP_OPER_PORT = "comm_SmashCLP_operPort"
    SORT_PROP_COMM_SMASH_CLP_POLICY_LEVEL = "comm_SmashCLP_policyLevel"
    SORT_PROP_COMM_SMASH_CLP_POLICY_OWNER = "comm_SmashCLP_policyOwner"
    SORT_PROP_COMM_SMASH_CLP_PORT = "comm_SmashCLP_port"
    SORT_PROP_COMM_SMASH_CLP_PROTO = "comm_SmashCLP_proto"
    SORT_PROP_COMM_SNMP_COMMUNITY_COMMUNITY = "comm_SnmpCommunity_community"
    SORT_PROP_COMM_SNMP_COMMUNITY_ROLE = "comm_SnmpCommunity_role"
    SORT_PROP_COMM_SNMP_TRAP_DATA_DESCR = "comm_SnmpTrapData_descr"
    SORT_PROP_COMM_SNMP_TRAP_DATA_INT_ID = "comm_SnmpTrapData_intId"
    SORT_PROP_COMM_SNMP_TRAP_DATA_NAME = "comm_SnmpTrapData_name"
    SORT_PROP_COMM_SNMP_TRAP_DATA_POLICY_LEVEL = "comm_SnmpTrapData_policyLevel"
    SORT_PROP_COMM_SNMP_TRAP_DATA_POLICY_OWNER = "comm_SnmpTrapData_policyOwner"
    SORT_PROP_COMM_SNMP_TRAP_DATA_PROP_OID = "comm_SnmpTrapData_propOid"
    SORT_PROP_COMM_SNMP_TRAP_DATA_PWD = "comm_SnmpTrapData_pwd"
    SORT_PROP_COMM_SNMP_TRAP_DATA_PWD_SET = "comm_SnmpTrapData_pwdSet"
    SORT_PROP_COMM_SNMP_TRAP_DATA_VALUE = "comm_SnmpTrapData_value"
    SORT_PROP_COMM_SNMP_TRAP_DATA_VAR_TYPE = "comm_SnmpTrapData_varType"
    SORT_PROP_COMM_SNMP_TRAP_COMMUNITY = "comm_SnmpTrap_community"
    SORT_PROP_COMM_SNMP_TRAP_HOSTNAME = "comm_SnmpTrap_hostname"
    SORT_PROP_COMM_SNMP_TRAP_NOTIFICATION_TYPE = "comm_SnmpTrap_notificationType"
    SORT_PROP_COMM_SNMP_TRAP_PORT = "comm_SnmpTrap_port"
    SORT_PROP_COMM_SNMP_TRAP_V3_PRIVILEGE = "comm_SnmpTrap_v3Privilege"
    SORT_PROP_COMM_SNMP_TRAP_VERSION = "comm_SnmpTrap_version"
    SORT_PROP_COMM_SNMP_USER_AUTH = "comm_SnmpUser_auth"
    SORT_PROP_COMM_SNMP_USER_DESCR = "comm_SnmpUser_descr"
    SORT_PROP_COMM_SNMP_USER_ENC_ALGORITHM = "comm_SnmpUser_encAlgorithm"
    SORT_PROP_COMM_SNMP_USER_INT_ID = "comm_SnmpUser_intId"
    SORT_PROP_COMM_SNMP_USER_NAME = "comm_SnmpUser_name"
    SORT_PROP_COMM_SNMP_USER_POLICY_LEVEL = "comm_SnmpUser_policyLevel"
    SORT_PROP_COMM_SNMP_USER_POLICY_OWNER = "comm_SnmpUser_policyOwner"
    SORT_PROP_COMM_SNMP_USER_PRIV_PWD_SET = "comm_SnmpUser_privPwdSet"
    SORT_PROP_COMM_SNMP_USER_PRIVPWD = "comm_SnmpUser_privpwd"
    SORT_PROP_COMM_SNMP_USER_PWD = "comm_SnmpUser_pwd"
    SORT_PROP_COMM_SNMP_USER_PWD_SET = "comm_SnmpUser_pwdSet"
    SORT_PROP_COMM_SNMP_USER_ROLE = "comm_SnmpUser_role"
    SORT_PROP_COMM_SNMP_USER_USE_AES = "comm_SnmpUser_useAes"
    SORT_PROP_COMM_SNMP_ADMIN_STATE = "comm_Snmp_adminState"
    SORT_PROP_COMM_SNMP_COMMUNITY = "comm_Snmp_community"
    SORT_PROP_COMM_SNMP_DESCR = "comm_Snmp_descr"
    SORT_PROP_COMM_SNMP_INT_ID = "comm_Snmp_intId"
    SORT_PROP_COMM_SNMP_NAME = "comm_Snmp_name"
    SORT_PROP_COMM_SNMP_OPER_PORT = "comm_Snmp_operPort"
    SORT_PROP_COMM_SNMP_POLICY_LEVEL = "comm_Snmp_policyLevel"
    SORT_PROP_COMM_SNMP_POLICY_OWNER = "comm_Snmp_policyOwner"
    SORT_PROP_COMM_SNMP_PORT = "comm_Snmp_port"
    SORT_PROP_COMM_SNMP_PROTO = "comm_Snmp_proto"
    SORT_PROP_COMM_SNMP_SYS_CONTACT = "comm_Snmp_sysContact"
    SORT_PROP_COMM_SNMP_SYS_LOCATION = "comm_Snmp_sysLocation"
    SORT_PROP_COMM_SSH_ADMIN_STATE = "comm_Ssh_adminState"
    SORT_PROP_COMM_SSH_DESCR = "comm_Ssh_descr"
    SORT_PROP_COMM_SSH_INT_ID = "comm_Ssh_intId"
    SORT_PROP_COMM_SSH_NAME = "comm_Ssh_name"
    SORT_PROP_COMM_SSH_OPER_PORT = "comm_Ssh_operPort"
    SORT_PROP_COMM_SSH_POLICY_LEVEL = "comm_Ssh_policyLevel"
    SORT_PROP_COMM_SSH_POLICY_OWNER = "comm_Ssh_policyOwner"
    SORT_PROP_COMM_SSH_PORT = "comm_Ssh_port"
    SORT_PROP_COMM_SSH_PROTO = "comm_Ssh_proto"
    SORT_PROP_COMM_SVC_CHANNEL_CHANNEL_STATE = "comm_SvcChannel_channelState"
    SORT_PROP_COMM_SVC_CHANNEL_DESCR = "comm_SvcChannel_descr"
    SORT_PROP_COMM_SVC_CHANNEL_INT_ID = "comm_SvcChannel_intId"
    SORT_PROP_COMM_SVC_CHANNEL_NAME = "comm_SvcChannel_name"
    SORT_PROP_COMM_SVC_CHANNEL_POLICY_LEVEL = "comm_SvcChannel_policyLevel"
    SORT_PROP_COMM_SVC_CHANNEL_POLICY_OWNER = "comm_SvcChannel_policyOwner"
    SORT_PROP_COMM_SVC_EP_FSM_STAGE_DESCR = "comm_SvcEpFsmStage_descr"
    SORT_PROP_COMM_SVC_EP_FSM_STAGE_LAST_UPDATE_TIME = "comm_SvcEpFsmStage_lastUpdateTime"
    SORT_PROP_COMM_SVC_EP_FSM_STAGE_NAME = "comm_SvcEpFsmStage_name"
    SORT_PROP_COMM_SVC_EP_FSM_STAGE_ORDER = "comm_SvcEpFsmStage_order"
    SORT_PROP_COMM_SVC_EP_FSM_STAGE_RETRY = "comm_SvcEpFsmStage_retry"
    SORT_PROP_COMM_SVC_EP_FSM_STAGE_STAGE_STATUS = "comm_SvcEpFsmStage_stageStatus"
    SORT_PROP_COMM_SVC_EP_FSM_TASK_COMPLETION = "comm_SvcEpFsmTask_completion"
    SORT_PROP_COMM_SVC_EP_FSM_TASK_FLAGS = "comm_SvcEpFsmTask_flags"
    SORT_PROP_COMM_SVC_EP_FSM_TASK_ITEM = "comm_SvcEpFsmTask_item"
    SORT_PROP_COMM_SVC_EP_FSM_TASK_SEQ_ID = "comm_SvcEpFsmTask_seqId"
    SORT_PROP_COMM_SVC_EP_FSM_COMPLETION_TIME = "comm_SvcEpFsm_completionTime"
    SORT_PROP_COMM_SVC_EP_FSM_CURRENT_FSM = "comm_SvcEpFsm_currentFsm"
    SORT_PROP_COMM_SVC_EP_FSM_DESCR = "comm_SvcEpFsm_descr"
    SORT_PROP_COMM_SVC_EP_FSM_FSM_INSTANCE_ID = "comm_SvcEpFsm_fsmInstanceId"
    SORT_PROP_COMM_SVC_EP_FSM_FSM_STATUS = "comm_SvcEpFsm_fsmStatus"
    SORT_PROP_COMM_SVC_EP_FSM_PROGRESS = "comm_SvcEpFsm_progress"
    SORT_PROP_COMM_SVC_EP_FSM_RMT_ERR_CODE = "comm_SvcEpFsm_rmtErrCode"
    SORT_PROP_COMM_SVC_EP_FSM_RMT_ERR_DESCR = "comm_SvcEpFsm_rmtErrDescr"
    SORT_PROP_COMM_SVC_EP_FSM_RMT_RSLT = "comm_SvcEpFsm_rmtRslt"
    SORT_PROP_COMM_SVC_EP_CONFIG_STATE = "comm_SvcEp_configState"
    SORT_PROP_COMM_SVC_EP_CONFIG_STATUS_MESSAGE = "comm_SvcEp_configStatusMessage"
    SORT_PROP_COMM_SVC_EP_DESCR = "comm_SvcEp_descr"
    SORT_PROP_COMM_SVC_EP_FSM_DESCR = "comm_SvcEp_fsmDescr"
    SORT_PROP_COMM_SVC_EP_FSM_PREV = "comm_SvcEp_fsmPrev"
    SORT_PROP_COMM_SVC_EP_FSM_PROGR = "comm_SvcEp_fsmProgr"
    SORT_PROP_COMM_SVC_EP_FSM_RMT_INV_ERR_CODE = "comm_SvcEp_fsmRmtInvErrCode"
    SORT_PROP_COMM_SVC_EP_FSM_RMT_INV_ERR_DESCR = "comm_SvcEp_fsmRmtInvErrDescr"
    SORT_PROP_COMM_SVC_EP_FSM_RMT_INV_RSLT = "comm_SvcEp_fsmRmtInvRslt"
    SORT_PROP_COMM_SVC_EP_FSM_STAGE_DESCR = "comm_SvcEp_fsmStageDescr"
    SORT_PROP_COMM_SVC_EP_FSM_STAMP = "comm_SvcEp_fsmStamp"
    SORT_PROP_COMM_SVC_EP_FSM_STATUS = "comm_SvcEp_fsmStatus"
    SORT_PROP_COMM_SVC_EP_FSM_TRY = "comm_SvcEp_fsmTry"
    SORT_PROP_COMM_SVC_EP_INT_ID = "comm_SvcEp_intId"
    SORT_PROP_COMM_SVC_EP_NAME = "comm_SvcEp_name"
    SORT_PROP_COMM_SVC_EP_POLICY_LEVEL = "comm_SvcEp_policyLevel"
    SORT_PROP_COMM_SVC_EP_POLICY_OWNER = "comm_SvcEp_policyOwner"
    SORT_PROP_COMM_SVC_LIMITS_DESCR = "comm_SvcLimits_descr"
    SORT_PROP_COMM_SVC_LIMITS_INT_ID = "comm_SvcLimits_intId"
    SORT_PROP_COMM_SVC_LIMITS_NAME = "comm_SvcLimits_name"
    SORT_PROP_COMM_SVC_LIMITS_POLICY_LEVEL = "comm_SvcLimits_policyLevel"
    SORT_PROP_COMM_SVC_LIMITS_POLICY_OWNER = "comm_SvcLimits_policyOwner"
    SORT_PROP_COMM_SVC_LIMITS_SESSIONS_PER_USER = "comm_SvcLimits_sessionsPerUser"
    SORT_PROP_COMM_SVC_LIMITS_TOTAL_SESSIONS = "comm_SvcLimits_totalSessions"
    SORT_PROP_COMM_SVC_POLICY_DESCR = "comm_SvcPolicy_descr"
    SORT_PROP_COMM_SVC_POLICY_INT_ID = "comm_SvcPolicy_intId"
    SORT_PROP_COMM_SVC_POLICY_NAME = "comm_SvcPolicy_name"
    SORT_PROP_COMM_SVC_POLICY_POLICY_LEVEL = "comm_SvcPolicy_policyLevel"
    SORT_PROP_COMM_SVC_POLICY_POLICY_OWNER = "comm_SvcPolicy_policyOwner"
    SORT_PROP_COMM_SVC_ADMIN_STATE = "comm_Svc_adminState"
    SORT_PROP_COMM_SVC_DESCR = "comm_Svc_descr"
    SORT_PROP_COMM_SVC_INT_ID = "comm_Svc_intId"
    SORT_PROP_COMM_SVC_NAME = "comm_Svc_name"
    SORT_PROP_COMM_SVC_OPER_PORT = "comm_Svc_operPort"
    SORT_PROP_COMM_SVC_POLICY_LEVEL = "comm_Svc_policyLevel"
    SORT_PROP_COMM_SVC_POLICY_OWNER = "comm_Svc_policyOwner"
    SORT_PROP_COMM_SVC_PORT = "comm_Svc_port"
    SORT_PROP_COMM_SVC_PROTO = "comm_Svc_proto"
    SORT_PROP_COMM_SYSLOG_CLIENT_ADMIN_STATE = "comm_SyslogClient_adminState"
    SORT_PROP_COMM_SYSLOG_CLIENT_FORWARDING_FACILITY = "comm_SyslogClient_forwardingFacility"
    SORT_PROP_COMM_SYSLOG_CLIENT_HOSTNAME = "comm_SyslogClient_hostname"
    SORT_PROP_COMM_SYSLOG_CLIENT_NAME = "comm_SyslogClient_name"
    SORT_PROP_COMM_SYSLOG_CLIENT_SEVERITY = "comm_SyslogClient_severity"
    SORT_PROP_COMM_SYSLOG_CONSOLE_ADMIN_STATE = "comm_SyslogConsole_adminState"
    SORT_PROP_COMM_SYSLOG_CONSOLE_DESCR = "comm_SyslogConsole_descr"
    SORT_PROP_COMM_SYSLOG_CONSOLE_NAME = "comm_SyslogConsole_name"
    SORT_PROP_COMM_SYSLOG_CONSOLE_SEVERITY = "comm_SyslogConsole_severity"
    SORT_PROP_COMM_SYSLOG_FILE_ADMIN_STATE = "comm_SyslogFile_adminState"
    SORT_PROP_COMM_SYSLOG_FILE_DESCR = "comm_SyslogFile_descr"
    SORT_PROP_COMM_SYSLOG_FILE_FILENAME = "comm_SyslogFile_filename"
    SORT_PROP_COMM_SYSLOG_FILE_NAME = "comm_SyslogFile_name"
    SORT_PROP_COMM_SYSLOG_FILE_SEVERITY = "comm_SyslogFile_severity"
    SORT_PROP_COMM_SYSLOG_FILE_SIZE = "comm_SyslogFile_size"
    SORT_PROP_COMM_SYSLOG_MONITOR_ADMIN_STATE = "comm_SyslogMonitor_adminState"
    SORT_PROP_COMM_SYSLOG_MONITOR_DESCR = "comm_SyslogMonitor_descr"
    SORT_PROP_COMM_SYSLOG_MONITOR_NAME = "comm_SyslogMonitor_name"
    SORT_PROP_COMM_SYSLOG_MONITOR_SEVERITY = "comm_SyslogMonitor_severity"
    SORT_PROP_COMM_SYSLOG_SOURCE_AUDITS = "comm_SyslogSource_audits"
    SORT_PROP_COMM_SYSLOG_SOURCE_DESCR = "comm_SyslogSource_descr"
    SORT_PROP_COMM_SYSLOG_SOURCE_EVENTS = "comm_SyslogSource_events"
    SORT_PROP_COMM_SYSLOG_SOURCE_FAULTS = "comm_SyslogSource_faults"
    SORT_PROP_COMM_SYSLOG_SOURCE_NAME = "comm_SyslogSource_name"
    SORT_PROP_COMM_SYSLOG_ADMIN_STATE = "comm_Syslog_adminState"
    SORT_PROP_COMM_SYSLOG_DESCR = "comm_Syslog_descr"
    SORT_PROP_COMM_SYSLOG_INT_ID = "comm_Syslog_intId"
    SORT_PROP_COMM_SYSLOG_NAME = "comm_Syslog_name"
    SORT_PROP_COMM_SYSLOG_OPER_PORT = "comm_Syslog_operPort"
    SORT_PROP_COMM_SYSLOG_POLICY_LEVEL = "comm_Syslog_policyLevel"
    SORT_PROP_COMM_SYSLOG_POLICY_OWNER = "comm_Syslog_policyOwner"
    SORT_PROP_COMM_SYSLOG_PORT = "comm_Syslog_port"
    SORT_PROP_COMM_SYSLOG_PROTO = "comm_Syslog_proto"
    SORT_PROP_COMM_SYSLOG_SEVERITY = "comm_Syslog_severity"
    SORT_PROP_COMM_TELNET_ADMIN_STATE = "comm_Telnet_adminState"
    SORT_PROP_COMM_TELNET_DESCR = "comm_Telnet_descr"
    SORT_PROP_COMM_TELNET_INT_ID = "comm_Telnet_intId"
    SORT_PROP_COMM_TELNET_NAME = "comm_Telnet_name"
    SORT_PROP_COMM_TELNET_OPER_PORT = "comm_Telnet_operPort"
    SORT_PROP_COMM_TELNET_POLICY_LEVEL = "comm_Telnet_policyLevel"
    SORT_PROP_COMM_TELNET_POLICY_OWNER = "comm_Telnet_policyOwner"
    SORT_PROP_COMM_TELNET_PORT = "comm_Telnet_port"
    SORT_PROP_COMM_TELNET_PROTO = "comm_Telnet_proto"
    SORT_PROP_COMM_WEB_CHANNEL_CHANNEL_STATE = "comm_WebChannel_channelState"
    SORT_PROP_COMM_WEB_CHANNEL_DESCR = "comm_WebChannel_descr"
    SORT_PROP_COMM_WEB_CHANNEL_INT_ID = "comm_WebChannel_intId"
    SORT_PROP_COMM_WEB_CHANNEL_NAME = "comm_WebChannel_name"
    SORT_PROP_COMM_WEB_CHANNEL_POLICY_LEVEL = "comm_WebChannel_policyLevel"
    SORT_PROP_COMM_WEB_CHANNEL_POLICY_OWNER = "comm_WebChannel_policyOwner"
    SORT_PROP_COMM_WEB_SVC_LIMITS_DESCR = "comm_WebSvcLimits_descr"
    SORT_PROP_COMM_WEB_SVC_LIMITS_INT_ID = "comm_WebSvcLimits_intId"
    SORT_PROP_COMM_WEB_SVC_LIMITS_NAME = "comm_WebSvcLimits_name"
    SORT_PROP_COMM_WEB_SVC_LIMITS_POLICY_LEVEL = "comm_WebSvcLimits_policyLevel"
    SORT_PROP_COMM_WEB_SVC_LIMITS_POLICY_OWNER = "comm_WebSvcLimits_policyOwner"
    SORT_PROP_COMM_WEB_SVC_LIMITS_SESSIONS_PER_USER = "comm_WebSvcLimits_sessionsPerUser"
    SORT_PROP_COMM_WEB_SVC_LIMITS_TOTAL_SESSIONS = "comm_WebSvcLimits_totalSessions"
    SORT_PROP_COMM_WEB_ADMIN_STATE = "comm_Web_adminState"
    SORT_PROP_COMM_WEB_DESCR = "comm_Web_descr"
    SORT_PROP_COMM_WEB_INT_ID = "comm_Web_intId"
    SORT_PROP_COMM_WEB_NAME = "comm_Web_name"
    SORT_PROP_COMM_WEB_OPER_PORT = "comm_Web_operPort"
    SORT_PROP_COMM_WEB_POLICY_LEVEL = "comm_Web_policyLevel"
    SORT_PROP_COMM_WEB_POLICY_OWNER = "comm_Web_policyOwner"
    SORT_PROP_COMM_WEB_PORT = "comm_Web_port"
    SORT_PROP_COMM_WEB_PROTO = "comm_Web_proto"
    SORT_PROP_COMM_WSMAN_ADMIN_STATE = "comm_Wsman_adminState"
    SORT_PROP_COMM_WSMAN_DESCR = "comm_Wsman_descr"
    SORT_PROP_COMM_WSMAN_INT_ID = "comm_Wsman_intId"
    SORT_PROP_COMM_WSMAN_NAME = "comm_Wsman_name"
    SORT_PROP_COMM_WSMAN_OPER_PORT = "comm_Wsman_operPort"
    SORT_PROP_COMM_WSMAN_POLICY_LEVEL = "comm_Wsman_policyLevel"
    SORT_PROP_COMM_WSMAN_POLICY_OWNER = "comm_Wsman_policyOwner"
    SORT_PROP_COMM_WSMAN_PORT = "comm_Wsman_port"
    SORT_PROP_COMM_WSMAN_PROTO = "comm_Wsman_proto"
    SORT_PROP_COMM_XML_CL_CONN_POLICY_ADMIN_STATE = "comm_XmlClConnPolicy_adminState"
    SORT_PROP_COMM_XML_CL_CONN_POLICY_CLIENT_TYPE = "comm_XmlClConnPolicy_clientType"
    SORT_PROP_COMM_XML_CL_CONN_POLICY_DESCR = "comm_XmlClConnPolicy_descr"
    SORT_PROP_COMM_XML_CL_CONN_POLICY_INT_ID = "comm_XmlClConnPolicy_intId"
    SORT_PROP_COMM_XML_CL_CONN_POLICY_NAME = "comm_XmlClConnPolicy_name"
    SORT_PROP_COMM_XML_CL_CONN_POLICY_OPER_PORT = "comm_XmlClConnPolicy_operPort"
    SORT_PROP_COMM_XML_CL_CONN_POLICY_POLICY_LEVEL = "comm_XmlClConnPolicy_policyLevel"
    SORT_PROP_COMM_XML_CL_CONN_POLICY_POLICY_OWNER = "comm_XmlClConnPolicy_policyOwner"
    SORT_PROP_COMM_XML_CL_CONN_POLICY_PORT = "comm_XmlClConnPolicy_port"
    SORT_PROP_COMM_XML_CL_CONN_POLICY_PROTO = "comm_XmlClConnPolicy_proto"
    SORT_PROP_COMPUTE_ABOARD_CMOS_VOLTAGE = "compute_ABoard_cmosVoltage"
    SORT_PROP_COMPUTE_ABOARD_FAULT_QUALIFIER = "compute_ABoard_faultQualifier"
    SORT_PROP_COMPUTE_ABOARD_ID = "compute_ABoard_id"
    SORT_PROP_COMPUTE_ABOARD_LOCATION_DN = "compute_ABoard_locationDn"
    SORT_PROP_COMPUTE_ABOARD_MODEL = "compute_ABoard_model"
    SORT_PROP_COMPUTE_ABOARD_OPER_POWER = "compute_ABoard_operPower"
    SORT_PROP_COMPUTE_ABOARD_OPER_QUALIFIER_REASON = "compute_ABoard_operQualifierReason"
    SORT_PROP_COMPUTE_ABOARD_OPER_STATE = "compute_ABoard_operState"
    SORT_PROP_COMPUTE_ABOARD_OPERABILITY = "compute_ABoard_operability"
    SORT_PROP_COMPUTE_ABOARD_PERF = "compute_ABoard_perf"
    SORT_PROP_COMPUTE_ABOARD_POWER = "compute_ABoard_power"
    SORT_PROP_COMPUTE_ABOARD_POWER_USAGE = "compute_ABoard_powerUsage"
    SORT_PROP_COMPUTE_ABOARD_PRESENCE = "compute_ABoard_presence"
    SORT_PROP_COMPUTE_ABOARD_REVISION = "compute_ABoard_revision"
    SORT_PROP_COMPUTE_ABOARD_SERIAL = "compute_ABoard_serial"
    SORT_PROP_COMPUTE_ABOARD_THERMAL = "compute_ABoard_thermal"
    SORT_PROP_COMPUTE_ABOARD_VENDOR = "compute_ABoard_vendor"
    SORT_PROP_COMPUTE_ABOARD_VOLTAGE = "compute_ABoard_voltage"
    SORT_PROP_COMPUTE_ACHASSIS_DISC_POLICY_ACTION = "compute_AChassisDiscPolicy_action"
    SORT_PROP_COMPUTE_ACHASSIS_DISC_POLICY_BACKPLANE_SPEED_PREF = "compute_AChassisDiscPolicy_backplaneSpeedPref"
    SORT_PROP_COMPUTE_ACHASSIS_DISC_POLICY_DESCR = "compute_AChassisDiscPolicy_descr"
    SORT_PROP_COMPUTE_ACHASSIS_DISC_POLICY_INT_ID = "compute_AChassisDiscPolicy_intId"
    SORT_PROP_COMPUTE_ACHASSIS_DISC_POLICY_LINK_AGGREGATION_PREF = "compute_AChassisDiscPolicy_linkAggregationPref"
    SORT_PROP_COMPUTE_ACHASSIS_DISC_POLICY_NAME = "compute_AChassisDiscPolicy_name"
    SORT_PROP_COMPUTE_ACHASSIS_DISC_POLICY_POLICY_LEVEL = "compute_AChassisDiscPolicy_policyLevel"
    SORT_PROP_COMPUTE_ACHASSIS_DISC_POLICY_POLICY_OWNER = "compute_AChassisDiscPolicy_policyOwner"
    SORT_PROP_COMPUTE_ACHASSIS_DISC_POLICY_QUALIFIER = "compute_AChassisDiscPolicy_qualifier"
    SORT_PROP_COMPUTE_AOPERATION_LAST_MODIFIED = "compute_AOperation_lastModified"
    SORT_PROP_COMPUTE_AOPERATION_REMOTE_ERROR_CODE = "compute_AOperation_remoteErrorCode"
    SORT_PROP_COMPUTE_AOPERATION_REMOTE_ERROR_DESCR = "compute_AOperation_remoteErrorDescr"
    SORT_PROP_COMPUTE_AOPERATION_TRIGGER_STATUS = "compute_AOperation_triggerStatus"
    SORT_PROP_COMPUTE_AUTOCONFIG_POLICY_DESCR = "compute_AutoconfigPolicy_descr"
    SORT_PROP_COMPUTE_AUTOCONFIG_POLICY_DST_DN = "compute_AutoconfigPolicy_dstDn"
    SORT_PROP_COMPUTE_AUTOCONFIG_POLICY_INT_ID = "compute_AutoconfigPolicy_intId"
    SORT_PROP_COMPUTE_AUTOCONFIG_POLICY_NAME = "compute_AutoconfigPolicy_name"
    SORT_PROP_COMPUTE_AUTOCONFIG_POLICY_OPER_QUALIFIER = "compute_AutoconfigPolicy_operQualifier"
    SORT_PROP_COMPUTE_AUTOCONFIG_POLICY_POLICY_LEVEL = "compute_AutoconfigPolicy_policyLevel"
    SORT_PROP_COMPUTE_AUTOCONFIG_POLICY_POLICY_OWNER = "compute_AutoconfigPolicy_policyOwner"
    SORT_PROP_COMPUTE_AUTOCONFIG_POLICY_QUALIFIER = "compute_AutoconfigPolicy_qualifier"
    SORT_PROP_COMPUTE_AUTOCONFIG_POLICY_SRC_TEMPL_NAME = "compute_AutoconfigPolicy_srcTemplName"
    SORT_PROP_COMPUTE_BASE_SYSTEM_ID = "compute_BaseSystem_id"
    SORT_PROP_COMPUTE_BASE_SYSTEM_NAME = "compute_BaseSystem_name"
    SORT_PROP_COMPUTE_BLADE_DISC_POLICY_ACTION = "compute_BladeDiscPolicy_action"
    SORT_PROP_COMPUTE_BLADE_DISC_POLICY_DESCR = "compute_BladeDiscPolicy_descr"
    SORT_PROP_COMPUTE_BLADE_DISC_POLICY_INT_ID = "compute_BladeDiscPolicy_intId"
    SORT_PROP_COMPUTE_BLADE_DISC_POLICY_NAME = "compute_BladeDiscPolicy_name"
    SORT_PROP_COMPUTE_BLADE_DISC_POLICY_POLICY_LEVEL = "compute_BladeDiscPolicy_policyLevel"
    SORT_PROP_COMPUTE_BLADE_DISC_POLICY_POLICY_OWNER = "compute_BladeDiscPolicy_policyOwner"
    SORT_PROP_COMPUTE_BLADE_DISC_POLICY_QUALIFIER = "compute_BladeDiscPolicy_qualifier"
    SORT_PROP_COMPUTE_BLADE_DISC_POLICY_SCRUB_POLICY_NAME = "compute_BladeDiscPolicy_scrubPolicyName"
    SORT_PROP_COMPUTE_BLADE_EP_ADMIN_STATE = "compute_BladeEp_adminState"
    SORT_PROP_COMPUTE_BLADE_EP_CHASSIS_ID = "compute_BladeEp_chassisId"
    SORT_PROP_COMPUTE_BLADE_EP_EP_DN = "compute_BladeEp_epDn"
    SORT_PROP_COMPUTE_BLADE_EP_ID = "compute_BladeEp_id"
    SORT_PROP_COMPUTE_BLADE_EP_OPER_QUALIFIER_REASON = "compute_BladeEp_operQualifierReason"
    SORT_PROP_COMPUTE_BLADE_EP_OPER_STATE = "compute_BladeEp_operState"
    SORT_PROP_COMPUTE_BLADE_EP_PEER_PRESENCE = "compute_BladeEp_peerPresence"
    SORT_PROP_COMPUTE_BLADE_EP_PRESENCE = "compute_BladeEp_presence"
    SORT_PROP_COMPUTE_BLADE_EP_SLOT_ID = "compute_BladeEp_slotId"
    SORT_PROP_COMPUTE_BLADE_INHERIT_POLICY_DESCR = "compute_BladeInheritPolicy_descr"
    SORT_PROP_COMPUTE_BLADE_INHERIT_POLICY_DST_DN = "compute_BladeInheritPolicy_dstDn"
    SORT_PROP_COMPUTE_BLADE_INHERIT_POLICY_INT_ID = "compute_BladeInheritPolicy_intId"
    SORT_PROP_COMPUTE_BLADE_INHERIT_POLICY_NAME = "compute_BladeInheritPolicy_name"
    SORT_PROP_COMPUTE_BLADE_INHERIT_POLICY_OPER_QUALIFIER = "compute_BladeInheritPolicy_operQualifier"
    SORT_PROP_COMPUTE_BLADE_INHERIT_POLICY_POLICY_LEVEL = "compute_BladeInheritPolicy_policyLevel"
    SORT_PROP_COMPUTE_BLADE_INHERIT_POLICY_POLICY_OWNER = "compute_BladeInheritPolicy_policyOwner"
    SORT_PROP_COMPUTE_BLADE_INHERIT_POLICY_QUALIFIER = "compute_BladeInheritPolicy_qualifier"
    SORT_PROP_COMPUTE_BLADE_POS_QUAL_MAX_ID = "compute_BladePosQual_maxId"
    SORT_PROP_COMPUTE_BLADE_POS_QUAL_MIN_ID = "compute_BladePosQual_minId"
    SORT_PROP_COMPUTE_BLADE_ADMIN_POWER = "compute_Blade_adminPower"
    SORT_PROP_COMPUTE_BLADE_ADMIN_STATE = "compute_Blade_adminState"
    SORT_PROP_COMPUTE_BLADE_ASSET_TAG = "compute_Blade_assetTag"
    SORT_PROP_COMPUTE_BLADE_ASSIGNED_TO_DN = "compute_Blade_assignedToDn"
    SORT_PROP_COMPUTE_BLADE_ASSOCIATION = "compute_Blade_association"
    SORT_PROP_COMPUTE_BLADE_AVAILABILITY = "compute_Blade_availability"
    SORT_PROP_COMPUTE_BLADE_AVAILABLE_MEMORY = "compute_Blade_availableMemory"
    SORT_PROP_COMPUTE_BLADE_CHASSIS_ID = "compute_Blade_chassisId"
    SORT_PROP_COMPUTE_BLADE_CHECK_POINT = "compute_Blade_checkPoint"
    SORT_PROP_COMPUTE_BLADE_CONN_PATH = "compute_Blade_connPath"
    SORT_PROP_COMPUTE_BLADE_CONN_STATUS = "compute_Blade_connStatus"
    SORT_PROP_COMPUTE_BLADE_DESCR = "compute_Blade_descr"
    SORT_PROP_COMPUTE_BLADE_DISCOVERY = "compute_Blade_discovery"
    SORT_PROP_COMPUTE_BLADE_DISCOVERY_STATUS = "compute_Blade_discoveryStatus"
    SORT_PROP_COMPUTE_BLADE_FLT_AGGR = "compute_Blade_fltAggr"
    SORT_PROP_COMPUTE_BLADE_INT_ID = "compute_Blade_intId"
    SORT_PROP_COMPUTE_BLADE_KMIP_FAULT = "compute_Blade_kmipFault"
    SORT_PROP_COMPUTE_BLADE_KMIP_FAULT_DESCRIPTION = "compute_Blade_kmipFaultDescription"
    SORT_PROP_COMPUTE_BLADE_LC = "compute_Blade_lc"
    SORT_PROP_COMPUTE_BLADE_LC_TS = "compute_Blade_lcTs"
    SORT_PROP_COMPUTE_BLADE_LOCAL_ID = "compute_Blade_localId"
    SORT_PROP_COMPUTE_BLADE_LOW_VOLTAGE_MEMORY = "compute_Blade_lowVoltageMemory"
    SORT_PROP_COMPUTE_BLADE_LS_DN = "compute_Blade_lsDn"
    SORT_PROP_COMPUTE_BLADE_MANAGING_INST = "compute_Blade_managingInst"
    SORT_PROP_COMPUTE_BLADE_MEMORY_SPEED = "compute_Blade_memorySpeed"
    SORT_PROP_COMPUTE_BLADE_MFG_TIME = "compute_Blade_mfgTime"
    SORT_PROP_COMPUTE_BLADE_MODEL = "compute_Blade_model"
    SORT_PROP_COMPUTE_BLADE_NAME = "compute_Blade_name"
    SORT_PROP_COMPUTE_BLADE_NUM_OF40_GADAPTORS_WITH_OLD_FW = "compute_Blade_numOf40GAdaptorsWithOldFw"
    SORT_PROP_COMPUTE_BLADE_NUM_OF40_GADAPTORS_WITH_UNKNOWN_FW = "compute_Blade_numOf40GAdaptorsWithUnknownFw"
    SORT_PROP_COMPUTE_BLADE_NUM_OF_ADAPTORS = "compute_Blade_numOfAdaptors"
    SORT_PROP_COMPUTE_BLADE_NUM_OF_CORES = "compute_Blade_numOfCores"
    SORT_PROP_COMPUTE_BLADE_NUM_OF_CORES_ENABLED = "compute_Blade_numOfCoresEnabled"
    SORT_PROP_COMPUTE_BLADE_NUM_OF_CPUS = "compute_Blade_numOfCpus"
    SORT_PROP_COMPUTE_BLADE_NUM_OF_ETH_HOST_IFS = "compute_Blade_numOfEthHostIfs"
    SORT_PROP_COMPUTE_BLADE_NUM_OF_FC_HOST_IFS = "compute_Blade_numOfFcHostIfs"
    SORT_PROP_COMPUTE_BLADE_NUM_OF_THREADS = "compute_Blade_numOfThreads"
    SORT_PROP_COMPUTE_BLADE_OPER_POWER = "compute_Blade_operPower"
    SORT_PROP_COMPUTE_BLADE_OPER_PWR_TRANS_SRC = "compute_Blade_operPwrTransSrc"
    SORT_PROP_COMPUTE_BLADE_OPER_QUALIFIER = "compute_Blade_operQualifier"
    SORT_PROP_COMPUTE_BLADE_OPER_STATE = "compute_Blade_operState"
    SORT_PROP_COMPUTE_BLADE_OPERABILITY = "compute_Blade_operability"
    SORT_PROP_COMPUTE_BLADE_ORIGINAL_UUID = "compute_Blade_originalUuid"
    SORT_PROP_COMPUTE_BLADE_PART_NUMBER = "compute_Blade_partNumber"
    SORT_PROP_COMPUTE_BLADE_POLICY_LEVEL = "compute_Blade_policyLevel"
    SORT_PROP_COMPUTE_BLADE_POLICY_OWNER = "compute_Blade_policyOwner"
    SORT_PROP_COMPUTE_BLADE_PRESENCE = "compute_Blade_presence"
    SORT_PROP_COMPUTE_BLADE_REVISION = "compute_Blade_revision"
    SORT_PROP_COMPUTE_BLADE_SCALED_MODE = "compute_Blade_scaledMode"
    SORT_PROP_COMPUTE_BLADE_SERIAL = "compute_Blade_serial"
    SORT_PROP_COMPUTE_BLADE_SERVER_ID = "compute_Blade_serverId"
    SORT_PROP_COMPUTE_BLADE_SLOT_ID = "compute_Blade_slotId"
    SORT_PROP_COMPUTE_BLADE_TOTAL_MEMORY = "compute_Blade_totalMemory"
    SORT_PROP_COMPUTE_BLADE_UPGRADE_SCENARIO = "compute_Blade_upgradeScenario"
    SORT_PROP_COMPUTE_BLADE_USR_LBL = "compute_Blade_usrLbl"
    SORT_PROP_COMPUTE_BLADE_UUID = "compute_Blade_uuid"
    SORT_PROP_COMPUTE_BLADE_VENDOR = "compute_Blade_vendor"
    SORT_PROP_COMPUTE_BLADE_VID = "compute_Blade_vid"
    SORT_PROP_COMPUTE_BOARD_CONNECTOR_BOARD_CONNECTOR_TYPE = "compute_BoardConnector_boardConnectorType"
    SORT_PROP_COMPUTE_BOARD_CONNECTOR_MASTER_SLOT_ID = "compute_BoardConnector_masterSlotId"
    SORT_PROP_COMPUTE_BOARD_CONNECTOR_SLAVE_SLOT_ID = "compute_BoardConnector_slaveSlotId"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_ID = "compute_BoardController_id"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_LOCATION_DN = "compute_BoardController_locationDn"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_MODEL = "compute_BoardController_model"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_OPER_QUALIFIER_REASON = "compute_BoardController_operQualifierReason"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_OPER_STATE = "compute_BoardController_operState"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_OPERABILITY = "compute_BoardController_operability"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_PERF = "compute_BoardController_perf"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_POWER = "compute_BoardController_power"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_PRESENCE = "compute_BoardController_presence"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_REVISION = "compute_BoardController_revision"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_SERIAL = "compute_BoardController_serial"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_THERMAL = "compute_BoardController_thermal"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_VENDOR = "compute_BoardController_vendor"
    SORT_PROP_COMPUTE_BOARD_CONTROLLER_VOLTAGE = "compute_BoardController_voltage"
    SORT_PROP_COMPUTE_BOARD_CMOS_VOLTAGE = "compute_Board_cmosVoltage"
    SORT_PROP_COMPUTE_BOARD_CPU_TYPE_DESCRIPTION = "compute_Board_cpuTypeDescription"
    SORT_PROP_COMPUTE_BOARD_FAULT_QUALIFIER = "compute_Board_faultQualifier"
    SORT_PROP_COMPUTE_BOARD_ID = "compute_Board_id"
    SORT_PROP_COMPUTE_BOARD_LOCATION_DN = "compute_Board_locationDn"
    SORT_PROP_COMPUTE_BOARD_MODEL = "compute_Board_model"
    SORT_PROP_COMPUTE_BOARD_OPER_POWER = "compute_Board_operPower"
    SORT_PROP_COMPUTE_BOARD_OPER_QUALIFIER_REASON = "compute_Board_operQualifierReason"
    SORT_PROP_COMPUTE_BOARD_OPER_STATE = "compute_Board_operState"
    SORT_PROP_COMPUTE_BOARD_OPERABILITY = "compute_Board_operability"
    SORT_PROP_COMPUTE_BOARD_PERF = "compute_Board_perf"
    SORT_PROP_COMPUTE_BOARD_POWER = "compute_Board_power"
    SORT_PROP_COMPUTE_BOARD_POWER_USAGE = "compute_Board_powerUsage"
    SORT_PROP_COMPUTE_BOARD_PRESENCE = "compute_Board_presence"
    SORT_PROP_COMPUTE_BOARD_REVISION = "compute_Board_revision"
    SORT_PROP_COMPUTE_BOARD_SERIAL = "compute_Board_serial"
    SORT_PROP_COMPUTE_BOARD_THERMAL = "compute_Board_thermal"
    SORT_PROP_COMPUTE_BOARD_VENDOR = "compute_Board_vendor"
    SORT_PROP_COMPUTE_BOARD_VOLTAGE = "compute_Board_voltage"
    SORT_PROP_COMPUTE_CARTRIDGE_OPERATION_LAST_MODIFIED = "compute_CartridgeOperation_lastModified"
    SORT_PROP_COMPUTE_CARTRIDGE_OPERATION_LC = "compute_CartridgeOperation_lc"
    SORT_PROP_COMPUTE_CARTRIDGE_OPERATION_REMOTE_ERROR_CODE = "compute_CartridgeOperation_remoteErrorCode"
    SORT_PROP_COMPUTE_CARTRIDGE_OPERATION_REMOTE_ERROR_DESCR = "compute_CartridgeOperation_remoteErrorDescr"
    SORT_PROP_COMPUTE_CARTRIDGE_OPERATION_TRIGGER_STATUS = "compute_CartridgeOperation_triggerStatus"
    SORT_PROP_COMPUTE_CARTRIDGE_CHASSIS_ID = "compute_Cartridge_chassisId"
    SORT_PROP_COMPUTE_CARTRIDGE_DISCOVERY = "compute_Cartridge_discovery"
    SORT_PROP_COMPUTE_CARTRIDGE_FLT_AGGR = "compute_Cartridge_fltAggr"
    SORT_PROP_COMPUTE_CARTRIDGE_ID = "compute_Cartridge_id"
    SORT_PROP_COMPUTE_CARTRIDGE_LC = "compute_Cartridge_lc"
    SORT_PROP_COMPUTE_CARTRIDGE_LC_TS = "compute_Cartridge_lcTs"
    SORT_PROP_COMPUTE_CARTRIDGE_MODEL = "compute_Cartridge_model"
    SORT_PROP_COMPUTE_CARTRIDGE_OPER_QUALIFIER_REASON = "compute_Cartridge_operQualifierReason"
    SORT_PROP_COMPUTE_CARTRIDGE_OPER_STATE = "compute_Cartridge_operState"
    SORT_PROP_COMPUTE_CARTRIDGE_OPERABILITY = "compute_Cartridge_operability"
    SORT_PROP_COMPUTE_CARTRIDGE_PERF = "compute_Cartridge_perf"
    SORT_PROP_COMPUTE_CARTRIDGE_POWER = "compute_Cartridge_power"
    SORT_PROP_COMPUTE_CARTRIDGE_PRESENCE = "compute_Cartridge_presence"
    SORT_PROP_COMPUTE_CARTRIDGE_REVISION = "compute_Cartridge_revision"
    SORT_PROP_COMPUTE_CARTRIDGE_SERIAL = "compute_Cartridge_serial"
    SORT_PROP_COMPUTE_CARTRIDGE_SLOT_ID = "compute_Cartridge_slotId"
    SORT_PROP_COMPUTE_CARTRIDGE_THERMAL = "compute_Cartridge_thermal"
    SORT_PROP_COMPUTE_CARTRIDGE_VENDOR = "compute_Cartridge_vendor"
    SORT_PROP_COMPUTE_CARTRIDGE_VOLTAGE = "compute_Cartridge_voltage"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_OPERATION_ADMIN_STATE = "compute_ChassisConnPolicyOperation_adminState"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_OPERATION_BACKPLANE_SPEED_PREF = "compute_ChassisConnPolicyOperation_backplaneSpeedPref"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_OPERATION_LAST_MODIFIED = "compute_ChassisConnPolicyOperation_lastModified"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_OPERATION_REMOTE_ERROR_CODE = "compute_ChassisConnPolicyOperation_remoteErrorCode"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_OPERATION_REMOTE_ERROR_DESCR = "compute_ChassisConnPolicyOperation_remoteErrorDescr"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_OPERATION_TRIGGER_STATUS = "compute_ChassisConnPolicyOperation_triggerStatus"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_ADMIN_STATE = "compute_ChassisConnPolicy_adminState"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_BACKPLANE_SPEED_PREF = "compute_ChassisConnPolicy_backplaneSpeedPref"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_CHASSIS_ID = "compute_ChassisConnPolicy_chassisId"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_DESCR = "compute_ChassisConnPolicy_descr"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_INT_ID = "compute_ChassisConnPolicy_intId"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_NAME = "compute_ChassisConnPolicy_name"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_POLICY_LEVEL = "compute_ChassisConnPolicy_policyLevel"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_POLICY_OWNER = "compute_ChassisConnPolicy_policyOwner"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_QUALIFIER = "compute_ChassisConnPolicy_qualifier"
    SORT_PROP_COMPUTE_CHASSIS_CONN_POLICY_SWITCH_ID = "compute_ChassisConnPolicy_switchId"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_ACTION = "compute_ChassisDiscPolicy_action"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_BACKPLANE_SPEED_PREF = "compute_ChassisDiscPolicy_backplaneSpeedPref"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_DESCR = "compute_ChassisDiscPolicy_descr"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_INT_ID = "compute_ChassisDiscPolicy_intId"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_LINK_AGGREGATION_PREF = "compute_ChassisDiscPolicy_linkAggregationPref"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_MULTICAST_HW_HASH = "compute_ChassisDiscPolicy_multicastHwHash"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_NAME = "compute_ChassisDiscPolicy_name"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_POLICY_LEVEL = "compute_ChassisDiscPolicy_policyLevel"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_POLICY_OWNER = "compute_ChassisDiscPolicy_policyOwner"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_QUALIFIER = "compute_ChassisDiscPolicy_qualifier"
    SORT_PROP_COMPUTE_CHASSIS_DISC_POLICY_REBALANCE = "compute_ChassisDiscPolicy_rebalance"
    SORT_PROP_COMPUTE_CHASSIS_FEAT_MASK_FEAT_MASK = "compute_ChassisFeatMask_featMask"
    SORT_PROP_COMPUTE_CHASSIS_QUAL_MAX_ID = "compute_ChassisQual_maxId"
    SORT_PROP_COMPUTE_CHASSIS_QUAL_MIN_ID = "compute_ChassisQual_minId"
    SORT_PROP_COMPUTE_COMPUTE_DISC_POLICY_ACTION = "compute_ComputeDiscPolicy_action"
    SORT_PROP_COMPUTE_COMPUTE_DISC_POLICY_DESCR = "compute_ComputeDiscPolicy_descr"
    SORT_PROP_COMPUTE_COMPUTE_DISC_POLICY_INT_ID = "compute_ComputeDiscPolicy_intId"
    SORT_PROP_COMPUTE_COMPUTE_DISC_POLICY_NAME = "compute_ComputeDiscPolicy_name"
    SORT_PROP_COMPUTE_COMPUTE_DISC_POLICY_POLICY_LEVEL = "compute_ComputeDiscPolicy_policyLevel"
    SORT_PROP_COMPUTE_COMPUTE_DISC_POLICY_POLICY_OWNER = "compute_ComputeDiscPolicy_policyOwner"
    SORT_PROP_COMPUTE_COMPUTE_DISC_POLICY_QUALIFIER = "compute_ComputeDiscPolicy_qualifier"
    SORT_PROP_COMPUTE_COMPUTE_DISC_POLICY_SCRUB_POLICY_NAME = "compute_ComputeDiscPolicy_scrubPolicyName"
    SORT_PROP_COMPUTE_CONFIG_POLICY_DESCR = "compute_ConfigPolicy_descr"
    SORT_PROP_COMPUTE_CONFIG_POLICY_INT_ID = "compute_ConfigPolicy_intId"
    SORT_PROP_COMPUTE_CONFIG_POLICY_NAME = "compute_ConfigPolicy_name"
    SORT_PROP_COMPUTE_CONFIG_POLICY_POLICY_LEVEL = "compute_ConfigPolicy_policyLevel"
    SORT_PROP_COMPUTE_CONFIG_POLICY_POLICY_OWNER = "compute_ConfigPolicy_policyOwner"
    SORT_PROP_COMPUTE_CONFIG_POLICY_QUALIFIER = "compute_ConfigPolicy_qualifier"
    SORT_PROP_COMPUTE_CONTAINER_DESCR = "compute_Container_descr"
    SORT_PROP_COMPUTE_CONTAINER_INT_ID = "compute_Container_intId"
    SORT_PROP_COMPUTE_CONTAINER_LS_DN = "compute_Container_lsDn"
    SORT_PROP_COMPUTE_CONTAINER_NAME = "compute_Container_name"
    SORT_PROP_COMPUTE_CONTAINER_POLICY_LEVEL = "compute_Container_policyLevel"
    SORT_PROP_COMPUTE_CONTAINER_POLICY_OWNER = "compute_Container_policyOwner"
    SORT_PROP_COMPUTE_CONTAINER_UUID = "compute_Container_uuid"
    SORT_PROP_COMPUTE_DEFINITION_DESCR = "compute_Definition_descr"
    SORT_PROP_COMPUTE_DEFINITION_INT_ID = "compute_Definition_intId"
    SORT_PROP_COMPUTE_DEFINITION_NAME = "compute_Definition_name"
    SORT_PROP_COMPUTE_DEFINITION_POLICY_LEVEL = "compute_Definition_policyLevel"
    SORT_PROP_COMPUTE_DEFINITION_POLICY_OWNER = "compute_Definition_policyOwner"
    SORT_PROP_COMPUTE_DISC_POLICY_DESCR = "compute_DiscPolicy_descr"
    SORT_PROP_COMPUTE_DISC_POLICY_INT_ID = "compute_DiscPolicy_intId"
    SORT_PROP_COMPUTE_DISC_POLICY_NAME = "compute_DiscPolicy_name"
    SORT_PROP_COMPUTE_DISC_POLICY_POLICY_LEVEL = "compute_DiscPolicy_policyLevel"
    SORT_PROP_COMPUTE_DISC_POLICY_POLICY_OWNER = "compute_DiscPolicy_policyOwner"
    SORT_PROP_COMPUTE_DISC_POLICY_QUALIFIER = "compute_DiscPolicy_qualifier"
    SORT_PROP_COMPUTE_DOMAIN_GROUP_QUAL_DOMAIN_GROUP_DN = "compute_DomainGroupQual_domainGroupDn"
    SORT_PROP_COMPUTE_DOMAIN_GROUP_QUAL_HIERARCHICAL = "compute_DomainGroupQual_hierarchical"
    SORT_PROP_COMPUTE_DOMAIN_GROUP_QUAL_NAME = "compute_DomainGroupQual_name"
    SORT_PROP_COMPUTE_DOMAIN_HW_CHANGE_DISC_POLICY_ACTION = "compute_DomainHwChangeDiscPolicy_action"
    SORT_PROP_COMPUTE_DOMAIN_HW_CHANGE_DISC_POLICY_DESCR = "compute_DomainHwChangeDiscPolicy_descr"
    SORT_PROP_COMPUTE_DOMAIN_HW_CHANGE_DISC_POLICY_INT_ID = "compute_DomainHwChangeDiscPolicy_intId"
    SORT_PROP_COMPUTE_DOMAIN_HW_CHANGE_DISC_POLICY_NAME = "compute_DomainHwChangeDiscPolicy_name"
    SORT_PROP_COMPUTE_DOMAIN_HW_CHANGE_DISC_POLICY_POLICY_LEVEL = "compute_DomainHwChangeDiscPolicy_policyLevel"
    SORT_PROP_COMPUTE_DOMAIN_HW_CHANGE_DISC_POLICY_POLICY_OWNER = "compute_DomainHwChangeDiscPolicy_policyOwner"
    SORT_PROP_COMPUTE_DOMAIN_HW_CHANGE_DISC_POLICY_QUALIFIER = "compute_DomainHwChangeDiscPolicy_qualifier"
    SORT_PROP_COMPUTE_DOMAIN_NAME_QUAL_NAME = "compute_DomainNameQual_name"
    SORT_PROP_COMPUTE_DOMAIN_PORT_DISC_POLICY_DESCR = "compute_DomainPortDiscPolicy_descr"
    SORT_PROP_COMPUTE_DOMAIN_PORT_DISC_POLICY_ETH_BREAKOUT_AUTO_DISCOVERY = "compute_DomainPortDiscPolicy_ethBreakoutAutoDiscovery"
    SORT_PROP_COMPUTE_DOMAIN_PORT_DISC_POLICY_ETH_SVR_AUTO_DISCOVERY = "compute_DomainPortDiscPolicy_ethSvrAutoDiscovery"
    SORT_PROP_COMPUTE_DOMAIN_PORT_DISC_POLICY_INT_ID = "compute_DomainPortDiscPolicy_intId"
    SORT_PROP_COMPUTE_DOMAIN_PORT_DISC_POLICY_NAME = "compute_DomainPortDiscPolicy_name"
    SORT_PROP_COMPUTE_DOMAIN_PORT_DISC_POLICY_POLICY_LEVEL = "compute_DomainPortDiscPolicy_policyLevel"
    SORT_PROP_COMPUTE_DOMAIN_PORT_DISC_POLICY_POLICY_OWNER = "compute_DomainPortDiscPolicy_policyOwner"
    SORT_PROP_COMPUTE_DOMAIN_PORT_DISC_POLICY_QUALIFIER = "compute_DomainPortDiscPolicy_qualifier"
    SORT_PROP_COMPUTE_DOMAIN_QUAL_NAME = "compute_DomainQual_name"
    SORT_PROP_COMPUTE_ENV_FEAT_MASK_FEAT_MASK = "compute_EnvFeatMask_featMask"
    SORT_PROP_COMPUTE_EXT_BOARD_BOARD_AGGREGATION_ROLE = "compute_ExtBoard_boardAggregationRole"
    SORT_PROP_COMPUTE_EXT_BOARD_CHASSIS_ID = "compute_ExtBoard_chassisId"
    SORT_PROP_COMPUTE_EXT_BOARD_CMOS_VOLTAGE = "compute_ExtBoard_cmosVoltage"
    SORT_PROP_COMPUTE_EXT_BOARD_CONN_PATH = "compute_ExtBoard_connPath"
    SORT_PROP_COMPUTE_EXT_BOARD_CONN_STATUS = "compute_ExtBoard_connStatus"
    SORT_PROP_COMPUTE_EXT_BOARD_DISCOVERY_STATUS = "compute_ExtBoard_discoveryStatus"
    SORT_PROP_COMPUTE_EXT_BOARD_FAULT_QUALIFIER = "compute_ExtBoard_faultQualifier"
    SORT_PROP_COMPUTE_EXT_BOARD_ID = "compute_ExtBoard_id"
    SORT_PROP_COMPUTE_EXT_BOARD_LOCATION_DN = "compute_ExtBoard_locationDn"
    SORT_PROP_COMPUTE_EXT_BOARD_MANAGING_INST = "compute_ExtBoard_managingInst"
    SORT_PROP_COMPUTE_EXT_BOARD_MODEL = "compute_ExtBoard_model"
    SORT_PROP_COMPUTE_EXT_BOARD_OPER_POWER = "compute_ExtBoard_operPower"
    SORT_PROP_COMPUTE_EXT_BOARD_OPER_QUALIFIER_REASON = "compute_ExtBoard_operQualifierReason"
    SORT_PROP_COMPUTE_EXT_BOARD_OPER_STATE = "compute_ExtBoard_operState"
    SORT_PROP_COMPUTE_EXT_BOARD_OPERABILITY = "compute_ExtBoard_operability"
    SORT_PROP_COMPUTE_EXT_BOARD_PERF = "compute_ExtBoard_perf"
    SORT_PROP_COMPUTE_EXT_BOARD_POWER = "compute_ExtBoard_power"
    SORT_PROP_COMPUTE_EXT_BOARD_POWER_USAGE = "compute_ExtBoard_powerUsage"
    SORT_PROP_COMPUTE_EXT_BOARD_PRESENCE = "compute_ExtBoard_presence"
    SORT_PROP_COMPUTE_EXT_BOARD_REVISION = "compute_ExtBoard_revision"
    SORT_PROP_COMPUTE_EXT_BOARD_SERIAL = "compute_ExtBoard_serial"
    SORT_PROP_COMPUTE_EXT_BOARD_SLOT_ID = "compute_ExtBoard_slotId"
    SORT_PROP_COMPUTE_EXT_BOARD_THERMAL = "compute_ExtBoard_thermal"
    SORT_PROP_COMPUTE_EXT_BOARD_VENDOR = "compute_ExtBoard_vendor"
    SORT_PROP_COMPUTE_EXT_BOARD_VOLTAGE = "compute_ExtBoard_voltage"
    SORT_PROP_COMPUTE_FABRIC_ETH_MON_SRC_EP_CONT_ID = "compute_FabricEthMonSrcEpCont_id"
    SORT_PROP_COMPUTE_FABRIC_ETH_MON_SRC_EP_DIRECTION = "compute_FabricEthMonSrcEp_direction"
    SORT_PROP_COMPUTE_FABRIC_ETH_MON_SRC_EP_ID = "compute_FabricEthMonSrcEp_id"
    SORT_PROP_COMPUTE_FABRIC_ETH_MON_SRC_EP_MO_DN = "compute_FabricEthMonSrcEp_moDn"
    SORT_PROP_COMPUTE_FABRIC_ETH_MON_SRC_EP_NAME = "compute_FabricEthMonSrcEp_name"
    SORT_PROP_COMPUTE_FABRIC_ETH_MON_SRC_EP_SESSION = "compute_FabricEthMonSrcEp_session"
    SORT_PROP_COMPUTE_FABRIC_ETH_MON_SRC_EP_TRANSPORT = "compute_FabricEthMonSrcEp_transport"
    SORT_PROP_COMPUTE_FABRIC_ETH_MON_SRC_EP_TYPE = "compute_FabricEthMonSrcEp_type"
    SORT_PROP_COMPUTE_FABRIC_FC_MON_SRC_EP_CONT_ID = "compute_FabricFcMonSrcEpCont_id"
    SORT_PROP_COMPUTE_FABRIC_FC_MON_SRC_EP_DIRECTION = "compute_FabricFcMonSrcEp_direction"
    SORT_PROP_COMPUTE_FABRIC_FC_MON_SRC_EP_ID = "compute_FabricFcMonSrcEp_id"
    SORT_PROP_COMPUTE_FABRIC_FC_MON_SRC_EP_MO_DN = "compute_FabricFcMonSrcEp_moDn"
    SORT_PROP_COMPUTE_FABRIC_FC_MON_SRC_EP_NAME = "compute_FabricFcMonSrcEp_name"
    SORT_PROP_COMPUTE_FABRIC_FC_MON_SRC_EP_SESSION = "compute_FabricFcMonSrcEp_session"
    SORT_PROP_COMPUTE_FABRIC_FC_MON_SRC_EP_TRANSPORT = "compute_FabricFcMonSrcEp_transport"
    SORT_PROP_COMPUTE_FABRIC_FC_MON_SRC_EP_TYPE = "compute_FabricFcMonSrcEp_type"
    SORT_PROP_COMPUTE_FABRIC_MON_SRC_EP_DIRECTION = "compute_FabricMonSrcEp_direction"
    SORT_PROP_COMPUTE_FABRIC_MON_SRC_EP_ID = "compute_FabricMonSrcEp_id"
    SORT_PROP_COMPUTE_FABRIC_MON_SRC_EP_MO_DN = "compute_FabricMonSrcEp_moDn"
    SORT_PROP_COMPUTE_FABRIC_MON_SRC_EP_NAME = "compute_FabricMonSrcEp_name"
    SORT_PROP_COMPUTE_FABRIC_MON_SRC_EP_SESSION = "compute_FabricMonSrcEp_session"
    SORT_PROP_COMPUTE_FABRIC_MON_SRC_EP_TRANSPORT = "compute_FabricMonSrcEp_transport"
    SORT_PROP_COMPUTE_FABRIC_MON_SRC_EP_TYPE = "compute_FabricMonSrcEp_type"
    SORT_PROP_COMPUTE_FACTORY_RESET_OP_CREATE_INITIAL_VOLUMES = "compute_FactoryResetOp_createInitialVolumes"
    SORT_PROP_COMPUTE_FACTORY_RESET_OP_FLEX_STORAGE_SCRUB = "compute_FactoryResetOp_flexStorageScrub"
    SORT_PROP_COMPUTE_FACTORY_RESET_OP_LAST_MODIFIED = "compute_FactoryResetOp_lastModified"
    SORT_PROP_COMPUTE_FACTORY_RESET_OP_REMOTE_ERROR_CODE = "compute_FactoryResetOp_remoteErrorCode"
    SORT_PROP_COMPUTE_FACTORY_RESET_OP_REMOTE_ERROR_DESCR = "compute_FactoryResetOp_remoteErrorDescr"
    SORT_PROP_COMPUTE_FACTORY_RESET_OP_RESET_TRIGGER = "compute_FactoryResetOp_resetTrigger"
    SORT_PROP_COMPUTE_FACTORY_RESET_OP_STORAGE_SCRUB = "compute_FactoryResetOp_storageScrub"
    SORT_PROP_COMPUTE_FACTORY_RESET_OP_TRIGGER_STATUS = "compute_FactoryResetOp_triggerStatus"
    SORT_PROP_COMPUTE_FACTORY_RESET_OPERATION_CREATE_INITIAL_VOLUMES = "compute_FactoryResetOperation_createInitialVolumes"
    SORT_PROP_COMPUTE_FACTORY_RESET_OPERATION_FLEX_STORAGE_SCRUB = "compute_FactoryResetOperation_flexStorageScrub"
    SORT_PROP_COMPUTE_FACTORY_RESET_OPERATION_OPER_STATUS = "compute_FactoryResetOperation_operStatus"
    SORT_PROP_COMPUTE_FACTORY_RESET_OPERATION_RESET_TRIGGER = "compute_FactoryResetOperation_resetTrigger"
    SORT_PROP_COMPUTE_FACTORY_RESET_OPERATION_STORAGE_SCRUB = "compute_FactoryResetOperation_storageScrub"
    SORT_PROP_COMPUTE_GRAPHICS_CARD_POLICY_DESCR = "compute_GraphicsCardPolicy_descr"
    SORT_PROP_COMPUTE_GRAPHICS_CARD_POLICY_GRAPHICS_CARD_MODE = "compute_GraphicsCardPolicy_graphicsCardMode"
    SORT_PROP_COMPUTE_GRAPHICS_CARD_POLICY_INT_ID = "compute_GraphicsCardPolicy_intId"
    SORT_PROP_COMPUTE_GRAPHICS_CARD_POLICY_NAME = "compute_GraphicsCardPolicy_name"
    SORT_PROP_COMPUTE_GRAPHICS_CARD_POLICY_POLICY_LEVEL = "compute_GraphicsCardPolicy_policyLevel"
    SORT_PROP_COMPUTE_GRAPHICS_CARD_POLICY_POLICY_OWNER = "compute_GraphicsCardPolicy_policyOwner"
    SORT_PROP_COMPUTE_GROUP_MEMBERSHIP_REF_ID = "compute_GroupMembershipRef_id"
    SORT_PROP_COMPUTE_GROUP_MEMBERSHIP_REF_OPER_SYS_DN = "compute_GroupMembershipRef_operSysDn"
    SORT_PROP_COMPUTE_GROUP_MEMBERSHIP_CONFIG_STATE = "compute_GroupMembership_configState"
    SORT_PROP_COMPUTE_GROUP_MEMBERSHIP_CONFIG_STATUS_MESSAGE = "compute_GroupMembership_configStatusMessage"
    SORT_PROP_COMPUTE_GROUP_MEMBERSHIP_FLT_AGGR = "compute_GroupMembership_fltAggr"
    SORT_PROP_COMPUTE_GROUP_MEMBERSHIP_GROUP_DN = "compute_GroupMembership_groupDn"
    SORT_PROP_COMPUTE_GROUP_MEMBERSHIP_IP = "compute_GroupMembership_ip"
    SORT_PROP_COMPUTE_GROUP_MEMBERSHIP_OPER_GROUP_DN = "compute_GroupMembership_operGroupDn"
    SORT_PROP_COMPUTE_GROUP_MEMBERSHIP_OWNER = "compute_GroupMembership_owner"
    SORT_PROP_COMPUTE_HW_CHANGE_DISC_POLICY_ACTION = "compute_HwChangeDiscPolicy_action"
    SORT_PROP_COMPUTE_HW_CHANGE_DISC_POLICY_DESCR = "compute_HwChangeDiscPolicy_descr"
    SORT_PROP_COMPUTE_HW_CHANGE_DISC_POLICY_INT_ID = "compute_HwChangeDiscPolicy_intId"
    SORT_PROP_COMPUTE_HW_CHANGE_DISC_POLICY_NAME = "compute_HwChangeDiscPolicy_name"
    SORT_PROP_COMPUTE_HW_CHANGE_DISC_POLICY_POLICY_LEVEL = "compute_HwChangeDiscPolicy_policyLevel"
    SORT_PROP_COMPUTE_HW_CHANGE_DISC_POLICY_POLICY_OWNER = "compute_HwChangeDiscPolicy_policyOwner"
    SORT_PROP_COMPUTE_HW_CHANGE_DISC_POLICY_QUALIFIER = "compute_HwChangeDiscPolicy_qualifier"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_HIST_ID = "compute_IOHubEnvStatsHist_id"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_HIST_MOST_RECENT = "compute_IOHubEnvStatsHist_mostRecent"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_HIST_SUSPECT = "compute_IOHubEnvStatsHist_suspect"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_HIST_TEMPERATURE = "compute_IOHubEnvStatsHist_temperature"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_HIST_TEMPERATURE_AVG = "compute_IOHubEnvStatsHist_temperatureAvg"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_HIST_TEMPERATURE_MAX = "compute_IOHubEnvStatsHist_temperatureMax"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_HIST_TEMPERATURE_MIN = "compute_IOHubEnvStatsHist_temperatureMin"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_HIST_THRESHOLDED = "compute_IOHubEnvStatsHist_thresholded"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_HIST_TIME_COLLECTED = "compute_IOHubEnvStatsHist_timeCollected"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_INTERVALS = "compute_IOHubEnvStats_intervals"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_NORMALIZED_TIME_COL = "compute_IOHubEnvStats_normalizedTimeCol"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_STATS_REPORTED = "compute_IOHubEnvStats_statsReported"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_SUSPECT = "compute_IOHubEnvStats_suspect"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_TEMPERATURE = "compute_IOHubEnvStats_temperature"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_TEMPERATURE_AVG = "compute_IOHubEnvStats_temperatureAvg"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_TEMPERATURE_MAX = "compute_IOHubEnvStats_temperatureMax"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_TEMPERATURE_MIN = "compute_IOHubEnvStats_temperatureMin"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_THRESHOLDED = "compute_IOHubEnvStats_thresholded"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_TIME_COLLECTED = "compute_IOHubEnvStats_timeCollected"
    SORT_PROP_COMPUTE_IOHUB_ENV_STATS_UPDATE = "compute_IOHubEnvStats_update"
    SORT_PROP_COMPUTE_IOHUB_ID = "compute_IOHub_id"
    SORT_PROP_COMPUTE_IOHUB_LOCATION_DN = "compute_IOHub_locationDn"
    SORT_PROP_COMPUTE_IOHUB_MODEL = "compute_IOHub_model"
    SORT_PROP_COMPUTE_IOHUB_OPER_QUALIFIER_REASON = "compute_IOHub_operQualifierReason"
    SORT_PROP_COMPUTE_IOHUB_OPER_STATE = "compute_IOHub_operState"
    SORT_PROP_COMPUTE_IOHUB_OPERABILITY = "compute_IOHub_operability"
    SORT_PROP_COMPUTE_IOHUB_PERF = "compute_IOHub_perf"
    SORT_PROP_COMPUTE_IOHUB_POWER = "compute_IOHub_power"
    SORT_PROP_COMPUTE_IOHUB_PRESENCE = "compute_IOHub_presence"
    SORT_PROP_COMPUTE_IOHUB_REVISION = "compute_IOHub_revision"
    SORT_PROP_COMPUTE_IOHUB_SERIAL = "compute_IOHub_serial"
    SORT_PROP_COMPUTE_IOHUB_THERMAL = "compute_IOHub_thermal"
    SORT_PROP_COMPUTE_IOHUB_VENDOR = "compute_IOHub_vendor"
    SORT_PROP_COMPUTE_IOHUB_VOLTAGE = "compute_IOHub_voltage"
    SORT_PROP_COMPUTE_INIT_CONFIG_POLICY_DESCR = "compute_InitConfigPolicy_descr"
    SORT_PROP_COMPUTE_INIT_CONFIG_POLICY_DST_DN = "compute_InitConfigPolicy_dstDn"
    SORT_PROP_COMPUTE_INIT_CONFIG_POLICY_INT_ID = "compute_InitConfigPolicy_intId"
    SORT_PROP_COMPUTE_INIT_CONFIG_POLICY_NAME = "compute_InitConfigPolicy_name"
    SORT_PROP_COMPUTE_INIT_CONFIG_POLICY_POLICY_LEVEL = "compute_InitConfigPolicy_policyLevel"
    SORT_PROP_COMPUTE_INIT_CONFIG_POLICY_POLICY_OWNER = "compute_InitConfigPolicy_policyOwner"
    SORT_PROP_COMPUTE_INIT_CONFIG_POLICY_QUALIFIER = "compute_InitConfigPolicy_qualifier"
    SORT_PROP_COMPUTE_INSTANCE_ID_QUAL_MAX_ID = "compute_InstanceIdQual_maxId"
    SORT_PROP_COMPUTE_INSTANCE_ID_QUAL_MIN_ID = "compute_InstanceIdQual_minId"
    SORT_PROP_COMPUTE_INSTANCE_MAPPING_DESCR = "compute_InstanceMapping_descr"
    SORT_PROP_COMPUTE_INSTANCE_MAPPING_INSTANCE_DN = "compute_InstanceMapping_instanceDn"
    SORT_PROP_COMPUTE_INSTANCE_MAPPING_INT_ID = "compute_InstanceMapping_intId"
    SORT_PROP_COMPUTE_INSTANCE_MAPPING_LS_DN = "compute_InstanceMapping_lsDn"
    SORT_PROP_COMPUTE_INSTANCE_MAPPING_NAME = "compute_InstanceMapping_name"
    SORT_PROP_COMPUTE_INSTANCE_MAPPING_POLICY_LEVEL = "compute_InstanceMapping_policyLevel"
    SORT_PROP_COMPUTE_INSTANCE_MAPPING_POLICY_OWNER = "compute_InstanceMapping_policyOwner"
    SORT_PROP_COMPUTE_INSTANCE_ASSIGN_STATE = "compute_Instance_assignState"
    SORT_PROP_COMPUTE_INSTANCE_ASSOC_STATE = "compute_Instance_assocState"
    SORT_PROP_COMPUTE_INSTANCE_CONFIG_QUALIFIER = "compute_Instance_configQualifier"
    SORT_PROP_COMPUTE_INSTANCE_CONFIG_STATE = "compute_Instance_configState"
    SORT_PROP_COMPUTE_INSTANCE_DESCR = "compute_Instance_descr"
    SORT_PROP_COMPUTE_INSTANCE_GLOBAL_LS_DN = "compute_Instance_globalLsDn"
    SORT_PROP_COMPUTE_INSTANCE_GUID = "compute_Instance_guid"
    SORT_PROP_COMPUTE_INSTANCE_ID = "compute_Instance_id"
    SORT_PROP_COMPUTE_INSTANCE_INT_ID = "compute_Instance_intId"
    SORT_PROP_COMPUTE_INSTANCE_MGMT_IP_ADDR = "compute_Instance_mgmtIpAddr"
    SORT_PROP_COMPUTE_INSTANCE_NAME = "compute_Instance_name"
    SORT_PROP_COMPUTE_INSTANCE_OPER_STATE = "compute_Instance_operState"
    SORT_PROP_COMPUTE_INSTANCE_PHYS_DN = "compute_Instance_physDn"
    SORT_PROP_COMPUTE_INSTANCE_POLICY_LEVEL = "compute_Instance_policyLevel"
    SORT_PROP_COMPUTE_INSTANCE_POLICY_OWNER = "compute_Instance_policyOwner"
    SORT_PROP_COMPUTE_INSTANCE_SYSTEM_NAME = "compute_Instance_systemName"
    SORT_PROP_COMPUTE_INSTANCE_TEMPL_DN = "compute_Instance_templDn"
    SORT_PROP_COMPUTE_INSTANCE_USR_LBL = "compute_Instance_usrLbl"
    SORT_PROP_COMPUTE_INSTANCE_UUID = "compute_Instance_uuid"
    SORT_PROP_COMPUTE_INSTANCE_VERSION = "compute_Instance_version"
    SORT_PROP_COMPUTE_ITEM_ADMIN_STATE = "compute_Item_adminState"
    SORT_PROP_COMPUTE_ITEM_ASSIGNED_TO_DN = "compute_Item_assignedToDn"
    SORT_PROP_COMPUTE_ITEM_ASSOCIATION = "compute_Item_association"
    SORT_PROP_COMPUTE_ITEM_AVAILABILITY = "compute_Item_availability"
    SORT_PROP_COMPUTE_ITEM_DESCR = "compute_Item_descr"
    SORT_PROP_COMPUTE_ITEM_DISCOVERY = "compute_Item_discovery"
    SORT_PROP_COMPUTE_ITEM_INT_ID = "compute_Item_intId"
    SORT_PROP_COMPUTE_ITEM_LS_DN = "compute_Item_lsDn"
    SORT_PROP_COMPUTE_ITEM_NAME = "compute_Item_name"
    SORT_PROP_COMPUTE_ITEM_OPER_STATE = "compute_Item_operState"
    SORT_PROP_COMPUTE_ITEM_POLICY_LEVEL = "compute_Item_policyLevel"
    SORT_PROP_COMPUTE_ITEM_POLICY_OWNER = "compute_Item_policyOwner"
    SORT_PROP_COMPUTE_ITEM_UUID = "compute_Item_uuid"
    SORT_PROP_COMPUTE_LOCAL_TEMPL_DEF_DESCR = "compute_LocalTemplDef_descr"
    SORT_PROP_COMPUTE_LOCAL_TEMPL_DEF_ID = "compute_LocalTemplDef_id"
    SORT_PROP_COMPUTE_LOCAL_TEMPL_DEF_INT_ID = "compute_LocalTemplDef_intId"
    SORT_PROP_COMPUTE_LOCAL_TEMPL_DEF_NAME = "compute_LocalTemplDef_name"
    SORT_PROP_COMPUTE_LOCAL_TEMPL_DEF_POLICY_LEVEL = "compute_LocalTemplDef_policyLevel"
    SORT_PROP_COMPUTE_LOCAL_TEMPL_DEF_POLICY_OWNER = "compute_LocalTemplDef_policyOwner"
    SORT_PROP_COMPUTE_LOCAL_TEMPL_DEF_SYSTEM_NAME = "compute_LocalTemplDef_systemName"
    SORT_PROP_COMPUTE_LOCAL_TEMPL_DEF_TYPE = "compute_LocalTemplDef_type"
    SORT_PROP_COMPUTE_LOGICAL_DESCR = "compute_Logical_descr"
    SORT_PROP_COMPUTE_LOGICAL_INT_ID = "compute_Logical_intId"
    SORT_PROP_COMPUTE_LOGICAL_LS_DN = "compute_Logical_lsDn"
    SORT_PROP_COMPUTE_LOGICAL_NAME = "compute_Logical_name"
    SORT_PROP_COMPUTE_LOGICAL_PN_DN = "compute_Logical_pnDn"
    SORT_PROP_COMPUTE_LOGICAL_POLICY_LEVEL = "compute_Logical_policyLevel"
    SORT_PROP_COMPUTE_LOGICAL_POLICY_OWNER = "compute_Logical_policyOwner"
    SORT_PROP_COMPUTE_LOGICAL_UUID = "compute_Logical_uuid"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_CONSUMED_POWER = "compute_MbPowerStatsHist_consumedPower"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_CONSUMED_POWER_AVG = "compute_MbPowerStatsHist_consumedPowerAvg"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_CONSUMED_POWER_MAX = "compute_MbPowerStatsHist_consumedPowerMax"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_CONSUMED_POWER_MIN = "compute_MbPowerStatsHist_consumedPowerMin"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_ID = "compute_MbPowerStatsHist_id"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_INPUT_CURRENT = "compute_MbPowerStatsHist_inputCurrent"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_INPUT_CURRENT_AVG = "compute_MbPowerStatsHist_inputCurrentAvg"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_INPUT_CURRENT_MAX = "compute_MbPowerStatsHist_inputCurrentMax"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_INPUT_CURRENT_MIN = "compute_MbPowerStatsHist_inputCurrentMin"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_INPUT_VOLTAGE = "compute_MbPowerStatsHist_inputVoltage"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_INPUT_VOLTAGE_AVG = "compute_MbPowerStatsHist_inputVoltageAvg"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_INPUT_VOLTAGE_MAX = "compute_MbPowerStatsHist_inputVoltageMax"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_INPUT_VOLTAGE_MIN = "compute_MbPowerStatsHist_inputVoltageMin"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_MOST_RECENT = "compute_MbPowerStatsHist_mostRecent"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_SUSPECT = "compute_MbPowerStatsHist_suspect"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_THRESHOLDED = "compute_MbPowerStatsHist_thresholded"
    SORT_PROP_COMPUTE_MB_POWER_STATS_HIST_TIME_COLLECTED = "compute_MbPowerStatsHist_timeCollected"
    SORT_PROP_COMPUTE_MB_POWER_STATS_CONSUMED_POWER = "compute_MbPowerStats_consumedPower"
    SORT_PROP_COMPUTE_MB_POWER_STATS_CONSUMED_POWER_AVG = "compute_MbPowerStats_consumedPowerAvg"
    SORT_PROP_COMPUTE_MB_POWER_STATS_CONSUMED_POWER_MAX = "compute_MbPowerStats_consumedPowerMax"
    SORT_PROP_COMPUTE_MB_POWER_STATS_CONSUMED_POWER_MIN = "compute_MbPowerStats_consumedPowerMin"
    SORT_PROP_COMPUTE_MB_POWER_STATS_INPUT_CURRENT = "compute_MbPowerStats_inputCurrent"
    SORT_PROP_COMPUTE_MB_POWER_STATS_INPUT_CURRENT_AVG = "compute_MbPowerStats_inputCurrentAvg"
    SORT_PROP_COMPUTE_MB_POWER_STATS_INPUT_CURRENT_MAX = "compute_MbPowerStats_inputCurrentMax"
    SORT_PROP_COMPUTE_MB_POWER_STATS_INPUT_CURRENT_MIN = "compute_MbPowerStats_inputCurrentMin"
    SORT_PROP_COMPUTE_MB_POWER_STATS_INPUT_VOLTAGE = "compute_MbPowerStats_inputVoltage"
    SORT_PROP_COMPUTE_MB_POWER_STATS_INPUT_VOLTAGE_AVG = "compute_MbPowerStats_inputVoltageAvg"
    SORT_PROP_COMPUTE_MB_POWER_STATS_INPUT_VOLTAGE_MAX = "compute_MbPowerStats_inputVoltageMax"
    SORT_PROP_COMPUTE_MB_POWER_STATS_INPUT_VOLTAGE_MIN = "compute_MbPowerStats_inputVoltageMin"
    SORT_PROP_COMPUTE_MB_POWER_STATS_INTERVALS = "compute_MbPowerStats_intervals"
    SORT_PROP_COMPUTE_MB_POWER_STATS_NORMALIZED_TIME_COL = "compute_MbPowerStats_normalizedTimeCol"
    SORT_PROP_COMPUTE_MB_POWER_STATS_STATS_REPORTED = "compute_MbPowerStats_statsReported"
    SORT_PROP_COMPUTE_MB_POWER_STATS_SUSPECT = "compute_MbPowerStats_suspect"
    SORT_PROP_COMPUTE_MB_POWER_STATS_THRESHOLDED = "compute_MbPowerStats_thresholded"
    SORT_PROP_COMPUTE_MB_POWER_STATS_TIME_COLLECTED = "compute_MbPowerStats_timeCollected"
    SORT_PROP_COMPUTE_MB_POWER_STATS_UPDATE = "compute_MbPowerStats_update"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_IO = "compute_MbTempStatsHist_fmTempSenIo"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_IO_AVG = "compute_MbTempStatsHist_fmTempSenIoAvg"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_IO_MAX = "compute_MbTempStatsHist_fmTempSenIoMax"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_IO_MIN = "compute_MbTempStatsHist_fmTempSenIoMin"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR = "compute_MbTempStatsHist_fmTempSenRear"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_AVG = "compute_MbTempStatsHist_fmTempSenRearAvg"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_L = "compute_MbTempStatsHist_fmTempSenRearL"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_LAVG = "compute_MbTempStatsHist_fmTempSenRearLAvg"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_LMAX = "compute_MbTempStatsHist_fmTempSenRearLMax"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_LMIN = "compute_MbTempStatsHist_fmTempSenRearLMin"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_MAX = "compute_MbTempStatsHist_fmTempSenRearMax"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_MIN = "compute_MbTempStatsHist_fmTempSenRearMin"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_R = "compute_MbTempStatsHist_fmTempSenRearR"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_RAVG = "compute_MbTempStatsHist_fmTempSenRearRAvg"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_RMAX = "compute_MbTempStatsHist_fmTempSenRearRMax"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_FM_TEMP_SEN_REAR_RMIN = "compute_MbTempStatsHist_fmTempSenRearRMin"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_ID = "compute_MbTempStatsHist_id"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_MOST_RECENT = "compute_MbTempStatsHist_mostRecent"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_SUSPECT = "compute_MbTempStatsHist_suspect"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_THRESHOLDED = "compute_MbTempStatsHist_thresholded"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_HIST_TIME_COLLECTED = "compute_MbTempStatsHist_timeCollected"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_IO = "compute_MbTempStats_fmTempSenIo"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_IO_AVG = "compute_MbTempStats_fmTempSenIoAvg"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_IO_MAX = "compute_MbTempStats_fmTempSenIoMax"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_IO_MIN = "compute_MbTempStats_fmTempSenIoMin"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR = "compute_MbTempStats_fmTempSenRear"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_AVG = "compute_MbTempStats_fmTempSenRearAvg"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_L = "compute_MbTempStats_fmTempSenRearL"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_LAVG = "compute_MbTempStats_fmTempSenRearLAvg"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_LMAX = "compute_MbTempStats_fmTempSenRearLMax"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_LMIN = "compute_MbTempStats_fmTempSenRearLMin"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_MAX = "compute_MbTempStats_fmTempSenRearMax"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_MIN = "compute_MbTempStats_fmTempSenRearMin"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_R = "compute_MbTempStats_fmTempSenRearR"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_RAVG = "compute_MbTempStats_fmTempSenRearRAvg"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_RMAX = "compute_MbTempStats_fmTempSenRearRMax"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_FM_TEMP_SEN_REAR_RMIN = "compute_MbTempStats_fmTempSenRearRMin"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_INTERVALS = "compute_MbTempStats_intervals"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_NORMALIZED_TIME_COL = "compute_MbTempStats_normalizedTimeCol"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_STATS_REPORTED = "compute_MbTempStats_statsReported"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_SUSPECT = "compute_MbTempStats_suspect"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_THRESHOLDED = "compute_MbTempStats_thresholded"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_TIME_COLLECTED = "compute_MbTempStats_timeCollected"
    SORT_PROP_COMPUTE_MB_TEMP_STATS_UPDATE = "compute_MbTempStats_update"
    SORT_PROP_COMPUTE_NETWORK_FEAT_MASK_FEAT_MASK = "compute_NetworkFeatMask_featMask"
    SORT_PROP_COMPUTE_OWNER_QUAL_NAME = "compute_OwnerQual_name"
    SORT_PROP_COMPUTE_OWNER_QUAL_REGEX = "compute_OwnerQual_regex"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST_ABORT_ERRORS = "compute_PCIeFatalCompletionStatsHist_AbortErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST_ABORT_ERRORS_AVG = "compute_PCIeFatalCompletionStatsHist_AbortErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST_ABORT_ERRORS_MAX = "compute_PCIeFatalCompletionStatsHist_AbortErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST_ABORT_ERRORS_MIN = "compute_PCIeFatalCompletionStatsHist_AbortErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST_ABORT_ERRORS_RUNNING = "compute_PCIeFatalCompletionStatsHist_AbortErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST_TIMEOUT_ERRORS = "compute_PCIeFatalCompletionStatsHist_TimeoutErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST_TIMEOUT_ERRORS_AVG = "compute_PCIeFatalCompletionStatsHist_TimeoutErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST_TIMEOUT_ERRORS_MAX = "compute_PCIeFatalCompletionStatsHist_TimeoutErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST_TIMEOUT_ERRORS_MIN = "compute_PCIeFatalCompletionStatsHist_TimeoutErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST_TIMEOUT_ERRORS_RUNNING = "compute_PCIeFatalCompletionStatsHist_TimeoutErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST_ID = "compute_PCIeFatalCompletionStatsHist_id"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST_MOST_RECENT = "compute_PCIeFatalCompletionStatsHist_mostRecent"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST_SUSPECT = "compute_PCIeFatalCompletionStatsHist_suspect"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST_THRESHOLDED = "compute_PCIeFatalCompletionStatsHist_thresholded"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST_TIME_COLLECTED = "compute_PCIeFatalCompletionStatsHist_timeCollected"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST_UNEXPECTED_ERRORS = "compute_PCIeFatalCompletionStatsHist_unexpectedErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST_UNEXPECTED_ERRORS_AVG = "compute_PCIeFatalCompletionStatsHist_unexpectedErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST_UNEXPECTED_ERRORS_MAX = "compute_PCIeFatalCompletionStatsHist_unexpectedErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST_UNEXPECTED_ERRORS_MIN = "compute_PCIeFatalCompletionStatsHist_unexpectedErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_HIST_UNEXPECTED_ERRORS_RUNNING = "compute_PCIeFatalCompletionStatsHist_unexpectedErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS = "compute_PCIeFatalCompletionStats_AbortErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS_AVG = "compute_PCIeFatalCompletionStats_AbortErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS_MAX = "compute_PCIeFatalCompletionStats_AbortErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS_MIN = "compute_PCIeFatalCompletionStats_AbortErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_ABORT_ERRORS_RUNNING = "compute_PCIeFatalCompletionStats_AbortErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS = "compute_PCIeFatalCompletionStats_TimeoutErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS_AVG = "compute_PCIeFatalCompletionStats_TimeoutErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS_MAX = "compute_PCIeFatalCompletionStats_TimeoutErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS_MIN = "compute_PCIeFatalCompletionStats_TimeoutErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIMEOUT_ERRORS_RUNNING = "compute_PCIeFatalCompletionStats_TimeoutErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_INTERVALS = "compute_PCIeFatalCompletionStats_intervals"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_NORMALIZED_TIME_COL = "compute_PCIeFatalCompletionStats_normalizedTimeCol"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_STATS_REPORTED = "compute_PCIeFatalCompletionStats_statsReported"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_SUSPECT = "compute_PCIeFatalCompletionStats_suspect"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_THRESHOLDED = "compute_PCIeFatalCompletionStats_thresholded"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_TIME_COLLECTED = "compute_PCIeFatalCompletionStats_timeCollected"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS = "compute_PCIeFatalCompletionStats_unexpectedErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS_AVG = "compute_PCIeFatalCompletionStats_unexpectedErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS_MAX = "compute_PCIeFatalCompletionStats_unexpectedErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS_MIN = "compute_PCIeFatalCompletionStats_unexpectedErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UNEXPECTED_ERRORS_RUNNING = "compute_PCIeFatalCompletionStats_unexpectedErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_COMPLETION_STATS_UPDATE = "compute_PCIeFatalCompletionStats_update"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_HIST_DLLP_ERRORS = "compute_PCIeFatalProtocolStatsHist_dllpErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_HIST_DLLP_ERRORS_AVG = "compute_PCIeFatalProtocolStatsHist_dllpErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_HIST_DLLP_ERRORS_MAX = "compute_PCIeFatalProtocolStatsHist_dllpErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_HIST_DLLP_ERRORS_MIN = "compute_PCIeFatalProtocolStatsHist_dllpErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_HIST_DLLP_ERRORS_RUNNING = "compute_PCIeFatalProtocolStatsHist_dllpErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_HIST_FLOW_CONTROL_ERRORS = "compute_PCIeFatalProtocolStatsHist_flowControlErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_HIST_FLOW_CONTROL_ERRORS_AVG = "compute_PCIeFatalProtocolStatsHist_flowControlErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_HIST_FLOW_CONTROL_ERRORS_MAX = "compute_PCIeFatalProtocolStatsHist_flowControlErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_HIST_FLOW_CONTROL_ERRORS_MIN = "compute_PCIeFatalProtocolStatsHist_flowControlErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_HIST_FLOW_CONTROL_ERRORS_RUNNING = "compute_PCIeFatalProtocolStatsHist_flowControlErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_HIST_ID = "compute_PCIeFatalProtocolStatsHist_id"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_HIST_MOST_RECENT = "compute_PCIeFatalProtocolStatsHist_mostRecent"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_HIST_SUSPECT = "compute_PCIeFatalProtocolStatsHist_suspect"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_HIST_THRESHOLDED = "compute_PCIeFatalProtocolStatsHist_thresholded"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_HIST_TIME_COLLECTED = "compute_PCIeFatalProtocolStatsHist_timeCollected"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS = "compute_PCIeFatalProtocolStats_dllpErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS_AVG = "compute_PCIeFatalProtocolStats_dllpErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS_MAX = "compute_PCIeFatalProtocolStats_dllpErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS_MIN = "compute_PCIeFatalProtocolStats_dllpErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_DLLP_ERRORS_RUNNING = "compute_PCIeFatalProtocolStats_dllpErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS = "compute_PCIeFatalProtocolStats_flowControlErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS_AVG = "compute_PCIeFatalProtocolStats_flowControlErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS_MAX = "compute_PCIeFatalProtocolStats_flowControlErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS_MIN = "compute_PCIeFatalProtocolStats_flowControlErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_FLOW_CONTROL_ERRORS_RUNNING = "compute_PCIeFatalProtocolStats_flowControlErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_INTERVALS = "compute_PCIeFatalProtocolStats_intervals"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_NORMALIZED_TIME_COL = "compute_PCIeFatalProtocolStats_normalizedTimeCol"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_STATS_REPORTED = "compute_PCIeFatalProtocolStats_statsReported"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_SUSPECT = "compute_PCIeFatalProtocolStats_suspect"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_THRESHOLDED = "compute_PCIeFatalProtocolStats_thresholded"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_TIME_COLLECTED = "compute_PCIeFatalProtocolStats_timeCollected"
    SORT_PROP_COMPUTE_PCIE_FATAL_PROTOCOL_STATS_UPDATE = "compute_PCIeFatalProtocolStats_update"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_BUFFER_OVERFLOW_ERRORS = "compute_PCIeFatalReceiveStatsHist_bufferOverflowErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_BUFFER_OVERFLOW_ERRORS_AVG = "compute_PCIeFatalReceiveStatsHist_bufferOverflowErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_BUFFER_OVERFLOW_ERRORS_MAX = "compute_PCIeFatalReceiveStatsHist_bufferOverflowErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_BUFFER_OVERFLOW_ERRORS_MIN = "compute_PCIeFatalReceiveStatsHist_bufferOverflowErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_BUFFER_OVERFLOW_ERRORS_RUNNING = "compute_PCIeFatalReceiveStatsHist_bufferOverflowErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_ERR_FATAL_ERRORS = "compute_PCIeFatalReceiveStatsHist_errFatalErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_ERR_FATAL_ERRORS_AVG = "compute_PCIeFatalReceiveStatsHist_errFatalErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_ERR_FATAL_ERRORS_MAX = "compute_PCIeFatalReceiveStatsHist_errFatalErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_ERR_FATAL_ERRORS_MIN = "compute_PCIeFatalReceiveStatsHist_errFatalErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_ERR_FATAL_ERRORS_RUNNING = "compute_PCIeFatalReceiveStatsHist_errFatalErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_ERR_NON_FATAL_ERRORS = "compute_PCIeFatalReceiveStatsHist_errNonFatalErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_ERR_NON_FATAL_ERRORS_AVG = "compute_PCIeFatalReceiveStatsHist_errNonFatalErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_ERR_NON_FATAL_ERRORS_MAX = "compute_PCIeFatalReceiveStatsHist_errNonFatalErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_ERR_NON_FATAL_ERRORS_MIN = "compute_PCIeFatalReceiveStatsHist_errNonFatalErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_ERR_NON_FATAL_ERRORS_RUNNING = "compute_PCIeFatalReceiveStatsHist_errNonFatalErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_ID = "compute_PCIeFatalReceiveStatsHist_id"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_MOST_RECENT = "compute_PCIeFatalReceiveStatsHist_mostRecent"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_SUSPECT = "compute_PCIeFatalReceiveStatsHist_suspect"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_THRESHOLDED = "compute_PCIeFatalReceiveStatsHist_thresholded"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_TIME_COLLECTED = "compute_PCIeFatalReceiveStatsHist_timeCollected"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_UNSUPPORTED_REQUEST_ERRORS = "compute_PCIeFatalReceiveStatsHist_unsupportedRequestErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_UNSUPPORTED_REQUEST_ERRORS_AVG = "compute_PCIeFatalReceiveStatsHist_unsupportedRequestErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_UNSUPPORTED_REQUEST_ERRORS_MAX = "compute_PCIeFatalReceiveStatsHist_unsupportedRequestErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_UNSUPPORTED_REQUEST_ERRORS_MIN = "compute_PCIeFatalReceiveStatsHist_unsupportedRequestErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_HIST_UNSUPPORTED_REQUEST_ERRORS_RUNNING = "compute_PCIeFatalReceiveStatsHist_unsupportedRequestErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS = "compute_PCIeFatalReceiveStats_bufferOverflowErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS_AVG = "compute_PCIeFatalReceiveStats_bufferOverflowErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS_MAX = "compute_PCIeFatalReceiveStats_bufferOverflowErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS_MIN = "compute_PCIeFatalReceiveStats_bufferOverflowErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_BUFFER_OVERFLOW_ERRORS_RUNNING = "compute_PCIeFatalReceiveStats_bufferOverflowErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS = "compute_PCIeFatalReceiveStats_errFatalErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS_AVG = "compute_PCIeFatalReceiveStats_errFatalErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS_MAX = "compute_PCIeFatalReceiveStats_errFatalErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS_MIN = "compute_PCIeFatalReceiveStats_errFatalErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_FATAL_ERRORS_RUNNING = "compute_PCIeFatalReceiveStats_errFatalErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS = "compute_PCIeFatalReceiveStats_errNonFatalErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS_AVG = "compute_PCIeFatalReceiveStats_errNonFatalErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS_MAX = "compute_PCIeFatalReceiveStats_errNonFatalErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS_MIN = "compute_PCIeFatalReceiveStats_errNonFatalErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_ERR_NON_FATAL_ERRORS_RUNNING = "compute_PCIeFatalReceiveStats_errNonFatalErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_INTERVALS = "compute_PCIeFatalReceiveStats_intervals"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_NORMALIZED_TIME_COL = "compute_PCIeFatalReceiveStats_normalizedTimeCol"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_STATS_REPORTED = "compute_PCIeFatalReceiveStats_statsReported"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_SUSPECT = "compute_PCIeFatalReceiveStats_suspect"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_THRESHOLDED = "compute_PCIeFatalReceiveStats_thresholded"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_TIME_COLLECTED = "compute_PCIeFatalReceiveStats_timeCollected"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS = "compute_PCIeFatalReceiveStats_unsupportedRequestErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS_AVG = "compute_PCIeFatalReceiveStats_unsupportedRequestErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS_MAX = "compute_PCIeFatalReceiveStats_unsupportedRequestErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS_MIN = "compute_PCIeFatalReceiveStats_unsupportedRequestErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UNSUPPORTED_REQUEST_ERRORS_RUNNING = "compute_PCIeFatalReceiveStats_unsupportedRequestErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_RECEIVE_STATS_UPDATE = "compute_PCIeFatalReceiveStats_update"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_ACS_VIOLATION_ERRORS = "compute_PCIeFatalStatsHist_acsViolationErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_ACS_VIOLATION_ERRORS_AVG = "compute_PCIeFatalStatsHist_acsViolationErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_ACS_VIOLATION_ERRORS_MAX = "compute_PCIeFatalStatsHist_acsViolationErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_ACS_VIOLATION_ERRORS_MIN = "compute_PCIeFatalStatsHist_acsViolationErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_ACS_VIOLATION_ERRORS_RUNNING = "compute_PCIeFatalStatsHist_acsViolationErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_ID = "compute_PCIeFatalStatsHist_id"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_MALFORMED_TLPERRORS = "compute_PCIeFatalStatsHist_malformedTLPErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_MALFORMED_TLPERRORS_AVG = "compute_PCIeFatalStatsHist_malformedTLPErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_MALFORMED_TLPERRORS_MAX = "compute_PCIeFatalStatsHist_malformedTLPErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_MALFORMED_TLPERRORS_MIN = "compute_PCIeFatalStatsHist_malformedTLPErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_MALFORMED_TLPERRORS_RUNNING = "compute_PCIeFatalStatsHist_malformedTLPErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_MOST_RECENT = "compute_PCIeFatalStatsHist_mostRecent"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_POISONED_TLPERRORS = "compute_PCIeFatalStatsHist_poisonedTLPErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_POISONED_TLPERRORS_AVG = "compute_PCIeFatalStatsHist_poisonedTLPErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_POISONED_TLPERRORS_MAX = "compute_PCIeFatalStatsHist_poisonedTLPErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_POISONED_TLPERRORS_MIN = "compute_PCIeFatalStatsHist_poisonedTLPErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_POISONED_TLPERRORS_RUNNING = "compute_PCIeFatalStatsHist_poisonedTLPErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_SURPRISE_LINK_DOWN_ERRORS = "compute_PCIeFatalStatsHist_surpriseLinkDownErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_SURPRISE_LINK_DOWN_ERRORS_AVG = "compute_PCIeFatalStatsHist_surpriseLinkDownErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_SURPRISE_LINK_DOWN_ERRORS_MAX = "compute_PCIeFatalStatsHist_surpriseLinkDownErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_SURPRISE_LINK_DOWN_ERRORS_MIN = "compute_PCIeFatalStatsHist_surpriseLinkDownErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_SURPRISE_LINK_DOWN_ERRORS_RUNNING = "compute_PCIeFatalStatsHist_surpriseLinkDownErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_SUSPECT = "compute_PCIeFatalStatsHist_suspect"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_THRESHOLDED = "compute_PCIeFatalStatsHist_thresholded"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_HIST_TIME_COLLECTED = "compute_PCIeFatalStatsHist_timeCollected"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS = "compute_PCIeFatalStats_acsViolationErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS_AVG = "compute_PCIeFatalStats_acsViolationErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS_MAX = "compute_PCIeFatalStats_acsViolationErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS_MIN = "compute_PCIeFatalStats_acsViolationErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_ACS_VIOLATION_ERRORS_RUNNING = "compute_PCIeFatalStats_acsViolationErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_INTERVALS = "compute_PCIeFatalStats_intervals"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS = "compute_PCIeFatalStats_malformedTLPErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS_AVG = "compute_PCIeFatalStats_malformedTLPErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS_MAX = "compute_PCIeFatalStats_malformedTLPErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS_MIN = "compute_PCIeFatalStats_malformedTLPErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_MALFORMED_TLPERRORS_RUNNING = "compute_PCIeFatalStats_malformedTLPErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_NORMALIZED_TIME_COL = "compute_PCIeFatalStats_normalizedTimeCol"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS = "compute_PCIeFatalStats_poisonedTLPErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS_AVG = "compute_PCIeFatalStats_poisonedTLPErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS_MAX = "compute_PCIeFatalStats_poisonedTLPErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS_MIN = "compute_PCIeFatalStats_poisonedTLPErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_POISONED_TLPERRORS_RUNNING = "compute_PCIeFatalStats_poisonedTLPErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_STATS_REPORTED = "compute_PCIeFatalStats_statsReported"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS = "compute_PCIeFatalStats_surpriseLinkDownErrors"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS_AVG = "compute_PCIeFatalStats_surpriseLinkDownErrorsAvg"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS_MAX = "compute_PCIeFatalStats_surpriseLinkDownErrorsMax"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS_MIN = "compute_PCIeFatalStats_surpriseLinkDownErrorsMin"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_SURPRISE_LINK_DOWN_ERRORS_RUNNING = "compute_PCIeFatalStats_surpriseLinkDownErrorsRunning"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_SUSPECT = "compute_PCIeFatalStats_suspect"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_THRESHOLDED = "compute_PCIeFatalStats_thresholded"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_TIME_COLLECTED = "compute_PCIeFatalStats_timeCollected"
    SORT_PROP_COMPUTE_PCIE_FATAL_STATS_UPDATE = "compute_PCIeFatalStats_update"
    SORT_PROP_COMPUTE_PHYSICAL_ASSOC_CTX_FRU_CAP_DN = "compute_PhysicalAssocCtx_fruCapDn"
    SORT_PROP_COMPUTE_PHYSICAL_EXTENSION_HW_INVENTORY_STATUS = "compute_PhysicalExtension_hwInventoryStatus"
    SORT_PROP_COMPUTE_PHYSICAL_OPERATION_ADMIN_POWER = "compute_PhysicalOperation_adminPower"
    SORT_PROP_COMPUTE_PHYSICAL_OPERATION_LAST_MODIFIED = "compute_PhysicalOperation_lastModified"
    SORT_PROP_COMPUTE_PHYSICAL_OPERATION_LC = "compute_PhysicalOperation_lc"
    SORT_PROP_COMPUTE_PHYSICAL_OPERATION_REMOTE_ERROR_CODE = "compute_PhysicalOperation_remoteErrorCode"
    SORT_PROP_COMPUTE_PHYSICAL_OPERATION_REMOTE_ERROR_DESCR = "compute_PhysicalOperation_remoteErrorDescr"
    SORT_PROP_COMPUTE_PHYSICAL_OPERATION_TRIGGER_STATUS = "compute_PhysicalOperation_triggerStatus"
    SORT_PROP_COMPUTE_PHYSICAL_QUAL_MODEL = "compute_PhysicalQual_model"
    SORT_PROP_COMPUTE_PHYSICAL_ADMIN_POWER = "compute_Physical_adminPower"
    SORT_PROP_COMPUTE_PHYSICAL_ADMIN_STATE = "compute_Physical_adminState"
    SORT_PROP_COMPUTE_PHYSICAL_ASSET_TAG = "compute_Physical_assetTag"
    SORT_PROP_COMPUTE_PHYSICAL_ASSIGNED_TO_DN = "compute_Physical_assignedToDn"
    SORT_PROP_COMPUTE_PHYSICAL_ASSOCIATION = "compute_Physical_association"
    SORT_PROP_COMPUTE_PHYSICAL_AVAILABILITY = "compute_Physical_availability"
    SORT_PROP_COMPUTE_PHYSICAL_AVAILABLE_MEMORY = "compute_Physical_availableMemory"
    SORT_PROP_COMPUTE_PHYSICAL_CHECK_POINT = "compute_Physical_checkPoint"
    SORT_PROP_COMPUTE_PHYSICAL_CONN_PATH = "compute_Physical_connPath"
    SORT_PROP_COMPUTE_PHYSICAL_CONN_STATUS = "compute_Physical_connStatus"
    SORT_PROP_COMPUTE_PHYSICAL_DESCR = "compute_Physical_descr"
    SORT_PROP_COMPUTE_PHYSICAL_DISCOVERY = "compute_Physical_discovery"
    SORT_PROP_COMPUTE_PHYSICAL_DISCOVERY_STATUS = "compute_Physical_discoveryStatus"
    SORT_PROP_COMPUTE_PHYSICAL_INT_ID = "compute_Physical_intId"
    SORT_PROP_COMPUTE_PHYSICAL_KMIP_FAULT = "compute_Physical_kmipFault"
    SORT_PROP_COMPUTE_PHYSICAL_KMIP_FAULT_DESCRIPTION = "compute_Physical_kmipFaultDescription"
    SORT_PROP_COMPUTE_PHYSICAL_LC = "compute_Physical_lc"
    SORT_PROP_COMPUTE_PHYSICAL_LC_TS = "compute_Physical_lcTs"
    SORT_PROP_COMPUTE_PHYSICAL_LOCAL_ID = "compute_Physical_localId"
    SORT_PROP_COMPUTE_PHYSICAL_LOW_VOLTAGE_MEMORY = "compute_Physical_lowVoltageMemory"
    SORT_PROP_COMPUTE_PHYSICAL_LS_DN = "compute_Physical_lsDn"
    SORT_PROP_COMPUTE_PHYSICAL_MANAGING_INST = "compute_Physical_managingInst"
    SORT_PROP_COMPUTE_PHYSICAL_MEMORY_SPEED = "compute_Physical_memorySpeed"
    SORT_PROP_COMPUTE_PHYSICAL_MFG_TIME = "compute_Physical_mfgTime"
    SORT_PROP_COMPUTE_PHYSICAL_MODEL = "compute_Physical_model"
    SORT_PROP_COMPUTE_PHYSICAL_NAME = "compute_Physical_name"
    SORT_PROP_COMPUTE_PHYSICAL_NUM_OF40_GADAPTORS_WITH_OLD_FW = "compute_Physical_numOf40GAdaptorsWithOldFw"
    SORT_PROP_COMPUTE_PHYSICAL_NUM_OF40_GADAPTORS_WITH_UNKNOWN_FW = "compute_Physical_numOf40GAdaptorsWithUnknownFw"
    SORT_PROP_COMPUTE_PHYSICAL_NUM_OF_ADAPTORS = "compute_Physical_numOfAdaptors"
    SORT_PROP_COMPUTE_PHYSICAL_NUM_OF_CORES = "compute_Physical_numOfCores"
    SORT_PROP_COMPUTE_PHYSICAL_NUM_OF_CORES_ENABLED = "compute_Physical_numOfCoresEnabled"
    SORT_PROP_COMPUTE_PHYSICAL_NUM_OF_CPUS = "compute_Physical_numOfCpus"
    SORT_PROP_COMPUTE_PHYSICAL_NUM_OF_ETH_HOST_IFS = "compute_Physical_numOfEthHostIfs"
    SORT_PROP_COMPUTE_PHYSICAL_NUM_OF_FC_HOST_IFS = "compute_Physical_numOfFcHostIfs"
    SORT_PROP_COMPUTE_PHYSICAL_NUM_OF_THREADS = "compute_Physical_numOfThreads"
    SORT_PROP_COMPUTE_PHYSICAL_OPER_POWER = "compute_Physical_operPower"
    SORT_PROP_COMPUTE_PHYSICAL_OPER_PWR_TRANS_SRC = "compute_Physical_operPwrTransSrc"
    SORT_PROP_COMPUTE_PHYSICAL_OPER_QUALIFIER = "compute_Physical_operQualifier"
    SORT_PROP_COMPUTE_PHYSICAL_OPER_STATE = "compute_Physical_operState"
    SORT_PROP_COMPUTE_PHYSICAL_OPERABILITY = "compute_Physical_operability"
    SORT_PROP_COMPUTE_PHYSICAL_ORIGINAL_UUID = "compute_Physical_originalUuid"
    SORT_PROP_COMPUTE_PHYSICAL_PART_NUMBER = "compute_Physical_partNumber"
    SORT_PROP_COMPUTE_PHYSICAL_POLICY_LEVEL = "compute_Physical_policyLevel"
    SORT_PROP_COMPUTE_PHYSICAL_POLICY_OWNER = "compute_Physical_policyOwner"
    SORT_PROP_COMPUTE_PHYSICAL_PRESENCE = "compute_Physical_presence"
    SORT_PROP_COMPUTE_PHYSICAL_REVISION = "compute_Physical_revision"
    SORT_PROP_COMPUTE_PHYSICAL_SERIAL = "compute_Physical_serial"
    SORT_PROP_COMPUTE_PHYSICAL_SERVER_ID = "compute_Physical_serverId"
    SORT_PROP_COMPUTE_PHYSICAL_TOTAL_MEMORY = "compute_Physical_totalMemory"
    SORT_PROP_COMPUTE_PHYSICAL_USR_LBL = "compute_Physical_usrLbl"
    SORT_PROP_COMPUTE_PHYSICAL_UUID = "compute_Physical_uuid"
    SORT_PROP_COMPUTE_PHYSICAL_VENDOR = "compute_Physical_vendor"
    SORT_PROP_COMPUTE_PHYSICAL_VID = "compute_Physical_vid"
    SORT_PROP_COMPUTE_PLACEABLE_DESCR = "compute_Placeable_descr"
    SORT_PROP_COMPUTE_PLACEABLE_INT_ID = "compute_Placeable_intId"
    SORT_PROP_COMPUTE_PLACEABLE_NAME = "compute_Placeable_name"
    SORT_PROP_COMPUTE_PLACEABLE_PLACEMENT_REF_CNT = "compute_Placeable_placementRefCnt"
    SORT_PROP_COMPUTE_PLACEABLE_POLICY_LEVEL = "compute_Placeable_policyLevel"
    SORT_PROP_COMPUTE_PLACEABLE_POLICY_OWNER = "compute_Placeable_policyOwner"
    SORT_PROP_COMPUTE_PLACED_DESCR = "compute_Placed_descr"
    SORT_PROP_COMPUTE_PLACED_ID = "compute_Placed_id"
    SORT_PROP_COMPUTE_PLACED_INT_ID = "compute_Placed_intId"
    SORT_PROP_COMPUTE_PLACED_NAME = "compute_Placed_name"
    SORT_PROP_COMPUTE_PLACED_POLICY_LEVEL = "compute_Placed_policyLevel"
    SORT_PROP_COMPUTE_PLACED_POLICY_OWNER = "compute_Placed_policyOwner"
    SORT_PROP_COMPUTE_PLACED_SYSTEM_NAME = "compute_Placed_systemName"
    SORT_PROP_COMPUTE_POOL_POLICY_REF_ID = "compute_PoolPolicyRef_id"
    SORT_PROP_COMPUTE_POOL_POLICY_REF_POLICY_DN = "compute_PoolPolicyRef_policyDn"
    SORT_PROP_COMPUTE_POOL_ASSIGNED = "compute_Pool_assigned"
    SORT_PROP_COMPUTE_POOL_DESCR = "compute_Pool_descr"
    SORT_PROP_COMPUTE_POOL_FLT_AGGR = "compute_Pool_fltAggr"
    SORT_PROP_COMPUTE_POOL_INT_ID = "compute_Pool_intId"
    SORT_PROP_COMPUTE_POOL_NAME = "compute_Pool_name"
    SORT_PROP_COMPUTE_POOL_POLICY_LEVEL = "compute_Pool_policyLevel"
    SORT_PROP_COMPUTE_POOL_POLICY_OWNER = "compute_Pool_policyOwner"
    SORT_PROP_COMPUTE_POOL_POOL_TYPE = "compute_Pool_poolType"
    SORT_PROP_COMPUTE_POOL_SIZE = "compute_Pool_size"
    SORT_PROP_COMPUTE_POOLABLE_ASSIGNED_TO_DN = "compute_Poolable_assignedToDn"
    SORT_PROP_COMPUTE_POOLABLE_ID = "compute_Poolable_id"
    SORT_PROP_COMPUTE_POOLABLE_OWNER = "compute_Poolable_owner"
    SORT_PROP_COMPUTE_POOLABLE_POOL_DN = "compute_Poolable_poolDn"
    SORT_PROP_COMPUTE_POOLABLE_SYS_ID = "compute_Poolable_sysId"
    SORT_PROP_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT_ASSIGNED = "compute_PooledEnclosureComputeSlot_assigned"
    SORT_PROP_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT_ASSIGNED_TO_DN = "compute_PooledEnclosureComputeSlot_assignedToDn"
    SORT_PROP_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT_BLOCK_DN = "compute_PooledEnclosureComputeSlot_blockDn"
    SORT_PROP_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT_CHASSIS_ID = "compute_PooledEnclosureComputeSlot_chassisId"
    SORT_PROP_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT_CONS_CNT = "compute_PooledEnclosureComputeSlot_consCnt"
    SORT_PROP_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT_ID_RELEASED_TIME = "compute_PooledEnclosureComputeSlot_idReleasedTime"
    SORT_PROP_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT_OWNER = "compute_PooledEnclosureComputeSlot_owner"
    SORT_PROP_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT_POOLABLE_DN = "compute_PooledEnclosureComputeSlot_poolableDn"
    SORT_PROP_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT_PREV_ASSIGNED_TO_DN = "compute_PooledEnclosureComputeSlot_prevAssignedToDn"
    SORT_PROP_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT_SERVER_INSTANCE_ID = "compute_PooledEnclosureComputeSlot_serverInstanceId"
    SORT_PROP_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT_SLOT_ID = "compute_PooledEnclosureComputeSlot_slotId"
    SORT_PROP_COMPUTE_POOLED_ENCLOSURE_COMPUTE_SLOT_SYSTEM_ID = "compute_PooledEnclosureComputeSlot_systemId"
    SORT_PROP_COMPUTE_POOLED_PHYSICAL_ASSIGNED = "compute_PooledPhysical_assigned"
    SORT_PROP_COMPUTE_POOLED_PHYSICAL_ASSIGNED_TO_DN = "compute_PooledPhysical_assignedToDn"
    SORT_PROP_COMPUTE_POOLED_PHYSICAL_BLOCK_DN = "compute_PooledPhysical_blockDn"
    SORT_PROP_COMPUTE_POOLED_PHYSICAL_CONS_CNT = "compute_PooledPhysical_consCnt"
    SORT_PROP_COMPUTE_POOLED_PHYSICAL_ID_RELEASED_TIME = "compute_PooledPhysical_idReleasedTime"
    SORT_PROP_COMPUTE_POOLED_PHYSICAL_OWNER = "compute_PooledPhysical_owner"
    SORT_PROP_COMPUTE_POOLED_PHYSICAL_POOLABLE_DN = "compute_PooledPhysical_poolableDn"
    SORT_PROP_COMPUTE_POOLED_PHYSICAL_PREV_ASSIGNED_TO_DN = "compute_PooledPhysical_prevAssignedToDn"
    SORT_PROP_COMPUTE_POOLED_PHYSICAL_SYSTEM_ID = "compute_PooledPhysical_systemId"
    SORT_PROP_COMPUTE_POOLED_RACK_UNIT_ASSIGNED = "compute_PooledRackUnit_assigned"
    SORT_PROP_COMPUTE_POOLED_RACK_UNIT_ASSIGNED_TO_DN = "compute_PooledRackUnit_assignedToDn"
    SORT_PROP_COMPUTE_POOLED_RACK_UNIT_BLOCK_DN = "compute_PooledRackUnit_blockDn"
    SORT_PROP_COMPUTE_POOLED_RACK_UNIT_CONS_CNT = "compute_PooledRackUnit_consCnt"
    SORT_PROP_COMPUTE_POOLED_RACK_UNIT_ID = "compute_PooledRackUnit_id"
    SORT_PROP_COMPUTE_POOLED_RACK_UNIT_ID_RELEASED_TIME = "compute_PooledRackUnit_idReleasedTime"
    SORT_PROP_COMPUTE_POOLED_RACK_UNIT_OWNER = "compute_PooledRackUnit_owner"
    SORT_PROP_COMPUTE_POOLED_RACK_UNIT_POOLABLE_DN = "compute_PooledRackUnit_poolableDn"
    SORT_PROP_COMPUTE_POOLED_RACK_UNIT_PREV_ASSIGNED_TO_DN = "compute_PooledRackUnit_prevAssignedToDn"
    SORT_PROP_COMPUTE_POOLED_RACK_UNIT_SYSTEM_ID = "compute_PooledRackUnit_systemId"
    SORT_PROP_COMPUTE_POOLED_SLOT_ASSIGNED = "compute_PooledSlot_assigned"
    SORT_PROP_COMPUTE_POOLED_SLOT_ASSIGNED_TO_DN = "compute_PooledSlot_assignedToDn"
    SORT_PROP_COMPUTE_POOLED_SLOT_BLOCK_DN = "compute_PooledSlot_blockDn"
    SORT_PROP_COMPUTE_POOLED_SLOT_CHASSIS_ID = "compute_PooledSlot_chassisId"
    SORT_PROP_COMPUTE_POOLED_SLOT_CONS_CNT = "compute_PooledSlot_consCnt"
    SORT_PROP_COMPUTE_POOLED_SLOT_ID_RELEASED_TIME = "compute_PooledSlot_idReleasedTime"
    SORT_PROP_COMPUTE_POOLED_SLOT_OWNER = "compute_PooledSlot_owner"
    SORT_PROP_COMPUTE_POOLED_SLOT_POOLABLE_DN = "compute_PooledSlot_poolableDn"
    SORT_PROP_COMPUTE_POOLED_SLOT_PREV_ASSIGNED_TO_DN = "compute_PooledSlot_prevAssignedToDn"
    SORT_PROP_COMPUTE_POOLED_SLOT_SLOT_ID = "compute_PooledSlot_slotId"
    SORT_PROP_COMPUTE_POOLED_SLOT_SYSTEM_ID = "compute_PooledSlot_systemId"
    SORT_PROP_COMPUTE_POOLED_ASSIGNED = "compute_Pooled_assigned"
    SORT_PROP_COMPUTE_POOLED_ASSIGNED_TO_DN = "compute_Pooled_assignedToDn"
    SORT_PROP_COMPUTE_POOLED_BLOCK_DN = "compute_Pooled_blockDn"
    SORT_PROP_COMPUTE_POOLED_CONS_CNT = "compute_Pooled_consCnt"
    SORT_PROP_COMPUTE_POOLED_ID_RELEASED_TIME = "compute_Pooled_idReleasedTime"
    SORT_PROP_COMPUTE_POOLED_OWNER = "compute_Pooled_owner"
    SORT_PROP_COMPUTE_POOLED_POOLABLE_DN = "compute_Pooled_poolableDn"
    SORT_PROP_COMPUTE_POOLED_PREV_ASSIGNED_TO_DN = "compute_Pooled_prevAssignedToDn"
    SORT_PROP_COMPUTE_POOLING_POLICY_DESCR = "compute_PoolingPolicy_descr"
    SORT_PROP_COMPUTE_POOLING_POLICY_INT_ID = "compute_PoolingPolicy_intId"
    SORT_PROP_COMPUTE_POOLING_POLICY_NAME = "compute_PoolingPolicy_name"
    SORT_PROP_COMPUTE_POOLING_POLICY_POLICY_LEVEL = "compute_PoolingPolicy_policyLevel"
    SORT_PROP_COMPUTE_POOLING_POLICY_POLICY_OWNER = "compute_PoolingPolicy_policyOwner"
    SORT_PROP_COMPUTE_POOLING_POLICY_POOL_DN = "compute_PoolingPolicy_poolDn"
    SORT_PROP_COMPUTE_POOLING_POLICY_QUALIFIER = "compute_PoolingPolicy_qualifier"
    SORT_PROP_COMPUTE_PORT_DISC_POLICY_DESCR = "compute_PortDiscPolicy_descr"
    SORT_PROP_COMPUTE_PORT_DISC_POLICY_ETH_BREAKOUT_AUTO_DISCOVERY = "compute_PortDiscPolicy_ethBreakoutAutoDiscovery"
    SORT_PROP_COMPUTE_PORT_DISC_POLICY_ETH_SVR_AUTO_DISCOVERY = "compute_PortDiscPolicy_ethSvrAutoDiscovery"
    SORT_PROP_COMPUTE_PORT_DISC_POLICY_INT_ID = "compute_PortDiscPolicy_intId"
    SORT_PROP_COMPUTE_PORT_DISC_POLICY_NAME = "compute_PortDiscPolicy_name"
    SORT_PROP_COMPUTE_PORT_DISC_POLICY_POLICY_LEVEL = "compute_PortDiscPolicy_policyLevel"
    SORT_PROP_COMPUTE_PORT_DISC_POLICY_POLICY_OWNER = "compute_PortDiscPolicy_policyOwner"
    SORT_PROP_COMPUTE_PORT_DISC_POLICY_QUALIFIER = "compute_PortDiscPolicy_qualifier"
    SORT_PROP_COMPUTE_POWER_SYNC_DEF_DESCR = "compute_PowerSyncDef_descr"
    SORT_PROP_COMPUTE_POWER_SYNC_DEF_INT_ID = "compute_PowerSyncDef_intId"
    SORT_PROP_COMPUTE_POWER_SYNC_DEF_NAME = "compute_PowerSyncDef_name"
    SORT_PROP_COMPUTE_POWER_SYNC_DEF_POLICY_LEVEL = "compute_PowerSyncDef_policyLevel"
    SORT_PROP_COMPUTE_POWER_SYNC_DEF_POLICY_OWNER = "compute_PowerSyncDef_policyOwner"
    SORT_PROP_COMPUTE_POWER_SYNC_DEF_SYNC_OPTION = "compute_PowerSyncDef_syncOption"
    SORT_PROP_COMPUTE_POWER_SYNC_POLICY_DESCR = "compute_PowerSyncPolicy_descr"
    SORT_PROP_COMPUTE_POWER_SYNC_POLICY_INT_ID = "compute_PowerSyncPolicy_intId"
    SORT_PROP_COMPUTE_POWER_SYNC_POLICY_NAME = "compute_PowerSyncPolicy_name"
    SORT_PROP_COMPUTE_POWER_SYNC_POLICY_POLICY_LEVEL = "compute_PowerSyncPolicy_policyLevel"
    SORT_PROP_COMPUTE_POWER_SYNC_POLICY_POLICY_OWNER = "compute_PowerSyncPolicy_policyOwner"
    SORT_PROP_COMPUTE_POWER_SYNC_POLICY_SYNC_OPTION = "compute_PowerSyncPolicy_syncOption"
    SORT_PROP_COMPUTE_PRODUCT_FAMILY_QUAL_PRODUCT_FAMILY = "compute_ProductFamilyQual_productFamily"
    SORT_PROP_COMPUTE_PROFILE_DESCR = "compute_Profile_descr"
    SORT_PROP_COMPUTE_PROFILE_INT_ID = "compute_Profile_intId"
    SORT_PROP_COMPUTE_PROFILE_NAME = "compute_Profile_name"
    SORT_PROP_COMPUTE_PROFILE_POLICY_LEVEL = "compute_Profile_policyLevel"
    SORT_PROP_COMPUTE_PROFILE_POLICY_OWNER = "compute_Profile_policyOwner"
    SORT_PROP_COMPUTE_PSU_DEF_DESCR = "compute_PsuDef_descr"
    SORT_PROP_COMPUTE_PSU_DEF_INT_ID = "compute_PsuDef_intId"
    SORT_PROP_COMPUTE_PSU_DEF_NAME = "compute_PsuDef_name"
    SORT_PROP_COMPUTE_PSU_DEF_POLICY_LEVEL = "compute_PsuDef_policyLevel"
    SORT_PROP_COMPUTE_PSU_DEF_POLICY_OWNER = "compute_PsuDef_policyOwner"
    SORT_PROP_COMPUTE_PSU_DEF_REDUNDANCY = "compute_PsuDef_redundancy"
    SORT_PROP_COMPUTE_PSU_POLICY_DESCR = "compute_PsuPolicy_descr"
    SORT_PROP_COMPUTE_PSU_POLICY_INT_ID = "compute_PsuPolicy_intId"
    SORT_PROP_COMPUTE_PSU_POLICY_NAME = "compute_PsuPolicy_name"
    SORT_PROP_COMPUTE_PSU_POLICY_POLICY_LEVEL = "compute_PsuPolicy_policyLevel"
    SORT_PROP_COMPUTE_PSU_POLICY_POLICY_OWNER = "compute_PsuPolicy_policyOwner"
    SORT_PROP_COMPUTE_PSU_POLICY_REDUNDANCY = "compute_PsuPolicy_redundancy"
    SORT_PROP_COMPUTE_QUAL_BASE_DESCR = "compute_QualBase_descr"
    SORT_PROP_COMPUTE_QUAL_BASE_INT_ID = "compute_QualBase_intId"
    SORT_PROP_COMPUTE_QUAL_BASE_NAME = "compute_QualBase_name"
    SORT_PROP_COMPUTE_QUAL_BASE_POLICY_LEVEL = "compute_QualBase_policyLevel"
    SORT_PROP_COMPUTE_QUAL_BASE_POLICY_OWNER = "compute_QualBase_policyOwner"
    SORT_PROP_COMPUTE_QUAL_DESCR = "compute_Qual_descr"
    SORT_PROP_COMPUTE_QUAL_INT_ID = "compute_Qual_intId"
    SORT_PROP_COMPUTE_QUAL_NAME = "compute_Qual_name"
    SORT_PROP_COMPUTE_QUAL_POLICY_LEVEL = "compute_Qual_policyLevel"
    SORT_PROP_COMPUTE_QUAL_POLICY_OWNER = "compute_Qual_policyOwner"
    SORT_PROP_COMPUTE_QUALIFIED_POLICY_DESCR = "compute_QualifiedPolicy_descr"
    SORT_PROP_COMPUTE_QUALIFIED_POLICY_INT_ID = "compute_QualifiedPolicy_intId"
    SORT_PROP_COMPUTE_QUALIFIED_POLICY_NAME = "compute_QualifiedPolicy_name"
    SORT_PROP_COMPUTE_QUALIFIED_POLICY_POLICY_LEVEL = "compute_QualifiedPolicy_policyLevel"
    SORT_PROP_COMPUTE_QUALIFIED_POLICY_POLICY_OWNER = "compute_QualifiedPolicy_policyOwner"
    SORT_PROP_COMPUTE_QUALIFIED_POLICY_QUALIFIER = "compute_QualifiedPolicy_qualifier"
    SORT_PROP_COMPUTE_RACK_POS_QUAL_MAX_ID = "compute_RackPosQual_maxId"
    SORT_PROP_COMPUTE_RACK_POS_QUAL_MIN_ID = "compute_RackPosQual_minId"
    SORT_PROP_COMPUTE_RACK_QUAL_MAX_ID = "compute_RackQual_maxId"
    SORT_PROP_COMPUTE_RACK_QUAL_MIN_ID = "compute_RackQual_minId"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_AMBIENT_TEMP = "compute_RackUnitMbTempStatsHist_ambientTemp"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_AMBIENT_TEMP_AVG = "compute_RackUnitMbTempStatsHist_ambientTempAvg"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_AMBIENT_TEMP_MAX = "compute_RackUnitMbTempStatsHist_ambientTempMax"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_AMBIENT_TEMP_MIN = "compute_RackUnitMbTempStatsHist_ambientTempMin"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_FRONT_TEMP = "compute_RackUnitMbTempStatsHist_frontTemp"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_FRONT_TEMP_AVG = "compute_RackUnitMbTempStatsHist_frontTempAvg"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_FRONT_TEMP_MAX = "compute_RackUnitMbTempStatsHist_frontTempMax"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_FRONT_TEMP_MIN = "compute_RackUnitMbTempStatsHist_frontTempMin"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_ID = "compute_RackUnitMbTempStatsHist_id"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH1_TEMP = "compute_RackUnitMbTempStatsHist_ioh1Temp"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH1_TEMP_AVG = "compute_RackUnitMbTempStatsHist_ioh1TempAvg"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH1_TEMP_MAX = "compute_RackUnitMbTempStatsHist_ioh1TempMax"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH1_TEMP_MIN = "compute_RackUnitMbTempStatsHist_ioh1TempMin"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH2_TEMP = "compute_RackUnitMbTempStatsHist_ioh2Temp"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH2_TEMP_AVG = "compute_RackUnitMbTempStatsHist_ioh2TempAvg"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH2_TEMP_MAX = "compute_RackUnitMbTempStatsHist_ioh2TempMax"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_IOH2_TEMP_MIN = "compute_RackUnitMbTempStatsHist_ioh2TempMin"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_MOST_RECENT = "compute_RackUnitMbTempStatsHist_mostRecent"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_REAR_TEMP = "compute_RackUnitMbTempStatsHist_rearTemp"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_REAR_TEMP_AVG = "compute_RackUnitMbTempStatsHist_rearTempAvg"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_REAR_TEMP_MAX = "compute_RackUnitMbTempStatsHist_rearTempMax"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_REAR_TEMP_MIN = "compute_RackUnitMbTempStatsHist_rearTempMin"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_SUSPECT = "compute_RackUnitMbTempStatsHist_suspect"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_THRESHOLDED = "compute_RackUnitMbTempStatsHist_thresholded"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_HIST_TIME_COLLECTED = "compute_RackUnitMbTempStatsHist_timeCollected"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_AMBIENT_TEMP = "compute_RackUnitMbTempStats_ambientTemp"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_AMBIENT_TEMP_AVG = "compute_RackUnitMbTempStats_ambientTempAvg"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_AMBIENT_TEMP_MAX = "compute_RackUnitMbTempStats_ambientTempMax"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_AMBIENT_TEMP_MIN = "compute_RackUnitMbTempStats_ambientTempMin"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_FRONT_TEMP = "compute_RackUnitMbTempStats_frontTemp"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_FRONT_TEMP_AVG = "compute_RackUnitMbTempStats_frontTempAvg"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_FRONT_TEMP_MAX = "compute_RackUnitMbTempStats_frontTempMax"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_FRONT_TEMP_MIN = "compute_RackUnitMbTempStats_frontTempMin"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_INTERVALS = "compute_RackUnitMbTempStats_intervals"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH1_TEMP = "compute_RackUnitMbTempStats_ioh1Temp"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH1_TEMP_AVG = "compute_RackUnitMbTempStats_ioh1TempAvg"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH1_TEMP_MAX = "compute_RackUnitMbTempStats_ioh1TempMax"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH1_TEMP_MIN = "compute_RackUnitMbTempStats_ioh1TempMin"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH2_TEMP = "compute_RackUnitMbTempStats_ioh2Temp"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH2_TEMP_AVG = "compute_RackUnitMbTempStats_ioh2TempAvg"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH2_TEMP_MAX = "compute_RackUnitMbTempStats_ioh2TempMax"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_IOH2_TEMP_MIN = "compute_RackUnitMbTempStats_ioh2TempMin"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_NORMALIZED_TIME_COL = "compute_RackUnitMbTempStats_normalizedTimeCol"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_REAR_TEMP = "compute_RackUnitMbTempStats_rearTemp"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_REAR_TEMP_AVG = "compute_RackUnitMbTempStats_rearTempAvg"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_REAR_TEMP_MAX = "compute_RackUnitMbTempStats_rearTempMax"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_REAR_TEMP_MIN = "compute_RackUnitMbTempStats_rearTempMin"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_STATS_REPORTED = "compute_RackUnitMbTempStats_statsReported"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_SUSPECT = "compute_RackUnitMbTempStats_suspect"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_THRESHOLDED = "compute_RackUnitMbTempStats_thresholded"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_TIME_COLLECTED = "compute_RackUnitMbTempStats_timeCollected"
    SORT_PROP_COMPUTE_RACK_UNIT_MB_TEMP_STATS_UPDATE = "compute_RackUnitMbTempStats_update"
    SORT_PROP_COMPUTE_RACK_UNIT_ADMIN_POWER = "compute_RackUnit_adminPower"
    SORT_PROP_COMPUTE_RACK_UNIT_ADMIN_STATE = "compute_RackUnit_adminState"
    SORT_PROP_COMPUTE_RACK_UNIT_ASSET_TAG = "compute_RackUnit_assetTag"
    SORT_PROP_COMPUTE_RACK_UNIT_ASSIGNED_TO_DN = "compute_RackUnit_assignedToDn"
    SORT_PROP_COMPUTE_RACK_UNIT_ASSOCIATION = "compute_RackUnit_association"
    SORT_PROP_COMPUTE_RACK_UNIT_AVAILABILITY = "compute_RackUnit_availability"
    SORT_PROP_COMPUTE_RACK_UNIT_AVAILABLE_MEMORY = "compute_RackUnit_availableMemory"
    SORT_PROP_COMPUTE_RACK_UNIT_CHECK_POINT = "compute_RackUnit_checkPoint"
    SORT_PROP_COMPUTE_RACK_UNIT_CONN_PATH = "compute_RackUnit_connPath"
    SORT_PROP_COMPUTE_RACK_UNIT_CONN_STATUS = "compute_RackUnit_connStatus"
    SORT_PROP_COMPUTE_RACK_UNIT_DESCR = "compute_RackUnit_descr"
    SORT_PROP_COMPUTE_RACK_UNIT_DISCOVERY = "compute_RackUnit_discovery"
    SORT_PROP_COMPUTE_RACK_UNIT_DISCOVERY_STATUS = "compute_RackUnit_discoveryStatus"
    SORT_PROP_COMPUTE_RACK_UNIT_FLT_AGGR = "compute_RackUnit_fltAggr"
    SORT_PROP_COMPUTE_RACK_UNIT_ID = "compute_RackUnit_id"
    SORT_PROP_COMPUTE_RACK_UNIT_INT_ID = "compute_RackUnit_intId"
    SORT_PROP_COMPUTE_RACK_UNIT_KMIP_FAULT = "compute_RackUnit_kmipFault"
    SORT_PROP_COMPUTE_RACK_UNIT_KMIP_FAULT_DESCRIPTION = "compute_RackUnit_kmipFaultDescription"
    SORT_PROP_COMPUTE_RACK_UNIT_LC = "compute_RackUnit_lc"
    SORT_PROP_COMPUTE_RACK_UNIT_LC_TS = "compute_RackUnit_lcTs"
    SORT_PROP_COMPUTE_RACK_UNIT_LOCAL_ID = "compute_RackUnit_localId"
    SORT_PROP_COMPUTE_RACK_UNIT_LOW_VOLTAGE_MEMORY = "compute_RackUnit_lowVoltageMemory"
    SORT_PROP_COMPUTE_RACK_UNIT_LS_DN = "compute_RackUnit_lsDn"
    SORT_PROP_COMPUTE_RACK_UNIT_MANAGING_INST = "compute_RackUnit_managingInst"
    SORT_PROP_COMPUTE_RACK_UNIT_MEMORY_SPEED = "compute_RackUnit_memorySpeed"
    SORT_PROP_COMPUTE_RACK_UNIT_MFG_TIME = "compute_RackUnit_mfgTime"
    SORT_PROP_COMPUTE_RACK_UNIT_MODEL = "compute_RackUnit_model"
    SORT_PROP_COMPUTE_RACK_UNIT_NAME = "compute_RackUnit_name"
    SORT_PROP_COMPUTE_RACK_UNIT_NUM_OF40_GADAPTORS_WITH_OLD_FW = "compute_RackUnit_numOf40GAdaptorsWithOldFw"
    SORT_PROP_COMPUTE_RACK_UNIT_NUM_OF40_GADAPTORS_WITH_UNKNOWN_FW = "compute_RackUnit_numOf40GAdaptorsWithUnknownFw"
    SORT_PROP_COMPUTE_RACK_UNIT_NUM_OF_ADAPTORS = "compute_RackUnit_numOfAdaptors"
    SORT_PROP_COMPUTE_RACK_UNIT_NUM_OF_CORES = "compute_RackUnit_numOfCores"
    SORT_PROP_COMPUTE_RACK_UNIT_NUM_OF_CORES_ENABLED = "compute_RackUnit_numOfCoresEnabled"
    SORT_PROP_COMPUTE_RACK_UNIT_NUM_OF_CPUS = "compute_RackUnit_numOfCpus"
    SORT_PROP_COMPUTE_RACK_UNIT_NUM_OF_ETH_HOST_IFS = "compute_RackUnit_numOfEthHostIfs"
    SORT_PROP_COMPUTE_RACK_UNIT_NUM_OF_FC_HOST_IFS = "compute_RackUnit_numOfFcHostIfs"
    SORT_PROP_COMPUTE_RACK_UNIT_NUM_OF_THREADS = "compute_RackUnit_numOfThreads"
    SORT_PROP_COMPUTE_RACK_UNIT_OPER_POWER = "compute_RackUnit_operPower"
    SORT_PROP_COMPUTE_RACK_UNIT_OPER_PWR_TRANS_SRC = "compute_RackUnit_operPwrTransSrc"
    SORT_PROP_COMPUTE_RACK_UNIT_OPER_QUALIFIER = "compute_RackUnit_operQualifier"
    SORT_PROP_COMPUTE_RACK_UNIT_OPER_STATE = "compute_RackUnit_operState"
    SORT_PROP_COMPUTE_RACK_UNIT_OPERABILITY = "compute_RackUnit_operability"
    SORT_PROP_COMPUTE_RACK_UNIT_ORIGINAL_UUID = "compute_RackUnit_originalUuid"
    SORT_PROP_COMPUTE_RACK_UNIT_PART_NUMBER = "compute_RackUnit_partNumber"
    SORT_PROP_COMPUTE_RACK_UNIT_POLICY_LEVEL = "compute_RackUnit_policyLevel"
    SORT_PROP_COMPUTE_RACK_UNIT_POLICY_OWNER = "compute_RackUnit_policyOwner"
    SORT_PROP_COMPUTE_RACK_UNIT_PRESENCE = "compute_RackUnit_presence"
    SORT_PROP_COMPUTE_RACK_UNIT_REVISION = "compute_RackUnit_revision"
    SORT_PROP_COMPUTE_RACK_UNIT_SERIAL = "compute_RackUnit_serial"
    SORT_PROP_COMPUTE_RACK_UNIT_SERVER_ID = "compute_RackUnit_serverId"
    SORT_PROP_COMPUTE_RACK_UNIT_TOTAL_MEMORY = "compute_RackUnit_totalMemory"
    SORT_PROP_COMPUTE_RACK_UNIT_USR_LBL = "compute_RackUnit_usrLbl"
    SORT_PROP_COMPUTE_RACK_UNIT_UUID = "compute_RackUnit_uuid"
    SORT_PROP_COMPUTE_RACK_UNIT_VENDOR = "compute_RackUnit_vendor"
    SORT_PROP_COMPUTE_RACK_UNIT_VID = "compute_RackUnit_vid"
    SORT_PROP_COMPUTE_REBOOT_LOG_COUNT = "compute_RebootLog_count"
    SORT_PROP_COMPUTE_REBOOT_LOG_ID = "compute_RebootLog_id"
    SORT_PROP_COMPUTE_REBOOT_LOG_PWR_CHANGE_SRC = "compute_RebootLog_pwrChangeSrc"
    SORT_PROP_COMPUTE_REBOOT_LOG_TIME_STAMP = "compute_RebootLog_timeStamp"
    SORT_PROP_COMPUTE_REMOTE_OP_STATUS_DESCR = "compute_RemoteOpStatus_descr"
    SORT_PROP_COMPUTE_REMOTE_OP_STATUS_OP_STATUS = "compute_RemoteOpStatus_opStatus"
    SORT_PROP_COMPUTE_REMOTE_OP_STATUS_OP_TYPE = "compute_RemoteOpStatus_opType"
    SORT_PROP_COMPUTE_REQUIREMENT_DESCR = "compute_Requirement_descr"
    SORT_PROP_COMPUTE_REQUIREMENT_INSTANTIATION_STATE = "compute_Requirement_instantiationState"
    SORT_PROP_COMPUTE_REQUIREMENT_INT_ID = "compute_Requirement_intId"
    SORT_PROP_COMPUTE_REQUIREMENT_LOCAL_PLACEMENT_REF_CNT = "compute_Requirement_localPlacementRefCnt"
    SORT_PROP_COMPUTE_REQUIREMENT_NAME = "compute_Requirement_name"
    SORT_PROP_COMPUTE_REQUIREMENT_OPER_STATE = "compute_Requirement_operState"
    SORT_PROP_COMPUTE_REQUIREMENT_PLACEMENT_REF_CNT = "compute_Requirement_placementRefCnt"
    SORT_PROP_COMPUTE_REQUIREMENT_POLICY_LEVEL = "compute_Requirement_policyLevel"
    SORT_PROP_COMPUTE_REQUIREMENT_POLICY_OWNER = "compute_Requirement_policyOwner"
    SORT_PROP_COMPUTE_RESOURCE_AGGR_EP_AVAILABLE_PHYSICAL_CNT = "compute_ResourceAggrEp_availablePhysicalCnt"
    SORT_PROP_COMPUTE_RESOURCE_AGGR_EP_POLLING_INTERVAL = "compute_ResourceAggrEp_pollingInterval"
    SORT_PROP_COMPUTE_RESOURCE_AGGR_EP_TOTAL_PHYSICAL_CNT = "compute_ResourceAggrEp_totalPhysicalCnt"
    SORT_PROP_COMPUTE_RESOURCE_SET_MANAGER_CURRENT_SET_IN_POLLING = "compute_ResourceSetManager_currentSetInPolling"
    SORT_PROP_COMPUTE_RESOURCE_SET_MANAGER_POLLING_STATE = "compute_ResourceSetManager_pollingState"
    SORT_PROP_COMPUTE_RESOURCE_SET_MEMBER_ID = "compute_ResourceSetMember_id"
    SORT_PROP_COMPUTE_RESOURCE_SET_MEMBER_OPER_STATE = "compute_ResourceSetMember_operState"
    SORT_PROP_COMPUTE_RESOURCE_SET_ID = "compute_ResourceSet_id"
    SORT_PROP_COMPUTE_RESOURCE_SET_LAST_POLLED_TS = "compute_ResourceSet_lastPolledTs"
    SORT_PROP_COMPUTE_RESOURCE_SET_STATE = "compute_ResourceSet_state"
    SORT_PROP_COMPUTE_SCRUB_POLICY_BIOS_SETTINGS_SCRUB = "compute_ScrubPolicy_biosSettingsScrub"
    SORT_PROP_COMPUTE_SCRUB_POLICY_DESCR = "compute_ScrubPolicy_descr"
    SORT_PROP_COMPUTE_SCRUB_POLICY_DISK_SCRUB = "compute_ScrubPolicy_diskScrub"
    SORT_PROP_COMPUTE_SCRUB_POLICY_FLEX_FLASH_SCRUB = "compute_ScrubPolicy_flexFlashScrub"
    SORT_PROP_COMPUTE_SCRUB_POLICY_INT_ID = "compute_ScrubPolicy_intId"
    SORT_PROP_COMPUTE_SCRUB_POLICY_NAME = "compute_ScrubPolicy_name"
    SORT_PROP_COMPUTE_SCRUB_POLICY_POLICY_LEVEL = "compute_ScrubPolicy_policyLevel"
    SORT_PROP_COMPUTE_SCRUB_POLICY_POLICY_OWNER = "compute_ScrubPolicy_policyOwner"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_ACTION = "compute_ServerDiscPolicy_action"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_DESCR = "compute_ServerDiscPolicy_descr"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_INT_ID = "compute_ServerDiscPolicy_intId"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_NAME = "compute_ServerDiscPolicy_name"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_POLICY_LEVEL = "compute_ServerDiscPolicy_policyLevel"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_POLICY_OWNER = "compute_ServerDiscPolicy_policyOwner"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_QUALIFIER = "compute_ServerDiscPolicy_qualifier"
    SORT_PROP_COMPUTE_SERVER_DISC_POLICY_SCRUB_POLICY_NAME = "compute_ServerDiscPolicy_scrubPolicyName"
    SORT_PROP_COMPUTE_SERVER_FEAT_MASK_FEAT_MASK = "compute_ServerFeatMask_featMask"
    SORT_PROP_COMPUTE_SERVER_MGMT_POLICY_ACTION = "compute_ServerMgmtPolicy_action"
    SORT_PROP_COMPUTE_SERVER_MGMT_POLICY_DESCR = "compute_ServerMgmtPolicy_descr"
    SORT_PROP_COMPUTE_SERVER_MGMT_POLICY_INT_ID = "compute_ServerMgmtPolicy_intId"
    SORT_PROP_COMPUTE_SERVER_MGMT_POLICY_NAME = "compute_ServerMgmtPolicy_name"
    SORT_PROP_COMPUTE_SERVER_MGMT_POLICY_POLICY_LEVEL = "compute_ServerMgmtPolicy_policyLevel"
    SORT_PROP_COMPUTE_SERVER_MGMT_POLICY_POLICY_OWNER = "compute_ServerMgmtPolicy_policyOwner"
    SORT_PROP_COMPUTE_SERVER_MGMT_POLICY_QUALIFIER = "compute_ServerMgmtPolicy_qualifier"
    SORT_PROP_COMPUTE_SERVER_UNIT_ADMIN_POWER = "compute_ServerUnit_adminPower"
    SORT_PROP_COMPUTE_SERVER_UNIT_ADMIN_STATE = "compute_ServerUnit_adminState"
    SORT_PROP_COMPUTE_SERVER_UNIT_ASSET_TAG = "compute_ServerUnit_assetTag"
    SORT_PROP_COMPUTE_SERVER_UNIT_ASSIGNED_TO_DN = "compute_ServerUnit_assignedToDn"
    SORT_PROP_COMPUTE_SERVER_UNIT_ASSOCIATION = "compute_ServerUnit_association"
    SORT_PROP_COMPUTE_SERVER_UNIT_AVAILABILITY = "compute_ServerUnit_availability"
    SORT_PROP_COMPUTE_SERVER_UNIT_AVAILABLE_MEMORY = "compute_ServerUnit_availableMemory"
    SORT_PROP_COMPUTE_SERVER_UNIT_CHASSIS_ID = "compute_ServerUnit_chassisId"
    SORT_PROP_COMPUTE_SERVER_UNIT_CHECK_POINT = "compute_ServerUnit_checkPoint"
    SORT_PROP_COMPUTE_SERVER_UNIT_CONN_PATH = "compute_ServerUnit_connPath"
    SORT_PROP_COMPUTE_SERVER_UNIT_CONN_STATUS = "compute_ServerUnit_connStatus"
    SORT_PROP_COMPUTE_SERVER_UNIT_DESCR = "compute_ServerUnit_descr"
    SORT_PROP_COMPUTE_SERVER_UNIT_DISCOVERY = "compute_ServerUnit_discovery"
    SORT_PROP_COMPUTE_SERVER_UNIT_DISCOVERY_STATUS = "compute_ServerUnit_discoveryStatus"
    SORT_PROP_COMPUTE_SERVER_UNIT_FLT_AGGR = "compute_ServerUnit_fltAggr"
    SORT_PROP_COMPUTE_SERVER_UNIT_INT_ID = "compute_ServerUnit_intId"
    SORT_PROP_COMPUTE_SERVER_UNIT_KMIP_FAULT = "compute_ServerUnit_kmipFault"
    SORT_PROP_COMPUTE_SERVER_UNIT_KMIP_FAULT_DESCRIPTION = "compute_ServerUnit_kmipFaultDescription"
    SORT_PROP_COMPUTE_SERVER_UNIT_LC = "compute_ServerUnit_lc"
    SORT_PROP_COMPUTE_SERVER_UNIT_LC_TS = "compute_ServerUnit_lcTs"
    SORT_PROP_COMPUTE_SERVER_UNIT_LOCAL_ID = "compute_ServerUnit_localId"
    SORT_PROP_COMPUTE_SERVER_UNIT_LOW_VOLTAGE_MEMORY = "compute_ServerUnit_lowVoltageMemory"
    SORT_PROP_COMPUTE_SERVER_UNIT_LS_DN = "compute_ServerUnit_lsDn"
    SORT_PROP_COMPUTE_SERVER_UNIT_MANAGING_INST = "compute_ServerUnit_managingInst"
    SORT_PROP_COMPUTE_SERVER_UNIT_MEMORY_SPEED = "compute_ServerUnit_memorySpeed"
    SORT_PROP_COMPUTE_SERVER_UNIT_MFG_TIME = "compute_ServerUnit_mfgTime"
    SORT_PROP_COMPUTE_SERVER_UNIT_MODEL = "compute_ServerUnit_model"
    SORT_PROP_COMPUTE_SERVER_UNIT_NAME = "compute_ServerUnit_name"
    SORT_PROP_COMPUTE_SERVER_UNIT_NUM_OF40_GADAPTORS_WITH_OLD_FW = "compute_ServerUnit_numOf40GAdaptorsWithOldFw"
    SORT_PROP_COMPUTE_SERVER_UNIT_NUM_OF40_GADAPTORS_WITH_UNKNOWN_FW = "compute_ServerUnit_numOf40GAdaptorsWithUnknownFw"
    SORT_PROP_COMPUTE_SERVER_UNIT_NUM_OF_ADAPTORS = "compute_ServerUnit_numOfAdaptors"
    SORT_PROP_COMPUTE_SERVER_UNIT_NUM_OF_CORES = "compute_ServerUnit_numOfCores"
    SORT_PROP_COMPUTE_SERVER_UNIT_NUM_OF_CORES_ENABLED = "compute_ServerUnit_numOfCoresEnabled"
    SORT_PROP_COMPUTE_SERVER_UNIT_NUM_OF_CPUS = "compute_ServerUnit_numOfCpus"
    SORT_PROP_COMPUTE_SERVER_UNIT_NUM_OF_ETH_HOST_IFS = "compute_ServerUnit_numOfEthHostIfs"
    SORT_PROP_COMPUTE_SERVER_UNIT_NUM_OF_FC_HOST_IFS = "compute_ServerUnit_numOfFcHostIfs"
    SORT_PROP_COMPUTE_SERVER_UNIT_NUM_OF_THREADS = "compute_ServerUnit_numOfThreads"
    SORT_PROP_COMPUTE_SERVER_UNIT_OPER_POWER = "compute_ServerUnit_operPower"
    SORT_PROP_COMPUTE_SERVER_UNIT_OPER_PWR_TRANS_SRC = "compute_ServerUnit_operPwrTransSrc"
    SORT_PROP_COMPUTE_SERVER_UNIT_OPER_QUALIFIER = "compute_ServerUnit_operQualifier"
    SORT_PROP_COMPUTE_SERVER_UNIT_OPER_STATE = "compute_ServerUnit_operState"
    SORT_PROP_COMPUTE_SERVER_UNIT_OPERABILITY = "compute_ServerUnit_operability"
    SORT_PROP_COMPUTE_SERVER_UNIT_ORIGINAL_UUID = "compute_ServerUnit_originalUuid"
    SORT_PROP_COMPUTE_SERVER_UNIT_PART_NUMBER = "compute_ServerUnit_partNumber"
    SORT_PROP_COMPUTE_SERVER_UNIT_POLICY_LEVEL = "compute_ServerUnit_policyLevel"
    SORT_PROP_COMPUTE_SERVER_UNIT_POLICY_OWNER = "compute_ServerUnit_policyOwner"
    SORT_PROP_COMPUTE_SERVER_UNIT_PRESENCE = "compute_ServerUnit_presence"
    SORT_PROP_COMPUTE_SERVER_UNIT_REVISION = "compute_ServerUnit_revision"
    SORT_PROP_COMPUTE_SERVER_UNIT_SERIAL = "compute_ServerUnit_serial"
    SORT_PROP_COMPUTE_SERVER_UNIT_SERVER_ID = "compute_ServerUnit_serverId"
    SORT_PROP_COMPUTE_SERVER_UNIT_SERVER_INSTANCE_ID = "compute_ServerUnit_serverInstanceId"
    SORT_PROP_COMPUTE_SERVER_UNIT_SLOT_ID = "compute_ServerUnit_slotId"
    SORT_PROP_COMPUTE_SERVER_UNIT_TOTAL_MEMORY = "compute_ServerUnit_totalMemory"
    SORT_PROP_COMPUTE_SERVER_UNIT_USR_LBL = "compute_ServerUnit_usrLbl"
    SORT_PROP_COMPUTE_SERVER_UNIT_UUID = "compute_ServerUnit_uuid"
    SORT_PROP_COMPUTE_SERVER_UNIT_VENDOR = "compute_ServerUnit_vendor"
    SORT_PROP_COMPUTE_SERVER_UNIT_VID = "compute_ServerUnit_vid"
    SORT_PROP_COMPUTE_SERVER_ASSIGN_STATE = "compute_Server_assignState"
    SORT_PROP_COMPUTE_SERVER_ASSOC_STATE = "compute_Server_assocState"
    SORT_PROP_COMPUTE_SERVER_DESCR = "compute_Server_descr"
    SORT_PROP_COMPUTE_SERVER_INT_ID = "compute_Server_intId"
    SORT_PROP_COMPUTE_SERVER_LS_DN = "compute_Server_lsDn"
    SORT_PROP_COMPUTE_SERVER_NAME = "compute_Server_name"
    SORT_PROP_COMPUTE_SERVER_PN_DN = "compute_Server_pnDn"
    SORT_PROP_COMPUTE_SERVER_POLICY_LEVEL = "compute_Server_policyLevel"
    SORT_PROP_COMPUTE_SERVER_POLICY_OWNER = "compute_Server_policyOwner"
    SORT_PROP_COMPUTE_SERVER_UUID = "compute_Server_uuid"
    SORT_PROP_COMPUTE_SESSION_COOKIE = "compute_Session_cookie"
    SORT_PROP_COMPUTE_SESSION_SYSTEM_NAME = "compute_Session_systemName"
    SORT_PROP_COMPUTE_SITE_QUAL_NAME = "compute_SiteQual_name"
    SORT_PROP_COMPUTE_SITE_QUAL_REGEX = "compute_SiteQual_regex"
    SORT_PROP_COMPUTE_SLOT_ENTITY_ID = "compute_SlotEntity_id"
    SORT_PROP_COMPUTE_SLOT_ENTITY_MODEL = "compute_SlotEntity_model"
    SORT_PROP_COMPUTE_SLOT_ENTITY_OPER_QUALIFIER_REASON = "compute_SlotEntity_operQualifierReason"
    SORT_PROP_COMPUTE_SLOT_ENTITY_OPER_STATE = "compute_SlotEntity_operState"
    SORT_PROP_COMPUTE_SLOT_ENTITY_OPERABILITY = "compute_SlotEntity_operability"
    SORT_PROP_COMPUTE_SLOT_ENTITY_PERF = "compute_SlotEntity_perf"
    SORT_PROP_COMPUTE_SLOT_ENTITY_POWER = "compute_SlotEntity_power"
    SORT_PROP_COMPUTE_SLOT_ENTITY_PRESENCE = "compute_SlotEntity_presence"
    SORT_PROP_COMPUTE_SLOT_ENTITY_REVISION = "compute_SlotEntity_revision"
    SORT_PROP_COMPUTE_SLOT_ENTITY_SERIAL = "compute_SlotEntity_serial"
    SORT_PROP_COMPUTE_SLOT_ENTITY_THERMAL = "compute_SlotEntity_thermal"
    SORT_PROP_COMPUTE_SLOT_ENTITY_VENDOR = "compute_SlotEntity_vendor"
    SORT_PROP_COMPUTE_SLOT_ENTITY_VOLTAGE = "compute_SlotEntity_voltage"
    SORT_PROP_COMPUTE_SLOT_QUAL_MAX_ID = "compute_SlotQual_maxId"
    SORT_PROP_COMPUTE_SLOT_QUAL_MIN_ID = "compute_SlotQual_minId"
    SORT_PROP_COMPUTE_STORAGE_FEAT_MASK_FEAT_MASK = "compute_StorageFeatMask_featMask"
    SORT_PROP_COMPUTE_SYSTEM_ADDR_QUAL_MAX_ADDR = "compute_SystemAddrQual_maxAddr"
    SORT_PROP_COMPUTE_SYSTEM_ADDR_QUAL_MIN_ADDR = "compute_SystemAddrQual_minAddr"
    SORT_PROP_COMPUTE_SYSTEM_FSM_STAGE_DESCR = "compute_SystemFsmStage_descr"
    SORT_PROP_COMPUTE_SYSTEM_FSM_STAGE_LAST_UPDATE_TIME = "compute_SystemFsmStage_lastUpdateTime"
    SORT_PROP_COMPUTE_SYSTEM_FSM_STAGE_NAME = "compute_SystemFsmStage_name"
    SORT_PROP_COMPUTE_SYSTEM_FSM_STAGE_ORDER = "compute_SystemFsmStage_order"
    SORT_PROP_COMPUTE_SYSTEM_FSM_STAGE_RETRY = "compute_SystemFsmStage_retry"
    SORT_PROP_COMPUTE_SYSTEM_FSM_STAGE_STAGE_STATUS = "compute_SystemFsmStage_stageStatus"
    SORT_PROP_COMPUTE_SYSTEM_FSM_TASK_COMPLETION = "compute_SystemFsmTask_completion"
    SORT_PROP_COMPUTE_SYSTEM_FSM_TASK_FLAGS = "compute_SystemFsmTask_flags"
    SORT_PROP_COMPUTE_SYSTEM_FSM_TASK_ITEM = "compute_SystemFsmTask_item"
    SORT_PROP_COMPUTE_SYSTEM_FSM_TASK_SEQ_ID = "compute_SystemFsmTask_seqId"
    SORT_PROP_COMPUTE_SYSTEM_FSM_COMPLETION_TIME = "compute_SystemFsm_completionTime"
    SORT_PROP_COMPUTE_SYSTEM_FSM_CURRENT_FSM = "compute_SystemFsm_currentFsm"
    SORT_PROP_COMPUTE_SYSTEM_FSM_DESCR = "compute_SystemFsm_descr"
    SORT_PROP_COMPUTE_SYSTEM_FSM_FSM_INSTANCE_ID = "compute_SystemFsm_fsmInstanceId"
    SORT_PROP_COMPUTE_SYSTEM_FSM_FSM_STATUS = "compute_SystemFsm_fsmStatus"
    SORT_PROP_COMPUTE_SYSTEM_FSM_PROGRESS = "compute_SystemFsm_progress"
    SORT_PROP_COMPUTE_SYSTEM_FSM_RMT_ERR_CODE = "compute_SystemFsm_rmtErrCode"
    SORT_PROP_COMPUTE_SYSTEM_FSM_RMT_ERR_DESCR = "compute_SystemFsm_rmtErrDescr"
    SORT_PROP_COMPUTE_SYSTEM_FSM_RMT_RSLT = "compute_SystemFsm_rmtRslt"
    SORT_PROP_COMPUTE_SYSTEM_QUAL_DESCR = "compute_SystemQual_descr"
    SORT_PROP_COMPUTE_SYSTEM_QUAL_INT_ID = "compute_SystemQual_intId"
    SORT_PROP_COMPUTE_SYSTEM_QUAL_NAME = "compute_SystemQual_name"
    SORT_PROP_COMPUTE_SYSTEM_QUAL_POLICY_LEVEL = "compute_SystemQual_policyLevel"
    SORT_PROP_COMPUTE_SYSTEM_QUAL_POLICY_OWNER = "compute_SystemQual_policyOwner"
    SORT_PROP_COMPUTE_SYSTEM_ADDRESS = "compute_System_address"
    SORT_PROP_COMPUTE_SYSTEM_AVAILABLE_PHYSICAL_CNT = "compute_System_availablePhysicalCnt"
    SORT_PROP_COMPUTE_SYSTEM_DESCR = "compute_System_descr"
    SORT_PROP_COMPUTE_SYSTEM_FLT_AGGR = "compute_System_fltAggr"
    SORT_PROP_COMPUTE_SYSTEM_FSM_DESCR = "compute_System_fsmDescr"
    SORT_PROP_COMPUTE_SYSTEM_FSM_PREV = "compute_System_fsmPrev"
    SORT_PROP_COMPUTE_SYSTEM_FSM_PROGR = "compute_System_fsmProgr"
    SORT_PROP_COMPUTE_SYSTEM_FSM_RMT_INV_ERR_CODE = "compute_System_fsmRmtInvErrCode"
    SORT_PROP_COMPUTE_SYSTEM_FSM_RMT_INV_ERR_DESCR = "compute_System_fsmRmtInvErrDescr"
    SORT_PROP_COMPUTE_SYSTEM_FSM_RMT_INV_RSLT = "compute_System_fsmRmtInvRslt"
    SORT_PROP_COMPUTE_SYSTEM_FSM_STAGE_DESCR = "compute_System_fsmStageDescr"
    SORT_PROP_COMPUTE_SYSTEM_FSM_STAMP = "compute_System_fsmStamp"
    SORT_PROP_COMPUTE_SYSTEM_FSM_STATUS = "compute_System_fsmStatus"
    SORT_PROP_COMPUTE_SYSTEM_FSM_TRY = "compute_System_fsmTry"
    SORT_PROP_COMPUTE_SYSTEM_FW_OPER_STATE = "compute_System_fwOperState"
    SORT_PROP_COMPUTE_SYSTEM_FW_PACK_NAME = "compute_System_fwPackName"
    SORT_PROP_COMPUTE_SYSTEM_FW_PACKAGE_VERSION = "compute_System_fwPackageVersion"
    SORT_PROP_COMPUTE_SYSTEM_FW_SERVICE_PACK_VERSION = "compute_System_fwServicePackVersion"
    SORT_PROP_COMPUTE_SYSTEM_ID = "compute_System_id"
    SORT_PROP_COMPUTE_SYSTEM_INVENTORY_STATUS = "compute_System_inventoryStatus"
    SORT_PROP_COMPUTE_SYSTEM_LAST_REFRESHED_TS = "compute_System_lastRefreshedTs"
    SORT_PROP_COMPUTE_SYSTEM_LAST_SUBSCRIBED_TS = "compute_System_lastSubscribedTs"
    SORT_PROP_COMPUTE_SYSTEM_NAME = "compute_System_name"
    SORT_PROP_COMPUTE_SYSTEM_OPER_GROUP_DN = "compute_System_operGroupDn"
    SORT_PROP_COMPUTE_SYSTEM_OWNER = "compute_System_owner"
    SORT_PROP_COMPUTE_SYSTEM_PRODUCT_FAMILY = "compute_System_productFamily"
    SORT_PROP_COMPUTE_SYSTEM_REFRESH_IMMEDIATE_FLAG = "compute_System_refreshImmediateFlag"
    SORT_PROP_COMPUTE_SYSTEM_REMOTE_FLT_AGGR = "compute_System_remoteFltAggr"
    SORT_PROP_COMPUTE_SYSTEM_SITE = "compute_System_site"
    SORT_PROP_COMPUTE_SYSTEM_SUBSCRIBE_STATUS = "compute_System_subscribeStatus"
    SORT_PROP_COMPUTE_SYSTEM_SYNC_INVENTORY_FROM_SM = "compute_System_syncInventoryFromSM"
    SORT_PROP_COMPUTE_SYSTEM_TOTAL_PHYSICAL_CNT = "compute_System_totalPhysicalCnt"
    SORT_PROP_COMPUTE_TEMPLATE_MAPPING_DESCR = "compute_TemplateMapping_descr"
    SORT_PROP_COMPUTE_TEMPLATE_MAPPING_INT_ID = "compute_TemplateMapping_intId"
    SORT_PROP_COMPUTE_TEMPLATE_MAPPING_LS_DN = "compute_TemplateMapping_lsDn"
    SORT_PROP_COMPUTE_TEMPLATE_MAPPING_NAME = "compute_TemplateMapping_name"
    SORT_PROP_COMPUTE_TEMPLATE_MAPPING_POLICY_LEVEL = "compute_TemplateMapping_policyLevel"
    SORT_PROP_COMPUTE_TEMPLATE_MAPPING_POLICY_OWNER = "compute_TemplateMapping_policyOwner"
    SORT_PROP_COMPUTE_TEMPLATE_MAPPING_TEMPL_DN = "compute_TemplateMapping_templDn"
    SORT_PROP_COMPUTE_TEMPLATE_DESCR = "compute_Template_descr"
    SORT_PROP_COMPUTE_TEMPLATE_INSTANTIATION_STATE = "compute_Template_instantiationState"
    SORT_PROP_COMPUTE_TEMPLATE_INT_ID = "compute_Template_intId"
    SORT_PROP_COMPUTE_TEMPLATE_NAME = "compute_Template_name"
    SORT_PROP_COMPUTE_TEMPLATE_PLACEMENT_REF_CNT = "compute_Template_placementRefCnt"
    SORT_PROP_COMPUTE_TEMPLATE_POLICY_LEVEL = "compute_Template_policyLevel"
    SORT_PROP_COMPUTE_TEMPLATE_POLICY_OWNER = "compute_Template_policyOwner"
    SORT_PROP_COMPUTE_USER_EP_DESCR = "compute_UserEp_descr"
    SORT_PROP_COMPUTE_USER_EP_INT_ID = "compute_UserEp_intId"
    SORT_PROP_COMPUTE_USER_EP_NAME = "compute_UserEp_name"
    SORT_PROP_COMPUTE_USER_EP_POLICY_LEVEL = "compute_UserEp_policyLevel"
    SORT_PROP_COMPUTE_USER_EP_POLICY_OWNER = "compute_UserEp_policyOwner"
    SORT_PROP_COMPUTE_USER_EP_PROFILE_DN = "compute_UserEp_profileDn"
    SORT_PROP_COMPUTE_USER_DESCR = "compute_User_descr"
    SORT_PROP_COMPUTE_USER_INT_ID = "compute_User_intId"
    SORT_PROP_COMPUTE_USER_NAME = "compute_User_name"
    SORT_PROP_COMPUTE_USER_POLICY_LEVEL = "compute_User_policyLevel"
    SORT_PROP_COMPUTE_USER_POLICY_OWNER = "compute_User_policyOwner"
    SORT_PROP_COMPUTE_USER_PWD = "compute_User_pwd"
    SORT_PROP_CONDITION_IMMUTABLE_CAUSE = "condition_Immutable_cause"
    SORT_PROP_CONDITION_IMMUTABLE_CHANGE_SET = "condition_Immutable_changeSet"
    SORT_PROP_CONDITION_IMMUTABLE_CODE = "condition_Immutable_code"
    SORT_PROP_CONDITION_IMMUTABLE_CREATED = "condition_Immutable_created"
    SORT_PROP_CONDITION_IMMUTABLE_DESCR = "condition_Immutable_descr"
    SORT_PROP_CONDITION_IMMUTABLE_ID = "condition_Immutable_id"
    SORT_PROP_CONDITION_IMMUTABLE_RULE = "condition_Immutable_rule"
    SORT_PROP_CONDITION_IMMUTABLE_SEVERITY = "condition_Immutable_severity"
    SORT_PROP_CONDITION_IMMUTABLE_SRC_DME = "condition_Immutable_srcDme"
    SORT_PROP_CONDITION_IMMUTABLE_TAGS = "condition_Immutable_tags"
    SORT_PROP_CONDITION_IMMUTABLE_TYPE = "condition_Immutable_type"
    SORT_PROP_CONDITION_INFO_CAUSE = "condition_Info_cause"
    SORT_PROP_CONDITION_INFO_CHANGE_SET = "condition_Info_changeSet"
    SORT_PROP_CONDITION_INFO_CODE = "condition_Info_code"
    SORT_PROP_CONDITION_INFO_CREATED = "condition_Info_created"
    SORT_PROP_CONDITION_INFO_DESCR = "condition_Info_descr"
    SORT_PROP_CONDITION_INFO_SEVERITY = "condition_Info_severity"
    SORT_PROP_CONDITION_INFO_SRC_DME = "condition_Info_srcDme"
    SORT_PROP_CONDITION_LOG_MAX_SIZE = "condition_Log_maxSize"
    SORT_PROP_CONDITION_LOG_PURGE_WINDOW = "condition_Log_purgeWindow"
    SORT_PROP_CONDITION_LOG_SIZE = "condition_Log_size"
    SORT_PROP_CONDITION_LOGGABLE_AFFECTED = "condition_Loggable_affected"
    SORT_PROP_CONDITION_LOGGABLE_CAUSE = "condition_Loggable_cause"
    SORT_PROP_CONDITION_LOGGABLE_CHANGE_SET = "condition_Loggable_changeSet"
    SORT_PROP_CONDITION_LOGGABLE_CODE = "condition_Loggable_code"
    SORT_PROP_CONDITION_LOGGABLE_CREATED = "condition_Loggable_created"
    SORT_PROP_CONDITION_LOGGABLE_DESCR = "condition_Loggable_descr"
    SORT_PROP_CONDITION_LOGGABLE_ID = "condition_Loggable_id"
    SORT_PROP_CONDITION_LOGGABLE_IND = "condition_Loggable_ind"
    SORT_PROP_CONDITION_LOGGABLE_SEVERITY = "condition_Loggable_severity"
    SORT_PROP_CONDITION_LOGGABLE_SRC_DME = "condition_Loggable_srcDme"
    SORT_PROP_CONDITION_LOGGABLE_TRIG = "condition_Loggable_trig"
    SORT_PROP_CONDITION_LOGGABLE_TX_ID = "condition_Loggable_txId"
    SORT_PROP_CONDITION_LOGGABLE_USER = "condition_Loggable_user"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_CAUSE = "condition_MultiInstanceImmutable_cause"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_CHANGE_SET = "condition_MultiInstanceImmutable_changeSet"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_CODE = "condition_MultiInstanceImmutable_code"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_CREATED = "condition_MultiInstanceImmutable_created"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_DESCR = "condition_MultiInstanceImmutable_descr"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_ID = "condition_MultiInstanceImmutable_id"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_RULE = "condition_MultiInstanceImmutable_rule"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_SEVERITY = "condition_MultiInstanceImmutable_severity"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_SRC_DME = "condition_MultiInstanceImmutable_srcDme"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_TAGS = "condition_MultiInstanceImmutable_tags"
    SORT_PROP_CONDITION_MULTI_INSTANCE_IMMUTABLE_TYPE = "condition_MultiInstanceImmutable_type"
    SORT_PROP_CONDITION_MUTABLE_CAUSE = "condition_Mutable_cause"
    SORT_PROP_CONDITION_MUTABLE_CAUSE_STRING = "condition_Mutable_causeString"
    SORT_PROP_CONDITION_MUTABLE_CHANGE_SET = "condition_Mutable_changeSet"
    SORT_PROP_CONDITION_MUTABLE_CODE = "condition_Mutable_code"
    SORT_PROP_CONDITION_MUTABLE_CREATED = "condition_Mutable_created"
    SORT_PROP_CONDITION_MUTABLE_DESCR = "condition_Mutable_descr"
    SORT_PROP_CONDITION_MUTABLE_HIGHEST_SEVERITY = "condition_Mutable_highestSeverity"
    SORT_PROP_CONDITION_MUTABLE_ID = "condition_Mutable_id"
    SORT_PROP_CONDITION_MUTABLE_LAST_TRANSITION = "condition_Mutable_lastTransition"
    SORT_PROP_CONDITION_MUTABLE_ORIG_SEVERITY = "condition_Mutable_origSeverity"
    SORT_PROP_CONDITION_MUTABLE_PREV_SEVERITY = "condition_Mutable_prevSeverity"
    SORT_PROP_CONDITION_MUTABLE_RULE = "condition_Mutable_rule"
    SORT_PROP_CONDITION_MUTABLE_SEVERITY = "condition_Mutable_severity"
    SORT_PROP_CONDITION_MUTABLE_SRC_DME = "condition_Mutable_srcDme"
    SORT_PROP_CONDITION_MUTABLE_TAGS = "condition_Mutable_tags"
    SORT_PROP_CONDITION_MUTABLE_TYPE = "condition_Mutable_type"
    SORT_PROP_CONDITION_POLICY_DESCR = "condition_Policy_descr"
    SORT_PROP_CONDITION_POLICY_INT_ID = "condition_Policy_intId"
    SORT_PROP_CONDITION_POLICY_NAME = "condition_Policy_name"
    SORT_PROP_CONDITION_POLICY_POLICY_LEVEL = "condition_Policy_policyLevel"
    SORT_PROP_CONDITION_POLICY_POLICY_OWNER = "condition_Policy_policyOwner"
    SORT_PROP_CONDITION_POLICY_RETENTION_INTERVAL = "condition_Policy_retentionInterval"
    SORT_PROP_CONDITION_POLICY_SIZE_LIMIT = "condition_Policy_sizeLimit"
    SORT_PROP_CONDITION_REPORTABLE_CAUSE = "condition_Reportable_cause"
    SORT_PROP_CONDITION_REPORTABLE_CHANGE_SET = "condition_Reportable_changeSet"
    SORT_PROP_CONDITION_REPORTABLE_CODE = "condition_Reportable_code"
    SORT_PROP_CONDITION_REPORTABLE_CREATED = "condition_Reportable_created"
    SORT_PROP_CONDITION_REPORTABLE_DESCR = "condition_Reportable_descr"
    SORT_PROP_CONDITION_REPORTABLE_ID = "condition_Reportable_id"
    SORT_PROP_CONDITION_REPORTABLE_RULE = "condition_Reportable_rule"
    SORT_PROP_CONDITION_REPORTABLE_SEVERITY = "condition_Reportable_severity"
    SORT_PROP_CONDITION_REPORTABLE_SRC_DME = "condition_Reportable_srcDme"
    SORT_PROP_CONDITION_REPORTABLE_TAGS = "condition_Reportable_tags"
    SORT_PROP_CONDITION_REPORTABLE_TYPE = "condition_Reportable_type"
    SORT_PROP_CONFIG_ABS_DB_CONFIG_DATABASE = "config_AbsDbConfig_database"
    SORT_PROP_CONFIG_ABS_DB_CONFIG_DB_ERROR = "config_AbsDbConfig_dbError"
    SORT_PROP_CONFIG_ABS_DB_CONFIG_HOSTNAME = "config_AbsDbConfig_hostname"
    SORT_PROP_CONFIG_ABS_DB_CONFIG_INSTANCE = "config_AbsDbConfig_instance"
    SORT_PROP_CONFIG_ABS_DB_CONFIG_LAST_DB_STATUS = "config_AbsDbConfig_lastDbStatus"
    SORT_PROP_CONFIG_ABS_DB_CONFIG_PORT = "config_AbsDbConfig_port"
    SORT_PROP_CONFIG_ABS_DB_CONFIG_PWD = "config_AbsDbConfig_pwd"
    SORT_PROP_CONFIG_ABS_DB_CONFIG_TYPE = "config_AbsDbConfig_type"
    SORT_PROP_CONFIG_ABS_DB_CONFIG_USER = "config_AbsDbConfig_user"
    SORT_PROP_CONFIG_ACK_ITEM_ACK_DN = "config_AckItem_ackDn"
    SORT_PROP_CONFIG_ACK_ITEM_ADMIN_STATE_ACK = "config_AckItem_adminStateAck"
    SORT_PROP_CONFIG_ACK_ITEM_ADMIN_STATE_REQUESTOR = "config_AckItem_adminStateRequestor"
    SORT_PROP_CONFIG_ACK_ITEM_CHANGE_BY = "config_AckItem_changeBy"
    SORT_PROP_CONFIG_ACK_ITEM_CHANGES = "config_AckItem_changes"
    SORT_PROP_CONFIG_ACK_ITEM_DISR_TYPE = "config_AckItem_disrType"
    SORT_PROP_CONFIG_ACK_ITEM_DOMAIN_DN = "config_AckItem_domainDn"
    SORT_PROP_CONFIG_ACK_ITEM_DOMAIN_GROUP_DN = "config_AckItem_domainGroupDn"
    SORT_PROP_CONFIG_ACK_ITEM_DOMAIN_NAME = "config_AckItem_domainName"
    SORT_PROP_CONFIG_ACK_ITEM_INSTANCE_TYPE = "config_AckItem_instanceType"
    SORT_PROP_CONFIG_ACK_ITEM_OPER_SCHEDULER = "config_AckItem_operScheduler"
    SORT_PROP_CONFIG_ACK_ITEM_OPER_STATE_ACK = "config_AckItem_operStateAck"
    SORT_PROP_CONFIG_ACK_ITEM_OPER_STATE_REQUESTOR = "config_AckItem_operStateRequestor"
    SORT_PROP_CONFIG_ACK_ITEM_REBOOT_REASON = "config_AckItem_rebootReason"
    SORT_PROP_CONFIG_ACK_ITEM_SCHEDULER = "config_AckItem_scheduler"
    SORT_PROP_CONFIG_ACK_ITEM_SERVER_ID = "config_AckItem_serverId"
    SORT_PROP_CONFIG_ACK_ITEM_SERVICE_PROFILE_DN = "config_AckItem_serviceProfileDn"
    SORT_PROP_CONFIG_ACK_ITEM_SERVICE_PROFILE_NAME = "config_AckItem_serviceProfileName"
    SORT_PROP_CONFIG_ACK_ITEM_TAG_NAME = "config_AckItem_tagName"
    SORT_PROP_CONFIG_ADAPTOR_ITEM_ADAPTOR_ID = "config_AdaptorItem_adaptorId"
    SORT_PROP_CONFIG_ADAPTOR_ITEM_COMPONENT_DN = "config_AdaptorItem_componentDn"
    SORT_PROP_CONFIG_ADAPTOR_ITEM_DOMAIN_GROUP_DN = "config_AdaptorItem_domainGroupDn"
    SORT_PROP_CONFIG_ADAPTOR_ITEM_DOMAIN_NAME = "config_AdaptorItem_domainName"
    SORT_PROP_CONFIG_ADAPTOR_ITEM_FAULT_LEVEL = "config_AdaptorItem_faultLevel"
    SORT_PROP_CONFIG_ADAPTOR_ITEM_FW_STATUS = "config_AdaptorItem_fwStatus"
    SORT_PROP_CONFIG_ADAPTOR_ITEM_FW_VERSION = "config_AdaptorItem_fwVersion"
    SORT_PROP_CONFIG_ADAPTOR_ITEM_LOCATION = "config_AdaptorItem_location"
    SORT_PROP_CONFIG_ADAPTOR_ITEM_MODEL = "config_AdaptorItem_model"
    SORT_PROP_CONFIG_ADAPTOR_ITEM_NUM_OF_DCES = "config_AdaptorItem_numOfDCEs"
    SORT_PROP_CONFIG_ADAPTOR_ITEM_NUM_OF_HBAS = "config_AdaptorItem_numOfHBAs"
    SORT_PROP_CONFIG_ADAPTOR_ITEM_NUM_OF_NICS = "config_AdaptorItem_numOfNICs"
    SORT_PROP_CONFIG_ADAPTOR_ITEM_NUM_OFI_SCSIV_NICS = "config_AdaptorItem_numOfiSCSIvNICs"
    SORT_PROP_CONFIG_ADAPTOR_ITEM_OPER_STATE = "config_AdaptorItem_operState"
    SORT_PROP_CONFIG_ADAPTOR_ITEM_POWER = "config_AdaptorItem_power"
    SORT_PROP_CONFIG_ADAPTOR_ITEM_PRESENCE = "config_AdaptorItem_presence"
    SORT_PROP_CONFIG_ADAPTOR_ITEM_SERIAL = "config_AdaptorItem_serial"
    SORT_PROP_CONFIG_ADAPTOR_ITEM_THERMAL = "config_AdaptorItem_thermal"
    SORT_PROP_CONFIG_APP_IMPACT_RESPONSE_APP_CONNECTOR_ID = "config_AppImpactResponse_appConnectorId"
    SORT_PROP_CONFIG_APP_IMPACT_RESPONSE_IMPACT_ANALYZER_ID = "config_AppImpactResponse_impactAnalyzerId"
    SORT_PROP_CONFIG_APP_IMPACT_RESPONSE_PROFILE_TYPE = "config_AppImpactResponse_profileType"
    SORT_PROP_CONFIG_APP_IMPACT_RESPONSE_SOURCE_CONNECTOR_ID = "config_AppImpactResponse_sourceConnectorId"
    SORT_PROP_CONFIG_APP_IMPACT_RESPONSE_STATE = "config_AppImpactResponse_state"
    SORT_PROP_CONFIG_BACKUP_FSM_STAGE_DESCR = "config_BackupFsmStage_descr"
    SORT_PROP_CONFIG_BACKUP_FSM_STAGE_LAST_UPDATE_TIME = "config_BackupFsmStage_lastUpdateTime"
    SORT_PROP_CONFIG_BACKUP_FSM_STAGE_NAME = "config_BackupFsmStage_name"
    SORT_PROP_CONFIG_BACKUP_FSM_STAGE_ORDER = "config_BackupFsmStage_order"
    SORT_PROP_CONFIG_BACKUP_FSM_STAGE_RETRY = "config_BackupFsmStage_retry"
    SORT_PROP_CONFIG_BACKUP_FSM_STAGE_STAGE_STATUS = "config_BackupFsmStage_stageStatus"
    SORT_PROP_CONFIG_BACKUP_FSM_TASK_COMPLETION = "config_BackupFsmTask_completion"
    SORT_PROP_CONFIG_BACKUP_FSM_TASK_FLAGS = "config_BackupFsmTask_flags"
    SORT_PROP_CONFIG_BACKUP_FSM_TASK_ITEM = "config_BackupFsmTask_item"
    SORT_PROP_CONFIG_BACKUP_FSM_TASK_SEQ_ID = "config_BackupFsmTask_seqId"
    SORT_PROP_CONFIG_BACKUP_FSM_COMPLETION_TIME = "config_BackupFsm_completionTime"
    SORT_PROP_CONFIG_BACKUP_FSM_CURRENT_FSM = "config_BackupFsm_currentFsm"
    SORT_PROP_CONFIG_BACKUP_FSM_DESCR = "config_BackupFsm_descr"
    SORT_PROP_CONFIG_BACKUP_FSM_FSM_INSTANCE_ID = "config_BackupFsm_fsmInstanceId"
    SORT_PROP_CONFIG_BACKUP_FSM_FSM_STATUS = "config_BackupFsm_fsmStatus"
    SORT_PROP_CONFIG_BACKUP_FSM_PROGRESS = "config_BackupFsm_progress"
    SORT_PROP_CONFIG_BACKUP_FSM_RMT_ERR_CODE = "config_BackupFsm_rmtErrCode"
    SORT_PROP_CONFIG_BACKUP_FSM_RMT_ERR_DESCR = "config_BackupFsm_rmtErrDescr"
    SORT_PROP_CONFIG_BACKUP_FSM_RMT_RSLT = "config_BackupFsm_rmtRslt"
    SORT_PROP_CONFIG_BACKUP_ADMIN_STATE = "config_Backup_adminState"
    SORT_PROP_CONFIG_BACKUP_BACKUP_TYPE = "config_Backup_backupType"
    SORT_PROP_CONFIG_BACKUP_CONFIG_QUALIFIER = "config_Backup_configQualifier"
    SORT_PROP_CONFIG_BACKUP_CREATION_TS = "config_Backup_creationTS"
    SORT_PROP_CONFIG_BACKUP_FAULT_DESCR = "config_Backup_faultDescr"
    SORT_PROP_CONFIG_BACKUP_FILE_NAME = "config_Backup_fileName"
    SORT_PROP_CONFIG_BACKUP_FILE_PATH = "config_Backup_filePath"
    SORT_PROP_CONFIG_BACKUP_FSM_DESCR = "config_Backup_fsmDescr"
    SORT_PROP_CONFIG_BACKUP_FSM_PREV = "config_Backup_fsmPrev"
    SORT_PROP_CONFIG_BACKUP_FSM_PROGR = "config_Backup_fsmProgr"
    SORT_PROP_CONFIG_BACKUP_FSM_RMT_INV_ERR_CODE = "config_Backup_fsmRmtInvErrCode"
    SORT_PROP_CONFIG_BACKUP_FSM_RMT_INV_ERR_DESCR = "config_Backup_fsmRmtInvErrDescr"
    SORT_PROP_CONFIG_BACKUP_FSM_RMT_INV_RSLT = "config_Backup_fsmRmtInvRslt"
    SORT_PROP_CONFIG_BACKUP_FSM_STAGE_DESCR = "config_Backup_fsmStageDescr"
    SORT_PROP_CONFIG_BACKUP_FSM_STAMP = "config_Backup_fsmStamp"
    SORT_PROP_CONFIG_BACKUP_FSM_STATUS = "config_Backup_fsmStatus"
    SORT_PROP_CONFIG_BACKUP_FSM_TRY = "config_Backup_fsmTry"
    SORT_PROP_CONFIG_BACKUP_GEN_NUMBER = "config_Backup_genNumber"
    SORT_PROP_CONFIG_BACKUP_NAME = "config_Backup_name"
    SORT_PROP_CONFIG_BACKUP_SERVER = "config_Backup_server"
    SORT_PROP_CONFIG_BACKUP_TFTP_URL = "config_Backup_tftpURL"
    SORT_PROP_CONFIG_BACKUP_TS = "config_Backup_ts"
    SORT_PROP_CONFIG_CARTRIDGE_FILTER_DOMAIN_DN = "config_CartridgeFilter_domainDn"
    SORT_PROP_CONFIG_CARTRIDGE_FILTER_DOMAIN_GROUP_DN = "config_CartridgeFilter_domainGroupDn"
    SORT_PROP_CONFIG_CARTRIDGE_FILTER_DOMAIN_NAME = "config_CartridgeFilter_domainName"
    SORT_PROP_CONFIG_CARTRIDGE_FILTER_FAULT_LEVEL = "config_CartridgeFilter_faultLevel"
    SORT_PROP_CONFIG_CARTRIDGE_FILTER_MODEL = "config_CartridgeFilter_model"
    SORT_PROP_CONFIG_CARTRIDGE_FILTER_OPER_STATE = "config_CartridgeFilter_operState"
    SORT_PROP_CONFIG_CARTRIDGE_ITEM_CHASSIS_ID = "config_CartridgeItem_chassisId"
    SORT_PROP_CONFIG_CARTRIDGE_ITEM_COMPONENT_DN = "config_CartridgeItem_componentDn"
    SORT_PROP_CONFIG_CARTRIDGE_ITEM_DOMAIN_GROUP_DN = "config_CartridgeItem_domainGroupDn"
    SORT_PROP_CONFIG_CARTRIDGE_ITEM_DOMAIN_NAME = "config_CartridgeItem_domainName"
    SORT_PROP_CONFIG_CARTRIDGE_ITEM_FAULT_LEVEL = "config_CartridgeItem_faultLevel"
    SORT_PROP_CONFIG_CARTRIDGE_ITEM_ID = "config_CartridgeItem_id"
    SORT_PROP_CONFIG_CARTRIDGE_ITEM_MODEL = "config_CartridgeItem_model"
    SORT_PROP_CONFIG_CARTRIDGE_ITEM_OPER_STATE = "config_CartridgeItem_operState"
    SORT_PROP_CONFIG_CARTRIDGE_ITEM_POWER = "config_CartridgeItem_power"
    SORT_PROP_CONFIG_CARTRIDGE_ITEM_PRESENCE = "config_CartridgeItem_presence"
    SORT_PROP_CONFIG_CARTRIDGE_ITEM_SERIAL = "config_CartridgeItem_serial"
    SORT_PROP_CONFIG_CARTRIDGE_ITEM_THERMAL = "config_CartridgeItem_thermal"
    SORT_PROP_CONFIG_CHASSIS_FILTER_DECOMMISSIONED = "config_ChassisFilter_decommissioned"
    SORT_PROP_CONFIG_CHASSIS_FILTER_DOMAIN_DN = "config_ChassisFilter_domainDn"
    SORT_PROP_CONFIG_CHASSIS_FILTER_DOMAIN_GROUP_DN = "config_ChassisFilter_domainGroupDn"
    SORT_PROP_CONFIG_CHASSIS_FILTER_DOMAIN_NAME = "config_ChassisFilter_domainName"
    SORT_PROP_CONFIG_CHASSIS_FILTER_FAULT_LEVEL = "config_ChassisFilter_faultLevel"
    SORT_PROP_CONFIG_CHASSIS_FILTER_MODEL = "config_ChassisFilter_model"
    SORT_PROP_CONFIG_CHASSIS_FILTER_OPER_STATE = "config_ChassisFilter_operState"
    SORT_PROP_CONFIG_CHASSIS_ITEM_CHASSIS_PROFILE = "config_ChassisItem_ChassisProfile"
    SORT_PROP_CONFIG_CHASSIS_ITEM_ADMIN_STATE = "config_ChassisItem_adminState"
    SORT_PROP_CONFIG_CHASSIS_ITEM_ASSOCIATION = "config_ChassisItem_association"
    SORT_PROP_CONFIG_CHASSIS_ITEM_CHASSIS_DN = "config_ChassisItem_chassisDn"
    SORT_PROP_CONFIG_CHASSIS_ITEM_CONFIG_STATE = "config_ChassisItem_configState"
    SORT_PROP_CONFIG_CHASSIS_ITEM_DECOMMISSIONED = "config_ChassisItem_decommissioned"
    SORT_PROP_CONFIG_CHASSIS_ITEM_DOMAIN_CONNECTION_STATE = "config_ChassisItem_domainConnectionState"
    SORT_PROP_CONFIG_CHASSIS_ITEM_DOMAIN_DN = "config_ChassisItem_domainDn"
    SORT_PROP_CONFIG_CHASSIS_ITEM_DOMAIN_GROUP_DN = "config_ChassisItem_domainGroupDn"
    SORT_PROP_CONFIG_CHASSIS_ITEM_DOMAIN_NAME = "config_ChassisItem_domainName"
    SORT_PROP_CONFIG_CHASSIS_ITEM_DOMAIN_OPER_STATE = "config_ChassisItem_domainOperState"
    SORT_PROP_CONFIG_CHASSIS_ITEM_DOMAIN_SUSPEND_STATE = "config_ChassisItem_domainSuspendState"
    SORT_PROP_CONFIG_CHASSIS_ITEM_FAULT_LEVEL = "config_ChassisItem_faultLevel"
    SORT_PROP_CONFIG_CHASSIS_ITEM_ID = "config_ChassisItem_id"
    SORT_PROP_CONFIG_CHASSIS_ITEM_LOCATOR_LED_OPER_STATE = "config_ChassisItem_locatorLedOperState"
    SORT_PROP_CONFIG_CHASSIS_ITEM_MANAGING_INST = "config_ChassisItem_managingInst"
    SORT_PROP_CONFIG_CHASSIS_ITEM_MODEL = "config_ChassisItem_model"
    SORT_PROP_CONFIG_CHASSIS_ITEM_NUM_OF_BLADES = "config_ChassisItem_numOfBlades"
    SORT_PROP_CONFIG_CHASSIS_ITEM_NUM_OF_CARTRIDGES = "config_ChassisItem_numOfCartridges"
    SORT_PROP_CONFIG_CHASSIS_ITEM_NUM_OF_STORAGE_BLADES = "config_ChassisItem_numOfStorageBlades"
    SORT_PROP_CONFIG_CHASSIS_ITEM_OPER_QUALIFIER = "config_ChassisItem_operQualifier"
    SORT_PROP_CONFIG_CHASSIS_ITEM_OPER_STATE = "config_ChassisItem_operState"
    SORT_PROP_CONFIG_CHASSIS_ITEM_POWER = "config_ChassisItem_power"
    SORT_PROP_CONFIG_CHASSIS_ITEM_SERIAL = "config_ChassisItem_serial"
    SORT_PROP_CONFIG_CHASSIS_ITEM_THERMAL = "config_ChassisItem_thermal"
    SORT_PROP_CONFIG_COMPONENTS_FILTER_COMPONENT_NAME = "config_ComponentsFilter_componentName"
    SORT_PROP_CONFIG_COMPONENTS_FILTER_DOMAIN_DN = "config_ComponentsFilter_domainDn"
    SORT_PROP_CONFIG_COMPONENTS_FILTER_DOMAIN_GROUP_DN = "config_ComponentsFilter_domainGroupDn"
    SORT_PROP_CONFIG_COMPONENTS_FILTER_DOMAIN_NAME = "config_ComponentsFilter_domainName"
    SORT_PROP_CONFIG_COMPONENTS_FILTER_EQUIPMENT_NAME = "config_ComponentsFilter_equipmentName"
    SORT_PROP_CONFIG_COMPONENTS_FILTER_FAULT_LEVEL = "config_ComponentsFilter_faultLevel"
    SORT_PROP_CONFIG_COMPONENTS_FILTER_MODEL = "config_ComponentsFilter_model"
    SORT_PROP_CONFIG_COMPONENTS_FILTER_OPER_STATE = "config_ComponentsFilter_operState"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_STAGE_DESCR = "config_ConsumerCatalogueFsmStage_descr"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_STAGE_LAST_UPDATE_TIME = "config_ConsumerCatalogueFsmStage_lastUpdateTime"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_STAGE_NAME = "config_ConsumerCatalogueFsmStage_name"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_STAGE_ORDER = "config_ConsumerCatalogueFsmStage_order"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_STAGE_RETRY = "config_ConsumerCatalogueFsmStage_retry"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_STAGE_STAGE_STATUS = "config_ConsumerCatalogueFsmStage_stageStatus"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_TASK_COMPLETION = "config_ConsumerCatalogueFsmTask_completion"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_TASK_FLAGS = "config_ConsumerCatalogueFsmTask_flags"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_TASK_ITEM = "config_ConsumerCatalogueFsmTask_item"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_TASK_SEQ_ID = "config_ConsumerCatalogueFsmTask_seqId"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_COMPLETION_TIME = "config_ConsumerCatalogueFsm_completionTime"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_CURRENT_FSM = "config_ConsumerCatalogueFsm_currentFsm"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_DESCR = "config_ConsumerCatalogueFsm_descr"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_FSM_INSTANCE_ID = "config_ConsumerCatalogueFsm_fsmInstanceId"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_FSM_STATUS = "config_ConsumerCatalogueFsm_fsmStatus"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_PROGRESS = "config_ConsumerCatalogueFsm_progress"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_RMT_ERR_CODE = "config_ConsumerCatalogueFsm_rmtErrCode"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_RMT_ERR_DESCR = "config_ConsumerCatalogueFsm_rmtErrDescr"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_RMT_RSLT = "config_ConsumerCatalogueFsm_rmtRslt"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_ADMIN_STATE = "config_ConsumerCatalogue_adminState"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_CONSUMER_DN = "config_ConsumerCatalogue_consumerDn"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_DESCR = "config_ConsumerCatalogue_fsmDescr"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_PREV = "config_ConsumerCatalogue_fsmPrev"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_PROGR = "config_ConsumerCatalogue_fsmProgr"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_RMT_INV_ERR_CODE = "config_ConsumerCatalogue_fsmRmtInvErrCode"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_RMT_INV_ERR_DESCR = "config_ConsumerCatalogue_fsmRmtInvErrDescr"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_RMT_INV_RSLT = "config_ConsumerCatalogue_fsmRmtInvRslt"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_STAGE_DESCR = "config_ConsumerCatalogue_fsmStageDescr"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_STAMP = "config_ConsumerCatalogue_fsmStamp"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_STATUS = "config_ConsumerCatalogue_fsmStatus"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_FSM_TRY = "config_ConsumerCatalogue_fsmTry"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_INTERNAL_NAME = "config_ConsumerCatalogue_internalName"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_NAME = "config_ConsumerCatalogue_name"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_OPER_STATE = "config_ConsumerCatalogue_operState"
    SORT_PROP_CONFIG_CONSUMER_CATALOGUE_SYNC_STATUS = "config_ConsumerCatalogue_syncStatus"
    SORT_PROP_CONFIG_CONTROLLER_ITEM_COMPONENT_DN = "config_ControllerItem_componentDn"
    SORT_PROP_CONFIG_CONTROLLER_ITEM_DOMAIN_GROUP_DN = "config_ControllerItem_domainGroupDn"
    SORT_PROP_CONFIG_CONTROLLER_ITEM_DOMAIN_NAME = "config_ControllerItem_domainName"
    SORT_PROP_CONFIG_CONTROLLER_ITEM_EQUIPMENT_TYPE = "config_ControllerItem_equipmentType"
    SORT_PROP_CONFIG_CONTROLLER_ITEM_FAULT_LEVEL = "config_ControllerItem_faultLevel"
    SORT_PROP_CONFIG_CONTROLLER_ITEM_FW_STATUS = "config_ControllerItem_fwStatus"
    SORT_PROP_CONFIG_CONTROLLER_ITEM_FW_VERSION = "config_ControllerItem_fwVersion"
    SORT_PROP_CONFIG_CONTROLLER_ITEM_ID = "config_ControllerItem_id"
    SORT_PROP_CONFIG_CONTROLLER_ITEM_IS_STORAGE_CONTROLLER = "config_ControllerItem_isStorageController"
    SORT_PROP_CONFIG_CONTROLLER_ITEM_LOCATION = "config_ControllerItem_location"
    SORT_PROP_CONFIG_CONTROLLER_ITEM_MODEL = "config_ControllerItem_model"
    SORT_PROP_CONFIG_CONTROLLER_ITEM_OPER_STATE = "config_ControllerItem_operState"
    SORT_PROP_CONFIG_CONTROLLER_ITEM_POWER = "config_ControllerItem_power"
    SORT_PROP_CONFIG_CONTROLLER_ITEM_PRESENCE = "config_ControllerItem_presence"
    SORT_PROP_CONFIG_CONTROLLER_ITEM_SERIAL = "config_ControllerItem_serial"
    SORT_PROP_CONFIG_CONTROLLER_ITEM_THERMAL = "config_ControllerItem_thermal"
    SORT_PROP_CONFIG_CPU_INFO_ARCH = "config_CpuInfo_arch"
    SORT_PROP_CONFIG_CPU_INFO_COUNT = "config_CpuInfo_count"
    SORT_PROP_CONFIG_CPU_INFO_SPEED = "config_CpuInfo_speed"
    SORT_PROP_CONFIG_CPU_ITEM_ARCH = "config_CpuItem_arch"
    SORT_PROP_CONFIG_CPU_ITEM_COMPONENT_DN = "config_CpuItem_componentDn"
    SORT_PROP_CONFIG_CPU_ITEM_CORES = "config_CpuItem_cores"
    SORT_PROP_CONFIG_CPU_ITEM_CORES_ENABLED = "config_CpuItem_coresEnabled"
    SORT_PROP_CONFIG_CPU_ITEM_DOMAIN_GROUP_DN = "config_CpuItem_domainGroupDn"
    SORT_PROP_CONFIG_CPU_ITEM_DOMAIN_NAME = "config_CpuItem_domainName"
    SORT_PROP_CONFIG_CPU_ITEM_FAULT_LEVEL = "config_CpuItem_faultLevel"
    SORT_PROP_CONFIG_CPU_ITEM_ID = "config_CpuItem_id"
    SORT_PROP_CONFIG_CPU_ITEM_LOCATION = "config_CpuItem_location"
    SORT_PROP_CONFIG_CPU_ITEM_OPER_STATE = "config_CpuItem_operState"
    SORT_PROP_CONFIG_CPU_ITEM_PID = "config_CpuItem_pid"
    SORT_PROP_CONFIG_CPU_ITEM_POWER = "config_CpuItem_power"
    SORT_PROP_CONFIG_CPU_ITEM_PRESENCE = "config_CpuItem_presence"
    SORT_PROP_CONFIG_CPU_ITEM_SPEED = "config_CpuItem_speed"
    SORT_PROP_CONFIG_CPU_ITEM_THERMAL = "config_CpuItem_thermal"
    SORT_PROP_CONFIG_CRYPTO_CARD_ITEM_COMPONENT_DN = "config_CryptoCardItem_componentDn"
    SORT_PROP_CONFIG_CRYPTO_CARD_ITEM_DOMAIN_GROUP_DN = "config_CryptoCardItem_domainGroupDn"
    SORT_PROP_CONFIG_CRYPTO_CARD_ITEM_DOMAIN_NAME = "config_CryptoCardItem_domainName"
    SORT_PROP_CONFIG_CRYPTO_CARD_ITEM_ID = "config_CryptoCardItem_id"
    SORT_PROP_CONFIG_CRYPTO_CARD_ITEM_LOCATION = "config_CryptoCardItem_location"
    SORT_PROP_CONFIG_CRYPTO_CARD_ITEM_MODEL = "config_CryptoCardItem_model"
    SORT_PROP_CONFIG_CRYPTO_CARD_ITEM_OPER_STATE = "config_CryptoCardItem_operState"
    SORT_PROP_CONFIG_CRYPTO_CARD_ITEM_POWER = "config_CryptoCardItem_power"
    SORT_PROP_CONFIG_CRYPTO_CARD_ITEM_PRESENCE = "config_CryptoCardItem_presence"
    SORT_PROP_CONFIG_CRYPTO_CARD_ITEM_SERIAL = "config_CryptoCardItem_serial"
    SORT_PROP_CONFIG_CRYPTO_CARD_ITEM_THERMAL = "config_CryptoCardItem_thermal"
    SORT_PROP_CONFIG_DB_CONFIG_DATABASE = "config_DbConfig_database"
    SORT_PROP_CONFIG_DB_CONFIG_DB_ERROR = "config_DbConfig_dbError"
    SORT_PROP_CONFIG_DB_CONFIG_HOSTNAME = "config_DbConfig_hostname"
    SORT_PROP_CONFIG_DB_CONFIG_INSTANCE = "config_DbConfig_instance"
    SORT_PROP_CONFIG_DB_CONFIG_LAST_DB_STATUS = "config_DbConfig_lastDbStatus"
    SORT_PROP_CONFIG_DB_CONFIG_PORT = "config_DbConfig_port"
    SORT_PROP_CONFIG_DB_CONFIG_PWD = "config_DbConfig_pwd"
    SORT_PROP_CONFIG_DB_CONFIG_TYPE = "config_DbConfig_type"
    SORT_PROP_CONFIG_DB_CONFIG_USER = "config_DbConfig_user"
    SORT_PROP_CONFIG_DOMAIN_FILTER_CONNECTION_STATE = "config_DomainFilter_connectionState"
    SORT_PROP_CONFIG_DOMAIN_FILTER_DOMAIN_GROUP_DN = "config_DomainFilter_domainGroupDn"
    SORT_PROP_CONFIG_DOMAIN_FILTER_FAULT_LEVEL = "config_DomainFilter_faultLevel"
    SORT_PROP_CONFIG_DOMAIN_FILTER_FW_OPER_STATE = "config_DomainFilter_fwOperState"
    SORT_PROP_CONFIG_DOMAIN_FILTER_FW_PACKAGE_VERSION = "config_DomainFilter_fwPackageVersion"
    SORT_PROP_CONFIG_DOMAIN_FILTER_FW_SERVICE_PACK_VERSION = "config_DomainFilter_fwServicePackVersion"
    SORT_PROP_CONFIG_DOMAIN_FILTER_INVENTORY_STATUS = "config_DomainFilter_inventoryStatus"
    SORT_PROP_CONFIG_DOMAIN_FILTER_LIC_STATE = "config_DomainFilter_licState"
    SORT_PROP_CONFIG_DOMAIN_FILTER_OPER_STATE = "config_DomainFilter_operState"
    SORT_PROP_CONFIG_DOMAIN_FILTER_PRODUCT_FAMILY = "config_DomainFilter_productFamily"
    SORT_PROP_CONFIG_DOMAIN_FILTER_SUSPEND_STATE = "config_DomainFilter_suspendState"
    SORT_PROP_CONFIG_DOMAIN_ITEM_CONNECTION_STATE = "config_DomainItem_connectionState"
    SORT_PROP_CONFIG_DOMAIN_ITEM_DOMAIN_DN = "config_DomainItem_domainDn"
    SORT_PROP_CONFIG_DOMAIN_ITEM_DOMAIN_GROUP_DN = "config_DomainItem_domainGroupDn"
    SORT_PROP_CONFIG_DOMAIN_ITEM_DOMAIN_NAME = "config_DomainItem_domainName"
    SORT_PROP_CONFIG_DOMAIN_ITEM_FABRIC_INTERCONNECT_MODEL = "config_DomainItem_fabricInterconnectModel"
    SORT_PROP_CONFIG_DOMAIN_ITEM_FAULT_LEVEL = "config_DomainItem_faultLevel"
    SORT_PROP_CONFIG_DOMAIN_ITEM_FW_OPER_STATE = "config_DomainItem_fwOperState"
    SORT_PROP_CONFIG_DOMAIN_ITEM_FW_PACKAGE_VERSION = "config_DomainItem_fwPackageVersion"
    SORT_PROP_CONFIG_DOMAIN_ITEM_FW_SERVICE_PACK_VERSION = "config_DomainItem_fwServicePackVersion"
    SORT_PROP_CONFIG_DOMAIN_ITEM_INVENTORY_STATUS = "config_DomainItem_inventoryStatus"
    SORT_PROP_CONFIG_DOMAIN_ITEM_IP = "config_DomainItem_ip"
    SORT_PROP_CONFIG_DOMAIN_ITEM_IPV6 = "config_DomainItem_ipv6"
    SORT_PROP_CONFIG_DOMAIN_ITEM_IS_HA = "config_DomainItem_isHA"
    SORT_PROP_CONFIG_DOMAIN_ITEM_LIC_STATE = "config_DomainItem_licState"
    SORT_PROP_CONFIG_DOMAIN_ITEM_NUM_OF_BLADES = "config_DomainItem_numOfBlades"
    SORT_PROP_CONFIG_DOMAIN_ITEM_NUM_OF_CARTRIDGES = "config_DomainItem_numOfCartridges"
    SORT_PROP_CONFIG_DOMAIN_ITEM_NUM_OF_CHASSIS = "config_DomainItem_numOfChassis"
    SORT_PROP_CONFIG_DOMAIN_ITEM_NUM_OF_FEX = "config_DomainItem_numOfFex"
    SORT_PROP_CONFIG_DOMAIN_ITEM_NUM_OF_RACKS = "config_DomainItem_numOfRacks"
    SORT_PROP_CONFIG_DOMAIN_ITEM_NUM_OF_STORAGE_BLADES = "config_DomainItem_numOfStorageBlades"
    SORT_PROP_CONFIG_DOMAIN_ITEM_OPER_STATE = "config_DomainItem_operState"
    SORT_PROP_CONFIG_DOMAIN_ITEM_OWNER = "config_DomainItem_owner"
    SORT_PROP_CONFIG_DOMAIN_ITEM_PRODUCT_FAMILY = "config_DomainItem_productFamily"
    SORT_PROP_CONFIG_DOMAIN_ITEM_SITE = "config_DomainItem_site"
    SORT_PROP_CONFIG_DOMAIN_ITEM_SUSPEND_STATE = "config_DomainItem_suspendState"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_FILTER_DOMAIN_DN = "config_FabricInterconnectFilter_domainDn"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_FILTER_DOMAIN_GROUP_DN = "config_FabricInterconnectFilter_domainGroupDn"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_FILTER_DOMAIN_NAME = "config_FabricInterconnectFilter_domainName"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_FILTER_FAULT_LEVEL = "config_FabricInterconnectFilter_faultLevel"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_FILTER_FW_OPER_STATE = "config_FabricInterconnectFilter_fwOperState"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_FILTER_FW_SERVICE_PACK_VERSION = "config_FabricInterconnectFilter_fwServicePackVersion"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_FILTER_FW_VERSION = "config_FabricInterconnectFilter_fwVersion"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_FILTER_MODEL = "config_FabricInterconnectFilter_model"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_FILTER_OPERABILITY = "config_FabricInterconnectFilter_operability"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_DOMAIN_CONNECTION_STATE = "config_FabricInterconnectItem_domainConnectionState"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_DOMAIN_DN = "config_FabricInterconnectItem_domainDn"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_DOMAIN_GROUP_DN = "config_FabricInterconnectItem_domainGroupDn"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_DOMAIN_NAME = "config_FabricInterconnectItem_domainName"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_DOMAIN_OPER_STATE = "config_FabricInterconnectItem_domainOperState"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_DOMAIN_SUSPEND_STATE = "config_FabricInterconnectItem_domainSuspendState"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_FABRIC_INTERCONNECT_DN = "config_FabricInterconnectItem_fabricInterconnectDn"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_FAULT_LEVEL = "config_FabricInterconnectItem_faultLevel"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_FW_OPER_STATE = "config_FabricInterconnectItem_fwOperState"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_FW_SERVICE_PACK_VERSION = "config_FabricInterconnectItem_fwServicePackVersion"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_FW_VERSION = "config_FabricInterconnectItem_fwVersion"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_ID = "config_FabricInterconnectItem_id"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_LEADERSHIP = "config_FabricInterconnectItem_leadership"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_LOCATOR_LED_OPER_STATE = "config_FabricInterconnectItem_locatorLedOperState"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_MODEL = "config_FabricInterconnectItem_model"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_NUM_OF_ETH_PORTS = "config_FabricInterconnectItem_numOfEthPorts"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_NUM_OF_EXPANSION_MODULES = "config_FabricInterconnectItem_numOfExpansionModules"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_NUM_OF_FC_PORTS = "config_FabricInterconnectItem_numOfFcPorts"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_NUM_OF_FIXED_MODULES = "config_FabricInterconnectItem_numOfFixedModules"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_OOB_IF_IP = "config_FabricInterconnectItem_oobIfIp"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_OPERABILITY = "config_FabricInterconnectItem_operability"
    SORT_PROP_CONFIG_FABRIC_INTERCONNECT_ITEM_SERIAL = "config_FabricInterconnectItem_serial"
    SORT_PROP_CONFIG_FAN_ITEM_COMPONENT_DN = "config_FanItem_componentDn"
    SORT_PROP_CONFIG_FAN_ITEM_DOMAIN_GROUP_DN = "config_FanItem_domainGroupDn"
    SORT_PROP_CONFIG_FAN_ITEM_DOMAIN_NAME = "config_FanItem_domainName"
    SORT_PROP_CONFIG_FAN_ITEM_EQUIPMENT_TYPE = "config_FanItem_equipmentType"
    SORT_PROP_CONFIG_FAN_ITEM_FAULT_LEVEL = "config_FanItem_faultLevel"
    SORT_PROP_CONFIG_FAN_ITEM_ID = "config_FanItem_id"
    SORT_PROP_CONFIG_FAN_ITEM_LOCATION = "config_FanItem_location"
    SORT_PROP_CONFIG_FAN_ITEM_MODEL = "config_FanItem_model"
    SORT_PROP_CONFIG_FAN_ITEM_MODULE = "config_FanItem_module"
    SORT_PROP_CONFIG_FAN_ITEM_OPER_STATE = "config_FanItem_operState"
    SORT_PROP_CONFIG_FAN_ITEM_POWER = "config_FanItem_power"
    SORT_PROP_CONFIG_FAN_ITEM_SERIAL = "config_FanItem_serial"
    SORT_PROP_CONFIG_FAN_ITEM_THERMAL = "config_FanItem_thermal"
    SORT_PROP_CONFIG_FEX_FILTER_DECOMMISSIONED = "config_FexFilter_decommissioned"
    SORT_PROP_CONFIG_FEX_FILTER_DOMAIN_DN = "config_FexFilter_domainDn"
    SORT_PROP_CONFIG_FEX_FILTER_DOMAIN_GROUP_DN = "config_FexFilter_domainGroupDn"
    SORT_PROP_CONFIG_FEX_FILTER_DOMAIN_NAME = "config_FexFilter_domainName"
    SORT_PROP_CONFIG_FEX_FILTER_FAULT_LEVEL = "config_FexFilter_faultLevel"
    SORT_PROP_CONFIG_FEX_FILTER_MODEL = "config_FexFilter_model"
    SORT_PROP_CONFIG_FEX_FILTER_OPER_STATE = "config_FexFilter_operState"
    SORT_PROP_CONFIG_FEX_ITEM_CONFIG_STATE = "config_FexItem_configState"
    SORT_PROP_CONFIG_FEX_ITEM_DECOMMISSIONED = "config_FexItem_decommissioned"
    SORT_PROP_CONFIG_FEX_ITEM_DOMAIN_CONNECTION_STATE = "config_FexItem_domainConnectionState"
    SORT_PROP_CONFIG_FEX_ITEM_DOMAIN_DN = "config_FexItem_domainDn"
    SORT_PROP_CONFIG_FEX_ITEM_DOMAIN_GROUP_DN = "config_FexItem_domainGroupDn"
    SORT_PROP_CONFIG_FEX_ITEM_DOMAIN_NAME = "config_FexItem_domainName"
    SORT_PROP_CONFIG_FEX_ITEM_DOMAIN_OPER_STATE = "config_FexItem_domainOperState"
    SORT_PROP_CONFIG_FEX_ITEM_DOMAIN_SUSPEND_STATE = "config_FexItem_domainSuspendState"
    SORT_PROP_CONFIG_FEX_ITEM_FAULT_LEVEL = "config_FexItem_faultLevel"
    SORT_PROP_CONFIG_FEX_ITEM_FEX_DN = "config_FexItem_fexDn"
    SORT_PROP_CONFIG_FEX_ITEM_ID = "config_FexItem_id"
    SORT_PROP_CONFIG_FEX_ITEM_LOCATOR_LED_OPER_STATE = "config_FexItem_locatorLedOperState"
    SORT_PROP_CONFIG_FEX_ITEM_MODEL = "config_FexItem_model"
    SORT_PROP_CONFIG_FEX_ITEM_NUM_OF_PORTS = "config_FexItem_numOfPorts"
    SORT_PROP_CONFIG_FEX_ITEM_OPER_QUALIFIER = "config_FexItem_operQualifier"
    SORT_PROP_CONFIG_FEX_ITEM_OPER_STATE = "config_FexItem_operState"
    SORT_PROP_CONFIG_FEX_ITEM_POWER = "config_FexItem_power"
    SORT_PROP_CONFIG_FEX_ITEM_SERIAL = "config_FexItem_serial"
    SORT_PROP_CONFIG_FEX_ITEM_SWITCH_ID = "config_FexItem_switchId"
    SORT_PROP_CONFIG_FEX_ITEM_THERMAL = "config_FexItem_thermal"
    SORT_PROP_CONFIG_FILTER_GROUP_NAME = "config_FilterGroup_name"
    SORT_PROP_CONFIG_FILTER_ITEM_COUNT = "config_FilterItem_count"
    SORT_PROP_CONFIG_FILTER_ITEM_NAME = "config_FilterItem_name"
    SORT_PROP_CONFIG_FSM_STAGE_DESCR = "config_FsmStage_descr"
    SORT_PROP_CONFIG_FSM_STAGE_LAST_UPDATE_TIME = "config_FsmStage_lastUpdateTime"
    SORT_PROP_CONFIG_FSM_STAGE_NAME = "config_FsmStage_name"
    SORT_PROP_CONFIG_FSM_STAGE_ORDER = "config_FsmStage_order"
    SORT_PROP_CONFIG_FSM_STAGE_RETRY = "config_FsmStage_retry"
    SORT_PROP_CONFIG_FSM_STAGE_STAGE_STATUS = "config_FsmStage_stageStatus"
    SORT_PROP_CONFIG_FSM_COMPLETION_TIME = "config_Fsm_completionTime"
    SORT_PROP_CONFIG_FSM_CURRENT_FSM = "config_Fsm_currentFsm"
    SORT_PROP_CONFIG_FSM_DESCR = "config_Fsm_descr"
    SORT_PROP_CONFIG_FSM_FSM_INSTANCE_ID = "config_Fsm_fsmInstanceId"
    SORT_PROP_CONFIG_FSM_FSM_PREV = "config_Fsm_fsmPrev"
    SORT_PROP_CONFIG_FSM_FSM_STAGE = "config_Fsm_fsmStage"
    SORT_PROP_CONFIG_FSM_FSM_STAGE_DESCR = "config_Fsm_fsmStageDescr"
    SORT_PROP_CONFIG_FSM_FSM_STATUS = "config_Fsm_fsmStatus"
    SORT_PROP_CONFIG_FSM_FSM_TRY = "config_Fsm_fsmTry"
    SORT_PROP_CONFIG_FSM_PROGRESS = "config_Fsm_progress"
    SORT_PROP_CONFIG_FSM_RMT_ERR_CODE = "config_Fsm_rmtErrCode"
    SORT_PROP_CONFIG_FSM_RMT_ERR_DESCR = "config_Fsm_rmtErrDescr"
    SORT_PROP_CONFIG_FSM_RMT_RSLT = "config_Fsm_rmtRslt"
    SORT_PROP_CONFIG_GRAPHICS_CARD_ITEM_COMPONENT_DN = "config_GraphicsCardItem_componentDn"
    SORT_PROP_CONFIG_GRAPHICS_CARD_ITEM_DOMAIN_GROUP_DN = "config_GraphicsCardItem_domainGroupDn"
    SORT_PROP_CONFIG_GRAPHICS_CARD_ITEM_DOMAIN_NAME = "config_GraphicsCardItem_domainName"
    SORT_PROP_CONFIG_GRAPHICS_CARD_ITEM_FW_STATUS = "config_GraphicsCardItem_fwStatus"
    SORT_PROP_CONFIG_GRAPHICS_CARD_ITEM_FW_VERSION = "config_GraphicsCardItem_fwVersion"
    SORT_PROP_CONFIG_GRAPHICS_CARD_ITEM_ID = "config_GraphicsCardItem_id"
    SORT_PROP_CONFIG_GRAPHICS_CARD_ITEM_IS_SUPPORTED = "config_GraphicsCardItem_isSupported"
    SORT_PROP_CONFIG_GRAPHICS_CARD_ITEM_LOCATION = "config_GraphicsCardItem_location"
    SORT_PROP_CONFIG_GRAPHICS_CARD_ITEM_MODEL = "config_GraphicsCardItem_model"
    SORT_PROP_CONFIG_GRAPHICS_CARD_ITEM_NUM_OF_GRAPHICS_CONTROLLERS = "config_GraphicsCardItem_numOfGraphicsControllers"
    SORT_PROP_CONFIG_GRAPHICS_CARD_ITEM_OPER_STATE = "config_GraphicsCardItem_operState"
    SORT_PROP_CONFIG_GRAPHICS_CARD_ITEM_PCI_SLOT = "config_GraphicsCardItem_pciSlot"
    SORT_PROP_CONFIG_GRAPHICS_CARD_ITEM_POWER = "config_GraphicsCardItem_power"
    SORT_PROP_CONFIG_GRAPHICS_CARD_ITEM_SERIAL = "config_GraphicsCardItem_serial"
    SORT_PROP_CONFIG_GRAPHICS_CARD_ITEM_THERMAL = "config_GraphicsCardItem_thermal"
    SORT_PROP_CONFIG_IOMITEM_COMPONENT_DN = "config_IOMItem_componentDn"
    SORT_PROP_CONFIG_IOMITEM_DOMAIN_GROUP_DN = "config_IOMItem_domainGroupDn"
    SORT_PROP_CONFIG_IOMITEM_DOMAIN_NAME = "config_IOMItem_domainName"
    SORT_PROP_CONFIG_IOMITEM_EQUIPMENT_TYPE = "config_IOMItem_equipmentType"
    SORT_PROP_CONFIG_IOMITEM_FAULT_LEVEL = "config_IOMItem_faultLevel"
    SORT_PROP_CONFIG_IOMITEM_ID = "config_IOMItem_id"
    SORT_PROP_CONFIG_IOMITEM_IS_SHARED_IOMODULE = "config_IOMItem_isSharedIOModule"
    SORT_PROP_CONFIG_IOMITEM_LOCATION = "config_IOMItem_location"
    SORT_PROP_CONFIG_IOMITEM_MODEL = "config_IOMItem_model"
    SORT_PROP_CONFIG_IOMITEM_OPER_STATE = "config_IOMItem_operState"
    SORT_PROP_CONFIG_IOMITEM_POWER = "config_IOMItem_power"
    SORT_PROP_CONFIG_IOMITEM_PRESENCE = "config_IOMItem_presence"
    SORT_PROP_CONFIG_IOMITEM_SERIAL = "config_IOMItem_serial"
    SORT_PROP_CONFIG_IOMITEM_SIDE = "config_IOMItem_side"
    SORT_PROP_CONFIG_IOMITEM_THERMAL = "config_IOMItem_thermal"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_ACK_APP_RESPONSE_COUNT = "config_ImpactAnalyzer_ackAppResponseCount"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_AFFECTED_CHASSIS_CNT = "config_ImpactAnalyzer_affectedChassisCnt"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_CHASSIS_PROFILE_AFFECTED = "config_ImpactAnalyzer_chassisProfileAffected"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_COMPLETION_TIMESTAMP = "config_ImpactAnalyzer_completionTimestamp"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_CONTEXT = "config_ImpactAnalyzer_context"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_CREATION_TIMESTAMP = "config_ImpactAnalyzer_creationTimestamp"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_IMPACT_ANALYZER_ID = "config_ImpactAnalyzer_impactAnalyzerId"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_MODE = "config_ImpactAnalyzer_mode"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_REBOOT_REQUIRED = "config_ImpactAnalyzer_rebootRequired"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_RELAY_APP_RESPONSE_COUNT = "config_ImpactAnalyzer_relayAppResponseCount"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_SERVERS_AFFECTED = "config_ImpactAnalyzer_serversAffected"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_SERVICE_PROFILE_AFFECTED = "config_ImpactAnalyzer_serviceProfileAffected"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_SERVICE_PROFILE_LOST_VISIBILITY = "config_ImpactAnalyzer_serviceProfileLostVisibility"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_SERVICE_PROFILE_SUSPEND = "config_ImpactAnalyzer_serviceProfileSuspend"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_SERVICE_PROFILE_TIMED_OUT = "config_ImpactAnalyzer_serviceProfileTimedOut"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_SOURCE_CONNECTOR_ID = "config_ImpactAnalyzer_sourceConnectorId"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_STATE = "config_ImpactAnalyzer_state"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_UC_CENTRAL_CONFIG_ISSUES = "config_ImpactAnalyzer_ucCentralConfigIssues"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_UC_CENTRAL_ERRORS = "config_ImpactAnalyzer_ucCentralErrors"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_UC_CENTRAL_OVERALL_ISSUES = "config_ImpactAnalyzer_ucCentralOverallIssues"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_UC_CENTRAL_WARNINGS = "config_ImpactAnalyzer_ucCentralWarnings"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_UCS_DOMAINS_AFFECTED = "config_ImpactAnalyzer_ucsDomainsAffected"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_UCS_DOMAINS_ANALYZED = "config_ImpactAnalyzer_ucsDomainsAnalyzed"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_UCS_DOMAINS_IN_SUSPEND = "config_ImpactAnalyzer_ucsDomainsInSuspend"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_UCS_DOMAINS_LOST_VISIBILITY = "config_ImpactAnalyzer_ucsDomainsLostVisibility"
    SORT_PROP_CONFIG_IMPACT_ANALYZER_UCS_DOMAINS_TIMED_OUT = "config_ImpactAnalyzer_ucsDomainsTimedOut"
    SORT_PROP_CONFIG_IMPACT_RESPONSE_APP_CONNECTOR_ID = "config_ImpactResponse_appConnectorId"
    SORT_PROP_CONFIG_IMPACT_RESPONSE_IMPACT_ANALYZER_ID = "config_ImpactResponse_impactAnalyzerId"
    SORT_PROP_CONFIG_IMPACT_RESPONSE_PROFILE_TYPE = "config_ImpactResponse_profileType"
    SORT_PROP_CONFIG_IMPACT_RESPONSE_SOURCE_CONNECTOR_ID = "config_ImpactResponse_sourceConnectorId"
    SORT_PROP_CONFIG_IMPACT_RESPONSE_STATE = "config_ImpactResponse_state"
    SORT_PROP_CONFIG_IMPACT_AFFECTED_CHASSIS = "config_Impact_affectedChassis"
    SORT_PROP_CONFIG_IMPACT_AFFECTED_OBJ = "config_Impact_affectedObj"
    SORT_PROP_CONFIG_IMPACT_AFFECTED_SERVER = "config_Impact_affectedServer"
    SORT_PROP_CONFIG_IMPACT_CHANGES = "config_Impact_changes"
    SORT_PROP_CONFIG_IMPACT_CHASSIS_CONFIG_ISSUES = "config_Impact_chassisConfigIssues"
    SORT_PROP_CONFIG_IMPACT_CHASSIS_CONFIG_QUALIFIER = "config_Impact_chassisConfigQualifier"
    SORT_PROP_CONFIG_IMPACT_CHASSIS_CONFIG_STATE = "config_Impact_chassisConfigState"
    SORT_PROP_CONFIG_IMPACT_CONFIG_ISSUES = "config_Impact_configIssues"
    SORT_PROP_CONFIG_IMPACT_CONFIG_QUALIFIER = "config_Impact_configQualifier"
    SORT_PROP_CONFIG_IMPACT_CONFIG_STATE = "config_Impact_configState"
    SORT_PROP_CONFIG_IMPACT_DEPLOYMENT_MODE = "config_Impact_deploymentMode"
    SORT_PROP_CONFIG_IMPACT_NAME = "config_Impact_name"
    SORT_PROP_CONFIG_IMPACT_REBOOT_REQUIRED = "config_Impact_rebootRequired"
    SORT_PROP_CONFIG_INPUT_CONFIG_SET_CREATED = "config_InputConfigSet_created"
    SORT_PROP_CONFIG_INPUT_CONFIG_SET_DELETED = "config_InputConfigSet_deleted"
    SORT_PROP_CONFIG_INPUT_CONFIG_SET_MODIFIED = "config_InputConfigSet_modified"
    SORT_PROP_CONFIG_INPUT_CONFIG_CONFIG_DN = "config_InputConfig_configDn"
    SORT_PROP_CONFIG_INPUT_CONFIG_INPUT_CONFIG_STATUS = "config_InputConfig_inputConfigStatus"
    SORT_PROP_CONFIG_INPUT_CONFIG_INPUT_NAME = "config_InputConfig_inputName"
    SORT_PROP_CONFIG_LOCAL_DISK_ITEM_COMPONENT_DN = "config_LocalDiskItem_componentDn"
    SORT_PROP_CONFIG_LOCAL_DISK_ITEM_CONTROLLER_ID = "config_LocalDiskItem_controllerId"
    SORT_PROP_CONFIG_LOCAL_DISK_ITEM_DEVICE_TYPE = "config_LocalDiskItem_deviceType"
    SORT_PROP_CONFIG_LOCAL_DISK_ITEM_DOMAIN_GROUP_DN = "config_LocalDiskItem_domainGroupDn"
    SORT_PROP_CONFIG_LOCAL_DISK_ITEM_DOMAIN_NAME = "config_LocalDiskItem_domainName"
    SORT_PROP_CONFIG_LOCAL_DISK_ITEM_EQUIPMENT_TYPE = "config_LocalDiskItem_equipmentType"
    SORT_PROP_CONFIG_LOCAL_DISK_ITEM_FAULT_LEVEL = "config_LocalDiskItem_faultLevel"
    SORT_PROP_CONFIG_LOCAL_DISK_ITEM_FW_STATUS = "config_LocalDiskItem_fwStatus"
    SORT_PROP_CONFIG_LOCAL_DISK_ITEM_FW_VERSION = "config_LocalDiskItem_fwVersion"
    SORT_PROP_CONFIG_LOCAL_DISK_ITEM_ID = "config_LocalDiskItem_id"
    SORT_PROP_CONFIG_LOCAL_DISK_ITEM_LOCATION = "config_LocalDiskItem_location"
    SORT_PROP_CONFIG_LOCAL_DISK_ITEM_MODEL = "config_LocalDiskItem_model"
    SORT_PROP_CONFIG_LOCAL_DISK_ITEM_OPER_STATE = "config_LocalDiskItem_operState"
    SORT_PROP_CONFIG_LOCAL_DISK_ITEM_PID = "config_LocalDiskItem_pid"
    SORT_PROP_CONFIG_LOCAL_DISK_ITEM_PRESENCE = "config_LocalDiskItem_presence"
    SORT_PROP_CONFIG_LOCAL_DISK_ITEM_SERIAL = "config_LocalDiskItem_serial"
    SORT_PROP_CONFIG_LUN_ITEM_AFFECTED_SP = "config_LunItem_affectedSP"
    SORT_PROP_CONFIG_LUN_ITEM_BLOCK_SIZE = "config_LunItem_blockSize"
    SORT_PROP_CONFIG_LUN_ITEM_BOOTABLE = "config_LunItem_bootable"
    SORT_PROP_CONFIG_LUN_ITEM_COMPONENT_DN = "config_LunItem_componentDn"
    SORT_PROP_CONFIG_LUN_ITEM_CONFIG_STATE = "config_LunItem_configState"
    SORT_PROP_CONFIG_LUN_ITEM_DOMAIN_GROUP_DN = "config_LunItem_domainGroupDn"
    SORT_PROP_CONFIG_LUN_ITEM_DOMAIN_NAME = "config_LunItem_domainName"
    SORT_PROP_CONFIG_LUN_ITEM_DRIVE_STATE = "config_LunItem_driveState"
    SORT_PROP_CONFIG_LUN_ITEM_EQUIPMENT_TYPE = "config_LunItem_equipmentType"
    SORT_PROP_CONFIG_LUN_ITEM_ID = "config_LunItem_id"
    SORT_PROP_CONFIG_LUN_ITEM_LOCATION = "config_LunItem_location"
    SORT_PROP_CONFIG_LUN_ITEM_NAME = "config_LunItem_name"
    SORT_PROP_CONFIG_LUN_ITEM_NUMBER_OF_BLOCKS = "config_LunItem_numberOfBlocks"
    SORT_PROP_CONFIG_LUN_ITEM_OPER_STATE = "config_LunItem_operState"
    SORT_PROP_CONFIG_LUN_ITEM_PRESENCE = "config_LunItem_presence"
    SORT_PROP_CONFIG_LUN_ITEM_SIZE = "config_LunItem_size"
    SORT_PROP_CONFIG_LUN_ITEM_STORAGE_PROFILE = "config_LunItem_storageProfile"
    SORT_PROP_CONFIG_MANAGED_EP_IMPACT_RESPONSE_AFFECTED_CHASSIS_CNT = "config_ManagedEpImpactResponse_affectedChassisCnt"
    SORT_PROP_CONFIG_MANAGED_EP_IMPACT_RESPONSE_AFFECTED_SERVERS = "config_ManagedEpImpactResponse_affectedServers"
    SORT_PROP_CONFIG_MANAGED_EP_IMPACT_RESPONSE_APP_CONNECTOR_ID = "config_ManagedEpImpactResponse_appConnectorId"
    SORT_PROP_CONFIG_MANAGED_EP_IMPACT_RESPONSE_EP_DN = "config_ManagedEpImpactResponse_epDn"
    SORT_PROP_CONFIG_MANAGED_EP_IMPACT_RESPONSE_EP_NAME = "config_ManagedEpImpactResponse_epName"
    SORT_PROP_CONFIG_MANAGED_EP_IMPACT_RESPONSE_IMPACT_ANALYZER_ID = "config_ManagedEpImpactResponse_impactAnalyzerId"
    SORT_PROP_CONFIG_MANAGED_EP_IMPACT_RESPONSE_PROFILE_TYPE = "config_ManagedEpImpactResponse_profileType"
    SORT_PROP_CONFIG_MANAGED_EP_IMPACT_RESPONSE_REBOOT_REQUIRED = "config_ManagedEpImpactResponse_rebootRequired"
    SORT_PROP_CONFIG_MANAGED_EP_IMPACT_RESPONSE_SOURCE_CONNECTOR_ID = "config_ManagedEpImpactResponse_sourceConnectorId"
    SORT_PROP_CONFIG_MANAGED_EP_IMPACT_RESPONSE_STATE = "config_ManagedEpImpactResponse_state"
    SORT_PROP_CONFIG_MEMORY_ITEM_CAPACITY = "config_MemoryItem_capacity"
    SORT_PROP_CONFIG_MEMORY_ITEM_CLOCK = "config_MemoryItem_clock"
    SORT_PROP_CONFIG_MEMORY_ITEM_COMPONENT_DN = "config_MemoryItem_componentDn"
    SORT_PROP_CONFIG_MEMORY_ITEM_DOMAIN_GROUP_DN = "config_MemoryItem_domainGroupDn"
    SORT_PROP_CONFIG_MEMORY_ITEM_DOMAIN_NAME = "config_MemoryItem_domainName"
    SORT_PROP_CONFIG_MEMORY_ITEM_FAULT_LEVEL = "config_MemoryItem_faultLevel"
    SORT_PROP_CONFIG_MEMORY_ITEM_ID = "config_MemoryItem_id"
    SORT_PROP_CONFIG_MEMORY_ITEM_LOCATION = "config_MemoryItem_location"
    SORT_PROP_CONFIG_MEMORY_ITEM_LOCATOR = "config_MemoryItem_locator"
    SORT_PROP_CONFIG_MEMORY_ITEM_MODEL = "config_MemoryItem_model"
    SORT_PROP_CONFIG_MEMORY_ITEM_OPER_STATE = "config_MemoryItem_operState"
    SORT_PROP_CONFIG_MEMORY_ITEM_PID = "config_MemoryItem_pid"
    SORT_PROP_CONFIG_MEMORY_ITEM_POWER = "config_MemoryItem_power"
    SORT_PROP_CONFIG_MEMORY_ITEM_PRESENCE = "config_MemoryItem_presence"
    SORT_PROP_CONFIG_MEMORY_ITEM_SERIAL = "config_MemoryItem_serial"
    SORT_PROP_CONFIG_MEMORY_ITEM_THERMAL = "config_MemoryItem_thermal"
    SORT_PROP_CONFIG_MOTHERBOARD_ITEM_BIOS_FW_STATUS = "config_MotherboardItem_biosFwStatus"
    SORT_PROP_CONFIG_MOTHERBOARD_ITEM_BIOS_FW_VERSION = "config_MotherboardItem_biosFwVersion"
    SORT_PROP_CONFIG_MOTHERBOARD_ITEM_BOARD_CONTROLLER_FW_STATUS = "config_MotherboardItem_boardControllerFwStatus"
    SORT_PROP_CONFIG_MOTHERBOARD_ITEM_BOARD_CONTROLLER_FW_VERSION = "config_MotherboardItem_boardControllerFwVersion"
    SORT_PROP_CONFIG_MOTHERBOARD_ITEM_COMPONENT_DN = "config_MotherboardItem_componentDn"
    SORT_PROP_CONFIG_MOTHERBOARD_ITEM_DOMAIN_GROUP_DN = "config_MotherboardItem_domainGroupDn"
    SORT_PROP_CONFIG_MOTHERBOARD_ITEM_DOMAIN_NAME = "config_MotherboardItem_domainName"
    SORT_PROP_CONFIG_MOTHERBOARD_ITEM_FAULT_LEVEL = "config_MotherboardItem_faultLevel"
    SORT_PROP_CONFIG_MOTHERBOARD_ITEM_ID = "config_MotherboardItem_id"
    SORT_PROP_CONFIG_MOTHERBOARD_ITEM_LOCATION = "config_MotherboardItem_location"
    SORT_PROP_CONFIG_MOTHERBOARD_ITEM_MODEL = "config_MotherboardItem_model"
    SORT_PROP_CONFIG_MOTHERBOARD_ITEM_OPER_STATE = "config_MotherboardItem_operState"
    SORT_PROP_CONFIG_MOTHERBOARD_ITEM_POWER = "config_MotherboardItem_power"
    SORT_PROP_CONFIG_MOTHERBOARD_ITEM_SERIAL = "config_MotherboardItem_serial"
    SORT_PROP_CONFIG_MOTHERBOARD_ITEM_THERMAL = "config_MotherboardItem_thermal"
    SORT_PROP_CONFIG_NET_REF_ITEM_INBAND_POLICY_DN = "config_NetRefItem_inbandPolicyDn"
    SORT_PROP_CONFIG_NET_REF_ITEM_NAME = "config_NetRefItem_name"
    SORT_PROP_CONFIG_NET_REF_ITEM_NET_GROUP_DN = "config_NetRefItem_netGroupDn"
    SORT_PROP_CONFIG_NET_REF_ITEM_TYPE = "config_NetRefItem_type"
    SORT_PROP_CONFIG_ORG_ITEM_CONTEXT = "config_OrgItem_context"
    SORT_PROP_CONFIG_ORG_ITEM_NAME = "config_OrgItem_name"
    SORT_PROP_CONFIG_ORG_ITEM_ORG_DN = "config_OrgItem_orgDn"
    SORT_PROP_CONFIG_PSUITEM_COMPONENT_DN = "config_PSUItem_componentDn"
    SORT_PROP_CONFIG_PSUITEM_DOMAIN_GROUP_DN = "config_PSUItem_domainGroupDn"
    SORT_PROP_CONFIG_PSUITEM_DOMAIN_NAME = "config_PSUItem_domainName"
    SORT_PROP_CONFIG_PSUITEM_EQUIPMENT_TYPE = "config_PSUItem_equipmentType"
    SORT_PROP_CONFIG_PSUITEM_FAULT_LEVEL = "config_PSUItem_faultLevel"
    SORT_PROP_CONFIG_PSUITEM_ID = "config_PSUItem_id"
    SORT_PROP_CONFIG_PSUITEM_LOCATION = "config_PSUItem_location"
    SORT_PROP_CONFIG_PSUITEM_MODEL = "config_PSUItem_model"
    SORT_PROP_CONFIG_PSUITEM_OPER_STATE = "config_PSUItem_operState"
    SORT_PROP_CONFIG_PSUITEM_POWER = "config_PSUItem_power"
    SORT_PROP_CONFIG_PSUITEM_PRESENCE = "config_PSUItem_presence"
    SORT_PROP_CONFIG_PSUITEM_SERIAL = "config_PSUItem_serial"
    SORT_PROP_CONFIG_PSUITEM_THERMAL = "config_PSUItem_thermal"
    SORT_PROP_CONFIG_POLICY_USAGE_ITEM_CLASS_NAME = "config_PolicyUsageItem_className"
    SORT_PROP_CONFIG_POLICY_USAGE_ITEM_CONSUMER_DN = "config_PolicyUsageItem_consumerDn"
    SORT_PROP_CONFIG_POLICY_USAGE_ITEM_CONSUMER_NAME = "config_PolicyUsageItem_consumerName"
    SORT_PROP_CONFIG_PORT_ITEM_ADMIN_STATE = "config_PortItem_adminState"
    SORT_PROP_CONFIG_PORT_ITEM_COMPONENT_DN = "config_PortItem_componentDn"
    SORT_PROP_CONFIG_PORT_ITEM_DOMAIN_GROUP_DN = "config_PortItem_domainGroupDn"
    SORT_PROP_CONFIG_PORT_ITEM_DOMAIN_NAME = "config_PortItem_domainName"
    SORT_PROP_CONFIG_PORT_ITEM_EXP_MOD_ID = "config_PortItem_expModId"
    SORT_PROP_CONFIG_PORT_ITEM_FAULT_LEVEL = "config_PortItem_faultLevel"
    SORT_PROP_CONFIG_PORT_ITEM_FI_ID = "config_PortItem_fiId"
    SORT_PROP_CONFIG_PORT_ITEM_ID = "config_PortItem_id"
    SORT_PROP_CONFIG_PORT_ITEM_MAC = "config_PortItem_mac"
    SORT_PROP_CONFIG_PORT_ITEM_MODE = "config_PortItem_mode"
    SORT_PROP_CONFIG_PORT_ITEM_OPER_STATE = "config_PortItem_operState"
    SORT_PROP_CONFIG_PORT_ITEM_ROLE = "config_PortItem_role"
    SORT_PROP_CONFIG_PORT_ITEM_TYPE = "config_PortItem_type"
    SORT_PROP_CONFIG_SEARCH_OPTIONS_OBJECT_TYPE = "config_SearchOptions_objectType"
    SORT_PROP_CONFIG_SEARCH_OPTIONS_POLICY_OWNER = "config_SearchOptions_policyOwner"
    SORT_PROP_CONFIG_SEARCH_OPTIONS_SEARCH_TYPE = "config_SearchOptions_searchType"
    SORT_PROP_CONFIG_SEARCH_RESULT_CONVERTED_DN = "config_SearchResult_convertedDn"
    SORT_PROP_CONFIG_SEARCH_RESULT_DESCR = "config_SearchResult_descr"
    SORT_PROP_CONFIG_SEARCH_RESULT_DOMAIN_GROUP = "config_SearchResult_domainGroup"
    SORT_PROP_CONFIG_SEARCH_RESULT_DOMAIN_ID = "config_SearchResult_domainId"
    SORT_PROP_CONFIG_SEARCH_RESULT_DOMAIN_NAME = "config_SearchResult_domainName"
    SORT_PROP_CONFIG_SEARCH_RESULT_IS_RENAMEABLE = "config_SearchResult_isRenameable"
    SORT_PROP_CONFIG_SEARCH_RESULT_NAME = "config_SearchResult_name"
    SORT_PROP_CONFIG_SEARCH_RESULT_OBJECT_TYPE = "config_SearchResult_objectType"
    SORT_PROP_CONFIG_SEARCH_RESULT_PARENT_ORG_TYPE = "config_SearchResult_parentOrgType"
    SORT_PROP_CONFIG_SEARCH_RESULT_POLICY_DN = "config_SearchResult_policyDn"
    SORT_PROP_CONFIG_SEARCH_RESULT_POLICY_OWNER = "config_SearchResult_policyOwner"
    SORT_PROP_CONFIG_SERVER_FILTER_ASSOCIATION = "config_ServerFilter_association"
    SORT_PROP_CONFIG_SERVER_FILTER_CHASSIS_DN = "config_ServerFilter_chassisDn"
    SORT_PROP_CONFIG_SERVER_FILTER_CPU_ARCH = "config_ServerFilter_cpuArch"
    SORT_PROP_CONFIG_SERVER_FILTER_DECOMMISSIONED = "config_ServerFilter_decommissioned"
    SORT_PROP_CONFIG_SERVER_FILTER_DISCOVERY = "config_ServerFilter_discovery"
    SORT_PROP_CONFIG_SERVER_FILTER_DOMAIN_DN = "config_ServerFilter_domainDn"
    SORT_PROP_CONFIG_SERVER_FILTER_DOMAIN_GROUP_DN = "config_ServerFilter_domainGroupDn"
    SORT_PROP_CONFIG_SERVER_FILTER_DOMAIN_NAME = "config_ServerFilter_domainName"
    SORT_PROP_CONFIG_SERVER_FILTER_FAULT_LEVEL = "config_ServerFilter_faultLevel"
    SORT_PROP_CONFIG_SERVER_FILTER_FW_OPER_STATE = "config_ServerFilter_fwOperState"
    SORT_PROP_CONFIG_SERVER_FILTER_FW_VERSION = "config_ServerFilter_fwVersion"
    SORT_PROP_CONFIG_SERVER_FILTER_MODEL = "config_ServerFilter_model"
    SORT_PROP_CONFIG_SERVER_FILTER_NUM_OF_ADAPTORS = "config_ServerFilter_numOfAdaptors"
    SORT_PROP_CONFIG_SERVER_FILTER_NUM_OF_CORES = "config_ServerFilter_numOfCores"
    SORT_PROP_CONFIG_SERVER_FILTER_OPER_STATE = "config_ServerFilter_operState"
    SORT_PROP_CONFIG_SERVER_FILTER_TOTAL_MEMORY = "config_ServerFilter_totalMemory"
    SORT_PROP_CONFIG_SERVER_ITEM_ASSOCIATION = "config_ServerItem_association"
    SORT_PROP_CONFIG_SERVER_ITEM_DECOMMISSIONED = "config_ServerItem_decommissioned"
    SORT_PROP_CONFIG_SERVER_ITEM_DIAG_OPER_STATE = "config_ServerItem_diagOperState"
    SORT_PROP_CONFIG_SERVER_ITEM_DIAG_OVERALL_PROGRESS = "config_ServerItem_diagOverallProgress"
    SORT_PROP_CONFIG_SERVER_ITEM_DISCOVERY = "config_ServerItem_discovery"
    SORT_PROP_CONFIG_SERVER_ITEM_DOMAIN_CONNECTION_STATE = "config_ServerItem_domainConnectionState"
    SORT_PROP_CONFIG_SERVER_ITEM_DOMAIN_DN = "config_ServerItem_domainDn"
    SORT_PROP_CONFIG_SERVER_ITEM_DOMAIN_GROUP_DN = "config_ServerItem_domainGroupDn"
    SORT_PROP_CONFIG_SERVER_ITEM_DOMAIN_IPV4 = "config_ServerItem_domainIpv4"
    SORT_PROP_CONFIG_SERVER_ITEM_DOMAIN_IPV6 = "config_ServerItem_domainIpv6"
    SORT_PROP_CONFIG_SERVER_ITEM_DOMAIN_NAME = "config_ServerItem_domainName"
    SORT_PROP_CONFIG_SERVER_ITEM_DOMAIN_OPER_STATE = "config_ServerItem_domainOperState"
    SORT_PROP_CONFIG_SERVER_ITEM_DOMAIN_SUSPEND_STATE = "config_ServerItem_domainSuspendState"
    SORT_PROP_CONFIG_SERVER_ITEM_FAULT_LEVEL = "config_ServerItem_faultLevel"
    SORT_PROP_CONFIG_SERVER_ITEM_FW_OPER_STATE = "config_ServerItem_fwOperState"
    SORT_PROP_CONFIG_SERVER_ITEM_FW_VERSION = "config_ServerItem_fwVersion"
    SORT_PROP_CONFIG_SERVER_ITEM_LOCATOR_LED_OPER_STATE = "config_ServerItem_locatorLedOperState"
    SORT_PROP_CONFIG_SERVER_ITEM_MGMT_IP = "config_ServerItem_mgmtIp"
    SORT_PROP_CONFIG_SERVER_ITEM_MODEL = "config_ServerItem_model"
    SORT_PROP_CONFIG_SERVER_ITEM_NUM_OF_ADAPTORS = "config_ServerItem_numOfAdaptors"
    SORT_PROP_CONFIG_SERVER_ITEM_NUM_OF_CORES = "config_ServerItem_numOfCores"
    SORT_PROP_CONFIG_SERVER_ITEM_OPER_POWER = "config_ServerItem_operPower"
    SORT_PROP_CONFIG_SERVER_ITEM_OPER_STATE = "config_ServerItem_operState"
    SORT_PROP_CONFIG_SERVER_ITEM_SERIAL = "config_ServerItem_serial"
    SORT_PROP_CONFIG_SERVER_ITEM_SERVER_DN = "config_ServerItem_serverDn"
    SORT_PROP_CONFIG_SERVER_ITEM_SERVER_ID = "config_ServerItem_serverId"
    SORT_PROP_CONFIG_SERVER_ITEM_SERVICE_PROFILE = "config_ServerItem_serviceProfile"
    SORT_PROP_CONFIG_SERVER_ITEM_TOTAL_MEMORY = "config_ServerItem_totalMemory"
    SORT_PROP_CONFIG_SERVICE_PROFILE_FILTER_ASSIGN_STATE = "config_ServiceProfileFilter_assignState"
    SORT_PROP_CONFIG_SERVICE_PROFILE_FILTER_ASSOC_STATE = "config_ServiceProfileFilter_assocState"
    SORT_PROP_CONFIG_SERVICE_PROFILE_FILTER_FAULT_LEVEL = "config_ServiceProfileFilter_faultLevel"
    SORT_PROP_CONFIG_SERVICE_PROFILE_FILTER_OPER_STATE = "config_ServiceProfileFilter_operState"
    SORT_PROP_CONFIG_SERVICE_PROFILE_FILTER_OWNER = "config_ServiceProfileFilter_owner"
    SORT_PROP_CONFIG_SERVICE_PROFILE_FILTER_TYPE = "config_ServiceProfileFilter_type"
    SORT_PROP_CONFIG_SORTER_DIRECTION = "config_Sorter_direction"
    SORT_PROP_CONFIG_SORTER_SORT_CLASS = "config_Sorter_sortClass"
    SORT_PROP_CONFIG_SORTER_SORT_PROP = "config_Sorter_sortProp"
    SORT_PROP_CONFIG_SPOT_LIGHT_ITEM_COMPOSITE_ID = "config_SpotLightItem_compositeId"
    SORT_PROP_CONFIG_SPOT_LIGHT_ITEM_OPER_CATEGORY = "config_SpotLightItem_operCategory"
    SORT_PROP_CONFIG_SPOT_LIGHT_ITEM_OPER_DN = "config_SpotLightItem_operDn"
    SORT_PROP_CONFIG_SPOT_LIGHT_ITEM_OPER_DOMAIN_DN = "config_SpotLightItem_operDomainDn"
    SORT_PROP_CONFIG_SPOT_LIGHT_ITEM_OPER_DOMAIN_GROUP_DN = "config_SpotLightItem_operDomainGroupDn"
    SORT_PROP_CONFIG_SPOT_LIGHT_ITEM_OPER_ID = "config_SpotLightItem_operId"
    SORT_PROP_CONFIG_SPOT_LIGHT_ITEM_OPER_NAME = "config_SpotLightItem_operName"
    SORT_PROP_CONFIG_SPOT_LIGHT_ITEM_OPER_ORG_DN = "config_SpotLightItem_operOrgDn"
    SORT_PROP_CONFIG_SPOT_LIGHT_ITEM_OPER_SEARCH_FIELD = "config_SpotLightItem_operSearchField"
    SORT_PROP_CONFIG_SPOT_LIGHT_ITEM_OPER_SEC_SEARCH_FIELD = "config_SpotLightItem_operSecSearchField"
    SORT_PROP_CONFIG_SPOT_LIGHT_ITEM_OPER_SRC_DME = "config_SpotLightItem_operSrcDme"
    SORT_PROP_CONFIG_SPOT_LIGHT_ITEM_OPER_SUB_TYPE = "config_SpotLightItem_operSubType"
    SORT_PROP_CONFIG_SPOT_LIGHT_ITEM_OPER_THIRD_SEARCH_FIELD = "config_SpotLightItem_operThirdSearchField"
    SORT_PROP_CONFIG_SPOT_LIGHT_ITEM_OPER_TYPE = "config_SpotLightItem_operType"
    SORT_PROP_CONFIG_SPOT_LIGHT_ITEM_SCORE = "config_SpotLightItem_score"
    SORT_PROP_CONFIG_STORAGE_ARRAY_PROFILE_FILTER_ASSIGN_STATE = "config_StorageArrayProfileFilter_assignState"
    SORT_PROP_CONFIG_STORAGE_ARRAY_PROFILE_FILTER_ASSOC_STATE = "config_StorageArrayProfileFilter_assocState"
    SORT_PROP_CONFIG_STORAGE_ARRAY_PROFILE_FILTER_FAULT_LEVEL = "config_StorageArrayProfileFilter_faultLevel"
    SORT_PROP_CONFIG_STORAGE_ARRAY_PROFILE_FILTER_OPER_STATE = "config_StorageArrayProfileFilter_operState"
    SORT_PROP_CONFIG_STORAGE_ARRAY_PROFILE_FILTER_OWNER = "config_StorageArrayProfileFilter_owner"
    SORT_PROP_CONFIG_STORAGE_ARRAY_PROFILE_FILTER_TYPE = "config_StorageArrayProfileFilter_type"
    SORT_PROP_CONFIG_STORAGE_BLADE_FILTER_DECOMMISSIONED = "config_StorageBladeFilter_decommissioned"
    SORT_PROP_CONFIG_STORAGE_BLADE_FILTER_DOMAIN_DN = "config_StorageBladeFilter_domainDn"
    SORT_PROP_CONFIG_STORAGE_BLADE_FILTER_DOMAIN_GROUP_DN = "config_StorageBladeFilter_domainGroupDn"
    SORT_PROP_CONFIG_STORAGE_BLADE_FILTER_DOMAIN_NAME = "config_StorageBladeFilter_domainName"
    SORT_PROP_CONFIG_STORAGE_BLADE_FILTER_FAULT_LEVEL = "config_StorageBladeFilter_faultLevel"
    SORT_PROP_CONFIG_STORAGE_BLADE_FILTER_MODEL = "config_StorageBladeFilter_model"
    SORT_PROP_CONFIG_STORAGE_BLADE_FILTER_OPER_STATE = "config_StorageBladeFilter_operState"
    SORT_PROP_CONFIG_STORAGE_ITEM_ASSIGNED_TO_DN = "config_StorageItem_assignedToDn"
    SORT_PROP_CONFIG_STORAGE_ITEM_BLADE_OPER_STATE = "config_StorageItem_bladeOperState"
    SORT_PROP_CONFIG_STORAGE_ITEM_CARTRIDGE_OPER_STATE = "config_StorageItem_cartridgeOperState"
    SORT_PROP_CONFIG_STORAGE_ITEM_CHASSIS_ID = "config_StorageItem_chassisId"
    SORT_PROP_CONFIG_STORAGE_ITEM_DECOMMISSIONED = "config_StorageItem_decommissioned"
    SORT_PROP_CONFIG_STORAGE_ITEM_DOMAIN_CONNECTION_STATE = "config_StorageItem_domainConnectionState"
    SORT_PROP_CONFIG_STORAGE_ITEM_DOMAIN_DN = "config_StorageItem_domainDn"
    SORT_PROP_CONFIG_STORAGE_ITEM_DOMAIN_GROUP_DN = "config_StorageItem_domainGroupDn"
    SORT_PROP_CONFIG_STORAGE_ITEM_DOMAIN_IPV4 = "config_StorageItem_domainIpv4"
    SORT_PROP_CONFIG_STORAGE_ITEM_DOMAIN_IPV6 = "config_StorageItem_domainIpv6"
    SORT_PROP_CONFIG_STORAGE_ITEM_DOMAIN_NAME = "config_StorageItem_domainName"
    SORT_PROP_CONFIG_STORAGE_ITEM_DOMAIN_OPER_STATE = "config_StorageItem_domainOperState"
    SORT_PROP_CONFIG_STORAGE_ITEM_DOMAIN_SUSPEND_STATE = "config_StorageItem_domainSuspendState"
    SORT_PROP_CONFIG_STORAGE_ITEM_FAULT_LEVEL = "config_StorageItem_faultLevel"
    SORT_PROP_CONFIG_STORAGE_ITEM_MODEL = "config_StorageItem_model"
    SORT_PROP_CONFIG_STORAGE_ITEM_NUM_OF_CONTROLLERS = "config_StorageItem_numOfControllers"
    SORT_PROP_CONFIG_STORAGE_ITEM_NUM_OF_ENCLOSURES = "config_StorageItem_numOfEnclosures"
    SORT_PROP_CONFIG_STORAGE_ITEM_NUM_OF_SERVER_UNITS = "config_StorageItem_numOfServerUnits"
    SORT_PROP_CONFIG_STORAGE_ITEM_SERIAL = "config_StorageItem_serial"
    SORT_PROP_CONFIG_STORAGE_ITEM_SLOT_ID = "config_StorageItem_slotId"
    SORT_PROP_CONFIG_STORAGE_ITEM_STORAGE_DN = "config_StorageItem_storageDn"
    SORT_PROP_CONFIG_STORAGE_ITEM_STORAGE_TYPE = "config_StorageItem_storageType"
    SORT_PROP_CONFIG_UCIMPACT_AFFECTED_OBJ = "config_UCImpact_affectedObj"
    SORT_PROP_CONFIG_UCIMPACT_AFFECTED_SERVER = "config_UCImpact_affectedServer"
    SORT_PROP_CONFIG_UCIMPACT_CHANGES = "config_UCImpact_changes"
    SORT_PROP_CONFIG_UCIMPACT_CONFIG_ISSUES = "config_UCImpact_configIssues"
    SORT_PROP_CONFIG_UCIMPACT_CONFIG_QUALIFIER = "config_UCImpact_configQualifier"
    SORT_PROP_CONFIG_UCIMPACT_CONFIG_STATE = "config_UCImpact_configState"
    SORT_PROP_CONFIG_UCIMPACT_DEPLOYMENT_MODE = "config_UCImpact_deploymentMode"
    SORT_PROP_CONFIG_UCIMPACT_ISSUE_TYPE = "config_UCImpact_issueType"
    SORT_PROP_CONFIG_UCIMPACT_NAME = "config_UCImpact_name"
    SORT_PROP_CONFIG_UCIMPACT_REBOOT_REQUIRED = "config_UCImpact_rebootRequired"
    SORT_PROP_CONSUMER_INST_FSM_STAGE_DESCR = "consumer_InstFsmStage_descr"
    SORT_PROP_CONSUMER_INST_FSM_STAGE_LAST_UPDATE_TIME = "consumer_InstFsmStage_lastUpdateTime"
    SORT_PROP_CONSUMER_INST_FSM_STAGE_NAME = "consumer_InstFsmStage_name"
    SORT_PROP_CONSUMER_INST_FSM_STAGE_ORDER = "consumer_InstFsmStage_order"
    SORT_PROP_CONSUMER_INST_FSM_STAGE_RETRY = "consumer_InstFsmStage_retry"
    SORT_PROP_CONSUMER_INST_FSM_STAGE_STAGE_STATUS = "consumer_InstFsmStage_stageStatus"
    SORT_PROP_CONSUMER_INST_FSM_TASK_COMPLETION = "consumer_InstFsmTask_completion"
    SORT_PROP_CONSUMER_INST_FSM_TASK_FLAGS = "consumer_InstFsmTask_flags"
    SORT_PROP_CONSUMER_INST_FSM_TASK_ITEM = "consumer_InstFsmTask_item"
    SORT_PROP_CONSUMER_INST_FSM_TASK_SEQ_ID = "consumer_InstFsmTask_seqId"
    SORT_PROP_CONSUMER_INST_FSM_COMPLETION_TIME = "consumer_InstFsm_completionTime"
    SORT_PROP_CONSUMER_INST_FSM_CURRENT_FSM = "consumer_InstFsm_currentFsm"
    SORT_PROP_CONSUMER_INST_FSM_DESCR = "consumer_InstFsm_descr"
    SORT_PROP_CONSUMER_INST_FSM_FSM_INSTANCE_ID = "consumer_InstFsm_fsmInstanceId"
    SORT_PROP_CONSUMER_INST_FSM_FSM_STATUS = "consumer_InstFsm_fsmStatus"
    SORT_PROP_CONSUMER_INST_FSM_PROGRESS = "consumer_InstFsm_progress"
    SORT_PROP_CONSUMER_INST_FSM_RMT_ERR_CODE = "consumer_InstFsm_rmtErrCode"
    SORT_PROP_CONSUMER_INST_FSM_RMT_ERR_DESCR = "consumer_InstFsm_rmtErrDescr"
    SORT_PROP_CONSUMER_INST_FSM_RMT_RSLT = "consumer_InstFsm_rmtRslt"
    SORT_PROP_CONSUMER_INST_ADMIN_STATE = "consumer_Inst_adminState"
    SORT_PROP_CONSUMER_INST_CONN_PROTOCOL = "consumer_Inst_connProtocol"
    SORT_PROP_CONSUMER_INST_CONNECTOR_ID = "consumer_Inst_connectorId"
    SORT_PROP_CONSUMER_INST_DOMAIN_GROUP_DN = "consumer_Inst_domainGroupDn"
    SORT_PROP_CONSUMER_INST_FSM_DESCR = "consumer_Inst_fsmDescr"
    SORT_PROP_CONSUMER_INST_FSM_PREV = "consumer_Inst_fsmPrev"
    SORT_PROP_CONSUMER_INST_FSM_PROGR = "consumer_Inst_fsmProgr"
    SORT_PROP_CONSUMER_INST_FSM_RMT_INV_ERR_CODE = "consumer_Inst_fsmRmtInvErrCode"
    SORT_PROP_CONSUMER_INST_FSM_RMT_INV_ERR_DESCR = "consumer_Inst_fsmRmtInvErrDescr"
    SORT_PROP_CONSUMER_INST_FSM_RMT_INV_RSLT = "consumer_Inst_fsmRmtInvRslt"
    SORT_PROP_CONSUMER_INST_FSM_STAGE_DESCR = "consumer_Inst_fsmStageDescr"
    SORT_PROP_CONSUMER_INST_FSM_STAMP = "consumer_Inst_fsmStamp"
    SORT_PROP_CONSUMER_INST_FSM_STATUS = "consumer_Inst_fsmStatus"
    SORT_PROP_CONSUMER_INST_FSM_TRY = "consumer_Inst_fsmTry"
    SORT_PROP_CONSUMER_INST_GUID = "consumer_Inst_guid"
    SORT_PROP_CONSUMER_INST_IP = "consumer_Inst_ip"
    SORT_PROP_CONSUMER_INST_NAME = "consumer_Inst_name"
    SORT_PROP_CONSUMER_INST_OPER_STATE = "consumer_Inst_operState"
    SORT_PROP_CONSUMER_INST_REPOSITORY_NAME = "consumer_Inst_repositoryName"
    SORT_PROP_CONSUMER_INST_VERSION = "consumer_Inst_version"
    SORT_PROP_CONTROLLER_EP_FSM_STAGE_DESCR = "controller_EpFsmStage_descr"
    SORT_PROP_CONTROLLER_EP_FSM_STAGE_LAST_UPDATE_TIME = "controller_EpFsmStage_lastUpdateTime"
    SORT_PROP_CONTROLLER_EP_FSM_STAGE_NAME = "controller_EpFsmStage_name"
    SORT_PROP_CONTROLLER_EP_FSM_STAGE_ORDER = "controller_EpFsmStage_order"
    SORT_PROP_CONTROLLER_EP_FSM_STAGE_RETRY = "controller_EpFsmStage_retry"
    SORT_PROP_CONTROLLER_EP_FSM_STAGE_STAGE_STATUS = "controller_EpFsmStage_stageStatus"
    SORT_PROP_CONTROLLER_EP_FSM_TASK_COMPLETION = "controller_EpFsmTask_completion"
    SORT_PROP_CONTROLLER_EP_FSM_TASK_FLAGS = "controller_EpFsmTask_flags"
    SORT_PROP_CONTROLLER_EP_FSM_TASK_ITEM = "controller_EpFsmTask_item"
    SORT_PROP_CONTROLLER_EP_FSM_TASK_SEQ_ID = "controller_EpFsmTask_seqId"
    SORT_PROP_CONTROLLER_EP_FSM_COMPLETION_TIME = "controller_EpFsm_completionTime"
    SORT_PROP_CONTROLLER_EP_FSM_CURRENT_FSM = "controller_EpFsm_currentFsm"
    SORT_PROP_CONTROLLER_EP_FSM_DESCR = "controller_EpFsm_descr"
    SORT_PROP_CONTROLLER_EP_FSM_FSM_INSTANCE_ID = "controller_EpFsm_fsmInstanceId"
    SORT_PROP_CONTROLLER_EP_FSM_FSM_STATUS = "controller_EpFsm_fsmStatus"
    SORT_PROP_CONTROLLER_EP_FSM_PROGRESS = "controller_EpFsm_progress"
    SORT_PROP_CONTROLLER_EP_FSM_RMT_ERR_CODE = "controller_EpFsm_rmtErrCode"
    SORT_PROP_CONTROLLER_EP_FSM_RMT_ERR_DESCR = "controller_EpFsm_rmtErrDescr"
    SORT_PROP_CONTROLLER_EP_FSM_RMT_RSLT = "controller_EpFsm_rmtRslt"
    SORT_PROP_CONTROLLER_EP_FSM_DESCR = "controller_Ep_fsmDescr"
    SORT_PROP_CONTROLLER_EP_FSM_PREV = "controller_Ep_fsmPrev"
    SORT_PROP_CONTROLLER_EP_FSM_PROGR = "controller_Ep_fsmProgr"
    SORT_PROP_CONTROLLER_EP_FSM_RMT_INV_ERR_CODE = "controller_Ep_fsmRmtInvErrCode"
    SORT_PROP_CONTROLLER_EP_FSM_RMT_INV_ERR_DESCR = "controller_Ep_fsmRmtInvErrDescr"
    SORT_PROP_CONTROLLER_EP_FSM_RMT_INV_RSLT = "controller_Ep_fsmRmtInvRslt"
    SORT_PROP_CONTROLLER_EP_FSM_STAGE_DESCR = "controller_Ep_fsmStageDescr"
    SORT_PROP_CONTROLLER_EP_FSM_STAMP = "controller_Ep_fsmStamp"
    SORT_PROP_CONTROLLER_EP_FSM_STATUS = "controller_Ep_fsmStatus"
    SORT_PROP_CONTROLLER_EP_FSM_TRY = "controller_Ep_fsmTry"
    SORT_PROP_CPMAINT_ACK_ACKED = "cpmaint_Ack_acked"
    SORT_PROP_CPMAINT_ACK_ACKED_BY = "cpmaint_Ack_ackedBy"
    SORT_PROP_CPMAINT_ACK_ADMIN_STATE = "cpmaint_Ack_adminState"
    SORT_PROP_CPMAINT_ACK_AUTO_DELETE = "cpmaint_Ack_autoDelete"
    SORT_PROP_CPMAINT_ACK_CHANGE_BY = "cpmaint_Ack_changeBy"
    SORT_PROP_CPMAINT_ACK_CHANGE_DETAILS = "cpmaint_Ack_changeDetails"
    SORT_PROP_CPMAINT_ACK_CHANGE_MODE = "cpmaint_Ack_changeMode"
    SORT_PROP_CPMAINT_ACK_CHANGES = "cpmaint_Ack_changes"
    SORT_PROP_CPMAINT_ACK_CONFIG_ISSUES = "cpmaint_Ack_configIssues"
    SORT_PROP_CPMAINT_ACK_DEPLOYMENT_MODE = "cpmaint_Ack_deploymentMode"
    SORT_PROP_CPMAINT_ACK_DESCR = "cpmaint_Ack_descr"
    SORT_PROP_CPMAINT_ACK_DISR = "cpmaint_Ack_disr"
    SORT_PROP_CPMAINT_ACK_IGNORE_CAP = "cpmaint_Ack_ignoreCap"
    SORT_PROP_CPMAINT_ACK_INT_ID = "cpmaint_Ack_intId"
    SORT_PROP_CPMAINT_ACK_MODIFIED = "cpmaint_Ack_modified"
    SORT_PROP_CPMAINT_ACK_NAME = "cpmaint_Ack_name"
    SORT_PROP_CPMAINT_ACK_OLD_CHASSIS_DN = "cpmaint_Ack_oldChassisDn"
    SORT_PROP_CPMAINT_ACK_OPER_SCHEDULER = "cpmaint_Ack_operScheduler"
    SORT_PROP_CPMAINT_ACK_OPER_STATE = "cpmaint_Ack_operState"
    SORT_PROP_CPMAINT_ACK_POLICY_LEVEL = "cpmaint_Ack_policyLevel"
    SORT_PROP_CPMAINT_ACK_POLICY_OWNER = "cpmaint_Ack_policyOwner"
    SORT_PROP_CPMAINT_ACK_PREV_OPER_STATE = "cpmaint_Ack_prevOperState"
    SORT_PROP_CPMAINT_ACK_SCHEDULER = "cpmaint_Ack_scheduler"
    SORT_PROP_CPMAINT_ACK_TRIGGER_CONFIG_STATE = "cpmaint_Ack_triggerConfigState"
    SORT_PROP_CPMAINT_MAINT_POLICY_DESCR = "cpmaint_MaintPolicy_descr"
    SORT_PROP_CPMAINT_MAINT_POLICY_INT_ID = "cpmaint_MaintPolicy_intId"
    SORT_PROP_CPMAINT_MAINT_POLICY_NAME = "cpmaint_MaintPolicy_name"
    SORT_PROP_CPMAINT_MAINT_POLICY_OPER_SCHED_NAME = "cpmaint_MaintPolicy_operSchedName"
    SORT_PROP_CPMAINT_MAINT_POLICY_POLICY_LEVEL = "cpmaint_MaintPolicy_policyLevel"
    SORT_PROP_CPMAINT_MAINT_POLICY_POLICY_OWNER = "cpmaint_MaintPolicy_policyOwner"
    SORT_PROP_CPMAINT_MAINT_POLICY_SCHED_NAME = "cpmaint_MaintPolicy_schedName"
    SORT_PROP_CPMAINT_MAINT_POLICY_TRIGGER_CONFIG = "cpmaint_MaintPolicy_triggerConfig"
    SORT_PROP_CPMAINT_MAINT_POLICY_UPTIME_DISR = "cpmaint_MaintPolicy_uptimeDisr"
    SORT_PROP_DCX_PATH_PROTECTION_PROT_PEER_ID = "dcx_PathProtection_protPeerId"
    SORT_PROP_DCX_PATH_PROTECTION_PROT_ROLE = "dcx_PathProtection_protRole"
    SORT_PROP_DCX_STATEFUL_END_POINT_ADMIN_STATE = "dcx_StatefulEndPoint_adminState"
    SORT_PROP_DCX_VIF_ADMIN_STATE = "dcx_VIf_adminState"
    SORT_PROP_DCX_VIF_COOKIE = "dcx_VIf_cookie"
    SORT_PROP_DCX_VIF_EP_DN = "dcx_VIf_epDn"
    SORT_PROP_DCX_VIF_ID = "dcx_VIf_id"
    SORT_PROP_DCX_VIF_IF_ROLE = "dcx_VIf_ifRole"
    SORT_PROP_DCX_VIF_IF_TYPE = "dcx_VIf_ifType"
    SORT_PROP_DCX_VIF_INST_TYPE = "dcx_VIf_instType"
    SORT_PROP_DCX_VIF_LC = "dcx_VIf_lc"
    SORT_PROP_DCX_VIF_LINK_STATE = "dcx_VIf_linkState"
    SORT_PROP_DCX_VIF_LOCALE = "dcx_VIf_locale"
    SORT_PROP_DCX_VIF_NAME = "dcx_VIf_name"
    SORT_PROP_DCX_VIF_OPER_STATE = "dcx_VIf_operState"
    SORT_PROP_DCX_VIF_PEER_DN = "dcx_VIf_peerDn"
    SORT_PROP_DCX_VIF_PROT_PEER_ID = "dcx_VIf_protPeerId"
    SORT_PROP_DCX_VIF_PROT_ROLE = "dcx_VIf_protRole"
    SORT_PROP_DCX_VIF_PROT_STATE = "dcx_VIf_protState"
    SORT_PROP_DCX_VIF_QOS_CONTROL = "dcx_VIf_qosControl"
    SORT_PROP_DCX_VIF_STATE = "dcx_VIf_state"
    SORT_PROP_DCX_VIF_SWITCH_ID = "dcx_VIf_switchId"
    SORT_PROP_DCX_VIF_TAG = "dcx_VIf_tag"
    SORT_PROP_DCX_VIF_TRANSPORT = "dcx_VIf_transport"
    SORT_PROP_DCX_VIF_TYPE = "dcx_VIf_type"
    SORT_PROP_DCX_VC_ADMIN_STATE = "dcx_Vc_adminState"
    SORT_PROP_DCX_VC_BORDER_AGGR_PORT_ID = "dcx_Vc_borderAggrPortId"
    SORT_PROP_DCX_VC_BORDER_PORT_ID = "dcx_Vc_borderPortId"
    SORT_PROP_DCX_VC_BORDER_SLOT_ID = "dcx_Vc_borderSlotId"
    SORT_PROP_DCX_VC_BORDER_VFC_ID = "dcx_Vc_borderVfcId"
    SORT_PROP_DCX_VC_CDP = "dcx_Vc_cdp"
    SORT_PROP_DCX_VC_COOKIE = "dcx_Vc_cookie"
    SORT_PROP_DCX_VC_COS = "dcx_Vc_cos"
    SORT_PROP_DCX_VC_DERIVED_FROM_ID = "dcx_Vc_derivedFromId"
    SORT_PROP_DCX_VC_ENCAP = "dcx_Vc_encap"
    SORT_PROP_DCX_VC_FCOE_ID = "dcx_Vc_fcoeId"
    SORT_PROP_DCX_VC_FORGE_MAC = "dcx_Vc_forgeMac"
    SORT_PROP_DCX_VC_ID = "dcx_Vc_id"
    SORT_PROP_DCX_VC_INST_TYPE = "dcx_Vc_instType"
    SORT_PROP_DCX_VC_LC = "dcx_Vc_lc"
    SORT_PROP_DCX_VC_LINK_STATE = "dcx_Vc_linkState"
    SORT_PROP_DCX_VC_LLDP = "dcx_Vc_lldp"
    SORT_PROP_DCX_VC_LOCALE = "dcx_Vc_locale"
    SORT_PROP_DCX_VC_MAC_REGISTER_MODE = "dcx_Vc_macRegisterMode"
    SORT_PROP_DCX_VC_MON_TRAF_DIR = "dcx_Vc_monTrafDir"
    SORT_PROP_DCX_VC_NAME = "dcx_Vc_name"
    SORT_PROP_DCX_VC_OPER_BORDER_AGGR_PORT_ID = "dcx_Vc_operBorderAggrPortId"
    SORT_PROP_DCX_VC_OPER_BORDER_PORT_ID = "dcx_Vc_operBorderPortId"
    SORT_PROP_DCX_VC_OPER_BORDER_SLOT_ID = "dcx_Vc_operBorderSlotId"
    SORT_PROP_DCX_VC_OPER_STATE = "dcx_Vc_operState"
    SORT_PROP_DCX_VC_PEER_ID = "dcx_Vc_peerId"
    SORT_PROP_DCX_VC_PROT_STATE = "dcx_Vc_protState"
    SORT_PROP_DCX_VC_QOS_POLICY_DN = "dcx_Vc_qosPolicyDn"
    SORT_PROP_DCX_VC_QOS_POLICY_ID = "dcx_Vc_qosPolicyId"
    SORT_PROP_DCX_VC_ROLE = "dcx_Vc_role"
    SORT_PROP_DCX_VC_STATE = "dcx_Vc_state"
    SORT_PROP_DCX_VC_STATE_QUAL = "dcx_Vc_stateQual"
    SORT_PROP_DCX_VC_SWITCH_ID = "dcx_Vc_switchId"
    SORT_PROP_DCX_VC_TAG = "dcx_Vc_tag"
    SORT_PROP_DCX_VC_TRANSPORT = "dcx_Vc_transport"
    SORT_PROP_DCX_VC_TYPE = "dcx_Vc_type"
    SORT_PROP_DCX_VC_UPLINK_FAIL_ACTION = "dcx_Vc_uplinkFailAction"
    SORT_PROP_DCX_VC_VNIC = "dcx_Vc_vnic"
    SORT_PROP_DIAG_CTRL_ADMIN_STATE = "diag_Ctrl_adminState"
    SORT_PROP_DIAG_CTRL_END_TS = "diag_Ctrl_endTs"
    SORT_PROP_DIAG_CTRL_END_TS_M = "diag_Ctrl_endTsM"
    SORT_PROP_DIAG_CTRL_ERROR_DESCR = "diag_Ctrl_errorDescr"
    SORT_PROP_DIAG_CTRL_OPER_QUALIFIER = "diag_Ctrl_operQualifier"
    SORT_PROP_DIAG_CTRL_OPER_STATE = "diag_Ctrl_operState"
    SORT_PROP_DIAG_CTRL_START_TS = "diag_Ctrl_startTs"
    SORT_PROP_DIAG_CTRL_START_TS_M = "diag_Ctrl_startTsM"
    SORT_PROP_DIAG_LOG_EP_LOG_DN = "diag_LogEp_logDn"
    SORT_PROP_DIAG_LOG_EP_SWITCH_ID = "diag_LogEp_switchId"
    SORT_PROP_DIAG_MEMORY_TEST_CPU_FILTER = "diag_MemoryTest_cpuFilter"
    SORT_PROP_DIAG_MEMORY_TEST_ID = "diag_MemoryTest_id"
    SORT_PROP_DIAG_MEMORY_TEST_LOOP_COUNT = "diag_MemoryTest_loopCount"
    SORT_PROP_DIAG_MEMORY_TEST_MEM_CHUNK_SIZE = "diag_MemoryTest_memChunkSize"
    SORT_PROP_DIAG_MEMORY_TEST_MEM_SIZE = "diag_MemoryTest_memSize"
    SORT_PROP_DIAG_MEMORY_TEST_ORDER = "diag_MemoryTest_order"
    SORT_PROP_DIAG_MEMORY_TEST_PATTERN = "diag_MemoryTest_pattern"
    SORT_PROP_DIAG_MEMORY_TEST_TYPE = "diag_MemoryTest_type"
    SORT_PROP_DIAG_RSLT_DESCR = "diag_Rslt_descr"
    SORT_PROP_DIAG_RSLT_END_TS = "diag_Rslt_endTs"
    SORT_PROP_DIAG_RSLT_EST_PROG_WEIGHT = "diag_Rslt_estProgWeight"
    SORT_PROP_DIAG_RSLT_ID = "diag_Rslt_id"
    SORT_PROP_DIAG_RSLT_PROGRESS = "diag_Rslt_progress"
    SORT_PROP_DIAG_RSLT_RESULT = "diag_Rslt_result"
    SORT_PROP_DIAG_RSLT_RSLT_STATUS = "diag_Rslt_rsltStatus"
    SORT_PROP_DIAG_RSLT_START_TS = "diag_Rslt_startTs"
    SORT_PROP_DIAG_RSLT_TEST_DN = "diag_Rslt_testDn"
    SORT_PROP_DIAG_RSLT_TEST_TYPE = "diag_Rslt_testType"
    SORT_PROP_DIAG_RUN_POLICY_DESCR = "diag_RunPolicy_descr"
    SORT_PROP_DIAG_RUN_POLICY_FAILURE_ACTION = "diag_RunPolicy_failureAction"
    SORT_PROP_DIAG_RUN_POLICY_INT_ID = "diag_RunPolicy_intId"
    SORT_PROP_DIAG_RUN_POLICY_NAME = "diag_RunPolicy_name"
    SORT_PROP_DIAG_RUN_POLICY_POLICY_LEVEL = "diag_RunPolicy_policyLevel"
    SORT_PROP_DIAG_RUN_POLICY_POLICY_OWNER = "diag_RunPolicy_policyOwner"
    SORT_PROP_DIAG_RUN_POLICY_SUCCESS_ACTION = "diag_RunPolicy_successAction"
    SORT_PROP_DIAG_SRV_CAP_PROVIDER_DEPRECATED = "diag_SrvCapProvider_deprecated"
    SORT_PROP_DIAG_SRV_CAP_PROVIDER_GENCOUNT = "diag_SrvCapProvider_gencount"
    SORT_PROP_DIAG_SRV_CAP_PROVIDER_MGMT_PLANE_VER = "diag_SrvCapProvider_mgmtPlaneVer"
    SORT_PROP_DIAG_SRV_CAP_PROVIDER_MODEL = "diag_SrvCapProvider_model"
    SORT_PROP_DIAG_SRV_CAP_PROVIDER_PROM_CARD_TYPE = "diag_SrvCapProvider_promCardType"
    SORT_PROP_DIAG_SRV_CAP_PROVIDER_REVISION = "diag_SrvCapProvider_revision"
    SORT_PROP_DIAG_SRV_CAP_PROVIDER_VENDOR = "diag_SrvCapProvider_vendor"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_STAGE_DESCR = "diag_SrvCtrlOperationFsmStage_descr"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_STAGE_LAST_UPDATE_TIME = "diag_SrvCtrlOperationFsmStage_lastUpdateTime"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_STAGE_NAME = "diag_SrvCtrlOperationFsmStage_name"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_STAGE_ORDER = "diag_SrvCtrlOperationFsmStage_order"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_STAGE_RETRY = "diag_SrvCtrlOperationFsmStage_retry"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_STAGE_STAGE_STATUS = "diag_SrvCtrlOperationFsmStage_stageStatus"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_TASK_COMPLETION = "diag_SrvCtrlOperationFsmTask_completion"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_TASK_FLAGS = "diag_SrvCtrlOperationFsmTask_flags"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_TASK_ITEM = "diag_SrvCtrlOperationFsmTask_item"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_TASK_SEQ_ID = "diag_SrvCtrlOperationFsmTask_seqId"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_COMPLETION_TIME = "diag_SrvCtrlOperationFsm_completionTime"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_CURRENT_FSM = "diag_SrvCtrlOperationFsm_currentFsm"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_DESCR = "diag_SrvCtrlOperationFsm_descr"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_FSM_INSTANCE_ID = "diag_SrvCtrlOperationFsm_fsmInstanceId"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_FSM_STATUS = "diag_SrvCtrlOperationFsm_fsmStatus"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_PROGRESS = "diag_SrvCtrlOperationFsm_progress"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_RMT_ERR_CODE = "diag_SrvCtrlOperationFsm_rmtErrCode"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_RMT_ERR_DESCR = "diag_SrvCtrlOperationFsm_rmtErrDescr"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_RMT_RSLT = "diag_SrvCtrlOperationFsm_rmtRslt"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_ADMIN_STATE = "diag_SrvCtrlOperation_adminState"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_DESCR = "diag_SrvCtrlOperation_fsmDescr"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_PREV = "diag_SrvCtrlOperation_fsmPrev"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_PROGR = "diag_SrvCtrlOperation_fsmProgr"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_RMT_INV_ERR_CODE = "diag_SrvCtrlOperation_fsmRmtInvErrCode"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_RMT_INV_ERR_DESCR = "diag_SrvCtrlOperation_fsmRmtInvErrDescr"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_RMT_INV_RSLT = "diag_SrvCtrlOperation_fsmRmtInvRslt"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_STAGE_DESCR = "diag_SrvCtrlOperation_fsmStageDescr"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_STAMP = "diag_SrvCtrlOperation_fsmStamp"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_STATUS = "diag_SrvCtrlOperation_fsmStatus"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_FSM_TRY = "diag_SrvCtrlOperation_fsmTry"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_LAST_MODIFIED = "diag_SrvCtrlOperation_lastModified"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_REMOTE_ERROR_CODE = "diag_SrvCtrlOperation_remoteErrorCode"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_REMOTE_ERROR_DESCR = "diag_SrvCtrlOperation_remoteErrorDescr"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_RUN_POLICY_NAME_OPERATION = "diag_SrvCtrlOperation_runPolicyNameOperation"
    SORT_PROP_DIAG_SRV_CTRL_OPERATION_TRIGGER_STATUS = "diag_SrvCtrlOperation_triggerStatus"
    SORT_PROP_DIAG_SRV_CTRL_ADMIN_STATE = "diag_SrvCtrl_adminState"
    SORT_PROP_DIAG_SRV_CTRL_END_TS = "diag_SrvCtrl_endTs"
    SORT_PROP_DIAG_SRV_CTRL_END_TS_M = "diag_SrvCtrl_endTsM"
    SORT_PROP_DIAG_SRV_CTRL_ERROR_DESCR = "diag_SrvCtrl_errorDescr"
    SORT_PROP_DIAG_SRV_CTRL_OPER_QUALIFIER = "diag_SrvCtrl_operQualifier"
    SORT_PROP_DIAG_SRV_CTRL_OPER_STATE = "diag_SrvCtrl_operState"
    SORT_PROP_DIAG_SRV_CTRL_OVERALL_PROGRESS = "diag_SrvCtrl_overallProgress"
    SORT_PROP_DIAG_SRV_CTRL_RUN_POLICY_NAME = "diag_SrvCtrl_runPolicyName"
    SORT_PROP_DIAG_SRV_CTRL_START_TS = "diag_SrvCtrl_startTs"
    SORT_PROP_DIAG_SRV_CTRL_START_TS_M = "diag_SrvCtrl_startTsM"
    SORT_PROP_DIAG_TEST_ID = "diag_Test_id"
    SORT_PROP_DIAG_TEST_ORDER = "diag_Test_order"
    SORT_PROP_DIAG_TEST_TYPE = "diag_Test_type"
    SORT_PROP_DOMAIN_CHASSIS_FEATURE_FUNCTIONAL_STATE = "domain_ChassisFeature_functionalState"
    SORT_PROP_DOMAIN_CHASSIS_FEATURE_NAME = "domain_ChassisFeature_name"
    SORT_PROP_DOMAIN_CHASSIS_FEATURE_TYPE = "domain_ChassisFeature_type"
    SORT_PROP_DOMAIN_CHASSIS_PARAM_NAME = "domain_ChassisParam_name"
    SORT_PROP_DOMAIN_CHASSIS_PARAM_VALUE = "domain_ChassisParam_value"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_ASSOC_STATE = "domain_ChassisProfileItem_assocState"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_BLADE_DN = "domain_ChassisProfileItem_bladeDn"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_CHASSIS_ID = "domain_ChassisProfileItem_chassisId"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_CHASSIS_PROFILE_DN = "domain_ChassisProfileItem_chassisProfileDn"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_CHASSIS_PROFILE_NAME = "domain_ChassisProfileItem_chassisProfileName"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_CHASSIS_PROFILE_OWNER = "domain_ChassisProfileItem_chassisProfileOwner"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_CONFIG_ERROR_COUNT = "domain_ChassisProfileItem_configErrorCount"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_DOMAIN_GROUP = "domain_ChassisProfileItem_domainGroup"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_DOMAIN_GROUP_DN = "domain_ChassisProfileItem_domainGroupDn"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_DOMAIN_ID = "domain_ChassisProfileItem_domainId"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_DOMAIN_NAME = "domain_ChassisProfileItem_domainName"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_DOMAIN_STATE = "domain_ChassisProfileItem_domainState"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_FAULT_LEVEL = "domain_ChassisProfileItem_faultLevel"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_NUM_RUNNING_INSTANCES = "domain_ChassisProfileItem_numRunningInstances"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_OPER_SRC_TEMPL_NAME = "domain_ChassisProfileItem_operSrcTemplName"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_OPER_STATE = "domain_ChassisProfileItem_operState"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_ORG_DN = "domain_ChassisProfileItem_orgDn"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_ORG_NAME = "domain_ChassisProfileItem_orgName"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_SRC_TEMPL_NAME = "domain_ChassisProfileItem_srcTemplName"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_TEMPLATE_TYPE = "domain_ChassisProfileItem_templateType"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_TYPE = "domain_ChassisProfileItem_type"
    SORT_PROP_DOMAIN_CHASSIS_PROFILE_ITEM_USR_LBL = "domain_ChassisProfileItem_usrLbl"
    SORT_PROP_DOMAIN_ENVIRONMENT_FEATURE_FUNCTIONAL_STATE = "domain_EnvironmentFeature_functionalState"
    SORT_PROP_DOMAIN_ENVIRONMENT_FEATURE_NAME = "domain_EnvironmentFeature_name"
    SORT_PROP_DOMAIN_ENVIRONMENT_FEATURE_TYPE = "domain_EnvironmentFeature_type"
    SORT_PROP_DOMAIN_ENVIRONMENT_PARAM_NAME = "domain_EnvironmentParam_name"
    SORT_PROP_DOMAIN_ENVIRONMENT_PARAM_VALUE = "domain_EnvironmentParam_value"
    SORT_PROP_DOMAIN_FAMILY_CAP_PROVIDER_FAMILY = "domain_FamilyCapProvider_family"
    SORT_PROP_DOMAIN_FAMILY_CAP_PROVIDER_MODEL = "domain_FamilyCapProvider_model"
    SORT_PROP_DOMAIN_FEATURE_CATALOG_DESCRIPTION = "domain_FeatureCatalog_description"
    SORT_PROP_DOMAIN_FEATURE_CATALOG_VERSION = "domain_FeatureCatalog_version"
    SORT_PROP_DOMAIN_FEATURE_FUNCTIONAL_STATE = "domain_Feature_functionalState"
    SORT_PROP_DOMAIN_FEATURE_NAME = "domain_Feature_name"
    SORT_PROP_DOMAIN_FEATURE_TYPE = "domain_Feature_type"
    SORT_PROP_DOMAIN_NETWORK_FEATURE_FUNCTIONAL_STATE = "domain_NetworkFeature_functionalState"
    SORT_PROP_DOMAIN_NETWORK_FEATURE_NAME = "domain_NetworkFeature_name"
    SORT_PROP_DOMAIN_NETWORK_FEATURE_TYPE = "domain_NetworkFeature_type"
    SORT_PROP_DOMAIN_NETWORK_PARAM_NAME = "domain_NetworkParam_name"
    SORT_PROP_DOMAIN_NETWORK_PARAM_VALUE = "domain_NetworkParam_value"
    SORT_PROP_DOMAIN_PARAMETER_NAME = "domain_Parameter_name"
    SORT_PROP_DOMAIN_PARAMETER_VALUE = "domain_Parameter_value"
    SORT_PROP_DOMAIN_PROFILE_FSM_STAGE_DESCR = "domain_ProfileFsmStage_descr"
    SORT_PROP_DOMAIN_PROFILE_FSM_STAGE_LAST_UPDATE_TIME = "domain_ProfileFsmStage_lastUpdateTime"
    SORT_PROP_DOMAIN_PROFILE_FSM_STAGE_NAME = "domain_ProfileFsmStage_name"
    SORT_PROP_DOMAIN_PROFILE_FSM_STAGE_ORDER = "domain_ProfileFsmStage_order"
    SORT_PROP_DOMAIN_PROFILE_FSM_STAGE_RETRY = "domain_ProfileFsmStage_retry"
    SORT_PROP_DOMAIN_PROFILE_FSM_STAGE_STAGE_STATUS = "domain_ProfileFsmStage_stageStatus"
    SORT_PROP_DOMAIN_PROFILE_FSM_TASK_COMPLETION = "domain_ProfileFsmTask_completion"
    SORT_PROP_DOMAIN_PROFILE_FSM_TASK_FLAGS = "domain_ProfileFsmTask_flags"
    SORT_PROP_DOMAIN_PROFILE_FSM_TASK_ITEM = "domain_ProfileFsmTask_item"
    SORT_PROP_DOMAIN_PROFILE_FSM_TASK_SEQ_ID = "domain_ProfileFsmTask_seqId"
    SORT_PROP_DOMAIN_PROFILE_FSM_COMPLETION_TIME = "domain_ProfileFsm_completionTime"
    SORT_PROP_DOMAIN_PROFILE_FSM_CURRENT_FSM = "domain_ProfileFsm_currentFsm"
    SORT_PROP_DOMAIN_PROFILE_FSM_DESCR = "domain_ProfileFsm_descr"
    SORT_PROP_DOMAIN_PROFILE_FSM_FSM_INSTANCE_ID = "domain_ProfileFsm_fsmInstanceId"
    SORT_PROP_DOMAIN_PROFILE_FSM_FSM_STATUS = "domain_ProfileFsm_fsmStatus"
    SORT_PROP_DOMAIN_PROFILE_FSM_PROGRESS = "domain_ProfileFsm_progress"
    SORT_PROP_DOMAIN_PROFILE_FSM_RMT_ERR_CODE = "domain_ProfileFsm_rmtErrCode"
    SORT_PROP_DOMAIN_PROFILE_FSM_RMT_ERR_DESCR = "domain_ProfileFsm_rmtErrDescr"
    SORT_PROP_DOMAIN_PROFILE_FSM_RMT_RSLT = "domain_ProfileFsm_rmtRslt"
    SORT_PROP_DOMAIN_PROFILE_DESCR = "domain_Profile_descr"
    SORT_PROP_DOMAIN_PROFILE_FSM_DESCR = "domain_Profile_fsmDescr"
    SORT_PROP_DOMAIN_PROFILE_FSM_PREV = "domain_Profile_fsmPrev"
    SORT_PROP_DOMAIN_PROFILE_FSM_PROGR = "domain_Profile_fsmProgr"
    SORT_PROP_DOMAIN_PROFILE_FSM_RMT_INV_ERR_CODE = "domain_Profile_fsmRmtInvErrCode"
    SORT_PROP_DOMAIN_PROFILE_FSM_RMT_INV_ERR_DESCR = "domain_Profile_fsmRmtInvErrDescr"
    SORT_PROP_DOMAIN_PROFILE_FSM_RMT_INV_RSLT = "domain_Profile_fsmRmtInvRslt"
    SORT_PROP_DOMAIN_PROFILE_FSM_STAGE_DESCR = "domain_Profile_fsmStageDescr"
    SORT_PROP_DOMAIN_PROFILE_FSM_STAMP = "domain_Profile_fsmStamp"
    SORT_PROP_DOMAIN_PROFILE_FSM_STATUS = "domain_Profile_fsmStatus"
    SORT_PROP_DOMAIN_PROFILE_FSM_TRY = "domain_Profile_fsmTry"
    SORT_PROP_DOMAIN_PROFILE_HW_CHANGE_DISC_POLICY_NAME = "domain_Profile_hwChangeDiscPolicyName"
    SORT_PROP_DOMAIN_PROFILE_INBAND_POLICY_NAME = "domain_Profile_inbandPolicyName"
    SORT_PROP_DOMAIN_PROFILE_INT_ID = "domain_Profile_intId"
    SORT_PROP_DOMAIN_PROFILE_KMIP_CERTIFICATE_POLICY_NAME = "domain_Profile_kmipCertificatePolicyName"
    SORT_PROP_DOMAIN_PROFILE_NAME = "domain_Profile_name"
    SORT_PROP_DOMAIN_PROFILE_NET_GROUP_DN = "domain_Profile_netGroupDn"
    SORT_PROP_DOMAIN_PROFILE_OPER_HW_CHANGE_DISC_POLICY_NAME = "domain_Profile_operHwChangeDiscPolicyName"
    SORT_PROP_DOMAIN_PROFILE_OPER_INBAND_POLICY_NAME = "domain_Profile_operInbandPolicyName"
    SORT_PROP_DOMAIN_PROFILE_OPER_KMIP_CERTIFICATE_POLICY_NAME = "domain_Profile_operKmipCertificatePolicyName"
    SORT_PROP_DOMAIN_PROFILE_OPER_PORT_DISC_POLICY_NAME = "domain_Profile_operPortDiscPolicyName"
    SORT_PROP_DOMAIN_PROFILE_OPER_QOSCLASS_DEFINITION_NAME = "domain_Profile_operQosclassDefinitionName"
    SORT_PROP_DOMAIN_PROFILE_OPER_SRC_TEMPL_NAME = "domain_Profile_operSrcTemplName"
    SORT_PROP_DOMAIN_PROFILE_OUTBAND_MGMT_POOL = "domain_Profile_outbandMgmtPool"
    SORT_PROP_DOMAIN_PROFILE_POLICY_LEVEL = "domain_Profile_policyLevel"
    SORT_PROP_DOMAIN_PROFILE_POLICY_OWNER = "domain_Profile_policyOwner"
    SORT_PROP_DOMAIN_PROFILE_PORT_DISC_POLICY_NAME = "domain_Profile_portDiscPolicyName"
    SORT_PROP_DOMAIN_PROFILE_QOSCLASS_DEFINITION_NAME = "domain_Profile_qosclassDefinitionName"
    SORT_PROP_DOMAIN_PROFILE_REFRESH = "domain_Profile_refresh"
    SORT_PROP_DOMAIN_PROFILE_SRC_TEMPL_NAME = "domain_Profile_srcTemplName"
    SORT_PROP_DOMAIN_PROFILE_TYPE = "domain_Profile_type"
    SORT_PROP_DOMAIN_SERVER_FEATURE_FUNCTIONAL_STATE = "domain_ServerFeature_functionalState"
    SORT_PROP_DOMAIN_SERVER_FEATURE_NAME = "domain_ServerFeature_name"
    SORT_PROP_DOMAIN_SERVER_FEATURE_TYPE = "domain_ServerFeature_type"
    SORT_PROP_DOMAIN_SERVER_PARAM_NAME = "domain_ServerParam_name"
    SORT_PROP_DOMAIN_SERVER_PARAM_VALUE = "domain_ServerParam_value"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_ASSOC_STATE = "domain_ServiceProfileItem_assocState"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_BLADE_DN = "domain_ServiceProfileItem_bladeDn"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_CONFIG_ERROR_COUNT = "domain_ServiceProfileItem_configErrorCount"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_DOMAIN_GROUP = "domain_ServiceProfileItem_domainGroup"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_DOMAIN_GROUP_DN = "domain_ServiceProfileItem_domainGroupDn"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_DOMAIN_ID = "domain_ServiceProfileItem_domainId"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_DOMAIN_NAME = "domain_ServiceProfileItem_domainName"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_DOMAIN_STATE = "domain_ServiceProfileItem_domainState"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_FAULT_LEVEL = "domain_ServiceProfileItem_faultLevel"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_NUM_RUNNING_INSTANCES = "domain_ServiceProfileItem_numRunningInstances"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_OPER_SRC_TEMPL_NAME = "domain_ServiceProfileItem_operSrcTemplName"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_OPER_STATE = "domain_ServiceProfileItem_operState"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_ORG_DN = "domain_ServiceProfileItem_orgDn"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_ORG_NAME = "domain_ServiceProfileItem_orgName"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_SERVER_DN = "domain_ServiceProfileItem_serverDn"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_SERVER_ID = "domain_ServiceProfileItem_serverId"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_SERVICE_PROFILE_DN = "domain_ServiceProfileItem_serviceProfileDn"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_SERVICE_PROFILE_NAME = "domain_ServiceProfileItem_serviceProfileName"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_SERVICE_PROFILE_OWNER = "domain_ServiceProfileItem_serviceProfileOwner"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_SRC_TEMPL_NAME = "domain_ServiceProfileItem_srcTemplName"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_TEMPLATE_TYPE = "domain_ServiceProfileItem_templateType"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_TYPE = "domain_ServiceProfileItem_type"
    SORT_PROP_DOMAIN_SERVICE_PROFILE_ITEM_USR_LBL = "domain_ServiceProfileItem_usrLbl"
    SORT_PROP_DOMAIN_STORAGE_FEATURE_FUNCTIONAL_STATE = "domain_StorageFeature_functionalState"
    SORT_PROP_DOMAIN_STORAGE_FEATURE_NAME = "domain_StorageFeature_name"
    SORT_PROP_DOMAIN_STORAGE_FEATURE_TYPE = "domain_StorageFeature_type"
    SORT_PROP_DOMAIN_STORAGE_PARAM_NAME = "domain_StorageParam_name"
    SORT_PROP_DOMAIN_STORAGE_PARAM_VALUE = "domain_StorageParam_value"
    SORT_PROP_DPSEC_MAC_DESCR = "dpsec_Mac_descr"
    SORT_PROP_DPSEC_MAC_FORGE = "dpsec_Mac_forge"
    SORT_PROP_DPSEC_MAC_INT_ID = "dpsec_Mac_intId"
    SORT_PROP_DPSEC_MAC_NAME = "dpsec_Mac_name"
    SORT_PROP_DPSEC_MAC_POLICY_LEVEL = "dpsec_Mac_policyLevel"
    SORT_PROP_DPSEC_MAC_POLICY_OWNER = "dpsec_Mac_policyOwner"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_STAGE_DESCR = "dupe_ChangeTrackerEpFsmStage_descr"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_STAGE_LAST_UPDATE_TIME = "dupe_ChangeTrackerEpFsmStage_lastUpdateTime"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_STAGE_NAME = "dupe_ChangeTrackerEpFsmStage_name"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_STAGE_ORDER = "dupe_ChangeTrackerEpFsmStage_order"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_STAGE_RETRY = "dupe_ChangeTrackerEpFsmStage_retry"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_STAGE_STAGE_STATUS = "dupe_ChangeTrackerEpFsmStage_stageStatus"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_TASK_COMPLETION = "dupe_ChangeTrackerEpFsmTask_completion"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_TASK_FLAGS = "dupe_ChangeTrackerEpFsmTask_flags"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_TASK_ITEM = "dupe_ChangeTrackerEpFsmTask_item"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_TASK_SEQ_ID = "dupe_ChangeTrackerEpFsmTask_seqId"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_COMPLETION_TIME = "dupe_ChangeTrackerEpFsm_completionTime"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_CURRENT_FSM = "dupe_ChangeTrackerEpFsm_currentFsm"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_DESCR = "dupe_ChangeTrackerEpFsm_descr"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_FSM_INSTANCE_ID = "dupe_ChangeTrackerEpFsm_fsmInstanceId"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_FSM_STATUS = "dupe_ChangeTrackerEpFsm_fsmStatus"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_PROGRESS = "dupe_ChangeTrackerEpFsm_progress"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_RMT_ERR_CODE = "dupe_ChangeTrackerEpFsm_rmtErrCode"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_RMT_ERR_DESCR = "dupe_ChangeTrackerEpFsm_rmtErrDescr"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_RMT_RSLT = "dupe_ChangeTrackerEpFsm_rmtRslt"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_DESCR = "dupe_ChangeTrackerEp_fsmDescr"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_PREV = "dupe_ChangeTrackerEp_fsmPrev"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_PROGR = "dupe_ChangeTrackerEp_fsmProgr"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_RMT_INV_ERR_CODE = "dupe_ChangeTrackerEp_fsmRmtInvErrCode"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_RMT_INV_ERR_DESCR = "dupe_ChangeTrackerEp_fsmRmtInvErrDescr"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_RMT_INV_RSLT = "dupe_ChangeTrackerEp_fsmRmtInvRslt"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_STAGE_DESCR = "dupe_ChangeTrackerEp_fsmStageDescr"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_STAMP = "dupe_ChangeTrackerEp_fsmStamp"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_STATUS = "dupe_ChangeTrackerEp_fsmStatus"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_FSM_TRY = "dupe_ChangeTrackerEp_fsmTry"
    SORT_PROP_DUPE_CHANGE_TRACKER_EP_LATEST_SEND_TIME = "dupe_ChangeTrackerEp_latestSendTime"
    SORT_PROP_DUPE_CHANGE_TRACKER_ID = "dupe_ChangeTracker_id"
    SORT_PROP_DUPE_CHANGE_TRACKER_OPERATION = "dupe_ChangeTracker_operation"
    SORT_PROP_DUPE_CHANGE_TRACKER_SCOPE_DN = "dupe_ChangeTracker_scopeDn"
    SORT_PROP_DUPE_CHANGE_TRACKER_UPDATE_TIME = "dupe_ChangeTracker_updateTime"
    SORT_PROP_DUPE_INT_REQUESTOR_NAME = "dupe_IntRequestor_name"
    SORT_PROP_DUPE_INT_REQUESTOR_ON_BEHALF_OF_IDENT = "dupe_IntRequestor_onBehalfOfIdent"
    SORT_PROP_DUPE_INT_REQUESTOR_ON_BEHALF_OF_TYPE = "dupe_IntRequestor_onBehalfOfType"
    SORT_PROP_DUPE_SCOPE_RESULT_MESSAGE = "dupe_ScopeResult_message"
    SORT_PROP_DUPE_SCOPE_RESULT_SCOPE_STATUS = "dupe_ScopeResult_scopeStatus"
    SORT_PROP_DUPE_SCOPE_RESULT_UPDATE_TIME = "dupe_ScopeResult_updateTime"
    SORT_PROP_DUPE_SCOPE_CLIENT_MO_DN = "dupe_Scope_clientMoDn"
    SORT_PROP_DUPE_SCOPE_ID = "dupe_Scope_id"
    SORT_PROP_DUPE_SCOPE_IS_SYSTEM = "dupe_Scope_isSystem"
    SORT_PROP_DUPE_SCOPE_MO_CLASS_ID = "dupe_Scope_moClassId"
    SORT_PROP_DUPE_SCOPE_OPER_CODE = "dupe_Scope_operCode"
    SORT_PROP_DUPE_SCOPE_SECONDARY_KEY = "dupe_Scope_secondaryKey"
    SORT_PROP_DUPE_SCOPE_SOURCE_MO_DN = "dupe_Scope_sourceMoDn"
    SORT_PROP_EPQOS_CONF_COS = "epqos_Conf_cos"
    SORT_PROP_EPQOS_CONF_QOS_POLICY_DN = "epqos_Conf_qosPolicyDn"
    SORT_PROP_EPQOS_CONF_QOS_POLICY_ID = "epqos_Conf_qosPolicyId"
    SORT_PROP_EPQOS_DEFINITION_DESCR = "epqos_Definition_descr"
    SORT_PROP_EPQOS_DEFINITION_INT_ID = "epqos_Definition_intId"
    SORT_PROP_EPQOS_DEFINITION_NAME = "epqos_Definition_name"
    SORT_PROP_EPQOS_DEFINITION_POLICY_LEVEL = "epqos_Definition_policyLevel"
    SORT_PROP_EPQOS_DEFINITION_POLICY_OWNER = "epqos_Definition_policyOwner"
    SORT_PROP_EPQOS_EGRESS_BURST = "epqos_Egress_burst"
    SORT_PROP_EPQOS_EGRESS_HOST_CONTROL = "epqos_Egress_hostControl"
    SORT_PROP_EPQOS_EGRESS_NAME = "epqos_Egress_name"
    SORT_PROP_EPQOS_EGRESS_OPER_PRIO = "epqos_Egress_operPrio"
    SORT_PROP_EPQOS_EGRESS_PRIO = "epqos_Egress_prio"
    SORT_PROP_EPQOS_EGRESS_RATE = "epqos_Egress_rate"
    SORT_PROP_EPQOS_ITEM_NAME = "epqos_Item_name"
    SORT_PROP_EQUIPMENT_ADVANCED_BOOT_ORDER_IS_SUPPORTED = "equipment_AdvancedBootOrder_isSupported"
    SORT_PROP_EQUIPMENT_ADVANCED_BOOT_ORDER_MIN_BIOS_VERSION = "equipment_AdvancedBootOrder_minBiosVersion"
    SORT_PROP_EQUIPMENT_ADVANCED_BOOT_ORDER_MIN_CIMC_VERSION = "equipment_AdvancedBootOrder_minCimcVersion"
    SORT_PROP_EQUIPMENT_ADVANCED_BOOT_ORDER_NAME = "equipment_AdvancedBootOrder_name"
    SORT_PROP_EQUIPMENT_ASSOC_CTX_FRU_CAP_DN = "equipment_AssocCtx_fruCapDn"
    SORT_PROP_EQUIPMENT_BEACON_LED_ADMIN_STATE = "equipment_BeaconLed_adminState"
    SORT_PROP_EQUIPMENT_BEACON_LED_COLOR = "equipment_BeaconLed_color"
    SORT_PROP_EQUIPMENT_BEACON_LED_ID = "equipment_BeaconLed_id"
    SORT_PROP_EQUIPMENT_BEACON_LED_NAME = "equipment_BeaconLed_name"
    SORT_PROP_EQUIPMENT_BEACON_LED_OPER_STATE = "equipment_BeaconLed_operState"
    SORT_PROP_EQUIPMENT_BINDING_ASSIGNED_TO_DN = "equipment_Binding_assignedToDn"
    SORT_PROP_EQUIPMENT_BINDING_CHASSIS_DN = "equipment_Binding_chassisDn"
    SORT_PROP_EQUIPMENT_BINDING_ISSUES = "equipment_Binding_issues"
    SORT_PROP_EQUIPMENT_BINDING_NAME = "equipment_Binding_name"
    SORT_PROP_EQUIPMENT_BINDING_OPER_STATE = "equipment_Binding_operState"
    SORT_PROP_EQUIPMENT_BINDING_RESTRICT_MIGRATION = "equipment_Binding_restrictMigration"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_DEPRECATED = "equipment_BladeCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_GENCOUNT = "equipment_BladeCapProvider_gencount"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_BladeCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_MODEL = "equipment_BladeCapProvider_model"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_BladeCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_REVISION = "equipment_BladeCapProvider_revision"
    SORT_PROP_EQUIPMENT_BLADE_CAP_PROVIDER_VENDOR = "equipment_BladeCapProvider_vendor"
    SORT_PROP_EQUIPMENT_BREAKOUT_CAP_EXT_PHY_PORT_BITMASK = "equipment_BreakoutCap_extPhyPortBitmask"
    SORT_PROP_EQUIPMENT_BREAKOUT_CAP_NAME = "equipment_BreakoutCap_name"
    SORT_PROP_EQUIPMENT_BREAKOUT_CAP_PHY_PORT_BITMASK = "equipment_BreakoutCap_phyPortBitmask"
    SORT_PROP_EQUIPMENT_CPMETA_CHASSIS_DN = "equipment_CPMeta_chassisDn"
    SORT_PROP_EQUIPMENT_CPMETA_CONFIG_QUALIFIER = "equipment_CPMeta_configQualifier"
    SORT_PROP_EQUIPMENT_CPMETA_CP_REFRESH = "equipment_CPMeta_cpRefresh"
    SORT_PROP_EQUIPMENT_CPMETA_GUID = "equipment_CPMeta_guid"
    SORT_PROP_EQUIPMENT_CPMETA_IS_RENAME = "equipment_CPMeta_isRename"
    SORT_PROP_EQUIPMENT_CPMETA_NEED_ID_RE_EVALUATE = "equipment_CPMeta_needIdReEvaluate"
    SORT_PROP_EQUIPMENT_CPMETA_NEW_CPDN = "equipment_CPMeta_newCPDN"
    SORT_PROP_EQUIPMENT_CPMETA_OLD_CPDN = "equipment_CPMeta_oldCPDN"
    SORT_PROP_EQUIPMENT_CPMETA_OPERATION_CODE = "equipment_CPMeta_operationCode"
    SORT_PROP_EQUIPMENT_CPMETA_OPERATION_CODE_CLEARANCE = "equipment_CPMeta_operationCodeClearance"
    SORT_PROP_EQUIPMENT_CPMETA_OWNERSHIP_STATE = "equipment_CPMeta_ownershipState"
    SORT_PROP_EQUIPMENT_CARD_ID = "equipment_Card_id"
    SORT_PROP_EQUIPMENT_CARD_MODEL = "equipment_Card_model"
    SORT_PROP_EQUIPMENT_CARD_OPER_QUALIFIER_REASON = "equipment_Card_operQualifierReason"
    SORT_PROP_EQUIPMENT_CARD_OPER_STATE = "equipment_Card_operState"
    SORT_PROP_EQUIPMENT_CARD_OPERABILITY = "equipment_Card_operability"
    SORT_PROP_EQUIPMENT_CARD_PERF = "equipment_Card_perf"
    SORT_PROP_EQUIPMENT_CARD_POWER = "equipment_Card_power"
    SORT_PROP_EQUIPMENT_CARD_PRESENCE = "equipment_Card_presence"
    SORT_PROP_EQUIPMENT_CARD_REVISION = "equipment_Card_revision"
    SORT_PROP_EQUIPMENT_CARD_SERIAL = "equipment_Card_serial"
    SORT_PROP_EQUIPMENT_CARD_THERMAL = "equipment_Card_thermal"
    SORT_PROP_EQUIPMENT_CARD_VENDOR = "equipment_Card_vendor"
    SORT_PROP_EQUIPMENT_CARD_VOLTAGE = "equipment_Card_voltage"
    SORT_PROP_EQUIPMENT_CARTRIDGE_CAP_PROVIDER_DEPRECATED = "equipment_CartridgeCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_CARTRIDGE_CAP_PROVIDER_GENCOUNT = "equipment_CartridgeCapProvider_gencount"
    SORT_PROP_EQUIPMENT_CARTRIDGE_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_CartridgeCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_CARTRIDGE_CAP_PROVIDER_MODEL = "equipment_CartridgeCapProvider_model"
    SORT_PROP_EQUIPMENT_CARTRIDGE_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_CartridgeCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_CARTRIDGE_CAP_PROVIDER_REVISION = "equipment_CartridgeCapProvider_revision"
    SORT_PROP_EQUIPMENT_CARTRIDGE_CAP_PROVIDER_VENDOR = "equipment_CartridgeCapProvider_vendor"
    SORT_PROP_EQUIPMENT_CHASSIS_ASSOC_CTX_FRU_CAP_DN = "equipment_ChassisAssocCtx_fruCapDn"
    SORT_PROP_EQUIPMENT_CHASSIS_CAP_PROVIDER_DEPRECATED = "equipment_ChassisCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_CHASSIS_CAP_PROVIDER_GENCOUNT = "equipment_ChassisCapProvider_gencount"
    SORT_PROP_EQUIPMENT_CHASSIS_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_ChassisCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_CHASSIS_CAP_PROVIDER_MODEL = "equipment_ChassisCapProvider_model"
    SORT_PROP_EQUIPMENT_CHASSIS_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_ChassisCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_CHASSIS_CAP_PROVIDER_REVISION = "equipment_ChassisCapProvider_revision"
    SORT_PROP_EQUIPMENT_CHASSIS_CAP_PROVIDER_VENDOR = "equipment_ChassisCapProvider_vendor"
    SORT_PROP_EQUIPMENT_CHASSIS_COMPONENT_CHASSIS_ID = "equipment_ChassisComponent_chassisId"
    SORT_PROP_EQUIPMENT_CHASSIS_COMPONENT_SLOT_ID = "equipment_ChassisComponent_slotId"
    SORT_PROP_EQUIPMENT_CHASSIS_ISSUES_CHASSIS_CONFIG_ISSUES = "equipment_ChassisIssues_chassisConfigIssues"
    SORT_PROP_EQUIPMENT_CHASSIS_ISSUES_CONFIG_WARNINGS = "equipment_ChassisIssues_configWarnings"
    SORT_PROP_EQUIPMENT_CHASSIS_ISSUES_STORAGE_CONFIG_ISSUES = "equipment_ChassisIssues_storageConfigIssues"
    SORT_PROP_EQUIPMENT_CHASSIS_OPERATION_ADMIN_STATE = "equipment_ChassisOperation_adminState"
    SORT_PROP_EQUIPMENT_CHASSIS_OPERATION_LAST_MODIFIED = "equipment_ChassisOperation_lastModified"
    SORT_PROP_EQUIPMENT_CHASSIS_OPERATION_REMOTE_ERROR_CODE = "equipment_ChassisOperation_remoteErrorCode"
    SORT_PROP_EQUIPMENT_CHASSIS_OPERATION_REMOTE_ERROR_DESCR = "equipment_ChassisOperation_remoteErrorDescr"
    SORT_PROP_EQUIPMENT_CHASSIS_OPERATION_TRIGGER_STATUS = "equipment_ChassisOperation_triggerStatus"
    SORT_PROP_EQUIPMENT_CHASSIS_POS_QUAL_MAX_ID = "equipment_ChassisPosQual_maxId"
    SORT_PROP_EQUIPMENT_CHASSIS_POS_QUAL_MIN_ID = "equipment_ChassisPosQual_minId"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_BINDING_ASSIGNED_TO_DN = "equipment_ChassisProfileBinding_assignedToDn"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_BINDING_CHASSIS_DN = "equipment_ChassisProfileBinding_chassisDn"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_BINDING_ISSUES = "equipment_ChassisProfileBinding_issues"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_BINDING_NAME = "equipment_ChassisProfileBinding_name"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_BINDING_OPER_STATE = "equipment_ChassisProfileBinding_operState"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_BINDING_RESTRICT_MIGRATION = "equipment_ChassisProfileBinding_restrictMigration"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE_DESCR = "equipment_ChassisProfileFsmStage_descr"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE_LAST_UPDATE_TIME = "equipment_ChassisProfileFsmStage_lastUpdateTime"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE_NAME = "equipment_ChassisProfileFsmStage_name"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE_ORDER = "equipment_ChassisProfileFsmStage_order"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE_RETRY = "equipment_ChassisProfileFsmStage_retry"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE_STAGE_STATUS = "equipment_ChassisProfileFsmStage_stageStatus"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_TASK_COMPLETION = "equipment_ChassisProfileFsmTask_completion"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_TASK_FLAGS = "equipment_ChassisProfileFsmTask_flags"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_TASK_ITEM = "equipment_ChassisProfileFsmTask_item"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_TASK_SEQ_ID = "equipment_ChassisProfileFsmTask_seqId"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_COMPLETION_TIME = "equipment_ChassisProfileFsm_completionTime"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_CURRENT_FSM = "equipment_ChassisProfileFsm_currentFsm"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_DESCR = "equipment_ChassisProfileFsm_descr"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_FSM_INSTANCE_ID = "equipment_ChassisProfileFsm_fsmInstanceId"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_FSM_STATUS = "equipment_ChassisProfileFsm_fsmStatus"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_PROGRESS = "equipment_ChassisProfileFsm_progress"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_RMT_ERR_CODE = "equipment_ChassisProfileFsm_rmtErrCode"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_RMT_ERR_DESCR = "equipment_ChassisProfileFsm_rmtErrDescr"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_RMT_RSLT = "equipment_ChassisProfileFsm_rmtRslt"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_ASSIGN_STATE = "equipment_ChassisProfile_assignState"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_ASSOC_STATE = "equipment_ChassisProfile_assocState"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_CHASSIS_DN = "equipment_ChassisProfile_chassisDn"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_CHASSIS_FW_POLICY_NAME = "equipment_ChassisProfile_chassisFwPolicyName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_COMPUTE_CONN_POLICY_NAME = "equipment_ChassisProfile_computeConnPolicyName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_CONFIG_QUALIFIER = "equipment_ChassisProfile_configQualifier"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_CONFIG_STATE = "equipment_ChassisProfile_configState"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_DESCR = "equipment_ChassisProfile_descr"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_DISK_ZONING_POLICY_NAME = "equipment_ChassisProfile_diskZoningPolicyName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_DOMAIN = "equipment_ChassisProfile_domain"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_DOMAIN_DN = "equipment_ChassisProfile_domainDn"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_DOMAIN_GROUP = "equipment_ChassisProfile_domainGroup"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_DOMAIN_GROUP_DN = "equipment_ChassisProfile_domainGroupDn"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_DESCR = "equipment_ChassisProfile_fsmDescr"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_FLAGS = "equipment_ChassisProfile_fsmFlags"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_PREV = "equipment_ChassisProfile_fsmPrev"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_PROGR = "equipment_ChassisProfile_fsmProgr"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_RMT_INV_ERR_CODE = "equipment_ChassisProfile_fsmRmtInvErrCode"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_RMT_INV_ERR_DESCR = "equipment_ChassisProfile_fsmRmtInvErrDescr"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_RMT_INV_RSLT = "equipment_ChassisProfile_fsmRmtInvRslt"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_STAGE_DESCR = "equipment_ChassisProfile_fsmStageDescr"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_STAMP = "equipment_ChassisProfile_fsmStamp"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_STATUS = "equipment_ChassisProfile_fsmStatus"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_FSM_TRY = "equipment_ChassisProfile_fsmTry"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_GUID = "equipment_ChassisProfile_guid"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_INT_ID = "equipment_ChassisProfile_intId"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_LS_DN = "equipment_ChassisProfile_lsDn"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_MAINT_POLICY_NAME = "equipment_ChassisProfile_maintPolicyName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_NAME = "equipment_ChassisProfile_name"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_OPER_CHASSIS_FW_POLICY_NAME = "equipment_ChassisProfile_operChassisFwPolicyName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_OPER_COMPUTE_CONN_POLICY_NAME = "equipment_ChassisProfile_operComputeConnPolicyName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_OPER_DISK_ZONING_POLICY_NAME = "equipment_ChassisProfile_operDiskZoningPolicyName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_OPER_MAINT_POLICY_NAME = "equipment_ChassisProfile_operMaintPolicyName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_OPER_SRC_TEMPL_NAME = "equipment_ChassisProfile_operSrcTemplName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_OPER_STATE = "equipment_ChassisProfile_operState"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_OWNER = "equipment_ChassisProfile_owner"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_PN_DN = "equipment_ChassisProfile_pnDn"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_POLICY_LEVEL = "equipment_ChassisProfile_policyLevel"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_POLICY_OWNER = "equipment_ChassisProfile_policyOwner"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_RESOLVE_REMOTE = "equipment_ChassisProfile_resolveRemote"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_SRC_TEMPL_NAME = "equipment_ChassisProfile_srcTemplName"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_TYPE = "equipment_ChassisProfile_type"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_USR_LBL = "equipment_ChassisProfile_usrLbl"
    SORT_PROP_EQUIPMENT_CHASSIS_PROFILE_UUID = "equipment_ChassisProfile_uuid"
    SORT_PROP_EQUIPMENT_CHASSIS_QUAL_MAX_ID = "equipment_ChassisQual_maxId"
    SORT_PROP_EQUIPMENT_CHASSIS_QUAL_MIN_ID = "equipment_ChassisQual_minId"
    SORT_PROP_EQUIPMENT_CHASSIS_REQUIREMENT_DESCR = "equipment_ChassisRequirement_descr"
    SORT_PROP_EQUIPMENT_CHASSIS_REQUIREMENT_INSTANTIATION_STATE = "equipment_ChassisRequirement_instantiationState"
    SORT_PROP_EQUIPMENT_CHASSIS_REQUIREMENT_INT_ID = "equipment_ChassisRequirement_intId"
    SORT_PROP_EQUIPMENT_CHASSIS_REQUIREMENT_LOCAL_PLACEMENT_REF_CNT = "equipment_ChassisRequirement_localPlacementRefCnt"
    SORT_PROP_EQUIPMENT_CHASSIS_REQUIREMENT_NAME = "equipment_ChassisRequirement_name"
    SORT_PROP_EQUIPMENT_CHASSIS_REQUIREMENT_OPER_STATE = "equipment_ChassisRequirement_operState"
    SORT_PROP_EQUIPMENT_CHASSIS_REQUIREMENT_PLACEMENT_REF_CNT = "equipment_ChassisRequirement_placementRefCnt"
    SORT_PROP_EQUIPMENT_CHASSIS_REQUIREMENT_POLICY_LEVEL = "equipment_ChassisRequirement_policyLevel"
    SORT_PROP_EQUIPMENT_CHASSIS_REQUIREMENT_POLICY_OWNER = "equipment_ChassisRequirement_policyOwner"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_ID = "equipment_ChassisStatsHist_id"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_INPUT_POWER = "equipment_ChassisStatsHist_inputPower"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_INPUT_POWER_AVG = "equipment_ChassisStatsHist_inputPowerAvg"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_INPUT_POWER_MAX = "equipment_ChassisStatsHist_inputPowerMax"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_INPUT_POWER_MIN = "equipment_ChassisStatsHist_inputPowerMin"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_MOST_RECENT = "equipment_ChassisStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_OUTPUT_POWER = "equipment_ChassisStatsHist_outputPower"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_OUTPUT_POWER_AVG = "equipment_ChassisStatsHist_outputPowerAvg"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_OUTPUT_POWER_MAX = "equipment_ChassisStatsHist_outputPowerMax"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_OUTPUT_POWER_MIN = "equipment_ChassisStatsHist_outputPowerMin"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_SUSPECT = "equipment_ChassisStatsHist_suspect"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_THRESHOLDED = "equipment_ChassisStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_HIST_TIME_COLLECTED = "equipment_ChassisStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_INPUT_POWER = "equipment_ChassisStats_inputPower"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_INPUT_POWER_AVG = "equipment_ChassisStats_inputPowerAvg"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_INPUT_POWER_MAX = "equipment_ChassisStats_inputPowerMax"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_INPUT_POWER_MIN = "equipment_ChassisStats_inputPowerMin"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_INTERVALS = "equipment_ChassisStats_intervals"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_NORMALIZED_TIME_COL = "equipment_ChassisStats_normalizedTimeCol"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_OUTPUT_POWER = "equipment_ChassisStats_outputPower"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_OUTPUT_POWER_AVG = "equipment_ChassisStats_outputPowerAvg"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_OUTPUT_POWER_MAX = "equipment_ChassisStats_outputPowerMax"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_OUTPUT_POWER_MIN = "equipment_ChassisStats_outputPowerMin"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_STATS_REPORTED = "equipment_ChassisStats_statsReported"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_SUSPECT = "equipment_ChassisStats_suspect"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_THRESHOLDED = "equipment_ChassisStats_thresholded"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_TIME_COLLECTED = "equipment_ChassisStats_timeCollected"
    SORT_PROP_EQUIPMENT_CHASSIS_STATS_UPDATE = "equipment_ChassisStats_update"
    SORT_PROP_EQUIPMENT_CHASSIS_ADMIN_STATE = "equipment_Chassis_adminState"
    SORT_PROP_EQUIPMENT_CHASSIS_ASSIGNED_TO_DN = "equipment_Chassis_assignedToDn"
    SORT_PROP_EQUIPMENT_CHASSIS_ASSOCIATION = "equipment_Chassis_association"
    SORT_PROP_EQUIPMENT_CHASSIS_AVAILABILITY = "equipment_Chassis_availability"
    SORT_PROP_EQUIPMENT_CHASSIS_CONFIG_STATE = "equipment_Chassis_configState"
    SORT_PROP_EQUIPMENT_CHASSIS_CONN_PATH = "equipment_Chassis_connPath"
    SORT_PROP_EQUIPMENT_CHASSIS_CONN_STATUS = "equipment_Chassis_connStatus"
    SORT_PROP_EQUIPMENT_CHASSIS_DISCOVERY = "equipment_Chassis_discovery"
    SORT_PROP_EQUIPMENT_CHASSIS_DISCOVERY_STATUS = "equipment_Chassis_discoveryStatus"
    SORT_PROP_EQUIPMENT_CHASSIS_ID = "equipment_Chassis_id"
    SORT_PROP_EQUIPMENT_CHASSIS_MANAGING_INST = "equipment_Chassis_managingInst"
    SORT_PROP_EQUIPMENT_CHASSIS_MODEL = "equipment_Chassis_model"
    SORT_PROP_EQUIPMENT_CHASSIS_OPER_QUALIFIER = "equipment_Chassis_operQualifier"
    SORT_PROP_EQUIPMENT_CHASSIS_OPER_QUALIFIER_REASON = "equipment_Chassis_operQualifierReason"
    SORT_PROP_EQUIPMENT_CHASSIS_OPER_STATE = "equipment_Chassis_operState"
    SORT_PROP_EQUIPMENT_CHASSIS_OPERABILITY = "equipment_Chassis_operability"
    SORT_PROP_EQUIPMENT_CHASSIS_POWER = "equipment_Chassis_power"
    SORT_PROP_EQUIPMENT_CHASSIS_PRESENCE = "equipment_Chassis_presence"
    SORT_PROP_EQUIPMENT_CHASSIS_REVISION = "equipment_Chassis_revision"
    SORT_PROP_EQUIPMENT_CHASSIS_SEEPROM_OPER_STATE = "equipment_Chassis_seepromOperState"
    SORT_PROP_EQUIPMENT_CHASSIS_SERIAL = "equipment_Chassis_serial"
    SORT_PROP_EQUIPMENT_CHASSIS_SERVICE_STATE = "equipment_Chassis_serviceState"
    SORT_PROP_EQUIPMENT_CHASSIS_THERMAL = "equipment_Chassis_thermal"
    SORT_PROP_EQUIPMENT_CHASSIS_THERMAL_STATE_QUALIFIER = "equipment_Chassis_thermalStateQualifier"
    SORT_PROP_EQUIPMENT_CHASSIS_USR_LBL = "equipment_Chassis_usrLbl"
    SORT_PROP_EQUIPMENT_CHASSIS_VENDOR = "equipment_Chassis_vendor"
    SORT_PROP_EQUIPMENT_CIMC_VMEDIA_IS_SUPPORTED = "equipment_CimcVmedia_isSupported"
    SORT_PROP_EQUIPMENT_CIMC_VMEDIA_MIN_BIOS_VERSION = "equipment_CimcVmedia_minBiosVersion"
    SORT_PROP_EQUIPMENT_CIMC_VMEDIA_MIN_CIMC_VERSION = "equipment_CimcVmedia_minCimcVersion"
    SORT_PROP_EQUIPMENT_CIMC_VMEDIA_NAME = "equipment_CimcVmedia_name"
    SORT_PROP_EQUIPMENT_COMPUTE_CONN_POLICY_DESCR = "equipment_ComputeConnPolicy_descr"
    SORT_PROP_EQUIPMENT_COMPUTE_CONN_POLICY_INT_ID = "equipment_ComputeConnPolicy_intId"
    SORT_PROP_EQUIPMENT_COMPUTE_CONN_POLICY_NAME = "equipment_ComputeConnPolicy_name"
    SORT_PROP_EQUIPMENT_COMPUTE_CONN_POLICY_POLICY_LEVEL = "equipment_ComputeConnPolicy_policyLevel"
    SORT_PROP_EQUIPMENT_COMPUTE_CONN_POLICY_POLICY_OWNER = "equipment_ComputeConnPolicy_policyOwner"
    SORT_PROP_EQUIPMENT_COMPUTE_CONN_POLICY_SERVER_SIOC_CONNECTIVITY = "equipment_ComputeConnPolicy_serverSiocConnectivity"
    SORT_PROP_EQUIPMENT_COMPUTE_CONN_SERVER_SIOC_CONNECTIVITY = "equipment_ComputeConn_serverSiocConnectivity"
    SORT_PROP_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER_DEPRECATED = "equipment_ComputePhysicalCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER_GENCOUNT = "equipment_ComputePhysicalCapProvider_gencount"
    SORT_PROP_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_ComputePhysicalCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER_MODEL = "equipment_ComputePhysicalCapProvider_model"
    SORT_PROP_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_ComputePhysicalCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER_REVISION = "equipment_ComputePhysicalCapProvider_revision"
    SORT_PROP_EQUIPMENT_COMPUTE_PHYSICAL_CAP_PROVIDER_VENDOR = "equipment_ComputePhysicalCapProvider_vendor"
    SORT_PROP_EQUIPMENT_CONNECTIVITY_CONN_PATH = "equipment_Connectivity_connPath"
    SORT_PROP_EQUIPMENT_CONNECTIVITY_CONN_STATUS = "equipment_Connectivity_connStatus"
    SORT_PROP_EQUIPMENT_CONNECTIVITY_DISCOVERY_STATUS = "equipment_Connectivity_discoveryStatus"
    SORT_PROP_EQUIPMENT_CONNECTIVITY_MANAGING_INST = "equipment_Connectivity_managingInst"
    SORT_PROP_EQUIPMENT_DEFINITION_DESCR = "equipment_Definition_descr"
    SORT_PROP_EQUIPMENT_DEFINITION_INT_ID = "equipment_Definition_intId"
    SORT_PROP_EQUIPMENT_DEFINITION_NAME = "equipment_Definition_name"
    SORT_PROP_EQUIPMENT_DEFINITION_POLICY_LEVEL = "equipment_Definition_policyLevel"
    SORT_PROP_EQUIPMENT_DEFINITION_POLICY_OWNER = "equipment_Definition_policyOwner"
    SORT_PROP_EQUIPMENT_DRIVE_SEC_CAP_IS_SUPPORTED = "equipment_DriveSecCap_isSupported"
    SORT_PROP_EQUIPMENT_DRIVE_SEC_CAP_MIN_VERSION = "equipment_DriveSecCap_minVersion"
    SORT_PROP_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_DEPRECATED = "equipment_FanModuleCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_GENCOUNT = "equipment_FanModuleCapProvider_gencount"
    SORT_PROP_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_FanModuleCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_MODEL = "equipment_FanModuleCapProvider_model"
    SORT_PROP_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_FanModuleCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_REVISION = "equipment_FanModuleCapProvider_revision"
    SORT_PROP_EQUIPMENT_FAN_MODULE_CAP_PROVIDER_VENDOR = "equipment_FanModuleCapProvider_vendor"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_AMBIENT_TEMP = "equipment_FanModuleStatsHist_ambientTemp"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_AMBIENT_TEMP_AVG = "equipment_FanModuleStatsHist_ambientTempAvg"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_AMBIENT_TEMP_MAX = "equipment_FanModuleStatsHist_ambientTempMax"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_AMBIENT_TEMP_MIN = "equipment_FanModuleStatsHist_ambientTempMin"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_ID = "equipment_FanModuleStatsHist_id"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_MOST_RECENT = "equipment_FanModuleStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_SUSPECT = "equipment_FanModuleStatsHist_suspect"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_THRESHOLDED = "equipment_FanModuleStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_HIST_TIME_COLLECTED = "equipment_FanModuleStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_AMBIENT_TEMP = "equipment_FanModuleStats_ambientTemp"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_AMBIENT_TEMP_AVG = "equipment_FanModuleStats_ambientTempAvg"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_AMBIENT_TEMP_MAX = "equipment_FanModuleStats_ambientTempMax"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_AMBIENT_TEMP_MIN = "equipment_FanModuleStats_ambientTempMin"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_INTERVALS = "equipment_FanModuleStats_intervals"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_NORMALIZED_TIME_COL = "equipment_FanModuleStats_normalizedTimeCol"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_STATS_REPORTED = "equipment_FanModuleStats_statsReported"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_SUSPECT = "equipment_FanModuleStats_suspect"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_THRESHOLDED = "equipment_FanModuleStats_thresholded"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_TIME_COLLECTED = "equipment_FanModuleStats_timeCollected"
    SORT_PROP_EQUIPMENT_FAN_MODULE_STATS_UPDATE = "equipment_FanModuleStats_update"
    SORT_PROP_EQUIPMENT_FAN_MODULE_ASSET_TAG = "equipment_FanModule_assetTag"
    SORT_PROP_EQUIPMENT_FAN_MODULE_ID = "equipment_FanModule_id"
    SORT_PROP_EQUIPMENT_FAN_MODULE_MFG_TIME = "equipment_FanModule_mfgTime"
    SORT_PROP_EQUIPMENT_FAN_MODULE_MODEL = "equipment_FanModule_model"
    SORT_PROP_EQUIPMENT_FAN_MODULE_OPER_QUALIFIER_REASON = "equipment_FanModule_operQualifierReason"
    SORT_PROP_EQUIPMENT_FAN_MODULE_OPER_STATE = "equipment_FanModule_operState"
    SORT_PROP_EQUIPMENT_FAN_MODULE_OPERABILITY = "equipment_FanModule_operability"
    SORT_PROP_EQUIPMENT_FAN_MODULE_PART_NUMBER = "equipment_FanModule_partNumber"
    SORT_PROP_EQUIPMENT_FAN_MODULE_PERF = "equipment_FanModule_perf"
    SORT_PROP_EQUIPMENT_FAN_MODULE_POWER = "equipment_FanModule_power"
    SORT_PROP_EQUIPMENT_FAN_MODULE_PRESENCE = "equipment_FanModule_presence"
    SORT_PROP_EQUIPMENT_FAN_MODULE_REVISION = "equipment_FanModule_revision"
    SORT_PROP_EQUIPMENT_FAN_MODULE_SERIAL = "equipment_FanModule_serial"
    SORT_PROP_EQUIPMENT_FAN_MODULE_THERMAL = "equipment_FanModule_thermal"
    SORT_PROP_EQUIPMENT_FAN_MODULE_TRAY = "equipment_FanModule_tray"
    SORT_PROP_EQUIPMENT_FAN_MODULE_VENDOR = "equipment_FanModule_vendor"
    SORT_PROP_EQUIPMENT_FAN_MODULE_VID = "equipment_FanModule_vid"
    SORT_PROP_EQUIPMENT_FAN_MODULE_VOLTAGE = "equipment_FanModule_voltage"
    SORT_PROP_EQUIPMENT_FAN_STATS_HIST_ID = "equipment_FanStatsHist_id"
    SORT_PROP_EQUIPMENT_FAN_STATS_HIST_MOST_RECENT = "equipment_FanStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_FAN_STATS_HIST_SPEED = "equipment_FanStatsHist_speed"
    SORT_PROP_EQUIPMENT_FAN_STATS_HIST_SPEED_AVG = "equipment_FanStatsHist_speedAvg"
    SORT_PROP_EQUIPMENT_FAN_STATS_HIST_SPEED_MAX = "equipment_FanStatsHist_speedMax"
    SORT_PROP_EQUIPMENT_FAN_STATS_HIST_SPEED_MIN = "equipment_FanStatsHist_speedMin"
    SORT_PROP_EQUIPMENT_FAN_STATS_HIST_SUSPECT = "equipment_FanStatsHist_suspect"
    SORT_PROP_EQUIPMENT_FAN_STATS_HIST_THRESHOLDED = "equipment_FanStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_FAN_STATS_HIST_TIME_COLLECTED = "equipment_FanStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_FAN_STATS_INTERVALS = "equipment_FanStats_intervals"
    SORT_PROP_EQUIPMENT_FAN_STATS_NORMALIZED_TIME_COL = "equipment_FanStats_normalizedTimeCol"
    SORT_PROP_EQUIPMENT_FAN_STATS_SPEED = "equipment_FanStats_speed"
    SORT_PROP_EQUIPMENT_FAN_STATS_SPEED_AVG = "equipment_FanStats_speedAvg"
    SORT_PROP_EQUIPMENT_FAN_STATS_SPEED_MAX = "equipment_FanStats_speedMax"
    SORT_PROP_EQUIPMENT_FAN_STATS_SPEED_MIN = "equipment_FanStats_speedMin"
    SORT_PROP_EQUIPMENT_FAN_STATS_STATS_REPORTED = "equipment_FanStats_statsReported"
    SORT_PROP_EQUIPMENT_FAN_STATS_SUSPECT = "equipment_FanStats_suspect"
    SORT_PROP_EQUIPMENT_FAN_STATS_THRESHOLDED = "equipment_FanStats_thresholded"
    SORT_PROP_EQUIPMENT_FAN_STATS_TIME_COLLECTED = "equipment_FanStats_timeCollected"
    SORT_PROP_EQUIPMENT_FAN_STATS_UPDATE = "equipment_FanStats_update"
    SORT_PROP_EQUIPMENT_FAN_FAN_SPEED_POLICY_ADMIN_STATE = "equipment_Fan_fanSpeedPolicyAdminState"
    SORT_PROP_EQUIPMENT_FAN_FAN_SPEED_POLICY_OPER_STATE = "equipment_Fan_fanSpeedPolicyOperState"
    SORT_PROP_EQUIPMENT_FAN_ID = "equipment_Fan_id"
    SORT_PROP_EQUIPMENT_FAN_INT_TYPE = "equipment_Fan_intType"
    SORT_PROP_EQUIPMENT_FAN_MODEL = "equipment_Fan_model"
    SORT_PROP_EQUIPMENT_FAN_MODULE = "equipment_Fan_module"
    SORT_PROP_EQUIPMENT_FAN_OPER_QUALIFIER_REASON = "equipment_Fan_operQualifierReason"
    SORT_PROP_EQUIPMENT_FAN_OPER_STATE = "equipment_Fan_operState"
    SORT_PROP_EQUIPMENT_FAN_OPERABILITY = "equipment_Fan_operability"
    SORT_PROP_EQUIPMENT_FAN_PERF = "equipment_Fan_perf"
    SORT_PROP_EQUIPMENT_FAN_POWER = "equipment_Fan_power"
    SORT_PROP_EQUIPMENT_FAN_PRESENCE = "equipment_Fan_presence"
    SORT_PROP_EQUIPMENT_FAN_REVISION = "equipment_Fan_revision"
    SORT_PROP_EQUIPMENT_FAN_SERIAL = "equipment_Fan_serial"
    SORT_PROP_EQUIPMENT_FAN_THERMAL = "equipment_Fan_thermal"
    SORT_PROP_EQUIPMENT_FAN_TRAY = "equipment_Fan_tray"
    SORT_PROP_EQUIPMENT_FAN_VENDOR = "equipment_Fan_vendor"
    SORT_PROP_EQUIPMENT_FAN_VOLTAGE = "equipment_Fan_voltage"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_DEPRECATED = "equipment_FexCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_GENCOUNT = "equipment_FexCapProvider_gencount"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_FexCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_MODEL = "equipment_FexCapProvider_model"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_FexCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_REVISION = "equipment_FexCapProvider_revision"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_ROLE = "equipment_FexCapProvider_role"
    SORT_PROP_EQUIPMENT_FEX_CAP_PROVIDER_VENDOR = "equipment_FexCapProvider_vendor"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_DIE1 = "equipment_FexEnvStatsHist_die1"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_DIE1_AVG = "equipment_FexEnvStatsHist_die1Avg"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_DIE1_MAX = "equipment_FexEnvStatsHist_die1Max"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_DIE1_MIN = "equipment_FexEnvStatsHist_die1Min"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_ID = "equipment_FexEnvStatsHist_id"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_INLET = "equipment_FexEnvStatsHist_inlet"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_INLET1 = "equipment_FexEnvStatsHist_inlet1"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_INLET1_AVG = "equipment_FexEnvStatsHist_inlet1Avg"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_INLET1_MAX = "equipment_FexEnvStatsHist_inlet1Max"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_INLET1_MIN = "equipment_FexEnvStatsHist_inlet1Min"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_INLET_AVG = "equipment_FexEnvStatsHist_inletAvg"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_INLET_MAX = "equipment_FexEnvStatsHist_inletMax"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_INLET_MIN = "equipment_FexEnvStatsHist_inletMin"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_MOST_RECENT = "equipment_FexEnvStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET1 = "equipment_FexEnvStatsHist_outlet1"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET1_AVG = "equipment_FexEnvStatsHist_outlet1Avg"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET1_MAX = "equipment_FexEnvStatsHist_outlet1Max"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET1_MIN = "equipment_FexEnvStatsHist_outlet1Min"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET2 = "equipment_FexEnvStatsHist_outlet2"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET2_AVG = "equipment_FexEnvStatsHist_outlet2Avg"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET2_MAX = "equipment_FexEnvStatsHist_outlet2Max"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_OUTLET2_MIN = "equipment_FexEnvStatsHist_outlet2Min"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_SUSPECT = "equipment_FexEnvStatsHist_suspect"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_THRESHOLDED = "equipment_FexEnvStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_HIST_TIME_COLLECTED = "equipment_FexEnvStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_DIE1 = "equipment_FexEnvStats_die1"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_DIE1_AVG = "equipment_FexEnvStats_die1Avg"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_DIE1_MAX = "equipment_FexEnvStats_die1Max"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_DIE1_MIN = "equipment_FexEnvStats_die1Min"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_INLET = "equipment_FexEnvStats_inlet"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_INLET1 = "equipment_FexEnvStats_inlet1"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_INLET1_AVG = "equipment_FexEnvStats_inlet1Avg"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_INLET1_MAX = "equipment_FexEnvStats_inlet1Max"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_INLET1_MIN = "equipment_FexEnvStats_inlet1Min"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_INLET_AVG = "equipment_FexEnvStats_inletAvg"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_INLET_MAX = "equipment_FexEnvStats_inletMax"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_INLET_MIN = "equipment_FexEnvStats_inletMin"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_INPUT_STATUS = "equipment_FexEnvStats_inputStatus"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_INTERVALS = "equipment_FexEnvStats_intervals"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_NORMALIZED_TIME_COL = "equipment_FexEnvStats_normalizedTimeCol"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_OUTLET1 = "equipment_FexEnvStats_outlet1"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_OUTLET1_AVG = "equipment_FexEnvStats_outlet1Avg"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_OUTLET1_MAX = "equipment_FexEnvStats_outlet1Max"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_OUTLET1_MIN = "equipment_FexEnvStats_outlet1Min"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_OUTLET2 = "equipment_FexEnvStats_outlet2"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_OUTLET2_AVG = "equipment_FexEnvStats_outlet2Avg"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_OUTLET2_MAX = "equipment_FexEnvStats_outlet2Max"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_OUTLET2_MIN = "equipment_FexEnvStats_outlet2Min"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_STATS_REPORTED = "equipment_FexEnvStats_statsReported"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_SUSPECT = "equipment_FexEnvStats_suspect"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_THRESHOLDED = "equipment_FexEnvStats_thresholded"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_TIME_COLLECTED = "equipment_FexEnvStats_timeCollected"
    SORT_PROP_EQUIPMENT_FEX_ENV_STATS_UPDATE = "equipment_FexEnvStats_update"
    SORT_PROP_EQUIPMENT_FEX_OPERATION_ADMIN_STATE = "equipment_FexOperation_adminState"
    SORT_PROP_EQUIPMENT_FEX_OPERATION_LAST_MODIFIED = "equipment_FexOperation_lastModified"
    SORT_PROP_EQUIPMENT_FEX_OPERATION_REMOTE_ERROR_CODE = "equipment_FexOperation_remoteErrorCode"
    SORT_PROP_EQUIPMENT_FEX_OPERATION_REMOTE_ERROR_DESCR = "equipment_FexOperation_remoteErrorDescr"
    SORT_PROP_EQUIPMENT_FEX_OPERATION_TRIGGER_STATUS = "equipment_FexOperation_triggerStatus"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_MODULE_POWER = "equipment_FexPowerSummaryHist_ModulePower"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_MODULE_POWER_AVG = "equipment_FexPowerSummaryHist_ModulePowerAvg"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_MODULE_POWER_MAX = "equipment_FexPowerSummaryHist_ModulePowerMax"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_MODULE_POWER_MIN = "equipment_FexPowerSummaryHist_ModulePowerMin"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_AVAILABLE_POWER = "equipment_FexPowerSummaryHist_availablePower"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_AVAILABLE_POWER_AVG = "equipment_FexPowerSummaryHist_availablePowerAvg"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_AVAILABLE_POWER_MAX = "equipment_FexPowerSummaryHist_availablePowerMax"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_AVAILABLE_POWER_MIN = "equipment_FexPowerSummaryHist_availablePowerMin"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_ID = "equipment_FexPowerSummaryHist_id"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_MOST_RECENT = "equipment_FexPowerSummaryHist_mostRecent"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_RESERVED_POWER = "equipment_FexPowerSummaryHist_reservedPower"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_RESERVED_POWER_AVG = "equipment_FexPowerSummaryHist_reservedPowerAvg"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_RESERVED_POWER_MAX = "equipment_FexPowerSummaryHist_reservedPowerMax"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_RESERVED_POWER_MIN = "equipment_FexPowerSummaryHist_reservedPowerMin"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_SUSPECT = "equipment_FexPowerSummaryHist_suspect"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_THRESHOLDED = "equipment_FexPowerSummaryHist_thresholded"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_TIME_COLLECTED = "equipment_FexPowerSummaryHist_timeCollected"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_TOTAL_POWER = "equipment_FexPowerSummaryHist_totalPower"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_TOTAL_POWER_AVG = "equipment_FexPowerSummaryHist_totalPowerAvg"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_TOTAL_POWER_MAX = "equipment_FexPowerSummaryHist_totalPowerMax"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_HIST_TOTAL_POWER_MIN = "equipment_FexPowerSummaryHist_totalPowerMin"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_MODULE_POWER = "equipment_FexPowerSummary_ModulePower"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_MODULE_POWER_AVG = "equipment_FexPowerSummary_ModulePowerAvg"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_MODULE_POWER_MAX = "equipment_FexPowerSummary_ModulePowerMax"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_MODULE_POWER_MIN = "equipment_FexPowerSummary_ModulePowerMin"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_AVAILABLE_POWER = "equipment_FexPowerSummary_availablePower"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_AVAILABLE_POWER_AVG = "equipment_FexPowerSummary_availablePowerAvg"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_AVAILABLE_POWER_MAX = "equipment_FexPowerSummary_availablePowerMax"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_AVAILABLE_POWER_MIN = "equipment_FexPowerSummary_availablePowerMin"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_INTERVALS = "equipment_FexPowerSummary_intervals"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_NORMALIZED_TIME_COL = "equipment_FexPowerSummary_normalizedTimeCol"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_RESERVED_POWER = "equipment_FexPowerSummary_reservedPower"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_RESERVED_POWER_AVG = "equipment_FexPowerSummary_reservedPowerAvg"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_RESERVED_POWER_MAX = "equipment_FexPowerSummary_reservedPowerMax"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_RESERVED_POWER_MIN = "equipment_FexPowerSummary_reservedPowerMin"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_STATS_REPORTED = "equipment_FexPowerSummary_statsReported"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_SUSPECT = "equipment_FexPowerSummary_suspect"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_THRESHOLDED = "equipment_FexPowerSummary_thresholded"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_TIME_COLLECTED = "equipment_FexPowerSummary_timeCollected"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_TOTAL_POWER = "equipment_FexPowerSummary_totalPower"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_TOTAL_POWER_AVG = "equipment_FexPowerSummary_totalPowerAvg"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_TOTAL_POWER_MAX = "equipment_FexPowerSummary_totalPowerMax"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_TOTAL_POWER_MIN = "equipment_FexPowerSummary_totalPowerMin"
    SORT_PROP_EQUIPMENT_FEX_POWER_SUMMARY_UPDATE = "equipment_FexPowerSummary_update"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_CURRENT = "equipment_FexPsuInputStatsHist_current"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_CURRENT_AVG = "equipment_FexPsuInputStatsHist_currentAvg"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_CURRENT_MAX = "equipment_FexPsuInputStatsHist_currentMax"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_CURRENT_MIN = "equipment_FexPsuInputStatsHist_currentMin"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_ID = "equipment_FexPsuInputStatsHist_id"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_MOST_RECENT = "equipment_FexPsuInputStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_POWER = "equipment_FexPsuInputStatsHist_power"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_POWER_AVG = "equipment_FexPsuInputStatsHist_powerAvg"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_POWER_MAX = "equipment_FexPsuInputStatsHist_powerMax"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_POWER_MIN = "equipment_FexPsuInputStatsHist_powerMin"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_SUSPECT = "equipment_FexPsuInputStatsHist_suspect"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_THRESHOLDED = "equipment_FexPsuInputStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_TIME_COLLECTED = "equipment_FexPsuInputStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_VOLTAGE = "equipment_FexPsuInputStatsHist_voltage"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_VOLTAGE_AVG = "equipment_FexPsuInputStatsHist_voltageAvg"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_VOLTAGE_MAX = "equipment_FexPsuInputStatsHist_voltageMax"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_HIST_VOLTAGE_MIN = "equipment_FexPsuInputStatsHist_voltageMin"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_CURRENT = "equipment_FexPsuInputStats_current"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_CURRENT_AVG = "equipment_FexPsuInputStats_currentAvg"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_CURRENT_MAX = "equipment_FexPsuInputStats_currentMax"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_CURRENT_MIN = "equipment_FexPsuInputStats_currentMin"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_INPUT_STATUS = "equipment_FexPsuInputStats_inputStatus"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_INTERVALS = "equipment_FexPsuInputStats_intervals"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_NORMALIZED_TIME_COL = "equipment_FexPsuInputStats_normalizedTimeCol"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_POWER = "equipment_FexPsuInputStats_power"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_POWER_AVG = "equipment_FexPsuInputStats_powerAvg"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_POWER_MAX = "equipment_FexPsuInputStats_powerMax"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_POWER_MIN = "equipment_FexPsuInputStats_powerMin"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_STATS_REPORTED = "equipment_FexPsuInputStats_statsReported"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_SUSPECT = "equipment_FexPsuInputStats_suspect"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_THRESHOLDED = "equipment_FexPsuInputStats_thresholded"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_TIME_COLLECTED = "equipment_FexPsuInputStats_timeCollected"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_UPDATE = "equipment_FexPsuInputStats_update"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_VOLTAGE = "equipment_FexPsuInputStats_voltage"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_VOLTAGE_AVG = "equipment_FexPsuInputStats_voltageAvg"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_VOLTAGE_MAX = "equipment_FexPsuInputStats_voltageMax"
    SORT_PROP_EQUIPMENT_FEX_PSU_INPUT_STATS_VOLTAGE_MIN = "equipment_FexPsuInputStats_voltageMin"
    SORT_PROP_EQUIPMENT_FEX_ADMIN_POWER_STATE = "equipment_Fex_adminPowerState"
    SORT_PROP_EQUIPMENT_FEX_ADMIN_STATE = "equipment_Fex_adminState"
    SORT_PROP_EQUIPMENT_FEX_CONFIG_STATE = "equipment_Fex_configState"
    SORT_PROP_EQUIPMENT_FEX_ID = "equipment_Fex_id"
    SORT_PROP_EQUIPMENT_FEX_MODEL = "equipment_Fex_model"
    SORT_PROP_EQUIPMENT_FEX_OPER_QUALIFIER = "equipment_Fex_operQualifier"
    SORT_PROP_EQUIPMENT_FEX_OPER_QUALIFIER_REASON = "equipment_Fex_operQualifierReason"
    SORT_PROP_EQUIPMENT_FEX_OPER_STATE = "equipment_Fex_operState"
    SORT_PROP_EQUIPMENT_FEX_OPERABILITY = "equipment_Fex_operability"
    SORT_PROP_EQUIPMENT_FEX_POWER = "equipment_Fex_power"
    SORT_PROP_EQUIPMENT_FEX_PRESENCE = "equipment_Fex_presence"
    SORT_PROP_EQUIPMENT_FEX_REVISION = "equipment_Fex_revision"
    SORT_PROP_EQUIPMENT_FEX_SERIAL = "equipment_Fex_serial"
    SORT_PROP_EQUIPMENT_FEX_SWITCH_ID = "equipment_Fex_switchId"
    SORT_PROP_EQUIPMENT_FEX_THERMAL = "equipment_Fex_thermal"
    SORT_PROP_EQUIPMENT_FEX_USR_LBL = "equipment_Fex_usrLbl"
    SORT_PROP_EQUIPMENT_FEX_VENDOR = "equipment_Fex_vendor"
    SORT_PROP_EQUIPMENT_FEX_VOLTAGE = "equipment_Fex_voltage"
    SORT_PROP_EQUIPMENT_FRU_CAP_PROVIDER_DEPRECATED = "equipment_FruCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_FRU_CAP_PROVIDER_GENCOUNT = "equipment_FruCapProvider_gencount"
    SORT_PROP_EQUIPMENT_FRU_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_FruCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_FRU_CAP_PROVIDER_MODEL = "equipment_FruCapProvider_model"
    SORT_PROP_EQUIPMENT_FRU_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_FruCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_FRU_CAP_PROVIDER_REVISION = "equipment_FruCapProvider_revision"
    SORT_PROP_EQUIPMENT_FRU_CAP_PROVIDER_VENDOR = "equipment_FruCapProvider_vendor"
    SORT_PROP_EQUIPMENT_FRU_VARIANT_DESCRIPTION = "equipment_FruVariant_description"
    SORT_PROP_EQUIPMENT_FRU_VARIANT_PID = "equipment_FruVariant_pid"
    SORT_PROP_EQUIPMENT_FRU_VARIANT_TYPE = "equipment_FruVariant_type"
    SORT_PROP_EQUIPMENT_FRUID_INFO_ASSET_TAG = "equipment_FruidInfo_assetTag"
    SORT_PROP_EQUIPMENT_FRUID_INFO_PART_NUMBER = "equipment_FruidInfo_partNumber"
    SORT_PROP_EQUIPMENT_FRUID_INFO_VID = "equipment_FruidInfo_vid"
    SORT_PROP_EQUIPMENT_GEM_CAP_PROVIDER_DEPRECATED = "equipment_GemCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_GEM_CAP_PROVIDER_GENCOUNT = "equipment_GemCapProvider_gencount"
    SORT_PROP_EQUIPMENT_GEM_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_GemCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_GEM_CAP_PROVIDER_MODEL = "equipment_GemCapProvider_model"
    SORT_PROP_EQUIPMENT_GEM_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_GemCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_GEM_CAP_PROVIDER_REVISION = "equipment_GemCapProvider_revision"
    SORT_PROP_EQUIPMENT_GEM_CAP_PROVIDER_VENDOR = "equipment_GemCapProvider_vendor"
    SORT_PROP_EQUIPMENT_HEALTH_LED_COLOR = "equipment_HealthLed_color"
    SORT_PROP_EQUIPMENT_HEALTH_LED_HEALTH_LED_STATE = "equipment_HealthLed_healthLedState"
    SORT_PROP_EQUIPMENT_HEALTH_LED_HEALTH_LED_STATE_QUALIFIER = "equipment_HealthLed_healthLedStateQualifier"
    SORT_PROP_EQUIPMENT_HEALTH_LED_ID = "equipment_HealthLed_id"
    SORT_PROP_EQUIPMENT_HEALTH_LED_NAME = "equipment_HealthLed_name"
    SORT_PROP_EQUIPMENT_HEALTH_LED_OPER_STATE = "equipment_HealthLed_operState"
    SORT_PROP_EQUIPMENT_HOLDER_CAP_PROVIDER_DEPRECATED = "equipment_HolderCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_HOLDER_CAP_PROVIDER_GENCOUNT = "equipment_HolderCapProvider_gencount"
    SORT_PROP_EQUIPMENT_HOLDER_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_HolderCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_HOLDER_CAP_PROVIDER_MODEL = "equipment_HolderCapProvider_model"
    SORT_PROP_EQUIPMENT_HOLDER_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_HolderCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_HOLDER_CAP_PROVIDER_REVISION = "equipment_HolderCapProvider_revision"
    SORT_PROP_EQUIPMENT_HOLDER_CAP_PROVIDER_VENDOR = "equipment_HolderCapProvider_vendor"
    SORT_PROP_EQUIPMENT_HOLDER_ID = "equipment_Holder_id"
    SORT_PROP_EQUIPMENT_HOLDER_MODEL = "equipment_Holder_model"
    SORT_PROP_EQUIPMENT_HOLDER_OPER_QUALIFIER_REASON = "equipment_Holder_operQualifierReason"
    SORT_PROP_EQUIPMENT_HOLDER_OPERABILITY = "equipment_Holder_operability"
    SORT_PROP_EQUIPMENT_HOLDER_PRESENCE = "equipment_Holder_presence"
    SORT_PROP_EQUIPMENT_HOLDER_REVISION = "equipment_Holder_revision"
    SORT_PROP_EQUIPMENT_HOLDER_SERIAL = "equipment_Holder_serial"
    SORT_PROP_EQUIPMENT_HOLDER_VENDOR = "equipment_Holder_vendor"
    SORT_PROP_EQUIPMENT_HOST_IF_CAP_PROVIDER_DEPRECATED = "equipment_HostIfCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_HOST_IF_CAP_PROVIDER_GENCOUNT = "equipment_HostIfCapProvider_gencount"
    SORT_PROP_EQUIPMENT_HOST_IF_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_HostIfCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_HOST_IF_CAP_PROVIDER_MODEL = "equipment_HostIfCapProvider_model"
    SORT_PROP_EQUIPMENT_HOST_IF_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_HostIfCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_HOST_IF_CAP_PROVIDER_REVISION = "equipment_HostIfCapProvider_revision"
    SORT_PROP_EQUIPMENT_HOST_IF_CAP_PROVIDER_VENDOR = "equipment_HostIfCapProvider_vendor"
    SORT_PROP_EQUIPMENT_HW_CAP_PROVIDER_DEPRECATED = "equipment_HwCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_HW_CAP_PROVIDER_GENCOUNT = "equipment_HwCapProvider_gencount"
    SORT_PROP_EQUIPMENT_HW_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_HwCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_HW_CAP_PROVIDER_MODEL = "equipment_HwCapProvider_model"
    SORT_PROP_EQUIPMENT_HW_CAP_PROVIDER_REVISION = "equipment_HwCapProvider_revision"
    SORT_PROP_EQUIPMENT_HW_CAP_PROVIDER_VENDOR = "equipment_HwCapProvider_vendor"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_ADMIN_PEER_POWER_STATE = "equipment_IOCardBase_adminPeerPowerState"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_ADMIN_POWER_STATE = "equipment_IOCardBase_adminPowerState"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_ADMIN_STATE = "equipment_IOCardBase_adminState"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_BASE_ADDR = "equipment_IOCardBase_baseAddr"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_CHASSIS_ID = "equipment_IOCardBase_chassisId"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_CONFIG_STATE = "equipment_IOCardBase_configState"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_DISCOVERY = "equipment_IOCardBase_discovery"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FE_OFFLINE_TS = "equipment_IOCardBase_feOfflineTs"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FE_READY_TS = "equipment_IOCardBase_feReadyTs"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_FLT_AGGR = "equipment_IOCardBase_fltAggr"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_ID = "equipment_IOCardBase_id"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_LC_NAME = "equipment_IOCardBase_lcName"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_LC_TS = "equipment_IOCardBase_lcTs"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_MODEL = "equipment_IOCardBase_model"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_OPER_EVAC_STATE = "equipment_IOCardBase_operEvacState"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_OPER_QUALIFIER = "equipment_IOCardBase_operQualifier"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_OPER_QUALIFIER_REASON = "equipment_IOCardBase_operQualifierReason"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_OPER_STATE = "equipment_IOCardBase_operState"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_OPERABILITY = "equipment_IOCardBase_operability"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_PEER_COMM_STATUS = "equipment_IOCardBase_peerCommStatus"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_PEER_DN = "equipment_IOCardBase_peerDn"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_PERF = "equipment_IOCardBase_perf"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_POWER = "equipment_IOCardBase_power"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_PRESENCE = "equipment_IOCardBase_presence"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_PROCESSOR_THERMAL_STATE = "equipment_IOCardBase_processorThermalState"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_REVISION = "equipment_IOCardBase_revision"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_SERIAL = "equipment_IOCardBase_serial"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_SIDE = "equipment_IOCardBase_side"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_SWITCH_ID = "equipment_IOCardBase_switchId"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_THERMAL = "equipment_IOCardBase_thermal"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_UPGRADE_STATUS = "equipment_IOCardBase_upgradeStatus"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_USR_LBL = "equipment_IOCardBase_usrLbl"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_VENDOR = "equipment_IOCardBase_vendor"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_VOLTAGE = "equipment_IOCardBase_voltage"
    SORT_PROP_EQUIPMENT_IOCARD_CAP_PROVIDER_DEPRECATED = "equipment_IOCardCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_IOCARD_CAP_PROVIDER_GENCOUNT = "equipment_IOCardCapProvider_gencount"
    SORT_PROP_EQUIPMENT_IOCARD_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_IOCardCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_IOCARD_CAP_PROVIDER_MODEL = "equipment_IOCardCapProvider_model"
    SORT_PROP_EQUIPMENT_IOCARD_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_IOCardCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_IOCARD_CAP_PROVIDER_REVISION = "equipment_IOCardCapProvider_revision"
    SORT_PROP_EQUIPMENT_IOCARD_CAP_PROVIDER_VENDOR = "equipment_IOCardCapProvider_vendor"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_AMBIENT_TEMP = "equipment_IOCardStatsHist_ambientTemp"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_AMBIENT_TEMP_AVG = "equipment_IOCardStatsHist_ambientTempAvg"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_AMBIENT_TEMP_MAX = "equipment_IOCardStatsHist_ambientTempMax"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_AMBIENT_TEMP_MIN = "equipment_IOCardStatsHist_ambientTempMin"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_ID = "equipment_IOCardStatsHist_id"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_MOST_RECENT = "equipment_IOCardStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_SUSPECT = "equipment_IOCardStatsHist_suspect"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_TEMP = "equipment_IOCardStatsHist_temp"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_TEMP_AVG = "equipment_IOCardStatsHist_tempAvg"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_TEMP_MAX = "equipment_IOCardStatsHist_tempMax"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_TEMP_MIN = "equipment_IOCardStatsHist_tempMin"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_THRESHOLDED = "equipment_IOCardStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_HIST_TIME_COLLECTED = "equipment_IOCardStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_AMBIENT_TEMP = "equipment_IOCardStats_ambientTemp"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_AMBIENT_TEMP_AVG = "equipment_IOCardStats_ambientTempAvg"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_AMBIENT_TEMP_MAX = "equipment_IOCardStats_ambientTempMax"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_AMBIENT_TEMP_MIN = "equipment_IOCardStats_ambientTempMin"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_INTERVALS = "equipment_IOCardStats_intervals"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_NORMALIZED_TIME_COL = "equipment_IOCardStats_normalizedTimeCol"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_STATS_REPORTED = "equipment_IOCardStats_statsReported"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_SUSPECT = "equipment_IOCardStats_suspect"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_TEMP = "equipment_IOCardStats_temp"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_TEMP_AVG = "equipment_IOCardStats_tempAvg"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_TEMP_MAX = "equipment_IOCardStats_tempMax"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_TEMP_MIN = "equipment_IOCardStats_tempMin"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_THRESHOLDED = "equipment_IOCardStats_thresholded"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_TIME_COLLECTED = "equipment_IOCardStats_timeCollected"
    SORT_PROP_EQUIPMENT_IOCARD_STATS_UPDATE = "equipment_IOCardStats_update"
    SORT_PROP_EQUIPMENT_IOCARD_ADMIN_PEER_POWER_STATE = "equipment_IOCard_adminPeerPowerState"
    SORT_PROP_EQUIPMENT_IOCARD_ADMIN_POWER_STATE = "equipment_IOCard_adminPowerState"
    SORT_PROP_EQUIPMENT_IOCARD_ADMIN_STATE = "equipment_IOCard_adminState"
    SORT_PROP_EQUIPMENT_IOCARD_ASSET_TAG = "equipment_IOCard_assetTag"
    SORT_PROP_EQUIPMENT_IOCARD_BASE_ADDR = "equipment_IOCard_baseAddr"
    SORT_PROP_EQUIPMENT_IOCARD_CHASSIS_ID = "equipment_IOCard_chassisId"
    SORT_PROP_EQUIPMENT_IOCARD_CONFIG_STATE = "equipment_IOCard_configState"
    SORT_PROP_EQUIPMENT_IOCARD_DISCOVERY = "equipment_IOCard_discovery"
    SORT_PROP_EQUIPMENT_IOCARD_FE_OFFLINE_TS = "equipment_IOCard_feOfflineTs"
    SORT_PROP_EQUIPMENT_IOCARD_FE_READY_TS = "equipment_IOCard_feReadyTs"
    SORT_PROP_EQUIPMENT_IOCARD_FLT_AGGR = "equipment_IOCard_fltAggr"
    SORT_PROP_EQUIPMENT_IOCARD_ID = "equipment_IOCard_id"
    SORT_PROP_EQUIPMENT_IOCARD_LC_NAME = "equipment_IOCard_lcName"
    SORT_PROP_EQUIPMENT_IOCARD_LC_TS = "equipment_IOCard_lcTs"
    SORT_PROP_EQUIPMENT_IOCARD_MFG_TIME = "equipment_IOCard_mfgTime"
    SORT_PROP_EQUIPMENT_IOCARD_MODEL = "equipment_IOCard_model"
    SORT_PROP_EQUIPMENT_IOCARD_OPER_EVAC_STATE = "equipment_IOCard_operEvacState"
    SORT_PROP_EQUIPMENT_IOCARD_OPER_QUALIFIER = "equipment_IOCard_operQualifier"
    SORT_PROP_EQUIPMENT_IOCARD_OPER_QUALIFIER_REASON = "equipment_IOCard_operQualifierReason"
    SORT_PROP_EQUIPMENT_IOCARD_OPER_STATE = "equipment_IOCard_operState"
    SORT_PROP_EQUIPMENT_IOCARD_OPERABILITY = "equipment_IOCard_operability"
    SORT_PROP_EQUIPMENT_IOCARD_PART_NUMBER = "equipment_IOCard_partNumber"
    SORT_PROP_EQUIPMENT_IOCARD_PEER_COMM_STATUS = "equipment_IOCard_peerCommStatus"
    SORT_PROP_EQUIPMENT_IOCARD_PEER_DN = "equipment_IOCard_peerDn"
    SORT_PROP_EQUIPMENT_IOCARD_PERF = "equipment_IOCard_perf"
    SORT_PROP_EQUIPMENT_IOCARD_POWER = "equipment_IOCard_power"
    SORT_PROP_EQUIPMENT_IOCARD_PRESENCE = "equipment_IOCard_presence"
    SORT_PROP_EQUIPMENT_IOCARD_PROCESSOR_THERMAL_STATE = "equipment_IOCard_processorThermalState"
    SORT_PROP_EQUIPMENT_IOCARD_REVISION = "equipment_IOCard_revision"
    SORT_PROP_EQUIPMENT_IOCARD_SERIAL = "equipment_IOCard_serial"
    SORT_PROP_EQUIPMENT_IOCARD_SIDE = "equipment_IOCard_side"
    SORT_PROP_EQUIPMENT_IOCARD_SWITCH_ID = "equipment_IOCard_switchId"
    SORT_PROP_EQUIPMENT_IOCARD_THERMAL = "equipment_IOCard_thermal"
    SORT_PROP_EQUIPMENT_IOCARD_UPGRADE_STATUS = "equipment_IOCard_upgradeStatus"
    SORT_PROP_EQUIPMENT_IOCARD_USR_LBL = "equipment_IOCard_usrLbl"
    SORT_PROP_EQUIPMENT_IOCARD_VENDOR = "equipment_IOCard_vendor"
    SORT_PROP_EQUIPMENT_IOCARD_VID = "equipment_IOCard_vid"
    SORT_PROP_EQUIPMENT_IOCARD_VOLTAGE = "equipment_IOCard_voltage"
    SORT_PROP_EQUIPMENT_IMPLIED_STORAGE_ENCLOSURE_DEF_DESCRIPTION = "equipment_ImpliedStorageEnclosureDef_description"
    SORT_PROP_EQUIPMENT_IMPLIED_STORAGE_ENCLOSURE_DEF_ENCLOSURE_ID = "equipment_ImpliedStorageEnclosureDef_enclosureId"
    SORT_PROP_EQUIPMENT_IMPLIED_STORAGE_ENCLOSURE_DEF_FIRST_SLOT_IDX = "equipment_ImpliedStorageEnclosureDef_firstSlotIdx"
    SORT_PROP_EQUIPMENT_IMPLIED_STORAGE_ENCLOSURE_DEF_MODEL = "equipment_ImpliedStorageEnclosureDef_model"
    SORT_PROP_EQUIPMENT_IMPLIED_STORAGE_ENCLOSURE_DEF_NUM_SLOTS = "equipment_ImpliedStorageEnclosureDef_numSlots"
    SORT_PROP_EQUIPMENT_IMPLIED_STORAGE_ENCLOSURE_DEF_VENDOR = "equipment_ImpliedStorageEnclosureDef_vendor"
    SORT_PROP_EQUIPMENT_INDICATOR_LED_COLOR = "equipment_IndicatorLed_color"
    SORT_PROP_EQUIPMENT_INDICATOR_LED_ID = "equipment_IndicatorLed_id"
    SORT_PROP_EQUIPMENT_INDICATOR_LED_NAME = "equipment_IndicatorLed_name"
    SORT_PROP_EQUIPMENT_INDICATOR_LED_OPER_STATE = "equipment_IndicatorLed_operState"
    SORT_PROP_EQUIPMENT_INFO_MODEL = "equipment_Info_model"
    SORT_PROP_EQUIPMENT_INFO_REVISION = "equipment_Info_revision"
    SORT_PROP_EQUIPMENT_INFO_SERIAL = "equipment_Info_serial"
    SORT_PROP_EQUIPMENT_INFO_VENDOR = "equipment_Info_vendor"
    SORT_PROP_EQUIPMENT_INSTANCE_MAPPING_CP_DN = "equipment_InstanceMapping_cpDn"
    SORT_PROP_EQUIPMENT_INSTANCE_MAPPING_DESCR = "equipment_InstanceMapping_descr"
    SORT_PROP_EQUIPMENT_INSTANCE_MAPPING_INSTANCE_DN = "equipment_InstanceMapping_instanceDn"
    SORT_PROP_EQUIPMENT_INSTANCE_MAPPING_INT_ID = "equipment_InstanceMapping_intId"
    SORT_PROP_EQUIPMENT_INSTANCE_MAPPING_NAME = "equipment_InstanceMapping_name"
    SORT_PROP_EQUIPMENT_INSTANCE_MAPPING_POLICY_LEVEL = "equipment_InstanceMapping_policyLevel"
    SORT_PROP_EQUIPMENT_INSTANCE_MAPPING_POLICY_OWNER = "equipment_InstanceMapping_policyOwner"
    SORT_PROP_EQUIPMENT_INSTANCE_ASSIGN_STATE = "equipment_Instance_assignState"
    SORT_PROP_EQUIPMENT_INSTANCE_ASSOC_STATE = "equipment_Instance_assocState"
    SORT_PROP_EQUIPMENT_INSTANCE_CONFIG_QUALIFIER = "equipment_Instance_configQualifier"
    SORT_PROP_EQUIPMENT_INSTANCE_CONFIG_STATE = "equipment_Instance_configState"
    SORT_PROP_EQUIPMENT_INSTANCE_DESCR = "equipment_Instance_descr"
    SORT_PROP_EQUIPMENT_INSTANCE_GLOBAL_CP_DN = "equipment_Instance_globalCpDn"
    SORT_PROP_EQUIPMENT_INSTANCE_GUID = "equipment_Instance_guid"
    SORT_PROP_EQUIPMENT_INSTANCE_ID = "equipment_Instance_id"
    SORT_PROP_EQUIPMENT_INSTANCE_INT_ID = "equipment_Instance_intId"
    SORT_PROP_EQUIPMENT_INSTANCE_MGMT_IP_ADDR = "equipment_Instance_mgmtIpAddr"
    SORT_PROP_EQUIPMENT_INSTANCE_NAME = "equipment_Instance_name"
    SORT_PROP_EQUIPMENT_INSTANCE_OPER_STATE = "equipment_Instance_operState"
    SORT_PROP_EQUIPMENT_INSTANCE_PHYS_DN = "equipment_Instance_physDn"
    SORT_PROP_EQUIPMENT_INSTANCE_POLICY_LEVEL = "equipment_Instance_policyLevel"
    SORT_PROP_EQUIPMENT_INSTANCE_POLICY_OWNER = "equipment_Instance_policyOwner"
    SORT_PROP_EQUIPMENT_INSTANCE_SYSTEM_NAME = "equipment_Instance_systemName"
    SORT_PROP_EQUIPMENT_INSTANCE_TEMPL_DN = "equipment_Instance_templDn"
    SORT_PROP_EQUIPMENT_INSTANCE_USR_LBL = "equipment_Instance_usrLbl"
    SORT_PROP_EQUIPMENT_INSTANCE_UUID = "equipment_Instance_uuid"
    SORT_PROP_EQUIPMENT_INSTANCE_VERSION = "equipment_Instance_version"
    SORT_PROP_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_DEPRECATED = "equipment_IntegratedComponentCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_GENCOUNT = "equipment_IntegratedComponentCapProvider_gencount"
    SORT_PROP_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_IntegratedComponentCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_MODEL = "equipment_IntegratedComponentCapProvider_model"
    SORT_PROP_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_IntegratedComponentCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_REVISION = "equipment_IntegratedComponentCapProvider_revision"
    SORT_PROP_EQUIPMENT_INTEGRATED_COMPONENT_CAP_PROVIDER_VENDOR = "equipment_IntegratedComponentCapProvider_vendor"
    SORT_PROP_EQUIPMENT_ITEM_IF_ID = "equipment_ItemIf_id"
    SORT_PROP_EQUIPMENT_ITEM_ID = "equipment_Item_id"
    SORT_PROP_EQUIPMENT_ITEM_MODEL = "equipment_Item_model"
    SORT_PROP_EQUIPMENT_ITEM_REVISION = "equipment_Item_revision"
    SORT_PROP_EQUIPMENT_ITEM_SERIAL = "equipment_Item_serial"
    SORT_PROP_EQUIPMENT_ITEM_VENDOR = "equipment_Item_vendor"
    SORT_PROP_EQUIPMENT_LED_COLOR = "equipment_Led_color"
    SORT_PROP_EQUIPMENT_LED_ID = "equipment_Led_id"
    SORT_PROP_EQUIPMENT_LED_NAME = "equipment_Led_name"
    SORT_PROP_EQUIPMENT_LED_OPER_STATE = "equipment_Led_operState"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_DEPRECATED = "equipment_LocalDiskCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_GENCOUNT = "equipment_LocalDiskCapProvider_gencount"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_LocalDiskCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_MODEL = "equipment_LocalDiskCapProvider_model"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_LocalDiskCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_REVISION = "equipment_LocalDiskCapProvider_revision"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CAP_PROVIDER_VENDOR = "equipment_LocalDiskCapProvider_vendor"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_DEPRECATED = "equipment_LocalDiskControllerCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_FORM = "equipment_LocalDiskControllerCapProvider_form"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_GENCOUNT = "equipment_LocalDiskControllerCapProvider_gencount"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_INTERNALPORTS = "equipment_LocalDiskControllerCapProvider_internalports"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_LocalDiskControllerCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_MODEL = "equipment_LocalDiskControllerCapProvider_model"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_LocalDiskControllerCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_REVISION = "equipment_LocalDiskControllerCapProvider_revision"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_CONTROLLER_CAP_PROVIDER_VENDOR = "equipment_LocalDiskControllerCapProvider_vendor"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_BLOCK_SIZE = "equipment_LocalDiskDef_blockSize"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_CACHE_SIZE = "equipment_LocalDiskDef_cacheSize"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_CAPACITY = "equipment_LocalDiskDef_capacity"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_FORCE_UPDATE_VERSION = "equipment_LocalDiskDef_forceUpdateVersion"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_LINK_SPEED = "equipment_LocalDiskDef_linkSpeed"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_ME4308_SUPPORTED = "equipment_LocalDiskDef_me4308Supported"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_NAME = "equipment_LocalDiskDef_name"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_NUMBER_OF_BLOCKS = "equipment_LocalDiskDef_numberOfBlocks"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_ROTATIONAL_SPEED = "equipment_LocalDiskDef_rotationalSpeed"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_SEEK_AVERAGE_READ_WRITE = "equipment_LocalDiskDef_seekAverageReadWrite"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_SEEK_TRACK_TO_TRACK_READ_WRITE = "equipment_LocalDiskDef_seekTrackToTrackReadWrite"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_SELF_ENCRYPTING_DRIVE = "equipment_LocalDiskDef_selfEncryptingDrive"
    SORT_PROP_EQUIPMENT_LOCAL_DISK_DEF_TECHNOLOGY = "equipment_LocalDiskDef_technology"
    SORT_PROP_EQUIPMENT_LOCAL_TEMPL_DEF_DESCR = "equipment_LocalTemplDef_descr"
    SORT_PROP_EQUIPMENT_LOCAL_TEMPL_DEF_ID = "equipment_LocalTemplDef_id"
    SORT_PROP_EQUIPMENT_LOCAL_TEMPL_DEF_INT_ID = "equipment_LocalTemplDef_intId"
    SORT_PROP_EQUIPMENT_LOCAL_TEMPL_DEF_NAME = "equipment_LocalTemplDef_name"
    SORT_PROP_EQUIPMENT_LOCAL_TEMPL_DEF_POLICY_LEVEL = "equipment_LocalTemplDef_policyLevel"
    SORT_PROP_EQUIPMENT_LOCAL_TEMPL_DEF_POLICY_OWNER = "equipment_LocalTemplDef_policyOwner"
    SORT_PROP_EQUIPMENT_LOCAL_TEMPL_DEF_SYSTEM_NAME = "equipment_LocalTemplDef_systemName"
    SORT_PROP_EQUIPMENT_LOCAL_TEMPL_DEF_TYPE = "equipment_LocalTemplDef_type"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_OPERATION_ADMIN_STATE = "equipment_LocatorLedOperation_adminState"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_OPERATION_LAST_MODIFIED = "equipment_LocatorLedOperation_lastModified"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_OPERATION_REMOTE_ERROR_CODE = "equipment_LocatorLedOperation_remoteErrorCode"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_OPERATION_REMOTE_ERROR_DESCR = "equipment_LocatorLedOperation_remoteErrorDescr"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_OPERATION_TRIGGER_STATUS = "equipment_LocatorLedOperation_triggerStatus"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_ADMIN_STATE = "equipment_LocatorLed_adminState"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_COLOR = "equipment_LocatorLed_color"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_ID = "equipment_LocatorLed_id"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_NAME = "equipment_LocatorLed_name"
    SORT_PROP_EQUIPMENT_LOCATOR_LED_OPER_STATE = "equipment_LocatorLed_operState"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_CAPTION = "equipment_ManufacturingDef_caption"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_CLEI = "equipment_ManufacturingDef_clei"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_DESCRIPTION = "equipment_ManufacturingDef_description"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_FRU_MAJOR_TYPE = "equipment_ManufacturingDef_fruMajorType"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_FRU_MINOR_TYPE = "equipment_ManufacturingDef_fruMinorType"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_NAME = "equipment_ManufacturingDef_name"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_OEM_NAME = "equipment_ManufacturingDef_oemName"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_OEM_PART_NUMBER = "equipment_ManufacturingDef_oemPartNumber"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_PART_NUMBER = "equipment_ManufacturingDef_partNumber"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_PID = "equipment_ManufacturingDef_pid"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_SERIES = "equipment_ManufacturingDef_series"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_SKU = "equipment_ManufacturingDef_sku"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_VENDOR_EQUIPMENT_TYPE = "equipment_ManufacturingDef_vendorEquipmentType"
    SORT_PROP_EQUIPMENT_MANUFACTURING_DEF_VID = "equipment_ManufacturingDef_vid"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_DEPRECATED = "equipment_MemoryUnitCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_GENCOUNT = "equipment_MemoryUnitCapProvider_gencount"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_MemoryUnitCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_MODEL = "equipment_MemoryUnitCapProvider_model"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_MemoryUnitCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_REVISION = "equipment_MemoryUnitCapProvider_revision"
    SORT_PROP_EQUIPMENT_MEMORY_UNIT_CAP_PROVIDER_VENDOR = "equipment_MemoryUnitCapProvider_vendor"
    SORT_PROP_EQUIPMENT_MFG_INFO_MFG_TIME = "equipment_MfgInfo_mfgTime"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_DRIVE_PERCENTAGE = "equipment_NetworkElementFanStatsHist_drivePercentage"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_DRIVE_PERCENTAGE_AVG = "equipment_NetworkElementFanStatsHist_drivePercentageAvg"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_DRIVE_PERCENTAGE_MAX = "equipment_NetworkElementFanStatsHist_drivePercentageMax"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_DRIVE_PERCENTAGE_MIN = "equipment_NetworkElementFanStatsHist_drivePercentageMin"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_ID = "equipment_NetworkElementFanStatsHist_id"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_MOST_RECENT = "equipment_NetworkElementFanStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_SPEED = "equipment_NetworkElementFanStatsHist_speed"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_SPEED_AVG = "equipment_NetworkElementFanStatsHist_speedAvg"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_SPEED_MAX = "equipment_NetworkElementFanStatsHist_speedMax"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_SPEED_MIN = "equipment_NetworkElementFanStatsHist_speedMin"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_SUSPECT = "equipment_NetworkElementFanStatsHist_suspect"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_THRESHOLDED = "equipment_NetworkElementFanStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_HIST_TIME_COLLECTED = "equipment_NetworkElementFanStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_AIRFLOW_DIRECTION = "equipment_NetworkElementFanStats_airflowDirection"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_DRIVE_PERCENTAGE = "equipment_NetworkElementFanStats_drivePercentage"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_DRIVE_PERCENTAGE_AVG = "equipment_NetworkElementFanStats_drivePercentageAvg"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_DRIVE_PERCENTAGE_MAX = "equipment_NetworkElementFanStats_drivePercentageMax"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_DRIVE_PERCENTAGE_MIN = "equipment_NetworkElementFanStats_drivePercentageMin"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_INTERVALS = "equipment_NetworkElementFanStats_intervals"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_NORMALIZED_TIME_COL = "equipment_NetworkElementFanStats_normalizedTimeCol"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_SPEED = "equipment_NetworkElementFanStats_speed"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_SPEED_AVG = "equipment_NetworkElementFanStats_speedAvg"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_SPEED_MAX = "equipment_NetworkElementFanStats_speedMax"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_SPEED_MIN = "equipment_NetworkElementFanStats_speedMin"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_STATS_REPORTED = "equipment_NetworkElementFanStats_statsReported"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_SUSPECT = "equipment_NetworkElementFanStats_suspect"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_THRESHOLDED = "equipment_NetworkElementFanStats_thresholded"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_TIME_COLLECTED = "equipment_NetworkElementFanStats_timeCollected"
    SORT_PROP_EQUIPMENT_NETWORK_ELEMENT_FAN_STATS_UPDATE = "equipment_NetworkElementFanStats_update"
    SORT_PROP_EQUIPMENT_PCI_DEF_DEVICE = "equipment_PciDef_device"
    SORT_PROP_EQUIPMENT_PCI_DEF_DEVICE_TYPE = "equipment_PciDef_deviceType"
    SORT_PROP_EQUIPMENT_PCI_DEF_NAME = "equipment_PciDef_name"
    SORT_PROP_EQUIPMENT_PCI_DEF_SUBDEVICE = "equipment_PciDef_subdevice"
    SORT_PROP_EQUIPMENT_PCI_DEF_SUBVENDOR = "equipment_PciDef_subvendor"
    SORT_PROP_EQUIPMENT_PCI_DEF_VENDOR = "equipment_PciDef_vendor"
    SORT_PROP_EQUIPMENT_PHYSICAL_QUAL_MODEL = "equipment_PhysicalQual_model"
    SORT_PROP_EQUIPMENT_PICTURE_FILE_NAME = "equipment_Picture_fileName"
    SORT_PROP_EQUIPMENT_PICTURE_TYPE = "equipment_Picture_type"
    SORT_PROP_EQUIPMENT_PLACEABLE_DESCR = "equipment_Placeable_descr"
    SORT_PROP_EQUIPMENT_PLACEABLE_INT_ID = "equipment_Placeable_intId"
    SORT_PROP_EQUIPMENT_PLACEABLE_NAME = "equipment_Placeable_name"
    SORT_PROP_EQUIPMENT_PLACEABLE_PLACEMENT_REF_CNT = "equipment_Placeable_placementRefCnt"
    SORT_PROP_EQUIPMENT_PLACEABLE_POLICY_LEVEL = "equipment_Placeable_policyLevel"
    SORT_PROP_EQUIPMENT_PLACEABLE_POLICY_OWNER = "equipment_Placeable_policyOwner"
    SORT_PROP_EQUIPMENT_PLACED_DESCR = "equipment_Placed_descr"
    SORT_PROP_EQUIPMENT_PLACED_ID = "equipment_Placed_id"
    SORT_PROP_EQUIPMENT_PLACED_INT_ID = "equipment_Placed_intId"
    SORT_PROP_EQUIPMENT_PLACED_NAME = "equipment_Placed_name"
    SORT_PROP_EQUIPMENT_PLACED_POLICY_LEVEL = "equipment_Placed_policyLevel"
    SORT_PROP_EQUIPMENT_PLACED_POLICY_OWNER = "equipment_Placed_policyOwner"
    SORT_PROP_EQUIPMENT_PLACED_SYSTEM_NAME = "equipment_Placed_systemName"
    SORT_PROP_EQUIPMENT_POOL_ASSIGNED = "equipment_Pool_assigned"
    SORT_PROP_EQUIPMENT_POOL_DESCR = "equipment_Pool_descr"
    SORT_PROP_EQUIPMENT_POOL_FLT_AGGR = "equipment_Pool_fltAggr"
    SORT_PROP_EQUIPMENT_POOL_INT_ID = "equipment_Pool_intId"
    SORT_PROP_EQUIPMENT_POOL_NAME = "equipment_Pool_name"
    SORT_PROP_EQUIPMENT_POOL_POLICY_LEVEL = "equipment_Pool_policyLevel"
    SORT_PROP_EQUIPMENT_POOL_POLICY_OWNER = "equipment_Pool_policyOwner"
    SORT_PROP_EQUIPMENT_POOL_POOL_TYPE = "equipment_Pool_poolType"
    SORT_PROP_EQUIPMENT_POOL_SIZE = "equipment_Pool_size"
    SORT_PROP_EQUIPMENT_POOLABLE_ASSIGNED_TO_DN = "equipment_Poolable_assignedToDn"
    SORT_PROP_EQUIPMENT_POOLABLE_ID = "equipment_Poolable_id"
    SORT_PROP_EQUIPMENT_POOLABLE_OWNER = "equipment_Poolable_owner"
    SORT_PROP_EQUIPMENT_POOLABLE_POOL_DN = "equipment_Poolable_poolDn"
    SORT_PROP_EQUIPMENT_POOLABLE_SYS_ID = "equipment_Poolable_sysId"
    SORT_PROP_EQUIPMENT_POOLED_ASSIGNED = "equipment_Pooled_assigned"
    SORT_PROP_EQUIPMENT_POOLED_ASSIGNED_TO_DN = "equipment_Pooled_assignedToDn"
    SORT_PROP_EQUIPMENT_POOLED_OWNER = "equipment_Pooled_owner"
    SORT_PROP_EQUIPMENT_POOLED_POOLABLE_DN = "equipment_Pooled_poolableDn"
    SORT_PROP_EQUIPMENT_POOLED_PREV_ASSIGNED_TO_DN = "equipment_Pooled_prevAssignedToDn"
    SORT_PROP_EQUIPMENT_POOLING_POLICY_DESCR = "equipment_PoolingPolicy_descr"
    SORT_PROP_EQUIPMENT_POOLING_POLICY_INT_ID = "equipment_PoolingPolicy_intId"
    SORT_PROP_EQUIPMENT_POOLING_POLICY_NAME = "equipment_PoolingPolicy_name"
    SORT_PROP_EQUIPMENT_POOLING_POLICY_POLICY_LEVEL = "equipment_PoolingPolicy_policyLevel"
    SORT_PROP_EQUIPMENT_POOLING_POLICY_POLICY_OWNER = "equipment_PoolingPolicy_policyOwner"
    SORT_PROP_EQUIPMENT_POOLING_POLICY_POOL_DN = "equipment_PoolingPolicy_poolDn"
    SORT_PROP_EQUIPMENT_POOLING_POLICY_QUALIFIER = "equipment_PoolingPolicy_qualifier"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_DEPRECATED = "equipment_ProcessorUnitCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_GENCOUNT = "equipment_ProcessorUnitCapProvider_gencount"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_ProcessorUnitCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_MODEL = "equipment_ProcessorUnitCapProvider_model"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_ProcessorUnitCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_REVISION = "equipment_ProcessorUnitCapProvider_revision"
    SORT_PROP_EQUIPMENT_PROCESSOR_UNIT_CAP_PROVIDER_VENDOR = "equipment_ProcessorUnitCapProvider_vendor"
    SORT_PROP_EQUIPMENT_PSU_CAP_PROVIDER_DEPRECATED = "equipment_PsuCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_PSU_CAP_PROVIDER_GENCOUNT = "equipment_PsuCapProvider_gencount"
    SORT_PROP_EQUIPMENT_PSU_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_PsuCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_PSU_CAP_PROVIDER_MODEL = "equipment_PsuCapProvider_model"
    SORT_PROP_EQUIPMENT_PSU_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_PsuCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_PSU_CAP_PROVIDER_REVISION = "equipment_PsuCapProvider_revision"
    SORT_PROP_EQUIPMENT_PSU_CAP_PROVIDER_VENDOR = "equipment_PsuCapProvider_vendor"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_CURRENT = "equipment_PsuInputStatsHist_current"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_CURRENT_AVG = "equipment_PsuInputStatsHist_currentAvg"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_CURRENT_MAX = "equipment_PsuInputStatsHist_currentMax"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_CURRENT_MIN = "equipment_PsuInputStatsHist_currentMin"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_ID = "equipment_PsuInputStatsHist_id"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_MOST_RECENT = "equipment_PsuInputStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_POWER = "equipment_PsuInputStatsHist_power"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_POWER_AVG = "equipment_PsuInputStatsHist_powerAvg"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_POWER_MAX = "equipment_PsuInputStatsHist_powerMax"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_POWER_MIN = "equipment_PsuInputStatsHist_powerMin"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_SUSPECT = "equipment_PsuInputStatsHist_suspect"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_THRESHOLDED = "equipment_PsuInputStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_TIME_COLLECTED = "equipment_PsuInputStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_VOLTAGE = "equipment_PsuInputStatsHist_voltage"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_VOLTAGE_AVG = "equipment_PsuInputStatsHist_voltageAvg"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_VOLTAGE_MAX = "equipment_PsuInputStatsHist_voltageMax"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_HIST_VOLTAGE_MIN = "equipment_PsuInputStatsHist_voltageMin"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_CURRENT = "equipment_PsuInputStats_current"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_CURRENT_AVG = "equipment_PsuInputStats_currentAvg"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_CURRENT_MAX = "equipment_PsuInputStats_currentMax"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_CURRENT_MIN = "equipment_PsuInputStats_currentMin"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_INPUT_STATUS = "equipment_PsuInputStats_inputStatus"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_INTERVALS = "equipment_PsuInputStats_intervals"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_NORMALIZED_TIME_COL = "equipment_PsuInputStats_normalizedTimeCol"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_POWER = "equipment_PsuInputStats_power"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_POWER_AVG = "equipment_PsuInputStats_powerAvg"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_POWER_MAX = "equipment_PsuInputStats_powerMax"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_POWER_MIN = "equipment_PsuInputStats_powerMin"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_STATS_REPORTED = "equipment_PsuInputStats_statsReported"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_SUSPECT = "equipment_PsuInputStats_suspect"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_THRESHOLDED = "equipment_PsuInputStats_thresholded"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_TIME_COLLECTED = "equipment_PsuInputStats_timeCollected"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_UPDATE = "equipment_PsuInputStats_update"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_VOLTAGE = "equipment_PsuInputStats_voltage"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_VOLTAGE_AVG = "equipment_PsuInputStats_voltageAvg"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_VOLTAGE_MAX = "equipment_PsuInputStats_voltageMax"
    SORT_PROP_EQUIPMENT_PSU_INPUT_STATS_VOLTAGE_MIN = "equipment_PsuInputStats_voltageMin"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_CURRENT = "equipment_PsuOutputStatsHist_current"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_CURRENT_AVG = "equipment_PsuOutputStatsHist_currentAvg"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_CURRENT_MAX = "equipment_PsuOutputStatsHist_currentMax"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_CURRENT_MIN = "equipment_PsuOutputStatsHist_currentMin"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_ID = "equipment_PsuOutputStatsHist_id"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_MOST_RECENT = "equipment_PsuOutputStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_POWER = "equipment_PsuOutputStatsHist_power"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_POWER_AVG = "equipment_PsuOutputStatsHist_powerAvg"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_POWER_MAX = "equipment_PsuOutputStatsHist_powerMax"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_POWER_MIN = "equipment_PsuOutputStatsHist_powerMin"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_SUSPECT = "equipment_PsuOutputStatsHist_suspect"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_THRESHOLDED = "equipment_PsuOutputStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_TIME_COLLECTED = "equipment_PsuOutputStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_VOLTAGE = "equipment_PsuOutputStatsHist_voltage"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_VOLTAGE_AVG = "equipment_PsuOutputStatsHist_voltageAvg"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_VOLTAGE_MAX = "equipment_PsuOutputStatsHist_voltageMax"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_HIST_VOLTAGE_MIN = "equipment_PsuOutputStatsHist_voltageMin"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_CURRENT = "equipment_PsuOutputStats_current"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_CURRENT_AVG = "equipment_PsuOutputStats_currentAvg"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_CURRENT_MAX = "equipment_PsuOutputStats_currentMax"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_CURRENT_MIN = "equipment_PsuOutputStats_currentMin"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_INTERVALS = "equipment_PsuOutputStats_intervals"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_NORMALIZED_TIME_COL = "equipment_PsuOutputStats_normalizedTimeCol"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_OUTPUT_STATUS = "equipment_PsuOutputStats_outputStatus"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_POWER = "equipment_PsuOutputStats_power"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_POWER_AVG = "equipment_PsuOutputStats_powerAvg"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_POWER_MAX = "equipment_PsuOutputStats_powerMax"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_POWER_MIN = "equipment_PsuOutputStats_powerMin"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_STATS_REPORTED = "equipment_PsuOutputStats_statsReported"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_SUSPECT = "equipment_PsuOutputStats_suspect"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_THRESHOLDED = "equipment_PsuOutputStats_thresholded"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_TIME_COLLECTED = "equipment_PsuOutputStats_timeCollected"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_UPDATE = "equipment_PsuOutputStats_update"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_VOLTAGE = "equipment_PsuOutputStats_voltage"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_VOLTAGE_AVG = "equipment_PsuOutputStats_voltageAvg"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_VOLTAGE_MAX = "equipment_PsuOutputStats_voltageMax"
    SORT_PROP_EQUIPMENT_PSU_OUTPUT_STATS_VOLTAGE_MIN = "equipment_PsuOutputStats_voltageMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_AMBIENT_TEMP = "equipment_PsuStatsHist_ambientTemp"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_AMBIENT_TEMP_AVG = "equipment_PsuStatsHist_ambientTempAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_AMBIENT_TEMP_MAX = "equipment_PsuStatsHist_ambientTempMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_AMBIENT_TEMP_MIN = "equipment_PsuStatsHist_ambientTempMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_ID = "equipment_PsuStatsHist_id"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_INPUT210V = "equipment_PsuStatsHist_input210v"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_INPUT210V_AVG = "equipment_PsuStatsHist_input210vAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_INPUT210V_MAX = "equipment_PsuStatsHist_input210vMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_INPUT210V_MIN = "equipment_PsuStatsHist_input210vMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_MOST_RECENT = "equipment_PsuStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT12V = "equipment_PsuStatsHist_output12v"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT12V_AVG = "equipment_PsuStatsHist_output12vAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT12V_MAX = "equipment_PsuStatsHist_output12vMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT12V_MIN = "equipment_PsuStatsHist_output12vMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT3V3 = "equipment_PsuStatsHist_output3v3"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT3V3_AVG = "equipment_PsuStatsHist_output3v3Avg"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT3V3_MAX = "equipment_PsuStatsHist_output3v3Max"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT3V3_MIN = "equipment_PsuStatsHist_output3v3Min"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT_CURRENT = "equipment_PsuStatsHist_outputCurrent"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT_CURRENT_AVG = "equipment_PsuStatsHist_outputCurrentAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT_CURRENT_MAX = "equipment_PsuStatsHist_outputCurrentMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT_CURRENT_MIN = "equipment_PsuStatsHist_outputCurrentMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT_POWER = "equipment_PsuStatsHist_outputPower"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT_POWER_AVG = "equipment_PsuStatsHist_outputPowerAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT_POWER_MAX = "equipment_PsuStatsHist_outputPowerMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_OUTPUT_POWER_MIN = "equipment_PsuStatsHist_outputPowerMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_SUSPECT = "equipment_PsuStatsHist_suspect"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_THRESHOLDED = "equipment_PsuStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_PSU_STATS_HIST_TIME_COLLECTED = "equipment_PsuStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_PSU_STATS_AMBIENT_TEMP = "equipment_PsuStats_ambientTemp"
    SORT_PROP_EQUIPMENT_PSU_STATS_AMBIENT_TEMP_AVG = "equipment_PsuStats_ambientTempAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_AMBIENT_TEMP_MAX = "equipment_PsuStats_ambientTempMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_AMBIENT_TEMP_MIN = "equipment_PsuStats_ambientTempMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_INPUT210V = "equipment_PsuStats_input210v"
    SORT_PROP_EQUIPMENT_PSU_STATS_INPUT210V_AVG = "equipment_PsuStats_input210vAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_INPUT210V_MAX = "equipment_PsuStats_input210vMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_INPUT210V_MIN = "equipment_PsuStats_input210vMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_INTERVALS = "equipment_PsuStats_intervals"
    SORT_PROP_EQUIPMENT_PSU_STATS_NORMALIZED_TIME_COL = "equipment_PsuStats_normalizedTimeCol"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT12V = "equipment_PsuStats_output12v"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT12V_AVG = "equipment_PsuStats_output12vAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT12V_MAX = "equipment_PsuStats_output12vMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT12V_MIN = "equipment_PsuStats_output12vMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT3V3 = "equipment_PsuStats_output3v3"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT3V3_AVG = "equipment_PsuStats_output3v3Avg"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT3V3_MAX = "equipment_PsuStats_output3v3Max"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT3V3_MIN = "equipment_PsuStats_output3v3Min"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT_CURRENT = "equipment_PsuStats_outputCurrent"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT_CURRENT_AVG = "equipment_PsuStats_outputCurrentAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT_CURRENT_MAX = "equipment_PsuStats_outputCurrentMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT_CURRENT_MIN = "equipment_PsuStats_outputCurrentMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT_POWER = "equipment_PsuStats_outputPower"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT_POWER_AVG = "equipment_PsuStats_outputPowerAvg"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT_POWER_MAX = "equipment_PsuStats_outputPowerMax"
    SORT_PROP_EQUIPMENT_PSU_STATS_OUTPUT_POWER_MIN = "equipment_PsuStats_outputPowerMin"
    SORT_PROP_EQUIPMENT_PSU_STATS_PSU_TEMP1 = "equipment_PsuStats_psuTemp1"
    SORT_PROP_EQUIPMENT_PSU_STATS_PSU_TEMP2 = "equipment_PsuStats_psuTemp2"
    SORT_PROP_EQUIPMENT_PSU_STATS_STATS_REPORTED = "equipment_PsuStats_statsReported"
    SORT_PROP_EQUIPMENT_PSU_STATS_SUSPECT = "equipment_PsuStats_suspect"
    SORT_PROP_EQUIPMENT_PSU_STATS_THRESHOLDED = "equipment_PsuStats_thresholded"
    SORT_PROP_EQUIPMENT_PSU_STATS_TIME_COLLECTED = "equipment_PsuStats_timeCollected"
    SORT_PROP_EQUIPMENT_PSU_STATS_UPDATE = "equipment_PsuStats_update"
    SORT_PROP_EQUIPMENT_PSU_TYPE = "equipment_Psu_Type"
    SORT_PROP_EQUIPMENT_PSU_ASSET_TAG = "equipment_Psu_assetTag"
    SORT_PROP_EQUIPMENT_PSU_ID = "equipment_Psu_id"
    SORT_PROP_EQUIPMENT_PSU_MODEL = "equipment_Psu_model"
    SORT_PROP_EQUIPMENT_PSU_OPER_QUALIFIER_REASON = "equipment_Psu_operQualifierReason"
    SORT_PROP_EQUIPMENT_PSU_OPER_STATE = "equipment_Psu_operState"
    SORT_PROP_EQUIPMENT_PSU_OPERABILITY = "equipment_Psu_operability"
    SORT_PROP_EQUIPMENT_PSU_PART_NUMBER = "equipment_Psu_partNumber"
    SORT_PROP_EQUIPMENT_PSU_PERF = "equipment_Psu_perf"
    SORT_PROP_EQUIPMENT_PSU_POWER = "equipment_Psu_power"
    SORT_PROP_EQUIPMENT_PSU_POWER_STATE_QUALIFIER = "equipment_Psu_powerStateQualifier"
    SORT_PROP_EQUIPMENT_PSU_PRESENCE = "equipment_Psu_presence"
    SORT_PROP_EQUIPMENT_PSU_PSU_FIRMWARE_VERSION = "equipment_Psu_psuFirmwareVersion"
    SORT_PROP_EQUIPMENT_PSU_PSU_INPUT_SRC = "equipment_Psu_psuInputSrc"
    SORT_PROP_EQUIPMENT_PSU_PSU_TYPE = "equipment_Psu_psuType"
    SORT_PROP_EQUIPMENT_PSU_PSU_WATTAGE = "equipment_Psu_psuWattage"
    SORT_PROP_EQUIPMENT_PSU_REVISION = "equipment_Psu_revision"
    SORT_PROP_EQUIPMENT_PSU_SERIAL = "equipment_Psu_serial"
    SORT_PROP_EQUIPMENT_PSU_THERMAL = "equipment_Psu_thermal"
    SORT_PROP_EQUIPMENT_PSU_VENDOR = "equipment_Psu_vendor"
    SORT_PROP_EQUIPMENT_PSU_VID = "equipment_Psu_vid"
    SORT_PROP_EQUIPMENT_PSU_VOLTAGE = "equipment_Psu_voltage"
    SORT_PROP_EQUIPMENT_QUAL_BASE_DESCR = "equipment_QualBase_descr"
    SORT_PROP_EQUIPMENT_QUAL_BASE_INT_ID = "equipment_QualBase_intId"
    SORT_PROP_EQUIPMENT_QUAL_BASE_NAME = "equipment_QualBase_name"
    SORT_PROP_EQUIPMENT_QUAL_BASE_POLICY_LEVEL = "equipment_QualBase_policyLevel"
    SORT_PROP_EQUIPMENT_QUAL_BASE_POLICY_OWNER = "equipment_QualBase_policyOwner"
    SORT_PROP_EQUIPMENT_QUAL_DESCR = "equipment_Qual_descr"
    SORT_PROP_EQUIPMENT_QUAL_INT_ID = "equipment_Qual_intId"
    SORT_PROP_EQUIPMENT_QUAL_NAME = "equipment_Qual_name"
    SORT_PROP_EQUIPMENT_QUAL_POLICY_LEVEL = "equipment_Qual_policyLevel"
    SORT_PROP_EQUIPMENT_QUAL_POLICY_OWNER = "equipment_Qual_policyOwner"
    SORT_PROP_EQUIPMENT_QUALIFIED_POLICY_DESCR = "equipment_QualifiedPolicy_descr"
    SORT_PROP_EQUIPMENT_QUALIFIED_POLICY_INT_ID = "equipment_QualifiedPolicy_intId"
    SORT_PROP_EQUIPMENT_QUALIFIED_POLICY_NAME = "equipment_QualifiedPolicy_name"
    SORT_PROP_EQUIPMENT_QUALIFIED_POLICY_POLICY_LEVEL = "equipment_QualifiedPolicy_policyLevel"
    SORT_PROP_EQUIPMENT_QUALIFIED_POLICY_POLICY_OWNER = "equipment_QualifiedPolicy_policyOwner"
    SORT_PROP_EQUIPMENT_QUALIFIED_POLICY_QUALIFIER = "equipment_QualifiedPolicy_qualifier"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_DEPRECATED = "equipment_RackUnitCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_GENCOUNT = "equipment_RackUnitCapProvider_gencount"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_MAX_LOCAL_DISKS = "equipment_RackUnitCapProvider_maxLocalDisks"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_RackUnitCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_MODEL = "equipment_RackUnitCapProvider_model"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_RackUnitCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_REVISION = "equipment_RackUnitCapProvider_revision"
    SORT_PROP_EQUIPMENT_RACK_UNIT_CAP_PROVIDER_VENDOR = "equipment_RackUnitCapProvider_vendor"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_ID = "equipment_RackUnitFanStatsHist_id"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_MOST_RECENT = "equipment_RackUnitFanStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_SPEED = "equipment_RackUnitFanStatsHist_speed"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_SPEED_AVG = "equipment_RackUnitFanStatsHist_speedAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_SPEED_MAX = "equipment_RackUnitFanStatsHist_speedMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_SPEED_MIN = "equipment_RackUnitFanStatsHist_speedMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_SUSPECT = "equipment_RackUnitFanStatsHist_suspect"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_THRESHOLDED = "equipment_RackUnitFanStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_HIST_TIME_COLLECTED = "equipment_RackUnitFanStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_INTERVALS = "equipment_RackUnitFanStats_intervals"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_NORMALIZED_TIME_COL = "equipment_RackUnitFanStats_normalizedTimeCol"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_SPEED = "equipment_RackUnitFanStats_speed"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_SPEED_AVG = "equipment_RackUnitFanStats_speedAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_SPEED_MAX = "equipment_RackUnitFanStats_speedMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_SPEED_MIN = "equipment_RackUnitFanStats_speedMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_STATS_REPORTED = "equipment_RackUnitFanStats_statsReported"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_SUSPECT = "equipment_RackUnitFanStats_suspect"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_THRESHOLDED = "equipment_RackUnitFanStats_thresholded"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_TIME_COLLECTED = "equipment_RackUnitFanStats_timeCollected"
    SORT_PROP_EQUIPMENT_RACK_UNIT_FAN_STATS_UPDATE = "equipment_RackUnitFanStats_update"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_AMBIENT_TEMP = "equipment_RackUnitPsuStatsHist_ambientTemp"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_AMBIENT_TEMP_AVG = "equipment_RackUnitPsuStatsHist_ambientTempAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_AMBIENT_TEMP_MAX = "equipment_RackUnitPsuStatsHist_ambientTempMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_AMBIENT_TEMP_MIN = "equipment_RackUnitPsuStatsHist_ambientTempMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_ID = "equipment_RackUnitPsuStatsHist_id"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_POWER = "equipment_RackUnitPsuStatsHist_inputPower"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_POWER_AVG = "equipment_RackUnitPsuStatsHist_inputPowerAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_POWER_MAX = "equipment_RackUnitPsuStatsHist_inputPowerMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_POWER_MIN = "equipment_RackUnitPsuStatsHist_inputPowerMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_VOLTAGE = "equipment_RackUnitPsuStatsHist_inputVoltage"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_VOLTAGE_AVG = "equipment_RackUnitPsuStatsHist_inputVoltageAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_VOLTAGE_MAX = "equipment_RackUnitPsuStatsHist_inputVoltageMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_INPUT_VOLTAGE_MIN = "equipment_RackUnitPsuStatsHist_inputVoltageMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_MOST_RECENT = "equipment_RackUnitPsuStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_CURRENT = "equipment_RackUnitPsuStatsHist_outputCurrent"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_CURRENT_AVG = "equipment_RackUnitPsuStatsHist_outputCurrentAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_CURRENT_MAX = "equipment_RackUnitPsuStatsHist_outputCurrentMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_CURRENT_MIN = "equipment_RackUnitPsuStatsHist_outputCurrentMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_POWER = "equipment_RackUnitPsuStatsHist_outputPower"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_POWER_AVG = "equipment_RackUnitPsuStatsHist_outputPowerAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_POWER_MAX = "equipment_RackUnitPsuStatsHist_outputPowerMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_POWER_MIN = "equipment_RackUnitPsuStatsHist_outputPowerMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_VOLTAGE = "equipment_RackUnitPsuStatsHist_outputVoltage"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_VOLTAGE_AVG = "equipment_RackUnitPsuStatsHist_outputVoltageAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_VOLTAGE_MAX = "equipment_RackUnitPsuStatsHist_outputVoltageMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_OUTPUT_VOLTAGE_MIN = "equipment_RackUnitPsuStatsHist_outputVoltageMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_SUSPECT = "equipment_RackUnitPsuStatsHist_suspect"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_THRESHOLDED = "equipment_RackUnitPsuStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_HIST_TIME_COLLECTED = "equipment_RackUnitPsuStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_AMBIENT_TEMP = "equipment_RackUnitPsuStats_ambientTemp"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_AMBIENT_TEMP_AVG = "equipment_RackUnitPsuStats_ambientTempAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_AMBIENT_TEMP_MAX = "equipment_RackUnitPsuStats_ambientTempMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_AMBIENT_TEMP_MIN = "equipment_RackUnitPsuStats_ambientTempMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_POWER = "equipment_RackUnitPsuStats_inputPower"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_POWER_AVG = "equipment_RackUnitPsuStats_inputPowerAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_POWER_MAX = "equipment_RackUnitPsuStats_inputPowerMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_POWER_MIN = "equipment_RackUnitPsuStats_inputPowerMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_VOLTAGE = "equipment_RackUnitPsuStats_inputVoltage"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_VOLTAGE_AVG = "equipment_RackUnitPsuStats_inputVoltageAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_VOLTAGE_MAX = "equipment_RackUnitPsuStats_inputVoltageMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_INPUT_VOLTAGE_MIN = "equipment_RackUnitPsuStats_inputVoltageMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_INTERVALS = "equipment_RackUnitPsuStats_intervals"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_NORMALIZED_TIME_COL = "equipment_RackUnitPsuStats_normalizedTimeCol"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_CURRENT = "equipment_RackUnitPsuStats_outputCurrent"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_CURRENT_AVG = "equipment_RackUnitPsuStats_outputCurrentAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_CURRENT_MAX = "equipment_RackUnitPsuStats_outputCurrentMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_CURRENT_MIN = "equipment_RackUnitPsuStats_outputCurrentMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_POWER = "equipment_RackUnitPsuStats_outputPower"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_POWER_AVG = "equipment_RackUnitPsuStats_outputPowerAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_POWER_MAX = "equipment_RackUnitPsuStats_outputPowerMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_POWER_MIN = "equipment_RackUnitPsuStats_outputPowerMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_VOLTAGE = "equipment_RackUnitPsuStats_outputVoltage"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_VOLTAGE_AVG = "equipment_RackUnitPsuStats_outputVoltageAvg"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_VOLTAGE_MAX = "equipment_RackUnitPsuStats_outputVoltageMax"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_OUTPUT_VOLTAGE_MIN = "equipment_RackUnitPsuStats_outputVoltageMin"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_STATS_REPORTED = "equipment_RackUnitPsuStats_statsReported"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_SUSPECT = "equipment_RackUnitPsuStats_suspect"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_THRESHOLDED = "equipment_RackUnitPsuStats_thresholded"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_TIME_COLLECTED = "equipment_RackUnitPsuStats_timeCollected"
    SORT_PROP_EQUIPMENT_RACK_UNIT_PSU_STATS_UPDATE = "equipment_RackUnitPsuStats_update"
    SORT_PROP_EQUIPMENT_REQUIREMENT_ASSIGNED_TO_DN = "equipment_Requirement_assignedToDn"
    SORT_PROP_EQUIPMENT_REQUIREMENT_CHASSIS_DN = "equipment_Requirement_chassisDn"
    SORT_PROP_EQUIPMENT_REQUIREMENT_CHASSIS_POOL_DN = "equipment_Requirement_chassisPoolDn"
    SORT_PROP_EQUIPMENT_REQUIREMENT_ISSUES = "equipment_Requirement_issues"
    SORT_PROP_EQUIPMENT_REQUIREMENT_NAME = "equipment_Requirement_name"
    SORT_PROP_EQUIPMENT_REQUIREMENT_OPER_NAME = "equipment_Requirement_operName"
    SORT_PROP_EQUIPMENT_REQUIREMENT_OPER_STATE = "equipment_Requirement_operState"
    SORT_PROP_EQUIPMENT_REQUIREMENT_QUALIFIER = "equipment_Requirement_qualifier"
    SORT_PROP_EQUIPMENT_REQUIREMENT_RESTRICT_MIGRATION = "equipment_Requirement_restrictMigration"
    SORT_PROP_EQUIPMENT_SECURE_BOOT_MIN_BIOS_VERSION = "equipment_SecureBoot_minBiosVersion"
    SORT_PROP_EQUIPMENT_SECURE_BOOT_MIN_CIMC_VERSION = "equipment_SecureBoot_minCimcVersion"
    SORT_PROP_EQUIPMENT_SECURE_BOOT_NAME = "equipment_SecureBoot_name"
    SORT_PROP_EQUIPMENT_SERVER_FEATURE_CAP_ADAPTOR_MODEL = "equipment_ServerFeatureCap_adaptorModel"
    SORT_PROP_EQUIPMENT_SERVER_FEATURE_CAP_CMOS_RESET_SUPPORTED = "equipment_ServerFeatureCap_cmosResetSupported"
    SORT_PROP_EQUIPMENT_SERVER_FEATURE_CAP_MAX_VIRTUAL_DRIVES_PER_SERVER = "equipment_ServerFeatureCap_maxVirtualDrivesPerServer"
    SORT_PROP_EQUIPMENT_SERVER_FEATURE_CAP_MAX_VIRTUAL_ETH_IF_PER_SERVER = "equipment_ServerFeatureCap_maxVirtualEthIfPerServer"
    SORT_PROP_EQUIPMENT_SERVER_FEATURE_CAP_NUMBER_OF_SERVER_UNITS = "equipment_ServerFeatureCap_numberOfServerUnits"
    SORT_PROP_EQUIPMENT_SERVER_FEATURE_CAP_STORAGE_JBOD_MODE_SUPPORTED = "equipment_ServerFeatureCap_storageJbodModeSupported"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_DEPRECATED = "equipment_ServerUnitCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_GENCOUNT = "equipment_ServerUnitCapProvider_gencount"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_MAX_LOCAL_DISKS = "equipment_ServerUnitCapProvider_maxLocalDisks"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_ServerUnitCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_MODEL = "equipment_ServerUnitCapProvider_model"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_ServerUnitCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_REVISION = "equipment_ServerUnitCapProvider_revision"
    SORT_PROP_EQUIPMENT_SERVER_UNIT_CAP_PROVIDER_VENDOR = "equipment_ServerUnitCapProvider_vendor"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_ADMIN_POWER_STATE = "equipment_SharedIOModule_adminPowerState"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_ASSET_TAG = "equipment_SharedIOModule_assetTag"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_BASE_ADDR = "equipment_SharedIOModule_baseAddr"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_CHASSIS_ID = "equipment_SharedIOModule_chassisId"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_CHECK_POINT = "equipment_SharedIOModule_checkPoint"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_CONFIG_STATE = "equipment_SharedIOModule_configState"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_DISCOVERY = "equipment_SharedIOModule_discovery"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_FE_OFFLINE_TS = "equipment_SharedIOModule_feOfflineTs"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_FE_READY_TS = "equipment_SharedIOModule_feReadyTs"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_FLT_AGGR = "equipment_SharedIOModule_fltAggr"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_ID = "equipment_SharedIOModule_id"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_LC_NAME = "equipment_SharedIOModule_lcName"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_LC_TS = "equipment_SharedIOModule_lcTs"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_MAC_OF_SHARED_IOMA = "equipment_SharedIOModule_macOfSharedIOMA"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_MAC_OF_SHARED_IOMB = "equipment_SharedIOModule_macOfSharedIOMB"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_MANAGING_INSTANCE = "equipment_SharedIOModule_managingInstance"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_MFG_TIME = "equipment_SharedIOModule_mfgTime"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_MODEL = "equipment_SharedIOModule_model"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_OPER_QUALIFIER = "equipment_SharedIOModule_operQualifier"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_OPER_QUALIFIER_REASON = "equipment_SharedIOModule_operQualifierReason"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_OPER_STATE = "equipment_SharedIOModule_operState"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_OPERABILITY = "equipment_SharedIOModule_operability"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_PART_NUMBER = "equipment_SharedIOModule_partNumber"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_PEER_DN = "equipment_SharedIOModule_peerDn"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_PERF = "equipment_SharedIOModule_perf"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_POWER = "equipment_SharedIOModule_power"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_PRESENCE = "equipment_SharedIOModule_presence"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_REACHABILITY = "equipment_SharedIOModule_reachability"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_REVISION = "equipment_SharedIOModule_revision"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_SERIAL = "equipment_SharedIOModule_serial"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_THERMAL = "equipment_SharedIOModule_thermal"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_UPGRADE_STATUS = "equipment_SharedIOModule_upgradeStatus"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_USR_LBL = "equipment_SharedIOModule_usrLbl"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_VENDOR = "equipment_SharedIOModule_vendor"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_VID = "equipment_SharedIOModule_vid"
    SORT_PROP_EQUIPMENT_SHARED_IOMODULE_VOLTAGE = "equipment_SharedIOModule_voltage"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_CMC_TEMP = "equipment_SiocTempStatsHist_cmcTemp"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_CMC_TEMP_AVG = "equipment_SiocTempStatsHist_cmcTempAvg"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_CMC_TEMP_MAX = "equipment_SiocTempStatsHist_cmcTempMax"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_CMC_TEMP_MIN = "equipment_SiocTempStatsHist_cmcTempMin"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_FRONT_TEMP = "equipment_SiocTempStatsHist_frontTemp"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_FRONT_TEMP_AVG = "equipment_SiocTempStatsHist_frontTempAvg"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_FRONT_TEMP_MAX = "equipment_SiocTempStatsHist_frontTempMax"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_FRONT_TEMP_MIN = "equipment_SiocTempStatsHist_frontTempMin"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_ID = "equipment_SiocTempStatsHist_id"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_MID_TEMP = "equipment_SiocTempStatsHist_midTemp"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_MID_TEMP_AVG = "equipment_SiocTempStatsHist_midTempAvg"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_MID_TEMP_MAX = "equipment_SiocTempStatsHist_midTempMax"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_MID_TEMP_MIN = "equipment_SiocTempStatsHist_midTempMin"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_MOST_RECENT = "equipment_SiocTempStatsHist_mostRecent"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_REAR_TEMP = "equipment_SiocTempStatsHist_rearTemp"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_REAR_TEMP_AVG = "equipment_SiocTempStatsHist_rearTempAvg"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_REAR_TEMP_MAX = "equipment_SiocTempStatsHist_rearTempMax"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_REAR_TEMP_MIN = "equipment_SiocTempStatsHist_rearTempMin"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_SUSPECT = "equipment_SiocTempStatsHist_suspect"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_THRESHOLDED = "equipment_SiocTempStatsHist_thresholded"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_TIME_COLLECTED = "equipment_SiocTempStatsHist_timeCollected"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_VIC_TEMP = "equipment_SiocTempStatsHist_vicTemp"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_VIC_TEMP_AVG = "equipment_SiocTempStatsHist_vicTempAvg"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_VIC_TEMP_MAX = "equipment_SiocTempStatsHist_vicTempMax"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_HIST_VIC_TEMP_MIN = "equipment_SiocTempStatsHist_vicTempMin"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_CMC_TEMP = "equipment_SiocTempStats_cmcTemp"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_CMC_TEMP_AVG = "equipment_SiocTempStats_cmcTempAvg"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_CMC_TEMP_MAX = "equipment_SiocTempStats_cmcTempMax"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_CMC_TEMP_MIN = "equipment_SiocTempStats_cmcTempMin"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_FRONT_TEMP = "equipment_SiocTempStats_frontTemp"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_FRONT_TEMP_AVG = "equipment_SiocTempStats_frontTempAvg"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_FRONT_TEMP_MAX = "equipment_SiocTempStats_frontTempMax"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_FRONT_TEMP_MIN = "equipment_SiocTempStats_frontTempMin"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_INTERVALS = "equipment_SiocTempStats_intervals"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_MID_TEMP = "equipment_SiocTempStats_midTemp"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_MID_TEMP_AVG = "equipment_SiocTempStats_midTempAvg"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_MID_TEMP_MAX = "equipment_SiocTempStats_midTempMax"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_MID_TEMP_MIN = "equipment_SiocTempStats_midTempMin"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_NORMALIZED_TIME_COL = "equipment_SiocTempStats_normalizedTimeCol"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_REAR_TEMP = "equipment_SiocTempStats_rearTemp"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_REAR_TEMP_AVG = "equipment_SiocTempStats_rearTempAvg"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_REAR_TEMP_MAX = "equipment_SiocTempStats_rearTempMax"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_REAR_TEMP_MIN = "equipment_SiocTempStats_rearTempMin"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_STATS_REPORTED = "equipment_SiocTempStats_statsReported"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_SUSPECT = "equipment_SiocTempStats_suspect"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_THRESHOLDED = "equipment_SiocTempStats_thresholded"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_TIME_COLLECTED = "equipment_SiocTempStats_timeCollected"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_UPDATE = "equipment_SiocTempStats_update"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_VIC_TEMP = "equipment_SiocTempStats_vicTemp"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_VIC_TEMP_AVG = "equipment_SiocTempStats_vicTempAvg"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_VIC_TEMP_MAX = "equipment_SiocTempStats_vicTempMax"
    SORT_PROP_EQUIPMENT_SIOC_TEMP_STATS_VIC_TEMP_MIN = "equipment_SiocTempStats_vicTempMin"
    SORT_PROP_EQUIPMENT_SLOT_ENCLOSURE_ID = "equipment_SlotEnclosure_id"
    SORT_PROP_EQUIPMENT_SLOT_ENCLOSURE_MODEL = "equipment_SlotEnclosure_model"
    SORT_PROP_EQUIPMENT_SLOT_ENCLOSURE_OPER_QUALIFIER_REASON = "equipment_SlotEnclosure_operQualifierReason"
    SORT_PROP_EQUIPMENT_SLOT_ENCLOSURE_OPERABILITY = "equipment_SlotEnclosure_operability"
    SORT_PROP_EQUIPMENT_SLOT_ENCLOSURE_PRESENCE = "equipment_SlotEnclosure_presence"
    SORT_PROP_EQUIPMENT_SLOT_ENCLOSURE_REVISION = "equipment_SlotEnclosure_revision"
    SORT_PROP_EQUIPMENT_SLOT_ENCLOSURE_SERIAL = "equipment_SlotEnclosure_serial"
    SORT_PROP_EQUIPMENT_SLOT_ENCLOSURE_VENDOR = "equipment_SlotEnclosure_vendor"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_IF_OPER_QUALIFIER_REASON = "equipment_StatefulBladeCompIf_operQualifierReason"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_IF_OPER_STATE = "equipment_StatefulBladeCompIf_operState"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_IF_OPERABILITY = "equipment_StatefulBladeCompIf_operability"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_IF_PERF = "equipment_StatefulBladeCompIf_perf"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_IF_POWER = "equipment_StatefulBladeCompIf_power"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_IF_PRESENCE = "equipment_StatefulBladeCompIf_presence"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_IF_THERMAL = "equipment_StatefulBladeCompIf_thermal"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_IF_VOLTAGE = "equipment_StatefulBladeCompIf_voltage"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_ID = "equipment_StatefulBladeComp_id"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_LOCATION_DN = "equipment_StatefulBladeComp_locationDn"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_MODEL = "equipment_StatefulBladeComp_model"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_OPER_QUALIFIER_REASON = "equipment_StatefulBladeComp_operQualifierReason"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_OPER_STATE = "equipment_StatefulBladeComp_operState"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_OPERABILITY = "equipment_StatefulBladeComp_operability"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_PERF = "equipment_StatefulBladeComp_perf"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_POWER = "equipment_StatefulBladeComp_power"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_PRESENCE = "equipment_StatefulBladeComp_presence"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_REVISION = "equipment_StatefulBladeComp_revision"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_SERIAL = "equipment_StatefulBladeComp_serial"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_THERMAL = "equipment_StatefulBladeComp_thermal"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_VENDOR = "equipment_StatefulBladeComp_vendor"
    SORT_PROP_EQUIPMENT_STATEFUL_BLADE_COMP_VOLTAGE = "equipment_StatefulBladeComp_voltage"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_IF_OPER_QUALIFIER_REASON = "equipment_StatefulChCompIf_operQualifierReason"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_IF_OPER_STATE = "equipment_StatefulChCompIf_operState"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_IF_OPERABILITY = "equipment_StatefulChCompIf_operability"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_IF_PERF = "equipment_StatefulChCompIf_perf"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_IF_POWER = "equipment_StatefulChCompIf_power"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_IF_PRESENCE = "equipment_StatefulChCompIf_presence"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_IF_THERMAL = "equipment_StatefulChCompIf_thermal"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_IF_VOLTAGE = "equipment_StatefulChCompIf_voltage"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_ID = "equipment_StatefulChComp_id"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_MODEL = "equipment_StatefulChComp_model"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_OPER_QUALIFIER_REASON = "equipment_StatefulChComp_operQualifierReason"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_OPER_STATE = "equipment_StatefulChComp_operState"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_OPERABILITY = "equipment_StatefulChComp_operability"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_PERF = "equipment_StatefulChComp_perf"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_POWER = "equipment_StatefulChComp_power"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_PRESENCE = "equipment_StatefulChComp_presence"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_REVISION = "equipment_StatefulChComp_revision"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_SERIAL = "equipment_StatefulChComp_serial"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_THERMAL = "equipment_StatefulChComp_thermal"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_VENDOR = "equipment_StatefulChComp_vendor"
    SORT_PROP_EQUIPMENT_STATEFUL_CH_COMP_VOLTAGE = "equipment_StatefulChComp_voltage"
    SORT_PROP_EQUIPMENT_STATEFUL_IF_OPER_QUALIFIER_REASON = "equipment_StatefulIf_operQualifierReason"
    SORT_PROP_EQUIPMENT_STATEFUL_IF_OPERABILITY = "equipment_StatefulIf_operability"
    SORT_PROP_EQUIPMENT_STATEFUL_IF_PRESENCE = "equipment_StatefulIf_presence"
    SORT_PROP_EQUIPMENT_STATEFUL_ID = "equipment_Stateful_id"
    SORT_PROP_EQUIPMENT_STATEFUL_MODEL = "equipment_Stateful_model"
    SORT_PROP_EQUIPMENT_STATEFUL_OPER_QUALIFIER_REASON = "equipment_Stateful_operQualifierReason"
    SORT_PROP_EQUIPMENT_STATEFUL_OPERABILITY = "equipment_Stateful_operability"
    SORT_PROP_EQUIPMENT_STATEFUL_PRESENCE = "equipment_Stateful_presence"
    SORT_PROP_EQUIPMENT_STATEFUL_REVISION = "equipment_Stateful_revision"
    SORT_PROP_EQUIPMENT_STATEFUL_SERIAL = "equipment_Stateful_serial"
    SORT_PROP_EQUIPMENT_STATEFUL_VENDOR = "equipment_Stateful_vendor"
    SORT_PROP_EQUIPMENT_STORAGE_PROCESSOR_CAP_VIRTUALIZED_CESUPPORTED = "equipment_StorageProcessorCap_virtualizedCESupported"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_PROVIDER_DEPRECATED = "equipment_SwitchCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_PROVIDER_GENCOUNT = "equipment_SwitchCapProvider_gencount"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_SwitchCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_PROVIDER_MODEL = "equipment_SwitchCapProvider_model"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_SwitchCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_PROVIDER_REVISION = "equipment_SwitchCapProvider_revision"
    SORT_PROP_EQUIPMENT_SWITCH_CAP_PROVIDER_VENDOR = "equipment_SwitchCapProvider_vendor"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_DESCR = "equipment_SwitchCard_descr"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_FLT_AGGR = "equipment_SwitchCard_fltAggr"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_ID = "equipment_SwitchCard_id"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_MODEL = "equipment_SwitchCard_model"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_NUM_PORTS = "equipment_SwitchCard_numPorts"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_OPER_QUALIFIER_REASON = "equipment_SwitchCard_operQualifierReason"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_OPER_STATE = "equipment_SwitchCard_operState"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_OPERABILITY = "equipment_SwitchCard_operability"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_PERF = "equipment_SwitchCard_perf"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_POWER = "equipment_SwitchCard_power"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_PRESENCE = "equipment_SwitchCard_presence"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_REVISION = "equipment_SwitchCard_revision"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_SERIAL = "equipment_SwitchCard_serial"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_STATE = "equipment_SwitchCard_state"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_THERMAL = "equipment_SwitchCard_thermal"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_TS = "equipment_SwitchCard_ts"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_VENDOR = "equipment_SwitchCard_vendor"
    SORT_PROP_EQUIPMENT_SWITCH_CARD_VOLTAGE = "equipment_SwitchCard_voltage"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER_DEPRECATED = "equipment_SwitchIOCardCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER_GENCOUNT = "equipment_SwitchIOCardCapProvider_gencount"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_SwitchIOCardCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER_MODEL = "equipment_SwitchIOCardCapProvider_model"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_SwitchIOCardCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER_REVISION = "equipment_SwitchIOCardCapProvider_revision"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CAP_PROVIDER_VENDOR = "equipment_SwitchIOCardCapProvider_vendor"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_ADMIN_PEER_POWER_STATE = "equipment_SwitchIOCard_adminPeerPowerState"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_ADMIN_POWER_STATE = "equipment_SwitchIOCard_adminPowerState"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_ADMIN_STATE = "equipment_SwitchIOCard_adminState"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_BASE_ADDR = "equipment_SwitchIOCard_baseAddr"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CHASSIS_ID = "equipment_SwitchIOCard_chassisId"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_CONFIG_STATE = "equipment_SwitchIOCard_configState"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_DISCOVERY = "equipment_SwitchIOCard_discovery"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FE_OFFLINE_TS = "equipment_SwitchIOCard_feOfflineTs"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FE_READY_TS = "equipment_SwitchIOCard_feReadyTs"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_FLT_AGGR = "equipment_SwitchIOCard_fltAggr"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_ID = "equipment_SwitchIOCard_id"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_LC_NAME = "equipment_SwitchIOCard_lcName"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_LC_TS = "equipment_SwitchIOCard_lcTs"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_MFG_TIME = "equipment_SwitchIOCard_mfgTime"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_MODEL = "equipment_SwitchIOCard_model"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_OPER_EVAC_STATE = "equipment_SwitchIOCard_operEvacState"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_OPER_QUALIFIER = "equipment_SwitchIOCard_operQualifier"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_OPER_QUALIFIER_REASON = "equipment_SwitchIOCard_operQualifierReason"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_OPER_STATE = "equipment_SwitchIOCard_operState"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_OPERABILITY = "equipment_SwitchIOCard_operability"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_PEER_COMM_STATUS = "equipment_SwitchIOCard_peerCommStatus"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_PEER_DN = "equipment_SwitchIOCard_peerDn"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_PERF = "equipment_SwitchIOCard_perf"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_POWER = "equipment_SwitchIOCard_power"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_PRESENCE = "equipment_SwitchIOCard_presence"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_PROCESSOR_THERMAL_STATE = "equipment_SwitchIOCard_processorThermalState"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_REVISION = "equipment_SwitchIOCard_revision"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_SERIAL = "equipment_SwitchIOCard_serial"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_SIDE = "equipment_SwitchIOCard_side"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_SWITCH_ID = "equipment_SwitchIOCard_switchId"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_THERMAL = "equipment_SwitchIOCard_thermal"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_UPGRADE_STATUS = "equipment_SwitchIOCard_upgradeStatus"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_USR_LBL = "equipment_SwitchIOCard_usrLbl"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_VENDOR = "equipment_SwitchIOCard_vendor"
    SORT_PROP_EQUIPMENT_SWITCH_IOCARD_VOLTAGE = "equipment_SwitchIOCard_voltage"
    SORT_PROP_EQUIPMENT_SYSTEM_FRU_CAP_PROVIDER_DEPRECATED = "equipment_SystemFruCapProvider_deprecated"
    SORT_PROP_EQUIPMENT_SYSTEM_FRU_CAP_PROVIDER_GENCOUNT = "equipment_SystemFruCapProvider_gencount"
    SORT_PROP_EQUIPMENT_SYSTEM_FRU_CAP_PROVIDER_MGMT_PLANE_VER = "equipment_SystemFruCapProvider_mgmtPlaneVer"
    SORT_PROP_EQUIPMENT_SYSTEM_FRU_CAP_PROVIDER_MODEL = "equipment_SystemFruCapProvider_model"
    SORT_PROP_EQUIPMENT_SYSTEM_FRU_CAP_PROVIDER_PROM_CARD_TYPE = "equipment_SystemFruCapProvider_promCardType"
    SORT_PROP_EQUIPMENT_SYSTEM_FRU_CAP_PROVIDER_REVISION = "equipment_SystemFruCapProvider_revision"
    SORT_PROP_EQUIPMENT_SYSTEM_FRU_CAP_PROVIDER_TYPE = "equipment_SystemFruCapProvider_type"
    SORT_PROP_EQUIPMENT_SYSTEM_FRU_CAP_PROVIDER_VENDOR = "equipment_SystemFruCapProvider_vendor"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_OPERATION_ADMIN_POWER_STATE = "equipment_SystemIOControllerOperation_adminPowerState"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_OPERATION_ADMIN_STATE = "equipment_SystemIOControllerOperation_adminState"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_OPERATION_LAST_MODIFIED = "equipment_SystemIOControllerOperation_lastModified"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_OPERATION_REMOTE_ERROR_CODE = "equipment_SystemIOControllerOperation_remoteErrorCode"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_OPERATION_REMOTE_ERROR_DESCR = "equipment_SystemIOControllerOperation_remoteErrorDescr"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_OPERATION_TRIGGER_STATUS = "equipment_SystemIOControllerOperation_triggerStatus"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_ADMIN_POWER_STATE = "equipment_SystemIOController_adminPowerState"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_ADMIN_STATE = "equipment_SystemIOController_adminState"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_ASSET_TAG = "equipment_SystemIOController_assetTag"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_CHASSIS_ID = "equipment_SystemIOController_chassisId"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_CHECK_POINT = "equipment_SystemIOController_checkPoint"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_CONFIG_STATE = "equipment_SystemIOController_configState"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_CONN_PATH = "equipment_SystemIOController_connPath"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_CONN_STATUS = "equipment_SystemIOController_connStatus"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_DISCOVERY = "equipment_SystemIOController_discovery"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_FLT_AGGR = "equipment_SystemIOController_fltAggr"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_ID = "equipment_SystemIOController_id"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_LC_NAME = "equipment_SystemIOController_lcName"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_LC_TS = "equipment_SystemIOController_lcTs"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_MANAGING_INSTANCE = "equipment_SystemIOController_managingInstance"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_MFG_TIME = "equipment_SystemIOController_mfgTime"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_MODEL = "equipment_SystemIOController_model"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_OPER_QUALIFIER = "equipment_SystemIOController_operQualifier"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_OPER_QUALIFIER_REASON = "equipment_SystemIOController_operQualifierReason"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_OPER_STATE = "equipment_SystemIOController_operState"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_OPERABILITY = "equipment_SystemIOController_operability"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_PART_NUMBER = "equipment_SystemIOController_partNumber"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_PERF = "equipment_SystemIOController_perf"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_POWER = "equipment_SystemIOController_power"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_PRESENCE = "equipment_SystemIOController_presence"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_REACHABILITY = "equipment_SystemIOController_reachability"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_REVISION = "equipment_SystemIOController_revision"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_ROLE = "equipment_SystemIOController_role"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_SERIAL = "equipment_SystemIOController_serial"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_THERMAL = "equipment_SystemIOController_thermal"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_USR_LBL = "equipment_SystemIOController_usrLbl"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_VENDOR = "equipment_SystemIOController_vendor"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_VID = "equipment_SystemIOController_vid"
    SORT_PROP_EQUIPMENT_SYSTEM_IOCONTROLLER_VOLTAGE = "equipment_SystemIOController_voltage"
    SORT_PROP_EQUIPMENT_TEMPLATE_MAPPING_CP_DN = "equipment_TemplateMapping_cpDn"
    SORT_PROP_EQUIPMENT_TEMPLATE_MAPPING_DESCR = "equipment_TemplateMapping_descr"
    SORT_PROP_EQUIPMENT_TEMPLATE_MAPPING_INT_ID = "equipment_TemplateMapping_intId"
    SORT_PROP_EQUIPMENT_TEMPLATE_MAPPING_NAME = "equipment_TemplateMapping_name"
    SORT_PROP_EQUIPMENT_TEMPLATE_MAPPING_POLICY_LEVEL = "equipment_TemplateMapping_policyLevel"
    SORT_PROP_EQUIPMENT_TEMPLATE_MAPPING_POLICY_OWNER = "equipment_TemplateMapping_policyOwner"
    SORT_PROP_EQUIPMENT_TEMPLATE_MAPPING_TEMPL_DN = "equipment_TemplateMapping_templDn"
    SORT_PROP_EQUIPMENT_TEMPLATE_DESCR = "equipment_Template_descr"
    SORT_PROP_EQUIPMENT_TEMPLATE_INSTANTIATION_STATE = "equipment_Template_instantiationState"
    SORT_PROP_EQUIPMENT_TEMPLATE_INT_ID = "equipment_Template_intId"
    SORT_PROP_EQUIPMENT_TEMPLATE_NAME = "equipment_Template_name"
    SORT_PROP_EQUIPMENT_TEMPLATE_PLACEMENT_REF_CNT = "equipment_Template_placementRefCnt"
    SORT_PROP_EQUIPMENT_TEMPLATE_POLICY_LEVEL = "equipment_Template_policyLevel"
    SORT_PROP_EQUIPMENT_TEMPLATE_POLICY_OWNER = "equipment_Template_policyOwner"
    SORT_PROP_EQUIPMENT_TIER_APPLY = "equipment_Tier_apply"
    SORT_PROP_EQUIPMENT_TIER_DESCR = "equipment_Tier_descr"
    SORT_PROP_EQUIPMENT_TIER_INT_ID = "equipment_Tier_intId"
    SORT_PROP_EQUIPMENT_TIER_NAME = "equipment_Tier_name"
    SORT_PROP_EQUIPMENT_TIER_POLICY_LEVEL = "equipment_Tier_policyLevel"
    SORT_PROP_EQUIPMENT_TIER_POLICY_OWNER = "equipment_Tier_policyOwner"
    SORT_PROP_EQUIPMENT_TIER_SRC_TEMPL_NAME = "equipment_Tier_srcTemplName"
    SORT_PROP_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_END_PORT_ID = "equipment_UnifiedPortCapProvider_endPortId"
    SORT_PROP_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_LIC_GP = "equipment_UnifiedPortCapProvider_licGP"
    SORT_PROP_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_LIC_STATE = "equipment_UnifiedPortCapProvider_licState"
    SORT_PROP_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_NAME = "equipment_UnifiedPortCapProvider_name"
    SORT_PROP_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_START_PORT_ID = "equipment_UnifiedPortCapProvider_startPortId"
    SORT_PROP_EQUIPMENT_UNIFIED_PORT_CAP_PROVIDER_SUPPORTED_ALGORITHM = "equipment_UnifiedPortCapProvider_supportedAlgorithm"
    SORT_PROP_EQUIPMENT_XCVR_ID = "equipment_Xcvr_id"
    SORT_PROP_EQUIPMENT_XCVR_MODEL = "equipment_Xcvr_model"
    SORT_PROP_EQUIPMENT_XCVR_REVISION = "equipment_Xcvr_revision"
    SORT_PROP_EQUIPMENT_XCVR_SERIAL = "equipment_Xcvr_serial"
    SORT_PROP_EQUIPMENT_XCVR_TS = "equipment_Xcvr_ts"
    SORT_PROP_EQUIPMENT_XCVR_TYPE = "equipment_Xcvr_type"
    SORT_PROP_EQUIPMENT_XCVR_VENDOR = "equipment_Xcvr_vendor"
    SORT_PROP_ETHER_ERR_STATS_HIST_ALIGN = "ether_ErrStatsHist_align"
    SORT_PROP_ETHER_ERR_STATS_HIST_ALIGN_DELTA = "ether_ErrStatsHist_alignDelta"
    SORT_PROP_ETHER_ERR_STATS_HIST_ALIGN_DELTA_AVG = "ether_ErrStatsHist_alignDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_HIST_ALIGN_DELTA_MAX = "ether_ErrStatsHist_alignDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_HIST_ALIGN_DELTA_MIN = "ether_ErrStatsHist_alignDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_HIST_DEFERRED_TX = "ether_ErrStatsHist_deferredTx"
    SORT_PROP_ETHER_ERR_STATS_HIST_DEFERRED_TX_DELTA = "ether_ErrStatsHist_deferredTxDelta"
    SORT_PROP_ETHER_ERR_STATS_HIST_DEFERRED_TX_DELTA_AVG = "ether_ErrStatsHist_deferredTxDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_HIST_DEFERRED_TX_DELTA_MAX = "ether_ErrStatsHist_deferredTxDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_HIST_DEFERRED_TX_DELTA_MIN = "ether_ErrStatsHist_deferredTxDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_HIST_FCS = "ether_ErrStatsHist_fcs"
    SORT_PROP_ETHER_ERR_STATS_HIST_FCS_DELTA = "ether_ErrStatsHist_fcsDelta"
    SORT_PROP_ETHER_ERR_STATS_HIST_FCS_DELTA_AVG = "ether_ErrStatsHist_fcsDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_HIST_FCS_DELTA_MAX = "ether_ErrStatsHist_fcsDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_HIST_FCS_DELTA_MIN = "ether_ErrStatsHist_fcsDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_HIST_ID = "ether_ErrStatsHist_id"
    SORT_PROP_ETHER_ERR_STATS_HIST_INT_MAC_RX = "ether_ErrStatsHist_intMacRx"
    SORT_PROP_ETHER_ERR_STATS_HIST_INT_MAC_RX_DELTA = "ether_ErrStatsHist_intMacRxDelta"
    SORT_PROP_ETHER_ERR_STATS_HIST_INT_MAC_RX_DELTA_AVG = "ether_ErrStatsHist_intMacRxDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_HIST_INT_MAC_RX_DELTA_MAX = "ether_ErrStatsHist_intMacRxDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_HIST_INT_MAC_RX_DELTA_MIN = "ether_ErrStatsHist_intMacRxDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_HIST_INT_MAC_TX = "ether_ErrStatsHist_intMacTx"
    SORT_PROP_ETHER_ERR_STATS_HIST_INT_MAC_TX_DELTA = "ether_ErrStatsHist_intMacTxDelta"
    SORT_PROP_ETHER_ERR_STATS_HIST_INT_MAC_TX_DELTA_AVG = "ether_ErrStatsHist_intMacTxDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_HIST_INT_MAC_TX_DELTA_MAX = "ether_ErrStatsHist_intMacTxDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_HIST_INT_MAC_TX_DELTA_MIN = "ether_ErrStatsHist_intMacTxDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_HIST_MOST_RECENT = "ether_ErrStatsHist_mostRecent"
    SORT_PROP_ETHER_ERR_STATS_HIST_OUT_DISCARD = "ether_ErrStatsHist_outDiscard"
    SORT_PROP_ETHER_ERR_STATS_HIST_OUT_DISCARD_DELTA = "ether_ErrStatsHist_outDiscardDelta"
    SORT_PROP_ETHER_ERR_STATS_HIST_OUT_DISCARD_DELTA_AVG = "ether_ErrStatsHist_outDiscardDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_HIST_OUT_DISCARD_DELTA_MAX = "ether_ErrStatsHist_outDiscardDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_HIST_OUT_DISCARD_DELTA_MIN = "ether_ErrStatsHist_outDiscardDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_HIST_RCV = "ether_ErrStatsHist_rcv"
    SORT_PROP_ETHER_ERR_STATS_HIST_RCV_DELTA = "ether_ErrStatsHist_rcvDelta"
    SORT_PROP_ETHER_ERR_STATS_HIST_RCV_DELTA_AVG = "ether_ErrStatsHist_rcvDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_HIST_RCV_DELTA_MAX = "ether_ErrStatsHist_rcvDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_HIST_RCV_DELTA_MIN = "ether_ErrStatsHist_rcvDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_HIST_SUSPECT = "ether_ErrStatsHist_suspect"
    SORT_PROP_ETHER_ERR_STATS_HIST_THRESHOLDED = "ether_ErrStatsHist_thresholded"
    SORT_PROP_ETHER_ERR_STATS_HIST_TIME_COLLECTED = "ether_ErrStatsHist_timeCollected"
    SORT_PROP_ETHER_ERR_STATS_HIST_UNDER_SIZE = "ether_ErrStatsHist_underSize"
    SORT_PROP_ETHER_ERR_STATS_HIST_UNDER_SIZE_DELTA = "ether_ErrStatsHist_underSizeDelta"
    SORT_PROP_ETHER_ERR_STATS_HIST_UNDER_SIZE_DELTA_AVG = "ether_ErrStatsHist_underSizeDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_HIST_UNDER_SIZE_DELTA_MAX = "ether_ErrStatsHist_underSizeDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_HIST_UNDER_SIZE_DELTA_MIN = "ether_ErrStatsHist_underSizeDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_HIST_XMIT = "ether_ErrStatsHist_xmit"
    SORT_PROP_ETHER_ERR_STATS_HIST_XMIT_DELTA = "ether_ErrStatsHist_xmitDelta"
    SORT_PROP_ETHER_ERR_STATS_HIST_XMIT_DELTA_AVG = "ether_ErrStatsHist_xmitDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_HIST_XMIT_DELTA_MAX = "ether_ErrStatsHist_xmitDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_HIST_XMIT_DELTA_MIN = "ether_ErrStatsHist_xmitDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_ALIGN = "ether_ErrStats_align"
    SORT_PROP_ETHER_ERR_STATS_ALIGN_DELTA = "ether_ErrStats_alignDelta"
    SORT_PROP_ETHER_ERR_STATS_ALIGN_DELTA_AVG = "ether_ErrStats_alignDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_ALIGN_DELTA_MAX = "ether_ErrStats_alignDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_ALIGN_DELTA_MIN = "ether_ErrStats_alignDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_DEFERRED_TX = "ether_ErrStats_deferredTx"
    SORT_PROP_ETHER_ERR_STATS_DEFERRED_TX_DELTA = "ether_ErrStats_deferredTxDelta"
    SORT_PROP_ETHER_ERR_STATS_DEFERRED_TX_DELTA_AVG = "ether_ErrStats_deferredTxDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_DEFERRED_TX_DELTA_MAX = "ether_ErrStats_deferredTxDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_DEFERRED_TX_DELTA_MIN = "ether_ErrStats_deferredTxDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_FCS = "ether_ErrStats_fcs"
    SORT_PROP_ETHER_ERR_STATS_FCS_DELTA = "ether_ErrStats_fcsDelta"
    SORT_PROP_ETHER_ERR_STATS_FCS_DELTA_AVG = "ether_ErrStats_fcsDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_FCS_DELTA_MAX = "ether_ErrStats_fcsDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_FCS_DELTA_MIN = "ether_ErrStats_fcsDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_INT_MAC_RX = "ether_ErrStats_intMacRx"
    SORT_PROP_ETHER_ERR_STATS_INT_MAC_RX_DELTA = "ether_ErrStats_intMacRxDelta"
    SORT_PROP_ETHER_ERR_STATS_INT_MAC_RX_DELTA_AVG = "ether_ErrStats_intMacRxDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_INT_MAC_RX_DELTA_MAX = "ether_ErrStats_intMacRxDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_INT_MAC_RX_DELTA_MIN = "ether_ErrStats_intMacRxDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_INT_MAC_TX = "ether_ErrStats_intMacTx"
    SORT_PROP_ETHER_ERR_STATS_INT_MAC_TX_DELTA = "ether_ErrStats_intMacTxDelta"
    SORT_PROP_ETHER_ERR_STATS_INT_MAC_TX_DELTA_AVG = "ether_ErrStats_intMacTxDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_INT_MAC_TX_DELTA_MAX = "ether_ErrStats_intMacTxDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_INT_MAC_TX_DELTA_MIN = "ether_ErrStats_intMacTxDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_INTERVALS = "ether_ErrStats_intervals"
    SORT_PROP_ETHER_ERR_STATS_NORMALIZED_TIME_COL = "ether_ErrStats_normalizedTimeCol"
    SORT_PROP_ETHER_ERR_STATS_OUT_DISCARD = "ether_ErrStats_outDiscard"
    SORT_PROP_ETHER_ERR_STATS_OUT_DISCARD_DELTA = "ether_ErrStats_outDiscardDelta"
    SORT_PROP_ETHER_ERR_STATS_OUT_DISCARD_DELTA_AVG = "ether_ErrStats_outDiscardDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_OUT_DISCARD_DELTA_MAX = "ether_ErrStats_outDiscardDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_OUT_DISCARD_DELTA_MIN = "ether_ErrStats_outDiscardDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_RCV = "ether_ErrStats_rcv"
    SORT_PROP_ETHER_ERR_STATS_RCV_DELTA = "ether_ErrStats_rcvDelta"
    SORT_PROP_ETHER_ERR_STATS_RCV_DELTA_AVG = "ether_ErrStats_rcvDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_RCV_DELTA_MAX = "ether_ErrStats_rcvDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_RCV_DELTA_MIN = "ether_ErrStats_rcvDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_STATS_REPORTED = "ether_ErrStats_statsReported"
    SORT_PROP_ETHER_ERR_STATS_SUSPECT = "ether_ErrStats_suspect"
    SORT_PROP_ETHER_ERR_STATS_THRESHOLDED = "ether_ErrStats_thresholded"
    SORT_PROP_ETHER_ERR_STATS_TIME_COLLECTED = "ether_ErrStats_timeCollected"
    SORT_PROP_ETHER_ERR_STATS_UNDER_SIZE = "ether_ErrStats_underSize"
    SORT_PROP_ETHER_ERR_STATS_UNDER_SIZE_DELTA = "ether_ErrStats_underSizeDelta"
    SORT_PROP_ETHER_ERR_STATS_UNDER_SIZE_DELTA_AVG = "ether_ErrStats_underSizeDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_UNDER_SIZE_DELTA_MAX = "ether_ErrStats_underSizeDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_UNDER_SIZE_DELTA_MIN = "ether_ErrStats_underSizeDeltaMin"
    SORT_PROP_ETHER_ERR_STATS_UPDATE = "ether_ErrStats_update"
    SORT_PROP_ETHER_ERR_STATS_XMIT = "ether_ErrStats_xmit"
    SORT_PROP_ETHER_ERR_STATS_XMIT_DELTA = "ether_ErrStats_xmitDelta"
    SORT_PROP_ETHER_ERR_STATS_XMIT_DELTA_AVG = "ether_ErrStats_xmitDeltaAvg"
    SORT_PROP_ETHER_ERR_STATS_XMIT_DELTA_MAX = "ether_ErrStats_xmitDeltaMax"
    SORT_PROP_ETHER_ERR_STATS_XMIT_DELTA_MIN = "ether_ErrStats_xmitDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_RX = "ether_FcoeInterfaceStatsHist_bytesRx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_RX_DELTA = "ether_FcoeInterfaceStatsHist_bytesRxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_RX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_bytesRxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_RX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_bytesRxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_RX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_bytesRxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_TX = "ether_FcoeInterfaceStatsHist_bytesTx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_TX_DELTA = "ether_FcoeInterfaceStatsHist_bytesTxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_TX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_bytesTxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_TX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_bytesTxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_BYTES_TX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_bytesTxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_RX = "ether_FcoeInterfaceStatsHist_droppedRx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_RX_DELTA = "ether_FcoeInterfaceStatsHist_droppedRxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_RX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_droppedRxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_RX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_droppedRxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_RX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_droppedRxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_TX = "ether_FcoeInterfaceStatsHist_droppedTx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_TX_DELTA = "ether_FcoeInterfaceStatsHist_droppedTxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_TX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_droppedTxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_TX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_droppedTxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_DROPPED_TX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_droppedTxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_RX = "ether_FcoeInterfaceStatsHist_errorsRx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_RX_DELTA = "ether_FcoeInterfaceStatsHist_errorsRxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_RX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_errorsRxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_RX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_errorsRxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_RX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_errorsRxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_TX = "ether_FcoeInterfaceStatsHist_errorsTx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_TX_DELTA = "ether_FcoeInterfaceStatsHist_errorsTxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_TX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_errorsTxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_TX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_errorsTxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ERRORS_TX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_errorsTxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_ID = "ether_FcoeInterfaceStatsHist_id"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_MOST_RECENT = "ether_FcoeInterfaceStatsHist_mostRecent"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_RX = "ether_FcoeInterfaceStatsHist_packetsRx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_RX_DELTA = "ether_FcoeInterfaceStatsHist_packetsRxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_RX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_packetsRxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_RX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_packetsRxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_RX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_packetsRxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_TX = "ether_FcoeInterfaceStatsHist_packetsTx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_TX_DELTA = "ether_FcoeInterfaceStatsHist_packetsTxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_TX_DELTA_AVG = "ether_FcoeInterfaceStatsHist_packetsTxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_TX_DELTA_MAX = "ether_FcoeInterfaceStatsHist_packetsTxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_PACKETS_TX_DELTA_MIN = "ether_FcoeInterfaceStatsHist_packetsTxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_SUSPECT = "ether_FcoeInterfaceStatsHist_suspect"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_THRESHOLDED = "ether_FcoeInterfaceStatsHist_thresholded"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_HIST_TIME_COLLECTED = "ether_FcoeInterfaceStatsHist_timeCollected"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_BYTES_RX = "ether_FcoeInterfaceStats_bytesRx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_BYTES_RX_DELTA = "ether_FcoeInterfaceStats_bytesRxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_BYTES_RX_DELTA_AVG = "ether_FcoeInterfaceStats_bytesRxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_BYTES_RX_DELTA_MAX = "ether_FcoeInterfaceStats_bytesRxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_BYTES_RX_DELTA_MIN = "ether_FcoeInterfaceStats_bytesRxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_BYTES_TX = "ether_FcoeInterfaceStats_bytesTx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_BYTES_TX_DELTA = "ether_FcoeInterfaceStats_bytesTxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_BYTES_TX_DELTA_AVG = "ether_FcoeInterfaceStats_bytesTxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_BYTES_TX_DELTA_MAX = "ether_FcoeInterfaceStats_bytesTxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_BYTES_TX_DELTA_MIN = "ether_FcoeInterfaceStats_bytesTxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_DROPPED_RX = "ether_FcoeInterfaceStats_droppedRx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_DROPPED_RX_DELTA = "ether_FcoeInterfaceStats_droppedRxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_DROPPED_RX_DELTA_AVG = "ether_FcoeInterfaceStats_droppedRxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_DROPPED_RX_DELTA_MAX = "ether_FcoeInterfaceStats_droppedRxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_DROPPED_RX_DELTA_MIN = "ether_FcoeInterfaceStats_droppedRxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_DROPPED_TX = "ether_FcoeInterfaceStats_droppedTx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_DROPPED_TX_DELTA = "ether_FcoeInterfaceStats_droppedTxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_DROPPED_TX_DELTA_AVG = "ether_FcoeInterfaceStats_droppedTxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_DROPPED_TX_DELTA_MAX = "ether_FcoeInterfaceStats_droppedTxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_DROPPED_TX_DELTA_MIN = "ether_FcoeInterfaceStats_droppedTxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_ERRORS_RX = "ether_FcoeInterfaceStats_errorsRx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_ERRORS_RX_DELTA = "ether_FcoeInterfaceStats_errorsRxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_ERRORS_RX_DELTA_AVG = "ether_FcoeInterfaceStats_errorsRxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_ERRORS_RX_DELTA_MAX = "ether_FcoeInterfaceStats_errorsRxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_ERRORS_RX_DELTA_MIN = "ether_FcoeInterfaceStats_errorsRxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_ERRORS_TX = "ether_FcoeInterfaceStats_errorsTx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_ERRORS_TX_DELTA = "ether_FcoeInterfaceStats_errorsTxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_ERRORS_TX_DELTA_AVG = "ether_FcoeInterfaceStats_errorsTxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_ERRORS_TX_DELTA_MAX = "ether_FcoeInterfaceStats_errorsTxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_ERRORS_TX_DELTA_MIN = "ether_FcoeInterfaceStats_errorsTxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_INTERVALS = "ether_FcoeInterfaceStats_intervals"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_NORMALIZED_TIME_COL = "ether_FcoeInterfaceStats_normalizedTimeCol"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_PACKETS_RX = "ether_FcoeInterfaceStats_packetsRx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_PACKETS_RX_DELTA = "ether_FcoeInterfaceStats_packetsRxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_PACKETS_RX_DELTA_AVG = "ether_FcoeInterfaceStats_packetsRxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_PACKETS_RX_DELTA_MAX = "ether_FcoeInterfaceStats_packetsRxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_PACKETS_RX_DELTA_MIN = "ether_FcoeInterfaceStats_packetsRxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_PACKETS_TX = "ether_FcoeInterfaceStats_packetsTx"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_PACKETS_TX_DELTA = "ether_FcoeInterfaceStats_packetsTxDelta"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_PACKETS_TX_DELTA_AVG = "ether_FcoeInterfaceStats_packetsTxDeltaAvg"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_PACKETS_TX_DELTA_MAX = "ether_FcoeInterfaceStats_packetsTxDeltaMax"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_PACKETS_TX_DELTA_MIN = "ether_FcoeInterfaceStats_packetsTxDeltaMin"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_STATS_REPORTED = "ether_FcoeInterfaceStats_statsReported"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_SUSPECT = "ether_FcoeInterfaceStats_suspect"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_THRESHOLDED = "ether_FcoeInterfaceStats_thresholded"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_TIME_COLLECTED = "ether_FcoeInterfaceStats_timeCollected"
    SORT_PROP_ETHER_FCOE_INTERFACE_STATS_UPDATE = "ether_FcoeInterfaceStats_update"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SQETEST = "ether_LossStatsHist_SQETest"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SQETEST_DELTA = "ether_LossStatsHist_SQETestDelta"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SQETEST_DELTA_AVG = "ether_LossStatsHist_SQETestDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SQETEST_DELTA_MAX = "ether_LossStatsHist_SQETestDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SQETEST_DELTA_MIN = "ether_LossStatsHist_SQETestDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_HIST_CARRIER_SENSE = "ether_LossStatsHist_carrierSense"
    SORT_PROP_ETHER_LOSS_STATS_HIST_CARRIER_SENSE_DELTA = "ether_LossStatsHist_carrierSenseDelta"
    SORT_PROP_ETHER_LOSS_STATS_HIST_CARRIER_SENSE_DELTA_AVG = "ether_LossStatsHist_carrierSenseDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_HIST_CARRIER_SENSE_DELTA_MAX = "ether_LossStatsHist_carrierSenseDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_HIST_CARRIER_SENSE_DELTA_MIN = "ether_LossStatsHist_carrierSenseDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_HIST_EXCESS_COLLISION = "ether_LossStatsHist_excessCollision"
    SORT_PROP_ETHER_LOSS_STATS_HIST_EXCESS_COLLISION_DELTA = "ether_LossStatsHist_excessCollisionDelta"
    SORT_PROP_ETHER_LOSS_STATS_HIST_EXCESS_COLLISION_DELTA_AVG = "ether_LossStatsHist_excessCollisionDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_HIST_EXCESS_COLLISION_DELTA_MAX = "ether_LossStatsHist_excessCollisionDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_HIST_EXCESS_COLLISION_DELTA_MIN = "ether_LossStatsHist_excessCollisionDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_HIST_GIANTS = "ether_LossStatsHist_giants"
    SORT_PROP_ETHER_LOSS_STATS_HIST_GIANTS_DELTA = "ether_LossStatsHist_giantsDelta"
    SORT_PROP_ETHER_LOSS_STATS_HIST_GIANTS_DELTA_AVG = "ether_LossStatsHist_giantsDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_HIST_GIANTS_DELTA_MAX = "ether_LossStatsHist_giantsDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_HIST_GIANTS_DELTA_MIN = "ether_LossStatsHist_giantsDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_HIST_ID = "ether_LossStatsHist_id"
    SORT_PROP_ETHER_LOSS_STATS_HIST_LATE_COLLISION = "ether_LossStatsHist_lateCollision"
    SORT_PROP_ETHER_LOSS_STATS_HIST_LATE_COLLISION_DELTA = "ether_LossStatsHist_lateCollisionDelta"
    SORT_PROP_ETHER_LOSS_STATS_HIST_LATE_COLLISION_DELTA_AVG = "ether_LossStatsHist_lateCollisionDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_HIST_LATE_COLLISION_DELTA_MAX = "ether_LossStatsHist_lateCollisionDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_HIST_LATE_COLLISION_DELTA_MIN = "ether_LossStatsHist_lateCollisionDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_HIST_MOST_RECENT = "ether_LossStatsHist_mostRecent"
    SORT_PROP_ETHER_LOSS_STATS_HIST_MULTI_COLLISION = "ether_LossStatsHist_multiCollision"
    SORT_PROP_ETHER_LOSS_STATS_HIST_MULTI_COLLISION_DELTA = "ether_LossStatsHist_multiCollisionDelta"
    SORT_PROP_ETHER_LOSS_STATS_HIST_MULTI_COLLISION_DELTA_AVG = "ether_LossStatsHist_multiCollisionDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_HIST_MULTI_COLLISION_DELTA_MAX = "ether_LossStatsHist_multiCollisionDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_HIST_MULTI_COLLISION_DELTA_MIN = "ether_LossStatsHist_multiCollisionDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SINGLE_COLLISION = "ether_LossStatsHist_singleCollision"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SINGLE_COLLISION_DELTA = "ether_LossStatsHist_singleCollisionDelta"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SINGLE_COLLISION_DELTA_AVG = "ether_LossStatsHist_singleCollisionDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SINGLE_COLLISION_DELTA_MAX = "ether_LossStatsHist_singleCollisionDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SINGLE_COLLISION_DELTA_MIN = "ether_LossStatsHist_singleCollisionDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SUSPECT = "ether_LossStatsHist_suspect"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SYMBOL = "ether_LossStatsHist_symbol"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SYMBOL_DELTA = "ether_LossStatsHist_symbolDelta"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SYMBOL_DELTA_AVG = "ether_LossStatsHist_symbolDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SYMBOL_DELTA_MAX = "ether_LossStatsHist_symbolDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_HIST_SYMBOL_DELTA_MIN = "ether_LossStatsHist_symbolDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_HIST_THRESHOLDED = "ether_LossStatsHist_thresholded"
    SORT_PROP_ETHER_LOSS_STATS_HIST_TIME_COLLECTED = "ether_LossStatsHist_timeCollected"
    SORT_PROP_ETHER_LOSS_STATS_SQETEST = "ether_LossStats_SQETest"
    SORT_PROP_ETHER_LOSS_STATS_SQETEST_DELTA = "ether_LossStats_SQETestDelta"
    SORT_PROP_ETHER_LOSS_STATS_SQETEST_DELTA_AVG = "ether_LossStats_SQETestDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_SQETEST_DELTA_MAX = "ether_LossStats_SQETestDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_SQETEST_DELTA_MIN = "ether_LossStats_SQETestDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_CARRIER_SENSE = "ether_LossStats_carrierSense"
    SORT_PROP_ETHER_LOSS_STATS_CARRIER_SENSE_DELTA = "ether_LossStats_carrierSenseDelta"
    SORT_PROP_ETHER_LOSS_STATS_CARRIER_SENSE_DELTA_AVG = "ether_LossStats_carrierSenseDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_CARRIER_SENSE_DELTA_MAX = "ether_LossStats_carrierSenseDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_CARRIER_SENSE_DELTA_MIN = "ether_LossStats_carrierSenseDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_EXCESS_COLLISION = "ether_LossStats_excessCollision"
    SORT_PROP_ETHER_LOSS_STATS_EXCESS_COLLISION_DELTA = "ether_LossStats_excessCollisionDelta"
    SORT_PROP_ETHER_LOSS_STATS_EXCESS_COLLISION_DELTA_AVG = "ether_LossStats_excessCollisionDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_EXCESS_COLLISION_DELTA_MAX = "ether_LossStats_excessCollisionDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_EXCESS_COLLISION_DELTA_MIN = "ether_LossStats_excessCollisionDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_GIANTS = "ether_LossStats_giants"
    SORT_PROP_ETHER_LOSS_STATS_GIANTS_DELTA = "ether_LossStats_giantsDelta"
    SORT_PROP_ETHER_LOSS_STATS_GIANTS_DELTA_AVG = "ether_LossStats_giantsDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_GIANTS_DELTA_MAX = "ether_LossStats_giantsDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_GIANTS_DELTA_MIN = "ether_LossStats_giantsDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_INTERVALS = "ether_LossStats_intervals"
    SORT_PROP_ETHER_LOSS_STATS_LATE_COLLISION = "ether_LossStats_lateCollision"
    SORT_PROP_ETHER_LOSS_STATS_LATE_COLLISION_DELTA = "ether_LossStats_lateCollisionDelta"
    SORT_PROP_ETHER_LOSS_STATS_LATE_COLLISION_DELTA_AVG = "ether_LossStats_lateCollisionDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_LATE_COLLISION_DELTA_MAX = "ether_LossStats_lateCollisionDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_LATE_COLLISION_DELTA_MIN = "ether_LossStats_lateCollisionDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_MULTI_COLLISION = "ether_LossStats_multiCollision"
    SORT_PROP_ETHER_LOSS_STATS_MULTI_COLLISION_DELTA = "ether_LossStats_multiCollisionDelta"
    SORT_PROP_ETHER_LOSS_STATS_MULTI_COLLISION_DELTA_AVG = "ether_LossStats_multiCollisionDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_MULTI_COLLISION_DELTA_MAX = "ether_LossStats_multiCollisionDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_MULTI_COLLISION_DELTA_MIN = "ether_LossStats_multiCollisionDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_NORMALIZED_TIME_COL = "ether_LossStats_normalizedTimeCol"
    SORT_PROP_ETHER_LOSS_STATS_SINGLE_COLLISION = "ether_LossStats_singleCollision"
    SORT_PROP_ETHER_LOSS_STATS_SINGLE_COLLISION_DELTA = "ether_LossStats_singleCollisionDelta"
    SORT_PROP_ETHER_LOSS_STATS_SINGLE_COLLISION_DELTA_AVG = "ether_LossStats_singleCollisionDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_SINGLE_COLLISION_DELTA_MAX = "ether_LossStats_singleCollisionDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_SINGLE_COLLISION_DELTA_MIN = "ether_LossStats_singleCollisionDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_STATS_REPORTED = "ether_LossStats_statsReported"
    SORT_PROP_ETHER_LOSS_STATS_SUSPECT = "ether_LossStats_suspect"
    SORT_PROP_ETHER_LOSS_STATS_SYMBOL = "ether_LossStats_symbol"
    SORT_PROP_ETHER_LOSS_STATS_SYMBOL_DELTA = "ether_LossStats_symbolDelta"
    SORT_PROP_ETHER_LOSS_STATS_SYMBOL_DELTA_AVG = "ether_LossStats_symbolDeltaAvg"
    SORT_PROP_ETHER_LOSS_STATS_SYMBOL_DELTA_MAX = "ether_LossStats_symbolDeltaMax"
    SORT_PROP_ETHER_LOSS_STATS_SYMBOL_DELTA_MIN = "ether_LossStats_symbolDeltaMin"
    SORT_PROP_ETHER_LOSS_STATS_THRESHOLDED = "ether_LossStats_thresholded"
    SORT_PROP_ETHER_LOSS_STATS_TIME_COLLECTED = "ether_LossStats_timeCollected"
    SORT_PROP_ETHER_LOSS_STATS_UPDATE = "ether_LossStats_update"
    SORT_PROP_ETHER_PIO_ADMIN_STATE = "ether_PIo_adminState"
    SORT_PROP_ETHER_PIO_ADMIN_TRANSPORT = "ether_PIo_adminTransport"
    SORT_PROP_ETHER_PIO_AGGR_PORT_ID = "ether_PIo_aggrPortId"
    SORT_PROP_ETHER_PIO_CHASSIS_ID = "ether_PIo_chassisId"
    SORT_PROP_ETHER_PIO_ENCAP = "ether_PIo_encap"
    SORT_PROP_ETHER_PIO_EP_DN = "ether_PIo_epDn"
    SORT_PROP_ETHER_PIO_IF_ROLE = "ether_PIo_ifRole"
    SORT_PROP_ETHER_PIO_IF_TYPE = "ether_PIo_ifType"
    SORT_PROP_ETHER_PIO_IS_BREAKOUT_XCVR = "ether_PIo_isBreakoutXcvr"
    SORT_PROP_ETHER_PIO_IS_PORT_CHANNEL_MEMBER = "ether_PIo_isPortChannelMember"
    SORT_PROP_ETHER_PIO_LC = "ether_PIo_lc"
    SORT_PROP_ETHER_PIO_LIC_GP = "ether_PIo_licGP"
    SORT_PROP_ETHER_PIO_LIC_STATE = "ether_PIo_licState"
    SORT_PROP_ETHER_PIO_LOCALE = "ether_PIo_locale"
    SORT_PROP_ETHER_PIO_MAC = "ether_PIo_mac"
    SORT_PROP_ETHER_PIO_MODE = "ether_PIo_mode"
    SORT_PROP_ETHER_PIO_MODEL = "ether_PIo_model"
    SORT_PROP_ETHER_PIO_NAME = "ether_PIo_name"
    SORT_PROP_ETHER_PIO_NON_CR4 = "ether_PIo_nonCR4"
    SORT_PROP_ETHER_PIO_OPER_SPEED = "ether_PIo_operSpeed"
    SORT_PROP_ETHER_PIO_OPER_STATE = "ether_PIo_operState"
    SORT_PROP_ETHER_PIO_PEER_AGGR_PORT_ID = "ether_PIo_peerAggrPortId"
    SORT_PROP_ETHER_PIO_PEER_CHASSIS_ID = "ether_PIo_peerChassisId"
    SORT_PROP_ETHER_PIO_PEER_DN = "ether_PIo_peerDn"
    SORT_PROP_ETHER_PIO_PEER_PORT_ID = "ether_PIo_peerPortId"
    SORT_PROP_ETHER_PIO_PEER_SLOT_ID = "ether_PIo_peerSlotId"
    SORT_PROP_ETHER_PIO_PORT_CAPABILITY = "ether_PIo_portCapability"
    SORT_PROP_ETHER_PIO_PORT_ID = "ether_PIo_portId"
    SORT_PROP_ETHER_PIO_REVISION = "ether_PIo_revision"
    SORT_PROP_ETHER_PIO_SERIAL = "ether_PIo_serial"
    SORT_PROP_ETHER_PIO_SLOT_ID = "ether_PIo_slotId"
    SORT_PROP_ETHER_PIO_STATE_QUAL = "ether_PIo_stateQual"
    SORT_PROP_ETHER_PIO_SWITCH_ID = "ether_PIo_switchId"
    SORT_PROP_ETHER_PIO_TRANSPORT = "ether_PIo_transport"
    SORT_PROP_ETHER_PIO_TS = "ether_PIo_ts"
    SORT_PROP_ETHER_PIO_TYPE = "ether_PIo_type"
    SORT_PROP_ETHER_PIO_UNIFIED_PORT = "ether_PIo_unifiedPort"
    SORT_PROP_ETHER_PIO_USR_LBL = "ether_PIo_usrLbl"
    SORT_PROP_ETHER_PIO_VENDOR = "ether_PIo_vendor"
    SORT_PROP_ETHER_PIO_XCVR_TYPE = "ether_PIo_xcvrType"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_ID = "ether_PauseStatsHist_id"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_MOST_RECENT = "ether_PauseStatsHist_mostRecent"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_RECV_PAUSE = "ether_PauseStatsHist_recvPause"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_RECV_PAUSE_DELTA = "ether_PauseStatsHist_recvPauseDelta"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_RECV_PAUSE_DELTA_AVG = "ether_PauseStatsHist_recvPauseDeltaAvg"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_RECV_PAUSE_DELTA_MAX = "ether_PauseStatsHist_recvPauseDeltaMax"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_RECV_PAUSE_DELTA_MIN = "ether_PauseStatsHist_recvPauseDeltaMin"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_RESETS = "ether_PauseStatsHist_resets"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_RESETS_DELTA = "ether_PauseStatsHist_resetsDelta"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_RESETS_DELTA_AVG = "ether_PauseStatsHist_resetsDeltaAvg"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_RESETS_DELTA_MAX = "ether_PauseStatsHist_resetsDeltaMax"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_RESETS_DELTA_MIN = "ether_PauseStatsHist_resetsDeltaMin"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_SUSPECT = "ether_PauseStatsHist_suspect"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_THRESHOLDED = "ether_PauseStatsHist_thresholded"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_TIME_COLLECTED = "ether_PauseStatsHist_timeCollected"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_XMIT_PAUSE = "ether_PauseStatsHist_xmitPause"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_XMIT_PAUSE_DELTA = "ether_PauseStatsHist_xmitPauseDelta"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_XMIT_PAUSE_DELTA_AVG = "ether_PauseStatsHist_xmitPauseDeltaAvg"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_XMIT_PAUSE_DELTA_MAX = "ether_PauseStatsHist_xmitPauseDeltaMax"
    SORT_PROP_ETHER_PAUSE_STATS_HIST_XMIT_PAUSE_DELTA_MIN = "ether_PauseStatsHist_xmitPauseDeltaMin"
    SORT_PROP_ETHER_PAUSE_STATS_INTERVALS = "ether_PauseStats_intervals"
    SORT_PROP_ETHER_PAUSE_STATS_NORMALIZED_TIME_COL = "ether_PauseStats_normalizedTimeCol"
    SORT_PROP_ETHER_PAUSE_STATS_RECV_PAUSE = "ether_PauseStats_recvPause"
    SORT_PROP_ETHER_PAUSE_STATS_RECV_PAUSE_DELTA = "ether_PauseStats_recvPauseDelta"
    SORT_PROP_ETHER_PAUSE_STATS_RECV_PAUSE_DELTA_AVG = "ether_PauseStats_recvPauseDeltaAvg"
    SORT_PROP_ETHER_PAUSE_STATS_RECV_PAUSE_DELTA_MAX = "ether_PauseStats_recvPauseDeltaMax"
    SORT_PROP_ETHER_PAUSE_STATS_RECV_PAUSE_DELTA_MIN = "ether_PauseStats_recvPauseDeltaMin"
    SORT_PROP_ETHER_PAUSE_STATS_RESETS = "ether_PauseStats_resets"
    SORT_PROP_ETHER_PAUSE_STATS_RESETS_DELTA = "ether_PauseStats_resetsDelta"
    SORT_PROP_ETHER_PAUSE_STATS_RESETS_DELTA_AVG = "ether_PauseStats_resetsDeltaAvg"
    SORT_PROP_ETHER_PAUSE_STATS_RESETS_DELTA_MAX = "ether_PauseStats_resetsDeltaMax"
    SORT_PROP_ETHER_PAUSE_STATS_RESETS_DELTA_MIN = "ether_PauseStats_resetsDeltaMin"
    SORT_PROP_ETHER_PAUSE_STATS_STATS_REPORTED = "ether_PauseStats_statsReported"
    SORT_PROP_ETHER_PAUSE_STATS_SUSPECT = "ether_PauseStats_suspect"
    SORT_PROP_ETHER_PAUSE_STATS_THRESHOLDED = "ether_PauseStats_thresholded"
    SORT_PROP_ETHER_PAUSE_STATS_TIME_COLLECTED = "ether_PauseStats_timeCollected"
    SORT_PROP_ETHER_PAUSE_STATS_UPDATE = "ether_PauseStats_update"
    SORT_PROP_ETHER_PAUSE_STATS_XMIT_PAUSE = "ether_PauseStats_xmitPause"
    SORT_PROP_ETHER_PAUSE_STATS_XMIT_PAUSE_DELTA = "ether_PauseStats_xmitPauseDelta"
    SORT_PROP_ETHER_PAUSE_STATS_XMIT_PAUSE_DELTA_AVG = "ether_PauseStats_xmitPauseDeltaAvg"
    SORT_PROP_ETHER_PAUSE_STATS_XMIT_PAUSE_DELTA_MAX = "ether_PauseStats_xmitPauseDeltaMax"
    SORT_PROP_ETHER_PAUSE_STATS_XMIT_PAUSE_DELTA_MIN = "ether_PauseStats_xmitPauseDeltaMin"
    SORT_PROP_ETHER_RX_STATS_HIST_BROADCAST_PACKETS = "ether_RxStatsHist_broadcastPackets"
    SORT_PROP_ETHER_RX_STATS_HIST_BROADCAST_PACKETS_DELTA = "ether_RxStatsHist_broadcastPacketsDelta"
    SORT_PROP_ETHER_RX_STATS_HIST_BROADCAST_PACKETS_DELTA_AVG = "ether_RxStatsHist_broadcastPacketsDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_HIST_BROADCAST_PACKETS_DELTA_MAX = "ether_RxStatsHist_broadcastPacketsDeltaMax"
    SORT_PROP_ETHER_RX_STATS_HIST_BROADCAST_PACKETS_DELTA_MIN = "ether_RxStatsHist_broadcastPacketsDeltaMin"
    SORT_PROP_ETHER_RX_STATS_HIST_ID = "ether_RxStatsHist_id"
    SORT_PROP_ETHER_RX_STATS_HIST_JUMBO_PACKETS = "ether_RxStatsHist_jumboPackets"
    SORT_PROP_ETHER_RX_STATS_HIST_JUMBO_PACKETS_DELTA = "ether_RxStatsHist_jumboPacketsDelta"
    SORT_PROP_ETHER_RX_STATS_HIST_JUMBO_PACKETS_DELTA_AVG = "ether_RxStatsHist_jumboPacketsDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_HIST_JUMBO_PACKETS_DELTA_MAX = "ether_RxStatsHist_jumboPacketsDeltaMax"
    SORT_PROP_ETHER_RX_STATS_HIST_JUMBO_PACKETS_DELTA_MIN = "ether_RxStatsHist_jumboPacketsDeltaMin"
    SORT_PROP_ETHER_RX_STATS_HIST_MOST_RECENT = "ether_RxStatsHist_mostRecent"
    SORT_PROP_ETHER_RX_STATS_HIST_MULTICAST_PACKETS = "ether_RxStatsHist_multicastPackets"
    SORT_PROP_ETHER_RX_STATS_HIST_MULTICAST_PACKETS_DELTA = "ether_RxStatsHist_multicastPacketsDelta"
    SORT_PROP_ETHER_RX_STATS_HIST_MULTICAST_PACKETS_DELTA_AVG = "ether_RxStatsHist_multicastPacketsDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_HIST_MULTICAST_PACKETS_DELTA_MAX = "ether_RxStatsHist_multicastPacketsDeltaMax"
    SORT_PROP_ETHER_RX_STATS_HIST_MULTICAST_PACKETS_DELTA_MIN = "ether_RxStatsHist_multicastPacketsDeltaMin"
    SORT_PROP_ETHER_RX_STATS_HIST_SUSPECT = "ether_RxStatsHist_suspect"
    SORT_PROP_ETHER_RX_STATS_HIST_THRESHOLDED = "ether_RxStatsHist_thresholded"
    SORT_PROP_ETHER_RX_STATS_HIST_TIME_COLLECTED = "ether_RxStatsHist_timeCollected"
    SORT_PROP_ETHER_RX_STATS_HIST_TOTAL_BYTES = "ether_RxStatsHist_totalBytes"
    SORT_PROP_ETHER_RX_STATS_HIST_TOTAL_BYTES_DELTA = "ether_RxStatsHist_totalBytesDelta"
    SORT_PROP_ETHER_RX_STATS_HIST_TOTAL_BYTES_DELTA_AVG = "ether_RxStatsHist_totalBytesDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_HIST_TOTAL_BYTES_DELTA_MAX = "ether_RxStatsHist_totalBytesDeltaMax"
    SORT_PROP_ETHER_RX_STATS_HIST_TOTAL_BYTES_DELTA_MIN = "ether_RxStatsHist_totalBytesDeltaMin"
    SORT_PROP_ETHER_RX_STATS_HIST_TOTAL_PACKETS = "ether_RxStatsHist_totalPackets"
    SORT_PROP_ETHER_RX_STATS_HIST_TOTAL_PACKETS_DELTA = "ether_RxStatsHist_totalPacketsDelta"
    SORT_PROP_ETHER_RX_STATS_HIST_TOTAL_PACKETS_DELTA_AVG = "ether_RxStatsHist_totalPacketsDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_HIST_TOTAL_PACKETS_DELTA_MAX = "ether_RxStatsHist_totalPacketsDeltaMax"
    SORT_PROP_ETHER_RX_STATS_HIST_TOTAL_PACKETS_DELTA_MIN = "ether_RxStatsHist_totalPacketsDeltaMin"
    SORT_PROP_ETHER_RX_STATS_HIST_UNICAST_PACKETS = "ether_RxStatsHist_unicastPackets"
    SORT_PROP_ETHER_RX_STATS_HIST_UNICAST_PACKETS_DELTA = "ether_RxStatsHist_unicastPacketsDelta"
    SORT_PROP_ETHER_RX_STATS_HIST_UNICAST_PACKETS_DELTA_AVG = "ether_RxStatsHist_unicastPacketsDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_HIST_UNICAST_PACKETS_DELTA_MAX = "ether_RxStatsHist_unicastPacketsDeltaMax"
    SORT_PROP_ETHER_RX_STATS_HIST_UNICAST_PACKETS_DELTA_MIN = "ether_RxStatsHist_unicastPacketsDeltaMin"
    SORT_PROP_ETHER_RX_STATS_BROADCAST_PACKETS = "ether_RxStats_broadcastPackets"
    SORT_PROP_ETHER_RX_STATS_BROADCAST_PACKETS_DELTA = "ether_RxStats_broadcastPacketsDelta"
    SORT_PROP_ETHER_RX_STATS_BROADCAST_PACKETS_DELTA_AVG = "ether_RxStats_broadcastPacketsDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_BROADCAST_PACKETS_DELTA_MAX = "ether_RxStats_broadcastPacketsDeltaMax"
    SORT_PROP_ETHER_RX_STATS_BROADCAST_PACKETS_DELTA_MIN = "ether_RxStats_broadcastPacketsDeltaMin"
    SORT_PROP_ETHER_RX_STATS_INTERVALS = "ether_RxStats_intervals"
    SORT_PROP_ETHER_RX_STATS_JUMBO_PACKETS = "ether_RxStats_jumboPackets"
    SORT_PROP_ETHER_RX_STATS_JUMBO_PACKETS_DELTA = "ether_RxStats_jumboPacketsDelta"
    SORT_PROP_ETHER_RX_STATS_JUMBO_PACKETS_DELTA_AVG = "ether_RxStats_jumboPacketsDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_JUMBO_PACKETS_DELTA_MAX = "ether_RxStats_jumboPacketsDeltaMax"
    SORT_PROP_ETHER_RX_STATS_JUMBO_PACKETS_DELTA_MIN = "ether_RxStats_jumboPacketsDeltaMin"
    SORT_PROP_ETHER_RX_STATS_MULTICAST_PACKETS = "ether_RxStats_multicastPackets"
    SORT_PROP_ETHER_RX_STATS_MULTICAST_PACKETS_DELTA = "ether_RxStats_multicastPacketsDelta"
    SORT_PROP_ETHER_RX_STATS_MULTICAST_PACKETS_DELTA_AVG = "ether_RxStats_multicastPacketsDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_MULTICAST_PACKETS_DELTA_MAX = "ether_RxStats_multicastPacketsDeltaMax"
    SORT_PROP_ETHER_RX_STATS_MULTICAST_PACKETS_DELTA_MIN = "ether_RxStats_multicastPacketsDeltaMin"
    SORT_PROP_ETHER_RX_STATS_NORMALIZED_TIME_COL = "ether_RxStats_normalizedTimeCol"
    SORT_PROP_ETHER_RX_STATS_STATS_REPORTED = "ether_RxStats_statsReported"
    SORT_PROP_ETHER_RX_STATS_SUSPECT = "ether_RxStats_suspect"
    SORT_PROP_ETHER_RX_STATS_THRESHOLDED = "ether_RxStats_thresholded"
    SORT_PROP_ETHER_RX_STATS_TIME_COLLECTED = "ether_RxStats_timeCollected"
    SORT_PROP_ETHER_RX_STATS_TOTAL_BYTES = "ether_RxStats_totalBytes"
    SORT_PROP_ETHER_RX_STATS_TOTAL_BYTES_DELTA = "ether_RxStats_totalBytesDelta"
    SORT_PROP_ETHER_RX_STATS_TOTAL_BYTES_DELTA_AVG = "ether_RxStats_totalBytesDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_TOTAL_BYTES_DELTA_MAX = "ether_RxStats_totalBytesDeltaMax"
    SORT_PROP_ETHER_RX_STATS_TOTAL_BYTES_DELTA_MIN = "ether_RxStats_totalBytesDeltaMin"
    SORT_PROP_ETHER_RX_STATS_TOTAL_PACKETS = "ether_RxStats_totalPackets"
    SORT_PROP_ETHER_RX_STATS_TOTAL_PACKETS_DELTA = "ether_RxStats_totalPacketsDelta"
    SORT_PROP_ETHER_RX_STATS_TOTAL_PACKETS_DELTA_AVG = "ether_RxStats_totalPacketsDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_TOTAL_PACKETS_DELTA_MAX = "ether_RxStats_totalPacketsDeltaMax"
    SORT_PROP_ETHER_RX_STATS_TOTAL_PACKETS_DELTA_MIN = "ether_RxStats_totalPacketsDeltaMin"
    SORT_PROP_ETHER_RX_STATS_UNICAST_PACKETS = "ether_RxStats_unicastPackets"
    SORT_PROP_ETHER_RX_STATS_UNICAST_PACKETS_DELTA = "ether_RxStats_unicastPacketsDelta"
    SORT_PROP_ETHER_RX_STATS_UNICAST_PACKETS_DELTA_AVG = "ether_RxStats_unicastPacketsDeltaAvg"
    SORT_PROP_ETHER_RX_STATS_UNICAST_PACKETS_DELTA_MAX = "ether_RxStats_unicastPacketsDeltaMax"
    SORT_PROP_ETHER_RX_STATS_UNICAST_PACKETS_DELTA_MIN = "ether_RxStats_unicastPacketsDeltaMin"
    SORT_PROP_ETHER_RX_STATS_UPDATE = "ether_RxStats_update"
    SORT_PROP_ETHER_SERVER_INT_FIO_ADMIN_SPEED = "ether_ServerIntFIo_adminSpeed"
    SORT_PROP_ETHER_SERVER_INT_FIO_ADMIN_STATE = "ether_ServerIntFIo_adminState"
    SORT_PROP_ETHER_SERVER_INT_FIO_AGGR_PORT_ID = "ether_ServerIntFIo_aggrPortId"
    SORT_PROP_ETHER_SERVER_INT_FIO_CHASSIS_ID = "ether_ServerIntFIo_chassisId"
    SORT_PROP_ETHER_SERVER_INT_FIO_ENCAP = "ether_ServerIntFIo_encap"
    SORT_PROP_ETHER_SERVER_INT_FIO_EP_DN = "ether_ServerIntFIo_epDn"
    SORT_PROP_ETHER_SERVER_INT_FIO_IF_ROLE = "ether_ServerIntFIo_ifRole"
    SORT_PROP_ETHER_SERVER_INT_FIO_IF_TYPE = "ether_ServerIntFIo_ifType"
    SORT_PROP_ETHER_SERVER_INT_FIO_LOCALE = "ether_ServerIntFIo_locale"
    SORT_PROP_ETHER_SERVER_INT_FIO_MAC = "ether_ServerIntFIo_mac"
    SORT_PROP_ETHER_SERVER_INT_FIO_MAC_ADDR = "ether_ServerIntFIo_macAddr"
    SORT_PROP_ETHER_SERVER_INT_FIO_MODE = "ether_ServerIntFIo_mode"
    SORT_PROP_ETHER_SERVER_INT_FIO_MODEL = "ether_ServerIntFIo_model"
    SORT_PROP_ETHER_SERVER_INT_FIO_NAME = "ether_ServerIntFIo_name"
    SORT_PROP_ETHER_SERVER_INT_FIO_NS_SIZE = "ether_ServerIntFIo_nsSize"
    SORT_PROP_ETHER_SERVER_INT_FIO_OPER_BORDER_AGGR_PORT_ID = "ether_ServerIntFIo_operBorderAggrPortId"
    SORT_PROP_ETHER_SERVER_INT_FIO_OPER_BORDER_PORT_ID = "ether_ServerIntFIo_operBorderPortId"
    SORT_PROP_ETHER_SERVER_INT_FIO_OPER_BORDER_SLOT_ID = "ether_ServerIntFIo_operBorderSlotId"
    SORT_PROP_ETHER_SERVER_INT_FIO_OPER_STATE = "ether_ServerIntFIo_operState"
    SORT_PROP_ETHER_SERVER_INT_FIO_PEER_AGGR_PORT_ID = "ether_ServerIntFIo_peerAggrPortId"
    SORT_PROP_ETHER_SERVER_INT_FIO_PEER_CHASSIS_ID = "ether_ServerIntFIo_peerChassisId"
    SORT_PROP_ETHER_SERVER_INT_FIO_PEER_DN = "ether_ServerIntFIo_peerDn"
    SORT_PROP_ETHER_SERVER_INT_FIO_PEER_ENCAP = "ether_ServerIntFIo_peerEncap"
    SORT_PROP_ETHER_SERVER_INT_FIO_PEER_PORT_ID = "ether_ServerIntFIo_peerPortId"
    SORT_PROP_ETHER_SERVER_INT_FIO_PEER_SLOT_ID = "ether_ServerIntFIo_peerSlotId"
    SORT_PROP_ETHER_SERVER_INT_FIO_PORT_ID = "ether_ServerIntFIo_portId"
    SORT_PROP_ETHER_SERVER_INT_FIO_REVISION = "ether_ServerIntFIo_revision"
    SORT_PROP_ETHER_SERVER_INT_FIO_SERIAL = "ether_ServerIntFIo_serial"
    SORT_PROP_ETHER_SERVER_INT_FIO_SLOT_ID = "ether_ServerIntFIo_slotId"
    SORT_PROP_ETHER_SERVER_INT_FIO_STATE_QUAL = "ether_ServerIntFIo_stateQual"
    SORT_PROP_ETHER_SERVER_INT_FIO_SWITCH_ID = "ether_ServerIntFIo_switchId"
    SORT_PROP_ETHER_SERVER_INT_FIO_TRANSPORT = "ether_ServerIntFIo_transport"
    SORT_PROP_ETHER_SERVER_INT_FIO_TS = "ether_ServerIntFIo_ts"
    SORT_PROP_ETHER_SERVER_INT_FIO_TYPE = "ether_ServerIntFIo_type"
    SORT_PROP_ETHER_SERVER_INT_FIO_USER_RECOVERY_OPERATION = "ether_ServerIntFIo_userRecoveryOperation"
    SORT_PROP_ETHER_SERVER_INT_FIO_VENDOR = "ether_ServerIntFIo_vendor"
    SORT_PROP_ETHER_SERVER_INT_FIO_XCVR_TYPE = "ether_ServerIntFIo_xcvrType"
    SORT_PROP_ETHER_SWITCH_INT_FIO_ACK = "ether_SwitchIntFIo_ack"
    SORT_PROP_ETHER_SWITCH_INT_FIO_ADMIN_STATE = "ether_SwitchIntFIo_adminState"
    SORT_PROP_ETHER_SWITCH_INT_FIO_AGGR_PORT_ID = "ether_SwitchIntFIo_aggrPortId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_CHASSIS_ID = "ether_SwitchIntFIo_chassisId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_DEL_FE_TS = "ether_SwitchIntFIo_delFeTs"
    SORT_PROP_ETHER_SWITCH_INT_FIO_DISCOVERY = "ether_SwitchIntFIo_discovery"
    SORT_PROP_ETHER_SWITCH_INT_FIO_ENCAP = "ether_SwitchIntFIo_encap"
    SORT_PROP_ETHER_SWITCH_INT_FIO_EP_DN = "ether_SwitchIntFIo_epDn"
    SORT_PROP_ETHER_SWITCH_INT_FIO_IF_ROLE = "ether_SwitchIntFIo_ifRole"
    SORT_PROP_ETHER_SWITCH_INT_FIO_IF_TYPE = "ether_SwitchIntFIo_ifType"
    SORT_PROP_ETHER_SWITCH_INT_FIO_LOCALE = "ether_SwitchIntFIo_locale"
    SORT_PROP_ETHER_SWITCH_INT_FIO_MAC_ADDR = "ether_SwitchIntFIo_macAddr"
    SORT_PROP_ETHER_SWITCH_INT_FIO_MODE = "ether_SwitchIntFIo_mode"
    SORT_PROP_ETHER_SWITCH_INT_FIO_MODEL = "ether_SwitchIntFIo_model"
    SORT_PROP_ETHER_SWITCH_INT_FIO_NAME = "ether_SwitchIntFIo_name"
    SORT_PROP_ETHER_SWITCH_INT_FIO_NEW_FE_TS = "ether_SwitchIntFIo_newFeTs"
    SORT_PROP_ETHER_SWITCH_INT_FIO_OPER_STATE = "ether_SwitchIntFIo_operState"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PEER_AGGR_PORT_ID = "ether_SwitchIntFIo_peerAggrPortId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PEER_CHASSIS_ID = "ether_SwitchIntFIo_peerChassisId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PEER_DN = "ether_SwitchIntFIo_peerDn"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PEER_PORT_ID = "ether_SwitchIntFIo_peerPortId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PEER_SLOT_ID = "ether_SwitchIntFIo_peerSlotId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_PORT_ID = "ether_SwitchIntFIo_portId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_REVISION = "ether_SwitchIntFIo_revision"
    SORT_PROP_ETHER_SWITCH_INT_FIO_SERIAL = "ether_SwitchIntFIo_serial"
    SORT_PROP_ETHER_SWITCH_INT_FIO_SLOT_ID = "ether_SwitchIntFIo_slotId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_STATE_QUAL = "ether_SwitchIntFIo_stateQual"
    SORT_PROP_ETHER_SWITCH_INT_FIO_SWITCH_ID = "ether_SwitchIntFIo_switchId"
    SORT_PROP_ETHER_SWITCH_INT_FIO_TRANSPORT = "ether_SwitchIntFIo_transport"
    SORT_PROP_ETHER_SWITCH_INT_FIO_TS = "ether_SwitchIntFIo_ts"
    SORT_PROP_ETHER_SWITCH_INT_FIO_TYPE = "ether_SwitchIntFIo_type"
    SORT_PROP_ETHER_SWITCH_INT_FIO_VENDOR = "ether_SwitchIntFIo_vendor"
    SORT_PROP_ETHER_SWITCH_INT_FIO_XCVR_TYPE = "ether_SwitchIntFIo_xcvrType"
    SORT_PROP_ETHER_TX_STATS_HIST_BROADCAST_PACKETS = "ether_TxStatsHist_broadcastPackets"
    SORT_PROP_ETHER_TX_STATS_HIST_BROADCAST_PACKETS_DELTA = "ether_TxStatsHist_broadcastPacketsDelta"
    SORT_PROP_ETHER_TX_STATS_HIST_BROADCAST_PACKETS_DELTA_AVG = "ether_TxStatsHist_broadcastPacketsDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_HIST_BROADCAST_PACKETS_DELTA_MAX = "ether_TxStatsHist_broadcastPacketsDeltaMax"
    SORT_PROP_ETHER_TX_STATS_HIST_BROADCAST_PACKETS_DELTA_MIN = "ether_TxStatsHist_broadcastPacketsDeltaMin"
    SORT_PROP_ETHER_TX_STATS_HIST_ID = "ether_TxStatsHist_id"
    SORT_PROP_ETHER_TX_STATS_HIST_JUMBO_PACKETS = "ether_TxStatsHist_jumboPackets"
    SORT_PROP_ETHER_TX_STATS_HIST_JUMBO_PACKETS_DELTA = "ether_TxStatsHist_jumboPacketsDelta"
    SORT_PROP_ETHER_TX_STATS_HIST_JUMBO_PACKETS_DELTA_AVG = "ether_TxStatsHist_jumboPacketsDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_HIST_JUMBO_PACKETS_DELTA_MAX = "ether_TxStatsHist_jumboPacketsDeltaMax"
    SORT_PROP_ETHER_TX_STATS_HIST_JUMBO_PACKETS_DELTA_MIN = "ether_TxStatsHist_jumboPacketsDeltaMin"
    SORT_PROP_ETHER_TX_STATS_HIST_MOST_RECENT = "ether_TxStatsHist_mostRecent"
    SORT_PROP_ETHER_TX_STATS_HIST_MULTICAST_PACKETS = "ether_TxStatsHist_multicastPackets"
    SORT_PROP_ETHER_TX_STATS_HIST_MULTICAST_PACKETS_DELTA = "ether_TxStatsHist_multicastPacketsDelta"
    SORT_PROP_ETHER_TX_STATS_HIST_MULTICAST_PACKETS_DELTA_AVG = "ether_TxStatsHist_multicastPacketsDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_HIST_MULTICAST_PACKETS_DELTA_MAX = "ether_TxStatsHist_multicastPacketsDeltaMax"
    SORT_PROP_ETHER_TX_STATS_HIST_MULTICAST_PACKETS_DELTA_MIN = "ether_TxStatsHist_multicastPacketsDeltaMin"
    SORT_PROP_ETHER_TX_STATS_HIST_SUSPECT = "ether_TxStatsHist_suspect"
    SORT_PROP_ETHER_TX_STATS_HIST_THRESHOLDED = "ether_TxStatsHist_thresholded"
    SORT_PROP_ETHER_TX_STATS_HIST_TIME_COLLECTED = "ether_TxStatsHist_timeCollected"
    SORT_PROP_ETHER_TX_STATS_HIST_TOTAL_BYTES = "ether_TxStatsHist_totalBytes"
    SORT_PROP_ETHER_TX_STATS_HIST_TOTAL_BYTES_DELTA = "ether_TxStatsHist_totalBytesDelta"
    SORT_PROP_ETHER_TX_STATS_HIST_TOTAL_BYTES_DELTA_AVG = "ether_TxStatsHist_totalBytesDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_HIST_TOTAL_BYTES_DELTA_MAX = "ether_TxStatsHist_totalBytesDeltaMax"
    SORT_PROP_ETHER_TX_STATS_HIST_TOTAL_BYTES_DELTA_MIN = "ether_TxStatsHist_totalBytesDeltaMin"
    SORT_PROP_ETHER_TX_STATS_HIST_TOTAL_PACKETS = "ether_TxStatsHist_totalPackets"
    SORT_PROP_ETHER_TX_STATS_HIST_TOTAL_PACKETS_DELTA = "ether_TxStatsHist_totalPacketsDelta"
    SORT_PROP_ETHER_TX_STATS_HIST_TOTAL_PACKETS_DELTA_AVG = "ether_TxStatsHist_totalPacketsDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_HIST_TOTAL_PACKETS_DELTA_MAX = "ether_TxStatsHist_totalPacketsDeltaMax"
    SORT_PROP_ETHER_TX_STATS_HIST_TOTAL_PACKETS_DELTA_MIN = "ether_TxStatsHist_totalPacketsDeltaMin"
    SORT_PROP_ETHER_TX_STATS_HIST_UNICAST_PACKETS = "ether_TxStatsHist_unicastPackets"
    SORT_PROP_ETHER_TX_STATS_HIST_UNICAST_PACKETS_DELTA = "ether_TxStatsHist_unicastPacketsDelta"
    SORT_PROP_ETHER_TX_STATS_HIST_UNICAST_PACKETS_DELTA_AVG = "ether_TxStatsHist_unicastPacketsDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_HIST_UNICAST_PACKETS_DELTA_MAX = "ether_TxStatsHist_unicastPacketsDeltaMax"
    SORT_PROP_ETHER_TX_STATS_HIST_UNICAST_PACKETS_DELTA_MIN = "ether_TxStatsHist_unicastPacketsDeltaMin"
    SORT_PROP_ETHER_TX_STATS_BROADCAST_PACKETS = "ether_TxStats_broadcastPackets"
    SORT_PROP_ETHER_TX_STATS_BROADCAST_PACKETS_DELTA = "ether_TxStats_broadcastPacketsDelta"
    SORT_PROP_ETHER_TX_STATS_BROADCAST_PACKETS_DELTA_AVG = "ether_TxStats_broadcastPacketsDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_BROADCAST_PACKETS_DELTA_MAX = "ether_TxStats_broadcastPacketsDeltaMax"
    SORT_PROP_ETHER_TX_STATS_BROADCAST_PACKETS_DELTA_MIN = "ether_TxStats_broadcastPacketsDeltaMin"
    SORT_PROP_ETHER_TX_STATS_INTERVALS = "ether_TxStats_intervals"
    SORT_PROP_ETHER_TX_STATS_JUMBO_PACKETS = "ether_TxStats_jumboPackets"
    SORT_PROP_ETHER_TX_STATS_JUMBO_PACKETS_DELTA = "ether_TxStats_jumboPacketsDelta"
    SORT_PROP_ETHER_TX_STATS_JUMBO_PACKETS_DELTA_AVG = "ether_TxStats_jumboPacketsDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_JUMBO_PACKETS_DELTA_MAX = "ether_TxStats_jumboPacketsDeltaMax"
    SORT_PROP_ETHER_TX_STATS_JUMBO_PACKETS_DELTA_MIN = "ether_TxStats_jumboPacketsDeltaMin"
    SORT_PROP_ETHER_TX_STATS_MULTICAST_PACKETS = "ether_TxStats_multicastPackets"
    SORT_PROP_ETHER_TX_STATS_MULTICAST_PACKETS_DELTA = "ether_TxStats_multicastPacketsDelta"
    SORT_PROP_ETHER_TX_STATS_MULTICAST_PACKETS_DELTA_AVG = "ether_TxStats_multicastPacketsDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_MULTICAST_PACKETS_DELTA_MAX = "ether_TxStats_multicastPacketsDeltaMax"
    SORT_PROP_ETHER_TX_STATS_MULTICAST_PACKETS_DELTA_MIN = "ether_TxStats_multicastPacketsDeltaMin"
    SORT_PROP_ETHER_TX_STATS_NORMALIZED_TIME_COL = "ether_TxStats_normalizedTimeCol"
    SORT_PROP_ETHER_TX_STATS_STATS_REPORTED = "ether_TxStats_statsReported"
    SORT_PROP_ETHER_TX_STATS_SUSPECT = "ether_TxStats_suspect"
    SORT_PROP_ETHER_TX_STATS_THRESHOLDED = "ether_TxStats_thresholded"
    SORT_PROP_ETHER_TX_STATS_TIME_COLLECTED = "ether_TxStats_timeCollected"
    SORT_PROP_ETHER_TX_STATS_TOTAL_BYTES = "ether_TxStats_totalBytes"
    SORT_PROP_ETHER_TX_STATS_TOTAL_BYTES_DELTA = "ether_TxStats_totalBytesDelta"
    SORT_PROP_ETHER_TX_STATS_TOTAL_BYTES_DELTA_AVG = "ether_TxStats_totalBytesDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_TOTAL_BYTES_DELTA_MAX = "ether_TxStats_totalBytesDeltaMax"
    SORT_PROP_ETHER_TX_STATS_TOTAL_BYTES_DELTA_MIN = "ether_TxStats_totalBytesDeltaMin"
    SORT_PROP_ETHER_TX_STATS_TOTAL_PACKETS = "ether_TxStats_totalPackets"
    SORT_PROP_ETHER_TX_STATS_TOTAL_PACKETS_DELTA = "ether_TxStats_totalPacketsDelta"
    SORT_PROP_ETHER_TX_STATS_TOTAL_PACKETS_DELTA_AVG = "ether_TxStats_totalPacketsDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_TOTAL_PACKETS_DELTA_MAX = "ether_TxStats_totalPacketsDeltaMax"
    SORT_PROP_ETHER_TX_STATS_TOTAL_PACKETS_DELTA_MIN = "ether_TxStats_totalPacketsDeltaMin"
    SORT_PROP_ETHER_TX_STATS_UNICAST_PACKETS = "ether_TxStats_unicastPackets"
    SORT_PROP_ETHER_TX_STATS_UNICAST_PACKETS_DELTA = "ether_TxStats_unicastPacketsDelta"
    SORT_PROP_ETHER_TX_STATS_UNICAST_PACKETS_DELTA_AVG = "ether_TxStats_unicastPacketsDeltaAvg"
    SORT_PROP_ETHER_TX_STATS_UNICAST_PACKETS_DELTA_MAX = "ether_TxStats_unicastPacketsDeltaMax"
    SORT_PROP_ETHER_TX_STATS_UNICAST_PACKETS_DELTA_MIN = "ether_TxStats_unicastPacketsDeltaMin"
    SORT_PROP_ETHER_TX_STATS_UPDATE = "ether_TxStats_update"
    SORT_PROP_EVENT_APPLICATION_IP = "event_Application_ip"
    SORT_PROP_EVENT_APPLICATION_SUBSCRIBE_STATUS = "event_Application_subscribeStatus"
    SORT_PROP_EVENT_APPLICATION_TYPE = "event_Application_type"
    SORT_PROP_EVENT_EP_CTRL_LEVEL = "event_EpCtrl_level"
    SORT_PROP_EVENT_EP_CTRL_REVERT_TIMEOUT = "event_EpCtrl_revertTimeout"
    SORT_PROP_EVENT_HOLDER_NAME = "event_Holder_name"
    SORT_PROP_EVENT_INST_CAUSE = "event_Inst_cause"
    SORT_PROP_EVENT_INST_CHANGE_SET = "event_Inst_changeSet"
    SORT_PROP_EVENT_INST_CODE = "event_Inst_code"
    SORT_PROP_EVENT_INST_CREATED = "event_Inst_created"
    SORT_PROP_EVENT_INST_DESCR = "event_Inst_descr"
    SORT_PROP_EVENT_INST_ID = "event_Inst_id"
    SORT_PROP_EVENT_INST_RULE = "event_Inst_rule"
    SORT_PROP_EVENT_INST_SEVERITY = "event_Inst_severity"
    SORT_PROP_EVENT_INST_SRC_DME = "event_Inst_srcDme"
    SORT_PROP_EVENT_INST_TAGS = "event_Inst_tags"
    SORT_PROP_EVENT_INST_TYPE = "event_Inst_type"
    SORT_PROP_EVENT_LOG_MAX_SIZE = "event_Log_maxSize"
    SORT_PROP_EVENT_LOG_PURGE_WINDOW = "event_Log_purgeWindow"
    SORT_PROP_EVENT_LOG_SIZE = "event_Log_size"
    SORT_PROP_EVENT_POLICY_DESCR = "event_Policy_descr"
    SORT_PROP_EVENT_POLICY_INT_ID = "event_Policy_intId"
    SORT_PROP_EVENT_POLICY_NAME = "event_Policy_name"
    SORT_PROP_EVENT_POLICY_POLICY_LEVEL = "event_Policy_policyLevel"
    SORT_PROP_EVENT_POLICY_POLICY_OWNER = "event_Policy_policyOwner"
    SORT_PROP_EVENT_POLICY_RETENTION_INTERVAL = "event_Policy_retentionInterval"
    SORT_PROP_EVENT_POLICY_SIZE_LIMIT = "event_Policy_sizeLimit"
    SORT_PROP_EVENT_RECORD_AFFECTED = "event_Record_affected"
    SORT_PROP_EVENT_RECORD_CAUSE = "event_Record_cause"
    SORT_PROP_EVENT_RECORD_CHANGE_SET = "event_Record_changeSet"
    SORT_PROP_EVENT_RECORD_CODE = "event_Record_code"
    SORT_PROP_EVENT_RECORD_CREATED = "event_Record_created"
    SORT_PROP_EVENT_RECORD_DESCR = "event_Record_descr"
    SORT_PROP_EVENT_RECORD_ID = "event_Record_id"
    SORT_PROP_EVENT_RECORD_IND = "event_Record_ind"
    SORT_PROP_EVENT_RECORD_SEVERITY = "event_Record_severity"
    SORT_PROP_EVENT_RECORD_SRC_DME = "event_Record_srcDme"
    SORT_PROP_EVENT_RECORD_TRIG = "event_Record_trig"
    SORT_PROP_EVENT_RECORD_TX_ID = "event_Record_txId"
    SORT_PROP_EVENT_RECORD_USER = "event_Record_user"
    SORT_PROP_EXTMGMT_ARP_TARGETS_CONFIG_STATE = "extmgmt_ArpTargets_configState"
    SORT_PROP_EXTMGMT_ARP_TARGETS_CONFIG_STATUS_MESSAGE = "extmgmt_ArpTargets_configStatusMessage"
    SORT_PROP_EXTMGMT_ARP_TARGETS_MAX_DEADLINE_TIMEOUT = "extmgmt_ArpTargets_maxDeadlineTimeout"
    SORT_PROP_EXTMGMT_ARP_TARGETS_NUMBER_OF_ARP_REQUESTS = "extmgmt_ArpTargets_numberOfArpRequests"
    SORT_PROP_EXTMGMT_ARP_TARGETS_TARGET_IP1 = "extmgmt_ArpTargets_targetIp1"
    SORT_PROP_EXTMGMT_ARP_TARGETS_TARGET_IP2 = "extmgmt_ArpTargets_targetIp2"
    SORT_PROP_EXTMGMT_ARP_TARGETS_TARGET_IP3 = "extmgmt_ArpTargets_targetIp3"
    SORT_PROP_EXTMGMT_GATEWAY_PING_MAX_DEADLINE_TIMEOUT = "extmgmt_GatewayPing_maxDeadlineTimeout"
    SORT_PROP_EXTMGMT_GATEWAY_PING_NUMBER_OF_PING_REQUESTS = "extmgmt_GatewayPing_numberOfPingRequests"
    SORT_PROP_EXTMGMT_IF_MON_POLICY_ADMIN_STATE = "extmgmt_IfMonPolicy_adminState"
    SORT_PROP_EXTMGMT_IF_MON_POLICY_DESCR = "extmgmt_IfMonPolicy_descr"
    SORT_PROP_EXTMGMT_IF_MON_POLICY_ENABLE_HAFAILOVER = "extmgmt_IfMonPolicy_enableHAFailover"
    SORT_PROP_EXTMGMT_IF_MON_POLICY_INT_ID = "extmgmt_IfMonPolicy_intId"
    SORT_PROP_EXTMGMT_IF_MON_POLICY_MAX_FAIL_REPORT_COUNT = "extmgmt_IfMonPolicy_maxFailReportCount"
    SORT_PROP_EXTMGMT_IF_MON_POLICY_MONITOR_MECHANISM = "extmgmt_IfMonPolicy_monitorMechanism"
    SORT_PROP_EXTMGMT_IF_MON_POLICY_NAME = "extmgmt_IfMonPolicy_name"
    SORT_PROP_EXTMGMT_IF_MON_POLICY_POLICY_LEVEL = "extmgmt_IfMonPolicy_policyLevel"
    SORT_PROP_EXTMGMT_IF_MON_POLICY_POLICY_OWNER = "extmgmt_IfMonPolicy_policyOwner"
    SORT_PROP_EXTMGMT_IF_MON_POLICY_POLL_INTERVAL = "extmgmt_IfMonPolicy_pollInterval"
    SORT_PROP_EXTMGMT_MII_STATUS_MAX_RETRY_COUNT = "extmgmt_MiiStatus_maxRetryCount"
    SORT_PROP_EXTMGMT_MII_STATUS_RETRY_INTERVAL = "extmgmt_MiiStatus_retryInterval"
    SORT_PROP_EXTMGMT_NDISC_TARGETS_CONFIG_STATE = "extmgmt_NdiscTargets_configState"
    SORT_PROP_EXTMGMT_NDISC_TARGETS_CONFIG_STATUS_MESSAGE = "extmgmt_NdiscTargets_configStatusMessage"
    SORT_PROP_EXTMGMT_NDISC_TARGETS_IPV6_TARGET1 = "extmgmt_NdiscTargets_ipv6Target1"
    SORT_PROP_EXTMGMT_NDISC_TARGETS_IPV6_TARGET2 = "extmgmt_NdiscTargets_ipv6Target2"
    SORT_PROP_EXTMGMT_NDISC_TARGETS_IPV6_TARGET3 = "extmgmt_NdiscTargets_ipv6Target3"
    SORT_PROP_EXTMGMT_NDISC_TARGETS_MAX_DEADLINE_TIMEOUT = "extmgmt_NdiscTargets_maxDeadlineTimeout"
    SORT_PROP_EXTMGMT_NDISC_TARGETS_NUMBER_OF_NDISC_REQUESTS = "extmgmt_NdiscTargets_numberOfNdiscRequests"
    SORT_PROP_EXTPOL_CLIENT_CONT_GEN_NUM = "extpol_ClientCont_genNum"
    SORT_PROP_EXTPOL_CLIENT_FSM_STAGE_DESCR = "extpol_ClientFsmStage_descr"
    SORT_PROP_EXTPOL_CLIENT_FSM_STAGE_LAST_UPDATE_TIME = "extpol_ClientFsmStage_lastUpdateTime"
    SORT_PROP_EXTPOL_CLIENT_FSM_STAGE_NAME = "extpol_ClientFsmStage_name"
    SORT_PROP_EXTPOL_CLIENT_FSM_STAGE_ORDER = "extpol_ClientFsmStage_order"
    SORT_PROP_EXTPOL_CLIENT_FSM_STAGE_RETRY = "extpol_ClientFsmStage_retry"
    SORT_PROP_EXTPOL_CLIENT_FSM_STAGE_STAGE_STATUS = "extpol_ClientFsmStage_stageStatus"
    SORT_PROP_EXTPOL_CLIENT_FSM_TASK_COMPLETION = "extpol_ClientFsmTask_completion"
    SORT_PROP_EXTPOL_CLIENT_FSM_TASK_FLAGS = "extpol_ClientFsmTask_flags"
    SORT_PROP_EXTPOL_CLIENT_FSM_TASK_ITEM = "extpol_ClientFsmTask_item"
    SORT_PROP_EXTPOL_CLIENT_FSM_TASK_SEQ_ID = "extpol_ClientFsmTask_seqId"
    SORT_PROP_EXTPOL_CLIENT_FSM_COMPLETION_TIME = "extpol_ClientFsm_completionTime"
    SORT_PROP_EXTPOL_CLIENT_FSM_CURRENT_FSM = "extpol_ClientFsm_currentFsm"
    SORT_PROP_EXTPOL_CLIENT_FSM_DESCR = "extpol_ClientFsm_descr"
    SORT_PROP_EXTPOL_CLIENT_FSM_FSM_INSTANCE_ID = "extpol_ClientFsm_fsmInstanceId"
    SORT_PROP_EXTPOL_CLIENT_FSM_FSM_STATUS = "extpol_ClientFsm_fsmStatus"
    SORT_PROP_EXTPOL_CLIENT_FSM_PROGRESS = "extpol_ClientFsm_progress"
    SORT_PROP_EXTPOL_CLIENT_FSM_RMT_ERR_CODE = "extpol_ClientFsm_rmtErrCode"
    SORT_PROP_EXTPOL_CLIENT_FSM_RMT_ERR_DESCR = "extpol_ClientFsm_rmtErrDescr"
    SORT_PROP_EXTPOL_CLIENT_FSM_RMT_RSLT = "extpol_ClientFsm_rmtRslt"
    SORT_PROP_EXTPOL_CLIENT_CAPABILITY = "extpol_Client_capability"
    SORT_PROP_EXTPOL_CLIENT_CONN_PROTOCOL = "extpol_Client_connProtocol"
    SORT_PROP_EXTPOL_CLIENT_CONNECTION_STATE = "extpol_Client_connectionState"
    SORT_PROP_EXTPOL_CLIENT_CONTEXT = "extpol_Client_context"
    SORT_PROP_EXTPOL_CLIENT_DESCR = "extpol_Client_descr"
    SORT_PROP_EXTPOL_CLIENT_FSM_DESCR = "extpol_Client_fsmDescr"
    SORT_PROP_EXTPOL_CLIENT_FSM_PREV = "extpol_Client_fsmPrev"
    SORT_PROP_EXTPOL_CLIENT_FSM_PROGR = "extpol_Client_fsmProgr"
    SORT_PROP_EXTPOL_CLIENT_FSM_RMT_INV_ERR_CODE = "extpol_Client_fsmRmtInvErrCode"
    SORT_PROP_EXTPOL_CLIENT_FSM_RMT_INV_ERR_DESCR = "extpol_Client_fsmRmtInvErrDescr"
    SORT_PROP_EXTPOL_CLIENT_FSM_RMT_INV_RSLT = "extpol_Client_fsmRmtInvRslt"
    SORT_PROP_EXTPOL_CLIENT_FSM_STAGE_DESCR = "extpol_Client_fsmStageDescr"
    SORT_PROP_EXTPOL_CLIENT_FSM_STAMP = "extpol_Client_fsmStamp"
    SORT_PROP_EXTPOL_CLIENT_FSM_STATUS = "extpol_Client_fsmStatus"
    SORT_PROP_EXTPOL_CLIENT_FSM_TRY = "extpol_Client_fsmTry"
    SORT_PROP_EXTPOL_CLIENT_GRACE_PERIOD_USED = "extpol_Client_gracePeriodUsed"
    SORT_PROP_EXTPOL_CLIENT_GUID = "extpol_Client_guid"
    SORT_PROP_EXTPOL_CLIENT_HOST = "extpol_Client_host"
    SORT_PROP_EXTPOL_CLIENT_ID = "extpol_Client_id"
    SORT_PROP_EXTPOL_CLIENT_INTEREST = "extpol_Client_interest"
    SORT_PROP_EXTPOL_CLIENT_IP = "extpol_Client_ip"
    SORT_PROP_EXTPOL_CLIENT_IPV6 = "extpol_Client_ipv6"
    SORT_PROP_EXTPOL_CLIENT_LAST_POLL_TS = "extpol_Client_lastPollTs"
    SORT_PROP_EXTPOL_CLIENT_LIC_STATE = "extpol_Client_licState"
    SORT_PROP_EXTPOL_CLIENT_LOSS_VISIBILITY_SOURCE = "extpol_Client_lossVisibilitySource"
    SORT_PROP_EXTPOL_CLIENT_MAINT_GRP_TAG = "extpol_Client_maintGrpTag"
    SORT_PROP_EXTPOL_CLIENT_NAME = "extpol_Client_name"
    SORT_PROP_EXTPOL_CLIENT_OPER_STATE = "extpol_Client_operState"
    SORT_PROP_EXTPOL_CLIENT_OWNER = "extpol_Client_owner"
    SORT_PROP_EXTPOL_CLIENT_PRODUCT_FAMILY = "extpol_Client_productFamily"
    SORT_PROP_EXTPOL_CLIENT_REG_COUNT = "extpol_Client_regCount"
    SORT_PROP_EXTPOL_CLIENT_SITE = "extpol_Client_site"
    SORT_PROP_EXTPOL_CLIENT_SUSPEND_STATE = "extpol_Client_suspendState"
    SORT_PROP_EXTPOL_CLIENT_TYPE = "extpol_Client_type"
    SORT_PROP_EXTPOL_CLIENT_VERSION = "extpol_Client_version"
    SORT_PROP_EXTPOL_CLIENT_VERSION_HOLDER = "extpol_Client_versionHolder"
    SORT_PROP_EXTPOL_CONNECTOR_CAPABILITY = "extpol_Connector_capability"
    SORT_PROP_EXTPOL_CONNECTOR_CONN_PROTOCOL = "extpol_Connector_connProtocol"
    SORT_PROP_EXTPOL_CONNECTOR_CONNECTION_STATE = "extpol_Connector_connectionState"
    SORT_PROP_EXTPOL_CONNECTOR_HOST = "extpol_Connector_host"
    SORT_PROP_EXTPOL_CONNECTOR_ID = "extpol_Connector_id"
    SORT_PROP_EXTPOL_CONNECTOR_INTEREST = "extpol_Connector_interest"
    SORT_PROP_EXTPOL_CONNECTOR_IP = "extpol_Connector_ip"
    SORT_PROP_EXTPOL_CONNECTOR_IPV6 = "extpol_Connector_ipv6"
    SORT_PROP_EXTPOL_CONNECTOR_LAST_POLL_TS = "extpol_Connector_lastPollTs"
    SORT_PROP_EXTPOL_CONNECTOR_NAME = "extpol_Connector_name"
    SORT_PROP_EXTPOL_CONNECTOR_OPER_STATE = "extpol_Connector_operState"
    SORT_PROP_EXTPOL_CONNECTOR_TYPE = "extpol_Connector_type"
    SORT_PROP_EXTPOL_CONNECTOR_VERSION = "extpol_Connector_version"
    SORT_PROP_EXTPOL_CONTROLLER_CONT_GEN_NUM = "extpol_ControllerCont_genNum"
    SORT_PROP_EXTPOL_CONTROLLER_CAPABILITY = "extpol_Controller_capability"
    SORT_PROP_EXTPOL_CONTROLLER_CONN_PROTOCOL = "extpol_Controller_connProtocol"
    SORT_PROP_EXTPOL_CONTROLLER_CONNECTION_STATE = "extpol_Controller_connectionState"
    SORT_PROP_EXTPOL_CONTROLLER_HOST = "extpol_Controller_host"
    SORT_PROP_EXTPOL_CONTROLLER_ID = "extpol_Controller_id"
    SORT_PROP_EXTPOL_CONTROLLER_INTEREST = "extpol_Controller_interest"
    SORT_PROP_EXTPOL_CONTROLLER_IP = "extpol_Controller_ip"
    SORT_PROP_EXTPOL_CONTROLLER_IPV6 = "extpol_Controller_ipv6"
    SORT_PROP_EXTPOL_CONTROLLER_LAST_POLL_TS = "extpol_Controller_lastPollTs"
    SORT_PROP_EXTPOL_CONTROLLER_NAME = "extpol_Controller_name"
    SORT_PROP_EXTPOL_CONTROLLER_OPER_STATE = "extpol_Controller_operState"
    SORT_PROP_EXTPOL_CONTROLLER_TYPE = "extpol_Controller_type"
    SORT_PROP_EXTPOL_CONTROLLER_VERSION = "extpol_Controller_version"
    SORT_PROP_EXTPOL_DOMAIN_GUID = "extpol_Domain_guid"
    SORT_PROP_EXTPOL_DOMAIN_ID = "extpol_Domain_id"
    SORT_PROP_EXTPOL_DOMAIN_PRODUCT_FAMILY = "extpol_Domain_productFamily"
    SORT_PROP_EXTPOL_DOMAIN_REG_COUNT = "extpol_Domain_regCount"
    SORT_PROP_EXTPOL_EP_FSM_STAGE_DESCR = "extpol_EpFsmStage_descr"
    SORT_PROP_EXTPOL_EP_FSM_STAGE_LAST_UPDATE_TIME = "extpol_EpFsmStage_lastUpdateTime"
    SORT_PROP_EXTPOL_EP_FSM_STAGE_NAME = "extpol_EpFsmStage_name"
    SORT_PROP_EXTPOL_EP_FSM_STAGE_ORDER = "extpol_EpFsmStage_order"
    SORT_PROP_EXTPOL_EP_FSM_STAGE_RETRY = "extpol_EpFsmStage_retry"
    SORT_PROP_EXTPOL_EP_FSM_STAGE_STAGE_STATUS = "extpol_EpFsmStage_stageStatus"
    SORT_PROP_EXTPOL_EP_FSM_TASK_COMPLETION = "extpol_EpFsmTask_completion"
    SORT_PROP_EXTPOL_EP_FSM_TASK_FLAGS = "extpol_EpFsmTask_flags"
    SORT_PROP_EXTPOL_EP_FSM_TASK_ITEM = "extpol_EpFsmTask_item"
    SORT_PROP_EXTPOL_EP_FSM_TASK_SEQ_ID = "extpol_EpFsmTask_seqId"
    SORT_PROP_EXTPOL_EP_FSM_COMPLETION_TIME = "extpol_EpFsm_completionTime"
    SORT_PROP_EXTPOL_EP_FSM_CURRENT_FSM = "extpol_EpFsm_currentFsm"
    SORT_PROP_EXTPOL_EP_FSM_DESCR = "extpol_EpFsm_descr"
    SORT_PROP_EXTPOL_EP_FSM_FSM_INSTANCE_ID = "extpol_EpFsm_fsmInstanceId"
    SORT_PROP_EXTPOL_EP_FSM_FSM_STATUS = "extpol_EpFsm_fsmStatus"
    SORT_PROP_EXTPOL_EP_FSM_PROGRESS = "extpol_EpFsm_progress"
    SORT_PROP_EXTPOL_EP_FSM_RMT_ERR_CODE = "extpol_EpFsm_rmtErrCode"
    SORT_PROP_EXTPOL_EP_FSM_RMT_ERR_DESCR = "extpol_EpFsm_rmtErrDescr"
    SORT_PROP_EXTPOL_EP_FSM_RMT_RSLT = "extpol_EpFsm_rmtRslt"
    SORT_PROP_EXTPOL_EP_FSM_DESCR = "extpol_Ep_fsmDescr"
    SORT_PROP_EXTPOL_EP_FSM_PREV = "extpol_Ep_fsmPrev"
    SORT_PROP_EXTPOL_EP_FSM_PROGR = "extpol_Ep_fsmProgr"
    SORT_PROP_EXTPOL_EP_FSM_RMT_INV_ERR_CODE = "extpol_Ep_fsmRmtInvErrCode"
    SORT_PROP_EXTPOL_EP_FSM_RMT_INV_ERR_DESCR = "extpol_Ep_fsmRmtInvErrDescr"
    SORT_PROP_EXTPOL_EP_FSM_RMT_INV_RSLT = "extpol_Ep_fsmRmtInvRslt"
    SORT_PROP_EXTPOL_EP_FSM_STAGE_DESCR = "extpol_Ep_fsmStageDescr"
    SORT_PROP_EXTPOL_EP_FSM_STAMP = "extpol_Ep_fsmStamp"
    SORT_PROP_EXTPOL_EP_FSM_STATUS = "extpol_Ep_fsmStatus"
    SORT_PROP_EXTPOL_EP_FSM_TRY = "extpol_Ep_fsmTry"
    SORT_PROP_EXTPOL_HBSTATUS_SCAN_COMPLETED = "extpol_HBStatus_scanCompleted"
    SORT_PROP_EXTPOL_HBSTATUS_SCAN_ENABLED = "extpol_HBStatus_scanEnabled"
    SORT_PROP_EXTPOL_PROVIDER_CONT_GEN_NUM = "extpol_ProviderCont_genNum"
    SORT_PROP_EXTPOL_PROVIDER_CAPABILITY = "extpol_Provider_capability"
    SORT_PROP_EXTPOL_PROVIDER_CONN_PROTOCOL = "extpol_Provider_connProtocol"
    SORT_PROP_EXTPOL_PROVIDER_CONNECTION_STATE = "extpol_Provider_connectionState"
    SORT_PROP_EXTPOL_PROVIDER_HOST = "extpol_Provider_host"
    SORT_PROP_EXTPOL_PROVIDER_ID = "extpol_Provider_id"
    SORT_PROP_EXTPOL_PROVIDER_INTEREST = "extpol_Provider_interest"
    SORT_PROP_EXTPOL_PROVIDER_IP = "extpol_Provider_ip"
    SORT_PROP_EXTPOL_PROVIDER_IPV6 = "extpol_Provider_ipv6"
    SORT_PROP_EXTPOL_PROVIDER_LAST_POLL_TS = "extpol_Provider_lastPollTs"
    SORT_PROP_EXTPOL_PROVIDER_NAME = "extpol_Provider_name"
    SORT_PROP_EXTPOL_PROVIDER_OPER_STATE = "extpol_Provider_operState"
    SORT_PROP_EXTPOL_PROVIDER_TYPE = "extpol_Provider_type"
    SORT_PROP_EXTPOL_PROVIDER_VERSION = "extpol_Provider_version"
    SORT_PROP_EXTPOL_REGISTRY_CAPABILITY_PRODUCT_FAMILY = "extpol_RegistryCapability_productFamily"
    SORT_PROP_EXTPOL_REGISTRY_CAPABILITY = "extpol_Registry_capability"
    SORT_PROP_EXTPOL_REGISTRY_CONN_PROTOCOL = "extpol_Registry_connProtocol"
    SORT_PROP_EXTPOL_REGISTRY_CONNECTION_STATE = "extpol_Registry_connectionState"
    SORT_PROP_EXTPOL_REGISTRY_GEN_NUM = "extpol_Registry_genNum"
    SORT_PROP_EXTPOL_REGISTRY_GUID = "extpol_Registry_guid"
    SORT_PROP_EXTPOL_REGISTRY_HOST = "extpol_Registry_host"
    SORT_PROP_EXTPOL_REGISTRY_ID = "extpol_Registry_id"
    SORT_PROP_EXTPOL_REGISTRY_ID_COUNT = "extpol_Registry_idCount"
    SORT_PROP_EXTPOL_REGISTRY_INTEREST = "extpol_Registry_interest"
    SORT_PROP_EXTPOL_REGISTRY_IP = "extpol_Registry_ip"
    SORT_PROP_EXTPOL_REGISTRY_IPV6 = "extpol_Registry_ipv6"
    SORT_PROP_EXTPOL_REGISTRY_LAST_POLL_TS = "extpol_Registry_lastPollTs"
    SORT_PROP_EXTPOL_REGISTRY_NAME = "extpol_Registry_name"
    SORT_PROP_EXTPOL_REGISTRY_OPER_STATE = "extpol_Registry_operState"
    SORT_PROP_EXTPOL_REGISTRY_TYPE = "extpol_Registry_type"
    SORT_PROP_EXTPOL_REGISTRY_VERSION = "extpol_Registry_version"
    SORT_PROP_EXTPOL_SVC_CAPABILITY = "extpol_Svc_capability"
    SORT_PROP_EXTPOL_SVC_CONN_PROTOCOL = "extpol_Svc_connProtocol"
    SORT_PROP_EXTPOL_SVC_CONNECTION_STATE = "extpol_Svc_connectionState"
    SORT_PROP_EXTPOL_SVC_HOST = "extpol_Svc_host"
    SORT_PROP_EXTPOL_SVC_ID = "extpol_Svc_id"
    SORT_PROP_EXTPOL_SVC_INTEREST = "extpol_Svc_interest"
    SORT_PROP_EXTPOL_SVC_IP = "extpol_Svc_ip"
    SORT_PROP_EXTPOL_SVC_IPV6 = "extpol_Svc_ipv6"
    SORT_PROP_EXTPOL_SVC_LAST_POLL_TS = "extpol_Svc_lastPollTs"
    SORT_PROP_EXTPOL_SVC_NAME = "extpol_Svc_name"
    SORT_PROP_EXTPOL_SVC_OPER_STATE = "extpol_Svc_operState"
    SORT_PROP_EXTPOL_SVC_TYPE = "extpol_Svc_type"
    SORT_PROP_EXTPOL_SVC_VERSION = "extpol_Svc_version"
    SORT_PROP_EXTPOL_SYSTEM_CONTEXT_CAPABILITY = "extpol_SystemContext_capability"
    SORT_PROP_EXTPOL_SYSTEM_CONTEXT_DESCR = "extpol_SystemContext_descr"
    SORT_PROP_EXTPOL_SYSTEM_CONTEXT_GUID = "extpol_SystemContext_guid"
    SORT_PROP_EXTPOL_SYSTEM_CONTEXT_ID = "extpol_SystemContext_id"
    SORT_PROP_EXTPOL_SYSTEM_CONTEXT_INTEREST = "extpol_SystemContext_interest"
    SORT_PROP_EXTPOL_SYSTEM_CONTEXT_IP = "extpol_SystemContext_ip"
    SORT_PROP_EXTPOL_SYSTEM_CONTEXT_IPV6ADDR = "extpol_SystemContext_ipv6addr"
    SORT_PROP_EXTPOL_SYSTEM_CONTEXT_MODEL = "extpol_SystemContext_model"
    SORT_PROP_EXTPOL_SYSTEM_CONTEXT_NAME = "extpol_SystemContext_name"
    SORT_PROP_EXTPOL_SYSTEM_CONTEXT_OWNER = "extpol_SystemContext_owner"
    SORT_PROP_EXTPOL_SYSTEM_CONTEXT_SITE = "extpol_SystemContext_site"
    SORT_PROP_EXTPOL_SYSTEM_CONTEXT_TYPE = "extpol_SystemContext_type"
    SORT_PROP_EXTPOL_SYSTEM_CONTEXT_VERSION = "extpol_SystemContext_version"
    SORT_PROP_EXTPOL_VERSION_HOLDER_CONN_PROTOCOL = "extpol_VersionHolder_connProtocol"
    SORT_PROP_EXTPOL_VERSION_HOLDER_GUID = "extpol_VersionHolder_guid"
    SORT_PROP_EXTPOL_VERSION_HOLDER_HOST = "extpol_VersionHolder_host"
    SORT_PROP_EXTPOL_VERSION_HOLDER_ID = "extpol_VersionHolder_id"
    SORT_PROP_EXTPOL_VERSION_HOLDER_IPV4 = "extpol_VersionHolder_ipv4"
    SORT_PROP_EXTPOL_VERSION_HOLDER_IPV6 = "extpol_VersionHolder_ipv6"
    SORT_PROP_EXTPOL_VERSION_HOLDER_OPERATION = "extpol_VersionHolder_operation"
    SORT_PROP_EXTPOL_VERSION_HOLDER_PRODUCT_FAMILY = "extpol_VersionHolder_productFamily"
    SORT_PROP_EXTPOL_VERSION_HOLDER_VERSION_HOLDER = "extpol_VersionHolder_versionHolder"
    SORT_PROP_EXTPOL_VERSION_HOLDER_VERSION_HOLDER_FLAG = "extpol_VersionHolder_versionHolderFlag"
    SORT_PROP_EXTVMM_NETWORK_SETS_GEN_NUM = "extvmm_NetworkSets_genNum"
    SORT_PROP_EXTVMM_VMNETWORK_SETS_GEN_NUM = "extvmm_VMNetworkSets_genNum"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_ADMIN_STATE = "fabric_ADceSwSrvEp_adminState"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_AGGR_PORT_ID = "fabric_ADceSwSrvEp_aggrPortId"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_AUTO_NEGOTIATE = "fabric_ADceSwSrvEp_autoNegotiate"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_CHASSIS_ID = "fabric_ADceSwSrvEp_chassisId"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_EP_DN = "fabric_ADceSwSrvEp_epDn"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_FLT_AGGR = "fabric_ADceSwSrvEp_fltAggr"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_IF_ROLE = "fabric_ADceSwSrvEp_ifRole"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_IF_TYPE = "fabric_ADceSwSrvEp_ifType"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_LIC_GP = "fabric_ADceSwSrvEp_licGP"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_LIC_STATE = "fabric_ADceSwSrvEp_licState"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_LOCALE = "fabric_ADceSwSrvEp_locale"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_NAME = "fabric_ADceSwSrvEp_name"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_OPER_STATE = "fabric_ADceSwSrvEp_operState"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_OPER_STATE_REASON = "fabric_ADceSwSrvEp_operStateReason"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_PEER_AGGR_PORT_ID = "fabric_ADceSwSrvEp_peerAggrPortId"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_PEER_CHASSIS_ID = "fabric_ADceSwSrvEp_peerChassisId"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_PEER_DN = "fabric_ADceSwSrvEp_peerDn"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_PEER_PORT_ID = "fabric_ADceSwSrvEp_peerPortId"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_PEER_SLOT_ID = "fabric_ADceSwSrvEp_peerSlotId"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_PORT_ID = "fabric_ADceSwSrvEp_portId"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_SLOT_ID = "fabric_ADceSwSrvEp_slotId"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_SWITCH_ID = "fabric_ADceSwSrvEp_switchId"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_TRANSPORT = "fabric_ADceSwSrvEp_transport"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_TYPE = "fabric_ADceSwSrvEp_type"
    SORT_PROP_FABRIC_ADCE_SW_SRV_EP_USR_LBL = "fabric_ADceSwSrvEp_usrLbl"
    SORT_PROP_FABRIC_AETH_ESTC_EP_ADMIN_STATE = "fabric_AEthEstcEp_adminState"
    SORT_PROP_FABRIC_AETH_ESTC_EP_AGGR_PORT_ID = "fabric_AEthEstcEp_aggrPortId"
    SORT_PROP_FABRIC_AETH_ESTC_EP_AUTO_NEGOTIATE = "fabric_AEthEstcEp_autoNegotiate"
    SORT_PROP_FABRIC_AETH_ESTC_EP_CHASSIS_ID = "fabric_AEthEstcEp_chassisId"
    SORT_PROP_FABRIC_AETH_ESTC_EP_CONFIG_STATE = "fabric_AEthEstcEp_configState"
    SORT_PROP_FABRIC_AETH_ESTC_EP_EP_DN = "fabric_AEthEstcEp_epDn"
    SORT_PROP_FABRIC_AETH_ESTC_EP_FLT_AGGR = "fabric_AEthEstcEp_fltAggr"
    SORT_PROP_FABRIC_AETH_ESTC_EP_IF_ROLE = "fabric_AEthEstcEp_ifRole"
    SORT_PROP_FABRIC_AETH_ESTC_EP_IF_TYPE = "fabric_AEthEstcEp_ifType"
    SORT_PROP_FABRIC_AETH_ESTC_EP_LIC_GP = "fabric_AEthEstcEp_licGP"
    SORT_PROP_FABRIC_AETH_ESTC_EP_LIC_STATE = "fabric_AEthEstcEp_licState"
    SORT_PROP_FABRIC_AETH_ESTC_EP_LOCALE = "fabric_AEthEstcEp_locale"
    SORT_PROP_FABRIC_AETH_ESTC_EP_NAME = "fabric_AEthEstcEp_name"
    SORT_PROP_FABRIC_AETH_ESTC_EP_OPER_STATE = "fabric_AEthEstcEp_operState"
    SORT_PROP_FABRIC_AETH_ESTC_EP_OPER_STATE_REASON = "fabric_AEthEstcEp_operStateReason"
    SORT_PROP_FABRIC_AETH_ESTC_EP_PEER_AGGR_PORT_ID = "fabric_AEthEstcEp_peerAggrPortId"
    SORT_PROP_FABRIC_AETH_ESTC_EP_PEER_CHASSIS_ID = "fabric_AEthEstcEp_peerChassisId"
    SORT_PROP_FABRIC_AETH_ESTC_EP_PEER_DN = "fabric_AEthEstcEp_peerDn"
    SORT_PROP_FABRIC_AETH_ESTC_EP_PEER_PORT_ID = "fabric_AEthEstcEp_peerPortId"
    SORT_PROP_FABRIC_AETH_ESTC_EP_PEER_SLOT_ID = "fabric_AEthEstcEp_peerSlotId"
    SORT_PROP_FABRIC_AETH_ESTC_EP_PORT_ID = "fabric_AEthEstcEp_portId"
    SORT_PROP_FABRIC_AETH_ESTC_EP_SLOT_ID = "fabric_AEthEstcEp_slotId"
    SORT_PROP_FABRIC_AETH_ESTC_EP_SWITCH_ID = "fabric_AEthEstcEp_switchId"
    SORT_PROP_FABRIC_AETH_ESTC_EP_TRANSPORT = "fabric_AEthEstcEp_transport"
    SORT_PROP_FABRIC_AETH_ESTC_EP_TYPE = "fabric_AEthEstcEp_type"
    SORT_PROP_FABRIC_AETH_ESTC_EP_USR_LBL = "fabric_AEthEstcEp_usrLbl"
    SORT_PROP_FABRIC_AETH_ESTC_EP_WARNINGS = "fabric_AEthEstcEp_warnings"
    SORT_PROP_FABRIC_AETH_LAN_EP_ADMIN_STATE = "fabric_AEthLanEp_adminState"
    SORT_PROP_FABRIC_AETH_LAN_EP_AGGR_PORT_ID = "fabric_AEthLanEp_aggrPortId"
    SORT_PROP_FABRIC_AETH_LAN_EP_AUTO_NEGOTIATE = "fabric_AEthLanEp_autoNegotiate"
    SORT_PROP_FABRIC_AETH_LAN_EP_CHASSIS_ID = "fabric_AEthLanEp_chassisId"
    SORT_PROP_FABRIC_AETH_LAN_EP_EP_DN = "fabric_AEthLanEp_epDn"
    SORT_PROP_FABRIC_AETH_LAN_EP_FLT_AGGR = "fabric_AEthLanEp_fltAggr"
    SORT_PROP_FABRIC_AETH_LAN_EP_IF_ROLE = "fabric_AEthLanEp_ifRole"
    SORT_PROP_FABRIC_AETH_LAN_EP_IF_TYPE = "fabric_AEthLanEp_ifType"
    SORT_PROP_FABRIC_AETH_LAN_EP_LIC_GP = "fabric_AEthLanEp_licGP"
    SORT_PROP_FABRIC_AETH_LAN_EP_LIC_STATE = "fabric_AEthLanEp_licState"
    SORT_PROP_FABRIC_AETH_LAN_EP_LOCALE = "fabric_AEthLanEp_locale"
    SORT_PROP_FABRIC_AETH_LAN_EP_NAME = "fabric_AEthLanEp_name"
    SORT_PROP_FABRIC_AETH_LAN_EP_OPER_STATE = "fabric_AEthLanEp_operState"
    SORT_PROP_FABRIC_AETH_LAN_EP_OPER_STATE_REASON = "fabric_AEthLanEp_operStateReason"
    SORT_PROP_FABRIC_AETH_LAN_EP_PEER_AGGR_PORT_ID = "fabric_AEthLanEp_peerAggrPortId"
    SORT_PROP_FABRIC_AETH_LAN_EP_PEER_CHASSIS_ID = "fabric_AEthLanEp_peerChassisId"
    SORT_PROP_FABRIC_AETH_LAN_EP_PEER_DN = "fabric_AEthLanEp_peerDn"
    SORT_PROP_FABRIC_AETH_LAN_EP_PEER_PORT_ID = "fabric_AEthLanEp_peerPortId"
    SORT_PROP_FABRIC_AETH_LAN_EP_PEER_SLOT_ID = "fabric_AEthLanEp_peerSlotId"
    SORT_PROP_FABRIC_AETH_LAN_EP_PORT_ID = "fabric_AEthLanEp_portId"
    SORT_PROP_FABRIC_AETH_LAN_EP_SLOT_ID = "fabric_AEthLanEp_slotId"
    SORT_PROP_FABRIC_AETH_LAN_EP_SWITCH_ID = "fabric_AEthLanEp_switchId"
    SORT_PROP_FABRIC_AETH_LAN_EP_TRANSPORT = "fabric_AEthLanEp_transport"
    SORT_PROP_FABRIC_AETH_LAN_EP_TYPE = "fabric_AEthLanEp_type"
    SORT_PROP_FABRIC_AETH_LAN_EP_USR_LBL = "fabric_AEthLanEp_usrLbl"
    SORT_PROP_FABRIC_AETH_LAN_EP_WARNINGS = "fabric_AEthLanEp_warnings"
    SORT_PROP_FABRIC_AFC_ESTC_EP_ADMIN_STATE = "fabric_AFcEstcEp_adminState"
    SORT_PROP_FABRIC_AFC_ESTC_EP_AGGR_PORT_ID = "fabric_AFcEstcEp_aggrPortId"
    SORT_PROP_FABRIC_AFC_ESTC_EP_AUTO_NEGOTIATE = "fabric_AFcEstcEp_autoNegotiate"
    SORT_PROP_FABRIC_AFC_ESTC_EP_CHASSIS_ID = "fabric_AFcEstcEp_chassisId"
    SORT_PROP_FABRIC_AFC_ESTC_EP_CONFIG_STATE = "fabric_AFcEstcEp_configState"
    SORT_PROP_FABRIC_AFC_ESTC_EP_EP_DN = "fabric_AFcEstcEp_epDn"
    SORT_PROP_FABRIC_AFC_ESTC_EP_FLT_AGGR = "fabric_AFcEstcEp_fltAggr"
    SORT_PROP_FABRIC_AFC_ESTC_EP_IF_ROLE = "fabric_AFcEstcEp_ifRole"
    SORT_PROP_FABRIC_AFC_ESTC_EP_IF_TYPE = "fabric_AFcEstcEp_ifType"
    SORT_PROP_FABRIC_AFC_ESTC_EP_LIC_GP = "fabric_AFcEstcEp_licGP"
    SORT_PROP_FABRIC_AFC_ESTC_EP_LIC_STATE = "fabric_AFcEstcEp_licState"
    SORT_PROP_FABRIC_AFC_ESTC_EP_LOCALE = "fabric_AFcEstcEp_locale"
    SORT_PROP_FABRIC_AFC_ESTC_EP_NAME = "fabric_AFcEstcEp_name"
    SORT_PROP_FABRIC_AFC_ESTC_EP_OPER_STATE = "fabric_AFcEstcEp_operState"
    SORT_PROP_FABRIC_AFC_ESTC_EP_OPER_STATE_REASON = "fabric_AFcEstcEp_operStateReason"
    SORT_PROP_FABRIC_AFC_ESTC_EP_PEER_AGGR_PORT_ID = "fabric_AFcEstcEp_peerAggrPortId"
    SORT_PROP_FABRIC_AFC_ESTC_EP_PEER_CHASSIS_ID = "fabric_AFcEstcEp_peerChassisId"
    SORT_PROP_FABRIC_AFC_ESTC_EP_PEER_DN = "fabric_AFcEstcEp_peerDn"
    SORT_PROP_FABRIC_AFC_ESTC_EP_PEER_PORT_ID = "fabric_AFcEstcEp_peerPortId"
    SORT_PROP_FABRIC_AFC_ESTC_EP_PEER_SLOT_ID = "fabric_AFcEstcEp_peerSlotId"
    SORT_PROP_FABRIC_AFC_ESTC_EP_PORT_ID = "fabric_AFcEstcEp_portId"
    SORT_PROP_FABRIC_AFC_ESTC_EP_SLOT_ID = "fabric_AFcEstcEp_slotId"
    SORT_PROP_FABRIC_AFC_ESTC_EP_SWITCH_ID = "fabric_AFcEstcEp_switchId"
    SORT_PROP_FABRIC_AFC_ESTC_EP_TRANSPORT = "fabric_AFcEstcEp_transport"
    SORT_PROP_FABRIC_AFC_ESTC_EP_TYPE = "fabric_AFcEstcEp_type"
    SORT_PROP_FABRIC_AFC_ESTC_EP_USR_LBL = "fabric_AFcEstcEp_usrLbl"
    SORT_PROP_FABRIC_AFC_ESTC_EP_WARNINGS = "fabric_AFcEstcEp_warnings"
    SORT_PROP_FABRIC_AFC_SAN_EP_ADMIN_STATE = "fabric_AFcSanEp_adminState"
    SORT_PROP_FABRIC_AFC_SAN_EP_AGGR_PORT_ID = "fabric_AFcSanEp_aggrPortId"
    SORT_PROP_FABRIC_AFC_SAN_EP_AUTO_NEGOTIATE = "fabric_AFcSanEp_autoNegotiate"
    SORT_PROP_FABRIC_AFC_SAN_EP_CHASSIS_ID = "fabric_AFcSanEp_chassisId"
    SORT_PROP_FABRIC_AFC_SAN_EP_EP_DN = "fabric_AFcSanEp_epDn"
    SORT_PROP_FABRIC_AFC_SAN_EP_FLT_AGGR = "fabric_AFcSanEp_fltAggr"
    SORT_PROP_FABRIC_AFC_SAN_EP_IF_ROLE = "fabric_AFcSanEp_ifRole"
    SORT_PROP_FABRIC_AFC_SAN_EP_IF_TYPE = "fabric_AFcSanEp_ifType"
    SORT_PROP_FABRIC_AFC_SAN_EP_LIC_GP = "fabric_AFcSanEp_licGP"
    SORT_PROP_FABRIC_AFC_SAN_EP_LIC_STATE = "fabric_AFcSanEp_licState"
    SORT_PROP_FABRIC_AFC_SAN_EP_LOCALE = "fabric_AFcSanEp_locale"
    SORT_PROP_FABRIC_AFC_SAN_EP_NAME = "fabric_AFcSanEp_name"
    SORT_PROP_FABRIC_AFC_SAN_EP_OPER_STATE = "fabric_AFcSanEp_operState"
    SORT_PROP_FABRIC_AFC_SAN_EP_OPER_STATE_REASON = "fabric_AFcSanEp_operStateReason"
    SORT_PROP_FABRIC_AFC_SAN_EP_PEER_AGGR_PORT_ID = "fabric_AFcSanEp_peerAggrPortId"
    SORT_PROP_FABRIC_AFC_SAN_EP_PEER_CHASSIS_ID = "fabric_AFcSanEp_peerChassisId"
    SORT_PROP_FABRIC_AFC_SAN_EP_PEER_DN = "fabric_AFcSanEp_peerDn"
    SORT_PROP_FABRIC_AFC_SAN_EP_PEER_PORT_ID = "fabric_AFcSanEp_peerPortId"
    SORT_PROP_FABRIC_AFC_SAN_EP_PEER_SLOT_ID = "fabric_AFcSanEp_peerSlotId"
    SORT_PROP_FABRIC_AFC_SAN_EP_PORT_ID = "fabric_AFcSanEp_portId"
    SORT_PROP_FABRIC_AFC_SAN_EP_SLOT_ID = "fabric_AFcSanEp_slotId"
    SORT_PROP_FABRIC_AFC_SAN_EP_SWITCH_ID = "fabric_AFcSanEp_switchId"
    SORT_PROP_FABRIC_AFC_SAN_EP_TRANSPORT = "fabric_AFcSanEp_transport"
    SORT_PROP_FABRIC_AFC_SAN_EP_TYPE = "fabric_AFcSanEp_type"
    SORT_PROP_FABRIC_AFC_SAN_EP_USR_LBL = "fabric_AFcSanEp_usrLbl"
    SORT_PROP_FABRIC_AFC_SAN_EP_WARNINGS = "fabric_AFcSanEp_warnings"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_ADMIN_STATE = "fabric_AFcoeEstcEp_adminState"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_AGGR_PORT_ID = "fabric_AFcoeEstcEp_aggrPortId"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_AUTO_NEGOTIATE = "fabric_AFcoeEstcEp_autoNegotiate"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_CHASSIS_ID = "fabric_AFcoeEstcEp_chassisId"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_CONFIG_STATE = "fabric_AFcoeEstcEp_configState"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_EP_DN = "fabric_AFcoeEstcEp_epDn"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_FLT_AGGR = "fabric_AFcoeEstcEp_fltAggr"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_IF_ROLE = "fabric_AFcoeEstcEp_ifRole"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_IF_TYPE = "fabric_AFcoeEstcEp_ifType"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_LIC_GP = "fabric_AFcoeEstcEp_licGP"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_LIC_STATE = "fabric_AFcoeEstcEp_licState"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_LOCALE = "fabric_AFcoeEstcEp_locale"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_NAME = "fabric_AFcoeEstcEp_name"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_OPER_STATE = "fabric_AFcoeEstcEp_operState"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_OPER_STATE_REASON = "fabric_AFcoeEstcEp_operStateReason"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_PEER_AGGR_PORT_ID = "fabric_AFcoeEstcEp_peerAggrPortId"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_PEER_CHASSIS_ID = "fabric_AFcoeEstcEp_peerChassisId"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_PEER_DN = "fabric_AFcoeEstcEp_peerDn"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_PEER_PORT_ID = "fabric_AFcoeEstcEp_peerPortId"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_PEER_SLOT_ID = "fabric_AFcoeEstcEp_peerSlotId"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_PORT_ID = "fabric_AFcoeEstcEp_portId"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_SLOT_ID = "fabric_AFcoeEstcEp_slotId"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_SWITCH_ID = "fabric_AFcoeEstcEp_switchId"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_TRANSPORT = "fabric_AFcoeEstcEp_transport"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_TYPE = "fabric_AFcoeEstcEp_type"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_USR_LBL = "fabric_AFcoeEstcEp_usrLbl"
    SORT_PROP_FABRIC_AFCOE_ESTC_EP_WARNINGS = "fabric_AFcoeEstcEp_warnings"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_ADMIN_STATE = "fabric_AFcoeSanEp_adminState"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_AGGR_PORT_ID = "fabric_AFcoeSanEp_aggrPortId"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_AUTO_NEGOTIATE = "fabric_AFcoeSanEp_autoNegotiate"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_CHASSIS_ID = "fabric_AFcoeSanEp_chassisId"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_EP_DN = "fabric_AFcoeSanEp_epDn"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_FLT_AGGR = "fabric_AFcoeSanEp_fltAggr"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_IF_ROLE = "fabric_AFcoeSanEp_ifRole"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_IF_TYPE = "fabric_AFcoeSanEp_ifType"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_LIC_GP = "fabric_AFcoeSanEp_licGP"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_LIC_STATE = "fabric_AFcoeSanEp_licState"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_LOCALE = "fabric_AFcoeSanEp_locale"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_NAME = "fabric_AFcoeSanEp_name"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_OPER_STATE = "fabric_AFcoeSanEp_operState"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_OPER_STATE_REASON = "fabric_AFcoeSanEp_operStateReason"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_PEER_AGGR_PORT_ID = "fabric_AFcoeSanEp_peerAggrPortId"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_PEER_CHASSIS_ID = "fabric_AFcoeSanEp_peerChassisId"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_PEER_DN = "fabric_AFcoeSanEp_peerDn"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_PEER_PORT_ID = "fabric_AFcoeSanEp_peerPortId"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_PEER_SLOT_ID = "fabric_AFcoeSanEp_peerSlotId"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_PORT_ID = "fabric_AFcoeSanEp_portId"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_SLOT_ID = "fabric_AFcoeSanEp_slotId"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_SWITCH_ID = "fabric_AFcoeSanEp_switchId"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_TRANSPORT = "fabric_AFcoeSanEp_transport"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_TYPE = "fabric_AFcoeSanEp_type"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_USR_LBL = "fabric_AFcoeSanEp_usrLbl"
    SORT_PROP_FABRIC_AFCOE_SAN_EP_WARNINGS = "fabric_AFcoeSanEp_warnings"
    SORT_PROP_FABRIC_AGROUP_REQ_CONFIG_ISSUES = "fabric_AGroupReq_configIssues"
    SORT_PROP_FABRIC_AGROUP_REQ_NAME = "fabric_AGroupReq_name"
    SORT_PROP_FABRIC_ANET_GROUP_REF_NAME = "fabric_ANetGroupRef_name"
    SORT_PROP_FABRIC_ANET_GROUP_REF_OPER_NET_GROUP_NAME = "fabric_ANetGroupRef_operNetGroupName"
    SORT_PROP_FABRIC_ANET_GROUP_REF_OWNER = "fabric_ANetGroupRef_owner"
    SORT_PROP_FABRIC_ANET_GROUP_ASSIGNED = "fabric_ANetGroup_assigned"
    SORT_PROP_FABRIC_ANET_GROUP_DESCR = "fabric_ANetGroup_descr"
    SORT_PROP_FABRIC_ANET_GROUP_FLT_AGGR = "fabric_ANetGroup_fltAggr"
    SORT_PROP_FABRIC_ANET_GROUP_INT_ID = "fabric_ANetGroup_intId"
    SORT_PROP_FABRIC_ANET_GROUP_NAME = "fabric_ANetGroup_name"
    SORT_PROP_FABRIC_ANET_GROUP_POLICY_LEVEL = "fabric_ANetGroup_policyLevel"
    SORT_PROP_FABRIC_ANET_GROUP_POLICY_OWNER = "fabric_ANetGroup_policyOwner"
    SORT_PROP_FABRIC_ANET_GROUP_POOL_TYPE = "fabric_ANetGroup_poolType"
    SORT_PROP_FABRIC_ANET_GROUP_SIZE = "fabric_ANetGroup_size"
    SORT_PROP_FABRIC_ASAN_GROUP_ASSIGNED = "fabric_ASanGroup_assigned"
    SORT_PROP_FABRIC_ASAN_GROUP_DESCR = "fabric_ASanGroup_descr"
    SORT_PROP_FABRIC_ASAN_GROUP_FLT_AGGR = "fabric_ASanGroup_fltAggr"
    SORT_PROP_FABRIC_ASAN_GROUP_INT_ID = "fabric_ASanGroup_intId"
    SORT_PROP_FABRIC_ASAN_GROUP_NAME = "fabric_ASanGroup_name"
    SORT_PROP_FABRIC_ASAN_GROUP_POLICY_LEVEL = "fabric_ASanGroup_policyLevel"
    SORT_PROP_FABRIC_ASAN_GROUP_POLICY_OWNER = "fabric_ASanGroup_policyOwner"
    SORT_PROP_FABRIC_ASAN_GROUP_POOL_TYPE = "fabric_ASanGroup_poolType"
    SORT_PROP_FABRIC_ASAN_GROUP_SIZE = "fabric_ASanGroup_size"
    SORT_PROP_FABRIC_AVLAN_ASSOC_PRIMARY_VLAN_STATE = "fabric_AVlan_assocPrimaryVlanState"
    SORT_PROP_FABRIC_AVLAN_ASSOC_PRIMARY_VLAN_SWITCH_ID = "fabric_AVlan_assocPrimaryVlanSwitchId"
    SORT_PROP_FABRIC_AVLAN_EP_DN = "fabric_AVlan_epDn"
    SORT_PROP_FABRIC_AVLAN_ID = "fabric_AVlan_id"
    SORT_PROP_FABRIC_AVLAN_IF_ROLE = "fabric_AVlan_ifRole"
    SORT_PROP_FABRIC_AVLAN_IF_TYPE = "fabric_AVlan_ifType"
    SORT_PROP_FABRIC_AVLAN_LOCALE = "fabric_AVlan_locale"
    SORT_PROP_FABRIC_AVLAN_NAME = "fabric_AVlan_name"
    SORT_PROP_FABRIC_AVLAN_OPER_STATE = "fabric_AVlan_operState"
    SORT_PROP_FABRIC_AVLAN_OVERLAP_STATE_FOR_A = "fabric_AVlan_overlapStateForA"
    SORT_PROP_FABRIC_AVLAN_OVERLAP_STATE_FOR_B = "fabric_AVlan_overlapStateForB"
    SORT_PROP_FABRIC_AVLAN_PEER_DN = "fabric_AVlan_peerDn"
    SORT_PROP_FABRIC_AVLAN_POLICY_OWNER = "fabric_AVlan_policyOwner"
    SORT_PROP_FABRIC_AVLAN_PUB_NW_DN = "fabric_AVlan_pubNwDn"
    SORT_PROP_FABRIC_AVLAN_PUB_NW_ID = "fabric_AVlan_pubNwId"
    SORT_PROP_FABRIC_AVLAN_PUB_NW_NAME = "fabric_AVlan_pubNwName"
    SORT_PROP_FABRIC_AVLAN_SHARING = "fabric_AVlan_sharing"
    SORT_PROP_FABRIC_AVLAN_SWITCH_ID = "fabric_AVlan_switchId"
    SORT_PROP_FABRIC_AVLAN_TRANSPORT = "fabric_AVlan_transport"
    SORT_PROP_FABRIC_AVLAN_TYPE = "fabric_AVlan_type"
    SORT_PROP_FABRIC_AVSAN_EP_DN = "fabric_AVsan_epDn"
    SORT_PROP_FABRIC_AVSAN_FCOE_VLAN = "fabric_AVsan_fcoeVlan"
    SORT_PROP_FABRIC_AVSAN_ID = "fabric_AVsan_id"
    SORT_PROP_FABRIC_AVSAN_IF_ROLE = "fabric_AVsan_ifRole"
    SORT_PROP_FABRIC_AVSAN_IF_TYPE = "fabric_AVsan_ifType"
    SORT_PROP_FABRIC_AVSAN_LOCALE = "fabric_AVsan_locale"
    SORT_PROP_FABRIC_AVSAN_NAME = "fabric_AVsan_name"
    SORT_PROP_FABRIC_AVSAN_OPER_STATE = "fabric_AVsan_operState"
    SORT_PROP_FABRIC_AVSAN_PEER_DN = "fabric_AVsan_peerDn"
    SORT_PROP_FABRIC_AVSAN_POLICY_OWNER = "fabric_AVsan_policyOwner"
    SORT_PROP_FABRIC_AVSAN_SWITCH_ID = "fabric_AVsan_switchId"
    SORT_PROP_FABRIC_AVSAN_TRANSPORT = "fabric_AVsan_transport"
    SORT_PROP_FABRIC_AVSAN_TYPE = "fabric_AVsan_type"
    SORT_PROP_FABRIC_AVSAN_ZONING_STATE = "fabric_AVsan_zoningState"
    SORT_PROP_FABRIC_BASE_NET_GROUP_ASSIGNED = "fabric_BaseNetGroup_assigned"
    SORT_PROP_FABRIC_BASE_NET_GROUP_DESCR = "fabric_BaseNetGroup_descr"
    SORT_PROP_FABRIC_BASE_NET_GROUP_FLT_AGGR = "fabric_BaseNetGroup_fltAggr"
    SORT_PROP_FABRIC_BASE_NET_GROUP_INT_ID = "fabric_BaseNetGroup_intId"
    SORT_PROP_FABRIC_BASE_NET_GROUP_NAME = "fabric_BaseNetGroup_name"
    SORT_PROP_FABRIC_BASE_NET_GROUP_POLICY_LEVEL = "fabric_BaseNetGroup_policyLevel"
    SORT_PROP_FABRIC_BASE_NET_GROUP_POLICY_OWNER = "fabric_BaseNetGroup_policyOwner"
    SORT_PROP_FABRIC_BASE_NET_GROUP_POOL_TYPE = "fabric_BaseNetGroup_poolType"
    SORT_PROP_FABRIC_BASE_NET_GROUP_SIZE = "fabric_BaseNetGroup_size"
    SORT_PROP_FABRIC_BASE_PH_EP_ADMIN_STATE = "fabric_BasePhEp_adminState"
    SORT_PROP_FABRIC_BASE_PH_EP_AGGR_PORT_ID = "fabric_BasePhEp_aggrPortId"
    SORT_PROP_FABRIC_BASE_PH_EP_AUTO_NEGOTIATE = "fabric_BasePhEp_autoNegotiate"
    SORT_PROP_FABRIC_BASE_PH_EP_CHASSIS_ID = "fabric_BasePhEp_chassisId"
    SORT_PROP_FABRIC_BASE_PH_EP_EP_DN = "fabric_BasePhEp_epDn"
    SORT_PROP_FABRIC_BASE_PH_EP_FLT_AGGR = "fabric_BasePhEp_fltAggr"
    SORT_PROP_FABRIC_BASE_PH_EP_IF_ROLE = "fabric_BasePhEp_ifRole"
    SORT_PROP_FABRIC_BASE_PH_EP_IF_TYPE = "fabric_BasePhEp_ifType"
    SORT_PROP_FABRIC_BASE_PH_EP_LIC_GP = "fabric_BasePhEp_licGP"
    SORT_PROP_FABRIC_BASE_PH_EP_LIC_STATE = "fabric_BasePhEp_licState"
    SORT_PROP_FABRIC_BASE_PH_EP_LOCALE = "fabric_BasePhEp_locale"
    SORT_PROP_FABRIC_BASE_PH_EP_MODEL = "fabric_BasePhEp_model"
    SORT_PROP_FABRIC_BASE_PH_EP_NAME = "fabric_BasePhEp_name"
    SORT_PROP_FABRIC_BASE_PH_EP_OPER_STATE = "fabric_BasePhEp_operState"
    SORT_PROP_FABRIC_BASE_PH_EP_OPER_STATE_REASON = "fabric_BasePhEp_operStateReason"
    SORT_PROP_FABRIC_BASE_PH_EP_PEER_AGGR_PORT_ID = "fabric_BasePhEp_peerAggrPortId"
    SORT_PROP_FABRIC_BASE_PH_EP_PEER_CHASSIS_ID = "fabric_BasePhEp_peerChassisId"
    SORT_PROP_FABRIC_BASE_PH_EP_PEER_DN = "fabric_BasePhEp_peerDn"
    SORT_PROP_FABRIC_BASE_PH_EP_PEER_PORT_ID = "fabric_BasePhEp_peerPortId"
    SORT_PROP_FABRIC_BASE_PH_EP_PEER_SLOT_ID = "fabric_BasePhEp_peerSlotId"
    SORT_PROP_FABRIC_BASE_PH_EP_PORT_ID = "fabric_BasePhEp_portId"
    SORT_PROP_FABRIC_BASE_PH_EP_REVISION = "fabric_BasePhEp_revision"
    SORT_PROP_FABRIC_BASE_PH_EP_SERIAL = "fabric_BasePhEp_serial"
    SORT_PROP_FABRIC_BASE_PH_EP_SLOT_ID = "fabric_BasePhEp_slotId"
    SORT_PROP_FABRIC_BASE_PH_EP_SWITCH_ID = "fabric_BasePhEp_switchId"
    SORT_PROP_FABRIC_BASE_PH_EP_TRANSPORT = "fabric_BasePhEp_transport"
    SORT_PROP_FABRIC_BASE_PH_EP_TYPE = "fabric_BasePhEp_type"
    SORT_PROP_FABRIC_BASE_PH_EP_USR_LBL = "fabric_BasePhEp_usrLbl"
    SORT_PROP_FABRIC_BASE_PH_EP_VENDOR = "fabric_BasePhEp_vendor"
    SORT_PROP_FABRIC_BASE_SLOT_EP_ADMIN_STATE = "fabric_BaseSlotEp_adminState"
    SORT_PROP_FABRIC_BASE_SLOT_EP_AGGR_PORT_ID = "fabric_BaseSlotEp_aggrPortId"
    SORT_PROP_FABRIC_BASE_SLOT_EP_AUTO_NEGOTIATE = "fabric_BaseSlotEp_autoNegotiate"
    SORT_PROP_FABRIC_BASE_SLOT_EP_CHASSIS_ID = "fabric_BaseSlotEp_chassisId"
    SORT_PROP_FABRIC_BASE_SLOT_EP_EP_DN = "fabric_BaseSlotEp_epDn"
    SORT_PROP_FABRIC_BASE_SLOT_EP_FLT_AGGR = "fabric_BaseSlotEp_fltAggr"
    SORT_PROP_FABRIC_BASE_SLOT_EP_IF_ROLE = "fabric_BaseSlotEp_ifRole"
    SORT_PROP_FABRIC_BASE_SLOT_EP_IF_TYPE = "fabric_BaseSlotEp_ifType"
    SORT_PROP_FABRIC_BASE_SLOT_EP_LIC_GP = "fabric_BaseSlotEp_licGP"
    SORT_PROP_FABRIC_BASE_SLOT_EP_LIC_STATE = "fabric_BaseSlotEp_licState"
    SORT_PROP_FABRIC_BASE_SLOT_EP_LOCALE = "fabric_BaseSlotEp_locale"
    SORT_PROP_FABRIC_BASE_SLOT_EP_MODEL = "fabric_BaseSlotEp_model"
    SORT_PROP_FABRIC_BASE_SLOT_EP_NAME = "fabric_BaseSlotEp_name"
    SORT_PROP_FABRIC_BASE_SLOT_EP_OPER_STATE = "fabric_BaseSlotEp_operState"
    SORT_PROP_FABRIC_BASE_SLOT_EP_OPER_STATE_REASON = "fabric_BaseSlotEp_operStateReason"
    SORT_PROP_FABRIC_BASE_SLOT_EP_PEER_AGGR_PORT_ID = "fabric_BaseSlotEp_peerAggrPortId"
    SORT_PROP_FABRIC_BASE_SLOT_EP_PEER_CHASSIS_ID = "fabric_BaseSlotEp_peerChassisId"
    SORT_PROP_FABRIC_BASE_SLOT_EP_PEER_DN = "fabric_BaseSlotEp_peerDn"
    SORT_PROP_FABRIC_BASE_SLOT_EP_PEER_PORT_ID = "fabric_BaseSlotEp_peerPortId"
    SORT_PROP_FABRIC_BASE_SLOT_EP_PEER_SLOT_ID = "fabric_BaseSlotEp_peerSlotId"
    SORT_PROP_FABRIC_BASE_SLOT_EP_PORT_ID = "fabric_BaseSlotEp_portId"
    SORT_PROP_FABRIC_BASE_SLOT_EP_REVISION = "fabric_BaseSlotEp_revision"
    SORT_PROP_FABRIC_BASE_SLOT_EP_SERIAL = "fabric_BaseSlotEp_serial"
    SORT_PROP_FABRIC_BASE_SLOT_EP_SLOT_ID = "fabric_BaseSlotEp_slotId"
    SORT_PROP_FABRIC_BASE_SLOT_EP_SWITCH_ID = "fabric_BaseSlotEp_switchId"
    SORT_PROP_FABRIC_BASE_SLOT_EP_TRANSPORT = "fabric_BaseSlotEp_transport"
    SORT_PROP_FABRIC_BASE_SLOT_EP_TYPE = "fabric_BaseSlotEp_type"
    SORT_PROP_FABRIC_BASE_SLOT_EP_USR_LBL = "fabric_BaseSlotEp_usrLbl"
    SORT_PROP_FABRIC_BASE_SLOT_EP_VENDOR = "fabric_BaseSlotEp_vendor"
    SORT_PROP_FABRIC_BREAKOUT_OPERATION_BREAKOUT_TYPE = "fabric_BreakoutOperation_breakoutType"
    SORT_PROP_FABRIC_BREAKOUT_OPERATION_LAST_MODIFIED = "fabric_BreakoutOperation_lastModified"
    SORT_PROP_FABRIC_BREAKOUT_OPERATION_PORT_ID = "fabric_BreakoutOperation_portId"
    SORT_PROP_FABRIC_BREAKOUT_OPERATION_REMOTE_ERROR_CODE = "fabric_BreakoutOperation_remoteErrorCode"
    SORT_PROP_FABRIC_BREAKOUT_OPERATION_REMOTE_ERROR_DESCR = "fabric_BreakoutOperation_remoteErrorDescr"
    SORT_PROP_FABRIC_BREAKOUT_OPERATION_SLOT_ID = "fabric_BreakoutOperation_slotId"
    SORT_PROP_FABRIC_BREAKOUT_OPERATION_TRIGGER_STATUS = "fabric_BreakoutOperation_triggerStatus"
    SORT_PROP_FABRIC_BREAKOUT_BREAKOUT_TYPE = "fabric_Breakout_breakoutType"
    SORT_PROP_FABRIC_BREAKOUT_PORT_ID = "fabric_Breakout_portId"
    SORT_PROP_FABRIC_BREAKOUT_SLOT_ID = "fabric_Breakout_slotId"
    SORT_PROP_FABRIC_CIO_EP_ADMIN_STATE = "fabric_CIoEp_adminState"
    SORT_PROP_FABRIC_CIO_EP_DESCR = "fabric_CIoEp_descr"
    SORT_PROP_FABRIC_CIO_EP_EP_DN = "fabric_CIoEp_epDn"
    SORT_PROP_FABRIC_CIO_EP_IF_ROLE = "fabric_CIoEp_ifRole"
    SORT_PROP_FABRIC_CIO_EP_IF_TYPE = "fabric_CIoEp_ifType"
    SORT_PROP_FABRIC_CIO_EP_LOCALE = "fabric_CIoEp_locale"
    SORT_PROP_FABRIC_CIO_EP_NAME = "fabric_CIoEp_name"
    SORT_PROP_FABRIC_CIO_EP_PEER_DN = "fabric_CIoEp_peerDn"
    SORT_PROP_FABRIC_CIO_EP_PORT_ID = "fabric_CIoEp_portId"
    SORT_PROP_FABRIC_CIO_EP_SWITCH_ID = "fabric_CIoEp_switchId"
    SORT_PROP_FABRIC_CIO_EP_TRANSPORT = "fabric_CIoEp_transport"
    SORT_PROP_FABRIC_CIO_EP_TYPE = "fabric_CIoEp_type"
    SORT_PROP_FABRIC_CABLING_SW_ID = "fabric_CablingSw_id"
    SORT_PROP_FABRIC_CABLING_SW_LOCALE = "fabric_CablingSw_locale"
    SORT_PROP_FABRIC_CABLING_SW_NAME = "fabric_CablingSw_name"
    SORT_PROP_FABRIC_CABLING_SW_TRANSPORT = "fabric_CablingSw_transport"
    SORT_PROP_FABRIC_CABLING_SW_TYPE = "fabric_CablingSw_type"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_OPERATION_ADMIN_STATE = "fabric_CartridgeSlotEpOperation_adminState"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_OPERATION_LAST_MODIFIED = "fabric_CartridgeSlotEpOperation_lastModified"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_OPERATION_MODEL = "fabric_CartridgeSlotEpOperation_model"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_OPERATION_REMOTE_ERROR_CODE = "fabric_CartridgeSlotEpOperation_remoteErrorCode"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_OPERATION_REMOTE_ERROR_DESCR = "fabric_CartridgeSlotEpOperation_remoteErrorDescr"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_OPERATION_REVISION = "fabric_CartridgeSlotEpOperation_revision"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_OPERATION_SERIAL = "fabric_CartridgeSlotEpOperation_serial"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_OPERATION_TRIGGER_STATUS = "fabric_CartridgeSlotEpOperation_triggerStatus"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_OPERATION_VENDOR = "fabric_CartridgeSlotEpOperation_vendor"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_ADMIN_STATE = "fabric_CartridgeSlotEp_adminState"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_AGGR_PORT_ID = "fabric_CartridgeSlotEp_aggrPortId"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_AUTO_NEGOTIATE = "fabric_CartridgeSlotEp_autoNegotiate"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_CHASSIS_ID = "fabric_CartridgeSlotEp_chassisId"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_CONN_PATH = "fabric_CartridgeSlotEp_connPath"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_CONN_STATUS = "fabric_CartridgeSlotEp_connStatus"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_DISCOVERY_STATUS = "fabric_CartridgeSlotEp_discoveryStatus"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_EP_DN = "fabric_CartridgeSlotEp_epDn"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_FLT_AGGR = "fabric_CartridgeSlotEp_fltAggr"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_IF_ROLE = "fabric_CartridgeSlotEp_ifRole"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_IF_TYPE = "fabric_CartridgeSlotEp_ifType"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_LIC_GP = "fabric_CartridgeSlotEp_licGP"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_LIC_STATE = "fabric_CartridgeSlotEp_licState"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_LOCALE = "fabric_CartridgeSlotEp_locale"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_MANAGING_INST = "fabric_CartridgeSlotEp_managingInst"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_MODEL = "fabric_CartridgeSlotEp_model"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_NAME = "fabric_CartridgeSlotEp_name"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_OPER_STATE = "fabric_CartridgeSlotEp_operState"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_OPER_STATE_REASON = "fabric_CartridgeSlotEp_operStateReason"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_PEER_AGGR_PORT_ID = "fabric_CartridgeSlotEp_peerAggrPortId"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_PEER_CHASSIS_ID = "fabric_CartridgeSlotEp_peerChassisId"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_PEER_DN = "fabric_CartridgeSlotEp_peerDn"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_PEER_PORT_ID = "fabric_CartridgeSlotEp_peerPortId"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_PEER_SLOT_ID = "fabric_CartridgeSlotEp_peerSlotId"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_PORT_ID = "fabric_CartridgeSlotEp_portId"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_PRESENCE = "fabric_CartridgeSlotEp_presence"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_REVISION = "fabric_CartridgeSlotEp_revision"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_SERIAL = "fabric_CartridgeSlotEp_serial"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_SLOT_ADMIN_STATE = "fabric_CartridgeSlotEp_slotAdminState"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_SLOT_ID = "fabric_CartridgeSlotEp_slotId"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_SWITCH_ID = "fabric_CartridgeSlotEp_switchId"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_TRANSPORT = "fabric_CartridgeSlotEp_transport"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_TYPE = "fabric_CartridgeSlotEp_type"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_USR_LBL = "fabric_CartridgeSlotEp_usrLbl"
    SORT_PROP_FABRIC_CARTRIDGE_SLOT_EP_VENDOR = "fabric_CartridgeSlotEp_vendor"
    SORT_PROP_FABRIC_CDP_LINK_POLICY_ADMIN_STATE = "fabric_CdpLinkPolicy_adminState"
    SORT_PROP_FABRIC_CDP_LINK_POLICY_DESCR = "fabric_CdpLinkPolicy_descr"
    SORT_PROP_FABRIC_CDP_LINK_POLICY_INT_ID = "fabric_CdpLinkPolicy_intId"
    SORT_PROP_FABRIC_CDP_LINK_POLICY_NAME = "fabric_CdpLinkPolicy_name"
    SORT_PROP_FABRIC_CDP_LINK_POLICY_POLICY_LEVEL = "fabric_CdpLinkPolicy_policyLevel"
    SORT_PROP_FABRIC_CDP_LINK_POLICY_POLICY_OWNER = "fabric_CdpLinkPolicy_policyOwner"
    SORT_PROP_FABRIC_CDP_LINK_POLICY_PROTOCOL = "fabric_CdpLinkPolicy_protocol"
    SORT_PROP_FABRIC_CDP_LINK_POLICY_TYPE = "fabric_CdpLinkPolicy_type"
    SORT_PROP_FABRIC_CHANGED_OBJECT_REF_CENTRAL_RANGE_CHECK_CONFIG_STATE = "fabric_ChangedObjectRef_centralRangeCheckConfigState"
    SORT_PROP_FABRIC_CHANGED_OBJECT_REF_CENTRALE_VNET_EP_DN = "fabric_ChangedObjectRef_centraleVnetEpDn"
    SORT_PROP_FABRIC_CHANGED_OBJECT_REF_CONFIG_RANGE_MESSAGE = "fabric_ChangedObjectRef_configRangeMessage"
    SORT_PROP_FABRIC_CHANGED_OBJECT_REF_ID = "fabric_ChangedObjectRef_id"
    SORT_PROP_FABRIC_CHANGED_OBJECT_REF_OLD_CENTRALE_VNET_EP_DN = "fabric_ChangedObjectRef_oldCentraleVnetEpDn"
    SORT_PROP_FABRIC_CHANGED_OBJECT_REF_REF_OBJ_STATUS = "fabric_ChangedObjectRef_refObjStatus"
    SORT_PROP_FABRIC_CHANGED_OBJECT_REF_UCSM_CONFIG_MESSAGE = "fabric_ChangedObjectRef_ucsmConfigMessage"
    SORT_PROP_FABRIC_CHANGED_OBJECT_REF_UCSM_DEPLOYMENT_CONFIG_STATE = "fabric_ChangedObjectRef_ucsmDeploymentConfigState"
    SORT_PROP_FABRIC_CHANGED_OBJECT_REF_UCSM_VNET_EP_DN = "fabric_ChangedObjectRef_ucsmVnetEpDn"
    SORT_PROP_FABRIC_CHASSIS_EP_CHASSIS_DN = "fabric_ChassisEp_chassisDn"
    SORT_PROP_FABRIC_CHASSIS_EP_CHASSIS_ID = "fabric_ChassisEp_chassisId"
    SORT_PROP_FABRIC_CHASSIS_EP_MODEL = "fabric_ChassisEp_model"
    SORT_PROP_FABRIC_CHASSIS_EP_REVISION = "fabric_ChassisEp_revision"
    SORT_PROP_FABRIC_CHASSIS_EP_SERIAL = "fabric_ChassisEp_serial"
    SORT_PROP_FABRIC_CHASSIS_EP_VENDOR = "fabric_ChassisEp_vendor"
    SORT_PROP_FABRIC_COMPUTE_EP_ADMIN_STATE = "fabric_ComputeEp_adminState"
    SORT_PROP_FABRIC_COMPUTE_EP_AGGR_PORT_ID = "fabric_ComputeEp_aggrPortId"
    SORT_PROP_FABRIC_COMPUTE_EP_AUTO_NEGOTIATE = "fabric_ComputeEp_autoNegotiate"
    SORT_PROP_FABRIC_COMPUTE_EP_CHASSIS_ID = "fabric_ComputeEp_chassisId"
    SORT_PROP_FABRIC_COMPUTE_EP_EP_DN = "fabric_ComputeEp_epDn"
    SORT_PROP_FABRIC_COMPUTE_EP_FLT_AGGR = "fabric_ComputeEp_fltAggr"
    SORT_PROP_FABRIC_COMPUTE_EP_IF_ROLE = "fabric_ComputeEp_ifRole"
    SORT_PROP_FABRIC_COMPUTE_EP_IF_TYPE = "fabric_ComputeEp_ifType"
    SORT_PROP_FABRIC_COMPUTE_EP_LIC_GP = "fabric_ComputeEp_licGP"
    SORT_PROP_FABRIC_COMPUTE_EP_LIC_STATE = "fabric_ComputeEp_licState"
    SORT_PROP_FABRIC_COMPUTE_EP_LOCALE = "fabric_ComputeEp_locale"
    SORT_PROP_FABRIC_COMPUTE_EP_NAME = "fabric_ComputeEp_name"
    SORT_PROP_FABRIC_COMPUTE_EP_OPER_STATE = "fabric_ComputeEp_operState"
    SORT_PROP_FABRIC_COMPUTE_EP_OPER_STATE_REASON = "fabric_ComputeEp_operStateReason"
    SORT_PROP_FABRIC_COMPUTE_EP_PEER_AGGR_PORT_ID = "fabric_ComputeEp_peerAggrPortId"
    SORT_PROP_FABRIC_COMPUTE_EP_PEER_CHASSIS_ID = "fabric_ComputeEp_peerChassisId"
    SORT_PROP_FABRIC_COMPUTE_EP_PEER_DN = "fabric_ComputeEp_peerDn"
    SORT_PROP_FABRIC_COMPUTE_EP_PEER_PORT_ID = "fabric_ComputeEp_peerPortId"
    SORT_PROP_FABRIC_COMPUTE_EP_PEER_SLOT_ID = "fabric_ComputeEp_peerSlotId"
    SORT_PROP_FABRIC_COMPUTE_EP_PORT_ID = "fabric_ComputeEp_portId"
    SORT_PROP_FABRIC_COMPUTE_EP_SLOT_ID = "fabric_ComputeEp_slotId"
    SORT_PROP_FABRIC_COMPUTE_EP_SWITCH_ID = "fabric_ComputeEp_switchId"
    SORT_PROP_FABRIC_COMPUTE_EP_TRANSPORT = "fabric_ComputeEp_transport"
    SORT_PROP_FABRIC_COMPUTE_EP_TYPE = "fabric_ComputeEp_type"
    SORT_PROP_FABRIC_COMPUTE_EP_USR_LBL = "fabric_ComputeEp_usrLbl"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_ADMIN_STATE = "fabric_ComputeMSlotEp_adminState"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_AGGR_PORT_ID = "fabric_ComputeMSlotEp_aggrPortId"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_AUTO_NEGOTIATE = "fabric_ComputeMSlotEp_autoNegotiate"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_CHASSIS_ID = "fabric_ComputeMSlotEp_chassisId"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_CONN_PATH = "fabric_ComputeMSlotEp_connPath"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_CONN_STATUS = "fabric_ComputeMSlotEp_connStatus"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_DISCOVERY = "fabric_ComputeMSlotEp_discovery"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_DISCOVERY_STATUS = "fabric_ComputeMSlotEp_discoveryStatus"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_EP_DN = "fabric_ComputeMSlotEp_epDn"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_FLT_AGGR = "fabric_ComputeMSlotEp_fltAggr"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_FRU_IDENT_TRIG_TS = "fabric_ComputeMSlotEp_fruIdentTrigTs"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_IF_ROLE = "fabric_ComputeMSlotEp_ifRole"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_IF_TYPE = "fabric_ComputeMSlotEp_ifType"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_LC_TS = "fabric_ComputeMSlotEp_lcTs"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_LIC_GP = "fabric_ComputeMSlotEp_licGP"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_LIC_STATE = "fabric_ComputeMSlotEp_licState"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_LOCALE = "fabric_ComputeMSlotEp_locale"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_MANAGING_INST = "fabric_ComputeMSlotEp_managingInst"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_MODEL = "fabric_ComputeMSlotEp_model"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_NAME = "fabric_ComputeMSlotEp_name"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_OPER_STATE = "fabric_ComputeMSlotEp_operState"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_OPER_STATE_REASON = "fabric_ComputeMSlotEp_operStateReason"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_PEER_AGGR_PORT_ID = "fabric_ComputeMSlotEp_peerAggrPortId"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_PEER_CHASSIS_ID = "fabric_ComputeMSlotEp_peerChassisId"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_PEER_DN = "fabric_ComputeMSlotEp_peerDn"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_PEER_PORT_ID = "fabric_ComputeMSlotEp_peerPortId"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_PEER_SLOT_ID = "fabric_ComputeMSlotEp_peerSlotId"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_PORT_ID = "fabric_ComputeMSlotEp_portId"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_PRESENCE = "fabric_ComputeMSlotEp_presence"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_REVISION = "fabric_ComputeMSlotEp_revision"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_SERIAL = "fabric_ComputeMSlotEp_serial"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_SERVER_INSTANCE_ID = "fabric_ComputeMSlotEp_serverInstanceId"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_SLOT_ID = "fabric_ComputeMSlotEp_slotId"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_SWITCH_ID = "fabric_ComputeMSlotEp_switchId"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_TRANSPORT = "fabric_ComputeMSlotEp_transport"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_TYPE = "fabric_ComputeMSlotEp_type"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_USR_LBL = "fabric_ComputeMSlotEp_usrLbl"
    SORT_PROP_FABRIC_COMPUTE_MSLOT_EP_VENDOR = "fabric_ComputeMSlotEp_vendor"
    SORT_PROP_FABRIC_COMPUTE_PH_EP_OPERATION_ADMIN_STATE = "fabric_ComputePhEpOperation_adminState"
    SORT_PROP_FABRIC_COMPUTE_PH_EP_OPERATION_LAST_MODIFIED = "fabric_ComputePhEpOperation_lastModified"
    SORT_PROP_FABRIC_COMPUTE_PH_EP_OPERATION_MODEL = "fabric_ComputePhEpOperation_model"
    SORT_PROP_FABRIC_COMPUTE_PH_EP_OPERATION_REMOTE_ERROR_CODE = "fabric_ComputePhEpOperation_remoteErrorCode"
    SORT_PROP_FABRIC_COMPUTE_PH_EP_OPERATION_REMOTE_ERROR_DESCR = "fabric_ComputePhEpOperation_remoteErrorDescr"
    SORT_PROP_FABRIC_COMPUTE_PH_EP_OPERATION_REVISION = "fabric_ComputePhEpOperation_revision"
    SORT_PROP_FABRIC_COMPUTE_PH_EP_OPERATION_SERIAL = "fabric_ComputePhEpOperation_serial"
    SORT_PROP_FABRIC_COMPUTE_PH_EP_OPERATION_TRIGGER_STATUS = "fabric_ComputePhEpOperation_triggerStatus"
    SORT_PROP_FABRIC_COMPUTE_PH_EP_OPERATION_VENDOR = "fabric_ComputePhEpOperation_vendor"
    SORT_PROP_FABRIC_COMPUTE_PH_EP_ADDRESS = "fabric_ComputePhEp_address"
    SORT_PROP_FABRIC_COMPUTE_PH_EP_ADMIN_STATE = "fabric_ComputePhEp_adminState"
    SORT_PROP_FABRIC_COMPUTE_PH_EP_CHASSIS_ID = "fabric_ComputePhEp_chassisId"
    SORT_PROP_FABRIC_COMPUTE_PH_EP_EQ_TYPE = "fabric_ComputePhEp_eqType"
    SORT_PROP_FABRIC_COMPUTE_PH_EP_LC = "fabric_ComputePhEp_lc"
    SORT_PROP_FABRIC_COMPUTE_PH_EP_MODEL = "fabric_ComputePhEp_model"
    SORT_PROP_FABRIC_COMPUTE_PH_EP_NAME = "fabric_ComputePhEp_name"
    SORT_PROP_FABRIC_COMPUTE_PH_EP_REVISION = "fabric_ComputePhEp_revision"
    SORT_PROP_FABRIC_COMPUTE_PH_EP_SERIAL = "fabric_ComputePhEp_serial"
    SORT_PROP_FABRIC_COMPUTE_PH_EP_SLOT_ID = "fabric_ComputePhEp_slotId"
    SORT_PROP_FABRIC_COMPUTE_PH_EP_VENDOR = "fabric_ComputePhEp_vendor"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_OPERATION_ADMIN_STATE = "fabric_ComputeSlotEpOperation_adminState"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_OPERATION_LAST_MODIFIED = "fabric_ComputeSlotEpOperation_lastModified"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_OPERATION_MODEL = "fabric_ComputeSlotEpOperation_model"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_OPERATION_REMOTE_ERROR_CODE = "fabric_ComputeSlotEpOperation_remoteErrorCode"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_OPERATION_REMOTE_ERROR_DESCR = "fabric_ComputeSlotEpOperation_remoteErrorDescr"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_OPERATION_REVISION = "fabric_ComputeSlotEpOperation_revision"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_OPERATION_SERIAL = "fabric_ComputeSlotEpOperation_serial"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_OPERATION_TRIGGER_STATUS = "fabric_ComputeSlotEpOperation_triggerStatus"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_OPERATION_VENDOR = "fabric_ComputeSlotEpOperation_vendor"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_ADMIN_STATE = "fabric_ComputeSlotEp_adminState"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_BOARD_AGGREGATION_ROLE = "fabric_ComputeSlotEp_boardAggregationRole"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_CHASSIS_ID = "fabric_ComputeSlotEp_chassisId"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_CONN_PATH = "fabric_ComputeSlotEp_connPath"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_CONN_STATUS = "fabric_ComputeSlotEp_connStatus"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_DISCOVERY_STATUS = "fabric_ComputeSlotEp_discoveryStatus"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_MANAGING_INST = "fabric_ComputeSlotEp_managingInst"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_MODEL = "fabric_ComputeSlotEp_model"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_PRESENCE = "fabric_ComputeSlotEp_presence"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_REVISION = "fabric_ComputeSlotEp_revision"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_SERIAL = "fabric_ComputeSlotEp_serial"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_SLOT_ID = "fabric_ComputeSlotEp_slotId"
    SORT_PROP_FABRIC_COMPUTE_SLOT_EP_VENDOR = "fabric_ComputeSlotEp_vendor"
    SORT_PROP_FABRIC_CONSUMER_CLIENT_ID = "fabric_Consumer_clientId"
    SORT_PROP_FABRIC_DCE_SRV_ID = "fabric_DceSrv_id"
    SORT_PROP_FABRIC_DCE_SRV_LOCALE = "fabric_DceSrv_locale"
    SORT_PROP_FABRIC_DCE_SRV_NAME = "fabric_DceSrv_name"
    SORT_PROP_FABRIC_DCE_SRV_TRANSPORT = "fabric_DceSrv_transport"
    SORT_PROP_FABRIC_DCE_SRV_TYPE = "fabric_DceSrv_type"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_OPERATION_ADMIN_STATE = "fabric_DceSwSrvEpOperation_adminState"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_OPERATION_EP_DN = "fabric_DceSwSrvEpOperation_epDn"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_OPERATION_LAST_MODIFIED = "fabric_DceSwSrvEpOperation_lastModified"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_OPERATION_PORT_ID = "fabric_DceSwSrvEpOperation_portId"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_OPERATION_REMOTE_ERROR_CODE = "fabric_DceSwSrvEpOperation_remoteErrorCode"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_OPERATION_REMOTE_ERROR_DESCR = "fabric_DceSwSrvEpOperation_remoteErrorDescr"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_OPERATION_SLOT_ID = "fabric_DceSwSrvEpOperation_slotId"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_OPERATION_TRIGGER_STATUS = "fabric_DceSwSrvEpOperation_triggerStatus"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_OPERATION_USR_LBL = "fabric_DceSwSrvEpOperation_usrLbl"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_ADMIN_STATE = "fabric_DceSwSrvEp_adminState"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_AGGR_PORT_ID = "fabric_DceSwSrvEp_aggrPortId"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_AUTO_NEGOTIATE = "fabric_DceSwSrvEp_autoNegotiate"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_CHASSIS_ID = "fabric_DceSwSrvEp_chassisId"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_EP_DN = "fabric_DceSwSrvEp_epDn"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_FLT_AGGR = "fabric_DceSwSrvEp_fltAggr"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_IF_ROLE = "fabric_DceSwSrvEp_ifRole"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_IF_TYPE = "fabric_DceSwSrvEp_ifType"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_LIC_GP = "fabric_DceSwSrvEp_licGP"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_LIC_STATE = "fabric_DceSwSrvEp_licState"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_LOCALE = "fabric_DceSwSrvEp_locale"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_NAME = "fabric_DceSwSrvEp_name"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_OPER_STATE = "fabric_DceSwSrvEp_operState"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_OPER_STATE_REASON = "fabric_DceSwSrvEp_operStateReason"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_PEER_AGGR_PORT_ID = "fabric_DceSwSrvEp_peerAggrPortId"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_PEER_CHASSIS_ID = "fabric_DceSwSrvEp_peerChassisId"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_PEER_DN = "fabric_DceSwSrvEp_peerDn"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_PEER_PORT_ID = "fabric_DceSwSrvEp_peerPortId"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_PEER_SLOT_ID = "fabric_DceSwSrvEp_peerSlotId"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_PORT_ID = "fabric_DceSwSrvEp_portId"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_SLOT_ID = "fabric_DceSwSrvEp_slotId"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_SWITCH_ID = "fabric_DceSwSrvEp_switchId"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_TRANSPORT = "fabric_DceSwSrvEp_transport"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_TYPE = "fabric_DceSwSrvEp_type"
    SORT_PROP_FABRIC_DCE_SW_SRV_EP_USR_LBL = "fabric_DceSwSrvEp_usrLbl"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_OPERATION_ADMIN_STATE = "fabric_DceSwSrvPcEpOperation_adminState"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_OPERATION_EP_DN = "fabric_DceSwSrvPcEpOperation_epDn"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_OPERATION_LAST_MODIFIED = "fabric_DceSwSrvPcEpOperation_lastModified"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_OPERATION_MEMBERSHIP = "fabric_DceSwSrvPcEpOperation_membership"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_OPERATION_PORT_ID = "fabric_DceSwSrvPcEpOperation_portId"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_OPERATION_REMOTE_ERROR_CODE = "fabric_DceSwSrvPcEpOperation_remoteErrorCode"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_OPERATION_REMOTE_ERROR_DESCR = "fabric_DceSwSrvPcEpOperation_remoteErrorDescr"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_OPERATION_SLOT_ID = "fabric_DceSwSrvPcEpOperation_slotId"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_OPERATION_TRIGGER_STATUS = "fabric_DceSwSrvPcEpOperation_triggerStatus"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_OPERATION_USR_LBL = "fabric_DceSwSrvPcEpOperation_usrLbl"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_ADMIN_STATE = "fabric_DceSwSrvPcEp_adminState"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_AGGR_PORT_ID = "fabric_DceSwSrvPcEp_aggrPortId"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_AUTO_NEGOTIATE = "fabric_DceSwSrvPcEp_autoNegotiate"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_CHASSIS_ID = "fabric_DceSwSrvPcEp_chassisId"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_EP_DN = "fabric_DceSwSrvPcEp_epDn"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_FLT_AGGR = "fabric_DceSwSrvPcEp_fltAggr"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_IF_ROLE = "fabric_DceSwSrvPcEp_ifRole"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_IF_TYPE = "fabric_DceSwSrvPcEp_ifType"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_LIC_GP = "fabric_DceSwSrvPcEp_licGP"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_LIC_STATE = "fabric_DceSwSrvPcEp_licState"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_LOCALE = "fabric_DceSwSrvPcEp_locale"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_MEMBERSHIP = "fabric_DceSwSrvPcEp_membership"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_NAME = "fabric_DceSwSrvPcEp_name"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_OPER_STATE = "fabric_DceSwSrvPcEp_operState"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_OPER_STATE_REASON = "fabric_DceSwSrvPcEp_operStateReason"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_PEER_AGGR_PORT_ID = "fabric_DceSwSrvPcEp_peerAggrPortId"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_PEER_CHASSIS_ID = "fabric_DceSwSrvPcEp_peerChassisId"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_PEER_DN = "fabric_DceSwSrvPcEp_peerDn"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_PEER_PORT_ID = "fabric_DceSwSrvPcEp_peerPortId"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_PEER_SLOT_ID = "fabric_DceSwSrvPcEp_peerSlotId"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_PORT_ID = "fabric_DceSwSrvPcEp_portId"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_SLOT_ID = "fabric_DceSwSrvPcEp_slotId"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_SWITCH_ID = "fabric_DceSwSrvPcEp_switchId"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_TRANSPORT = "fabric_DceSwSrvPcEp_transport"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_TYPE = "fabric_DceSwSrvPcEp_type"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_USR_LBL = "fabric_DceSwSrvPcEp_usrLbl"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_STAGE_DESCR = "fabric_DceSwSrvPcOperationFsmStage_descr"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_STAGE_LAST_UPDATE_TIME = "fabric_DceSwSrvPcOperationFsmStage_lastUpdateTime"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_STAGE_NAME = "fabric_DceSwSrvPcOperationFsmStage_name"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_STAGE_ORDER = "fabric_DceSwSrvPcOperationFsmStage_order"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_STAGE_RETRY = "fabric_DceSwSrvPcOperationFsmStage_retry"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_STAGE_STAGE_STATUS = "fabric_DceSwSrvPcOperationFsmStage_stageStatus"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_COMPLETION_TIME = "fabric_DceSwSrvPcOperationFsm_completionTime"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_CURRENT_FSM = "fabric_DceSwSrvPcOperationFsm_currentFsm"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_DESCR = "fabric_DceSwSrvPcOperationFsm_descr"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_FSM_INSTANCE_ID = "fabric_DceSwSrvPcOperationFsm_fsmInstanceId"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_FSM_STATUS = "fabric_DceSwSrvPcOperationFsm_fsmStatus"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_PROGRESS = "fabric_DceSwSrvPcOperationFsm_progress"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_RMT_ERR_CODE = "fabric_DceSwSrvPcOperationFsm_rmtErrCode"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_RMT_ERR_DESCR = "fabric_DceSwSrvPcOperationFsm_rmtErrDescr"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_RMT_RSLT = "fabric_DceSwSrvPcOperationFsm_rmtRslt"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_ADMIN_STATE = "fabric_DceSwSrvPcOperation_adminState"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_CHASSIS_ID = "fabric_DceSwSrvPcOperation_chassisId"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_DESCR = "fabric_DceSwSrvPcOperation_descr"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_EP_DN = "fabric_DceSwSrvPcOperation_epDn"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_DESCR = "fabric_DceSwSrvPcOperation_fsmDescr"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_PREV = "fabric_DceSwSrvPcOperation_fsmPrev"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_PROGR = "fabric_DceSwSrvPcOperation_fsmProgr"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_RMT_INV_ERR_CODE = "fabric_DceSwSrvPcOperation_fsmRmtInvErrCode"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_RMT_INV_ERR_DESCR = "fabric_DceSwSrvPcOperation_fsmRmtInvErrDescr"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_RMT_INV_RSLT = "fabric_DceSwSrvPcOperation_fsmRmtInvRslt"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_STAGE_DESCR = "fabric_DceSwSrvPcOperation_fsmStageDescr"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_STAMP = "fabric_DceSwSrvPcOperation_fsmStamp"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_STATUS = "fabric_DceSwSrvPcOperation_fsmStatus"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_FSM_TRY = "fabric_DceSwSrvPcOperation_fsmTry"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_IF_ROLE = "fabric_DceSwSrvPcOperation_ifRole"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_LAST_MODIFIED = "fabric_DceSwSrvPcOperation_lastModified"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_NAME = "fabric_DceSwSrvPcOperation_name"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_OPER_SPEED = "fabric_DceSwSrvPcOperation_operSpeed"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_PORT_ID = "fabric_DceSwSrvPcOperation_portId"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_REMOTE_ERROR_CODE = "fabric_DceSwSrvPcOperation_remoteErrorCode"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_REMOTE_ERROR_DESCR = "fabric_DceSwSrvPcOperation_remoteErrorDescr"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_TRANSPORT = "fabric_DceSwSrvPcOperation_transport"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_TRIGGER_STATUS = "fabric_DceSwSrvPcOperation_triggerStatus"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPERATION_TYPE = "fabric_DceSwSrvPcOperation_type"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_ADMIN_STATE = "fabric_DceSwSrvPc_adminState"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_CHASSIS_ID = "fabric_DceSwSrvPc_chassisId"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_DESCR = "fabric_DceSwSrvPc_descr"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_EP_DN = "fabric_DceSwSrvPc_epDn"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_FLT_AGGR = "fabric_DceSwSrvPc_fltAggr"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_IF_ROLE = "fabric_DceSwSrvPc_ifRole"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_IF_TYPE = "fabric_DceSwSrvPc_ifType"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_LOCALE = "fabric_DceSwSrvPc_locale"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_NAME = "fabric_DceSwSrvPc_name"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPER_SPEED = "fabric_DceSwSrvPc_operSpeed"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_OPER_STATE = "fabric_DceSwSrvPc_operState"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_PEER_DN = "fabric_DceSwSrvPc_peerDn"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_PORT_ID = "fabric_DceSwSrvPc_portId"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_STATE_QUAL = "fabric_DceSwSrvPc_stateQual"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_SWITCH_ID = "fabric_DceSwSrvPc_switchId"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_TRANSPORT = "fabric_DceSwSrvPc_transport"
    SORT_PROP_FABRIC_DCE_SW_SRV_PC_TYPE = "fabric_DceSwSrvPc_type"
    SORT_PROP_FABRIC_DCE_SW_SRV_ID = "fabric_DceSwSrv_id"
    SORT_PROP_FABRIC_DCE_SW_SRV_LOCALE = "fabric_DceSwSrv_locale"
    SORT_PROP_FABRIC_DCE_SW_SRV_NAME = "fabric_DceSwSrv_name"
    SORT_PROP_FABRIC_DCE_SW_SRV_TRANSPORT = "fabric_DceSwSrv_transport"
    SORT_PROP_FABRIC_DCE_SW_SRV_TYPE = "fabric_DceSwSrv_type"
    SORT_PROP_FABRIC_DOMAIN_ID = "fabric_Domain_id"
    SORT_PROP_FABRIC_DOMAIN_LOCALE = "fabric_Domain_locale"
    SORT_PROP_FABRIC_DOMAIN_NAME = "fabric_Domain_name"
    SORT_PROP_FABRIC_DOMAIN_TRANSPORT = "fabric_Domain_transport"
    SORT_PROP_FABRIC_DOMAIN_TYPE = "fabric_Domain_type"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_OPERATION_ADMIN_STATE = "fabric_EnclosurePhEpOperation_adminState"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_OPERATION_LAST_MODIFIED = "fabric_EnclosurePhEpOperation_lastModified"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_OPERATION_MODEL = "fabric_EnclosurePhEpOperation_model"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_OPERATION_REMOTE_ERROR_CODE = "fabric_EnclosurePhEpOperation_remoteErrorCode"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_OPERATION_REMOTE_ERROR_DESCR = "fabric_EnclosurePhEpOperation_remoteErrorDescr"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_OPERATION_REVISION = "fabric_EnclosurePhEpOperation_revision"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_OPERATION_SERIAL = "fabric_EnclosurePhEpOperation_serial"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_OPERATION_TRIGGER_STATUS = "fabric_EnclosurePhEpOperation_triggerStatus"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_OPERATION_VENDOR = "fabric_EnclosurePhEpOperation_vendor"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_ADMIN_STATE = "fabric_EnclosurePhEp_adminState"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_AGGR_PORT_ID = "fabric_EnclosurePhEp_aggrPortId"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_AUTO_NEGOTIATE = "fabric_EnclosurePhEp_autoNegotiate"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_CHASSIS_ID = "fabric_EnclosurePhEp_chassisId"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_EP_DN = "fabric_EnclosurePhEp_epDn"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_FLT_AGGR = "fabric_EnclosurePhEp_fltAggr"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_IF_ROLE = "fabric_EnclosurePhEp_ifRole"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_IF_TYPE = "fabric_EnclosurePhEp_ifType"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_LC = "fabric_EnclosurePhEp_lc"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_LIC_GP = "fabric_EnclosurePhEp_licGP"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_LIC_STATE = "fabric_EnclosurePhEp_licState"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_LOCALE = "fabric_EnclosurePhEp_locale"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_MODEL = "fabric_EnclosurePhEp_model"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_NAME = "fabric_EnclosurePhEp_name"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_OPER_STATE = "fabric_EnclosurePhEp_operState"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_OPER_STATE_REASON = "fabric_EnclosurePhEp_operStateReason"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_PEER_AGGR_PORT_ID = "fabric_EnclosurePhEp_peerAggrPortId"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_PEER_CHASSIS_ID = "fabric_EnclosurePhEp_peerChassisId"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_PEER_DN = "fabric_EnclosurePhEp_peerDn"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_PEER_PORT_ID = "fabric_EnclosurePhEp_peerPortId"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_PEER_SLOT_ID = "fabric_EnclosurePhEp_peerSlotId"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_PORT_ID = "fabric_EnclosurePhEp_portId"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_REVISION = "fabric_EnclosurePhEp_revision"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_SERIAL = "fabric_EnclosurePhEp_serial"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_SLOT_ID = "fabric_EnclosurePhEp_slotId"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_SWITCH_ID = "fabric_EnclosurePhEp_switchId"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_TRANSPORT = "fabric_EnclosurePhEp_transport"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_TYPE = "fabric_EnclosurePhEp_type"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_USR_LBL = "fabric_EnclosurePhEp_usrLbl"
    SORT_PROP_FABRIC_ENCLOSURE_PH_EP_VENDOR = "fabric_EnclosurePhEp_vendor"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_OPERATION_ADMIN_STATE = "fabric_EnclosureSlotEpOperation_adminState"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_OPERATION_LAST_MODIFIED = "fabric_EnclosureSlotEpOperation_lastModified"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_OPERATION_MODEL = "fabric_EnclosureSlotEpOperation_model"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_OPERATION_REMOTE_ERROR_CODE = "fabric_EnclosureSlotEpOperation_remoteErrorCode"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_OPERATION_REMOTE_ERROR_DESCR = "fabric_EnclosureSlotEpOperation_remoteErrorDescr"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_OPERATION_REVISION = "fabric_EnclosureSlotEpOperation_revision"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_OPERATION_SERIAL = "fabric_EnclosureSlotEpOperation_serial"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_OPERATION_TRIGGER_STATUS = "fabric_EnclosureSlotEpOperation_triggerStatus"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_OPERATION_VENDOR = "fabric_EnclosureSlotEpOperation_vendor"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_ADMIN_STATE = "fabric_EnclosureSlotEp_adminState"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_AGGR_PORT_ID = "fabric_EnclosureSlotEp_aggrPortId"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_AUTO_NEGOTIATE = "fabric_EnclosureSlotEp_autoNegotiate"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_CHASSIS_ID = "fabric_EnclosureSlotEp_chassisId"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_CONN_PATH = "fabric_EnclosureSlotEp_connPath"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_CONN_STATUS = "fabric_EnclosureSlotEp_connStatus"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_DISCOVERY_STATUS = "fabric_EnclosureSlotEp_discoveryStatus"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_EP_DN = "fabric_EnclosureSlotEp_epDn"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_FLT_AGGR = "fabric_EnclosureSlotEp_fltAggr"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_IF_ROLE = "fabric_EnclosureSlotEp_ifRole"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_IF_TYPE = "fabric_EnclosureSlotEp_ifType"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_LIC_GP = "fabric_EnclosureSlotEp_licGP"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_LIC_STATE = "fabric_EnclosureSlotEp_licState"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_LOCALE = "fabric_EnclosureSlotEp_locale"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_MANAGING_INST = "fabric_EnclosureSlotEp_managingInst"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_MODEL = "fabric_EnclosureSlotEp_model"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_NAME = "fabric_EnclosureSlotEp_name"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_OPER_STATE = "fabric_EnclosureSlotEp_operState"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_OPER_STATE_REASON = "fabric_EnclosureSlotEp_operStateReason"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_PEER_AGGR_PORT_ID = "fabric_EnclosureSlotEp_peerAggrPortId"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_PEER_CHASSIS_ID = "fabric_EnclosureSlotEp_peerChassisId"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_PEER_DN = "fabric_EnclosureSlotEp_peerDn"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_PEER_PORT_ID = "fabric_EnclosureSlotEp_peerPortId"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_PEER_SLOT_ID = "fabric_EnclosureSlotEp_peerSlotId"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_PORT_ID = "fabric_EnclosureSlotEp_portId"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_PRESENCE = "fabric_EnclosureSlotEp_presence"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_REVISION = "fabric_EnclosureSlotEp_revision"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_SERIAL = "fabric_EnclosureSlotEp_serial"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_SLOT_ADMIN_STATE = "fabric_EnclosureSlotEp_slotAdminState"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_SLOT_ID = "fabric_EnclosureSlotEp_slotId"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_SWITCH_ID = "fabric_EnclosureSlotEp_switchId"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_TRANSPORT = "fabric_EnclosureSlotEp_transport"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_TYPE = "fabric_EnclosureSlotEp_type"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_USR_LBL = "fabric_EnclosureSlotEp_usrLbl"
    SORT_PROP_FABRIC_ENCLOSURE_SLOT_EP_VENDOR = "fabric_EnclosureSlotEp_vendor"
    SORT_PROP_FABRIC_EP_VLAN_ASSOC_PRIMARY_VLAN_STATE = "fabric_EpVlan_assocPrimaryVlanState"
    SORT_PROP_FABRIC_EP_VLAN_ASSOC_PRIMARY_VLAN_SWITCH_ID = "fabric_EpVlan_assocPrimaryVlanSwitchId"
    SORT_PROP_FABRIC_EP_VLAN_EP_DN = "fabric_EpVlan_epDn"
    SORT_PROP_FABRIC_EP_VLAN_ID = "fabric_EpVlan_id"
    SORT_PROP_FABRIC_EP_VLAN_IF_ROLE = "fabric_EpVlan_ifRole"
    SORT_PROP_FABRIC_EP_VLAN_IF_TYPE = "fabric_EpVlan_ifType"
    SORT_PROP_FABRIC_EP_VLAN_LOCALE = "fabric_EpVlan_locale"
    SORT_PROP_FABRIC_EP_VLAN_NAME = "fabric_EpVlan_name"
    SORT_PROP_FABRIC_EP_VLAN_OPER_STATE = "fabric_EpVlan_operState"
    SORT_PROP_FABRIC_EP_VLAN_OVERLAP_STATE_FOR_A = "fabric_EpVlan_overlapStateForA"
    SORT_PROP_FABRIC_EP_VLAN_OVERLAP_STATE_FOR_B = "fabric_EpVlan_overlapStateForB"
    SORT_PROP_FABRIC_EP_VLAN_PEER_DN = "fabric_EpVlan_peerDn"
    SORT_PROP_FABRIC_EP_VLAN_POLICY_OWNER = "fabric_EpVlan_policyOwner"
    SORT_PROP_FABRIC_EP_VLAN_PUB_NW_DN = "fabric_EpVlan_pubNwDn"
    SORT_PROP_FABRIC_EP_VLAN_PUB_NW_ID = "fabric_EpVlan_pubNwId"
    SORT_PROP_FABRIC_EP_VLAN_PUB_NW_NAME = "fabric_EpVlan_pubNwName"
    SORT_PROP_FABRIC_EP_VLAN_SHARING = "fabric_EpVlan_sharing"
    SORT_PROP_FABRIC_EP_VLAN_SWITCH_ID = "fabric_EpVlan_switchId"
    SORT_PROP_FABRIC_EP_VLAN_TRANSPORT = "fabric_EpVlan_transport"
    SORT_PROP_FABRIC_EP_VLAN_TYPE = "fabric_EpVlan_type"
    SORT_PROP_FABRIC_EP_VLAN_VLAN_TYPE = "fabric_EpVlan_vlanType"
    SORT_PROP_FABRIC_EP_VSAN_EP_DN = "fabric_EpVsan_epDn"
    SORT_PROP_FABRIC_EP_VSAN_FCOE_VLAN = "fabric_EpVsan_fcoeVlan"
    SORT_PROP_FABRIC_EP_VSAN_ID = "fabric_EpVsan_id"
    SORT_PROP_FABRIC_EP_VSAN_IF_ROLE = "fabric_EpVsan_ifRole"
    SORT_PROP_FABRIC_EP_VSAN_IF_TYPE = "fabric_EpVsan_ifType"
    SORT_PROP_FABRIC_EP_VSAN_LOCALE = "fabric_EpVsan_locale"
    SORT_PROP_FABRIC_EP_VSAN_NAME = "fabric_EpVsan_name"
    SORT_PROP_FABRIC_EP_VSAN_OPER_STATE = "fabric_EpVsan_operState"
    SORT_PROP_FABRIC_EP_VSAN_PEER_DN = "fabric_EpVsan_peerDn"
    SORT_PROP_FABRIC_EP_VSAN_POLICY_OWNER = "fabric_EpVsan_policyOwner"
    SORT_PROP_FABRIC_EP_VSAN_SWITCH_ID = "fabric_EpVsan_switchId"
    SORT_PROP_FABRIC_EP_VSAN_TRANSPORT = "fabric_EpVsan_transport"
    SORT_PROP_FABRIC_EP_VSAN_TYPE = "fabric_EpVsan_type"
    SORT_PROP_FABRIC_EP_VSAN_ZONING_STATE = "fabric_EpVsan_zoningState"
    SORT_PROP_FABRIC_EQUIPMENT_EP_ADMIN_STATE = "fabric_EquipmentEp_adminState"
    SORT_PROP_FABRIC_EQUIPMENT_EP_AGGR_PORT_ID = "fabric_EquipmentEp_aggrPortId"
    SORT_PROP_FABRIC_EQUIPMENT_EP_AUTO_NEGOTIATE = "fabric_EquipmentEp_autoNegotiate"
    SORT_PROP_FABRIC_EQUIPMENT_EP_CHASSIS_ID = "fabric_EquipmentEp_chassisId"
    SORT_PROP_FABRIC_EQUIPMENT_EP_EP_DN = "fabric_EquipmentEp_epDn"
    SORT_PROP_FABRIC_EQUIPMENT_EP_FLT_AGGR = "fabric_EquipmentEp_fltAggr"
    SORT_PROP_FABRIC_EQUIPMENT_EP_IF_ROLE = "fabric_EquipmentEp_ifRole"
    SORT_PROP_FABRIC_EQUIPMENT_EP_IF_TYPE = "fabric_EquipmentEp_ifType"
    SORT_PROP_FABRIC_EQUIPMENT_EP_LIC_GP = "fabric_EquipmentEp_licGP"
    SORT_PROP_FABRIC_EQUIPMENT_EP_LIC_STATE = "fabric_EquipmentEp_licState"
    SORT_PROP_FABRIC_EQUIPMENT_EP_LOCALE = "fabric_EquipmentEp_locale"
    SORT_PROP_FABRIC_EQUIPMENT_EP_NAME = "fabric_EquipmentEp_name"
    SORT_PROP_FABRIC_EQUIPMENT_EP_OPER_STATE = "fabric_EquipmentEp_operState"
    SORT_PROP_FABRIC_EQUIPMENT_EP_OPER_STATE_REASON = "fabric_EquipmentEp_operStateReason"
    SORT_PROP_FABRIC_EQUIPMENT_EP_PEER_AGGR_PORT_ID = "fabric_EquipmentEp_peerAggrPortId"
    SORT_PROP_FABRIC_EQUIPMENT_EP_PEER_CHASSIS_ID = "fabric_EquipmentEp_peerChassisId"
    SORT_PROP_FABRIC_EQUIPMENT_EP_PEER_DN = "fabric_EquipmentEp_peerDn"
    SORT_PROP_FABRIC_EQUIPMENT_EP_PEER_PORT_ID = "fabric_EquipmentEp_peerPortId"
    SORT_PROP_FABRIC_EQUIPMENT_EP_PEER_SLOT_ID = "fabric_EquipmentEp_peerSlotId"
    SORT_PROP_FABRIC_EQUIPMENT_EP_PORT_ID = "fabric_EquipmentEp_portId"
    SORT_PROP_FABRIC_EQUIPMENT_EP_SLOT_ID = "fabric_EquipmentEp_slotId"
    SORT_PROP_FABRIC_EQUIPMENT_EP_SWITCH_ID = "fabric_EquipmentEp_switchId"
    SORT_PROP_FABRIC_EQUIPMENT_EP_TRANSPORT = "fabric_EquipmentEp_transport"
    SORT_PROP_FABRIC_EQUIPMENT_EP_TYPE = "fabric_EquipmentEp_type"
    SORT_PROP_FABRIC_EQUIPMENT_EP_USR_LBL = "fabric_EquipmentEp_usrLbl"
    SORT_PROP_FABRIC_ESTC_EP_ADMIN_STATE = "fabric_EstcEp_adminState"
    SORT_PROP_FABRIC_ESTC_EP_AGGR_PORT_ID = "fabric_EstcEp_aggrPortId"
    SORT_PROP_FABRIC_ESTC_EP_AUTO_NEGOTIATE = "fabric_EstcEp_autoNegotiate"
    SORT_PROP_FABRIC_ESTC_EP_CHASSIS_ID = "fabric_EstcEp_chassisId"
    SORT_PROP_FABRIC_ESTC_EP_CONFIG_STATE = "fabric_EstcEp_configState"
    SORT_PROP_FABRIC_ESTC_EP_EP_DN = "fabric_EstcEp_epDn"
    SORT_PROP_FABRIC_ESTC_EP_FLT_AGGR = "fabric_EstcEp_fltAggr"
    SORT_PROP_FABRIC_ESTC_EP_IF_ROLE = "fabric_EstcEp_ifRole"
    SORT_PROP_FABRIC_ESTC_EP_IF_TYPE = "fabric_EstcEp_ifType"
    SORT_PROP_FABRIC_ESTC_EP_LIC_GP = "fabric_EstcEp_licGP"
    SORT_PROP_FABRIC_ESTC_EP_LIC_STATE = "fabric_EstcEp_licState"
    SORT_PROP_FABRIC_ESTC_EP_LOCALE = "fabric_EstcEp_locale"
    SORT_PROP_FABRIC_ESTC_EP_NAME = "fabric_EstcEp_name"
    SORT_PROP_FABRIC_ESTC_EP_OPER_STATE = "fabric_EstcEp_operState"
    SORT_PROP_FABRIC_ESTC_EP_OPER_STATE_REASON = "fabric_EstcEp_operStateReason"
    SORT_PROP_FABRIC_ESTC_EP_PEER_AGGR_PORT_ID = "fabric_EstcEp_peerAggrPortId"
    SORT_PROP_FABRIC_ESTC_EP_PEER_CHASSIS_ID = "fabric_EstcEp_peerChassisId"
    SORT_PROP_FABRIC_ESTC_EP_PEER_DN = "fabric_EstcEp_peerDn"
    SORT_PROP_FABRIC_ESTC_EP_PEER_PORT_ID = "fabric_EstcEp_peerPortId"
    SORT_PROP_FABRIC_ESTC_EP_PEER_SLOT_ID = "fabric_EstcEp_peerSlotId"
    SORT_PROP_FABRIC_ESTC_EP_PORT_ID = "fabric_EstcEp_portId"
    SORT_PROP_FABRIC_ESTC_EP_SLOT_ID = "fabric_EstcEp_slotId"
    SORT_PROP_FABRIC_ESTC_EP_SWITCH_ID = "fabric_EstcEp_switchId"
    SORT_PROP_FABRIC_ESTC_EP_TRANSPORT = "fabric_EstcEp_transport"
    SORT_PROP_FABRIC_ESTC_EP_TYPE = "fabric_EstcEp_type"
    SORT_PROP_FABRIC_ESTC_EP_USR_LBL = "fabric_EstcEp_usrLbl"
    SORT_PROP_FABRIC_ESTC_EP_WARNINGS = "fabric_EstcEp_warnings"
    SORT_PROP_FABRIC_ESTC_PC_ADMIN_SPEED = "fabric_EstcPc_adminSpeed"
    SORT_PROP_FABRIC_ESTC_PC_ADMIN_STATE = "fabric_EstcPc_adminState"
    SORT_PROP_FABRIC_ESTC_PC_DESCR = "fabric_EstcPc_descr"
    SORT_PROP_FABRIC_ESTC_PC_EP_DN = "fabric_EstcPc_epDn"
    SORT_PROP_FABRIC_ESTC_PC_FLT_AGGR = "fabric_EstcPc_fltAggr"
    SORT_PROP_FABRIC_ESTC_PC_IF_ROLE = "fabric_EstcPc_ifRole"
    SORT_PROP_FABRIC_ESTC_PC_IF_TYPE = "fabric_EstcPc_ifType"
    SORT_PROP_FABRIC_ESTC_PC_LOCALE = "fabric_EstcPc_locale"
    SORT_PROP_FABRIC_ESTC_PC_NAME = "fabric_EstcPc_name"
    SORT_PROP_FABRIC_ESTC_PC_OPER_SPEED = "fabric_EstcPc_operSpeed"
    SORT_PROP_FABRIC_ESTC_PC_OPER_STATE = "fabric_EstcPc_operState"
    SORT_PROP_FABRIC_ESTC_PC_PEER_DN = "fabric_EstcPc_peerDn"
    SORT_PROP_FABRIC_ESTC_PC_PORT_ID = "fabric_EstcPc_portId"
    SORT_PROP_FABRIC_ESTC_PC_STATE_QUAL = "fabric_EstcPc_stateQual"
    SORT_PROP_FABRIC_ESTC_PC_SWITCH_ID = "fabric_EstcPc_switchId"
    SORT_PROP_FABRIC_ESTC_PC_TRANSPORT = "fabric_EstcPc_transport"
    SORT_PROP_FABRIC_ESTC_PC_TYPE = "fabric_EstcPc_type"
    SORT_PROP_FABRIC_ESTC_PC_WARNINGS = "fabric_EstcPc_warnings"
    SORT_PROP_FABRIC_ETH_CDP_POLICY_DESCR = "fabric_EthCdpPolicy_descr"
    SORT_PROP_FABRIC_ETH_CDP_POLICY_INT_ID = "fabric_EthCdpPolicy_intId"
    SORT_PROP_FABRIC_ETH_CDP_POLICY_NAME = "fabric_EthCdpPolicy_name"
    SORT_PROP_FABRIC_ETH_CDP_POLICY_POLICY_LEVEL = "fabric_EthCdpPolicy_policyLevel"
    SORT_PROP_FABRIC_ETH_CDP_POLICY_POLICY_OWNER = "fabric_EthCdpPolicy_policyOwner"
    SORT_PROP_FABRIC_ETH_CDP_POLICY_PROTOCOL = "fabric_EthCdpPolicy_protocol"
    SORT_PROP_FABRIC_ETH_CDP_POLICY_TYPE = "fabric_EthCdpPolicy_type"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_STAGE_DESCR = "fabric_EthEstcEpOperationFsmStage_descr"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_STAGE_LAST_UPDATE_TIME = "fabric_EthEstcEpOperationFsmStage_lastUpdateTime"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_STAGE_NAME = "fabric_EthEstcEpOperationFsmStage_name"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_STAGE_ORDER = "fabric_EthEstcEpOperationFsmStage_order"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_STAGE_RETRY = "fabric_EthEstcEpOperationFsmStage_retry"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_STAGE_STAGE_STATUS = "fabric_EthEstcEpOperationFsmStage_stageStatus"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_COMPLETION_TIME = "fabric_EthEstcEpOperationFsm_completionTime"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_CURRENT_FSM = "fabric_EthEstcEpOperationFsm_currentFsm"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_DESCR = "fabric_EthEstcEpOperationFsm_descr"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_FSM_INSTANCE_ID = "fabric_EthEstcEpOperationFsm_fsmInstanceId"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_FSM_STATUS = "fabric_EthEstcEpOperationFsm_fsmStatus"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_PROGRESS = "fabric_EthEstcEpOperationFsm_progress"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_RMT_ERR_CODE = "fabric_EthEstcEpOperationFsm_rmtErrCode"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_RMT_ERR_DESCR = "fabric_EthEstcEpOperationFsm_rmtErrDescr"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_RMT_RSLT = "fabric_EthEstcEpOperationFsm_rmtRslt"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_ADMIN_SPEED = "fabric_EthEstcEpOperation_adminSpeed"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_ADMIN_STATE = "fabric_EthEstcEpOperation_adminState"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_EP_DN = "fabric_EthEstcEpOperation_epDn"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FLOW_CTRL_POLICY = "fabric_EthEstcEpOperation_flowCtrlPolicy"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_DESCR = "fabric_EthEstcEpOperation_fsmDescr"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_PREV = "fabric_EthEstcEpOperation_fsmPrev"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_PROGR = "fabric_EthEstcEpOperation_fsmProgr"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_RMT_INV_ERR_CODE = "fabric_EthEstcEpOperation_fsmRmtInvErrCode"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_RMT_INV_ERR_DESCR = "fabric_EthEstcEpOperation_fsmRmtInvErrDescr"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_RMT_INV_RSLT = "fabric_EthEstcEpOperation_fsmRmtInvRslt"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_STAGE_DESCR = "fabric_EthEstcEpOperation_fsmStageDescr"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_STAMP = "fabric_EthEstcEpOperation_fsmStamp"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_STATUS = "fabric_EthEstcEpOperation_fsmStatus"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_FSM_TRY = "fabric_EthEstcEpOperation_fsmTry"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_LAST_MODIFIED = "fabric_EthEstcEpOperation_lastModified"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_NW_CTRL_POLICY_NAME = "fabric_EthEstcEpOperation_nwCtrlPolicyName"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_OPER_NW_CTRL_POLICY_NAME = "fabric_EthEstcEpOperation_operNwCtrlPolicyName"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_PIN_GROUP_NAME = "fabric_EthEstcEpOperation_pinGroupName"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_PORT_ID = "fabric_EthEstcEpOperation_portId"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_PORT_MODE = "fabric_EthEstcEpOperation_portMode"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_PRIO = "fabric_EthEstcEpOperation_prio"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_REMOTE_ERROR_CODE = "fabric_EthEstcEpOperation_remoteErrorCode"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_REMOTE_ERROR_DESCR = "fabric_EthEstcEpOperation_remoteErrorDescr"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_SLOT_ID = "fabric_EthEstcEpOperation_slotId"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_TRIGGER_STATUS = "fabric_EthEstcEpOperation_triggerStatus"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_USR_LBL = "fabric_EthEstcEpOperation_usrLbl"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPERATION_VLAN_NAME = "fabric_EthEstcEpOperation_vlanName"
    SORT_PROP_FABRIC_ETH_ESTC_EP_ADMIN_SPEED = "fabric_EthEstcEp_adminSpeed"
    SORT_PROP_FABRIC_ETH_ESTC_EP_ADMIN_STATE = "fabric_EthEstcEp_adminState"
    SORT_PROP_FABRIC_ETH_ESTC_EP_AGGR_PORT_ID = "fabric_EthEstcEp_aggrPortId"
    SORT_PROP_FABRIC_ETH_ESTC_EP_AUTO_NEGOTIATE = "fabric_EthEstcEp_autoNegotiate"
    SORT_PROP_FABRIC_ETH_ESTC_EP_CHASSIS_ID = "fabric_EthEstcEp_chassisId"
    SORT_PROP_FABRIC_ETH_ESTC_EP_CONFIG_STATE = "fabric_EthEstcEp_configState"
    SORT_PROP_FABRIC_ETH_ESTC_EP_EP_DN = "fabric_EthEstcEp_epDn"
    SORT_PROP_FABRIC_ETH_ESTC_EP_FLOW_CTRL_POLICY = "fabric_EthEstcEp_flowCtrlPolicy"
    SORT_PROP_FABRIC_ETH_ESTC_EP_FLT_AGGR = "fabric_EthEstcEp_fltAggr"
    SORT_PROP_FABRIC_ETH_ESTC_EP_IF_ROLE = "fabric_EthEstcEp_ifRole"
    SORT_PROP_FABRIC_ETH_ESTC_EP_IF_TYPE = "fabric_EthEstcEp_ifType"
    SORT_PROP_FABRIC_ETH_ESTC_EP_LIC_GP = "fabric_EthEstcEp_licGP"
    SORT_PROP_FABRIC_ETH_ESTC_EP_LIC_STATE = "fabric_EthEstcEp_licState"
    SORT_PROP_FABRIC_ETH_ESTC_EP_LOCALE = "fabric_EthEstcEp_locale"
    SORT_PROP_FABRIC_ETH_ESTC_EP_NAME = "fabric_EthEstcEp_name"
    SORT_PROP_FABRIC_ETH_ESTC_EP_NW_CTRL_POLICY_NAME = "fabric_EthEstcEp_nwCtrlPolicyName"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPER_NW_CTRL_POLICY_NAME = "fabric_EthEstcEp_operNwCtrlPolicyName"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPER_PORT_MODE = "fabric_EthEstcEp_operPortMode"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPER_STATE = "fabric_EthEstcEp_operState"
    SORT_PROP_FABRIC_ETH_ESTC_EP_OPER_STATE_REASON = "fabric_EthEstcEp_operStateReason"
    SORT_PROP_FABRIC_ETH_ESTC_EP_PEER_AGGR_PORT_ID = "fabric_EthEstcEp_peerAggrPortId"
    SORT_PROP_FABRIC_ETH_ESTC_EP_PEER_CHASSIS_ID = "fabric_EthEstcEp_peerChassisId"
    SORT_PROP_FABRIC_ETH_ESTC_EP_PEER_DN = "fabric_EthEstcEp_peerDn"
    SORT_PROP_FABRIC_ETH_ESTC_EP_PEER_PORT_ID = "fabric_EthEstcEp_peerPortId"
    SORT_PROP_FABRIC_ETH_ESTC_EP_PEER_SLOT_ID = "fabric_EthEstcEp_peerSlotId"
    SORT_PROP_FABRIC_ETH_ESTC_EP_PIN_GROUP_NAME = "fabric_EthEstcEp_pinGroupName"
    SORT_PROP_FABRIC_ETH_ESTC_EP_PORT_ID = "fabric_EthEstcEp_portId"
    SORT_PROP_FABRIC_ETH_ESTC_EP_PORT_MODE = "fabric_EthEstcEp_portMode"
    SORT_PROP_FABRIC_ETH_ESTC_EP_PRIO = "fabric_EthEstcEp_prio"
    SORT_PROP_FABRIC_ETH_ESTC_EP_SLOT_ID = "fabric_EthEstcEp_slotId"
    SORT_PROP_FABRIC_ETH_ESTC_EP_SWITCH_ID = "fabric_EthEstcEp_switchId"
    SORT_PROP_FABRIC_ETH_ESTC_EP_TRANSPORT = "fabric_EthEstcEp_transport"
    SORT_PROP_FABRIC_ETH_ESTC_EP_TYPE = "fabric_EthEstcEp_type"
    SORT_PROP_FABRIC_ETH_ESTC_EP_USR_LBL = "fabric_EthEstcEp_usrLbl"
    SORT_PROP_FABRIC_ETH_ESTC_EP_WARNINGS = "fabric_EthEstcEp_warnings"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_OPERATION_ADMIN_STATE = "fabric_EthEstcPcEpOperation_adminState"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_OPERATION_EP_DN = "fabric_EthEstcPcEpOperation_epDn"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_OPERATION_LAST_MODIFIED = "fabric_EthEstcPcEpOperation_lastModified"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_OPERATION_PORT_ID = "fabric_EthEstcPcEpOperation_portId"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_OPERATION_REMOTE_ERROR_CODE = "fabric_EthEstcPcEpOperation_remoteErrorCode"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_OPERATION_REMOTE_ERROR_DESCR = "fabric_EthEstcPcEpOperation_remoteErrorDescr"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_OPERATION_SLOT_ID = "fabric_EthEstcPcEpOperation_slotId"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_OPERATION_TRIGGER_STATUS = "fabric_EthEstcPcEpOperation_triggerStatus"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_ADMIN_SPEED = "fabric_EthEstcPcEp_adminSpeed"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_ADMIN_STATE = "fabric_EthEstcPcEp_adminState"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_AGGR_PORT_ID = "fabric_EthEstcPcEp_aggrPortId"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_AUTO_NEGOTIATE = "fabric_EthEstcPcEp_autoNegotiate"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_CHASSIS_ID = "fabric_EthEstcPcEp_chassisId"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_CONFIG_STATE = "fabric_EthEstcPcEp_configState"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_EP_DN = "fabric_EthEstcPcEp_epDn"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_FLT_AGGR = "fabric_EthEstcPcEp_fltAggr"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_IF_ROLE = "fabric_EthEstcPcEp_ifRole"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_IF_TYPE = "fabric_EthEstcPcEp_ifType"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_LIC_GP = "fabric_EthEstcPcEp_licGP"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_LIC_STATE = "fabric_EthEstcPcEp_licState"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_LOCALE = "fabric_EthEstcPcEp_locale"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_MEMBERSHIP = "fabric_EthEstcPcEp_membership"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_NAME = "fabric_EthEstcPcEp_name"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_OPER_STATE = "fabric_EthEstcPcEp_operState"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_OPER_STATE_REASON = "fabric_EthEstcPcEp_operStateReason"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_PEER_AGGR_PORT_ID = "fabric_EthEstcPcEp_peerAggrPortId"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_PEER_CHASSIS_ID = "fabric_EthEstcPcEp_peerChassisId"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_PEER_DN = "fabric_EthEstcPcEp_peerDn"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_PEER_PORT_ID = "fabric_EthEstcPcEp_peerPortId"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_PEER_SLOT_ID = "fabric_EthEstcPcEp_peerSlotId"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_PORT_ID = "fabric_EthEstcPcEp_portId"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_SLOT_ID = "fabric_EthEstcPcEp_slotId"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_SWITCH_ID = "fabric_EthEstcPcEp_switchId"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_TRANSPORT = "fabric_EthEstcPcEp_transport"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_TYPE = "fabric_EthEstcPcEp_type"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_USR_LBL = "fabric_EthEstcPcEp_usrLbl"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_WARNINGS = "fabric_EthEstcPcEp_warnings"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_STAGE_DESCR = "fabric_EthEstcPcOperationFsmStage_descr"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_STAGE_LAST_UPDATE_TIME = "fabric_EthEstcPcOperationFsmStage_lastUpdateTime"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_STAGE_NAME = "fabric_EthEstcPcOperationFsmStage_name"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_STAGE_ORDER = "fabric_EthEstcPcOperationFsmStage_order"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_STAGE_RETRY = "fabric_EthEstcPcOperationFsmStage_retry"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_STAGE_STAGE_STATUS = "fabric_EthEstcPcOperationFsmStage_stageStatus"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_COMPLETION_TIME = "fabric_EthEstcPcOperationFsm_completionTime"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_CURRENT_FSM = "fabric_EthEstcPcOperationFsm_currentFsm"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_DESCR = "fabric_EthEstcPcOperationFsm_descr"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_FSM_INSTANCE_ID = "fabric_EthEstcPcOperationFsm_fsmInstanceId"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_FSM_STATUS = "fabric_EthEstcPcOperationFsm_fsmStatus"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_PROGRESS = "fabric_EthEstcPcOperationFsm_progress"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_RMT_ERR_CODE = "fabric_EthEstcPcOperationFsm_rmtErrCode"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_RMT_ERR_DESCR = "fabric_EthEstcPcOperationFsm_rmtErrDescr"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_RMT_RSLT = "fabric_EthEstcPcOperationFsm_rmtRslt"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_ADMIN_SPEED = "fabric_EthEstcPcOperation_adminSpeed"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_ADMIN_STATE = "fabric_EthEstcPcOperation_adminState"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_DESCR = "fabric_EthEstcPcOperation_descr"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_EP_DN = "fabric_EthEstcPcOperation_epDn"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FLOW_CTRL_POLICY = "fabric_EthEstcPcOperation_flowCtrlPolicy"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_DESCR = "fabric_EthEstcPcOperation_fsmDescr"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_PREV = "fabric_EthEstcPcOperation_fsmPrev"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_PROGR = "fabric_EthEstcPcOperation_fsmProgr"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_RMT_INV_ERR_CODE = "fabric_EthEstcPcOperation_fsmRmtInvErrCode"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_RMT_INV_ERR_DESCR = "fabric_EthEstcPcOperation_fsmRmtInvErrDescr"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_RMT_INV_RSLT = "fabric_EthEstcPcOperation_fsmRmtInvRslt"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_STAGE_DESCR = "fabric_EthEstcPcOperation_fsmStageDescr"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_STAMP = "fabric_EthEstcPcOperation_fsmStamp"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_STATUS = "fabric_EthEstcPcOperation_fsmStatus"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_FSM_TRY = "fabric_EthEstcPcOperation_fsmTry"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_LACP_POLICY_NAME = "fabric_EthEstcPcOperation_lacpPolicyName"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_LAST_MODIFIED = "fabric_EthEstcPcOperation_lastModified"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_NAME = "fabric_EthEstcPcOperation_name"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_NW_CTRL_POLICY_NAME = "fabric_EthEstcPcOperation_nwCtrlPolicyName"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_OPER_LACP_POLICY_NAME = "fabric_EthEstcPcOperation_operLacpPolicyName"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_PIN_GROUP_NAME = "fabric_EthEstcPcOperation_pinGroupName"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_PORT_ID = "fabric_EthEstcPcOperation_portId"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_PORT_MODE = "fabric_EthEstcPcOperation_portMode"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_PRIO = "fabric_EthEstcPcOperation_prio"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_PROTOCOL = "fabric_EthEstcPcOperation_protocol"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_REMOTE_ERROR_CODE = "fabric_EthEstcPcOperation_remoteErrorCode"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_REMOTE_ERROR_DESCR = "fabric_EthEstcPcOperation_remoteErrorDescr"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_TRIGGER_STATUS = "fabric_EthEstcPcOperation_triggerStatus"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPERATION_VLAN_NAME = "fabric_EthEstcPcOperation_vlanName"
    SORT_PROP_FABRIC_ETH_ESTC_PC_ADMIN_SPEED = "fabric_EthEstcPc_adminSpeed"
    SORT_PROP_FABRIC_ETH_ESTC_PC_ADMIN_STATE = "fabric_EthEstcPc_adminState"
    SORT_PROP_FABRIC_ETH_ESTC_PC_DESCR = "fabric_EthEstcPc_descr"
    SORT_PROP_FABRIC_ETH_ESTC_PC_EP_DN = "fabric_EthEstcPc_epDn"
    SORT_PROP_FABRIC_ETH_ESTC_PC_FLOW_CTRL_POLICY = "fabric_EthEstcPc_flowCtrlPolicy"
    SORT_PROP_FABRIC_ETH_ESTC_PC_FLT_AGGR = "fabric_EthEstcPc_fltAggr"
    SORT_PROP_FABRIC_ETH_ESTC_PC_IF_ROLE = "fabric_EthEstcPc_ifRole"
    SORT_PROP_FABRIC_ETH_ESTC_PC_IF_TYPE = "fabric_EthEstcPc_ifType"
    SORT_PROP_FABRIC_ETH_ESTC_PC_LACP_POLICY_NAME = "fabric_EthEstcPc_lacpPolicyName"
    SORT_PROP_FABRIC_ETH_ESTC_PC_LOCALE = "fabric_EthEstcPc_locale"
    SORT_PROP_FABRIC_ETH_ESTC_PC_NAME = "fabric_EthEstcPc_name"
    SORT_PROP_FABRIC_ETH_ESTC_PC_NW_CTRL_POLICY_NAME = "fabric_EthEstcPc_nwCtrlPolicyName"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPER_LACP_POLICY_NAME = "fabric_EthEstcPc_operLacpPolicyName"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPER_NW_CTRL_POLICY_NAME = "fabric_EthEstcPc_operNwCtrlPolicyName"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPER_SPEED = "fabric_EthEstcPc_operSpeed"
    SORT_PROP_FABRIC_ETH_ESTC_PC_OPER_STATE = "fabric_EthEstcPc_operState"
    SORT_PROP_FABRIC_ETH_ESTC_PC_PEER_DN = "fabric_EthEstcPc_peerDn"
    SORT_PROP_FABRIC_ETH_ESTC_PC_PIN_GROUP_NAME = "fabric_EthEstcPc_pinGroupName"
    SORT_PROP_FABRIC_ETH_ESTC_PC_PORT_ID = "fabric_EthEstcPc_portId"
    SORT_PROP_FABRIC_ETH_ESTC_PC_PORT_MODE = "fabric_EthEstcPc_portMode"
    SORT_PROP_FABRIC_ETH_ESTC_PC_PRIO = "fabric_EthEstcPc_prio"
    SORT_PROP_FABRIC_ETH_ESTC_PC_PROTOCOL = "fabric_EthEstcPc_protocol"
    SORT_PROP_FABRIC_ETH_ESTC_PC_STATE_QUAL = "fabric_EthEstcPc_stateQual"
    SORT_PROP_FABRIC_ETH_ESTC_PC_SWITCH_ID = "fabric_EthEstcPc_switchId"
    SORT_PROP_FABRIC_ETH_ESTC_PC_TRANSPORT = "fabric_EthEstcPc_transport"
    SORT_PROP_FABRIC_ETH_ESTC_PC_TYPE = "fabric_EthEstcPc_type"
    SORT_PROP_FABRIC_ETH_ESTC_PC_WARNINGS = "fabric_EthEstcPc_warnings"
    SORT_PROP_FABRIC_ETH_ESTC_ID = "fabric_EthEstc_id"
    SORT_PROP_FABRIC_ETH_ESTC_LOCALE = "fabric_EthEstc_locale"
    SORT_PROP_FABRIC_ETH_ESTC_NAME = "fabric_EthEstc_name"
    SORT_PROP_FABRIC_ETH_ESTC_TRANSPORT = "fabric_EthEstc_transport"
    SORT_PROP_FABRIC_ETH_ESTC_TYPE = "fabric_EthEstc_type"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_STAGE_DESCR = "fabric_EthLanEpOperationFsmStage_descr"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_STAGE_LAST_UPDATE_TIME = "fabric_EthLanEpOperationFsmStage_lastUpdateTime"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_STAGE_NAME = "fabric_EthLanEpOperationFsmStage_name"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_STAGE_ORDER = "fabric_EthLanEpOperationFsmStage_order"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_STAGE_RETRY = "fabric_EthLanEpOperationFsmStage_retry"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_STAGE_STAGE_STATUS = "fabric_EthLanEpOperationFsmStage_stageStatus"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_COMPLETION_TIME = "fabric_EthLanEpOperationFsm_completionTime"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_CURRENT_FSM = "fabric_EthLanEpOperationFsm_currentFsm"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_DESCR = "fabric_EthLanEpOperationFsm_descr"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_FSM_INSTANCE_ID = "fabric_EthLanEpOperationFsm_fsmInstanceId"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_FSM_STATUS = "fabric_EthLanEpOperationFsm_fsmStatus"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_PROGRESS = "fabric_EthLanEpOperationFsm_progress"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_RMT_ERR_CODE = "fabric_EthLanEpOperationFsm_rmtErrCode"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_RMT_ERR_DESCR = "fabric_EthLanEpOperationFsm_rmtErrDescr"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_RMT_RSLT = "fabric_EthLanEpOperationFsm_rmtRslt"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_ADMIN_SPEED = "fabric_EthLanEpOperation_adminSpeed"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_ADMIN_STATE = "fabric_EthLanEpOperation_adminState"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_EP_DN = "fabric_EthLanEpOperation_epDn"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_ETH_LINK_PROFILE_NAME = "fabric_EthLanEpOperation_ethLinkProfileName"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FLOW_CTRL_POLICY = "fabric_EthLanEpOperation_flowCtrlPolicy"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_DESCR = "fabric_EthLanEpOperation_fsmDescr"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_PREV = "fabric_EthLanEpOperation_fsmPrev"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_PROGR = "fabric_EthLanEpOperation_fsmProgr"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_RMT_INV_ERR_CODE = "fabric_EthLanEpOperation_fsmRmtInvErrCode"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_RMT_INV_ERR_DESCR = "fabric_EthLanEpOperation_fsmRmtInvErrDescr"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_RMT_INV_RSLT = "fabric_EthLanEpOperation_fsmRmtInvRslt"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_STAGE_DESCR = "fabric_EthLanEpOperation_fsmStageDescr"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_STAMP = "fabric_EthLanEpOperation_fsmStamp"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_STATUS = "fabric_EthLanEpOperation_fsmStatus"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_FSM_TRY = "fabric_EthLanEpOperation_fsmTry"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_LAST_MODIFIED = "fabric_EthLanEpOperation_lastModified"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_OPER_ETH_LINK_PROFILE_NAME = "fabric_EthLanEpOperation_operEthLinkProfileName"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_PORT_ID = "fabric_EthLanEpOperation_portId"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_PORT_MODE = "fabric_EthLanEpOperation_portMode"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_REMOTE_ERROR_CODE = "fabric_EthLanEpOperation_remoteErrorCode"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_REMOTE_ERROR_DESCR = "fabric_EthLanEpOperation_remoteErrorDescr"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_SLOT_ID = "fabric_EthLanEpOperation_slotId"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_TRIGGER_STATUS = "fabric_EthLanEpOperation_triggerStatus"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_USR_LBL = "fabric_EthLanEpOperation_usrLbl"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPERATION_VLAN_NAME = "fabric_EthLanEpOperation_vlanName"
    SORT_PROP_FABRIC_ETH_LAN_EP_ADMIN_SPEED = "fabric_EthLanEp_adminSpeed"
    SORT_PROP_FABRIC_ETH_LAN_EP_ADMIN_STATE = "fabric_EthLanEp_adminState"
    SORT_PROP_FABRIC_ETH_LAN_EP_AGGR_PORT_ID = "fabric_EthLanEp_aggrPortId"
    SORT_PROP_FABRIC_ETH_LAN_EP_AUTO_NEGOTIATE = "fabric_EthLanEp_autoNegotiate"
    SORT_PROP_FABRIC_ETH_LAN_EP_CHASSIS_ID = "fabric_EthLanEp_chassisId"
    SORT_PROP_FABRIC_ETH_LAN_EP_EP_DN = "fabric_EthLanEp_epDn"
    SORT_PROP_FABRIC_ETH_LAN_EP_ETH_LINK_PROFILE_NAME = "fabric_EthLanEp_ethLinkProfileName"
    SORT_PROP_FABRIC_ETH_LAN_EP_FLOW_CTRL_POLICY = "fabric_EthLanEp_flowCtrlPolicy"
    SORT_PROP_FABRIC_ETH_LAN_EP_FLT_AGGR = "fabric_EthLanEp_fltAggr"
    SORT_PROP_FABRIC_ETH_LAN_EP_IF_ROLE = "fabric_EthLanEp_ifRole"
    SORT_PROP_FABRIC_ETH_LAN_EP_IF_TYPE = "fabric_EthLanEp_ifType"
    SORT_PROP_FABRIC_ETH_LAN_EP_LIC_GP = "fabric_EthLanEp_licGP"
    SORT_PROP_FABRIC_ETH_LAN_EP_LIC_STATE = "fabric_EthLanEp_licState"
    SORT_PROP_FABRIC_ETH_LAN_EP_LOCALE = "fabric_EthLanEp_locale"
    SORT_PROP_FABRIC_ETH_LAN_EP_NAME = "fabric_EthLanEp_name"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPER_ETH_LINK_PROFILE_NAME = "fabric_EthLanEp_operEthLinkProfileName"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPER_STATE = "fabric_EthLanEp_operState"
    SORT_PROP_FABRIC_ETH_LAN_EP_OPER_STATE_REASON = "fabric_EthLanEp_operStateReason"
    SORT_PROP_FABRIC_ETH_LAN_EP_OVERLAPPING_VLANS = "fabric_EthLanEp_overlappingVlans"
    SORT_PROP_FABRIC_ETH_LAN_EP_PEER_AGGR_PORT_ID = "fabric_EthLanEp_peerAggrPortId"
    SORT_PROP_FABRIC_ETH_LAN_EP_PEER_CHASSIS_ID = "fabric_EthLanEp_peerChassisId"
    SORT_PROP_FABRIC_ETH_LAN_EP_PEER_DN = "fabric_EthLanEp_peerDn"
    SORT_PROP_FABRIC_ETH_LAN_EP_PEER_PORT_ID = "fabric_EthLanEp_peerPortId"
    SORT_PROP_FABRIC_ETH_LAN_EP_PEER_SLOT_ID = "fabric_EthLanEp_peerSlotId"
    SORT_PROP_FABRIC_ETH_LAN_EP_PORT_ID = "fabric_EthLanEp_portId"
    SORT_PROP_FABRIC_ETH_LAN_EP_SLOT_ID = "fabric_EthLanEp_slotId"
    SORT_PROP_FABRIC_ETH_LAN_EP_SWITCH_ID = "fabric_EthLanEp_switchId"
    SORT_PROP_FABRIC_ETH_LAN_EP_TRANSPORT = "fabric_EthLanEp_transport"
    SORT_PROP_FABRIC_ETH_LAN_EP_TYPE = "fabric_EthLanEp_type"
    SORT_PROP_FABRIC_ETH_LAN_EP_UDLD_OPER_STATE = "fabric_EthLanEp_udldOperState"
    SORT_PROP_FABRIC_ETH_LAN_EP_USR_LBL = "fabric_EthLanEp_usrLbl"
    SORT_PROP_FABRIC_ETH_LAN_EP_VLAN_STATUS = "fabric_EthLanEp_vlanStatus"
    SORT_PROP_FABRIC_ETH_LAN_EP_WARNINGS = "fabric_EthLanEp_warnings"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_OPERATION_ADMIN_STATE = "fabric_EthLanPcEpOperation_adminState"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_OPERATION_EP_DN = "fabric_EthLanPcEpOperation_epDn"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_OPERATION_ETH_LINK_PROFILE_NAME = "fabric_EthLanPcEpOperation_ethLinkProfileName"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_OPERATION_LAST_MODIFIED = "fabric_EthLanPcEpOperation_lastModified"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_OPERATION_OPER_ETH_LINK_PROFILE_NAME = "fabric_EthLanPcEpOperation_operEthLinkProfileName"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_OPERATION_PORT_ID = "fabric_EthLanPcEpOperation_portId"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_OPERATION_REMOTE_ERROR_CODE = "fabric_EthLanPcEpOperation_remoteErrorCode"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_OPERATION_REMOTE_ERROR_DESCR = "fabric_EthLanPcEpOperation_remoteErrorDescr"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_OPERATION_SLOT_ID = "fabric_EthLanPcEpOperation_slotId"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_OPERATION_TRIGGER_STATUS = "fabric_EthLanPcEpOperation_triggerStatus"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_ADMIN_STATE = "fabric_EthLanPcEp_adminState"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_AGGR_PORT_ID = "fabric_EthLanPcEp_aggrPortId"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_AUTO_NEGOTIATE = "fabric_EthLanPcEp_autoNegotiate"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_CHASSIS_ID = "fabric_EthLanPcEp_chassisId"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_EP_DN = "fabric_EthLanPcEp_epDn"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_ETH_LINK_PROFILE_NAME = "fabric_EthLanPcEp_ethLinkProfileName"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_FLT_AGGR = "fabric_EthLanPcEp_fltAggr"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_IF_ROLE = "fabric_EthLanPcEp_ifRole"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_IF_TYPE = "fabric_EthLanPcEp_ifType"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_LIC_GP = "fabric_EthLanPcEp_licGP"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_LIC_STATE = "fabric_EthLanPcEp_licState"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_LOCALE = "fabric_EthLanPcEp_locale"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_MEMBERSHIP = "fabric_EthLanPcEp_membership"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_NAME = "fabric_EthLanPcEp_name"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_OPER_ETH_LINK_PROFILE_NAME = "fabric_EthLanPcEp_operEthLinkProfileName"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_OPER_STATE = "fabric_EthLanPcEp_operState"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_OPER_STATE_REASON = "fabric_EthLanPcEp_operStateReason"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_PEER_AGGR_PORT_ID = "fabric_EthLanPcEp_peerAggrPortId"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_PEER_CHASSIS_ID = "fabric_EthLanPcEp_peerChassisId"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_PEER_DN = "fabric_EthLanPcEp_peerDn"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_PEER_PORT_ID = "fabric_EthLanPcEp_peerPortId"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_PEER_SLOT_ID = "fabric_EthLanPcEp_peerSlotId"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_PORT_ID = "fabric_EthLanPcEp_portId"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_SLOT_ID = "fabric_EthLanPcEp_slotId"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_SWITCH_ID = "fabric_EthLanPcEp_switchId"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_TRANSPORT = "fabric_EthLanPcEp_transport"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_TYPE = "fabric_EthLanPcEp_type"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_UDLD_OPER_STATE = "fabric_EthLanPcEp_udldOperState"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_USR_LBL = "fabric_EthLanPcEp_usrLbl"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_WARNINGS = "fabric_EthLanPcEp_warnings"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_STAGE_DESCR = "fabric_EthLanPcOperationFsmStage_descr"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_STAGE_LAST_UPDATE_TIME = "fabric_EthLanPcOperationFsmStage_lastUpdateTime"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_STAGE_NAME = "fabric_EthLanPcOperationFsmStage_name"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_STAGE_ORDER = "fabric_EthLanPcOperationFsmStage_order"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_STAGE_RETRY = "fabric_EthLanPcOperationFsmStage_retry"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_STAGE_STAGE_STATUS = "fabric_EthLanPcOperationFsmStage_stageStatus"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_COMPLETION_TIME = "fabric_EthLanPcOperationFsm_completionTime"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_CURRENT_FSM = "fabric_EthLanPcOperationFsm_currentFsm"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_DESCR = "fabric_EthLanPcOperationFsm_descr"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_FSM_INSTANCE_ID = "fabric_EthLanPcOperationFsm_fsmInstanceId"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_FSM_STATUS = "fabric_EthLanPcOperationFsm_fsmStatus"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_PROGRESS = "fabric_EthLanPcOperationFsm_progress"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_RMT_ERR_CODE = "fabric_EthLanPcOperationFsm_rmtErrCode"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_RMT_ERR_DESCR = "fabric_EthLanPcOperationFsm_rmtErrDescr"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_RMT_RSLT = "fabric_EthLanPcOperationFsm_rmtRslt"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_ADMIN_SPEED = "fabric_EthLanPcOperation_adminSpeed"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_ADMIN_STATE = "fabric_EthLanPcOperation_adminState"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_DESCR = "fabric_EthLanPcOperation_descr"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_EP_DN = "fabric_EthLanPcOperation_epDn"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FLOW_CTRL_POLICY = "fabric_EthLanPcOperation_flowCtrlPolicy"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_DESCR = "fabric_EthLanPcOperation_fsmDescr"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_PREV = "fabric_EthLanPcOperation_fsmPrev"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_PROGR = "fabric_EthLanPcOperation_fsmProgr"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_RMT_INV_ERR_CODE = "fabric_EthLanPcOperation_fsmRmtInvErrCode"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_RMT_INV_ERR_DESCR = "fabric_EthLanPcOperation_fsmRmtInvErrDescr"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_RMT_INV_RSLT = "fabric_EthLanPcOperation_fsmRmtInvRslt"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_STAGE_DESCR = "fabric_EthLanPcOperation_fsmStageDescr"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_STAMP = "fabric_EthLanPcOperation_fsmStamp"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_STATUS = "fabric_EthLanPcOperation_fsmStatus"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_FSM_TRY = "fabric_EthLanPcOperation_fsmTry"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_LACP_POLICY_NAME = "fabric_EthLanPcOperation_lacpPolicyName"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_LAST_MODIFIED = "fabric_EthLanPcOperation_lastModified"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_NAME = "fabric_EthLanPcOperation_name"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_OPER_LACP_POLICY_NAME = "fabric_EthLanPcOperation_operLacpPolicyName"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_OPER_SPEED = "fabric_EthLanPcOperation_operSpeed"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_PORT_ID = "fabric_EthLanPcOperation_portId"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_PORT_MODE = "fabric_EthLanPcOperation_portMode"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_REMOTE_ERROR_CODE = "fabric_EthLanPcOperation_remoteErrorCode"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_REMOTE_ERROR_DESCR = "fabric_EthLanPcOperation_remoteErrorDescr"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_TRIGGER_STATUS = "fabric_EthLanPcOperation_triggerStatus"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPERATION_VLAN_NAME = "fabric_EthLanPcOperation_vlanName"
    SORT_PROP_FABRIC_ETH_LAN_PC_ADMIN_SPEED = "fabric_EthLanPc_adminSpeed"
    SORT_PROP_FABRIC_ETH_LAN_PC_ADMIN_STATE = "fabric_EthLanPc_adminState"
    SORT_PROP_FABRIC_ETH_LAN_PC_BANDWIDTH = "fabric_EthLanPc_bandwidth"
    SORT_PROP_FABRIC_ETH_LAN_PC_DESCR = "fabric_EthLanPc_descr"
    SORT_PROP_FABRIC_ETH_LAN_PC_EP_DN = "fabric_EthLanPc_epDn"
    SORT_PROP_FABRIC_ETH_LAN_PC_FLOW_CTRL_POLICY = "fabric_EthLanPc_flowCtrlPolicy"
    SORT_PROP_FABRIC_ETH_LAN_PC_FLT_AGGR = "fabric_EthLanPc_fltAggr"
    SORT_PROP_FABRIC_ETH_LAN_PC_IF_ROLE = "fabric_EthLanPc_ifRole"
    SORT_PROP_FABRIC_ETH_LAN_PC_IF_TYPE = "fabric_EthLanPc_ifType"
    SORT_PROP_FABRIC_ETH_LAN_PC_LACP_POLICY_NAME = "fabric_EthLanPc_lacpPolicyName"
    SORT_PROP_FABRIC_ETH_LAN_PC_LOCALE = "fabric_EthLanPc_locale"
    SORT_PROP_FABRIC_ETH_LAN_PC_NAME = "fabric_EthLanPc_name"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPER_LACP_POLICY_NAME = "fabric_EthLanPc_operLacpPolicyName"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPER_SPEED = "fabric_EthLanPc_operSpeed"
    SORT_PROP_FABRIC_ETH_LAN_PC_OPER_STATE = "fabric_EthLanPc_operState"
    SORT_PROP_FABRIC_ETH_LAN_PC_OVERLAPPING_VLANS = "fabric_EthLanPc_overlappingVlans"
    SORT_PROP_FABRIC_ETH_LAN_PC_PEER_DN = "fabric_EthLanPc_peerDn"
    SORT_PROP_FABRIC_ETH_LAN_PC_PORT_ID = "fabric_EthLanPc_portId"
    SORT_PROP_FABRIC_ETH_LAN_PC_STATE_QUAL = "fabric_EthLanPc_stateQual"
    SORT_PROP_FABRIC_ETH_LAN_PC_SWITCH_ID = "fabric_EthLanPc_switchId"
    SORT_PROP_FABRIC_ETH_LAN_PC_TRANSPORT = "fabric_EthLanPc_transport"
    SORT_PROP_FABRIC_ETH_LAN_PC_TYPE = "fabric_EthLanPc_type"
    SORT_PROP_FABRIC_ETH_LAN_PC_VLAN_STATUS = "fabric_EthLanPc_vlanStatus"
    SORT_PROP_FABRIC_ETH_LAN_PC_WARNINGS = "fabric_EthLanPc_warnings"
    SORT_PROP_FABRIC_ETH_LAN_CONFIG_QUALIFIER = "fabric_EthLan_configQualifier"
    SORT_PROP_FABRIC_ETH_LAN_ID = "fabric_EthLan_id"
    SORT_PROP_FABRIC_ETH_LAN_LOCALE = "fabric_EthLan_locale"
    SORT_PROP_FABRIC_ETH_LAN_NAME = "fabric_EthLan_name"
    SORT_PROP_FABRIC_ETH_LAN_TRANSPORT = "fabric_EthLan_transport"
    SORT_PROP_FABRIC_ETH_LAN_TYPE = "fabric_EthLan_type"
    SORT_PROP_FABRIC_ETH_LINK_POLICY_DESCR = "fabric_EthLinkPolicy_descr"
    SORT_PROP_FABRIC_ETH_LINK_POLICY_INT_ID = "fabric_EthLinkPolicy_intId"
    SORT_PROP_FABRIC_ETH_LINK_POLICY_NAME = "fabric_EthLinkPolicy_name"
    SORT_PROP_FABRIC_ETH_LINK_POLICY_POLICY_LEVEL = "fabric_EthLinkPolicy_policyLevel"
    SORT_PROP_FABRIC_ETH_LINK_POLICY_POLICY_OWNER = "fabric_EthLinkPolicy_policyOwner"
    SORT_PROP_FABRIC_ETH_LINK_POLICY_PROTOCOL = "fabric_EthLinkPolicy_protocol"
    SORT_PROP_FABRIC_ETH_LINK_POLICY_TYPE = "fabric_EthLinkPolicy_type"
    SORT_PROP_FABRIC_ETH_LINK_PROFILE_CDP_LINK_POLICY_NAME = "fabric_EthLinkProfile_cdpLinkPolicyName"
    SORT_PROP_FABRIC_ETH_LINK_PROFILE_DESCR = "fabric_EthLinkProfile_descr"
    SORT_PROP_FABRIC_ETH_LINK_PROFILE_INT_ID = "fabric_EthLinkProfile_intId"
    SORT_PROP_FABRIC_ETH_LINK_PROFILE_NAME = "fabric_EthLinkProfile_name"
    SORT_PROP_FABRIC_ETH_LINK_PROFILE_OPER_CDP_LINK_POLICY_NAME = "fabric_EthLinkProfile_operCdpLinkPolicyName"
    SORT_PROP_FABRIC_ETH_LINK_PROFILE_OPER_UDLD_LINK_POLICY_NAME = "fabric_EthLinkProfile_operUdldLinkPolicyName"
    SORT_PROP_FABRIC_ETH_LINK_PROFILE_POLICY_LEVEL = "fabric_EthLinkProfile_policyLevel"
    SORT_PROP_FABRIC_ETH_LINK_PROFILE_POLICY_OWNER = "fabric_EthLinkProfile_policyOwner"
    SORT_PROP_FABRIC_ETH_LINK_PROFILE_UDLD_LINK_POLICY_NAME = "fabric_EthLinkProfile_udldLinkPolicyName"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_OPERATION_ADMIN_SPEED = "fabric_EthMonDestEpOperation_adminSpeed"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_OPERATION_ADMIN_STATE = "fabric_EthMonDestEpOperation_adminState"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_OPERATION_EP_DN = "fabric_EthMonDestEpOperation_epDn"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_OPERATION_IF_ROLE = "fabric_EthMonDestEpOperation_ifRole"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_OPERATION_LAST_MODIFIED = "fabric_EthMonDestEpOperation_lastModified"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_OPERATION_NAME = "fabric_EthMonDestEpOperation_name"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_OPERATION_PORT_ID = "fabric_EthMonDestEpOperation_portId"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_OPERATION_REMOTE_ERROR_CODE = "fabric_EthMonDestEpOperation_remoteErrorCode"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_OPERATION_REMOTE_ERROR_DESCR = "fabric_EthMonDestEpOperation_remoteErrorDescr"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_OPERATION_SLOT_ID = "fabric_EthMonDestEpOperation_slotId"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_OPERATION_TRIGGER_STATUS = "fabric_EthMonDestEpOperation_triggerStatus"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_OPERATION_TYPE = "fabric_EthMonDestEpOperation_type"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_ADMIN_SPEED = "fabric_EthMonDestEp_adminSpeed"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_ADMIN_STATE = "fabric_EthMonDestEp_adminState"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_AGGR_PORT_ID = "fabric_EthMonDestEp_aggrPortId"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_AUTO_NEGOTIATE = "fabric_EthMonDestEp_autoNegotiate"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_CHASSIS_ID = "fabric_EthMonDestEp_chassisId"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_EP_DN = "fabric_EthMonDestEp_epDn"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_FLT_AGGR = "fabric_EthMonDestEp_fltAggr"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_IF_ROLE = "fabric_EthMonDestEp_ifRole"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_IF_TYPE = "fabric_EthMonDestEp_ifType"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_LIC_GP = "fabric_EthMonDestEp_licGP"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_LIC_STATE = "fabric_EthMonDestEp_licState"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_LOCALE = "fabric_EthMonDestEp_locale"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_NAME = "fabric_EthMonDestEp_name"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_OPER_STATE = "fabric_EthMonDestEp_operState"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_OPER_STATE_REASON = "fabric_EthMonDestEp_operStateReason"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_PEER_AGGR_PORT_ID = "fabric_EthMonDestEp_peerAggrPortId"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_PEER_CHASSIS_ID = "fabric_EthMonDestEp_peerChassisId"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_PEER_DN = "fabric_EthMonDestEp_peerDn"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_PEER_PORT_ID = "fabric_EthMonDestEp_peerPortId"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_PEER_SLOT_ID = "fabric_EthMonDestEp_peerSlotId"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_PORT_ID = "fabric_EthMonDestEp_portId"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_SLOT_ID = "fabric_EthMonDestEp_slotId"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_SWITCH_ID = "fabric_EthMonDestEp_switchId"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_TRANSPORT = "fabric_EthMonDestEp_transport"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_TYPE = "fabric_EthMonDestEp_type"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_USR_LBL = "fabric_EthMonDestEp_usrLbl"
    SORT_PROP_FABRIC_ETH_MON_DEST_EP_WARNINGS = "fabric_EthMonDestEp_warnings"
    SORT_PROP_FABRIC_ETH_MON_LAN_ID = "fabric_EthMonLan_id"
    SORT_PROP_FABRIC_ETH_MON_LAN_LOCALE = "fabric_EthMonLan_locale"
    SORT_PROP_FABRIC_ETH_MON_LAN_NAME = "fabric_EthMonLan_name"
    SORT_PROP_FABRIC_ETH_MON_LAN_TRANSPORT = "fabric_EthMonLan_transport"
    SORT_PROP_FABRIC_ETH_MON_LAN_TYPE = "fabric_EthMonLan_type"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_STAGE_DESCR = "fabric_EthMonOperationFsmStage_descr"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_STAGE_LAST_UPDATE_TIME = "fabric_EthMonOperationFsmStage_lastUpdateTime"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_STAGE_NAME = "fabric_EthMonOperationFsmStage_name"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_STAGE_ORDER = "fabric_EthMonOperationFsmStage_order"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_STAGE_RETRY = "fabric_EthMonOperationFsmStage_retry"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_STAGE_STAGE_STATUS = "fabric_EthMonOperationFsmStage_stageStatus"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_COMPLETION_TIME = "fabric_EthMonOperationFsm_completionTime"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_CURRENT_FSM = "fabric_EthMonOperationFsm_currentFsm"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_DESCR = "fabric_EthMonOperationFsm_descr"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_FSM_INSTANCE_ID = "fabric_EthMonOperationFsm_fsmInstanceId"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_FSM_STATUS = "fabric_EthMonOperationFsm_fsmStatus"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_PROGRESS = "fabric_EthMonOperationFsm_progress"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_RMT_ERR_CODE = "fabric_EthMonOperationFsm_rmtErrCode"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_RMT_ERR_DESCR = "fabric_EthMonOperationFsm_rmtErrDescr"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_RMT_RSLT = "fabric_EthMonOperationFsm_rmtRslt"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_ADMIN_STATE = "fabric_EthMonOperation_adminState"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_CONFIG_FAIL_REASON = "fabric_EthMonOperation_configFailReason"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_EP_DN = "fabric_EthMonOperation_epDn"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_DESCR = "fabric_EthMonOperation_fsmDescr"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_PREV = "fabric_EthMonOperation_fsmPrev"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_PROGR = "fabric_EthMonOperation_fsmProgr"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_RMT_INV_ERR_CODE = "fabric_EthMonOperation_fsmRmtInvErrCode"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_RMT_INV_ERR_DESCR = "fabric_EthMonOperation_fsmRmtInvErrDescr"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_RMT_INV_RSLT = "fabric_EthMonOperation_fsmRmtInvRslt"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_STAGE_DESCR = "fabric_EthMonOperation_fsmStageDescr"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_STAMP = "fabric_EthMonOperation_fsmStamp"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_STATUS = "fabric_EthMonOperation_fsmStatus"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_FSM_TRY = "fabric_EthMonOperation_fsmTry"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_IS_CONFIG_SUCCESS = "fabric_EthMonOperation_isConfigSuccess"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_LAST_MODIFIED = "fabric_EthMonOperation_lastModified"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_NAME = "fabric_EthMonOperation_name"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_OPER_STATE = "fabric_EthMonOperation_operState"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_OPER_STATE_REASON = "fabric_EthMonOperation_operStateReason"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_PEER_DN = "fabric_EthMonOperation_peerDn"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_REMOTE_ERROR_CODE = "fabric_EthMonOperation_remoteErrorCode"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_REMOTE_ERROR_DESCR = "fabric_EthMonOperation_remoteErrorDescr"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_SESSION = "fabric_EthMonOperation_session"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_TRANSPORT = "fabric_EthMonOperation_transport"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_TRIGGER_STATUS = "fabric_EthMonOperation_triggerStatus"
    SORT_PROP_FABRIC_ETH_MON_OPERATION_TYPE = "fabric_EthMonOperation_type"
    SORT_PROP_FABRIC_ETH_MON_SRC_EP_OPERATION_ADMIN_STATE = "fabric_EthMonSrcEpOperation_adminState"
    SORT_PROP_FABRIC_ETH_MON_SRC_EP_OPERATION_DIRECTION = "fabric_EthMonSrcEpOperation_direction"
    SORT_PROP_FABRIC_ETH_MON_SRC_EP_OPERATION_LAST_MODIFIED = "fabric_EthMonSrcEpOperation_lastModified"
    SORT_PROP_FABRIC_ETH_MON_SRC_EP_OPERATION_NAME = "fabric_EthMonSrcEpOperation_name"
    SORT_PROP_FABRIC_ETH_MON_SRC_EP_OPERATION_REMOTE_ERROR_CODE = "fabric_EthMonSrcEpOperation_remoteErrorCode"
    SORT_PROP_FABRIC_ETH_MON_SRC_EP_OPERATION_REMOTE_ERROR_DESCR = "fabric_EthMonSrcEpOperation_remoteErrorDescr"
    SORT_PROP_FABRIC_ETH_MON_SRC_EP_OPERATION_SESSION = "fabric_EthMonSrcEpOperation_session"
    SORT_PROP_FABRIC_ETH_MON_SRC_EP_OPERATION_TRANSPORT = "fabric_EthMonSrcEpOperation_transport"
    SORT_PROP_FABRIC_ETH_MON_SRC_EP_OPERATION_TRIGGER_STATUS = "fabric_EthMonSrcEpOperation_triggerStatus"
    SORT_PROP_FABRIC_ETH_MON_SRC_EP_OPERATION_TYPE = "fabric_EthMonSrcEpOperation_type"
    SORT_PROP_FABRIC_ETH_MON_SRC_EP_DIRECTION = "fabric_EthMonSrcEp_direction"
    SORT_PROP_FABRIC_ETH_MON_SRC_EP_NAME = "fabric_EthMonSrcEp_name"
    SORT_PROP_FABRIC_ETH_MON_SRC_EP_SESSION = "fabric_EthMonSrcEp_session"
    SORT_PROP_FABRIC_ETH_MON_SRC_EP_TRANSPORT = "fabric_EthMonSrcEp_transport"
    SORT_PROP_FABRIC_ETH_MON_SRC_EP_TYPE = "fabric_EthMonSrcEp_type"
    SORT_PROP_FABRIC_ETH_MON_SRC_REF_ID = "fabric_EthMonSrcRef_id"
    SORT_PROP_FABRIC_ETH_MON_SRC_REF_SOURCE_DN = "fabric_EthMonSrcRef_sourceDn"
    SORT_PROP_FABRIC_ETH_MON_SRC_REF_SOURCE_TYPE = "fabric_EthMonSrcRef_sourceType"
    SORT_PROP_FABRIC_ETH_MON_SRC_REF_TYPE = "fabric_EthMonSrcRef_type"
    SORT_PROP_FABRIC_ETH_MON_ADMIN_STATE = "fabric_EthMon_adminState"
    SORT_PROP_FABRIC_ETH_MON_CONFIG_FAIL_REASON = "fabric_EthMon_configFailReason"
    SORT_PROP_FABRIC_ETH_MON_ID = "fabric_EthMon_id"
    SORT_PROP_FABRIC_ETH_MON_IS_CONFIG_SUCCESS = "fabric_EthMon_isConfigSuccess"
    SORT_PROP_FABRIC_ETH_MON_LOCALE = "fabric_EthMon_locale"
    SORT_PROP_FABRIC_ETH_MON_NAME = "fabric_EthMon_name"
    SORT_PROP_FABRIC_ETH_MON_OPER_STATE = "fabric_EthMon_operState"
    SORT_PROP_FABRIC_ETH_MON_OPER_STATE_REASON = "fabric_EthMon_operStateReason"
    SORT_PROP_FABRIC_ETH_MON_PEER_DN = "fabric_EthMon_peerDn"
    SORT_PROP_FABRIC_ETH_MON_SESSION = "fabric_EthMon_session"
    SORT_PROP_FABRIC_ETH_MON_TRANSPORT = "fabric_EthMon_transport"
    SORT_PROP_FABRIC_ETH_MON_TYPE = "fabric_EthMon_type"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_STAGE_DESCR = "fabric_EthPortOperationFsmStage_descr"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_STAGE_LAST_UPDATE_TIME = "fabric_EthPortOperationFsmStage_lastUpdateTime"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_STAGE_NAME = "fabric_EthPortOperationFsmStage_name"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_STAGE_ORDER = "fabric_EthPortOperationFsmStage_order"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_STAGE_RETRY = "fabric_EthPortOperationFsmStage_retry"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_STAGE_STAGE_STATUS = "fabric_EthPortOperationFsmStage_stageStatus"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_COMPLETION_TIME = "fabric_EthPortOperationFsm_completionTime"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_CURRENT_FSM = "fabric_EthPortOperationFsm_currentFsm"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_DESCR = "fabric_EthPortOperationFsm_descr"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_FSM_INSTANCE_ID = "fabric_EthPortOperationFsm_fsmInstanceId"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_FSM_STATUS = "fabric_EthPortOperationFsm_fsmStatus"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_PROGRESS = "fabric_EthPortOperationFsm_progress"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_RMT_ERR_CODE = "fabric_EthPortOperationFsm_rmtErrCode"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_RMT_ERR_DESCR = "fabric_EthPortOperationFsm_rmtErrDescr"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_RMT_RSLT = "fabric_EthPortOperationFsm_rmtRslt"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_DESCR = "fabric_EthPortOperation_fsmDescr"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_PREV = "fabric_EthPortOperation_fsmPrev"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_PROGR = "fabric_EthPortOperation_fsmProgr"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_RMT_INV_ERR_CODE = "fabric_EthPortOperation_fsmRmtInvErrCode"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_RMT_INV_ERR_DESCR = "fabric_EthPortOperation_fsmRmtInvErrDescr"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_RMT_INV_RSLT = "fabric_EthPortOperation_fsmRmtInvRslt"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_STAGE_DESCR = "fabric_EthPortOperation_fsmStageDescr"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_STAMP = "fabric_EthPortOperation_fsmStamp"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_STATUS = "fabric_EthPortOperation_fsmStatus"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_FSM_TRY = "fabric_EthPortOperation_fsmTry"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_LAST_MODIFIED = "fabric_EthPortOperation_lastModified"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_REMOTE_ERROR_CODE = "fabric_EthPortOperation_remoteErrorCode"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_REMOTE_ERROR_DESCR = "fabric_EthPortOperation_remoteErrorDescr"
    SORT_PROP_FABRIC_ETH_PORT_OPERATION_TRIGGER_STATUS = "fabric_EthPortOperation_triggerStatus"
    SORT_PROP_FABRIC_ETH_TARGET_EP_OPERATION_EP_DN = "fabric_EthTargetEpOperation_epDn"
    SORT_PROP_FABRIC_ETH_TARGET_EP_OPERATION_LAST_MODIFIED = "fabric_EthTargetEpOperation_lastModified"
    SORT_PROP_FABRIC_ETH_TARGET_EP_OPERATION_MAC_ADDRESS = "fabric_EthTargetEpOperation_macAddress"
    SORT_PROP_FABRIC_ETH_TARGET_EP_OPERATION_NAME = "fabric_EthTargetEpOperation_name"
    SORT_PROP_FABRIC_ETH_TARGET_EP_OPERATION_REMOTE_ERROR_CODE = "fabric_EthTargetEpOperation_remoteErrorCode"
    SORT_PROP_FABRIC_ETH_TARGET_EP_OPERATION_REMOTE_ERROR_DESCR = "fabric_EthTargetEpOperation_remoteErrorDescr"
    SORT_PROP_FABRIC_ETH_TARGET_EP_OPERATION_TRIGGER_STATUS = "fabric_EthTargetEpOperation_triggerStatus"
    SORT_PROP_FABRIC_ETH_TARGET_EP_ADMIN_STATE = "fabric_EthTargetEp_adminState"
    SORT_PROP_FABRIC_ETH_TARGET_EP_AGGR_PORT_ID = "fabric_EthTargetEp_aggrPortId"
    SORT_PROP_FABRIC_ETH_TARGET_EP_AUTO_NEGOTIATE = "fabric_EthTargetEp_autoNegotiate"
    SORT_PROP_FABRIC_ETH_TARGET_EP_CHASSIS_ID = "fabric_EthTargetEp_chassisId"
    SORT_PROP_FABRIC_ETH_TARGET_EP_EP_DN = "fabric_EthTargetEp_epDn"
    SORT_PROP_FABRIC_ETH_TARGET_EP_FLT_AGGR = "fabric_EthTargetEp_fltAggr"
    SORT_PROP_FABRIC_ETH_TARGET_EP_IF_ROLE = "fabric_EthTargetEp_ifRole"
    SORT_PROP_FABRIC_ETH_TARGET_EP_IF_TYPE = "fabric_EthTargetEp_ifType"
    SORT_PROP_FABRIC_ETH_TARGET_EP_LIC_GP = "fabric_EthTargetEp_licGP"
    SORT_PROP_FABRIC_ETH_TARGET_EP_LIC_STATE = "fabric_EthTargetEp_licState"
    SORT_PROP_FABRIC_ETH_TARGET_EP_LOCALE = "fabric_EthTargetEp_locale"
    SORT_PROP_FABRIC_ETH_TARGET_EP_MAC_ADDRESS = "fabric_EthTargetEp_macAddress"
    SORT_PROP_FABRIC_ETH_TARGET_EP_NAME = "fabric_EthTargetEp_name"
    SORT_PROP_FABRIC_ETH_TARGET_EP_OPER_STATE = "fabric_EthTargetEp_operState"
    SORT_PROP_FABRIC_ETH_TARGET_EP_OPER_STATE_REASON = "fabric_EthTargetEp_operStateReason"
    SORT_PROP_FABRIC_ETH_TARGET_EP_PEER_AGGR_PORT_ID = "fabric_EthTargetEp_peerAggrPortId"
    SORT_PROP_FABRIC_ETH_TARGET_EP_PEER_CHASSIS_ID = "fabric_EthTargetEp_peerChassisId"
    SORT_PROP_FABRIC_ETH_TARGET_EP_PEER_DN = "fabric_EthTargetEp_peerDn"
    SORT_PROP_FABRIC_ETH_TARGET_EP_PEER_PORT_ID = "fabric_EthTargetEp_peerPortId"
    SORT_PROP_FABRIC_ETH_TARGET_EP_PEER_SLOT_ID = "fabric_EthTargetEp_peerSlotId"
    SORT_PROP_FABRIC_ETH_TARGET_EP_PORT_ID = "fabric_EthTargetEp_portId"
    SORT_PROP_FABRIC_ETH_TARGET_EP_SLOT_ID = "fabric_EthTargetEp_slotId"
    SORT_PROP_FABRIC_ETH_TARGET_EP_SWITCH_ID = "fabric_EthTargetEp_switchId"
    SORT_PROP_FABRIC_ETH_TARGET_EP_TRANSPORT = "fabric_EthTargetEp_transport"
    SORT_PROP_FABRIC_ETH_TARGET_EP_TYPE = "fabric_EthTargetEp_type"
    SORT_PROP_FABRIC_ETH_TARGET_EP_USR_LBL = "fabric_EthTargetEp_usrLbl"
    SORT_PROP_FABRIC_ETH_TARGET_EP_WARNINGS = "fabric_EthTargetEp_warnings"
    SORT_PROP_FABRIC_ETH_UDLD_POLICY_DESCR = "fabric_EthUdldPolicy_descr"
    SORT_PROP_FABRIC_ETH_UDLD_POLICY_INT_ID = "fabric_EthUdldPolicy_intId"
    SORT_PROP_FABRIC_ETH_UDLD_POLICY_NAME = "fabric_EthUdldPolicy_name"
    SORT_PROP_FABRIC_ETH_UDLD_POLICY_POLICY_LEVEL = "fabric_EthUdldPolicy_policyLevel"
    SORT_PROP_FABRIC_ETH_UDLD_POLICY_POLICY_OWNER = "fabric_EthUdldPolicy_policyOwner"
    SORT_PROP_FABRIC_ETH_UDLD_POLICY_PROTOCOL = "fabric_EthUdldPolicy_protocol"
    SORT_PROP_FABRIC_ETH_UDLD_POLICY_TYPE = "fabric_EthUdldPolicy_type"
    SORT_PROP_FABRIC_ETH_VLAN_PC_ADMIN_SPEED = "fabric_EthVlanPc_adminSpeed"
    SORT_PROP_FABRIC_ETH_VLAN_PC_ADMIN_STATE = "fabric_EthVlanPc_adminState"
    SORT_PROP_FABRIC_ETH_VLAN_PC_DESCR = "fabric_EthVlanPc_descr"
    SORT_PROP_FABRIC_ETH_VLAN_PC_EP_DN = "fabric_EthVlanPc_epDn"
    SORT_PROP_FABRIC_ETH_VLAN_PC_FLT_AGGR = "fabric_EthVlanPc_fltAggr"
    SORT_PROP_FABRIC_ETH_VLAN_PC_IF_ROLE = "fabric_EthVlanPc_ifRole"
    SORT_PROP_FABRIC_ETH_VLAN_PC_IF_TYPE = "fabric_EthVlanPc_ifType"
    SORT_PROP_FABRIC_ETH_VLAN_PC_IS_NATIVE = "fabric_EthVlanPc_isNative"
    SORT_PROP_FABRIC_ETH_VLAN_PC_LOCALE = "fabric_EthVlanPc_locale"
    SORT_PROP_FABRIC_ETH_VLAN_PC_NAME = "fabric_EthVlanPc_name"
    SORT_PROP_FABRIC_ETH_VLAN_PC_OPER_SPEED = "fabric_EthVlanPc_operSpeed"
    SORT_PROP_FABRIC_ETH_VLAN_PC_OPER_STATE = "fabric_EthVlanPc_operState"
    SORT_PROP_FABRIC_ETH_VLAN_PC_PEER_DN = "fabric_EthVlanPc_peerDn"
    SORT_PROP_FABRIC_ETH_VLAN_PC_PORT_ID = "fabric_EthVlanPc_portId"
    SORT_PROP_FABRIC_ETH_VLAN_PC_STATE_QUAL = "fabric_EthVlanPc_stateQual"
    SORT_PROP_FABRIC_ETH_VLAN_PC_SWITCH_ID = "fabric_EthVlanPc_switchId"
    SORT_PROP_FABRIC_ETH_VLAN_PC_TRANSPORT = "fabric_EthVlanPc_transport"
    SORT_PROP_FABRIC_ETH_VLAN_PC_TYPE = "fabric_EthVlanPc_type"
    SORT_PROP_FABRIC_ETH_VLAN_PC_WARNINGS = "fabric_EthVlanPc_warnings"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_ADMIN_STATE = "fabric_EthVlanPortEp_adminState"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_AGGR_PORT_ID = "fabric_EthVlanPortEp_aggrPortId"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_AUTO_NEGOTIATE = "fabric_EthVlanPortEp_autoNegotiate"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_CHASSIS_ID = "fabric_EthVlanPortEp_chassisId"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_EP_DN = "fabric_EthVlanPortEp_epDn"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_FLT_AGGR = "fabric_EthVlanPortEp_fltAggr"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_IF_ROLE = "fabric_EthVlanPortEp_ifRole"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_IF_TYPE = "fabric_EthVlanPortEp_ifType"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_IS_NATIVE = "fabric_EthVlanPortEp_isNative"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_LIC_GP = "fabric_EthVlanPortEp_licGP"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_LIC_STATE = "fabric_EthVlanPortEp_licState"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_LOCALE = "fabric_EthVlanPortEp_locale"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_NAME = "fabric_EthVlanPortEp_name"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_OPER_STATE = "fabric_EthVlanPortEp_operState"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_OPER_STATE_REASON = "fabric_EthVlanPortEp_operStateReason"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_PEER_AGGR_PORT_ID = "fabric_EthVlanPortEp_peerAggrPortId"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_PEER_CHASSIS_ID = "fabric_EthVlanPortEp_peerChassisId"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_PEER_DN = "fabric_EthVlanPortEp_peerDn"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_PEER_PORT_ID = "fabric_EthVlanPortEp_peerPortId"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_PEER_SLOT_ID = "fabric_EthVlanPortEp_peerSlotId"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_PORT_ID = "fabric_EthVlanPortEp_portId"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_SLOT_ID = "fabric_EthVlanPortEp_slotId"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_SWITCH_ID = "fabric_EthVlanPortEp_switchId"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_TRANSPORT = "fabric_EthVlanPortEp_transport"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_TYPE = "fabric_EthVlanPortEp_type"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_USR_LBL = "fabric_EthVlanPortEp_usrLbl"
    SORT_PROP_FABRIC_ETH_VLAN_PORT_EP_WARNINGS = "fabric_EthVlanPortEp_warnings"
    SORT_PROP_FABRIC_ETHER_REF_CLIENT_ID = "fabric_EtherRef_clientId"
    SORT_PROP_FABRIC_ETHER_REF_LC_CTRL_STATE = "fabric_EtherRef_lcCtrlState"
    SORT_PROP_FABRIC_ETHER_REF_NAME = "fabric_EtherRef_name"
    SORT_PROP_FABRIC_ETHER_REF_OPER_ETH_DN = "fabric_EtherRef_operEthDn"
    SORT_PROP_FABRIC_EXTENSION_DESCRIPTION = "fabric_Extension_description"
    SORT_PROP_FABRIC_EXTERNAL_EP_ADMIN_STATE = "fabric_ExternalEp_adminState"
    SORT_PROP_FABRIC_EXTERNAL_EP_AGGR_PORT_ID = "fabric_ExternalEp_aggrPortId"
    SORT_PROP_FABRIC_EXTERNAL_EP_AUTO_NEGOTIATE = "fabric_ExternalEp_autoNegotiate"
    SORT_PROP_FABRIC_EXTERNAL_EP_CHASSIS_ID = "fabric_ExternalEp_chassisId"
    SORT_PROP_FABRIC_EXTERNAL_EP_EP_DN = "fabric_ExternalEp_epDn"
    SORT_PROP_FABRIC_EXTERNAL_EP_FLT_AGGR = "fabric_ExternalEp_fltAggr"
    SORT_PROP_FABRIC_EXTERNAL_EP_IF_ROLE = "fabric_ExternalEp_ifRole"
    SORT_PROP_FABRIC_EXTERNAL_EP_IF_TYPE = "fabric_ExternalEp_ifType"
    SORT_PROP_FABRIC_EXTERNAL_EP_LIC_GP = "fabric_ExternalEp_licGP"
    SORT_PROP_FABRIC_EXTERNAL_EP_LIC_STATE = "fabric_ExternalEp_licState"
    SORT_PROP_FABRIC_EXTERNAL_EP_LOCALE = "fabric_ExternalEp_locale"
    SORT_PROP_FABRIC_EXTERNAL_EP_NAME = "fabric_ExternalEp_name"
    SORT_PROP_FABRIC_EXTERNAL_EP_OPER_STATE = "fabric_ExternalEp_operState"
    SORT_PROP_FABRIC_EXTERNAL_EP_OPER_STATE_REASON = "fabric_ExternalEp_operStateReason"
    SORT_PROP_FABRIC_EXTERNAL_EP_PEER_AGGR_PORT_ID = "fabric_ExternalEp_peerAggrPortId"
    SORT_PROP_FABRIC_EXTERNAL_EP_PEER_CHASSIS_ID = "fabric_ExternalEp_peerChassisId"
    SORT_PROP_FABRIC_EXTERNAL_EP_PEER_DN = "fabric_ExternalEp_peerDn"
    SORT_PROP_FABRIC_EXTERNAL_EP_PEER_PORT_ID = "fabric_ExternalEp_peerPortId"
    SORT_PROP_FABRIC_EXTERNAL_EP_PEER_SLOT_ID = "fabric_ExternalEp_peerSlotId"
    SORT_PROP_FABRIC_EXTERNAL_EP_PORT_ID = "fabric_ExternalEp_portId"
    SORT_PROP_FABRIC_EXTERNAL_EP_SLOT_ID = "fabric_ExternalEp_slotId"
    SORT_PROP_FABRIC_EXTERNAL_EP_SWITCH_ID = "fabric_ExternalEp_switchId"
    SORT_PROP_FABRIC_EXTERNAL_EP_TRANSPORT = "fabric_ExternalEp_transport"
    SORT_PROP_FABRIC_EXTERNAL_EP_TYPE = "fabric_ExternalEp_type"
    SORT_PROP_FABRIC_EXTERNAL_EP_USR_LBL = "fabric_ExternalEp_usrLbl"
    SORT_PROP_FABRIC_EXTERNAL_EP_WARNINGS = "fabric_ExternalEp_warnings"
    SORT_PROP_FABRIC_EXTERNAL_ESTC_ID = "fabric_ExternalEstc_id"
    SORT_PROP_FABRIC_EXTERNAL_ESTC_LOCALE = "fabric_ExternalEstc_locale"
    SORT_PROP_FABRIC_EXTERNAL_ESTC_NAME = "fabric_ExternalEstc_name"
    SORT_PROP_FABRIC_EXTERNAL_ESTC_TRANSPORT = "fabric_ExternalEstc_transport"
    SORT_PROP_FABRIC_EXTERNAL_ESTC_TYPE = "fabric_ExternalEstc_type"
    SORT_PROP_FABRIC_EXTERNAL_PC_ADMIN_STATE = "fabric_ExternalPc_adminState"
    SORT_PROP_FABRIC_EXTERNAL_PC_DESCR = "fabric_ExternalPc_descr"
    SORT_PROP_FABRIC_EXTERNAL_PC_EP_DN = "fabric_ExternalPc_epDn"
    SORT_PROP_FABRIC_EXTERNAL_PC_FLT_AGGR = "fabric_ExternalPc_fltAggr"
    SORT_PROP_FABRIC_EXTERNAL_PC_IF_ROLE = "fabric_ExternalPc_ifRole"
    SORT_PROP_FABRIC_EXTERNAL_PC_IF_TYPE = "fabric_ExternalPc_ifType"
    SORT_PROP_FABRIC_EXTERNAL_PC_LOCALE = "fabric_ExternalPc_locale"
    SORT_PROP_FABRIC_EXTERNAL_PC_NAME = "fabric_ExternalPc_name"
    SORT_PROP_FABRIC_EXTERNAL_PC_OPER_STATE = "fabric_ExternalPc_operState"
    SORT_PROP_FABRIC_EXTERNAL_PC_PEER_DN = "fabric_ExternalPc_peerDn"
    SORT_PROP_FABRIC_EXTERNAL_PC_PORT_ID = "fabric_ExternalPc_portId"
    SORT_PROP_FABRIC_EXTERNAL_PC_STATE_QUAL = "fabric_ExternalPc_stateQual"
    SORT_PROP_FABRIC_EXTERNAL_PC_SWITCH_ID = "fabric_ExternalPc_switchId"
    SORT_PROP_FABRIC_EXTERNAL_PC_TRANSPORT = "fabric_ExternalPc_transport"
    SORT_PROP_FABRIC_EXTERNAL_PC_TYPE = "fabric_ExternalPc_type"
    SORT_PROP_FABRIC_EXTERNAL_PC_WARNINGS = "fabric_ExternalPc_warnings"
    SORT_PROP_FABRIC_EXTERNAL_ID = "fabric_External_id"
    SORT_PROP_FABRIC_EXTERNAL_LOCALE = "fabric_External_locale"
    SORT_PROP_FABRIC_EXTERNAL_NAME = "fabric_External_name"
    SORT_PROP_FABRIC_EXTERNAL_TRANSPORT = "fabric_External_transport"
    SORT_PROP_FABRIC_EXTERNAL_TYPE = "fabric_External_type"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_STAGE_DESCR = "fabric_FIPortOperationFsmStage_descr"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_STAGE_LAST_UPDATE_TIME = "fabric_FIPortOperationFsmStage_lastUpdateTime"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_STAGE_NAME = "fabric_FIPortOperationFsmStage_name"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_STAGE_ORDER = "fabric_FIPortOperationFsmStage_order"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_STAGE_RETRY = "fabric_FIPortOperationFsmStage_retry"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_STAGE_STAGE_STATUS = "fabric_FIPortOperationFsmStage_stageStatus"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_TASK_COMPLETION = "fabric_FIPortOperationFsmTask_completion"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_TASK_FLAGS = "fabric_FIPortOperationFsmTask_flags"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_TASK_ITEM = "fabric_FIPortOperationFsmTask_item"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_TASK_SEQ_ID = "fabric_FIPortOperationFsmTask_seqId"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_COMPLETION_TIME = "fabric_FIPortOperationFsm_completionTime"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_CURRENT_FSM = "fabric_FIPortOperationFsm_currentFsm"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_DESCR = "fabric_FIPortOperationFsm_descr"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_FSM_INSTANCE_ID = "fabric_FIPortOperationFsm_fsmInstanceId"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_FSM_STATUS = "fabric_FIPortOperationFsm_fsmStatus"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_PROGRESS = "fabric_FIPortOperationFsm_progress"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_RMT_ERR_CODE = "fabric_FIPortOperationFsm_rmtErrCode"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_RMT_ERR_DESCR = "fabric_FIPortOperationFsm_rmtErrDescr"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_RMT_RSLT = "fabric_FIPortOperationFsm_rmtRslt"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_DESCR = "fabric_FIPortOperation_fsmDescr"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_PREV = "fabric_FIPortOperation_fsmPrev"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_PROGR = "fabric_FIPortOperation_fsmProgr"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_RMT_INV_ERR_CODE = "fabric_FIPortOperation_fsmRmtInvErrCode"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_RMT_INV_ERR_DESCR = "fabric_FIPortOperation_fsmRmtInvErrDescr"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_RMT_INV_RSLT = "fabric_FIPortOperation_fsmRmtInvRslt"
    SORT_PROP_FABRIC_FIPORT_OPERATION_FSM_STAGE_DESCR = "fabric_FIPortOperation_fsmStageDescr"
    SORT_PROP_FABRIC