from Fortuna import TruffleShuffle, QuantumMonty
from DungeonGenerator.player_lib import Fighter, Paladin, Barbarian, Wizard, Sorcerer, Warlock
from DungeonGenerator.player_lib import Cleric, Druid, Bard, Rogue, Ranger, Monk


random_human = QuantumMonty((
    "Human: Peasant",
    "Human: Villager",
    "Human: Highborn",
    "Human: Outcast",
    "Human: Noble",
    "Human: Outlaw",
    "Human: Royal",
)).front_gauss

npc_dict = {
    'farm_professions': (
        "Bean Farmer", "Grain Farmer", "Vegetable Farmer", "Fruit Farmer", "Pig Farmer",
        "Rancher", "Stable Hand", "Horse Trainer", "Cook", "Ranch Hand", "Rat Catcher",
        "Vagabond", "Weed Farmer", "Bee Keeper", "Worm Farmer", "Gong Farmer", "Maid",
        "Footman", "Servant", "Beggar", "Piss Boy", "Sin Eater", "Town Crier", "Grave Digger",
        "Ditch Digger", "Thug", 'Gypsy', "Nerf Herder", 'Messenger', 'Midwife', 'Milkmaid', 'Miner', 'Minstrel',
        'Peddler', 'Student',
    ),
    'quests': (
        'Perform a rescue mission',
        'Recover a legendary artifact',
        'Remove a powerful curse',
        'Defend a castle from invasion',
        'Spy on a villain',
        'Lay siege to an enemy castle',
        'Restore the family name',
        'Investigate a murder',
        'Solve a riddle',
        'Stop an execution',
        'Locate a missing family member',
        'Break someone out of jail',
        'Preform an ancient ritual to save an endangered species',
        'Communicate with the dead',
        'Recover stolen artwork or heirloom',
        'Give safe passage',
    ),
    'npc_classes': (
        Fighter, Paladin, Barbarian,
        Wizard,
        Sorcerer, Warlock, Bard,
        Cleric, Druid,
        Rogue, Ranger, Monk,
    ),
    'races': (
        random_human, "Mountain Dwarf", "Hill Dwarf", "Shout Halfling",
        "Lightfoot Halfling", "Forest Gnome", "Rock Gnome", "High Elf", "Wood Elf", "Half-elf", "Drow", "Half-orc",
        "Tiefling", "Dragonborn",
    ),
    'appearances': (
        "Distinctive jewelry", "Piercings", "Flamboyant or outlandish clothes", "Formal, clean clothes",
        "Ragged, dirty clothes", "Pronounced scar", "Missing teeth", "Missing fingers", "Unusual eye color", "Tattoos",
        "Birthmark", "Unusual skin color", "Bald", "Braided beard or hair", "Unusual hair color", "Nervous eye twitch",
        "Distinctive nose", "Exceptionally ugly", "Distinctive posture", "Exceptionally beautiful",
    ),
    'talents': (
        "Plays a musical instrument", "Speaks several languages fluently", "Unbelievably lucky",
        "Perfect memory",
        "Great with animals", "Great with children", "Great at solving puzzles", "Great at games",
        "Great at impersonations", "Draws beautifully", "Paints beautifully", "Sings beautifully",
        "Drinks everyone under the table", "Expert carpenter", "Expert cook",
        "Expert dart thrower and rock skipper", "Expert juggler", "Skilled actor and master of disguise",
        "Skilled dancer", "Knows thieves' cant",
    ),
    'mannerisms': (
        "Prone to singing", "Prone to whistling", "Prone to humming quietly",
        "Speaks in rhyme", "Speaks in some peculiar way",
        "Particularly low booming voice", "High-pitched screechy voice", "Slurs words",
        "Enunciates overly clearly", "Speaks with a lisp", "Speaks with a stutter",
        "Speaks loudly", "Whispers", "Uses flowery speech", "Uses unnecessarily long words",
        "Frequently uses the wrong word", "Uses colorful oaths and exclamations", "Makes constant jokes or puns",
        "Prone to predictions of doom", "Fidgets", "Squints", "Stares into the distance", "Chews something",
        "Paces", "Taps fingers", "Bites fingernails", "Twirls hair or tugs beard",
    ),
    'traits': (
        "Argumentative", "Arrogant", "Blustering", "Rude", "Curious", "Friendly", "Brutally Honest", "Hot tempered",
        "Irritable", "Ponderous", "Quiet", "Suspicious", "Nervous",
    ),
    'skills': {
        'STR': ("Athletics STR", "Heavy Lifting STR"),
        'DEX': ("Acrobatics DEX", "Sleight of Hand DEX", "Stealth DEX", "Reflex DEX"),
        'INT': ("Arcana INT", "History INT", "Investigation INT", "Nature INT", "Religion INT",
                "Inspect Merchandise INT"),
        'WIS': ("Animal Handling WIS", "Insight WIS", "Medicine WIS", "Perception WIS", "Survival WIS"),
        'CHA': ("Deception CHA", "Intimidation CHA", "Performance CHA", "Persuasion CHA"),
        'CON': ("Endurance CON", "Fortitude CON")
    },
    'bonds': (
        "Dedicated to fulfilling a personal life goal", "Protective of close family members",
        "Protective of colleagues or compatriots", "Loyal to a benefactor, patron, or employer",
        "Captivated by a romantic interest", "Drawn to a special place", "Protective of a sentimental keepsake",
        "Protective of a valuable possession", "Out for revenge",
    ),
    'flaws': (
        "Forbidden love or susceptibility to romance", "Enjoys decadent pleasures", "Arrogance",
        "Envies another creature's possessions or station", "Overpowering greed", "Prone to rage",
        "Has a powerful enemy", "Specific phobia", "Shameful or scandalous history", "Secret crime or misdeed",
        "Knowledge of forbidden lore", "Foolhardy bravery",
    ),
    'trinkets': (
        'a dead scarab beetle', 'a toy soldier with a missing head', 'a small box filled with buttons',
        "a candle that can't be lit", 'a tiny cage with no door', 'an old key', 'an indecipherable treasure map',
        'a hilt from a broken sword', "a rabbit's foot", 'a glass eye', 'a cameo in the likeness of a famous person',
        'a silver skull the size of a coin', 'an alabaster mask', 'a pyramid of black incense',
        'a nightcap of pleasant dreams', 'a single caltrop made from bone', 'a gold monocle frame without the lens',
        'a 1-inch cube, each side painted a different color', 'a crystal knob from a door',
        'a small packet filled with pink dust', 'a fragment of a beautiful song, written on parchment',
        'a silver teardrop earring made from a real teardrop', 'the shell of an egg painted with wildlife scenes',
        'a fan that, when unfolded, shows a sleeping cat', 'a set of bone bagpipes',
        'a four-leaf clover pressed inside a book', 'a drawing of a complex mechanical contraption',
        'an ornate scabbard that fits no blade you have found so far',
        'an invitation to a party where a murder happened',
        'a bronze pentacle with an etching of an animal in its center',
        'a purple handkerchief embroidered with the name zarn the great and powerful',
        'a floor plan for a temple, castle, or some other structure',
        'a bit of folded cloth that, when unfolded, turns into a stylish cap',
        'a receipt of deposit at a bank in a far-flung city', 'a diary with seven missing pages',
        'an empty silver snuffbox', 'an iron holy symbol devoted to an unknown god',
        "a book that tells the story of a legendary hero", 'a vial of dragon blood',
        'an ancient arrow of elven design', 'a needle that never bends', 'an ornate brooch of dwarven design',
        'an empty wine bottle bearing a pretty label', 'a mosaic tile with a multicolored, glazed surface',
        'a petrified mouse', "a black pirate flag adorned with a dragon's skull and crossbones",
        "a tiny mechanical spider that moves about when it's not being observed",
        'a glass jar containing lard with a label that reads, "griffon grease"',
        'a wooden box that holds a living worm with a head on each end of its body',
        'a metal urn containing the ashes of a hero'
    ),
    'professions': (
        'Acrobat', 'Animal Trainer', 'Armor Smith', 'Baker', 'Barmaid', 'Barber', 'Bartender',
        'Blacksmith', 'Bookbinder', 'Bowyer Fletcher', 'Brewer', 'Butcher', 'Butler',
        'Candlestick Maker', 'Chef', 'Clerk', 'Jester', 'Courtesan', 'Dancer',
        'Farrier', 'Ferryman', 'Fire Eater', 'Fisherman', 'Fool', 'Fortuneteller', 'Gardener',
        'Gatekeeper', 'Glassblower', 'Hatter', 'Healer', 'Herbalist', 'Innkeeper',
        'Jailer', 'Juggler', 'Lamp Wright', 'Leather Worker', 'Locksmith', 'Lumberjack',
        'Merchant', 'Missionary', 'Mortician', 'Musician', 'Oracle', 'Playwright', 'Poet',
        'Potion Salesman', 'Potter', 'Prostitute', 'Quartermaster',
        'Sailor', 'Scholar', 'Scout', 'Scribe', 'Sculptor', 'Sentry',
        'Ship Captain', 'Shipwright', 'Silver Smith', 'Singer', 'Soldier', 'Songwriter', 'Spice Dealer',
        'Stage Hand', 'Stonemason', 'Storyteller',
        'Tailor', 'Teacher', 'Tracker', 'Trapper', 'Weaver', 'Wet Nurse', 'Wine Vintner', "Weapon Smith",
    ),
    'noble professions': (
        'Actor', 'Artist', 'Alchemist', 'Artificer', 'Astrologer', 'Author', 'Bureaucrat', 'Coin Maker', 'Diplomat',
        'Falconer', 'Gem Cutter', 'Gold Smith', 'Harpist', 'Instrument Maker', 'Inventor', 'Mad Scientist',
        'Professor', 'Council Member', 'Royal Guard', 'Time Keeper', 'Tutor', 'Local Magistrate', 'Jeweler',
    ),
    'treasure': (
        "Alchemy jug", "Bowl of commanding water rand_elemental", "Brazier of commanding fire rand_elemental",
        "Candle of invocation", "Censer of controlling air rand_elemental", "Dust of disappearance",
        "Dust of dryness", "Dust of sneezing and choking", "Efreeti bottle", "Elixir of health",
        "Eversmoking bottle", "Figurine of wondrous power (Bronze griffon)",
        "Figurine of wondrous power (Ebonyfly)", "Figurine of wondrous power (Golden lions)",
        "Figurine of wondrous power (Ivorygoats)", "Figurine of wondrous power (Marble elephant)",
        "Figurine of wondrous power (Onyx dog)", "Figurine of wondrous power (Serpentine owl)",
        "Figurine of wondrous power (obsidian steed)", "Figurine of wondrous power (silver raven)",
        "Stone of controlling earth rand_elemental", "Stone of good luck",
        "Deck of illusions", "Manual of bodily health", "Manual of gainful exercise",
        "Manual of golems", "Manual of quickness of action", "Scroll of protection",
        "Tome of clear thought",
        "Tome of leadership and influence", "Tome of the stilled tongue", "Tome of understanding",
        "Berserker axe", "Dagger of venom", "Dancing sword", "Defender",
        "Dragon slayer", "Dwarven thrower", "Flame tongue", "Frost brand", "Giant slayer",
        "Hammer of thunderbolts", "Holy avenger", "Immovable rod", "Javelin of lightning", "Luck blade",
        "Mace of smiting", "Mace of terror", "Nine lives stealer", "Oath bow", "Quiver of Ehlonna",
        "Rod of absorption", "Rod of alertness", "Rod of lordly might", "Rod of resurrection",
        "Rod of rulership", "Rod of security", "Rod of the pact keeper", "Scimitar of speed",
        "Sphere of annihilation", "Staff of charming", "Staff of fire", "Staff of frost", "Staff of healing",
        "Staff of power", "Staff of striking", "Staff of swarming insects", "Staff of the adder",
        "Staff of the magi", "Staff of the python", "Staff of the woodlands", "Staff of thunder and lightning",
        "Staff of withering", "Sun blade", "Sword of answering", "Sword of life stealing",
        "Sword of sharpness",
        "Sword of vengeance", "Sword of wounding", "Tentacle rod", "Trident of fish command", "Vicious weapon",
        "Vorpal sword", "Wand of binding", "Wand of enemy detection", "Wand of fear", "Wand of fireballs",
        "Wand of lightning bolts", "Wand of magic detection", "Wand of magic missiles", "Wand of paralysis",
        "Wand of polymorph", "Wand of secrets", "Wand of the war mage", "Wand of web", "Wand of wonder",
        "Weapon of warning", "Animated shield", "Armor of invulnerability",
        "Armor of resistance (breastplate)",
        "Armor of resistance (chain mail)", "Armor of resistance (chain shirt)",
        "Armor of resistance (half plate)", "Armor of resistance (leather)",
        "Armor of resistance (scale mail)",
        "Armor of resistance (splint)", "Armor of resistance (studded leather)", "Armor of vulnerability",
        "Arrow-catching shield", "Belt of cloud giant strength", "Belt of dwarvenkind",
        "Belt of fire giant strength", "Belt of frost (or stone) giant strength",
        "Belt of hill giant strength",
        "Belt of storm giant strength", "Boots of elvenkind", "Boots of levitation", "Boots of speed",
        "Boots of striding and springing", "Boots of the winterlands", "Bracers of archery",
        "Bracers of defense", "Cap of water breathing", "Cape of the mountebank", "Circlet of blasting",
        "Cloak of arachnida", "Cloak of displacement", "Cloak of elvenkind", "Cloak of invisibility",
        "Cloak of protection", "Cloak of the manta ray", "Cloak of the bat", "Demon armor", "Dragon scale mail",
        "Dwarven plate", "Elven chain", "Eyes of charming", "Eyes of minute seeing", "Eyes of the eagle",
        "Gauntlets of ogre power", "Glamoured studded leather", "Gloves of missile snaring",
        "Gloves of swimming and climbing", "Gloves of thievery", "Goggles of night", "Hat of disguise",
        "Headband of intellect", "Helm of brilliance", "Helm of comprehending languages", "Helm of telepathy",
        "Helm of teleportation", "Mantle of spell resistance", "Mariner's armor", "Mithral armor",
        "Plate armor of etherealness", "Plate armor of resistance", "Robe of eyes",
        "Robe of scintillating colors", "Robe of stars", "Robe of the archmagi", "Robe of useful items_by_rank",
        "Sentinel shield", "Shield of missile attraction", "Slippers of spider climbing", "Spellguard shield",
        "Winged boots", "Iron bands of Bilarro", "Rope of climbing", "Saddle of the cavalier",
        "Horseshoes of a zephyr", "Horseshoes of speed", "Apparatus of Kwalish", "Bag of beans",
        "Bag of holding", "Broom of flying", "Carpet of flying", "Chime of opening",
        "Crystal ball (very rare version)", "Crystal ball (legendary version)", "Cube of force", "Cubic gate",
        "Daern's instant fortress", "Decanter of endless water", "Dimensional shackles", "Driftglobe",
        "Efreeti chain", "Folding boat", "Heward's handy haversack", "Horn of Valhalla (bronze)",
        "Horn of Valhalla (iron)", "Horn of Valhalla (silver or brass)", "Horn of blasting",
        "Lantern of revealing", "Mirror of life trapping",
        "Pipes of haunting", "Pipes of the sewers", "Portable hole", "Quaal's feather token",
        "Rope of entanglement", "Sending stones", "Well of many worlds", "Wind fan", "Wings of flying",
        "Amulet of health", "Amulet of proof against detection and location", "Amulet of the planes",
        "Brooch of shielding", "Elemental gem", "Gem of brightness", "Gem of seeing", "Medallion of thoughts",
        "Necklace of adaptation", "Necklace of fireballs", "Necklace of prayer beads", "Pearl of power",
        "Periapt of health", "Periapt of proof against poison", "Periapt of wound closure",
        "Ring of X-ray vision", "Ring of air elemental command", "Ring of animal influence",
        "Ring of djinni summoning", "Ring of earth elemental command", "Ring of evasion",
        "Ring of feather falling", "Ring of fire elemental command", "Ring of free action",
        "Ring of invisibility", "Ring of jumping", "Ring of mind shielding", "Ring of protection",
        "Ring of regeneration", "Ring of resistance", "Ring of shooting stars", "Ring of spell storing",
        "Ring of spell turning", "Ring of swimming", "Ring of telekinesis", "Ring of the ram",
        "Ring of three wishes", "Ring of warmth", "Ring of water elemental command", "Ring of water walking",
        "Ring of Fortuna", "Scarab of protection",
    )
}

favorite_trinket = TruffleShuffle(npc_dict['trinkets'])
