"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PrepayInstance = exports.PrepayInstanceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const redis_generated_1 = require("./redis.generated");
Object.defineProperty(exports, "PrepayInstanceProperty", { enumerable: true, get: function () { return redis_generated_1.RosPrepayInstance; } });
/**
 * A ROS resource type:  `ALIYUN::REDIS::PrepayInstance`
 */
class PrepayInstance extends ros.Resource {
    /**
     * Create a new `ALIYUN::REDIS::PrepayInstance`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props = {}, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosPrepayInstance = new redis_generated_1.RosPrepayInstance(this, id, {
            connections: props.connections,
            engineVersion: props.engineVersion,
            resourceGroupId: props.resourceGroupId,
            zoneId: props.zoneId,
            evictionPolicy: props.evictionPolicy,
            vSwitchId: props.vSwitchId,
            securityGroupId: props.securityGroupId,
            productType: props.productType,
            instanceMaintainTime: props.instanceMaintainTime,
            period: props.period === undefined || props.period === null ? 1 : props.period,
            instanceClass: props.instanceClass,
            vpcPasswordFree: props.vpcPasswordFree,
            autoPay: props.autoPay === undefined || props.autoPay === null ? true : props.autoPay,
            secondaryZoneId: props.secondaryZoneId,
            autoRenewDuration: props.autoRenewDuration,
            instanceName: props.instanceName,
            deletionForce: props.deletionForce === undefined || props.deletionForce === null ? false : props.deletionForce,
            sslEnabled: props.sslEnabled,
            vpcId: props.vpcId,
            tags: props.tags,
            periodUnit: props.periodUnit,
            backupPolicy: props.backupPolicy,
            password: props.password,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosPrepayInstance;
        this.attrArchitectureType = rosPrepayInstance.attrArchitectureType;
        this.attrBandwidth = rosPrepayInstance.attrBandwidth;
        this.attrCapacity = rosPrepayInstance.attrCapacity;
        this.attrChargeType = rosPrepayInstance.attrChargeType;
        this.attrClassicInnerConnectionPort = rosPrepayInstance.attrClassicInnerConnectionPort;
        this.attrClassicInnerConnectionString = rosPrepayInstance.attrClassicInnerConnectionString;
        this.attrConnectionDomain = rosPrepayInstance.attrConnectionDomain;
        this.attrConnections = rosPrepayInstance.attrConnections;
        this.attrDirectConnectionPort = rosPrepayInstance.attrDirectConnectionPort;
        this.attrDirectConnectionString = rosPrepayInstance.attrDirectConnectionString;
        this.attrEngineVersion = rosPrepayInstance.attrEngineVersion;
        this.attrHasRenewChangeOrder = rosPrepayInstance.attrHasRenewChangeOrder;
        this.attrInstanceClass = rosPrepayInstance.attrInstanceClass;
        this.attrInstanceId = rosPrepayInstance.attrInstanceId;
        this.attrInstanceName = rosPrepayInstance.attrInstanceName;
        this.attrInstanceType = rosPrepayInstance.attrInstanceType;
        this.attrNetworkType = rosPrepayInstance.attrNetworkType;
        this.attrNodeType = rosPrepayInstance.attrNodeType;
        this.attrOrderId = rosPrepayInstance.attrOrderId;
        this.attrPackageType = rosPrepayInstance.attrPackageType;
        this.attrPort = rosPrepayInstance.attrPort;
        this.attrPrivateIp = rosPrepayInstance.attrPrivateIp;
        this.attrPublicConnectionPort = rosPrepayInstance.attrPublicConnectionPort;
        this.attrPublicConnectionString = rosPrepayInstance.attrPublicConnectionString;
        this.attrQps = rosPrepayInstance.attrQps;
        this.attrResourceGroupId = rosPrepayInstance.attrResourceGroupId;
        this.attrVSwitchId = rosPrepayInstance.attrVSwitchId;
        this.attrVpcId = rosPrepayInstance.attrVpcId;
        this.attrVpcPrivateConnectionPort = rosPrepayInstance.attrVpcPrivateConnectionPort;
        this.attrVpcPrivateConnectionString = rosPrepayInstance.attrVpcPrivateConnectionString;
        this.attrZoneId = rosPrepayInstance.attrZoneId;
    }
}
exports.PrepayInstance = PrepayInstance;
//# sourceMappingURL=data:application/json;base64,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