"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Account = exports.AccountProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const redis_generated_1 = require("./redis.generated");
Object.defineProperty(exports, "AccountProperty", { enumerable: true, get: function () { return redis_generated_1.RosAccount; } });
/**
 * A ROS resource type:  `ALIYUN::REDIS::Account`
 */
class Account extends ros.Resource {
    /**
     * Create a new `ALIYUN::REDIS::Account`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosAccount = new redis_generated_1.RosAccount(this, id, {
            accountDescription: props.accountDescription,
            instanceId: props.instanceId,
            accountPrivilege: props.accountPrivilege,
            accountType: props.accountType === undefined || props.accountType === null ? 'Normal' : props.accountType,
            accountName: props.accountName,
            accountPassword: props.accountPassword,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAccount;
        this.attrAccountName = rosAccount.attrAccountName;
        this.attrInstanceId = rosAccount.attrInstanceId;
    }
}
exports.Account = Account;
//# sourceMappingURL=data:application/json;base64,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