# coding: utf-8

"""
    ODM API

    This swagger page describes the variantUser API endpoints for ODM. These are typically used to find and retrieve variant data and metadata.  Before carrying out any API calls you will need an API token. API tokens can be obtained under your profile within the Genestack software.  To try out calls in this swagger page:  1.  Click the 'Authorize' button below to enter your API token 2.  Scroll to the 'Parameters' section for the method you wish to try out and click the 'Try it out' button 3.  Enter parameter values that you wish to try 4.  Scroll to the bottom of the Parameters section and click the 'Execute' bar that appears    The server response will be in the section that follows.

    The version of the OpenAPI document: default-released
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class ImportExpressionSignalRunRequest(BaseModel):
    """
    ImportExpressionSignalRunRequest
    """ # noqa: E501
    number_of_feature_attributes: Optional[StrictInt] = Field(default=None, description="Integer value that specifies the number of columns related to the feature in the uploaded data frame, and indicates the starting position of the sample data. This attribute is not needed if the uploaded file is in GCT format.", alias="numberOfFeatureAttributes")
    data_class: Optional[StrictStr] = Field(default=None, description="A mandatory parameter with the following possible values: `Bulk transcriptomics`, `Single-cell transcriptomics`, `Differential abundance (FC, pval, etc.)`, `Pathway analysis`, `Proteomics`, `Single-cell proteomics`, `Metabolomics`, `Lipidomics`, `Epigenomics`, `DNA methylation`, `Chemoinformatics`, `Imaging features`, `Gene panel data`, `Biomarker data`, `Physical measures`, `Blood counts`, `Other body fluid counts`, `Nanopore`, `Flow Cytometry (FCS)`, `Document`, `Other`.  In case the parameter is not set the dataClass is automatically defined as `Other`.", alias="dataClass")
    measurement_separator: Optional[StrictStr] = Field(default=None, description="This parameter is necessary when your file contains multiple measurement columns for each sample, library, or preparation. It represents the character that distinguishes the sample/library/preparation name from the measurement name in column headers. Supported separators include `. , : ; _ - / \\ |`, with the allowance for multi-character separators.", alias="measurementSeparator")
    source: Optional[StrictStr] = None
    metadata_link: Optional[StrictStr] = Field(default=None, alias="metadataLink")
    data_link: StrictStr = Field(alias="dataLink")
    template_id: Optional[StrictStr] = Field(default=None, alias="templateId")
    previous_version: Optional[StrictStr] = Field(default=None, alias="previousVersion")
    __properties: ClassVar[List[str]] = ["source", "metadataLink", "dataLink", "templateId", "previousVersion"]

    @field_validator('source')
    def source_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['S3', 'HTTP', 'LOCAL']):
            raise ValueError("must be one of enum values ('S3', 'HTTP', 'LOCAL')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ImportExpressionSignalRunRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ImportExpressionSignalRunRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "source": obj.get("source"),
            "metadataLink": obj.get("metadataLink"),
            "dataLink": obj.get("dataLink"),
            "templateId": obj.get("templateId"),
            "previousVersion": obj.get("previousVersion")
        })
        return _obj


