# coding: utf-8

"""
    ODM API

    This swagger page describes the variantUser API endpoints for ODM. These are typically used to find and retrieve variant data and metadata.  Before carrying out any API calls you will need an API token. API tokens can be obtained under your profile within the Genestack software.  To try out calls in this swagger page:  1.  Click the 'Authorize' button below to enter your API token 2.  Scroll to the 'Parameters' section for the method you wish to try out and click the 'Try it out' button 3.  Enter parameter values that you wish to try 4.  Scroll to the bottom of the Parameters section and click the 'Execute' bar that appears    The server response will be in the section that follows.

    The version of the OpenAPI document: default-released
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from odm_api.models.find_objects_response_objects_page_content_inner import FindObjectsResponseObjectsPageContentInner
from odm_api.models.search_study_request_page import SearchStudyRequestPage
from typing import Optional, Set
from typing_extensions import Self

class FindObjectsResponseObjectsPage(BaseModel):
    """
    FindObjectsResponseObjectsPage
    """ # noqa: E501
    filtered_count: Optional[StrictInt] = Field(default=None, alias="filteredCount")
    page_request: Optional[SearchStudyRequestPage] = Field(default=None, alias="pageRequest")
    content: Optional[List[FindObjectsResponseObjectsPageContentInner]] = None
    __properties: ClassVar[List[str]] = ["filteredCount", "pageRequest", "content"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FindObjectsResponseObjectsPage from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of page_request
        if self.page_request:
            _dict['pageRequest'] = self.page_request.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in content (list)
        _items = []
        if self.content:
            for _item_content in self.content:
                if _item_content:
                    _items.append(_item_content.to_dict())
            _dict['content'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FindObjectsResponseObjectsPage from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "filteredCount": obj.get("filteredCount"),
            "pageRequest": SearchStudyRequestPage.from_dict(obj["pageRequest"]) if obj.get("pageRequest") is not None else None,
            "content": [FindObjectsResponseObjectsPageContentInner.from_dict(_item) for _item in obj["content"]] if obj.get("content") is not None else None
        })
        return _obj


