# coding: utf-8

"""
    ODM API

    This swagger page describes the variantUser API endpoints for ODM. These are typically used to find and retrieve variant data and metadata.  Before carrying out any API calls you will need an API token. API tokens can be obtained under your profile within the Genestack software.  To try out calls in this swagger page:  1.  Click the 'Authorize' button below to enter your API token 2.  Scroll to the 'Parameters' section for the method you wish to try out and click the 'Try it out' button 3.  Enter parameter values that you wish to try 4.  Scroll to the bottom of the Parameters section and click the 'Execute' bar that appears    The server response will be in the section that follows.

    The version of the OpenAPI document: default-released
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from odm_api.models.get_expression_as_curator200_response_feature import GetExpressionAsCurator200ResponseFeature
from odm_api.models.get_expression_as_curator200_response_item_origin import GetExpressionAsCurator200ResponseItemOrigin
from typing import Optional, Set
from typing_extensions import Self

class ExpressionItem(BaseModel):
    """
    ExpressionItem
    """ # noqa: E501
    item_id: Optional[StrictStr] = Field(default=None, alias="itemId")
    item_origin: Optional[GetExpressionAsCurator200ResponseItemOrigin] = Field(default=None, alias="itemOrigin")
    metadata: Optional[Dict[str, Any]] = None
    gene: Optional[StrictStr] = None
    expression: Optional[Union[StrictFloat, StrictInt]] = None
    feature: Optional[GetExpressionAsCurator200ResponseFeature] = None
    value: Optional[Dict[str, Any]] = None
    description: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["itemId", "itemOrigin", "metadata", "gene", "expression", "feature", "value", "description"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExpressionItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "description",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of item_origin
        if self.item_origin:
            _dict['itemOrigin'] = self.item_origin.to_dict()
        # override the default output from pydantic by calling `to_dict()` of feature
        if self.feature:
            _dict['feature'] = self.feature.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExpressionItem from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "itemId": obj.get("itemId"),
            "itemOrigin": GetExpressionAsCurator200ResponseItemOrigin.from_dict(obj["itemOrigin"]) if obj.get("itemOrigin") is not None else None,
            "metadata": obj.get("metadata"),
            "gene": obj.get("gene"),
            "expression": obj.get("expression"),
            "feature": GetExpressionAsCurator200ResponseFeature.from_dict(obj["feature"]) if obj.get("feature") is not None else None,
            "value": obj.get("value"),
            "description": obj.get("description")
        })
        return _obj


