# coding: utf-8

"""
    ODM API

    This swagger page describes the variantUser API endpoints for ODM. These are typically used to find and retrieve variant data and metadata.  Before carrying out any API calls you will need an API token. API tokens can be obtained under your profile within the Genestack software.  To try out calls in this swagger page:  1.  Click the 'Authorize' button below to enter your API token 2.  Scroll to the 'Parameters' section for the method you wish to try out and click the 'Try it out' button 3.  Enter parameter values that you wish to try 4.  Scroll to the bottom of the Parameters section and click the 'Execute' bar that appears    The server response will be in the section that follows.

    The version of the OpenAPI document: default-released
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from odm_api.models.create_group201_response_all_of_meta import CreateGroup201ResponseAllOfMeta
from odm_api.models.create_user_request_emails_inner import CreateUserRequestEmailsInner
from typing import Optional, Set
from typing_extensions import Self

class CreateUser201Response(BaseModel):
    """
    CreateUser201Response
    """ # noqa: E501
    active: StrictBool = Field(description="User status")
    emails: List[CreateUserRequestEmailsInner]
    external_id: Optional[StrictStr] = Field(default=None, description="External unique resource id", alias="externalId")
    id: Optional[StrictStr] = Field(default=None, description="Unique resource id")
    schemas: Optional[List[StrictStr]] = None
    user_name: Optional[StrictStr] = Field(default=None, alias="userName")
    display_name: StrictStr = Field(alias="displayName")
    meta: Optional[CreateGroup201ResponseAllOfMeta] = None
    __properties: ClassVar[List[str]] = ["active", "emails", "externalId", "id", "schemas", "userName", "displayName", "meta"]

    @field_validator('schemas')
    def schemas_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        for i in value:
            if i not in set(['urn:ietf:params:scim:schemas:core:2.0:User']):
                raise ValueError("each list item must be one of ('urn:ietf:params:scim:schemas:core:2.0:User')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateUser201Response from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in emails (list)
        _items = []
        if self.emails:
            for _item_emails in self.emails:
                if _item_emails:
                    _items.append(_item_emails.to_dict())
            _dict['emails'] = _items
        # override the default output from pydantic by calling `to_dict()` of meta
        if self.meta:
            _dict['meta'] = self.meta.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateUser201Response from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "active": obj.get("active"),
            "emails": [CreateUserRequestEmailsInner.from_dict(_item) for _item in obj["emails"]] if obj.get("emails") is not None else None,
            "externalId": obj.get("externalId"),
            "id": obj.get("id"),
            "schemas": obj.get("schemas"),
            "userName": obj.get("userName"),
            "displayName": obj.get("displayName"),
            "meta": CreateGroup201ResponseAllOfMeta.from_dict(obj["meta"]) if obj.get("meta") is not None else None
        })
        return _obj


