# coding: utf-8

"""
    ODM API

    This swagger page describes the variantUser API endpoints for ODM. These are typically used to find and retrieve variant data and metadata.  Before carrying out any API calls you will need an API token. API tokens can be obtained under your profile within the Genestack software.  To try out calls in this swagger page:  1.  Click the 'Authorize' button below to enter your API token 2.  Scroll to the 'Parameters' section for the method you wish to try out and click the 'Try it out' button 3.  Enter parameter values that you wish to try 4.  Scroll to the bottom of the Parameters section and click the 'Execute' bar that appears    The server response will be in the section that follows.

    The version of the OpenAPI document: default-released
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated
from odm_api.models.commit_info import CommitInfo
from odm_api.models.get_variant_as_curator200_response import GetVariantAsCurator200Response
from odm_api.models.list_response import ListResponse
from odm_api.models.response_format import ResponseFormat
from odm_api.models.variant_metadata_with_id import VariantMetadataWithId
from odm_api.models.variant_response import VariantResponse

from odm_api.api_client import ApiClient, RequestSerialized
from odm_api.api_response import ApiResponse
from odm_api.rest import RESTResponseType


class VariantSPoTAsCuratorApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_all_variants_as_curator(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for variant objects via a full text query over all variant metadata. E.g. `dbSNP`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\" in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        variant_region: Annotated[Optional[List[StrictStr]], Field(description="Specify a chromosome interval to find genes between these positions. E.g. `2:233364596-233385916`. Multiple intervals can be provided as a list.")] = None,
        variant_feature: Annotated[Optional[List[StrictStr]], Field(description="Specify the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name, such as `TP53`, variants located within the same genomic region as the specified gene will be retrieved. Multiple genes can be provided as a list.")] = None,
        variant_id: Annotated[Optional[List[StrictStr]], Field(description="One or more specific variation IDs can be specified. E.g. `rs838705`")] = None,
        variant_filter: Annotated[Optional[StrictStr], Field(description="The parameter allows to retrieve gene variants based on the filters defined in the vcf file. If not specified, all variants are returned.    1. pass - return gene variants which passed all filters   2. noPass - return gene variants which failed one or more filters")] = None,
        variant_info: Annotated[Optional[StrictStr], Field(description="Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(info.DB)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries. Combine multiple filters for `INFO` fields using `AND` (`&&`), `OR` (`||`) logical operators and parentheses")] = None,
        run_filter: Annotated[Optional[List[StrictStr]], Field(description="Autogenerated numeric ID that corresponds to a column and is used to link data from the same run to a sample. Multiple values can be provided as a list.")] = None,
        run_source_filter: Annotated[Optional[List[StrictStr]], Field(description="Column name from the file to which all data for a sample is related. Multiple values can be provided as a list to retrieve data from multiple columns.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> VariantResponse:
        """Retrieve multiple variant data and metadata objects

        Retrieve all variant data and metadata objects that match a query.  ## Metadata full-text queries Single words can be supplied as is, otherwise use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type filter: str
        :param query: Search for variant objects via a full text query over all variant metadata. E.g. `dbSNP`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\" in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param variant_region: Specify a chromosome interval to find genes between these positions. E.g. `2:233364596-233385916`. Multiple intervals can be provided as a list.
        :type variant_region: List[str]
        :param variant_feature: Specify the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name, such as `TP53`, variants located within the same genomic region as the specified gene will be retrieved. Multiple genes can be provided as a list.
        :type variant_feature: List[str]
        :param variant_id: One or more specific variation IDs can be specified. E.g. `rs838705`
        :type variant_id: List[str]
        :param variant_filter: The parameter allows to retrieve gene variants based on the filters defined in the vcf file. If not specified, all variants are returned.    1. pass - return gene variants which passed all filters   2. noPass - return gene variants which failed one or more filters
        :type variant_filter: str
        :param variant_info: Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(info.DB)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries. Combine multiple filters for `INFO` fields using `AND` (`&&`), `OR` (`||`) logical operators and parentheses
        :type variant_info: str
        :param run_filter: Autogenerated numeric ID that corresponds to a column and is used to link data from the same run to a sample. Multiple values can be provided as a list.
        :type run_filter: List[str]
        :param run_source_filter: Column name from the file to which all data for a sample is related. Multiple values can be provided as a list to retrieve data from multiple columns.
        :type run_source_filter: List[str]
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param page_limit: Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.
        :type page_limit: int
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_all_variants_as_curator_serialize(
            response_format=response_format,
            filter=filter,
            query=query,
            search_specific_terms=search_specific_terms,
            variant_region=variant_region,
            variant_feature=variant_feature,
            variant_id=variant_id,
            variant_filter=variant_filter,
            variant_info=variant_info,
            run_filter=run_filter,
            run_source_filter=run_source_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            page_limit=page_limit,
            cursor=cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VariantResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_all_variants_as_curator_with_http_info(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for variant objects via a full text query over all variant metadata. E.g. `dbSNP`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\" in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        variant_region: Annotated[Optional[List[StrictStr]], Field(description="Specify a chromosome interval to find genes between these positions. E.g. `2:233364596-233385916`. Multiple intervals can be provided as a list.")] = None,
        variant_feature: Annotated[Optional[List[StrictStr]], Field(description="Specify the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name, such as `TP53`, variants located within the same genomic region as the specified gene will be retrieved. Multiple genes can be provided as a list.")] = None,
        variant_id: Annotated[Optional[List[StrictStr]], Field(description="One or more specific variation IDs can be specified. E.g. `rs838705`")] = None,
        variant_filter: Annotated[Optional[StrictStr], Field(description="The parameter allows to retrieve gene variants based on the filters defined in the vcf file. If not specified, all variants are returned.    1. pass - return gene variants which passed all filters   2. noPass - return gene variants which failed one or more filters")] = None,
        variant_info: Annotated[Optional[StrictStr], Field(description="Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(info.DB)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries. Combine multiple filters for `INFO` fields using `AND` (`&&`), `OR` (`||`) logical operators and parentheses")] = None,
        run_filter: Annotated[Optional[List[StrictStr]], Field(description="Autogenerated numeric ID that corresponds to a column and is used to link data from the same run to a sample. Multiple values can be provided as a list.")] = None,
        run_source_filter: Annotated[Optional[List[StrictStr]], Field(description="Column name from the file to which all data for a sample is related. Multiple values can be provided as a list to retrieve data from multiple columns.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[VariantResponse]:
        """Retrieve multiple variant data and metadata objects

        Retrieve all variant data and metadata objects that match a query.  ## Metadata full-text queries Single words can be supplied as is, otherwise use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type filter: str
        :param query: Search for variant objects via a full text query over all variant metadata. E.g. `dbSNP`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\" in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param variant_region: Specify a chromosome interval to find genes between these positions. E.g. `2:233364596-233385916`. Multiple intervals can be provided as a list.
        :type variant_region: List[str]
        :param variant_feature: Specify the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name, such as `TP53`, variants located within the same genomic region as the specified gene will be retrieved. Multiple genes can be provided as a list.
        :type variant_feature: List[str]
        :param variant_id: One or more specific variation IDs can be specified. E.g. `rs838705`
        :type variant_id: List[str]
        :param variant_filter: The parameter allows to retrieve gene variants based on the filters defined in the vcf file. If not specified, all variants are returned.    1. pass - return gene variants which passed all filters   2. noPass - return gene variants which failed one or more filters
        :type variant_filter: str
        :param variant_info: Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(info.DB)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries. Combine multiple filters for `INFO` fields using `AND` (`&&`), `OR` (`||`) logical operators and parentheses
        :type variant_info: str
        :param run_filter: Autogenerated numeric ID that corresponds to a column and is used to link data from the same run to a sample. Multiple values can be provided as a list.
        :type run_filter: List[str]
        :param run_source_filter: Column name from the file to which all data for a sample is related. Multiple values can be provided as a list to retrieve data from multiple columns.
        :type run_source_filter: List[str]
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param page_limit: Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.
        :type page_limit: int
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_all_variants_as_curator_serialize(
            response_format=response_format,
            filter=filter,
            query=query,
            search_specific_terms=search_specific_terms,
            variant_region=variant_region,
            variant_feature=variant_feature,
            variant_id=variant_id,
            variant_filter=variant_filter,
            variant_info=variant_info,
            run_filter=run_filter,
            run_source_filter=run_source_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            page_limit=page_limit,
            cursor=cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VariantResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_all_variants_as_curator_without_preload_content(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for variant objects via a full text query over all variant metadata. E.g. `dbSNP`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\" in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        variant_region: Annotated[Optional[List[StrictStr]], Field(description="Specify a chromosome interval to find genes between these positions. E.g. `2:233364596-233385916`. Multiple intervals can be provided as a list.")] = None,
        variant_feature: Annotated[Optional[List[StrictStr]], Field(description="Specify the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name, such as `TP53`, variants located within the same genomic region as the specified gene will be retrieved. Multiple genes can be provided as a list.")] = None,
        variant_id: Annotated[Optional[List[StrictStr]], Field(description="One or more specific variation IDs can be specified. E.g. `rs838705`")] = None,
        variant_filter: Annotated[Optional[StrictStr], Field(description="The parameter allows to retrieve gene variants based on the filters defined in the vcf file. If not specified, all variants are returned.    1. pass - return gene variants which passed all filters   2. noPass - return gene variants which failed one or more filters")] = None,
        variant_info: Annotated[Optional[StrictStr], Field(description="Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(info.DB)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries. Combine multiple filters for `INFO` fields using `AND` (`&&`), `OR` (`||`) logical operators and parentheses")] = None,
        run_filter: Annotated[Optional[List[StrictStr]], Field(description="Autogenerated numeric ID that corresponds to a column and is used to link data from the same run to a sample. Multiple values can be provided as a list.")] = None,
        run_source_filter: Annotated[Optional[List[StrictStr]], Field(description="Column name from the file to which all data for a sample is related. Multiple values can be provided as a list to retrieve data from multiple columns.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve multiple variant data and metadata objects

        Retrieve all variant data and metadata objects that match a query.  ## Metadata full-text queries Single words can be supplied as is, otherwise use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type filter: str
        :param query: Search for variant objects via a full text query over all variant metadata. E.g. `dbSNP`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\" in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param variant_region: Specify a chromosome interval to find genes between these positions. E.g. `2:233364596-233385916`. Multiple intervals can be provided as a list.
        :type variant_region: List[str]
        :param variant_feature: Specify the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name, such as `TP53`, variants located within the same genomic region as the specified gene will be retrieved. Multiple genes can be provided as a list.
        :type variant_feature: List[str]
        :param variant_id: One or more specific variation IDs can be specified. E.g. `rs838705`
        :type variant_id: List[str]
        :param variant_filter: The parameter allows to retrieve gene variants based on the filters defined in the vcf file. If not specified, all variants are returned.    1. pass - return gene variants which passed all filters   2. noPass - return gene variants which failed one or more filters
        :type variant_filter: str
        :param variant_info: Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(info.DB)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries. Combine multiple filters for `INFO` fields using `AND` (`&&`), `OR` (`||`) logical operators and parentheses
        :type variant_info: str
        :param run_filter: Autogenerated numeric ID that corresponds to a column and is used to link data from the same run to a sample. Multiple values can be provided as a list.
        :type run_filter: List[str]
        :param run_source_filter: Column name from the file to which all data for a sample is related. Multiple values can be provided as a list to retrieve data from multiple columns.
        :type run_source_filter: List[str]
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param page_limit: Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.
        :type page_limit: int
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_all_variants_as_curator_serialize(
            response_format=response_format,
            filter=filter,
            query=query,
            search_specific_terms=search_specific_terms,
            variant_region=variant_region,
            variant_feature=variant_feature,
            variant_id=variant_id,
            variant_filter=variant_filter,
            variant_info=variant_info,
            run_filter=run_filter,
            run_source_filter=run_source_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            page_limit=page_limit,
            cursor=cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VariantResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_all_variants_as_curator_serialize(
        self,
        response_format,
        filter,
        query,
        search_specific_terms,
        variant_region,
        variant_feature,
        variant_id,
        variant_filter,
        variant_info,
        run_filter,
        run_source_filter,
        use_versions,
        returned_metadata_fields,
        page_limit,
        cursor,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'variantRegion': 'multi',
            'variantFeature': 'multi',
            'variantId': 'multi',
            'runFilter': 'multi',
            'runSourceFilter': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if filter is not None:
            
            _query_params.append(('filter', filter))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if search_specific_terms is not None:
            
            _query_params.append(('searchSpecificTerms', search_specific_terms))
            
        if variant_region is not None:
            
            _query_params.append(('variantRegion', variant_region))
            
        if variant_feature is not None:
            
            _query_params.append(('variantFeature', variant_feature))
            
        if variant_id is not None:
            
            _query_params.append(('variantId', variant_id))
            
        if variant_filter is not None:
            
            _query_params.append(('variantFilter', variant_filter))
            
        if variant_info is not None:
            
            _query_params.append(('variantInfo', variant_info))
            
        if run_filter is not None:
            
            _query_params.append(('runFilter', run_filter))
            
        if run_source_filter is not None:
            
            _query_params.append(('runSourceFilter', run_source_filter))
            
        if use_versions is not None:
            
            _query_params.append(('useVersions', use_versions))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        if page_limit is not None:
            
            _query_params.append(('pageLimit', page_limit))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-curator/variants',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_variant_as_curator(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> GetVariantAsCurator200Response:
        """Retrieve a single variant object by ID (accession)


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_as_curator_serialize(
            id=id,
            response_format=response_format,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetVariantAsCurator200Response",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_variant_as_curator_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[GetVariantAsCurator200Response]:
        """Retrieve a single variant object by ID (accession)


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_as_curator_serialize(
            id=id,
            response_format=response_format,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetVariantAsCurator200Response",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_variant_as_curator_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve a single variant object by ID (accession)


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_as_curator_serialize(
            id=id,
            response_format=response_format,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "GetVariantAsCurator200Response",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_variant_as_curator_serialize(
        self,
        id,
        response_format,
        returned_metadata_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-curator/variants/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_variant_by_version_as_curator(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        version: Annotated[StrictStr, Field(description="Unique version of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Retrieve a single variant object by ID (accession)


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param version: Unique version of the object. (required)
        :type version: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_by_version_as_curator_serialize(
            id=id,
            version=version,
            response_format=response_format,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_variant_by_version_as_curator_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        version: Annotated[StrictStr, Field(description="Unique version of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Retrieve a single variant object by ID (accession)


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param version: Unique version of the object. (required)
        :type version: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_by_version_as_curator_serialize(
            id=id,
            version=version,
            response_format=response_format,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_variant_by_version_as_curator_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        version: Annotated[StrictStr, Field(description="Unique version of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve a single variant object by ID (accession)


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param version: Unique version of the object. (required)
        :type version: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_by_version_as_curator_serialize(
            id=id,
            version=version,
            response_format=response_format,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_variant_by_version_as_curator_serialize(
        self,
        id,
        version,
        response_format,
        returned_metadata_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        if version is not None:
            _path_params['version'] = version
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-curator/variants/{id}/versions/{version}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_variant_group_as_curator(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> VariantMetadataWithId:
        """Retrieve a single group object by ID (accession)


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_group_as_curator_serialize(
            id=id,
            response_format=response_format,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VariantMetadataWithId",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_variant_group_as_curator_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[VariantMetadataWithId]:
        """Retrieve a single group object by ID (accession)


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_group_as_curator_serialize(
            id=id,
            response_format=response_format,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VariantMetadataWithId",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_variant_group_as_curator_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve a single group object by ID (accession)


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_group_as_curator_serialize(
            id=id,
            response_format=response_format,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VariantMetadataWithId",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_variant_group_as_curator_serialize(
        self,
        id,
        response_format,
        returned_metadata_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-curator/variants/group/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_variant_group_by_run_as_curator(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> VariantMetadataWithId:
        """Retrieve a single group object by run ID (accession)


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_group_by_run_as_curator_serialize(
            id=id,
            response_format=response_format,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VariantMetadataWithId",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_variant_group_by_run_as_curator_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[VariantMetadataWithId]:
        """Retrieve a single group object by run ID (accession)


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_group_by_run_as_curator_serialize(
            id=id,
            response_format=response_format,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VariantMetadataWithId",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_variant_group_by_run_as_curator_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve a single group object by run ID (accession)


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_group_by_run_as_curator_serialize(
            id=id,
            response_format=response_format,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "VariantMetadataWithId",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_variant_group_by_run_as_curator_serialize(
        self,
        id,
        response_format,
        returned_metadata_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-curator/variants/group/by/run/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_variant_versions_as_curator(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CommitInfo]:
        """Retrieve a list of object versions by ID


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_versions_as_curator_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CommitInfo]",
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_variant_versions_as_curator_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CommitInfo]]:
        """Retrieve a list of object versions by ID


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_versions_as_curator_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CommitInfo]",
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_variant_versions_as_curator_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve a list of object versions by ID


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_versions_as_curator_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CommitInfo]",
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_variant_versions_as_curator_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-curator/variants/{id}/versions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def search_groups_as_curator(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for variant objects via a full text query over all variant metadata. E.g. `dbSNP`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\" in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListResponse:
        """Retrieve groups that match a query

        Retrieve all group metadata objects that match a query.  ## Metadata full-text queries Single words can be supplied as is, otherwise use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n*pageLimit` until the `resultsExhausted` response field is true.  ## List operation  This endpoint can be called with no `query` parameter. Doing so returns a list of all data objects.

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type filter: str
        :param query: Search for variant objects via a full text query over all variant metadata. E.g. `dbSNP`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\" in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param page_limit: Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_groups_as_curator_serialize(
            response_format=response_format,
            filter=filter,
            query=query,
            search_specific_terms=search_specific_terms,
            returned_metadata_fields=returned_metadata_fields,
            use_versions=use_versions,
            page_offset=page_offset,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def search_groups_as_curator_with_http_info(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for variant objects via a full text query over all variant metadata. E.g. `dbSNP`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\" in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListResponse]:
        """Retrieve groups that match a query

        Retrieve all group metadata objects that match a query.  ## Metadata full-text queries Single words can be supplied as is, otherwise use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n*pageLimit` until the `resultsExhausted` response field is true.  ## List operation  This endpoint can be called with no `query` parameter. Doing so returns a list of all data objects.

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type filter: str
        :param query: Search for variant objects via a full text query over all variant metadata. E.g. `dbSNP`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\" in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param page_limit: Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_groups_as_curator_serialize(
            response_format=response_format,
            filter=filter,
            query=query,
            search_specific_terms=search_specific_terms,
            returned_metadata_fields=returned_metadata_fields,
            use_versions=use_versions,
            page_offset=page_offset,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def search_groups_as_curator_without_preload_content(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for variant objects via a full text query over all variant metadata. E.g. `dbSNP`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\" in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve groups that match a query

        Retrieve all group metadata objects that match a query.  ## Metadata full-text queries Single words can be supplied as is, otherwise use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n*pageLimit` until the `resultsExhausted` response field is true.  ## List operation  This endpoint can be called with no `query` parameter. Doing so returns a list of all data objects.

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type filter: str
        :param query: Search for variant objects via a full text query over all variant metadata. E.g. `dbSNP`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\" in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template, default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param page_limit: Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_groups_as_curator_serialize(
            response_format=response_format,
            filter=filter,
            query=query,
            search_specific_terms=search_specific_terms,
            returned_metadata_fields=returned_metadata_fields,
            use_versions=use_versions,
            page_offset=page_offset,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_groups_as_curator_serialize(
        self,
        response_format,
        filter,
        query,
        search_specific_terms,
        returned_metadata_fields,
        use_versions,
        page_offset,
        page_limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if filter is not None:
            
            _query_params.append(('filter', filter))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if search_specific_terms is not None:
            
            _query_params.append(('searchSpecificTerms', search_specific_terms))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        if use_versions is not None:
            
            _query_params.append(('useVersions', use_versions))
            
        if page_offset is not None:
            
            _query_params.append(('pageOffset', page_offset))
            
        if page_limit is not None:
            
            _query_params.append(('pageLimit', page_limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-curator/variants/group',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def search_variant_runs_as_curator(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListResponse:
        """Retrieve run objects related to the given group

        ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param page_limit: Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_variant_runs_as_curator_serialize(
            id=id,
            page_offset=page_offset,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def search_variant_runs_as_curator_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListResponse]:
        """Retrieve run objects related to the given group

        ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param page_limit: Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_variant_runs_as_curator_serialize(
            id=id,
            page_offset=page_offset,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def search_variant_runs_as_curator_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve run objects related to the given group

        ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param page_limit: Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_variant_runs_as_curator_serialize(
            id=id,
            page_offset=page_offset,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_variant_runs_as_curator_serialize(
        self,
        id,
        page_offset,
        page_limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if page_offset is not None:
            
            _query_params.append(('pageOffset', page_offset))
            
        if page_limit is not None:
            
            _query_params.append(('pageLimit', page_limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-curator/variants/runs/by/group/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


