# coding: utf-8

"""
    ODM API

    This swagger page describes the variantUser API endpoints for ODM. These are typically used to find and retrieve variant data and metadata.  Before carrying out any API calls you will need an API token. API tokens can be obtained under your profile within the Genestack software.  To try out calls in this swagger page:  1.  Click the 'Authorize' button below to enter your API token 2.  Scroll to the 'Parameters' section for the method you wish to try out and click the 'Try it out' button 3.  Enter parameter values that you wish to try 4.  Scroll to the bottom of the Parameters section and click the 'Execute' bar that appears    The server response will be in the section that follows.

    The version of the OpenAPI document: default-released
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from odm_api.models.list_response import ListResponse
from odm_api.models.metadata_with_id import MetadataWithId
from odm_api.models.response_format import ResponseFormat

from odm_api.api_client import ApiClient, RequestSerialized
from odm_api.api_response import ApiResponse
from odm_api.rest import RESTResponseType


class VariantIntegrationAsUserApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_variant_by_sample_as_user(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return. This value must be between 0 and 2000 (inclusive).")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListResponse:
        """Retrieve variant run-level data by querying related sample ID (accession)

        ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param page_limit: Maximum number of results to return. This value must be between 0 and 2000 (inclusive).
        :type page_limit: int
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_by_sample_as_user_serialize(
            id=id,
            response_format=response_format,
            page_limit=page_limit,
            page_offset=page_offset,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_variant_by_sample_as_user_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return. This value must be between 0 and 2000 (inclusive).")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListResponse]:
        """Retrieve variant run-level data by querying related sample ID (accession)

        ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param page_limit: Maximum number of results to return. This value must be between 0 and 2000 (inclusive).
        :type page_limit: int
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_by_sample_as_user_serialize(
            id=id,
            response_format=response_format,
            page_limit=page_limit,
            page_offset=page_offset,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_variant_by_sample_as_user_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return. This value must be between 0 and 2000 (inclusive).")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve variant run-level data by querying related sample ID (accession)

        ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param page_limit: Maximum number of results to return. This value must be between 0 and 2000 (inclusive).
        :type page_limit: int
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_by_sample_as_user_serialize(
            id=id,
            response_format=response_format,
            page_limit=page_limit,
            page_offset=page_offset,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_variant_by_sample_as_user_serialize(
        self,
        id,
        response_format,
        page_limit,
        page_offset,
        use_versions,
        returned_metadata_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if page_limit is not None:
            
            _query_params.append(('pageLimit', page_limit))
            
        if page_offset is not None:
            
            _query_params.append(('pageOffset', page_offset))
            
        if use_versions is not None:
            
            _query_params.append(('useVersions', use_versions))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-user/integration/link/variant/by/sample/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_variant_groups_by_study_as_user(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[MetadataWithId]:
        """Retrieve group metadata by querying study ID (accession)

        ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  

        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_groups_by_study_as_user_serialize(
            id=id,
            response_format=response_format,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[MetadataWithId]",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_variant_groups_by_study_as_user_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[MetadataWithId]]:
        """Retrieve group metadata by querying study ID (accession)

        ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  

        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_groups_by_study_as_user_serialize(
            id=id,
            response_format=response_format,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[MetadataWithId]",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_variant_groups_by_study_as_user_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve group metadata by querying study ID (accession)

        ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  

        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_groups_by_study_as_user_serialize(
            id=id,
            response_format=response_format,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[MetadataWithId]",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_variant_groups_by_study_as_user_serialize(
        self,
        id,
        response_format,
        use_versions,
        returned_metadata_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if use_versions is not None:
            
            _query_params.append(('useVersions', use_versions))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-user/integration/link/variant/group/by/study/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_variant_run_to_sample_pairs_as_user(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return. This value must be between 0 and 2000 (inclusive).")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListResponse:
        """Retrieve run-sample pairs by group id. Pagination is based on unique runs, not unique pairs.

        ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param page_limit: Maximum number of results to return. This value must be between 0 and 2000 (inclusive).
        :type page_limit: int
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_run_to_sample_pairs_as_user_serialize(
            id=id,
            page_limit=page_limit,
            page_offset=page_offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_variant_run_to_sample_pairs_as_user_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return. This value must be between 0 and 2000 (inclusive).")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListResponse]:
        """Retrieve run-sample pairs by group id. Pagination is based on unique runs, not unique pairs.

        ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param page_limit: Maximum number of results to return. This value must be between 0 and 2000 (inclusive).
        :type page_limit: int
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_run_to_sample_pairs_as_user_serialize(
            id=id,
            page_limit=page_limit,
            page_offset=page_offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_variant_run_to_sample_pairs_as_user_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return. This value must be between 0 and 2000 (inclusive).")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve run-sample pairs by group id. Pagination is based on unique runs, not unique pairs.

        ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param page_limit: Maximum number of results to return. This value must be between 0 and 2000 (inclusive).
        :type page_limit: int
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_variant_run_to_sample_pairs_as_user_serialize(
            id=id,
            page_limit=page_limit,
            page_offset=page_offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '400': None,
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_variant_run_to_sample_pairs_as_user_serialize(
        self,
        id,
        page_limit,
        page_offset,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if page_limit is not None:
            
            _query_params.append(('pageLimit', page_limit))
            
        if page_offset is not None:
            
            _query_params.append(('pageOffset', page_offset))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-user/integration/link/variant/run-to-samples/by/group/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


