# coding: utf-8

"""
    ODM API

    This swagger page describes the variantUser API endpoints for ODM. These are typically used to find and retrieve variant data and metadata.  Before carrying out any API calls you will need an API token. API tokens can be obtained under your profile within the Genestack software.  To try out calls in this swagger page:  1.  Click the 'Authorize' button below to enter your API token 2.  Scroll to the 'Parameters' section for the method you wish to try out and click the 'Try it out' button 3.  Enter parameter values that you wish to try 4.  Scroll to the bottom of the Parameters section and click the 'Execute' bar that appears    The server response will be in the section that follows.

    The version of the OpenAPI document: default-released
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, Dict, Optional
from typing_extensions import Annotated
from odm_api.models.find_objects_response import FindObjectsResponse
from odm_api.models.list_response import ListResponse
from odm_api.models.response_format import ResponseFormat
from odm_api.models.search_study_request import SearchStudyRequest

from odm_api.api_client import ApiClient, RequestSerialized
from odm_api.api_response import ApiResponse
from odm_api.rest import RESTResponseType


class StudyIntegrationAsUserApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_studies_by_files_as_user(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by attachment file metadata (key-value metadata pair(s)). E.g. \"Species or strain\"=\"Homo sapiens\"")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for study metadata objects via a full-text query over all attached files metadata fields. E.g. \"RNA-Seq of human dendritic cells\". Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return. This value must be between 0 and 2000 (inclusive).")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListResponse:
        """Retrieve study metadata objects by querying related attachment files

        Retrieve study metadata objects whose linked attached files metadata matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Attachment files (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param filter: Filter by attachment file metadata (key-value metadata pair(s)). E.g. \"Species or strain\"=\"Homo sapiens\"
        :type filter: str
        :param query: Search for study metadata objects via a full-text query over all attached files metadata fields. E.g. \"RNA-Seq of human dendritic cells\". Queries matching dictionary terms are automatically expanded to include synonyms.
        :type query: str
        :param page_limit: Maximum number of results to return. This value must be between 0 and 2000 (inclusive).
        :type page_limit: int
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studies_by_files_as_user_serialize(
            response_format=response_format,
            filter=filter,
            query=query,
            page_limit=page_limit,
            page_offset=page_offset,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_studies_by_files_as_user_with_http_info(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by attachment file metadata (key-value metadata pair(s)). E.g. \"Species or strain\"=\"Homo sapiens\"")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for study metadata objects via a full-text query over all attached files metadata fields. E.g. \"RNA-Seq of human dendritic cells\". Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return. This value must be between 0 and 2000 (inclusive).")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListResponse]:
        """Retrieve study metadata objects by querying related attachment files

        Retrieve study metadata objects whose linked attached files metadata matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Attachment files (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param filter: Filter by attachment file metadata (key-value metadata pair(s)). E.g. \"Species or strain\"=\"Homo sapiens\"
        :type filter: str
        :param query: Search for study metadata objects via a full-text query over all attached files metadata fields. E.g. \"RNA-Seq of human dendritic cells\". Queries matching dictionary terms are automatically expanded to include synonyms.
        :type query: str
        :param page_limit: Maximum number of results to return. This value must be between 0 and 2000 (inclusive).
        :type page_limit: int
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studies_by_files_as_user_serialize(
            response_format=response_format,
            filter=filter,
            query=query,
            page_limit=page_limit,
            page_offset=page_offset,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_studies_by_files_as_user_without_preload_content(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by attachment file metadata (key-value metadata pair(s)). E.g. \"Species or strain\"=\"Homo sapiens\"")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for study metadata objects via a full-text query over all attached files metadata fields. E.g. \"RNA-Seq of human dendritic cells\". Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return. This value must be between 0 and 2000 (inclusive).")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve study metadata objects by querying related attachment files

        Retrieve study metadata objects whose linked attached files metadata matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Attachment files (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param filter: Filter by attachment file metadata (key-value metadata pair(s)). E.g. \"Species or strain\"=\"Homo sapiens\"
        :type filter: str
        :param query: Search for study metadata objects via a full-text query over all attached files metadata fields. E.g. \"RNA-Seq of human dendritic cells\". Queries matching dictionary terms are automatically expanded to include synonyms.
        :type query: str
        :param page_limit: Maximum number of results to return. This value must be between 0 and 2000 (inclusive).
        :type page_limit: int
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studies_by_files_as_user_serialize(
            response_format=response_format,
            filter=filter,
            query=query,
            page_limit=page_limit,
            page_offset=page_offset,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_studies_by_files_as_user_serialize(
        self,
        response_format,
        filter,
        query,
        page_limit,
        page_offset,
        returned_metadata_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if filter is not None:
            
            _query_params.append(('filter', filter))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if page_limit is not None:
            
            _query_params.append(('pageLimit', page_limit))
            
        if page_offset is not None:
            
            _query_params.append(('pageOffset', page_offset))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-user/integration/link/studies/by/files',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_studies_by_libraries_as_user(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return. This value must be between 0 and 2000 (inclusive).")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListResponse:
        """Retrieve study metadata objects by querying related libraries

        Retrieve study metadata objects whose linked library metadata matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type filter: str
        :param query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param page_limit: Maximum number of results to return. This value must be between 0 and 2000 (inclusive).
        :type page_limit: int
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studies_by_libraries_as_user_serialize(
            response_format=response_format,
            filter=filter,
            query=query,
            search_specific_terms=search_specific_terms,
            page_limit=page_limit,
            page_offset=page_offset,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_studies_by_libraries_as_user_with_http_info(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return. This value must be between 0 and 2000 (inclusive).")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListResponse]:
        """Retrieve study metadata objects by querying related libraries

        Retrieve study metadata objects whose linked library metadata matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type filter: str
        :param query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param page_limit: Maximum number of results to return. This value must be between 0 and 2000 (inclusive).
        :type page_limit: int
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studies_by_libraries_as_user_serialize(
            response_format=response_format,
            filter=filter,
            query=query,
            search_specific_terms=search_specific_terms,
            page_limit=page_limit,
            page_offset=page_offset,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_studies_by_libraries_as_user_without_preload_content(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return. This value must be between 0 and 2000 (inclusive).")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve study metadata objects by querying related libraries

        Retrieve study metadata objects whose linked library metadata matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type filter: str
        :param query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param page_limit: Maximum number of results to return. This value must be between 0 and 2000 (inclusive).
        :type page_limit: int
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studies_by_libraries_as_user_serialize(
            response_format=response_format,
            filter=filter,
            query=query,
            search_specific_terms=search_specific_terms,
            page_limit=page_limit,
            page_offset=page_offset,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_studies_by_libraries_as_user_serialize(
        self,
        response_format,
        filter,
        query,
        search_specific_terms,
        page_limit,
        page_offset,
        returned_metadata_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if filter is not None:
            
            _query_params.append(('filter', filter))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if search_specific_terms is not None:
            
            _query_params.append(('searchSpecificTerms', search_specific_terms))
            
        if page_limit is not None:
            
            _query_params.append(('pageLimit', page_limit))
            
        if page_offset is not None:
            
            _query_params.append(('pageOffset', page_offset))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-user/integration/link/studies/by/libraries',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_studies_by_preparations_as_user(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return. This value must be between 0 and 2000 (inclusive).")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListResponse:
        """Retrieve study metadata objects by querying related preparations

        Retrieve study metadata objects whose linked preparation metadata matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type filter: str
        :param query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param page_limit: Maximum number of results to return. This value must be between 0 and 2000 (inclusive).
        :type page_limit: int
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studies_by_preparations_as_user_serialize(
            response_format=response_format,
            filter=filter,
            query=query,
            search_specific_terms=search_specific_terms,
            page_limit=page_limit,
            page_offset=page_offset,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_studies_by_preparations_as_user_with_http_info(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return. This value must be between 0 and 2000 (inclusive).")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListResponse]:
        """Retrieve study metadata objects by querying related preparations

        Retrieve study metadata objects whose linked preparation metadata matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type filter: str
        :param query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param page_limit: Maximum number of results to return. This value must be between 0 and 2000 (inclusive).
        :type page_limit: int
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studies_by_preparations_as_user_serialize(
            response_format=response_format,
            filter=filter,
            query=query,
            search_specific_terms=search_specific_terms,
            page_limit=page_limit,
            page_offset=page_offset,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_studies_by_preparations_as_user_without_preload_content(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return. This value must be between 0 and 2000 (inclusive).")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve study metadata objects by querying related preparations

        Retrieve study metadata objects whose linked preparation metadata matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type filter: str
        :param query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param page_limit: Maximum number of results to return. This value must be between 0 and 2000 (inclusive).
        :type page_limit: int
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studies_by_preparations_as_user_serialize(
            response_format=response_format,
            filter=filter,
            query=query,
            search_specific_terms=search_specific_terms,
            page_limit=page_limit,
            page_offset=page_offset,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_studies_by_preparations_as_user_serialize(
        self,
        response_format,
        filter,
        query,
        search_specific_terms,
        page_limit,
        page_offset,
        returned_metadata_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if filter is not None:
            
            _query_params.append(('filter', filter))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if search_specific_terms is not None:
            
            _query_params.append(('searchSpecificTerms', search_specific_terms))
            
        if page_limit is not None:
            
            _query_params.append(('pageLimit', page_limit))
            
        if page_offset is not None:
            
            _query_params.append(('pageOffset', page_offset))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-user/integration/link/studies/by/preparations',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_studies_by_samples_as_user(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. \"Species or strain\"=\"Homo sapiens\"")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for study metadata objects via a full-text query over all sample metadata fields. E.g. \"RNA-Seq of human dendritic cells\". Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return. This value must be between 0 and 2000 (inclusive).")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListResponse:
        """Retrieve study metadata objects by querying related samples

        Retrieve study metadata objects whose linked sample metadata matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param filter: Filter by sample metadata (key-value metadata pair(s)). E.g. \"Species or strain\"=\"Homo sapiens\"
        :type filter: str
        :param query: Search for study metadata objects via a full-text query over all sample metadata fields. E.g. \"RNA-Seq of human dendritic cells\". Queries matching dictionary terms are automatically expanded to include synonyms.
        :type query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param page_limit: Maximum number of results to return. This value must be between 0 and 2000 (inclusive).
        :type page_limit: int
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studies_by_samples_as_user_serialize(
            response_format=response_format,
            filter=filter,
            query=query,
            search_specific_terms=search_specific_terms,
            page_limit=page_limit,
            page_offset=page_offset,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_studies_by_samples_as_user_with_http_info(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. \"Species or strain\"=\"Homo sapiens\"")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for study metadata objects via a full-text query over all sample metadata fields. E.g. \"RNA-Seq of human dendritic cells\". Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return. This value must be between 0 and 2000 (inclusive).")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListResponse]:
        """Retrieve study metadata objects by querying related samples

        Retrieve study metadata objects whose linked sample metadata matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param filter: Filter by sample metadata (key-value metadata pair(s)). E.g. \"Species or strain\"=\"Homo sapiens\"
        :type filter: str
        :param query: Search for study metadata objects via a full-text query over all sample metadata fields. E.g. \"RNA-Seq of human dendritic cells\". Queries matching dictionary terms are automatically expanded to include synonyms.
        :type query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param page_limit: Maximum number of results to return. This value must be between 0 and 2000 (inclusive).
        :type page_limit: int
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studies_by_samples_as_user_serialize(
            response_format=response_format,
            filter=filter,
            query=query,
            search_specific_terms=search_specific_terms,
            page_limit=page_limit,
            page_offset=page_offset,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_studies_by_samples_as_user_without_preload_content(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. \"Species or strain\"=\"Homo sapiens\"")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for study metadata objects via a full-text query over all sample metadata fields. E.g. \"RNA-Seq of human dendritic cells\". Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return. This value must be between 0 and 2000 (inclusive).")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve study metadata objects by querying related samples

        Retrieve study metadata objects whose linked sample metadata matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the pageOffset query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To return all results iterate through pages using pageOffset values of `n * pageLimit` until the `resultsExhausted` response field is true.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param filter: Filter by sample metadata (key-value metadata pair(s)). E.g. \"Species or strain\"=\"Homo sapiens\"
        :type filter: str
        :param query: Search for study metadata objects via a full-text query over all sample metadata fields. E.g. \"RNA-Seq of human dendritic cells\". Queries matching dictionary terms are automatically expanded to include synonyms.
        :type query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param page_limit: Maximum number of results to return. This value must be between 0 and 2000 (inclusive).
        :type page_limit: int
        :param page_offset: Show the page {pageOffset+1} results from the start of the results. E.g. 100 will show a page of results  starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_studies_by_samples_as_user_serialize(
            response_format=response_format,
            filter=filter,
            query=query,
            search_specific_terms=search_specific_terms,
            page_limit=page_limit,
            page_offset=page_offset,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_studies_by_samples_as_user_serialize(
        self,
        response_format,
        filter,
        query,
        search_specific_terms,
        page_limit,
        page_offset,
        returned_metadata_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if filter is not None:
            
            _query_params.append(('filter', filter))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if search_specific_terms is not None:
            
            _query_params.append(('searchSpecificTerms', search_specific_terms))
            
        if page_limit is not None:
            
            _query_params.append(('pageLimit', page_limit))
            
        if page_offset is not None:
            
            _query_params.append(('pageOffset', page_offset))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json', 
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-user/integration/link/studies/by/samples',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_study_by_file_as_user(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Retrieve study metadata by querying attachment file ID (accession)


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_study_by_file_as_user_serialize(
            id=id,
            response_format=response_format,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_study_by_file_as_user_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Retrieve study metadata by querying attachment file ID (accession)


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_study_by_file_as_user_serialize(
            id=id,
            response_format=response_format,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_study_by_file_as_user_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve study metadata by querying attachment file ID (accession)


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_study_by_file_as_user_serialize(
            id=id,
            response_format=response_format,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_study_by_file_as_user_serialize(
        self,
        id,
        response_format,
        returned_metadata_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-user/integration/link/study/by/file/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_study_by_sample_as_user(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Retrieve study metadata by querying sample ID (accession)


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_study_by_sample_as_user_serialize(
            id=id,
            response_format=response_format,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_study_by_sample_as_user_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Retrieve study metadata by querying sample ID (accession)


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_study_by_sample_as_user_serialize(
            id=id,
            response_format=response_format,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_study_by_sample_as_user_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (accession) of the object.")],
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve study metadata by querying sample ID (accession)


        :param id: Unique identifier (accession) of the object. (required)
        :type id: str
        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_study_by_sample_as_user_serialize(
            id=id,
            response_format=response_format,
            returned_metadata_fields=returned_metadata_fields,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_study_by_sample_as_user_serialize(
        self,
        id,
        response_format,
        returned_metadata_fields,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-user/integration/link/study/by/sample/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def search_studies_by_filter_as_user(
        self,
        request: SearchStudyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FindObjectsResponse:
        """Find and retrieve studies by full-text or facet query

        Find studies and retrieve their data using full-text search or facet search by metadata of study itself or child object (samples, libraries, preparations, signal groups). Only studies available to that users are returned.  The endpoint returns: - a list of studies with their metadata summary; - a list of filter objects with counts; filter list is the same for all users in an and can be configured in “Study Browser” application via \"Configure facets\" (by a user with corresponding permission); for each filter object, only the first 5 most popular facets are returned, the facts are sorted by the count value in descending order; only studies available to user are counted.  Filter attributes for fulltext search: - `\"type\": \"FULL_TEXT\"` - `\"match\"` - `\"mode\"`  For details on two latter ones, see the request body model. Only one filter with `\"type=\": \"FULL_TEXT\"` can be passed in the request body.  To filter studies via facets, the filter attributes are necessary: type = SELECT, filterOptionId. For details, use the request body model. filterOptionId can be obtained from the response body when the endpoint is first called without filters. Multiple filters with type = SELECT can be passed in the request body. Filters within the same attribute are automatically used with the OR operator. Filters of different attributes are automatically used with the AND operator. This behaviour can not be changed.  It is possible to call the endpoint without any filters, then all the studies available to the user are returned.  The endpoint searches by staging version of the object metadata.

        :param request: (required)
        :type request: SearchStudyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_studies_by_filter_as_user_serialize(
            request=request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FindObjectsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def search_studies_by_filter_as_user_with_http_info(
        self,
        request: SearchStudyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FindObjectsResponse]:
        """Find and retrieve studies by full-text or facet query

        Find studies and retrieve their data using full-text search or facet search by metadata of study itself or child object (samples, libraries, preparations, signal groups). Only studies available to that users are returned.  The endpoint returns: - a list of studies with their metadata summary; - a list of filter objects with counts; filter list is the same for all users in an and can be configured in “Study Browser” application via \"Configure facets\" (by a user with corresponding permission); for each filter object, only the first 5 most popular facets are returned, the facts are sorted by the count value in descending order; only studies available to user are counted.  Filter attributes for fulltext search: - `\"type\": \"FULL_TEXT\"` - `\"match\"` - `\"mode\"`  For details on two latter ones, see the request body model. Only one filter with `\"type=\": \"FULL_TEXT\"` can be passed in the request body.  To filter studies via facets, the filter attributes are necessary: type = SELECT, filterOptionId. For details, use the request body model. filterOptionId can be obtained from the response body when the endpoint is first called without filters. Multiple filters with type = SELECT can be passed in the request body. Filters within the same attribute are automatically used with the OR operator. Filters of different attributes are automatically used with the AND operator. This behaviour can not be changed.  It is possible to call the endpoint without any filters, then all the studies available to the user are returned.  The endpoint searches by staging version of the object metadata.

        :param request: (required)
        :type request: SearchStudyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_studies_by_filter_as_user_serialize(
            request=request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FindObjectsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def search_studies_by_filter_as_user_without_preload_content(
        self,
        request: SearchStudyRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Find and retrieve studies by full-text or facet query

        Find studies and retrieve their data using full-text search or facet search by metadata of study itself or child object (samples, libraries, preparations, signal groups). Only studies available to that users are returned.  The endpoint returns: - a list of studies with their metadata summary; - a list of filter objects with counts; filter list is the same for all users in an and can be configured in “Study Browser” application via \"Configure facets\" (by a user with corresponding permission); for each filter object, only the first 5 most popular facets are returned, the facts are sorted by the count value in descending order; only studies available to user are counted.  Filter attributes for fulltext search: - `\"type\": \"FULL_TEXT\"` - `\"match\"` - `\"mode\"`  For details on two latter ones, see the request body model. Only one filter with `\"type=\": \"FULL_TEXT\"` can be passed in the request body.  To filter studies via facets, the filter attributes are necessary: type = SELECT, filterOptionId. For details, use the request body model. filterOptionId can be obtained from the response body when the endpoint is first called without filters. Multiple filters with type = SELECT can be passed in the request body. Filters within the same attribute are automatically used with the OR operator. Filters of different attributes are automatically used with the AND operator. This behaviour can not be changed.  It is possible to call the endpoint without any filters, then all the studies available to the user are returned.  The endpoint searches by staging version of the object metadata.

        :param request: (required)
        :type request: SearchStudyRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_studies_by_filter_as_user_serialize(
            request=request,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FindObjectsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_studies_by_filter_as_user_serialize(
        self,
        request,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if request is not None:
            _body_params = request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/as-user/integration/fulltext/search/studies',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


