# coding: utf-8

"""
    ODM API

    This swagger page describes the variantUser API endpoints for ODM. These are typically used to find and retrieve variant data and metadata.  Before carrying out any API calls you will need an API token. API tokens can be obtained under your profile within the Genestack software.  To try out calls in this swagger page:  1.  Click the 'Authorize' button below to enter your API token 2.  Scroll to the 'Parameters' section for the method you wish to try out and click the 'Try it out' button 3.  Enter parameter values that you wish to try 4.  Scroll to the bottom of the Parameters section and click the 'Execute' bar that appears    The server response will be in the section that follows.

    The version of the OpenAPI document: default-released
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr
from typing import Optional
from typing_extensions import Annotated
from odm_api.models.accession_response import AccessionResponse
from odm_api.models.list_response import ListResponse
from odm_api.models.rg_item import RGItem
from odm_api.models.upload_rg_request import UploadRGRequest

from odm_api.api_client import ApiClient, RequestSerialized
from odm_api.api_response import ApiResponse
from odm_api.rest import RESTResponseType


class ReferenceGenomeApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_reference_genome_by_accession(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (Genestack accession) of Reference Genome object.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RGItem:
        """Retrieve a single Reference Genome object by ID (accession)


        :param id: Unique identifier (Genestack accession) of Reference Genome object. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_reference_genome_by_accession_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RGItem",
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_reference_genome_by_accession_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (Genestack accession) of Reference Genome object.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[RGItem]:
        """Retrieve a single Reference Genome object by ID (accession)


        :param id: Unique identifier (Genestack accession) of Reference Genome object. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_reference_genome_by_accession_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RGItem",
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_reference_genome_by_accession_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="Unique identifier (Genestack accession) of Reference Genome object.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve a single Reference Genome object by ID (accession)


        :param id: Unique identifier (Genestack accession) of Reference Genome object. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_reference_genome_by_accession_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "RGItem",
            '401': None,
            '404': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_reference_genome_by_accession_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/reference-genomes/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def search_reference_genomes(
        self,
        organism: Annotated[Optional[StrictStr], Field(description="Scientific name of an organism (species) used in reference genome file (e.g. `Homo sapiens`).")] = None,
        assembly: Annotated[Optional[StrictStr], Field(description="Major version (for example, `GRCh38`).")] = None,
        release: Annotated[Optional[StrictStr], Field(description="Ensembl reference genome minor version (for example, `75` or `109`).")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for reference genome via a full-text query over all reference genome metadata fields (e.g. `GRCh38`).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset + 1} results from the start of the results. E.g. 100 will show a page of results starting from the 101st result. The default value is 0.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ListResponse:
        """List or search for Reference Genome objects

        Retrieve Reference Genome metadata objects by searching/listing Reference Genome metadata.  ## Metadata full-text queries Single words can be supplied as is, otherwise use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Paging For performance reasons, this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the `pageOffset` query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To retrieve all results, iterate through pages by increasing the offset in multiples of limit (e.g., `offset = n * limit`), until all results have been retrieved. The total number of pages can be calculated by dividing the total number of results by the limit.  ## List operation  This endpoint can be called without any query parameters. When called this way, it returns a list of all Reference Genome objects.

        :param organism: Scientific name of an organism (species) used in reference genome file (e.g. `Homo sapiens`).
        :type organism: str
        :param assembly: Major version (for example, `GRCh38`).
        :type assembly: str
        :param release: Ensembl reference genome minor version (for example, `75` or `109`).
        :type release: str
        :param query: Search for reference genome via a full-text query over all reference genome metadata fields (e.g. `GRCh38`).
        :type query: str
        :param page_limit: Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.
        :type page_limit: int
        :param page_offset: Show the page {pageOffset + 1} results from the start of the results. E.g. 100 will show a page of results starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_reference_genomes_serialize(
            organism=organism,
            assembly=assembly,
            release=release,
            query=query,
            page_limit=page_limit,
            page_offset=page_offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def search_reference_genomes_with_http_info(
        self,
        organism: Annotated[Optional[StrictStr], Field(description="Scientific name of an organism (species) used in reference genome file (e.g. `Homo sapiens`).")] = None,
        assembly: Annotated[Optional[StrictStr], Field(description="Major version (for example, `GRCh38`).")] = None,
        release: Annotated[Optional[StrictStr], Field(description="Ensembl reference genome minor version (for example, `75` or `109`).")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for reference genome via a full-text query over all reference genome metadata fields (e.g. `GRCh38`).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset + 1} results from the start of the results. E.g. 100 will show a page of results starting from the 101st result. The default value is 0.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ListResponse]:
        """List or search for Reference Genome objects

        Retrieve Reference Genome metadata objects by searching/listing Reference Genome metadata.  ## Metadata full-text queries Single words can be supplied as is, otherwise use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Paging For performance reasons, this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the `pageOffset` query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To retrieve all results, iterate through pages by increasing the offset in multiples of limit (e.g., `offset = n * limit`), until all results have been retrieved. The total number of pages can be calculated by dividing the total number of results by the limit.  ## List operation  This endpoint can be called without any query parameters. When called this way, it returns a list of all Reference Genome objects.

        :param organism: Scientific name of an organism (species) used in reference genome file (e.g. `Homo sapiens`).
        :type organism: str
        :param assembly: Major version (for example, `GRCh38`).
        :type assembly: str
        :param release: Ensembl reference genome minor version (for example, `75` or `109`).
        :type release: str
        :param query: Search for reference genome via a full-text query over all reference genome metadata fields (e.g. `GRCh38`).
        :type query: str
        :param page_limit: Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.
        :type page_limit: int
        :param page_offset: Show the page {pageOffset + 1} results from the start of the results. E.g. 100 will show a page of results starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_reference_genomes_serialize(
            organism=organism,
            assembly=assembly,
            release=release,
            query=query,
            page_limit=page_limit,
            page_offset=page_offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def search_reference_genomes_without_preload_content(
        self,
        organism: Annotated[Optional[StrictStr], Field(description="Scientific name of an organism (species) used in reference genome file (e.g. `Homo sapiens`).")] = None,
        assembly: Annotated[Optional[StrictStr], Field(description="Major version (for example, `GRCh38`).")] = None,
        release: Annotated[Optional[StrictStr], Field(description="Ensembl reference genome minor version (for example, `75` or `109`).")] = None,
        query: Annotated[Optional[StrictStr], Field(description="Search for reference genome via a full-text query over all reference genome metadata fields (e.g. `GRCh38`).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.")] = None,
        page_offset: Annotated[Optional[StrictInt], Field(description="Show the page {pageOffset + 1} results from the start of the results. E.g. 100 will show a page of results starting from the 101st result. The default value is 0.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """List or search for Reference Genome objects

        Retrieve Reference Genome metadata objects by searching/listing Reference Genome metadata.  ## Metadata full-text queries Single words can be supplied as is, otherwise use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Paging For performance reasons, this endpoint returns results in \"pages\" of limited size. In order to retrieve all matching results the client needs to request multiple pages starting from an offset to the first result. You can do this using the `pageOffset` query parameter. A value of 0 (the default) instructs the server to return the first page of results, 100 would return a page of results starting from the 101st result and so on. To retrieve all results, iterate through pages by increasing the offset in multiples of limit (e.g., `offset = n * limit`), until all results have been retrieved. The total number of pages can be calculated by dividing the total number of results by the limit.  ## List operation  This endpoint can be called without any query parameters. When called this way, it returns a list of all Reference Genome objects.

        :param organism: Scientific name of an organism (species) used in reference genome file (e.g. `Homo sapiens`).
        :type organism: str
        :param assembly: Major version (for example, `GRCh38`).
        :type assembly: str
        :param release: Ensembl reference genome minor version (for example, `75` or `109`).
        :type release: str
        :param query: Search for reference genome via a full-text query over all reference genome metadata fields (e.g. `GRCh38`).
        :type query: str
        :param page_limit: Maximum number of results to return per page (see Paging above). This value must be between 0 and 2000 (inclusive). The default is 2000.
        :type page_limit: int
        :param page_offset: Show the page {pageOffset + 1} results from the start of the results. E.g. 100 will show a page of results starting from the 101st result. The default value is 0.
        :type page_offset: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._search_reference_genomes_serialize(
            organism=organism,
            assembly=assembly,
            release=release,
            query=query,
            page_limit=page_limit,
            page_offset=page_offset,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "ListResponse",
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _search_reference_genomes_serialize(
        self,
        organism,
        assembly,
        release,
        query,
        page_limit,
        page_offset,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if organism is not None:
            
            _query_params.append(('organism', organism))
            
        if assembly is not None:
            
            _query_params.append(('assembly', assembly))
            
        if release is not None:
            
            _query_params.append(('release', release))
            
        if query is not None:
            
            _query_params.append(('query', query))
            
        if page_limit is not None:
            
            _query_params.append(('pageLimit', page_limit))
            
        if page_offset is not None:
            
            _query_params.append(('pageOffset', page_offset))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/reference-genomes',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def upload(
        self,
        body: Optional[UploadRGRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> AccessionResponse:
        """Upload reference genome to ODM

        In order to import reference genome file, please fill in the following fields:  * `annotationUrl` - link to the non-vertebrae organism or any custom reference genome in .gtf format, archived in `.gz` format. Note: if any of the parameters below are not corresponding to the available Ensembl data (for example, organism name or assembly is changed), the link must be provided. * `organism` - scientific name (default: Homo sapiens). Please see the list of available organisms [here](https://www.ensembl.org/info/about/species.html). Note: for some specific cases (Canis lupus breeds, Mus musculus strains, etc.) please see the species folders name in the Ensembl FTP (release 113) to provide the same organism name as shown in the list. * `assembly` - major version (for example, `GRCh38`). Please see the list of available assemblies [here](https://www.ensembl.org/info/website/archives/assembly.html). * `release` - Ensembl reference genome minor version (for example, `75` or `109`). * `name` - customized reference genome title that is used for linkage variant files. By default is combined from species, assembly and release parameters: `{species} reference genome {assembly}.{release}`.  Reference genome will be available after initialisation. Please track initialisation task status.

        :param body:
        :type body: UploadRGRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._upload_serialize(
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "AccessionResponse",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def upload_with_http_info(
        self,
        body: Optional[UploadRGRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[AccessionResponse]:
        """Upload reference genome to ODM

        In order to import reference genome file, please fill in the following fields:  * `annotationUrl` - link to the non-vertebrae organism or any custom reference genome in .gtf format, archived in `.gz` format. Note: if any of the parameters below are not corresponding to the available Ensembl data (for example, organism name or assembly is changed), the link must be provided. * `organism` - scientific name (default: Homo sapiens). Please see the list of available organisms [here](https://www.ensembl.org/info/about/species.html). Note: for some specific cases (Canis lupus breeds, Mus musculus strains, etc.) please see the species folders name in the Ensembl FTP (release 113) to provide the same organism name as shown in the list. * `assembly` - major version (for example, `GRCh38`). Please see the list of available assemblies [here](https://www.ensembl.org/info/website/archives/assembly.html). * `release` - Ensembl reference genome minor version (for example, `75` or `109`). * `name` - customized reference genome title that is used for linkage variant files. By default is combined from species, assembly and release parameters: `{species} reference genome {assembly}.{release}`.  Reference genome will be available after initialisation. Please track initialisation task status.

        :param body:
        :type body: UploadRGRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._upload_serialize(
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "AccessionResponse",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def upload_without_preload_content(
        self,
        body: Optional[UploadRGRequest] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Upload reference genome to ODM

        In order to import reference genome file, please fill in the following fields:  * `annotationUrl` - link to the non-vertebrae organism or any custom reference genome in .gtf format, archived in `.gz` format. Note: if any of the parameters below are not corresponding to the available Ensembl data (for example, organism name or assembly is changed), the link must be provided. * `organism` - scientific name (default: Homo sapiens). Please see the list of available organisms [here](https://www.ensembl.org/info/about/species.html). Note: for some specific cases (Canis lupus breeds, Mus musculus strains, etc.) please see the species folders name in the Ensembl FTP (release 113) to provide the same organism name as shown in the list. * `assembly` - major version (for example, `GRCh38`). Please see the list of available assemblies [here](https://www.ensembl.org/info/website/archives/assembly.html). * `release` - Ensembl reference genome minor version (for example, `75` or `109`). * `name` - customized reference genome title that is used for linkage variant files. By default is combined from species, assembly and release parameters: `{species} reference genome {assembly}.{release}`.  Reference genome will be available after initialisation. Please track initialisation task status.

        :param body:
        :type body: UploadRGRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._upload_serialize(
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "AccessionResponse",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _upload_serialize(
        self,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/reference-genomes',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


