# coding: utf-8

"""
    ODM API

    This swagger page describes the variantUser API endpoints for ODM. These are typically used to find and retrieve variant data and metadata.  Before carrying out any API calls you will need an API token. API tokens can be obtained under your profile within the Genestack software.  To try out calls in this swagger page:  1.  Click the 'Authorize' button below to enter your API token 2.  Scroll to the 'Parameters' section for the method you wish to try out and click the 'Try it out' button 3.  Enter parameter values that you wish to try 4.  Scroll to the bottom of the Parameters section and click the 'Execute' bar that appears    The server response will be in the section that follows.

    The version of the OpenAPI document: default-released
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, Dict, List, Optional
from typing_extensions import Annotated
from odm_api.models.omics_response import OmicsResponse
from odm_api.models.response_format import ResponseFormat

from odm_api.api_client import ApiClient, RequestSerialized
from odm_api.api_response import ApiResponse
from odm_api.rest import RESTResponseType


class OmicsQueriesAsUserApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def omics_search_expression_data_as_user(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OmicsResponse:
        """Retrieve data objects by searching across multiple data types

        Retrieve any data objects whose linked data matches all supplied conditions.   Note: An expression data query must be supplied.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_expression_data_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def omics_search_expression_data_as_user_with_http_info(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OmicsResponse]:
        """Retrieve data objects by searching across multiple data types

        Retrieve any data objects whose linked data matches all supplied conditions.   Note: An expression data query must be supplied.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_expression_data_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def omics_search_expression_data_as_user_without_preload_content(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve data objects by searching across multiple data types

        Retrieve any data objects whose linked data matches all supplied conditions.   Note: An expression data query must be supplied.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_expression_data_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _omics_search_expression_data_as_user_serialize(
        self,
        response_format,
        study_filter,
        study_query,
        sample_filter,
        sample_query,
        library_filter,
        library_query,
        preparation_filter,
        preparation_query,
        search_specific_terms,
        vx_query,
        vx_filter,
        ex_query,
        ex_filter,
        fx_query,
        fx_filter,
        use_versions,
        returned_metadata_fields,
        cursor,
        page_limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if study_filter is not None:
            
            _query_params.append(('studyFilter', study_filter))
            
        if study_query is not None:
            
            _query_params.append(('studyQuery', study_query))
            
        if sample_filter is not None:
            
            _query_params.append(('sampleFilter', sample_filter))
            
        if sample_query is not None:
            
            _query_params.append(('sampleQuery', sample_query))
            
        if library_filter is not None:
            
            _query_params.append(('libraryFilter', library_filter))
            
        if library_query is not None:
            
            _query_params.append(('libraryQuery', library_query))
            
        if preparation_filter is not None:
            
            _query_params.append(('preparationFilter', preparation_filter))
            
        if preparation_query is not None:
            
            _query_params.append(('preparationQuery', preparation_query))
            
        if search_specific_terms is not None:
            
            _query_params.append(('searchSpecificTerms', search_specific_terms))
            
        if vx_query is not None:
            
            _query_params.append(('vxQuery', vx_query))
            
        if vx_filter is not None:
            
            _query_params.append(('vxFilter', vx_filter))
            
        if ex_query is not None:
            
            _query_params.append(('exQuery', ex_query))
            
        if ex_filter is not None:
            
            _query_params.append(('exFilter', ex_filter))
            
        if fx_query is not None:
            
            _query_params.append(('fxQuery', fx_query))
            
        if fx_filter is not None:
            
            _query_params.append(('fxFilter', fx_filter))
            
        if use_versions is not None:
            
            _query_params.append(('useVersions', use_versions))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if page_limit is not None:
            
            _query_params.append(('pageLimit', page_limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-user/omics/expression/data',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def omics_search_expression_groups_as_user(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OmicsResponse:
        """Retrieve group objects by searching across multiple data types

        Retrieve group objects whose linked data matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_expression_groups_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def omics_search_expression_groups_as_user_with_http_info(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OmicsResponse]:
        """Retrieve group objects by searching across multiple data types

        Retrieve group objects whose linked data matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_expression_groups_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def omics_search_expression_groups_as_user_without_preload_content(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve group objects by searching across multiple data types

        Retrieve group objects whose linked data matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_expression_groups_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _omics_search_expression_groups_as_user_serialize(
        self,
        response_format,
        study_filter,
        study_query,
        sample_filter,
        sample_query,
        library_filter,
        library_query,
        preparation_filter,
        preparation_query,
        search_specific_terms,
        vx_query,
        vx_filter,
        ex_query,
        ex_filter,
        fx_query,
        fx_filter,
        use_versions,
        returned_metadata_fields,
        cursor,
        page_limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if study_filter is not None:
            
            _query_params.append(('studyFilter', study_filter))
            
        if study_query is not None:
            
            _query_params.append(('studyQuery', study_query))
            
        if sample_filter is not None:
            
            _query_params.append(('sampleFilter', sample_filter))
            
        if sample_query is not None:
            
            _query_params.append(('sampleQuery', sample_query))
            
        if library_filter is not None:
            
            _query_params.append(('libraryFilter', library_filter))
            
        if library_query is not None:
            
            _query_params.append(('libraryQuery', library_query))
            
        if preparation_filter is not None:
            
            _query_params.append(('preparationFilter', preparation_filter))
            
        if preparation_query is not None:
            
            _query_params.append(('preparationQuery', preparation_query))
            
        if search_specific_terms is not None:
            
            _query_params.append(('searchSpecificTerms', search_specific_terms))
            
        if vx_query is not None:
            
            _query_params.append(('vxQuery', vx_query))
            
        if vx_filter is not None:
            
            _query_params.append(('vxFilter', vx_filter))
            
        if ex_query is not None:
            
            _query_params.append(('exQuery', ex_query))
            
        if ex_filter is not None:
            
            _query_params.append(('exFilter', ex_filter))
            
        if fx_query is not None:
            
            _query_params.append(('fxQuery', fx_query))
            
        if fx_filter is not None:
            
            _query_params.append(('fxFilter', fx_filter))
            
        if use_versions is not None:
            
            _query_params.append(('useVersions', use_versions))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if page_limit is not None:
            
            _query_params.append(('pageLimit', page_limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-user/omics/expression/group',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def omics_search_flow_cytometry_data_as_user(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OmicsResponse:
        """Retrieve flow cytometry data objects by searching across multiple data types

        Retrieve flow cytometry data objects whose linked data matches all supplied conditions.  Note: A flow cytometry data query must be supplied.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_flow_cytometry_data_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def omics_search_flow_cytometry_data_as_user_with_http_info(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OmicsResponse]:
        """Retrieve flow cytometry data objects by searching across multiple data types

        Retrieve flow cytometry data objects whose linked data matches all supplied conditions.  Note: A flow cytometry data query must be supplied.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_flow_cytometry_data_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def omics_search_flow_cytometry_data_as_user_without_preload_content(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve flow cytometry data objects by searching across multiple data types

        Retrieve flow cytometry data objects whose linked data matches all supplied conditions.  Note: A flow cytometry data query must be supplied.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_flow_cytometry_data_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _omics_search_flow_cytometry_data_as_user_serialize(
        self,
        response_format,
        study_filter,
        study_query,
        sample_filter,
        sample_query,
        library_filter,
        library_query,
        preparation_filter,
        preparation_query,
        search_specific_terms,
        vx_query,
        vx_filter,
        ex_query,
        ex_filter,
        fx_query,
        fx_filter,
        use_versions,
        returned_metadata_fields,
        cursor,
        page_limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if study_filter is not None:
            
            _query_params.append(('studyFilter', study_filter))
            
        if study_query is not None:
            
            _query_params.append(('studyQuery', study_query))
            
        if sample_filter is not None:
            
            _query_params.append(('sampleFilter', sample_filter))
            
        if sample_query is not None:
            
            _query_params.append(('sampleQuery', sample_query))
            
        if library_filter is not None:
            
            _query_params.append(('libraryFilter', library_filter))
            
        if library_query is not None:
            
            _query_params.append(('libraryQuery', library_query))
            
        if preparation_filter is not None:
            
            _query_params.append(('preparationFilter', preparation_filter))
            
        if preparation_query is not None:
            
            _query_params.append(('preparationQuery', preparation_query))
            
        if search_specific_terms is not None:
            
            _query_params.append(('searchSpecificTerms', search_specific_terms))
            
        if vx_query is not None:
            
            _query_params.append(('vxQuery', vx_query))
            
        if vx_filter is not None:
            
            _query_params.append(('vxFilter', vx_filter))
            
        if ex_query is not None:
            
            _query_params.append(('exQuery', ex_query))
            
        if ex_filter is not None:
            
            _query_params.append(('exFilter', ex_filter))
            
        if fx_query is not None:
            
            _query_params.append(('fxQuery', fx_query))
            
        if fx_filter is not None:
            
            _query_params.append(('fxFilter', fx_filter))
            
        if use_versions is not None:
            
            _query_params.append(('useVersions', use_versions))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if page_limit is not None:
            
            _query_params.append(('pageLimit', page_limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-user/omics/flow-cytometry/data',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def omics_search_flow_cytometry_groups_as_user(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OmicsResponse:
        """Retrieve group objects by searching across multiple data types

        Retrieve group objects whose linked data matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_flow_cytometry_groups_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def omics_search_flow_cytometry_groups_as_user_with_http_info(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OmicsResponse]:
        """Retrieve group objects by searching across multiple data types

        Retrieve group objects whose linked data matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_flow_cytometry_groups_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def omics_search_flow_cytometry_groups_as_user_without_preload_content(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve group objects by searching across multiple data types

        Retrieve group objects whose linked data matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_flow_cytometry_groups_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _omics_search_flow_cytometry_groups_as_user_serialize(
        self,
        response_format,
        study_filter,
        study_query,
        sample_filter,
        sample_query,
        library_filter,
        library_query,
        preparation_filter,
        preparation_query,
        search_specific_terms,
        vx_query,
        vx_filter,
        ex_query,
        ex_filter,
        fx_query,
        fx_filter,
        use_versions,
        returned_metadata_fields,
        cursor,
        page_limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if study_filter is not None:
            
            _query_params.append(('studyFilter', study_filter))
            
        if study_query is not None:
            
            _query_params.append(('studyQuery', study_query))
            
        if sample_filter is not None:
            
            _query_params.append(('sampleFilter', sample_filter))
            
        if sample_query is not None:
            
            _query_params.append(('sampleQuery', sample_query))
            
        if library_filter is not None:
            
            _query_params.append(('libraryFilter', library_filter))
            
        if library_query is not None:
            
            _query_params.append(('libraryQuery', library_query))
            
        if preparation_filter is not None:
            
            _query_params.append(('preparationFilter', preparation_filter))
            
        if preparation_query is not None:
            
            _query_params.append(('preparationQuery', preparation_query))
            
        if search_specific_terms is not None:
            
            _query_params.append(('searchSpecificTerms', search_specific_terms))
            
        if vx_query is not None:
            
            _query_params.append(('vxQuery', vx_query))
            
        if vx_filter is not None:
            
            _query_params.append(('vxFilter', vx_filter))
            
        if ex_query is not None:
            
            _query_params.append(('exQuery', ex_query))
            
        if ex_filter is not None:
            
            _query_params.append(('exFilter', ex_filter))
            
        if fx_query is not None:
            
            _query_params.append(('fxQuery', fx_query))
            
        if fx_filter is not None:
            
            _query_params.append(('fxFilter', fx_filter))
            
        if use_versions is not None:
            
            _query_params.append(('useVersions', use_versions))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if page_limit is not None:
            
            _query_params.append(('pageLimit', page_limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-user/omics/flow-cytometry/group',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def omics_search_samples_as_user(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OmicsResponse:
        """Retrieve sample metadata objects by searching across multiple data types

        Retrieve sample metadata objects whose linked data matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_samples_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def omics_search_samples_as_user_with_http_info(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OmicsResponse]:
        """Retrieve sample metadata objects by searching across multiple data types

        Retrieve sample metadata objects whose linked data matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_samples_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def omics_search_samples_as_user_without_preload_content(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve sample metadata objects by searching across multiple data types

        Retrieve sample metadata objects whose linked data matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_samples_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _omics_search_samples_as_user_serialize(
        self,
        response_format,
        study_filter,
        study_query,
        sample_filter,
        sample_query,
        library_filter,
        library_query,
        preparation_filter,
        preparation_query,
        search_specific_terms,
        vx_query,
        vx_filter,
        ex_query,
        ex_filter,
        fx_query,
        fx_filter,
        use_versions,
        returned_metadata_fields,
        cursor,
        page_limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if study_filter is not None:
            
            _query_params.append(('studyFilter', study_filter))
            
        if study_query is not None:
            
            _query_params.append(('studyQuery', study_query))
            
        if sample_filter is not None:
            
            _query_params.append(('sampleFilter', sample_filter))
            
        if sample_query is not None:
            
            _query_params.append(('sampleQuery', sample_query))
            
        if library_filter is not None:
            
            _query_params.append(('libraryFilter', library_filter))
            
        if library_query is not None:
            
            _query_params.append(('libraryQuery', library_query))
            
        if preparation_filter is not None:
            
            _query_params.append(('preparationFilter', preparation_filter))
            
        if preparation_query is not None:
            
            _query_params.append(('preparationQuery', preparation_query))
            
        if search_specific_terms is not None:
            
            _query_params.append(('searchSpecificTerms', search_specific_terms))
            
        if vx_query is not None:
            
            _query_params.append(('vxQuery', vx_query))
            
        if vx_filter is not None:
            
            _query_params.append(('vxFilter', vx_filter))
            
        if ex_query is not None:
            
            _query_params.append(('exQuery', ex_query))
            
        if ex_filter is not None:
            
            _query_params.append(('exFilter', ex_filter))
            
        if fx_query is not None:
            
            _query_params.append(('fxQuery', fx_query))
            
        if fx_filter is not None:
            
            _query_params.append(('fxFilter', fx_filter))
            
        if use_versions is not None:
            
            _query_params.append(('useVersions', use_versions))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if page_limit is not None:
            
            _query_params.append(('pageLimit', page_limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-user/omics/samples',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def omics_search_streamed_expression_data_as_user(
        self,
        group_accession: Annotated[StrictStr, Field(description="Accession of the expression group object (GCT)")],
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g.`\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `features.NAME=1007_s_at` or `features.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `features.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `features.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `features.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < features.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `features.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `values.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < values.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `features.Name_1!=A`: Select all rows where Name_1 is not A.  * `features.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `features.Name_1=A AND features.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `features.Name_1=A && features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A OR features.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `features.Name_1=A || features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A AND (features.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        feature_list: Annotated[Optional[List[StrictStr]], Field(description="Deprecated; use `exQuery` parameter instead. Filters results by the feature column (e.g., Gene ID). The feature parameter value must match the name of the identifier in the GCT file (under the NAME column). Example: `ENSG00000077044`")] = None,
        round_digits: Annotated[Optional[StrictInt], Field(description="The number of digits after the decimal point for floating-point values. The final value is rounded up. Must be non-negative. The default is 4.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Stream data from a given tabular file

        Stream data from a given group for a tabular file that matches a sample/library/preparations query/filter. If no query/filters are supplied all expression data is returned. If a metadata filter is specified, this endpoint will only return expression data that is associated with a sample via the Sample Source ID attribute. ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Libraries (full-text or metadata key-value pair) 3. Preparations (full-text or metadata key-value pair) ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.     ## Error Handling   In case of unexpected internal error during data retrieval, the last line of the body will contain an error message, prefixed by the `#` character   

        :param group_accession: Accession of the expression group object (GCT) (required)
        :type group_accession: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g.`\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `features.NAME=1007_s_at` or `features.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `features.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `features.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `features.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < features.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `features.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `values.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < values.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `features.Name_1!=A`: Select all rows where Name_1 is not A.  * `features.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `features.Name_1=A AND features.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `features.Name_1=A && features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A OR features.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `features.Name_1=A || features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A AND (features.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param feature_list: Deprecated; use `exQuery` parameter instead. Filters results by the feature column (e.g., Gene ID). The feature parameter value must match the name of the identifier in the GCT file (under the NAME column). Example: `ENSG00000077044`
        :type feature_list: List[str]
        :param round_digits: The number of digits after the decimal point for floating-point values. The final value is rounded up. Must be non-negative. The default is 4.
        :type round_digits: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_streamed_expression_data_as_user_serialize(
            group_accession=group_accession,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            ex_query=ex_query,
            feature_list=feature_list,
            round_digits=round_digits,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def omics_search_streamed_expression_data_as_user_with_http_info(
        self,
        group_accession: Annotated[StrictStr, Field(description="Accession of the expression group object (GCT)")],
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g.`\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `features.NAME=1007_s_at` or `features.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `features.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `features.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `features.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < features.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `features.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `values.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < values.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `features.Name_1!=A`: Select all rows where Name_1 is not A.  * `features.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `features.Name_1=A AND features.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `features.Name_1=A && features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A OR features.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `features.Name_1=A || features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A AND (features.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        feature_list: Annotated[Optional[List[StrictStr]], Field(description="Deprecated; use `exQuery` parameter instead. Filters results by the feature column (e.g., Gene ID). The feature parameter value must match the name of the identifier in the GCT file (under the NAME column). Example: `ENSG00000077044`")] = None,
        round_digits: Annotated[Optional[StrictInt], Field(description="The number of digits after the decimal point for floating-point values. The final value is rounded up. Must be non-negative. The default is 4.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Stream data from a given tabular file

        Stream data from a given group for a tabular file that matches a sample/library/preparations query/filter. If no query/filters are supplied all expression data is returned. If a metadata filter is specified, this endpoint will only return expression data that is associated with a sample via the Sample Source ID attribute. ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Libraries (full-text or metadata key-value pair) 3. Preparations (full-text or metadata key-value pair) ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.     ## Error Handling   In case of unexpected internal error during data retrieval, the last line of the body will contain an error message, prefixed by the `#` character   

        :param group_accession: Accession of the expression group object (GCT) (required)
        :type group_accession: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g.`\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `features.NAME=1007_s_at` or `features.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `features.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `features.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `features.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < features.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `features.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `values.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < values.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `features.Name_1!=A`: Select all rows where Name_1 is not A.  * `features.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `features.Name_1=A AND features.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `features.Name_1=A && features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A OR features.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `features.Name_1=A || features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A AND (features.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param feature_list: Deprecated; use `exQuery` parameter instead. Filters results by the feature column (e.g., Gene ID). The feature parameter value must match the name of the identifier in the GCT file (under the NAME column). Example: `ENSG00000077044`
        :type feature_list: List[str]
        :param round_digits: The number of digits after the decimal point for floating-point values. The final value is rounded up. Must be non-negative. The default is 4.
        :type round_digits: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_streamed_expression_data_as_user_serialize(
            group_accession=group_accession,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            ex_query=ex_query,
            feature_list=feature_list,
            round_digits=round_digits,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def omics_search_streamed_expression_data_as_user_without_preload_content(
        self,
        group_accession: Annotated[StrictStr, Field(description="Accession of the expression group object (GCT)")],
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g.`\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `features.NAME=1007_s_at` or `features.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `features.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `features.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `features.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < features.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `features.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `values.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < values.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `features.Name_1!=A`: Select all rows where Name_1 is not A.  * `features.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `features.Name_1=A AND features.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `features.Name_1=A && features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A OR features.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `features.Name_1=A || features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A AND (features.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        feature_list: Annotated[Optional[List[StrictStr]], Field(description="Deprecated; use `exQuery` parameter instead. Filters results by the feature column (e.g., Gene ID). The feature parameter value must match the name of the identifier in the GCT file (under the NAME column). Example: `ENSG00000077044`")] = None,
        round_digits: Annotated[Optional[StrictInt], Field(description="The number of digits after the decimal point for floating-point values. The final value is rounded up. Must be non-negative. The default is 4.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Stream data from a given tabular file

        Stream data from a given group for a tabular file that matches a sample/library/preparations query/filter. If no query/filters are supplied all expression data is returned. If a metadata filter is specified, this endpoint will only return expression data that is associated with a sample via the Sample Source ID attribute. ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Libraries (full-text or metadata key-value pair) 3. Preparations (full-text or metadata key-value pair) ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.     ## Error Handling   In case of unexpected internal error during data retrieval, the last line of the body will contain an error message, prefixed by the `#` character   

        :param group_accession: Accession of the expression group object (GCT) (required)
        :type group_accession: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g.`\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `features.NAME=1007_s_at` or `features.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `features.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `features.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `features.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < features.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `features.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `values.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < values.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `features.Name_1!=A`: Select all rows where Name_1 is not A.  * `features.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `features.Name_1=A AND features.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `features.Name_1=A && features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A OR features.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `features.Name_1=A || features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A AND (features.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param feature_list: Deprecated; use `exQuery` parameter instead. Filters results by the feature column (e.g., Gene ID). The feature parameter value must match the name of the identifier in the GCT file (under the NAME column). Example: `ENSG00000077044`
        :type feature_list: List[str]
        :param round_digits: The number of digits after the decimal point for floating-point values. The final value is rounded up. Must be non-negative. The default is 4.
        :type round_digits: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_streamed_expression_data_as_user_serialize(
            group_accession=group_accession,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            ex_query=ex_query,
            feature_list=feature_list,
            round_digits=round_digits,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _omics_search_streamed_expression_data_as_user_serialize(
        self,
        group_accession,
        sample_filter,
        sample_query,
        library_filter,
        library_query,
        preparation_filter,
        preparation_query,
        search_specific_terms,
        ex_query,
        feature_list,
        round_digits,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'featureList': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if sample_filter is not None:
            
            _query_params.append(('sampleFilter', sample_filter))
            
        if sample_query is not None:
            
            _query_params.append(('sampleQuery', sample_query))
            
        if library_filter is not None:
            
            _query_params.append(('libraryFilter', library_filter))
            
        if library_query is not None:
            
            _query_params.append(('libraryQuery', library_query))
            
        if preparation_filter is not None:
            
            _query_params.append(('preparationFilter', preparation_filter))
            
        if preparation_query is not None:
            
            _query_params.append(('preparationQuery', preparation_query))
            
        if search_specific_terms is not None:
            
            _query_params.append(('searchSpecificTerms', search_specific_terms))
            
        if ex_query is not None:
            
            _query_params.append(('exQuery', ex_query))
            
        if feature_list is not None:
            
            _query_params.append(('featureList', feature_list))
            
        if group_accession is not None:
            
            _query_params.append(('groupAccession', group_accession))
            
        if round_digits is not None:
            
            _query_params.append(('roundDigits', round_digits))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/csv'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-user/omics/expression/streamed-data',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def omics_search_streamed_variant_data_as_user(
        self,
        group_accession: Annotated[StrictStr, Field(description="Accession of the variant group object (VCF)")],
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `features.NAME=1007_s_at` or `features.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `features.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `features.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `features.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < features.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `features.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `values.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < values.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `features.Name_1!=A`: Select all rows where Name_1 is not A.  * `features.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `features.Name_1=A AND features.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `features.Name_1=A && features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A OR features.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `features.Name_1=A || features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A AND (features.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> object:
        """Stream data from a given VCF file

        Stream data from a given group for a VCF file that matches a sample query/filter. If no query/filters are supplied all variant data is returned. If a metadata filter is specified, this endpoint will only return variant data that is associated with a sample via metadata attribute.  ## Conditions It is possible to supply conditions for Samples (full-text or metadata key-value pair)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  

        :param group_accession: Accession of the variant group object (VCF) (required)
        :type group_accession: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `features.NAME=1007_s_at` or `features.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `features.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `features.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `features.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < features.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `features.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `values.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < values.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `features.Name_1!=A`: Select all rows where Name_1 is not A.  * `features.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `features.Name_1=A AND features.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `features.Name_1=A && features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A OR features.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `features.Name_1=A || features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A AND (features.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_streamed_variant_data_as_user_serialize(
            group_accession=group_accession,
            sample_filter=sample_filter,
            sample_query=sample_query,
            search_specific_terms=search_specific_terms,
            ex_query=ex_query,
            vx_query=vx_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def omics_search_streamed_variant_data_as_user_with_http_info(
        self,
        group_accession: Annotated[StrictStr, Field(description="Accession of the variant group object (VCF)")],
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `features.NAME=1007_s_at` or `features.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `features.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `features.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `features.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < features.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `features.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `values.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < values.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `features.Name_1!=A`: Select all rows where Name_1 is not A.  * `features.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `features.Name_1=A AND features.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `features.Name_1=A && features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A OR features.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `features.Name_1=A || features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A AND (features.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[object]:
        """Stream data from a given VCF file

        Stream data from a given group for a VCF file that matches a sample query/filter. If no query/filters are supplied all variant data is returned. If a metadata filter is specified, this endpoint will only return variant data that is associated with a sample via metadata attribute.  ## Conditions It is possible to supply conditions for Samples (full-text or metadata key-value pair)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  

        :param group_accession: Accession of the variant group object (VCF) (required)
        :type group_accession: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `features.NAME=1007_s_at` or `features.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `features.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `features.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `features.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < features.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `features.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `values.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < values.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `features.Name_1!=A`: Select all rows where Name_1 is not A.  * `features.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `features.Name_1=A AND features.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `features.Name_1=A && features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A OR features.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `features.Name_1=A || features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A AND (features.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_streamed_variant_data_as_user_serialize(
            group_accession=group_accession,
            sample_filter=sample_filter,
            sample_query=sample_query,
            search_specific_terms=search_specific_terms,
            ex_query=ex_query,
            vx_query=vx_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def omics_search_streamed_variant_data_as_user_without_preload_content(
        self,
        group_accession: Annotated[StrictStr, Field(description="Accession of the variant group object (VCF)")],
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `features.NAME=1007_s_at` or `features.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `features.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `features.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `features.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < features.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `features.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `values.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < values.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `features.Name_1!=A`: Select all rows where Name_1 is not A.  * `features.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `features.Name_1=A AND features.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `features.Name_1=A && features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A OR features.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `features.Name_1=A || features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A AND (features.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Stream data from a given VCF file

        Stream data from a given group for a VCF file that matches a sample query/filter. If no query/filters are supplied all variant data is returned. If a metadata filter is specified, this endpoint will only return variant data that is associated with a sample via metadata attribute.  ## Conditions It is possible to supply conditions for Samples (full-text or metadata key-value pair)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  

        :param group_accession: Accession of the variant group object (VCF) (required)
        :type group_accession: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `features.NAME=1007_s_at` or `features.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `features.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `features.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `features.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < features.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `features.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `values.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < values.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `features.Name_1!=A`: Select all rows where Name_1 is not A.  * `features.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `features.Name_1=A AND features.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `features.Name_1=A && features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A OR features.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `features.Name_1=A || features.Name_2=B`: Equivalent to the example above.  * `features.Name_1=A AND (features.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_streamed_variant_data_as_user_serialize(
            group_accession=group_accession,
            sample_filter=sample_filter,
            sample_query=sample_query,
            search_specific_terms=search_specific_terms,
            ex_query=ex_query,
            vx_query=vx_query,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "object",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _omics_search_streamed_variant_data_as_user_serialize(
        self,
        group_accession,
        sample_filter,
        sample_query,
        search_specific_terms,
        ex_query,
        vx_query,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if sample_filter is not None:
            
            _query_params.append(('sampleFilter', sample_filter))
            
        if sample_query is not None:
            
            _query_params.append(('sampleQuery', sample_query))
            
        if search_specific_terms is not None:
            
            _query_params.append(('searchSpecificTerms', search_specific_terms))
            
        if ex_query is not None:
            
            _query_params.append(('exQuery', ex_query))
            
        if vx_query is not None:
            
            _query_params.append(('vxQuery', vx_query))
            
        if group_accession is not None:
            
            _query_params.append(('groupAccession', group_accession))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'text/tab-separated-values'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-user/omics/variant/streamed-data',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def omics_search_variant_data_as_user(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OmicsResponse:
        """Retrieve variant data objects by searching across multiple data types

        Retrieve variant data objects whose linked data matches all supplied conditions.  Note: A variant data query must be supplied.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked expression objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_variant_data_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def omics_search_variant_data_as_user_with_http_info(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OmicsResponse]:
        """Retrieve variant data objects by searching across multiple data types

        Retrieve variant data objects whose linked data matches all supplied conditions.  Note: A variant data query must be supplied.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked expression objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_variant_data_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def omics_search_variant_data_as_user_without_preload_content(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve variant data objects by searching across multiple data types

        Retrieve variant data objects whose linked data matches all supplied conditions.  Note: A variant data query must be supplied.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked expression objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_variant_data_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _omics_search_variant_data_as_user_serialize(
        self,
        response_format,
        study_filter,
        study_query,
        sample_filter,
        sample_query,
        library_filter,
        library_query,
        preparation_filter,
        preparation_query,
        search_specific_terms,
        vx_query,
        vx_filter,
        ex_query,
        ex_filter,
        fx_query,
        fx_filter,
        use_versions,
        returned_metadata_fields,
        cursor,
        page_limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if study_filter is not None:
            
            _query_params.append(('studyFilter', study_filter))
            
        if study_query is not None:
            
            _query_params.append(('studyQuery', study_query))
            
        if sample_filter is not None:
            
            _query_params.append(('sampleFilter', sample_filter))
            
        if sample_query is not None:
            
            _query_params.append(('sampleQuery', sample_query))
            
        if library_filter is not None:
            
            _query_params.append(('libraryFilter', library_filter))
            
        if library_query is not None:
            
            _query_params.append(('libraryQuery', library_query))
            
        if preparation_filter is not None:
            
            _query_params.append(('preparationFilter', preparation_filter))
            
        if preparation_query is not None:
            
            _query_params.append(('preparationQuery', preparation_query))
            
        if search_specific_terms is not None:
            
            _query_params.append(('searchSpecificTerms', search_specific_terms))
            
        if vx_query is not None:
            
            _query_params.append(('vxQuery', vx_query))
            
        if vx_filter is not None:
            
            _query_params.append(('vxFilter', vx_filter))
            
        if ex_query is not None:
            
            _query_params.append(('exQuery', ex_query))
            
        if ex_filter is not None:
            
            _query_params.append(('exFilter', ex_filter))
            
        if fx_query is not None:
            
            _query_params.append(('fxQuery', fx_query))
            
        if fx_filter is not None:
            
            _query_params.append(('fxFilter', fx_filter))
            
        if use_versions is not None:
            
            _query_params.append(('useVersions', use_versions))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if page_limit is not None:
            
            _query_params.append(('pageLimit', page_limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-user/omics/variant/data',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def omics_search_variant_groups_as_user(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        reference_genome_id: Annotated[Optional[StrictStr], Field(description="Unique identifier (accession) of Reference Genome object.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> OmicsResponse:
        """Retrieve group objects by searching across multiple data types

        Retrieve group objects whose linked data matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param reference_genome_id: Unique identifier (accession) of Reference Genome object.
        :type reference_genome_id: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_variant_groups_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            reference_genome_id=reference_genome_id,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def omics_search_variant_groups_as_user_with_http_info(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        reference_genome_id: Annotated[Optional[StrictStr], Field(description="Unique identifier (accession) of Reference Genome object.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[OmicsResponse]:
        """Retrieve group objects by searching across multiple data types

        Retrieve group objects whose linked data matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param reference_genome_id: Unique identifier (accession) of Reference Genome object.
        :type reference_genome_id: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_variant_groups_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            reference_genome_id=reference_genome_id,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def omics_search_variant_groups_as_user_without_preload_content(
        self,
        response_format: Annotated[Optional[ResponseFormat], Field(description="Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.")] = None,
        study_filter: Annotated[Optional[StrictStr], Field(description="Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` ")] = None,
        study_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        sample_filter: Annotated[Optional[StrictStr], Field(description="Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` ")] = None,
        sample_query: Annotated[Optional[StrictStr], Field(description="Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        library_filter: Annotated[Optional[StrictStr], Field(description="Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`")] = None,
        library_query: Annotated[Optional[StrictStr], Field(description="Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        preparation_filter: Annotated[Optional[StrictStr], Field(description="Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`")] = None,
        preparation_query: Annotated[Optional[StrictStr], Field(description="Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.")] = None,
        search_specific_terms: Annotated[Optional[StrictBool], Field(description="If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.")] = None,
        vx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.")] = None,
        vx_filter: Annotated[Optional[StrictStr], Field(description="Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.")] = None,
        ex_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.")] = None,
        ex_filter: Annotated[Optional[StrictStr], Field(description="Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.")] = None,
        fx_query: Annotated[Optional[StrictStr], Field(description="Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`")] = None,
        fx_filter: Annotated[Optional[StrictStr], Field(description="Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.")] = None,
        reference_genome_id: Annotated[Optional[StrictStr], Field(description="Unique identifier (accession) of Reference Genome object.")] = None,
        use_versions: Annotated[Optional[StrictStr], Field(description="Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`")] = None,
        returned_metadata_fields: Annotated[Optional[StrictStr], Field(description="The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="The page tag to resume results from (see paging above).")] = None,
        page_limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve group objects by searching across multiple data types

        Retrieve group objects whose linked data matches all supplied conditions.  ## Conditions It is possible to supply conditions for:  1. Samples (full-text or metadata key-value pair) 2. Parent studies (full-text or metadata key-value pair) 3. Linked variant objects (list of data key-value pairs) 4. Linked flow cytometry objects (list of data key-value pairs) 5. Linked any data (except variant and flow cytometry) objects (list of data key-value pairs)  ## Metadata full-text queries Single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace. Speech marks and backslash characters in the query need to be escaped with a backslash (`\\`).  ## Metadata filters Metadata filters are key-value pairs joined by an operator. The `=` operator matches literal values/string. The `!=` operator matches anything except the literal value/string. The `<` or `>` operators match numerical results that are less or greater than the supplied value. Strings containing whitespace need to be quoted with (`\"`).  ## Data queries Data queries must be a list of key-value pairs, separated by whitespace. The set of valid keys depends on the specific query type, and is documented in the query parameter summary. The values can be simple non-whitespace strings, or strings enclosed by speech marks (`\"`). Depending on the key, the value may be be a comma-delimited list of string values. Others require numerical values. Ranges can be supplied with `(0:1)` syntax, OR values with `|`.  ## Combinations Metadata queries/filters for the same parameter can be combined with `&&`, `AND`, `||` and `OR` operators, using white-space to separate out the terms and operators. Parentheses `( )` can be used for complex expressions.  ## Versioning Specific versions of omics data files (eg. GCT) can be queried via the useVersions parameter. Different versions of an omics data file are associated via their CHAIN_ID metadata value. This CHAIN_ID can be supplied to the useVersions parameter along with the version number or specific omics data file accessions to include them in the query. If nothing is supplied to the useVersions parameter then only the active version (which is usually the last one imported) is queried. This acts as a filter before the rest of the query is carried out.  Example usage: useVersions=* (query all versions, including those without CHAIN_IDs) useVersions=v2 (query the second version. If there is no second version then the data file is not queried) useVersions=v1,v0 (query the first version and any data files without CHAIN_IDs(v0) ) useVersions=GSVC002:v3 (for omics data files with a CHAIN_ID of GSCV002 query the third version) useVersions=GSVC002:GSF00494,GSF000496 (for omics data files with a CHAIN_ID of GSCV002 query only the specific accessions GSF00494 and GSF000496)  Rules for multiple CHAIN_IDs can be supplied to the parameter using the ; separator.  ## Paging For performance reasons this endpoint returns results in \"pages\" of limited size together with a `cursor` tag. To retrieve the next page of results please supply this `cursor` tag to resume the query from your previous result and get the next page. If there are no more results you will just retrieve an empty result.  

        :param response_format: Supply this parameter with the value `term_id` as part of the query to return extended information including IDs for values and dictionaries.
        :type response_format: ResponseFormat
        :param study_filter: Filter by study metadata (key-value metadata pair(s)). E.g. `\"Study Source\"=ArrayExpress` 
        :type study_filter: str
        :param study_query: Search for objects via a full-text query over all study metadata fields. E.g. `\"RNA-Seq of human dendritic cells\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type study_query: str
        :param sample_filter: Filter by sample metadata (key-value metadata pair(s)). E.g. `\"Species or strain\"=\"Homo sapiens\"` 
        :type sample_filter: str
        :param sample_query: Search for objects via a full-text query over all sample metadata fields. E.g. `Clozapine`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type sample_query: str
        :param library_filter: Filter by library metadata (key-value metadata pair(s)). E.g. `\"Library Type\"=RNA-Seq-1`
        :type library_filter: str
        :param library_query: Search for library objects via a full-text query over all library metadata fields. E.g. `\"illumina HiSeq500\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type library_query: str
        :param preparation_filter: Filter by preparation metadata (key-value metadata pair(s)). E.g. `Digestion=Trypsin`
        :type preparation_filter: str
        :param preparation_query: Search for preparation objects via a full-text query over all preparation metadata fields. E.g. `\"reversed-phase liquid chromatography\"`. Queries matching dictionary terms are automatically expanded to include synonyms.
        :type preparation_query: str
        :param search_specific_terms: If the full-text query term is present in an ODM dictionary, enabling this parameter will modify the query to include child terms of the full-text query.  For example, the search query \"Body fluid\" can be expanded to include the term \"Blood\" (a child term of  \"Body fluid\") so files containing either \"Body fluid\" or  \"Blood\"  in their metadata will be returned in the search results.  The parent-child relationship is defined by the key \"broaders\" or \"subClassOf\"  in the dictionary.  If the full query term is not present in a dictionary then this parameter has no effect.
        :type search_specific_terms: bool
        :param vx_query: Search for objects linked to variant data by SNPs properties. Filtering is currently supported by `filter`, `id`, `region` and `info` keywords, as well as `exists` keyword for `INFO` field and their logical combinations by means of `not` (`!`), `and` (`&&`), and `or` (`||`) operators with standard boolean precedence. Keyword case is ignored.  * `filter` corresponds to the `FILTER` column in the original vcf file. Could be either equals or not equals to `PASS` : `filter = PASS` or `filter != pass`.  * `id` is a string value that corresponds to the `ID` column. Multiple values could be added via a comma. Expression `id = rs3214,rg1234` is equivalent to `id = rs3214 or id = rg1234`.  * `region` corresponds to CHROM and POS columns. Supports querying by the whole chromosome `region = chr1` , by interval within a chromosome `region = chr1:4567-9876543` by exact position `region = chr1:456789` or by indefinite ranges like `region = x:3456789-*` . Multiple regions could be separated via comma, e.g. `region = chr1:34567-98767,chr3` is equivalent to  `region = chr1:34567-98767 or region = chr3`.  * `feature` is the name of the reference gene associated with a specific location in the reference genome which corresponds to the VCF file (variant group) from which the variant information is derived. By providing the gene name(s), such as `feature=TP53` or `feature=TP53,TGFB`, variants located within the same genomic region as the specified gene(s) will be retrieved.  * Filter by vcf `INFO` fields. E.g. to filter all variants annotated in dbSNP add `exists(INFO.KEY)`. Use `!exists(INFO.KEY)` to exclude variants having the key from the search results. Provide `info.key=value` pair to search for an exact match or `info.key!=value` to exclude it from the search. Due to the limits of precision in floating point numbers, we use a small range of 0.0000001 to identify close matches. This means any differences smaller than that won't be detected. For more precise results, please use range queries.
        :type vx_query: str
        :param vx_filter: Filter by variant metadata (key-value metadata pair(s)). E.g. `\"Variant Source\"=dbSNP`.
        :type vx_filter: str
        :param ex_query: Search for objects linked to expression data and originally uploaded in TSV or GCT format via data query, e.g., `feature=ENSG00000230368,ENSG00000188976 value>=1.50`  For the case when the original data is represented by multiple attributes per feature scenarios, extended filtering syntax is as follows:  1. By feature attribute value for numeric and string attributes: `feature.NAME=1007_s_at` or `feature.\"Average Mz\"=2.218`. As in the case of sample metadata queries, single words can be supplied as is; otherwise, use speech marks (`\"`) to quote queries that include whitespace.  2. It is possible to specify a set of possible values, separated by comma: `feature.NAME=1007_s_at,121_at`.  3. Utilize range filters to search numeric attributes. Apply `<` (less than), `>` (greater than), and `=` (equal to) symbols to specify the desired ranges as follows:  `feature.Name_1 > 3`: Select all rows where the feature attribute Name_1 values are greater than 3.  `feature.Name_2 >= 6`: Select all rows where the feature attribute Name_2 values are greater than or equal to 6.  `-3 < feature.Name_3 < 3`: Select all rows where the feature attribute Name_3 values lie within the interval between -3 and 3.  4. Use substring search to get the records where the attribute field contains the provided substring: `feature.attribute1 =~ \"some text\"`.  5. The first column for each original data file is identified as feature accession (typically, it contains gene or protein names, accession IDs, etc.). Searching by such feature accession would significantly outperform more complex queries by combining the other feature attributes. To enable such a search, use `feature` without any attribute extension, e.g., `feature=ENSG00000230368,ENSG00000188976`.   The `value` keyword can be used to select rows where the sample (library or preparation) measurements has values from a certain range. Examples: `value = 3`, `value > 3`, `-3 < value < 3`. When the original data contains multiple measurements for a single item, such as a sample (library or preparation), use the measurement name to specify the exact column type, e.g.:  1. `value.intensity = 3`: Selects all rows where the measurement attribute intensity equals 3.   `value.intensity != 2,null`: Select all rows where the measurement attribute intensity is not equal 2 and is not an empty value.  `value.p_value > 3`: Selects all rows where the measurement attribute 'p_value' values are greater than 3.  `-3 < value.FC < 3`: Selects all rows where the measurement attribute 'FC' values lie within the interval between -3 and 3.   2. Note: The `MinValue` keyword has been deprecated and should be replaced with the aforementioned comparisons.   Combine multiple filters for different feature attributes and measurements using `AND` (`&&`), `OR` (`||`) logical operators and parentheses:  * `feature.Name_1!=A`: Select all rows where Name_1 is not A.  * `feature.Name_1!=A,B,C`: Select all rows where Name_1 is not A, B, or C.  * `feature.Name_1=A AND feature.Name_2=B`: Select all rows where Name_1 is A and Name_2 is B.  * `feature.Name_1=A && feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A OR feature.Name_2=B`: Select all rows where Name_1 is A or Name_2 is B.  * `feature.Name_1=A || feature.Name_2=B`: Equivalent to the example above.  * `feature.Name_1=A AND (feature.Name_2=B OR value>=1.0)`: Select all rows where Name_1 is A and either Name_2 is B or minimal possible measurement value is 1.0.
        :type ex_query: str
        :param ex_filter: Filter by expression metadata (key-value metadata pair(s)). E.g. `\"Genome Version\"=hg19-BROAD`.
        :type ex_filter: str
        :param fx_query: Search for objects linked to flow cytometry data via data query (key-value pair(s)). E.g. `ReadoutType=Median|Count` `CellPopulation=\"CD45+, live\"` `MinValue=3.5`
        :type fx_query: str
        :param fx_filter: Filter by flow cytometry metadata (key-value metadata pair(s)). E.g. `Organ=blood`.
        :type fx_filter: str
        :param reference_genome_id: Unique identifier (accession) of Reference Genome object.
        :type reference_genome_id: str
        :param use_versions: Specify which versions of omics data files are used in the query. By default the active version is used. See Versioning above. Syntax:  \\* or `v<version number>` or `<CHAIN_ID>`:`v<version number>` or `<CHAIN_ID>`:`<accession1,accession2,..>`
        :type use_versions: str
        :param returned_metadata_fields: The parameter defines amount of metadata attributes to return:  1. `minimal_data` - return metadata attributes according to the default template. 2. `extended_data_included` - return metadata attributes according to applied template, if object doesn’t have applied template default template will be used. This is the default for User endpoints. 3. `original_data_included` - return all metadata attributes with values and null attributes, if they are present in the applied template. This is the default for Curator endpoints.
        :type returned_metadata_fields: str
        :param cursor: The page tag to resume results from (see paging above).
        :type cursor: str
        :param page_limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type page_limit: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._omics_search_variant_groups_as_user_serialize(
            response_format=response_format,
            study_filter=study_filter,
            study_query=study_query,
            sample_filter=sample_filter,
            sample_query=sample_query,
            library_filter=library_filter,
            library_query=library_query,
            preparation_filter=preparation_filter,
            preparation_query=preparation_query,
            search_specific_terms=search_specific_terms,
            vx_query=vx_query,
            vx_filter=vx_filter,
            ex_query=ex_query,
            ex_filter=ex_filter,
            fx_query=fx_query,
            fx_filter=fx_filter,
            reference_genome_id=reference_genome_id,
            use_versions=use_versions,
            returned_metadata_fields=returned_metadata_fields,
            cursor=cursor,
            page_limit=page_limit,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "OmicsResponse",
            '400': None,
            '401': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _omics_search_variant_groups_as_user_serialize(
        self,
        response_format,
        study_filter,
        study_query,
        sample_filter,
        sample_query,
        library_filter,
        library_query,
        preparation_filter,
        preparation_query,
        search_specific_terms,
        vx_query,
        vx_filter,
        ex_query,
        ex_filter,
        fx_query,
        fx_filter,
        reference_genome_id,
        use_versions,
        returned_metadata_fields,
        cursor,
        page_limit,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if response_format is not None:
            
            _query_params.append(('responseFormat', response_format.value))
            
        if study_filter is not None:
            
            _query_params.append(('studyFilter', study_filter))
            
        if study_query is not None:
            
            _query_params.append(('studyQuery', study_query))
            
        if sample_filter is not None:
            
            _query_params.append(('sampleFilter', sample_filter))
            
        if sample_query is not None:
            
            _query_params.append(('sampleQuery', sample_query))
            
        if library_filter is not None:
            
            _query_params.append(('libraryFilter', library_filter))
            
        if library_query is not None:
            
            _query_params.append(('libraryQuery', library_query))
            
        if preparation_filter is not None:
            
            _query_params.append(('preparationFilter', preparation_filter))
            
        if preparation_query is not None:
            
            _query_params.append(('preparationQuery', preparation_query))
            
        if search_specific_terms is not None:
            
            _query_params.append(('searchSpecificTerms', search_specific_terms))
            
        if vx_query is not None:
            
            _query_params.append(('vxQuery', vx_query))
            
        if vx_filter is not None:
            
            _query_params.append(('vxFilter', vx_filter))
            
        if ex_query is not None:
            
            _query_params.append(('exQuery', ex_query))
            
        if ex_filter is not None:
            
            _query_params.append(('exFilter', ex_filter))
            
        if fx_query is not None:
            
            _query_params.append(('fxQuery', fx_query))
            
        if fx_filter is not None:
            
            _query_params.append(('fxFilter', fx_filter))
            
        if reference_genome_id is not None:
            
            _query_params.append(('referenceGenomeId', reference_genome_id))
            
        if use_versions is not None:
            
            _query_params.append(('useVersions', use_versions))
            
        if returned_metadata_fields is not None:
            
            _query_params.append(('returnedMetadataFields', returned_metadata_fields))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        if page_limit is not None:
            
            _query_params.append(('pageLimit', page_limit))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/as-user/omics/variant/group',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


