# coding: utf-8

"""
    ODM API

    This swagger page describes the variantUser API endpoints for ODM. These are typically used to find and retrieve variant data and metadata.  Before carrying out any API calls you will need an API token. API tokens can be obtained under your profile within the Genestack software.  To try out calls in this swagger page:  1.  Click the 'Authorize' button below to enter your API token 2.  Scroll to the 'Parameters' section for the method you wish to try out and click the 'Try it out' button 3.  Enter parameter values that you wish to try 4.  Scroll to the bottom of the Parameters section and click the 'Execute' bar that appears    The server response will be in the section that follows.

    The version of the OpenAPI document: default-released
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr
from typing import List, Optional
from typing_extensions import Annotated
from odm_api.models.detached_collection import DetachedCollection
from odm_api.models.managed_object import ManagedObject

from odm_api.api_client import ApiClient, RequestSerialized
from odm_api.api_response import ApiResponse
from odm_api.rest import RESTResponseType


class ManageDataApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def delete_data(
        self,
        accessions: Annotated[Optional[List[StrictStr]], Field(description="Accessions files to be deleted.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ManagedObject:
        """Delete objects from ODM

        The objects will be marked for deletion. In case the selected object has more than one version, the endpoint deletes all of them. The following object types can be deleted by the endpoint:  * `STUDY`  * `SAMPLE_GROUP`   * `LIBRARY_GROUP`   * `PREPARATION_GROUP`   * `TABULAR_DATA`  * `GENE_VARIANT`  * `FLOW_CYTOMETRY`  * `REFERENCE_GENOME`  * `FILE`   Moreover, if the selected object is linked to any other data, the endpoint will also delete the linked data associated with it according to the specified rules:  * If you delete a `STUDY`, the entire study with all the listed group types and files, will be removed.  * Deleting a `SAMPLE_GROUP` will result in the removal of all samples associated with this sample group, along with any linked `TABULAR_DATA`/`GENE_VARIANT`/`FLOW_CYTOMETRY`/`LIBRARY_GROUP`/`PREPARATION_GROUP`. The linked `TABULAR_DATA`/`GENE_VARIANT`/`FLOW_CYTOMETRY` will be deleted, even if it is linked to another metadata group.  * If you delete `TABULAR_DATA`/`GENE_VARIANT`/`FLOW_CYTOMETRY`, all associated data, such as links and runs will be removed from ODM.  * If you delete `REFERENCE_GENOME`, searching for variant by variantFeature (genes) won't be available for linked VCF groups.  * If you delete `FILE`, the file will be removed from ODM.

        :param accessions: Accessions files to be deleted.
        :type accessions: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_data_serialize(
            accessions=accessions,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "ManagedObject",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '406': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_data_with_http_info(
        self,
        accessions: Annotated[Optional[List[StrictStr]], Field(description="Accessions files to be deleted.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[ManagedObject]:
        """Delete objects from ODM

        The objects will be marked for deletion. In case the selected object has more than one version, the endpoint deletes all of them. The following object types can be deleted by the endpoint:  * `STUDY`  * `SAMPLE_GROUP`   * `LIBRARY_GROUP`   * `PREPARATION_GROUP`   * `TABULAR_DATA`  * `GENE_VARIANT`  * `FLOW_CYTOMETRY`  * `REFERENCE_GENOME`  * `FILE`   Moreover, if the selected object is linked to any other data, the endpoint will also delete the linked data associated with it according to the specified rules:  * If you delete a `STUDY`, the entire study with all the listed group types and files, will be removed.  * Deleting a `SAMPLE_GROUP` will result in the removal of all samples associated with this sample group, along with any linked `TABULAR_DATA`/`GENE_VARIANT`/`FLOW_CYTOMETRY`/`LIBRARY_GROUP`/`PREPARATION_GROUP`. The linked `TABULAR_DATA`/`GENE_VARIANT`/`FLOW_CYTOMETRY` will be deleted, even if it is linked to another metadata group.  * If you delete `TABULAR_DATA`/`GENE_VARIANT`/`FLOW_CYTOMETRY`, all associated data, such as links and runs will be removed from ODM.  * If you delete `REFERENCE_GENOME`, searching for variant by variantFeature (genes) won't be available for linked VCF groups.  * If you delete `FILE`, the file will be removed from ODM.

        :param accessions: Accessions files to be deleted.
        :type accessions: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_data_serialize(
            accessions=accessions,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "ManagedObject",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '406': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_data_without_preload_content(
        self,
        accessions: Annotated[Optional[List[StrictStr]], Field(description="Accessions files to be deleted.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete objects from ODM

        The objects will be marked for deletion. In case the selected object has more than one version, the endpoint deletes all of them. The following object types can be deleted by the endpoint:  * `STUDY`  * `SAMPLE_GROUP`   * `LIBRARY_GROUP`   * `PREPARATION_GROUP`   * `TABULAR_DATA`  * `GENE_VARIANT`  * `FLOW_CYTOMETRY`  * `REFERENCE_GENOME`  * `FILE`   Moreover, if the selected object is linked to any other data, the endpoint will also delete the linked data associated with it according to the specified rules:  * If you delete a `STUDY`, the entire study with all the listed group types and files, will be removed.  * Deleting a `SAMPLE_GROUP` will result in the removal of all samples associated with this sample group, along with any linked `TABULAR_DATA`/`GENE_VARIANT`/`FLOW_CYTOMETRY`/`LIBRARY_GROUP`/`PREPARATION_GROUP`. The linked `TABULAR_DATA`/`GENE_VARIANT`/`FLOW_CYTOMETRY` will be deleted, even if it is linked to another metadata group.  * If you delete `TABULAR_DATA`/`GENE_VARIANT`/`FLOW_CYTOMETRY`, all associated data, such as links and runs will be removed from ODM.  * If you delete `REFERENCE_GENOME`, searching for variant by variantFeature (genes) won't be available for linked VCF groups.  * If you delete `FILE`, the file will be removed from ODM.

        :param accessions: Accessions files to be deleted.
        :type accessions: List[str]
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_data_serialize(
            accessions=accessions,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '202': "ManagedObject",
            '400': None,
            '401': None,
            '403': None,
            '404': None,
            '406': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_data_serialize(
        self,
        accessions,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'accessions': 'csv',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if accessions is not None:
            
            _query_params.append(('accessions', accessions))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v1/manage-data/data',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_detached_objects(
        self,
        detached_object_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by detached object type. Multiple values can be used to filter the data.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="This parameter enables retrieval of objects starting from a specific point.  Currently, it represents the accession of the last obtained object. However, please note that its functionality might change over time, so it is advisable to consider the cursor's content as a general string.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> DetachedCollection:
        """Retrieve a list of detached objects

        Retrieve various types of detached data objects. An object is defined as 'detached' if it lacks any direct or indirect link to a root-level object, which in this context is referred to as 'study'. Study is considered as detached object itself in case there are no links to objects at a lower level. Data with specific `detachedObjectType` can be retrieved by specifying the types in `detachedObjectType` parameter. The detached objects are sorted according to their `detachedObjectType` and `genestack:accession`. Specific ordering can be observed in the list of supported detached types found below. Pagination of the results can be conveniently managed using the `cursor` and `limit` parameters.  Supported types of detached objects (listed in the order of retrieval) include:  * `STUDY`  * `SAMPLE_GROUP`  * `LIBRARY_GROUP`  * `PREPARATION_GROUP`  * `TABULAR_DATA`  * `GENE_VARIANT`  * `FLOW_CYTOMETRY`  

        :param detached_object_type: Filter by detached object type. Multiple values can be used to filter the data.
        :type detached_object_type: List[str]
        :param limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type limit: int
        :param cursor: This parameter enables retrieval of objects starting from a specific point.  Currently, it represents the accession of the last obtained object. However, please note that its functionality might change over time, so it is advisable to consider the cursor's content as a general string.
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_detached_objects_serialize(
            detached_object_type=detached_object_type,
            limit=limit,
            cursor=cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DetachedCollection",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_detached_objects_with_http_info(
        self,
        detached_object_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by detached object type. Multiple values can be used to filter the data.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="This parameter enables retrieval of objects starting from a specific point.  Currently, it represents the accession of the last obtained object. However, please note that its functionality might change over time, so it is advisable to consider the cursor's content as a general string.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[DetachedCollection]:
        """Retrieve a list of detached objects

        Retrieve various types of detached data objects. An object is defined as 'detached' if it lacks any direct or indirect link to a root-level object, which in this context is referred to as 'study'. Study is considered as detached object itself in case there are no links to objects at a lower level. Data with specific `detachedObjectType` can be retrieved by specifying the types in `detachedObjectType` parameter. The detached objects are sorted according to their `detachedObjectType` and `genestack:accession`. Specific ordering can be observed in the list of supported detached types found below. Pagination of the results can be conveniently managed using the `cursor` and `limit` parameters.  Supported types of detached objects (listed in the order of retrieval) include:  * `STUDY`  * `SAMPLE_GROUP`  * `LIBRARY_GROUP`  * `PREPARATION_GROUP`  * `TABULAR_DATA`  * `GENE_VARIANT`  * `FLOW_CYTOMETRY`  

        :param detached_object_type: Filter by detached object type. Multiple values can be used to filter the data.
        :type detached_object_type: List[str]
        :param limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type limit: int
        :param cursor: This parameter enables retrieval of objects starting from a specific point.  Currently, it represents the accession of the last obtained object. However, please note that its functionality might change over time, so it is advisable to consider the cursor's content as a general string.
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_detached_objects_serialize(
            detached_object_type=detached_object_type,
            limit=limit,
            cursor=cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DetachedCollection",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_detached_objects_without_preload_content(
        self,
        detached_object_type: Annotated[Optional[List[StrictStr]], Field(description="Filter by detached object type. Multiple values can be used to filter the data.")] = None,
        limit: Annotated[Optional[StrictInt], Field(description="This parameter determines the number of results to retrieve per page, with the default set at 2000.")] = None,
        cursor: Annotated[Optional[StrictStr], Field(description="This parameter enables retrieval of objects starting from a specific point.  Currently, it represents the accession of the last obtained object. However, please note that its functionality might change over time, so it is advisable to consider the cursor's content as a general string.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve a list of detached objects

        Retrieve various types of detached data objects. An object is defined as 'detached' if it lacks any direct or indirect link to a root-level object, which in this context is referred to as 'study'. Study is considered as detached object itself in case there are no links to objects at a lower level. Data with specific `detachedObjectType` can be retrieved by specifying the types in `detachedObjectType` parameter. The detached objects are sorted according to their `detachedObjectType` and `genestack:accession`. Specific ordering can be observed in the list of supported detached types found below. Pagination of the results can be conveniently managed using the `cursor` and `limit` parameters.  Supported types of detached objects (listed in the order of retrieval) include:  * `STUDY`  * `SAMPLE_GROUP`  * `LIBRARY_GROUP`  * `PREPARATION_GROUP`  * `TABULAR_DATA`  * `GENE_VARIANT`  * `FLOW_CYTOMETRY`  

        :param detached_object_type: Filter by detached object type. Multiple values can be used to filter the data.
        :type detached_object_type: List[str]
        :param limit: This parameter determines the number of results to retrieve per page, with the default set at 2000.
        :type limit: int
        :param cursor: This parameter enables retrieval of objects starting from a specific point.  Currently, it represents the accession of the last obtained object. However, please note that its functionality might change over time, so it is advisable to consider the cursor's content as a general string.
        :type cursor: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_detached_objects_serialize(
            detached_object_type=detached_object_type,
            limit=limit,
            cursor=cursor,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "DetachedCollection",
            '400': None,
            '401': None,
            '403': None,
            '500': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_detached_objects_serialize(
        self,
        detached_object_type,
        limit,
        cursor,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'detachedObjectType': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if detached_object_type is not None:
            
            _query_params.append(('detachedObjectType', detached_object_type))
            
        if limit is not None:
            
            _query_params.append(('limit', limit))
            
        if cursor is not None:
            
            _query_params.append(('cursor', cursor))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/manage-data/detached-objects',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


