# coding: utf-8

"""
    ODM API

    This swagger page describes the variantUser API endpoints for ODM. These are typically used to find and retrieve variant data and metadata.  Before carrying out any API calls you will need an API token. API tokens can be obtained under your profile within the Genestack software.  To try out calls in this swagger page:  1.  Click the 'Authorize' button below to enter your API token 2.  Scroll to the 'Parameters' section for the method you wish to try out and click the 'Try it out' button 3.  Enter parameter values that you wish to try 4.  Scroll to the bottom of the Parameters section and click the 'Execute' bar that appears    The server response will be in the section that follows.

    The version of the OpenAPI document: default-released
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from pydantic import Field, StrictInt, StrictStr
from typing import Optional
from typing_extensions import Annotated
from odm_api.models.create_group201_response import CreateGroup201Response
from odm_api.models.create_group_request import CreateGroupRequest
from odm_api.models.filter_groups_response import FilterGroupsResponse
from odm_api.models.group_patch import GroupPatch

from odm_api.api_client import ApiClient, RequestSerialized
from odm_api.api_response import ApiResponse
from odm_api.rest import RESTResponseType


class GroupsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def create_group(
        self,
        body: CreateGroupRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateGroup201Response:
        """Add a new user group

        The endpoint creates a new user group in ODM. The endpoint does not update an existing group. A user who calls the endpoint is added to the group automatically with the \"Group admin\" role. The \"members\" attribute in the request body must be empty, otherwise the endpoint returns an error.  The endpoint does not require any user permission.  The endpoint does not check the uniqueness of the group name. The user can create any number of groups with the same name.  If there are attributes in the request body that ODM does not support, then ODM ignores them.

        :param body: (required)
        :type body: CreateGroupRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_group_serialize(
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateGroup201Response",
            '400': "SCIMErrorResponse",
            '401': "BaseErrorResponse",
            '409': "SCIMErrorResponse",
            '500': "BaseErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def create_group_with_http_info(
        self,
        body: CreateGroupRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateGroup201Response]:
        """Add a new user group

        The endpoint creates a new user group in ODM. The endpoint does not update an existing group. A user who calls the endpoint is added to the group automatically with the \"Group admin\" role. The \"members\" attribute in the request body must be empty, otherwise the endpoint returns an error.  The endpoint does not require any user permission.  The endpoint does not check the uniqueness of the group name. The user can create any number of groups with the same name.  If there are attributes in the request body that ODM does not support, then ODM ignores them.

        :param body: (required)
        :type body: CreateGroupRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_group_serialize(
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateGroup201Response",
            '400': "SCIMErrorResponse",
            '401': "BaseErrorResponse",
            '409': "SCIMErrorResponse",
            '500': "BaseErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def create_group_without_preload_content(
        self,
        body: CreateGroupRequest,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add a new user group

        The endpoint creates a new user group in ODM. The endpoint does not update an existing group. A user who calls the endpoint is added to the group automatically with the \"Group admin\" role. The \"members\" attribute in the request body must be empty, otherwise the endpoint returns an error.  The endpoint does not require any user permission.  The endpoint does not check the uniqueness of the group name. The user can create any number of groups with the same name.  If there are attributes in the request body that ODM does not support, then ODM ignores them.

        :param body: (required)
        :type body: CreateGroupRequest
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._create_group_serialize(
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "CreateGroup201Response",
            '400': "SCIMErrorResponse",
            '401': "BaseErrorResponse",
            '409': "SCIMErrorResponse",
            '500': "BaseErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _create_group_serialize(
        self,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/scim+json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/api/v1/scim/Groups',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_group(
        self,
        id: Annotated[StrictStr, Field(description="String, unique identifier of the group in ODM.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete a group

        The endpoint deletes a group in ODM. The group can be deleted, even if it has members: admins and not admins. Users of this group are not deactivated.  Permissions to call the endpoint:  &nbsp;&nbsp;- If the user does not have the \"Manage groups\" permission:  &nbsp;&nbsp;&nbsp;&nbsp;* the user has \"Group admin\" role - the user can delete the group;  &nbsp;&nbsp;&nbsp;&nbsp;* the user has \"Group member\" role - the group can not be deleted, an error is returned;  &nbsp;&nbsp;&nbsp;&nbsp;* the user is not a member of the specified group - the group can not be deleted, an error is returned.  &nbsp;&nbsp;- If the user has the \"Manage groups\" permission - the user can delete the group regardless of user’s membership in this group.

        :param id: String, unique identifier of the group in ODM. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_group_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "SCIMErrorResponse",
            '401': "BaseErrorResponse",
            '403': "SCIMErrorResponse",
            '404': "SCIMErrorResponse",
            '500': "BaseErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_group_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="String, unique identifier of the group in ODM.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete a group

        The endpoint deletes a group in ODM. The group can be deleted, even if it has members: admins and not admins. Users of this group are not deactivated.  Permissions to call the endpoint:  &nbsp;&nbsp;- If the user does not have the \"Manage groups\" permission:  &nbsp;&nbsp;&nbsp;&nbsp;* the user has \"Group admin\" role - the user can delete the group;  &nbsp;&nbsp;&nbsp;&nbsp;* the user has \"Group member\" role - the group can not be deleted, an error is returned;  &nbsp;&nbsp;&nbsp;&nbsp;* the user is not a member of the specified group - the group can not be deleted, an error is returned.  &nbsp;&nbsp;- If the user has the \"Manage groups\" permission - the user can delete the group regardless of user’s membership in this group.

        :param id: String, unique identifier of the group in ODM. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_group_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "SCIMErrorResponse",
            '401': "BaseErrorResponse",
            '403': "SCIMErrorResponse",
            '404': "SCIMErrorResponse",
            '500': "BaseErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_group_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="String, unique identifier of the group in ODM.")],
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete a group

        The endpoint deletes a group in ODM. The group can be deleted, even if it has members: admins and not admins. Users of this group are not deactivated.  Permissions to call the endpoint:  &nbsp;&nbsp;- If the user does not have the \"Manage groups\" permission:  &nbsp;&nbsp;&nbsp;&nbsp;* the user has \"Group admin\" role - the user can delete the group;  &nbsp;&nbsp;&nbsp;&nbsp;* the user has \"Group member\" role - the group can not be deleted, an error is returned;  &nbsp;&nbsp;&nbsp;&nbsp;* the user is not a member of the specified group - the group can not be deleted, an error is returned.  &nbsp;&nbsp;- If the user has the \"Manage groups\" permission - the user can delete the group regardless of user’s membership in this group.

        :param id: String, unique identifier of the group in ODM. (required)
        :type id: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_group_serialize(
            id=id,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "SCIMErrorResponse",
            '401': "BaseErrorResponse",
            '403': "SCIMErrorResponse",
            '404': "SCIMErrorResponse",
            '500': "BaseErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_group_serialize(
        self,
        id,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/scim+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/api/v1/scim/Groups/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def find_groups(
        self,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by group attributes. The parameter name is case-sensitive, therefore parameters FILTER, fiLter, and other options are ignored.  Supported operators:  &nbsp;&nbsp;eq - equal, the attribute and operator values must be identical for a match;  &nbsp;&nbsp;Using other operators returns an error.  Groups can be filtered by displayName only.  Attribute names and attribute operators used in filters are case insensitive.  Examples of the request:  &nbsp;&nbsp;filter=displayName eq \"Curator\".")] = None,
        excluded_attributes: Annotated[Optional[StrictStr], Field(description="If excludedAttributes=members is specified in the request, groups are returned without the members attribute. Other attributes are not supported in excludedAttributes parameter and ignored in the request → all attributes are returned in the response body.")] = None,
        start_index: Annotated[Optional[StrictInt], Field(description="The 1-based index of the first result in the current set of list results.")] = None,
        count: Annotated[Optional[StrictInt], Field(description="The number of resources returned in a list response page. The value by default is 100.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FilterGroupsResponse:
        """Retrieve a list of available groups

        The endpoint returns a list of groups that the user has access to: where the user is a member of the group or if the user has the \"Manage Groups\" permission, then a list of all groups.  The list can be filtered by group attributes using the filter parameter. If no filtering parameters are passed, then all available groups are returned. If there are no groups in the response body, the endpoint returns 200 OK.

        :param filter: Filter by group attributes. The parameter name is case-sensitive, therefore parameters FILTER, fiLter, and other options are ignored.  Supported operators:  &nbsp;&nbsp;eq - equal, the attribute and operator values must be identical for a match;  &nbsp;&nbsp;Using other operators returns an error.  Groups can be filtered by displayName only.  Attribute names and attribute operators used in filters are case insensitive.  Examples of the request:  &nbsp;&nbsp;filter=displayName eq \"Curator\".
        :type filter: str
        :param excluded_attributes: If excludedAttributes=members is specified in the request, groups are returned without the members attribute. Other attributes are not supported in excludedAttributes parameter and ignored in the request → all attributes are returned in the response body.
        :type excluded_attributes: str
        :param start_index: The 1-based index of the first result in the current set of list results.
        :type start_index: int
        :param count: The number of resources returned in a list response page. The value by default is 100.
        :type count: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._find_groups_serialize(
            filter=filter,
            excluded_attributes=excluded_attributes,
            start_index=start_index,
            count=count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FilterGroupsResponse",
            '400': "SCIMErrorResponse",
            '401': "BaseErrorResponse",
            '500': "BaseErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def find_groups_with_http_info(
        self,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by group attributes. The parameter name is case-sensitive, therefore parameters FILTER, fiLter, and other options are ignored.  Supported operators:  &nbsp;&nbsp;eq - equal, the attribute and operator values must be identical for a match;  &nbsp;&nbsp;Using other operators returns an error.  Groups can be filtered by displayName only.  Attribute names and attribute operators used in filters are case insensitive.  Examples of the request:  &nbsp;&nbsp;filter=displayName eq \"Curator\".")] = None,
        excluded_attributes: Annotated[Optional[StrictStr], Field(description="If excludedAttributes=members is specified in the request, groups are returned without the members attribute. Other attributes are not supported in excludedAttributes parameter and ignored in the request → all attributes are returned in the response body.")] = None,
        start_index: Annotated[Optional[StrictInt], Field(description="The 1-based index of the first result in the current set of list results.")] = None,
        count: Annotated[Optional[StrictInt], Field(description="The number of resources returned in a list response page. The value by default is 100.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FilterGroupsResponse]:
        """Retrieve a list of available groups

        The endpoint returns a list of groups that the user has access to: where the user is a member of the group or if the user has the \"Manage Groups\" permission, then a list of all groups.  The list can be filtered by group attributes using the filter parameter. If no filtering parameters are passed, then all available groups are returned. If there are no groups in the response body, the endpoint returns 200 OK.

        :param filter: Filter by group attributes. The parameter name is case-sensitive, therefore parameters FILTER, fiLter, and other options are ignored.  Supported operators:  &nbsp;&nbsp;eq - equal, the attribute and operator values must be identical for a match;  &nbsp;&nbsp;Using other operators returns an error.  Groups can be filtered by displayName only.  Attribute names and attribute operators used in filters are case insensitive.  Examples of the request:  &nbsp;&nbsp;filter=displayName eq \"Curator\".
        :type filter: str
        :param excluded_attributes: If excludedAttributes=members is specified in the request, groups are returned without the members attribute. Other attributes are not supported in excludedAttributes parameter and ignored in the request → all attributes are returned in the response body.
        :type excluded_attributes: str
        :param start_index: The 1-based index of the first result in the current set of list results.
        :type start_index: int
        :param count: The number of resources returned in a list response page. The value by default is 100.
        :type count: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._find_groups_serialize(
            filter=filter,
            excluded_attributes=excluded_attributes,
            start_index=start_index,
            count=count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FilterGroupsResponse",
            '400': "SCIMErrorResponse",
            '401': "BaseErrorResponse",
            '500': "BaseErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def find_groups_without_preload_content(
        self,
        filter: Annotated[Optional[StrictStr], Field(description="Filter by group attributes. The parameter name is case-sensitive, therefore parameters FILTER, fiLter, and other options are ignored.  Supported operators:  &nbsp;&nbsp;eq - equal, the attribute and operator values must be identical for a match;  &nbsp;&nbsp;Using other operators returns an error.  Groups can be filtered by displayName only.  Attribute names and attribute operators used in filters are case insensitive.  Examples of the request:  &nbsp;&nbsp;filter=displayName eq \"Curator\".")] = None,
        excluded_attributes: Annotated[Optional[StrictStr], Field(description="If excludedAttributes=members is specified in the request, groups are returned without the members attribute. Other attributes are not supported in excludedAttributes parameter and ignored in the request → all attributes are returned in the response body.")] = None,
        start_index: Annotated[Optional[StrictInt], Field(description="The 1-based index of the first result in the current set of list results.")] = None,
        count: Annotated[Optional[StrictInt], Field(description="The number of resources returned in a list response page. The value by default is 100.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve a list of available groups

        The endpoint returns a list of groups that the user has access to: where the user is a member of the group or if the user has the \"Manage Groups\" permission, then a list of all groups.  The list can be filtered by group attributes using the filter parameter. If no filtering parameters are passed, then all available groups are returned. If there are no groups in the response body, the endpoint returns 200 OK.

        :param filter: Filter by group attributes. The parameter name is case-sensitive, therefore parameters FILTER, fiLter, and other options are ignored.  Supported operators:  &nbsp;&nbsp;eq - equal, the attribute and operator values must be identical for a match;  &nbsp;&nbsp;Using other operators returns an error.  Groups can be filtered by displayName only.  Attribute names and attribute operators used in filters are case insensitive.  Examples of the request:  &nbsp;&nbsp;filter=displayName eq \"Curator\".
        :type filter: str
        :param excluded_attributes: If excludedAttributes=members is specified in the request, groups are returned without the members attribute. Other attributes are not supported in excludedAttributes parameter and ignored in the request → all attributes are returned in the response body.
        :type excluded_attributes: str
        :param start_index: The 1-based index of the first result in the current set of list results.
        :type start_index: int
        :param count: The number of resources returned in a list response page. The value by default is 100.
        :type count: int
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._find_groups_serialize(
            filter=filter,
            excluded_attributes=excluded_attributes,
            start_index=start_index,
            count=count,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FilterGroupsResponse",
            '400': "SCIMErrorResponse",
            '401': "BaseErrorResponse",
            '500': "BaseErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _find_groups_serialize(
        self,
        filter,
        excluded_attributes,
        start_index,
        count,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        if filter is not None:
            
            _query_params.append(('filter', filter))
            
        if excluded_attributes is not None:
            
            _query_params.append(('excludedAttributes', excluded_attributes))
            
        if start_index is not None:
            
            _query_params.append(('startIndex', start_index))
            
        if count is not None:
            
            _query_params.append(('count', count))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/scim+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/scim/Groups',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_group(
        self,
        id: Annotated[StrictStr, Field(description="String, unique identifier of the group in ODM.")],
        excluded_attributes: Annotated[Optional[StrictStr], Field(description="If excludedAttributes=members is specified in the request, Groups are returned without the members attribute. Other attributes are not supported in excludedAttributes parameter and ignored in the request → all attributes are returned in the response body.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CreateGroup201Response:
        """Retrieve a group by id

        The endpoint returns a not deleted group by id, where id is an internal group id in ODM. Access to the group is required:  &nbsp;&nbsp;- If the user has the \"Manage groups\" permission, the endpoint returns not deleted group on the instance regardless of user’s membership in this group;  &nbsp;&nbsp;- If the user does not have the \"Manage groups\" permission, the endpoint returns only groups in which the user is a member. Otherwise, 404 Not Found is returned.

        :param id: String, unique identifier of the group in ODM. (required)
        :type id: str
        :param excluded_attributes: If excludedAttributes=members is specified in the request, Groups are returned without the members attribute. Other attributes are not supported in excludedAttributes parameter and ignored in the request → all attributes are returned in the response body.
        :type excluded_attributes: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_group_serialize(
            id=id,
            excluded_attributes=excluded_attributes,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateGroup201Response",
            '400': "SCIMErrorResponse",
            '401': "BaseErrorResponse",
            '404': "SCIMErrorResponse",
            '500': "BaseErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_group_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="String, unique identifier of the group in ODM.")],
        excluded_attributes: Annotated[Optional[StrictStr], Field(description="If excludedAttributes=members is specified in the request, Groups are returned without the members attribute. Other attributes are not supported in excludedAttributes parameter and ignored in the request → all attributes are returned in the response body.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CreateGroup201Response]:
        """Retrieve a group by id

        The endpoint returns a not deleted group by id, where id is an internal group id in ODM. Access to the group is required:  &nbsp;&nbsp;- If the user has the \"Manage groups\" permission, the endpoint returns not deleted group on the instance regardless of user’s membership in this group;  &nbsp;&nbsp;- If the user does not have the \"Manage groups\" permission, the endpoint returns only groups in which the user is a member. Otherwise, 404 Not Found is returned.

        :param id: String, unique identifier of the group in ODM. (required)
        :type id: str
        :param excluded_attributes: If excludedAttributes=members is specified in the request, Groups are returned without the members attribute. Other attributes are not supported in excludedAttributes parameter and ignored in the request → all attributes are returned in the response body.
        :type excluded_attributes: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_group_serialize(
            id=id,
            excluded_attributes=excluded_attributes,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateGroup201Response",
            '400': "SCIMErrorResponse",
            '401': "BaseErrorResponse",
            '404': "SCIMErrorResponse",
            '500': "BaseErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_group_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="String, unique identifier of the group in ODM.")],
        excluded_attributes: Annotated[Optional[StrictStr], Field(description="If excludedAttributes=members is specified in the request, Groups are returned without the members attribute. Other attributes are not supported in excludedAttributes parameter and ignored in the request → all attributes are returned in the response body.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Retrieve a group by id

        The endpoint returns a not deleted group by id, where id is an internal group id in ODM. Access to the group is required:  &nbsp;&nbsp;- If the user has the \"Manage groups\" permission, the endpoint returns not deleted group on the instance regardless of user’s membership in this group;  &nbsp;&nbsp;- If the user does not have the \"Manage groups\" permission, the endpoint returns only groups in which the user is a member. Otherwise, 404 Not Found is returned.

        :param id: String, unique identifier of the group in ODM. (required)
        :type id: str
        :param excluded_attributes: If excludedAttributes=members is specified in the request, Groups are returned without the members attribute. Other attributes are not supported in excludedAttributes parameter and ignored in the request → all attributes are returned in the response body.
        :type excluded_attributes: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_group_serialize(
            id=id,
            excluded_attributes=excluded_attributes,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CreateGroup201Response",
            '400': "SCIMErrorResponse",
            '401': "BaseErrorResponse",
            '404': "SCIMErrorResponse",
            '500': "BaseErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_group_serialize(
        self,
        id,
        excluded_attributes,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        if excluded_attributes is not None:
            
            _query_params.append(('excludedAttributes', excluded_attributes))
            
        # process the header parameters
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/scim+json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/api/v1/scim/Groups/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def patch_group(
        self,
        id: Annotated[StrictStr, Field(description="String, unique identifier of the group in ODM.")],
        body: GroupPatch,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Update a group

        The endpoint updates one or several attributes of a specific group, where id is internal group id in ODM. Also the endpoints adds a new user to the group and removes users from the group.   Supported operators in the request body: replace, add, remove. For details of the syntax of using these operators, we recommend that you refer to the SCIM 2.0 specification.   The list of group attributes that can be edited: displayName, externalId, members. If the user tries to edit other attributes, e.g. id, an error is returned. If the user tries to edit attributes that are not supported in the ODM group scheme, this attribute is ignored. If the request body includes only attributes that are not supported by ODM, the endpoint returns 200 OK.   A PATCH request, regardless of the number of operations, is treated as atomic. If a single operation encounters an error condition, the original user attributes are restored, and a failure status is returned.   The endpoint requires access to the group as admin of the group: the user has the \"Admin group\" role in the group or the user has the \"Manage groups\" permission.

        :param id: String, unique identifier of the group in ODM. (required)
        :type id: str
        :param body: (required)
        :type body: GroupPatch
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._patch_group_serialize(
            id=id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "SCIMErrorResponse",
            '401': "BaseErrorResponse",
            '403': "SCIMErrorResponse",
            '404': "SCIMErrorResponse",
            '500': "BaseErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def patch_group_with_http_info(
        self,
        id: Annotated[StrictStr, Field(description="String, unique identifier of the group in ODM.")],
        body: GroupPatch,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Update a group

        The endpoint updates one or several attributes of a specific group, where id is internal group id in ODM. Also the endpoints adds a new user to the group and removes users from the group.   Supported operators in the request body: replace, add, remove. For details of the syntax of using these operators, we recommend that you refer to the SCIM 2.0 specification.   The list of group attributes that can be edited: displayName, externalId, members. If the user tries to edit other attributes, e.g. id, an error is returned. If the user tries to edit attributes that are not supported in the ODM group scheme, this attribute is ignored. If the request body includes only attributes that are not supported by ODM, the endpoint returns 200 OK.   A PATCH request, regardless of the number of operations, is treated as atomic. If a single operation encounters an error condition, the original user attributes are restored, and a failure status is returned.   The endpoint requires access to the group as admin of the group: the user has the \"Admin group\" role in the group or the user has the \"Manage groups\" permission.

        :param id: String, unique identifier of the group in ODM. (required)
        :type id: str
        :param body: (required)
        :type body: GroupPatch
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._patch_group_serialize(
            id=id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "SCIMErrorResponse",
            '401': "BaseErrorResponse",
            '403': "SCIMErrorResponse",
            '404': "SCIMErrorResponse",
            '500': "BaseErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def patch_group_without_preload_content(
        self,
        id: Annotated[StrictStr, Field(description="String, unique identifier of the group in ODM.")],
        body: GroupPatch,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update a group

        The endpoint updates one or several attributes of a specific group, where id is internal group id in ODM. Also the endpoints adds a new user to the group and removes users from the group.   Supported operators in the request body: replace, add, remove. For details of the syntax of using these operators, we recommend that you refer to the SCIM 2.0 specification.   The list of group attributes that can be edited: displayName, externalId, members. If the user tries to edit other attributes, e.g. id, an error is returned. If the user tries to edit attributes that are not supported in the ODM group scheme, this attribute is ignored. If the request body includes only attributes that are not supported by ODM, the endpoint returns 200 OK.   A PATCH request, regardless of the number of operations, is treated as atomic. If a single operation encounters an error condition, the original user attributes are restored, and a failure status is returned.   The endpoint requires access to the group as admin of the group: the user has the \"Admin group\" role in the group or the user has the \"Manage groups\" permission.

        :param id: String, unique identifier of the group in ODM. (required)
        :type id: str
        :param body: (required)
        :type body: GroupPatch
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._patch_group_serialize(
            id=id,
            body=body,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
            '400': "SCIMErrorResponse",
            '401': "BaseErrorResponse",
            '403': "SCIMErrorResponse",
            '404': "SCIMErrorResponse",
            '500': "BaseErrorResponse",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _patch_group_serialize(
        self,
        id,
        body,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if id is not None:
            _path_params['id'] = id
        # process the query parameters
        # process the header parameters
        # process the form parameters
        # process the body parameter
        if body is not None:
            _body_params = body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/scim+json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'Access-token', 
            'Genestack-API-Token'
        ]

        return self.api_client.param_serialize(
            method='PATCH',
            resource_path='/api/v1/scim/Groups/{id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


