# odm-api
This swagger page describes the variantUser API endpoints for ODM. These are typically used to find and retrieve variant data and metadata.

Before carrying out any API calls you will need an API token. API tokens can be obtained under your profile within the Genestack software.

To try out calls in this swagger page:

1.  Click the 'Authorize' button below to enter your API token
2.  Scroll to the 'Parameters' section for the method you wish to try out and click the 'Try it out' button
3.  Enter parameter values that you wish to try
4.  Scroll to the bottom of the Parameters section and click the 'Execute' bar that appears


 The server response will be in the section that follows.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: default-released
- Package version: 1.59.9
- Generator version: 7.10.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.8+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/genestack/openapi.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/genestack/openapi.git`)

Then import the package:
```python
import odm_api
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import odm_api
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import odm_api
from odm_api.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = odm_api.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: Access-token
configuration.api_key['Access-token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Access-token'] = 'Bearer'

# Configure API key authorization: Genestack-API-Token
configuration.api_key['Genestack-API-Token'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['Genestack-API-Token'] = 'Bearer'


# Enter a context with an instance of the API client
with odm_api.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = odm_api.DataImportJobsApi(api_client)
    body = odm_api.ImportAFileRequest() # ImportAFileRequest |  (optional)

    try:
        # Import file as an attachment
        api_response = api_instance.start_import_a_file(body=body)
        print("The response of DataImportJobsApi->start_import_a_file:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DataImportJobsApi->start_import_a_file: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DataImportJobsApi* | [**start_import_a_file**](docs/DataImportJobsApi.md#start_import_a_file) | **POST** /api/v1/jobs/import/file | Import file as an attachment
*DataImportJobsApi* | [**start_import_expression**](docs/DataImportJobsApi.md#start_import_expression) | **POST** /api/v1/jobs/import/expression | Import any tabular data from TSV or GCT files
*DataImportJobsApi* | [**start_import_flow_cytometry**](docs/DataImportJobsApi.md#start_import_flow_cytometry) | **POST** /api/v1/jobs/import/flow-cytometry | Import flow-cytometry data and metadata from FACS and TSV files
*DataImportJobsApi* | [**start_import_libraries**](docs/DataImportJobsApi.md#start_import_libraries) | **POST** /api/v1/jobs/import/libraries | Import a group of library metadata objects from a TSV file
*DataImportJobsApi* | [**start_import_preparations**](docs/DataImportJobsApi.md#start_import_preparations) | **POST** /api/v1/jobs/import/preparations | Import a group of preparation metadata objects from a TSV file
*DataImportJobsApi* | [**start_import_samples**](docs/DataImportJobsApi.md#start_import_samples) | **POST** /api/v1/jobs/import/samples | Import a group of sample metadata objects from a TSV file
*DataImportJobsApi* | [**start_import_study**](docs/DataImportJobsApi.md#start_import_study) | **POST** /api/v1/jobs/import/study | Import study metadata from a TSV file
*DataImportJobsApi* | [**start_import_variant**](docs/DataImportJobsApi.md#start_import_variant) | **POST** /api/v1/jobs/import/variant | Import variation data and metadata from VCF and TSV files
*ExpressionSPoTAsCuratorApi* | [**get_expression_as_curator**](docs/ExpressionSPoTAsCuratorApi.md#get_expression_as_curator) | **GET** /api/v1/as-curator/expressions/{id} | Retrieve a single expression object by ID (accession)
*ExpressionSPoTAsCuratorApi* | [**get_expression_by_version_as_curator**](docs/ExpressionSPoTAsCuratorApi.md#get_expression_by_version_as_curator) | **GET** /api/v1/as-curator/expressions/{id}/versions/{version} | Retrieve a single expression object by ID (accession)
*ExpressionSPoTAsCuratorApi* | [**get_expression_data_as_curator**](docs/ExpressionSPoTAsCuratorApi.md#get_expression_data_as_curator) | **GET** /api/v1/as-curator/expressions | Retrieve multiple expression data and metadata objects
*ExpressionSPoTAsCuratorApi* | [**get_expression_group_as_curator**](docs/ExpressionSPoTAsCuratorApi.md#get_expression_group_as_curator) | **GET** /api/v1/as-curator/expressions/group/{id} | Retrieve a single group object by ID (accession)
*ExpressionSPoTAsCuratorApi* | [**get_expression_group_by_run_as_curator**](docs/ExpressionSPoTAsCuratorApi.md#get_expression_group_by_run_as_curator) | **GET** /api/v1/as-curator/expressions/group/by/run/{id} | Retrieve a single group object by run ID (accession)
*ExpressionSPoTAsCuratorApi* | [**get_expression_versions_as_curator**](docs/ExpressionSPoTAsCuratorApi.md#get_expression_versions_as_curator) | **GET** /api/v1/as-curator/expressions/{id}/versions | Retrieve a list of object versions by ID
*ExpressionSPoTAsCuratorApi* | [**search_expression_groups_as_curator**](docs/ExpressionSPoTAsCuratorApi.md#search_expression_groups_as_curator) | **GET** /api/v1/as-curator/expressions/group | Retrieve groups that match a query
*ExpressionSPoTAsCuratorApi* | [**search_expression_runs_as_curator**](docs/ExpressionSPoTAsCuratorApi.md#search_expression_runs_as_curator) | **GET** /api/v1/as-curator/expressions/runs/by/group/{id} | Retrieve run objects related to the given group
*ExpressionSPoTAsCuratorApi* | [**update_expression_run_as_curator**](docs/ExpressionSPoTAsCuratorApi.md#update_expression_run_as_curator) | **PATCH** /api/v1/as-curator/expressions/{id} | Update object metadata
*ExpressionSPoTAsUserApi* | [**get_expression_as_user**](docs/ExpressionSPoTAsUserApi.md#get_expression_as_user) | **GET** /api/v1/as-user/expressions/{id} | Retrieve a single expression object by ID (accession)
*ExpressionSPoTAsUserApi* | [**get_expression_by_version_as_user**](docs/ExpressionSPoTAsUserApi.md#get_expression_by_version_as_user) | **GET** /api/v1/as-user/expressions/{id}/versions/{version} | Retrieve a single expression object by ID (accession)
*ExpressionSPoTAsUserApi* | [**get_expression_data_as_user**](docs/ExpressionSPoTAsUserApi.md#get_expression_data_as_user) | **GET** /api/v1/as-user/expressions | Retrieve multiple expression data and metadata objects
*ExpressionSPoTAsUserApi* | [**get_expression_group_as_user**](docs/ExpressionSPoTAsUserApi.md#get_expression_group_as_user) | **GET** /api/v1/as-user/expressions/group/{id} | Retrieve a single group object by ID (accession)
*ExpressionSPoTAsUserApi* | [**get_expression_group_by_run_as_user**](docs/ExpressionSPoTAsUserApi.md#get_expression_group_by_run_as_user) | **GET** /api/v1/as-user/expressions/group/by/run/{id} | Retrieve a single group object by run ID (accession)
*ExpressionSPoTAsUserApi* | [**get_expression_versions_as_user**](docs/ExpressionSPoTAsUserApi.md#get_expression_versions_as_user) | **GET** /api/v1/as-user/expressions/{id}/versions | Retrieve a list of object versions by ID
*ExpressionSPoTAsUserApi* | [**search_expression_groups_as_user**](docs/ExpressionSPoTAsUserApi.md#search_expression_groups_as_user) | **GET** /api/v1/as-user/expressions/group | Retrieve groups that match a query
*ExpressionSPoTAsUserApi* | [**search_expression_runs_as_user**](docs/ExpressionSPoTAsUserApi.md#search_expression_runs_as_user) | **GET** /api/v1/as-user/expressions/runs/by/group/{id} | Retrieve run objects related to the given group
*ExpressionIntegrationAsCuratorApi* | [**create_expression_group_library_group_link_as_curator**](docs/ExpressionIntegrationAsCuratorApi.md#create_expression_group_library_group_link_as_curator) | **POST** /api/v1/as-curator/integration/link/expression/group/{sourceId}/to/library/group/{targetId} | Create a link between a group of expression objects and a group of library objects
*ExpressionIntegrationAsCuratorApi* | [**create_expression_group_preparation_group_link_as_curator**](docs/ExpressionIntegrationAsCuratorApi.md#create_expression_group_preparation_group_link_as_curator) | **POST** /api/v1/as-curator/integration/link/expression/group/{sourceId}/to/preparation/group/{targetId} | Create a link between a group of expression objects and a group of preparation objects
*ExpressionIntegrationAsCuratorApi* | [**create_expression_group_sample_group_link_as_curator**](docs/ExpressionIntegrationAsCuratorApi.md#create_expression_group_sample_group_link_as_curator) | **POST** /api/v1/as-curator/integration/link/expression/group/{sourceId}/to/sample/group/{targetId} | Create a link between a group of expression objects and a group of sample objects
*ExpressionIntegrationAsCuratorApi* | [**create_expression_library_link_as_curator**](docs/ExpressionIntegrationAsCuratorApi.md#create_expression_library_link_as_curator) | **POST** /api/v1/as-curator/integration/link/expression/{sourceId}/to/library/{targetId} | Create a link between an expression object and a library
*ExpressionIntegrationAsCuratorApi* | [**create_expression_preparation_link_as_curator**](docs/ExpressionIntegrationAsCuratorApi.md#create_expression_preparation_link_as_curator) | **POST** /api/v1/as-curator/integration/link/expression/{sourceId}/to/preparation/{targetId} | Create a link between an expression object and a preparation
*ExpressionIntegrationAsCuratorApi* | [**create_expression_sample_link_as_curator**](docs/ExpressionIntegrationAsCuratorApi.md#create_expression_sample_link_as_curator) | **POST** /api/v1/as-curator/integration/link/expression/{sourceId}/to/sample/{targetId} | Create a link between an expression object and a sample
*ExpressionIntegrationAsCuratorApi* | [**delete_expression_group_library_group_link_as_curator**](docs/ExpressionIntegrationAsCuratorApi.md#delete_expression_group_library_group_link_as_curator) | **DELETE** /api/v1/as-curator/integration/link/expression/group/{sourceId}/to/library/group/{targetId} | Delete link between a group of expression objects and a group of library objects
*ExpressionIntegrationAsCuratorApi* | [**delete_expression_group_preparation_group_link_as_curator**](docs/ExpressionIntegrationAsCuratorApi.md#delete_expression_group_preparation_group_link_as_curator) | **DELETE** /api/v1/as-curator/integration/link/expression/group/{sourceId}/to/preparation/group/{targetId} | Delete link between a group of expression objects and a group of preparation objects
*ExpressionIntegrationAsCuratorApi* | [**delete_expression_group_sample_group_link_as_curator**](docs/ExpressionIntegrationAsCuratorApi.md#delete_expression_group_sample_group_link_as_curator) | **DELETE** /api/v1/as-curator/integration/link/expression/group/{sourceId}/to/sample/group/{targetId} | Delete link between a group of expression objects and a group of sample objects
*ExpressionIntegrationAsCuratorApi* | [**delete_expression_library_link_as_curator**](docs/ExpressionIntegrationAsCuratorApi.md#delete_expression_library_link_as_curator) | **DELETE** /api/v1/as-curator/integration/link/expression/{sourceId}/to/library/{targetId} | Delete link between an expression object and a library
*ExpressionIntegrationAsCuratorApi* | [**delete_expression_preparation_link_as_curator**](docs/ExpressionIntegrationAsCuratorApi.md#delete_expression_preparation_link_as_curator) | **DELETE** /api/v1/as-curator/integration/link/expression/{sourceId}/to/preparation/{targetId} | Delete link between an expression object and a preparation
*ExpressionIntegrationAsCuratorApi* | [**delete_expression_sample_link_as_curator**](docs/ExpressionIntegrationAsCuratorApi.md#delete_expression_sample_link_as_curator) | **DELETE** /api/v1/as-curator/integration/link/expression/{sourceId}/to/sample/{targetId} | Delete link between an expression object and a sample
*ExpressionIntegrationAsCuratorApi* | [**get_expression_by_library_as_curator**](docs/ExpressionIntegrationAsCuratorApi.md#get_expression_by_library_as_curator) | **GET** /api/v1/as-curator/integration/link/expression/by/library/{id} | Retrieve expression run-level data by querying related library ID (accession)
*ExpressionIntegrationAsCuratorApi* | [**get_expression_by_preparation**](docs/ExpressionIntegrationAsCuratorApi.md#get_expression_by_preparation) | **GET** /api/v1/as-curator/integration/link/expression/by/preparation/{id} | Retrieve expression run-level data by querying related preparation ID (accession)
*ExpressionIntegrationAsCuratorApi* | [**get_expression_by_sample_as_curator**](docs/ExpressionIntegrationAsCuratorApi.md#get_expression_by_sample_as_curator) | **GET** /api/v1/as-curator/integration/link/expression/by/sample/{id} | Retrieve expression run-level data by querying related sample ID (accession)
*ExpressionIntegrationAsCuratorApi* | [**get_expression_groups_by_study_as_curator**](docs/ExpressionIntegrationAsCuratorApi.md#get_expression_groups_by_study_as_curator) | **GET** /api/v1/as-curator/integration/link/expression/group/by/study/{id} | Retrieve group metadata by querying study ID (accession)
*ExpressionIntegrationAsCuratorApi* | [**get_expression_run_to_library_pairs_as_curator**](docs/ExpressionIntegrationAsCuratorApi.md#get_expression_run_to_library_pairs_as_curator) | **GET** /api/v1/as-curator/integration/link/expression/run-to-libraries/by/group/{id} | Retrieve run-library pairs by group id. Pagination is based on unique runs, not unique pairs.
*ExpressionIntegrationAsCuratorApi* | [**get_expression_run_to_preparation_pairs_as_curator**](docs/ExpressionIntegrationAsCuratorApi.md#get_expression_run_to_preparation_pairs_as_curator) | **GET** /api/v1/as-curator/integration/link/expression/run-to-preparations/by/group/{id} | Retrieve run-preparation pairs by group id. Pagination is based on unique runs, not unique pairs.
*ExpressionIntegrationAsCuratorApi* | [**get_expression_run_to_sample_pairs_as_curator**](docs/ExpressionIntegrationAsCuratorApi.md#get_expression_run_to_sample_pairs_as_curator) | **GET** /api/v1/as-curator/integration/link/expression/run-to-samples/by/group/{id} | Retrieve run-sample pairs by group id. Pagination is based on unique runs, not unique pairs.
*ExpressionIntegrationAsUserApi* | [**get_expression_by_library_as_user**](docs/ExpressionIntegrationAsUserApi.md#get_expression_by_library_as_user) | **GET** /api/v1/as-user/integration/link/expression/by/library/{id} | Retrieve expression run-level data by querying related library ID (accession)
*ExpressionIntegrationAsUserApi* | [**get_expression_by_preparation_as_user**](docs/ExpressionIntegrationAsUserApi.md#get_expression_by_preparation_as_user) | **GET** /api/v1/as-user/integration/link/expression/by/preparation/{id} | Retrieve expression run-level data by querying related preparation ID (accession)
*ExpressionIntegrationAsUserApi* | [**get_expression_by_sample_as_user**](docs/ExpressionIntegrationAsUserApi.md#get_expression_by_sample_as_user) | **GET** /api/v1/as-user/integration/link/expression/by/sample/{id} | Retrieve expression run-level data by querying related sample ID (accession)
*ExpressionIntegrationAsUserApi* | [**get_expression_groups_by_study_as_user**](docs/ExpressionIntegrationAsUserApi.md#get_expression_groups_by_study_as_user) | **GET** /api/v1/as-user/integration/link/expression/group/by/study/{id} | Retrieve group metadata by querying study ID (accession)
*ExpressionIntegrationAsUserApi* | [**get_expression_run_to_library_pairs_as_user**](docs/ExpressionIntegrationAsUserApi.md#get_expression_run_to_library_pairs_as_user) | **GET** /api/v1/as-user/integration/link/expression/run-to-libraries/by/group/{id} | Retrieve run-library pairs by group id. Pagination is based on unique runs, not unique pairs.
*ExpressionIntegrationAsUserApi* | [**get_expression_run_to_preparation_pairs_as_user**](docs/ExpressionIntegrationAsUserApi.md#get_expression_run_to_preparation_pairs_as_user) | **GET** /api/v1/as-user/integration/link/expression/run-to-preparations/by/group/{id} | Retrieve run-preparation pairs by group id. Pagination is based on unique runs, not unique pairs.
*ExpressionIntegrationAsUserApi* | [**get_expression_run_to_sample_pairs_as_user**](docs/ExpressionIntegrationAsUserApi.md#get_expression_run_to_sample_pairs_as_user) | **GET** /api/v1/as-user/integration/link/expression/run-to-samples/by/group/{id} | Retrieve run-sample pairs by group id. Pagination is based on unique runs, not unique pairs.
*FilesAsCuratorApi* | [**get_file_as_curator**](docs/FilesAsCuratorApi.md#get_file_as_curator) | **GET** /api/v1/as-curator/files/{id}/download | Retrieve a file by ID (accession)
*FilesAsCuratorApi* | [**get_file_metadata_by_id_as_curator**](docs/FilesAsCuratorApi.md#get_file_metadata_by_id_as_curator) | **GET** /api/v1/as-curator/files/{id} | Retrieve file&#39;s metadata by ID (accession)
*FilesAsCuratorApi* | [**get_files_metadata_as_curator**](docs/FilesAsCuratorApi.md#get_files_metadata_as_curator) | **GET** /api/v1/as-curator/files | Retrieve file&#39;s metadata by its fields
*FilesAsCuratorApi* | [**head_file_as_curator**](docs/FilesAsCuratorApi.md#head_file_as_curator) | **HEAD** /api/v1/as-curator/files/{id}/download | 
*FilesAsUserApi* | [**get_file_as_user**](docs/FilesAsUserApi.md#get_file_as_user) | **GET** /api/v1/as-user/files/{id}/download | Retrieve a file by ID (accession)
*FilesAsUserApi* | [**get_file_metadata_by_id_as_user**](docs/FilesAsUserApi.md#get_file_metadata_by_id_as_user) | **GET** /api/v1/as-user/files/{id} | Retrieve file&#39;s metadata by ID (accession)
*FilesAsUserApi* | [**get_files_metadata_as_user**](docs/FilesAsUserApi.md#get_files_metadata_as_user) | **GET** /api/v1/as-user/files | Retrieve file&#39;s metadata by its fields
*FilesAsUserApi* | [**head_file_as_user**](docs/FilesAsUserApi.md#head_file_as_user) | **HEAD** /api/v1/as-user/files/{id}/download | Check if a file exists by ID (accession).
*FilesIntegrationAsCuratorApi* | [**get_files_by_study_as_curator**](docs/FilesIntegrationAsCuratorApi.md#get_files_by_study_as_curator) | **GET** /api/v1/as-curator/integration/link/files/by/study/{id} | Retrieve file&#39;s metadata by study ID
*FilesIntegrationAsUserApi* | [**get_files_by_study_as_user**](docs/FilesIntegrationAsUserApi.md#get_files_by_study_as_user) | **GET** /api/v1/as-user/integration/link/files/by/study/{id} | Retrieve file&#39;s metadata by study ID
*FlowCytometrySPoTAsCuratorApi* | [**get_flow_cytometry_as_curator**](docs/FlowCytometrySPoTAsCuratorApi.md#get_flow_cytometry_as_curator) | **GET** /api/v1/as-curator/flow-cytometries/{id} | Retrieve a single sample flow cytometry by ID (accession)
*FlowCytometrySPoTAsCuratorApi* | [**get_flow_cytometry_by_version_as_curator**](docs/FlowCytometrySPoTAsCuratorApi.md#get_flow_cytometry_by_version_as_curator) | **GET** /api/v1/as-curator/flow-cytometries/{id}/versions/{version} | Retrieve a single sample flow cytometry by ID (accession)
*FlowCytometrySPoTAsCuratorApi* | [**get_flow_cytometry_data_as_curator**](docs/FlowCytometrySPoTAsCuratorApi.md#get_flow_cytometry_data_as_curator) | **GET** /api/v1/as-curator/flow-cytometries | Retrieve multiple flow cytometry data and metadata objects
*FlowCytometrySPoTAsCuratorApi* | [**get_flow_cytometry_group_as_curator**](docs/FlowCytometrySPoTAsCuratorApi.md#get_flow_cytometry_group_as_curator) | **GET** /api/v1/as-curator/flow-cytometries/group/{id} | Retrieve a single group object by ID (accession)
*FlowCytometrySPoTAsCuratorApi* | [**get_flow_cytometry_group_by_run_as_curator**](docs/FlowCytometrySPoTAsCuratorApi.md#get_flow_cytometry_group_by_run_as_curator) | **GET** /api/v1/as-curator/flow-cytometries/group/by/run/{id} | Retrieve a single group object by run ID (accession)
*FlowCytometrySPoTAsCuratorApi* | [**get_flow_cytometry_versions_as_curator**](docs/FlowCytometrySPoTAsCuratorApi.md#get_flow_cytometry_versions_as_curator) | **GET** /api/v1/as-curator/flow-cytometries/{id}/versions | Retrieve a list of object versions by ID
*FlowCytometrySPoTAsCuratorApi* | [**search_flow_cytometry_groups_as_curator**](docs/FlowCytometrySPoTAsCuratorApi.md#search_flow_cytometry_groups_as_curator) | **GET** /api/v1/as-curator/flow-cytometries/group | Retrieve groups that match a query
*FlowCytometrySPoTAsCuratorApi* | [**search_flow_cytometry_runs_as_curator**](docs/FlowCytometrySPoTAsCuratorApi.md#search_flow_cytometry_runs_as_curator) | **GET** /api/v1/as-curator/flow-cytometries/runs/by/group/{id} | Retrieve run objects related to the given group
*FlowCytometrySPoTAsCuratorApi* | [**update_flow_cytometry_as_curator**](docs/FlowCytometrySPoTAsCuratorApi.md#update_flow_cytometry_as_curator) | **PATCH** /api/v1/as-curator/flow-cytometries/{id} | Update object metadata
*FlowCytometrySPoTAsUserApi* | [**get_flow_cytometry_as_user**](docs/FlowCytometrySPoTAsUserApi.md#get_flow_cytometry_as_user) | **GET** /api/v1/as-user/flow-cytometries/{id} | Retrieve a single sample flow cytometry by ID (accession)
*FlowCytometrySPoTAsUserApi* | [**get_flow_cytometry_by_version_as_user**](docs/FlowCytometrySPoTAsUserApi.md#get_flow_cytometry_by_version_as_user) | **GET** /api/v1/as-user/flow-cytometries/{id}/versions/{version} | Retrieve a single sample flow cytometry by ID (accession)
*FlowCytometrySPoTAsUserApi* | [**get_flow_cytometry_data_as_user**](docs/FlowCytometrySPoTAsUserApi.md#get_flow_cytometry_data_as_user) | **GET** /api/v1/as-user/flow-cytometries | Retrieve multiple flow cytometry data and metadata objects
*FlowCytometrySPoTAsUserApi* | [**get_flow_cytometry_group_as_user**](docs/FlowCytometrySPoTAsUserApi.md#get_flow_cytometry_group_as_user) | **GET** /api/v1/as-user/flow-cytometries/group/{id} | Retrieve a single group object by ID (accession)
*FlowCytometrySPoTAsUserApi* | [**get_flow_cytometry_group_by_run_as_user**](docs/FlowCytometrySPoTAsUserApi.md#get_flow_cytometry_group_by_run_as_user) | **GET** /api/v1/as-user/flow-cytometries/group/by/run/{id} | Retrieve a single group object by run ID (accession)
*FlowCytometrySPoTAsUserApi* | [**get_flow_cytometry_versions_as_user**](docs/FlowCytometrySPoTAsUserApi.md#get_flow_cytometry_versions_as_user) | **GET** /api/v1/as-user/flow-cytometries/{id}/versions | Retrieve a list of object versions by ID
*FlowCytometrySPoTAsUserApi* | [**search_flow_cytometry_groups_as_user**](docs/FlowCytometrySPoTAsUserApi.md#search_flow_cytometry_groups_as_user) | **GET** /api/v1/as-user/flow-cytometries/group | Retrieve groups that match a query
*FlowCytometrySPoTAsUserApi* | [**search_flow_cytometry_runs_as_user**](docs/FlowCytometrySPoTAsUserApi.md#search_flow_cytometry_runs_as_user) | **GET** /api/v1/as-user/flow-cytometries/runs/by/group/{id} | Retrieve run objects related to the given group
*FlowCytometryFACSIntegrationAsCuratorApi* | [**create_flow_cytometry_group_sample_group_link_as_curator**](docs/FlowCytometryFACSIntegrationAsCuratorApi.md#create_flow_cytometry_group_sample_group_link_as_curator) | **POST** /api/v1/as-curator/integration/link/flow-cytometry/group/{sourceId}/to/sample/group/{targetId} | Create a link between a group of flow-cytometry objects and a group of sample objects
*FlowCytometryFACSIntegrationAsCuratorApi* | [**create_flow_cytometry_sample_link_as_curator**](docs/FlowCytometryFACSIntegrationAsCuratorApi.md#create_flow_cytometry_sample_link_as_curator) | **POST** /api/v1/as-curator/integration/link/flow-cytometry/{sourceId}/to/sample/{targetId} | Create a link between a flow-cytometry object and a sample
*FlowCytometryFACSIntegrationAsCuratorApi* | [**delete_flow_cytometry_group_sample_group_link_as_curator**](docs/FlowCytometryFACSIntegrationAsCuratorApi.md#delete_flow_cytometry_group_sample_group_link_as_curator) | **DELETE** /api/v1/as-curator/integration/link/flow-cytometry/group/{sourceId}/to/sample/group/{targetId} | Delete link between a group of flow-cytometry objects and a group of sample objects
*FlowCytometryFACSIntegrationAsCuratorApi* | [**delete_flow_cytometry_sample_link_as_curator**](docs/FlowCytometryFACSIntegrationAsCuratorApi.md#delete_flow_cytometry_sample_link_as_curator) | **DELETE** /api/v1/as-curator/integration/link/flow-cytometry/{sourceId}/to/sample/{targetId} | Delete link between a flow-cytometry object and a sample
*FlowCytometryFACSIntegrationAsCuratorApi* | [**get_flow_cytometry_by_sample_as_curator**](docs/FlowCytometryFACSIntegrationAsCuratorApi.md#get_flow_cytometry_by_sample_as_curator) | **GET** /api/v1/as-curator/integration/link/flow-cytometry/by/sample/{id} | Retrieve flow cytometry run-level data by querying related sample ID (accession)
*FlowCytometryFACSIntegrationAsCuratorApi* | [**get_flow_cytometry_groups_by_study_as_curator**](docs/FlowCytometryFACSIntegrationAsCuratorApi.md#get_flow_cytometry_groups_by_study_as_curator) | **GET** /api/v1/as-curator/integration/link/flow-cytometry/group/by/study/{id} | Retrieve group metadata by querying study ID (accession)
*FlowCytometryFACSIntegrationAsCuratorApi* | [**get_flow_cytometry_run_to_sample_pairs_as_curator**](docs/FlowCytometryFACSIntegrationAsCuratorApi.md#get_flow_cytometry_run_to_sample_pairs_as_curator) | **GET** /api/v1/as-curator/integration/link/flow-cytometry/run-to-samples/by/group/{id} | Retrieve run-sample pairs by group id. Pagination is based on unique runs, not unique pairs.
*FlowCytometryFACSIntegrationAsUserApi* | [**get_flow_cytometry_by_sample_as_user**](docs/FlowCytometryFACSIntegrationAsUserApi.md#get_flow_cytometry_by_sample_as_user) | **GET** /api/v1/as-user/integration/link/flow-cytometry/by/sample/{id} | Retrieve flow cytometry run-level data by querying related sample ID (accession)
*FlowCytometryFACSIntegrationAsUserApi* | [**get_flow_cytometry_groups_by_study_as_user**](docs/FlowCytometryFACSIntegrationAsUserApi.md#get_flow_cytometry_groups_by_study_as_user) | **GET** /api/v1/as-user/integration/link/flow-cytometry/group/by/study/{id} | Retrieve group metadata by querying study ID (accession)
*FlowCytometryFACSIntegrationAsUserApi* | [**get_flow_cytometry_run_to_sample_pairs_as_user**](docs/FlowCytometryFACSIntegrationAsUserApi.md#get_flow_cytometry_run_to_sample_pairs_as_user) | **GET** /api/v1/as-user/integration/link/flow-cytometry/run-to-samples/by/group/{id} | Retrieve run-sample pairs by group id. Pagination is based on unique runs, not unique pairs.
*GroupsApi* | [**create_group**](docs/GroupsApi.md#create_group) | **POST** /api/v1/scim/Groups | Add a new user group
*GroupsApi* | [**delete_group**](docs/GroupsApi.md#delete_group) | **DELETE** /api/v1/scim/Groups/{id} | Delete a group
*GroupsApi* | [**find_groups**](docs/GroupsApi.md#find_groups) | **GET** /api/v1/scim/Groups | Retrieve a list of available groups
*GroupsApi* | [**get_group**](docs/GroupsApi.md#get_group) | **GET** /api/v1/scim/Groups/{id} | Retrieve a group by id
*GroupsApi* | [**patch_group**](docs/GroupsApi.md#patch_group) | **PATCH** /api/v1/scim/Groups/{id} | Update a group
*JobOperationsApi* | [**info**](docs/JobOperationsApi.md#info) | **GET** /api/v1/jobs/{jobExecId}/info | get information about one particular job execution
*JobOperationsApi* | [**output**](docs/JobOperationsApi.md#output) | **GET** /api/v1/jobs/{jobExecId}/output | retrieve job output (result)
*JobOperationsApi* | [**restart**](docs/JobOperationsApi.md#restart) | **PUT** /api/v1/jobs/{jobExecId}/restart | restart stopped (failed) job
*JobOperationsApi* | [**stop**](docs/JobOperationsApi.md#stop) | **PUT** /api/v1/jobs/{jobExecId}/stop | stop running job
*LibrarySPoTAsCuratorApi* | [**get_libraries_by_group_as_curator**](docs/LibrarySPoTAsCuratorApi.md#get_libraries_by_group_as_curator) | **GET** /api/v1/as-curator/libraries/by/group/{id} | Retrieve libraries related to the given group
*LibrarySPoTAsCuratorApi* | [**get_library_as_curator**](docs/LibrarySPoTAsCuratorApi.md#get_library_as_curator) | **GET** /api/v1/as-curator/libraries/{id} | Retrieve a single library object by ID (accession)
*LibrarySPoTAsCuratorApi* | [**get_library_by_version_as_curator**](docs/LibrarySPoTAsCuratorApi.md#get_library_by_version_as_curator) | **GET** /api/v1/as-curator/libraries/{id}/versions/{version} | Retrieve a single library object by ID (accession)
*LibrarySPoTAsCuratorApi* | [**get_library_versions_as_curator**](docs/LibrarySPoTAsCuratorApi.md#get_library_versions_as_curator) | **GET** /api/v1/as-curator/libraries/{id}/versions | Retrieve a list of object versions by ID
*LibrarySPoTAsCuratorApi* | [**search_libraries_as_curator**](docs/LibrarySPoTAsCuratorApi.md#search_libraries_as_curator) | **GET** /api/v1/as-curator/libraries | List or search for library metadata objects
*LibrarySPoTAsCuratorApi* | [**update_library_as_curator**](docs/LibrarySPoTAsCuratorApi.md#update_library_as_curator) | **PATCH** /api/v1/as-curator/libraries/{id} | Update a library object
*LibrarySPoTAsUserApi* | [**get_libraries_by_group_as_user**](docs/LibrarySPoTAsUserApi.md#get_libraries_by_group_as_user) | **GET** /api/v1/as-user/libraries/by/group/{id} | Retrieve libraries related to the given group
*LibrarySPoTAsUserApi* | [**get_library_as_user**](docs/LibrarySPoTAsUserApi.md#get_library_as_user) | **GET** /api/v1/as-user/libraries/{id} | Retrieve a single library object by ID (accession)
*LibrarySPoTAsUserApi* | [**get_library_by_version_as_user**](docs/LibrarySPoTAsUserApi.md#get_library_by_version_as_user) | **GET** /api/v1/as-user/libraries/{id}/versions/{version} | Retrieve a single library object by ID (accession)
*LibrarySPoTAsUserApi* | [**get_library_versions_as_user**](docs/LibrarySPoTAsUserApi.md#get_library_versions_as_user) | **GET** /api/v1/as-user/libraries/{id}/versions | Retrieve a list of object versions by ID
*LibrarySPoTAsUserApi* | [**search_libraries_as_user**](docs/LibrarySPoTAsUserApi.md#search_libraries_as_user) | **GET** /api/v1/as-user/libraries | List or search for library metadata objects
*LibraryIntegrationAsCuratorApi* | [**create_library_group_sample_group_link_as_curator**](docs/LibraryIntegrationAsCuratorApi.md#create_library_group_sample_group_link_as_curator) | **POST** /api/v1/as-curator/integration/link/library/group/{sourceId}/to/sample/group/{targetId} | Create links between samples and libraries
*LibraryIntegrationAsCuratorApi* | [**create_library_sample_link_as_curator**](docs/LibraryIntegrationAsCuratorApi.md#create_library_sample_link_as_curator) | **POST** /api/v1/as-curator/integration/link/library/{sourceId}/to/sample/{targetId} | Create a link between a library and a sample
*LibraryIntegrationAsCuratorApi* | [**delete_library_group_sample_group_link_as_curator**](docs/LibraryIntegrationAsCuratorApi.md#delete_library_group_sample_group_link_as_curator) | **DELETE** /api/v1/as-curator/integration/link/library/group/{sourceId}/to/sample/group/{targetId} | Delete links between samples and libraries related to the specified group
*LibraryIntegrationAsCuratorApi* | [**delete_library_sample_link_as_curator**](docs/LibraryIntegrationAsCuratorApi.md#delete_library_sample_link_as_curator) | **DELETE** /api/v1/as-curator/integration/link/library/{sourceId}/to/sample/{targetId} | Delete a link between a library and a sample
*LibraryIntegrationAsCuratorApi* | [**get_libraries_by_samples_as_curator**](docs/LibraryIntegrationAsCuratorApi.md#get_libraries_by_samples_as_curator) | **GET** /api/v1/as-curator/integration/link/libraries/by/samples | Retrieve library metadata by querying related samples
*LibraryIntegrationAsCuratorApi* | [**get_library_by_sample_as_curator**](docs/LibraryIntegrationAsCuratorApi.md#get_library_by_sample_as_curator) | **GET** /api/v1/as-curator/integration/link/library/by/sample/{id} | Retrieve library metadata by querying related sample ID (accession)
*LibraryIntegrationAsCuratorApi* | [**get_library_groups_by_study_as_curator**](docs/LibraryIntegrationAsCuratorApi.md#get_library_groups_by_study_as_curator) | **GET** /api/v1/as-curator/integration/link/library/group/by/study/{id} | Retrieve group metadata by querying study ID (accession)
*LibraryIntegrationAsCuratorApi* | [**get_library_links_to_samples_as_curator**](docs/LibraryIntegrationAsCuratorApi.md#get_library_links_to_samples_as_curator) | **GET** /api/v1/as-curator/integration/link/library/libraries-to-samples/by/group/{id} | Retrieve library-samples pairs by group id. Pagination is based on unique libraries, not unique pairs.
*LibraryIntegrationAsUserApi* | [**get_libraries_by_samples_as_user**](docs/LibraryIntegrationAsUserApi.md#get_libraries_by_samples_as_user) | **GET** /api/v1/as-user/integration/link/libraries/by/samples | Retrieve library metadata by querying related samples
*LibraryIntegrationAsUserApi* | [**get_library_by_sample_as_user**](docs/LibraryIntegrationAsUserApi.md#get_library_by_sample_as_user) | **GET** /api/v1/as-user/integration/link/library/by/sample/{id} | Retrieve library metadata by querying related sample ID (accession)
*LibraryIntegrationAsUserApi* | [**get_library_groups_by_study_as_user**](docs/LibraryIntegrationAsUserApi.md#get_library_groups_by_study_as_user) | **GET** /api/v1/as-user/integration/link/library/group/by/study/{id} | Retrieve group metadata by querying study ID (accession)
*LibraryIntegrationAsUserApi* | [**get_library_links_to_samples_as_user**](docs/LibraryIntegrationAsUserApi.md#get_library_links_to_samples_as_user) | **GET** /api/v1/as-user/integration/link/library/libraries-to-samples/by/group/{id} | Retrieve library-samples pairs by group id. Pagination is based on unique libraries, not unique pairs.
*LinkageAsCuratorApi* | [**delete_link_as_curator**](docs/LinkageAsCuratorApi.md#delete_link_as_curator) | **DELETE** /api/v1/as-curator/links | Deletes existing links matching the specified criteria.
*LinkageAsCuratorApi* | [**get_data_types_as_curator**](docs/LinkageAsCuratorApi.md#get_data_types_as_curator) | **GET** /api/v1/as-curator/data-types | Lists all available data types.
*LinkageAsCuratorApi* | [**get_data_types_links_as_curator**](docs/LinkageAsCuratorApi.md#get_data_types_links_as_curator) | **GET** /api/v1/as-curator/data-types/links | List all possible links between data types that match the specified criteria.
*LinkageAsCuratorApi* | [**get_links_by_ids_as_curator**](docs/LinkageAsCuratorApi.md#get_links_by_ids_as_curator) | **POST** /api/v1/as-curator/links/get-batch | Finds existing links by passing many IDs.  Pagination goes through all links matched the criteria.
*LinkageAsCuratorApi* | [**get_links_by_params_as_curator**](docs/LinkageAsCuratorApi.md#get_links_by_params_as_curator) | **GET** /api/v1/as-curator/links | Finds existing links matching the specified criteria.
*LinkageAsCuratorApi* | [**save_links_as_curator**](docs/LinkageAsCuratorApi.md#save_links_as_curator) | **POST** /api/v1/as-curator/links | Creates new links between objects.
*LinkageAsUserApi* | [**get_data_types_as_user**](docs/LinkageAsUserApi.md#get_data_types_as_user) | **GET** /api/v1/as-user/data-types | Lists all available data types.
*LinkageAsUserApi* | [**get_data_types_links_as_user**](docs/LinkageAsUserApi.md#get_data_types_links_as_user) | **GET** /api/v1/as-user/data-types/links | List all possible links between data types that match the specified criteria.
*LinkageAsUserApi* | [**get_links_by_ids_as_user**](docs/LinkageAsUserApi.md#get_links_by_ids_as_user) | **POST** /api/v1/as-user/links/get-batch | Finds existing links by passing many IDs.  Pagination goes through all links matched the criteria.
*LinkageAsUserApi* | [**get_links_by_params_as_user**](docs/LinkageAsUserApi.md#get_links_by_params_as_user) | **GET** /api/v1/as-user/links | Finds existing links matching the specified criteria.
*ManageDataApi* | [**delete_data**](docs/ManageDataApi.md#delete_data) | **DELETE** /api/v1/manage-data/data | Delete objects from ODM
*ManageDataApi* | [**get_detached_objects**](docs/ManageDataApi.md#get_detached_objects) | **GET** /api/v1/manage-data/detached-objects | Retrieve a list of detached objects
*MetadataVersioningAsCuratorApi* | [**publish_study_by_accession_as_curator**](docs/MetadataVersioningAsCuratorApi.md#publish_study_by_accession_as_curator) | **POST** /api/v1/as-curator/integration/studies/{id}/tasks/publish-versions | Asynchronous task that publishes all pending versions for a single study.
*OmicsQueriesAsCuratorApi* | [**omics_search_expression_data_as_curator**](docs/OmicsQueriesAsCuratorApi.md#omics_search_expression_data_as_curator) | **GET** /api/v1/as-curator/omics/expression/data | Retrieve data objects by searching across multiple data types
*OmicsQueriesAsCuratorApi* | [**omics_search_expression_groups_as_curator**](docs/OmicsQueriesAsCuratorApi.md#omics_search_expression_groups_as_curator) | **GET** /api/v1/as-curator/omics/expression/group | Retrieve group objects by searching across multiple data types
*OmicsQueriesAsCuratorApi* | [**omics_search_flow_cytometry_data_as_curator**](docs/OmicsQueriesAsCuratorApi.md#omics_search_flow_cytometry_data_as_curator) | **GET** /api/v1/as-curator/omics/flow-cytometry/data | Retrieve flow cytometry data objects by searching across multiple data types
*OmicsQueriesAsCuratorApi* | [**omics_search_flow_cytometry_groups_as_curator**](docs/OmicsQueriesAsCuratorApi.md#omics_search_flow_cytometry_groups_as_curator) | **GET** /api/v1/as-curator/omics/flow-cytometry/group | Retrieve group objects by searching across multiple data types
*OmicsQueriesAsCuratorApi* | [**omics_search_samples_as_curator**](docs/OmicsQueriesAsCuratorApi.md#omics_search_samples_as_curator) | **GET** /api/v1/as-curator/omics/samples | Retrieve sample metadata objects by searching across multiple data types
*OmicsQueriesAsCuratorApi* | [**omics_search_streamed_expression_data_as_curator**](docs/OmicsQueriesAsCuratorApi.md#omics_search_streamed_expression_data_as_curator) | **GET** /api/v1/as-curator/omics/expression/streamed-data | Stream data from a given tabular file
*OmicsQueriesAsCuratorApi* | [**omics_search_streamed_variant_data_as_curator**](docs/OmicsQueriesAsCuratorApi.md#omics_search_streamed_variant_data_as_curator) | **GET** /api/v1/as-curator/omics/variant/streamed-data | Stream data from a given VCF file
*OmicsQueriesAsCuratorApi* | [**omics_search_variant_data_as_curator**](docs/OmicsQueriesAsCuratorApi.md#omics_search_variant_data_as_curator) | **GET** /api/v1/as-curator/omics/variant/data | Retrieve variant data objects by searching across multiple data types
*OmicsQueriesAsCuratorApi* | [**omics_search_variant_groups_as_curator**](docs/OmicsQueriesAsCuratorApi.md#omics_search_variant_groups_as_curator) | **GET** /api/v1/as-curator/omics/variant/group | Retrieve group objects by searching across multiple data types
*OmicsQueriesAsUserApi* | [**omics_search_expression_data_as_user**](docs/OmicsQueriesAsUserApi.md#omics_search_expression_data_as_user) | **GET** /api/v1/as-user/omics/expression/data | Retrieve data objects by searching across multiple data types
*OmicsQueriesAsUserApi* | [**omics_search_expression_groups_as_user**](docs/OmicsQueriesAsUserApi.md#omics_search_expression_groups_as_user) | **GET** /api/v1/as-user/omics/expression/group | Retrieve group objects by searching across multiple data types
*OmicsQueriesAsUserApi* | [**omics_search_flow_cytometry_data_as_user**](docs/OmicsQueriesAsUserApi.md#omics_search_flow_cytometry_data_as_user) | **GET** /api/v1/as-user/omics/flow-cytometry/data | Retrieve flow cytometry data objects by searching across multiple data types
*OmicsQueriesAsUserApi* | [**omics_search_flow_cytometry_groups_as_user**](docs/OmicsQueriesAsUserApi.md#omics_search_flow_cytometry_groups_as_user) | **GET** /api/v1/as-user/omics/flow-cytometry/group | Retrieve group objects by searching across multiple data types
*OmicsQueriesAsUserApi* | [**omics_search_samples_as_user**](docs/OmicsQueriesAsUserApi.md#omics_search_samples_as_user) | **GET** /api/v1/as-user/omics/samples | Retrieve sample metadata objects by searching across multiple data types
*OmicsQueriesAsUserApi* | [**omics_search_streamed_expression_data_as_user**](docs/OmicsQueriesAsUserApi.md#omics_search_streamed_expression_data_as_user) | **GET** /api/v1/as-user/omics/expression/streamed-data | Stream data from a given tabular file
*OmicsQueriesAsUserApi* | [**omics_search_streamed_variant_data_as_user**](docs/OmicsQueriesAsUserApi.md#omics_search_streamed_variant_data_as_user) | **GET** /api/v1/as-user/omics/variant/streamed-data | Stream data from a given VCF file
*OmicsQueriesAsUserApi* | [**omics_search_variant_data_as_user**](docs/OmicsQueriesAsUserApi.md#omics_search_variant_data_as_user) | **GET** /api/v1/as-user/omics/variant/data | Retrieve variant data objects by searching across multiple data types
*OmicsQueriesAsUserApi* | [**omics_search_variant_groups_as_user**](docs/OmicsQueriesAsUserApi.md#omics_search_variant_groups_as_user) | **GET** /api/v1/as-user/omics/variant/group | Retrieve group objects by searching across multiple data types
*PreparationSPoTAsCuratorApi* | [**get_preparation_as_curator**](docs/PreparationSPoTAsCuratorApi.md#get_preparation_as_curator) | **GET** /api/v1/as-curator/preparations/{id} | Retrieve a single preparation object by ID (accession)
*PreparationSPoTAsCuratorApi* | [**get_preparation_by_version_as_curator**](docs/PreparationSPoTAsCuratorApi.md#get_preparation_by_version_as_curator) | **GET** /api/v1/as-curator/preparations/{id}/versions/{version} | Retrieve a single preparation object by ID (accession)
*PreparationSPoTAsCuratorApi* | [**get_preparation_versions_as_curator**](docs/PreparationSPoTAsCuratorApi.md#get_preparation_versions_as_curator) | **GET** /api/v1/as-curator/preparations/{id}/versions | Retrieve a list of object versions by ID
*PreparationSPoTAsCuratorApi* | [**get_preparations_by_group_as_curator**](docs/PreparationSPoTAsCuratorApi.md#get_preparations_by_group_as_curator) | **GET** /api/v1/as-curator/preparations/by/group/{id} | Retrieve preparations related to the given group
*PreparationSPoTAsCuratorApi* | [**search_preparations_as_curator**](docs/PreparationSPoTAsCuratorApi.md#search_preparations_as_curator) | **GET** /api/v1/as-curator/preparations | List or search for preparation metadata objects
*PreparationSPoTAsCuratorApi* | [**update_preparation_as_curator**](docs/PreparationSPoTAsCuratorApi.md#update_preparation_as_curator) | **PATCH** /api/v1/as-curator/preparations/{id} | Update a preparation object
*PreparationSPoTAsUserApi* | [**get_preparation_as_user**](docs/PreparationSPoTAsUserApi.md#get_preparation_as_user) | **GET** /api/v1/as-user/preparations/{id} | Retrieve a single preparation object by ID (accession)
*PreparationSPoTAsUserApi* | [**get_preparation_by_version_as_user**](docs/PreparationSPoTAsUserApi.md#get_preparation_by_version_as_user) | **GET** /api/v1/as-user/preparations/{id}/versions/{version} | Retrieve a single preparation object by ID (accession)
*PreparationSPoTAsUserApi* | [**get_preparation_versions_as_user**](docs/PreparationSPoTAsUserApi.md#get_preparation_versions_as_user) | **GET** /api/v1/as-user/preparations/{id}/versions | Retrieve a list of object versions by ID
*PreparationSPoTAsUserApi* | [**get_preparations_by_group_as_user**](docs/PreparationSPoTAsUserApi.md#get_preparations_by_group_as_user) | **GET** /api/v1/as-user/preparations/by/group/{id} | Retrieve preparations related to the given group
*PreparationSPoTAsUserApi* | [**search_preparations_as_user**](docs/PreparationSPoTAsUserApi.md#search_preparations_as_user) | **GET** /api/v1/as-user/preparations | List or search for preparation metadata objects
*PreparationIntegrationAsCuratorApi* | [**create_preparation_group_sample_group_link_as_curator**](docs/PreparationIntegrationAsCuratorApi.md#create_preparation_group_sample_group_link_as_curator) | **POST** /api/v1/as-curator/integration/link/preparation/group/{sourceId}/to/sample/group/{targetId} | Create links between samples and preparations
*PreparationIntegrationAsCuratorApi* | [**create_preparation_sample_link_as_curator**](docs/PreparationIntegrationAsCuratorApi.md#create_preparation_sample_link_as_curator) | **POST** /api/v1/as-curator/integration/link/preparation/{sourceId}/to/sample/{targetId} | Create a link between a preparation and a sample
*PreparationIntegrationAsCuratorApi* | [**delete_preparation_group_sample_group_link_as_curator**](docs/PreparationIntegrationAsCuratorApi.md#delete_preparation_group_sample_group_link_as_curator) | **DELETE** /api/v1/as-curator/integration/link/preparation/group/{sourceId}/to/sample/group/{targetId} | Delete links between samples and preparations related to the specified group
*PreparationIntegrationAsCuratorApi* | [**delete_preparation_sample_link_as_curator**](docs/PreparationIntegrationAsCuratorApi.md#delete_preparation_sample_link_as_curator) | **DELETE** /api/v1/as-curator/integration/link/preparation/{sourceId}/to/sample/{targetId} | Delete a link between a preparation and a sample
*PreparationIntegrationAsCuratorApi* | [**get_preparation_by_sample_as_curator**](docs/PreparationIntegrationAsCuratorApi.md#get_preparation_by_sample_as_curator) | **GET** /api/v1/as-curator/integration/link/preparation/by/sample/{id} | Retrieve preparation metadata by querying related sample ID (accession)
*PreparationIntegrationAsCuratorApi* | [**get_preparation_groups_by_study_as_curator**](docs/PreparationIntegrationAsCuratorApi.md#get_preparation_groups_by_study_as_curator) | **GET** /api/v1/as-curator/integration/link/preparation/group/by/study/{id} | Retrieve group metadata by querying study ID (accession)
*PreparationIntegrationAsCuratorApi* | [**get_preparation_links_to_samples_as_curator**](docs/PreparationIntegrationAsCuratorApi.md#get_preparation_links_to_samples_as_curator) | **GET** /api/v1/as-curator/integration/link/preparation/preparations-to-samples/by/group/{id} | Retrieve run-sample pairs by group id. Pagination is based on unique preparations, not unique pairs.
*PreparationIntegrationAsCuratorApi* | [**get_preparations_by_samples_as_curator**](docs/PreparationIntegrationAsCuratorApi.md#get_preparations_by_samples_as_curator) | **GET** /api/v1/as-curator/integration/link/preparations/by/samples | Retrieve preparation metadata by querying related samples
*PreparationIntegrationAsUserApi* | [**get_preparation_by_sample_as_user**](docs/PreparationIntegrationAsUserApi.md#get_preparation_by_sample_as_user) | **GET** /api/v1/as-user/integration/link/preparation/by/sample/{id} | Retrieve preparation metadata by querying related sample ID (accession)
*PreparationIntegrationAsUserApi* | [**get_preparation_groups_by_study_as_user**](docs/PreparationIntegrationAsUserApi.md#get_preparation_groups_by_study_as_user) | **GET** /api/v1/as-user/integration/link/preparation/group/by/study/{id} | Retrieve group metadata by querying study ID (accession)
*PreparationIntegrationAsUserApi* | [**get_preparation_links_to_samples_as_user**](docs/PreparationIntegrationAsUserApi.md#get_preparation_links_to_samples_as_user) | **GET** /api/v1/as-user/integration/link/preparation/preparations-to-samples/by/group/{id} | Retrieve run-sample pairs by group id. Pagination is based on unique preparations, not unique pairs.
*PreparationIntegrationAsUserApi* | [**get_preparations_by_samples_as_user**](docs/PreparationIntegrationAsUserApi.md#get_preparations_by_samples_as_user) | **GET** /api/v1/as-user/integration/link/preparations/by/samples | Retrieve preparation metadata by querying related samples
*ReferenceGenomeApi* | [**get_reference_genome_by_accession**](docs/ReferenceGenomeApi.md#get_reference_genome_by_accession) | **GET** /api/v1/reference-genomes/{id} | Retrieve a single Reference Genome object by ID (accession)
*ReferenceGenomeApi* | [**search_reference_genomes**](docs/ReferenceGenomeApi.md#search_reference_genomes) | **GET** /api/v1/reference-genomes | List or search for Reference Genome objects
*ReferenceGenomeApi* | [**upload**](docs/ReferenceGenomeApi.md#upload) | **POST** /api/v1/reference-genomes | Upload reference genome to ODM
*SampleSPoTAsCuratorApi* | [**get_sample_as_curator**](docs/SampleSPoTAsCuratorApi.md#get_sample_as_curator) | **GET** /api/v1/as-curator/samples/{id} | Retrieve a single sample object by ID (accession)
*SampleSPoTAsCuratorApi* | [**get_sample_by_version_as_curator**](docs/SampleSPoTAsCuratorApi.md#get_sample_by_version_as_curator) | **GET** /api/v1/as-curator/samples/{id}/versions/{version} | Retrieve a single sample object by ID (accession)
*SampleSPoTAsCuratorApi* | [**get_sample_versions_as_curator**](docs/SampleSPoTAsCuratorApi.md#get_sample_versions_as_curator) | **GET** /api/v1/as-curator/samples/{id}/versions | Retrieve a list of object versions by ID
*SampleSPoTAsCuratorApi* | [**search_samples_as_curator**](docs/SampleSPoTAsCuratorApi.md#search_samples_as_curator) | **GET** /api/v1/as-curator/samples | List or search for sample metadata objects
*SampleSPoTAsCuratorApi* | [**update_sample_as_curator**](docs/SampleSPoTAsCuratorApi.md#update_sample_as_curator) | **PATCH** /api/v1/as-curator/samples/{id} | Update a sample object
*SampleSPoTAsUserApi* | [**get_sample_as_user**](docs/SampleSPoTAsUserApi.md#get_sample_as_user) | **GET** /api/v1/as-user/samples/{id} | Retrieve a single sample object by ID (accession)
*SampleSPoTAsUserApi* | [**get_sample_by_version_as_user**](docs/SampleSPoTAsUserApi.md#get_sample_by_version_as_user) | **GET** /api/v1/as-user/samples/{id}/versions/{version} | Retrieve a single sample object by ID (accession)
*SampleSPoTAsUserApi* | [**get_sample_versions_as_user**](docs/SampleSPoTAsUserApi.md#get_sample_versions_as_user) | **GET** /api/v1/as-user/samples/{id}/versions | Retrieve a list of object versions by ID
*SampleSPoTAsUserApi* | [**search_samples_as_user**](docs/SampleSPoTAsUserApi.md#search_samples_as_user) | **GET** /api/v1/as-user/samples | List or search for sample metadata objects
*SampleIntegrationAsCuratorApi* | [**create_sample_group_study_link_as_curator**](docs/SampleIntegrationAsCuratorApi.md#create_sample_group_study_link_as_curator) | **POST** /api/v1/as-curator/integration/link/sample/group/{sourceId}/to/study/{targetId} | Create a link between a group of sample objects and a study
*SampleIntegrationAsCuratorApi* | [**create_sample_study_link_as_curator**](docs/SampleIntegrationAsCuratorApi.md#create_sample_study_link_as_curator) | **POST** /api/v1/as-curator/integration/link/sample/{sourceId}/to/study/{targetId} | Create a link between a sample and a study
*SampleIntegrationAsCuratorApi* | [**delete_sample_group_study_link_as_curator**](docs/SampleIntegrationAsCuratorApi.md#delete_sample_group_study_link_as_curator) | **DELETE** /api/v1/as-curator/integration/link/sample/group/{sourceId}/to/study/{targetId} | Delete link between a group of sample objects and a study
*SampleIntegrationAsCuratorApi* | [**delete_sample_study_link_as_curator**](docs/SampleIntegrationAsCuratorApi.md#delete_sample_study_link_as_curator) | **DELETE** /api/v1/as-curator/integration/link/sample/{sourceId}/to/study/{targetId} | Delete link between a sample and a study
*SampleIntegrationAsCuratorApi* | [**get_samples_by_libraries_as_curator**](docs/SampleIntegrationAsCuratorApi.md#get_samples_by_libraries_as_curator) | **GET** /api/v1/as-curator/integration/link/samples/by/libraries | Retrieve sample metadata by querying related libraries
*SampleIntegrationAsCuratorApi* | [**get_samples_by_preparations_as_curator**](docs/SampleIntegrationAsCuratorApi.md#get_samples_by_preparations_as_curator) | **GET** /api/v1/as-curator/integration/link/samples/by/preparations | Retrieve sample metadata by querying related preparations
*SampleIntegrationAsCuratorApi* | [**get_samples_by_study_as_curator**](docs/SampleIntegrationAsCuratorApi.md#get_samples_by_study_as_curator) | **GET** /api/v1/as-curator/integration/link/samples/by/study/{id} | Retrieve sample metadata by querying related study ID (accession)
*SampleIntegrationAsUserApi* | [**get_samples_by_libraries_as_user**](docs/SampleIntegrationAsUserApi.md#get_samples_by_libraries_as_user) | **GET** /api/v1/as-user/integration/link/samples/by/libraries | Retrieve sample metadata by querying related libraries
*SampleIntegrationAsUserApi* | [**get_samples_by_preparations_as_user**](docs/SampleIntegrationAsUserApi.md#get_samples_by_preparations_as_user) | **GET** /api/v1/as-user/integration/link/samples/by/preparations | Retrieve sample metadata by querying related preparations
*SampleIntegrationAsUserApi* | [**get_samples_by_study_as_user**](docs/SampleIntegrationAsUserApi.md#get_samples_by_study_as_user) | **GET** /api/v1/as-user/integration/link/samples/by/study/{id} | Retrieve sample metadata by querying related study ID (accession)
*StudySPoTAsCuratorApi* | [**get_study_as_curator**](docs/StudySPoTAsCuratorApi.md#get_study_as_curator) | **GET** /api/v1/as-curator/studies/{id} | Retrieve a single study object by ID (accession)
*StudySPoTAsCuratorApi* | [**get_study_by_version_as_curator**](docs/StudySPoTAsCuratorApi.md#get_study_by_version_as_curator) | **GET** /api/v1/as-curator/studies/{id}/versions/{version} | Retrieve a single study object by ID (accession)
*StudySPoTAsCuratorApi* | [**get_study_versions_as_curator**](docs/StudySPoTAsCuratorApi.md#get_study_versions_as_curator) | **GET** /api/v1/as-curator/studies/{id}/versions | Retrieve a list of object versions by ID
*StudySPoTAsCuratorApi* | [**search_studies_as_curator**](docs/StudySPoTAsCuratorApi.md#search_studies_as_curator) | **GET** /api/v1/as-curator/studies | List or search for study metadata objects
*StudySPoTAsCuratorApi* | [**update_study_as_curator**](docs/StudySPoTAsCuratorApi.md#update_study_as_curator) | **PATCH** /api/v1/as-curator/studies/{id} | Update a study object
*StudySPoTAsUserApi* | [**get_study_as_user**](docs/StudySPoTAsUserApi.md#get_study_as_user) | **GET** /api/v1/as-user/studies/{id} | Retrieve a single study object by ID (accession)
*StudySPoTAsUserApi* | [**get_study_by_version_as_user**](docs/StudySPoTAsUserApi.md#get_study_by_version_as_user) | **GET** /api/v1/as-user/studies/{id}/versions/{version} | Retrieve a single study object by ID (accession)
*StudySPoTAsUserApi* | [**get_study_versions_as_user**](docs/StudySPoTAsUserApi.md#get_study_versions_as_user) | **GET** /api/v1/as-user/studies/{id}/versions | Retrieve a list of object versions by ID
*StudySPoTAsUserApi* | [**search_studies_as_user**](docs/StudySPoTAsUserApi.md#search_studies_as_user) | **GET** /api/v1/as-user/studies | List or search for study metadata objects
*StudyIntegrationAsCuratorApi* | [**get_studies_by_files_as_curator**](docs/StudyIntegrationAsCuratorApi.md#get_studies_by_files_as_curator) | **GET** /api/v1/as-curator/integration/link/studies/by/files | Retrieve study metadata objects by querying related attachment files
*StudyIntegrationAsCuratorApi* | [**get_studies_by_libraries_as_curator**](docs/StudyIntegrationAsCuratorApi.md#get_studies_by_libraries_as_curator) | **GET** /api/v1/as-curator/integration/link/studies/by/libraries | Retrieve study metadata objects by querying related libraries
*StudyIntegrationAsCuratorApi* | [**get_studies_by_preparations_as_curator**](docs/StudyIntegrationAsCuratorApi.md#get_studies_by_preparations_as_curator) | **GET** /api/v1/as-curator/integration/link/studies/by/preparations | Retrieve study metadata objects by querying related preparations
*StudyIntegrationAsCuratorApi* | [**get_studies_by_samples_as_curator**](docs/StudyIntegrationAsCuratorApi.md#get_studies_by_samples_as_curator) | **GET** /api/v1/as-curator/integration/link/studies/by/samples | Retrieve study metadata objects by querying related samples
*StudyIntegrationAsCuratorApi* | [**get_study_by_file_as_curator**](docs/StudyIntegrationAsCuratorApi.md#get_study_by_file_as_curator) | **GET** /api/v1/as-curator/integration/link/study/by/file/{id} | Retrieve study metadata by querying attachment file ID (accession)
*StudyIntegrationAsCuratorApi* | [**get_study_by_sample_as_curator**](docs/StudyIntegrationAsCuratorApi.md#get_study_by_sample_as_curator) | **GET** /api/v1/as-curator/integration/link/study/by/sample/{id} | Retrieve study metadata by querying sample ID (accession)
*StudyIntegrationAsCuratorApi* | [**search_studies_by_filter_as_curator**](docs/StudyIntegrationAsCuratorApi.md#search_studies_by_filter_as_curator) | **POST** /api/v1/as-curator/integration/fulltext/search/studies | Find and retrieve studies by full-text or facet query
*StudyIntegrationAsUserApi* | [**get_studies_by_files_as_user**](docs/StudyIntegrationAsUserApi.md#get_studies_by_files_as_user) | **GET** /api/v1/as-user/integration/link/studies/by/files | Retrieve study metadata objects by querying related attachment files
*StudyIntegrationAsUserApi* | [**get_studies_by_libraries_as_user**](docs/StudyIntegrationAsUserApi.md#get_studies_by_libraries_as_user) | **GET** /api/v1/as-user/integration/link/studies/by/libraries | Retrieve study metadata objects by querying related libraries
*StudyIntegrationAsUserApi* | [**get_studies_by_preparations_as_user**](docs/StudyIntegrationAsUserApi.md#get_studies_by_preparations_as_user) | **GET** /api/v1/as-user/integration/link/studies/by/preparations | Retrieve study metadata objects by querying related preparations
*StudyIntegrationAsUserApi* | [**get_studies_by_samples_as_user**](docs/StudyIntegrationAsUserApi.md#get_studies_by_samples_as_user) | **GET** /api/v1/as-user/integration/link/studies/by/samples | Retrieve study metadata objects by querying related samples
*StudyIntegrationAsUserApi* | [**get_study_by_file_as_user**](docs/StudyIntegrationAsUserApi.md#get_study_by_file_as_user) | **GET** /api/v1/as-user/integration/link/study/by/file/{id} | Retrieve study metadata by querying attachment file ID (accession)
*StudyIntegrationAsUserApi* | [**get_study_by_sample_as_user**](docs/StudyIntegrationAsUserApi.md#get_study_by_sample_as_user) | **GET** /api/v1/as-user/integration/link/study/by/sample/{id} | Retrieve study metadata by querying sample ID (accession)
*StudyIntegrationAsUserApi* | [**search_studies_by_filter_as_user**](docs/StudyIntegrationAsUserApi.md#search_studies_by_filter_as_user) | **POST** /api/v1/as-user/integration/fulltext/search/studies | Find and retrieve studies by full-text or facet query
*TasksAPIApi* | [**get_task_info**](docs/TasksAPIApi.md#get_task_info) | **GET** /api/v1/tasks/{id} | Retrieve information about any ODM task.
*TasksAPIApi* | [**publish_all_studies**](docs/TasksAPIApi.md#publish_all_studies) | **POST** /api/v1/tasks/publish-versions | Asynchronous task that publishes all pending versions across all studies in the instance.
*UsersApi* | [**create_user**](docs/UsersApi.md#create_user) | **POST** /api/v1/scim/Users | Add a new user
*UsersApi* | [**delete_user**](docs/UsersApi.md#delete_user) | **DELETE** /api/v1/scim/Users/{id} | Deactivate a user
*UsersApi* | [**find_users**](docs/UsersApi.md#find_users) | **GET** /api/v1/scim/Users | Retrieve a list of all active users
*UsersApi* | [**get_user**](docs/UsersApi.md#get_user) | **GET** /api/v1/scim/Users/{id} | Retrieve a user by id
*UsersApi* | [**patch_user**](docs/UsersApi.md#patch_user) | **PATCH** /api/v1/scim/Users/{id} | Update a user
*ValidationSummaryAsCuratorApi* | [**get_study_validation_summary**](docs/ValidationSummaryAsCuratorApi.md#get_study_validation_summary) | **GET** /api/v1/as-curator/integration/studies/{id}/validation-summary | Retrieve validation summary by querying study ID (accession)
*VariantSPoTAsCuratorApi* | [**get_all_variants_as_curator**](docs/VariantSPoTAsCuratorApi.md#get_all_variants_as_curator) | **GET** /api/v1/as-curator/variants | Retrieve multiple variant data and metadata objects
*VariantSPoTAsCuratorApi* | [**get_variant_as_curator**](docs/VariantSPoTAsCuratorApi.md#get_variant_as_curator) | **GET** /api/v1/as-curator/variants/{id} | Retrieve a single variant object by ID (accession)
*VariantSPoTAsCuratorApi* | [**get_variant_by_version_as_curator**](docs/VariantSPoTAsCuratorApi.md#get_variant_by_version_as_curator) | **GET** /api/v1/as-curator/variants/{id}/versions/{version} | Retrieve a single variant object by ID (accession)
*VariantSPoTAsCuratorApi* | [**get_variant_group_as_curator**](docs/VariantSPoTAsCuratorApi.md#get_variant_group_as_curator) | **GET** /api/v1/as-curator/variants/group/{id} | Retrieve a single group object by ID (accession)
*VariantSPoTAsCuratorApi* | [**get_variant_group_by_run_as_curator**](docs/VariantSPoTAsCuratorApi.md#get_variant_group_by_run_as_curator) | **GET** /api/v1/as-curator/variants/group/by/run/{id} | Retrieve a single group object by run ID (accession)
*VariantSPoTAsCuratorApi* | [**get_variant_versions_as_curator**](docs/VariantSPoTAsCuratorApi.md#get_variant_versions_as_curator) | **GET** /api/v1/as-curator/variants/{id}/versions | Retrieve a list of object versions by ID
*VariantSPoTAsCuratorApi* | [**search_groups_as_curator**](docs/VariantSPoTAsCuratorApi.md#search_groups_as_curator) | **GET** /api/v1/as-curator/variants/group | Retrieve groups that match a query
*VariantSPoTAsCuratorApi* | [**search_variant_runs_as_curator**](docs/VariantSPoTAsCuratorApi.md#search_variant_runs_as_curator) | **GET** /api/v1/as-curator/variants/runs/by/group/{id} | Retrieve run objects related to the given group
*VariantSPoTAsUserApi* | [**get_all_variants_as_user**](docs/VariantSPoTAsUserApi.md#get_all_variants_as_user) | **GET** /api/v1/as-user/variants | Retrieve multiple variant data and metadata objects
*VariantSPoTAsUserApi* | [**get_variant_as_user**](docs/VariantSPoTAsUserApi.md#get_variant_as_user) | **GET** /api/v1/as-user/variants/{id} | Retrieve a single variant object by ID (accession)
*VariantSPoTAsUserApi* | [**get_variant_by_version_as_user**](docs/VariantSPoTAsUserApi.md#get_variant_by_version_as_user) | **GET** /api/v1/as-user/variants/{id}/versions/{version} | Retrieve a single variant object by ID (accession)
*VariantSPoTAsUserApi* | [**get_variant_group_as_user**](docs/VariantSPoTAsUserApi.md#get_variant_group_as_user) | **GET** /api/v1/as-user/variants/group/{id} | Retrieve a single group object by ID (accession)
*VariantSPoTAsUserApi* | [**get_variant_group_by_run_as_user**](docs/VariantSPoTAsUserApi.md#get_variant_group_by_run_as_user) | **GET** /api/v1/as-user/variants/group/by/run/{id} | Retrieve a single group object by run ID (accession)
*VariantSPoTAsUserApi* | [**get_variant_versions_as_user**](docs/VariantSPoTAsUserApi.md#get_variant_versions_as_user) | **GET** /api/v1/as-user/variants/{id}/versions | Retrieve a list of object versions by ID
*VariantSPoTAsUserApi* | [**search_variant_groups_as_user**](docs/VariantSPoTAsUserApi.md#search_variant_groups_as_user) | **GET** /api/v1/as-user/variants/group | Retrieve groups that match a query
*VariantSPoTAsUserApi* | [**search_variant_runs_as_user**](docs/VariantSPoTAsUserApi.md#search_variant_runs_as_user) | **GET** /api/v1/as-user/variants/runs/by/group/{id} | Retrieve run objects related to the given group
*VariantIntegrationAsCuratorApi* | [**create_variant_group_sample_group_link_as_curator**](docs/VariantIntegrationAsCuratorApi.md#create_variant_group_sample_group_link_as_curator) | **POST** /api/v1/as-curator/integration/link/variant/group/{sourceId}/to/sample/group/{targetId} | Create a link between a group of variant objects and a group of sample objects
*VariantIntegrationAsCuratorApi* | [**create_variant_sample_link_as_curator**](docs/VariantIntegrationAsCuratorApi.md#create_variant_sample_link_as_curator) | **POST** /api/v1/as-curator/integration/link/variant/{sourceId}/to/sample/{targetId} | Create a link between a variant object and a sample
*VariantIntegrationAsCuratorApi* | [**delete_variant_group_sample_group_link_as_curator**](docs/VariantIntegrationAsCuratorApi.md#delete_variant_group_sample_group_link_as_curator) | **DELETE** /api/v1/as-curator/integration/link/variant/group/{sourceId}/to/sample/group/{targetId} | Delete link between a group of variant objects and a group of sample objects
*VariantIntegrationAsCuratorApi* | [**delete_variant_sample_link_as_curator**](docs/VariantIntegrationAsCuratorApi.md#delete_variant_sample_link_as_curator) | **DELETE** /api/v1/as-curator/integration/link/variant/{sourceId}/to/sample/{targetId} | Delete link between a variant object and a sample
*VariantIntegrationAsCuratorApi* | [**get_variant_by_sample_as_curator**](docs/VariantIntegrationAsCuratorApi.md#get_variant_by_sample_as_curator) | **GET** /api/v1/as-curator/integration/link/variant/by/sample/{id} | Retrieve variant run-level data by querying related sample ID (accession)
*VariantIntegrationAsCuratorApi* | [**get_variant_groups_by_study_as_curator**](docs/VariantIntegrationAsCuratorApi.md#get_variant_groups_by_study_as_curator) | **GET** /api/v1/as-curator/integration/link/variant/group/by/study/{id} | Retrieve group metadata by querying study ID (accession)
*VariantIntegrationAsCuratorApi* | [**get_variant_run_to_sample_pairs_as_curator**](docs/VariantIntegrationAsCuratorApi.md#get_variant_run_to_sample_pairs_as_curator) | **GET** /api/v1/as-curator/integration/link/variant/run-to-samples/by/group/{id} | Retrieve run-sample pairs by group id. Pagination is based on unique runs, not unique pairs.
*VariantIntegrationAsUserApi* | [**get_variant_by_sample_as_user**](docs/VariantIntegrationAsUserApi.md#get_variant_by_sample_as_user) | **GET** /api/v1/as-user/integration/link/variant/by/sample/{id} | Retrieve variant run-level data by querying related sample ID (accession)
*VariantIntegrationAsUserApi* | [**get_variant_groups_by_study_as_user**](docs/VariantIntegrationAsUserApi.md#get_variant_groups_by_study_as_user) | **GET** /api/v1/as-user/integration/link/variant/group/by/study/{id} | Retrieve group metadata by querying study ID (accession)
*VariantIntegrationAsUserApi* | [**get_variant_run_to_sample_pairs_as_user**](docs/VariantIntegrationAsUserApi.md#get_variant_run_to_sample_pairs_as_user) | **GET** /api/v1/as-user/integration/link/variant/run-to-samples/by/group/{id} | Retrieve run-sample pairs by group id. Pagination is based on unique runs, not unique pairs.
*XrefsetQueriesApi* | [**create**](docs/XrefsetQueriesApi.md#create) | **POST** /api/v1/xrefsets | Import a new xrefset file
*XrefsetQueriesApi* | [**delete_file**](docs/XrefsetQueriesApi.md#delete_file) | **DELETE** /api/v1/xrefsets/{id} | Delete a xrefset with all related data. Only users who uploaded the xrefset are allowed to delete it.
*XrefsetQueriesApi* | [**get_details_by_accession**](docs/XrefsetQueriesApi.md#get_details_by_accession) | **GET** /api/v1/xrefsets/{id}/metadata | Retrieve xrefset details
*XrefsetQueriesApi* | [**search_entries**](docs/XrefsetQueriesApi.md#search_entries) | **GET** /api/v1/xrefsets/entries | Retrieve a list of entries across all xrefsets for given sourceId and targetId
*XrefsetQueriesApi* | [**search_entries_within_file**](docs/XrefsetQueriesApi.md#search_entries_within_file) | **GET** /api/v1/xrefsets/{id}/entries | Retrieve a list of entries for the given xrefset and given sourceId and targetId


## Documentation For Models

 - [AccessionResponse](docs/AccessionResponse.md)
 - [AppliedFilter](docs/AppliedFilter.md)
 - [AttributeInvalidValue](docs/AttributeInvalidValue.md)
 - [AttributeInvalidValueErrorsInner](docs/AttributeInvalidValueErrorsInner.md)
 - [AttributeInvalidValueValue](docs/AttributeInvalidValueValue.md)
 - [AttributeValidationSummary](docs/AttributeValidationSummary.md)
 - [AttributeValidationSummaryAttributeInvalidValuesInner](docs/AttributeValidationSummaryAttributeInvalidValuesInner.md)
 - [BaseErrorResponse](docs/BaseErrorResponse.md)
 - [BaseErrorResponseError](docs/BaseErrorResponseError.md)
 - [BatchOfIds](docs/BatchOfIds.md)
 - [CommitInfo](docs/CommitInfo.md)
 - [CreateGroup201Response](docs/CreateGroup201Response.md)
 - [CreateGroup201ResponseAllOfMeta](docs/CreateGroup201ResponseAllOfMeta.md)
 - [CreateGroupRequest](docs/CreateGroupRequest.md)
 - [CreateGroupRequestMembersInner](docs/CreateGroupRequestMembersInner.md)
 - [CreateUser201Response](docs/CreateUser201Response.md)
 - [CreateUserRequest](docs/CreateUserRequest.md)
 - [CreateUserRequestEmailsInner](docs/CreateUserRequestEmailsInner.md)
 - [DataItem](docs/DataItem.md)
 - [DataPresentation](docs/DataPresentation.md)
 - [DataPresentationRelationships](docs/DataPresentationRelationships.md)
 - [DetachedCollection](docs/DetachedCollection.md)
 - [DetachedCollectionDataInner](docs/DetachedCollectionDataInner.md)
 - [DetachedObject](docs/DetachedObject.md)
 - [Email](docs/Email.md)
 - [ErrorMessage](docs/ErrorMessage.md)
 - [ExceptionTypeAndMessage](docs/ExceptionTypeAndMessage.md)
 - [ExpressionItem](docs/ExpressionItem.md)
 - [ExpressionResponse](docs/ExpressionResponse.md)
 - [FilterGroupsResponse](docs/FilterGroupsResponse.md)
 - [FilterOption](docs/FilterOption.md)
 - [FilterOptionGroup](docs/FilterOptionGroup.md)
 - [FilterUsersResponse](docs/FilterUsersResponse.md)
 - [FindObjectsResponse](docs/FindObjectsResponse.md)
 - [FindObjectsResponseFilterOptionGroupsInner](docs/FindObjectsResponseFilterOptionGroupsInner.md)
 - [FindObjectsResponseFilterOptionGroupsInnerOptionsInner](docs/FindObjectsResponseFilterOptionGroupsInnerOptionsInner.md)
 - [FindObjectsResponseObjectsPage](docs/FindObjectsResponseObjectsPage.md)
 - [FindObjectsResponseObjectsPageContentInner](docs/FindObjectsResponseObjectsPageContentInner.md)
 - [FindObjectsResponseObjectsPageContentInnerSummaryInner](docs/FindObjectsResponseObjectsPageContentInnerSummaryInner.md)
 - [FlowCytometryItem](docs/FlowCytometryItem.md)
 - [FlowCytometryResponse](docs/FlowCytometryResponse.md)
 - [GetExpressionAsCurator200Response](docs/GetExpressionAsCurator200Response.md)
 - [GetExpressionAsCurator200ResponseFeature](docs/GetExpressionAsCurator200ResponseFeature.md)
 - [GetExpressionAsCurator200ResponseItemOrigin](docs/GetExpressionAsCurator200ResponseItemOrigin.md)
 - [GetFlowCytometryAsCurator200Response](docs/GetFlowCytometryAsCurator200Response.md)
 - [GetFlowCytometryAsCurator200ResponseFeature](docs/GetFlowCytometryAsCurator200ResponseFeature.md)
 - [GetFlowCytometryAsCurator200ResponseValue](docs/GetFlowCytometryAsCurator200ResponseValue.md)
 - [GetVariantAsCurator200Response](docs/GetVariantAsCurator200Response.md)
 - [GetVariantAsCurator200ResponseVariant](docs/GetVariantAsCurator200ResponseVariant.md)
 - [Group](docs/Group.md)
 - [GroupPatch](docs/GroupPatch.md)
 - [GroupPatchOperationsInner](docs/GroupPatchOperationsInner.md)
 - [GroupResponse](docs/GroupResponse.md)
 - [GroupResponseAllOfMembers](docs/GroupResponseAllOfMembers.md)
 - [GroupValidationSummary](docs/GroupValidationSummary.md)
 - [GroupValidationSummaryAttributesInner](docs/GroupValidationSummaryAttributesInner.md)
 - [IMetadata](docs/IMetadata.md)
 - [ImportAFileRequest](docs/ImportAFileRequest.md)
 - [ImportExpressionSignalRunRequest](docs/ImportExpressionSignalRunRequest.md)
 - [ImportMetadataRequest](docs/ImportMetadataRequest.md)
 - [ImportSignalRunRequest](docs/ImportSignalRunRequest.md)
 - [Info](docs/Info.md)
 - [JobRuntimeError](docs/JobRuntimeError.md)
 - [JobRuntimeErrorStackInner](docs/JobRuntimeErrorStackInner.md)
 - [Link](docs/Link.md)
 - [ListResponse](docs/ListResponse.md)
 - [ListResponseMeta](docs/ListResponseMeta.md)
 - [ListResponseMetaPagination](docs/ListResponseMetaPagination.md)
 - [ManagedObject](docs/ManagedObject.md)
 - [Member](docs/Member.md)
 - [Meta](docs/Meta.md)
 - [MetaResponse](docs/MetaResponse.md)
 - [MetadataPresentation](docs/MetadataPresentation.md)
 - [MetadataPresentationMetadata](docs/MetadataPresentationMetadata.md)
 - [MetadataWithId](docs/MetadataWithId.md)
 - [MetainfoKeyForSummary](docs/MetainfoKeyForSummary.md)
 - [ObjectsPage](docs/ObjectsPage.md)
 - [OmicsResponse](docs/OmicsResponse.md)
 - [OmicsResponseDataPresentation](docs/OmicsResponseDataPresentation.md)
 - [OmicsResponseDataPresentationDataInner](docs/OmicsResponseDataPresentationDataInner.md)
 - [OmicsResponseMetadataPresentation](docs/OmicsResponseMetadataPresentation.md)
 - [OmicsResponseMetadataPresentationDataInner](docs/OmicsResponseMetadataPresentationDataInner.md)
 - [OmicsResponseMetadataWithId](docs/OmicsResponseMetadataWithId.md)
 - [Output](docs/Output.md)
 - [OutputErrorsInner](docs/OutputErrorsInner.md)
 - [PageRequest](docs/PageRequest.md)
 - [PaginationInfo](docs/PaginationInfo.md)
 - [PatchOperation](docs/PatchOperation.md)
 - [RGItem](docs/RGItem.md)
 - [Relationships](docs/Relationships.md)
 - [ResponseFormat](docs/ResponseFormat.md)
 - [RunsResponse](docs/RunsResponse.md)
 - [SCIMErrorResponse](docs/SCIMErrorResponse.md)
 - [SearchStudyRequest](docs/SearchStudyRequest.md)
 - [SearchStudyRequestFiltersInner](docs/SearchStudyRequestFiltersInner.md)
 - [SearchStudyRequestPage](docs/SearchStudyRequestPage.md)
 - [SourceTypePair](docs/SourceTypePair.md)
 - [StartImportFlowCytometryRequest](docs/StartImportFlowCytometryRequest.md)
 - [StudySearchInfo](docs/StudySearchInfo.md)
 - [StudyValidationSummary](docs/StudyValidationSummary.md)
 - [StudyValidationSummarySamplesInner](docs/StudyValidationSummarySamplesInner.md)
 - [TaskInfo](docs/TaskInfo.md)
 - [UploadRGRequest](docs/UploadRGRequest.md)
 - [User](docs/User.md)
 - [UserPatch](docs/UserPatch.md)
 - [UserResponse](docs/UserResponse.md)
 - [ValidationError](docs/ValidationError.md)
 - [VariantItem](docs/VariantItem.md)
 - [VariantMetadataWithId](docs/VariantMetadataWithId.md)
 - [VariantResponse](docs/VariantResponse.md)
 - [XrefSetCreateRequest](docs/XrefSetCreateRequest.md)
 - [XrefSetCreateResponse](docs/XrefSetCreateResponse.md)
 - [XrefSetMetadata](docs/XrefSetMetadata.md)
 - [XrefSetSearchResult](docs/XrefSetSearchResult.md)
 - [XrefSetSearchResultEntry](docs/XrefSetSearchResultEntry.md)
 - [XrefSetSearchResultResultInner](docs/XrefSetSearchResultResultInner.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="Access-token"></a>
### Access-token

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header

<a id="Genestack-API-Token"></a>
### Genestack-API-Token

- **Type**: API key
- **API key parameter name**: Genestack-API-Token
- **Location**: HTTP header


## Author




