import React from "react";
import ColorInput from "../../components/elements/ColorInput";
import Col from "../../components/layout/Col";
import Row from "../../components/layout/Row";
/*
    A Pro element to be used in graph styling to allow
    users to select the color of a certain element of
    the graph
*/
const LabelAndColor = (props) => {
    return (React.createElement(Row, { justify: 'space-between', align: 'center' },
        React.createElement(Col, null,
            React.createElement("p", null, props.label)),
        React.createElement(ColorInput, { value: props.color, onChange: props.onChange })));
};
export default LabelAndColor;
//# sourceMappingURL=LabelAndColor.js.map