// Copyright (c) Mito
import React from 'react';
import { ActionEnum } from '../../types';
import Dropdown from '../elements/Dropdown';
import { makeToolbarDropdownItem } from './utils';
/**
 * Dropdown that displays all the actions that are available for editing Rows.
 */
const ToolbarRowsDropdown = (props) => {
    return (React.createElement(React.Fragment, null,
        React.createElement(Dropdown, { display: props.uiState.currOpenToolbarDropdown === 'Rows', closeDropdown: () => props.setUIState((prevUIState) => {
                // Only close this dropdown if it's actually the one that is open, to avoid race conditions
                if (prevUIState.currOpenToolbarDropdown === 'Rows') {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenToolbarDropdown: undefined });
                }
                return prevUIState;
            }), width: 'large' },
            makeToolbarDropdownItem(props.actions[ActionEnum.Delete_Row]),
            makeToolbarDropdownItem(props.actions[ActionEnum.Promote_Row_To_Header]))));
};
export default ToolbarRowsDropdown;
//# sourceMappingURL=ToolbarRowsDropdown.tsx.js.map