// Copyright (c) Mito
import React from 'react';
import { ActionEnum } from '../../types';
import Dropdown from '../elements/Dropdown';
import DropdownSectionSeperator from '../elements/DropdownSectionSeperator';
import { makeToolbarDropdownItem } from './utils';
/**
 * Dropdown that displays all the actions that are available for editing graphs
 */
const ToolbarGraphsDropdown = (props) => {
    return (React.createElement(React.Fragment, null,
        React.createElement(Dropdown, { display: props.uiState.currOpenToolbarDropdown === 'Graphs', closeDropdown: () => props.setUIState((prevUIState) => {
                // Only close this dropdown if it's actually the one that is open, to avoid race conditions
                if (prevUIState.currOpenToolbarDropdown === 'Graphs') {
                    return Object.assign(Object.assign({}, prevUIState), { currOpenToolbarDropdown: undefined });
                }
                return prevUIState;
            }), width: 'medium' },
            makeToolbarDropdownItem(props.actions[ActionEnum.Graph]),
            React.createElement(DropdownSectionSeperator, { isDropdownSectionSeperator: true }),
            makeToolbarDropdownItem(props.actions[ActionEnum.Duplicate_Graph]),
            makeToolbarDropdownItem(props.actions[ActionEnum.Rename_Graph]),
            makeToolbarDropdownItem(props.actions[ActionEnum.Delete_Graph]))));
};
export default ToolbarGraphsDropdown;
//# sourceMappingURL=ToolbarGraphsDropdown.js.map