// Copyright (c) Mito
import React from 'react';
import { classNames } from '../../utils/classNames';
import { getToolbarItemIcon } from './utils';
/**
 * The ToolbarButton component is used to create each
 * button in the Toolbar.
 */
const ToolbarButton = (props) => {
    const disabled = props.disabledTooltip !== undefined;
    const highlightToobarItemClass = props.highlightToolbarButton === true ? 'toolbar-button-draw-attention' : '';
    return (React.createElement("div", { className: classNames('toolbar-button-container', disabled ? 'toolbar-button-container-disabled' : 'toolbar-button-container-enabled'), id: props.id, onClick: () => {
            if (disabled) {
                return;
            }
            if (props.setEditorState) {
                props.setEditorState(undefined);
            }
            props.action.actionFunction();
        } },
        React.createElement("button", { className: classNames('toolbar-button', 'vertical-align-content', highlightToobarItemClass), type: "button" },
            React.createElement("span", { title: props.disabledTooltip || props.action.tooltip },
                React.createElement("div", { className: 'toolbar-button-icon-container' }, getToolbarItemIcon(props.toolbarButtonType)),
                React.createElement("p", { className: 'toolbar-button-label' }, props.action.shortTitle))),
        props.children !== undefined && props.children));
};
export default ToolbarButton;
//# sourceMappingURL=ToolbarButton.js.map