// Copyright (c) Mito
import React from 'react';
import { ModalEnum } from './modals';
import DefaultModal from '../DefaultModal';
import TextButton from '../elements/TextButton';
import { TaskpaneType } from '../taskpanes/taskpanes';
/*
  A modal that confirms with the user that they want to delete the dataframe and
  all of the depedant graphs
*/
const DeleteGraphsModal = (props) => {
    const graphIDs = props.dependantGraphTabNamesAndIDs.map(graphTabNameAndID => { return graphTabNameAndID.graphID; });
    const graphTabNames = props.dependantGraphTabNamesAndIDs.map(graphTabNameAndID => { return graphTabNameAndID.graphTabName; });
    const clickDelete = async () => {
        // Delete the graphs 
        graphIDs.forEach(graphID => {
            void props.mitoAPI.editGraphDelete(graphID);
        });
        // Then delete the dataframe
        await props.mitoAPI.editDataframeDelete(props.sheetIndex);
        // Select the previous sheet and close the modal
        props.setUIState(prevUIState => {
            return Object.assign(Object.assign({}, prevUIState), { selectedTabType: 'data', selectedSheetIndex: prevUIState.selectedSheetIndex > 0 ? prevUIState.selectedSheetIndex - 1 : 0, currOpenModal: { type: ModalEnum.None }, currOpenTaskpane: { type: TaskpaneType.NONE } });
        });
    };
    return (React.createElement(DefaultModal, { header: `Delete Sheet and Dependant Graphs`, modalType: ModalEnum.ClearAnalysis, viewComponent: React.createElement(React.Fragment, null,
            React.createElement("p", { className: 'body-text-1' },
                "Deleting ",
                props.dfName,
                " will delete the following graphs that rely on it:\u00A0",
                React.createElement("span", { className: 'text-color-mito-purple-important' }, graphTabNames.join(', ')))), buttons: React.createElement(React.Fragment, null,
            React.createElement(TextButton, { variant: 'light', width: 'small', onClick: () => {
                    props.setUIState((prevUIState) => {
                        return Object.assign(Object.assign({}, prevUIState), { currOpenModal: { type: ModalEnum.None } });
                    });
                } }, "Close"),
            React.createElement(TextButton, { variant: 'dark', width: 'large', onClick: clickDelete }, "Delete Sheet and Graphs")) }));
};
export default DeleteGraphsModal;
//# sourceMappingURL=DeleteGraphsModal.js.map