// Copyright (c) Mito
import React from 'react';
import '../../../css/layout/Row.css';
import { classNames } from '../../utils/classNames';
/**
 * The Row component is the base spacing component for Mito, and is used
 * to build pretty layouts that require not much configuration.
 *
 * A Row is simply a flexbox container that holds Cols. The Row can be understood
 * to have 24 units of space that the columns can claim - either for internal
 * content or for spacing between them.
 *
 * Example usage:
 * <Row>
 *      <Col>
 *          Content 1
 *      </Col>
 *      <Col>
 *          Content 2
 *      </Col>
 * </Row>
 *
 * Furthermore, Rows support different types of justifications and aligntment,
 * similar to a flexbox itself. This makes it very easy to get a large number
 * of layouts, without having to write any custom CSS code.
 *
 * See the PivotTable component for a great example of how these Rows and Cols
 * can be used - they eliminated all custom CSS code for the pivot tables -
 * and it also looks much better as a result!
 *
 * See spacing/README.md for more information on the motivation as the to spacing
 * components.
 */
const Row = (props) => {
    const marginClass = props.suppressTopBottomMargin ? 'spacing-row-no-top-bottom-margin' : 'spacing-row-top-bottom-margin';
    return (React.createElement("div", { className: classNames('spacing-row', marginClass, props.className), title: props.title, onClick: props.onClick, style: Object.assign(Object.assign({}, props.style), { justifyContent: props.justify, alignItems: props.align }) }, props.children));
};
export default Row;
//# sourceMappingURL=Row.js.map