# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['github_dependents_info']

package_data = \
{'': ['*']}

install_requires = \
['beautifulsoup4==4.8.0', 'rich>=12.6.0,<13.0.0', 'typer[all]>=0.4.0,<0.5.0']

entry_points = \
{'console_scripts': ['github-dependents-info = '
                     'github_dependents_info.__main__:app']}

setup_kwargs = {
    'name': 'github-dependents-info',
    'version': '0.4.1',
    'description': 'Collect information about dependencies between a github repo and other repositories. Results available in JSON, markdown and badges.',
    'long_description': '# github-dependents-info\n\n<div align="center">\n\n![PyPI](https://img.shields.io/pypi/v/github-dependents-info)\n![PyPI - Downloads](https://img.shields.io/pypi/dm/github-dependents-info)\n[![Build status](https://github.com/nvuillam/github-dependents-info/workflows/build/badge.svg?branch=main&event=push)](https://github.com/nvuillam/github-dependents-info/actions?query=workflow%3Abuild)\n[![Python Version](https://img.shields.io/pypi/pyversions/github-dependents-info.svg)](https://pypi.org/project/github-dependents-info/)\n[![Dependencies Status](https://img.shields.io/badge/dependencies-up%20to%20date-brightgreen.svg)](https://github.com/nvuillam/github-dependents-info/pulls?utf8=%E2%9C%93&q=is%3Apr%20author%3Aapp%2Fdependabot)\n\n[![MegaLinter](https://github.com/nvuillam/github-dependents-info/workflows/MegaLinter/badge.svg?branch=main)](https://oxsecurity.github.io/megalinter)\n[![License](https://img.shields.io/github/license/nvuillam/github-dependents-info)](https://github.com/nvuillam/github-dependents-info/blob/master/LICENSE)\n[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](http://makeapullrequest.com)\n\nCollect information about dependencies between a github repo and other repositories.\n\n</div>\n\n## 🚀 Features\n\nGitHub API does not allow to collect information about package usage (Used by insights section)\n\nThis package uses GitHub HTML to collect information and output it as text or json, or generate a markdown file.\n\n### Badges example\n\n[![](https://img.shields.io/static/v1?label=Used%20by&message=15&color=informational&logo=slickpic)](https://github.com/nvuillam/npm-groovy-lint/network/dependents)\n[![](https://img.shields.io/static/v1?label=Used%20by%20(public)&message=11&color=informational&logo=slickpic)](https://github.com/nvuillam/npm-groovy-lint/network/dependents)\n[![](https://img.shields.io/static/v1?label=Used%20by%20(private)&message=4&color=informational&logo=slickpic)](https://github.com/nvuillam/npm-groovy-lint/network/dependents)\n[![](https://img.shields.io/static/v1?label=Used%20by%20(stars)&message=56&color=informational&logo=slickpic)](https://github.com/nvuillam/npm-groovy-lint/network/dependents)\n\n### JSON example\n\n```json\n{\n    "public_dependents_repos": [\n        {\n            "id": null,\n            "name": "nvuillam/npm-groovy-lint",\n            "url": "https://github.com/nvuillam/npm-groovy-lint/network/dependents",\n            "public_dependent_stars": 56,\n            "public_dependents": [\n                {\n                    "name": "nvuillam/vscode-groovy-lint",\n                    "stars": 52\n                },\n                {\n                    "name": "run2cmd/dotfiles",\n                    "stars": 2\n                },\n                {\n                    "name": "aboe026/software-update-checker",\n                    "stars": 2\n                },\n                {\n                    "name": "Moaz-Adel/Jobsity-Challenge",\n                    "stars": 0\n                },\n                {\n                    "name": "Moaz-Adel/automation-exercise-cypress",\n                    "stars": 0\n                },\n                {\n                    "name": "mashafrancis/sa-jenkins",\n                    "stars": 0\n                },\n                {\n                    "name": "katalon-labs/katalon-recorder-extension",\n                    "stars": 0\n                },\n                {\n                    "name": "aboe026/data-structures",\n                    "stars": 0\n                },\n                {\n                    "name": "aboe026/shields.io-badge-results",\n                    "stars": 0\n                },\n                {\n                    "name": "CIT-SeniorDesign/CIT-SeniorDesign.github.io",\n                    "stars": 0\n                },\n                {\n                    "name": "RecuencoJones/vscode-groovy-lint-issue",\n                    "stars": 0\n                }\n            ],\n            "public_dependents_number": 11,\n            "private_dependents_number": 4,\n            "total_dependents_number": 15,\n            "badges": {\n                "total": "[![](https://img.shields.io/static/v1?label=Used%20by&message=15&color=informational&logo=slickpic)](https://github.com/nvuillam/npm-groovy-lint/network/dependents)",\n                "public": "[![](https://img.shields.io/static/v1?label=Used%20by%20(public)&message=11&color=informational&logo=slickpic)](https://github.com/nvuillam/npm-groovy-lint/network/dependents)",\n                "private": "[![](https://img.shields.io/static/v1?label=Used%20by%20(private)&message=4&color=informational&logo=slickpic)](https://github.com/nvuillam/npm-groovy-lint/network/dependents)",\n                "stars": "[![](https://img.shields.io/static/v1?label=Used%20by%20(stars)&message=56&color=informational&logo=slickpic)](https://github.com/nvuillam/npm-groovy-lint/network/dependents)"\n            }\n        }\n    ],\n    "total_dependents_number": 15,\n    "public_dependents_number": 11,\n    "private_dependents_number": 4,\n    "public_dependents_stars": 56,\n    "badges": {\n        "total": "[![](https://img.shields.io/static/v1?label=Used%20by&message=15&color=informational&logo=slickpic)](https://github.com/nvuillam/npm-groovy-lint/network/dependents)",\n        "public": "[![](https://img.shields.io/static/v1?label=Used%20by%20(public)&message=11&color=informational&logo=slickpic)](https://github.com/nvuillam/npm-groovy-lint/network/dependents)",\n        "private": "[![](https://img.shields.io/static/v1?label=Used%20by%20(private)&message=4&color=informational&logo=slickpic)](https://github.com/nvuillam/npm-groovy-lint/network/dependents)",\n        "stars": "[![](https://img.shields.io/static/v1?label=Used%20by%20(stars)&message=56&color=informational&logo=slickpic)](https://github.com/nvuillam/npm-groovy-lint/network/dependents)"\n    }\n}\n```\n\n### Markdown example\n\n```markdown\n# Dependents stats for nvuillam/npm-groovy-lint\n\n[![](https://img.shields.io/static/v1?label=Used%20by&message=15&color=informational&logo=slickpic)](https://github.com/nvuillam/npm-groovy-lint/network/dependents)\n[![](https://img.shields.io/static/v1?label=Used%20by%20(public)&message=11&color=informational&logo=slickpic)](https://github.com/nvuillam/npm-groovy-lint/network/dependents)\n[![](https://img.shields.io/static/v1?label=Used%20by%20(private)&message=4&color=informational&logo=slickpic)](https://github.com/nvuillam/npm-groovy-lint/network/dependents)\n[![](https://img.shields.io/static/v1?label=Used%20by%20(stars)&message=56&color=informational&logo=slickpic)](https://github.com/nvuillam/npm-groovy-lint/network/dependents)\n\n## Package nvuillam/npm-groovy-lint\n\n[![](https://img.shields.io/static/v1?label=Used%20by&message=15&color=informational&logo=slickpic)](https://github.com/nvuillam/npm-groovy-lint/network/dependents)\n[![](https://img.shields.io/static/v1?label=Used%20by%20(public)&message=11&color=informational&logo=slickpic)](https://github.com/nvuillam/npm-groovy-lint/network/dependents)\n[![](https://img.shields.io/static/v1?label=Used%20by%20(private)&message=4&color=informational&logo=slickpic)](https://github.com/nvuillam/npm-groovy-lint/network/dependents)\n[![](https://img.shields.io/static/v1?label=Used%20by%20(stars)&message=56&color=informational&logo=slickpic)](https://github.com/nvuillam/npm-groovy-lint/network/dependents)\n\n| Repository                                                                                                    | Stars |\n|:--------------------------------------------------------------------------------------------------------------|------:|\n| [nvuillam/vscode-groovy-lint](https://github.com/nvuillam/vscode-groovy-lint)                                 |    52 |\n| [run2cmd/dotfiles](https://github.com/run2cmd/dotfiles)                                                       |     2 |\n| [aboe026/software-update-checker](https://github.com/aboe026/software-update-checker)                         |     2 |\n| [Moaz-Adel/Jobsity-Challenge](https://github.com/Moaz-Adel/Jobsity-Challenge)                                 |     0 |\n| [Moaz-Adel/automation-exercise-cypress](https://github.com/Moaz-Adel/automation-exercise-cypress)             |     0 |\n| [mashafrancis/sa-jenkins](https://github.com/mashafrancis/sa-jenkins)                                         |     0 |\n| [katalon-labs/katalon-recorder-extension](https://github.com/katalon-labs/katalon-recorder-extension)         |     0 |\n| [aboe026/data-structures](https://github.com/aboe026/data-structures)                                         |     0 |\n| [aboe026/shields.io-badge-results](https://github.com/aboe026/shields.io-badge-results)                       |     0 |\n| [CIT-SeniorDesign/CIT-SeniorDesign.github.io](https://github.com/CIT-SeniorDesign/CIT-SeniorDesign.github.io) |     0 |\n| [RecuencoJones/vscode-groovy-lint-issue](https://github.com/RecuencoJones/vscode-groovy-lint-issue)           |     0 |\n\n_Generated by [github-dependents-info](https://github.com/nvuillam/github-dependents-info)_\n```\n\n## Installation\n\n```bash\npip install -U github-dependents-info\n```\n\nor install with `Poetry`\n\n```bash\npoetry add github-dependents-info\n```\n\n## Usage\n\n```shell\n    github-dependents-info [OPTIONS]\n```\n\n| Parameter              | Type    | Description                                           |\n|------------------------|---------|-------------------------------------------------------|\n| --repo                 | String  | Repository. Example: `oxsecurity/megalinter`          |\n| -s<br/> --sort         | String  | (optional) Sort order: name (default) or stars        |\n| -m<br/> --markdownfile | String  | (optional) Output markdown file file                  |\n| -j<br/> --json         | String  | (optional) Output in json format                      |\n| -v<br/> --version      | Boolean | (optional) Displays version of github-dependents-info |\n| --verbose              | Boolean | (optional) Verbose output                             |\n\n## Examples\n\nText output\n\n`github-dependents-info --repo nvuillam/npm-groovy-lint`\n\nJSON output\n\n`github-dependents-info --repo nvuillam/npm-groovy-lint --json`\n\nBuild markdown file with dependent repos (single package), sorted by name\n\n`github-dependents-info --repo nvuillam/npm-groovy-lint --markdownfile ./assets/package-usage.md --verbose`\n\nBuild markdown file with dependent repos (multiple package), sorted by stars\n\n`github-dependents-info --repo oxsecurity/megalinter --markdownfile ./assets/package-usage.md --sort stars --verbose`\n\n## 🛡 License\n\n[![License](https://img.shields.io/github/license/nvuillam/github-dependents-info)](https://github.com/nvuillam/github-dependents-info/blob/master/LICENSE)\n\nThis project is licensed under the terms of the `MIT` license. See [LICENSE](https://github.com/nvuillam/github-dependents-info/blob/master/LICENSE) for more details.\n\n## Credits [![🚀 Your next Python package needs a bleeding-edge project structure.](https://img.shields.io/badge/python--package--template-%F0%9F%9A%80-brightgreen)](https://github.com/TezRomacH/python-package-template)\n\nThis package has been inspired by stackexchange post [How to use GitHub API to get a repository\'s dependents information in GitHub?](https://stackoverflow.com/questions/58734176/how-to-use-github-api-to-get-a-repositorys-dependents-information-in-github)\n- [Bertrand Martel](https://github.com/bertrandmartel)\n- [muvaf](https://stackoverflow.com/users/5233252/muvaf)\n- [Mo Ganji](https://linkedin.com/in/mohganji)\n\nThis project was generated with [`python-package-template`](https://github.com/TezRomacH/python-package-template)\n',
    'author': 'nvuillam',
    'author_email': 'nicolas.vuillamy@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/nvuillam/github-dependents-info',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
