""" Nuvla CLI main script """
import logging

import typer

from nuvla_cli.common.cli_builder import build_entity_action
from nuvla_cli.nuvlaio.edge import Edge


app_cli = typer.Typer(no_args_is_help=True)

build_entity_action(app_cli)


logging.basicConfig(
        level=logging.WARNING,
        format='[%(asctime)s] Line:%(lineno)d %(levelname)s - %(message)s',
        datefmt='%H:%M:%S'
    )


@app_cli.command(name='clear')
def clear_edges(force: bool = typer.Option(...,
                                           help='Force skip clear confirmation [Not '
                                                'recommended',
                                           prompt='You are about to decommission and '
                                                  'delete all the Edges generated by CLI,'
                                                  ' are you sure?',
                                           confirmation_prompt=True)):
    """
    Clears all the Edges instances for the user created by the CLI

    :return: None
    """
    if force:
        # Create NuvlaIO instance
        edge: Edge = Edge()
        edges_in_nuvla = edge.nuvla_api.search('nuvlabox',
                                               filter={"tags=='cli.created=True'"})

        for nuvla_edge in edges_in_nuvla.resources:

            edge.remove_edge(nuvla_edge.data.get('id'))
