# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pypokedex']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.21.0,<3.0.0']

setup_kwargs = {
    'name': 'pypokedex',
    'version': '1.6.0',
    'description': 'A minimal pokedex library',
    'long_description': '<p align=\'center\'>\n    <img src=\'https://raw.githubusercontent.com/arnavb/pypokedex/master/assets/logo.png\'/>\n</p>\n\n[![Travis Build Status](https://travis-ci.org/arnavb/pypokedex.svg?branch=master)](https://travis-ci.com/arnavb/pypokedex)\n[![Appveyor Build status](https://ci.appveyor.com/api/projects/status/wpbab6ojfvoe1eg2/branch/master?svg=true)](https://ci.appveyor.com/project/arnavb/pypokedex/branch/master)\n[![Codecov](https://img.shields.io/codecov/c/github/arnavb/pypokedex.svg)](https://codecov.io/gh/arnavb/pypokedex)\n[![PyPI](https://img.shields.io/pypi/v/pypokedex.svg)](https://pypi.org/project/pypokedex/)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/pypokedex.svg)\n[![License](https://img.shields.io/github/license/arnavb/pypokedex.svg)](https://github.com/arnavb/pypokedex/blob/master/LICENSE)\n\nPyPokedex is a minimal pokedex library for Python that uses [PokeAPI](https://pokeapi.co/) internally to get Pokemon data. A simple example:\n\n<p align=\'center\'>\n    <img src=\'https://raw.githubusercontent.com/arnavb/pypokedex/master/assets/example-usage.png\'/>\n</p>\n\n## Requirements\n\n- Python 3.6+\n\n## Installing\n\nUse:\n\n```bash\n$ pip install pypokedex\n```\n\nto get the latest stable release, or:\n\n```bash\n$ pip install git+https://github.com/arnavb/pypokedex.git@master\n```\n\nto get the latest commit on master.\n\n## Documentation\n\nThis package (`pypokedex`) only provides one function through the\npublic API—`get`. It can be used as follows:\n\n```python\nimport pypokedex\n\npokemon = pypokedex.get(dex=DEX)  # DEX must be a valid _national_ pokedex\n                                  # number\npokemon2 = pypokedex.get(name=NAME)  # NAME must be a valid name of a pokemon\n```\n\nIn addition to the above function, the following classes are provided as part of the public API:\n \n - `Pokemon` (returned by `get`),\n - `BaseStats`,\n - `Ability`,\n - `Sprites`,\n - and `Move`\n \nNote that these classes shouldn\'t be initialized through client code; their purpose is mainly for type annotations.\n\n### Possible Exceptions\n\n- A `TypeError` will be raised if the wrong number of arguments or the wrong\n  type of arguments are passed.\n- A `PyPokedexHTTPError` will be raised with an HTTP code of 404 if the Pokemon\n  requested is not found. **Note**: The `name` parameter to `get` is _case-insensitive_.\n- A `PyPokedexHTTPError` will be raised with the proper HTTP code if another type\n  of HTTP error occurs.\n- A `PyPokedexError` will be raised if a [requests exception](http://docs.python-requests.org/en/master/_modules/requests/exceptions/)\n  occurs (with the exception of `requests.exceptions.HTTPError`, handled in the\n  previous two bullet points).\n- A `PyPokedexError` will be raised if data is missing when parsing the returned\n  JSON from PokeAPI (usually this indicates an API change).\n\nOnce a valid `pypokedex.pokemon.Pokemon` object is returned, the following\nmembers are provided for its consumption:\n\n### Member Variables\n\n- `dex` (`int`): Contains the _national_ Pokedex number of the current Pokemon.\n- `name` (`str`): Contains the name of the current Pokemon.\n- `height` (`int`): Contains the height of the current Pokemon in decimeters (see [veekun/pokedex#249](https://github.com/veekun/pokedex/issues/249)).\n- `weight` (`int`): Contains the weight of the current Pokemon in hectograms (see [veekun/pokedex#249](https://github.com/veekun/pokedex/issues/249)).\n- `base_experience` (`intt`): Contains the base experience yield of the current Pokemon.\n- `types` (`List[str]`): Contains a list of strings with the name of the current\n  Pokemon\'s types.\n- `abilities` (`List[Ability]`): Contains a list of named tuples called `Ability`.\n  Each `Ability` has the following members:\n  - `name` (`str`): The name of the current ability.\n  - `is_hidden` (`bool`): Whether the current ability is a hidden ability or not.\n- `base_stats` (`BaseStats`): Contains a named tuple with the current\n  Pokemon\'s base stats stored as follows (all `int`s):\n  - `hp`: The base HP of the current Pokemon.\n  - `attack`: The base attack of the current Pokemon.\n  - `defense`: The base defense of the current Pokemon.\n  - `sp_atk`: The base special attack of the current Pokemon.\n  - `sp_def`: The base special defense of the current Pokemon.\n  - `speed`: The base speed of the current Pokemon.\n- `moves` (`DefaultDict[str, List[Move]]`): Contains a dictionary of game names\n  (according to PokeAPI) to a list of named tuples called `Move` representing the\n  moves the current Pokemon learns in the respective game. The `Move` named tuple\n  contains the following members:\n  - `name` (`str`): The name of the current move.\n  - `learn_method` (`str`): The method the current Pokemon uses to learn the\n    current move (according to PokeAPI).\n  - `level` (`int`): The level the current Pokemon learns the current move if\n    `learn_method` is `level-up`, `None` otherwise.\n- `sprites` (`Sprites`): Contains two dictionaries, `front` and `back` representing the respective sprites of the current Pokemon. The keys in the dictionary are [Pokeapi sprite keys](https://pokeapi.co/docs/v2.html#pokemonsprites) without the direction prefix (e.g `back_default` is just `default` in the `back` dictionary).\n- `other_sprites` (`Dict[str, Sprites]`): Contains a mapping of sprite groups to sprites (sprites are stored in the same way as the `sprites` instance variable.\n- `version_sprites` (`Dict[str, Dict[str, Sprites]]`): Contains a mapping of generations to games to sprites. Note that like the API itself, keys are included for all generations and games, despite the fact that those Pokemon may not exist in said generation or game. e.g `pypokedex.get(name=\'garchomp\')` would include keys for generation 1 through 3, even though it was introduced in generation 4.\n\n### Member Functions\n\n- `def exists_in(self, game: str) -> bool`: Method to check whether the current\n  Pokemon exists in a specific game.\n- `def learns(self, move_name: str, game: str) -> bool`: Method to check\n  whether the current Pokemon learns a specific move in a specific game.\n- `def get_descriptions(self, language="en") -> Dict[str, str]`: Method to returns all the descriptions of the current Pokemon for the specified language (en by default). **Note**: This function only returns the descriptions as a dictionary. It doesn\'t store them anywhere on the Pokemon object. This was done since the descriptions are fetched from a separate API endpoint.\n- `def __str__(self) -> str`: Method to get a string represenation of the\n  current Pokemon. This string is of the form: `Pokemon(dex={self.dex}, name=\'{self.name}\')`.\n- `__eq__, __lt__, __gt__, __le__, __ge__`: Methods that implement various\n  comparison operators for Pokemon objects in terms of their Pokedex number.\n\n#### Possible Exceptions\n\n- `learns` will raise a `PyPokedexError` if the current Pokemon does not exist\n  in the game specified.\n\n## License\n\nThis library is licensed under the [MIT License](https://github.com/arnavb/pypokedex/blob/master/LICENSE).\n\n### Dependency Licenses\n\nThis library depends on [requests](https://github.com/requests/requests), which is licensed under the [Apache 2.0 License](https://github.com/requests/requests/blob/master/LICENSE).\n',
    'author': 'Arnav Borborah',
    'author_email': 'arnavborborah11@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/arnavb/pypokedex#readme',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
