import random, string
import pandas as pd
from typing import *



def generate_random_string(N: int=10) -> str:
    """
    generates random string

    :param N: random string's length
    :return: random string
    """
    return "".join(random.choices(string.ascii_uppercase + string.digits, k=N))


def dataframe_as_list_of_dict(df: pd.DataFrame) -> List[Dict[str, float]]:
    """
    converts dataframe to list of dictionaries

    :param df: target dataframe to convert
    :return: list of dictionaries, which is generated by given dataframe
    """
    ret = []
    keys = list(df.columns)
    for val in df.values:
        ret.append(dict(zip(keys, val)))
    return ret
