# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['instruqt_converter',
 'instruqt_converter.converters',
 'instruqt_converter.converters.utils',
 'instruqt_converter.core']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=6.0,<7.0',
 'gql[all]>=3.4.0,<4.0.0',
 'pydantic>=1.9.1,<2.0.0',
 'python-frontmatter>=1.0.0,<2.0.0',
 'rich-click>=1.5.1,<2.0.0',
 'rich>=12.5.1,<13.0.0']

entry_points = \
{'console_scripts': ['convert = instruqt_converter.convert:convert_track']}

setup_kwargs = {
    'name': 'instruqt-converter',
    'version': '0.0.1',
    'description': 'Python-based CLI utility to convert Instruqt tracks to and from a temporary state for testing',
    'long_description': '# instruqt-converter\n\nPython based CLI tool to convert Instruqt (<https://www.instruqt.com>) tracks to and from a temporary state for testing.  This tool utilizes the Instruqt GraphQL API to validate tracks and use existing track and challenge IDs if available.\n\n## Configuration\n\nBefore using the tool you will need to do the following:\n\n### Install instruqt-converter\n\n```shell\npip install instruqt-converter\n```\n\n### Configure Environment Variables\n\n```shell\ncp ENVEXAMPLE ~/.instruqt-converter.env\n```\n\nAfter you have copied `ENVEXAMPLE` to `~/.instruqt-converter.env` update the following key/value pairs:\n\n* `INSTRUQT_API_KEY` - Replace `<api-key>` with the API key from your Instruqt team settings page\n\n* `INSTRUQT_ORG_SLUG` - Replace `<org-slug>` with your organizations slug\n\nLoad the environment variables:\n\n```shell\nsource ~/.instruqt-converter.env\n```\n\nYou may want to add `source ~/.instruqt-converter.env` to your shell profile so the environment variables are loaded every time you log in.\n\n## Usage\n\n### Help\n\n```shell\nvscode ➜ /workspaces/development/instruqt-converter $ convert --help\n\n Usage: convert [OPTIONS]\n\n╭─ Options ────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╮\n│  *  --track         PATH        Path to Instruqt track [required]                                                                                    │\n│  *  --to            [dev|prod]  Convert To: [dev] - Convert to dev for testing [prod] - Convert to prod for promotion [required]                     │\n│  *  --identifier    TEXT        Track identifier used when converting to dev [default: dev] [required]                                               │\n│     --help                      Show this message and exit.                                                                                          │\n╰──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────────╯\n```\n\n### Converting to Dev Track\n\n```shell\nvscode ➜ /workspaces/development/instruqt-converter (main ✗) $ convert --track /workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible --to dev\n[21:41:23] INFO     Converting to [dev] with identifier [dev]                                                                                                                                                     convert.py:56\n[21:41:24] WARNING  Track with identifier: [dev] and ID: vbiz8rpaul3w already exists.                                                                                                                                 dev.py:50\n           WARNING  Found Existing Assignment [explore-the-environment] with ID: 3swpbta9acpw                                                                                                                         dev.py:74\n           INFO     Completed update of [/workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/01-explore-the-environment/assignment.md]                                         dev.py:103\n           WARNING  Found Existing Assignment [configure-system] with ID: lp2ahqitimsf                                                                                                                                dev.py:74\n           INFO     Completed update of [/workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/02-configure-system/assignment.md]                                                dev.py:103\n           WARNING  Found Existing Assignment [configure-ntp] with ID: 4ju8kkouqiug                                                                                                                                   dev.py:74\n           INFO     Completed update of [/workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/03-configure-ntp/assignment.md]                                                   dev.py:103\n           WARNING  Found Existing Assignment [configure-snmp] with ID: ywddqrez9r38                                                                                                                                  dev.py:74\n           INFO     Completed update of [/workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/04-configure-snmp/assignment.md]                                                  dev.py:103\n           WARNING  Found Existing Assignment [configure-interfaces] with ID: q1z7o0lg7hpm                                                                                                                            dev.py:74\n           INFO     Completed update of [/workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/05-configure-interfaces/assignment.md]                                            dev.py:103\n           WARNING  Found Existing Assignment [configure-ospf] with ID: kmf8zc84x83o                                                                                                                                  dev.py:74\n           INFO     Completed update of [/workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/06-configure-ospf/assignment.md]                                                  dev.py:103\n           INFO     Setting id in track.yml to: vbiz8rpaul3w                                                                                                                                                         dev.py:121\n           INFO     Completed update of /workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/track.yml                                                                          dev.py:141\n           INFO     Track conversion to [dev] with identifier [dev] complete!                                                                                                                                        dev.py:142\n```\n\n### Converting to Prod Track\n\n```shell\nvscode ➜ /workspaces/development/instruqt-converter (main ✗) $ convert --track /workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible --to prod\n[21:42:20] INFO     Converting to [prod] with identifier [dev]                                                                                                                                                    convert.py:60\n[21:42:21] WARNING  Track with identifier: [dev] and ID: zcr4yrnk5jgr already exists.                                                                                                                                prod.py:50\n           WARNING  Found Existing Assignment [explore-the-environment] with ID: puhvtzr2iij2                                                                                                                        prod.py:74\n           INFO     Completed update of [/workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/01-explore-the-environment/assignment.md]                                        prod.py:103\n           WARNING  Found Existing Assignment [configure-system] with ID: dlxrwky2yfb7                                                                                                                               prod.py:74\n           INFO     Completed update of [/workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/02-configure-system/assignment.md]                                               prod.py:103\n           WARNING  Found Existing Assignment [configure-ntp] with ID: qvj2hx3kj1q4                                                                                                                                  prod.py:74\n           INFO     Completed update of [/workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/03-configure-ntp/assignment.md]                                                  prod.py:103\n           WARNING  Found Existing Assignment [configure-snmp] with ID: m8lal25bbcqe                                                                                                                                 prod.py:74\n           INFO     Completed update of [/workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/04-configure-snmp/assignment.md]                                                 prod.py:103\n           WARNING  Found Existing Assignment [configure-interfaces] with ID: pin7dorfav3y                                                                                                                           prod.py:74\n           INFO     Completed update of [/workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/05-configure-interfaces/assignment.md]                                           prod.py:103\n           WARNING  Found Existing Assignment [configure-ospf] with ID: n7t3cuwcd9vg                                                                                                                                 prod.py:74\n           INFO     Completed update of [/workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/06-configure-ospf/assignment.md]                                                 prod.py:103\n           INFO     Setting id in track.yml to: zcr4yrnk5jgr                                                                                                                                                        prod.py:121\n           INFO     Completed update of /workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/track.yml                                                                         prod.py:141\n           INFO     Track conversion to [prod] with identifier [dev] complete!                                                                                                                                      prod.py:142\n```\n\n### Using a different track identifier\n\nThe tool also supports using track identifiers other than `dev`.  To change the identifier use the `--identifier` command line option.\n\n```shell\nvscode ➜ /workspaces/development/instruqt-converter (main ✗) $ convert --track /workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible --to dev --identifier nick\n[21:58:22] INFO     Converting to [dev] with identifier [nick]                                                                                                                                                    convert.py:56\n[21:58:23] ERROR    Track with identifier: nick does not exist                                                                                                                                                        dev.py:57\n           INFO     Assignment [explore-the-environment] does not exist  Removing id.                                                                                                                                 dev.py:88\n           INFO     Completed update of [/workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/01-explore-the-environment/assignment.md]                                         dev.py:103\n           INFO     Assignment [configure-system] does not exist  Removing id.                                                                                                                                        dev.py:88\n           INFO     Completed update of [/workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/02-configure-system/assignment.md]                                                dev.py:103\n           INFO     Assignment [configure-ntp] does not exist  Removing id.                                                                                                                                           dev.py:88\n           INFO     Completed update of [/workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/03-configure-ntp/assignment.md]                                                   dev.py:103\n           INFO     Assignment [configure-snmp] does not exist  Removing id.                                                                                                                                          dev.py:88\n           INFO     Completed update of [/workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/04-configure-snmp/assignment.md]                                                  dev.py:103\n           INFO     Assignment [configure-interfaces] does not exist  Removing id.                                                                                                                                    dev.py:88\n           INFO     Completed update of [/workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/05-configure-interfaces/assignment.md]                                            dev.py:103\n           INFO     Assignment [configure-ospf] does not exist  Removing id.                                                                                                                                          dev.py:88\n           INFO     Completed update of [/workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/06-configure-ospf/assignment.md]                                                  dev.py:103\n           INFO     Track [network-automation-challenge-lab-nick] not found.  Removing id.                                                                                                                           dev.py:128\n           INFO     Completed update of /workspaces/development/network-automation-challenge-lab/instruqt-challenge-cisco-ansible/track.yml                                                                          dev.py:141\n           INFO     Track conversion to [dev] with identifier [nick] complete!\n```\n\n## Version\n\nVersion: v0.0.1\n\n## Changelog\n\nSee `CHANGELOG.md` for changes.\n\n## Contributors\n\n* Nick Thompson ([@nsthompson](https://github.com/nsthompson))\n',
    'author': 'Nick Thompson',
    'author_email': 'nick@imperial.org',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/nsthompson/instruqt-converter',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0.0',
}


setup(**setup_kwargs)
