# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: verify/v0/verify.proto
# plugin: python-betterproto
import logging
from typing import List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class InfoCReq(betterproto.Message):
    # 评论ID
    id: int = betterproto.int32_field(1)


@dataclass
class InfoCResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "InfoCData" = betterproto.message_field(3)


@dataclass
class InfoCData(betterproto.Message):
    title: str = betterproto.string_field(1)
    jump_url: str = betterproto.string_field(2)


@dataclass
class DefaultResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EmptyData" = betterproto.message_field(3)


@dataclass
class EmptyData(betterproto.Message):
    pass


@dataclass
class EpOnlineReq(betterproto.Message):
    # 单话ID(对应审核单话oid)
    oid: int = betterproto.int32_field(1)
    # 上线状态 0-上线 1-下线
    extra1: int = betterproto.int32_field(2)


@dataclass
class ComicInfoByEpReq(betterproto.Message):
    # 单话ID(对应审核单话oid)
    oid: int = betterproto.int32_field(1)


@dataclass
class ComicInfoByEpResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ComicInfoByEpData" = betterproto.message_field(3)


@dataclass
class ComicInfoByEpData(betterproto.Message):
    # 漫画ID
    cid: int = betterproto.int32_field(1)
    # 漫画名
    title: str = betterproto.string_field(2)
    # 话列表
    ep_list: List["EpInfo"] = betterproto.message_field(3)


@dataclass
class WikiInfoByEpReq(betterproto.Message):
    # 单话ID(对应审核单话oid)
    oid: int = betterproto.int32_field(1)


@dataclass
class WikiInfoByEpResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "WikiInfoByEpData" = betterproto.message_field(3)


@dataclass
class WikiInfoByEpData(betterproto.Message):
    # 百科ID
    info_id: int = betterproto.int32_field(1)
    # 百科原名
    o_name: str = betterproto.string_field(2)
    # 百科中文名
    c_name: str = betterproto.string_field(3)
    # 创建人
    cuser: str = betterproto.string_field(4)


@dataclass
class EpInfo(betterproto.Message):
    # 话ID
    id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)


@dataclass
class ResultCallbackReq(betterproto.Message):
    # 单话ID(对应审核单话oid)
    oid: int = betterproto.int32_field(1)
    # 审核状态 0-不处理 1-通过 2-驳回
    state: int = betterproto.int32_field(2)
    # 驳回理由（通过可以不填）
    reason: str = betterproto.string_field(3)


@dataclass
class BfsTokenReq(betterproto.Message):
    # ["http://1.jpg", "http://2.jpg"]
    urls: str = betterproto.string_field(1)


@dataclass
class BfsTokenResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["Token"] = betterproto.message_field(3)


@dataclass
class Token(betterproto.Message):
    url: str = betterproto.string_field(1)
    token: str = betterproto.string_field(2)


class VerifyStub(betterproto.ServiceStub):
    """Verify 服务"""

    @allure.step("""评论用信息""")
    def info_c(self, request: InfoCReq) -> InfoCResp:
        """评论用信息"""
        logging.getLogger(__name__).info(
            "start call " + "[info_c]" + " api" + "=>" + """评论用信息"""
        )
        response = InfoCResp()
        self._do_twirp_rpc("/verify.v0.Verify/InfoC", request, response)
        logging.getLogger(__name__).info("call " + "[info_c]" + " api success!")
        return response

    @allure.step("""单话上下线""")
    def ep_online(self, request: EpOnlineReq) -> DefaultResponse:
        """单话上下线"""
        logging.getLogger(__name__).info(
            "start call " + "[ep_online]" + " api" + "=>" + """单话上下线"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/verify.v0.Verify/EpOnline", request, response)
        logging.getLogger(__name__).info("call " + "[ep_online]" + " api success!")
        return response

    @allure.step("""根据单话ID获取漫画信息""")
    def comic_info_by_ep(self, request: ComicInfoByEpReq) -> ComicInfoByEpResp:
        """根据单话ID获取漫画信息"""
        logging.getLogger(__name__).info(
            "start call " + "[comic_info_by_ep]" + " api" + "=>" + """根据单话ID获取漫画信息"""
        )
        response = ComicInfoByEpResp()
        self._do_twirp_rpc("/verify.v0.Verify/ComicInfoByEp", request, response)
        logging.getLogger(__name__).info(
            "call " + "[comic_info_by_ep]" + " api success!"
        )
        return response

    @allure.step("""根据单话ID获取百科信息""")
    def wiki_info_by_ep(self, request: WikiInfoByEpReq) -> WikiInfoByEpResp:
        """根据单话ID获取百科信息"""
        logging.getLogger(__name__).info(
            "start call " + "[wiki_info_by_ep]" + " api" + "=>" + """根据单话ID获取百科信息"""
        )
        response = WikiInfoByEpResp()
        self._do_twirp_rpc("/verify.v0.Verify/WikiInfoByEp", request, response)
        logging.getLogger(__name__).info(
            "call " + "[wiki_info_by_ep]" + " api success!"
        )
        return response

    @allure.step("""单话审核回调""")
    def result_callback(self, request: ResultCallbackReq) -> DefaultResponse:
        """单话审核回调"""
        logging.getLogger(__name__).info(
            "start call " + "[result_callback]" + " api" + "=>" + """单话审核回调"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/verify.v0.Verify/ResultCallback", request, response)
        logging.getLogger(__name__).info(
            "call " + "[result_callback]" + " api success!"
        )
        return response

    @allure.step("""BfsToken""")
    def bfs_token(self, request: BfsTokenReq) -> BfsTokenResp:
        """BfsToken"""
        logging.getLogger(__name__).info(
            "start call " + "[bfs_token]" + " api" + "=>" + """BfsToken"""
        )
        response = BfsTokenResp()
        self._do_twirp_rpc("/verify.v0.Verify/BfsToken", request, response)
        logging.getLogger(__name__).info("call " + "[bfs_token]" + " api success!")
        return response
