# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: pointshop/v1/pointshop.proto
# plugin: python-betterproto
import logging
from typing import List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class Empty(betterproto.Message):
    pass


@dataclass
class ListProductResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["Product"] = betterproto.message_field(3)


@dataclass
class Product(betterproto.Message):
    """商品信息"""

    # 商品编号
    id: int = betterproto.int32_field(1)
    # 商品类型 1 - 全场券 2 - 限定券 3 - 专属限免卡 4 - 专属打折卡 5 - 全场限免卡 6 - 全场打折卡 7 - 全场福利券
    type: int = betterproto.int32_field(2)
    # 商品名称
    title: str = betterproto.string_field(3)
    # 商品图片 限定券为漫画封面 全场券为空
    image: str = betterproto.string_field(4)
    # 商品库存
    amount: int = betterproto.int32_field(5)
    # 打折前商品积分价格
    cost: int = betterproto.int32_field(6)
    # 实际商品积分价格
    real_cost: int = betterproto.int32_field(7)
    # 剩余商品库存
    remain_amount: int = betterproto.int32_field(8)
    # 专属券对应漫画
    comic_id: int = betterproto.int32_field(9)
    # 详细限制信息
    limits: List["Limit"] = betterproto.message_field(10)
    # 打折卡折扣
    discount: int = betterproto.int32_field(11)
    # 积分商品类型 1. 卡券 2. 挂件
    product_type: int = betterproto.int32_field(12)
    # 挂件url
    pendant_url: str = betterproto.string_field(13)
    # 挂件过期时间(天)
    pendant_expire: int = betterproto.int32_field(14)


@dataclass
class Limit(betterproto.Message):
    # 限定维度类型(暂时只有漫画维度) 1.漫画
    type: int = betterproto.int32_field(1)
    # id内容取决于type 当 type 为 1 时，id 为 comic_id
    id: int = betterproto.int32_field(2)
    # title内容取决于type 当 type 为 1 时，title 为 漫画标题
    title: str = betterproto.string_field(3)


@dataclass
class UserPointResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "UserPoint" = betterproto.message_field(3)


@dataclass
class UserPoint(betterproto.Message):
    # 用户当前积分
    point: int = betterproto.int64_field(1)


@dataclass
class ExchangeReq(betterproto.Message):
    # 商品编号
    product_id: int = betterproto.int32_field(1)
    # 商品数量
    product_num: int = betterproto.int32_field(2)
    # 扣除积分
    point: int = betterproto.int64_field(3)


@dataclass
class ExchangeResp(betterproto.Message):
    # 0 - 成功 1 - 积分不够 2 - 库存不够 3 - 积分不匹配 4 - 兑换人数过多
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ExchangeData" = betterproto.message_field(3)


@dataclass
class ExchangeData(betterproto.Message):
    # 订单编号
    id: int = betterproto.int64_field(1)
    # 漫读券有效天数
    expire_day: int = betterproto.int32_field(2)


@dataclass
class GetExchangeRuleResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ExchangeRule" = betterproto.message_field(3)


@dataclass
class ExchangeRule(betterproto.Message):
    # 兑换规则
    rule: str = betterproto.string_field(1)


class PointshopStub(betterproto.ServiceStub):
    """积分商城前台服务"""

    @allure.step("""查询商品""")
    def list_product(self, request: Empty) -> ListProductResp:
        """查询商品"""
        logging.getLogger(__name__).info(
            "start call " + "[list_product]" + " api" + "=>" + """查询商品"""
        )
        response = ListProductResp()
        self._do_twirp_rpc("/pointshop.v1.Pointshop/ListProduct", request, response)
        logging.getLogger(__name__).info("call " + "[list_product]" + " api success!")
        return response

    @allure.step("""查询用户积分""")
    def get_user_point(self, request: Empty) -> UserPointResp:
        """查询用户积分"""
        logging.getLogger(__name__).info(
            "start call " + "[get_user_point]" + " api" + "=>" + """查询用户积分"""
        )
        response = UserPointResp()
        self._do_twirp_rpc("/pointshop.v1.Pointshop/GetUserPoint", request, response)
        logging.getLogger(__name__).info("call " + "[get_user_point]" + " api success!")
        return response

    @allure.step("""查询兑换规则""")
    def get_exchange_rule(self, request: Empty) -> GetExchangeRuleResp:
        """查询兑换规则"""
        logging.getLogger(__name__).info(
            "start call " + "[get_exchange_rule]" + " api" + "=>" + """查询兑换规则"""
        )
        response = GetExchangeRuleResp()
        self._do_twirp_rpc("/pointshop.v1.Pointshop/GetExchangeRule", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_exchange_rule]" + " api success!"
        )
        return response

    @allure.step("""兑换商品""")
    def exchange(self, request: ExchangeReq) -> ExchangeResp:
        """兑换商品"""
        logging.getLogger(__name__).info(
            "start call " + "[exchange]" + " api" + "=>" + """兑换商品"""
        )
        response = ExchangeResp()
        self._do_twirp_rpc("/pointshop.v1.Pointshop/Exchange", request, response)
        logging.getLogger(__name__).info("call " + "[exchange]" + " api success!")
        return response
