# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: pointshop/v0/pointshop.proto
# plugin: python-betterproto
import logging
from typing import List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class ListProductReq(betterproto.Message):
    # 商品状态 - 0 表示返回在线商品 - 1 表示返回下线商品
    status: int = betterproto.int32_field(1)


@dataclass
class ListProductResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["Product"] = betterproto.message_field(3)


@dataclass
class CreateProductData(betterproto.Message):
    # 商品编号
    id: int = betterproto.int32_field(1)


@dataclass
class CreateProductResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "CreateProductData" = betterproto.message_field(3)


@dataclass
class EmptyResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "Empty" = betterproto.message_field(3)


@dataclass
class Empty(betterproto.Message):
    pass


@dataclass
class CreateProductReq(betterproto.Message):
    """商品信息"""

    # 修改时此字段无效
    id: int = betterproto.int32_field(1)
    # 商品标题
    title: str = betterproto.string_field(2)
    # 漫读券批次 修改时此字段无效
    coupon_set_id: int = betterproto.int32_field(3)
    # 商品库存
    next_amount: int = betterproto.int32_field(4)
    # 打折前商品积分价格
    cost: int = betterproto.int32_field(5)
    # 实际商品积分价格
    real_cost: int = betterproto.int32_field(6)
    # 上线时间，格式 "2006-01-02 15:04:05"
    begin_at: str = betterproto.string_field(7)
    # 下线时间，格式 "2006-01-02 15:04:05"
    end_at: str = betterproto.string_field(8)
    # 刷新时间 [0, 10, 12, 14, 18, 20, 22]
    flush_at: List[int] = betterproto.int32_field(9)
    # 排序权重
    weight: float = betterproto.double_field(10)
    # 积分商品类型 1. 卡券 2. 挂件
    product_type: int = betterproto.int32_field(11)
    # 挂件ID
    pendant_id: int = betterproto.int32_field(12)
    # 挂件过期时间(天，上限365)
    pendant_expire: int = betterproto.int32_field(13)


@dataclass
class Product(betterproto.Message):
    """商品信息"""

    id: int = betterproto.int32_field(1)
    # 商品类型 1 - 全场券 2 - 限定券 3 - 专属限免卡 4 - 专属打折卡 5 - 全场限免卡 6 - 全场打折卡 7 - 全场福利券
    type: int = betterproto.int32_field(2)
    # 商品名称
    title: str = betterproto.string_field(3)
    # 商品状态 0 - 上线 1 - 下线
    status: int = betterproto.int32_field(4)
    # 商品库存
    amount: int = betterproto.int32_field(5)
    # 打折前商品积分价格
    cost: int = betterproto.int32_field(6)
    # 实际商品积分价格
    real_cost: int = betterproto.int32_field(7)
    # 上线时间，格式 "2006-01-02 15:04:05"
    begin_at: str = betterproto.string_field(8)
    # 下线时间，格式 "2006-01-02 15:04:05"
    end_at: str = betterproto.string_field(9)
    # 刷新时间 [0, 10, 12, 14, 18, 20, 22]
    flush_at: List[int] = betterproto.int32_field(10)
    # 排序权重
    weight: float = betterproto.double_field(11)
    # 最后操作人
    user: str = betterproto.string_field(12)
    # 当前可用库存
    remain_amount: int = betterproto.int32_field(13)
    # 漫读券模板
    coupon_set_id: int = betterproto.int32_field(14)
    # 最近修改时间，格式 "2006-01-02 15:04:05"
    mtime: str = betterproto.string_field(15)
    # 专属券对应漫画
    comic_id: int = betterproto.int32_field(16)
    # 专属券对应漫画封面
    image: str = betterproto.string_field(17)
    # 下次补货数量，编辑时使展示此字段
    next_amount: int = betterproto.int32_field(18)
    # 详细限制信息
    limits: List["Limit"] = betterproto.message_field(19)
    # 打折卡折扣
    discount: int = betterproto.int32_field(20)
    # 积分商品类型 1. 卡券 2. 挂件
    product_type: int = betterproto.int32_field(21)
    # 挂件ID
    pendant_id: int = betterproto.int32_field(22)
    # 挂件过期时间(天，上限365)
    pendant_expire: int = betterproto.int32_field(23)
    # 挂件图片url
    pendant_url: str = betterproto.string_field(24)


@dataclass
class Limit(betterproto.Message):
    # 限定维度类型(暂时只有漫画维度) 1.漫画
    type: int = betterproto.int32_field(1)
    # id内容取决于type 当 type 为 1 时，id 为 comic_id
    id: int = betterproto.int32_field(2)
    # title内容取决于type 当 type 为 1 时，title 为 漫画标题
    title: str = betterproto.string_field(3)


@dataclass
class EditRuleReq(betterproto.Message):
    # 兑换规则
    rule: str = betterproto.string_field(1)


class PointshopStub(betterproto.ServiceStub):
    """积分商城后台服务"""

    @allure.step("""查询商品""")
    def list_product(self, request: ListProductReq) -> ListProductResp:
        """查询商品"""
        logging.getLogger(__name__).info(
            "start call " + "[list_product]" + " api" + "=>" + """查询商品"""
        )
        response = ListProductResp()
        self._do_twirp_rpc("/pointshop.v0.Pointshop/ListProduct", request, response)
        logging.getLogger(__name__).info("call " + "[list_product]" + " api success!")
        return response

    @allure.step("""创建商品""")
    def create_product(self, request: CreateProductReq) -> CreateProductResp:
        """创建商品"""
        logging.getLogger(__name__).info(
            "start call " + "[create_product]" + " api" + "=>" + """创建商品"""
        )
        response = CreateProductResp()
        self._do_twirp_rpc("/pointshop.v0.Pointshop/CreateProduct", request, response)
        logging.getLogger(__name__).info("call " + "[create_product]" + " api success!")
        return response

    @allure.step("""修改商品""")
    def edit_product(self, request: CreateProductReq) -> EmptyResp:
        """修改商品"""
        logging.getLogger(__name__).info(
            "start call " + "[edit_product]" + " api" + "=>" + """修改商品"""
        )
        response = EmptyResp()
        self._do_twirp_rpc("/pointshop.v0.Pointshop/EditProduct", request, response)
        logging.getLogger(__name__).info("call " + "[edit_product]" + " api success!")
        return response

    @allure.step("""修改积分兑换规则""")
    def edit_rule(self, request: EditRuleReq) -> EmptyResp:
        """修改积分兑换规则"""
        logging.getLogger(__name__).info(
            "start call " + "[edit_rule]" + " api" + "=>" + """修改积分兑换规则"""
        )
        response = EmptyResp()
        self._do_twirp_rpc("/pointshop.v0.Pointshop/EditRule", request, response)
        logging.getLogger(__name__).info("call " + "[edit_rule]" + " api success!")
        return response
