# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: pay/v1/pay.proto
# plugin: python-betterproto
import logging
from typing import List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class EmptyRequest(betterproto.Message):
    pass


@dataclass
class GetPayConfigReq(betterproto.Message):
    pay_amount: int = betterproto.int32_field(1)
    # 0 非订阅 1 订阅
    subscripe_type: int = betterproto.int32_field(2)


@dataclass
class CreateOrderRequest(betterproto.Message):
    # 支付类型 - qpay QQ钱包 - wechat 微信 - alipay 支付宝 - bp B币 - iap IOS 内购 - qr 二维码支付 -
    # ali_huabei 花呗 调用方注意(pay_type 是 alipay, real_type 是 ali_huabei, 使用
    # real_type)
    pay_type: str = betterproto.string_field(1)
    # 支付金额，单位：分 限额 9999 元 RMB
    pay_amount: int = betterproto.int32_field(2)
    # 购买产品类型 - 1 漫币 - 2 漫读券
    product_id: int = betterproto.int32_field(3)
    # 支付业务类型 破冰: 3
    business_type: int = betterproto.int32_field(4)
    # 支付业务所需额外信息 json string
    business_info: str = betterproto.string_field(5)


@dataclass
class CreateOrderResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "PayInfo" = betterproto.message_field(3)


@dataclass
class PayInfo(betterproto.Message):
    # 支付 SDK 参数 http://info.bilibili.co/display/OpenPlateform/IOS 二维码支付返回格式:
    # {"codeUrl":"xxx","expiredTime":300, "orderId":1024} - expiredTime 表示有效时间 -
    # codeUrl 是支付链接，业务方自行生成二维码 - orderId 表示订单号
    pay_params: str = betterproto.string_field(1)


@dataclass
class GetPayConfigResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "PayConfig" = betterproto.message_field(3)


@dataclass
class PayAmountRange(betterproto.Message):
    # 支付金额，元
    pay_amount: int = betterproto.int32_field(1)
    # 首充奖励漫币金额, 用户有首充则首充优先
    first_bonus_amount: int = betterproto.int32_field(2)
    # 漫币金额
    gold_amount: int = betterproto.int32_field(3)
    # 活动赠送漫读券数量
    bonus_coupon_amount: int = betterproto.int32_field(4)
    # 首充赠送漫读券数量, 用户有首充则首充优先
    first_coupon_amount: int = betterproto.int32_field(5)
    # 活动赠送漫币金额
    bonus_gold_amount: int = betterproto.int32_field(6)


@dataclass
class PayChannel(betterproto.Message):
    # 支付渠道编号，以 payChannelId 传入支付 SDK
    id: int = betterproto.int32_field(1)
    # 支付渠道类型，以 payChannel 传入支付 SDK
    type: str = betterproto.string_field(3)
    # 支付渠道类型，以 realChannel 传入支付 SDK
    real_type: str = betterproto.string_field(4)
    # 支付渠道名称
    name: str = betterproto.string_field(2)
    # 支付渠道图标
    icon_url: str = betterproto.string_field(5)


@dataclass
class PayBanner(betterproto.Message):
    # banner id
    id: int = betterproto.int32_field(1)
    # banner 标题
    title: str = betterproto.string_field(2)
    # banner url 1-漫画详情：bilicomic://detail/10 2-单话：bilicomic://reader/10/11
    # 3-活动页地址：http://www.bilibili.com
    url: str = betterproto.string_field(3)


@dataclass
class PayConfig(betterproto.Message):
    # 充值列表
    pay_amount_ranges: List["PayAmountRange"] = betterproto.message_field(1)
    # 支付渠道列表
    pay_channels: List["PayChannel"] = betterproto.message_field(2)
    # 默认支付渠道，参考 pay_channels 中的 type 字段
    default_channel: str = betterproto.string_field(3)
    # 充值奖励原因，默认为空，活期间返回「活动」 客户端优先展示首充标记，没有首充，则展示 bonus_reason 内容
    bonus_reason: str = betterproto.string_field(4)
    # 默认支付档位，0 表示第一档
    default_amount_index: int = betterproto.int32_field(5)
    # 该字段表示首充送券还是送币, 不在用来表示赠送漫币百分比 如果为 0 表示充值送漫读券  注意从 2.10 开始要逐渐废弃该字段 根据
    # first_pay_send_type 来判断首充赠送类型
    first_bonus_percent: int = betterproto.int32_field(6)
    # 活动奖励百分比，50 表示 50% 没有活动则返回 0 从 2.10 开始活动期间赠送比例不固定， 请用 PayAmountRange 相关字段 根据
    # act_send_type 判断活动赠送什么类型
    bonus_percent: int = betterproto.int32_field(7)
    # 充值页面的 banner
    banner: "PayBanner" = betterproto.message_field(8)
    # 充值页面 ABTest, 0、原页面, 1、新页面
    recharge_ab: int = betterproto.int32_field(9)
    # 付费渠道页面 ABTest, 0、原页面, 1、新页面
    pay_ab: int = betterproto.int32_field(10)
    # 是否是站友日 用来控制前端站友日展示
    is_comrade_day: bool = betterproto.bool_field(11)
    # 站友日免费赠送漫读券数量
    comrade_coupon_amount: int = betterproto.int32_field(12)
    # 赠送漫读券所需的最小 B 币兑换数量
    comrade_b_coin_needed: int = betterproto.int32_field(13)
    # 活动期间赠送类型  1、漫读券 2、漫币
    act_send_type: int = betterproto.int32_field(14)
    # 首充赠送类型 1、漫读券 2、漫币 (不要用来判断首充)
    first_pay_send_type: int = betterproto.int32_field(15)
    # 充值展示的文案(可配置)
    show_text: str = betterproto.string_field(16)
    # 花呗最大值 元
    huabei_max: int = betterproto.int32_field(17)


@dataclass
class GetBCoinResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "BCoin" = betterproto.message_field(3)


@dataclass
class BCoin(betterproto.Message):
    # B 币余额
    amount: float = betterproto.double_field(1)
    # 1B 币可以兑换到漫币的数量
    exchange_rate: int = betterproto.int32_field(2)
    # 首次兑换上限（节省首充奖励）
    first_max_coin: int = betterproto.int32_field(3)
    # 首充奖励百分比，50 表示 50%
    first_bonus_percent: int = betterproto.int32_field(4)
    # 活动奖励百分比，50 表示 50% 没有活动则返回 0
    bonus_percent: int = betterproto.int32_field(5)
    # 1B 币可以兑换到漫读券的数量
    coupon_rate: int = betterproto.int32_field(6)
    # 漫读券过期天数
    coupon_exp: int = betterproto.int32_field(7)


@dataclass
class PayBCoinReq(betterproto.Message):
    # 支付金额，单位：个，最低一个 B 币
    pay_amount: int = betterproto.int32_field(1)
    # 购买产品类型 - 1 漫读券
    product_id: int = betterproto.int32_field(2)


@dataclass
class PayBCoinResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "PayBCoinOrder" = betterproto.message_field(3)


@dataclass
class PayBCoinOrder(betterproto.Message):
    # 订单号
    id: int = betterproto.int64_field(1)


@dataclass
class CreateCardOrderReq(betterproto.Message):
    # 支付类型 - wechat 微信 - alipay 支付宝 - iap IOS 内购 - ali_huabei 花呗 调用方注意(pay_type 是
    # alipay, real_type 是 ali_huabei, 使用 real_type)
    pay_type: str = betterproto.string_field(1)
    # 购买产品类型 传入漫读卡 ID
    product_id: int = betterproto.int32_field(2)
    # 是否生成二维码
    make_qr: bool = betterproto.bool_field(3)
    # 默认是普通充值购买 1 活动
    biz_type: int = betterproto.int32_field(4)


@dataclass
class CardRescissionResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: str = betterproto.string_field(3)


@dataclass
class CardRecoverPayResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: str = betterproto.string_field(3)


class PayStub(betterproto.ServiceStub):
    """Pay 支付服务"""

    @allure.step("""创建订单""")
    def create_order(self, request: CreateOrderRequest) -> CreateOrderResponse:
        """创建订单"""
        logging.getLogger(__name__).info(
            "start call " + "[create_order]" + " api" + "=>" + """创建订单"""
        )
        response = CreateOrderResponse()
        self._do_twirp_rpc("/pay.v1.Pay/CreateOrder", request, response)
        logging.getLogger(__name__).info("call " + "[create_order]" + " api success!")
        return response

    @allure.step("""获取充值配置信息""")
    def get_pay_config(self, request: GetPayConfigReq) -> GetPayConfigResponse:
        """获取充值配置信息"""
        logging.getLogger(__name__).info(
            "start call " + "[get_pay_config]" + " api" + "=>" + """获取充值配置信息"""
        )
        response = GetPayConfigResponse()
        self._do_twirp_rpc("/pay.v1.Pay/GetPayConfig", request, response)
        logging.getLogger(__name__).info("call " + "[get_pay_config]" + " api success!")
        return response

    @allure.step("""获取 B 币信息""")
    def get_b_coin(self, request: EmptyRequest) -> GetBCoinResponse:
        """获取 B 币信息"""
        logging.getLogger(__name__).info(
            "start call " + "[get_b_coin]" + " api" + "=>" + """获取 B 币信息"""
        )
        response = GetBCoinResponse()
        self._do_twirp_rpc("/pay.v1.Pay/GetBCoin", request, response)
        logging.getLogger(__name__).info("call " + "[get_b_coin]" + " api success!")
        return response

    @allure.step("""使用 B 币购买商品""")
    def pay_b_coin(self, request: PayBCoinReq) -> PayBCoinResp:
        """使用 B 币购买商品"""
        logging.getLogger(__name__).info(
            "start call " + "[pay_b_coin]" + " api" + "=>" + """使用 B 币购买商品"""
        )
        response = PayBCoinResp()
        self._do_twirp_rpc("/pay.v1.Pay/PayBCoin", request, response)
        logging.getLogger(__name__).info("call " + "[pay_b_coin]" + " api success!")
        return response

    @allure.step("""创建漫读卡订单""")
    def create_card_order(self, request: CreateCardOrderReq) -> CreateOrderResponse:
        """创建漫读卡订单"""
        logging.getLogger(__name__).info(
            "start call " + "[create_card_order]" + " api" + "=>" + """创建漫读卡订单"""
        )
        response = CreateOrderResponse()
        self._do_twirp_rpc("/pay.v1.Pay/CreateCardOrder", request, response)
        logging.getLogger(__name__).info(
            "call " + "[create_card_order]" + " api success!"
        )
        return response

    @allure.step("""漫读卡解约""")
    def card_rescission(self, request: EmptyRequest) -> CardRescissionResp:
        """漫读卡解约"""
        logging.getLogger(__name__).info(
            "start call " + "[card_rescission]" + " api" + "=>" + """漫读卡解约"""
        )
        response = CardRescissionResp()
        self._do_twirp_rpc("/pay.v1.Pay/CardRescission", request, response)
        logging.getLogger(__name__).info(
            "call " + "[card_rescission]" + " api success!"
        )
        return response

    @allure.step("""漫读卡恢复购买""")
    def card_recover_pay(self, request: EmptyRequest) -> CardRecoverPayResp:
        """漫读卡恢复购买"""
        logging.getLogger(__name__).info(
            "start call " + "[card_recover_pay]" + " api" + "=>" + """漫读卡恢复购买"""
        )
        response = CardRecoverPayResp()
        self._do_twirp_rpc("/pay.v1.Pay/CardRecoverPay", request, response)
        logging.getLogger(__name__).info(
            "call " + "[card_recover_pay]" + " api success!"
        )
        return response
