# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: notice/v1/notice.proto
# plugin: python-betterproto
import logging
from typing import List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class EmptyResp(betterproto.Message):
    pass


@dataclass
class DelNoticeReq(betterproto.Message):
    # 通知 id 列表，所有类型消息通用，英文逗号分割
    ids: str = betterproto.string_field(1)


@dataclass
class NoticeReq(betterproto.Message):
    # 页码
    page_num: int = betterproto.int32_field(1)
    # 条目数
    page_size: int = betterproto.int32_field(2)
    # 消息类型，1、回复；2、点赞 查询系统消息不用传此字段
    type: int = betterproto.int32_field(3)


@dataclass
class SysNotice(betterproto.Message):
    # 主键 id 降序排列
    id: int = betterproto.int32_field(1)
    # 通知标题
    title: str = betterproto.string_field(2)
    # 通知内容
    content: str = betterproto.string_field(3)
    # 跳转链接，跟推送保持一致
    link: str = betterproto.string_field(4)
    # 创建时间，"2006-01-02 15:04:05"
    time: str = betterproto.string_field(5)


@dataclass
class CommentNotice(betterproto.Message):
    # 主键 id, 用于删除
    id: int = betterproto.int32_field(1)
    # 业务评论类型，用于区分漫画、活动等 漫画评论 22 单话评论 29 当 type=22 时要校验 is_review
    type: int = betterproto.int32_field(2)
    # 业务内评论 id
    oid: int = betterproto.int32_field(3)
    # 根评论 id
    rpid: int = betterproto.int64_field(4)
    # 我的评论内容
    content: str = betterproto.string_field(5)
    # 别人回复我的内容
    reply: str = betterproto.string_field(6)
    # 回复我的人的 id
    uid: int = betterproto.int64_field(7)
    # 回复我的人的昵称
    name: str = betterproto.string_field(8)
    # 回复我的人的头像
    face: str = betterproto.string_field(9)
    # 创建时间，"2006-01-02 15:04:05"
    time: str = betterproto.string_field(10)
    # 当前评论 id，用于直接回复。有别于根评论 id。
    parent_id: int = betterproto.int64_field(11)
    # 是否是点评 0-不是 1-是
    is_review: int = betterproto.int32_field(12)
    # 漫画 id
    comic_id: int = betterproto.int32_field(13)
    # 跳转信息 0-直接往漫画/单话评论详情跳转 1-直接往点评详情页跳转 2-往点评的楼中楼页面跳转
    show_type: int = betterproto.int32_field(14)


@dataclass
class GetSysNoticeResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["SysNotice"] = betterproto.message_field(3)


@dataclass
class GetCommentNoticeResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["CommentNotice"] = betterproto.message_field(3)


class NoticeStub(betterproto.ServiceStub):
    """通知中心服务"""

    @allure.step("""读取系统消息""")
    def get_sys_notice(self, request: NoticeReq) -> GetSysNoticeResp:
        """读取系统消息"""
        logging.getLogger(__name__).info(
            "start call " + "[get_sys_notice]" + " api" + "=>" + """读取系统消息"""
        )
        response = GetSysNoticeResp()
        self._do_twirp_rpc("/notice.v1.Notice/GetSysNotice", request, response)
        logging.getLogger(__name__).info("call " + "[get_sys_notice]" + " api success!")
        return response

    @allure.step("""读取评论消息(评论回复和点赞)""")
    def get_comment_notice(self, request: NoticeReq) -> GetCommentNoticeResp:
        """读取评论消息(评论回复和点赞)"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_comment_notice]"
            + " api"
            + "=>"
            + """读取评论消息(评论回复和点赞)"""
        )
        response = GetCommentNoticeResp()
        self._do_twirp_rpc("/notice.v1.Notice/GetCommentNotice", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_comment_notice]" + " api success!"
        )
        return response

    @allure.step("""删除消息""")
    def del_notice(self, request: DelNoticeReq) -> EmptyResp:
        """删除消息"""
        logging.getLogger(__name__).info(
            "start call " + "[del_notice]" + " api" + "=>" + """删除消息"""
        )
        response = EmptyResp()
        self._do_twirp_rpc("/notice.v1.Notice/DelNotice", request, response)
        logging.getLogger(__name__).info("call " + "[del_notice]" + " api success!")
        return response
