# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: headboard/v0/headboard.proto
# plugin: python-betterproto
import logging
from typing import List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class ListTopResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    # 积分排名信息
    list: List["ScoreDetail"] = betterproto.message_field(3)


@dataclass
class ListTopReq(betterproto.Message):
    # 榜单记录 id
    rank_id: int = betterproto.int32_field(1)
    # type id 总榜/日榜/周榜...
    type_id: int = betterproto.int64_field(2)


@dataclass
class GetScoreResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    # 积分信息
    data: "ScoreDetail" = betterproto.message_field(3)


@dataclass
class GetScoreReq(betterproto.Message):
    # 榜单记录 id
    rank_id: int = betterproto.int32_field(1)
    # type id 总榜/日榜/周榜...
    type_id: int = betterproto.int64_field(2)
    # item id  UID/comic id
    item_id: int = betterproto.int64_field(3)


@dataclass
class ScoreDetail(betterproto.Message):
    # uid/comic id
    item_id: int = betterproto.int64_field(1)
    # 积分值
    score: int = betterproto.int64_field(2)


@dataclass
class ScoreReq(betterproto.Message):
    # 榜单记录 id
    rank_id: int = betterproto.int32_field(1)
    # type id 总榜/日榜/周榜...
    type_id: int = betterproto.int64_field(2)
    # item id  UID/comic id
    item_id: int = betterproto.int64_field(3)
    # 增加的数值
    score: int = betterproto.int64_field(4)


@dataclass
class GetResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "HeadBoardDetail" = betterproto.message_field(3)


@dataclass
class GetReq(betterproto.Message):
    # id
    id: int = betterproto.int32_field(1)


@dataclass
class ListResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    # 榜单信息
    data: "HeadBoardInfo" = betterproto.message_field(3)


@dataclass
class HeadBoardInfo(betterproto.Message):
    # total 分页使用
    total: int = betterproto.int32_field(1)
    # 榜单列表
    list: List["HeadBoardDetail"] = betterproto.message_field(2)


@dataclass
class HeadBoardDetail(betterproto.Message):
    # id
    id: int = betterproto.int32_field(1)
    # 用途说明
    desc: str = betterproto.string_field(2)
    # 榜单最大数量
    size: int = betterproto.int32_field(3)
    # 榜单类型  0-总榜 1-日榜 2-周榜 3-月榜 4-年榜
    type: int = betterproto.int32_field(4)
    # 表名
    table_name: str = betterproto.string_field(5)
    # 积分上限
    max_score: int = betterproto.int64_field(6)


@dataclass
class ListReq(betterproto.Message):
    # 分页
    page_num: int = betterproto.int32_field(1)
    # 默认一页 20 条记录
    page_size: int = betterproto.int32_field(2)


@dataclass
class DeleteReq(betterproto.Message):
    # 榜单记录id
    id: int = betterproto.int32_field(1)


@dataclass
class AddReq(betterproto.Message):
    # 榜单记录 id id 传 0 值，添加记录的时候主键自增 id 传大于 0 的值，该条记录在数据库的主键为该 id
    id: int = betterproto.int32_field(1)
    # 用途说明
    desc: str = betterproto.string_field(2)
    # 榜单最大成员数量，超过此数量不入榜
    size: int = betterproto.int32_field(3)
    # 表名
    table_name: str = betterproto.string_field(4)
    # 积分/数值上限
    max_score: int = betterproto.int64_field(5)


@dataclass
class EditReq(betterproto.Message):
    # 榜单记录id
    id: int = betterproto.int32_field(1)
    # 用途说明
    desc: str = betterproto.string_field(2)
    # 榜单最大成员数量，超过此数量不入榜
    size: int = betterproto.int32_field(3)
    # 表名
    table_name: str = betterproto.string_field(4)
    # 积分/数值上限
    max_score: int = betterproto.int64_field(5)


@dataclass
class AddResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    # 新创建的榜单记录 id
    id: int = betterproto.int32_field(3)


@dataclass
class EmptyReq(betterproto.Message):
    pass


@dataclass
class DefaultResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)


class HeadBoardStub(betterproto.ServiceStub):
    """榜单通用服务"""

    @allure.step("""添加一条榜单信息""")
    def add(self, request: AddReq) -> AddResp:
        """添加一条榜单信息"""
        logging.getLogger(__name__).info(
            "start call " + "[add]" + " api" + "=>" + """添加一条榜单信息"""
        )
        response = AddResp()
        self._do_twirp_rpc("/headboard.v0.HeadBoard/Add", request, response)
        logging.getLogger(__name__).info("call " + "[add]" + " api success!")
        return response

    @allure.step("""修改榜单信息""")
    def edit(self, request: EditReq) -> DefaultResp:
        """修改榜单信息"""
        logging.getLogger(__name__).info(
            "start call " + "[edit]" + " api" + "=>" + """修改榜单信息"""
        )
        response = DefaultResp()
        self._do_twirp_rpc("/headboard.v0.HeadBoard/Edit", request, response)
        logging.getLogger(__name__).info("call " + "[edit]" + " api success!")
        return response

    @allure.step("""删除榜单记录""")
    def delete(self, request: DeleteReq) -> DefaultResp:
        """删除榜单记录"""
        logging.getLogger(__name__).info(
            "start call " + "[delete]" + " api" + "=>" + """删除榜单记录"""
        )
        response = DefaultResp()
        self._do_twirp_rpc("/headboard.v0.HeadBoard/Delete", request, response)
        logging.getLogger(__name__).info("call " + "[delete]" + " api success!")
        return response

    @allure.step("""获取榜单信息""")
    def list(self, request: ListReq) -> ListResp:
        """获取榜单信息"""
        logging.getLogger(__name__).info(
            "start call " + "[list]" + " api" + "=>" + """获取榜单信息"""
        )
        response = ListResp()
        self._do_twirp_rpc("/headboard.v0.HeadBoard/List", request, response)
        logging.getLogger(__name__).info("call " + "[list]" + " api success!")
        return response

    @allure.step("""获取指定榜单信息""")
    def get(self, request: GetReq) -> GetResp:
        """获取指定榜单信息"""
        logging.getLogger(__name__).info(
            "start call " + "[get]" + " api" + "=>" + """获取指定榜单信息"""
        )
        response = GetResp()
        self._do_twirp_rpc("/headboard.v0.HeadBoard/Get", request, response)
        logging.getLogger(__name__).info("call " + "[get]" + " api success!")
        return response

    @allure.step("""设置积分""")
    def set_score(self, request: ScoreReq) -> DefaultResp:
        """设置积分"""
        logging.getLogger(__name__).info(
            "start call " + "[set_score]" + " api" + "=>" + """设置积分"""
        )
        response = DefaultResp()
        self._do_twirp_rpc("/headboard.v0.HeadBoard/SetScore", request, response)
        logging.getLogger(__name__).info("call " + "[set_score]" + " api success!")
        return response

    @allure.step("""增加积分值""")
    def incr_score(self, request: ScoreReq) -> DefaultResp:
        """增加积分值"""
        logging.getLogger(__name__).info(
            "start call " + "[incr_score]" + " api" + "=>" + """增加积分值"""
        )
        response = DefaultResp()
        self._do_twirp_rpc("/headboard.v0.HeadBoard/IncrScore", request, response)
        logging.getLogger(__name__).info("call " + "[incr_score]" + " api success!")
        return response

    @allure.step("""获取积分值""")
    def get_score(self, request: GetScoreReq) -> GetScoreResp:
        """获取积分值"""
        logging.getLogger(__name__).info(
            "start call " + "[get_score]" + " api" + "=>" + """获取积分值"""
        )
        response = GetScoreResp()
        self._do_twirp_rpc("/headboard.v0.HeadBoard/GetScore", request, response)
        logging.getLogger(__name__).info("call " + "[get_score]" + " api success!")
        return response

    @allure.step("""获取前 N 名""")
    def list_top_n(self, request: ListTopReq) -> ListTopResp:
        """获取前 N 名"""
        logging.getLogger(__name__).info(
            "start call " + "[list_top_n]" + " api" + "=>" + """获取前 N 名"""
        )
        response = ListTopResp()
        self._do_twirp_rpc("/headboard.v0.HeadBoard/ListTopN", request, response)
        logging.getLogger(__name__).info("call " + "[list_top_n]" + " api success!")
        return response
