# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: comic/v0/comic.proto
# plugin: python-betterproto
import logging
from typing import List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class EpisodeInfos(betterproto.Message):
    # 单话 id 列表
    ep_ids: List[int] = betterproto.int32_field(1)


@dataclass
class GetComicEpIDsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EpisodeInfos" = betterproto.message_field(3)


@dataclass
class GetComicEpIDsReq(betterproto.Message):
    # 漫画 id
    comic_id: int = betterproto.int32_field(1)


@dataclass
class DanmakuComicInfo(betterproto.Message):
    # 漫画标题
    title: str = betterproto.string_field(1)
    # 单话标题
    short_title: str = betterproto.string_field(2)
    # 单话序号
    ord: float = betterproto.float_field(3)
    # 漫画详情页链接
    url: str = betterproto.string_field(4)
    # 漫画 id
    comic_id: int = betterproto.int32_field(5)


@dataclass
class GetComicByEpIDResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "DanmakuComicInfo" = betterproto.message_field(3)


@dataclass
class GetComicByEpIDReq(betterproto.Message):
    # 单话(章节) id
    ep_id: int = betterproto.int32_field(1)


@dataclass
class DanmakuImageInfo(betterproto.Message):
    # 图片 id
    oid: int = betterproto.int64_field(1)
    # 图片 url
    url: str = betterproto.string_field(2)


@dataclass
class EpisodeImages(betterproto.Message):
    # 单话(章节)下面所有的图片信息
    list: List["DanmakuImageInfo"] = betterproto.message_field(1)


@dataclass
class GetImageByEpIDResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EpisodeImages" = betterproto.message_field(3)


@dataclass
class GetImageByEpIDReq(betterproto.Message):
    # 单话(章节) id
    ep_id: int = betterproto.int32_field(1)


@dataclass
class DanmakuInfo(betterproto.Message):
    # 图片 id
    oid: int = betterproto.int64_field(1)
    # 章节(单话) id
    pid: int = betterproto.int32_field(2)
    # 4:先审后发 5:先发后审 9:运营先审后发 10:运营先发后审
    attr: int = betterproto.int32_field(3)
    # 是否允许用户发送弹幕
    state: bool = betterproto.bool_field(4)
    # 可显示弹幕上限
    maxlimit: int = betterproto.int32_field(5)


@dataclass
class QueryDanmakuResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "DanmakuInfo" = betterproto.message_field(3)


@dataclass
class QueryDanmakuReq(betterproto.Message):
    # 单话(章节) id
    ep_id: int = betterproto.int32_field(1)


@dataclass
class CanSendDanmakuResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)


@dataclass
class CanSendDanmakuReq(betterproto.Message):
    # uid
    uid: int = betterproto.int64_field(1)
    # 单话(章节) id
    ep_id: int = betterproto.int32_field(2)


@dataclass
class GetUserComicsReq(betterproto.Message):
    # 用户 UID
    uid: int = betterproto.int64_field(1)
    # 页码
    page: int = betterproto.int32_field(2)
    # 分页数量上限
    page_size: int = betterproto.int32_field(3)


@dataclass
class GetUserComicsResp(betterproto.Message):
    # 0. 接口请求成功
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "UserComicsInfo" = betterproto.message_field(3)


@dataclass
class UserComicsInfo(betterproto.Message):
    # comics 总数(仅供展示使用, 以具体分页为准)
    total_count: int = betterproto.int32_field(1)
    comics: List["UserComic"] = betterproto.message_field(2)


@dataclass
class UserComic(betterproto.Message):
    # 漫画ID
    id: int = betterproto.int32_field(1)
    # 漫画标题
    title: str = betterproto.string_field(2)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(3)
    # 完结状态 1:完结 0:连载 -1:未开刊
    is_finish: int = betterproto.int32_field(4)
    # 风格标签
    styles: List["StyleInfo"] = betterproto.message_field(5)
    # 总话数（全x话）
    total: int = betterproto.int32_field(6)
    # 最新话短标题
    last_short_title: str = betterproto.string_field(7)
    # 最新话更新时间: 秒级时间戳, 当更新时间不存在时, 最新话更新时间为0
    last_update_time: int = betterproto.int64_field(8)
    # h5 跳转链接
    url: str = betterproto.string_field(9)
    # pc 跳转链接
    pc_url: str = betterproto.string_field(10)


@dataclass
class StyleInfo(betterproto.Message):
    id: int = betterproto.int32_field(1)
    name: str = betterproto.string_field(2)


@dataclass
class GetComicInfosReq(betterproto.Message):
    # 漫画ID列表
    ids: List[int] = betterproto.int32_field(1)
    # 用户ID 如果传入此字段接口会返回用户追漫状态
    mid: int = betterproto.int64_field(2)


@dataclass
class GetComicInfosResp(betterproto.Message):
    # 0接口请求成功
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["ComicInfo"] = betterproto.message_field(3)


@dataclass
class ComicInfo(betterproto.Message):
    # 如果传入的漫画id没有对应数据，2，3，4，5都为空值
    id: int = betterproto.int32_field(1)
    # 漫画标题
    title: str = betterproto.string_field(2)
    # 漫画作者列表
    author: List[str] = betterproto.string_field(3)
    # 漫画简介
    evaluate: str = betterproto.string_field(4)
    # 竖版封面
    vertical_cover: str = betterproto.string_field(5)
    # 完结状态 1:完结 0:连载 -1:未开刊
    is_finish: int = betterproto.int32_field(6)
    # 风格标签
    styles: List["StyleInfo"] = betterproto.message_field(7)
    # 总话数（全x话）
    total: int = betterproto.int32_field(8)
    # 最新话短标题
    last_short_title: str = betterproto.string_field(9)
    # 最新话更新时间: 秒级时间戳, 当更新时间不存在时, 最新话更新时间为0
    last_update_time: int = betterproto.int64_field(10)
    # h5 跳转url
    url: str = betterproto.string_field(11)
    # pc 跳转链接
    pc_url: str = betterproto.string_field(12)
    # 用户是否追漫，0 未追；1 已追
    fav_status: int = betterproto.int32_field(13)


@dataclass
class PgcCardReq(betterproto.Message):
    # 番剧ID
    season_id: int = betterproto.int32_field(1)
    # 是否来自 pc，传 1 会返回 pc 链接
    from_pc: int = betterproto.int32_field(2)


@dataclass
class PgcCardResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: List["PgcCard"] = betterproto.message_field(3)


@dataclass
class PgcCard(betterproto.Message):
    # 漫画标题
    title: str = betterproto.string_field(1)
    # 漫画封面（竖版封面）
    cover: str = betterproto.string_field(2)
    # 最新话
    last_ord: float = betterproto.float_field(3)
    # 人气值
    pop: int = betterproto.int64_field(4)
    # 漫画ID
    comic_id: int = betterproto.int32_field(5)
    # h5 跳转链接 from_pc = 1 时返回 pc 链接
    jump_url: str = betterproto.string_field(6)
    # 最新话文本
    last_ord_str: str = betterproto.string_field(7)
    # 标签
    label: str = betterproto.string_field(8)
    # 出版方
    producer: str = betterproto.string_field(9)
    # 作者信息
    authors: List[str] = betterproto.string_field(10)
    # PC跳转链接
    pc_url: str = betterproto.string_field(11)


@dataclass
class ComicInfoReq(betterproto.Message):
    # 漫画ID
    id: int = betterproto.int32_field(1)


@dataclass
class ComicInfoResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ComicInfoData" = betterproto.message_field(3)


@dataclass
class ComicInfoData(betterproto.Message):
    # 漫画标题
    title: str = betterproto.string_field(1)


class ComicStub(betterproto.ServiceStub):
    """漫画核心服务"""

    @allure.step("""根据关联番剧ID获取漫画信息（番剧页卡片专用）""")
    def pgc_card(self, request: PgcCardReq) -> PgcCardResp:
        """根据关联番剧ID获取漫画信息（番剧页卡片专用）"""
        logging.getLogger(__name__).info(
            "start call " + "[pgc_card]" + " api" + "=>" + """根据关联番剧ID获取漫画信息（番剧页卡片专用）"""
        )
        response = PgcCardResp()
        self._do_twirp_rpc("/comic.v0.Comic/PgcCard", request, response)
        logging.getLogger(__name__).info("call " + "[pgc_card]" + " api success!")
        return response

    @allure.step("""根据漫画ID获取漫画信息""")
    def comic_info(self, request: ComicInfoReq) -> ComicInfoResp:
        """根据漫画ID获取漫画信息"""
        logging.getLogger(__name__).info(
            "start call " + "[comic_info]" + " api" + "=>" + """根据漫画ID获取漫画信息"""
        )
        response = ComicInfoResp()
        self._do_twirp_rpc("/comic.v0.Comic/ComicInfo", request, response)
        logging.getLogger(__name__).info("call " + "[comic_info]" + " api success!")
        return response

    @allure.step("""获取批量漫画信息""")
    def get_comic_infos(self, request: GetComicInfosReq) -> GetComicInfosResp:
        """获取批量漫画信息"""
        logging.getLogger(__name__).info(
            "start call " + "[get_comic_infos]" + " api" + "=>" + """获取批量漫画信息"""
        )
        response = GetComicInfosResp()
        self._do_twirp_rpc("/comic.v0.Comic/GetComicInfos", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_comic_infos]" + " api success!"
        )
        return response

    @allure.step("""获取用户关联的漫画""")
    def get_user_comics(self, request: GetUserComicsReq) -> GetUserComicsResp:
        """获取用户关联的漫画"""
        logging.getLogger(__name__).info(
            "start call " + "[get_user_comics]" + " api" + "=>" + """获取用户关联的漫画"""
        )
        response = GetUserComicsResp()
        self._do_twirp_rpc("/comic.v0.Comic/GetUserComics", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_user_comics]" + " api success!"
        )
        return response

    @allure.step("""校验是否能发送弹幕""")
    def can_send_danmaku(self, request: CanSendDanmakuReq) -> CanSendDanmakuResp:
        """校验是否能发送弹幕"""
        logging.getLogger(__name__).info(
            "start call " + "[can_send_danmaku]" + " api" + "=>" + """校验是否能发送弹幕"""
        )
        response = CanSendDanmakuResp()
        self._do_twirp_rpc("/comic.v0.Comic/CanSendDanmaku", request, response)
        logging.getLogger(__name__).info(
            "call " + "[can_send_danmaku]" + " api success!"
        )
        return response

    @allure.step("""首次注册""")
    def query_danmaku(self, request: QueryDanmakuReq) -> QueryDanmakuResp:
        """首次注册"""
        logging.getLogger(__name__).info(
            "start call " + "[query_danmaku]" + " api" + "=>" + """首次注册"""
        )
        response = QueryDanmakuResp()
        self._do_twirp_rpc("/comic.v0.Comic/QueryDanmaku", request, response)
        logging.getLogger(__name__).info("call " + "[query_danmaku]" + " api success!")
        return response

    @allure.step("""获取单话下面所有的图片 url""")
    def get_image_by_ep_i_d(self, request: GetImageByEpIDReq) -> GetImageByEpIDResp:
        """获取单话下面所有的图片 url"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_image_by_ep_i_d]"
            + " api"
            + "=>"
            + """获取单话下面所有的图片 url"""
        )
        response = GetImageByEpIDResp()
        self._do_twirp_rpc("/comic.v0.Comic/GetImageByEpID", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_image_by_ep_i_d]" + " api success!"
        )
        return response

    @allure.step("""漫画详情""")
    def get_comic_by_ep_i_d(self, request: GetComicByEpIDReq) -> GetComicByEpIDResp:
        """漫画详情"""
        logging.getLogger(__name__).info(
            "start call " + "[get_comic_by_ep_i_d]" + " api" + "=>" + """漫画详情"""
        )
        response = GetComicByEpIDResp()
        self._do_twirp_rpc("/comic.v0.Comic/GetComicByEpID", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_comic_by_ep_i_d]" + " api success!"
        )
        return response

    @allure.step("""获取漫画下面 index 不为空的单话 ID 列表""")
    def get_comic_ep_i_ds(self, request: GetComicEpIDsReq) -> GetComicEpIDsResp:
        """获取漫画下面 index 不为空的单话 ID 列表"""
        logging.getLogger(__name__).info(
            "start call "
            + "[get_comic_ep_i_ds]"
            + " api"
            + "=>"
            + """获取漫画下面 index 不为空的单话 ID 列表"""
        )
        response = GetComicEpIDsResp()
        self._do_twirp_rpc("/comic.v0.Comic/GetComicEpIDs", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_comic_ep_i_ds]" + " api success!"
        )
        return response
