# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: card/v0/card.proto
# plugin: python-betterproto
import logging
from typing import Dict, List

import allure
from dataclasses import dataclass

import betterproto


@dataclass
class EmptyData(betterproto.Message):
    pass


@dataclass
class DefaultPaginateReq(betterproto.Message):
    # 页码
    page_num: int = betterproto.int32_field(1)
    # 每页数量
    page_size: int = betterproto.int32_field(2)


@dataclass
class DefaultResponse(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "EmptyData" = betterproto.message_field(3)


@dataclass
class ListCardSetsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ListCardSetsData" = betterproto.message_field(3)


@dataclass
class ListCardSetsData(betterproto.Message):
    total_count: int = betterproto.int32_field(1)
    list: List["CardSet"] = betterproto.message_field(2)


@dataclass
class ListCardSetGroupsResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "ListCardSetGroupsData" = betterproto.message_field(3)


@dataclass
class ListCardSetGroupsData(betterproto.Message):
    total_count: int = betterproto.int32_field(1)
    list: List["CardSetGroup"] = betterproto.message_field(2)


@dataclass
class CardSetGroup(betterproto.Message):
    id: int = betterproto.int32_field(1)
    # 标题
    title: str = betterproto.string_field(2)
    # 档位ID
    card_set_ids: List[int] = betterproto.int32_field(3)
    # 推送类型 1.全局 2.人群包
    push_type: int = betterproto.int32_field(4)
    # 人群包ID
    user_group_ids: List[int] = betterproto.int32_field(5)
    # 权重
    weight: int = betterproto.int32_field(6)
    # 开始时间 2006-01-02 15:04:05
    start_time: str = betterproto.string_field(7)
    # 结束时间 2006-01-02 15:04:05(保持上线:1970-01-01 08:01:00)
    end_time: str = betterproto.string_field(8)
    # 操作人(创建/编辑时不传)
    cuser: str = betterproto.string_field(9)
    # 创建时间(创建/编辑时不传)
    ctime: str = betterproto.string_field(10)
    # 修改时间(创建/编辑时不传)
    mtime: str = betterproto.string_field(11)
    # 上下线状态 1-上线 2-下线 3-待上线(创建/编辑时不传)
    status: int = betterproto.int32_field(12)


@dataclass
class CardSet(betterproto.Message):
    # ID(创建时不传)
    id: int = betterproto.int32_field(1)
    # 名称
    title: str = betterproto.string_field(2)
    # 实际价格(分)
    gold: int = betterproto.int32_field(3)
    # 虚拟、原价格(分)
    origin_gold: int = betterproto.int32_field(4)
    # 档位类型:  1-月卡  2-季卡  3-年卡  4-连续月卡  5-连续季卡 6-连续年卡 7-赠送月卡  8-赠送季卡 9-赠送连续年卡
    card_type: int = betterproto.int32_field(5)
    # 角标文案
    icon_txt: str = betterproto.string_field(6)
    # 宣传文案
    ad_txt: str = betterproto.string_field(7)
    # 增发数量
    extra_amount: int = betterproto.int32_field(8)
    # 操作人(创建/编辑时不传)
    cuser: str = betterproto.string_field(9)
    # 创建时间(创建/编辑时不传)
    ctime: str = betterproto.string_field(10)
    # 修改时间(创建/编辑时不传)
    mtime: str = betterproto.string_field(11)
    # 首购优惠价格(分), 没有则传0
    discount_first_gold: int = betterproto.int32_field(12)
    # 优惠开始时间2006-01-02 15:04:05, 没有则不传或者传空字符串
    discount_start_time: str = betterproto.string_field(13)
    # 优惠结束时间2006-01-02 15:04:05, 没有或者保持上线则不传或者传空字符串
    discount_end_time: str = betterproto.string_field(14)
    # ios商品ID
    product_id: str = betterproto.string_field(15)


@dataclass
class DefaultDeleteReq(betterproto.Message):
    # ID
    id: int = betterproto.int32_field(1)


@dataclass
class UserCardInfoReq(betterproto.Message):
    uids: List[int] = betterproto.int64_field(1)


@dataclass
class UserCardInfoResp(betterproto.Message):
    code: int = betterproto.int32_field(1)
    msg: str = betterproto.string_field(2)
    data: "UserCardData" = betterproto.message_field(3)


@dataclass
class UserCardData(betterproto.Message):
    # 漫读卡等级 key uid value 0 未开通 1 已开通
    card_levels: Dict[int, int] = betterproto.map_field(
        2, betterproto.TYPE_INT64, betterproto.TYPE_INT32
    )


class CardStub(betterproto.ServiceStub):
    """Card 服务"""

    @allure.step("""添加漫读卡档位""")
    def add_card_set(self, request: CardSet) -> DefaultResponse:
        """添加漫读卡档位"""
        logging.getLogger(__name__).info(
            "start call " + "[add_card_set]" + " api" + "=>" + """添加漫读卡档位"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/card.v0.Card/AddCardSet", request, response)
        logging.getLogger(__name__).info("call " + "[add_card_set]" + " api success!")
        return response

    @allure.step("""列出漫读卡档位""")
    def list_card_sets(self, request: DefaultPaginateReq) -> ListCardSetsResp:
        """列出漫读卡档位"""
        logging.getLogger(__name__).info(
            "start call " + "[list_card_sets]" + " api" + "=>" + """列出漫读卡档位"""
        )
        response = ListCardSetsResp()
        self._do_twirp_rpc("/card.v0.Card/ListCardSets", request, response)
        logging.getLogger(__name__).info("call " + "[list_card_sets]" + " api success!")
        return response

    @allure.step("""编辑漫读卡档位""")
    def edit_card_set(self, request: CardSet) -> DefaultResponse:
        """编辑漫读卡档位"""
        logging.getLogger(__name__).info(
            "start call " + "[edit_card_set]" + " api" + "=>" + """编辑漫读卡档位"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/card.v0.Card/EditCardSet", request, response)
        logging.getLogger(__name__).info("call " + "[edit_card_set]" + " api success!")
        return response

    @allure.step("""添加漫读卡档位组""")
    def add_card_set_group(self, request: CardSetGroup) -> DefaultResponse:
        """添加漫读卡档位组"""
        logging.getLogger(__name__).info(
            "start call " + "[add_card_set_group]" + " api" + "=>" + """添加漫读卡档位组"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/card.v0.Card/AddCardSetGroup", request, response)
        logging.getLogger(__name__).info(
            "call " + "[add_card_set_group]" + " api success!"
        )
        return response

    @allure.step("""列出漫读卡档位组""")
    def list_card_set_groups(
        self, request: DefaultPaginateReq
    ) -> ListCardSetGroupsResp:
        """列出漫读卡档位组"""
        logging.getLogger(__name__).info(
            "start call " + "[list_card_set_groups]" + " api" + "=>" + """列出漫读卡档位组"""
        )
        response = ListCardSetGroupsResp()
        self._do_twirp_rpc("/card.v0.Card/ListCardSetGroups", request, response)
        logging.getLogger(__name__).info(
            "call " + "[list_card_set_groups]" + " api success!"
        )
        return response

    @allure.step("""编辑漫读卡档位组""")
    def edit_card_set_group(self, request: CardSetGroup) -> DefaultResponse:
        """编辑漫读卡档位组"""
        logging.getLogger(__name__).info(
            "start call " + "[edit_card_set_group]" + " api" + "=>" + """编辑漫读卡档位组"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/card.v0.Card/EditCardSetGroup", request, response)
        logging.getLogger(__name__).info(
            "call " + "[edit_card_set_group]" + " api success!"
        )
        return response

    @allure.step("""删除漫读卡档位组""")
    def delete_card_set_group(self, request: DefaultDeleteReq) -> DefaultResponse:
        """删除漫读卡档位组"""
        logging.getLogger(__name__).info(
            "start call " + "[delete_card_set_group]" + " api" + "=>" + """删除漫读卡档位组"""
        )
        response = DefaultResponse()
        self._do_twirp_rpc("/card.v0.Card/DeleteCardSetGroup", request, response)
        logging.getLogger(__name__).info(
            "call " + "[delete_card_set_group]" + " api success!"
        )
        return response

    @allure.step()
    def get_user_card_info(self, request: UserCardInfoReq) -> UserCardInfoResp:
        logging.getLogger(__name__).info(
            "start call " + "[get_user_card_info]" + " api"
        )
        response = UserCardInfoResp()
        self._do_twirp_rpc("/card.v0.Card/GetUserCardInfo", request, response)
        logging.getLogger(__name__).info(
            "call " + "[get_user_card_info]" + " api success!"
        )
        return response
